################################################################################################################################################################################# 
################################################################################ licence CCBY4.0 ################################################################################
################################################################################################################################################################################# 

################ The following have to be cited when using the atlases produced in the Garin et al. (PNAS, 2022) ################
#e.g you are using the modify version of the sheep atlas for you paper
# => you need to cite 1. Manuscript, 2. DOI of the Zenodo file, 3. the original atlases
#################################################################################################################################

######### 1. Manuscript ######### 
# Garin, C. M., Garin, M., Silenzi, L., Jaffe, R., & Constantinidis, C. (2022). 
# Multilevel atlas comparisons reveal divergent evolution of the primate brain. 
# Proceedings of the National Academy of Sciences, of the United States of America, 119, e2202491119.
### DOI
# https://doi.org/10.1073/pnas.2202491119

######### 2. DOI of the Zenodo file #########

######### 3. the original atlases #########
'''
######### Homo sapiens #########
M. F. Glasser et al., A multi-modal parcellation of human cerebral cortex. Nature 536,
171-178 (2016). 
######### link for downloading: https://balsa.wustl.edu/study/RVVG

######### Homo sapiens #########
L. Fan et al., The Human Brainnetome Atlas: A New Brain Atlas Based on Connectional
Architecture. Cerebral cortex 26, 3508-3526 (2016).
######### link for downloading: https://www.nitrc.org/projects/bn_atlas

######### Homo sapiens #########
R. Pijnenburg et al., Myelo- and cytoarchitectonic microstructural and functional human
cortical atlases reconstructed in common MRI space. NeuroImage 239, 118274 (2021).
######### link for downloading: http://www.dutchconnectomelab.nl/

######### Pan troglodytes #########
S. Vickery et al., Chimpanzee brain morphometry utilizing standardized MRI
preprocessing and macroanatomical annotations. Elife 9, e60136 (2020).
######### link for downloading: http://junachimp.inm7.de/?templateSelected=Juna.Chimp+T1&parcellationSelected=DaVi130&navigation=0_0_0_1__-0.2753947079181671_0.6631333827972412_-0.6360703706741333_0.2825356423854828__1765814.9090350657__0_0_0__7660116.524205456

######### Macaca mulatta #########
B. Jung et al., A comprehensive macaque fMRI pipeline and hierarchical atlas.
NeuroImage 235, 117997 (2021).
######### link for downloading: https://afni.nimh.nih.gov/pub/dist/doc/htmldoc/nonhuman/macaque_tempatl/template_nmtv2.html#download-symmetric-nmt-v2-datasets

######### Chlorocebus aethiops #########
J. A. Maldjian, J. B. Daunais, D. P. Friedman, C. T. Whitlow, Vervet MRI atlas and label
map for fully automated morphometric analyses. Neuroinformatics 12, 543-550 (2014).
######### link for downloading: Data obtained after contacting the authors

######### Callithrix jacchus #########
C. Liu et al., A digital 3D atlas of the marmoset brain based on multi-modal MRI.
NeuroImage 169, 106-116 (2018). 
######### link for downloading: https://marmosetbrainmapping.org/atlas.html#v1

######### Saimiri sciureus ######### 
K. G. Schilling et al., The VALiDATe29 MRI Based Multi-Channel Atlas of the Squirrel
Monkey Brain. Neuroinformatics 15, 321-331 (2017).
######### link for downloading: https://www.nitrc.org/projects/validate29

######### Microcebus murinus ######### 
N. A. Nadkarni, S. Bougacha, C. Garin, M. Dhenain, J. L. Picq, A 3D population-based
brain atlas of the mouse lemur primate with examples of applications in aging studies
and comparative anatomy. NeuroImage 185, 85-95 (2019). 
######### link for downloading: https://www.nitrc.org/frs/?group_id=1206 

######### Mus musculus ######### 
A. E. Dorr, J. P. Lerch, S. Spring, N. Kabani, R. M. Henkelman, High resolution three-dimensional 
brain atlas using an average magnetic resonance image of 40 adult C57Bl/6J mice. 
NeuroImage 42, 60-69 (2008).
######### link for downloading: https://wiki.mouseimaging.ca/display/MICePub/Mouse+Brain+Atlases

######### Rattus norvegicus ######### 
E. A. Papp, T. B. Leergaard, E. Calabrese, G. A. Johnson, J. G. Bjaalie, Waxholm Space
atlas of the Sprague Dawley rat brain. NeuroImage 97, 374-386 (2014). 
######### link for downloading: https://www.nitrc.org/projects/sigma_template (V1.11)

######### Oryctolagus cuniculus ######### 
E. Munoz-Moreno et al., A magnetic resonance image based atlas of the rabbit brain for
automatic parcellation. PloS one 8, e67418 (2013). 
######### link for downloading: Data obtained after contacting the authors 

######### Pteronotus parnellii ######### 
S. D. Washington et al., A three-dimensional digital neurological atlas of the mustached
bat (Pteronotus parnellii). NeuroImage 183, 300-313 (2018).
######### link for downloading: https://blackboard.uantwerpen.be/webapps/cmsmain/webui/users/bio.imaginglab.ua/Bat?action=frameset&subaction=view&uniq=1cz05y&bptksess=false

######### Sus scrofa ######### 
14. S. Saikali et al., A three-dimensional digital segmented and deformable brain atlas of the
domestic pig. Journal of neuroscience methods 192, 102-109 (2010).
######### link for downloading: https://github.com/neurabenn/pig_connectivity_bp_preprint/tree/master/atlases

######### Ovis aries ######### 
A. Ella, J. A. Delgadillo, P. Chemineau, M. Keller, Computation of a high-resolution MRI
3D stereotaxic atlas of the sheep brain. The Journal of comparative neurology 525, 676-
692 (2017). 
######### link for downloading: Data obtained after contacting the authors 

######### Equus caballus ######### 
P. J. Johnson et al., Equine Stereotaxtic Population Average Brain Atlas With
Neuroanatomic Correlation. Frontiers in neuroanatomy 13, 89 (2019).
https://ecommons.cornell.edu/handle/1813/64533.2

######### Mustela putorius ######### 
E. B. Hutchinson et al., Population based MRI and DTI templates of the adult ferret brain
and tools for voxelwise analysis. NeuroImage 152, 575-589 (2017).
######### link for downloading: https://scalablebrainatlas.incf.org/ferret/HSRetal17#downloads

######### Canis lupus ######### 
P. J. Johnson et al., Stereotactic Cortical Atlas of the Domestic Canine Brain. Scientific
reports 10, 4781 (2020). 
######### link for downloading: https://ecommons.cornell.edu/handle/1813/67018

######### Felis catus ######### 
D. Stolzberg, C. Wong, B. E. Butler, S. G. Lomber, Catlas: An magnetic resonance
imaging-based three-dimensional cortical atlas and tissue probability maps for the
domestic cat (Felis catus). The Journal of comparative neurology 525, 3190-3206
(2017). 
######### link for downloading: Data obtained after contacting the authors

######### Monodelphis domestica ######### 
P. Majka et al., A three-dimensional stereotaxic atlas of the gray short-tailed opossum
(Monodelphis domestica) brain. Brain structure & function 223, 1779-1795 (2018). 
######### link for downloading: Data obtained after contacting the authors

'''

################################ Script to modify the original version of the atlases ################################

											##### Requirement #####
##### AFNI https://afni.nimh.nih.gov/pub/dist/doc/htmldoc/background_install/install_instructs/index.html
##### Python

import pandas as pd
import os
import subprocess

spco = subprocess.check_output

#output folder (to creat)
output_atlas = 'XXX'

#input folder (where the original atlases are)
input_atlas = 'XXX'

species = [
'Horse', 
'Sheep',
'Pig', 
'Mouse_lemur', 
'Marmoset', 
'Squirrel_monkey',
'Macaque', 
'Chimpanzee',
'Cat', 
'Ferret', 
'Dog', 
'Mouse', 
'Short_tailed_opossum', 
'Rat',
'Mustached_bat', 
'Rabbit',
'Human_BA2',
'Human',
'Human_BN',
'Vervet']

### transformation file (see PNAS atlas Supplementary file "Dataset S01 (XLSX)")
atlas_exel = 'pnas.2202491119.sd01.xlsx'

for animal in species: 
	#resemple the template to the atlas space (to donwload on the orignal website)
	command = '3dresample -master ' + output_atlas + animal + '/atlaslvl1.nii.gz -prefix ' + output_atlas + animal + '/Whole_brain_res.nii.gz -input ' + output_atlas + animal + '/Whole_brain.nii.gz -overwrite'
	spco(command, shell=True)

	animal_excel = pd.read_excel(atlas_exel, sheet_name=animal)
	for numberlvl in [1, 2, 3, 4]:

		#define new and old label
		list_new_label = list(animal_excel['Number_level_' + str(numberlvl)])
		list_old_label = list(animal_excel['Number_level_orig'])

		#build the string for 3dcalc
		string_build_atlas = str('')
		for new_label, old_label in zip(list_new_label, list_old_label):
			string_build_atlas = string_build_atlas + '(' + str(int(new_label)) + '*(equals(a,' + str(int(old_label)) + ')))+'
		string_build_atlas2 = "'" + string_build_atlas[:-1] + "'"
		if not os.path.exists(output_atlas + animal) : os.mkdir(output_atlas + animal)

		#apply the transformation
		command = '3dcalc' + ' -a ' + input_atlas + animal + '/atlas.nii.gz ' + ' -expr ' + string_build_atlas2 + ' -prefix ' + output_atlas + animal + '/atlaslvl' + str(numberlvl) + '.nii.gz -overwrite'
		spco(command, shell=True)