function data_table = import_OG_file(filename, dataLines)
%IMPORTFILE Import data from a text file
%  REF20230608150818 = IMPORTFILE(FILENAME) reads data from text file
%  FILENAME for the default selection.  Returns the data as a table.
%
%  REF20230608150818 = IMPORTFILE(FILE, DATALINES) reads data for the
%  specified row interval(s) of text file FILENAME. Specify DATALINES as
%  a positive scalar integer or a N-by-2 array of positive scalar
%  integers for dis-contiguous row intervals.
%
%  Example:
%  ref20230608150818 = importfile("/Users/ciaran.breen/Library/CloudStorage/OneDrive-SharedLibraries-ScienceandTechnologyFacilitiesCouncil/CfI_AM_outgassing - Documents/Data/2023/Pressure_data/ref_20230608_150818.txt", [2, Inf]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 13-Jun-2023 13:35:38

%% Input handling

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [2, Inf];
end

%% Set up the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 12);

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = ["Datetime", "CH2", "CH3", "T1", "T2", "T3", "T4", "T5", "T6", "T7", "T8", "T9"];
opts.VariableTypes = ["datetime", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Specify variable properties
opts = setvaropts(opts, "Datetime", "InputFormat", "dd-MMM-yyyy HH:mm:ss");

% Import the data
data_table = readtable(filename, opts);

end