# computation of Regression to The Mean expected value
# on each quartile between two tests
# following the permutation method by R.E.Furrow (2019) DOI:10.1187/cbe.19-02-0034
# Computation of confidence intervals
# simply with a 95% cutoff (0.025,0.975) in the bootstrap simulated values

# function syntax RTM.effect(X1,X2,nboot) where:
# X1 is pre-test scores
# X2 is post-test scores
# nboot the number of simulated permutations (default = 1000)
# RTM.effect function displays boxplots, a table of confidence intervals
# and returns the simulated data
RTM.effect <- function(X1,X2,nboot=1000){
library(dplyr)
library(ggplot2)
df <- data.frame(X1=X1,X2=X2)
numsamp <- nrow(df)
nboot <- nboot
change_perm_H0 <- matrix(0,nrow = nboot,ncol = 4)
for (i in 1:nboot) {
  ## H0 by scores permutation
  perm_temp <- sample(1:2,numsamp,replace=TRUE)
  inds_pre <- cbind(1:numsamp,perm_temp)
  inds_post <- cbind(1:numsamp,3-perm_temp)
  S_1_perm = df[inds_pre]
  S_2_perm = df[inds_post]
  nquartile <- ntile(S_1_perm,4)
  df <- data.frame(z1_pre=S_1_perm,z1_post=S_2_perm,quartile=nquartile)
  for (j in 1:4) {
    sub_j <- subset(df,df$quartile==j)
    mu <- mean(sub_j$z1_post-sub_j$z1_pre)
    change_perm_H0[i,j] <- mu
  }
}
# grouping by quartile et mean computation
res.rtm.H0 <- data.frame(q1=change_perm_H0[,1],q2=change_perm_H0[,2],q3=change_perm_H0[,3],q4=change_perm_H0[,4])
# violin boxplot graph
res1 <- data.frame(mu=res.rtm.H0$q1,quartile=1)
res2 <- data.frame(mu=res.rtm.H0$q2,quartile=2)
res3 <- data.frame(mu=res.rtm.H0$q3,quartile=3)
res4 <- data.frame(mu=res.rtm.H0$q4,quartile=4)
df.plot <- rbind(res1,res2,res3,res4)
colnames(df.plot) <- c("mu","quartile")
p <- ggplot(df.plot,aes(x=factor(quartile), y=mu)) + geom_violin(fill="grey") + theme_bw() + labs(x="Pretest quartile (lowest to highest)",y="Mean change (posttest minus pretest)")
print(p)
# table of confidence intervals
res.fin <- data.frame(quantile=1:4, CI_low="",CI_high="")
res.fin[1,2:3] <- quantile(res1$mu, probs = c(0.025,0.975))
res.fin[2,2:3] <- quantile(res2$mu, probs = c(0.025,0.975))
res.fin[3,2:3] <- quantile(res3$mu, probs = c(0.025,0.975))
res.fin[4,2:3] <- quantile(res4$mu, probs = c(0.025,0.975))

print(res.fin, row.names=FALSE) # RTM effect confidence interval for each quartile
invisible(res.rtm.H0) # return full table of simulated data
}

