(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    159403,       3341]
NotebookOptionsPosition[    155935,       3226]
NotebookOutlinePosition[    156315,       3243]
CellTagsIndexPosition[    156272,       3240]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"B", "->", 
   RowBox[{
    SubscriptBox["X", "s"], "\[Gamma]"}]}], TraditionalForm]], "None",
 FormatType->"TraditionalForm"]], "Title",
 CellChangeTimes->{{3.5403869294899187`*^9, 3.54038696001222*^9}, {
  3.5403870098979*^9, 3.54038701712177*^9}}],

Cell[TextData[{
 "Based on [CMM1996]. See Eqs. (39)-(40), p. 9 therein. We fit a polynomial \
in ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Log", "[", "z", "]"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", " ", "-", "\[Delta]"}], " ", "]"}], TraditionalForm]]],
 "\nto the loop functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "22"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "27"], TraditionalForm]]],
 ". The relative error between our approximations and the loop functions\nis \
smaller than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "9"}]], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "22"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "27"], TraditionalForm]]],
 " for  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", " ", "\[Element]", " ", 
    RowBox[{"[", 
     RowBox[{"0.03", ",", " ", "0.12"}], "]"}], " "}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", " ", "\[Element]", " ", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", "/", "36"}], ",", " ", 
      RowBox[{"1", "/", "3"}]}], "]"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5403891644150343`*^9, 3.540389208109549*^9}, {
  3.545827732742083*^9, 3.545827922158477*^9}, {3.545827955162633*^9, 
  3.5458280653640013`*^9}, {3.545828107088807*^9, 3.545828276566584*^9}, {
  3.545832970331258*^9, 3.545832970665762*^9}, {3.545833298560158*^9, 
  3.545833298652746*^9}}],

Cell[CellGroupData[{

Cell["Basics", "Subtitle",
 CellChangeTimes->{{3.540387123458991*^9, 3.540387123953908*^9}}],

Cell["Basic Loop Function", "Subsubtitle",
 CellChangeTimes->{{3.540386910627696*^9, 3.540386928529097*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"G1", " ", "=", " ", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"t", " ", "/", " ", 
        RowBox[{"(", 
         RowBox[{"4", " ", "-", " ", "t"}], ")"}]}], "]"}], "]"}], "^", 
     "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Pi", "^", "2"}]}], "/", "2"}], " ", "+", " ", 
    RowBox[{"2", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", "t", "]"}], " ", "+", " ", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"t", " ", "-", " ", "4"}], "]"}]}], ")"}], " ", "/", " ", 
        "2"}], "]"}], "^", "2"}]}], " ", "-", " ", 
    RowBox[{"I", " ", "2", " ", "Pi", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", "t", "]"}], " ", "+", " ", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"t", " ", "-", " ", "4"}], "]"}]}], ")"}], "/", "2"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "[", "t_", "]"}], " ", ":=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"G1", ",", " ", 
       RowBox[{"t", " ", "<", " ", "4"}]}], "}"}], "}"}], ",", " ", "G2"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.540387472304446*^9, 3.540387522402667*^9}}],

Cell[CellGroupData[{

Cell["Evaluation", "Subsubtitle",
 CellChangeTimes->{{3.540387131228697*^9, 3.5403871324386387`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"evaluationPoints", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{"List", ",", " ", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"3", "/", "100"}], ",", " ", 
         RowBox[{"12", "/", "100"}], ",", " ", 
         RowBox[{"5", "/", "1000"}]}], "]"}], ",", " ", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"1", "/", "36"}], ",", " ", 
         RowBox[{"1", "/", "3"}], ",", " ", 
         RowBox[{"1", "/", "36"}]}], "]"}]}], "]"}], ",", " ", "1"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "evaluationPoints", "]"}]}], "Input",
 CellChangeTimes->{{3.5403871172200603`*^9, 3.540387139008732*^9}, {
   3.5403872793219423`*^9, 3.540387396635599*^9}, {3.540389736882708*^9, 
   3.540389740674511*^9}, {3.5403897979750423`*^9, 3.540389849793038*^9}, {
   3.5403899390643673`*^9, 3.540389943008498*^9}, {3.5403902855061283`*^9, 
   3.540390289351426*^9}, {3.5403917137171307`*^9, 3.540391759018742*^9}, {
   3.5403917988141823`*^9, 3.540391800851358*^9}, {3.540391952624975*^9, 
   3.540391995454028*^9}, 3.540392098462302*^9, {3.540392235776352*^9, 
   3.540392324435604*^9}, {3.540392530248165*^9, 3.540392593905654*^9}, {
   3.540392629322454*^9, 3.540392641437001*^9}, {3.540392672165133*^9, 
   3.54039267391168*^9}, {3.540392769636222*^9, 3.5403927951707*^9}, {
   3.5403928454300613`*^9, 3.54039285117658*^9}, {3.5403928842512302`*^9, 
   3.540392904587224*^9}, {3.5403930063683043`*^9, 3.5403931553024273`*^9}, {
   3.540393212301724*^9, 3.540393214139113*^9}, {3.540393264873468*^9, 
   3.540393340248646*^9}, {3.5403948573772182`*^9, 3.540394857685444*^9}, 
   3.540499528325314*^9, {3.5458259077295313`*^9, 3.545825912479559*^9}, {
   3.545826116294342*^9, 3.5458261279495907`*^9}}],

Cell[BoxData["228"], "Output",
 CellChangeTimes->{3.545825912919182*^9, 3.54582602442001*^9, 
  3.545826140569024*^9, 3.545828417567876*^9, 3.5458291183382063`*^9, 
  3.54584627667323*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ccName", "[", 
    RowBox[{"i_", ",", " ", "j_", ",", " ", "k_", ",", " ", "l_"}], "]"}], 
   " ", ":=", " ", 
   RowBox[{"ToExpression", "[", 
    RowBox[{"\"\<cc\>\"", "<>", " ", 
     RowBox[{"ToString", "[", "i", "]"}], " ", "<>", 
     RowBox[{"ToString", "[", "j", "]"}], " ", "<>", " ", 
     RowBox[{"ToString", "[", "k", "]"}], "<>", " ", 
     RowBox[{"ToString", "[", "l", "]"}]}], "]"}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"polynomial", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ccName", "[", 
          RowBox[{"i", ",", " ", "j", ",", " ", "k", ",", " ", "l"}], "]"}], 
         " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "z"}], ")"}], "^", "i"}], " ", 
         RowBox[{
          RowBox[{"Log", "[", "z", "]"}], "^", "j"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", " ", "delta"}], ")"}], "^", "k"}], " ", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"1", " ", "-", " ", "delta"}], "]"}], "^", "l"}]}], ",", 
        " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", "0", ",", "4"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"j", ",", " ", "0", ",", " ", "i"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"k", ",", " ", "0", ",", " ", "4"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"l", ",", " ", "0", ",", " ", "k"}], "}"}]}], "]"}], "]"}], 
     " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{"List", " ", "\[Rule]", " ", "Plus"}], "}"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coefficients", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ccName", "[", 
       RowBox[{"i", ",", " ", "j", ",", " ", "k", ",", " ", "l"}], "]"}], ",",
       " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", " ", "0", ",", " ", "4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"j", ",", " ", "0", ",", " ", "i"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "0", ",", " ", "4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"l", ",", " ", "0", ",", " ", "k"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "coefficients", "]"}]}], "Input",
 CellChangeTimes->{{3.5403871172200603`*^9, 3.540387139008732*^9}, {
   3.5403872793219423`*^9, 3.540387396635599*^9}, {3.540389736882708*^9, 
   3.540389740674511*^9}, {3.5403897979750423`*^9, 3.540389849793038*^9}, {
   3.5403899390643673`*^9, 3.540389943008498*^9}, {3.5403902855061283`*^9, 
   3.540390289351426*^9}, {3.5403917137171307`*^9, 3.540391759018742*^9}, {
   3.5403917988141823`*^9, 3.540391800851358*^9}, {3.540391952624975*^9, 
   3.540391995454028*^9}, 3.540392098462302*^9, {3.540392235776352*^9, 
   3.540392324435604*^9}, {3.540392530248165*^9, 3.540392593905654*^9}, {
   3.540392629322454*^9, 3.540392641437001*^9}, {3.540392672165133*^9, 
   3.54039267391168*^9}, {3.540392769636222*^9, 3.5403927951707*^9}, {
   3.5403928454300613`*^9, 3.54039285117658*^9}, {3.5403928842512302`*^9, 
   3.540392904587224*^9}, {3.5403930063683043`*^9, 3.5403931553024273`*^9}, {
   3.540393212301724*^9, 3.540393214139113*^9}, {3.540393264873468*^9, 
   3.5403933976261463`*^9}, 3.540393468168939*^9, {3.540393828836347*^9, 
   3.54039393299902*^9}, {3.5403939709610987`*^9, 3.540393971655184*^9}, {
   3.540394306318336*^9, 3.540394372773497*^9}, {3.540394457703265*^9, 
   3.540394551665091*^9}, {3.5403946161466846`*^9, 3.5403946511428843`*^9}, {
   3.540394691304117*^9, 3.540394695634274*^9}, {3.54039476490589*^9, 
   3.540394801198949*^9}, {3.540394877450802*^9, 3.540394917060337*^9}, {
   3.540394976259409*^9, 3.540395034733433*^9}, {3.540395153256516*^9, 
   3.540395175382168*^9}, {3.540395217985531*^9, 3.540395221568499*^9}, {
   3.540395261462452*^9, 3.540395269435701*^9}, {3.5403953248728647`*^9, 
   3.540395329667943*^9}, {3.540499924015417*^9, 3.5404999245144157`*^9}, {
   3.540499955926265*^9, 3.540499956380494*^9}, {3.540502329878022*^9, 
   3.5405023625229607`*^9}, {3.540502395799341*^9, 3.540502409757677*^9}, {
   3.540502464265193*^9, 3.540502505400058*^9}, {3.540502707336924*^9, 
   3.5405027403662863`*^9}, {3.54582549015434*^9, 3.545825491459628*^9}, {
   3.545825555877953*^9, 3.545825556535099*^9}, {3.545825740042468*^9, 
   3.5458257423456783`*^9}, {3.545825788498337*^9, 3.54582579160253*^9}, {
   3.5458258254577923`*^9, 3.545825898953362*^9}, {3.5458287600098457`*^9, 
   3.5458288457100487`*^9}, {3.545828884609106*^9, 3.545828887841456*^9}, {
   3.545832532102172*^9, 3.545832543885625*^9}, {3.5458325767119303`*^9, 
   3.5458326295132303`*^9}, {3.545832662478477*^9, 3.545832665236575*^9}, {
   3.545834217395171*^9, 3.545834263574225*^9}, {3.545843161773407*^9, 
   3.545843201638938*^9}, {3.545843256921307*^9, 3.5458432653106527`*^9}, {
   3.545843727670383*^9, 3.5458437804659758`*^9}}],

Cell[BoxData["225"], "Output",
 CellChangeTimes->{{3.545825903830821*^9, 3.545825919142913*^9}, 
   3.545826024512269*^9, 3.545826140613386*^9, 3.545828417625808*^9, {
   3.545828824863758*^9, 3.545828847286622*^9}, 3.54582888913754*^9, 
   3.545829118406006*^9, 3.5458325499350224`*^9, {3.5458325964686623`*^9, 
   3.545832630272303*^9}, 3.5458326662091103`*^9, 3.545833405863865*^9, 
   3.545834267064343*^9, {3.5458431788499813`*^9, 3.5458432022132587`*^9}, 
   3.54584326590909*^9, 3.545843680702907*^9, {3.54584375337391*^9, 
   3.545843781402268*^9}, 3.5458462767310953`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SubscriptBox["f", "22"], TraditionalForm]], "None"]], "Subsubtitle",
 CellChangeTimes->{{3.540387068761395*^9, 3.5403870842931757`*^9}}],

Cell[CellGroupData[{

Cell["I1", "Subsection",
 CellChangeTimes->{{3.540389867354951*^9, 3.5403898725443974`*^9}, {
  3.5403899869452133`*^9, 3.540389988229648*^9}, {3.540390067384313*^9, 
  3.540390071482112*^9}, {3.5403902258254843`*^9, 3.5403902360516253`*^9}, {
  3.540390933495535*^9, 3.54039094365397*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f22I1Function", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       RowBox[{"z", " ", "*", " ", "t"}]}], ")"}], " ", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"G", "[", "t", "]"}], " ", "/", " ", "t"}], " ", "+", " ", 
        RowBox[{"1", "/", "2"}]}], "]"}], "^", "2"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", " ", "-", " ", "delta"}], ")"}], "/", "z"}]}], "}"}]}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f22I1Data", " ", "=", 
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", " ", 
         RowBox[{"Apply", "[", 
          RowBox[{"f22I1Function", ",", " ", "#"}], "]"}]}], "}"}], "]"}], 
      " ", "&"}], "/@", " ", "evaluationPoints"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f22I1Model", " ", "=", " ", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{
    "f22I1Data", ",", " ", "polynomial", ",", "coefficients", ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", " ", "delta"}], "}"}]}], "]"}]}], " ", ";"}], "\n", 
 RowBox[{"f22I1Model", "[", "\"\<BestFitParameters\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f22I1", " ", "=", " ", 
   RowBox[{"f22I1Model", "[", "\"\<Function\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f22I1Model", "[", "\"\<FitResiduals\>\"", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f22I1Model", "[", "\"\<StandardizedResiduals\>\"", "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.54039163388741*^9, 3.54039163859312*^9}, {
   3.540392273167967*^9, 3.540392274627585*^9}, {3.5403923289602833`*^9, 
   3.5403923821119013`*^9}, {3.540392599956798*^9, 3.54039260406031*^9}, 
   3.545834273829453*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"cc0000", "\[Rule]", "14.098598630799978`"}], ",", 
   RowBox[{"cc0010", "\[Rule]", "18.30526556306201`"}], ",", 
   RowBox[{"cc0011", "\[Rule]", 
    RowBox[{"-", "37.08773221263469`"}]}], ",", 
   RowBox[{"cc0020", "\[Rule]", "23.6928828886954`"}], ",", 
   RowBox[{"cc0021", "\[Rule]", 
    RowBox[{"-", "60.7399749755396`"}]}], ",", 
   RowBox[{"cc0022", "\[Rule]", "47.965477679191245`"}], ",", 
   RowBox[{"cc0030", "\[Rule]", "29.132677126241664`"}], ",", 
   RowBox[{"cc0031", "\[Rule]", 
    RowBox[{"-", "93.58889849886185`"}]}], ",", 
   RowBox[{"cc0032", "\[Rule]", "133.3503038968965`"}], ",", 
   RowBox[{"cc0033", "\[Rule]", "72.81660966335441`"}], ",", 
   RowBox[{"cc0040", "\[Rule]", "33.98957833166903`"}], ",", 
   RowBox[{"cc0041", "\[Rule]", 
    RowBox[{"-", "140.33029910232707`"}]}], ",", 
   RowBox[{"cc0042", "\[Rule]", "182.614707017166`"}], ",", 
   RowBox[{"cc0043", "\[Rule]", "6.022746853032141`"}], ",", 
   RowBox[{"cc0044", "\[Rule]", 
    RowBox[{"-", "1036.9411222389274`"}]}], ",", 
   RowBox[{"cc1000", "\[Rule]", 
    RowBox[{"-", "80.86307000705308`"}]}], ",", 
   RowBox[{"cc1010", "\[Rule]", 
    RowBox[{"-", "108.43020339018987`"}]}], ",", 
   RowBox[{"cc1011", "\[Rule]", "209.27618797854146`"}], ",", 
   RowBox[{"cc1020", "\[Rule]", 
    RowBox[{"-", "138.63761951649485`"}]}], ",", 
   RowBox[{"cc1021", "\[Rule]", "344.80091889532844`"}], ",", 
   RowBox[{"cc1022", "\[Rule]", 
    RowBox[{"-", "277.4265908897876`"}]}], ",", 
   RowBox[{"cc1030", "\[Rule]", 
    RowBox[{"-", "168.91873666257158`"}]}], ",", 
   RowBox[{"cc1031", "\[Rule]", "546.5191362338694`"}], ",", 
   RowBox[{"cc1032", "\[Rule]", 
    RowBox[{"-", "612.1438959428275`"}]}], ",", 
   RowBox[{"cc1033", "\[Rule]", 
    RowBox[{"-", "341.3149622262314`"}]}], ",", 
   RowBox[{"cc1040", "\[Rule]", 
    RowBox[{"-", "198.2888052976828`"}]}], ",", 
   RowBox[{"cc1041", "\[Rule]", "820.6733109692236`"}], ",", 
   RowBox[{"cc1042", "\[Rule]", 
    RowBox[{"-", "1222.6970882621501`"}]}], ",", 
   RowBox[{"cc1043", "\[Rule]", "143.41976818656178`"}], ",", 
   RowBox[{"cc1044", "\[Rule]", "5580.255095290669`"}], ",", 
   RowBox[{"cc1100", "\[Rule]", "69.50845393443748`"}], ",", 
   RowBox[{"cc1110", "\[Rule]", "93.78538997295948`"}], ",", 
   RowBox[{"cc1111", "\[Rule]", 
    RowBox[{"-", "172.8504519045025`"}]}], ",", 
   RowBox[{"cc1120", "\[Rule]", "120.31445694228132`"}], ",", 
   RowBox[{"cc1121", "\[Rule]", 
    RowBox[{"-", "287.60441596036094`"}]}], ",", 
   RowBox[{"cc1122", "\[Rule]", "245.69535730371848`"}], ",", 
   RowBox[{"cc1130", "\[Rule]", "147.22519863844303`"}], ",", 
   RowBox[{"cc1131", "\[Rule]", 
    RowBox[{"-", "455.531884854664`"}]}], ",", 
   RowBox[{"cc1132", "\[Rule]", "509.94174655657554`"}], ",", 
   RowBox[{"cc1133", "\[Rule]", "97.62266172441679`"}], ",", 
   RowBox[{"cc1140", "\[Rule]", "173.30327764578877`"}], ",", 
   RowBox[{"cc1141", "\[Rule]", 
    RowBox[{"-", "687.6040935089131`"}]}], ",", 
   RowBox[{"cc1142", "\[Rule]", "944.6465154966398`"}], ",", 
   RowBox[{"cc1143", "\[Rule]", 
    RowBox[{"-", "291.3188094793638`"}]}], ",", 
   RowBox[{"cc1144", "\[Rule]", 
    RowBox[{"-", "2861.554400425678`"}]}], ",", 
   RowBox[{"cc2000", "\[Rule]", "255.11640035588655`"}], ",", 
   RowBox[{"cc2010", "\[Rule]", "346.3838050580048`"}], ",", 
   RowBox[{"cc2011", "\[Rule]", 
    RowBox[{"-", "645.1944825926647`"}]}], ",", 
   RowBox[{"cc2020", "\[Rule]", "443.4577474764791`"}], ",", 
   RowBox[{"cc2021", "\[Rule]", 
    RowBox[{"-", "1085.74376231633`"}]}], ",", 
   RowBox[{"cc2022", "\[Rule]", "919.368381562335`"}], ",", 
   RowBox[{"cc2030", "\[Rule]", "541.4899169087721`"}], ",", 
   RowBox[{"cc2031", "\[Rule]", 
    RowBox[{"-", "1719.7531664613318`"}]}], ",", 
   RowBox[{"cc2032", "\[Rule]", "1945.4214701289216`"}], ",", 
   RowBox[{"cc2033", "\[Rule]", "838.4730103613117`"}], ",", 
   RowBox[{"cc2040", "\[Rule]", "635.9860457152175`"}], ",", 
   RowBox[{"cc2041", "\[Rule]", 
    RowBox[{"-", "2590.82065105928`"}]}], ",", 
   RowBox[{"cc2042", "\[Rule]", "3687.3782511430995`"}], ",", 
   RowBox[{"cc2043", "\[Rule]", 
    RowBox[{"-", "761.1075526044516`"}]}], ",", 
   RowBox[{"cc2044", "\[Rule]", 
    RowBox[{"-", "14545.090949859292`"}]}], ",", 
   RowBox[{"cc2100", "\[Rule]", "62.23563401641963`"}], ",", 
   RowBox[{"cc2110", "\[Rule]", "84.03480198461358`"}], ",", 
   RowBox[{"cc2111", "\[Rule]", 
    RowBox[{"-", "154.8246492180961`"}]}], ",", 
   RowBox[{"cc2120", "\[Rule]", "107.75231663119338`"}], ",", 
   RowBox[{"cc2121", "\[Rule]", 
    RowBox[{"-", "258.54652741421705`"}]}], ",", 
   RowBox[{"cc2122", "\[Rule]", "222.4603719206343`"}], ",", 
   RowBox[{"cc2130", "\[Rule]", "131.79216105653958`"}], ",", 
   RowBox[{"cc2131", "\[Rule]", 
    RowBox[{"-", "409.2085141942021`"}]}], ",", 
   RowBox[{"cc2132", "\[Rule]", "461.2497306274983`"}], ",", 
   RowBox[{"cc2133", "\[Rule]", "102.7974479940949`"}], ",", 
   RowBox[{"cc2140", "\[Rule]", "155.1367741413609`"}], ",", 
   RowBox[{"cc2141", "\[Rule]", 
    RowBox[{"-", "617.8267964178884`"}]}], ",", 
   RowBox[{"cc2142", "\[Rule]", "851.2396107578395`"}], ",", 
   RowBox[{"cc2143", "\[Rule]", 
    RowBox[{"-", "245.52337911628825`"}]}], ",", 
   RowBox[{"cc2144", "\[Rule]", 
    RowBox[{"-", "2712.5030661372025`"}]}], ",", 
   RowBox[{"cc2200", "\[Rule]", 
    RowBox[{"-", "0.24738633063774054`"}]}], ",", 
   RowBox[{"cc2210", "\[Rule]", 
    RowBox[{"-", "0.2895681543309805`"}]}], ",", 
   RowBox[{"cc2211", "\[Rule]", "1.0721515525644207`"}], ",", 
   RowBox[{"cc2220", "\[Rule]", 
    RowBox[{"-", "0.30583502729119766`"}]}], ",", 
   RowBox[{"cc2221", "\[Rule]", "2.8775576990160907`"}], ",", 
   RowBox[{"cc2222", "\[Rule]", "0.6648742606198059`"}], ",", 
   RowBox[{"cc2230", "\[Rule]", 
    RowBox[{"-", "0.28748382713835247`"}]}], ",", 
   RowBox[{"cc2231", "\[Rule]", "4.569446348262335`"}], ",", 
   RowBox[{"cc2232", "\[Rule]", 
    RowBox[{"-", "8.029256694667362`"}]}], ",", 
   RowBox[{"cc2233", "\[Rule]", 
    RowBox[{"-", "43.449804333869274`"}]}], ",", 
   RowBox[{"cc2240", "\[Rule]", 
    RowBox[{"-", "0.206184989888957`"}]}], ",", 
   RowBox[{"cc2241", "\[Rule]", "6.464679881393967`"}], ",", 
   RowBox[{"cc2242", "\[Rule]", 
    RowBox[{"-", "15.541168938330687`"}]}], ",", 
   RowBox[{"cc2243", "\[Rule]", 
    RowBox[{"-", "14.715746544796994`"}]}], ",", 
   RowBox[{"cc2244", "\[Rule]", "301.30193492971927`"}], ",", 
   RowBox[{"cc3000", "\[Rule]", 
    RowBox[{"-", "116.71838295280534`"}]}], ",", 
   RowBox[{"cc3010", "\[Rule]", 
    RowBox[{"-", "157.10494595228252`"}]}], ",", 
   RowBox[{"cc3011", "\[Rule]", "297.26983526527147`"}], ",", 
   RowBox[{"cc3020", "\[Rule]", 
    RowBox[{"-", "201.0157606106547`"}]}], ",", 
   RowBox[{"cc3021", "\[Rule]", "496.36566707931894`"}], ",", 
   RowBox[{"cc3022", "\[Rule]", 
    RowBox[{"-", "405.04558760573553`"}]}], ",", 
   RowBox[{"cc3030", "\[Rule]", 
    RowBox[{"-", "245.18577976754526`"}]}], ",", 
   RowBox[{"cc3031", "\[Rule]", "787.0145352627235`"}], ",", 
   RowBox[{"cc3032", "\[Rule]", 
    RowBox[{"-", "896.6932897726005`"}]}], ",", 
   RowBox[{"cc3033", "\[Rule]", 
    RowBox[{"-", "478.37449350241087`"}]}], ",", 
   RowBox[{"cc3040", "\[Rule]", 
    RowBox[{"-", "287.8353416456311`"}]}], ",", 
   RowBox[{"cc3041", "\[Rule]", "1184.2431621185108`"}], ",", 
   RowBox[{"cc3042", "\[Rule]", 
    RowBox[{"-", "1704.9923904423533`"}]}], ",", 
   RowBox[{"cc3043", "\[Rule]", "306.2628415953851`"}], ",", 
   RowBox[{"cc3044", "\[Rule]", "7296.486460770611`"}], ",", 
   RowBox[{"cc3100", "\[Rule]", "6.844523348528763`"}], ",", 
   RowBox[{"cc3110", "\[Rule]", "9.192496505105465`"}], ",", 
   RowBox[{"cc3111", "\[Rule]", 
    RowBox[{"-", "15.192136636540283`"}]}], ",", 
   RowBox[{"cc3120", "\[Rule]", "11.854291007667145`"}], ",", 
   RowBox[{"cc3121", "\[Rule]", 
    RowBox[{"-", "26.436099333734095`"}]}], ",", 
   RowBox[{"cc3122", "\[Rule]", "29.04600750272108`"}], ",", 
   RowBox[{"cc3130", "\[Rule]", "14.624115040575631`"}], ",", 
   RowBox[{"cc3131", "\[Rule]", 
    RowBox[{"-", "41.46618724149998`"}]}], ",", 
   RowBox[{"cc3132", "\[Rule]", "50.113138300330704`"}], ",", 
   RowBox[{"cc3133", "\[Rule]", 
    RowBox[{"-", "33.13072638388647`"}]}], ",", 
   RowBox[{"cc3140", "\[Rule]", "17.263597429745634`"}], ",", 
   RowBox[{"cc3141", "\[Rule]", 
    RowBox[{"-", "62.76199608380465`"}]}], ",", 
   RowBox[{"cc3142", "\[Rule]", "71.08954498498129`"}], ",", 
   RowBox[{"cc3143", "\[Rule]", 
    RowBox[{"-", "38.93313967317646`"}]}], ",", 
   RowBox[{"cc3144", "\[Rule]", "31.442026444703863`"}], ",", 
   RowBox[{"cc3200", "\[Rule]", "16.66288973040004`"}], ",", 
   RowBox[{"cc3210", "\[Rule]", "22.619348194064127`"}], ",", 
   RowBox[{"cc3211", "\[Rule]", 
    RowBox[{"-", "42.09641045776917`"}]}], ",", 
   RowBox[{"cc3220", "\[Rule]", "28.99027356890732`"}], ",", 
   RowBox[{"cc3221", "\[Rule]", 
    RowBox[{"-", "69.6475572575767`"}]}], ",", 
   RowBox[{"cc3222", "\[Rule]", "59.885951463002286`"}], ",", 
   RowBox[{"cc3230", "\[Rule]", "35.466816556743744`"}], ",", 
   RowBox[{"cc3231", "\[Rule]", 
    RowBox[{"-", "110.39092966282884`"}]}], ",", 
   RowBox[{"cc3232", "\[Rule]", "122.09661954639736`"}], ",", 
   RowBox[{"cc3233", "\[Rule]", "27.564931823867674`"}], ",", 
   RowBox[{"cc3240", "\[Rule]", "41.7346252900847`"}], ",", 
   RowBox[{"cc3241", "\[Rule]", 
    RowBox[{"-", "166.5973801863051`"}]}], ",", 
   RowBox[{"cc3242", "\[Rule]", "234.12423344133444`"}], ",", 
   RowBox[{"cc3243", "\[Rule]", 
    RowBox[{"-", "60.73577377393905`"}]}], ",", 
   RowBox[{"cc3244", "\[Rule]", 
    RowBox[{"-", "775.668746702764`"}]}], ",", 
   RowBox[{"cc3300", "\[Rule]", "3.1170848365164026`"}], ",", 
   RowBox[{"cc3310", "\[Rule]", "4.2316085144379505`"}], ",", 
   RowBox[{"cc3311", "\[Rule]", 
    RowBox[{"-", "8.099940652197818`"}]}], ",", 
   RowBox[{"cc3320", "\[Rule]", "5.401355353938019`"}], ",", 
   RowBox[{"cc3321", "\[Rule]", 
    RowBox[{"-", "13.691650489200176`"}]}], ",", 
   RowBox[{"cc3322", "\[Rule]", "11.236950081152482`"}], ",", 
   RowBox[{"cc3330", "\[Rule]", "6.577221298178338`"}], ",", 
   RowBox[{"cc3331", "\[Rule]", 
    RowBox[{"-", "21.69524400805971`"}]}], ",", 
   RowBox[{"cc3332", "\[Rule]", "24.438200516871166`"}], ",", 
   RowBox[{"cc3333", "\[Rule]", "18.01157152366934`"}], ",", 
   RowBox[{"cc3340", "\[Rule]", "7.694674745782479`"}], ",", 
   RowBox[{"cc3341", "\[Rule]", 
    RowBox[{"-", "32.58926954534253`"}]}], ",", 
   RowBox[{"cc3342", "\[Rule]", "48.97859672040116`"}], ",", 
   RowBox[{"cc3343", "\[Rule]", 
    RowBox[{"-", "3.2268903874120674`"}]}], ",", 
   RowBox[{"cc3344", "\[Rule]", 
    RowBox[{"-", "250.54881019909402`"}]}], ",", 
   RowBox[{"cc4000", "\[Rule]", "175.5331194385192`"}], ",", 
   RowBox[{"cc4010", "\[Rule]", "237.26330314353268`"}], ",", 
   RowBox[{"cc4011", "\[Rule]", 
    RowBox[{"-", "439.48259738916664`"}]}], ",", 
   RowBox[{"cc4020", "\[Rule]", "304.1623663145637`"}], ",", 
   RowBox[{"cc4021", "\[Rule]", 
    RowBox[{"-", "726.0463268838279`"}]}], ",", 
   RowBox[{"cc4022", "\[Rule]", "611.5154963263251`"}], ",", 
   RowBox[{"cc4030", "\[Rule]", "372.345841412667`"}], ",", 
   RowBox[{"cc4031", "\[Rule]", 
    RowBox[{"-", "1151.378574761728`"}]}], ",", 
   RowBox[{"cc4032", "\[Rule]", "1273.606835903029`"}], ",", 
   RowBox[{"cc4033", "\[Rule]", "211.32277074627208`"}], ",", 
   RowBox[{"cc4040", "\[Rule]", "438.30161823153253`"}], ",", 
   RowBox[{"cc4041", "\[Rule]", 
    RowBox[{"-", "1738.4872796935288`"}]}], ",", 
   RowBox[{"cc4042", "\[Rule]", "2406.6150460964404`"}], ",", 
   RowBox[{"cc4043", "\[Rule]", 
    RowBox[{"-", "739.3597723484471`"}]}], ",", 
   RowBox[{"cc4044", "\[Rule]", 
    RowBox[{"-", "7219.478400697426`"}]}], ",", 
   RowBox[{"cc4100", "\[Rule]", 
    RowBox[{"-", "7.061578090332209`"}]}], ",", 
   RowBox[{"cc4110", "\[Rule]", 
    RowBox[{"-", "9.475975222602505`"}]}], ",", 
   RowBox[{"cc4111", "\[Rule]", "20.849772873697578`"}], ",", 
   RowBox[{"cc4120", "\[Rule]", 
    RowBox[{"-", "12.009102558865525`"}]}], ",", 
   RowBox[{"cc4121", "\[Rule]", "32.833451837383656`"}], ",", 
   RowBox[{"cc4122", "\[Rule]", 
    RowBox[{"-", "18.478622809938468`"}]}], ",", 
   RowBox[{"cc4130", "\[Rule]", 
    RowBox[{"-", "14.472795730349524`"}]}], ",", 
   RowBox[{"cc4131", "\[Rule]", "52.56216220181686`"}], ",", 
   RowBox[{"cc4132", "\[Rule]", 
    RowBox[{"-", "56.85750086549421`"}]}], ",", 
   RowBox[{"cc4133", "\[Rule]", 
    RowBox[{"-", "106.09243483544996`"}]}], ",", 
   RowBox[{"cc4140", "\[Rule]", 
    RowBox[{"-", "16.794684388541643`"}]}], ",", 
   RowBox[{"cc4141", "\[Rule]", "78.41513123798792`"}], ",", 
   RowBox[{"cc4142", "\[Rule]", 
    RowBox[{"-", "140.24336918863662`"}]}], ",", 
   RowBox[{"cc4143", "\[Rule]", 
    RowBox[{"-", "7.5270783246041`"}]}], ",", 
   RowBox[{"cc4144", "\[Rule]", "996.276476522988`"}], ",", 
   RowBox[{"cc4200", "\[Rule]", "12.156842575486523`"}], ",", 
   RowBox[{"cc4210", "\[Rule]", "16.608729594203968`"}], ",", 
   RowBox[{"cc4211", "\[Rule]", 
    RowBox[{"-", "30.228103561212915`"}]}], ",", 
   RowBox[{"cc4220", "\[Rule]", "21.325903659795625`"}], ",", 
   RowBox[{"cc4221", "\[Rule]", 
    RowBox[{"-", "50.18818597374305`"}]}], ",", 
   RowBox[{"cc4222", "\[Rule]", "43.853348713125435`"}], ",", 
   RowBox[{"cc4230", "\[Rule]", "26.138135217829422`"}], ",", 
   RowBox[{"cc4231", "\[Rule]", 
    RowBox[{"-", "79.39500223519022`"}]}], ",", 
   RowBox[{"cc4232", "\[Rule]", "85.11775658218221`"}], ",", 
   RowBox[{"cc4233", "\[Rule]", 
    RowBox[{"-", "0.48215049654651343`"}]}], ",", 
   RowBox[{"cc4240", "\[Rule]", "30.800968101098906`"}], ",", 
   RowBox[{"cc4241", "\[Rule]", 
    RowBox[{"-", "120.32636857366307`"}]}], ",", 
   RowBox[{"cc4242", "\[Rule]", "162.5146962632294`"}], ",", 
   RowBox[{"cc4243", "\[Rule]", 
    RowBox[{"-", "63.96347921831137`"}]}], ",", 
   RowBox[{"cc4244", "\[Rule]", 
    RowBox[{"-", "370.2629368011434`"}]}], ",", 
   RowBox[{"cc4300", "\[Rule]", 
    RowBox[{"-", "0.0348511356205778`"}]}], ",", 
   RowBox[{"cc4310", "\[Rule]", 
    RowBox[{"-", "0.027328194595255505`"}]}], ",", 
   RowBox[{"cc4311", "\[Rule]", "0.5181607623593176`"}], ",", 
   RowBox[{"cc4320", "\[Rule]", "0.005010984792621554`"}], ",", 
   RowBox[{"cc4321", "\[Rule]", "1.1488979611280208`"}], ",", 
   RowBox[{"cc4322", "\[Rule]", "0.5880092019006476`"}], ",", 
   RowBox[{"cc4330", "\[Rule]", "0.05184465589446093`"}], ",", 
   RowBox[{"cc4331", "\[Rule]", "1.8520009186676696`"}], ",", 
   RowBox[{"cc4332", "\[Rule]", 
    RowBox[{"-", "3.8582181073295234`"}]}], ",", 
   RowBox[{"cc4333", "\[Rule]", 
    RowBox[{"-", "22.46450431043029`"}]}], ",", 
   RowBox[{"cc4340", "\[Rule]", "0.12812527410853755`"}], ",", 
   RowBox[{"cc4341", "\[Rule]", "2.5426446456393323`"}], ",", 
   RowBox[{"cc4342", "\[Rule]", 
    RowBox[{"-", "8.268980033815573`"}]}], ",", 
   RowBox[{"cc4343", "\[Rule]", 
    RowBox[{"-", "12.508648170735288`"}]}], ",", 
   RowBox[{"cc4344", "\[Rule]", "175.25151814674064`"}], ",", 
   RowBox[{"cc4400", "\[Rule]", "0.15004579596300108`"}], ",", 
   RowBox[{"cc4410", "\[Rule]", "0.19392909925663102`"}], ",", 
   RowBox[{"cc4411", "\[Rule]", 
    RowBox[{"-", "0.2800728070380264`"}]}], ",", 
   RowBox[{"cc4420", "\[Rule]", "0.2486369361482559`"}], ",", 
   RowBox[{"cc4421", "\[Rule]", 
    RowBox[{"-", "0.604700939419277`"}]}], ",", 
   RowBox[{"cc4422", "\[Rule]", "0.8306621786864264`"}], ",", 
   RowBox[{"cc4430", "\[Rule]", "0.30588611620929707`"}], ",", 
   RowBox[{"cc4431", "\[Rule]", 
    RowBox[{"-", "0.9210950772740316`"}]}], ",", 
   RowBox[{"cc4432", "\[Rule]", "1.5003380921029394`"}], ",", 
   RowBox[{"cc4433", "\[Rule]", "0.14954021389054764`"}], ",", 
   RowBox[{"cc4440", "\[Rule]", "0.3615806155323782`"}], ",", 
   RowBox[{"cc4441", "\[Rule]", 
    RowBox[{"-", "1.3908938567406017`"}]}], ",", 
   RowBox[{"cc4442", "\[Rule]", "1.1139719095672898`"}], ",", 
   RowBox[{"cc4443", "\[Rule]", 
    RowBox[{"-", "0.3524813017747819`"}]}], ",", 
   RowBox[{"cc4444", "\[Rule]", 
    RowBox[{"-", "2.7668130806446323`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391639514044*^9, 3.5403917725455914`*^9, 3.5403918847505074`*^9, 
   3.540392043450543*^9, 3.540392335030674*^9, 3.540392466553894*^9, 
   3.540392613746681*^9, 3.540392699786097*^9, 3.540392858074416*^9, 
   3.540393100162195*^9, 3.540393162119933*^9, 3.5403932259539013`*^9, {
   3.5403947855833597`*^9, 3.540394806859878*^9}, 3.540394925714875*^9, 
   3.5403950661531143`*^9, {3.540395164032443*^9, 3.540395180053707*^9}, 
   3.540395239952392*^9, 3.540395345562056*^9, 3.54039678827913*^9, 
   3.5404999779897537`*^9, 3.540502380176126*^9, 3.540502420194992*^9, 
   3.540502519922926*^9, 3.540502595320764*^9, 3.540502753116165*^9, {
   3.54582554369728*^9, 3.545825565812854*^9}, 3.5458257514578257`*^9, 
   3.5458257974969053`*^9, 3.545825923001237*^9, 3.545826030544148*^9, 
   3.545826146498745*^9, 3.545828423513542*^9, 3.545829124336581*^9, 
   3.5458325548626337`*^9, 3.545832634550809*^9, 3.545832672138947*^9, 
   3.545834275881975*^9, 3.545843204393455*^9, 3.545843268266458*^9, 
   3.545846282720303*^9}],

Cell[BoxData["3.832840711481822`*^-10"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391639514044*^9, 3.5403917725455914`*^9, 3.5403918847505074`*^9, 
   3.540392043450543*^9, 3.540392335030674*^9, 3.540392466553894*^9, 
   3.540392613746681*^9, 3.540392699786097*^9, 3.540392858074416*^9, 
   3.540393100162195*^9, 3.540393162119933*^9, 3.5403932259539013`*^9, {
   3.5403947855833597`*^9, 3.540394806859878*^9}, 3.540394925714875*^9, 
   3.5403950661531143`*^9, {3.540395164032443*^9, 3.540395180053707*^9}, 
   3.540395239952392*^9, 3.540395345562056*^9, 3.54039678827913*^9, 
   3.5404999779897537`*^9, 3.540502380176126*^9, 3.540502420194992*^9, 
   3.540502519922926*^9, 3.540502595320764*^9, 3.540502753116165*^9, {
   3.54582554369728*^9, 3.545825565812854*^9}, 3.5458257514578257`*^9, 
   3.5458257974969053`*^9, 3.545825923001237*^9, 3.545826030544148*^9, 
   3.545826146498745*^9, 3.545828423513542*^9, 3.545829124336581*^9, 
   3.5458325548626337`*^9, 3.545832634550809*^9, 3.545832672138947*^9, 
   3.545834275881975*^9, 3.545843204393455*^9, 3.545843268266458*^9, 
   3.5458462830079613`*^9}],

Cell[BoxData["0.26950115438737077`"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391639514044*^9, 3.5403917725455914`*^9, 3.5403918847505074`*^9, 
   3.540392043450543*^9, 3.540392335030674*^9, 3.540392466553894*^9, 
   3.540392613746681*^9, 3.540392699786097*^9, 3.540392858074416*^9, 
   3.540393100162195*^9, 3.540393162119933*^9, 3.5403932259539013`*^9, {
   3.5403947855833597`*^9, 3.540394806859878*^9}, 3.540394925714875*^9, 
   3.5403950661531143`*^9, {3.540395164032443*^9, 3.540395180053707*^9}, 
   3.540395239952392*^9, 3.540395345562056*^9, 3.54039678827913*^9, 
   3.5404999779897537`*^9, 3.540502380176126*^9, 3.540502420194992*^9, 
   3.540502519922926*^9, 3.540502595320764*^9, 3.540502753116165*^9, {
   3.54582554369728*^9, 3.545825565812854*^9}, 3.5458257514578257`*^9, 
   3.5458257974969053`*^9, 3.545825923001237*^9, 3.545826030544148*^9, 
   3.545826146498745*^9, 3.545828423513542*^9, 3.545829124336581*^9, 
   3.5458325548626337`*^9, 3.545832634550809*^9, 3.545832672138947*^9, 
   3.545834275881975*^9, 3.545843204393455*^9, 3.545843268266458*^9, 
   3.5458462844611073`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.540392712503456*^9, 3.540392746093145*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["I2", "Subsection",
 CellChangeTimes->{{3.5403903458397007`*^9, 3.540390345908845*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f22I2Function", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        RowBox[{"z", " ", "*", " ", "t"}]}], ")"}], "^", "2"}], " ", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"G", "[", "t", "]"}], " ", "/", " ", "t"}], " ", "+", " ", 
        RowBox[{"1", "/", "2"}]}], "]"}], "^", "2"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", " ", "-", " ", "delta"}], ")"}], "/", "z"}], ",", " ", 
      RowBox[{"1", "/", "z"}]}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f22I2Data", " ", "=", 
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", " ", 
         RowBox[{"Apply", "[", 
          RowBox[{"f22I2Function", ",", " ", "#"}], "]"}]}], "}"}], "]"}], 
      " ", "&"}], "/@", " ", "evaluationPoints"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.540390367744677*^9, 3.540390391896315*^9}, {
   3.540390424798936*^9, 3.5403904251308727`*^9}, {3.540390458667108*^9, 
   3.540390492743198*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f22I2Model", " ", "=", " ", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{"f22I2Data", ",", " ", "polynomial", ",", "coefficients", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", " ", "delta"}], "}"}]}], "]"}]}], " ", ";"}], "\n", 
 RowBox[{"f22I2Model", "[", "\"\<BestFitParameters\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f22I2", " ", "=", " ", 
   RowBox[{"f22I2Model", "[", "\"\<Function\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f22I2Model", "[", "\"\<FitResiduals\>\"", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f22I2Model", "[", "\"\<StandardizedResiduals\>\"", "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.5403904030912943`*^9, 3.540390411938726*^9}, {
   3.540390558606029*^9, 3.540390574639647*^9}, {3.540390692118628*^9, 
   3.5403906924464283`*^9}, {3.5403907432028217`*^9, 
   3.5403907454381237`*^9}, {3.540390818086678*^9, 3.5403908390898933`*^9}, {
   3.540391616166291*^9, 3.54039162286337*^9}, {3.5403924902307987`*^9, 
   3.5403925185593367`*^9}, {3.5403950844337482`*^9, 3.540395085946599*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"cc0000", "\[Rule]", 
    RowBox[{"-", "0.08844478727893182`"}]}], ",", 
   RowBox[{"cc0010", "\[Rule]", "0.02013979777267092`"}], ",", 
   RowBox[{"cc0011", "\[Rule]", 
    RowBox[{"-", "8.630853206710956`"}]}], ",", 
   RowBox[{"cc0020", "\[Rule]", 
    RowBox[{"-", "0.2294912152097781`"}]}], ",", 
   RowBox[{"cc0021", "\[Rule]", "0.7640181994153706`"}], ",", 
   RowBox[{"cc0022", "\[Rule]", "73.55919074244919`"}], ",", 
   RowBox[{"cc0030", "\[Rule]", 
    RowBox[{"-", "0.19509746655788332`"}]}], ",", 
   RowBox[{"cc0031", "\[Rule]", "2.823283011745419`"}], ",", 
   RowBox[{"cc0032", "\[Rule]", 
    RowBox[{"-", "32.02360779003266`"}]}], ",", 
   RowBox[{"cc0033", "\[Rule]", "26.254824787406807`"}], ",", 
   RowBox[{"cc0040", "\[Rule]", 
    RowBox[{"-", "0.18330571779624213`"}]}], ",", 
   RowBox[{"cc0041", "\[Rule]", "1.975828076335874`"}], ",", 
   RowBox[{"cc0042", "\[Rule]", 
    RowBox[{"-", "26.25543151168059`"}]}], ",", 
   RowBox[{"cc0043", "\[Rule]", "29.865139874025694`"}], ",", 
   RowBox[{"cc0044", "\[Rule]", 
    RowBox[{"-", "204.48983183444915`"}]}], ",", 
   RowBox[{"cc1000", "\[Rule]", 
    RowBox[{"-", "1.0940440400573597`"}]}], ",", 
   RowBox[{"cc1010", "\[Rule]", "0.4137222599366964`"}], ",", 
   RowBox[{"cc1011", "\[Rule]", "25.59700884693367`"}], ",", 
   RowBox[{"cc1020", "\[Rule]", "1.2283287153063294`"}], ",", 
   RowBox[{"cc1021", "\[Rule]", "0.2528225117050316`"}], ",", 
   RowBox[{"cc1022", "\[Rule]", 
    RowBox[{"-", "183.33667622449147`"}]}], ",", 
   RowBox[{"cc1030", "\[Rule]", "1.4809209127369325`"}], ",", 
   RowBox[{"cc1031", "\[Rule]", 
    RowBox[{"-", "5.861396598855272`"}]}], ",", 
   RowBox[{"cc1032", "\[Rule]", "35.39952274310065`"}], ",", 
   RowBox[{"cc1033", "\[Rule]", "231.11641232448343`"}], ",", 
   RowBox[{"cc1040", "\[Rule]", "1.7299373477122426`"}], ",", 
   RowBox[{"cc1041", "\[Rule]", 
    RowBox[{"-", "6.052734190230891`"}]}], ",", 
   RowBox[{"cc1042", "\[Rule]", "34.2949292625201`"}], ",", 
   RowBox[{"cc1043", "\[Rule]", 
    RowBox[{"-", "178.66703753423386`"}]}], ",", 
   RowBox[{"cc1044", "\[Rule]", "710.655759296404`"}], ",", 
   RowBox[{"cc1100", "\[Rule]", 
    RowBox[{"-", "0.7385771314999667`"}]}], ",", 
   RowBox[{"cc1110", "\[Rule]", 
    RowBox[{"-", "0.06308227431262102`"}]}], ",", 
   RowBox[{"cc1111", "\[Rule]", "0.8216827621736801`"}], ",", 
   RowBox[{"cc1120", "\[Rule]", 
    RowBox[{"-", "0.21006372820459074`"}]}], ",", 
   RowBox[{"cc1121", "\[Rule]", 
    RowBox[{"-", "4.773354370665777`"}]}], ",", 
   RowBox[{"cc1122", "\[Rule]", "16.241961533998353`"}], ",", 
   RowBox[{"cc1130", "\[Rule]", 
    RowBox[{"-", "0.46567764498070024`"}]}], ",", 
   RowBox[{"cc1131", "\[Rule]", 
    RowBox[{"-", "5.571532609296328`"}]}], ",", 
   RowBox[{"cc1132", "\[Rule]", "25.115417002416567`"}], ",", 
   RowBox[{"cc1133", "\[Rule]", 
    RowBox[{"-", "161.787331686738`"}]}], ",", 
   RowBox[{"cc1140", "\[Rule]", 
    RowBox[{"-", "0.7611478635043902`"}]}], ",", 
   RowBox[{"cc1141", "\[Rule]", 
    RowBox[{"-", "6.78238768793539`"}]}], ",", 
   RowBox[{"cc1142", "\[Rule]", "27.924018588281843`"}], ",", 
   RowBox[{"cc1143", "\[Rule]", 
    RowBox[{"-", "144.46569737071437`"}]}], ",", 
   RowBox[{"cc1144", "\[Rule]", "800.578347568791`"}], ",", 
   RowBox[{"cc2000", "\[Rule]", "1.6063541724988502`"}], ",", 
   RowBox[{"cc2010", "\[Rule]", 
    RowBox[{"-", "1.1638730935608`"}]}], ",", 
   RowBox[{"cc2011", "\[Rule]", 
    RowBox[{"-", "21.20110431038122`"}]}], ",", 
   RowBox[{"cc2020", "\[Rule]", 
    RowBox[{"-", "2.383637538536832`"}]}], ",", 
   RowBox[{"cc2021", "\[Rule]", 
    RowBox[{"-", "13.160506166237967`"}]}], ",", 
   RowBox[{"cc2022", "\[Rule]", "108.49681075694997`"}], ",", 
   RowBox[{"cc2030", "\[Rule]", 
    RowBox[{"-", "3.5975418626184874`"}]}], ",", 
   RowBox[{"cc2031", "\[Rule]", 
    RowBox[{"-", "9.887884365415399`"}]}], ",", 
   RowBox[{"cc2032", "\[Rule]", "115.53868148535899`"}], ",", 
   RowBox[{"cc2033", "\[Rule]", 
    RowBox[{"-", "893.4516082813665`"}]}], ",", 
   RowBox[{"cc2040", "\[Rule]", 
    RowBox[{"-", "4.836344259715466`"}]}], ",", 
   RowBox[{"cc2041", "\[Rule]", 
    RowBox[{"-", "5.517013983697198`"}]}], ",", 
   RowBox[{"cc2042", "\[Rule]", "132.60900408852095`"}], ",", 
   RowBox[{"cc2043", "\[Rule]", 
    RowBox[{"-", "73.70881623880194`"}]}], ",", 
   RowBox[{"cc2044", "\[Rule]", "630.3077820076137`"}], ",", 
   RowBox[{"cc2100", "\[Rule]", 
    RowBox[{"-", "0.22985284681546078`"}]}], ",", 
   RowBox[{"cc2110", "\[Rule]", 
    RowBox[{"-", "0.11681716780385427`"}]}], ",", 
   RowBox[{"cc2111", "\[Rule]", 
    RowBox[{"-", "3.7137977765351806`"}]}], ",", 
   RowBox[{"cc2120", "\[Rule]", 
    RowBox[{"-", "0.3502342691466022`"}]}], ",", 
   RowBox[{"cc2121", "\[Rule]", 
    RowBox[{"-", "3.2593540998627155`"}]}], ",", 
   RowBox[{"cc2122", "\[Rule]", "40.84353292074809`"}], ",", 
   RowBox[{"cc2130", "\[Rule]", 
    RowBox[{"-", "0.5644626298971566`"}]}], ",", 
   RowBox[{"cc2131", "\[Rule]", 
    RowBox[{"-", "2.4852819372973207`"}]}], ",", 
   RowBox[{"cc2132", "\[Rule]", "11.06906050662053`"}], ",", 
   RowBox[{"cc2133", "\[Rule]", 
    RowBox[{"-", "299.42850206818605`"}]}], ",", 
   RowBox[{"cc2140", "\[Rule]", 
    RowBox[{"-", "0.8001138855701317`"}]}], ",", 
   RowBox[{"cc2141", "\[Rule]", 
    RowBox[{"-", "3.5462258070054893`"}]}], ",", 
   RowBox[{"cc2142", "\[Rule]", "6.536883485897214`"}], ",", 
   RowBox[{"cc2143", "\[Rule]", "67.28855601174371`"}], ",", 
   RowBox[{"cc2144", "\[Rule]", "333.03488137319664`"}], ",", 
   RowBox[{"cc2200", "\[Rule]", "0.5597113669903457`"}], ",", 
   RowBox[{"cc2210", "\[Rule]", 
    RowBox[{"-", "0.051929512471634395`"}]}], ",", 
   RowBox[{"cc2211", "\[Rule]", 
    RowBox[{"-", "6.006283436591498`"}]}], ",", 
   RowBox[{"cc2220", "\[Rule]", 
    RowBox[{"-", "0.16203180152032357`"}]}], ",", 
   RowBox[{"cc2221", "\[Rule]", "1.7969654512028523`"}], ",", 
   RowBox[{"cc2222", "\[Rule]", "39.14658551984174`"}], ",", 
   RowBox[{"cc2230", "\[Rule]", 
    RowBox[{"-", "0.10529177244984911`"}]}], ",", 
   RowBox[{"cc2231", "\[Rule]", "3.721565635266355`"}], ",", 
   RowBox[{"cc2232", "\[Rule]", 
    RowBox[{"-", "24.77312292535894`"}]}], ",", 
   RowBox[{"cc2233", "\[Rule]", 
    RowBox[{"-", "172.83791314882984`"}]}], ",", 
   RowBox[{"cc2240", "\[Rule]", 
    RowBox[{"-", "0.041870556894143325`"}]}], ",", 
   RowBox[{"cc2241", "\[Rule]", "2.8570939868890295`"}], ",", 
   RowBox[{"cc2242", "\[Rule]", 
    RowBox[{"-", "40.28617937888477`"}]}], ",", 
   RowBox[{"cc2243", "\[Rule]", "234.95908883734222`"}], ",", 
   RowBox[{"cc2244", "\[Rule]", 
    RowBox[{"-", "295.58749449358714`"}]}], ",", 
   RowBox[{"cc3000", "\[Rule]", "1.6917875141302143`"}], ",", 
   RowBox[{"cc3010", "\[Rule]", "0.216020090613757`"}], ",", 
   RowBox[{"cc3011", "\[Rule]", 
    RowBox[{"-", "8.166417087444488`"}]}], ",", 
   RowBox[{"cc3020", "\[Rule]", "0.4130990991089515`"}], ",", 
   RowBox[{"cc3021", "\[Rule]", "11.688534632247162`"}], ",", 
   RowBox[{"cc3022", "\[Rule]", "51.03826086670832`"}], ",", 
   RowBox[{"cc3030", "\[Rule]", "1.0697314891566323`"}], ",", 
   RowBox[{"cc3031", "\[Rule]", "15.55668406971433`"}], ",", 
   RowBox[{"cc3032", "\[Rule]", 
    RowBox[{"-", "126.47111087216638`"}]}], ",", 
   RowBox[{"cc3033", "\[Rule]", 
    RowBox[{"-", "53.699322636760954`"}]}], ",", 
   RowBox[{"cc3040", "\[Rule]", "1.7577232424156906`"}], ",", 
   RowBox[{"cc3041", "\[Rule]", "11.634607460130178`"}], ",", 
   RowBox[{"cc3042", "\[Rule]", 
    RowBox[{"-", "165.39788297258542`"}]}], ",", 
   RowBox[{"cc3043", "\[Rule]", "627.9142137327303`"}], ",", 
   RowBox[{"cc3044", "\[Rule]", 
    RowBox[{"-", "1135.6896875678324`"}]}], ",", 
   RowBox[{"cc3100", "\[Rule]", "0.6595298519516858`"}], ",", 
   RowBox[{"cc3110", "\[Rule]", 
    RowBox[{"-", "0.0748827310427068`"}]}], ",", 
   RowBox[{"cc3111", "\[Rule]", 
    RowBox[{"-", "8.659891397464534`"}]}], ",", 
   RowBox[{"cc3120", "\[Rule]", 
    RowBox[{"-", "0.2508270901767513`"}]}], ",", 
   RowBox[{"cc3121", "\[Rule]", "2.046011845442022`"}], ",", 
   RowBox[{"cc3122", "\[Rule]", "54.66113999474579`"}], ",", 
   RowBox[{"cc3130", "\[Rule]", 
    RowBox[{"-", "0.19647324931757576`"}]}], ",", 
   RowBox[{"cc3131", "\[Rule]", "4.576545890311634`"}], ",", 
   RowBox[{"cc3132", "\[Rule]", 
    RowBox[{"-", "31.457915227573885`"}]}], ",", 
   RowBox[{"cc3133", "\[Rule]", 
    RowBox[{"-", "255.60625025887717`"}]}], ",", 
   RowBox[{"cc3140", "\[Rule]", 
    RowBox[{"-", "0.14005232820616603`"}]}], ",", 
   RowBox[{"cc3141", "\[Rule]", "3.410534952979702`"}], ",", 
   RowBox[{"cc3142", "\[Rule]", 
    RowBox[{"-", "49.172809319071376`"}]}], ",", 
   RowBox[{"cc3143", "\[Rule]", "306.74847240147153`"}], ",", 
   RowBox[{"cc3144", "\[Rule]", 
    RowBox[{"-", "363.05085037370475`"}]}], ",", 
   RowBox[{"cc3200", "\[Rule]", "0.43802335582868446`"}], ",", 
   RowBox[{"cc3210", "\[Rule]", 
    RowBox[{"-", "0.1125464622158745`"}]}], ",", 
   RowBox[{"cc3211", "\[Rule]", 
    RowBox[{"-", "4.569472242353568`"}]}], ",", 
   RowBox[{"cc3220", "\[Rule]", 
    RowBox[{"-", "0.24544475079518147`"}]}], ",", 
   RowBox[{"cc3221", "\[Rule]", "0.18342481509851818`"}], ",", 
   RowBox[{"cc3222", "\[Rule]", "22.459591376855066`"}], ",", 
   RowBox[{"cc3230", "\[Rule]", 
    RowBox[{"-", "0.29922738812813615`"}]}], ",", 
   RowBox[{"cc3231", "\[Rule]", "1.168532542395069`"}], ",", 
   RowBox[{"cc3232", "\[Rule]", 
    RowBox[{"-", "3.3820044979266446`"}]}], ",", 
   RowBox[{"cc3233", "\[Rule]", 
    RowBox[{"-", "87.89441658837859`"}]}], ",", 
   RowBox[{"cc3240", "\[Rule]", 
    RowBox[{"-", "0.350782609580471`"}]}], ",", 
   RowBox[{"cc3241", "\[Rule]", "1.2036750575781043`"}], ",", 
   RowBox[{"cc3242", "\[Rule]", 
    RowBox[{"-", "10.694498278928723`"}]}], ",", 
   RowBox[{"cc3243", "\[Rule]", "55.54840271275914`"}], ",", 
   RowBox[{"cc3244", "\[Rule]", 
    RowBox[{"-", "1.6235221890753955`"}]}], ",", 
   RowBox[{"cc3300", "\[Rule]", "0.16612048201406623`"}], ",", 
   RowBox[{"cc3310", "\[Rule]", 
    RowBox[{"-", "0.04508784275759907`"}]}], ",", 
   RowBox[{"cc3311", "\[Rule]", 
    RowBox[{"-", "1.1272460733522318`"}]}], ",", 
   RowBox[{"cc3320", "\[Rule]", 
    RowBox[{"-", "0.07598292685253591`"}]}], ",", 
   RowBox[{"cc3321", "\[Rule]", "0.10515704064481832`"}], ",", 
   RowBox[{"cc3322", "\[Rule]", 
    RowBox[{"-", "0.5278688057184483`"}]}], ",", 
   RowBox[{"cc3330", "\[Rule]", 
    RowBox[{"-", "0.09742856630532715`"}]}], ",", 
   RowBox[{"cc3331", "\[Rule]", "0.16073967364766534`"}], ",", 
   RowBox[{"cc3332", "\[Rule]", "2.387014004089063`"}], ",", 
   RowBox[{"cc3333", "\[Rule]", "26.553197098004738`"}], ",", 
   RowBox[{"cc3340", "\[Rule]", 
    RowBox[{"-", "0.11567329305228644`"}]}], ",", 
   RowBox[{"cc3341", "\[Rule]", "0.56740759045708`"}], ",", 
   RowBox[{"cc3342", "\[Rule]", "3.1269774336566103`"}], ",", 
   RowBox[{"cc3343", "\[Rule]", 
    RowBox[{"-", "33.7894872036245`"}]}], ",", 
   RowBox[{"cc3344", "\[Rule]", "31.021812629375855`"}], ",", 
   RowBox[{"cc4000", "\[Rule]", 
    RowBox[{"-", "2.6736259865655603`"}]}], ",", 
   RowBox[{"cc4010", "\[Rule]", "0.0156909241608018`"}], ",", 
   RowBox[{"cc4011", "\[Rule]", "4.302624332862838`"}], ",", 
   RowBox[{"cc4020", "\[Rule]", 
    RowBox[{"-", "0.3522576430119394`"}]}], ",", 
   RowBox[{"cc4021", "\[Rule]", 
    RowBox[{"-", "12.553865778495572`"}]}], ",", 
   RowBox[{"cc4022", "\[Rule]", "89.21478412603666`"}], ",", 
   RowBox[{"cc4030", "\[Rule]", 
    RowBox[{"-", "0.9409149868471159`"}]}], ",", 
   RowBox[{"cc4031", "\[Rule]", 
    RowBox[{"-", "15.254757092752813`"}]}], ",", 
   RowBox[{"cc4032", "\[Rule]", "24.643704933040574`"}], ",", 
   RowBox[{"cc4033", "\[Rule]", "98.10328617239486`"}], ",", 
   RowBox[{"cc4040", "\[Rule]", 
    RowBox[{"-", "1.6967827873999732`"}]}], ",", 
   RowBox[{"cc4041", "\[Rule]", 
    RowBox[{"-", "20.08073679326782`"}]}], ",", 
   RowBox[{"cc4042", "\[Rule]", "72.55345896138209`"}], ",", 
   RowBox[{"cc4043", "\[Rule]", 
    RowBox[{"-", "782.6201160189243`"}]}], ",", 
   RowBox[{"cc4044", "\[Rule]", "2676.8516343715555`"}], ",", 
   RowBox[{"cc4100", "\[Rule]", "1.2363820378846686`"}], ",", 
   RowBox[{"cc4110", "\[Rule]", 
    RowBox[{"-", "0.12742094055925593`"}]}], ",", 
   RowBox[{"cc4111", "\[Rule]", 
    RowBox[{"-", "11.114489628879317`"}]}], ",", 
   RowBox[{"cc4120", "\[Rule]", 
    RowBox[{"-", "0.2754427968514543`"}]}], ",", 
   RowBox[{"cc4121", "\[Rule]", "4.507068058303987`"}], ",", 
   RowBox[{"cc4122", "\[Rule]", "35.07448586987439`"}], ",", 
   RowBox[{"cc4130", "\[Rule]", 
    RowBox[{"-", "0.1628028633858431`"}]}], ",", 
   RowBox[{"cc4131", "\[Rule]", "6.204096141716936`"}], ",", 
   RowBox[{"cc4132", "\[Rule]", 
    RowBox[{"-", "42.83082909548467`"}]}], ",", 
   RowBox[{"cc4133", "\[Rule]", "150.8458961809553`"}], ",", 
   RowBox[{"cc4140", "\[Rule]", 
    RowBox[{"-", "0.036606349945206874`"}]}], ",", 
   RowBox[{"cc4141", "\[Rule]", "5.847285544088573`"}], ",", 
   RowBox[{"cc4142", "\[Rule]", 
    RowBox[{"-", "56.96898441691739`"}]}], ",", 
   RowBox[{"cc4143", "\[Rule]", 
    RowBox[{"-", "28.591024787527893`"}]}], ",", 
   RowBox[{"cc4144", "\[Rule]", "195.96907423426342`"}], ",", 
   RowBox[{"cc4200", "\[Rule]", "0.3223468879775074`"}], ",", 
   RowBox[{"cc4210", "\[Rule]", 
    RowBox[{"-", "0.0913184965955331`"}]}], ",", 
   RowBox[{"cc4211", "\[Rule]", 
    RowBox[{"-", "0.8047708305798156`"}]}], ",", 
   RowBox[{"cc4220", "\[Rule]", 
    RowBox[{"-", "0.12437846150918067`"}]}], ",", 
   RowBox[{"cc4221", "\[Rule]", 
    RowBox[{"-", "0.13437580491745668`"}]}], ",", 
   RowBox[{"cc4222", "\[Rule]", 
    RowBox[{"-", "16.037434941656866`"}]}], ",", 
   RowBox[{"cc4230", "\[Rule]", 
    RowBox[{"-", "0.1860822546254927`"}]}], ",", 
   RowBox[{"cc4231", "\[Rule]", 
    RowBox[{"-", "0.7486822699443438`"}]}], ",", 
   RowBox[{"cc4232", "\[Rule]", "10.579780517873314`"}], ",", 
   RowBox[{"cc4233", "\[Rule]", "92.0709842982618`"}], ",", 
   RowBox[{"cc4240", "\[Rule]", 
    RowBox[{"-", "0.2529945683067125`"}]}], ",", 
   RowBox[{"cc4241", "\[Rule]", 
    RowBox[{"-", "0.16996005404335707`"}]}], ",", 
   RowBox[{"cc4242", "\[Rule]", "6.684302826771035`"}], ",", 
   RowBox[{"cc4243", "\[Rule]", 
    RowBox[{"-", "158.08907134754196`"}]}], ",", 
   RowBox[{"cc4244", "\[Rule]", "404.42394779858154`"}], ",", 
   RowBox[{"cc4300", "\[Rule]", "0.1745752787700182`"}], ",", 
   RowBox[{"cc4310", "\[Rule]", 
    RowBox[{"-", "0.015252387229377952`"}]}], ",", 
   RowBox[{"cc4311", "\[Rule]", 
    RowBox[{"-", "1.3658492502919344`"}]}], ",", 
   RowBox[{"cc4320", "\[Rule]", 
    RowBox[{"-", "0.03492521925371115`"}]}], ",", 
   RowBox[{"cc4321", "\[Rule]", "0.5241337404927174`"}], ",", 
   RowBox[{"cc4322", "\[Rule]", "5.766663749745204`"}], ",", 
   RowBox[{"cc4330", "\[Rule]", 
    RowBox[{"-", "0.019295916385540818`"}]}], ",", 
   RowBox[{"cc4331", "\[Rule]", "0.9008794493871275`"}], ",", 
   RowBox[{"cc4332", "\[Rule]", 
    RowBox[{"-", "5.697022377396328`"}]}], ",", 
   RowBox[{"cc4333", "\[Rule]", 
    RowBox[{"-", "48.49183331914661`"}]}], ",", 
   RowBox[{"cc4340", "\[Rule]", 
    RowBox[{"-", "0.002070281862684145`"}]}], ",", 
   RowBox[{"cc4341", "\[Rule]", "0.6517116630639099`"}], ",", 
   RowBox[{"cc4342", "\[Rule]", 
    RowBox[{"-", "10.994058486102738`"}]}], ",", 
   RowBox[{"cc4343", "\[Rule]", "56.70390695718978`"}], ",", 
   RowBox[{"cc4344", "\[Rule]", 
    RowBox[{"-", "30.702718371170192`"}]}], ",", 
   RowBox[{"cc4400", "\[Rule]", "0.054201634002265506`"}], ",", 
   RowBox[{"cc4410", "\[Rule]", 
    RowBox[{"-", "0.009730669441115235`"}]}], ",", 
   RowBox[{"cc4411", "\[Rule]", 
    RowBox[{"-", "0.1884337476231421`"}]}], ",", 
   RowBox[{"cc4420", "\[Rule]", 
    RowBox[{"-", "0.014235233468680273`"}]}], ",", 
   RowBox[{"cc4421", "\[Rule]", "0.0693480826656825`"}], ",", 
   RowBox[{"cc4422", "\[Rule]", "0.08483085338518491`"}], ",", 
   RowBox[{"cc4430", "\[Rule]", 
    RowBox[{"-", "0.01578367820676655`"}]}], ",", 
   RowBox[{"cc4431", "\[Rule]", "0.10734332244629864`"}], ",", 
   RowBox[{"cc4432", "\[Rule]", 
    RowBox[{"-", "0.38882973847719465`"}]}], ",", 
   RowBox[{"cc4433", "\[Rule]", 
    RowBox[{"-", "1.2022690174435458`"}]}], ",", 
   RowBox[{"cc4440", "\[Rule]", 
    RowBox[{"-", "0.016882310866676322`"}]}], ",", 
   RowBox[{"cc4441", "\[Rule]", "0.13824196494994653`"}], ",", 
   RowBox[{"cc4442", "\[Rule]", 
    RowBox[{"-", "0.3278085962707645`"}]}], ",", 
   RowBox[{"cc4443", "\[Rule]", "1.2564141643522067`"}], ",", 
   RowBox[{"cc4444", "\[Rule]", 
    RowBox[{"-", "0.43426091929412725`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, 3.5403916428668203`*^9, 
   3.540391785575221*^9, 3.540391908367577*^9, 3.540392067070156*^9, {
   3.5403925066454067`*^9, 3.540392519025996*^9}, 3.540395112856679*^9, 
   3.540395186228484*^9, 3.540395245252141*^9, 3.5403953511426687`*^9, 
   3.540396811169014*^9, 3.540500000768293*^9, 3.545825577522138*^9, 
   3.5458257559933147`*^9, 3.54582580116689*^9, 3.545825941180457*^9, 
   3.545826043152318*^9, 3.545826160161954*^9, 3.545828436459874*^9, 
   3.5458325586625843`*^9, 3.545832684602577*^9, 3.545834300973546*^9, 
   3.545843208784149*^9, 3.545843273305984*^9, 3.545846296327227*^9}],

Cell[BoxData["2.6015967158343756`*^-11"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, 3.5403916428668203`*^9, 
   3.540391785575221*^9, 3.540391908367577*^9, 3.540392067070156*^9, {
   3.5403925066454067`*^9, 3.540392519025996*^9}, 3.540395112856679*^9, 
   3.540395186228484*^9, 3.540395245252141*^9, 3.5403953511426687`*^9, 
   3.540396811169014*^9, 3.540500000768293*^9, 3.545825577522138*^9, 
   3.5458257559933147`*^9, 3.54582580116689*^9, 3.545825941180457*^9, 
   3.545826043152318*^9, 3.545826160161954*^9, 3.545828436459874*^9, 
   3.5458325586625843`*^9, 3.545832684602577*^9, 3.545834300973546*^9, 
   3.545843208784149*^9, 3.545843273305984*^9, 3.545846296652804*^9}],

Cell[BoxData["0.7051052911037956`"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, 3.5403916428668203`*^9, 
   3.540391785575221*^9, 3.540391908367577*^9, 3.540392067070156*^9, {
   3.5403925066454067`*^9, 3.540392519025996*^9}, 3.540395112856679*^9, 
   3.540395186228484*^9, 3.540395245252141*^9, 3.5403953511426687`*^9, 
   3.540396811169014*^9, 3.540500000768293*^9, 3.545825577522138*^9, 
   3.5458257559933147`*^9, 3.54582580116689*^9, 3.545825941180457*^9, 
   3.545826043152318*^9, 3.545826160161954*^9, 3.545828436459874*^9, 
   3.5458325586625843`*^9, 3.545832684602577*^9, 3.545834300973546*^9, 
   3.545843208784149*^9, 3.545843273305984*^9, 3.5458462981857643`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["relative error", "Subsection",
 CellChangeTimes->{{3.540391557706044*^9, 3.54039155925325*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f22", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"-", "8"}], 
   RowBox[{
    RowBox[{"z", "^", "2"}], "/", "9"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"delta", " ", "*", " ", 
      RowBox[{"f22I1Function", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}]}], " ", "+", " ", 
     RowBox[{"f22I2Function", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f22Approx", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"-", "8"}], 
   RowBox[{
    RowBox[{"z", "^", "2"}], "/", "9"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"delta", " ", "*", " ", 
      RowBox[{"f22I1", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}]}], " ", "+", " ", 
     RowBox[{"f22I2", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f22RelError", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f22", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}], " ", "-", " ", 
     RowBox[{"f22Approx", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}], "/", 
   RowBox[{"f22", "[", 
    RowBox[{"z", ",", " ", "delta"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.540391182768642*^9, 3.5403913040756893`*^9}, {
  3.540391463874198*^9, 3.540391468862564*^9}, {3.540391575496809*^9, 
  3.540391597370288*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"11", "/", "36"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "5"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"11", "/", "36"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f22RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "5"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.540391182768642*^9, 3.5403913040756893`*^9}, {
  3.540391463874198*^9, 3.5403915069933243`*^9}, {3.540391665974099*^9, 
  3.540391667869361*^9}, {3.540391700435533*^9, 3.540391701941266*^9}, {
  3.545825719139771*^9, 3.545825725805408*^9}}],

Cell[BoxData[
 RowBox[{"3.065335066700151`*^-10", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.545846298505864*^9}],

Cell[BoxData[
 RowBox[{"2.8037027981181795`*^-10", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.545846298648511*^9}],

Cell[BoxData[
 RowBox[{"2.371109529963335`*^-10", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.545846298790633*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.0015463563609339`*^-10"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.545846298956032*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.5149682375833432`*^-10"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.545846299123407*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.8029538968034244`*^-10"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.540391668450639*^9, 3.540391703578862*^9, 3.540391786037498*^9, 
   3.540391909019602*^9, 3.540392067674461*^9, 3.5403951259592648`*^9, 
   3.540395190880859*^9, 3.5403952499654818`*^9, 3.540395355292631*^9, 
   3.54039681185518*^9, 3.540500001585659*^9, 3.545825578168178*^9, {
   3.54582570553638*^9, 3.5458257264922533`*^9}, {3.545825777866558*^9, 
   3.545825806899704*^9}, 3.545825990143162*^9, 3.545826044908732*^9, 
   3.54582616195226*^9, 3.545828438201901*^9, 3.545832563878539*^9, 
   3.545832690663557*^9, 3.545843213843235*^9, 3.54584328781108*^9, 
   3.5458462992900467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f22RelError", "[", 
       RowBox[{"z", ",", "delta"}], "]"}], "\[Equal]", " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "10"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"f22RelError", "[", 
       RowBox[{"z", ",", "delta"}], "]"}], "\[Equal]", " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "9"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", 
     RowBox[{"3", "/", "100"}], ",", " ", 
     RowBox[{"12", "/", "100"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"delta", ",", " ", 
     RowBox[{"1", "/", "36"}], ",", " ", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.545826266817603*^9, 3.545826333836135*^9}, {
  3.545826395958715*^9, 3.545826409866385*^9}, {3.545826712526803*^9, 
  3.54582671668266*^9}, {3.5458267657939997`*^9, 3.545826785030246*^9}, {
  3.545826917852666*^9, 3.545826941280423*^9}, {3.545827136375307*^9, 
  3.545827138921*^9}, {3.5458271969684353`*^9, 3.545827199008737*^9}, {
  3.545827436337471*^9, 3.545827442259457*^9}, {3.545832702479068*^9, 
  3.545832707825963*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlmgk0lG/YuIWiUshehLTYs2+pG1kishYp0YYKUSiRSglJtlJkHSN7mgXT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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}], 
     LineBox[{51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 
      67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
      85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
      102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 
      116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
      130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142}], 
     LineBox[{143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
       156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
      170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181}], 
     LineBox[CompressedData["
1:eJwN0EVWQgEAAMCPjYUo1tIrcQSfa7kdBgY2BtgB2I1d2DWLucD09Cbi/aEg
CPpIMsAgQwyTYoRRxhgnzQSTTDHNDLPMkWGeBRZZIkuOZVZYZY11Nthki212
yFOgyC577HPAIUccc8IpZ5xzwSUlrrjmhlvuuOeBR5545oUyr7zxzgeffPHN
D7/8EQgLUUElVVRTQy11hKmngUaaaCZCC1FaaSNGOx100kU3/ys7QqA=
      "]], 
     LineBox[CompressedData["
1:eJwV0Nk2QgEAQNHbbyCUMgsVmecQkkJJiEiDEv3/g+1hr3WeT6QxKH2HgiCo
MiJGGSPMOBNMEiHKFDHiTDPDLHPMs8AiSyRYZoVVkqRIs8Y6GTbYZIttdthl
j30OOOSIY07IcsoZ5+S44JIr8lxT4IYiJW65454yFR6o8kiNJ555oc4rbzR4
54Mmn7Ro06HLFz36/I8d8MMvQ/4As3wavA==
      "]], LineBox[CompressedData["
1:eJwNxtc6ggEAANDfo3glD+DCA3CREcnOzl4VQig7o8wQMpJ4JOfifN9pbGlr
am0IgqCZkLTTQSddhOmmhwi9ROmjnwEGGWKYEWKMMsY4E0wyxTRxZphljnkW
WGSJZVZYZY0ESVKss8EmabbYZocMu+yxT5YcBxxyxDEnnHJGnnMuuOSKAkWu
ueGWO+55oMQjTzxT5oVX3qjwzgeffFHlmxo/1Pnlj38vzD29
      "]], 
     LineBox[{465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477,
       478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 
      492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 
      506, 507, 508, 509, 510, 511, 512}], LineBox[CompressedData["
1:eJwNw9c6AmAAANC/MhIZ2Vuo7DJDw0zZRFZ3PQDvf+ec7zvpzl/zNxJCaBuJ
hhA1Zpfd9thr3D4T9jtg0kGHHHbElKOOOe6Ek0457YyzzjnvgosumXbZFVfN
mDXnmutuuOmW2+6Yt+Cue+574KFHFj32xFNLlq1Y9cxzL7z0ymtr3li34a13
3vvgo08+++KrTd98t+WHn3757Y9t/wFvSBMf
      "]], LineBox[CompressedData["
1:eJwNxdc6ggEAANCfN+mVukZkr5akYcsM2SNkF6HMeDzn4nwnFI2HYx1BEHTT
1Wl6iNBLH1H6GWCQIYYZYZQxxplgkhhxEiRJMUWaaTLMkCVHngKzzDHPAoss
scwKRVZZY50NNtmixDY77FJmj30OOOSIY0445YxzKlxwyRVVrrnhljvueeCR
GnWeeKbBC6+80aTFOx988sU3P7T55Y9/WBM07Q==
      "]], 
     LineBox[{697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709,
       710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 
      724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 
      738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749}]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->NCache[{{
      Rational[3, 100], 
      Rational[3, 25]}, {
      Rational[1, 36], 
      Rational[1, 3]}}, {{0.03, 0.12}, {0.027777777777777776`, 
    0.3333333333333333}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.545826385931525*^9, 3.545826401617127*^9}, 
   3.5458266724724417`*^9, 3.545826758221026*^9, 3.545826832561481*^9, 
   3.545826937529606*^9, 3.545826987607376*^9, 3.5458272951933327`*^9, 
   3.545827741138423*^9, 3.545828735338675*^9, 3.545832950802664*^9, 
   3.545846528386458*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SubscriptBox["f", "27"], TraditionalForm]], "None",
 FormatType->"TraditionalForm"]], "Subsubtitle",
 CellChangeTimes->{{3.540387068761395*^9, 3.5403870842931757`*^9}, {
  3.5403909170090647`*^9, 3.54039091781078*^9}}],

Cell[CellGroupData[{

Cell["I1", "Subsection",
 CellChangeTimes->{{3.540389867354951*^9, 3.5403898725443974`*^9}, {
  3.5403899869452133`*^9, 3.540389988229648*^9}, {3.540390067384313*^9, 
  3.540390071482112*^9}, {3.5403902258254843`*^9, 3.5403902360516253`*^9}, {
  3.540390925198291*^9, 3.54039095155634*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f27I1Function", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      RowBox[{"G", "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"t", "/", "2"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", " ", "-", " ", "delta"}], ")"}], "/", "z"}]}], "}"}]}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f27I1Data", " ", "=", 
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", " ", 
         RowBox[{"Apply", "[", 
          RowBox[{"f27I1Function", ",", " ", "#"}], "]"}]}], "}"}], "]"}], 
      " ", "&"}], "/@", " ", "evaluationPoints"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.540390953593841*^9, 3.540390992204667*^9}, {
   3.545825504735344*^9, 3.545825504864458*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f27I1Model", " ", "=", " ", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{
    "f27I1Data", ",", " ", "polynomial", ",", "coefficients", ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", " ", "delta"}], "}"}]}], "]"}]}], " ", ";"}], "\n", 
 RowBox[{"f27I1Model", "[", "\"\<BestFitParameters\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f27I1", " ", "=", " ", 
   RowBox[{"f27I1Model", "[", "\"\<Function\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f27I1Model", "[", "\"\<FitResiduals\>\"", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f27I1Model", "[", "\"\<StandardizedResiduals\>\"", "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.540390996538213*^9, 3.540391008600401*^9}, {
   3.540391330958645*^9, 3.540391348263796*^9}, {3.54039671445595*^9, 
   3.5403967237035*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"cc0000", "\[Rule]", "57642.41181913365`"}], ",", 
   RowBox[{"cc0010", "\[Rule]", "76628.00435464433`"}], ",", 
   RowBox[{"cc0011", "\[Rule]", 
    RowBox[{"-", "81792.42262667979`"}]}], ",", 
   RowBox[{"cc0020", "\[Rule]", "102651.62645467483`"}], ",", 
   RowBox[{"cc0021", "\[Rule]", 
    RowBox[{"-", "222628.6027026766`"}]}], ",", 
   RowBox[{"cc0022", "\[Rule]", 
    RowBox[{"-", "199816.19579649795`"}]}], ",", 
   RowBox[{"cc0030", "\[Rule]", "127143.46724136967`"}], ",", 
   RowBox[{"cc0031", "\[Rule]", 
    RowBox[{"-", "380272.9192408513`"}]}], ",", 
   RowBox[{"cc0032", "\[Rule]", "128877.92720967138`"}], ",", 
   RowBox[{"cc0033", "\[Rule]", "2.556149662537058`*^6"}], ",", 
   RowBox[{"cc0040", "\[Rule]", "148737.6101720353`"}], ",", 
   RowBox[{"cc0041", "\[Rule]", 
    RowBox[{"-", "617859.7018000662`"}]}], ",", 
   RowBox[{"cc0042", "\[Rule]", "130548.64745369986`"}], ",", 
   RowBox[{"cc0043", "\[Rule]", "2.796107647242838`*^6"}], ",", 
   RowBox[{"cc0044", "\[Rule]", 
    RowBox[{"-", "1.294524635714758`*^7"}]}], ",", 
   RowBox[{"cc1000", "\[Rule]", 
    RowBox[{"-", "324329.6245568517`"}]}], ",", 
   RowBox[{"cc1010", "\[Rule]", 
    RowBox[{"-", "459650.5033131449`"}]}], ",", 
   RowBox[{"cc1011", "\[Rule]", "563662.650816039`"}], ",", 
   RowBox[{"cc1020", "\[Rule]", 
    RowBox[{"-", "602852.6652825683`"}]}], ",", 
   RowBox[{"cc1021", "\[Rule]", "1.1715685566801983`*^6"}], ",", 
   RowBox[{"cc1022", "\[Rule]", "1.2771141767706592`*^6"}], ",", 
   RowBox[{"cc1030", "\[Rule]", 
    RowBox[{"-", "745486.2239826688`"}]}], ",", 
   RowBox[{"cc1031", "\[Rule]", "2.1086241975698415`*^6"}], ",", 
   RowBox[{"cc1032", "\[Rule]", "359437.35296994785`"}], ",", 
   RowBox[{"cc1033", "\[Rule]", 
    RowBox[{"-", "1.342566653931726`*^7"}]}], ",", 
   RowBox[{"cc1040", "\[Rule]", 
    RowBox[{"-", "882130.4269188569`"}]}], ",", 
   RowBox[{"cc1041", "\[Rule]", "3.435786768339397`*^6"}], ",", 
   RowBox[{"cc1042", "\[Rule]", 
    RowBox[{"-", "1.7672083257341268`*^6"}]}], ",", 
   RowBox[{"cc1043", "\[Rule]", 
    RowBox[{"-", "1.4911366723390423`*^7"}]}], ",", 
   RowBox[{"cc1044", "\[Rule]", "7.161085193603878`*^7"}], ",", 
   RowBox[{"cc1100", "\[Rule]", "265632.6975851112`"}], ",", 
   RowBox[{"cc1110", "\[Rule]", "375689.45940174034`"}], ",", 
   RowBox[{"cc1111", "\[Rule]", 
    RowBox[{"-", "353984.9600108969`"}]}], ",", 
   RowBox[{"cc1120", "\[Rule]", "499903.91507128434`"}], ",", 
   RowBox[{"cc1121", "\[Rule]", 
    RowBox[{"-", "726808.03233889`"}]}], ",", 
   RowBox[{"cc1122", "\[Rule]", 
    RowBox[{"-", "688270.9056099897`"}]}], ",", 
   RowBox[{"cc1130", "\[Rule]", "630578.4070262264`"}], ",", 
   RowBox[{"cc1131", "\[Rule]", 
    RowBox[{"-", "1.306757702653988`*^6"}]}], ",", 
   RowBox[{"cc1132", "\[Rule]", 
    RowBox[{"-", "244248.15904847562`"}]}], ",", 
   RowBox[{"cc1133", "\[Rule]", "7.602865385683121`*^6"}], ",", 
   RowBox[{"cc1140", "\[Rule]", "761877.1779264117`"}], ",", 
   RowBox[{"cc1141", "\[Rule]", 
    RowBox[{"-", "2.1469523176939012`*^6"}]}], ",", 
   RowBox[{"cc1142", "\[Rule]", "707711.9759305483`"}], ",", 
   RowBox[{"cc1143", "\[Rule]", "8.820868562640531`*^6"}], ",", 
   RowBox[{"cc1144", "\[Rule]", 
    RowBox[{"-", "4.1431847473739155`*^7"}]}], ",", 
   RowBox[{"cc2000", "\[Rule]", "1.0197496244979253`*^6"}], ",", 
   RowBox[{"cc2010", "\[Rule]", "1.4366679541438066`*^6"}], ",", 
   RowBox[{"cc2011", "\[Rule]", 
    RowBox[{"-", "1.5718148792396497`*^6"}]}], ",", 
   RowBox[{"cc2020", "\[Rule]", "1.8948991016486802`*^6"}], ",", 
   RowBox[{"cc2021", "\[Rule]", 
    RowBox[{"-", "3.276147330559534`*^6"}]}], ",", 
   RowBox[{"cc2022", "\[Rule]", 
    RowBox[{"-", "3.177411156988841`*^6"}]}], ",", 
   RowBox[{"cc2030", "\[Rule]", "2.365113043431839`*^6"}], ",", 
   RowBox[{"cc2031", "\[Rule]", 
    RowBox[{"-", "5.88493692096229`*^6"}]}], ",", 
   RowBox[{"cc2032", "\[Rule]", 
    RowBox[{"-", "882988.7535317859`"}]}], ",", 
   RowBox[{"cc2033", "\[Rule]", "3.637277971336388`*^7"}], ",", 
   RowBox[{"cc2040", "\[Rule]", "2.823606146034706`*^6"}], ",", 
   RowBox[{"cc2041", "\[Rule]", 
    RowBox[{"-", "9.633217821353272`*^6"}]}], ",", 
   RowBox[{"cc2042", "\[Rule]", "3.908236189023737`*^6"}], ",", 
   RowBox[{"cc2043", "\[Rule]", "4.142592616457078`*^7"}], ",", 
   RowBox[{"cc2044", "\[Rule]", 
    RowBox[{"-", "1.959043568848486`*^8"}]}], ",", 
   RowBox[{"cc2100", "\[Rule]", "235723.02512043648`"}], ",", 
   RowBox[{"cc2110", "\[Rule]", "333218.46009977994`"}], ",", 
   RowBox[{"cc2111", "\[Rule]", 
    RowBox[{"-", "319770.69057073264`"}]}], ",", 
   RowBox[{"cc2120", "\[Rule]", "442571.9871928868`"}], ",", 
   RowBox[{"cc2121", "\[Rule]", 
    RowBox[{"-", "669307.4682469493`"}]}], ",", 
   RowBox[{"cc2122", "\[Rule]", 
    RowBox[{"-", "650071.8229185456`"}]}], ",", 
   RowBox[{"cc2130", "\[Rule]", "556918.1182613997`"}], ",", 
   RowBox[{"cc2131", "\[Rule]", 
    RowBox[{"-", "1.2019020013500217`*^6"}]}], ",", 
   RowBox[{"cc2132", "\[Rule]", 
    RowBox[{"-", "187740.3070032586`"}]}], ",", 
   RowBox[{"cc2133", "\[Rule]", "7.203206712541087`*^6"}], ",", 
   RowBox[{"cc2140", "\[Rule]", "671450.4496192596`"}], ",", 
   RowBox[{"cc2141", "\[Rule]", 
    RowBox[{"-", "1.9732679992881871`*^6"}]}], ",", 
   RowBox[{"cc2142", "\[Rule]", "683322.454553729`"}], ",", 
   RowBox[{"cc2143", "\[Rule]", "8.047707583083854`*^6"}], ",", 
   RowBox[{"cc2144", "\[Rule]", 
    RowBox[{"-", "3.8269505472640365`*^7"}]}], ",", 
   RowBox[{"cc2200", "\[Rule]", 
    RowBox[{"-", "10255.862506851305`"}]}], ",", 
   RowBox[{"cc2210", "\[Rule]", 
    RowBox[{"-", "13176.767553794254`"}]}], ",", 
   RowBox[{"cc2211", "\[Rule]", "29330.751472619886`"}], ",", 
   RowBox[{"cc2220", "\[Rule]", 
    RowBox[{"-", "16488.439536519392`"}]}], ",", 
   RowBox[{"cc2221", "\[Rule]", "53171.13982279409`"}], ",", 
   RowBox[{"cc2222", "\[Rule]", "18950.94320250689`"}], ",", 
   RowBox[{"cc2230", "\[Rule]", 
    RowBox[{"-", "19482.807144153285`"}]}], ",", 
   RowBox[{"cc2231", "\[Rule]", "93899.97107213335`"}], ",", 
   RowBox[{"cc2232", "\[Rule]", "15890.82711336008`"}], ",", 
   RowBox[{"cc2233", "\[Rule]", 
    RowBox[{"-", "528062.1518457636`"}]}], ",", 
   RowBox[{"cc2240", "\[Rule]", 
    RowBox[{"-", "21595.223785314083`"}]}], ",", 
   RowBox[{"cc2241", "\[Rule]", "154477.54978727506`"}], ",", 
   RowBox[{"cc2242", "\[Rule]", 
    RowBox[{"-", "50984.991481751495`"}]}], ",", 
   RowBox[{"cc2243", "\[Rule]", 
    RowBox[{"-", "969788.3455250548`"}]}], ",", 
   RowBox[{"cc2244", "\[Rule]", "3.993041574801145`*^6"}], ",", 
   RowBox[{"cc3000", "\[Rule]", 
    RowBox[{"-", "476548.55078880873`"}]}], ",", 
   RowBox[{"cc3010", "\[Rule]", 
    RowBox[{"-", "668979.1620365995`"}]}], ",", 
   RowBox[{"cc3011", "\[Rule]", "789678.8905704037`"}], ",", 
   RowBox[{"cc3020", "\[Rule]", 
    RowBox[{"-", "879719.4177751531`"}]}], ",", 
   RowBox[{"cc3021", "\[Rule]", "1.596140492179965`*^6"}], ",", 
   RowBox[{"cc3022", "\[Rule]", "1.4703603083470913`*^6"}], ",", 
   RowBox[{"cc3030", "\[Rule]", 
    RowBox[{"-", "1.0940884909226552`*^6"}]}], ",", 
   RowBox[{"cc3031", "\[Rule]", "2.867909812494095`*^6"}], ",", 
   RowBox[{"cc3032", "\[Rule]", "487525.09935012076`"}], ",", 
   RowBox[{"cc3033", "\[Rule]", 
    RowBox[{"-", "1.749334097035659`*^7"}]}], ",", 
   RowBox[{"cc3040", "\[Rule]", 
    RowBox[{"-", "1.3016288454885248`*^6"}]}], ",", 
   RowBox[{"cc3041", "\[Rule]", "4.6971297696282575`*^6"}], ",", 
   RowBox[{"cc3042", "\[Rule]", 
    RowBox[{"-", "1.92964044394718`*^6"}]}], ",", 
   RowBox[{"cc3043", "\[Rule]", 
    RowBox[{"-", "2.1158785457405444`*^7"}]}], ",", 
   RowBox[{"cc3044", "\[Rule]", "9.828634821075007`*^7"}], ",", 
   RowBox[{"cc3100", "\[Rule]", "15875.441203635984`"}], ",", 
   RowBox[{"cc3110", "\[Rule]", "22913.95115980388`"}], ",", 
   RowBox[{"cc3111", "\[Rule]", "3789.917936622463`"}], ",", 
   RowBox[{"cc3120", "\[Rule]", "31560.398309440323`"}], ",", 
   RowBox[{"cc3121", "\[Rule]", 
    RowBox[{"-", "18237.47180185487`"}]}], ",", 
   RowBox[{"cc3122", "\[Rule]", 
    RowBox[{"-", "41963.233101749174`"}]}], ",", 
   RowBox[{"cc3130", "\[Rule]", "41258.58471770888`"}], ",", 
   RowBox[{"cc3131", "\[Rule]", 
    RowBox[{"-", "32077.780580381874`"}]}], ",", 
   RowBox[{"cc3132", "\[Rule]", "50831.51060517313`"}], ",", 
   RowBox[{"cc3133", "\[Rule]", "288865.1714647651`"}], ",", 
   RowBox[{"cc3140", "\[Rule]", "51403.806692671285`"}], ",", 
   RowBox[{"cc3141", "\[Rule]", 
    RowBox[{"-", "49865.917557558205`"}]}], ",", 
   RowBox[{"cc3142", "\[Rule]", 
    RowBox[{"-", "33957.25531334513`"}]}], ",", 
   RowBox[{"cc3143", "\[Rule]", 
    RowBox[{"-", "190545.46424974702`"}]}], ",", 
   RowBox[{"cc3144", "\[Rule]", "246211.66741371364`"}], ",", 
   RowBox[{"cc3200", "\[Rule]", "61603.531572561806`"}], ",", 
   RowBox[{"cc3210", "\[Rule]", "87768.80014510668`"}], ",", 
   RowBox[{"cc3211", "\[Rule]", 
    RowBox[{"-", "88575.38400828776`"}]}], ",", 
   RowBox[{"cc3220", "\[Rule]", "116305.5072811455`"}], ",", 
   RowBox[{"cc3221", "\[Rule]", 
    RowBox[{"-", "183769.5498843731`"}]}], ",", 
   RowBox[{"cc3222", "\[Rule]", 
    RowBox[{"-", "193924.36643210865`"}]}], ",", 
   RowBox[{"cc3230", "\[Rule]", "146024.80560931322`"}], ",", 
   RowBox[{"cc3231", "\[Rule]", 
    RowBox[{"-", "331357.4367283314`"}]}], ",", 
   RowBox[{"cc3232", "\[Rule]", 
    RowBox[{"-", "62736.54507535774`"}]}], ",", 
   RowBox[{"cc3233", "\[Rule]", "2.0102949972502617`*^6"}], ",", 
   RowBox[{"cc3240", "\[Rule]", "175469.0759607871`"}], ",", 
   RowBox[{"cc3241", "\[Rule]", 
    RowBox[{"-", "542891.2380618266`"}]}], ",", 
   RowBox[{"cc3242", "\[Rule]", "228862.41935848191`"}], ",", 
   RowBox[{"cc3243", "\[Rule]", "2.2070839898115518`*^6"}], ",", 
   RowBox[{"cc3244", "\[Rule]", 
    RowBox[{"-", "1.0638163265060127`*^7"}]}], ",", 
   RowBox[{"cc3300", "\[Rule]", "13227.624237372518`"}], ",", 
   RowBox[{"cc3310", "\[Rule]", "18576.961360159727`"}], ",", 
   RowBox[{"cc3311", "\[Rule]", 
    RowBox[{"-", "24725.951963103664`"}]}], ",", 
   RowBox[{"cc3320", "\[Rule]", "24203.571247511816`"}], ",", 
   RowBox[{"cc3321", "\[Rule]", 
    RowBox[{"-", "50933.5879830966`"}]}], ",", 
   RowBox[{"cc3322", "\[Rule]", 
    RowBox[{"-", "47877.70292079197`"}]}], ",", 
   RowBox[{"cc3330", "\[Rule]", "29786.278045535542`"}], ",", 
   RowBox[{"cc3331", "\[Rule]", 
    RowBox[{"-", "91348.2713423854`"}]}], ",", 
   RowBox[{"cc3332", "\[Rule]", 
    RowBox[{"-", "14878.459953201027`"}]}], ",", 
   RowBox[{"cc3333", "\[Rule]", "561817.1756197046`"}], ",", 
   RowBox[{"cc3340", "\[Rule]", "34940.07858340801`"}], ",", 
   RowBox[{"cc3341", "\[Rule]", 
    RowBox[{"-", "149220.10059743005`"}]}], ",", 
   RowBox[{"cc3342", "\[Rule]", "71601.70744134851`"}], ",", 
   RowBox[{"cc3343", "\[Rule]", "705469.620089068`"}], ",", 
   RowBox[{"cc3344", "\[Rule]", 
    RowBox[{"-", "3.248683843422632`*^6"}]}], ",", 
   RowBox[{"cc4000", "\[Rule]", "667693.6168046737`"}], ",", 
   RowBox[{"cc4010", "\[Rule]", "945688.3608130084`"}], ",", 
   RowBox[{"cc4011", "\[Rule]", 
    RowBox[{"-", "903389.1109947661`"}]}], ",", 
   RowBox[{"cc4020", "\[Rule]", "1.257290297386828`*^6"}], ",", 
   RowBox[{"cc4021", "\[Rule]", 
    RowBox[{"-", "1.8267931436567719`*^6"}]}], ",", 
   RowBox[{"cc4022", "\[Rule]", 
    RowBox[{"-", "1.7436171222953137`*^6"}]}], ",", 
   RowBox[{"cc4030", "\[Rule]", "1.5865130101680546`*^6"}], ",", 
   RowBox[{"cc4031", "\[Rule]", 
    RowBox[{"-", "3.289830689196776`*^6"}]}], ",", 
   RowBox[{"cc4032", "\[Rule]", 
    RowBox[{"-", "725639.9355736221`"}]}], ",", 
   RowBox[{"cc4033", "\[Rule]", "1.868720291913677`*^7"}], ",", 
   RowBox[{"cc4040", "\[Rule]", "1.9166557422309162`*^6"}], ",", 
   RowBox[{"cc4041", "\[Rule]", 
    RowBox[{"-", "5.410239826865902`*^6"}]}], ",", 
   RowBox[{"cc4042", "\[Rule]", "1.88586159568655`*^6"}], ",", 
   RowBox[{"cc4043", "\[Rule]", "2.2548439772150803`*^7"}], ",", 
   RowBox[{"cc4044", "\[Rule]", 
    RowBox[{"-", "1.0511303872384854`*^8"}]}], ",", 
   RowBox[{"cc4100", "\[Rule]", 
    RowBox[{"-", "39622.67002608743`"}]}], ",", 
   RowBox[{"cc4110", "\[Rule]", 
    RowBox[{"-", "55034.56372357698`"}]}], ",", 
   RowBox[{"cc4111", "\[Rule]", "101924.74553791025`"}], ",", 
   RowBox[{"cc4120", "\[Rule]", 
    RowBox[{"-", "70481.43848474625`"}]}], ",", 
   RowBox[{"cc4121", "\[Rule]", "183472.37943327543`"}], ",", 
   RowBox[{"cc4122", "\[Rule]", "186482.36283553907`"}], ",", 
   RowBox[{"cc4130", "\[Rule]", 
    RowBox[{"-", "84835.635377464`"}]}], ",", 
   RowBox[{"cc4131", "\[Rule]", "332398.4013324676`"}], ",", 
   RowBox[{"cc4132", "\[Rule]", "104024.31065618283`"}], ",", 
   RowBox[{"cc4133", "\[Rule]", 
    RowBox[{"-", "2.286946203190607`*^6"}]}], ",", 
   RowBox[{"cc4140", "\[Rule]", 
    RowBox[{"-", "97089.22785752807`"}]}], ",", 
   RowBox[{"cc4141", "\[Rule]", "543428.0576654547`"}], ",", 
   RowBox[{"cc4142", "\[Rule]", 
    RowBox[{"-", "344756.9107302729`"}]}], ",", 
   RowBox[{"cc4143", "\[Rule]", 
    RowBox[{"-", "2.562493925201869`*^6"}]}], ",", 
   RowBox[{"cc4144", "\[Rule]", "1.2318383107644472`*^7"}], ",", 
   RowBox[{"cc4200", "\[Rule]", "46771.90850405295`"}], ",", 
   RowBox[{"cc4210", "\[Rule]", "66959.36324380744`"}], ",", 
   RowBox[{"cc4211", "\[Rule]", 
    RowBox[{"-", "56902.66181795025`"}]}], ",", 
   RowBox[{"cc4220", "\[Rule]", "89671.41175766461`"}], ",", 
   RowBox[{"cc4221", "\[Rule]", 
    RowBox[{"-", "109937.62580748512`"}]}], ",", 
   RowBox[{"cc4222", "\[Rule]", 
    RowBox[{"-", "95345.8109292393`"}]}], ",", 
   RowBox[{"cc4230", "\[Rule]", "114129.40524289757`"}], ",", 
   RowBox[{"cc4231", "\[Rule]", 
    RowBox[{"-", "197315.16853039816`"}]}], ",", 
   RowBox[{"cc4232", "\[Rule]", 
    RowBox[{"-", "66100.8357840722`"}]}], ",", 
   RowBox[{"cc4233", "\[Rule]", "982759.1595210414`"}], ",", 
   RowBox[{"cc4240", "\[Rule]", "139178.29160671643`"}], ",", 
   RowBox[{"cc4241", "\[Rule]", 
    RowBox[{"-", "327565.0189312451`"}]}], ",", 
   RowBox[{"cc4242", "\[Rule]", "90358.45207831937`"}], ",", 
   RowBox[{"cc4243", "\[Rule]", "1.349571973976628`*^6"}], ",", 
   RowBox[{"cc4244", "\[Rule]", 
    RowBox[{"-", "6.074019449629868`*^6"}]}], ",", 
   RowBox[{"cc4300", "\[Rule]", 
    RowBox[{"-", "3318.0564052224436`"}]}], ",", 
   RowBox[{"cc4310", "\[Rule]", 
    RowBox[{"-", "4177.936276306888`"}]}], ",", 
   RowBox[{"cc4311", "\[Rule]", "14292.695085637859`"}], ",", 
   RowBox[{"cc4320", "\[Rule]", 
    RowBox[{"-", "4857.127424635734`"}]}], ",", 
   RowBox[{"cc4321", "\[Rule]", "27805.380489850802`"}], ",", 
   RowBox[{"cc4322", "\[Rule]", "20643.275285241245`"}], ",", 
   RowBox[{"cc4330", "\[Rule]", 
    RowBox[{"-", "5166.21589109008`"}]}], ",", 
   RowBox[{"cc4331", "\[Rule]", "49542.73226509348`"}], ",", 
   RowBox[{"cc4332", "\[Rule]", "3337.610976758721`"}], ",", 
   RowBox[{"cc4333", "\[Rule]", 
    RowBox[{"-", "328613.1437350596`"}]}], ",", 
   RowBox[{"cc4340", "\[Rule]", 
    RowBox[{"-", "4879.441070822196`"}]}], ",", 
   RowBox[{"cc4341", "\[Rule]", "80607.18688914926`"}], ",", 
   RowBox[{"cc4342", "\[Rule]", 
    RowBox[{"-", "44933.71550003207`"}]}], ",", 
   RowBox[{"cc4343", "\[Rule]", 
    RowBox[{"-", "476416.0905398687`"}]}], ",", 
   RowBox[{"cc4344", "\[Rule]", "2.0901459190054915`*^6"}], ",", 
   RowBox[{"cc4400", "\[Rule]", "478.2973397645338`"}], ",", 
   RowBox[{"cc4410", "\[Rule]", "591.2662059290421`"}], ",", 
   RowBox[{"cc4411", "\[Rule]", "156.9422533643689`"}], ",", 
   RowBox[{"cc4420", "\[Rule]", "794.6172327178516`"}], ",", 
   RowBox[{"cc4421", "\[Rule]", 
    RowBox[{"-", "1100.1603290805556`"}]}], ",", 
   RowBox[{"cc4422", "\[Rule]", "330.0896807640545`"}], ",", 
   RowBox[{"cc4430", "\[Rule]", "1015.536927119728`"}], ",", 
   RowBox[{"cc4431", "\[Rule]", 
    RowBox[{"-", "1724.8496102504143`"}]}], ",", 
   RowBox[{"cc4432", "\[Rule]", "3531.722934186084`"}], ",", 
   RowBox[{"cc4433", "\[Rule]", "12028.754577753532`"}], ",", 
   RowBox[{"cc4440", "\[Rule]", "1244.7876326002026`"}], ",", 
   RowBox[{"cc4441", "\[Rule]", 
    RowBox[{"-", "2762.154539377646`"}]}], ",", 
   RowBox[{"cc4442", "\[Rule]", 
    RowBox[{"-", "3696.0560176274657`"}]}], ",", 
   RowBox[{"cc4443", "\[Rule]", "10685.017693291784`"}], ",", 
   RowBox[{"cc4444", "\[Rule]", 
    RowBox[{"-", "43041.23976178243`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391010899745*^9, {3.54039133590849*^9, 3.540391349037044*^9}, 
   3.540391792254197*^9, 3.540391919363516*^9, 3.540392079128565*^9, 
   3.540396727258849*^9, 3.5403968214423723`*^9, 3.540500011348571*^9, 
   3.545825583380649*^9, 3.5458260499083977`*^9, 3.545826167429737*^9, 
   3.5458287400623693`*^9, 3.5458329784117393`*^9, 3.545844008916563*^9, 
   3.545846533069385*^9}],

Cell[BoxData["2.4898889350311038`*^-6"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391010899745*^9, {3.54039133590849*^9, 3.540391349037044*^9}, 
   3.540391792254197*^9, 3.540391919363516*^9, 3.540392079128565*^9, 
   3.540396727258849*^9, 3.5403968214423723`*^9, 3.540500011348571*^9, 
   3.545825583380649*^9, 3.5458260499083977`*^9, 3.545826167429737*^9, 
   3.5458287400623693`*^9, 3.5458329784117393`*^9, 3.545844008916563*^9, 
   3.545846533459811*^9}],

Cell[BoxData["0.46167070971884433`"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.540391010899745*^9, {3.54039133590849*^9, 3.540391349037044*^9}, 
   3.540391792254197*^9, 3.540391919363516*^9, 3.540392079128565*^9, 
   3.540396727258849*^9, 3.5403968214423723`*^9, 3.540500011348571*^9, 
   3.545825583380649*^9, 3.5458260499083977`*^9, 3.545826167429737*^9, 
   3.5458287400623693`*^9, 3.5458329784117393`*^9, 3.545844008916563*^9, 
   3.545846535223822*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["I2", "Subsection",
 CellChangeTimes->{{3.5403903458397007`*^9, 3.540390345908845*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f27I2Function", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       RowBox[{"z", " ", "*", " ", "t"}]}], ")"}], " ", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"G", "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"t", "/", "2"}]}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", " ", "-", " ", "delta"}], ")"}], "/", "z"}], ",", " ", 
      RowBox[{"1", "/", "z"}]}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"f27I2Data", " ", "=", 
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", " ", 
         RowBox[{"Apply", "[", 
          RowBox[{"f27I2Function", ",", " ", "#"}], "]"}]}], "}"}], "]"}], 
      " ", "&"}], "/@", " ", "evaluationPoints"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.540390367744677*^9, 3.540390391896315*^9}, {
   3.540390424798936*^9, 3.5403904251308727`*^9}, {3.540390458667108*^9, 
   3.540390492743198*^9}, {3.540391097709412*^9, 3.540391113004285*^9}, {
   3.5458255086692133`*^9, 3.5458255089314528`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f27I2Model", " ", "=", " ", 
   RowBox[{"NonlinearModelFit", "[", 
    RowBox[{
    "f27I2Data", ",", " ", "polynomial", ",", "coefficients", ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", " ", "delta"}], "}"}]}], "]"}]}], " ", ";"}], "\n", 
 RowBox[{
  RowBox[{"f27I2", " ", "=", " ", 
   RowBox[{"f27I2Model", "[", "\"\<Function\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"f27I2Model", "[", "\"\<BestFitParameters\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f27I2Model", "[", "\"\<FitResiduals\>\"", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"f27I2Model", "[", "\"\<StandardizedResiduals\>\"", "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.540387090167899*^9, 3.540387107160968*^9}, {
   3.540387411656415*^9, 3.540387463034504*^9}, {3.5403875291694403`*^9, 
   3.540387547676916*^9}, {3.540387594510454*^9, 3.54038759765026*^9}, {
   3.540389990714278*^9, 3.540389991382669*^9}, {3.5403900273926897`*^9, 
   3.540390035873948*^9}, {3.5403902202453403`*^9, 3.5403902634335318`*^9}, 
   3.5403902980466747`*^9, {3.5403904030912943`*^9, 3.540390411938726*^9}, {
   3.540390558606029*^9, 3.540390574639647*^9}, {3.540390692118628*^9, 
   3.5403906924464283`*^9}, {3.5403907432028217`*^9, 
   3.5403907454381237`*^9}, {3.540390818086678*^9, 3.5403908390898933`*^9}, {
   3.5403911163426857`*^9, 3.5403911238739862`*^9}, {3.540391283577487*^9, 
   3.540391294625408*^9}, {3.5403913539060917`*^9, 3.540391354883436*^9}, {
   3.540396734955896*^9, 3.540396740024716*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"cc0000", "\[Rule]", "1084.028304456328`"}], ",", 
   RowBox[{"cc0010", "\[Rule]", 
    RowBox[{"-", "3.0940204457988405`"}]}], ",", 
   RowBox[{"cc0011", "\[Rule]", 
    RowBox[{"-", "29662.313607707205`"}]}], ",", 
   RowBox[{"cc0020", "\[Rule]", 
    RowBox[{"-", "1384.011430913439`"}]}], ",", 
   RowBox[{"cc0021", "\[Rule]", 
    RowBox[{"-", "14585.201853021887`"}]}], ",", 
   RowBox[{"cc0022", "\[Rule]", "177178.99654672478`"}], ",", 
   RowBox[{"cc0030", "\[Rule]", 
    RowBox[{"-", "2230.700431628284`"}]}], ",", 
   RowBox[{"cc0031", "\[Rule]", 
    RowBox[{"-", "14066.917813220776`"}]}], ",", 
   RowBox[{"cc0032", "\[Rule]", "45962.34214078094`"}], ",", 
   RowBox[{"cc0033", "\[Rule]", 
    RowBox[{"-", "526830.4893072806`"}]}], ",", 
   RowBox[{"cc0040", "\[Rule]", 
    RowBox[{"-", "3269.834947130008`"}]}], ",", 
   RowBox[{"cc0041", "\[Rule]", 
    RowBox[{"-", "17595.735521196475`"}]}], ",", 
   RowBox[{"cc0042", "\[Rule]", "78188.09556619241`"}], ",", 
   RowBox[{"cc0043", "\[Rule]", 
    RowBox[{"-", "174619.0627933893`"}]}], ",", 
   RowBox[{"cc0044", "\[Rule]", "1.0917685828866092`*^6"}], ",", 
   RowBox[{"cc1000", "\[Rule]", 
    RowBox[{"-", "6191.403965802526`"}]}], ",", 
   RowBox[{"cc1010", "\[Rule]", "989.8476633016699`"}], ",", 
   RowBox[{"cc1011", "\[Rule]", "127244.80173457263`"}], ",", 
   RowBox[{"cc1020", "\[Rule]", "6684.982077032143`"}], ",", 
   RowBox[{"cc1021", "\[Rule]", "93400.09792272831`"}], ",", 
   RowBox[{"cc1022", "\[Rule]", 
    RowBox[{"-", "751669.4354607249`"}]}], ",", 
   RowBox[{"cc1030", "\[Rule]", "12188.209517887768`"}], ",", 
   RowBox[{"cc1031", "\[Rule]", "95706.18407227806`"}], ",", 
   RowBox[{"cc1032", "\[Rule]", 
    RowBox[{"-", "490148.64032974525`"}]}], ",", 
   RowBox[{"cc1033", "\[Rule]", "2.976377439964362`*^6"}], ",", 
   RowBox[{"cc1040", "\[Rule]", "18402.86854519959`"}], ",", 
   RowBox[{"cc1041", "\[Rule]", "108370.46557048745`"}], ",", 
   RowBox[{"cc1042", "\[Rule]", 
    RowBox[{"-", "608774.2933876859`"}]}], ",", 
   RowBox[{"cc1043", "\[Rule]", "1.7000448906793091`*^6"}], ",", 
   RowBox[{"cc1044", "\[Rule]", 
    RowBox[{"-", "7.566119186613629`*^6"}]}], ",", 
   RowBox[{"cc1100", "\[Rule]", "1903.6244205383919`"}], ",", 
   RowBox[{"cc1110", "\[Rule]", "30.298170454091075`"}], ",", 
   RowBox[{"cc1111", "\[Rule]", 
    RowBox[{"-", "60410.319750102535`"}]}], ",", 
   RowBox[{"cc1120", "\[Rule]", 
    RowBox[{"-", "3113.8069749245333`"}]}], ",", 
   RowBox[{"cc1121", "\[Rule]", 
    RowBox[{"-", "71604.04370682944`"}]}], ",", 
   RowBox[{"cc1122", "\[Rule]", "403578.873847845`"}], ",", 
   RowBox[{"cc1130", "\[Rule]", 
    RowBox[{"-", "6768.811144420808`"}]}], ",", 
   RowBox[{"cc1131", "\[Rule]", 
    RowBox[{"-", "71525.02591891443`"}]}], ",", 
   RowBox[{"cc1132", "\[Rule]", "545821.5668253239`"}], ",", 
   RowBox[{"cc1133", "\[Rule]", 
    RowBox[{"-", "1.930096297034418`*^6"}]}], ",", 
   RowBox[{"cc1140", "\[Rule]", 
    RowBox[{"-", "10515.23157590894`"}]}], ",", 
   RowBox[{"cc1141", "\[Rule]", 
    RowBox[{"-", "60220.98701765404`"}]}], ",", 
   RowBox[{"cc1142", "\[Rule]", "698084.7775063982`"}], ",", 
   RowBox[{"cc1143", "\[Rule]", 
    RowBox[{"-", "2.6751851362326685`*^6"}]}], ",", 
   RowBox[{"cc1144", "\[Rule]", "7.733553879989198`*^6"}], ",", 
   RowBox[{"cc2000", "\[Rule]", "11158.236572065849`"}], ",", 
   RowBox[{"cc2010", "\[Rule]", 
    RowBox[{"-", "1473.2141877269692`"}]}], ",", 
   RowBox[{"cc2011", "\[Rule]", 
    RowBox[{"-", "280872.59126541537`"}]}], ",", 
   RowBox[{"cc2020", "\[Rule]", 
    RowBox[{"-", "15687.940607635108`"}]}], ",", 
   RowBox[{"cc2021", "\[Rule]", 
    RowBox[{"-", "295303.4225550449`"}]}], ",", 
   RowBox[{"cc2022", "\[Rule]", "1.6655015087531488`*^6"}], ",", 
   RowBox[{"cc2030", "\[Rule]", 
    RowBox[{"-", "31885.07596502325`"}]}], ",", 
   RowBox[{"cc2031", "\[Rule]", 
    RowBox[{"-", "312315.66149815405`"}]}], ",", 
   RowBox[{"cc2032", "\[Rule]", "1.9478587879160119`*^6"}], ",", 
   RowBox[{"cc2033", "\[Rule]", 
    RowBox[{"-", "8.051520657850099`*^6"}]}], ",", 
   RowBox[{"cc2040", "\[Rule]", 
    RowBox[{"-", "49503.80778236362`"}]}], ",", 
   RowBox[{"cc2041", "\[Rule]", 
    RowBox[{"-", "311461.64097010414`"}]}], ",", 
   RowBox[{"cc2042", "\[Rule]", "2.4721992732238807`*^6"}], ",", 
   RowBox[{"cc2043", "\[Rule]", 
    RowBox[{"-", "8.50851922954711`*^6"}]}], ",", 
   RowBox[{"cc2044", "\[Rule]", "2.806536507949016`*^7"}], ",", 
   RowBox[{"cc2100", "\[Rule]", "2446.642939392728`"}], ",", 
   RowBox[{"cc2110", "\[Rule]", 
    RowBox[{"-", "105.13499397856157`"}]}], ",", 
   RowBox[{"cc2111", "\[Rule]", 
    RowBox[{"-", "63119.38100451848`"}]}], ",", 
   RowBox[{"cc2120", "\[Rule]", 
    RowBox[{"-", "3158.4634557262707`"}]}], ",", 
   RowBox[{"cc2121", "\[Rule]", 
    RowBox[{"-", "62728.521845243966`"}]}], ",", 
   RowBox[{"cc2122", "\[Rule]", "416256.4440500495`"}], ",", 
   RowBox[{"cc2130", "\[Rule]", 
    RowBox[{"-", "6448.211751557912`"}]}], ",", 
   RowBox[{"cc2131", "\[Rule]", 
    RowBox[{"-", "60780.78127942563`"}]}], ",", 
   RowBox[{"cc2132", "\[Rule]", "452766.3943431396`"}], ",", 
   RowBox[{"cc2133", "\[Rule]", 
    RowBox[{"-", "2.0123096078385443`*^6"}]}], ",", 
   RowBox[{"cc2140", "\[Rule]", 
    RowBox[{"-", "9851.246598312782`"}]}], ",", 
   RowBox[{"cc2141", "\[Rule]", 
    RowBox[{"-", "52926.38734481109`"}]}], ",", 
   RowBox[{"cc2142", "\[Rule]", "575727.7081314084`"}], ",", 
   RowBox[{"cc2143", "\[Rule]", 
    RowBox[{"-", "1.9088572818756062`*^6"}]}], ",", 
   RowBox[{"cc2144", "\[Rule]", "6.234233583726331`*^6"}], ",", 
   RowBox[{"cc2200", "\[Rule]", "935.0379760620832`"}], ",", 
   RowBox[{"cc2210", "\[Rule]", 
    RowBox[{"-", "60.15759641232268`"}]}], ",", 
   RowBox[{"cc2211", "\[Rule]", 
    RowBox[{"-", "8633.241889988383`"}]}], ",", 
   RowBox[{"cc2220", "\[Rule]", 
    RowBox[{"-", "106.28558771359792`"}]}], ",", 
   RowBox[{"cc2221", "\[Rule]", "7204.960229553345`"}], ",", 
   RowBox[{"cc2222", "\[Rule]", "68769.20394714615`"}], ",", 
   RowBox[{"cc2230", "\[Rule]", "240.23079255695924`"}], ",", 
   RowBox[{"cc2231", "\[Rule]", "12927.953051300805`"}], ",", 
   RowBox[{"cc2232", "\[Rule]", 
    RowBox[{"-", "54430.056780194995`"}]}], ",", 
   RowBox[{"cc2233", "\[Rule]", 
    RowBox[{"-", "295590.4369666725`"}]}], ",", 
   RowBox[{"cc2240", "\[Rule]", "679.7569421422145`"}], ",", 
   RowBox[{"cc2241", "\[Rule]", "14602.62044125129`"}], ",", 
   RowBox[{"cc2242", "\[Rule]", 
    RowBox[{"-", "75981.02412437422`"}]}], ",", 
   RowBox[{"cc2243", "\[Rule]", "596293.0703338223`"}], ",", 
   RowBox[{"cc2244", "\[Rule]", 
    RowBox[{"-", "1.0724352513887447`*^6"}]}], ",", 
   RowBox[{"cc3000", "\[Rule]", 
    RowBox[{"-", "1266.224509681784`"}]}], ",", 
   RowBox[{"cc3010", "\[Rule]", "358.8865174725379`"}], ",", 
   RowBox[{"cc3011", "\[Rule]", "90692.51924762702`"}], ",", 
   RowBox[{"cc3020", "\[Rule]", "6329.8932558991055`"}], ",", 
   RowBox[{"cc3021", "\[Rule]", "153356.57455994876`"}], ",", 
   RowBox[{"cc3022", "\[Rule]", 
    RowBox[{"-", "496539.88550821686`"}]}], ",", 
   RowBox[{"cc3030", "\[Rule]", "14482.178737359513`"}], ",", 
   RowBox[{"cc3031", "\[Rule]", "179633.18368521414`"}], ",", 
   RowBox[{"cc3032", "\[Rule]", 
    RowBox[{"-", "1.03871805416822`*^6"}]}], ",", 
   RowBox[{"cc3033", "\[Rule]", "2.4803278874695487`*^6"}], ",", 
   RowBox[{"cc3040", "\[Rule]", "23594.303378795354`"}], ",", 
   RowBox[{"cc3041", "\[Rule]", "184219.72825184758`"}], ",", 
   RowBox[{"cc3042", "\[Rule]", 
    RowBox[{"-", "1.3390154994444144`*^6"}]}], ",", 
   RowBox[{"cc3043", "\[Rule]", "5.670382557454622`*^6"}], ",", 
   RowBox[{"cc3044", "\[Rule]", 
    RowBox[{"-", "1.5921860351988332`*^7"}]}], ",", 
   RowBox[{"cc3100", "\[Rule]", "1596.1423308727792`"}], ",", 
   RowBox[{"cc3110", "\[Rule]", 
    RowBox[{"-", "110.6708869785107`"}]}], ",", 
   RowBox[{"cc3111", "\[Rule]", 
    RowBox[{"-", "20086.789244277687`"}]}], ",", 
   RowBox[{"cc3120", "\[Rule]", 
    RowBox[{"-", "571.8665301678469`"}]}], ",", 
   RowBox[{"cc3121", "\[Rule]", "1874.5829066872398`"}], ",", 
   RowBox[{"cc3122", "\[Rule]", "141777.72118148534`"}], ",", 
   RowBox[{"cc3130", "\[Rule]", 
    RowBox[{"-", "534.5699215810567`"}]}], ",", 
   RowBox[{"cc3131", "\[Rule]", "9437.615037931691`"}], ",", 
   RowBox[{"cc3132", "\[Rule]", 
    RowBox[{"-", "20763.062283893927`"}]}], ",", 
   RowBox[{"cc3133", "\[Rule]", 
    RowBox[{"-", "643838.4489538318`"}]}], ",", 
   RowBox[{"cc3140", "\[Rule]", 
    RowBox[{"-", "388.77286742754546`"}]}], ",", 
   RowBox[{"cc3141", "\[Rule]", "12132.540237767587`"}], ",", 
   RowBox[{"cc3142", "\[Rule]", 
    RowBox[{"-", "31667.794603779545`"}]}], ",", 
   RowBox[{"cc3143", "\[Rule]", "570341.5410176088`"}], ",", 
   RowBox[{"cc3144", "\[Rule]", 
    RowBox[{"-", "685959.8699252789`"}]}], ",", 
   RowBox[{"cc3200", "\[Rule]", "1119.9170482967068`"}], ",", 
   RowBox[{"cc3210", "\[Rule]", 
    RowBox[{"-", "114.32903265049053`"}]}], ",", 
   RowBox[{"cc3211", "\[Rule]", 
    RowBox[{"-", "21072.976298529706`"}]}], ",", 
   RowBox[{"cc3220", "\[Rule]", 
    RowBox[{"-", "1021.513729301066`"}]}], ",", 
   RowBox[{"cc3221", "\[Rule]", 
    RowBox[{"-", "15823.770387751676`"}]}], ",", 
   RowBox[{"cc3222", "\[Rule]", "128780.57834002763`"}], ",", 
   RowBox[{"cc3230", "\[Rule]", 
    RowBox[{"-", "1910.9472697570568`"}]}], ",", 
   RowBox[{"cc3231", "\[Rule]", 
    RowBox[{"-", "14630.21149168701`"}]}], ",", 
   RowBox[{"cc3232", "\[Rule]", "108023.06438737671`"}], ",", 
   RowBox[{"cc3233", "\[Rule]", 
    RowBox[{"-", "567750.0911698743`"}]}], ",", 
   RowBox[{"cc3240", "\[Rule]", 
    RowBox[{"-", "2839.272151045579`"}]}], ",", 
   RowBox[{"cc3241", "\[Rule]", 
    RowBox[{"-", "13133.698912290789`"}]}], ",", 
   RowBox[{"cc3242", "\[Rule]", "133734.33114845084`"}], ",", 
   RowBox[{"cc3243", "\[Rule]", 
    RowBox[{"-", "401909.019261111`"}]}], ",", 
   RowBox[{"cc3244", "\[Rule]", "1.5079380021074717`*^6"}], ",", 
   RowBox[{"cc3300", "\[Rule]", "180.67513996474437`"}], ",", 
   RowBox[{"cc3310", "\[Rule]", 
    RowBox[{"-", "50.09018436514679`"}]}], ",", 
   RowBox[{"cc3311", "\[Rule]", 
    RowBox[{"-", "3596.2144757214696`"}]}], ",", 
   RowBox[{"cc3320", "\[Rule]", 
    RowBox[{"-", "249.20813543208376`"}]}], ",", 
   RowBox[{"cc3321", "\[Rule]", 
    RowBox[{"-", "4341.297077694678`"}]}], ",", 
   RowBox[{"cc3322", "\[Rule]", "12847.929469093644`"}], ",", 
   RowBox[{"cc3330", "\[Rule]", 
    RowBox[{"-", "508.52023195128567`"}]}], ",", 
   RowBox[{"cc3331", "\[Rule]", 
    RowBox[{"-", "5395.4702600524615`"}]}], ",", 
   RowBox[{"cc3332", "\[Rule]", "27056.3997030079`"}], ",", 
   RowBox[{"cc3333", "\[Rule]", 
    RowBox[{"-", "34026.17407834179`"}]}], ",", 
   RowBox[{"cc3340", "\[Rule]", 
    RowBox[{"-", "806.4303871125362`"}]}], ",", 
   RowBox[{"cc3341", "\[Rule]", 
    RowBox[{"-", "5940.524833931896`"}]}], ",", 
   RowBox[{"cc3342", "\[Rule]", "34892.37646601749`"}], ",", 
   RowBox[{"cc3343", "\[Rule]", 
    RowBox[{"-", "179930.4506280977`"}]}], ",", 
   RowBox[{"cc3344", "\[Rule]", "484673.2137870467`"}], ",", 
   RowBox[{"cc4000", "\[Rule]", "3508.1702911021025`"}], ",", 
   RowBox[{"cc4010", "\[Rule]", "275.2955105389341`"}], ",", 
   RowBox[{"cc4011", "\[Rule]", 
    RowBox[{"-", "140761.18536778187`"}]}], ",", 
   RowBox[{"cc4020", "\[Rule]", 
    RowBox[{"-", "7425.344904181785`"}]}], ",", 
   RowBox[{"cc4021", "\[Rule]", 
    RowBox[{"-", "182679.05411850996`"}]}], ",", 
   RowBox[{"cc4022", "\[Rule]", "945492.0181797004`"}], ",", 
   RowBox[{"cc4030", "\[Rule]", 
    RowBox[{"-", "16694.321753734195`"}]}], ",", 
   RowBox[{"cc4031", "\[Rule]", 
    RowBox[{"-", "188176.9248011785`"}]}], ",", 
   RowBox[{"cc4032", "\[Rule]", "1.3956405157706866`*^6"}], ",", 
   RowBox[{"cc4033", "\[Rule]", 
    RowBox[{"-", "3.912092644086358`*^6"}]}], ",", 
   RowBox[{"cc4040", "\[Rule]", 
    RowBox[{"-", "26282.0651527656`"}]}], ",", 
   RowBox[{"cc4041", "\[Rule]", 
    RowBox[{"-", "159325.73990167188`"}]}], ",", 
   RowBox[{"cc4042", "\[Rule]", "1.814977288936499`*^6"}], ",", 
   RowBox[{"cc4043", "\[Rule]", 
    RowBox[{"-", "7.789396234155763`*^6"}]}], ",", 
   RowBox[{"cc4044", "\[Rule]", "2.1067397833938498`*^7"}], ",", 
   RowBox[{"cc4100", "\[Rule]", "949.742435458129`"}], ",", 
   RowBox[{"cc4110", "\[Rule]", 
    RowBox[{"-", "22.866479782335144`"}]}], ",", 
   RowBox[{"cc4111", "\[Rule]", "532.7091163324025`"}], ",", 
   RowBox[{"cc4120", "\[Rule]", "491.4789018248069`"}], ",", 
   RowBox[{"cc4121", "\[Rule]", "19037.250426728013`"}], ",", 
   RowBox[{"cc4122", "\[Rule]", 
    RowBox[{"-", "20060.923108689323`"}]}], ",", 
   RowBox[{"cc4130", "\[Rule]", "1445.0006588754698`"}], ",", 
   RowBox[{"cc4131", "\[Rule]", "25171.35580413252`"}], ",", 
   RowBox[{"cc4132", "\[Rule]", 
    RowBox[{"-", "98926.51178234935`"}]}], ",", 
   RowBox[{"cc4133", "\[Rule]", "415466.92518413515`"}], ",", 
   RowBox[{"cc4140", "\[Rule]", "2634.598723369475`"}], ",", 
   RowBox[{"cc4141", "\[Rule]", "31517.238537864505`"}], ",", 
   RowBox[{"cc4142", "\[Rule]", 
    RowBox[{"-", "121565.05162000413`"}]}], ",", 
   RowBox[{"cc4143", "\[Rule]", "250988.38076600543`"}], ",", 
   RowBox[{"cc4144", "\[Rule]", 
    RowBox[{"-", "1.1311465540864475`*^6"}]}], ",", 
   RowBox[{"cc4200", "\[Rule]", "367.6782659966645`"}], ",", 
   RowBox[{"cc4210", "\[Rule]", "22.933406879694928`"}], ",", 
   RowBox[{"cc4211", "\[Rule]", 
    RowBox[{"-", "7552.303737295869`"}]}], ",", 
   RowBox[{"cc4220", "\[Rule]", 
    RowBox[{"-", "424.8776319031234`"}]}], ",", 
   RowBox[{"cc4221", "\[Rule]", 
    RowBox[{"-", "11914.408770875707`"}]}], ",", 
   RowBox[{"cc4222", "\[Rule]", "37083.09769497575`"}], ",", 
   RowBox[{"cc4230", "\[Rule]", 
    RowBox[{"-", "1022.7605899572766`"}]}], ",", 
   RowBox[{"cc4231", "\[Rule]", 
    RowBox[{"-", "12478.182917796026`"}]}], ",", 
   RowBox[{"cc4232", "\[Rule]", "115020.77561023846`"}], ",", 
   RowBox[{"cc4233", "\[Rule]", 
    RowBox[{"-", "130616.93115894547`"}]}], ",", 
   RowBox[{"cc4240", "\[Rule]", 
    RowBox[{"-", "1606.7698298304726`"}]}], ",", 
   RowBox[{"cc4241", "\[Rule]", 
    RowBox[{"-", "8032.18076607573`"}]}], ",", 
   RowBox[{"cc4242", "\[Rule]", "144390.32643815488`"}], ",", 
   RowBox[{"cc4243", "\[Rule]", 
    RowBox[{"-", "779867.8581536793`"}]}], ",", 
   RowBox[{"cc4244", "\[Rule]", "1.7715866738824127`*^6"}], ",", 
   RowBox[{"cc4300", "\[Rule]", "240.7816864033522`"}], ",", 
   RowBox[{"cc4310", "\[Rule]", "10.450175661570169`"}], ",", 
   RowBox[{"cc4311", "\[Rule]", 
    RowBox[{"-", "1392.1288428215437`"}]}], ",", 
   RowBox[{"cc4320", "\[Rule]", "47.163858249068056`"}], ",", 
   RowBox[{"cc4321", "\[Rule]", "2733.0181180254463`"}], ",", 
   RowBox[{"cc4322", "\[Rule]", "14915.770268799017`"}], ",", 
   RowBox[{"cc4330", "\[Rule]", "200.20249360600752`"}], ",", 
   RowBox[{"cc4331", "\[Rule]", "4810.296213882675`"}], ",", 
   RowBox[{"cc4332", "\[Rule]", 
    RowBox[{"-", "12293.007062179215`"}]}], ",", 
   RowBox[{"cc4333", "\[Rule]", 
    RowBox[{"-", "79010.25242979228`"}]}], ",", 
   RowBox[{"cc4340", "\[Rule]", "407.69523995401295`"}], ",", 
   RowBox[{"cc4341", "\[Rule]", "6374.533456396545`"}], ",", 
   RowBox[{"cc4342", "\[Rule]", 
    RowBox[{"-", "17915.673337432643`"}]}], ",", 
   RowBox[{"cc4343", "\[Rule]", "142051.07730574536`"}], ",", 
   RowBox[{"cc4344", "\[Rule]", 
    RowBox[{"-", "296655.7273728161`"}]}], ",", 
   RowBox[{"cc4400", "\[Rule]", "30.241226161735852`"}], ",", 
   RowBox[{"cc4410", "\[Rule]", 
    RowBox[{"-", "3.567435508941057`"}]}], ",", 
   RowBox[{"cc4411", "\[Rule]", 
    RowBox[{"-", "298.66045408113246`"}]}], ",", 
   RowBox[{"cc4420", "\[Rule]", 
    RowBox[{"-", "11.719796683143242`"}]}], ",", 
   RowBox[{"cc4421", "\[Rule]", 
    RowBox[{"-", "31.964516934894608`"}]}], ",", 
   RowBox[{"cc4422", "\[Rule]", "1265.7414714592496`"}], ",", 
   RowBox[{"cc4430", "\[Rule]", 
    RowBox[{"-", "15.78528534213625`"}]}], ",", 
   RowBox[{"cc4431", "\[Rule]", "29.739089482479283`"}], ",", 
   RowBox[{"cc4432", "\[Rule]", "357.3890488441759`"}], ",", 
   RowBox[{"cc4433", "\[Rule]", 
    RowBox[{"-", "5236.333470924621`"}]}], ",", 
   RowBox[{"cc4440", "\[Rule]", 
    RowBox[{"-", "18.753338804236787`"}]}], ",", 
   RowBox[{"cc4441", "\[Rule]", "86.67306033267691`"}], ",", 
   RowBox[{"cc4442", "\[Rule]", "677.893082253208`"}], ",", 
   RowBox[{"cc4443", "\[Rule]", 
    RowBox[{"-", "727.713025986628`"}]}], ",", 
   RowBox[{"cc4444", "\[Rule]", "6253.174712253666`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, {3.540391125601266*^9, 
   3.540391143883629*^9}, 3.5403912955125303`*^9, 3.540391355291871*^9, 
   3.540391798966073*^9, 3.5403919314576883`*^9, 3.540392092415667*^9, 
   3.540396741189118*^9, 3.540396833312455*^9, 3.540500023738361*^9, 
   3.5458255907489843`*^9, 3.5458260589063177`*^9, 3.545826176336238*^9, 
   3.5458287495850487`*^9, 3.545832987656803*^9, 3.545844030310841*^9, 
   3.545846542754037*^9}],

Cell[BoxData["1.9587305377655184`*^-7"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, {3.540391125601266*^9, 
   3.540391143883629*^9}, 3.5403912955125303`*^9, 3.540391355291871*^9, 
   3.540391798966073*^9, 3.5403919314576883`*^9, 3.540392092415667*^9, 
   3.540396741189118*^9, 3.540396833312455*^9, 3.540500023738361*^9, 
   3.5458255907489843`*^9, 3.5458260589063177`*^9, 3.545826176336238*^9, 
   3.5458287495850487`*^9, 3.545832987656803*^9, 3.545844030310841*^9, 
   3.545846543052479*^9}],

Cell[BoxData["0.5568925235809563`"], "Output",
 CellChangeTimes->{
  3.540389281826385*^9, 3.540389454845183*^9, {3.540389492915184*^9, 
   3.54038950307143*^9}, {3.540389544661873*^9, 3.540389573645835*^9}, {
   3.5403896037445*^9, 3.5403896553544197`*^9}, 3.540389752019199*^9, 
   3.540389824882333*^9, {3.540389890498835*^9, 3.5403899346585293`*^9}, 
   3.540390043357491*^9, 3.5403902697913523`*^9, 3.540390300500431*^9, 
   3.5403904135132027`*^9, 3.540390513966201*^9, {3.540390565734784*^9, 
   3.540390575872223*^9}, 3.5403907037255487`*^9, 3.5403907458590317`*^9, {
   3.540390832096691*^9, 3.540390839601657*^9}, {3.540391125601266*^9, 
   3.540391143883629*^9}, 3.5403912955125303`*^9, 3.540391355291871*^9, 
   3.540391798966073*^9, 3.5403919314576883`*^9, 3.540392092415667*^9, 
   3.540396741189118*^9, 3.540396833312455*^9, 3.540500023738361*^9, 
   3.5458255907489843`*^9, 3.5458260589063177`*^9, 3.545826176336238*^9, 
   3.5458287495850487`*^9, 3.545832987656803*^9, 3.545844030310841*^9, 
   3.5458465447700567`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["relative error", "Subsection",
 CellChangeTimes->{{3.540391557706044*^9, 3.54039155925325*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f27", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"-", "8"}], 
   RowBox[{
    RowBox[{"z", "^", "2"}], "/", "9"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"delta", " ", "*", " ", 
      RowBox[{"f27I1Function", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}]}], " ", "+", " ", 
     RowBox[{"f27I2Function", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f27Approx", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"-", "8"}], 
   RowBox[{
    RowBox[{"z", "^", "2"}], "/", "9"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"delta", " ", "*", " ", 
      RowBox[{"f27I1", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}]}], " ", "+", " ", 
     RowBox[{"f27I2", "[", 
      RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}]}]}], "\n", 
 RowBox[{
  RowBox[{"f27RelError", "[", 
   RowBox[{"z_", ",", " ", "delta_"}], "]"}], ":=", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f27", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}], " ", "-", " ", 
      RowBox[{"f27Approx", "[", 
       RowBox[{"z", ",", " ", "delta"}], "]"}]}], ")"}], "/", 
    RowBox[{"f27", "[", 
     RowBox[{"z", ",", " ", "delta"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.540391182768642*^9, 3.5403913040756893`*^9}, {
  3.540391463874198*^9, 3.540391468862564*^9}, {3.5458267725064507`*^9, 
  3.545826775897073*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"11", "/", "36"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.19", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "5"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "3"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"11", "/", "36"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"f27RelError", "[", 
  RowBox[{
   RowBox[{"0.29", "^", "2"}], ",", " ", 
   RowBox[{"1", "/", "5"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.540391182768642*^9, 3.5403913040756893`*^9}, {
  3.540391463874198*^9, 3.5403915069933243`*^9}, {3.540391832277966*^9, 
  3.540391833877995*^9}, {3.545826083918799*^9, 3.545826095106103*^9}}],

Cell[BoxData["8.776890453808103`*^-8"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.545846544970357*^9}],

Cell[BoxData["7.29710899775241`*^-8"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.545846545086038*^9}],

Cell[BoxData["4.6193898352699083`*^-8"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.545846545196464*^9}],

Cell[BoxData["8.704494435855208`*^-8"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.545846545325768*^9}],

Cell[BoxData["2.6613225981099953`*^-7"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.5458465454628468`*^9}],

Cell[BoxData["1.036007721273567`*^-6"], "Output",
 CellChangeTimes->{3.54039147042927*^9, 3.5403915075889378`*^9, 
  3.540391799310604*^9, 3.540391835527759*^9, 3.540391931785591*^9, 
  3.540392093184759*^9, 3.540396746271179*^9, 3.5403968341207733`*^9, 
  3.5405000242922707`*^9, 3.545825591130932*^9, 3.545826060625284*^9, 
  3.545826095623352*^9, 3.54582617812166*^9, 3.545832994262663*^9, 
  3.5458440398157263`*^9, 3.545846545599166*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f27RelError", "[", 
       RowBox[{"z", ",", "delta"}], "]"}], "\[Equal]", " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "7"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"f27RelError", "[", 
       RowBox[{"z", ",", "delta"}], "]"}], "\[Equal]", " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "6"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", 
     RowBox[{"3", "/", "100"}], ",", " ", 
     RowBox[{"12", "/", "100"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"delta", ",", " ", 
     RowBox[{"1", "/", "36"}], ",", " ", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.545826266817603*^9, 3.545826333836135*^9}, {
  3.545826395958715*^9, 3.545826409866385*^9}, {3.545826712526803*^9, 
  3.54582671668266*^9}, {3.5458267657939997`*^9, 3.545826785030246*^9}, {
  3.545826917852666*^9, 3.545826941280423*^9}, {3.545827136375307*^9, 
  3.545827138921*^9}, {3.5458330119229803`*^9, 3.545833014567733*^9}, {
  3.545833266445311*^9, 3.54583326902106*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlegk01O/3vzWlKBQtRIuIUJZofVGJJFsKSdpUSjuVFqUSbZaKJNmjrDNj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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59}], 
     LineBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72}], 
     LineBox[{73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
      89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
      105, 106, 107, 108, 109, 110, 111, 112, 113}], 
     LineBox[{114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,
       127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
      141, 142, 143, 144, 145, 146, 147, 148, 149, 150}], 
     LineBox[CompressedData["
1:eJwt0WdeDwAAgOF/Q6WoFGnR0EA4jCM4AMdRaWoPyUhKFGlY7VJWg9JQCpEW
z4c+PL/3AG/GlWuXrwYFAoF8rh+0gEJuUEQxJZRSRjk3qaCSKqqpoZY66mmg
kVs0cZtm7nCXe9ynhQe08pA22nlEB495QiddPOUZ3Tynh1766OcFL3nFa94w
wCBDDDPCKGOMM8FbJpniHe/5wEc+Mc0Ms8zxmS/Ms8BXFllimRW+scoa31ln
gx/85Beb/OYPW/xlmx122WOffwTMCiKYEEI5RBjhRHCYSKI4wlGiiSGWY8QR
z3FOkMBJEkkimRRSOcVp0kgng0zOkEU2OeRylnOcJ48LXOQS/wHl4Fn3
      "]], 
     LineBox[{303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315,
       316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 
      330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 
      344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357}], 
     LineBox[CompressedData["
1:eJwVytkyFgAAgNG/R+mVegQXpVRUQlJJskUIIRSyrylki2wpZCtRERUiRUmJ
MtPp4sx8F9/BoNBDJw8EAoE8DosjBHOUY4RwnBP8H0MJ4xSnOUM4Z4kgkijO
Ec15YrjARS4Ry2XiuEI8V0kgkSSSSeEaqaRxnXQyyOQGWWSTw01yySOfWxRQ
SBG3uUMxJZRylzLKqaCSKqqpoZY66mmgkXs0cZ8HNNNCKw9po50OOuniEd30
8Jhe+uhngEGeMMRTnjHMCKM8Z4xxJphkihe8ZJpXzDDLa97wljnmeccCi7zn
Ax9ZYpkVPrHKGp9Z5wtf2WCTb3xnix9s85Nf7PCbXfb4w1/2+Qdh52xI
      "]], 
     LineBox[{510, 511, 512, 513, 514, 515}], 
     LineBox[{516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528,
       529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 
      543, 544}], 
     LineBox[{545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557,
       558, 559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 
      572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 
      586, 587, 588}], LineBox[{589, 590, 591, 592, 593, 594, 595, 596, 597}],
      LineBox[{598, 599, 600, 601, 602, 603, 604}], 
     LineBox[{605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617,
       618, 619, 620, 621, 622, 623}], 
     LineBox[{624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636,
       637, 638, 639, 640}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwNw4c6lQEAAND/ur2IV/IIHqCeIa6ZLSMSZe9NIatdIpS9914JiTjn+050
7KOYh6EgCCI+jgqCOOONmGCiSSabYqpPTDPdDDPNMtscc31qnvkWWOgziyz2
uSW+sNQyX/rKciustMpqa6y1znobbLTJZltstc12O+y0y25f+8Yee+3zrf0O
OOiQw77zvR/86Cc/+8WvfnPE74465g/HnXDSn/5yymlnnHXOeRdcdMllV1x1
zXU33HTLbXfcdc99Dzz0yGNPPPXM3577xwsvvfKv1/7zxlv/e2cQDoKQUYZ9
4D0FTmKP
      "]], 
     LineBox[{773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785,
       786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 
      800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 
      814, 815, 816, 817, 818, 819}]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->NCache[{{
      Rational[3, 100], 
      Rational[3, 25]}, {
      Rational[1, 36], 
      Rational[1, 3]}}, {{0.03, 0.12}, {0.027777777777777776`, 
    0.3333333333333333}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.545826385931525*^9, 3.545826401617127*^9}, 
   3.5458266724724417`*^9, 3.545826758221026*^9, 3.545826832561481*^9, 
   3.545826937529606*^9, 3.545826987607376*^9, 3.545827215520937*^9, 
   3.545833198251751*^9, 3.545846698460373*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1054, 1029},
WindowMargins->{{0, Automatic}, {Automatic, 19}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 298, 7, 104, "Title"],
Cell[868, 31, 1807, 64, 85, "Text"],
Cell[CellGroupData[{
Cell[2700, 99, 92, 1, 65, "Subtitle"],
Cell[2795, 102, 108, 1, 38, "Subsubtitle"],
Cell[2906, 105, 1496, 46, 114, "Input"],
Cell[CellGroupData[{
Cell[4427, 155, 101, 1, 38, "Subsubtitle"],
Cell[CellGroupData[{
Cell[4553, 160, 1844, 34, 89, "Input"],
Cell[6400, 196, 188, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6625, 204, 5081, 101, 214, "Input"],
Cell[11709, 307, 581, 8, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12339, 321, 176, 3, 38, "Subsubtitle"],
Cell[CellGroupData[{
Cell[12540, 328, 290, 4, 47, "Subsection"],
Cell[12833, 334, 1456, 38, 89, "Input"],
Cell[CellGroupData[{
Cell[14314, 376, 1353, 28, 139, "Input"],
Cell[15670, 406, 17590, 351, 1214, "Output"],
Cell[33263, 759, 1460, 21, 38, "Output"],
Cell[34726, 782, 1457, 21, 38, "Output"]
}, Open  ]],
Cell[36198, 806, 92, 1, 38, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36327, 812, 92, 1, 47, "Subsection"],
Cell[36422, 815, 1656, 41, 89, "Input"],
Cell[CellGroupData[{
Cell[38103, 860, 1527, 29, 139, "Input"],
Cell[39633, 891, 17892, 370, 1364, "Output"],
Cell[57528, 1263, 1222, 17, 38, "Output"],
Cell[58753, 1282, 1219, 17, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60021, 1305, 101, 1, 47, "Subsection"],
Cell[60125, 1308, 1490, 43, 89, "Input"],
Cell[CellGroupData[{
Cell[61640, 1355, 1132, 28, 164, "Input"],
Cell[62775, 1385, 720, 12, 38, "Output"],
Cell[63498, 1399, 721, 12, 38, "Output"],
Cell[64222, 1413, 720, 12, 38, "Output"],
Cell[64945, 1427, 739, 13, 38, "Output"],
Cell[65687, 1442, 739, 13, 38, "Output"],
Cell[66429, 1457, 741, 13, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67207, 1475, 1192, 29, 64, "Input"],
Cell[68402, 1506, 16992, 288, 458, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85455, 1801, 258, 5, 38, "Subsubtitle"],
Cell[CellGroupData[{
Cell[85738, 1810, 290, 4, 47, "Subsection"],
Cell[86031, 1816, 1351, 33, 64, "Input"],
Cell[CellGroupData[{
Cell[87407, 1853, 1277, 27, 139, "Input"],
Cell[88687, 1882, 17163, 345, 1364, "Output"],
Cell[105853, 2229, 815, 12, 38, "Output"],
Cell[106671, 2243, 812, 12, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107532, 2261, 92, 1, 47, "Subsection"],
Cell[107627, 2264, 1656, 39, 89, "Input"],
Cell[CellGroupData[{
Cell[109308, 2307, 1588, 31, 139, "Input"],
Cell[110899, 2340, 17603, 363, 1314, "Output"],
Cell[128505, 2705, 1038, 15, 38, "Output"],
Cell[129546, 2722, 1036, 15, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130631, 2743, 101, 1, 47, "Subsection"],
Cell[130735, 2746, 1531, 44, 89, "Input"],
Cell[CellGroupData[{
Cell[132291, 2794, 1083, 27, 164, "Input"],
Cell[133377, 2823, 442, 6, 38, "Output"],
Cell[133822, 2831, 441, 6, 38, "Output"],
Cell[134266, 2839, 443, 6, 38, "Output"],
Cell[134712, 2847, 442, 6, 38, "Output"],
Cell[135157, 2855, 445, 6, 38, "Output"],
Cell[135605, 2863, 442, 6, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136084, 2874, 1141, 28, 64, "Input"],
Cell[137228, 2904, 18643, 315, 458, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
