/* vim: set sw=4 sts=4 et foldmethod=syntax : */

/*
 * Copyright (c) 2022 Viktor Kuschke
 *
 * This file is part of the EOS project. EOS is free software;
 * you can redistribute it and/or modify it under the terms of the GNU General
 * Public License version 2, as published by the Free Software Foundation.
 *
 * EOS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <eos/maths/power-of.hh>
#include <eos/maths/polylog.hh>
#include <eos/maths/multiplepolylog-li22.hh>

#include <eos/rare-b-decays/charm-loops-impl.hh>

#include <eos/utils/exception.hh>
#include <eos/utils/log.hh>
#include <eos/utils/stringify.hh>

#include <cmath>
#include <complex>

namespace eos
{
    using std::complex;
    using std::log;
    using std::real;

    namespace agv_2019a
    {
        // this functions contains the GPLs of weight 4 in F27(9)d where exactly one weight is + wx3(4)
        // the sum that contains the GPLs of weight 4 with one weight being - wx3(4) can be derived from this one
        complex<double> weight4_wx3_wx4(const CharmLoopsParameters & clp, const complex<double> & wx)
        {
            const complex<double> xd = clp.xd;
            const complex<double> wxinv = 1.0 / wx;

            // this term multiplies an ill-defined sign(0.0)
            // the terms multiply a function form T(1, x, 1 + y) * T(p(-y, x), 1 + y, 2.0) which is conjectured to be zero for any values of x and y
            const complex<double> sign0term = (-6.0 * pisqu * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) * T(p((-1.0i) * wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0) - 6.0 * pisqu * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) * T(p(1.0i * wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0));

            if(sign0term != 0.0)
            {
                throw InternalError("Ill-defined Sign(0.0)");
            }

            const complex<double> xdinv = 1.0 / xd;

            const complex<double> result = power_of<4>(M_PI) / 5.0 - (3.0 * power_of<2>(dilog(1.0 - 1.0i * wx))) / 4.0 - (3.0 * power_of<2>(dilog(1.0 + 1.0i * wx))) / 4.0 + (3.0 * power_of<2>(dilog(-1.0i / (-1.0i + wx)))) / 4.0 + (3.0 * power_of<2>(dilog(1.0i / (1.0i + wx)))) / 4.0 + (9.0 * quadlog(1.0 - 1.0i * wx)) / 2.0 + (9.0 * quadlog(1.0 + 1.0i * wx)) / 2.0 + quadlog(-1.0i / wx) + quadlog(1.0i / wx) + 2.0 * quadlog((-1.0i) * wx) + 2.0 * quadlog(1.0i * wx) + (3.0 * quadlog(-1.0i / (-1.0i + wx))) / 2.0 + quadlog(wx / (-1.0i + wx)) + quadlog((-1.0i + wx) / wx) + (3.0 * quadlog(1.0i / (1.0i + wx))) / 2.0 + quadlog(wx / (1.0i + wx)) + quadlog((1.0i + wx) / wx) - 2.0 * quadlog(1.0 - wx * xdinv) + quadlog((wx - xd) / (-1.0i + wx)) + quadlog((wx - xd) / (1.0i + wx)) - 8.0 * quadlog(1.0 - 1.0i * xd)
                - 8.0 * quadlog(1.0 + 1.0i * xd) - 6.0 * quadlog((-1.0i) * xd) - 6.0 * quadlog(1.0i * xd) + 9.0 * quadlog(xd / wx) + 2.0 * quadlog(-(xd / (wx - xd))) + 2.0 * quadlog((1.0i * (1.0i + wx) * xd) / (wx - xd)) - 2.0 * quadlog(xd / (-1.0i + xd)) - 3.0 * quadlog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) - 6.0 * quadlog((-1.0i + xd) / (-1.0i + wx)) + quadlog((-1.0i + xd) * xdinv) - 2.0 * quadlog(xd / (1.0i + xd)) - 3.0 * quadlog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) - 6.0 * quadlog((1.0i + xd) / (1.0i + wx)) + quadlog((1.0i + xd) * xdinv) + 8.0 * quadlog(1.0 - xd / wx) + 2.0 * quadlog(-((xd + 1.0i * wx * xd) / (wx - xd))) - li22(-1.0, (-1.0i) * xd) / 2.0 - li22(-1.0, 1.0i * xd) / 2.0 + li22(0.5, 1.0 - 1.0i * wx) / 4.0
                + li22(0.5, 1.0 + 1.0i * wx) / 4.0 - (5.0 * li22(0.5, (-2.0 * 1.0i) / (-1.0i + wx))) / 2.0 - li22(0.5, (-1.0i + wx) / wx) / 4.0 - (5.0 * li22(0.5, (2.0 * 1.0i) / (1.0i + wx))) / 2.0 - li22(0.5, (1.0i + wx) / wx) / 4.0 + li22(0.5, (2.0 * wx) / (wx - xd)) - li22(0.5, (-2.0 * xd) / (wx - xd)) + li22(0.5, (2.0 * xd) / (-1.0i + xd)) / 2.0 + li22(0.5, (2.0 * xd) / (1.0i + xd)) / 2.0 - li22(0.5 - (1.0i / 2.0) * wx, 1.0i / (1.0i + wx)) / 4.0 + li22(0.5 - (1.0i / 2.0) * wx, (-2.0 * xd) / (wx - xd)) / 2.0 + li22(0.5 - (1.0i / 2.0) * wx, (1.0i + xd) / (1.0i + wx)) / 4.0 + li22(0.5 + (1.0i / 2.0) * wx, (-2.0 * xd) / (wx - xd)) / 2.0 + li22(1.0 - 1.0i * wx, (1.0i + xd) / (1.0i + wx))
                - li22((1.0 + 1.0i * wx) / 2.0, -1.0i / (-1.0i + wx)) / 4.0 + li22((1.0 + 1.0i * wx) / 2.0, (-1.0i + xd) / (-1.0i + wx)) / 4.0 + li22(1.0 + 1.0i * wx, (-1.0i + xd) / (-1.0i + wx)) + li22(-1.0i / wx, 1.0i * xd) + li22(1.0i / wx, (-1.0i) * xd) + 2.0 * li22(-1.0i / (-1.0i + wx), 2.0) + li22(-1.0i / (-1.0i + wx), 1.0 - 1.0i * wx) - li22(-1.0i / (-1.0i + wx), (1.0 + 1.0i * wx) / 2.0) / 2.0 - li22(-1.0i / (-1.0i + wx), 1.0 + 1.0i * xd) - li22(-1.0i / (-1.0i + wx), (1.0i - wx) / (1.0i + xd)) - li22(-1.0i / (-1.0i + wx), -((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - li22(-1.0i / (-1.0i + wx), (xd + 1.0i * wx * xd) / (1.0i + xd)) / 4.0 - 2.0 * li22((-2.0 * 1.0i) / (-1.0i + wx), 0.5) + 2.0 * li22((-2.0 * 1.0i) / (-1.0i + wx), (1.0 + 1.0i * xd) / 2.0)
                + li22((-2.0 * 1.0i) / (-1.0i + wx), (xd + 1.0i * wx * xd) / (1.0i + xd)) / 4.0 - li22(wx / (-1.0i + wx), 2.0) / 2.0 - li22(wx / (-1.0i + wx), (1.0i + wx) / wx) / 2.0 + li22(wx / (-1.0i + wx), ((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) / 4.0 + li22(wx / (-1.0i + wx), ((-1.0i + wx) * xd) / (wx * (1.0i + xd))) + li22(wx / (-1.0i + wx), 1.0 - xd / wx) / 2.0 + li22(wx / (-1.0i + wx), (1.0 + 1.0i * wx) / (1.0i * wx + wx * xd)) / 4.0 + li22((2.0 * wx) / (-1.0i + wx), 0.5) / 2.0 - li22((2.0 * wx) / (-1.0i + wx), (wx - xd) / (2.0 * wx)) / 2.0 - li22((2.0 * wx) / (-1.0i + wx), ((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) / 4.0 + li22((-1.0i + wx) / (2.0 * wx), wx / (-1.0i + wx)) / 4.0
                - li22((-1.0i + wx) / (2.0 * wx), (wx * (1.0 - 1.0i * xd)) / (-1.0i + wx)) / 4.0 - li22((-1.0i + wx) / (2.0 * wx), (2.0 * xd) / (-1.0i + xd)) / 2.0 + 2.0 * li22(1.0i / (1.0i + wx), 2.0) - li22(1.0i / (1.0i + wx), 0.5 - (1.0i / 2.0) * wx) / 2.0 + li22(1.0i / (1.0i + wx), 1.0 + 1.0i * wx) - li22(1.0i / (1.0i + wx), (1.0i + wx) / (1.0i - xd)) - li22(1.0i / (1.0i + wx), 1.0 - 1.0i * xd) - li22(1.0i / (1.0i + wx), (1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 - li22(1.0i / (1.0i + wx), ((1.0 - 1.0i * wx) * xd) / (-1.0i + xd)) / 4.0 - 2.0 * li22((2.0 * 1.0i) / (1.0i + wx), 0.5) + 2.0 * li22((2.0 * 1.0i) / (1.0i + wx), 0.5 - (1.0i / 2.0) * xd) + li22((2.0 * 1.0i) / (1.0i + wx), ((1.0 - 1.0i * wx) * xd) / (-1.0i + xd)) / 4.0
                - li22((1.0i - wx) / (1.0i + wx), -1.0i / (-1.0i + wx)) + li22((1.0i - wx) / (1.0i + wx), (1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 + li22((1.0i - wx) / (1.0i + wx), (1.0i + xd) / (1.0i - wx)) - li22(wx / (1.0i + wx), 2.0) / 2.0 - li22(wx / (1.0i + wx), (-1.0i + wx) / wx) / 2.0 + li22(wx / (1.0i + wx), (1.0 - 1.0i * wx) / (wx * (-1.0i + xd))) / 4.0 + li22(wx / (1.0i + wx), ((1.0i + wx) * xd) / (wx * (-1.0i + xd))) + li22(wx / (1.0i + wx), ((1.0i + wx) * xd) / (wx * (1.0i + xd))) / 4.0 + li22(wx / (1.0i + wx), 1.0 - xd / wx) / 2.0 + li22((2.0 * wx) / (1.0i + wx), 0.5) / 2.0 - li22((2.0 * wx) / (1.0i + wx), (wx - xd) / (2.0 * wx)) / 2.0
                - li22((2.0 * wx) / (1.0i + wx), ((1.0i + wx) * xd) / (wx * (1.0i + xd))) / 4.0 + li22((-1.0i + wx) / (1.0i + wx), wx / (-1.0i + wx)) / 2.0 - li22((-1.0i + wx) / (1.0i + wx), (wx - xd) / (-1.0i + wx)) / 2.0 - li22((-1.0i + wx) / (1.0i + wx), ((1.0i + wx) * xd) / (wx * (-1.0i + xd))) - li22((1.0i + wx) / (1.0i - wx), 1.0i / (1.0i + wx)) + li22((1.0i + wx) / (1.0i - wx), (1.0i - xd) / (1.0i + wx)) + li22((1.0i + wx) / (1.0i - wx), -((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + li22((1.0i + wx) / (2.0 * wx), wx / (1.0i + wx)) / 4.0 - li22((1.0i + wx) / (2.0 * wx), (2.0 * xd) / (1.0i + xd)) / 2.0 - li22((1.0i + wx) / (2.0 * wx), (wx + 1.0i * wx * xd) / (1.0i + wx)) / 4.0
                + li22((1.0i + wx) / (-1.0i + wx), wx / (1.0i + wx)) / 2.0 - li22((1.0i + wx) / (-1.0i + wx), (wx - xd) / (1.0i + wx)) / 2.0 - li22((1.0i + wx) / (-1.0i + wx), ((-1.0i + wx) * xd) / (wx * (1.0i + xd))) - li22(wx / (wx - xd), (wx - xd) / (2.0 * wx)) + li22((wx - xd) / (-1.0i + wx), wx / (wx - xd)) / 2.0 + li22((wx - xd) / (-1.0i + wx), (2.0 * wx) / (wx - xd)) / 2.0 + li22((wx - xd) / (-1.0i + wx), (1.0i + wx) / (wx - xd)) / 2.0 - li22((wx - xd) / (-1.0i + wx), (1.0 + 1.0i * wx) / (1.0i * wx + wx * xd)) / 4.0 + li22((wx - xd) / (1.0i + wx), wx / (wx - xd)) / 2.0 + li22((wx - xd) / (1.0i + wx), (2.0 * wx) / (wx - xd)) / 2.0
                + li22((wx - xd) / (1.0i + wx), (-1.0i + wx) / (wx - xd)) / 2.0 - li22((wx - xd) / (1.0i + wx), (1.0 - 1.0i * wx) / (wx * (-1.0i + xd))) / 4.0 + (5.0 * li22(0.5 - (1.0i / 2.0) * xd, (2.0 * 1.0i) / (1.0i + wx))) / 2.0 - li22(0.5 - (1.0i / 2.0) * xd, (2.0 * wx) / (wx - xd)) / 2.0 - li22(0.5 - (1.0i / 2.0) * xd, (1.0i + wx) / (1.0i + xd)) / 4.0 + li22(0.5 - (1.0i / 2.0) * xd, (1.0 + 1.0i * wx) / (1.0i * wx + wx * xd)) / 4.0 - li22(0.5 + (1.0i / 2.0) * xd, (2.0 * wx) / (wx - xd)) / 2.0 - li22(1.0 - 1.0i * xd, 1.0i / (1.0i + wx)) / 2.0 - li22(1.0 - 1.0i * xd, (1.0i + wx) / (1.0i + xd)) + (5.0 * li22((1.0 + 1.0i * xd) / 2.0, (-2.0 * 1.0i) / (-1.0i + wx))) / 2.0 + li22((1.0 + 1.0i * xd) / 2.0, (1.0 - 1.0i * wx) / (wx * (-1.0i + xd))) / 4.0
                - li22((1.0 + 1.0i * xd) / 2.0, (-1.0i + wx) / (-1.0i + xd)) / 4.0 - li22(1.0 + 1.0i * xd, -1.0i / (-1.0i + wx)) / 2.0 - li22(1.0 + 1.0i * xd, (-1.0i + wx) / (-1.0i + xd)) + li22((-1.0i) * xd, -1.0) + li22((-1.0i) * xd, wx * xdinv) + li22(1.0i * xd, -1.0) + li22(1.0i * xd, wx * xdinv) + li22(xd / wx, (-1.0i) * wx) / 2.0 + li22(xd / wx, 1.0i * wx) / 2.0 - 2.0 * li22(xd / wx, -1.0i / xd) - 2.0 * li22(xd / wx, 1.0i / xd) + (3.0 * li22(-(xd / (wx - xd)), 1.0 - 1.0i * wx)) / 4.0 + (3.0 * li22(-(xd / (wx - xd)), 1.0 + 1.0i * wx)) / 4.0 + li22(-(xd / (wx - xd)), (1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) / 2.0 + li22(-(xd / (wx - xd)), ((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) / 2.0
                - li22(-(xd / (wx - xd)), (-1.0i + xd) * xdinv) / 4.0 - li22(-(xd / (wx - xd)), (1.0i + xd) * xdinv) / 4.0 + li22(-(xd / (wx - xd)), (-wx + xd) / (2.0 * xd)) + (5.0 * li22((1.0i * (1.0i + wx) * xd) / (wx - xd), 1.0i / (1.0i + wx))) / 4.0 - li22((1.0i * (1.0i + wx) * xd) / (wx - xd), (1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) / 2.0 - li22((1.0i * (1.0i + wx) * xd) / (wx - xd), (-wx + xd) / (2.0 * xd)) / 2.0 + li22((1.0i * (1.0i + wx) * xd) / (wx - xd), (1.0 + 1.0i * xd) / (1.0i * xd + wx * xd)) / 4.0 + li22(-1.0i / (-1.0i + xd), (1.0i - xd) / (1.0i + wx)) - li22(-1.0i / (-1.0i + xd), (wx + 1.0i * wx * xd) / (1.0i + wx)) / 4.0
                + li22(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)), (wx + 1.0i * wx * xd) / (1.0i + wx)) / 4.0 - li22(xd / (-1.0i + xd), 2.0) / 2.0 - li22(xd / (-1.0i + xd), (-1.0i + wx) / wx) - li22(xd / (-1.0i + xd), 1.0 - wx * xdinv) / 2.0 - li22(xd / (-1.0i + xd), (-1.0i + xd) / (2.0 * xd)) / 2.0 - li22(xd / (-1.0i + xd), (wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) / 4.0 - li22(xd / (-1.0i + xd), (wx * (-1.0i + xd)) / ((1.0i + wx) * xd)) + li22(xd / (-1.0i + xd), (1.0i + xd) * xdinv) + li22(xd / (-1.0i + xd), (1.0 + 1.0i * xd) / (1.0i * xd + wx * xd)) / 4.0 + li22((2.0 * xd) / (-1.0i + xd), 0.5) / 2.0 - li22((2.0 * xd) / (-1.0i + xd), (-1.0i + wx) / (2.0 * wx))
                + li22((2.0 * xd) / (-1.0i + xd), (wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) / 4.0 + li22((2.0 * xd) / (-1.0i + xd), (-wx + xd) / (2.0 * xd)) / 2.0 - li22((2.0 * xd) / (-1.0i + xd), (1.0 + 1.0i * xd) / (1.0i * xd + wx * xd)) / 4.0 - 2.0 * li22(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)), wx / (-1.0i + wx)) + li22(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)), (2.0 * wx) / (-1.0i + wx)) + li22(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)), (-1.0i + xd) / (2.0 * xd)) / 2.0 + li22(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)), (wx * (-1.0i + xd)) / ((1.0i + wx) * xd)) - li22(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)), (wx * (1.0i + xd)) / ((-1.0i + wx) * xd)) + li22((-1.0i + xd) / (-1.0i + wx), (1.0 + 1.0i * wx) / 2.0) / 2.0
                - li22((-1.0i + xd) / (-1.0i + wx), 1.0 + 1.0i * wx) / 2.0 - li22((-1.0i + xd) / (-1.0i + wx), (1.0i + wx) / (1.0i - xd)) - 2.0 * li22((-1.0i + xd) / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + xd)) + li22((-1.0i + xd) / (-1.0i + wx), (1.0i - wx) / (1.0i + xd)) - li22(1.0i / (1.0i + xd), (wx * (1.0 - 1.0i * xd)) / (-1.0i + wx)) / 4.0 + li22(1.0i / (1.0i + xd), (1.0i + xd) / (1.0i - wx)) - li22((1.0i - xd) / (1.0i + xd), (1.0i + xd) / (1.0i - wx)) + li22((1.0i * (wx - xd)) / (wx * (1.0i + xd)), (wx * (1.0 - 1.0i * xd)) / (-1.0i + wx)) / 4.0 - li22(xd / (1.0i + xd), 2.0) / 2.0 - li22(xd / (1.0i + xd), (1.0i + wx) / wx) - li22(xd / (1.0i + xd), 1.0 - wx * xdinv) / 2.0
                + li22(xd / (1.0i + xd), (1.0 - 1.0i * xd) / ((-1.0i + wx) * xd)) / 4.0 + li22(xd / (1.0i + xd), (-1.0i + xd) * xdinv) - li22(xd / (1.0i + xd), (1.0i + xd) / (2.0 * xd)) / 2.0 - li22(xd / (1.0i + xd), (wx * (1.0i + xd)) / ((-1.0i + wx) * xd)) - li22(xd / (1.0i + xd), (wx * (1.0i + xd)) / ((1.0i + wx) * xd)) / 4.0 + li22((2.0 * xd) / (1.0i + xd), 0.5) / 2.0 - li22((2.0 * xd) / (1.0i + xd), (1.0i + wx) / (2.0 * wx)) - li22((2.0 * xd) / (1.0i + xd), (1.0 - 1.0i * xd) / ((-1.0i + wx) * xd)) / 4.0 + li22((2.0 * xd) / (1.0i + xd), (wx * (1.0i + xd)) / ((1.0i + wx) * xd)) / 4.0 + li22((2.0 * xd) / (1.0i + xd), (-wx + xd) / (2.0 * xd)) / 2.0 - 2.0 * li22(((1.0i + wx) * xd) / (wx * (1.0i + xd)), wx / (1.0i + wx))
                + li22(((1.0i + wx) * xd) / (wx * (1.0i + xd)), (2.0 * wx) / (1.0i + wx)) - li22(((1.0i + wx) * xd) / (wx * (1.0i + xd)), (wx * (-1.0i + xd)) / ((1.0i + wx) * xd)) + li22(((1.0i + wx) * xd) / (wx * (1.0i + xd)), (1.0i + xd) / (2.0 * xd)) / 2.0 + li22(((1.0i + wx) * xd) / (wx * (1.0i + xd)), (wx * (1.0i + xd)) / ((-1.0i + wx) * xd)) - li22((-1.0i + xd) / (1.0i + xd), xd / (-1.0i + xd)) + li22((-1.0i + xd) / (1.0i + xd), ((1.0i + wx) * xd) / (wx * (-1.0i + xd))) + li22((1.0i + xd) / (1.0i + wx), 0.5 - (1.0i / 2.0) * wx) / 2.0 - li22((1.0i + xd) / (1.0i + wx), 1.0 - 1.0i * wx) / 2.0 + li22((1.0i + xd) / (1.0i + wx), (1.0i + wx) / (1.0i - xd)) - 2.0 * li22((1.0i + xd) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + xd))
                - li22((1.0i + xd) / (1.0i + wx), (1.0i - wx) / (1.0i + xd)) - li22((1.0i + xd) / (1.0i - xd), (1.0i - xd) / (1.0i + wx)) + li22(-((1.0i + xd) / (wx - xd)), xd / (1.0i + xd)) / 4.0 - li22(-((1.0i + xd) / (wx - xd)), (xd + 1.0i * wx * xd) / (1.0i + xd)) / 4.0 - li22((1.0i + xd) / (-1.0i + xd), xd / (1.0i + xd)) + li22((1.0i + xd) / (-1.0i + xd), ((-1.0i + wx) * xd) / (wx * (1.0i + xd))) + li22((-1.0i + xd) / (-wx + xd), xd / (-1.0i + xd)) / 4.0 - li22((-1.0i + xd) / (-wx + xd), ((1.0 - 1.0i * wx) * xd) / (-1.0i + xd)) / 4.0 - li22((-wx + xd) / (-1.0i + xd), (-2.0 * xd) / (wx - xd)) / 2.0 + li22((-wx + xd) / (-1.0i + xd), -(xd / (wx - xd))) / 2.0
                - li22((-wx + xd) / (1.0i + xd), (-2.0 * xd) / (wx - xd)) / 2.0 + li22((-wx + xd) / (1.0i + xd), -(xd / (wx - xd))) / 2.0 + li22((wx - 1.0i * wx * xd) / (wx - xd), (wx - xd) / (2.0 * wx)) / 2.0 + li22((wx + 1.0i * wx * xd) / (wx - xd), (wx - xd) / (2.0 * wx)) / 2.0 + (5.0 * li22(-((xd + 1.0i * wx * xd) / (wx - xd)), -1.0i / (-1.0i + wx))) / 4.0 - li22(-((xd + 1.0i * wx * xd) / (wx - xd)), ((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) / 2.0 + li22(-((xd + 1.0i * wx * xd) / (wx - xd)), (1.0 - 1.0i * xd) / ((-1.0i + wx) * xd)) / 4.0 - li22(-((xd + 1.0i * wx * xd) / (wx - xd)), (-wx + xd) / (2.0 * xd)) / 2.0 - (pisqu * power_of<2>(lnm2)) / 24.0 - (pisqu * ln2 * log(-1.0 + 1.0i / wx)) / 6.0
                + (pisqu * power_of<2>(log(-1.0 + 1.0i / wx))) / 24.0 - (ln2 * power_of<3>(log(-1.0 + 1.0i / wx))) / 6.0 + (pisqu * ln2 * log(-1.0 - 1.0i * wx)) / 12.0 + (5.0 * pisqu * power_of<2>(log(-1.0 - 1.0i * wx))) / 24.0 + (power_of<2>(lnm2) * power_of<2>(log(-1.0 - 1.0i * wx))) / 16.0 + (ln2 * power_of<3>(log(-1.0 - 1.0i * wx))) / 12.0 + power_of<4>(log(-1.0 - 1.0i * wx)) / 24.0 + (pisqu * lnm2 * log(1.0 - 1.0i * wx)) / 12.0 + (power_of<3>(lnm2) * log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * lnm1 * log(1.0 - 1.0i * wx)) / 12.0 - (power_of<3>(lnm1) * log(1.0 - 1.0i * wx)) / 12.0 + (lnm1 * ln2squ * log(1.0 - 1.0i * wx)) / 4.0 + (pisqu * power_of<2>(log(1.0 - 1.0i * wx))) / 6.0 + power_of<4>(log(1.0 - 1.0i * wx)) / 6.0 + (pisqu * ln2 * log(-1.0 + 1.0i * wx)) / 12.0
                + (5.0 * pisqu * power_of<2>(log(-1.0 + 1.0i * wx))) / 24.0 + (power_of<2>(lnm2) * power_of<2>(log(-1.0 + 1.0i * wx))) / 16.0 + (ln2 * power_of<3>(log(-1.0 + 1.0i * wx))) / 12.0 + power_of<4>(log(-1.0 + 1.0i * wx)) / 24.0 + (pisqu * lnm2 * log(1.0 + 1.0i * wx)) / 12.0 + (power_of<3>(lnm2) * log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * lnm1 * log(1.0 + 1.0i * wx)) / 12.0 - (power_of<3>(lnm1) * log(1.0 + 1.0i * wx)) / 12.0 + (lnm1 * ln2squ * log(1.0 + 1.0i * wx)) / 4.0 - (pisqu * log(-1.0 + 1.0i / wx) * log(1.0 + 1.0i * wx)) / 6.0 - (power_of<3>(log(-1.0 + 1.0i / wx)) * log(1.0 + 1.0i * wx)) / 6.0 + (pisqu * power_of<2>(log(1.0 + 1.0i * wx))) / 6.0 + power_of<4>(log(1.0 + 1.0i * wx)) / 6.0 + trilog(wx * xdinv) * (2.0 * ln2 + log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx))
                + (pisqu * ln2 * log(-1.0i / wx)) / 6.0 - (ln2 * power_of<2>(log(1.0 - 1.0i * wx)) * log(-1.0i / wx)) / 2.0 + (pisqu * log(1.0 + 1.0i * wx) * log(-1.0i / wx)) / 6.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * wx) * log(-1.0i / wx)) / 2.0 + (ln2 * power_of<3>(log(-1.0i / wx))) / 6.0 + (log(1.0 + 1.0i * wx) * power_of<3>(log(-1.0i / wx))) / 6.0 + (pisqu * ln2 * log(1.0i / wx)) / 6.0 + (pisqu * log(1.0 - 1.0i * wx) * log(1.0i / wx)) / 6.0 - (ln2 * power_of<2>(log(1.0 + 1.0i * wx)) * log(1.0i / wx)) / 2.0 - (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0 + 1.0i * wx)) * log(1.0i / wx)) / 2.0 + (ln2 * power_of<3>(log(1.0i / wx))) / 6.0 + (log(1.0 - 1.0i * wx) * power_of<3>(log(1.0i / wx))) / 6.0 - (pisqu * ln2 * log((-1.0i) * wx)) / 3.0
                - (power_of<2>(log(-1.0 + 1.0i / wx)) * log(1.0 + 1.0i * wx) * log((-1.0i) * wx)) / 2.0 - (pisqu * power_of<2>(log((-1.0i) * wx))) / 4.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * power_of<2>(log((-1.0i) * wx))) / 2.0 - (ln2 * power_of<3>(log((-1.0i) * wx))) / 3.0 - (log(-1.0 - 1.0i * wx) * power_of<3>(log((-1.0i) * wx))) / 2.0 + power_of<4>(log((-1.0i) * wx)) / 4.0 - (pisqu * ln2 * log(1.0i * wx)) / 3.0 - (pisqu * power_of<2>(log(1.0i * wx))) / 4.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * power_of<2>(log(1.0i * wx))) / 2.0 - (ln2 * power_of<3>(log(1.0i * wx))) / 3.0 - (log(-1.0 + 1.0i * wx) * power_of<3>(log(1.0i * wx))) / 2.0 + power_of<4>(log(1.0i * wx)) / 4.0 - (pisqu * log(1.0 + 1.0i * wx) * log(-1.0i / (-1.0i + wx))) / 6.0 + (log(1.0 + 1.0i * wx) * power_of<2>(log((-1.0i) * wx)) * log(-1.0i / (-1.0i + wx))) / 2.0
                - (pisqu * power_of<2>(log(-1.0i / (-1.0i + wx)))) / 6.0 - (log(1.0 + 1.0i * wx) * power_of<3>(log(-1.0i / (-1.0i + wx)))) / 6.0 + power_of<4>(log(-1.0i / (-1.0i + wx))) / 6.0 - (power_of<3>(log(-1.0i / (-1.0i + wx))) * log(-(wx / (-1.0i + wx)))) / 3.0 - (pisqu * lnm2 * log((-1.0i + wx) / wx)) / 12.0 - (power_of<3>(lnm2) * log((-1.0i + wx) / wx)) / 12.0 + (pisqu * lnm1 * log((-1.0i + wx) / wx)) / 12.0 + (power_of<3>(lnm1) * log((-1.0i + wx) / wx)) / 12.0 - (lnm1 * ln2squ * log((-1.0i + wx) / wx)) / 4.0 + (power_of<2>(log(-1.0 - 1.0i * wx)) * log(1.0i / wx) * log((-1.0i + wx) / wx)) / 2.0 - (pisqu * log(1.0i * wx) * log((-1.0i + wx) / wx)) / 6.0 - (power_of<3>(log(1.0i * wx)) * log((-1.0i + wx) / wx)) / 6.0
                + (pisqu * log(wx / (-1.0i + wx)) * log((-1.0i + wx) / wx)) / 3.0 - power_of<2>(log(1.0i / wx)) * log(wx / (-1.0i + wx)) * log((-1.0i + wx) / wx) + (power_of<3>(log(wx / (-1.0i + wx))) * log((-1.0i + wx) / wx)) / 3.0 + (power_of<2>(log(1.0i / wx)) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + ln2 * log((-1.0i) * wx) * power_of<2>(log((-1.0i + wx) / wx)) + (log(-1.0 - 1.0i * wx) * power_of<3>(log((-1.0i + wx) / wx))) / 3.0 - power_of<4>(log((-1.0i + wx) / wx)) / 3.0 - (pisqu * log(1.0 - 1.0i * wx) * log(1.0i / (1.0i + wx))) / 6.0 + (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0i * wx)) * log(1.0i / (1.0i + wx))) / 2.0 - (pisqu * power_of<2>(log(1.0i / (1.0i + wx)))) / 6.0 - (log(1.0 - 1.0i * wx) * power_of<3>(log(1.0i / (1.0i + wx)))) / 6.0 + power_of<4>(log(1.0i / (1.0i + wx))) / 6.0
                - (power_of<3>(log(1.0i / (1.0i + wx))) * log(-(wx / (1.0i + wx)))) / 3.0 - (pisqu * ln2 * log(-((1.0i + wx) / wx))) / 6.0 - (pisqu * log(1.0 - 1.0i * wx) * log(-((1.0i + wx) / wx))) / 6.0 + (pisqu * power_of<2>(log(-((1.0i + wx) / wx)))) / 24.0 - (log(1.0 - 1.0i * wx) * log(1.0i * wx) * power_of<2>(log(-((1.0i + wx) / wx)))) / 2.0 - (ln2 * power_of<3>(log(-((1.0i + wx) / wx)))) / 6.0 - (log(1.0 - 1.0i * wx) * power_of<3>(log(-((1.0i + wx) / wx)))) / 6.0 - (pisqu * lnm2 * log((1.0i + wx) / wx)) / 12.0 - (power_of<3>(lnm2) * log((1.0i + wx) / wx)) / 12.0 + (pisqu * lnm1 * log((1.0i + wx) / wx)) / 12.0 + (power_of<3>(lnm1) * log((1.0i + wx) / wx)) / 12.0 - (lnm1 * ln2squ * log((1.0i + wx) / wx)) / 4.0
                + (power_of<2>(log(-1.0 + 1.0i * wx)) * log(-1.0i / wx) * log((1.0i + wx) / wx)) / 2.0 - (pisqu * log((-1.0i) * wx) * log((1.0i + wx) / wx)) / 6.0 - (power_of<3>(log((-1.0i) * wx)) * log((1.0i + wx) / wx)) / 6.0 + (log((-1.0i) * wx) * power_of<2>(log((-1.0i + wx) / wx)) * log((1.0i + wx) / wx)) / 2.0 + (pisqu * log(wx / (1.0i + wx)) * log((1.0i + wx) / wx)) / 3.0 - power_of<2>(log(-1.0i / wx)) * log(wx / (1.0i + wx)) * log((1.0i + wx) / wx) + (power_of<3>(log(wx / (1.0i + wx))) * log((1.0i + wx) / wx)) / 3.0 + (power_of<2>(log(-1.0i / wx)) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + ln2 * log(1.0i * wx) * power_of<2>(log((1.0i + wx) / wx)) + (log(1.0i * wx) * log((-1.0i + wx) / wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0
                + (log(-1.0 + 1.0i * wx) * power_of<3>(log((1.0i + wx) / wx))) / 3.0 - power_of<4>(log((1.0i + wx) / wx)) / 3.0 + ((pisqu * ln2) / 12.0 + (pisqu * log(1.0 - 1.0i * wx)) / 12.0) * log(wx * (-1.0i - xdinv)) + (ln2 / 12.0 + log(1.0 - 1.0i * wx) / 12.0) * power_of<3>(log(wx * (-1.0i - xdinv))) + ((-1.0 / 6.0) * (pisqu * ln2) + (pisqu * log((1.0i + wx) / wx)) / 6.0) * log(1.0i * (1.0 / wx - xdinv)) + ((-1.0 / 6.0) * ln2 + log((1.0i + wx) / wx) / 6.0) * power_of<3>(log(1.0i * (1.0 / wx - xdinv))) + power_of<4>(log(-1.0 + 1.0i / xd)) / 24.0 - (pisqu * log(1.0 - 1.0i * wx) * log(wx * (-1.0i + xdinv))) / 6.0 - (log(1.0 - 1.0i * wx) * power_of<3>(log(wx * (-1.0i + xdinv)))) / 6.0
                - (pisqu * log(1.0 + 1.0i * wx) * log(wx * (1.0i + xdinv))) / 6.0 - (log(1.0 + 1.0i * wx) * power_of<3>(log(wx * (1.0i + xdinv)))) / 6.0 - power_of<4>(log(-1.0 + wx * xdinv)) / 12.0 + power_of<4>(log(wx / (wx - xd))) / 3.0 - (pisqu * log(1.0 + 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (-1.0i + wx)))) / 6.0 - (log(1.0 + 1.0i * wx) * power_of<3>(log((1.0i * (wx - xd)) / (wx * (-1.0i + wx))))) / 6.0 - (pisqu * log(1.0 - 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (1.0i + wx)))) / 6.0 - (log(1.0 - 1.0i * wx) * power_of<3>(log(((-1.0i) * (wx - xd)) / (wx * (1.0i + wx))))) / 6.0
                + trilog(wx / (wx - xd)) * (4.0 * ln2 + log(1.0 - 1.0i * wx) / 2.0 + log(1.0 + 1.0i * wx) / 2.0 + log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) + log(0.5 - (1.0i / 2.0) * xd) / 2.0 + log(0.5 + (1.0i / 2.0) * xd) / 2.0) + trilog((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * (ln2 + 2.0 * log(1.0 - 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 - 2.0 * log(1.0 - 1.0i * xd)) - power_of<4>(log(1.0 - 1.0i * xd)) / 3.0 + trilog(-1.0i / xd) * (-2.0 * ln2 - log(1.0 + 1.0i * wx) / 2.0 - log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) / 2.0 + 2.0 * log(1.0 - 1.0i * xd))
                + dilog((-1.0i + wx) / (wx - xd)) * (2.0 * ln2 * log((-1.0i + wx) / wx) + log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) - log(1.0 + 1.0i * wx) * log(1.0 - 1.0i * xd)) + dilog((-1.0i + wx) / (-1.0i + xd)) * (-(ln2 * log(1.0 + 1.0i * wx)) - log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx) - (log((-1.0i + wx) / wx) * log(1.0 - 1.0i * xd)) / 2.0) + trilog((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * (ln2 + 2.0 * log(1.0 + 1.0i * wx) + log((1.0i + wx) / wx) / 2.0 - 2.0 * log(1.0 + 1.0i * xd)) + trilog(xd / (-wx + xd)) * (-log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd))
                + power_of<3>(log(1.0i / (wx - xd))) * (ln2 / 6.0 + log(1.0 + 1.0i * wx) / 12.0 + log(1.0 - 1.0i * xd) / 6.0 - log(1.0 + 1.0i * xd) / 4.0) + power_of<3>(log(1.0i * (wx - xd))) * ((-1.0 / 6.0) * ln2 - log(1.0 - 1.0i * wx) / 12.0 + log(1.0 - 1.0i * xd) / 12.0 - log(1.0 + 1.0i * xd) / 12.0) + power_of<3>(log((-1.0i) * (wx - xd))) * ((-1.0 / 6.0) * ln2 - log(1.0 + 1.0i * wx) / 12.0 - log(1.0 - 1.0i * xd) / 12.0 + log(1.0 + 1.0i * xd) / 12.0) + power_of<3>(log(-1.0i / (wx - xd))) * (ln2 / 6.0 + log(1.0 - 1.0i * wx) / 12.0 - log(1.0 - 1.0i * xd) / 4.0 + log(1.0 + 1.0i * xd) / 6.0) - (pisqu * log((-2.0 * 1.0i) / (wx - xd)) * log(1.0 + 1.0i * xd)) / 3.0 - (power_of<3>(log((-2.0 * 1.0i) / (wx - xd))) * log(1.0 + 1.0i * xd)) / 3.0
                - (pisqu * log((2.0 * 1.0i) / (wx - xd)) * log(1.0 + 1.0i * xd)) / 3.0 - (power_of<3>(log((2.0 * 1.0i) / (wx - xd))) * log(1.0 + 1.0i * xd)) / 3.0 - power_of<4>(log(1.0 + 1.0i * xd)) / 3.0 + trilog(1.0i / xd) * (-2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 + log((-1.0i + wx) / wx) / 2.0 - log((1.0i + wx) / wx) + 2.0 * log(1.0 + 1.0i * xd)) + trilog(((-2.0 * 1.0i) * (wx - xd)) / ((1.0i + wx) * (-1.0i + xd))) * (3.0 * log(1.0 - 1.0i * xd) + 3.0 * log(1.0 + 1.0i * xd)) + trilog(((2.0 * 1.0i) * (wx - xd)) / ((-1.0i + wx) * (1.0i + xd))) * (3.0 * log(1.0 - 1.0i * xd) + 3.0 * log(1.0 + 1.0i * xd))
                + log(1.0i / (wx - xd)) * ((pisqu * ln2) / 6.0 + (pisqu * log(1.0 + 1.0i * wx)) / 12.0 + (pisqu * log(1.0 - 1.0i * xd)) / 6.0 - (pisqu * log(1.0 + 1.0i * xd)) / 4.0) + log(1.0i * (wx - xd)) * ((-1.0 / 6.0) * (pisqu * ln2) - (pisqu * log(1.0 - 1.0i * wx)) / 12.0 + (pisqu * log(1.0 - 1.0i * xd)) / 12.0 - (pisqu * log(1.0 + 1.0i * xd)) / 12.0) + log((-1.0i) * (wx - xd)) * ((-1.0 / 6.0) * (pisqu * ln2) - (pisqu * log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * log(1.0 - 1.0i * xd)) / 12.0 + (pisqu * log(1.0 + 1.0i * xd)) / 12.0) + log(-1.0i / (wx - xd)) * ((pisqu * ln2) / 6.0 + (pisqu * log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log(1.0 - 1.0i * xd)) / 4.0 + (pisqu * log(1.0 + 1.0i * xd)) / 6.0)
                + dilog((1.0i + wx) / (wx - xd)) * (2.0 * ln2 * log((1.0i + wx) / wx) + log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) - log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * xd)) + dilog(wx * xdinv) * ((ln2 + log(1.0 + 1.0i * wx)) * log(1.0 - 1.0i * xd) + (ln2 + log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * xd)) + dilog((1.0i + wx) / (1.0i + xd)) * (-(ln2 * log(1.0 - 1.0i * wx)) - log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx) - (log((1.0i + wx) / wx) * log(1.0 + 1.0i * xd)) / 2.0) + dilog(((-2.0 * 1.0i) * (wx - xd)) / ((1.0i + wx) * (-1.0i + xd))) * (-3.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) - 3.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd))
                + dilog(((2.0 * 1.0i) * (wx - xd)) / ((-1.0i + wx) * (1.0i + xd))) * (-3.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) - 3.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd)) + dilog(wx / (wx - xd)) * (dilog(0.5 - (1.0i / 2.0) * xd) / 2.0 + dilog(0.5 + (1.0i / 2.0) * xd) / 2.0 - dilog((-1.0i) * xd) / 2.0 - dilog(1.0i * xd) / 2.0 + (log(0.5 + (1.0i / 2.0) * xd) * log(1.0 - 1.0i * xd)) / 2.0 + (log(0.5 - (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd)) / 2.0) + ((-0.5) * ln2 + log(1.0 - 1.0i * wx) / 4.0 - log(1.0 + 1.0i * wx) / 3.0 - log((-1.0i + wx) / wx) / 6.0) * power_of<3>(log(-1.0i / xd))
                + ((-0.5) * ln2 - log(1.0 - 1.0i * wx) / 3.0 + log(1.0 + 1.0i * wx) / 4.0 - log((1.0i + wx) / wx) / 6.0) * power_of<3>(log(1.0i / xd)) + ((4.0 * ln2) / 3.0 + log((-1.0i + wx) / wx) / 4.0 + log((1.0i + wx) / wx) / 4.0) * power_of<3>(log(wx * xdinv)) + ((pisqu * ln2) / 12.0 + (pisqu * log((1.0i + wx) / wx)) / 12.0) * log((1.0i * wx) / ((-1.0i + wx) * xd)) + (ln2 / 12.0 + log((1.0i + wx) / wx) / 12.0) * power_of<3>(log((1.0i * wx) / ((-1.0i + wx) * xd))) + ((-1.0 / 6.0) * (pisqu * ln2) + (pisqu * log((-1.0i + wx) / wx)) / 6.0) * log((1.0i * (wx - xd)) / (wx * xd)) + ((-1.0 / 6.0) * ln2 + log((-1.0i + wx) / wx) / 6.0) * power_of<3>(log((1.0i * (wx - xd)) / (wx * xd)))
                + (log(1.0 + 1.0i * wx) * power_of<3>(log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)))) / 6.0 + (log(1.0 - 1.0i * wx) * power_of<3>(log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)))) / 6.0 + power_of<2>(log(-1.0 + wx * xdinv)) * ((-5.0 * pisqu) / 12.0 - power_of<2>(lnm2) / 8.0 - power_of<2>(log(-1.0 - 1.0i * wx)) / 16.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 16.0 - (log(1.0i / wx) * log((-1.0i + wx) / wx)) / 2.0 - (log(-1.0i / wx) * log((1.0i + wx) / wx)) / 2.0 - (log(1.0 + 1.0i * xd) * log((-1.0i) * xd)) / 2.0 - (log(1.0 - 1.0i * xd) * log(1.0i * xd)) / 2.0) + dilog(xd / (-wx + xd)) * (log(1.0 + 1.0i * xd) * log((-1.0i) * xd) + log(1.0 - 1.0i * xd) * log(1.0i * xd))
                + trilog(xd / wx) * (6.0 * ln2 + 2.0 * log((-1.0i + wx) / wx) + 2.0 * log((1.0i + wx) / wx) - log(1.0 - 1.0i * xd) / 2.0 - log(1.0 + 1.0i * xd) / 2.0 + log(xd)) + trilog(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (wx - xd))) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) + log(xd)) + trilog(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (wx - xd))) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) + log(xd)) + trilog(((1.0i + wx) * (-1.0i + xd)) / ((-1.0i + wx) * (1.0i + xd))) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) + log(xd))
                + trilog(((-1.0i + wx) * (1.0i + xd)) / ((1.0i + wx) * (-1.0i + xd))) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) + log(xd)) - (pisqu * ln2 * log((-1.0i - 1.0 / wx) * xd)) / 12.0 - (ln2 * power_of<3>(log((-1.0i - 1.0 / wx) * xd))) / 12.0 + (pisqu * ln2 * log((-1.0i + 1.0 / wx) * xd)) / 6.0 + (ln2 * power_of<3>(log((-1.0i + 1.0 / wx) * xd))) / 6.0 + (pisqu * ln2 * log((1.0i + 1.0 / wx) * xd)) / 6.0 + (ln2 * power_of<3>(log((1.0i + 1.0 / wx) * xd))) / 6.0 - (pisqu * ln2 * log((1.0i * (1.0i + wx) * xd) / wx)) / 12.0 - (ln2 * power_of<3>(log((1.0i * (1.0i + wx) * xd) / wx))) / 12.0 + (log(1.0 + 1.0i * wx) / 12.0 - log((1.0i + wx) / wx) / 12.0) * power_of<3>(log(xd / (1.0i - xd)))
                + ((pisqu * ln2) / 6.0 - (pisqu * log((-1.0i + wx) / wx)) / 6.0) * log(((-1.0i) * wx * xd) / (wx - xd)) + (ln2 / 6.0 - log((-1.0i + wx) / wx) / 6.0) * power_of<3>(log(((-1.0i) * wx * xd) / (wx - xd))) + ((pisqu * ln2) / 6.0 - (pisqu * log((1.0i + wx) / wx)) / 6.0) * log((1.0i * wx * xd) / (wx - xd)) + (ln2 / 6.0 - log((1.0i + wx) / wx) / 6.0) * power_of<3>(log((1.0i * wx * xd) / (wx - xd))) - (log(1.0 - 1.0i * wx) * power_of<3>(log((1.0i * (1.0i + wx) * xd) / (wx - xd)))) / 6.0 - power_of<4>(log(-1.0i / (-1.0i + xd))) / 3.0 + log(xd / (1.0i - xd)) * ((pisqu * log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * log((1.0i + wx) / wx)) / 12.0 + (2.0 * power_of<3>(log(-1.0i / (-1.0i + xd)))) / 3.0)
                - (pisqu * log((-1.0i + wx) / wx) * log((1.0 + 1.0i * wx) / (wx * (-1.0i + xd)))) / 6.0 - (log((-1.0i + wx) / wx) * power_of<3>(log((1.0 + 1.0i * wx) / (wx * (-1.0i + xd))))) / 6.0 + ((-1.0 / 6.0) * (pisqu * ln2) + (pisqu * log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log((1.0i + wx) / wx)) / 4.0) * log(wx / (-1.0i + xd)) + ((-1.0 / 6.0) * ln2 + log(1.0 - 1.0i * wx) / 12.0 - log((1.0i + wx) / wx) / 4.0) * power_of<3>(log(wx / (-1.0i + xd))) + (log(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (wx - xd))) * log(xd) * power_of<2>(log((-1.0i + wx) / (-1.0i + xd)))) / 2.0
                + dilog(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (wx - xd))) * (log(0.5 + (1.0i / 2.0) * xd) * (-2.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd)) + log(xd) * log((-1.0i + wx) / (-1.0i + xd))) + dilog(((1.0i + wx) * (-1.0i + xd)) / ((-1.0i + wx) * (1.0i + xd))) * (log(0.5 + (1.0i / 2.0) * xd) * (-2.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd)) + log(xd) * log((-1.0i + wx) / (-1.0i + xd))) + trilog((-1.0i + wx) / (2.0 * wx)) * ((-0.5) * lnhalf + log(0.5 + (1.0i / 2.0) * xd) / 2.0 - log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) - log(xd) + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))))
                + ((-1.0 / 12.0) * (pisqu * ln2) - (pisqu * log(1.0 - 1.0i * wx)) / 12.0) * log((1.0i * xd) / (wx * (-1.0i + xd))) + ((-1.0 / 12.0) * ln2 - log(1.0 - 1.0i * wx) / 12.0) * power_of<3>(log((1.0i * xd) / (wx * (-1.0i + xd)))) + (log((-1.0i + wx) / wx) * power_of<3>(log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))))) / 6.0 + (pisqu * ln2 * log((-1.0i + xd) / wx)) / 6.0 + (ln2 * power_of<3>(log((-1.0i + xd) / wx))) / 6.0 + trilog((1.0i * (wx - xd)) / (wx * (1.0i + xd))) * (2.0 * ln2 + 2.0 * log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx) / 2.0 + (3.0 * log((-1.0i + wx) / wx)) / 2.0 + log(1.0 - 1.0i * xd) / 2.0 + log(xd) - log((-1.0i + xd) / (-1.0i + wx)) / 2.0)
                + trilog((1.0i + xd) / (1.0i + wx)) * (lnhalf - ln2 - 2.0 * log(1.0 - 1.0i * wx) - 2.0 * log(1.0i * wx) - log((-1.0i + wx) / wx) / 2.0 - log(wx / (1.0i + wx)) + 3.0 * log((-1.0i + wx) / (1.0i + wx)) - log((1.0i + wx) / wx) - (5.0 * log(0.5 + (1.0i / 2.0) * xd)) / 2.0 - 3.0 * log(1.0 - 1.0i * xd) - 3.0 * log(1.0 + 1.0i * xd) + 3.0 * log(1.0i * xd) - log(xd) - log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 - log(xd / (-1.0i + xd)) + log((-1.0i + xd) * xdinv)) - (log((-1.0i + wx) / wx) * power_of<3>(log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)))) / 3.0 - power_of<4>(log(1.0i / (1.0i + xd))) / 3.0
                + ((-1.0 / 6.0) * (pisqu * ln2) + (pisqu * log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * log((-1.0i + wx) / wx)) / 4.0) * log(wx / (1.0i + xd)) + ((-1.0 / 6.0) * ln2 + log(1.0 + 1.0i * wx) / 12.0 - log((-1.0i + wx) / wx) / 4.0) * power_of<3>(log(wx / (1.0i + xd))) + (log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (wx - xd))) * log(xd) * power_of<2>(log((1.0i + wx) / (1.0i + xd)))) / 2.0 + dilog(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (wx - xd))) * (log(0.5 - (1.0i / 2.0) * xd) * (-2.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd)) + log(xd) * log((1.0i + wx) / (1.0i + xd)))
                + dilog(((-1.0i + wx) * (1.0i + xd)) / ((1.0i + wx) * (-1.0i + xd))) * (log(0.5 - (1.0i / 2.0) * xd) * (-2.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd)) + log(xd) * log((1.0i + wx) / (1.0i + xd))) + trilog((1.0i + wx) / (2.0 * wx)) * ((-0.5) * lnhalf + log(0.5 - (1.0i / 2.0) * xd) / 2.0 - log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) - log(xd) + log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) + power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) * (-(log(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (wx - xd))) * log(1.0 + 1.0i * xd)) - log(1.0 + 1.0i * xd) * log(((2.0 * 1.0i) * (wx - xd)) / ((-1.0i + wx) * (1.0i + xd))))
                + ((pisqu * log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log((-1.0i + wx) / wx)) / 12.0) * log(-(xd / (1.0i + xd))) + (log(1.0 - 1.0i * wx) / 12.0 - log((-1.0i + wx) / wx) / 12.0) * power_of<3>(log(-(xd / (1.0i + xd)))) + (log((1.0i + wx) / wx) * power_of<3>(log(((1.0i + wx) * xd) / (wx * (1.0i + xd))))) / 6.0 + ((ln2squ * log(1.0 - 1.0i * wx)) / 4.0 - (ln2squ * log((-1.0i + wx) / wx)) / 4.0) * log((-1.0i + xd) / (1.0i + xd)) + (pisqu * ln2 * log((1.0i + xd) / wx)) / 6.0 + (ln2 * power_of<3>(log((1.0i + xd) / wx))) / 6.0
                + trilog(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) * (2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 + 2.0 * log(1.0 + 1.0i * wx) + (3.0 * log((1.0i + wx) / wx)) / 2.0 + log(1.0 + 1.0i * xd) / 2.0 + log(xd) - log((1.0i + xd) / (1.0i + wx)) / 2.0) + trilog(1.0 - xd / wx) * (4.0 * ln2 - (3.0 * log(1.0 - 1.0i * wx)) / 2.0 - (3.0 * log(1.0 + 1.0i * wx)) / 2.0 + log(-1.0i / (-1.0i + wx)) - 3.0 * log((-1.0i + wx) / wx) + log(1.0i / (1.0i + wx)) - 3.0 * log((1.0i + wx) / wx) + log(1.0 - 1.0i * xd) / 2.0 + log(1.0 + 1.0i * xd) / 2.0 - log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 + log((-1.0i + xd) / (-1.0i + wx)) - log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i + wx)))
                + (pisqu * log((1.0i + wx) / wx) * log((1.0i * wx * (1.0i + xd)) / (1.0i + wx))) / 3.0 + (log((1.0i + wx) / wx) * power_of<3>(log((1.0i * wx * (1.0i + xd)) / (1.0i + wx)))) / 3.0 + trilog((-wx + xd) / (1.0i + xd)) * (-2.0 * ln2 - 2.0 * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 2.0 - (3.0 * log((-1.0i + wx) / wx)) / 2.0 - 2.0 * log(1.0 - 1.0i * xd) - 3.0 * log(1.0 + 1.0i * xd) - log(xd) - log(1.0i / (1.0i + xd)) / 2.0 + log((1.0i - xd) / (1.0i + xd)) / 2.0 - log((1.0i + xd) / (1.0i - xd)) / 2.0)
                + trilog((-wx + xd) / (-1.0i + xd)) * (-2.0 * ln2 + log(1.0 - 1.0i * wx) / 2.0 - 2.0 * log(1.0 + 1.0i * wx) - (3.0 * log((1.0i + wx) / wx)) / 2.0 - 3.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd) - log(xd) - log(-1.0i / (-1.0i + xd)) / 2.0 - log((1.0i - xd) / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i - xd)) / 2.0) + power_of<4>(log(-((1.0i + xd) * xdinv))) / 24.0
                + dilog(xd / wx) * ((-5.0 * pisqu) / 6.0 + dilog(-1.0i / (-1.0i + xd)) + dilog(1.0i / (1.0i + xd)) - 2.0 * dilog((1.0i - xd) / (1.0i + xd)) - 2.0 * dilog((1.0i + xd) / (1.0i - xd)) - power_of<2>(lnm2) / 2.0 - power_of<2>(log(-1.0 + 1.0i / wx)) / 2.0 - ln2 * log(1.0 - 1.0i * wx) - power_of<2>(log(1.0 - 1.0i * wx)) - ln2 * log(1.0 + 1.0i * wx) - power_of<2>(log(1.0 + 1.0i * wx)) + log(0.5 - (1.0i / 2.0) * wx) * log((-1.0i + wx) / wx) - (3.0 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 - log((-1.0i + wx) / wx) * log((2.0 * 1.0i) / (1.0i + wx)) - power_of<2>(log(-((1.0i + wx) / wx))) / 2.0 - log((-1.0i + wx) / wx) * log((1.0i + wx) / (2.0 * wx)) + log(0.5 + (1.0i / 2.0) * wx) * log((1.0i + wx) / wx)
                - log((-2.0 * 1.0i) / (-1.0i + wx)) * log((1.0i + wx) / wx) - log((-1.0i + wx) / (2.0 * wx)) * log((1.0i + wx) / wx) - (3.0 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - power_of<2>(log(-1.0 - 1.0i * xd)) / 2.0 + power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 - power_of<2>(log(-1.0 + 1.0i * xd)) / 2.0 + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log(1.0 - 1.0i * xd) * (log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) + log(0.5 + (1.0i / 2.0) * xd) / 2.0 - 2.0 * log(1.0 + 1.0i * xd) + 2.0 * log(1.0i * xd) + log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 - log((2.0 * xd) / (-1.0i + xd)) + log((-1.0i + xd) / (2.0 * xd)))
                + log(1.0 + 1.0i * xd) * (log(1.0 - 1.0i * wx) - log((1.0i + wx) / wx) + log(0.5 - (1.0i / 2.0) * xd) / 2.0 + 2.0 * log((-1.0i) * xd) + log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 - log((2.0 * xd) / (1.0i + xd)) + log((1.0i + xd) / (2.0 * xd)))) + trilog((-1.0i + xd) / (-1.0i + wx)) * (lnhalf - ln2 - 2.0 * log(1.0 + 1.0i * wx) - 2.0 * log((-1.0i) * wx) - log(wx / (-1.0i + wx)) - log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) / 2.0 + 3.0 * log((1.0i + wx) / (-1.0i + wx)) - (5.0 * log(0.5 - (1.0i / 2.0) * xd)) / 2.0 - 3.0 * log(1.0 - 1.0i * xd) - 3.0 * log(1.0 + 1.0i * xd) + 3.0 * log((-1.0i) * xd) - log(xd) - log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 - log(xd / (1.0i + xd))
                + log((1.0i + xd) * xdinv)) + ((pisqu * ln2) / 12.0 + (pisqu * log(1.0 + 1.0i * wx)) / 12.0) * log((1.0i * wx * (1.0i + xd)) * xdinv) + (ln2 / 12.0 + log(1.0 + 1.0i * wx) / 12.0) * power_of<3>(log((1.0i * wx * (1.0i + xd)) * xdinv)) - (log((1.0i + wx) / wx) * power_of<3>(log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)))) / 3.0 + ((ln2squ * log(1.0 + 1.0i * wx)) / 4.0 - (ln2squ * log((1.0i + wx) / wx)) / 4.0) * log((1.0i + xd) / (-1.0i + xd)) + ((-0.25) * (ln2 * power_of<2>(log(1.0 + 1.0i * wx))) - (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 - (ln2 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0) * log((-wx + xd) / (-1.0i + xd))
                + ((-0.25) * (ln2 * power_of<2>(log(1.0 - 1.0i * wx))) - (power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * wx)) / 4.0 - (ln2 * power_of<2>(log((1.0i + wx) / wx))) / 2.0) * log((-wx + xd) / (1.0i + xd)) + trilog(-1.0i / wx) * ((-0.5) * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 + 8.0 * log(1.0 - 1.0i * xd) + (5.0 * log(1.0 + 1.0i * xd)) / 2.0 + log(xd) - 4.0 * log(1.0 - xd / wx)) + trilog(1.0i / wx) * ((-0.5) * log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx) / 2.0 + (5.0 * log(1.0 - 1.0i * xd)) / 2.0 + 8.0 * log(1.0 + 1.0i * xd) + log(xd) - 4.0 * log(1.0 - xd / wx))
                + trilog(1.0i * wx) * (-ln2 + (5.0 * log(1.0 - 1.0i * xd)) / 2.0 - (3.0 * log(1.0 + 1.0i * xd)) / 2.0 - 3.0 * log(1.0 - xd / wx)) + trilog((-1.0i) * wx) * (-ln2 - (3.0 * log(1.0 - 1.0i * xd)) / 2.0 + (5.0 * log(1.0 + 1.0i * xd)) / 2.0 - 3.0 * log(1.0 - xd / wx)) + dilog((-1.0i + xd) / (2.0 * xd)) * log(1.0 + 1.0i * xd) * (-log(1.0 - 1.0i * wx) + log((-1.0i + wx) / wx) - 2.0 * log(1.0 - xd / wx)) + dilog((1.0i - xd) / (1.0i + xd)) * log(1.0 + 1.0i * xd) * ((-3.0 * log(1.0 + 1.0i * wx)) / 2.0 + log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) / 2.0 - 2.0 * log(1.0 - xd / wx))
                + dilog((1.0i + xd) / (2.0 * xd)) * log(1.0 - 1.0i * xd) * (-log(1.0 + 1.0i * wx) + log((1.0i + wx) / wx) - 2.0 * log(1.0 - xd / wx)) + dilog((1.0i + xd) / (1.0i - xd)) * log(1.0 - 1.0i * xd) * ((-3.0 * log(1.0 - 1.0i * wx)) / 2.0 + log((-1.0i + wx) / wx) / 2.0 + log((1.0i + wx) / wx) - 2.0 * log(1.0 - xd / wx)) + trilog(1.0i * xd) * (-ln2 + log(1.0 - 1.0i * wx) / 2.0 - (3.0 * log(1.0 + 1.0i * wx)) / 2.0 - log((1.0i + wx) / wx) - log(1.0 - 1.0i * xd) / 2.0 - (5.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(xd) - log(1.0 - xd / wx))
                + trilog((-1.0i) * xd) * (-ln2 - (3.0 * log(1.0 - 1.0i * wx)) / 2.0 + log(1.0 + 1.0i * wx) / 2.0 - log((-1.0i + wx) / wx) - (5.0 * log(1.0 - 1.0i * xd)) / 2.0 - log(1.0 + 1.0i * xd) / 2.0 - log(xd) - log(1.0 - xd / wx)) + trilog((wx - 1.0i * wx * xd) / (wx - xd)) * (-2.0 * ln2 - log(1.0 + 1.0i * wx) - 3.0 * log((1.0i + wx) / wx) - log(0.5 + (1.0i / 2.0) * xd) / 2.0 - log(1.0 - 1.0i * xd) / 2.0 + log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 - log(1.0 - xd / wx))
                + trilog((wx + 1.0i * wx * xd) / (wx - xd)) * (-2.0 * ln2 - log(1.0 - 1.0i * wx) - 3.0 * log((-1.0i + wx) / wx) - log(0.5 - (1.0i / 2.0) * xd) / 2.0 - log(1.0 + 1.0i * xd) / 2.0 + log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 - log(1.0 - xd / wx)) + trilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * (-lnhalf - ln2 - 3.0 * log((-1.0i + wx) / wx) - log(1.0i / (1.0i + wx)) - log(1.0 - 1.0i * xd) / 2.0 + log(1.0 + 1.0i * xd) / 2.0 + (5.0 * log(-1.0i / (-1.0i + xd))) / 2.0 + log((1.0i - xd) / (1.0i + xd)) / 2.0 - log((1.0i + xd) / (1.0i - xd)) / 2.0 - log(1.0 - xd / wx))
                + trilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * (-lnhalf - ln2 - log(-1.0i / (-1.0i + wx)) - 3.0 * log((1.0i + wx) / wx) + log(1.0 - 1.0i * xd) / 2.0 - log(1.0 + 1.0i * xd) / 2.0 + (5.0 * log(1.0i / (1.0i + xd))) / 2.0 - log((1.0i - xd) / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i - xd)) / 2.0 - log(1.0 - xd / wx)) + power_of<3>(log(wx / (wx - xd))) * ((-2.0 * log(xd / (wx - xd))) / 3.0 - log(1.0 - xd / wx) / 3.0) + power_of<3>(log(-1.0i / (-1.0i + xd))) * ((-1.0 / 6.0) * log(1.0 - 1.0i * wx) + log((-1.0i + wx) / wx) / 12.0 + log((1.0i + wx) / wx) / 6.0 - log(1.0 - xd / wx) / 4.0)
                + power_of<3>(log(1.0i / (1.0i + xd))) * ((-1.0 / 6.0) * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) / 6.0 + log((1.0i + wx) / wx) / 12.0 + (2.0 * log(-(xd / (1.0i + xd)))) / 3.0 - log(1.0 - xd / wx) / 4.0) + power_of<3>(log((1.0i * wx * (1.0i + wx)) / (wx - xd))) * (log(1.0 - 1.0i * wx) / 6.0 - log(1.0 - xd / wx) / 6.0) + power_of<3>(log(((-1.0 - 1.0i * wx) * wx) / (wx - xd))) * (log(1.0 + 1.0i * wx) / 6.0 - log(1.0 - xd / wx) / 6.0) + power_of<3>(log((-2.0 * 1.0i) * xd)) * ((-1.0 / 12.0) * log(1.0 - 1.0i * wx) - log(1.0 - xd / wx) / 12.0) + power_of<3>(log((2.0 * 1.0i) * xd)) * ((-1.0 / 12.0) * log(1.0 + 1.0i * wx) - log(1.0 - xd / wx) / 12.0)
                + power_of<3>(log(1.0i / 2.0 * xdinv)) * (log(1.0 - 1.0i * wx) / 12.0 - log((-1.0i + wx) / wx) / 6.0 + log(1.0 - xd / wx) / 4.0) + power_of<3>(log(((-0.5) * 1.0i) * xdinv)) * (log(1.0 + 1.0i * wx) / 12.0 - log((1.0i + wx) / wx) / 6.0 + log(1.0 - xd / wx) / 4.0) + (pisqu * log(wx / (1.0i - xd)) * log(1.0 - xd / wx)) / 6.0 + (power_of<3>(log(wx / (1.0i - xd))) * log(1.0 - xd / wx)) / 6.0 + (power_of<3>(log((-1.0i + wx) / (wx - xd))) * log(1.0 - xd / wx)) / 6.0 + (power_of<3>(log((1.0i + wx) / (wx - xd))) * log(1.0 - xd / wx)) / 6.0 + (pisqu * log(-(wx / (1.0i + xd))) * log(1.0 - xd / wx)) / 6.0 + (power_of<3>(log(-(wx / (1.0i + xd)))) * log(1.0 - xd / wx)) / 6.0 + power_of<4>(log(1.0 - xd / wx)) / 3.0
                + trilog((-1.0i + wx) / (-1.0i + xd)) * (ln2 + log(1.0 - 1.0i * wx) + log(1.0 - 1.0i * xd) / 2.0 - log(xd) + log(1.0 - xd / wx)) + trilog((1.0i + wx) / (1.0i + xd)) * (ln2 + log(1.0 + 1.0i * wx) + log(1.0 + 1.0i * xd) / 2.0 - log(xd) + log(1.0 - xd / wx)) + trilog((1.0i - xd) / (1.0i + xd)) * ((3.0 * log(1.0 + 1.0i * wx)) / 2.0 - log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) / 2.0 - log((-1.0i + wx) / (wx - xd)) + log((wx - xd) / (-1.0i + wx)) + 2.0 * log(1.0 - xd / wx))
                + trilog((1.0i + xd) / (1.0i - xd)) * ((3.0 * log(1.0 - 1.0i * wx)) / 2.0 - log((-1.0i + wx) / wx) / 2.0 - log((1.0i + wx) / wx) - log((1.0i + wx) / (wx - xd)) + log((wx - xd) / (1.0i + wx)) + 2.0 * log(1.0 - xd / wx)) + trilog((-2.0 * 1.0i) / (-1.0i + wx)) * (log(wx / (-1.0i + wx)) - log((wx - xd) / (-1.0i + wx)) + log(1.0 - 1.0i * xd) + 3.0 * log(1.0 + 1.0i * xd) - log((1.0i - xd) / (1.0i + xd)) / 2.0 + 2.0 * log(1.0 - xd / wx)) + trilog((2.0 * 1.0i) / (1.0i + wx)) * (log(wx / (1.0i + wx)) - log((wx - xd) / (1.0i + wx)) + 3.0 * log(1.0 - 1.0i * xd) + log(1.0 + 1.0i * xd) - log((1.0i + xd) / (1.0i - xd)) / 2.0 + 2.0 * log(1.0 - xd / wx))
                + trilog(-1.0) * (log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) + log(1.0 - 1.0i * xd) + log(1.0 + 1.0i * xd) + 2.0 * log(xd) + 8.0 * log(1.0 - xd / wx)) + log((1.0i * wx * (1.0i + wx)) / (wx - xd)) * ((pisqu * log(1.0 - 1.0i * wx)) / 6.0 - (pisqu * log(1.0 - xd / wx)) / 6.0) + log(((-1.0 - 1.0i * wx) * wx) / (wx - xd)) * ((pisqu * log(1.0 + 1.0i * wx)) / 6.0 - (pisqu * log(1.0 - xd / wx)) / 6.0) + log((-2.0 * 1.0i) * xd) * ((-1.0 / 12.0) * (pisqu * log(1.0 - 1.0i * wx)) - (pisqu * log(1.0 - xd / wx)) / 12.0) + log((2.0 * 1.0i) * xd) * ((-1.0 / 12.0) * (pisqu * log(1.0 + 1.0i * wx)) - (pisqu * log(1.0 - xd / wx)) / 12.0)
                + log(1.0i / 2.0 * xdinv) * ((pisqu * log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log((-1.0i + wx) / wx)) / 6.0 + (pisqu * log(1.0 - xd / wx)) / 4.0) + log(((-0.5) * 1.0i) * xdinv) * ((pisqu * log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * log((1.0i + wx) / wx)) / 6.0 + (pisqu * log(1.0 - xd / wx)) / 4.0) + dilog((-2.0 * 1.0i) / (-1.0i + wx)) * (dilog((-1.0i) * xd) / 2.0 - dilog(1.0i * xd) + dilog((-1.0i + xd) / (-1.0i + wx)) - dilog((2.0 * xd) / (1.0i + xd)) / 4.0 - 2.0 * power_of<2>(log(1.0 - 1.0i * xd)) + log(1.0 - 1.0i * xd) * (-ln2 - 2.0 * log(1.0 + 1.0i * xd)) + 3.0 * log(0.5 - (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd) - 2.0 * ln2 * log(1.0 - xd / wx))
                + dilog((2.0 * 1.0i) / (1.0i + wx)) * (-dilog((-1.0i) * xd) + dilog(1.0i * xd) / 2.0 - dilog((2.0 * xd) / (-1.0i + xd)) / 4.0 + dilog((1.0i + xd) / (1.0i + wx)) + 3.0 * log(0.5 + (1.0i / 2.0) * xd) * log(1.0 - 1.0i * xd) - ln2 * log(1.0 + 1.0i * xd) - 2.0 * log(1.0 - 1.0i * xd) * log(1.0 + 1.0i * xd) - 2.0 * power_of<2>(log(1.0 + 1.0i * xd)) - 2.0 * ln2 * log(1.0 - xd / wx)) + dilog((2.0 * 1.0i) / (1.0i + xd)) * ((ln2 * log(1.0 - 1.0i * wx)) / 2.0 - (ln2 * log((-1.0i + wx) / wx)) / 2.0 + 2.0 * ln2 * log(1.0 - xd / wx)) + dilog((-2.0 * 1.0i) / (-1.0i + xd)) * ((ln2 * log(1.0 + 1.0i * wx)) / 2.0 - (ln2 * log((1.0i + wx) / wx)) / 2.0 + 2.0 * ln2 * log(1.0 - xd / wx))
                + dilog((2.0 * wx) / (-1.0i + wx)) * (pisqu / 24.0 + dilog((-1.0i + wx) / wx) / 4.0 + dilog((wx - xd) / (-1.0i + wx)) / 2.0 - dilog(1.0i * xd) / 2.0 + dilog((2.0 * xd) / (-1.0i + xd)) / 4.0 + power_of<2>(log(-1.0 + 1.0i / wx)) / 8.0 + ln2 * log(1.0 - 1.0i * xd) + 2.0 * ln2 * log(1.0 - xd / wx)) + dilog((2.0 * wx) / (1.0i + wx)) * (pisqu / 24.0 + dilog((1.0i + wx) / wx) / 4.0 + dilog((wx - xd) / (1.0i + wx)) / 2.0 - dilog((-1.0i) * xd) / 2.0 + dilog((2.0 * xd) / (1.0i + xd)) / 4.0 + power_of<2>(log(-((1.0i + wx) / wx))) / 8.0 + ln2 * log(1.0 + 1.0i * xd) + 2.0 * ln2 * log(1.0 - xd / wx))
                + dilog(-1.0i / xd) * (((-0.5) * log(1.0 + 1.0i * wx) + log((1.0i + wx) / wx) / 2.0) * log(1.0 + 1.0i * xd) + (-2.0 * ln2 - log((-1.0i + wx) / wx)) * log(1.0 - xd / wx)) + dilog((1.0i - wx) / (1.0i + wx)) * ((-1.0 / 12.0) * pisqu + dilog((-1.0i) * xd) - dilog((1.0i + xd) / (1.0i + wx)) - dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 4.0 + (2.0 * lnhalf - log((-1.0i + wx) / wx) / 2.0) * log(1.0 - 1.0i * xd) + (2.0 * lnhalf - (3.0 * log(1.0 + 1.0i * wx)) / 2.0 + log((-1.0i + wx) / wx)) * log(1.0 + 1.0i * xd) - log(1.0 - 1.0i * wx) * log(xd) + (log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx)) * log(1.0 - xd / wx))
                + dilog((-1.0i + wx) / (2.0 * wx)) * (dilog(0.5 - (1.0i / 2.0) * xd) / 4.0 - dilog(xd / wx) + dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) / 2.0 + (2.0 * lnhalf - log(1.0 + 1.0i * wx)) * log(1.0 - 1.0i * xd) + (2.0 * lnhalf + log(1.0 + 1.0i * wx) - 2.0 * log((-1.0i + wx) / wx)) * log(1.0 + 1.0i * xd) - log(1.0 - 1.0i * wx) * log(xd) + (-log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx)) * log(1.0 - xd / wx)) + dilog(1.0i / xd) * (((-0.5) * log(1.0 - 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0) * log(1.0 - 1.0i * xd) + (-2.0 * ln2 - log((1.0i + wx) / wx)) * log(1.0 - xd / wx))
                + dilog((1.0i + wx) / (1.0i - wx)) * ((-1.0 / 12.0) * pisqu + dilog(1.0i * xd) - dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 - dilog((-1.0i + xd) / (-1.0i + wx)) - power_of<2>(log(-1.0 - 1.0i * wx)) / 4.0 + (2.0 * lnhalf - (3.0 * log(1.0 - 1.0i * wx)) / 2.0 + log((1.0i + wx) / wx)) * log(1.0 - 1.0i * xd) + (2.0 * lnhalf - log((1.0i + wx) / wx) / 2.0) * log(1.0 + 1.0i * xd) - log(1.0 + 1.0i * wx) * log(xd) + (log(1.0 - 1.0i * wx) - log((1.0i + wx) / wx)) * log(1.0 - xd / wx))
                + dilog((1.0i + wx) / (2.0 * wx)) * (dilog(0.5 + (1.0i / 2.0) * xd) / 4.0 - dilog(xd / wx) + dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) / 2.0 + (2.0 * lnhalf + log(1.0 - 1.0i * wx) - 2.0 * log((1.0i + wx) / wx)) * log(1.0 - 1.0i * xd) + (2.0 * lnhalf - log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * xd) - log(1.0 + 1.0i * wx) * log(xd) + (-log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx)) * log(1.0 - xd / wx))
                + dilog((1.0i * (wx - xd)) / (wx * (1.0i + xd))) * (log((1.0i + wx) / (wx - xd)) * log(1.0 - 1.0i * xd) + log(1.0 - 1.0i * xd) * (log((wx - xd) / (1.0i + wx)) - log(1.0 - xd / wx) / 2.0) + (-2.0 * ln2 + log(1.0 + 1.0i * wx) / 2.0 - (3.0 * log((-1.0i + wx) / wx)) / 2.0 - log(xd)) * log(1.0 - xd / wx)) + dilog(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) * (log((-1.0i + wx) / (wx - xd)) * log(1.0 + 1.0i * xd) + log(1.0 + 1.0i * xd) * (log((wx - xd) / (-1.0i + wx)) - log(1.0 - xd / wx) / 2.0) + (-2.0 * ln2 + log(1.0 - 1.0i * wx) / 2.0 - (3.0 * log((1.0i + wx) / wx)) / 2.0 - log(xd)) * log(1.0 - xd / wx))
                + dilog((-wx + xd) / (1.0i + xd)) * (pisqu / 24.0 + 2.0 * log(1.0 - 1.0i * wx) * log(1.0i * wx) - log((1.0i + wx) / (wx - xd)) * log(1.0 - 1.0i * xd) + 3.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + power_of<2>(log(-((1.0i + xd) * xdinv))) / 8.0 + log(1.0 - 1.0i * xd) * (log((wx - xd) / (1.0i + wx)) + log(1.0 - xd / wx) / 2.0) + (2.0 * ln2 - log(1.0 + 1.0i * wx) / 2.0 + (3.0 * log((-1.0i + wx) / wx)) / 2.0 + log(xd)) * log(1.0 - xd / wx))
                + dilog((-wx + xd) / (-1.0i + xd)) * (pisqu / 24.0 + 2.0 * log(1.0 + 1.0i * wx) * log((-1.0i) * wx) + power_of<2>(log(-1.0 + 1.0i / xd)) / 8.0 + 3.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) - log((-1.0i + wx) / (wx - xd)) * log(1.0 + 1.0i * xd) + log(1.0 + 1.0i * xd) * (log((wx - xd) / (-1.0i + wx)) + log(1.0 - xd / wx) / 2.0) + (2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 + (3.0 * log((1.0i + wx) / wx)) / 2.0 + log(xd)) * log(1.0 - xd / wx))
                + dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * ((13.0 * pisqu) / 24.0 - (3.0 * dilog((-1.0i + xd) * xdinv)) / 4.0 - dilog((1.0i + xd) / (-1.0i + xd)) + ln2 * log(1.0 + 1.0i * wx) + log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx) + lnhalf * log((-1.0i + wx) / wx) - log(1.0 - 1.0i * wx) * log((-1.0i + wx) / wx) + (3.0 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + log((-1.0i + wx) / wx) * log(1.0i / (1.0i + wx)) + power_of<2>(log(-((1.0i + wx) / wx))) / 2.0 - (3.0 * power_of<2>(log(-1.0 + 1.0i / xd))) / 8.0 + (log((-1.0i + wx) / wx) * log(1.0 - 1.0i * xd)) / 2.0 - 2.0 * log(1.0 + 1.0i * xd) * log((-1.0i) * xd) + log(xd / wx) * log(1.0 - xd / wx))
                + dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * ((13.0 * pisqu) / 24.0 - dilog((-1.0i + xd) / (1.0i + xd)) - (3.0 * dilog((1.0i + xd) * xdinv)) / 4.0 + power_of<2>(log(-1.0 + 1.0i / wx)) / 2.0 + ln2 * log(1.0 - 1.0i * wx) + log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx) + lnhalf * log((1.0i + wx) / wx) - log(1.0 + 1.0i * wx) * log((1.0i + wx) / wx) + log(-1.0i / (-1.0i + wx)) * log((1.0i + wx) / wx) + (3.0 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (log((1.0i + wx) / wx) * log(1.0 + 1.0i * xd)) / 2.0 - 2.0 * log(1.0 - 1.0i * xd) * log(1.0i * xd) - (3.0 * power_of<2>(log(-((1.0i + xd) * xdinv)))) / 8.0 + log(xd / wx) * log(1.0 - xd / wx))
                + dilog((-1.0i + xd) / (-wx + xd)) * (-3.0 * log(1.0i / wx) * log((-1.0i + wx) / wx) + (-2.0 * ln2 - log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * xd) - power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log(0.5 + (1.0i / 2.0) * xd) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd)) - log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx)) + dilog((wx + 1.0i * wx * xd) / (wx - xd)) * ((2.0 * ln2 + log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * xd) + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx))
                + power_of<2>(log(xd / wx)) * ((-0.5) * (log(-1.0i / (-1.0i + xd)) * log(1.0 - xd / wx)) + (log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) * log(1.0 - xd / wx)) / 2.0 - (log(1.0i / (1.0i + xd)) * log(1.0 - xd / wx)) / 2.0 + (log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) * log(1.0 - xd / wx)) / 2.0) + dilog(-((1.0i + xd) / (wx - xd))) * (dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 4.0 - 3.0 * log(-1.0i / wx) * log((1.0i + wx) / wx) + (-2.0 * ln2 - log(1.0 + 1.0i * wx) + 2.0 * log(0.5 - (1.0i / 2.0) * xd)) * log(1.0 - 1.0i * xd) - power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 + 2.0 * log(0.5 - (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd) - log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx))
                + dilog((wx - 1.0i * wx * xd) / (wx - xd)) * ((2.0 * ln2 + log(1.0 + 1.0i * wx)) * log(1.0 - 1.0i * xd) + power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 + log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx)) + log((1.0i * (1.0i + wx) * xd) / (wx - xd)) * ((-1.0 / 6.0) * (pisqu * log(1.0 - 1.0i * wx)) + (log(1.0 - 1.0i * wx) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + xd))))) / 2.0 + (power_of<2>(log((1.0i + xd) / (1.0i + wx))) * log(1.0 - xd / wx)) / 2.0)
                + dilog((1.0i + xd) / (-1.0i + xd)) * ((-1.0 / 12.0) * pisqu - power_of<2>(log(-1.0 + 1.0i / xd)) / 4.0 - log(xd) * log((1.0i + wx) / (1.0i + xd)) + log(1.0 - 1.0i * xd) * ((3.0 * log(1.0 - 1.0i * wx)) / 2.0 - log((-1.0i + wx) / wx) / 2.0 - log((1.0i + wx) / wx) + 2.0 * log(1.0 - xd / wx))) + dilog((-1.0i + xd) / (1.0i + xd)) * ((-1.0 / 12.0) * pisqu - dilog((1.0i + xd) * xdinv) / 2.0 - log(xd) * log((-1.0i + wx) / (-1.0i + xd)) - power_of<2>(log(-((1.0i + xd) * xdinv))) / 4.0 + log(1.0 + 1.0i * xd) * ((3.0 * log(1.0 + 1.0i * wx)) / 2.0 - log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) / 2.0 + 2.0 * log(1.0 - xd / wx)))
                + ((2.0 * pisqu * ln2) / 3.0 + (pisqu * log(1.0 - 1.0i * wx)) / 12.0 + (pisqu * log(1.0 + 1.0i * wx)) / 12.0) * log(-1.0 + xd / wx) + ((-1.0 / 24.0) * pisqu - power_of<2>(lnm2) / 8.0) * power_of<2>(log(-1.0 + xd / wx)) + ((2.0 * ln2) / 3.0 + log(1.0 - 1.0i * wx) / 12.0 + log(1.0 + 1.0i * wx) / 12.0) * power_of<3>(log(-1.0 + xd / wx)) + (pisqu * log(1.0 + 1.0i * wx) * log((1.0i * xd) / (1.0i * wx - wx * xd))) / 6.0 + (log(1.0 + 1.0i * wx) * power_of<3>(log((1.0i * xd) / (1.0i * wx - wx * xd)))) / 6.0 + ((-1.0 / 6.0) * (pisqu * ln2) - (pisqu * log(1.0 - 1.0i * wx)) / 12.0) * log((1.0i * wx) / (1.0i * xd - wx * xd)) + ((-1.0 / 6.0) * ln2 - log(1.0 - 1.0i * wx) / 12.0) * power_of<3>(log((1.0i * wx) / (1.0i * xd - wx * xd)))
                + trilog((1.0i + wx) / (-1.0i + wx)) * (log(1.0 + 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) / 2.0 + (5.0 * log(1.0 - 1.0i * xd)) / 2.0 - log(1.0 + 1.0i * xd) / 2.0 - log((-1.0i + wx) / (-1.0i + xd)) / 2.0 + log((-1.0i + xd) / (-1.0i + wx)) / 2.0 + log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - log((wx - 1.0i * wx * xd) / (wx - xd))) + trilog((-1.0i + xd) / (-wx + xd)) * (2.0 * ln2 + log(1.0 - 1.0i * wx) + 3.0 * log((-1.0i + wx) / wx) - log(wx / (wx - xd)) / 2.0 - 2.0 * log(1.0 - 1.0i * xd) - (3.0 * log(1.0 + 1.0i * xd)) / 2.0 + log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0)
                + trilog((-1.0i + xd) / (1.0i + xd)) * ((-3.0 * log(1.0 + 1.0i * wx)) / 2.0 + log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) / 2.0 - log(1.0 - 1.0i * xd) - log(xd) + log(1.0i / (1.0i + xd)) - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - 2.0 * log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd))) + dilog((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * ((-ln2 - log((-1.0i + wx) / wx) / 2.0) * log(1.0 - 1.0i * xd) + 2.0 * power_of<2>(log(1.0 - 1.0i * xd)) + log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd)))
                + dilog((1.0i + xd) / (1.0i + wx)) * (pisqu / 12.0 + dilog((1.0i + xd) / (1.0i - xd)) - power_of<2>(log(-1.0 + 1.0i * wx)) / 4.0 + power_of<2>(log(-1.0 - 1.0i * xd)) / 2.0 - (3.0 * power_of<2>(log(1.0 - 1.0i * xd))) / 2.0 + 2.0 * log(0.5 - (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd) + (3.0 * power_of<2>(log(1.0 + 1.0i * xd))) / 2.0 + log(1.0 - 1.0i * xd) * (-lnhalf + ln2 + log((-1.0i + wx) / wx) / 2.0 + 2.0 * log(0.5 - (1.0i / 2.0) * xd) + log(xd / (-1.0i + xd)) - log((-1.0i + xd) * xdinv)) - log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd)))
                + dilog(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) * (2.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) + 2.0 * log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + (2.0 * ln2 + log(1.0 + 1.0i * wx) / 2.0 - (3.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(xd)) * log(1.0 - xd / wx) - log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd))) + log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) * ((pisqu * log(1.0 - 1.0i * wx)) / 6.0 - (log(1.0 - 1.0i * wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0)
                + log((wx - xd) / (1.0i + wx)) * ((power_of<2>(log(-1.0i / wx)) * log((1.0i + wx) / wx)) / 2.0 - power_of<3>(log(1.0 - 1.0i * xd)) + power_of<2>(log(0.5 - (1.0i / 2.0) * xd)) * log(1.0 + 1.0i * xd) + 2.0 * log(0.5 - (1.0i / 2.0) * xd) * power_of<2>(log(1.0 + 1.0i * xd)) + log(1.0 - 1.0i * xd) * ((-1.0 / 6.0) * pisqu + power_of<2>(log(0.5 - (1.0i / 2.0) * xd)) + 2.0 * log(0.5 - (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd) - power_of<2>(log(1.0 + 1.0i * xd)) / 2.0) + power_of<2>(log(1.0 - 1.0i * xd)) * ((-0.5) * lnhalf + (3.0 * ln2) / 4.0 + log(1.0 + 1.0i * wx) / 4.0 + log((-1.0i + wx) / wx) / 4.0 - log(1.0 + 1.0i * xd) - log(xd) / 2.0 - log(xd / wx) / 2.0 + log(xd / (-1.0i + xd)) / 2.0 + (3.0 * log((-1.0i + xd) / (-1.0i + wx))) / 2.0)
                + (log(1.0 - 1.0i * wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0) + log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * ((pisqu * log((1.0i + wx) / wx)) / 6.0 + (-ln2 + log(1.0 + 1.0i * wx) / 4.0 - (3.0 * log((-1.0i + wx) / wx)) / 4.0) * power_of<2>(log(1.0 - xd / wx)) - (log((1.0i + wx) / wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0) + log((1.0i + wx) / (1.0i + xd)) * ((log(1.0 - 1.0i * wx) * power_of<2>(log(1.0i * wx))) / 2.0 + (ln2 - log(1.0 + 1.0i * wx) / 4.0 + (3.0 * log((-1.0i + wx) / wx)) / 4.0) * power_of<2>(log(1.0 - xd / wx)) + (log((1.0i + wx) / wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0) + (pisqu * log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (1.0i - wx))) / 3.0
                + (log((-1.0i + wx) / wx) * power_of<3>(log((wx + 1.0i * wx * xd) / (1.0i - wx)))) / 3.0 + trilog((-1.0i + wx) / (1.0i + wx)) * (log(1.0 - 1.0i * wx) / 2.0 - log(1.0i / (1.0i + wx)) / 2.0 - log(1.0 - 1.0i * xd) / 2.0 + (5.0 * log(1.0 + 1.0i * xd)) / 2.0 + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log((1.0i + wx) / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i + wx)) / 2.0 - log((wx + 1.0i * wx * xd) / (wx - xd))) + trilog(-((1.0i + xd) / (wx - xd))) * (2.0 * ln2 + log(1.0 + 1.0i * wx) + 3.0 * log((1.0i + wx) / wx) - log(wx / (wx - xd)) / 2.0 - (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - 2.0 * log(1.0 + 1.0i * xd) + log(1.0 - xd / wx) + log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0)
                + trilog((1.0i + xd) / (-1.0i + xd)) * ((-3.0 * log(1.0 - 1.0i * wx)) / 2.0 + log((-1.0i + wx) / wx) / 2.0 + log((1.0i + wx) / wx) - log(1.0 + 1.0i * xd) - log(xd) + log(-1.0i / (-1.0i + xd)) - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - 2.0 * log(1.0 - xd / wx) + log((wx + 1.0i * wx * xd) / (wx - xd))) + dilog((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * ((-ln2 - log((1.0i + wx) / wx) / 2.0) * log(1.0 + 1.0i * xd) + 2.0 * power_of<2>(log(1.0 + 1.0i * xd)) + log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd)))
                + dilog(1.0 - wx * xdinv) * ((-0.5) * pisqu + dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - power_of<2>(lnm2) / 4.0 - power_of<2>(log(-1.0 - 1.0i * wx)) / 8.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 8.0 - log(1.0i / wx) * log((-1.0i + wx) / wx) - log(-1.0i / wx) * log((1.0i + wx) / wx) - 2.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) - 2.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))
                + (-8.0 * ln2 - (3.0 * log((-1.0i + wx) / wx)) / 2.0 - (3.0 * log((1.0i + wx) / wx)) / 2.0) * log(1.0 - xd / wx) + log(1.0 + 1.0i * xd) * (-log((-1.0i) * xd) + log(1.0 - xd / wx)) + log(1.0 - 1.0i * xd) * (-log(1.0i * xd) + log(1.0 - xd / wx)) - log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) - log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd)))
                + dilog((-1.0i + xd) / (-1.0i + wx)) * (pisqu / 12.0 - dilog(1.0i / (1.0i + xd)) + dilog((1.0i - xd) / (1.0i + xd)) - power_of<2>(log(-1.0 - 1.0i * wx)) / 4.0 + (3.0 * power_of<2>(log(1.0 - 1.0i * xd))) / 2.0 + power_of<2>(log(-1.0 + 1.0i * xd)) / 2.0 - (3.0 * power_of<2>(log(1.0 + 1.0i * xd))) / 2.0 + log(0.5 + (1.0i / 2.0) * xd) * (2.0 * log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd)) - log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + log(1.0 + 1.0i * xd) * (-lnhalf + ln2 + log((1.0i + wx) / wx) / 2.0 + log(xd / (1.0i + xd)) - log((1.0i + xd) * xdinv)) + log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd)))
                + dilog((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) * (2.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + 2.0 * log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + (2.0 * ln2 + log(1.0 - 1.0i * wx) / 2.0 - (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - log(xd)) * log(1.0 - xd / wx) - log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)))
                + dilog(1.0 - xd / wx) * ((-1.0 / 12.0) * pisqu - power_of<2>(lnm2) / 4.0 - log((1.0i + wx) / (wx - xd)) * log(1.0 - 1.0i * xd) - power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 - log((-1.0i + wx) / (wx - xd)) * log(1.0 + 1.0i * xd) - power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log(1.0 - 1.0i * xd) * (-log((wx - xd) / (1.0i + wx)) + log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0) + 2.0 * log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + log(1.0 + 1.0i * xd) * (-log((wx - xd) / (-1.0i + wx)) + log((2.0 * 1.0i) / (1.0i + xd)) / 2.0) + 2.0 * log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx)
                + log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx) - log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) - log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd))) + log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) * ((pisqu * log(1.0 + 1.0i * wx)) / 6.0 - (log(1.0 + 1.0i * wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0)
                + log((wx - xd) / (-1.0i + wx)) * ((power_of<2>(log(1.0i / wx)) * log((-1.0i + wx) / wx)) / 2.0 + power_of<2>(log(1.0 - 1.0i * xd)) * (2.0 * log(0.5 + (1.0i / 2.0) * xd) - log(1.0 + 1.0i * xd) / 2.0) - (pisqu * log(1.0 + 1.0i * xd)) / 6.0 + power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) * log(1.0 + 1.0i * xd) - power_of<3>(log(1.0 + 1.0i * xd)) + log(1.0 - 1.0i * xd) * (power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) + 2.0 * log(0.5 + (1.0i / 2.0) * xd) * log(1.0 + 1.0i * xd) - power_of<2>(log(1.0 + 1.0i * xd))) + power_of<2>(log(1.0 + 1.0i * xd)) * ((-0.5) * lnhalf + (3.0 * ln2) / 4.0 + log(1.0 - 1.0i * wx) / 4.0 + log((1.0i + wx) / wx) / 4.0 - log(xd) / 2.0 - log(xd / wx) / 2.0 + log(xd / (1.0i + xd)) / 2.0 + (3.0 * log((1.0i + xd) / (1.0i + wx))) / 2.0)
                + (log(1.0 + 1.0i * wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0) + log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * ((pisqu * log((-1.0i + wx) / wx)) / 6.0 + (-ln2 + log(1.0 - 1.0i * wx) / 4.0 - (3.0 * log((1.0i + wx) / wx)) / 4.0) * power_of<2>(log(1.0 - xd / wx)) - (log((-1.0i + wx) / wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0) + log((-1.0i + wx) / (-1.0i + xd)) * ((log(1.0 + 1.0i * wx) * power_of<2>(log((-1.0i) * wx))) / 2.0 + (ln2 - log(1.0 - 1.0i * wx) / 4.0 + (3.0 * log((1.0i + wx) / wx)) / 4.0) * power_of<2>(log(1.0 - xd / wx)) + (log((-1.0i + wx) / wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0)
                + log(xd / wx) * (log((-1.0i + wx) / wx) * power_of<2>(log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))) + log((1.0i + wx) / wx) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) + (log((1.0i + wx) / wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0 + (log((-1.0i + wx) / wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0) - (pisqu * log(1.0 + 1.0i * wx) * log(-((xd + 1.0i * wx * xd) / (wx - xd)))) / 6.0 - (log(1.0 + 1.0i * wx) * power_of<3>(log(-((xd + 1.0i * wx * xd) / (wx - xd))))) / 6.0 - (pisqu * log((1.0i + wx) / wx) * log((1.0 - 1.0i * wx) / (1.0i * wx + wx * xd))) / 6.0 - (log((1.0i + wx) / wx) * power_of<3>(log((1.0 - 1.0i * wx) / (1.0i * wx + wx * xd)))) / 6.0
                + ((-1.0 / 12.0) * (pisqu * ln2) - (pisqu * log(1.0 + 1.0i * wx)) / 12.0) * log(((-1.0i) * xd) / (1.0i * wx + wx * xd)) + ((-1.0 / 12.0) * ln2 - log(1.0 + 1.0i * wx) / 12.0) * power_of<3>(log(((-1.0i) * xd) / (1.0i * wx + wx * xd))) + (pisqu * log(1.0 - 1.0i * wx) * log((1.0i * xd) / (1.0i * wx + wx * xd))) / 6.0 + (log(1.0 - 1.0i * wx) * power_of<3>(log((1.0i * xd) / (1.0i * wx + wx * xd)))) / 6.0 + ((pisqu * ln2) / 12.0 + (pisqu * log((-1.0i + wx) / wx)) / 12.0) * log(((-1.0i) * wx) / (1.0i * xd + wx * xd)) + (ln2 / 12.0 + log((-1.0i + wx) / wx) / 12.0) * power_of<3>(log(((-1.0i) * wx) / (1.0i * xd + wx * xd))) + ((-1.0 / 6.0) * (pisqu * ln2) - (pisqu * log(1.0 + 1.0i * wx)) / 12.0) * log((1.0i * wx) / (1.0i * xd + wx * xd))
                + ((-1.0 / 6.0) * ln2 - log(1.0 + 1.0i * wx) / 12.0) * power_of<3>(log((1.0i * wx) / (1.0i * xd + wx * xd))) - 1.0i * M_PI * H1(xd / (-1.0i + xd), wx / (-1.0i + wx)) * log((-1.0i + wx) / wx) * power_of<2>(log((1.0i * (-wx + xd)) / (wx * xd))) * my_sign(imag(wx / (1.0i - wx))) - (2.0 * 1.0i) * M_PI * H1(xd / (-1.0i + xd), wx / (-1.0i + wx)) * log((-1.0i + wx) / wx) * power_of<2>(log((1.0i * (-1.0 + xd / wx)) * xdinv)) * my_sign(imag(wx / (1.0i - wx))) - (2.0 * 1.0i) * M_PI * H1(xd / (1.0i + xd), wx / (1.0i + wx)) * log((1.0i + wx) / wx) * power_of<2>(log(((-1.0i) * (-1.0 + xd / wx)) * xdinv)) * my_sign(-imag(wx / (1.0i + wx))) - 1.0i * M_PI * H1(wx / (-1.0i + wx), wx / (wx - xd)) * power_of<2>(log((-1.0i + xd) / wx)) * log(1.0 - xd / wx) * my_sign(imag(wx / (wx - xd)))
                - 1.0i * M_PI * H1(wx / (1.0i + wx), wx / (wx - xd)) * power_of<2>(log((1.0i + xd) / wx)) * log(1.0 - xd / wx) * my_sign(imag(wx / (wx - xd))) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * trilog((1.0 - 1.0i * xd) / ((-1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * trilog(((1.0 - 1.0i * wx) * xd) / (-1.0i + xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * trilog((xd + 1.0i * wx * xd) / (1.0i + xd)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * trilog((1.0 + 1.0i * xd) / (1.0i * xd + wx * xd)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-1.0 + (2.0 * 1.0i) / wx) * my_sign(imag(wx * xdinv))
                + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-1.0i / wx) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(1.0i / wx) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-((2.0 * 1.0i + wx) / wx)) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * log((-1.0i) * wx) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0i * wx) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * log(wx * (-2.0 * 1.0i + wx)) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(imag(wx * xdinv))
                + (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * log(wx * (2.0 * 1.0i + wx)) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H1(-1.0i / xd, wx * xdinv) * ln2 * power_of<2>(log((1.0i * (1.0i + wx) * xd) / wx)) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd))) * log((1.0i - xd) / (1.0i + xd)) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)))) * log((1.0i + xd) / (1.0i - xd)) * my_sign(imag(wx * xdinv))
                + trilog((1.0i - wx) / (1.0i + wx)) * (log(wx / (1.0i + wx)) - log((1.0i + wx) / wx) + log((1.0i + wx) / (wx - xd)) - log((wx - xd) / (1.0i + wx)) - (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - (3.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(xd) + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 - log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv))) + log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * ((-1.0 / 3.0) * (pisqu * log((1.0i + wx) / wx)) + (ln2 + log(1.0 + 1.0i * wx) / 4.0) * power_of<2>(log(1.0 - xd / wx)) - (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)))
                + trilog((1.0i + wx) / (1.0i - wx)) * (log(wx / (-1.0i + wx)) - log((-1.0i + wx) / wx) + log((-1.0i + wx) / (wx - xd)) - log((wx - xd) / (-1.0i + wx)) - (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - (3.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(xd) + log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 - log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv))) + log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * ((-1.0 / 3.0) * (pisqu * log((-1.0i + wx) / wx)) + (ln2 + log(1.0 - 1.0i * wx) / 4.0) * power_of<2>(log(1.0 - xd / wx)) - (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)))
                + power_of<2>(log((-1.0i - 1.0 / wx) * xd)) * ((2.0 * 1.0i) * M_PI * H1(1.0i / xd, wx * xdinv) * ln2 * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H1(1.0i / xd, wx * xdinv) * log(1.0 - 1.0i * wx) * my_sign(imag(wx * xdinv))) + power_of<2>(log((1.0i - 1.0 / wx) * xd)) * (1.0i * M_PI * H1(-1.0i / xd, wx * xdinv) * ln2 * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H1(-1.0i / xd, wx * xdinv) * log(1.0 + 1.0i * wx) * my_sign(imag(wx * xdinv))) + power_of<2>(log(-((1.0i + xd) / wx))) * ((2.0 * 1.0i) * M_PI * H1(1.0i * wx, wx * xdinv) * ln2 * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H1(1.0i * wx, wx * xdinv) * log(1.0 + 1.0i * wx) * my_sign(imag(wx * xdinv)) + ((3.0 * 1.0i) / 2.0) * M_PI * H1(1.0i * wx, wx * xdinv) * log((-1.0i + wx) / wx) * my_sign(imag(wx * xdinv)))
                + power_of<2>(log((1.0i - xd) / wx)) * ((2.0 * 1.0i) * M_PI * H1((-1.0i) * wx, wx * xdinv) * ln2 * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H1((-1.0i) * wx, wx * xdinv) * log(1.0 - 1.0i * wx) * my_sign(imag(wx * xdinv)) + ((3.0 * 1.0i) / 2.0) * M_PI * H1((-1.0i) * wx, wx * xdinv) * log((1.0i + wx) / wx) * my_sign(imag(wx * xdinv))) + power_of<2>(log(-((1.0i + xd) * xdinv))) * ((5.0 * pisqu) / 24.0 + power_of<2>(log(-1.0 + 1.0i / wx)) / 8.0 + (log(1.0 - 1.0i * wx) * log(1.0i * wx)) / 2.0 - (1.0i / 2.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)))
                - 1.0i * M_PI * H1(wx / (-1.0i + wx), (wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * log((-1.0i + wx) / wx) * power_of<2>(log((wx * (1.0 + 1.0i * xd)) / (-1.0i + wx))) * my_sign(imag((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd))) - (2.0 * 1.0i) * M_PI * H1(wx / (-1.0i + wx), (wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * log((-1.0i + wx) / wx) * power_of<2>(log((1.0 + 1.0i * wx) / (1.0i * wx - wx * xd))) * my_sign(imag((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd))) - (2.0 * 1.0i) * M_PI * H1(wx / (1.0i + wx), (wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * log((1.0i + wx) / wx) * power_of<2>(log((1.0i * (1.0i + wx)) / (wx * (1.0i + xd)))) * my_sign(imag((wx * (1.0i + xd)) / ((1.0i + wx) * xd)))
                - 1.0i * M_PI * H1(wx / (1.0i + wx), (wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * log((1.0i + wx) / wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (1.0i + wx))) * my_sign(imag((wx * (1.0i + xd)) / ((1.0i + wx) * xd))) - 1.0i * M_PI * H1(-(xd / (wx - xd)), -1.0i / (-1.0i + wx)) * log(1.0 + 1.0i * wx) * power_of<2>(log(wx * (-1.0i - xdinv))) * my_sign(real(1.0 / (1.0i - wx))) + power_of<3>(log(-((1.0i + xd) * xdinv))) * (log(1.0 - 1.0i * wx) / 6.0 - log(1.0 + 1.0i * wx) / 6.0 - log(1.0 - xd / wx) / 6.0 + (1.0i / 6.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) - (1.0i / 6.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)))
                + trilog(xd / (1.0i + xd)) * (lnhalf + log(1.0 - 1.0i * wx) + log(-1.0i / (-1.0i + wx)) - log(wx / (-1.0i + wx)) / 2.0 + log(1.0i / (1.0i + wx)) / 2.0 - log(1.0 - 1.0i * xd) + log(1.0 + 1.0i * xd) / 2.0 + 2.0 * log(1.0i / (1.0i + xd)) - 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx))) + trilog((-1.0i + wx) / (wx - xd)) * (-2.0 * ln2 - log((1.0i + wx) / wx) - log(1.0 - 1.0i * xd) - 4.0 * log(1.0 + 1.0i * xd) - (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)))
                + trilog((2.0 * xd) / (1.0i + xd)) * (log(1.0 - 1.0i * wx) / 2.0 + log(wx / (-1.0i + wx)) / 2.0 - log((-1.0i + wx) / wx) / 2.0 - log(1.0i / (1.0i + wx)) / 2.0 - log(1.0i / (1.0i + xd)) + log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) + (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx))) + log(-((1.0i + xd) * xdinv)) * ((pisqu * log(1.0 - 1.0i * wx)) / 6.0 - (pisqu * log(1.0 + 1.0i * wx)) / 6.0 - (pisqu * log(1.0 - xd / wx)) / 6.0 + (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) - (1.0i / 6.0) * power_of<3>(M_PI) * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)))
                + power_of<2>(log(wx * (-1.0i + xdinv))) * (1.0i * M_PI * H1(xd / wx, -1.0i / wx) * ln2 * my_sign(-real(1.0 / wx)) + 1.0i * M_PI * H1(xd / wx, -1.0i / wx) * log(1.0 + 1.0i * wx) * my_sign(-real(1.0 / wx))) + log(-((1.0i + xd) / (wx - xd))) * ((ln2 * power_of<2>(log(1.0 - 1.0i * wx))) / 4.0 + (power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * wx)) / 4.0 + (ln2 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (log((-1.0i + wx) / wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (1.0i / 6.0) * power_of<3>(M_PI) * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) + (1.0i / 2.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * power_of<2>(log(-((1.0i + xd) * xdinv))) * my_sign(-real(1.0 / wx)))
                + dilog((2.0 * xd) / (1.0i + xd)) * (dilog((-wx + xd) / (1.0i + xd)) / 2.0 - (ln2 * log(1.0 - 1.0i * wx)) / 2.0 - (ln2 * log(wx / (-1.0i + wx))) / 2.0 + (ln2 * log((-1.0i + wx) / wx)) / 2.0 + (ln2 * log(1.0i / (1.0i + wx))) / 2.0 - 2.0 * ln2 * log(1.0 - xd / wx) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * log(-((1.0i + xd) / (wx - xd))) * my_sign(-real(1.0 / wx)) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * log((-wx + xd) / (1.0i + xd)) * my_sign(-real(1.0 / wx)))
                + dilog(xd / (1.0i + xd)) * ((-1.0 / 3.0) * pisqu - dilog((2.0 * xd) / (1.0i + xd)) / 2.0 + (5.0 * dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd)))) / 4.0 + dilog((-1.0i + xd) / (1.0i + xd)) / 2.0 - dilog((-wx + xd) / (1.0i + xd)) / 4.0 - log(1.0 - 1.0i * wx) * log(1.0i * wx) + log(1.0 - 1.0i * xd) * log(1.0i * xd) - log(xd / wx) * log(1.0 - xd / wx) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * log((-wx + xd) / (1.0i + xd)) * my_sign(-real(1.0 / wx)))
                + power_of<3>(log(-1.0 + 1.0i / xd)) * ((-1.0 / 6.0) * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 6.0 - log(1.0 - xd / wx) / 6.0 + (1.0i / 6.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) - (1.0i / 6.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx))) + trilog(xd / (-1.0i + xd)) * (lnhalf + log(1.0 + 1.0i * wx) + log(-1.0i / (-1.0i + wx)) / 2.0 + log(1.0i / (1.0i + wx)) - log(wx / (1.0i + wx)) / 2.0 + log(1.0 - 1.0i * xd) / 2.0 - log(1.0 + 1.0i * xd) + 2.0 * log(-1.0i / (-1.0i + xd)) - 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)))
                + trilog((1.0i + wx) / (wx - xd)) * (-2.0 * ln2 - log((-1.0i + wx) / wx) - 4.0 * log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx))) + trilog((2.0 * wx) / (wx - xd)) * ((-2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)))
                + trilog((2.0 * xd) / (-1.0i + xd)) * (log(1.0 + 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) / 2.0 + log(wx / (1.0i + wx)) / 2.0 - log((1.0i + wx) / wx) / 2.0 - log(-1.0i / (-1.0i + xd)) + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx))) + log(-1.0 + 1.0i / xd) * ((-1.0 / 6.0) * (pisqu * log(1.0 - 1.0i * wx)) + (pisqu * log(1.0 + 1.0i * wx)) / 6.0 + power_of<3>(log(1.0 + 1.0i * xd)) / 3.0 - (pisqu * log(1.0 - xd / wx)) / 6.0 + (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) - (1.0i / 6.0) * power_of<3>(M_PI) * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)))
                + log((-1.0i + xd) / (-wx + xd)) * ((ln2 * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 + (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 + (ln2 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + (power_of<2>(log((-1.0i + wx) / wx)) * log((1.0i + wx) / wx)) / 2.0 + (1.0i / 6.0) * power_of<3>(M_PI) * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx))) + power_of<2>(log(wx * (1.0i + xdinv))) * (1.0i * M_PI * H1(xd / wx, 1.0i / wx) * ln2 * my_sign(real(1.0 / wx)) + 1.0i * M_PI * H1(xd / wx, 1.0i / wx) * log(1.0 - 1.0i * wx) * my_sign(real(1.0 / wx)))
                + power_of<2>(log(-1.0 + 1.0i / xd)) * ((5.0 * pisqu) / 24.0 + (log(1.0 + 1.0i * wx) * log((-1.0i) * wx)) / 2.0 + power_of<2>(log(-((1.0i + wx) / wx))) / 8.0 + (log(1.0 + 1.0i * xd) * log((-1.0i) * xd)) / 2.0 - (1.0i / 2.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * log((-1.0i + xd) / (-wx + xd)) * my_sign(real(1.0 / wx)))
                + log((1.0i - xd) / (1.0i + xd)) * ((-0.25) * (ln2squ * log(1.0 - 1.0i * wx)) - (ln2squ * log(wx / (-1.0i + wx))) / 4.0 + (ln2squ * log((-1.0i + wx) / wx)) / 4.0 + (ln2squ * log(1.0i / (1.0i + wx))) / 4.0 + (1.0i / 2.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(((1.0i + wx) * xd) / (wx * (1.0i + xd)))) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * power_of<2>(log((-wx + xd) / (1.0i + xd))) * my_sign(-real(1.0 / wx)) + (1.0i / 2.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * power_of<2>(log((-1.0i + xd) / (-wx + xd))) * my_sign(real(1.0 / wx)))
                + dilog((2.0 * xd) / (-1.0i + xd)) * (dilog((-wx + xd) / (-1.0i + xd)) / 2.0 - (ln2 * log(1.0 + 1.0i * wx)) / 2.0 + (ln2 * log(-1.0i / (-1.0i + wx))) / 2.0 - (ln2 * log(wx / (1.0i + wx))) / 2.0 + (ln2 * log((1.0i + wx) / wx)) / 2.0 - 2.0 * ln2 * log(1.0 - xd / wx) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * log((-1.0i + xd) / (-wx + xd)) * my_sign(real(1.0 / wx)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * log((-wx + xd) / (-1.0i + xd)) * my_sign(real(1.0 / wx)))
                + dilog(xd / (-1.0i + xd)) * ((-1.0 / 3.0) * pisqu - dilog((2.0 * xd) / (-1.0i + xd)) / 2.0 + (5.0 * dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)))) / 4.0 + dilog((1.0i + xd) / (-1.0i + xd)) / 2.0 - dilog((-wx + xd) / (-1.0i + xd)) / 4.0 - log(1.0 + 1.0i * wx) * log((-1.0i) * wx) + log(1.0 + 1.0i * xd) * log((-1.0i) * xd) - log(xd / wx) * log(1.0 - xd / wx) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * log((-wx + xd) / (-1.0i + xd)) * my_sign(real(1.0 / wx)))
                + log((1.0i + xd) / (1.0i - xd)) * ((-0.25) * (ln2squ * log(1.0 + 1.0i * wx)) + (ln2squ * log(-1.0i / (-1.0i + wx))) / 4.0 - (ln2squ * log(wx / (1.0i + wx))) / 4.0 + (ln2squ * log((1.0i + wx) / wx)) / 4.0 - (1.0i / 2.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log((wx * (1.0i + xd)) / ((1.0i + wx) * xd))) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * power_of<2>(log(-((1.0i + xd) / (wx - xd)))) * my_sign(-real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * power_of<2>(log((-wx + xd) / (-1.0i + xd))) * my_sign(real(1.0 / wx))) - (1.0i / 2.0) * M_PI * H2((-1.0i) * wx, wx * xdinv) * power_of<2>(log((-1.0i + xd) / (-wx + xd))) * log((wx - 1.0i * wx * xd) / (wx - xd)) * my_sign(-real(wx))
                - pisqu * H2((-1.0i) * wx, wx * xdinv) * H2(wx * xdinv, -1.0i / xd) * my_HT(-r((-1.0i) * wx, wx * xdinv) + r(wx * xdinv, -1.0i / xd)) * power_of<2>(log((1.0 + 1.0i * xd) / (1.0i * xd + wx * xd))) * my_sign(imag(wx * xdinv)) * my_sign(-real(wx)) + trilog((1.0i + wx + xd - 1.0i * wx * xd) * xdinv) * ((-1.0i) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx))) + dilog((1.0i + wx + xd - 1.0i * wx * xd) * xdinv) * log(1.0 + xdinv * xdinv) * (1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)))
                + trilog((-2.0 * 1.0i) / (-1.0i + xd)) * ((-0.5) * log(1.0 + 1.0i * wx) + log((1.0i + wx) / wx) / 2.0 - 3.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 - xd / wx) + (2.0 * 1.0i) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx))) + power_of<2>(log((1.0i * (wx - xd)) / (wx * xd))) * ((-1.0i) * M_PI * H1(xd / (1.0i + xd), wx / (1.0i + wx)) * log((1.0i + wx) / wx) * my_sign(-imag(wx / (1.0i + wx))) - 1.0i * M_PI * H1((-1.0i) * xd, (-1.0i) * wx) * ln2 * my_sign(-real(wx))) + power_of<2>(log((1.0i * (-1.0 + wx * xdinv)) / wx)) * ((-1.0i) * M_PI * H1((-1.0i) * xd, (-1.0i) * wx) * ln2 * my_sign(-real(wx)) - 1.0i * M_PI * H1((-1.0i) * xd, (-1.0i) * wx) * log((1.0i + wx) / wx) * my_sign(-real(wx)))
                + dilog((1.0i + xd) * xdinv) * (pisqu / 4.0 + dilog((-wx + xd) / (1.0i + xd)) / 4.0 + power_of<2>(log(-1.0 + 1.0i / wx)) / 4.0 + log(1.0 - 1.0i * wx) * log(1.0i * wx) - (3.0 * power_of<2>(log(1.0 - 1.0i * xd))) / 2.0 + log(1.0 - 1.0i * xd) * (3.0 * ln2 - (3.0 * log(1.0 - 1.0i * wx)) / 2.0 + 2.0 * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) + log(1.0i * xd)) + 2.0 * log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * log(-((1.0i + xd) / (wx - xd))) * my_sign(-real(1.0 / wx))
                + log(1.0 + xdinv * xdinv) * ((-1.0i) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)))) - 1.0i * M_PI * H1(1.0i * xd, 1.0i * wx) * ln2 * power_of<2>(log(1.0i * (1.0 / wx - xdinv))) * my_sign(real(wx)) - (1.0i / 2.0) * M_PI * H2(1.0i * wx, wx * xdinv) * power_of<2>(log(-((1.0i + xd) / (wx - xd)))) * log((wx + 1.0i * wx * xd) / (wx - xd)) * my_sign(real(wx)) - pisqu * H2(1.0i * wx, wx * xdinv) * H2(wx * xdinv, 1.0i / xd) * my_HT(-r(1.0i * wx, wx * xdinv) + r(wx * xdinv, 1.0i / xd)) * power_of<2>(log((1.0 - 1.0i * xd) / ((-1.0i + wx) * xd))) * my_sign(imag(wx * xdinv)) * my_sign(real(wx))
                + trilog(((1.0 + 1.0i * wx) * (-1.0i + xd)) * xdinv) * ((-1.0i) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx))) + dilog(((1.0 + 1.0i * wx) * (-1.0i + xd)) * xdinv) * log(1.0 + xdinv * xdinv) * (1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx))) + trilog((2.0 * 1.0i) / (1.0i + xd)) * ((-0.5) * log(1.0 - 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 - 3.0 * log(1.0 + 1.0i * xd) - 2.0 * log(1.0 - xd / wx) + (2.0 * 1.0i) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)))
                + power_of<2>(log(((-1.0i) * (-1.0 + wx * xdinv)) / wx)) * ((-1.0i) * M_PI * H1(1.0i * xd, 1.0i * wx) * ln2 * my_sign(real(wx)) - 1.0i * M_PI * H1(1.0i * xd, 1.0i * wx) * log((-1.0i + wx) / wx) * my_sign(real(wx))) + power_of<2>(log(1.0 + xdinv * xdinv)) * (log((1.0i * (-1.0 + wx * (1.0i + xd))) * xdinv) * ((1.0i / 2.0) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx))) + log((1.0i - wx - 1.0i * wx * xd) * xdinv) * ((1.0i / 2.0) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx))))
                + dilog((-1.0i + xd) * xdinv) * (pisqu / 4.0 - dilog((1.0i + xd) / (-1.0i + xd)) / 2.0 + dilog((-wx + xd) / (-1.0i + xd)) / 4.0 + log(1.0 + 1.0i * wx) * log((-1.0i) * wx) + power_of<2>(log(-((1.0i + wx) / wx))) / 4.0 - (3.0 * power_of<2>(log(1.0 + 1.0i * xd))) / 2.0 + log(1.0 + 1.0i * xd) * (3.0 * ln2 + 2.0 * log(1.0 - 1.0i * wx) - (3.0 * log(1.0 + 1.0i * wx)) / 2.0 + log((1.0i + wx) / wx) + log((-1.0i) * xd)) + 2.0 * log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * my_sign(imag(wx * xdinv))
                + 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * log((-1.0i + xd) / (-wx + xd)) * my_sign(real(1.0 / wx)) + log(1.0 + xdinv * xdinv) * ((-1.0i) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)))) + 1.0i * M_PI * H1(-(xd / (wx - xd)), -1.0i / (-1.0i + wx)) * log(1.0 + 1.0i * wx) * power_of<2>(log(-((wx + 1.0i * wx * xd) * xdinv))) * my_sign(real(1.0 / (-1.0i + wx))) + power_of<2>(log((1.0i * wx * (1.0i + xd)) * xdinv)) * (1.0i * M_PI * H1(-(xd / (wx - xd)), 1.0i / (1.0i + wx)) * log(1.0 - 1.0i * wx) * my_sign(-real(1.0 / (1.0i + wx))) - 1.0i * M_PI * H1(-(xd / (wx - xd)), 1.0i / (1.0i + wx)) * log(1.0 - 1.0i * wx) * my_sign(real(1.0 / (1.0i + wx))))
                - 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-1.0 + (2.0 * 1.0i) / wx) * my_sign(-real(xdinv)) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(1.0i / wx) * my_sign(-real(xdinv)) + (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, -1.0i / xd) * log(-((1.0i + wx) / wx)) * my_sign(-real(xdinv)) + (1.0i / 6.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<3>(log(-((1.0i + wx) / wx))) * my_sign(-real(xdinv)) - (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * log((-1.0i) * wx) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(-real(xdinv)) + (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * log(wx * (-2.0 * 1.0i + wx)) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(-real(xdinv))
                - (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * power_of<2>(log((1.0i * (1.0i + wx) * xd) / (wx - xd))) * log((wx + 1.0i * wx * xd) / (wx - xd)) * my_sign(-real(xdinv)) - pisqu * H2(-1.0i / xd, wx * xdinv) * H2(wx * xdinv, 1.0i / xd) * my_HT(-r(-1.0i / xd, wx * xdinv) + r(wx * xdinv, 1.0i / xd)) * power_of<2>(log((1.0i + wx) / (1.0i - wx))) * my_sign(imag(wx * xdinv)) * my_sign(-real(xdinv)) + trilog(-power_of<2>(-1.0i + wx)) * ((-1.0i) * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)))
                + trilog(-((xd + 1.0i * wx * xd) / (wx - xd))) * (lnhalf / 2.0 + (3.0 * ln2) / 2.0 + 2.0 * log(1.0 + 1.0i * wx) + log(wx / (1.0i + wx)) / 2.0 + log((1.0i + wx) / wx) / 2.0 - (3.0 * log(wx / (wx - xd))) / 2.0 - log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) + log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)) + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)))
                + trilog((2.0 * wx) / (1.0i + wx)) * (log(1.0 - 1.0i * wx) / 2.0 - log(1.0i / (1.0i + wx)) / 2.0 - log(1.0 + 1.0i * xd) - log((1.0i + wx) / (1.0i + xd)) / 2.0 + log((1.0i - xd) / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i + wx)) / 2.0 - 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(-real(xdinv))) + trilog(2.0 - (2.0 * 1.0i) / wx) * ((2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(-real(xdinv)))
                + dilog(2.0 - (2.0 * 1.0i) / wx) * ((-2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(imag(wx * xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(-real(xdinv))) + power_of<2>(log((-1.0i + 1.0 / wx) * xd)) * ((-1.0i) * M_PI * H1(wx * xdinv, -1.0i / xd) * ln2 * my_sign(-real(xdinv)) - (1.0i / 2.0) * M_PI * H1(wx * xdinv, -1.0i / xd) * log((-1.0i + wx) / wx) * my_sign(-real(xdinv))) + dilog(-power_of<2>(-1.0i + wx)) * (1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(-real(xdinv)))
                + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) * ((-5.0 * pisqu) / 12.0 - power_of<2>(lnm2) / 4.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 4.0 - (lnhalf * log(1.0 + 1.0i * wx)) / 2.0 + (ln2 * log(1.0 + 1.0i * wx)) / 2.0 - power_of<2>(log(1.0 + 1.0i * wx)) - 2.0 * ln2 * log((-1.0i + wx) / wx) - (log(1.0 + 1.0i * wx) * log(wx / (1.0i + wx))) / 2.0 + (log(1.0 + 1.0i * wx) * log((1.0i + wx) / wx)) / 2.0 - log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) + power_of<2>(log(-1.0 + wx * xdinv)) / 4.0 + log(1.0 + 1.0i * wx) * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd) * log((-1.0i) * xd) - 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * log(-((1.0i + xd) / (wx - xd))) * my_sign(real(wx))
                - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log((1.0i * (1.0i + wx) * xd) / (wx - xd)) * my_sign(-real(xdinv))) + power_of<2>(log(1.0i * (wx - xd))) * ((2.0 * 1.0i) * M_PI * H1(-1.0i / (-1.0i + wx), -1.0i / (-1.0i + xd)) * log(1.0 + 1.0i * xd) * my_sign(real(1.0 / (1.0i - xd))) - (2.0 * 1.0i) * M_PI * H1(-1.0i / wx, -1.0i / xd) * ln2 * my_sign(-real(xdinv)) - 1.0i * M_PI * H1(-1.0i / wx, -1.0i / xd) * log(1.0 + 1.0i * wx) * my_sign(-real(xdinv)) + log(1.0 - 1.0i * xd) * ((-1.0i) * M_PI * H1(1.0i / xd, 1.0i / wx) * my_sign(real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H1(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)))) + (1.0i / 6.0) * power_of<3>(M_PI) * H2(wx * xdinv, 1.0i / xd) * log(-1.0 + 1.0i / wx) * my_sign(real(xdinv))
                + (1.0i / 6.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<3>(log(-1.0 + 1.0i / wx)) * my_sign(real(xdinv)) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-1.0i / wx) * my_sign(real(xdinv)) - 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(1.0 + wxinv * wxinv)) * log(-((2.0 * 1.0i + wx) / wx)) * my_sign(real(xdinv)) - (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0i * wx) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(real(xdinv)) + (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * log(wx * (2.0 * 1.0i + wx)) * power_of<2>(log(1.0 + power_of<2>(wx))) * my_sign(real(xdinv))
                - pisqu * H2(1.0i / xd, wx * xdinv) * H2(wx * xdinv, -1.0i / xd) * my_HT(-r(1.0i / xd, wx * xdinv) + r(wx * xdinv, -1.0i / xd)) * power_of<2>(log((1.0i - wx) / (1.0i + wx))) * my_sign(imag(wx * xdinv)) * my_sign(real(xdinv)) + power_of<3>(log(-1.0 + wx * xdinv)) * (ln2 / 6.0 - log((-1.0i + wx) / wx) / 12.0 - log((1.0i + wx) / wx) / 12.0 - log(1.0 - 1.0i * xd) / 12.0 - log(1.0 + 1.0i * xd) / 12.0 + log(1.0 - xd / wx) / 3.0 - (1.0i / 6.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) - (1.0i / 6.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)))
                + trilog((2.0 * (wx + xd)) * xdinv) * ((-2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) - (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv))) + dilog((wx + xd) * xdinv) * log(1.0 - power_of<2>(wx) * power_of<2>(xdinv)) * ((-2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) - (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)))
                + trilog((-2.0 * xd) / (wx - xd)) * ((2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv))) + trilog((wx + xd) * xdinv) * ((2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) + (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)))
                + dilog((2.0 * (wx + xd)) * xdinv) * log(1.0 - power_of<2>(wx) * power_of<2>(xdinv)) * ((2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) + (2.0 * 1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) + (2.0 * 1.0i) * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv))) + log(-1.0 + wx * xdinv) * ((pisqu * ln2) / 6.0 - (pisqu * log((-1.0i + wx) / wx)) / 12.0 - (pisqu * log((1.0i + wx) / wx)) / 12.0 - (pisqu * log(1.0 - 1.0i * xd)) / 12.0 - (pisqu * log(1.0 + 1.0i * xd)) / 12.0 + (pisqu * log(1.0 - xd / wx)) / 3.0 - (2.0 * power_of<3>(log(1.0 - xd / wx))) / 3.0 - (1.0i / 6.0) * power_of<3>(M_PI) * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv))
                - (1.0i / 6.0) * power_of<3>(M_PI) * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv))) + trilog(-power_of<2>(1.0i + wx)) * ((-1.0i) * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv))) + trilog(-(xd / (wx - xd))) * (-lnhalf - log(wx / (-1.0i + wx)) / 2.0 - 2.0 * log((-1.0i + wx) / wx) - log(wx / (1.0i + wx)) / 2.0 - 2.0 * log((1.0i + wx) / wx) - 2.0 * log(wx / (wx - xd)) + log(1.0 - 1.0i * xd) / 2.0 + log(1.0 + 1.0i * xd) / 2.0 - 2.0 * log(1.0 - xd / wx) - 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)) - 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv))
                - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)) - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv))) + trilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) * (lnhalf / 2.0 + (3.0 * ln2) / 2.0 + 2.0 * log(1.0 - 1.0i * wx) + log(wx / (-1.0i + wx)) / 2.0 + log((-1.0i + wx) / wx) / 2.0 - (3.0 * log(wx / (wx - xd))) / 2.0 + 2.0 * log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) + log(1.0 - xd / wx) + log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)) + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv)))
                + trilog((2.0 * wx) / (-1.0i + wx)) * (log(1.0 + 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) / 2.0 - log(1.0 - 1.0i * xd) - log((-1.0i + wx) / (-1.0i + xd)) / 2.0 + log((-1.0i + xd) / (-1.0i + wx)) / 2.0 + log((1.0i + xd) / (1.0i - xd)) / 2.0 - 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(real(xdinv))) + trilog(2.0 + (2.0 * 1.0i) / wx) * ((2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(real(xdinv)))
                + dilog(2.0 + (2.0 * 1.0i) / wx) * ((-2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(imag(wx * xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(real(xdinv))) + power_of<2>(log((1.0i + 1.0 / wx) * xd)) * ((-1.0i) * M_PI * H1(wx * xdinv, 1.0i / xd) * ln2 * my_sign(real(xdinv)) - (1.0i / 2.0) * M_PI * H1(wx * xdinv, 1.0i / xd) * log((1.0i + wx) / wx) * my_sign(real(xdinv))) + dilog(-power_of<2>(1.0i + wx)) * (1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(real(xdinv)))
                + dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) * ((-5.0 * pisqu) / 12.0 + dilog((-1.0i + xd) / (-wx + xd)) / 4.0 + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - power_of<2>(lnm2) / 4.0 - power_of<2>(log(-1.0 - 1.0i * wx)) / 4.0 - (lnhalf * log(1.0 - 1.0i * wx)) / 2.0 + (ln2 * log(1.0 - 1.0i * wx)) / 2.0 - power_of<2>(log(1.0 - 1.0i * wx)) - (log(1.0 - 1.0i * wx) * log(wx / (-1.0i + wx))) / 2.0 + (log(1.0 - 1.0i * wx) * log((-1.0i + wx) / wx)) / 2.0 - 2.0 * ln2 * log((1.0i + wx) / wx) - log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) + power_of<2>(log(-1.0 + wx * xdinv)) / 4.0 + log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * xd) - 2.0 * log(1.0 - 1.0i * xd) * log(1.0i * xd)
                - 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * log((-1.0i + xd) / (-wx + xd)) * my_sign(-real(wx)) - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(-((xd + 1.0i * wx * xd) / (wx - xd))) * my_sign(real(xdinv))) + dilog(-(xd / (wx - xd))) * (pisqu / 3.0 - (3.0 * dilog((1.0i * (1.0i + wx) * xd) / (wx - xd))) / 4.0 - dilog(-((1.0i + xd) / (wx - xd))) / 4.0 - dilog((-1.0i + xd) / (-wx + xd)) / 4.0 - (3.0 * dilog(-((xd + 1.0i * wx * xd) / (wx - xd)))) / 4.0 + 2.0 * log(1.0i / wx) * log((-1.0i + wx) / wx) + 2.0 * log(-1.0i / wx) * log((1.0i + wx) / wx) + 2.0 * log(xd / wx) * log(1.0 - xd / wx) + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * log((-1.0i + xd) / (-wx + xd)) * my_sign(-real(wx))
                + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * log(-((1.0i + xd) / (wx - xd))) * my_sign(real(wx)) + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log((1.0i * (1.0i + wx) * xd) / (wx - xd)) * my_sign(-real(xdinv)) + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(-((xd + 1.0i * wx * xd) / (wx - xd))) * my_sign(real(xdinv))) + power_of<2>(log(1.0 - power_of<2>(wx) * power_of<2>(xdinv))) * (log(-(wx * xdinv)) * ((-1.0i) * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)))
                + log(-1.0 - (2.0 * wx) * xdinv) * (1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) + 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) + 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) + 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)))) + 1.0i * M_PI * H1(-1.0i / (-1.0i + wx), (1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) * log(1.0 + 1.0i * wx) * power_of<2>(log(((1.0 + 1.0i * wx) * wx) / (wx - xd))) * my_sign(real((wx - xd) / ((-1.0i + wx) * xd))) + 1.0i * M_PI * H1(-1.0i / (-1.0i + wx), (1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) * log(1.0 + 1.0i * wx) * power_of<2>(log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + wx)))) * my_sign(real((wx - xd) / ((-1.0i + wx) * xd)))
                + power_of<2>(log((-1.0i) * (wx - xd))) * ((-2.0 * 1.0i) * M_PI * H1(1.0i / wx, 1.0i / xd) * ln2 * my_sign(real(xdinv)) - 1.0i * M_PI * H1(1.0i / wx, 1.0i / xd) * log(1.0 - 1.0i * wx) * my_sign(real(xdinv)) + log(1.0 + 1.0i * xd) * (((-0.5) * 1.0i) * M_PI * H1(-1.0i / xd, -1.0i / wx) * my_sign(-real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H1(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv))) + 1.0i * M_PI * H1(1.0i / (1.0i + wx), 1.0i / (1.0i + xd)) * log(1.0 - 1.0i * xd) * my_sign(real(1.0 / (1.0i + xd)))) + 1.0i * M_PI * H1(1.0i / (1.0i + wx), ((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) * log(1.0 - 1.0i * wx) * power_of<2>(log(((1.0 - 1.0i * wx) * wx) / (wx - xd))) * my_sign(-real((wx - xd) / (1.0i * xd + wx * xd)))
                + 1.0i * M_PI * H1(1.0i / (1.0i + wx), ((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) * log(1.0 - 1.0i * wx) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + wx)))) * my_sign(-real((wx - xd) / (1.0i * xd + wx * xd))) - (1.0i / 6.0) * power_of<3>(M_PI) * lnm2 * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 6.0) * M_PI * power_of<3>(lnm2) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 6.0) * power_of<3>(M_PI) * log(-1.0 - 1.0i * wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 6.0) * M_PI * power_of<3>(log(-1.0 - 1.0i * wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv)
                + trilog(-1.0i / (-1.0i + wx)) * (-lnhalf + ln2 / 2.0 + 3.0 * log((-1.0i) * wx) + 2.0 * log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) / 2.0 - 3.0 * log((1.0i + wx) / (-1.0i + wx)) + (5.0 * log(0.5 - (1.0i / 2.0) * xd)) / 2.0 + 2.0 * log(1.0 - 1.0i * xd) + (5.0 * log(1.0 + 1.0i * xd)) / 2.0 - 3.0 * log((-1.0i) * xd) + log(xd) + log((1.0i - xd) / (1.0i + xd)) / 2.0 + log(xd / (1.0i + xd)) - log(1.0 - xd / wx) / 2.0 + log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv))
                + trilog((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) * (-2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 - 3.0 * log((-1.0i + wx) / wx) + (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - 2.0 * log(1.0 + 1.0i * xd) + log(xd) + (2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv)) + dilog(-1.0i / (-1.0i + wx)) * ((11.0 * pisqu) / 12.0 - dilog((-2.0 * 1.0i) / (-1.0i + wx)) + dilog((1.0i + wx) / (1.0i - wx)) / 2.0 - dilog(0.5 + (1.0i / 2.0) * xd) / 2.0 - dilog(1.0 + 1.0i * xd) - (3.0 * dilog((-1.0i) * xd)) / 2.0 + dilog(1.0i * xd) - dilog(-(xd / (wx - xd))) / 4.0 + dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 - dilog((-1.0i + xd) / (-1.0i + wx)) / 2.0 + dilog(1.0i / (1.0i + xd)) / 2.0
                - dilog(xd / (1.0i + xd)) / 4.0 + dilog((2.0 * xd) / (1.0i + xd)) / 2.0 + (3.0 * power_of<2>(log(1.0i / (-1.0i + wx)))) / 4.0 - 2.0 * log(1.0i / wx) * log((-1.0i + wx) / wx) + power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log(1.0 - 1.0i * xd) * (-2.0 * lnhalf + log(1.0 + 1.0i * xd)) + log(1.0 + 1.0i * xd) * (-2.0 * lnhalf - log(0.5 - (1.0i / 2.0) * xd) / 2.0 - 3.0 * log((-1.0i) * xd) + log(xd)) + (ln2 * log((1.0i - xd) / (1.0i + xd))) / 2.0 + (log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd))) / 2.0 - 1.0i * M_PI * log(1.0 - wx * xdinv) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv))
                + dilog(1.0 + 1.0i * wx) * ((5.0 * pisqu) / 12.0 - dilog((1.0i + wx) / (1.0i - wx)) / 2.0 + (3.0 * dilog(1.0 - wx * xdinv)) / 4.0 + dilog(0.5 + (1.0i / 2.0) * xd) / 2.0 + dilog(1.0 - 1.0i * xd) / 2.0 + dilog(1.0i * xd) - dilog(-(xd / (wx - xd))) - dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 - dilog((-1.0i + xd) / (-1.0i + wx)) / 2.0 + 2.0 * dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) + power_of<2>(lnm2) / 8.0 + 2.0 * ln2 * log((-1.0i + wx) / wx) + log(1.0i / wx) * log((-1.0i + wx) / wx) + log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) + (3.0 * power_of<2>(log(-1.0 + wx * xdinv))) / 8.0 + log((-1.0i + wx) / wx) * log(1.0 - 1.0i * xd) + power_of<2>(log(-1.0 + 1.0i * xd)) / 4.0
                - log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + log(1.0 + 1.0i * xd) * (-3.0 * log((-1.0i + wx) / wx) - log((-1.0i + wx) / (wx - xd)) + log((wx - xd) / (-1.0i + wx)) - log((2.0 * 1.0i) / (1.0i + xd)) / 2.0) + (log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) / 2.0 + 2.0 * log((-1.0i + wx) / wx) * log(1.0 - xd / wx) + log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(-real(xdinv)) + 1.0i * M_PI * log(1.0 - wx * xdinv) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv))
                + dilog((-1.0i) * wx) * (pisqu / 6.0 + dilog(1.0 - wx * xdinv) / 2.0 + dilog(0.5 + (1.0i / 2.0) * xd) + (3.0 * dilog((-1.0i) * xd)) / 2.0 - 2.0 * dilog(1.0i * xd) - dilog(-(xd / (wx - xd))) / 2.0 + dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) + dilog(xd / (1.0i + xd)) / 2.0 - dilog((2.0 * xd) / (1.0i + xd)) / 2.0 + power_of<2>(lnm2) / 4.0 + power_of<2>(log(-1.0 + wx * xdinv)) / 4.0 + (ln2 - log((1.0i + wx) / wx) / 2.0) * log(1.0 - 1.0i * xd) - (ln2 * log((1.0i - xd) / (1.0i + xd))) / 2.0 - (log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) / 2.0
                + log(1.0 + 1.0i * xd) * (-2.0 * ln2 - 2.0 * log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx) / 2.0 + log(0.5 - (1.0i / 2.0) * xd) / 2.0 - log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 - log(1.0 - xd / wx) / 2.0) - 2.0 * ln2 * log(1.0 - xd / wx) - power_of<2>(log(1.0 - xd / wx)) / 2.0 + (log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd))) / 2.0 + (2.0 * 1.0i) * M_PI * log(1.0 - wx * xdinv) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv)) - (1.0i / 6.0) * power_of<3>(M_PI) * lnm2 * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 6.0) * M_PI * power_of<3>(lnm2) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)
                - (1.0i / 6.0) * power_of<3>(M_PI) * log(-1.0 + 1.0i * wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 6.0) * M_PI * power_of<3>(log(-1.0 + 1.0i * wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) + power_of<3>(log(1.0 - wx * xdinv)) * (((2.0 * 1.0i) / 3.0) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + ((2.0 * 1.0i) / 3.0) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + trilog(1.0i / (1.0i + wx)) * (-lnhalf + ln2 / 2.0 + 3.0 * log(1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 - 3.0 * log((-1.0i + wx) / (1.0i + wx)) + 2.0 * log((1.0i + wx) / wx) + (5.0 * log(0.5 + (1.0i / 2.0) * xd)) / 2.0 + (5.0 * log(1.0 - 1.0i * xd)) / 2.0 + 2.0 * log(1.0 + 1.0i * xd) - 3.0 * log(1.0i * xd) + log(xd) + log(xd / (-1.0i + xd)) + log((1.0i + xd) / (1.0i - xd)) / 2.0 - log(1.0 - xd / wx) / 2.0 + log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 - 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + trilog(2.0) * (log(1.0 - wx * xdinv) - 2.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd) + 2.0 * log(xd) - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 + 12.0 * log(1.0 - xd / wx) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)) + trilog(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) * (-2.0 * ln2 - log(1.0 + 1.0i * wx) / 2.0 - 3.0 * log((1.0i + wx) / wx) - 2.0 * log(1.0 - 1.0i * xd) + (3.0 * log(1.0 + 1.0i * xd)) / 2.0 + log(xd) + (2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + trilog((-wx + xd) / (2.0 * xd)) * ((2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)) + trilog(1.0 - wx * xdinv) * (9.0 * ln2 - 2.0 * log(1.0 - 1.0i * wx) - 2.0 * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) + log(1.0 - 1.0i * xd) / 2.0 + log(1.0 + 1.0i * xd) / 2.0 + 2.0 * log(1.0 - xd / wx) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(xdinv)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(xdinv)) - (4.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (4.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + log(1.0 - wx * xdinv) * ((pisqu * lnm2) / 6.0 + power_of<3>(lnm2) / 6.0 - (power_of<2>(log(1.0 - 1.0i * xd)) * log((-2.0 * 1.0i) / (-1.0i + xd))) / 4.0 - (power_of<2>(log(1.0 + 1.0i * xd)) * log((2.0 * 1.0i) / (1.0i + xd))) / 4.0 + 1.0i * power_of<3>(M_PI) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (1.0i / 2.0) * M_PI * power_of<2>(lnm2) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (1.0i / 2.0) * M_PI * power_of<2>(log(-1.0 - 1.0i * wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + 1.0i * power_of<3>(M_PI) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) + (1.0i / 2.0) * M_PI * power_of<2>(lnm2) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)
                + (1.0i / 2.0) * M_PI * power_of<2>(log(-1.0 + 1.0i * wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)) + dilog(1.0i / (1.0i + wx)) * ((11.0 * pisqu) / 12.0 - dilog((2.0 * 1.0i) / (1.0i + wx)) + dilog((1.0i - wx) / (1.0i + wx)) / 2.0 - dilog(0.5 - (1.0i / 2.0) * xd) / 2.0 - dilog(1.0 - 1.0i * xd) + dilog((-1.0i) * xd) - (3.0 * dilog(1.0i * xd)) / 2.0 - dilog(-(xd / (wx - xd))) / 4.0 + dilog(-1.0i / (-1.0i + xd)) / 2.0 - dilog(xd / (-1.0i + xd)) / 4.0 + dilog((2.0 * xd) / (-1.0i + xd)) / 2.0 - dilog((1.0i + xd) / (1.0i + wx)) / 2.0 + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + (3.0 * power_of<2>(log(-1.0i / (1.0i + wx)))) / 4.0 - 2.0 * log(-1.0i / wx) * log((1.0i + wx) / wx) + power_of<2>(log(1.0 - 1.0i * xd)) / 2.0
                - 2.0 * lnhalf * log(1.0 + 1.0i * xd) + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 + log(1.0 - 1.0i * xd) * (-2.0 * lnhalf - log(0.5 + (1.0i / 2.0) * xd) / 2.0 + log(1.0 + 1.0i * xd) - 3.0 * log(1.0i * xd) + log(xd)) + (ln2 * log((1.0i + xd) / (1.0i - xd))) / 2.0 + (log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd))) / 2.0 - 1.0i * M_PI * log(1.0 - wx * xdinv) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + dilog(1.0 - 1.0i * wx) * ((5.0 * pisqu) / 12.0 - dilog((1.0i - wx) / (1.0i + wx)) / 2.0 + (3.0 * dilog(1.0 - wx * xdinv)) / 4.0 + dilog(0.5 - (1.0i / 2.0) * xd) / 2.0 + dilog(1.0 + 1.0i * xd) / 2.0 + dilog((-1.0i) * xd) - dilog(-(xd / (wx - xd))) + 2.0 * dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) - dilog((1.0i + xd) / (1.0i + wx)) / 2.0 - dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + power_of<2>(lnm2) / 8.0 + 2.0 * ln2 * log((1.0i + wx) / wx) + log(-1.0i / wx) * log((1.0i + wx) / wx) + log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) + (3.0 * power_of<2>(log(-1.0 + wx * xdinv))) / 8.0 + power_of<2>(log(-1.0 - 1.0i * xd)) / 4.0 + log((1.0i + wx) / wx) * log(1.0 + 1.0i * xd)
                + log(1.0 - 1.0i * xd) * (-3.0 * log((1.0i + wx) / wx) - log((1.0i + wx) / (wx - xd)) + log((wx - xd) / (1.0i + wx)) - log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0) + (log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))) / 2.0 - log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + 2.0 * log((1.0i + wx) / wx) * log(1.0 - xd / wx) + log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * log(1.0 + power_of<2>(wx)) * my_sign(real(xdinv)) + 1.0i * M_PI * log(1.0 - wx * xdinv) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + dilog(1.0i * wx) * (pisqu / 6.0 + dilog(1.0 - wx * xdinv) / 2.0 + dilog(0.5 - (1.0i / 2.0) * xd) - 2.0 * dilog((-1.0i) * xd) + (3.0 * dilog(1.0i * xd)) / 2.0 - dilog(-(xd / (wx - xd))) / 2.0 + dilog(xd / (-1.0i + xd)) / 2.0 - dilog((2.0 * xd) / (-1.0i + xd)) / 2.0 + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) + power_of<2>(lnm2) / 4.0 + power_of<2>(log(-1.0 + wx * xdinv)) / 4.0 + (ln2 - log((-1.0i + wx) / wx) / 2.0) * log(1.0 + 1.0i * xd) - (log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))) / 2.0 - (ln2 * log((1.0i + xd) / (1.0i - xd))) / 2.0
                + log(1.0 - 1.0i * xd) * (-2.0 * ln2 - 2.0 * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 + log(0.5 + (1.0i / 2.0) * xd) / 2.0 - log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 - log(1.0 - xd / wx) / 2.0) - 2.0 * ln2 * log(1.0 - xd / wx) - power_of<2>(log(1.0 - xd / wx)) / 2.0 + (log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd))) / 2.0 + (2.0 * 1.0i) * M_PI * log(1.0 - wx * xdinv) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv))
                + dilog(2.0) * ((-1.0 / 12.0) * pisqu + dilog(1.0 - 1.0i * wx) / 4.0 + dilog(1.0 + 1.0i * wx) / 4.0 + dilog((-1.0i) * wx) / 2.0 + dilog(1.0i * wx) / 2.0 - dilog(1.0 - wx * xdinv) / 2.0 + dilog((-1.0i) * xd) / 2.0 + dilog(1.0i * xd) / 2.0 - dilog(xd / wx) - dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 - dilog(1.0 - xd / wx) / 2.0 - dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + power_of<2>(log(-1.0 - 1.0i * wx)) / 8.0 + (ln2 * log(1.0 - 1.0i * wx)) / 2.0 + power_of<2>(log(-1.0 + 1.0i * wx)) / 8.0 + (ln2 * log(1.0 + 1.0i * wx)) / 2.0 - (ln2 * log((-1.0i + wx) / wx)) / 2.0 - (ln2 * log((1.0i + wx) / wx)) / 2.0 - power_of<2>(log(-1.0 + wx * xdinv)) / 4.0 + ln2 * log(1.0 - 1.0i * xd)
                + ln2 * log(1.0 + 1.0i * xd) + (-log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx)) * log(xd) + (log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))) / 2.0 + (log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) / 2.0 - 8.0 * ln2 * log(1.0 - xd / wx) - power_of<2>(log(-1.0 + xd / wx)) / 4.0 + log(1.0 - wx * xdinv) * (1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)))
                + power_of<2>(log(1.0 - wx * xdinv)) * ((1.0i / 2.0) * M_PI * lnhalf * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 2.0) * M_PI * ln2 * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (1.0i / 2.0) * M_PI * log(wx / (-1.0i + wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 2.0) * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - 1.0i * M_PI * log(1.0 + 1.0i * xd) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (1.0i / 2.0) * M_PI * lnhalf * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 2.0) * M_PI * ln2 * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)
                + (1.0i / 2.0) * M_PI * log(wx / (1.0i + wx)) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) - (1.0i / 2.0) * M_PI * log((1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) - 1.0i * M_PI * log(1.0 - 1.0i * xd) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) + log(wx * xdinv) * ((-2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (2.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)))
                + power_of<2>(log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))) * (-(log((-1.0i + wx) / wx) * log((-1.0i + xd) / (-1.0i + wx))) + log((-1.0i + wx) / wx) * log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) + (log(1.0 + 1.0i * wx) * log(-((xd + 1.0i * wx * xd) / (wx - xd)))) / 2.0 + (2.0 * 1.0i) * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)))) * T(1.0, 1.0i / wx, ((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(((1.0i - wx) * xd) / (wx - xd))) * T(1.0, (-1.0i) * wx, (wx + 1.0i * wx * xd) / (wx - xd)))
                + power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd))) * (1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)))) * T(1.0, 1.0i / wx, ((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(((-1.0i + wx) * xd) / (-wx + xd))) * T(1.0, (-1.0i) * wx, (wx + 1.0i * wx * xd) / (wx - xd))) + log(wx * xdinv) * ((4.0 * pisqu * ln2) / 3.0 + (pisqu * log((-1.0i + wx) / wx)) / 4.0 + (pisqu * log((1.0i + wx) / wx)) / 4.0 + (-4.0 * ln2 - (3.0 * log((-1.0i + wx) / wx)) / 4.0 - (3.0 * log((1.0i + wx) / wx)) / 4.0) * power_of<2>(log(1.0 - xd / wx)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(real(1.0 / (1.0i - wx))) * T(1.0, (-1.0i) * wx, wx * xdinv)
                + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(1.0 / (1.0i + wx))) * T(1.0, 1.0i * wx, wx * xdinv)) + power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + xd)))) * (-(log((1.0i + wx) / wx) * log((1.0i + xd) / (1.0i + wx))) + log((1.0i + wx) / wx) * log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) + (2.0 * 1.0i) * M_PI * log((1.0i + wx) / wx) * my_sign(imag(((1.0i + wx) * xd) / (wx * (1.0i + xd)))) * T(1.0, -1.0i / wx, (1.0i * (wx - xd)) / (wx * (1.0i + xd))) + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(((1.0i + wx) * xd) / (wx - xd))) * T(1.0, 1.0i * wx, (wx - 1.0i * wx * xd) / (wx - xd)))
                + power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd))) * (1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(imag(((1.0i + wx) * xd) / (wx * (1.0i + xd)))) * T(1.0, -1.0i / wx, (1.0i * (wx - xd)) / (wx * (1.0i + xd))) + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(((1.0i + wx) * xd) / (-wx + xd))) * T(1.0, 1.0i * wx, (wx - 1.0i * wx * xd) / (wx - xd))) + (1.0i / 3.0) * power_of<3>(M_PI) * log(-((1.0i + wx) / wx)) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + (1.0i / 3.0) * M_PI * power_of<3>(log(-((1.0i + wx) / wx))) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<3>(log((-1.0i + xd) * xdinv)) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv)
                + trilog((-1.0i + xd) / (2.0 * xd)) * (log(1.0 - 1.0i * wx) - log((-1.0i + wx) / wx) + 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv)) + trilog((wx * (-1.0i + xd)) / ((1.0i + wx) * xd)) * ((4.0 * 1.0i) * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)) - (4.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv))
                + trilog((-1.0i + xd) * xdinv) * (-3.0 * ln2 - 3.0 * log(1.0 - 1.0i * wx) + (5.0 * log(1.0 + 1.0i * wx)) / 2.0 + 3.0 * log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) + (3.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(1.0 - xd / wx) + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(1.0i / wx, 1.0i / xd) * my_sign(real(1.0 / wx)) + 1.0i * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)) + (6.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv))
                + power_of<2>(log((-1.0i + xd) * xdinv)) * ((-1.0i) * M_PI * lnhalf * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * log(1.0i / (1.0i + wx)) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv)) + log(1.0i / xd) * ((-0.5) * (pisqu * ln2) - (pisqu * log(1.0 - 1.0i * wx)) / 3.0 + (pisqu * log(1.0 + 1.0i * wx)) / 4.0 - (pisqu * log((1.0i + wx) / wx)) / 6.0 + power_of<2>(log(1.0 + xdinv * xdinv)) * (((-0.5) * 1.0i) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)))
                + (3.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(imag(wx / (1.0i - wx))) * T(1.0, 1.0i / wx, 1.0i / xd) + (3.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + xd) * xdinv)) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv)) + (1.0i / 3.0) * power_of<3>(M_PI) * log(-1.0 + 1.0i / wx) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) + (1.0i / 3.0) * M_PI * power_of<3>(log(-1.0 + 1.0i / wx)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<3>(log((1.0i + xd) * xdinv)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv)
                + trilog((1.0i + xd) / (2.0 * xd)) * (log(1.0 + 1.0i * wx) - log((1.0i + wx) / wx) + 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv)) + trilog((wx * (1.0i + xd)) / ((-1.0i + wx) * xd)) * ((4.0 * 1.0i) * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv)) - (4.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv))
                + trilog((1.0i + xd) * xdinv) * (-3.0 * ln2 + (5.0 * log(1.0 - 1.0i * wx)) / 2.0 - 3.0 * log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) + 3.0 * log((1.0i + wx) / wx) + (3.0 * log(1.0 - 1.0i * xd)) / 2.0 - log(1.0 - xd / wx) + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H2(-1.0i / wx, -1.0i / xd) * my_sign(-real(1.0 / wx)) + 1.0i * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)) + (6.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv))
                + power_of<2>(log((1.0i + xd) * xdinv)) * ((-1.0i) * M_PI * lnhalf * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * log(-1.0i / (-1.0i + wx)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv)) + log(-1.0i / xd) * ((-0.5) * (pisqu * ln2) + (pisqu * log(1.0 - 1.0i * wx)) / 4.0 - (pisqu * log(1.0 + 1.0i * wx)) / 3.0 - (pisqu * log((-1.0i + wx) / wx)) / 6.0 + power_of<2>(log(1.0 + xdinv * xdinv)) * (((-0.5) * 1.0i) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)))
                + (3.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-imag(wx / (1.0i + wx))) * T(1.0, -1.0i / wx, -1.0i / xd) + (3.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + xd) * xdinv)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv)) + power_of<2>(log(0.5 - (1.0i / 2.0) * xd)) * log(1.0 + 1.0i * xd) * (-log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (wx - xd))) - log(((-2.0 * 1.0i) * (wx - xd)) / ((1.0i + wx) * (-1.0i + xd))) + (3.0 * 1.0i) * M_PI * my_sign(real(xd) / 2.0) * T(1.0, (wx - xd) / (-1.0i + wx), ((-0.5) * 1.0i) * (1.0i + xd))) - (1.0i / 3.0) * power_of<3>(M_PI) * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + 1.0i * M_PI * lnhalf * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)
                - 1.0i * M_PI * ln2 * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (3.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + ((2.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * log((-1.0i + wx) / wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)
                + power_of<3>(log(-1.0 - 1.0i * xd)) * ((-0.25) * ln2 - log(1.0 - 1.0i * wx) / 6.0 + log(1.0 - xd / wx) / 12.0 + (1.0i / 3.0) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + trilog(1.0 + 1.0i * xd) * ((-3.0 * ln2) / 2.0 - log(1.0 - 1.0i * wx) + 2.0 * log(1.0 + 1.0i * wx) + 2.0 * log((-1.0i) * wx) + log(wx / (-1.0i + wx)) + 4.0 * log((-1.0i + wx) / wx) + log((-1.0i + wx) / (wx - xd)) + log((1.0i + wx) / (wx - xd)) + 2.0 * log(1.0 + 1.0i * xd) + log(1.0 - xd / wx) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx))
                + trilog(1.0 - 1.0i * wx) * ((-3.0 * ln2) / 2.0 - 3.0 * log(1.0i * wx) - log((-1.0i + wx) / wx) + log(wx / (wx - xd)) + 5.0 * log(1.0 - 1.0i * xd) - 2.0 * log(1.0 + 1.0i * xd) + log(xd) + log((-2.0 * 1.0i) / (-1.0i + xd)) / 2.0 - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 - log((-1.0i + xd) * xdinv) - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - (9.0 * log(1.0 - xd / wx)) / 2.0 + log((wx - 1.0i * wx * xd) / (wx - xd)) + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(1.0i / xd, wx * xdinv) * my_sign(real(xdinv)) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) + (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx))
                + trilog((1.0i + wx) / (1.0i - xd)) * ((4.0 * 1.0i) * M_PI * H2((-1.0i) * wx, wx * xdinv) * my_sign(-real(wx)) - (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + trilog(0.5 - (1.0i / 2.0) * wx) * (lnhalf / 2.0 - log(0.5 + (1.0i / 2.0) * xd) / 2.0 - log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) + log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 - log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + log(-1.0 - 1.0i * xd) * ((-0.25) * (pisqu * ln2) - (pisqu * log(1.0 - 1.0i * wx)) / 6.0 + (pisqu * log(1.0 - xd / wx)) / 12.0 + (1.0i / 3.0) * power_of<3>(M_PI) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx))
                + power_of<2>(log(-1.0 - 1.0i * xd)) * (pisqu / 24.0 + power_of<2>(log(-1.0 + 1.0i * wx)) / 8.0 - 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + log((-1.0i + xd) * xdinv) * ((-1.0 / 6.0) * (pisqu * log(-1.0 + 1.0i * wx)) - power_of<3>(log(-1.0 + 1.0i * wx)) / 6.0 - ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<2>(log(-((1.0i + wx) / wx))) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + 1.0i * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx))
                + log(1.0i * xd) * ((-0.5) * (log(1.0 - 1.0i * wx) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + xd))))) - (power_of<2>(log((1.0i + xd) / (1.0i + wx))) * log(1.0 - xd / wx)) / 2.0 - (log(1.0 - 1.0i * wx) * power_of<2>(log((wx - 1.0i * wx * xd) / (wx - xd)))) / 2.0 + (3.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + dilog(0.5 - (1.0i / 2.0) * wx) * ((-0.25) * dilog(0.5 - (1.0i / 2.0) * xd) + dilog(1.0i * xd) - dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 + 2.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 + 1.0i * xd) + (log(1.0 - 1.0i * wx) - log((1.0i + wx) / wx) - log(xd)) * log(1.0 - xd / wx)
                + log(1.0 + 1.0i * xd) * (log(1.0 - 1.0i * wx) - 2.0 * log(wx / (1.0i + wx)) - (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) + log(1.0 - 1.0i * xd) * (-log(1.0 - 1.0i * wx) - 2.0 * log(wx / (1.0i + wx)) + 2.0 * log((1.0i + wx) / wx) + 2.0 * log((wx - xd) / (1.0i + wx)) - (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)))
                + trilog(((-0.5) * 1.0i) * (1.0i + xd)) * (-log(1.0 + 1.0i * wx) - log(wx / (1.0i + wx)) / 2.0 - 3.0 * log((-1.0i + wx) / (1.0i + wx)) + (3.0 * log((1.0i + wx) / wx)) / 2.0 - log(1.0 - wx * xdinv) / 2.0 - log((wx - xd) / (1.0i + wx)) - log(1.0 - 1.0i * xd) + 2.0 * log(1.0 + 1.0i * xd) - log(xd) + log(-(xd / (wx - xd))) / 2.0 - 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx))
                + log(0.5 + (1.0i / 2.0) * xd) * ((-0.5) * (log(xd) * power_of<2>(log((1.0i + wx) / (1.0i + xd)))) - ((5.0 * 1.0i) / 2.0) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)) + log((-2.0 * 1.0i) / (-1.0i + xd)) * ((pisqu * log(-1.0 + 1.0i * wx)) / 12.0 + power_of<3>(log(-1.0 + 1.0i * wx)) / 12.0 - (pisqu * log(-1.0 + xd / wx)) / 12.0 - power_of<3>(log(-1.0 + xd / wx)) / 12.0 - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx))
                + dilog(0.5 - (1.0i / 2.0) * xd) * ((-3.0 * dilog((1.0i + xd) / (1.0i + wx))) / 2.0 - dilog(1.0 - xd / wx) / 2.0 - dilog((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + power_of<2>(log(-1.0 + 1.0i * wx)) / 4.0 + log(xd) * (-log((1.0i + wx) / (1.0i + xd)) + log(1.0 - xd / wx)) - power_of<2>(log(-1.0 + xd / wx)) / 4.0 - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (2.0 * 1.0i) * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)
                + log(1.0 - 1.0i * xd) * (log(1.0 + 1.0i * wx) + log(wx / (1.0i + wx)) / 2.0 - (3.0 * log((1.0i + wx) / wx)) / 2.0 + log(1.0 - wx * xdinv) / 2.0 - log(-(xd / (wx - xd))) / 2.0 + 2.0 * log(1.0 - xd / wx) + (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx))) - (1.0i / 3.0) * power_of<3>(M_PI) * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + 1.0i * M_PI * lnhalf * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - 1.0i * M_PI * ln2 * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)
                + (3.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + ((2.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * log((-1.0i) * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * log((1.0i + wx) / wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + power_of<3>(log(-1.0 + 1.0i * xd)) * ((-0.25) * ln2 - log(1.0 + 1.0i * wx) / 6.0 + log(1.0 - xd / wx) / 12.0 + (1.0i / 3.0) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + li3half * (log(1.0 - 1.0i * wx) / 2.0 + log(1.0 + 1.0i * wx) / 2.0 + log(wx / (-1.0i + wx)) / 2.0 - log((-1.0i + wx) / wx) + log(wx / (1.0i + wx)) / 2.0 + 3.0 * log((-1.0i + wx) / (1.0i + wx)) - log((1.0i + wx) / wx) + 3.0 * log((1.0i + wx) / (-1.0i + wx)) + log((wx - xd) / (-1.0i + wx)) + log((wx - xd) / (1.0i + wx)) - 5.0 * log(1.0 - 1.0i * xd) - 5.0 * log(1.0 + 1.0i * xd) - log(-(xd / (wx - xd))) - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + 4.0 * log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0
                - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) + (2.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + (2.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + trilog(1.0 - 1.0i * xd) * ((-3.0 * ln2) / 2.0 + 2.0 * log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx) + 2.0 * log(1.0i * wx) + log(wx / (1.0i + wx)) + 4.0 * log((1.0i + wx) / wx) + log((-1.0i + wx) / (wx - xd)) + log((1.0i + wx) / (wx - xd)) + 2.0 * log(1.0 - 1.0i * xd) + log(1.0 - xd / wx) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + trilog(1.0 + 1.0i * wx) * ((-3.0 * ln2) / 2.0 - 3.0 * log((-1.0i) * wx) - log((1.0i + wx) / wx) + log(wx / (wx - xd)) - 2.0 * log(1.0 - 1.0i * xd) + 5.0 * log(1.0 + 1.0i * xd) + log(xd) - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + log((2.0 * 1.0i) / (1.0i + xd)) / 2.0 - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 - log((1.0i + xd) * xdinv) - (9.0 * log(1.0 - xd / wx)) / 2.0 + log((wx + 1.0i * wx * xd) / (wx - xd)) + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(-1.0i / xd, wx * xdinv) * my_sign(-real(xdinv)) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) + (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + trilog((1.0i - wx) / (1.0i + xd)) * ((4.0 * 1.0i) * M_PI * H2(1.0i * wx, wx * xdinv) * my_sign(real(wx)) - (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + trilog(0.5 + (1.0i / 2.0) * wx) * (lnhalf / 2.0 - log(0.5 - (1.0i / 2.0) * xd) / 2.0 - log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 - log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 + (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + log(-1.0 + 1.0i * xd) * ((-0.25) * (pisqu * ln2) - (pisqu * log(1.0 + 1.0i * wx)) / 6.0 + (pisqu * log(1.0 - xd / wx)) / 12.0 + (1.0i / 3.0) * power_of<3>(M_PI) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + power_of<2>(log(-1.0 + 1.0i * xd)) * (pisqu / 24.0 + power_of<2>(log(-1.0 - 1.0i * wx)) / 8.0 - 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + dilog(1.0 - 1.0i * xd) * ((-1.0 / 12.0) * pisqu - dilog(xd / wx) + dilog((-1.0i + xd) / (-1.0i + wx)) + dilog((1.0i + xd) / (1.0i + wx)) / 2.0 + power_of<2>(log(-1.0 - 1.0i * wx)) / 4.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 2.0 + log((1.0i + wx) / (wx - xd)) * log(1.0 - 1.0i * xd) - log((-1.0i + wx) / (wx - xd)) * log(1.0 + 1.0i * xd) + log(1.0 - 1.0i * wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx) - log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd))
                - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + dilog(1.0 + 1.0i * xd) * ((-1.0 / 12.0) * pisqu - dilog(xd / wx) + dilog((-1.0i + xd) / (-1.0i + wx)) / 2.0 + dilog((1.0i + xd) / (1.0i + wx)) - power_of<2>(log(-1.0 - 1.0i * wx)) / 2.0 + power_of<2>(log(-1.0 + 1.0i * wx)) / 4.0 - log((1.0i + wx) / (wx - xd)) * log(1.0 - 1.0i * xd) + log((-1.0i + wx) / (wx - xd)) * log(1.0 + 1.0i * xd) + log(1.0 + 1.0i * wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx)
                - log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + log((1.0i + xd) * xdinv) * ((-1.0 / 6.0) * (pisqu * log(-1.0 - 1.0i * wx)) - power_of<3>(log(-1.0 - 1.0i * wx)) / 6.0 - ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<2>(log(-1.0 + 1.0i / wx)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) + 1.0i * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx))
                + log((-1.0i) * xd) * ((-0.5) * (log(1.0 + 1.0i * wx) * power_of<2>(log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))))) - (power_of<2>(log((-1.0i + xd) / (-1.0i + wx))) * log(1.0 - xd / wx)) / 2.0 - (log(1.0 + 1.0i * wx) * power_of<2>(log((wx + 1.0i * wx * xd) / (wx - xd)))) / 2.0 + (3.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + dilog(0.5 + (1.0i / 2.0) * wx) * ((-0.25) * dilog(0.5 + (1.0i / 2.0) * xd) + dilog((-1.0i) * xd) - dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + 2.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + (log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) - log(xd)) * log(1.0 - xd / wx)
                + log(1.0 + 1.0i * xd) * (-log(1.0 + 1.0i * wx) - 2.0 * log(wx / (-1.0i + wx)) + 2.0 * log((-1.0i + wx) / wx) - (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + log(1.0 - 1.0i * xd) * (log(1.0 + 1.0i * wx) - 2.0 * log(wx / (-1.0i + wx)) + 2.0 * log((wx - xd) / (-1.0i + wx)) - (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)))
                + li2half * (dilog(0.5 - (1.0i / 2.0) * wx) / 4.0 + dilog(0.5 + (1.0i / 2.0) * wx) / 4.0 - dilog((-1.0i) * wx) / 2.0 - dilog(1.0i * wx) / 2.0 + (5.0 * dilog(-1.0i / (-1.0i + wx))) / 4.0 - dilog((-1.0i + wx) / (2.0 * wx)) / 4.0 + (5.0 * dilog(1.0i / (1.0i + wx))) / 4.0 - dilog((1.0i + wx) / (2.0 * wx)) / 4.0 - dilog(wx / (wx - xd)) / 2.0 - dilog((-1.0i) * xd) / 2.0 - dilog(1.0i * xd) / 2.0 + dilog(xd / wx) - dilog(-(xd / (wx - xd))) / 2.0 + dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 + dilog(xd / (-1.0i + xd)) / 2.0 - dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + dilog((-1.0i + xd) / (-1.0i + wx)) + dilog(xd / (1.0i + xd)) / 2.0
                - dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) + dilog((1.0i + xd) / (1.0i + wx)) + dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) - 2.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 + 1.0i * xd) - log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + (log(1.0 - 1.0i * wx) * log((wx - 1.0i * wx * xd) / (wx - xd))) / 2.0 + (log(1.0 + 1.0i * wx) * log((wx + 1.0i * wx * xd) / (wx - xd))) / 2.0
                + log(1.0 - wx * xdinv) * ((-1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)) + (2.0 * 1.0i) * M_PI * log((-1.0i + xd) * xdinv) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + (2.0 * 1.0i) * M_PI * log((1.0i + xd) * xdinv) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)
                + log(1.0 + 1.0i * xd) * (2.0 * log(wx / (-1.0i + wx)) + 2.0 * log(wx / (1.0i + wx)) + (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + log(1.0 - 1.0i * xd) * (2.0 * log(wx / (-1.0i + wx)) + 2.0 * log(wx / (1.0i + wx)) - 2.0 * log((wx - xd) / (-1.0i + wx)) - log((wx - xd) / (1.0i + wx)) + (4.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (4.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)))
                + trilog((wx - xd) / (2.0 * wx)) * ((-2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)) + trilog(0.5 + (1.0i / 2.0) * xd) * (-log(1.0 - 1.0i * wx) - log(wx / (-1.0i + wx)) / 2.0 + (3.0 * log((-1.0i + wx) / wx)) / 2.0 - 3.0 * log((1.0i + wx) / (-1.0i + wx)) - log(1.0 - wx * xdinv) / 2.0 - log((wx - xd) / (-1.0i + wx)) + 2.0 * log(1.0 - 1.0i * xd) - log(1.0 + 1.0i * xd) - log(xd) + log(-(xd / (wx - xd))) / 2.0 - 2.0 * log(1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + (2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx))
                + log((2.0 * 1.0i) / (1.0i + xd)) * ((pisqu * log(-1.0 - 1.0i * wx)) / 12.0 + power_of<3>(log(-1.0 - 1.0i * wx)) / 12.0 - (pisqu * log(-1.0 + xd / wx)) / 12.0 - power_of<3>(log(-1.0 + xd / wx)) / 12.0 - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx))
                + dilog(0.5 + (1.0i / 2.0) * xd) * ((-3.0 * dilog((-1.0i + xd) / (-1.0i + wx))) / 2.0 - dilog(1.0 - xd / wx) / 2.0 - dilog((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 + power_of<2>(log(-1.0 - 1.0i * wx)) / 4.0 + log(xd) * (-log((-1.0i + wx) / (-1.0i + xd)) + log(1.0 - xd / wx)) - power_of<2>(log(-1.0 + xd / wx)) / 4.0 - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + (2.0 * 1.0i) * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)
                + log(1.0 + 1.0i * xd) * (log(1.0 - 1.0i * wx) + log(wx / (-1.0i + wx)) / 2.0 - (3.0 * log((-1.0i + wx) / wx)) / 2.0 + log(1.0 - wx * xdinv) / 2.0 - log(-(xd / (wx - xd))) / 2.0 + 2.0 * log(1.0 - xd / wx) + (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (2.0 * 1.0i) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx))) + log(0.5 - (1.0i / 2.0) * xd) * ((-0.5) * (log(xd) * power_of<2>(log((-1.0i + wx) / (-1.0i + xd)))) - ((5.0 * 1.0i) / 2.0) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)
                + power_of<2>(log(1.0 + 1.0i * xd)) * (log(1.0 - 1.0i * wx) / 4.0 - log(1.0 + 1.0i * wx) / 4.0 + log(wx / (-1.0i + wx)) / 4.0 - log((-1.0i + wx) / wx) / 2.0 - log(-(xd / (wx - xd))) / 4.0 + log(1.0 - xd / wx) / 2.0 + (1.0i / 2.0) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (1.0i / 2.0) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)) + log(1.0 + 1.0i * xd) * ((-1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)))
                + dilog(-1.0) * ((-7.0 * pisqu) / 6.0 - dilog(1.0 - 1.0i * wx) - dilog(1.0 + 1.0i * wx) + dilog(-1.0i / (-1.0i + wx)) + dilog(1.0i / (1.0i + wx)) - dilog(1.0 - wx * xdinv) + 2.0 * dilog(wx / (wx - xd)) - dilog((-1.0i) * xd) - dilog(1.0i * xd) + 8.0 * dilog(xd / wx) + dilog(-(xd / (wx - xd))) - dilog((1.0i * (1.0i + wx) * xd) / (wx - xd)) + dilog(xd / (-1.0i + xd)) - 2.0 * dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) - 2.0 * dilog((-1.0i + xd) / (-1.0i + wx)) - dilog((-1.0i + xd) * xdinv) + dilog(xd / (1.0i + xd)) - 2.0 * dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) - 2.0 * dilog((1.0i + xd) / (1.0i + wx)) - dilog((1.0i + xd) * xdinv)
                - 2.0 * dilog(1.0 - xd / wx) - 2.0 * dilog((wx - 1.0i * wx * xd) / (wx - xd)) - 2.0 * dilog((wx + 1.0i * wx * xd) / (wx - xd)) - dilog(-((xd + 1.0i * wx * xd) / (wx - xd))) - power_of<2>(log(-1.0 - 1.0i * wx)) / 2.0 - power_of<2>(log(-1.0 + 1.0i * wx)) / 2.0 - power_of<2>(log(-1.0 + 1.0i / xd)) / 2.0 - power_of<2>(log(-1.0 + wx * xdinv)) / 2.0 + (log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx)) * log(xd) + (log(1.0 + 1.0i * wx) / 2.0 - log((-1.0i + wx) / wx)) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + (log(1.0 - 1.0i * wx) / 2.0 - log((1.0i + wx) / wx)) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - power_of<2>(log(-((1.0i + xd) * xdinv))) / 2.0
                + log(1.0 - 1.0i * xd) * (3.0 * log(1.0 - 1.0i * wx) + 2.0 * log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) + log((1.0i + wx) / (wx - xd)) - log((wx - xd) / (1.0i + wx)) + log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) - log((1.0i * (1.0i + wx) * xd) / (wx - xd)) + 2.0 * log(1.0 - xd / wx)) - power_of<2>(log(-1.0 + xd / wx)) + ((-0.5) * log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx)) * log((wx - 1.0i * wx * xd) / (wx - xd)) + ((-0.5) * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx)) * log((wx + 1.0i * wx * xd) / (wx - xd))
                + log(1.0 + 1.0i * xd) * (2.0 * log(1.0 - 1.0i * wx) + 3.0 * log(1.0 + 1.0i * wx) - log((1.0i + wx) / wx) + log((-1.0i + wx) / (wx - xd)) - log((wx - xd) / (-1.0i + wx)) + log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) + 2.0 * log(1.0 - xd / wx) - log(-((xd + 1.0i * wx * xd) / (wx - xd)))) + log(1.0 - wx * xdinv) * ((-2.0 * 1.0i) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) - (2.0 * 1.0i) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv)) - (4.0 * 1.0i) * M_PI * log((-1.0i + xd) * xdinv) * my_sign(-real(wx)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - (4.0 * 1.0i) * M_PI * log((1.0i + xd) * xdinv) * my_sign(real(wx)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv)
                - (4.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (4.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + log(1.0 - xd / wx) * (-log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) - log((1.0i + wx) / wx) - (4.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) - (4.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)))
                + power_of<2>(log((-1.0i + wx) / (wx - xd))) * log(1.0 + 1.0i * xd) * (log(xd / wx) / 2.0 - log((-1.0i + xd) / (-1.0i + wx)) / 2.0 + log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) / 2.0 + 1.0i * M_PI * my_sign(imag((-1.0i + xd) / (-1.0i + wx))) * T(1.0, (-1.0i) * xd, (wx - xd) / (-1.0i + wx))) + power_of<2>(log((1.0i + wx) / (wx - xd))) * log(1.0 - 1.0i * xd) * (log(xd / wx) / 2.0 - log((1.0i + xd) / (1.0i + wx)) / 2.0 + log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) / 2.0 + 1.0i * M_PI * my_sign(imag((1.0i + xd) / (1.0i + wx))) * T(1.0, 1.0i * xd, (wx - xd) / (1.0i + wx)))
                + power_of<2>(log((wx - xd) / (1.0i + wx))) * ((2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * xd) * my_sign(imag((1.0i + xd) / (1.0i + wx))) * T(1.0, 0.5 + (1.0i / 2.0) * xd, (wx - xd) / (1.0i + wx)) + log(1.0 - 1.0i * xd) * (-log(wx * xdinv) - log(xd / wx) / 2.0 + (3.0 * log((-1.0i + wx) / (-1.0i + xd))) / 2.0 + (3.0 * log((-1.0i + xd) / (-1.0i + wx))) / 2.0 + log((1.0i + wx) / (1.0i + xd)) / 2.0 + log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) / 2.0 - (3.0 * log(((1.0i + wx) * (-1.0i + xd)) / ((-1.0i + wx) * (1.0i + xd)))) / 2.0 + log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) - (3.0 * log(((-1.0i + wx) * (1.0i + xd)) / ((1.0i + wx) * (-1.0i + xd)))) / 2.0
                    + (2.0 * 1.0i) * M_PI * my_sign(imag((1.0i + xd) / (1.0i + wx))) * T(1.0, 0.5 + (1.0i / 2.0) * xd, (wx - xd) / (1.0i + wx)) + 1.0i * M_PI * my_sign(imag((1.0i + xd) / (1.0i + wx))) * T(1.0, 1.0i * xd, (wx - xd) / (1.0i + wx)))) + power_of<2>(log((-1.0i + xd) / (-1.0i + wx))) * log(1.0 - xd / wx) * (log(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 - 1.0i * M_PI * my_sign(imag((wx - xd) / (-1.0i + wx))) * T(1.0, xd / wx, (-1.0i + xd) / (-1.0i + wx))) - 1.0i * M_PI * power_of<2>(log((1.0i + xd) / (1.0i + wx))) * log(1.0 - xd / wx) * my_sign(imag((wx - xd) / (1.0i + wx))) * T(1.0, xd / wx, (1.0i + xd) / (1.0i + wx))
                + power_of<2>(log(-1.0i / (-1.0i + xd))) * (pisqu / 3.0 + (2.0 * 1.0i) * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(xd / (1.0i - xd))) * T(1.0, ((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)), -1.0i / (-1.0i + xd))) + power_of<2>(log(1.0i / (1.0i + xd))) * (pisqu / 3.0 + (2.0 * 1.0i) * M_PI * log((1.0i + wx) / wx) * my_sign(-imag(xd / (1.0i + xd))) * T(1.0, (1.0i * (wx - xd)) / (wx * (1.0i + xd)), 1.0i / (1.0i + xd)))
                + power_of<2>(log((wx - xd) / (-1.0i + wx))) * ((2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * xd) * my_sign(imag((-1.0i + xd) / (-1.0i + wx))) * T(1.0, ((-0.5) * 1.0i) * (1.0i + xd), (wx - xd) / (-1.0i + wx)) + log(1.0 + 1.0i * xd) * (-log(wx * xdinv) - log(xd / wx) / 2.0 + log((-1.0i + wx) / (-1.0i + xd)) / 2.0 + log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) / 2.0 + log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) + (3.0 * log((1.0i + wx) / (1.0i + xd))) / 2.0 - (3.0 * log(((1.0i + wx) * (-1.0i + xd)) / ((-1.0i + wx) * (1.0i + xd)))) / 2.0 + (3.0 * log((1.0i + xd) / (1.0i + wx))) / 2.0 - (3.0 * log(((-1.0i + wx) * (1.0i + xd)) / ((1.0i + wx) * (-1.0i + xd)))) / 2.0
                    + 1.0i * M_PI * my_sign(imag((-1.0i + xd) / (-1.0i + wx))) * T(1.0, (-1.0i) * xd, (wx - xd) / (-1.0i + wx)) + (2.0 * 1.0i) * M_PI * my_sign(imag((-1.0i + xd) / (-1.0i + wx))) * T(1.0, ((-0.5) * 1.0i) * (1.0i + xd), (wx - xd) / (-1.0i + wx)))) + 1.0i * M_PI * trilog((1.0 + 1.0i * wx) / (1.0i * wx + wx * xd)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + (1.0i / 3.0) * power_of<3>(M_PI) * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + (2.0 * 1.0i) * M_PI * ln2 * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + (1.0i / 2.0) * M_PI * log(1.0 - 1.0i * wx) * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) - 1.0i * M_PI * log(1.0i / wx) * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + (1.0i / 3.0) * M_PI * power_of<3>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + (1.0i / 2.0) * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * log(1.0i / (1.0i + wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + trilog(wx / (1.0i + wx)) * (-ln2 - log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) / 2.0 - log(1.0i / (1.0i + wx)) + log(1.0 - 1.0i * xd) + log(xd) - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - log(xd / (-1.0i + xd)) / 2.0 + log((-1.0i + xd) / (-1.0i + wx)) / 2.0 - log((1.0i - xd) / (1.0i + xd)) / 2.0 + log(1.0 - xd / wx) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(-real(xdinv)) + (2.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))
                + trilog(1.0i / (1.0i + xd)) * ((-3.0 * ln2) / 2.0 + log(1.0 - 1.0i * wx) / 2.0 - log(1.0 + 1.0i * wx) - log((-1.0i + wx) / wx) + log((1.0i + wx) / wx) / 2.0 - log((wx - xd) / (-1.0i + wx)) - log(1.0 - 1.0i * xd) / 2.0 - log(xd) + log((-1.0i + xd) / (-1.0i + wx)) / 2.0 - (3.0 * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - 1.0i * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))
                + trilog((-1.0i + wx) / wx) * (log(1.0 - 1.0i * wx) - log(1.0 + 1.0i * wx) + log(1.0 - 1.0i * xd) + (11.0 * log(1.0 + 1.0i * xd)) / 2.0 - 2.0 * log(-1.0i / (-1.0i + xd)) - 2.0 * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - 3.0 * log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd)) + log((wx + 1.0i * wx * xd) / (wx - xd)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(imag(wx * xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(-real(xdinv)) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(real(xdinv)) + (2.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - (2.0 * 1.0i) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))
                + dilog(wx / (1.0i + wx)) * (pisqu / 6.0 - dilog((2.0 * wx) / (1.0i + wx)) / 4.0 - dilog((-1.0i + wx) / (1.0i + wx)) / 4.0 + dilog((wx - xd) / (-1.0i + wx)) / 2.0 - dilog((wx - xd) / (1.0i + wx)) / 2.0 + (3.0 * dilog((-1.0i) * xd)) / 2.0 + dilog(xd / wx) - dilog(-1.0i / (-1.0i + xd)) / 4.0 + dilog(xd / (-1.0i + xd)) / 2.0 - dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + dilog(xd / (1.0i + xd)) / 4.0 - dilog((2.0 * xd) / (1.0i + xd)) / 2.0 - dilog(1.0 - xd / wx) + log(1.0 - 1.0i * wx) * log(1.0i * wx) - log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - (ln2 * log((1.0i - xd) / (1.0i + xd))) / 2.0
                + (log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log((-1.0i + xd) * xdinv) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)) + dilog(1.0i / (1.0i + xd)) * (-(log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd)) + (log((-1.0i + xd) / (-1.0i + wx)) * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))
                + log(xd / (1.0i + xd)) * ((-1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + (1.0i / 2.0) * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)) + dilog((-1.0i + wx) / (1.0i + wx)) * (pisqu / 24.0 + dilog((1.0i + wx) / wx) / 4.0 + dilog((wx - xd) / (1.0i + wx)) / 2.0 + dilog((-1.0i) * xd) - 2.0 * dilog(xd / wx) + dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + power_of<2>(log(-((1.0i + wx) / wx))) / 8.0 + (log((-1.0i + wx) / wx) * log(1.0 - 1.0i * xd)) / 2.0 + ((3.0 * log(1.0 + 1.0i * wx)) / 2.0 - log((-1.0i + wx) / wx)) * log(1.0 + 1.0i * xd) - (3.0 * power_of<2>(log(1.0 + 1.0i * xd))) / 2.0
                + (-log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx)) * log(1.0 - xd / wx) + log(xd) * (log(1.0 + 1.0i * wx) - log((-1.0i + wx) / (-1.0i + xd)) - (2.0 * 1.0i) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))) + dilog((1.0i + wx) / wx) * ((-1.0 / 12.0) * pisqu + dilog((-1.0i) * xd) - dilog(xd / wx) + dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + dilog((-1.0i + xd) * xdinv) / 2.0 + 2.0 * dilog(xd / (1.0i + xd)) - 3.0 * dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) - dilog((1.0i + xd) * xdinv) - ln2 * log(1.0 - 1.0i * wx) - log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx) - log(1.0 - 1.0i * wx) * log(1.0i * wx) + power_of<2>(log(-1.0 + 1.0i / xd)) / 4.0
                - (5.0 * log(1.0 - 1.0i * wx) * log(1.0 - 1.0i * xd)) / 2.0 + power_of<2>(log(1.0 - 1.0i * xd)) / 2.0 + 2.0 * log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * xd) - 2.0 * log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - power_of<2>(log(-((1.0i + xd) * xdinv))) / 2.0 + (2.0 * log(1.0 - 1.0i * wx) - log((1.0i + xd) / (1.0i + wx))) * log(1.0 - xd / wx) + log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) - log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(imag(wx * xdinv)) + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(real(xdinv))
                - (2.0 * 1.0i) * M_PI * log((-1.0i + xd) * xdinv) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + log(xd) * (log(1.0 + 1.0i * wx) - log((-1.0i + wx) / (-1.0i + xd)) - (2.0 * 1.0i) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))) + 1.0i * M_PI * trilog((1.0 - 1.0i * wx) / (wx * (-1.0i + xd))) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + (1.0i / 3.0) * power_of<3>(M_PI) * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + (2.0 * 1.0i) * M_PI * ln2 * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)
                + (1.0i / 2.0) * M_PI * log(1.0 + 1.0i * wx) * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) - 1.0i * M_PI * log(-1.0i / wx) * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + (1.0i / 2.0) * M_PI * log(-1.0i / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + (1.0i / 3.0) * M_PI * power_of<3>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)
                + trilog(wx / (-1.0i + wx)) * (-ln2 - log(1.0 - 1.0i * wx) / 2.0 - log(1.0 + 1.0i * wx) - log(-1.0i / (-1.0i + wx)) - log(1.0i / (1.0i + wx)) / 2.0 + log(1.0 + 1.0i * xd) + log(xd) - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - log(xd / (1.0i + xd)) / 2.0 + log((1.0i + xd) / (1.0i + wx)) / 2.0 - log((1.0i + xd) / (1.0i - xd)) / 2.0 + log(1.0 - xd / wx) + 1.0i * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(real(xdinv)) + (2.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))
                + trilog(-1.0i / (-1.0i + xd)) * ((-3.0 * ln2) / 2.0 - log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 2.0 + log((-1.0i + wx) / wx) / 2.0 - log((1.0i + wx) / wx) - log((wx - xd) / (1.0i + wx)) - log(1.0 + 1.0i * xd) / 2.0 - log(xd) + log((1.0i + xd) / (1.0i + wx)) / 2.0 - (3.0 * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - 1.0i * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))
                + trilog((1.0i + wx) / wx) * (-log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) + (11.0 * log(1.0 - 1.0i * xd)) / 2.0 + log(1.0 + 1.0i * xd) - 2.0 * log(1.0i / (1.0i + xd)) - 2.0 * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - 3.0 * log(1.0 - xd / wx) + log((wx - 1.0i * wx * xd) / (wx - xd)) + log((wx + 1.0i * wx * xd) / (wx - xd)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H2(wx * xdinv, -1.0i / xd) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * H2(wx * xdinv, 1.0i / xd) * my_sign(real(xdinv)) + (2.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - (2.0 * 1.0i) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))
                + dilog(wx / (-1.0i + wx)) * (pisqu / 6.0 - dilog((2.0 * wx) / (-1.0i + wx)) / 4.0 - dilog(wx / (1.0i + wx)) / 2.0 - dilog((1.0i + wx) / (-1.0i + wx)) / 4.0 - dilog((wx - xd) / (-1.0i + wx)) / 2.0 + dilog((wx - xd) / (1.0i + wx)) / 2.0 + (3.0 * dilog(1.0i * xd)) / 2.0 + dilog(xd / wx) + dilog(xd / (-1.0i + xd)) / 4.0 - dilog((2.0 * xd) / (-1.0i + xd)) / 2.0 - dilog(1.0i / (1.0i + xd)) / 4.0 + dilog(xd / (1.0i + xd)) / 2.0 - dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) - dilog(1.0 - xd / wx) + log(1.0 + 1.0i * wx) * log((-1.0i) * wx) - log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - (ln2 * log((1.0i + xd) / (1.0i - xd))) / 2.0
                + (log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log((1.0i + xd) * xdinv) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)) + dilog(-1.0i / (-1.0i + xd)) * (-dilog((1.0i + xd) / (1.0i + wx)) - log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) + (log((1.0i + xd) / (1.0i + wx)) * log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))
                + log(xd / (-1.0i + xd)) * ((-0.25) * (log((1.0i + xd) / (1.0i + wx)) * power_of<2>(log(1.0 - xd / wx))) - 1.0i * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (1.0i / 2.0) * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)) + dilog((1.0i + wx) / (-1.0i + wx)) * (pisqu / 24.0 + dilog((wx - xd) / (-1.0i + wx)) / 2.0 + dilog(1.0i * xd) - 2.0 * dilog(xd / wx) + dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) + power_of<2>(log(-1.0 + 1.0i / wx)) / 8.0 + ((3.0 * log(1.0 - 1.0i * wx)) / 2.0 - log((1.0i + wx) / wx)) * log(1.0 - 1.0i * xd) - (3.0 * power_of<2>(log(1.0 - 1.0i * xd))) / 2.0 + (log((1.0i + wx) / wx) * log(1.0 + 1.0i * xd)) / 2.0
                + (-log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx)) * log(1.0 - xd / wx) + log(xd) * (log(1.0 - 1.0i * wx) - log((1.0i + wx) / (1.0i + xd)) - (2.0 * 1.0i) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))) + dilog((-1.0i + wx) / wx) * ((-1.0 / 12.0) * pisqu + dilog((1.0i + wx) / (-1.0i + wx)) / 4.0 + dilog(1.0i * xd) - dilog(xd / wx) + 2.0 * dilog(xd / (-1.0i + xd)) - 3.0 * dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) - dilog((-1.0i + xd) * xdinv) + dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) + dilog((1.0i + xd) * xdinv) / 2.0 - ln2 * log(1.0 + 1.0i * wx) - log(1.0 - 1.0i * wx) * log(1.0 + 1.0i * wx)
                - log(1.0 + 1.0i * wx) * log((-1.0i) * wx) - power_of<2>(log(-1.0 + 1.0i / xd)) / 2.0 + 2.0 * log(1.0 + 1.0i * wx) * log(1.0 - 1.0i * xd) - (5.0 * log(1.0 + 1.0i * wx) * log(1.0 + 1.0i * xd)) / 2.0 + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0 - 2.0 * log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) + power_of<2>(log(-((1.0i + xd) * xdinv))) / 4.0 + (2.0 * log(1.0 + 1.0i * wx) - log((-1.0i + xd) / (-1.0i + wx))) * log(1.0 - xd / wx) - log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd)) + log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(imag(wx * xdinv))
                + (2.0 * 1.0i) * M_PI * H2(wx * xdinv, -1.0i / xd) * log(1.0 + wxinv * wxinv) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * log((1.0i + xd) * xdinv) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) + log(xd) * (log(1.0 - 1.0i * wx) - log((1.0i + wx) / (1.0i + xd)) - (2.0 * 1.0i) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))) - 1.0i * M_PI * trilog((wx * (1.0 - 1.0i * xd)) / (-1.0i + wx)) * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)
                + power_of<3>(log(1.0 - 1.0i * xd)) * (log(1.0 + 1.0i * wx) / 12.0 - (3.0 * log(-1.0i / xd)) / 4.0 + log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) + log((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 4.0 + log(-((1.0i + xd) * xdinv)) / 3.0 + log(1.0 - xd / wx) / 12.0 + (1.0i / 2.0) * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) + trilog((wx - xd) / (-1.0i + wx)) * (2.0 * ln2 + log(1.0 - 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) + 3.0 * log((-1.0i + wx) / wx) + log(1.0i / (1.0i + wx)) / 2.0 - (9.0 * log(1.0 - 1.0i * xd)) / 2.0 - log(xd) + log(xd / (1.0i + xd)) / 2.0 - log((1.0i + xd) / (1.0i + wx)) / 2.0 + log(1.0 - xd / wx)
                + 1.0i * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + 1.0i * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) + dilog((-1.0i) * xd) * (pisqu / 2.0 - dilog(1.0i * xd) - dilog(xd / wx) + dilog((-1.0i + xd) / (-1.0i + wx)) - dilog(1.0i / (1.0i + xd)) / 2.0 + dilog((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 + dilog(1.0 - xd / wx) / 2.0 + dilog((wx - 1.0i * wx * xd) / (wx - xd)) + power_of<2>(lnm2) / 4.0 + power_of<2>(log(-1.0 + 1.0i * wx)) / 2.0 + (log(0.5 - (1.0i / 2.0) * wx) * log(1.0 + 1.0i * wx)) / 2.0 + power_of<2>(log(1.0 + 1.0i * wx)) - log(0.5 - (1.0i / 2.0) * wx) * log((-1.0i + wx) / wx) + (log(1.0 - 1.0i * wx) * log((-1.0i + wx) / wx)) / 2.0
                + (3.0 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 - (log(1.0 + 1.0i * wx) * log((2.0 * 1.0i) / (1.0i + wx))) / 2.0 - (ln2 * log((1.0i - wx) / (1.0i + wx))) / 2.0 + (log(1.0 + 1.0i * wx) * log((2.0 * wx) / (1.0i + wx))) / 2.0 - ln2 * log((-1.0i + wx) / (1.0i + wx)) + power_of<2>(log(-((1.0i + wx) / wx))) / 2.0 - (log(1.0 + 1.0i * wx) * log((1.0i + wx) / (2.0 * wx))) / 2.0 + ln2 * log((1.0i + wx) / wx) + (ln2 * log((1.0i + wx) / (-1.0i + wx))) / 2.0 + log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + (log(1.0 + 1.0i * xd) * log(1.0 - xd / wx)) / 2.0 + power_of<2>(log(1.0 - xd / wx)) / 2.0 + power_of<2>(log(-1.0 + xd / wx)) / 4.0
                + log(1.0 - xd / wx) * (2.0 * ln2 + log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) / 2.0 - log((1.0i + xd) / (1.0i + wx)) + (2.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)) + (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (2.0 * 1.0i) * M_PI * log((1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)
                + log(1.0 - 1.0i * xd) * (-2.0 * log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0 - log((1.0i + wx) / (wx - xd)) / 2.0 - log((wx - xd) / (1.0i + wx)) / 2.0 - log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) / 2.0 + log((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0 + 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd))) + dilog(1.0i / wx) * (pisqu / 3.0 - dilog(wx / (1.0i + wx)) / 2.0 + dilog((wx - xd) / (1.0i + wx)) / 2.0 + dilog(1.0 - 1.0i * xd) - dilog(1.0i * xd) - dilog(xd / (-1.0i + xd)) / 2.0 + dilog((2.0 * xd) / (-1.0i + xd)) / 2.0 - 2.0 * dilog(1.0i / (1.0i + xd)) + 3.0 * dilog((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - dilog(xd / (1.0i + xd))
                + 2.0 * dilog(((1.0i + wx) * xd) / (wx * (1.0i + xd))) + dilog((1.0i + xd) * xdinv) + power_of<2>(log(-1.0 + 1.0i * xd)) / 2.0 + log(1.0 + 1.0i * xd) * (-2.0 * lnhalf + log((1.0i + wx) / wx) / 2.0 + log(xd)) + log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) + (ln2 * log((1.0i + xd) / (1.0i - xd))) / 2.0 + power_of<2>(log(-((1.0i + xd) * xdinv))) / 2.0 + (2.0 * ln2 - log((1.0i + wx) / wx) + 2.0 * log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) + log((1.0i + xd) / (1.0i + wx)) / 2.0 - log((wx * (1.0i + xd)) / ((1.0i + wx) * xd))) * log(1.0 - xd / wx) - log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd))
                + (4.0 * 1.0i) * M_PI * log((1.0i + xd) * xdinv) * my_sign(real(wx)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) + 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + log(1.0 - 1.0i * xd) * (-2.0 * lnhalf + 2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 + (6.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)))
                + dilog((wx - xd) / (-1.0i + wx)) * ((-1.0 / 6.0) * pisqu - dilog((wx - xd) / (1.0i + wx)) / 2.0 - dilog(1.0i * xd) + dilog(1.0i / (1.0i + xd)) / 2.0 - dilog((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 4.0 + dilog(1.0 - xd / wx) + 3.0 * log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) + (3.0 * power_of<2>(log(1.0 - 1.0i * xd))) / 2.0 - 2.0 * log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - power_of<2>(log(1.0 - xd / wx)) / 2.0 + log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) + 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)
                + log(1.0 - xd / wx) * (-2.0 * ln2 - log(1.0 - 1.0i * wx) / 2.0 - log(1.0i / (1.0i + wx)) / 2.0 + log(xd) - log(xd / (1.0i + xd)) / 2.0 - 1.0i * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) - 1.0i * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) + log(1.0 - 1.0i * xd) * ((3.0 * log(1.0 - xd / wx)) / 2.0 + 1.0i * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd))) - 1.0i * M_PI * trilog((wx + 1.0i * wx * xd) / (1.0i + wx)) * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)
                + power_of<3>(log(1.0 + 1.0i * xd)) * (log(1.0 - 1.0i * wx) / 12.0 - (3.0 * log(1.0i / xd)) / 4.0 + log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) + log(1.0 - xd / wx) / 12.0 + log(-((xd + 1.0i * wx * xd) / (wx - xd))) / 4.0 + (1.0i / 2.0) * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)) + trilog((wx - xd) / (1.0i + wx)) * (2.0 * ln2 + log(1.0 + 1.0i * wx) / 2.0 + log(-1.0i / (-1.0i + wx)) / 2.0 - log(1.0i / (1.0i + wx)) + 3.0 * log((1.0i + wx) / wx) - (9.0 * log(1.0 + 1.0i * xd)) / 2.0 - log(xd) + log(xd / (-1.0i + xd)) / 2.0 - log((-1.0i + xd) / (-1.0i + wx)) / 2.0 + log(1.0 - xd / wx) + 1.0i * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + 1.0i * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)) + dilog(1.0i * xd) * (pisqu / 2.0 - dilog(xd / wx) - dilog(-1.0i / (-1.0i + xd)) / 2.0 + dilog(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 + dilog((1.0i + xd) / (1.0i + wx)) + dilog(1.0 - xd / wx) / 2.0 + dilog((wx + 1.0i * wx * xd) / (wx - xd)) + power_of<2>(lnm2) / 4.0 + power_of<2>(log(-1.0 + 1.0i / wx)) / 2.0 + power_of<2>(log(-1.0 - 1.0i * wx)) / 2.0 + (log(0.5 + (1.0i / 2.0) * wx) * log(1.0 - 1.0i * wx)) / 2.0 + power_of<2>(log(1.0 - 1.0i * wx)) - (log(1.0 - 1.0i * wx) * log((-2.0 * 1.0i) / (-1.0i + wx))) / 2.0 + (log(1.0 - 1.0i * wx) * log((2.0 * wx) / (-1.0i + wx))) / 2.0 - (log(1.0 - 1.0i * wx) * log((-1.0i + wx) / (2.0 * wx))) / 2.0
                + ln2 * log((-1.0i + wx) / wx) + (ln2 * log((-1.0i + wx) / (1.0i + wx))) / 2.0 - (ln2 * log((1.0i + wx) / (1.0i - wx))) / 2.0 - log(0.5 + (1.0i / 2.0) * wx) * log((1.0i + wx) / wx) + (log(1.0 + 1.0i * wx) * log((1.0i + wx) / wx)) / 2.0 + (3.0 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - ln2 * log((1.0i + wx) / (-1.0i + wx)) + log((wx - xd) / (1.0i + wx)) * log(1.0 - 1.0i * xd) + (log(1.0 - 1.0i * xd) * log(1.0 - xd / wx)) / 2.0 + power_of<2>(log(1.0 - xd / wx)) / 2.0 + power_of<2>(log(-1.0 + xd / wx)) / 4.0 + (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)
                + log(1.0 - xd / wx) * (2.0 * ln2 + log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) / 2.0 - log((-1.0i + xd) / (-1.0i + wx)) + (2.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)) - (2.0 * 1.0i) * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + log(1.0 + 1.0i * xd) * (-2.0 * log(1.0 - 1.0i * wx) + log((1.0i + wx) / wx) / 2.0 - log((-1.0i + wx) / (wx - xd)) / 2.0 - log((wx - xd) / (-1.0i + wx)) / 2.0 - log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) / 2.0 + log(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0 + 1.0i * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)))
                + dilog(-1.0i / wx) * (pisqu / 3.0 - dilog(wx / (-1.0i + wx)) / 2.0 + dilog((wx - xd) / (-1.0i + wx)) / 2.0 + dilog(1.0 + 1.0i * xd) - dilog((-1.0i) * xd) - 2.0 * dilog(-1.0i / (-1.0i + xd)) + 3.0 * dilog(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) - dilog(xd / (-1.0i + xd)) + 2.0 * dilog(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + dilog((-1.0i + xd) * xdinv) - dilog(xd / (1.0i + xd)) / 2.0 + dilog((2.0 * xd) / (1.0i + xd)) / 2.0 + power_of<2>(log(-1.0 + 1.0i / xd)) / 2.0 + power_of<2>(log(-1.0 - 1.0i * xd)) / 2.0 + log(1.0 - 1.0i * xd) * (-2.0 * lnhalf + log((-1.0i + wx) / wx) / 2.0 + log(xd)) + log((-1.0i + wx) / wx) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))
                + (ln2 * log((1.0i - xd) / (1.0i + xd))) / 2.0 + (2.0 * ln2 - log((-1.0i + wx) / wx) + 2.0 * log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) + log((-1.0i + xd) / (-1.0i + wx)) / 2.0 - log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd))) * log(1.0 - xd / wx) - log((-1.0i + wx) / wx) * log((wx + 1.0i * wx * xd) / (wx - xd)) + (4.0 * 1.0i) * M_PI * log((-1.0i + xd) * xdinv) * my_sign(-real(wx)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) + 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + log(1.0 + 1.0i * xd) * (-2.0 * lnhalf + 2.0 * ln2 - log(1.0 + 1.0i * wx) / 2.0 + (6.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd))) + dilog((wx - xd) / (1.0i + wx)) * ((-1.0 / 6.0) * pisqu - dilog((-1.0i) * xd) + dilog(-1.0i / (-1.0i + xd)) / 2.0 - dilog(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 4.0 + dilog(1.0 - xd / wx) + 3.0 * log((wx - xd) / (-1.0i + wx)) * log(1.0 + 1.0i * xd) + (3.0 * power_of<2>(log(1.0 + 1.0i * xd))) / 2.0 - 2.0 * log((1.0i + wx) / wx) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - power_of<2>(log(1.0 - xd / wx)) / 2.0 + log((1.0i + wx) / wx) * log((wx - 1.0i * wx * xd) / (wx - xd))
                + 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + log(1.0 - xd / wx) * (-2.0 * ln2 - log(1.0 + 1.0i * wx) / 2.0 - log(-1.0i / (-1.0i + wx)) / 2.0 + log(xd) - log(xd / (-1.0i + xd)) / 2.0 - 1.0i * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) - 1.0i * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)) + log(1.0 + 1.0i * xd) * ((3.0 * log(1.0 - xd / wx)) / 2.0 + 1.0i * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)))
                + power_of<2>(log(wx / (wx - xd))) * ((-1.0 / 3.0) * pisqu + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(-imag(xd / (wx - xd))) * T(1.0, (wx - 1.0i * wx * xd) / (wx - xd), wx / (wx - xd)) + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-imag(xd / (wx - xd))) * T(1.0, (wx + 1.0i * wx * xd) / (wx - xd), wx / (wx - xd))) - pisqu * power_of<2>(log((-1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) * T(p(-1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx) + 2.0 * pisqu * log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) * T(p(-1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx)
                - pisqu * power_of<2>(log((1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) * T(p(-1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx) - pisqu * power_of<2>(log((-1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) * T(p(1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx) + 2.0 * pisqu * log((-1.0i + wx) / wx) * log((1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) * T(p(1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx) - pisqu * power_of<2>(log((1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) * T(p(1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx)
                + log(xd) * ((pisqu * lnm2) / 3.0 + power_of<3>(lnm2) / 3.0 + (pisqu * log(1.0 - 1.0i * wx)) / 6.0 - (power_of<2>(lnm2) * log(1.0 - 1.0i * wx)) / 2.0 + (power_of<2>(log(-1.0 + 1.0i / wx)) * log(1.0 - 1.0i * wx)) / 2.0 + power_of<3>(log(1.0 - 1.0i * wx)) / 6.0 + (pisqu * log(1.0 + 1.0i * wx)) / 6.0 - (power_of<2>(lnm2) * log(1.0 + 1.0i * wx)) / 2.0 + power_of<3>(log(1.0 + 1.0i * wx)) / 6.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * wx) / (-1.0i + wx))) / 2.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((-1.0i + wx) / (2.0 * wx))) / 2.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((2.0 * wx) / (1.0i + wx))) / 2.0 + (log(1.0 + 1.0i * wx) * power_of<2>(log(-((1.0i + wx) / wx)))) / 2.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((1.0i + wx) / (2.0 * wx))) / 2.0
                + (pisqu * log(((-2.0 * 1.0i) * wx) / (1.0 + power_of<2>(wx)))) / 6.0 + power_of<3>(log(((-2.0 * 1.0i) * wx) / (1.0 + power_of<2>(wx)))) / 6.0 + (pisqu * log(((2.0 * 1.0i) * wx) / (1.0 + power_of<2>(wx)))) / 6.0 + power_of<3>(log(((2.0 * 1.0i) * wx) / (1.0 + power_of<2>(wx)))) / 6.0 + (pisqu * log((1.0i - xd) / (1.0i + wx))) / 6.0 + power_of<3>(log((1.0i - xd) / (1.0i + wx))) / 6.0 - (pisqu * log(((-2.0 * 1.0i) * (wx - xd)) / (1.0 + power_of<2>(wx)))) / 6.0 - power_of<3>(log(((-2.0 * 1.0i) * (wx - xd)) / (1.0 + power_of<2>(wx)))) / 6.0 - (pisqu * log(((2.0 * 1.0i) * (wx - xd)) / (1.0 + power_of<2>(wx)))) / 6.0 - power_of<3>(log(((2.0 * 1.0i) * (wx - xd)) / (1.0 + power_of<2>(wx)))) / 6.0 - (pisqu * log(wx / (-1.0i + xd))) / 6.0 - power_of<3>(log(wx / (-1.0i + xd))) / 6.0 - (pisqu * log(wx / (1.0i + xd))) / 6.0 - power_of<3>(log(wx / (1.0i + xd))) / 6.0
                + (log(((-2.0 * 1.0i) * (wx - xd)) / ((1.0i + wx) * (-1.0i + xd))) * power_of<2>(log((1.0i + wx) / (1.0i + xd)))) / 2.0 + (pisqu * log((1.0i + xd) / (1.0i - wx))) / 6.0 + power_of<3>(log((1.0i + xd) / (1.0i - wx))) / 6.0 - (log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 2.0 + (log((-1.0i + xd) / (-1.0i + wx)) * power_of<2>(log(1.0 - xd / wx))) / 2.0 - (log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * power_of<2>(log(1.0 - xd / wx))) / 2.0 - (log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 2.0 + (log((1.0i + xd) / (1.0i + wx)) * power_of<2>(log(1.0 - xd / wx))) / 2.0 - (log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * power_of<2>(log(1.0 - xd / wx))) / 2.0
                + log((-2.0 * 1.0i) / (-1.0i + xd)) * ((-0.5) * power_of<2>(log((1.0i + wx) / (1.0i + xd))) + log((1.0i + wx) / (1.0i + xd)) * log(1.0 - xd / wx)) + (pisqu * log((1.0i * wx) / (1.0i * xd - wx * xd))) / 6.0 + power_of<3>(log((1.0i * wx) / (1.0i * xd - wx * xd))) / 6.0 + (pisqu * log((1.0i * wx) / (1.0i * xd + wx * xd))) / 6.0 + power_of<3>(log((1.0i * wx) / (1.0i * xd + wx * xd))) / 6.0 - 1.0i * M_PI * H1((1.0i + wx) / (wx - xd), (-1.0i + wx) / (wx - xd)) * power_of<2>(log(((1.0i / 2.0) * (1.0 + power_of<2>(wx))) / (wx - xd))) * my_sign(imag((-1.0i + wx) / (wx - xd))) + 1.0i * M_PI * H1((-1.0i + wx) / (1.0i + wx), (-1.0i + wx) / (wx - xd)) * power_of<2>(log((-1.0i + wx) / (1.0i + xd))) * my_sign(imag((-1.0i + wx) / (wx - xd)))
                - 1.0i * M_PI * H1((-1.0i + wx) / (wx - xd), (1.0i + wx) / (wx - xd)) * power_of<2>(log((((-0.5) * 1.0i) * (1.0 + power_of<2>(wx))) / (wx - xd))) * my_sign(imag((1.0i + wx) / (wx - xd))) + 1.0i * M_PI * H1((1.0i + wx) / (-1.0i + wx), (1.0i + wx) / (wx - xd)) * power_of<2>(log((1.0i + wx) / (-1.0i + xd))) * my_sign(imag((1.0i + wx) / (wx - xd))) + 1.0i * M_PI * H1((-1.0i) * wx, wx * xdinv) * power_of<2>(log((1.0i - xd) / wx)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H1(1.0i / xd, wx * xdinv) * power_of<2>(log((-1.0i - 1.0 / wx) * xd)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H1(-1.0i / xd, wx * xdinv) * power_of<2>(log((1.0i - 1.0 / wx) * xd)) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H1(1.0i * wx, wx * xdinv) * power_of<2>(log(-((1.0i + xd) / wx))) * my_sign(imag(wx * xdinv))
                + 1.0i * M_PI * H1((1.0i + wx) / (-1.0i + wx), (1.0i + wx) / wx) * power_of<2>(log(-1.0 + 1.0i * wx)) * my_sign(-real(1.0 / wx)) - 1.0i * M_PI * H1((-1.0i + wx) / wx, (1.0i + wx) / wx) * power_of<2>(log((((-0.5) * 1.0i) * (1.0 + power_of<2>(wx))) / wx)) * my_sign(-real(1.0 / wx)) + 1.0i * M_PI * H1((-1.0i + wx) / (1.0i + wx), (-1.0i + wx) / wx) * power_of<2>(log(-1.0 - 1.0i * wx)) * my_sign(real(1.0 / wx)) - 1.0i * M_PI * H1((1.0i + wx) / wx, (-1.0i + wx) / wx) * power_of<2>(log(((1.0i / 2.0) * (1.0 + power_of<2>(wx))) / wx)) * my_sign(real(1.0 / wx)) + 1.0i * M_PI * power_of<2>(log(0.5 + (1.0i / 2.0) * wx)) * my_sign(imag((1.0i + wx) / (-1.0i + wx))) * T(1.0, -1.0i / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + wx)) + 1.0i * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(-imag(wx / (1.0i + wx))) * T(1.0, -1.0i / (-1.0i + wx), 1.0i / (1.0i + wx))
                + 1.0i * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(imag(wx / (1.0i - wx))) * T(1.0, 1.0i / (1.0i + wx), -1.0i / (-1.0i + wx)) + 1.0i * M_PI * power_of<2>(log(0.5 - (1.0i / 2.0) * wx)) * my_sign(imag((-1.0i + wx) / (1.0i + wx))) * T(1.0, 1.0i / (1.0i + wx), (2.0 * 1.0i) / (1.0i + wx)) - 1.0i * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - 1.0i * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - 1.0i * M_PI * power_of<2>(log(0.5 + (1.0i / 2.0) * wx)) * my_sign(imag((1.0i + wx) / (-1.0i + wx))) * T(1.0, (-1.0i + xd) / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + wx)) + 1.0i * M_PI * power_of<2>(log((1.0i + wx) / (1.0i + xd))) * my_sign(imag((wx - xd) / (1.0i + wx))) * T(1.0, (-1.0i + xd) / (-1.0i + wx), (1.0i + xd) / (1.0i + wx))
                - 1.0i * M_PI * power_of<2>(log(0.5 - (1.0i / 2.0) * wx)) * my_sign(imag((-1.0i + wx) / (1.0i + wx))) * T(1.0, (1.0i + xd) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + wx)) + log(1.0 - xd / wx) * ((-2.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * my_sign(imag((-1.0i + wx) / (wx - xd))) * T(1.0, (-1.0i + xd) / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + wx)) - (2.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * my_sign(imag((1.0i + wx) / (wx - xd))) * T(1.0, (1.0i + xd) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + wx)))
                + power_of<2>(log((-1.0i + wx) / (-1.0i + xd))) * ((-0.5) * log((2.0 * 1.0i) / (1.0i + xd)) + log(((2.0 * 1.0i) * (wx - xd)) / ((-1.0i + wx) * (1.0i + xd))) / 2.0 + 1.0i * M_PI * my_sign(imag((wx - xd) / (-1.0i + wx))) * T(1.0, (1.0i + xd) / (1.0i + wx), (-1.0i + xd) / (-1.0i + wx))) - (1.0i / 3.0) * power_of<3>(M_PI) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) - 1.0i * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) - 1.0i * M_PI * power_of<2>(log(-((1.0i + wx) / wx))) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + log((1.0i + wx) / (1.0i + xd)) * ((-1.0 / 6.0) * pisqu - power_of<2>(log(-1.0 + 1.0i / wx)) / 2.0 + power_of<2>(log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)) - (1.0i / 3.0) * power_of<3>(M_PI) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) - 1.0i * M_PI * power_of<2>(log(-1.0 + 1.0i / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) - 1.0i * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)
                + log((-1.0i + wx) / (-1.0i + xd)) * ((-1.0 / 6.0) * pisqu - power_of<2>(log(-((1.0i + wx) / wx))) / 2.0 + log((2.0 * 1.0i) / (1.0i + xd)) * log(1.0 - xd / wx) + power_of<2>(log(1.0 - xd / wx)) / 2.0 + (2.0 * 1.0i) * M_PI * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx)) - 4.0 * pisqu * log((1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) * T(p(-1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx) - 4.0 * pisqu * log((-1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) * T(p(1.0i / wx, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx)) + 2.0 * pisqu * ln2squ * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) * T(p((-1.0i) * wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0)
                - 4.0 * pisqu * ln2 * log(1.0 + 1.0i * wx) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) * T(p((-1.0i) * wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0) + 2.0 * pisqu * power_of<2>(log(1.0 + 1.0i * wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) * T(p((-1.0i) * wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0) + 2.0 * pisqu * ln2squ * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) * T(p(1.0i * wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0) - 4.0 * pisqu * ln2 * log(1.0 - 1.0i * wx) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) * T(p(1.0i * wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0) + 2.0 * pisqu * power_of<2>(log(1.0 - 1.0i * wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) * T(p(1.0i * wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0)
                - pisqu * power_of<2>(log((1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) * T(p((-1.0i) * xd, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx)
                + power_of<2>(log(1.0 + 1.0i * xd)) * (((3.0 * ln2) / 2.0 + log(1.0 - 1.0i * wx) - (3.0 * log(1.0 + 1.0i * wx)) / 4.0 + log((1.0i + wx) / wx) / 2.0) * log(1.0i / xd) + ((-3.0 * ln2) / 4.0 - log(1.0 - 1.0i * wx) / 4.0 - log((1.0i + wx) / wx) / 4.0) * log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) + power_of<2>(log((-1.0i) * xd)) / 2.0 + log((1.0i + xd) / (2.0 * xd)) * ((-0.25) * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 4.0 + log((-1.0i + wx) / wx) / 2.0 - log(1.0 - xd / wx) / 2.0) + log((2.0 * xd) / (1.0i + xd)) * (log(1.0 - 1.0i * wx) / 4.0 - log(1.0 + 1.0i * wx) / 2.0 + log((-1.0i + wx) / wx) / 2.0 + log((1.0i + wx) / wx) / 4.0 - log(1.0 - xd / wx) / 2.0) + (log((-1.0i) * xd) * log(1.0 - xd / wx)) / 2.0
                + ((3.0 * ln2) / 4.0 + log(1.0 - 1.0i * wx) / 4.0) * log(-((xd + 1.0i * wx * xd) / (wx - xd))) + 1.0i * M_PI * ln2 * my_sign(-real(xd)) * T(1.0, 1.0 + 1.0i * wx, 1.0 + 1.0i * xd) + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(xd)) * T(1.0, 1.0 + 1.0i * wx, 1.0 + 1.0i * xd) - 1.0i * M_PI * log(wx / (-1.0i + wx)) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) * T(1.0, (wx - xd) / (-1.0i + wx), wx / (-1.0i + wx)) + (3.0 * 1.0i) * M_PI * log((1.0i + wx) / (-1.0i + wx)) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) * T(1.0, (wx - xd) / (-1.0i + wx), (1.0i + wx) / (-1.0i + wx)) + (4.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * my_sign(2.0 * real(1.0 / (1.0i - xd))) * T(1.0, 0.5 - (1.0i / 2.0) * xd, 0.5 - (1.0i / 2.0) * wx)
                - 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + log((2.0 * 1.0i) / (1.0i + xd)) * ((-0.25) * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 2.0 - log((-1.0i + wx) / wx) / 4.0 - log((1.0i + wx) / wx) / 4.0 + log(1.0 - xd / wx) / 2.0 - (1.0i / 2.0) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + (1.0i / 2.0) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)) + 1.0i * M_PI * log((-1.0i) * wx) * my_sign(real(1.0 / (1.0i - xd))) * T(1.0, (-1.0i) * xd, (-1.0i) * wx)
                + 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(xd / (1.0i - xd))) * T(1.0, ((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)), -1.0i / (-1.0i + xd)) + (2.0 * 1.0i) * M_PI * ln2 * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) - (1.0i / 2.0) * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) + ((3.0 * 1.0i) / 2.0) * M_PI * log((1.0i + wx) / wx) * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) - (1.0i / 2.0) * M_PI * log((1.0i + xd) / (1.0i + wx)) * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) + log(xd) * (log(1.0 - xd / wx) / 2.0 + 1.0i * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd))
                - pisqu * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) * T(p((-1.0i) * xd, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx)) - pisqu * power_of<2>(log((-1.0i + wx) / wx)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) * T(p(1.0i * xd, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx) + power_of<2>(log(1.0 - 1.0i * xd)) * (((3.0 * ln2) / 2.0 - (3.0 * log(1.0 - 1.0i * wx)) / 4.0 + log(1.0 + 1.0i * wx) + log((-1.0i + wx) / wx) / 2.0) * log(-1.0i / xd) + ((-3.0 * ln2) / 4.0 - log(1.0 + 1.0i * wx) / 4.0 - log((-1.0i + wx) / wx) / 4.0) * log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) + power_of<2>(log(1.0i * xd)) / 2.0
                + log(1.0 + 1.0i * xd) * ((-0.5) * log(((-1.0i) * (wx - xd)) / ((1.0i + wx) * xd)) - log((1.0i * (1.0i + wx) * xd) / (wx - xd)) / 2.0) + ((3.0 * ln2) / 4.0 + log(1.0 + 1.0i * wx) / 4.0) * log((1.0i * (1.0i + wx) * xd) / (wx - xd)) + log((-1.0i + xd) / (2.0 * xd)) * (log(1.0 - 1.0i * wx) / 4.0 - log(1.0 + 1.0i * wx) / 4.0 + log((1.0i + wx) / wx) / 2.0 - log(1.0 - xd / wx) / 2.0) + log((2.0 * xd) / (-1.0i + xd)) * ((-0.5) * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 4.0 + log((-1.0i + wx) / wx) / 4.0 + log((1.0i + wx) / wx) / 2.0 - log(1.0 - xd / wx) / 2.0) + (log(1.0i * xd) * log(1.0 - xd / wx)) / 2.0 + 1.0i * M_PI * ln2 * my_sign(real(xd)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - 1.0i * xd)
                + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(xd)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - 1.0i * xd) - 1.0i * M_PI * log(wx / (1.0i + wx)) * my_sign(imag((1.0i + wx) / (1.0i + xd))) * T(1.0, (wx - xd) / (1.0i + wx), wx / (1.0i + wx)) + (3.0 * 1.0i) * M_PI * log((-1.0i + wx) / (1.0i + wx)) * my_sign(imag((1.0i + wx) / (1.0i + xd))) * T(1.0, (wx - xd) / (1.0i + wx), (-1.0i + wx) / (1.0i + wx)) + (4.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * my_sign(2.0 * real(1.0 / (1.0i + xd))) * T(1.0, 0.5 + (1.0i / 2.0) * xd, 0.5 + (1.0i / 2.0) * wx) - 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)
                + log(0.5 + (1.0i / 2.0) * xd) * ((-0.25) * log(1.0 - 1.0i * wx) + log(1.0 + 1.0i * wx) / 4.0 + log(wx / (1.0i + wx)) / 4.0 - log((1.0i + wx) / wx) / 2.0 - log(-(xd / (wx - xd))) / 4.0 + log(1.0 - xd / wx) / 2.0 + (1.0i / 2.0) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (1.0i / 2.0) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)) + log((-2.0 * 1.0i) / (-1.0i + xd)) * (log(1.0 - 1.0i * wx) / 2.0 - log(1.0 + 1.0i * wx) / 4.0 - log((-1.0i + wx) / wx) / 4.0 - log((1.0i + wx) / wx) / 4.0 + log(1.0 - xd / wx) / 2.0 - (1.0i / 2.0) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + (1.0i / 2.0) * M_PI * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx))
                - 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + 1.0i * M_PI * log(1.0i * wx) * my_sign(real(1.0 / (1.0i + xd))) * T(1.0, 1.0i * xd, 1.0i * wx) + 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(-imag(xd / (1.0i + xd))) * T(1.0, (1.0i * (wx - xd)) / (wx * (1.0i + xd)), 1.0i / (1.0i + xd)) + (2.0 * 1.0i) * M_PI * ln2 * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) - (1.0i / 2.0) * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) + ((3.0 * 1.0i) / 2.0) * M_PI * log((-1.0i + wx) / wx) * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) - (1.0i / 2.0) * M_PI * log((-1.0i + xd) / (-1.0i + wx)) * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)
                + log(xd) * (log(1.0 - xd / wx) / 2.0 + 1.0i * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) - pisqu * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) * T(p(1.0i * xd, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx)) - 2.0 * pisqu * ln2squ * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0) - 2.0 * pisqu * ln2squ * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0)
                + power_of<2>(log(1.0 - xd / wx)) * ((-1.0 / 3.0) * pisqu - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(xd / wx)) * T(1.0, (-1.0i + wx) / wx, 1.0 - xd / wx) - 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(imag(xd / wx)) * T(1.0, (-1.0i + wx) / wx, 1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(xd / wx)) * T(1.0, (1.0i + wx) / wx, 1.0 - xd / wx) - 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(imag(xd / wx)) * T(1.0, (1.0i + wx) / wx, 1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) - 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)
                - 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx) + 1.0i * M_PI * log(-1.0i / wx) * my_sign(imag(wx / (wx - xd))) * T(1.0, xd / wx, -1.0i / wx) + 1.0i * M_PI * log(1.0i / wx) * my_sign(imag(wx / (wx - xd))) * T(1.0, xd / wx, 1.0i / wx) - 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(imag(xd / (wx - xd))) * T(1.0, (wx - 1.0i * wx * xd) / (wx - xd), wx / (wx - xd)) - 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(imag(xd / (wx - xd))) * T(1.0, (wx + 1.0i * wx * xd) / (wx - xd), wx / (wx - xd)) - 2.0 * pisqu * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0) - 2.0 * pisqu * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0))
                + log((wx + 1.0i * wx * xd) / (wx - xd)) * ((-1.0 / 6.0) * (pisqu * log(1.0 + 1.0i * wx)) - (lnhalf * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 - (ln2 * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 - (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 - power_of<3>(log(1.0 + 1.0i * wx)) / 6.0 - (pisqu * log((-1.0i + wx) / wx)) / 3.0 - (ln2 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + (log(1.0 - 1.0i * wx) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 - power_of<3>(log((-1.0i + wx) / wx)) / 6.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log(wx / (1.0i + wx))) / 4.0 + (pisqu * log(-((1.0i + wx) / wx))) / 6.0 - (log((-1.0i + wx) / wx) * power_of<2>(log(-((1.0i + wx) / wx)))) / 2.0 + power_of<3>(log(-((1.0i + wx) / wx))) / 6.0
                - (power_of<2>(log((-1.0i + wx) / wx)) * log((1.0i + wx) / wx)) / 2.0 - 2.0 * zeta3) + log(1.0i / (1.0i + xd)) * ((-1.0 / 6.0) * (pisqu * log(1.0 + 1.0i * wx)) - (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0i * wx))) / 2.0 + (pisqu * log((-1.0i + wx) / wx)) / 6.0 + (pisqu * log((1.0i + wx) / wx)) / 12.0 - (pisqu * log(1.0 - xd / wx)) / 4.0 - (1.0i / 2.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log(((1.0i + wx) * xd) / (wx * (1.0i + xd)))) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * power_of<2>(log((-wx + xd) / (1.0i + xd))) * my_sign(-real(1.0 / wx)) - 2.0 * zeta3)
                + log(-1.0i / (-1.0i + xd)) * ((-1.0 / 6.0) * (pisqu * log(1.0 - 1.0i * wx)) - (log(1.0 + 1.0i * wx) * power_of<2>(log((-1.0i) * wx))) / 2.0 + (pisqu * log((-1.0i + wx) / wx)) / 12.0 + (pisqu * log((1.0i + wx) / wx)) / 6.0 - (pisqu * log(1.0 - xd / wx)) / 4.0 - (1.0i / 2.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd)))) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * power_of<2>(log((-wx + xd) / (-1.0i + xd))) * my_sign(real(1.0 / wx)) - 2.0 * zeta3)
                + log((wx - 1.0i * wx * xd) / (wx - xd)) * ((pisqu * log(-1.0 + 1.0i / wx)) / 6.0 + power_of<3>(log(-1.0 + 1.0i / wx)) / 6.0 - (pisqu * log(1.0 - 1.0i * wx)) / 6.0 - (lnhalf * power_of<2>(log(1.0 - 1.0i * wx))) / 4.0 - (ln2 * power_of<2>(log(1.0 - 1.0i * wx))) / 4.0 - power_of<3>(log(1.0 - 1.0i * wx)) / 6.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * wx)) / 4.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log(wx / (-1.0i + wx))) / 4.0 - (pisqu * log((1.0i + wx) / wx)) / 3.0 - (power_of<2>(log(-1.0 + 1.0i / wx)) * log((1.0i + wx) / wx)) / 2.0 - (ln2 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (log(1.0 + 1.0i * wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - (log((-1.0i + wx) / wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - power_of<3>(log((1.0i + wx) / wx)) / 6.0
                - (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * power_of<2>(log(-((xd + 1.0i * wx * xd) / (wx - xd)))) * my_sign(real(xdinv)) - 2.0 * zeta3) + log(1.0 - xd / wx) * ((2.0 * pisqu * lnm2) / 3.0 + (2.0 * power_of<3>(lnm2)) / 3.0 + (4.0 * pisqu * lnm1) / 3.0 + (4.0 * power_of<3>(lnm1)) / 3.0 - 4.0 * lnm1 * ln2squ + (pisqu * log(-1.0 + 1.0i / wx)) / 6.0 + power_of<3>(log(-1.0 + 1.0i / wx)) / 6.0 - (pisqu * log(-1.0 - 1.0i * wx)) / 12.0 - power_of<3>(log(-1.0 - 1.0i * wx)) / 12.0 - (pisqu * log(1.0 - 1.0i * wx)) / 12.0 + (log(0.5 + (1.0i / 2.0) * wx) * power_of<2>(log(1.0 - 1.0i * wx))) / 2.0 - power_of<3>(log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log(-1.0 + 1.0i * wx)) / 12.0 - power_of<3>(log(-1.0 + 1.0i * wx)) / 12.0 - (pisqu * log(1.0 + 1.0i * wx)) / 12.0
                + (log(0.5 - (1.0i / 2.0) * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 2.0 - power_of<3>(log(1.0 + 1.0i * wx)) / 12.0 + (pisqu * log(((-0.5) * 1.0i) / wx)) / 12.0 + power_of<3>(log(((-0.5) * 1.0i) / wx)) / 12.0 + (pisqu * log(1.0i / 2.0 / wx)) / 12.0 + power_of<3>(log(1.0i / 2.0 / wx)) / 12.0 - (pisqu * log(-1.0i / wx)) / 3.0 + power_of<2>(log(1.0 - 1.0i * wx)) * log(-1.0i / wx) - power_of<3>(log(-1.0i / wx)) / 3.0 - (pisqu * log(1.0i / wx)) / 3.0 + power_of<2>(log(1.0 + 1.0i * wx)) * log(1.0i / wx) - power_of<3>(log(1.0i / wx)) / 3.0 - (pisqu * log((-2.0 * 1.0i) / wx)) / 6.0 - power_of<3>(log((-2.0 * 1.0i) / wx)) / 6.0 - (pisqu * log((2.0 * 1.0i) / wx)) / 6.0 - power_of<3>(log((2.0 * 1.0i) / wx)) / 6.0 - (pisqu * log((-1.0i) * wx)) / 3.0 - power_of<3>(log((-1.0i) * wx)) / 3.0 - (pisqu * log(1.0i * wx)) / 3.0 - power_of<3>(log(1.0i * wx)) / 3.0
                - (pisqu * log((-2.0 * 1.0i) * wx)) / 12.0 - power_of<3>(log((-2.0 * 1.0i) * wx)) / 12.0 - (pisqu * log((2.0 * 1.0i) * wx)) / 12.0 - power_of<3>(log((2.0 * 1.0i) * wx)) / 12.0 - (pisqu * log(wx / (1.0i - wx))) / 6.0 - power_of<3>(log(wx / (1.0i - wx))) / 6.0 + (pisqu * log(-1.0i / (-1.0i + wx))) / 12.0 + power_of<3>(log(-1.0i / (-1.0i + wx))) / 12.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((-2.0 * 1.0i) / (-1.0i + wx))) / 2.0 + (pisqu * log(wx / (-1.0i + wx))) / 6.0 + power_of<3>(log(wx / (-1.0i + wx))) / 6.0 + (power_of<2>(log(1.0 - 1.0i * wx)) * log((2.0 * wx) / (-1.0i + wx))) / 2.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((-1.0i + wx) / (2.0 * wx))) / 2.0 - (power_of<2>(log(1.0i / wx)) * log((-1.0i + wx) / wx)) / 2.0 - (3.0 * log(1.0i / wx) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0
                + log((-1.0i) * wx) * power_of<2>(log((-1.0i + wx) / wx)) + (pisqu * log(1.0i / (1.0i + wx))) / 12.0 + power_of<3>(log(1.0i / (1.0i + wx))) / 12.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * 1.0i) / (1.0i + wx))) / 2.0 + power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * 1.0i) / (1.0i + wx)) - (pisqu * log(-(wx / (1.0i + wx)))) / 6.0 - power_of<3>(log(-(wx / (1.0i + wx)))) / 6.0 + (pisqu * log(wx / (1.0i + wx))) / 6.0 + power_of<3>(log(wx / (1.0i + wx))) / 6.0 + (power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * wx) / (1.0i + wx))) / 2.0 - power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * wx) / (1.0i + wx)) + (pisqu * log(-((1.0i + wx) / wx))) / 6.0 + power_of<3>(log(-((1.0i + wx) / wx))) / 6.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((1.0i + wx) / (2.0 * wx))) / 2.0
                - (power_of<2>(log(-1.0i / wx)) * log((1.0i + wx) / wx)) / 2.0 - (3.0 * log(-1.0i / wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + log(1.0i * wx) * power_of<2>(log((1.0i + wx) / wx)) + log((-2.0 * 1.0i) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx)) - log((2.0 * wx) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx)) - (pisqu * log(1.0i / (-1.0i + xd))) / 6.0 - power_of<3>(log(1.0i / (-1.0i + xd))) / 6.0 - (pisqu * log(-1.0i / (1.0i + xd))) / 6.0 - power_of<3>(log(-1.0i / (1.0i + xd))) / 6.0 + 1.0i * M_PI * H1(wx / (wx - xd), (-1.0i + wx) / (wx - xd)) * power_of<2>(log((1.0i * (-wx + xd)) / (wx * (-1.0i + wx)))) * my_sign(imag((-1.0i + wx) / (wx - xd)))
                + 1.0i * M_PI * H1(wx / (wx - xd), (1.0i + wx) / (wx - xd)) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + wx)))) * my_sign(imag((1.0i + wx) / (wx - xd))) + 1.0i * M_PI * power_of<2>(log(-1.0i / (-1.0i + wx))) * my_sign(imag(wx / (-1.0i + wx))) * T(1.0, (-1.0i + xd) / (-1.0i + wx), -1.0i / (-1.0i + wx)) + 1.0i * M_PI * power_of<2>(log(1.0i / (1.0i + wx))) * my_sign(imag(wx / (1.0i + wx))) * T(1.0, (1.0i + xd) / (1.0i + wx), 1.0i / (1.0i + wx)) + 4.0 * pisqu * ln2 * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 - 1.0i * xd), 1.0 - 1.0i * xd, 2.0) + 4.0 * pisqu * ln2 * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx) * T(p(xd / wx, 1.0 + 1.0i * xd), 1.0 + 1.0i * xd, 2.0) - 2.0 * zeta3)
                + log((-1.0i + wx) / (wx - xd)) * (-(power_of<2>(log(1.0i / wx)) * log((-1.0i + wx) / wx)) + (pisqu * log(-1.0 + 1.0i * xd)) / 6.0 + power_of<3>(log(-1.0 + 1.0i * xd)) / 6.0 - (pisqu * log(1.0 + 1.0i * xd)) / 3.0 + power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) * log(1.0 + 1.0i * xd) - (power_of<2>(log(-1.0 + 1.0i * xd)) * log(1.0 + 1.0i * xd)) / 2.0 - (5.0 * power_of<3>(log(1.0 + 1.0i * xd))) / 12.0 + log(1.0 - 1.0i * xd) * (power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) + power_of<2>(log(1.0 + 1.0i * xd)) / 2.0) - (log(1.0 + 1.0i * wx) * power_of<2>(log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))))) / 2.0 + power_of<2>(log(1.0 + 1.0i * xd)) * ((-3.0 * ln2) / 4.0 - log(1.0 - 1.0i * wx) / 4.0 + log((1.0i + xd) * xdinv) / 2.0) + (pisqu * log(1.0 - xd / wx)) / 6.0
                - (power_of<2>(log((-1.0i + xd) / (-1.0i + wx))) * log(1.0 - xd / wx)) / 2.0 - zeta3) + log((1.0i + wx) / (wx - xd)) * (-(power_of<2>(log(-1.0i / wx)) * log((1.0i + wx) / wx)) + (pisqu * log(-1.0 - 1.0i * xd)) / 6.0 + power_of<3>(log(-1.0 - 1.0i * xd)) / 6.0 + ((-1.0 / 3.0) * pisqu + power_of<2>(log(0.5 - (1.0i / 2.0) * xd))) * log(1.0 - 1.0i * xd) - (power_of<2>(log(-1.0 - 1.0i * xd)) * log(1.0 - 1.0i * xd)) / 2.0 - (5.0 * power_of<3>(log(1.0 - 1.0i * xd))) / 12.0 + power_of<2>(log(0.5 - (1.0i / 2.0) * xd)) * log(1.0 + 1.0i * xd) + power_of<2>(log(1.0 - 1.0i * xd)) * ((-3.0 * ln2) / 4.0 - log(1.0 + 1.0i * wx) / 4.0 + log(1.0 + 1.0i * xd) / 2.0 + log((-1.0i + xd) * xdinv) / 2.0) - (log(1.0 - 1.0i * wx) * power_of<2>(log((1.0i * (wx - xd)) / (wx * (1.0i + xd))))) / 2.0
                + (pisqu * log(1.0 - xd / wx)) / 6.0 - (power_of<2>(log((1.0i + xd) / (1.0i + wx))) * log(1.0 - xd / wx)) / 2.0 - zeta3) + log((-1.0i + xd) / (-1.0i + wx)) * ((-0.5) * (log(1.0 + 1.0i * wx) * power_of<2>(log((-1.0i) * wx))) - (log(xd / (1.0i + xd)) * power_of<2>(log(1.0 - xd / wx))) / 4.0 - power_of<3>(log(1.0 - xd / wx)) / 6.0 - (1.0i / 2.0) * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + log(1.0 - xd / wx) * ((-1.0 / 6.0) * pisqu + 1.0i * M_PI * log((1.0i + wx) / wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx))
                + power_of<2>(log(1.0 - xd / wx)) * (-ln2 - log(1.0 - 1.0i * wx) / 4.0 - log(1.0i / (1.0i + wx)) / 4.0 - (1.0i / 2.0) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) - (1.0i / 2.0) * M_PI * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) - zeta3) + log((1.0i + xd) / (1.0i + wx)) * ((-0.5) * (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0i * wx))) - power_of<3>(log(1.0 - xd / wx)) / 6.0 - (1.0i / 2.0) * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) + log(1.0 - xd / wx) * ((-1.0 / 6.0) * pisqu + 1.0i * M_PI * log((-1.0i + wx) / wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx))
                + power_of<2>(log(1.0 - xd / wx)) * (-ln2 - log(1.0 + 1.0i * wx) / 4.0 - log(-1.0i / (-1.0i + wx)) / 4.0 - (1.0i / 2.0) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) - (1.0i / 2.0) * M_PI * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd)) - zeta3) + log(-1.0i / (-1.0i + wx)) * zeta3 + log((-1.0i + wx) / wx) * zeta3 + log(1.0i / (1.0i + wx)) * zeta3 + log((1.0i + wx) / wx) * zeta3 + (4.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 - 1.0i * wx, 1.0 - wx * xdinv) * zeta3 + (4.0 * 1.0i) * M_PI * my_sign(imag(wx * xdinv)) * T(1.0, 1.0 + 1.0i * wx, 1.0 - wx * xdinv) * zeta3 - (6.0 * 1.0i) * M_PI * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) * zeta3
                - (6.0 * 1.0i) * M_PI * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) * zeta3 - (2.0 * 1.0i) * M_PI * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) * zeta3 - (2.0 * 1.0i) * M_PI * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) * zeta3 + (2.0 * 1.0i) * M_PI * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx) * zeta3 + (2.0 * 1.0i) * M_PI * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) * zeta3
                + log(1.0 + 1.0i * xd) * ((-1.0 / 6.0) * (pisqu * lnm2) - power_of<3>(lnm2) / 6.0 - (pisqu * lnm1) / 6.0 - power_of<3>(lnm1) / 6.0 + (lnm1 * ln2squ) / 2.0 + (pisqu * log(1.0 - 1.0i * wx)) / 6.0 + (log(0.5 + (1.0i / 2.0) * wx) * power_of<2>(log(1.0 - 1.0i * wx))) / 4.0 + power_of<3>(log(1.0 - 1.0i * wx)) / 12.0 - (pisqu * log(-1.0 + 1.0i * wx)) / 4.0 - power_of<3>(log(-1.0 + 1.0i * wx)) / 4.0 - (log(0.5 - (1.0i / 2.0) * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 2.0 + (pisqu * log(((-0.5) * 1.0i) / wx)) / 12.0 + power_of<3>(log(((-0.5) * 1.0i) / wx)) / 12.0 - (pisqu * log(1.0i / 2.0 / wx)) / 12.0 - power_of<3>(log(1.0i / 2.0 / wx)) / 12.0 - (pisqu * log(-1.0i / wx)) / 3.0 + power_of<2>(log(1.0 - 1.0i * wx)) * log(-1.0i / wx) - power_of<3>(log(-1.0i / wx)) / 3.0
                + (5.0 * pisqu * log(1.0i / wx)) / 12.0 - (5.0 * power_of<2>(log(1.0 + 1.0i * wx)) * log(1.0i / wx)) / 4.0 + (5.0 * power_of<3>(log(1.0i / wx))) / 12.0 + (pisqu * log((-2.0 * 1.0i) / wx)) / 3.0 + power_of<3>(log((-2.0 * 1.0i) / wx)) / 3.0 + (pisqu * log((2.0 * 1.0i) / wx)) / 2.0 + power_of<3>(log((2.0 * 1.0i) / wx)) / 2.0 - (pisqu * log(((-0.5) * 1.0i) * wx)) / 6.0 - power_of<3>(log(((-0.5) * 1.0i) * wx)) / 6.0 + (pisqu * log((-1.0i) * wx)) / 2.0 + power_of<2>(log(1.0 + 1.0i * wx)) * log((-1.0i) * wx) + (log(1.0 + 1.0i * wx) * power_of<2>(log((-1.0i) * wx))) / 2.0 + power_of<3>(log((-1.0i) * wx)) / 2.0 - (pisqu * log(1.0i * wx)) / 6.0 - power_of<3>(log(1.0i * wx)) / 6.0 + (pisqu * log((-2.0 * 1.0i) * wx)) / 12.0 + power_of<3>(log((-2.0 * 1.0i) * wx)) / 12.0 - (pisqu * log((2.0 * 1.0i) * wx)) / 12.0 - power_of<3>(log((2.0 * 1.0i) * wx)) / 12.0
                + (pisqu * log(wx / (1.0i - wx))) / 12.0 + power_of<3>(log(wx / (1.0i - wx))) / 12.0 + (pisqu * log(1.0i / (-1.0i + wx))) / 12.0 + power_of<3>(log(1.0i / (-1.0i + wx))) / 12.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((-2.0 * 1.0i) / (-1.0i + wx))) / 4.0 + (pisqu * log(wx / (-1.0i + wx))) / 12.0 - power_of<2>(lnhalf) * log(wx / (-1.0i + wx)) + power_of<3>(log(wx / (-1.0i + wx))) / 12.0 + power_of<2>(lnhalf) * log((2.0 * wx) / (-1.0i + wx)) + (power_of<2>(log(1.0 - 1.0i * wx)) * log((2.0 * wx) / (-1.0i + wx))) / 4.0 + power_of<2>(lnhalf) * log((-1.0i + wx) / (2.0 * wx)) - (power_of<2>(log(1.0 - 1.0i * wx)) * log((-1.0i + wx) / (2.0 * wx))) / 4.0 - power_of<2>(lnhalf) * log((-1.0i + wx) / wx) + (log(0.5 - (1.0i / 2.0) * wx) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0
                - (3.0 * log((-1.0i) * wx) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 - (pisqu * log(1.0i / (1.0i + wx))) / 6.0 - power_of<3>(log(1.0i / (1.0i + wx))) / 6.0 + (3.0 * power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * 1.0i) / (1.0i + wx))) / 4.0 - power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * 1.0i) / (1.0i + wx)) + (ln2squ * log((1.0i - wx) / (1.0i + wx))) / 4.0 - (pisqu * log(-(wx / (1.0i + wx)))) / 12.0 - power_of<3>(log(-(wx / (1.0i + wx)))) / 12.0 - (pisqu * log(wx / (1.0i + wx))) / 6.0 - power_of<2>(lnhalf) * log(wx / (1.0i + wx)) - power_of<3>(log(wx / (1.0i + wx))) / 6.0 + power_of<2>(lnhalf) * log((2.0 * wx) / (1.0i + wx)) - (3.0 * power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * wx) / (1.0i + wx))) / 4.0 + power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * wx) / (1.0i + wx))
                - (ln2squ * log((-1.0i + wx) / (1.0i + wx))) / 4.0 - (pisqu * log((2.0 * (-1.0i + wx)) / (1.0i + wx))) / 3.0 - power_of<3>(log((2.0 * (-1.0i + wx)) / (1.0i + wx))) / 3.0 - (ln2squ * log((1.0i + wx) / (1.0i - wx))) / 4.0 + (pisqu * log(-((1.0i + wx) / wx))) / 6.0 + power_of<3>(log(-((1.0i + wx) / wx))) / 6.0 + power_of<2>(lnhalf) * log((1.0i + wx) / (2.0 * wx)) + (power_of<2>(log(1.0 + 1.0i * wx)) * log((1.0i + wx) / (2.0 * wx))) / 2.0 - (power_of<2>(log((-1.0i + wx) / wx)) * log((1.0i + wx) / (2.0 * wx))) / 2.0 - power_of<2>(lnhalf) * log((1.0i + wx) / wx) + (log(1.0i * wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (log((-2.0 * 1.0i) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx))) / 4.0
                - (log((2.0 * wx) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx))) / 4.0 + (ln2squ * log((1.0i + wx) / (-1.0i + wx))) / 4.0 - (pisqu * log((2.0 * (1.0i + wx)) / (-1.0i + wx))) / 3.0 - power_of<3>(log((2.0 * (1.0i + wx)) / (-1.0i + wx))) / 3.0 + (pisqu * log(1.0i / xd)) / 4.0 + power_of<3>(log(1.0i / xd)) / 4.0 - power_of<3>(log(wx * xdinv)) / 6.0 - (pisqu * log((1.0i * wx) / ((-1.0i + wx) * xd))) / 3.0 - power_of<3>(log((1.0i * wx) / ((-1.0i + wx) * xd))) / 3.0 + (pisqu * log((-1.0i + wx) * xdinv)) / 3.0 + power_of<3>(log((-1.0i + wx) * xdinv)) / 3.0 - (pisqu * log((-1.0i + 1.0 / wx) * xd)) / 12.0 - power_of<3>(log((-1.0i + 1.0 / wx) * xd)) / 12.0 + (pisqu * log((1.0i * (1.0i + wx) * xd) / wx)) / 12.0 + power_of<3>(log((1.0i * (1.0i + wx) * xd) / wx)) / 12.0
                - (pisqu * log(-1.0i / (-1.0i + xd))) / 6.0 - power_of<3>(log(-1.0i / (-1.0i + xd))) / 6.0 - (pisqu * log((1.0 + 1.0i * wx) / (wx * (-1.0i + xd)))) / 6.0 - power_of<3>(log((1.0 + 1.0i * wx) / (wx * (-1.0i + xd)))) / 6.0 - (pisqu * log(wx / (-1.0i + xd))) / 12.0 - power_of<3>(log(wx / (-1.0i + xd))) / 12.0 - power_of<3>(log((-1.0i + wx) / (-1.0i + xd))) / 6.0 + (pisqu * log((-2.0 - (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 3.0 + power_of<3>(log((-2.0 - (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 3.0 + (pisqu * log((2.0 + (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 2.0 + power_of<3>(log((2.0 + (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 2.0 + (pisqu * log((-1.0i + xd) / (-1.0i + wx))) / 6.0 + power_of<3>(log((-1.0i + xd) / (-1.0i + wx))) / 6.0
                + (pisqu * log(-(wx / (1.0i + xd)))) / 12.0 + power_of<3>(log(-(wx / (1.0i + xd)))) / 12.0 - (pisqu * log((-1.0i + wx) / (1.0i + xd))) / 2.0 - power_of<3>(log((-1.0i + wx) / (1.0i + xd))) / 2.0 + (pisqu * log(((2.0 * 1.0i) * (1.0i + wx)) / ((-1.0i + wx) * (1.0i + xd)))) / 3.0 + power_of<3>(log(((2.0 * 1.0i) * (1.0i + wx)) / ((-1.0i + wx) * (1.0i + xd)))) / 3.0 + ((-0.25) * power_of<2>(log(1.0 - 1.0i * wx)) + power_of<2>(log((1.0i + wx) / wx)) / 4.0) * log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) - (power_of<2>(log(1.0 - 1.0i * wx)) * log(-((1.0i + xd) / (wx - xd)))) / 4.0 + (power_of<2>(log(1.0 - 1.0i * wx)) / 4.0 - power_of<2>(log((1.0i + wx) / wx)) / 4.0) * log((-wx + xd) / (1.0i + xd)) + (pisqu * log(1.0 - xd / wx)) / 12.0 + (log(xd / wx) * power_of<2>(log(1.0 - xd / wx))) / 2.0
                - (log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 4.0 - (log((1.0i + wx) / (1.0i + xd)) * power_of<2>(log(1.0 - xd / wx))) / 4.0 + (log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 4.0 - (log((wx * (1.0i + xd)) / ((1.0i + wx) * xd)) * power_of<2>(log(1.0 - xd / wx))) / 2.0 + log((-1.0i + wx) / (-1.0i + xd)) * ((-1.0 / 6.0) * pisqu + power_of<2>(log(1.0 - xd / wx)) / 4.0) + log(wx * xdinv) * ((-1.0 / 6.0) * pisqu + power_of<2>(log(1.0 - xd / wx)) / 2.0) + (pisqu * log(-1.0 + xd / wx)) / 12.0 + power_of<3>(log(-1.0 + xd / wx)) / 12.0 + (pisqu * log((1.0 + 1.0i * wx) / (1.0i * wx - wx * xd))) / 3.0 + power_of<3>(log((1.0 + 1.0i * wx) / (1.0i * wx - wx * xd))) / 3.0
                + (power_of<2>(log(1.0 - 1.0i * wx)) * log((wx - 1.0i * wx * xd) / (wx - xd))) / 4.0 - (pisqu * log((wx + 1.0i * wx * xd) / (1.0i - wx))) / 6.0 - power_of<3>(log((wx + 1.0i * wx * xd) / (1.0i - wx))) / 6.0 + (pisqu * log(((-1.0i) * wx) / (1.0i * xd + wx * xd))) / 12.0 + power_of<3>(log(((-1.0i) * wx) / (1.0i * xd + wx * xd))) / 12.0 + (pisqu * log((1.0i * wx) / (1.0i * xd + wx * xd))) / 6.0 + power_of<3>(log((1.0i * wx) / (1.0i * xd + wx * xd))) / 6.0 + (1.0i / 2.0) * M_PI * H1((-1.0i) * wx, wx * xdinv) * power_of<2>(log((1.0i - xd) / wx)) * my_sign(imag(wx * xdinv)) - 1.0i * M_PI * H1(-1.0i / xd, wx * xdinv) * power_of<2>(log((1.0i - 1.0 / wx) * xd)) * my_sign(imag(wx * xdinv)) - (1.0i / 2.0) * M_PI * H1(-1.0i / xd, wx * xdinv) * power_of<2>(log((1.0i * (1.0i + wx) * xd) / wx)) * my_sign(imag(wx * xdinv))
                + (1.0i / 2.0) * M_PI * H2(wx * xdinv, 1.0i / xd) * power_of<2>(log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd))) * my_sign(imag(wx * xdinv)) + 1.0i * M_PI * H1(-1.0i / (-1.0i + xd), (-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log((wx * (1.0 + 1.0i * xd)) / (-1.0i + wx))) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) - (3.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + xd), (-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (-1.0i + wx)))) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) - (2.0 * 1.0i) * M_PI * H1(1.0 + 1.0i * wx, (-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log(-(xd / (-1.0i + wx)))) * my_sign(imag((-1.0i + wx) / (-1.0i + xd)))
                + (3.0 * 1.0i) * M_PI * H1((1.0 + 1.0i * wx) / 2.0, (-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log((1.0i + xd) / (1.0i - wx))) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) - 1.0i * M_PI * H1(-1.0i / (-1.0i + xd), (-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log((1.0 + 1.0i * wx) / (1.0i * wx - wx * xd))) * my_sign(imag((-1.0i + wx) / (-1.0i + xd))) - (1.0i / 2.0) * M_PI * H1(-1.0i / xd, -1.0i / wx) * power_of<2>(log(1.0i * (-wx + xd))) * my_sign(-real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H2(1.0i / wx, 1.0i / xd) * power_of<2>(log((-1.0i + xd) / (-wx + xd))) * my_sign(real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H1(wx * xdinv, 1.0i * wx) * power_of<2>(log((1.0i + xd) / wx)) * my_sign(real(wx))
                - (2.0 * 1.0i) * M_PI * H1((-1.0i + wx) / (-1.0i + xd), -1.0i / (-1.0i + xd)) * power_of<2>(log((wx + 1.0i * wx * xd) / (1.0i - wx))) * my_sign(real(1.0 / (1.0i - xd))) + (2.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + xd)) * power_of<2>(log((1.0i / 2.0) * (wx - xd))) * my_sign(2.0 * real(1.0 / (1.0i - xd))) - (2.0 * 1.0i) * M_PI * H1((-1.0i + wx) / (-1.0i + xd), (-2.0 * 1.0i) / (-1.0i + xd)) * power_of<2>(log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * 1.0i - 2.0 * wx))) * my_sign(2.0 * real(1.0 / (1.0i - xd))) + (2.0 * 1.0i) * M_PI * H1(wx * xdinv, 1.0i / xd) * power_of<2>(log((1.0i + 1.0 / wx) * xd)) * my_sign(real(xdinv)) + (2.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + xd)) * power_of<2>(log(((-0.5) * 1.0i) * (wx - xd))) * my_sign(2.0 * real(1.0 / (1.0i + xd)))
                - (2.0 * 1.0i) * M_PI * H1((1.0i + wx) / (1.0i + xd), (2.0 * 1.0i) / (1.0i + xd)) * power_of<2>(log(((1.0 + 1.0i * wx) * (1.0i + xd)) / (2.0 * (1.0i + wx)))) * my_sign(2.0 * real(1.0 / (1.0i + xd))) - (1.0i / 2.0) * M_PI * power_of<2>(log((1.0i + xd) * xdinv)) * my_sign(-real(xdinv)) * T(1.0, (1.0i + wx) / wx, (1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / (1.0i - wx))) * T(1.0, (wx - xd) / (-1.0i + wx), wx / (-1.0i + wx)) - 1.0i * M_PI * power_of<2>(log(wx / (-1.0i + wx))) * my_sign(real(1.0 / (-1.0i + wx))) * T(1.0, (wx - xd) / (-1.0i + wx), wx / (-1.0i + wx)) - (3.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx) / (-1.0i + wx))) * my_sign(-2.0 * real(1.0 / (-1.0i + wx))) * T(1.0, (wx - xd) / (-1.0i + wx), (1.0i + wx) / (-1.0i + wx))
                + power_of<2>(log((-1.0i) * xd)) * (log(-1.0i / (-1.0i + xd)) / 2.0 - log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) / 2.0 + log(1.0 - xd / wx) / 2.0 - log((wx + 1.0i * wx * xd) / (wx - xd)) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(-real(xd)) * T(1.0, (wx - xd) / (-1.0i + wx), (-1.0i) * xd)) - (2.0 * 1.0i) * M_PI * power_of<2>(log(0.5 - (1.0i / 2.0) * wx)) * my_sign(real(wx) / 2.0) * T(1.0, 0.5 - (1.0i / 2.0) * xd, 0.5 - (1.0i / 2.0) * wx) - (2.0 * 1.0i) * M_PI * power_of<2>(log(0.5 + (1.0i / 2.0) * wx)) * my_sign((-0.5) * real(wx)) * T(1.0, 0.5 + (1.0i / 2.0) * xd, 0.5 + (1.0i / 2.0) * wx) - (4.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)
                + 1.0i * M_PI * power_of<2>(log(1.0 - 1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (4.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * log((-1.0i) * xd) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * log(xd) * my_sign(real(xdinv)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)
                + log((2.0 * 1.0i) / (1.0i + xd)) * ((-0.25) * power_of<2>(log(-1.0 - 1.0i * wx)) + power_of<2>(log(-1.0 + xd / wx)) / 4.0 + 1.0i * M_PI * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) - 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 - xd / wx)) + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i) * wx)) * my_sign(-real(wx)) * T(1.0, (-1.0i) * xd, (-1.0i) * wx) - ((3.0 * 1.0i) / 2.0) * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (1.0i + wx) / wx) + log((1.0i + xd) / (1.0i + wx)) * (power_of<2>(log(1.0 - xd / wx)) / 2.0 + 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(-real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd))
                + 2.0 * pisqu * log((1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, 1.0 + 1.0i * xd) * T(p((-1.0i) * xd, 1.0 - xd / wx), 1.0 - xd / wx, (1.0i + wx) / wx) + zeta3) + log(1.0 - 1.0i * xd) * ((-1.0 / 6.0) * (pisqu * lnm2) - power_of<3>(lnm2) / 6.0 - (pisqu * lnm1) / 6.0 - power_of<3>(lnm1) / 6.0 + (lnm1 * ln2squ) / 2.0 + (pisqu * log(-1.0 + 1.0i / wx)) / 6.0 + power_of<3>(log(-1.0 + 1.0i / wx)) / 6.0 - (pisqu * log(-1.0 - 1.0i * wx)) / 4.0 - power_of<3>(log(-1.0 - 1.0i * wx)) / 4.0 - (log(0.5 + (1.0i / 2.0) * wx) * power_of<2>(log(1.0 - 1.0i * wx))) / 2.0 + (pisqu * log(1.0 + 1.0i * wx)) / 6.0 + (log(0.5 - (1.0i / 2.0) * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 + power_of<3>(log(1.0 + 1.0i * wx)) / 12.0 - (pisqu * log(((-0.5) * 1.0i) / wx)) / 12.0
                - power_of<3>(log(((-0.5) * 1.0i) / wx)) / 12.0 + (pisqu * log(1.0i / 2.0 / wx)) / 12.0 + power_of<3>(log(1.0i / 2.0 / wx)) / 12.0 + (5.0 * pisqu * log(-1.0i / wx)) / 12.0 - (5.0 * power_of<2>(log(1.0 - 1.0i * wx)) * log(-1.0i / wx)) / 4.0 + (5.0 * power_of<3>(log(-1.0i / wx))) / 12.0 - (pisqu * log(1.0i / wx)) / 3.0 + power_of<2>(log(1.0 + 1.0i * wx)) * log(1.0i / wx) - power_of<3>(log(1.0i / wx)) / 3.0 + (pisqu * log((-2.0 * 1.0i) / wx)) / 2.0 + power_of<3>(log((-2.0 * 1.0i) / wx)) / 2.0 + (pisqu * log((2.0 * 1.0i) / wx)) / 3.0 + power_of<3>(log((2.0 * 1.0i) / wx)) / 3.0 - (pisqu * log((1.0i / 2.0) * wx)) / 6.0 - power_of<3>(log((1.0i / 2.0) * wx)) / 6.0 - (pisqu * log((-1.0i) * wx)) / 6.0 - power_of<3>(log((-1.0i) * wx)) / 6.0 + (pisqu * log(1.0i * wx)) / 2.0 + power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0i * wx) + (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0i * wx))) / 2.0
                + power_of<3>(log(1.0i * wx)) / 2.0 - (pisqu * log((-2.0 * 1.0i) * wx)) / 12.0 - power_of<3>(log((-2.0 * 1.0i) * wx)) / 12.0 + (pisqu * log((2.0 * 1.0i) * wx)) / 12.0 + power_of<3>(log((2.0 * 1.0i) * wx)) / 12.0 - (pisqu * log(wx / (1.0i - wx))) / 12.0 - power_of<3>(log(wx / (1.0i - wx))) / 12.0 - (pisqu * log(-1.0i / (-1.0i + wx))) / 6.0 - power_of<3>(log(-1.0i / (-1.0i + wx))) / 6.0 + (3.0 * power_of<2>(log(1.0 - 1.0i * wx)) * log((-2.0 * 1.0i) / (-1.0i + wx))) / 4.0 - (pisqu * log(wx / (-1.0i + wx))) / 6.0 - power_of<2>(lnhalf) * log(wx / (-1.0i + wx)) - power_of<3>(log(wx / (-1.0i + wx))) / 6.0 + power_of<2>(lnhalf) * log((2.0 * wx) / (-1.0i + wx)) - (3.0 * power_of<2>(log(1.0 - 1.0i * wx)) * log((2.0 * wx) / (-1.0i + wx))) / 4.0 + power_of<2>(lnhalf) * log((-1.0i + wx) / (2.0 * wx))
                + (power_of<2>(log(1.0 - 1.0i * wx)) * log((-1.0i + wx) / (2.0 * wx))) / 2.0 - power_of<2>(lnhalf) * log((-1.0i + wx) / wx) + (log((-1.0i) * wx) * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + (pisqu * log(-1.0i / (1.0i + wx))) / 12.0 + power_of<3>(log(-1.0i / (1.0i + wx))) / 12.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * 1.0i) / (1.0i + wx))) / 4.0 + (power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * 1.0i) / (1.0i + wx))) / 4.0 - (ln2squ * log((1.0i - wx) / (1.0i + wx))) / 4.0 + (pisqu * log(-(wx / (1.0i + wx)))) / 12.0 + power_of<3>(log(-(wx / (1.0i + wx)))) / 12.0 + (pisqu * log(wx / (1.0i + wx))) / 12.0 - power_of<2>(lnhalf) * log(wx / (1.0i + wx)) + power_of<3>(log(wx / (1.0i + wx))) / 12.0 + power_of<2>(lnhalf) * log((2.0 * wx) / (1.0i + wx))
                + (power_of<2>(log(1.0 + 1.0i * wx)) * log((2.0 * wx) / (1.0i + wx))) / 4.0 - (power_of<2>(log((-1.0i + wx) / wx)) * log((2.0 * wx) / (1.0i + wx))) / 4.0 + (ln2squ * log((-1.0i + wx) / (1.0i + wx))) / 4.0 - (pisqu * log((2.0 * (-1.0i + wx)) / (1.0i + wx))) / 3.0 - power_of<3>(log((2.0 * (-1.0i + wx)) / (1.0i + wx))) / 3.0 + (ln2squ * log((1.0i + wx) / (1.0i - wx))) / 4.0 + power_of<2>(lnhalf) * log((1.0i + wx) / (2.0 * wx)) - (power_of<2>(log(1.0 + 1.0i * wx)) * log((1.0i + wx) / (2.0 * wx))) / 4.0 - power_of<2>(lnhalf) * log((1.0i + wx) / wx) + (log(0.5 + (1.0i / 2.0) * wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - (3.0 * log(1.0i * wx) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - log((-2.0 * 1.0i) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx))
                + log((2.0 * wx) / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx)) - (log((-1.0i + wx) / (2.0 * wx)) * power_of<2>(log((1.0i + wx) / wx))) / 2.0 - (ln2squ * log((1.0i + wx) / (-1.0i + wx))) / 4.0 - (pisqu * log((2.0 * (1.0i + wx)) / (-1.0i + wx))) / 3.0 - power_of<3>(log((2.0 * (1.0i + wx)) / (-1.0i + wx))) / 3.0 + (pisqu * log(wx / (1.0i - xd))) / 12.0 + power_of<3>(log(wx / (1.0i - xd))) / 12.0 - (pisqu * log((-2.0 * 1.0i) / (wx - xd))) / 3.0 - power_of<3>(log((-2.0 * 1.0i) / (wx - xd))) / 3.0 - (pisqu * log((2.0 * 1.0i) / (wx - xd))) / 3.0 - power_of<3>(log((2.0 * 1.0i) / (wx - xd))) / 3.0 + (pisqu * log(-1.0i / xd)) / 4.0 + power_of<3>(log(-1.0i / xd)) / 4.0 - power_of<3>(log(wx * xdinv)) / 6.0 + (pisqu * log((1.0i * wx) / ((-1.0i + wx) * xd))) / 12.0
                + power_of<3>(log((1.0i * wx) / ((-1.0i + wx) * xd))) / 12.0 + (pisqu * log((1.0i + wx) * xdinv)) / 3.0 + power_of<3>(log((1.0i + wx) * xdinv)) / 3.0 + (pisqu * log((-1.0i - 1.0 / wx) * xd)) / 12.0 + power_of<3>(log((-1.0i - 1.0 / wx) * xd)) / 12.0 - (pisqu * log((1.0i + 1.0 / wx) * xd)) / 12.0 - power_of<3>(log((1.0i + 1.0 / wx) * xd)) / 12.0 + (pisqu * log((-2.0 - (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 3.0 + power_of<3>(log((-2.0 - (2.0 * 1.0i) * wx) / ((1.0i + wx) * (-1.0i + xd)))) / 3.0 - (pisqu * log((1.0i + wx) / (-1.0i + xd))) / 2.0 - power_of<3>(log((1.0i + wx) / (-1.0i + xd))) / 2.0 + ((-0.25) * power_of<2>(log(1.0 + 1.0i * wx)) + power_of<2>(log((-1.0i + wx) / wx)) / 4.0) * log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd)))
                + power_of<2>(log(0.5 - (1.0i / 2.0) * xd)) * (-log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * (wx - xd))) - log(((-2.0 * 1.0i) * (wx - xd)) / ((1.0i + wx) * (-1.0i + xd)))) - (pisqu * log(1.0i / (1.0i + xd))) / 6.0 - power_of<3>(log(1.0i / (1.0i + xd))) / 6.0 - (pisqu * log(wx / (1.0i + xd))) / 12.0 - power_of<3>(log(wx / (1.0i + xd))) / 12.0 + (pisqu * log((2.0 - (2.0 * 1.0i) * wx) / ((-1.0i + wx) * (1.0i + xd)))) / 2.0 + power_of<3>(log((2.0 - (2.0 * 1.0i) * wx) / ((-1.0i + wx) * (1.0i + xd)))) / 2.0 - power_of<3>(log((1.0i + wx) / (1.0i + xd))) / 6.0 + (pisqu * log((1.0i * (1.0i + wx)) / (wx * (1.0i + xd)))) / 3.0 + power_of<3>(log((1.0i * (1.0i + wx)) / (wx * (1.0i + xd)))) / 3.0 + (pisqu * log(((2.0 * 1.0i) * (1.0i + wx)) / ((-1.0i + wx) * (1.0i + xd)))) / 3.0
                + power_of<3>(log(((2.0 * 1.0i) * (1.0i + wx)) / ((-1.0i + wx) * (1.0i + xd)))) / 3.0 + (pisqu * log((1.0i + xd) / (1.0i + wx))) / 6.0 + power_of<3>(log((1.0i + xd) / (1.0i + wx))) / 6.0 - (pisqu * log((1.0i * wx * (1.0i + xd)) / (1.0i + wx))) / 6.0 - power_of<3>(log((1.0i * wx * (1.0i + xd)) / (1.0i + wx))) / 6.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((-1.0i + xd) / (-wx + xd))) / 4.0 + (power_of<2>(log(1.0 + 1.0i * wx)) / 4.0 - power_of<2>(log((-1.0i + wx) / wx)) / 4.0) * log((-wx + xd) / (-1.0i + xd)) + (pisqu * log(1.0 - xd / wx)) / 12.0 + (log(xd / wx) * power_of<2>(log(1.0 - xd / wx))) / 2.0 - (log((-1.0i + wx) / (-1.0i + xd)) * power_of<2>(log(1.0 - xd / wx))) / 4.0 + (log(((-1.0i + wx) * xd) / (wx * (-1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 4.0
                - (log((wx * (-1.0i + xd)) / ((-1.0i + wx) * xd)) * power_of<2>(log(1.0 - xd / wx))) / 2.0 - (log(((1.0i + wx) * xd) / (wx * (1.0i + xd))) * power_of<2>(log(1.0 - xd / wx))) / 4.0 + log((1.0i + wx) / (1.0i + xd)) * ((-1.0 / 6.0) * pisqu + power_of<2>(log(1.0 - xd / wx)) / 4.0) + log(wx * xdinv) * ((-1.0 / 6.0) * pisqu + power_of<2>(log(1.0 - xd / wx)) / 2.0) + (pisqu * log(-1.0 + xd / wx)) / 12.0 + power_of<3>(log(-1.0 + xd / wx)) / 12.0 + (pisqu * log((1.0i * wx) / (1.0i * xd - wx * xd))) / 6.0 + power_of<3>(log((1.0i * wx) / (1.0i * xd - wx * xd))) / 6.0 + (power_of<2>(log(1.0 + 1.0i * wx)) * log((wx + 1.0i * wx * xd) / (wx - xd))) / 4.0
                + power_of<2>(log(1.0 + 1.0i * xd)) * ((-0.5) * log((1.0i * (wx - xd)) / ((-1.0i + wx) * xd)) - log(-((xd + 1.0i * wx * xd) / (wx - xd))) / 2.0) - (pisqu * log((1.0 - 1.0i * wx) / (1.0i * wx + wx * xd))) / 6.0 - power_of<3>(log((1.0 - 1.0i * wx) / (1.0i * wx + wx * xd))) / 6.0 - (pisqu * log(((-1.0i) * wx) / (1.0i * xd + wx * xd))) / 3.0 - power_of<3>(log(((-1.0i) * wx) / (1.0i * xd + wx * xd))) / 3.0 - ((3.0 * 1.0i) / 2.0) * M_PI * H1(1.0i / xd, wx * xdinv) * power_of<2>(log((-1.0i - 1.0 / wx) * xd)) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H1(1.0i * wx, wx * xdinv) * power_of<2>(log(-((1.0i + xd) / wx))) * my_sign(imag(wx * xdinv)) + (1.0i / 2.0) * M_PI * H2(wx * xdinv, -1.0i / xd) * power_of<2>(log((wx * (1.0i + xd)) / ((1.0i + wx) * xd))) * my_sign(imag(wx * xdinv))
                + (3.0 * 1.0i) * M_PI * H1(0.5 - (1.0i / 2.0) * wx, (1.0i + wx) / (1.0i + xd)) * power_of<2>(log((1.0i - xd) / (1.0i + wx))) * my_sign(imag((1.0i + wx) / (1.0i + xd))) - (3.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + xd), (1.0i + wx) / (1.0i + xd)) * power_of<2>(log(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (1.0i + wx)))) * my_sign(imag((1.0i + wx) / (1.0i + xd))) - (2.0 * 1.0i) * M_PI * H1(1.0 - 1.0i * wx, (1.0i + wx) / (1.0i + xd)) * power_of<2>(log(-(xd / (1.0i + wx)))) * my_sign(imag((1.0i + wx) / (1.0i + xd))) - 1.0i * M_PI * H1(1.0i / (1.0i + xd), (1.0i + wx) / (1.0i + xd)) * power_of<2>(log((1.0i * (1.0i + wx)) / (wx * (1.0i + xd)))) * my_sign(imag((1.0i + wx) / (1.0i + xd)))
                + 1.0i * M_PI * H1(1.0i / (1.0i + xd), (1.0i + wx) / (1.0i + xd)) * power_of<2>(log((wx - 1.0i * wx * xd) / (1.0i + wx))) * my_sign(imag((1.0i + wx) / (1.0i + xd))) - (1.0i / 2.0) * M_PI * H2(-1.0i / wx, -1.0i / xd) * power_of<2>(log(-((1.0i + xd) / (wx - xd)))) * my_sign(-real(1.0 / wx)) - (1.0i / 2.0) * M_PI * H1(wx * xdinv, (-1.0i) * wx) * power_of<2>(log((-1.0i + xd) / wx)) * my_sign(-real(wx)) + (2.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx), (-2.0 * 1.0i) / (-1.0i + xd)) * power_of<2>(log((1.0i / 2.0) * (wx - xd))) * my_sign(2.0 * real(1.0 / (1.0i - xd))) - (2.0 * 1.0i) * M_PI * H1((-1.0i + wx) / (-1.0i + xd), (-2.0 * 1.0i) / (-1.0i + xd)) * power_of<2>(log(((1.0i + wx) * (1.0 + 1.0i * xd)) / (2.0 * 1.0i - 2.0 * wx))) * my_sign(2.0 * real(1.0 / (1.0i - xd)))
                + (2.0 * 1.0i) * M_PI * H1(wx * xdinv, -1.0i / xd) * power_of<2>(log((-1.0i + 1.0 / wx) * xd)) * my_sign(-real(xdinv)) - (2.0 * 1.0i) * M_PI * H1((1.0i + wx) / (1.0i + xd), 1.0i / (1.0i + xd)) * power_of<2>(log((1.0i * wx * (1.0i + xd)) / (1.0i + wx))) * my_sign(real(1.0 / (1.0i + xd))) + 1.0i * M_PI * H1(1.0i / (1.0i + wx), 1.0i / (1.0i + xd)) * power_of<2>(log(1.0i * (-wx + xd))) * my_sign(real(1.0 / (1.0i + xd))) + 1.0i * M_PI * H1((2.0 * 1.0i) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + xd)) * power_of<2>(log(((-0.5) * 1.0i) * (wx - xd))) * my_sign(2.0 * real(1.0 / (1.0i + xd))) - (2.0 * 1.0i) * M_PI * H1((1.0i + wx) / (1.0i + xd), (2.0 * 1.0i) / (1.0i + xd)) * power_of<2>(log(((1.0 + 1.0i * wx) * (1.0i + xd)) / (2.0 * (1.0i + wx)))) * my_sign(2.0 * real(1.0 / (1.0i + xd)))
                + 1.0i * M_PI * H1((2.0 * 1.0i) / (1.0i + wx), (2.0 * 1.0i) / (1.0i + xd)) * power_of<2>(log((1.0i / 2.0) * (-wx + xd))) * my_sign(2.0 * real(1.0 / (1.0i + xd))) - (1.0i / 2.0) * M_PI * power_of<2>(log((-1.0i + xd) * xdinv)) * my_sign(real(xdinv)) * T(1.0, (-1.0i + wx) / wx, (-1.0i + xd) * xdinv) - 1.0i * M_PI * power_of<2>(log(wx / (1.0i + wx))) * my_sign(-real(1.0 / (1.0i + wx))) * T(1.0, (wx - xd) / (1.0i + wx), wx / (1.0i + wx)) - 1.0i * M_PI * power_of<2>(log((1.0i + wx) / wx)) * my_sign(real(1.0 / (1.0i + wx))) * T(1.0, (wx - xd) / (1.0i + wx), wx / (1.0i + wx)) - (3.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx) / (1.0i + wx))) * my_sign(2.0 * real(1.0 / (1.0i + wx))) * T(1.0, (wx - xd) / (1.0i + wx), (-1.0i + wx) / (1.0i + wx))
                + power_of<2>(log(0.5 + (1.0i / 2.0) * xd)) * (-log(((-1.0i + wx) * (1.0 - 1.0i * xd)) / (2.0 * (wx - xd))) - log(((2.0 * 1.0i) * (wx - xd)) / ((-1.0i + wx) * (1.0i + xd))) + (3.0 * 1.0i) * M_PI * my_sign((-0.5) * real(xd)) * T(1.0, (wx - xd) / (1.0i + wx), 0.5 + (1.0i / 2.0) * xd)) + power_of<2>(log(1.0i * xd)) * (log(1.0i / (1.0i + xd)) / 2.0 - log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) / 2.0 + log(1.0 - xd / wx) / 2.0 - log((wx - 1.0i * wx * xd) / (wx - xd)) / 2.0 + (2.0 * 1.0i) * M_PI * my_sign(real(xd)) * T(1.0, (wx - xd) / (1.0i + wx), 1.0i * xd)) - (2.0 * 1.0i) * M_PI * power_of<2>(log(0.5 - (1.0i / 2.0) * wx)) * my_sign(real(wx) / 2.0) * T(1.0, 0.5 - (1.0i / 2.0) * xd, 0.5 - (1.0i / 2.0) * wx)
                - (2.0 * 1.0i) * M_PI * power_of<2>(log(0.5 + (1.0i / 2.0) * wx)) * my_sign((-0.5) * real(wx)) * T(1.0, 0.5 + (1.0i / 2.0) * xd, 0.5 + (1.0i / 2.0) * wx) - (4.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * log(xd) * my_sign(-real(xdinv)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + log(1.0i * xd) * (power_of<2>(log(-((1.0i + xd) * xdinv))) / 2.0 - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx)) - (1.0i / 2.0) * M_PI * power_of<2>(log(1.0 - xd / wx)) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)
                + log((-2.0 * 1.0i) / (-1.0i + xd)) * ((-0.25) * power_of<2>(log(-1.0 + 1.0i * wx)) + power_of<2>(log(-1.0 + xd / wx)) / 4.0 + 1.0i * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)) + log(0.5 + (1.0i / 2.0) * xd) * ((-1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(real(wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) + 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(imag(xd / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - xd / wx)) - (4.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * log(1.0 + 1.0i * wx) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx) + 1.0i * M_PI * power_of<2>(log(1.0 + 1.0i * wx)) * my_sign(-real(wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)
                + log(1.0 + 1.0i * xd) * ((4.0 * 1.0i) * M_PI * log(0.5 - (1.0i / 2.0) * wx) * my_sign(2.0 * real(1.0 / (1.0i - xd))) * T(1.0, 0.5 - (1.0i / 2.0) * xd, 0.5 - (1.0i / 2.0) * wx) + (4.0 * 1.0i) * M_PI * log(0.5 + (1.0i / 2.0) * wx) * my_sign(2.0 * real(1.0 / (1.0i + xd))) * T(1.0, 0.5 + (1.0i / 2.0) * xd, 0.5 + (1.0i / 2.0) * wx) - (2.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx) * my_sign(-real(1.0 / wx)) * T(1.0, 1.0 - 1.0i * xd, 1.0 - 1.0i * wx) - (2.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 + 1.0i * xd, 1.0 + 1.0i * wx)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0i * wx)) * my_sign(real(wx)) * T(1.0, 1.0i * xd, 1.0i * wx) - ((3.0 * 1.0i) / 2.0) * M_PI * power_of<2>(log((-1.0i + wx) / wx)) * my_sign(real(1.0 / wx)) * T(1.0, 1.0 - xd / wx, (-1.0i + wx) / wx)
                + log((-1.0i + xd) / (-1.0i + wx)) * (power_of<2>(log(1.0 - xd / wx)) / 2.0 + 1.0i * M_PI * log(1.0 - xd / wx) * my_sign(real(xd)) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd)) + 2.0 * pisqu * log((-1.0i + wx) / wx) * T(1.0, 1.0 - xd / wx, 1.0 - 1.0i * xd) * T(p(1.0i * xd, 1.0 - xd / wx), 1.0 - xd / wx, (-1.0i + wx) / wx) + zeta3) + log(wx / (wx - xd)) * (power_of<2>(log(1.0i / wx)) * log((-1.0i + wx) / wx) + power_of<2>(log(-1.0i / wx)) * log((1.0i + wx) / wx) + (log(1.0 + 1.0i * xd) * power_of<2>(log((-1.0i) * xd))) / 2.0 + (log(1.0 - 1.0i * xd) * power_of<2>(log(1.0i * xd))) / 2.0 - (pisqu * log(1.0 - xd / wx)) / 3.0 + power_of<2>(log(xd / wx)) * log(1.0 - xd / wx)
                + (1.0i / 2.0) * M_PI * H2((-1.0i) * wx, wx * xdinv) * power_of<2>(log((-1.0i + xd) / (-wx + xd))) * my_sign(-real(wx)) + (1.0i / 2.0) * M_PI * H2(1.0i * wx, wx * xdinv) * power_of<2>(log(-((1.0i + xd) / (wx - xd)))) * my_sign(real(wx)) + (1.0i / 2.0) * M_PI * H2(-1.0i / xd, wx * xdinv) * power_of<2>(log((1.0i * (1.0i + wx) * xd) / (wx - xd))) * my_sign(-real(xdinv)) + (1.0i / 2.0) * M_PI * H2(1.0i / xd, wx * xdinv) * power_of<2>(log(-((xd + 1.0i * wx * xd) / (wx - xd)))) * my_sign(real(xdinv)) + 2.0 * zeta3)
                + log(((-1.0i) * (wx - xd)) / (wx * (-1.0i + xd))) * ((-1.0 / 12.0) * (pisqu * lnm2) - power_of<3>(lnm2) / 12.0 - (pisqu * log(-1.0 + 1.0i * wx)) / 12.0 - power_of<3>(log(-1.0 + 1.0i * wx)) / 12.0 + (pisqu * log(1.0 + 1.0i * wx)) / 3.0 + (power_of<2>(lnm2) * log(1.0 + 1.0i * wx)) / 4.0 + (power_of<2>(log(-1.0 + 1.0i * wx)) * log(1.0 + 1.0i * wx)) / 4.0 + (log(1.0 - 1.0i * wx) * power_of<2>(log(1.0 + 1.0i * wx))) / 4.0 + power_of<3>(log(1.0 + 1.0i * wx)) / 6.0 + (pisqu * log((-1.0i + wx) / wx)) / 3.0 + (lnhalf * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + (ln2 * power_of<2>(log((-1.0i + wx) / wx))) / 2.0 + power_of<3>(log((-1.0i + wx) / wx)) / 3.0 + (power_of<2>(log((-1.0i + wx) / wx)) * log(1.0i / (1.0i + wx))) / 2.0 - (power_of<2>(log(1.0 + 1.0i * wx)) * log((1.0i + wx) / wx)) / 4.0
                + 3.0 * zeta3) + log((1.0i * (wx - xd)) / (wx * (1.0i + xd))) * ((-1.0 / 12.0) * (pisqu * lnm2) - power_of<3>(lnm2) / 12.0 - (pisqu * log(-1.0 - 1.0i * wx)) / 12.0 - power_of<3>(log(-1.0 - 1.0i * wx)) / 12.0 + (pisqu * log(1.0 - 1.0i * wx)) / 3.0 + (power_of<2>(lnm2) * log(1.0 - 1.0i * wx)) / 4.0 + (power_of<2>(log(-1.0 - 1.0i * wx)) * log(1.0 - 1.0i * wx)) / 4.0 + power_of<3>(log(1.0 - 1.0i * wx)) / 6.0 + (power_of<2>(log(1.0 - 1.0i * wx)) * log(1.0 + 1.0i * wx)) / 4.0 - (power_of<2>(log(1.0 - 1.0i * wx)) * log((-1.0i + wx) / wx)) / 4.0 + (pisqu * log((1.0i + wx) / wx)) / 3.0 + (lnhalf * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (ln2 * power_of<2>(log((1.0i + wx) / wx))) / 2.0 + (log(-1.0i / (-1.0i + wx)) * power_of<2>(log((1.0i + wx) / wx))) / 2.0
                + power_of<3>(log((1.0i + wx) / wx)) / 3.0 + 3.0 * zeta3);

            return 4.0 * result;
        }
    }
}
