/* vim: set sw=4 sts=4 et foldmethod=syntax : */

/*
 * Copyright (c) 2022 Viktor Kuschke
 *
 * This file is part of the EOS project. EOS is free software;
 * you can redistribute it and/or modify it under the terms of the GNU General
 * Public License version 2, as published by the Free Software Foundation.
 *
 * EOS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <eos/maths/power-of.hh>
#include <eos/maths/polylog.hh>
#include <eos/maths/multiplepolylog-li22.hh>

#include <eos/rare-b-decays/charm-loops-impl.hh>

#include <eos/utils/exception.hh>
#include <eos/utils/log.hh>
#include <eos/utils/stringify.hh>

#include <cmath>
#include <complex>

namespace eos
{
    using std::complex;
    using std::log;

    namespace agv_2019a
    {
        // the sums of GPLs that contain GPLs of weight 4 with one weight being w4, w5 or w7 can be expressed by the following function
        complex<double> weight4_w4_w5_w7(const CharmLoopsParameters & clp, const complex<double> & w)
        {
            const complex<double> yd = clp.yd;
            const complex<double> winv = 1.0 / w;

            // this term multiplies an ill-defined sign(0.0)
            // the terms multiply a function form T(1, x, 1 + y) * T(p(-y, x), 1 + y, 2.0) which is conjectured to be zero for any values of x and y
            const complex<double> sign0term = + my_sign(0.0) * (-16.0 * pisqu * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) * T(p(-w, 1.0 - yd), 1.0 - yd, 2.0) - 16.0 * pisqu * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) * T(p(-w, 1.0 + yd), 1.0 + yd, 2.0));

            if(sign0term != 0.0)
            {
                throw InternalError("Ill-defined Sign(0.0)");
            }

            const complex<double> ydinv = 1.0 / yd;
            const complex<double> yd2 = power_of<2>(yd);

            const double imydinv = imag(ydinv);

            // often apperaing logs of yd

            const complex<double> ln1pyd = log(1.0 + yd);
            const complex<double> ln1myd = log(1.0 - yd);

            const complex<double> result = (-2.0 * power_of<4>(M_PI)) / 9.0 - 6.0 * power_of<2>(dilog(1.0 / (1.0 + w))) + 2.0 * power_of<2>(dilog(1.0 + w)) + dilog((2.0 * w) / (-1.0 + w)) * (dilog((w - yd) / (-1.0 + w)) + dilog((w + yd) / (-1.0 + w))) + 16.0 * quadlog(0.5) - 24.0 * quadlog(1.0 + winv) + 8.0 * quadlog(1.0 / (1.0 - w)) + 16.0 * quadlog(1.0 - w) - 24.0 * quadlog(-winv) + 16.0 * quadlog(winv) + 16.0 * quadlog((-1.0 + w) / w) + 16.0 * quadlog(w) + 8.0 * quadlog(w / (-1.0 + w)) + 28.0 * quadlog(1.0 / (1.0 + w)) + 12.0 * quadlog(1.0 + w) - 8.0 * quadlog((1.0 - yd) / 2.0) - 16.0 * quadlog(1.0 - yd) + 4.0 * quadlog((w - yd) / (-1.0 + w)) + 4.0 * quadlog((-1.0 + yd) / (-1.0 + w))
                - 28.0 * quadlog(-yd) - 28.0 * quadlog(yd) + 4.0 * quadlog(-(yd / w)) + 4.0 * quadlog(yd / w) + 4.0 * quadlog(-(yd / (w - yd))) + 4.0 * quadlog(((-1.0 + w) * yd) / (w - yd)) - 12.0 * quadlog(yd / (-1.0 + yd)) - 8.0 * quadlog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) - 4.0 * quadlog(((1.0 + w) * yd) / (w * (-1.0 + yd))) - 12.0 * quadlog(yd / (1.0 + yd)) - 8.0 * quadlog(((-1.0 + w) * yd) / (w * (1.0 + yd))) - 8.0 * quadlog((1.0 + yd) / 2.0) - 16.0 * quadlog(1.0 + yd) + 4.0 * quadlog((1.0 + yd) / (1.0 - w)) + 4.0 * quadlog(yd / (w + yd)) + 4.0 * quadlog((w + yd) / (-1.0 + w)) + 8.0 * quadlog((w + yd) / w) + 8.0 * quadlog(1.0 - yd / w)
                + 4.0 * quadlog((yd - w * yd) / (w + yd)) - 4.0 * quadlog((yd + w * yd) / (w + w * yd)) - 2.0 * li22(-1.0, -yd) - 2.0 * li22(-1.0, yd) - 4.0 * li22(0.5, -2.0 / (-1.0 + w)) - 2.0 * li22(0.5, (-1.0 + w) / w) - 14.0 * li22(0.5, 2.0 / (1.0 + w)) + 10.0 * li22(0.5, 1.0 + w) + li22(0.5, (2.0 * w) / (w - yd)) - li22(0.5, (-2.0 * yd) / (w - yd)) + 4.0 * li22(0.5, (2.0 * yd) / (-1.0 + yd)) + 4.0 * li22(0.5, (2.0 * yd) / (1.0 + yd)) + li22(0.5, (2.0 * w) / (w + yd)) - li22(0.5, (2.0 * yd) / (w + yd)) + 4.0 * li22(1.0 / (1.0 - w), 2.0) + 4.0 * li22(1.0 / (1.0 - w), (1.0 - w) / 2.0) + 4.0 * li22(1.0 / (1.0 - w), 1.0 + w)
                + 2.0 * li22(1.0 / (1.0 - w), 1.0 - yd) - li22(1.0 / (1.0 - w), -(((-1.0 + w) * yd) / (-1.0 + yd))) + 2.0 * li22(1.0 / (1.0 - w), 1.0 + yd) - li22(1.0 / (1.0 - w), (yd - w * yd) / (1.0 + yd)) + li22((1.0 - w) / 2.0, (-2.0 * yd) / (w - yd)) + li22((1.0 - w) / 2.0, (2.0 * yd) / (w + yd)) - 4.0 * li22(-2.0 / (-1.0 + w), 0.5) + 2.0 * li22(-2.0 / (-1.0 + w), (1.0 - yd) / 2.0) + li22(-2.0 / (-1.0 + w), -(((-1.0 + w) * yd) / (-1.0 + yd))) + 2.0 * li22(-2.0 / (-1.0 + w), (1.0 + yd) / 2.0) + li22(-2.0 / (-1.0 + w), (yd - w * yd) / (1.0 + yd)) - 2.0 * li22(-winv, -yd) - 2.0 * li22(-winv, yd) + 2.0 * li22(winv, -yd)
                + 2.0 * li22(winv, yd) + 2.0 * li22((-1.0 + w) / (2.0 * w), w / (-1.0 + w)) - li22((-1.0 + w) / (2.0 * w), -((w * (-1.0 + yd)) / (-1.0 + w))) - 2.0 * li22((-1.0 + w) / (2.0 * w), (2.0 * yd) / (-1.0 + yd)) - 2.0 * li22((-1.0 + w) / (2.0 * w), (2.0 * yd) / (1.0 + yd)) - li22((-1.0 + w) / (2.0 * w), (w * (1.0 + yd)) / (-1.0 + w)) + 2.0 * li22(w, -(yd / w)) + 2.0 * li22(w, yd / w) - 2.0 * li22(w / (-1.0 + w), 2.0) - 2.0 * li22(w / (-1.0 + w), 1.0 + winv) + 2.0 * li22(w / (-1.0 + w), (-1.0 + w) / (1.0 + w)) + li22(w / (-1.0 + w), (1.0 - w) / (w * (-1.0 + yd))) + li22(w / (-1.0 + w), (-1.0 + w) / (w * (1.0 + yd)))
                + 2.0 * li22(w / (-1.0 + w), (w + yd) / w) + 2.0 * li22(w / (-1.0 + w), 1.0 - yd / w) + 2.0 * li22((2.0 * w) / (-1.0 + w), 0.5) - li22((2.0 * w) / (-1.0 + w), (w - yd) / (2.0 * w)) - li22((2.0 * w) / (-1.0 + w), (w + yd) / (2.0 * w)) + 12.0 * li22(1.0 / (1.0 + w), 2.0) - 10.0 * li22(1.0 / (1.0 + w), (1.0 + w) / 2.0) - 2.0 * li22(1.0 / (1.0 + w), (1.0 + w) / (1.0 - yd)) + 2.0 * li22(1.0 / (1.0 + w), 1.0 - yd) - 2.0 * li22(1.0 / (1.0 + w), (1.0 + w) / (1.0 + yd)) + 2.0 * li22(1.0 / (1.0 + w), 1.0 + yd) - li22(1.0 / (1.0 + w), ((1.0 + w) * yd) / (-w + yd)) - li22(1.0 / (1.0 + w), ((1.0 + w) * yd) / (w + yd))
                - 12.0 * li22(2.0 / (1.0 + w), 0.5) + 6.0 * li22(2.0 / (1.0 + w), 0.5 - yd / 2.0) + 6.0 * li22(2.0 / (1.0 + w), (1.0 + yd) / 2.0) + li22((1.0 - w) / (1.0 + w), ((1.0 + w) * yd) / (-w + yd)) + li22((1.0 - w) / (1.0 + w), ((1.0 + w) * yd) / (w + yd)) - 2.0 * li22((-1.0 + w) / (1.0 + w), ((1.0 + w) * yd) / (w * (-1.0 + yd))) - 2.0 * li22((-1.0 + w) / (1.0 + w), (yd + w * yd) / (w + w * yd)) - 2.0 * li22(w / (1.0 + w), (1.0 + w) / (-1.0 + w)) + 3.0 * li22(w / (1.0 + w), ((1.0 + w) * yd) / (w * (-1.0 + yd))) + 3.0 * li22(w / (1.0 + w), (yd + w * yd) / (w + w * yd))
                - li22((2.0 * w) / (1.0 + w), ((1.0 + w) * yd) / (w * (-1.0 + yd))) - li22((2.0 * w) / (1.0 + w), (yd + w * yd) / (w + w * yd)) - 10.0 * li22((1.0 + w) / 2.0, 1.0 / (1.0 + w)) + 5.0 * li22((1.0 + w) / 2.0, (1.0 - yd) / (1.0 + w)) + 5.0 * li22((1.0 + w) / 2.0, (1.0 + yd) / (1.0 + w)) - 4.0 * li22(1.0 + w, (1.0 - yd) / (1.0 + w)) - 4.0 * li22(1.0 + w, (1.0 + yd) / (1.0 + w)) - 4.0 * li22((1.0 + w) / (1.0 - w), 1.0 / (1.0 + w)) + 2.0 * li22((1.0 + w) / (1.0 - w), (1.0 - yd) / (1.0 + w)) + 2.0 * li22((1.0 + w) / (1.0 - w), (1.0 + yd) / (1.0 + w)) + 2.0 * li22((1.0 + w) / (-1.0 + w), w / (1.0 + w))
                - li22((1.0 + w) / (-1.0 + w), (w - yd) / (1.0 + w)) - li22((1.0 + w) / (-1.0 + w), (w + yd) / (1.0 + w)) - 2.0 * li22((1.0 + w) / (2.0 * w), (2.0 * yd) / (-1.0 + yd)) - 2.0 * li22((1.0 + w) / (2.0 * w), (2.0 * yd) / (1.0 + yd)) + 2.0 * li22(1.0 / (1.0 - yd), (1.0 - yd) / (1.0 + w)) - li22(1.0 / (1.0 - yd), -((w * (-1.0 + yd)) / (-1.0 + w))) + 2.0 * li22((1.0 - yd) / 2.0, -2.0 / (-1.0 + w)) - 5.0 * li22((1.0 - yd) / 2.0, (1.0 + w) / (1.0 - yd)) + li22((1.0 - yd) / 2.0, (1.0 - w) / (w * (-1.0 + yd))) + 2.0 * li22(1.0 - yd, 1.0 / (1.0 + w)) + 4.0 * li22(1.0 - yd, (1.0 + w) / (1.0 - yd)) + 5.0 * li22((1.0 - yd) / (1.0 + w), (1.0 + w) / 2.0)
                - 2.0 * li22((1.0 - yd) / (1.0 + w), 1.0 + w) - 2.0 * li22((1.0 - yd) / (1.0 + w), 1.0 / (1.0 - yd)) - 6.0 * li22((1.0 - yd) / (1.0 + w), -2.0 / (-1.0 + yd)) + 2.0 * li22((1.0 - yd) / (1.0 + w), (1.0 + w) / (1.0 + yd)) - li22(w / (w - yd), (w - yd) / (2.0 * w)) - li22((w - yd) / (-1.0 + w), (-1.0 + w) / (1.0 + w)) + 2.0 * li22((w - yd) / (-1.0 + w), w / (w - yd)) + li22((w - yd) / (-1.0 + w), (2.0 * w) / (w - yd)) + li22((w - yd) / (-1.0 + w), (1.0 + w) / (w - yd)) - li22((w - yd) / (-1.0 + w), (-1.0 + w) / (w * (1.0 + yd))) + li22((w - yd) / (1.0 + w), (1.0 + w) / (-1.0 + w))
                + 7.0 * li22(0.5 - yd / 2.0, 2.0 / (1.0 + w)) - li22(0.5 - yd / 2.0, (2.0 * w) / (w + yd)) - 2.0 * li22((-1.0 + yd) / (-1.0 + w), (1.0 - w) / 2.0) + 2.0 * li22((-1.0 + yd) / (-1.0 + w), 1.0 / (1.0 - yd)) - 2.0 * li22((-1.0 + yd) / (-1.0 + w), (1.0 + w) / (1.0 - yd)) - 2.0 * li22((-1.0 + yd) / (-1.0 + w), -2.0 / (-1.0 + yd)) + 2.0 * li22(-yd, -1.0) - 4.0 * li22(-yd, -winv) + 2.0 * li22(yd, -1.0) - 4.0 * li22(yd, -winv) - 4.0 * li22(-(yd / w), -w) + 6.0 * li22(-(yd / w), w) - 6.0 * li22(-(yd / w), -ydinv) - 2.0 * li22(-(yd / w), ydinv) - 4.0 * li22(yd / w, -w) + 6.0 * li22(yd / w, w)
                - 2.0 * li22(yd / w, -ydinv) - 6.0 * li22(yd / w, ydinv) + 2.0 * li22(-(yd / (w - yd)), 1.0 - w) - li22(-(yd / (w - yd)), 1.0 + w) - li22(-(yd / (w - yd)), 1.0 + ydinv) + li22(-(yd / (w - yd)), (-w + yd) / (2.0 * yd)) + li22(-(yd / (w - yd)), -((w - yd) / (yd + w * yd))) + 2.0 * li22(((-1.0 + w) * yd) / (w - yd), 1.0 / (1.0 - w)) + li22(((-1.0 + w) * yd) / (w - yd), (1.0 + w) / (1.0 - w)) - li22(((-1.0 + w) * yd) / (w - yd), (-w + yd) / (2.0 * yd)) + li22(((-1.0 + w) * yd) / (w - yd), (1.0 + yd) / (yd - w * yd))
                - li22(((-1.0 + w) * yd) / (w - yd), -((w - yd) / (yd + w * yd))) - 4.0 * li22(yd / (-1.0 + yd), 2.0) - li22(yd / (-1.0 + yd), 1.0 + winv) - 4.0 * li22(yd / (-1.0 + yd), (-1.0 + w) / w) + 2.0 * li22(yd / (-1.0 + yd), 1.0 + ydinv) + li22(yd / (-1.0 + yd), (1.0 - yd) / ((-1.0 + w) * yd)) - 4.0 * li22(yd / (-1.0 + yd), (-1.0 + yd) / (2.0 * yd)) - 3.0 * li22(yd / (-1.0 + yd), (w * (-1.0 + yd)) / ((1.0 + w) * yd)) - li22(yd / (-1.0 + yd), (w + yd) / yd) + 4.0 * li22((2.0 * yd) / (-1.0 + yd), 0.5) - 2.0 * li22((2.0 * yd) / (-1.0 + yd), (-1.0 + w) / (2.0 * w)) - 3.0 * li22((2.0 * yd) / (-1.0 + yd), (1.0 + w) / (2.0 * w))
                - li22((2.0 * yd) / (-1.0 + yd), (1.0 - yd) / ((-1.0 + w) * yd)) + li22((2.0 * yd) / (-1.0 + yd), (w * (-1.0 + yd)) / ((1.0 + w) * yd)) + li22((2.0 * yd) / (-1.0 + yd), (w + yd) / (2.0 * yd)) - 4.0 * li22(((-1.0 + w) * yd) / (w * (-1.0 + yd)), w / (-1.0 + w)) + 2.0 * li22(((-1.0 + w) * yd) / (w * (-1.0 + yd)), (2.0 * w) / (-1.0 + w)) + 2.0 * li22(((-1.0 + w) * yd) / (w * (-1.0 + yd)), (-1.0 + yd) / (2.0 * yd)) + 2.0 * li22(((-1.0 + w) * yd) / (w * (-1.0 + yd)), (w * (-1.0 + yd)) / ((1.0 + w) * yd)) - 3.0 * li22(((1.0 + w) * yd) / (w * (-1.0 + yd)), w / (1.0 + w)) + 3.0 * li22(((1.0 + w) * yd) / (w * (-1.0 + yd)), (2.0 * w) / (1.0 + w))
                + 2.0 * li22(((1.0 + w) * yd) / (w * (-1.0 + yd)), (-1.0 + yd) / (2.0 * yd)) - 2.0 * li22(((1.0 + w) * yd) / (w * (-1.0 + yd)), (w + w * yd) / (yd + w * yd)) - li22(1.0 / (1.0 + yd), (w * (1.0 + yd)) / (-1.0 + w)) + 2.0 * li22(1.0 / (1.0 + yd), (1.0 + yd) / (1.0 + w)) - 2.0 * li22((1.0 - yd) / (1.0 + yd), (1.0 + yd) / (1.0 + w)) - 2.0 * li22((-1.0 + yd) / (1.0 + yd), yd / (-1.0 + yd)) + 2.0 * li22((-1.0 + yd) / (1.0 + yd), ((1.0 + w) * yd) / (w * (-1.0 + yd))) - 4.0 * li22(yd / (1.0 + yd), 2.0) - li22(yd / (1.0 + yd), 1.0 + winv) - 4.0 * li22(yd / (1.0 + yd), (-1.0 + w) / w) - li22(yd / (1.0 + yd), 1.0 - w / yd)
                + 2.0 * li22(yd / (1.0 + yd), (-1.0 + yd) / yd) - 4.0 * li22(yd / (1.0 + yd), (1.0 + yd) / (2.0 * yd)) + li22(yd / (1.0 + yd), (1.0 + yd) / (yd - w * yd)) - 3.0 * li22(yd / (1.0 + yd), (w + w * yd) / (yd + w * yd)) + 4.0 * li22((2.0 * yd) / (1.0 + yd), 0.5) - 2.0 * li22((2.0 * yd) / (1.0 + yd), (-1.0 + w) / (2.0 * w)) - 3.0 * li22((2.0 * yd) / (1.0 + yd), (1.0 + w) / (2.0 * w)) + li22((2.0 * yd) / (1.0 + yd), (-w + yd) / (2.0 * yd)) - li22((2.0 * yd) / (1.0 + yd), (1.0 + yd) / (yd - w * yd)) + li22((2.0 * yd) / (1.0 + yd), (w + w * yd) / (yd + w * yd)) - 4.0 * li22(((-1.0 + w) * yd) / (w * (1.0 + yd)), w / (-1.0 + w))
                + 2.0 * li22(((-1.0 + w) * yd) / (w * (1.0 + yd)), (2.0 * w) / (-1.0 + w)) + 2.0 * li22(((-1.0 + w) * yd) / (w * (1.0 + yd)), (1.0 + yd) / (2.0 * yd)) + 2.0 * li22(((-1.0 + w) * yd) / (w * (1.0 + yd)), (w + w * yd) / (yd + w * yd)) + 2.0 * li22((1.0 + yd) / 2.0, -2.0 / (-1.0 + w)) + 7.0 * li22((1.0 + yd) / 2.0, 2.0 / (1.0 + w)) - li22((1.0 + yd) / 2.0, (2.0 * w) / (w - yd)) + li22((1.0 + yd) / 2.0, (-1.0 + w) / (w * (1.0 + yd))) - 5.0 * li22((1.0 + yd) / 2.0, (1.0 + w) / (1.0 + yd)) + 2.0 * li22(1.0 + yd, 1.0 / (1.0 + w)) + 4.0 * li22(1.0 + yd, (1.0 + w) / (1.0 + yd)) - 2.0 * li22((1.0 + yd) / (1.0 - w), 0.5 - w / 2.0)
                + 2.0 * li22((1.0 + yd) / (1.0 - w), 1.0 / (1.0 + yd)) - 2.0 * li22((1.0 + yd) / (1.0 - w), 2.0 / (1.0 + yd)) - 2.0 * li22((1.0 + yd) / (1.0 - w), (1.0 + w) / (1.0 + yd)) + 5.0 * li22((1.0 + yd) / (1.0 + w), (1.0 + w) / 2.0) - 2.0 * li22((1.0 + yd) / (1.0 + w), 1.0 + w) + 2.0 * li22((1.0 + yd) / (1.0 + w), (1.0 + w) / (1.0 - yd)) - 2.0 * li22((1.0 + yd) / (1.0 + w), 1.0 / (1.0 + yd)) - 6.0 * li22((1.0 + yd) / (1.0 + w), 2.0 / (1.0 + yd)) - 2.0 * li22((1.0 + yd) / (1.0 - yd), (1.0 - yd) / (1.0 + w)) + li22(-((1.0 + yd) / (w - yd)), yd / (1.0 + yd)) - li22(-((1.0 + yd) / (w - yd)), (yd - w * yd) / (1.0 + yd))
                + li22((w * (1.0 + yd)) / (w - yd), (w - yd) / (2.0 * w)) - 2.0 * li22((1.0 + yd) / (-1.0 + yd), yd / (1.0 + yd)) + 2.0 * li22((1.0 + yd) / (-1.0 + yd), (yd + w * yd) / (w + w * yd)) + li22(((1.0 + w) * yd) / (-w + yd), 1.0 / (1.0 + w)) - li22(((1.0 + w) * yd) / (-w + yd), (1.0 - w) / (1.0 + w)) - li22((-w + yd) / (1.0 + yd), (-2.0 * yd) / (w - yd)) + li22((-w + yd) / (1.0 + yd), -(yd / (w - yd))) - li22(w / (w + yd), (w + yd) / (2.0 * w)) + li22((-1.0 + yd) / (w + yd), yd / (-1.0 + yd)) - li22((-1.0 + yd) / (w + yd), -(((-1.0 + w) * yd) / (-1.0 + yd)))
                + 2.0 * li22(yd / (w + yd), 1.0 - w) - li22(yd / (w + yd), 1.0 + w) - li22(yd / (w + yd), (-1.0 + yd) / yd) + li22(yd / (w + yd), (w + yd) / (2.0 * yd)) + li22(yd / (w + yd), (w + yd) / (yd + w * yd)) + li22(((1.0 + w) * yd) / (w + yd), 1.0 / (1.0 + w)) - li22(((1.0 + w) * yd) / (w + yd), (1.0 - w) / (1.0 + w)) - li22((w + yd) / (-1.0 + w), (-1.0 + w) / (1.0 + w)) - li22((w + yd) / (-1.0 + w), (1.0 - w) / (w * (-1.0 + yd))) + 2.0 * li22((w + yd) / (-1.0 + w), w / (w + yd)) + li22((w + yd) / (-1.0 + w), (2.0 * w) / (w + yd))
                + li22((w + yd) / (-1.0 + w), (1.0 + w) / (w + yd)) + li22((w + yd) / (1.0 + w), (1.0 + w) / (-1.0 + w)) + li22((w + yd) / (-1.0 + yd), yd / (w + yd)) - li22((w + yd) / (-1.0 + yd), (2.0 * yd) / (w + yd)) + li22((w + yd) / (w - w * yd), -((w * (-1.0 + yd)) / (-1.0 + w))) + li22((w - w * yd) / (w + yd), (w + yd) / (2.0 * w)) + 2.0 * li22((yd - w * yd) / (w + yd), 1.0 / (1.0 - w)) + li22((yd - w * yd) / (w + yd), (1.0 + w) / (1.0 - w)) + li22((yd - w * yd) / (w + yd), (1.0 - yd) / ((-1.0 + w) * yd)) - li22((yd - w * yd) / (w + yd), (w + yd) / (2.0 * yd))
                - li22((yd - w * yd) / (w + yd), (w + yd) / (yd + w * yd)) + li22((w - yd) / (w + w * yd), (w * (1.0 + yd)) / (-1.0 + w)) - 3.0 * li22((yd + w * yd) / (w + w * yd), w / (1.0 + w)) + 3.0 * li22((yd + w * yd) / (w + w * yd), (2.0 * w) / (1.0 + w)) - 2.0 * li22((yd + w * yd) / (w + w * yd), (w * (-1.0 + yd)) / ((1.0 + w) * yd)) + 2.0 * li22((yd + w * yd) / (w + w * yd), (1.0 + yd) / (2.0 * yd)) + (2.0 * pisqu * lnm1 * log(1.0 + winv)) / 3.0 + (2.0 * power_of<3>(lnm1) * log(1.0 + winv)) / 3.0 - 2.0 * lnm1 * ln2squ * log(1.0 + winv) - (4.0 * pisqu * power_of<2>(log(1.0 / (1.0 - w)))) / 3.0
                + (4.0 * power_of<4>(log(1.0 / (1.0 - w)))) / 3.0 - (2.0 * pisqu * lnm1 * log(1.0 - w)) / 3.0 - (2.0 * power_of<3>(lnm1) * log(1.0 - w)) / 3.0 + 2.0 * lnm1 * ln2squ * log(1.0 - w) - (4.0 * pisqu * log(1.0 / (1.0 - w)) * log(1.0 - w)) / 3.0 - (4.0 * power_of<3>(log(1.0 / (1.0 - w))) * log(1.0 - w)) / 3.0 + (2.0 * pisqu * ln2 * log(winv)) / 3.0 - 2.0 * ln2 * power_of<2>(log(1.0 - w)) * log(winv) + (2.0 * ln2 * power_of<3>(log(winv))) / 3.0 + dilog((-1.0 + w) / (w - yd)) * (4.0 * ln2 * log((-1.0 + w) / w) + 4.0 * log(1.0 + winv) * log((-1.0 + w) / w))
                + dilog((-1.0 + w) / (w + yd)) * (4.0 * ln2 * log((-1.0 + w) / w) + 4.0 * log(1.0 + winv) * log((-1.0 + w) / w)) - (4.0 * pisqu * log((-1.0 + w) / w) * log(-w)) / 3.0 + 4.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / w) * log(-w) + 2.0 * pisqu * power_of<2>(log(-w)) + 4.0 * log(-1.0 - w) * power_of<3>(log(-w)) - (4.0 * log((-1.0 + w) / w) * power_of<3>(log(-w))) / 3.0 - 2.0 * power_of<4>(log(-w)) - (4.0 * pisqu * ln2 * log(w)) / 3.0 - (4.0 * pisqu * log(1.0 + winv) * log(w)) / 3.0 + 4.0 * ln2 * power_of<2>(log((-1.0 + w) / w)) * log(w) + 4.0 * log(1.0 + winv) * power_of<2>(log((-1.0 + w) / w)) * log(w)
                + 4.0 * log(1.0 / (1.0 - w)) * log(1.0 - w) * power_of<2>(log(w)) - (4.0 * ln2 * power_of<3>(log(w))) / 3.0 - (4.0 * log(1.0 + winv) * power_of<3>(log(w))) / 3.0 - (8.0 * power_of<3>(log(1.0 / (1.0 - w))) * log(w / (1.0 - w))) / 3.0 + (8.0 * pisqu * log((-1.0 + w) / w) * log(w / (-1.0 + w))) / 3.0 - 8.0 * power_of<2>(log(winv)) * log((-1.0 + w) / w) * log(w / (-1.0 + w)) - (4.0 * pisqu * power_of<2>(log(w / (-1.0 + w)))) / 3.0 - (8.0 * log(1.0 / (-1.0 + w)) * power_of<3>(log(w / (-1.0 + w)))) / 3.0 + (8.0 * log((-1.0 + w) / w) * power_of<3>(log(w / (-1.0 + w)))) / 3.0 + (4.0 * power_of<4>(log(w / (-1.0 + w)))) / 3.0 + (4.0 * pisqu * log(1.0 + winv) * log(w / (1.0 + w))) / 3.0
                - 4.0 * log(1.0 + winv) * power_of<2>(log(-winv)) * log(w / (1.0 + w)) + (4.0 * log(1.0 + winv) * power_of<3>(log(w / (1.0 + w)))) / 3.0 + (2.0 * pisqu * log(winv) * log(1.0 + w)) / 3.0 - 2.0 * power_of<2>(log(1.0 - w)) * log(winv) * log(1.0 + w) + (2.0 * power_of<3>(log(winv)) * log(1.0 + w)) / 3.0 + trilog(-(w / yd)) * (2.0 * ln2 + 2.0 * log(1.0 + w)) + trilog(w / yd) * (2.0 * ln2 + 2.0 * log(1.0 + w)) + dilog((-1.0 + w) / (-1.0 + yd)) * (-2.0 * ln2 * log(1.0 - w) - 2.0 * log(1.0 - w) * log(1.0 + w)) + dilog((1.0 - w) / (1.0 + yd)) * (-2.0 * ln2 * log(1.0 - w) - 2.0 * log(1.0 - w) * log(1.0 + w))
                - 2.0 * power_of<4>(log(1.0 / (1.0 - yd))) + trilog(ydinv) * (-4.0 * ln2 - 2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) - 4.0 * ln1myd) + trilog(yd / w) * (6.0 * ln2 + 4.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 4.0 * ln1myd) + 4.0 * trilog(((-1.0 + w) * (-1.0 + yd)) / ((1.0 + w) * (1.0 + yd))) * ln1myd + 8.0 * trilog(((1.0 + w) * (1.0 + yd)) / ((-1.0 + w) * (-1.0 + yd))) * ln1myd + 4.0 * trilog((-0.5) * (((-1.0 + w) * (-1.0 + yd)) / (w + yd))) * ln1myd + 4.0 * trilog(((1.0 + w) * (1.0 + yd)) / (2.0 * (w + yd))) * ln1myd
                + 8.0 * trilog((-2.0 * (w + yd)) / ((-1.0 + w) * (-1.0 + yd))) * ln1myd + 8.0 * trilog((2.0 * (w + yd)) / ((1.0 + w) * (1.0 + yd))) * ln1myd - 2.0 * dilog((w * (-1.0 + yd)) / ((1.0 + w) * yd)) * ln2 * ln1myd - 2.0 * dilog((1.0 + w) / (1.0 + yd)) * log(1.0 + winv) * ln1myd + dilog(w / yd) * (2.0 * ln2 + 2.0 * log(1.0 + w)) * ln1myd - 4.0 * dilog(((-1.0 + w) * (-1.0 + yd)) / ((1.0 + w) * (1.0 + yd))) * log((1.0 - yd) / 2.0) * ln1myd - 4.0 * dilog((-0.5) * (((-1.0 + w) * (-1.0 + yd)) / (w + yd))) * log((1.0 - yd) / 2.0) * ln1myd
                + trilog((w * (1.0 + yd)) / ((-1.0 + w) * yd)) * (2.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 2.0 * ln1myd) + trilog((w + yd) / (yd - w * yd)) * (-8.0 * log((-1.0 + w) / w) + 4.0 * ln1myd) + dilog((1.0 + w) / (w - yd)) * (4.0 * log(1.0 + winv) * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) * ln1myd) + (2.0 * power_of<4>(log(w / (w - yd)))) / 3.0 - (2.0 * pisqu * log(1.0 - w) * log((w - yd) / ((-1.0 + w) * w))) / 3.0 - (2.0 * log(1.0 - w) * power_of<3>(log((w - yd) / ((-1.0 + w) * w)))) / 3.0 + (4.0 * pisqu * log((-1.0 + w) / w) * log((w * (-1.0 + yd)) / (-1.0 + w))) / 3.0
                + (4.0 * log((-1.0 + w) / w) * power_of<3>(log((w * (-1.0 + yd)) / (-1.0 + w)))) / 3.0 + (2.0 * pisqu * log(1.0 + winv) * log((w * (-1.0 + yd)) / (1.0 + w))) / 3.0 + (2.0 * log(1.0 + winv) * power_of<3>(log((w * (-1.0 + yd)) / (1.0 + w)))) / 3.0 + (2.0 * log(1.0 - w) * power_of<3>(log((w - yd) / ((-1.0 + w) * yd)))) / 3.0 - (4.0 * log((-1.0 + w) / w) * power_of<3>(log((w * (-1.0 + yd)) / ((-1.0 + w) * yd)))) / 3.0 - (2.0 * log(1.0 + winv) * power_of<3>(log((w * (-1.0 + yd)) / ((1.0 + w) * yd)))) / 3.0 + ((-1.0 / 3.0) * (pisqu * log(1.0 + winv)) + (pisqu * log(1.0 - w)) / 3.0) * log(yd / (1.0 - yd)) + ((-1.0 / 3.0) * log(1.0 + winv) + log(1.0 - w) / 3.0) * power_of<3>(log(yd / (1.0 - yd)))
                + ((2.0 * pisqu * ln2) / 3.0 + (2.0 * pisqu * log(1.0 + winv)) / 3.0) * log(-((w * yd) / (w - yd))) + ((2.0 * ln2) / 3.0 + (2.0 * log(1.0 + winv)) / 3.0) * power_of<3>(log(-((w * yd) / (w - yd)))) - (2.0 * pisqu * log((-1.0 + w) / w) * log((w * yd) / (w - yd))) / 3.0 - (2.0 * log((-1.0 + w) / w) * power_of<3>(log((w * yd) / (w - yd)))) / 3.0 + ((-1.0 / 3.0) * (pisqu * ln2) - (pisqu * log(1.0 + w)) / 3.0) * log(yd / (w * (-1.0 + yd))) + ((-1.0 / 3.0) * ln2 - log(1.0 + w) / 3.0) * power_of<3>(log(yd / (w * (-1.0 + yd)))) - 2.0 * power_of<4>(log(1.0 / (1.0 + yd))) + ((-2.0 * pisqu * ln2) / 3.0 - pisqu * log(1.0 + winv)) * log(-(w / (1.0 + yd)))
                + ((-2.0 * ln2) / 3.0 - log(1.0 + winv)) * power_of<3>(log(-(w / (1.0 + yd)))) + trilog((-w + yd) / (1.0 + yd)) * (2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 6.0 * ln1myd - 2.0 * log(1.0 / (1.0 + yd)) + 2.0 * log((1.0 - yd) / (1.0 + yd))) + ((-1.0 / 3.0) * (pisqu * log(1.0 + winv)) + (pisqu * log(1.0 - w)) / 3.0) * log(-(yd / (1.0 + yd))) + ((-1.0 / 3.0) * log(1.0 + winv) + log(1.0 - w) / 3.0) * power_of<3>(log(-(yd / (1.0 + yd)))) + 2.0 * dilog(w / (w + yd)) * ln1myd * log((1.0 + yd) / 2.0)
                + dilog((1.0 - yd) / (1.0 + w)) * ((2.0 * pisqu) / 3.0 + 2.0 * dilog(-yd) - 4.0 * dilog(1.0 / (1.0 + yd)) + 2.0 * dilog((1.0 - yd) / (1.0 + yd)) + 2.0 * power_of<2>(ln1myd) + ln1myd * (-4.0 * lnhalf + 2.0 * ln2 + 4.0 * log((1.0 - yd) / 2.0) + 4.0 * log(yd / (1.0 + yd)) - 4.0 * ln1pyd)) + dilog((w - w * yd) / (w + yd)) * (4.0 * power_of<2>(ln1myd) + ln1myd * (2.0 * ln2 - 2.0 * ln1pyd)) + trilog((-1.0 + yd) / (-1.0 + w)) * (4.0 * lnhalf - 2.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) - 4.0 * log(w / (-1.0 + w)) + 4.0 * ln1myd - 18.0 * ln1pyd)
                + trilog(1.0 + w) * (-8.0 * log((-1.0 + w) / w) + 24.0 * log(-w) - 8.0 * ln1myd - 8.0 * ln1pyd) + trilog((yd + w * yd) / (w + w * yd)) * (-4.0 * lnhalf - 4.0 * log(1.0 + winv) - 2.0 * ln1myd + 6.0 * log(1.0 / (1.0 + yd)) - 2.0 * log((1.0 - yd) / (1.0 + yd)) - 8.0 * ln1pyd) + trilog((-w + yd) / (-1.0 + yd)) * (-4.0 * ln2 - 6.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) + 4.0 * ln1myd - 6.0 * ln1pyd) + trilog(-ydinv) * (-4.0 * ln2 - 2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) - 4.0 * ln1pyd)
                + trilog(-(yd / w)) * (6.0 * ln2 + 4.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 4.0 * ln1pyd) + trilog((w + yd) / (w + w * yd)) * (4.0 * ln2 + 6.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) - 2.0 * ln1myd - 4.0 * ln1pyd) + trilog(w / (w - yd)) * (8.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 2.0 * log((1.0 - yd) / 2.0) - 2.0 * ln1myd - 4.0 * ln1pyd)
                + trilog((w * (1.0 + yd)) / (w - yd)) * (-2.0 * ln2 - 4.0 * log(1.0 + winv) - 2.0 * log((1.0 - yd) / 2.0) + 2.0 * ln1myd - 4.0 * ln1pyd) + trilog((-1.0 + w) / (w - yd)) * (-4.0 * ln2 - 4.0 * log(1.0 + winv) + 4.0 * ln1myd - 4.0 * ln1pyd) + trilog(1.0 - yd / w) * (-4.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 - w)) - 4.0 * log(1.0 - w) - 8.0 * log((-1.0 + w) / w) + 4.0 * ln1myd + 4.0 * log((-1.0 + yd) / (-1.0 + w)) - 4.0 * ln1pyd)
                + trilog((1.0 + yd) / (1.0 + w)) * (4.0 * lnhalf - 2.0 * ln2 - 8.0 * log((1.0 - w) / 2.0) + 8.0 * log(-w) + 8.0 * log((-1.0 + w) / (1.0 + w)) + 4.0 * log(w / (1.0 + w)) - 6.0 * log((1.0 - yd) / 2.0) + 8.0 * ln1myd - 4.0 * log(-yd) - 4.0 * log(yd / (-1.0 + yd)) - 4.0 * ln1pyd) + trilog((w - yd) / (w - w * yd)) * (4.0 * ln2 + 6.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) - 4.0 * ln1myd - 2.0 * ln1pyd) + trilog(w / (w + yd)) * (8.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) - 4.0 * ln1myd + 2.0 * log((1.0 + yd) / 2.0) - 2.0 * ln1pyd)
                + power_of<3>(log(-(w / yd))) * ((4.0 * ln2) / 3.0 + log(1.0 + winv) + (2.0 * log((-1.0 + w) / w)) / 3.0 - ln1pyd) + power_of<3>(log(w / yd)) * ((4.0 * ln2) / 3.0 + log(1.0 + winv) + (2.0 * log((-1.0 + w) / w)) / 3.0 - ln1pyd) + power_of<3>(log(w / ((-1.0 + w) * yd))) * (log(1.0 + winv) / 3.0 + ln1pyd / 3.0) + power_of<3>(log(1.0 / (w - yd))) * (ln2 / 3.0 + (2.0 * ln1pyd) / 3.0) + power_of<3>(log(w / (-1.0 + yd))) * ((-2.0 * ln2) / 3.0 - log(1.0 + winv) + (2.0 * ln1pyd) / 3.0) + 8.0 * trilog((-2.0 * (w - yd)) / ((1.0 + w) * (-1.0 + yd))) * ln1pyd
                + 4.0 * trilog((-0.5) * (((1.0 + w) * (-1.0 + yd)) / (w - yd))) * ln1pyd + 8.0 * trilog((2.0 * (w - yd)) / ((-1.0 + w) * (1.0 + yd))) * ln1pyd + 8.0 * trilog(((1.0 + w) * (-1.0 + yd)) / ((-1.0 + w) * (1.0 + yd))) * ln1pyd + 4.0 * trilog(((-1.0 + w) * (1.0 + yd)) / (2.0 * (w - yd))) * ln1pyd + 4.0 * trilog(((-1.0 + w) * (1.0 + yd)) / ((1.0 + w) * (-1.0 + yd))) * ln1pyd + 4.0 * trilog(yd / (-w + yd)) * ln1pyd - 2.0 * dilog((w + w * yd) / (yd + w * yd)) * ln2 * ln1pyd - 2.0 * dilog((1.0 + w) / (1.0 - yd)) * log(1.0 + winv) * ln1pyd
                + dilog(-(w / yd)) * (2.0 * ln2 + 2.0 * log(1.0 + w)) * ln1pyd - 8.0 * dilog((-2.0 * (w - yd)) / ((1.0 + w) * (-1.0 + yd))) * log((w - yd) / (1.0 + w)) * ln1pyd - 8.0 * dilog((2.0 * (w - yd)) / ((-1.0 + w) * (1.0 + yd))) * log((w - yd) / (1.0 + w)) * ln1pyd - 4.0 * dilog(yd / (-w + yd)) * log(-yd) * ln1pyd + ((-2.0 * pisqu) / 3.0 + 2.0 * power_of<2>(log((1.0 - yd) / 2.0)) - 2.0 * power_of<2>(log((-1.0 + yd) / (-1.0 + w)))) * log(2.0 / (1.0 + yd)) * ln1pyd - (2.0 * power_of<3>(log(2.0 / (1.0 + yd))) * ln1pyd) / 3.0 + (4.0 * power_of<3>(log((1.0 - w) / (1.0 + yd))) * ln1pyd) / 3.0
                - 4.0 * dilog(((-1.0 + w) * (1.0 + yd)) / (2.0 * (w - yd))) * log((1.0 + yd) / 2.0) * ln1pyd - 4.0 * dilog(((-1.0 + w) * (1.0 + yd)) / ((1.0 + w) * (-1.0 + yd))) * log((1.0 + yd) / 2.0) * ln1pyd + (2.0 * log((w - yd) / (1.0 + w)) - 2.0 * log((-2.0 * (w - yd)) / ((1.0 + w) * (-1.0 + yd))) - 2.0 * log((-0.5) * (((1.0 + w) * (-1.0 + yd)) / (w - yd)))) * power_of<2>(log((1.0 + yd) / 2.0)) * ln1pyd + trilog((w * (-1.0 + yd)) / ((-1.0 + w) * yd)) * (2.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 2.0 * ln1pyd)
                + trilog((w - w * yd) / (w + yd)) * (-2.0 * ln2 - 4.0 * log(1.0 + winv) - 4.0 * ln1myd - 2.0 * log((1.0 + yd) / 2.0) + 2.0 * ln1pyd) + trilog((w - yd) / ((-1.0 + w) * yd)) * (-8.0 * log((-1.0 + w) / w) + 4.0 * ln1pyd) + trilog((1.0 + yd) / (1.0 - w)) * (4.0 * lnhalf - 2.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) - 4.0 * log(w / (-1.0 + w)) - 18.0 * ln1myd + 4.0 * ln1pyd) + trilog((w + yd) / (1.0 + yd)) * (-4.0 * ln2 - 6.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) - 6.0 * ln1myd + 4.0 * ln1pyd)
                + trilog((-1.0 + w) / (w + yd)) * (-4.0 * ln2 - 4.0 * log(1.0 + winv) - 4.0 * ln1myd + 4.0 * ln1pyd) + trilog((w - yd) / (1.0 + w)) * (4.0 * ln2 + 4.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 2.0 * log((-1.0 + yd) / (-1.0 + w)) + 4.0 * ln1pyd) + trilog((w - yd) / (w + w * yd)) * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 6.0 * ln1myd - 2.0 * log((-1.0 + yd) / (-1.0 + w)) + 4.0 * ln1pyd)
                + trilog((1.0 - yd) / (1.0 + w)) * (4.0 * lnhalf - 2.0 * ln2 - 8.0 * log((1.0 - w) / 2.0) + 8.0 * log(-w) + 8.0 * log((-1.0 + w) / (1.0 + w)) + 4.0 * log(w / (1.0 + w)) - 4.0 * ln1myd - 4.0 * log(yd) - 4.0 * log(yd / (1.0 + yd)) - 6.0 * log((1.0 + yd) / 2.0) + 8.0 * ln1pyd) + log(w / ((-1.0 + w) * yd)) * ((pisqu * log(1.0 + winv)) / 3.0 + (pisqu * ln1pyd) / 3.0) + log(1.0 / (w - yd)) * ((pisqu * ln2) / 3.0 + (2.0 * pisqu * ln1pyd) / 3.0) + log(w / (-1.0 + yd)) * ((-2.0 * pisqu * ln2) / 3.0 - pisqu * log(1.0 + winv) + (2.0 * pisqu * ln1pyd) / 3.0)
                + dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) * ((2.0 * pisqu) / 3.0 - 2.0 * dilog((1.0 + yd) / (-1.0 + yd)) + 4.0 * lnhalf * log(1.0 + winv) + 2.0 * power_of<2>(log(1.0 + winv)) + 8.0 * ln1myd * log(yd) + 2.0 * log(1.0 + winv) * ln1pyd) + dilog((1.0 + w) / (w + yd)) * (4.0 * log(1.0 + winv) * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) * ln1pyd) + dilog(((1.0 + w) * yd) / (w + yd)) * (dilog((yd - w * yd) / (w + yd)) - 4.0 * log(1.0 + winv) * log((-1.0 + w) / w) + 4.0 * ln1myd * log(yd) + 2.0 * log(1.0 + w) * ln1pyd)
                + dilog(w / (w - yd)) * (-2.0 * dilog(yd) + 2.0 * dilog((1.0 + yd) / 2.0) + 2.0 * log((1.0 - yd) / 2.0) * ln1pyd) + dilog(((1.0 + w) * (-1.0 + yd)) / ((-1.0 + w) * (1.0 + yd))) * (-12.0 * log((1.0 - yd) / 2.0) * ln1pyd + 4.0 * log((-1.0 + yd) / (-1.0 + w)) * ln1pyd) + dilog((-0.5) * (((1.0 + w) * (-1.0 + yd)) / (w - yd))) * (-8.0 * log((1.0 - yd) / 2.0) * ln1pyd + 4.0 * log((-1.0 + yd) / (-1.0 + w)) * ln1pyd) + dilog(((1.0 + w) * yd) / (-w + yd)) * (-4.0 * log(1.0 + winv) * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) * ln1myd + 4.0 * log(-yd) * ln1pyd)
                + dilog((yd + w * yd) / (w + w * yd)) * ((2.0 * pisqu) / 3.0 + 4.0 * lnhalf * log(1.0 + winv) + 2.0 * power_of<2>(log(1.0 + winv)) + 2.0 * log(1.0 + winv) * ln1myd + 8.0 * log(-yd) * ln1pyd) + dilog(-2.0 / (-1.0 + w)) * (-2.0 * dilog((-1.0 + yd) / (-1.0 + w)) - 2.0 * dilog(-yd) - 2.0 * dilog(yd) - dilog((2.0 * yd) / (-1.0 + yd)) - dilog((2.0 * yd) / (1.0 + yd)) - 2.0 * dilog((1.0 + yd) / (1.0 - w)) - 8.0 * power_of<2>(ln1myd) - 8.0 * power_of<2>(ln1pyd))
                + dilog(yd / w) * (6.0 * dilog((1.0 + yd) / 2.0) - 4.0 * dilog((1.0 + yd) / (1.0 - yd)) - 2.0 * power_of<2>(log(1.0 + winv)) - 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * log(1.0 + winv) * log((-1.0 + w) / (2.0 * w)) - 4.0 * power_of<2>(log((-1.0 + w) / w)) - 4.0 * log((-1.0 + w) / w) * log(2.0 / (1.0 + w)) - 2.0 * ln2 * log(1.0 + w) - 4.0 * log((-1.0 + w) / w) * log((1.0 + w) / (2.0 * w)) + 2.0 * power_of<2>(ln1myd) + ln1myd * (-4.0 * log(1.0 + winv) + 2.0 * log(1.0 + w) + 12.0 * log((1.0 + yd) / 2.0) - 4.0 * ln1pyd) + 6.0 * log((1.0 - yd) / 2.0) * ln1pyd + (-8.0 * log(-yd) - 4.0 * log((2.0 * yd) / (-1.0 + yd))) * ln1pyd
                - 4.0 * power_of<2>(ln1pyd)) + dilog(-((1.0 + yd) / (w - yd))) * (-4.0 * log(1.0 + winv) * log(-winv) + (-2.0 * ln2 + 2.0 * ln1myd + 4.0 * log((1.0 + yd) / 2.0)) * ln1pyd - 4.0 * power_of<2>(ln1pyd)) + dilog(-(yd / w)) * (-4.0 * dilog((-1.0 + w) / (1.0 + w)) - 4.0 * dilog((1.0 + w) / (2.0 * w)) + 4.0 * dilog(1.0 / (1.0 + yd)) - 4.0 * dilog((1.0 - yd) / (1.0 + yd)) + 12.0 * dilog((1.0 + yd) / 2.0) - 2.0 * power_of<2>(log(1.0 + winv)) - 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * log(1.0 + winv) * log((-1.0 + w) / (2.0 * w)) - 4.0 * power_of<2>(log((-1.0 + w) / w)) - 4.0 * log((-1.0 + w) / w) * log(2.0 / (1.0 + w))
                - 2.0 * ln2 * log(1.0 + w) - 4.0 * log((-1.0 + w) / w) * log((1.0 + w) / (2.0 * w)) - 4.0 * power_of<2>(ln1myd) + ln1myd * (-8.0 * log(yd) - 4.0 * log((2.0 * yd) / (1.0 + yd)) + 6.0 * log((1.0 + yd) / 2.0) - 4.0 * ln1pyd) + (-4.0 * log(1.0 + winv) + 2.0 * log(1.0 + w) + 12.0 * log((1.0 - yd) / 2.0)) * ln1pyd + 2.0 * power_of<2>(ln1pyd)) + dilog((1.0 + yd) / (1.0 + w)) * ((2.0 * pisqu) / 3.0 + 2.0 * dilog((1.0 + yd) / (1.0 - yd)) + (-4.0 * lnhalf + 2.0 * ln2 - 4.0 * ln1myd + 4.0 * log(yd / (-1.0 + yd)) + 4.0 * log((1.0 + yd) / 2.0)) * ln1pyd + 2.0 * power_of<2>(ln1pyd))
                + dilog((w * (1.0 + yd)) / (w - yd)) * ((2.0 * ln2 - 2.0 * ln1myd) * ln1pyd + 4.0 * power_of<2>(ln1pyd)) + log((1.0 + w) / (w - yd)) * (-2.0 * log(1.0 + winv) * power_of<2>(log(-winv)) + 2.0 * power_of<2>(log((1.0 + yd) / 2.0)) * ln1pyd - ln2 * power_of<2>(ln1pyd) - 2.0 * power_of<3>(ln1pyd)) + dilog((-1.0 + yd) / (w + yd)) * (dilog((yd - w * yd) / (w + yd)) - 4.0 * log(1.0 + winv) * log(-winv) - 4.0 * power_of<2>(ln1myd) + ln1myd * (-2.0 * ln2 + 4.0 * log((1.0 - yd) / 2.0) + 2.0 * ln1pyd))
                + trilog((w + yd) / (1.0 + w)) * (4.0 * ln2 + 4.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) + 4.0 * ln1myd - 2.0 * log((1.0 + yd) / (1.0 - w))) + trilog((w + yd) / (w - w * yd)) * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) + 4.0 * ln1myd - 6.0 * ln1pyd - 2.0 * log((1.0 + yd) / (1.0 - w))) + dilog(((1.0 + w) * (1.0 + yd)) / ((-1.0 + w) * (-1.0 + yd))) * ln1myd * (-12.0 * log((1.0 + yd) / 2.0) + 4.0 * log((1.0 + yd) / (1.0 - w))) + dilog(((1.0 + w) * (1.0 + yd)) / (2.0 * (w + yd))) * ln1myd * (-8.0 * log((1.0 + yd) / 2.0) + 4.0 * log((1.0 + yd) / (1.0 - w)))
                + trilog((w + yd) / w) * (-4.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 - w)) - 4.0 * log(1.0 - w) - 8.0 * log((-1.0 + w) / w) - 4.0 * ln1myd + 4.0 * ln1pyd + 4.0 * log((1.0 + yd) / (1.0 - w))) + (4.0 * pisqu * log((-1.0 + w) / w) * log(-((w * (1.0 + yd)) / (-1.0 + w)))) / 3.0 + (4.0 * log((-1.0 + w) / w) * power_of<3>(log(-((w * (1.0 + yd)) / (-1.0 + w))))) / 3.0 + (2.0 * pisqu * log(1.0 + winv) * log(-((w * (1.0 + yd)) / (1.0 + w)))) / 3.0 + (2.0 * log(1.0 + winv) * power_of<3>(log(-((w * (1.0 + yd)) / (1.0 + w))))) / 3.0
                + trilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) * (-4.0 * lnhalf - 4.0 * log(1.0 + winv) + 6.0 * log(1.0 / (1.0 - yd)) - 8.0 * ln1myd - 2.0 * ln1pyd - 2.0 * log((1.0 + yd) / (1.0 - yd))) + trilog((w + yd) / (-1.0 + yd)) * (2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 / (1.0 - yd)) + 6.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - yd))) + trilog(1.0 / (1.0 - w)) * (-8.0 * lnhalf + 4.0 * log(1.0 + winv) + 16.0 * log((-1.0 + w) / w) - 8.0 * log(w / (-1.0 + w)) + 10.0 * ln1myd + 2.0 * log((1.0 - yd) / (1.0 + yd)) + 10.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - yd)))
                + dilog(1.0 / (1.0 - w)) * ((4.0 * pisqu) / 3.0 - 4.0 * li2half + 4.0 * dilog(-2.0 / (-1.0 + w)) + 4.0 * dilog((1.0 + w) / (1.0 - w)) - 4.0 * dilog(1.0 - yd) - 2.0 * dilog((-1.0 + yd) / (-1.0 + w)) + 6.0 * dilog(-yd) + 6.0 * dilog(yd) - dilog(yd / (-1.0 + yd)) + 2.0 * dilog((2.0 * yd) / (-1.0 + yd)) - dilog(yd / (1.0 + yd)) + 2.0 * dilog((2.0 * yd) / (1.0 + yd)) - 4.0 * dilog(1.0 + yd) - 2.0 * dilog((1.0 + yd) / (1.0 - w)) - 16.0 * log(winv) * log((-1.0 + w) / w) - 4.0 * lnhalf * ln1myd + 4.0 * power_of<2>(ln1myd) + 2.0 * ln2 * log((1.0 - yd) / (1.0 + yd)) - 4.0 * lnhalf * ln1pyd
                + 4.0 * power_of<2>(ln1pyd) + 2.0 * ln2 * log((1.0 + yd) / (1.0 - yd))) + 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / w) * log(-((1.0 + yd) / (w - yd))) - 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / w) * log((w * (1.0 + yd)) / (w - yd)) - (4.0 * log((-1.0 + w) / w) * power_of<3>(log((w * (1.0 + yd)) / ((-1.0 + w) * yd)))) / 3.0 + ((pisqu * ln2) / 3.0 + (pisqu * log(1.0 + w)) / 3.0) * log(1.0 / (-w + yd)) + (ln2 / 3.0 + log(1.0 + w) / 3.0) * power_of<3>(log(1.0 / (-w + yd))) + (2.0 * ln2 * power_of<2>(log((-1.0 + w) / w)) + 2.0 * log(1.0 + winv) * power_of<2>(log((-1.0 + w) / w))) * log((-1.0 + yd) / (-w + yd))
                - (2.0 * pisqu * log(1.0 + winv) * log((w * yd) / (-w + yd))) / 3.0 - (2.0 * log(1.0 + winv) * power_of<3>(log((w * yd) / (-w + yd)))) / 3.0 + (-(ln2 * power_of<2>(log(1.0 - w))) - power_of<2>(log(1.0 - w)) * log(1.0 + w)) * log((-w + yd) / (-1.0 + yd)) + ((pisqu * ln2) / 3.0 + (pisqu * log(1.0 + w)) / 3.0) * log(-1.0 / (w + yd)) + (ln2 / 3.0 + log(1.0 + w) / 3.0) * power_of<3>(log(-1.0 / (w + yd))) + (pisqu * ln2 * log(1.0 / (w + yd))) / 3.0 + (ln2 * power_of<3>(log(1.0 / (w + yd)))) / 3.0 + (2.0 * power_of<4>(log(w / (w + yd)))) / 3.0 - 2.0 * log(1.0 + winv) * power_of<2>(log(-winv)) * log((1.0 + w) / (w + yd))
                + 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / w) * log((-1.0 + yd) / (w + yd)) - (2.0 * pisqu * log((-1.0 + w) / w) * log(-((w * yd) / (w + yd)))) / 3.0 - (2.0 * log((-1.0 + w) / w) * power_of<3>(log(-((w * yd) / (w + yd))))) / 3.0 + (2.0 * pisqu * ln2 * log((w * yd) / (w + yd))) / 3.0 + (2.0 * ln2 * power_of<3>(log((w * yd) / (w + yd)))) / 3.0 + power_of<3>(ln1myd) * ((-2.0 * log((w - yd) / (-1.0 + w))) / 3.0 + 2.0 * log(ydinv) - 2.0 * log((1.0 + w) / (w + yd)) + 2.0 * log(((1.0 + w) * yd) / (w + yd))) + (2.0 * ln2 * power_of<2>(log((-1.0 + w) / w)) + 2.0 * log(1.0 + winv) * power_of<2>(log((-1.0 + w) / w))) * log((1.0 + yd) / (w + yd))
                + trilog((-1.0 + yd) / (w + yd)) * (2.0 * ln2 + 4.0 * log(1.0 + winv) - 2.0 * ln1pyd - 2.0 * log(w / (w + yd)) + 2.0 * log((w * (1.0 + yd)) / (w + yd))) + trilog(((1.0 + w) * yd) / (w + yd)) * (4.0 * log((-1.0 + w) / w) - 4.0 * ln1myd - 2.0 * ln1pyd - 2.0 * log(w / (w + yd)) + 2.0 * log((w * (1.0 + yd)) / (w + yd))) + dilog((w * (1.0 + yd)) / ((-1.0 + w) * yd)) * ((-2.0 * log(1.0 + winv) - 2.0 * ln1myd) * ln1pyd - 4.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)))
                + dilog((1.0 + yd) / (1.0 - w)) * ((-2.0 * pisqu) / 3.0 + 4.0 * power_of<2>(ln1myd) + (-4.0 * lnhalf + 2.0 * log(1.0 + winv)) * ln1pyd - 2.0 * power_of<2>(ln1pyd) + ln1myd * (12.0 * log((1.0 + yd) / 2.0) + 2.0 * ln1pyd) + 4.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd))) + trilog(-2.0 / (-1.0 + w)) * (8.0 * log(w / (-1.0 + w)) + 8.0 * ln1myd - 4.0 * log((w - yd) / (-1.0 + w)) - 2.0 * log((1.0 - yd) / (1.0 + yd)) + 8.0 * ln1pyd - 2.0 * log((1.0 + yd) / (1.0 - yd)) - 4.0 * log((w + yd) / (-1.0 + w)))
                + power_of<3>(ln1pyd) * (2.0 * log(((1.0 + w) * yd) / (-w + yd)) - (2.0 * log((w + yd) / (-1.0 + w))) / 3.0) + trilog((w * (1.0 + yd)) / (w + yd)) * (-2.0 * ln2 - 8.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 8.0 * ln1myd - 4.0 * log((w + yd) / w)) + trilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) * (-4.0 * lnhalf - 2.0 * ln2 - 8.0 * log((-1.0 + w) / w) - 4.0 * log(1.0 / (1.0 + w)) - 2.0 * log(1.0 + w) + 8.0 * log(1.0 / (1.0 + yd)) - 4.0 * log((w + yd) / w)) + power_of<3>(log(w / (w + yd))) * ((-4.0 * log(-(yd / (w + yd)))) / 3.0 - (2.0 * log((w + yd) / w)) / 3.0)
                + power_of<3>(log(w / (1.0 + yd))) * (log(1.0 - w) / 3.0 - (2.0 * log((-1.0 + w) / w)) / 3.0 + (2.0 * log((w + yd) / w)) / 3.0) + dilog((w + yd) / (-1.0 + yd)) * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 6.0 * ln1pyd) * log((w + yd) / w) + (2.0 * power_of<3>(log((-1.0 + w) / (w + yd))) * log((w + yd) / w)) / 3.0 + (-2.0 * ln2 - 3.0 * log(1.0 + winv)) * log(((-1.0 + w) * yd) / (w * (1.0 + yd))) * power_of<2>(log((w + yd) / w)) + trilog(-yd) * (-2.0 * ln2 + 8.0 * log(1.0 - w) - 4.0 * log(1.0 + w) + 2.0 * ln1myd - 4.0 * ln1pyd + 2.0 * log((w + yd) / w))
                + trilog((1.0 - w) / (1.0 + yd)) * (2.0 * ln2 + 2.0 * log(1.0 + w) + 4.0 * log((w + yd) / w)) + trilog((1.0 + yd) / (w + yd)) * (2.0 * ln2 + 8.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) - 16.0 * ln1myd + 4.0 * log((w + yd) / w)) + trilog(1.0 + yd) * (4.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 8.0 * log(-w) + 4.0 * log(w / (-1.0 + w)) - 4.0 * log(w / (1.0 + w)) - 8.0 * ln1pyd + 4.0 * log((w + yd) / (-1.0 + w)) + 4.0 * log((w + yd) / w))
                + log(w / (1.0 + yd)) * ((pisqu * log(1.0 - w)) / 3.0 - (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + (2.0 * pisqu * log((w + yd) / w)) / 3.0) + log((-1.0 + w) / (w + yd)) * (-4.0 * power_of<2>(log(winv)) * log((-1.0 + w) / w) + (2.0 * pisqu * log((w + yd) / w)) / 3.0) + dilog(2.0 / (1.0 + yd)) * (-2.0 * ln2 * log(1.0 + winv) + 2.0 * ln2 * log(1.0 - w) + 4.0 * ln2 * log((w + yd) / w)) + log((-1.0 + yd) / (1.0 + yd)) * (-(ln2squ * log(1.0 + winv)) + ln2squ * log(1.0 - w) + 2.0 * ln2squ * log((w + yd) / w))
                + dilog((w + yd) / (w + w * yd)) * (4.0 * ln1pyd * log((w + yd) / (-1.0 + w)) + (-4.0 * ln2 - 6.0 * log(1.0 + winv) + 2.0 * ln1myd) * log((w + yd) / w)) + dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) * ((4.0 * pisqu) / 3.0 + 2.0 * ln2 * log(1.0 - w) + 4.0 * lnhalf * log((-1.0 + w) / w) + 4.0 * power_of<2>(log((-1.0 + w) / w)) + 4.0 * log((-1.0 + w) / w) * log(1.0 / (1.0 + w)) + 2.0 * log(1.0 - w) * log(1.0 + w) + 4.0 * log(-(yd / w)) * log((w + yd) / w))
                + dilog((1.0 + yd) / (w + yd)) * (-8.0 * log(winv) * log((-1.0 + w) / w) + (-2.0 * ln2 - 2.0 * log(1.0 + w)) * ln1pyd + ln1myd * (8.0 * log((1.0 + yd) / 2.0) + 8.0 * ln1pyd) - 4.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w)) + dilog(1.0 + yd) * (4.0 * dilog((1.0 + yd) / (1.0 - w)) - 2.0 * dilog((1.0 + yd) / (1.0 + w)) - 4.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) + 4.0 * ln1pyd * log((w + yd) / (-1.0 + w)) - 4.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w))
                + dilog((w * (1.0 + yd)) / (w + yd)) * ((2.0 * ln2 + 2.0 * log(1.0 + w) - 8.0 * ln1myd) * ln1pyd + 4.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w)) + log((1.0 - w) / (1.0 + yd)) * (2.0 * log(1.0 - w) * power_of<2>(log(w)) + ln1pyd * ((4.0 * pisqu) / 3.0 - 2.0 * power_of<2>(log((w + yd) / (-1.0 + w)))) + (2.0 * ln2 + 3.0 * log(1.0 + winv)) * power_of<2>(log((w + yd) / w))) - (2.0 * pisqu * log(1.0 - w) * log((w + yd) / ((-1.0 + w) * w))) / 3.0 - (2.0 * log(1.0 - w) * power_of<3>(log((w + yd) / ((-1.0 + w) * w)))) / 3.0
                - 8.0 * dilog((-2.0 * (w + yd)) / ((-1.0 + w) * (-1.0 + yd))) * ln1myd * log((w + yd) / (1.0 + w)) - 8.0 * dilog((2.0 * (w + yd)) / ((1.0 + w) * (1.0 + yd))) * ln1myd * log((w + yd) / (1.0 + w)) + dilog((w + yd) / (w - w * yd)) * ((2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 6.0 * ln1pyd) * log((w + yd) / w) - 4.0 * ln1myd * log((w + yd) / (1.0 + w)))
                + dilog((w + yd) / (1.0 + yd)) * (4.0 * log(1.0 - w) * log(w) - 4.0 * ln1pyd * log((w + yd) / (-1.0 + w)) + (4.0 * ln2 + 6.0 * log(1.0 + winv) - 2.0 * ln1myd) * log((w + yd) / w) + 8.0 * ln1myd * log((w + yd) / (1.0 + w))) + (-(ln2 * power_of<2>(log(1.0 - w))) - power_of<2>(log(1.0 - w)) * log(1.0 + w)) * log((w + yd) / (1.0 + yd)) + trilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) * (-4.0 * lnhalf - 2.0 * ln2 - 8.0 * log((-1.0 + w) / w) - 4.0 * log(1.0 / (1.0 + w)) - 2.0 * log(1.0 + w) + 8.0 * log(1.0 / (1.0 - yd)) - 4.0 * log(1.0 - yd / w))
                + trilog((w - w * yd) / (w - yd)) * (-2.0 * ln2 - 8.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 8.0 * ln1pyd - 4.0 * log(1.0 - yd / w)) + trilog(-winv) * (-4.0 * log(1.0 - w) - 6.0 * ln1myd - 6.0 * ln1pyd - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) + trilog(winv) * (4.0 * log(1.0 + winv) + 10.0 * ln1myd + 10.0 * ln1pyd - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) + trilog(w) * (14.0 * ln1myd + 14.0 * ln1pyd - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w))
                + dilog((1.0 - yd) / (1.0 + yd)) * ln1myd * (6.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - 2.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) + dilog((1.0 + yd) / (2.0 * yd)) * ln1pyd * (4.0 * log(1.0 + winv) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 6.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) + dilog((1.0 + yd) / (1.0 - yd)) * ln1pyd * (6.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - 4.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w))
                + trilog(-w) * (-4.0 * ln2 - 4.0 * ln1myd - 4.0 * ln1pyd - 2.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w)) + power_of<3>(log(1.0 / (2.0 * yd))) * ((-2.0 * log(1.0 + winv)) / 3.0 - (2.0 * log((-1.0 + w) / w)) / 3.0 + log(1.0 + w) / 3.0 + (2.0 * log((w + yd) / w)) / 3.0 - log(1.0 - yd / w)) + power_of<3>(log(w / (w - yd))) * ((-4.0 * log(yd / (w - yd))) / 3.0 - (2.0 * log(1.0 - yd / w)) / 3.0) + power_of<3>(log(1.0 / (1.0 + yd))) * (log(1.0 + winv) - log(1.0 - w) / 3.0 + (2.0 * log((-1.0 + w) / w)) / 3.0 - log(1.0 + w) / 3.0 + 4.0 * log(-(yd / (1.0 + yd))) - log((w + yd) / w) / 3.0 - (2.0 * log(1.0 - yd / w)) / 3.0)
                + power_of<3>(log(1.0 / (1.0 - yd))) * (log(1.0 + winv) - log(1.0 - w) / 3.0 + (2.0 * log((-1.0 + w) / w)) / 3.0 - log(1.0 + w) / 3.0 + 4.0 * log(yd / (1.0 - yd)) - (2.0 * log((w + yd) / w)) / 3.0 - log(1.0 - yd / w) / 3.0) + power_of<3>(log(-ydinv)) * (-ln2 - (2.0 * log(1.0 + winv)) / 3.0 + log(1.0 - w) / 3.0 - log(1.0 + w) / 3.0 - (2.0 * ln1pyd) / 3.0 + (5.0 * log((w + yd) / w)) / 3.0 - log(1.0 - yd / w) / 3.0) + power_of<3>(log(w / (1.0 - yd))) * (log(1.0 - w) / 3.0 - (2.0 * log((-1.0 + w) / w)) / 3.0 + ln1pyd + (2.0 * log(1.0 - yd / w)) / 3.0)
                + power_of<3>(log((-0.5) * (1.0 / yd))) * ((-2.0 * log(1.0 + winv)) / 3.0 - (2.0 * log((-1.0 + w) / w)) / 3.0 + log(1.0 + w) / 3.0 - log((w + yd) / w) + (2.0 * log(1.0 - yd / w)) / 3.0) + dilog((-w + yd) / (1.0 + yd)) * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 6.0 * ln1myd) * log(1.0 - yd / w) + (2.0 * power_of<3>(log((-1.0 + w) / (w - yd))) * log(1.0 - yd / w)) / 3.0 + 2.0 * power_of<2>(log((-1.0 + yd) / (-1.0 + w))) * log(((-1.0 + w) * yd) / (w - yd)) * log(1.0 - yd / w)
                + log(-2.0 / (-1.0 + yd)) * power_of<2>(ln1pyd) * (-3.0 * log(1.0 + winv) + log(1.0 - w) - 2.0 * log((-1.0 + w) / w) + log(1.0 + w) + 2.0 * log((w + yd) / w) + log(1.0 - yd / w)) + power_of<3>(log(ydinv)) * (-ln2 - (2.0 * log(1.0 + winv)) / 3.0 + log(1.0 - w) / 3.0 - log(1.0 + w) / 3.0 + (4.0 * ln1pyd) / 3.0 - log((w + yd) / w) / 3.0 + (5.0 * log(1.0 - yd / w)) / 3.0) + trilog(yd) * (-2.0 * ln2 + 8.0 * log(1.0 - w) - 4.0 * log(1.0 + w) - 4.0 * ln1myd + 2.0 * ln1pyd + 2.0 * log(1.0 - yd / w))
                + trilog((1.0 + yd) / (1.0 - yd)) * (-6.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 4.0 * log((w - yd) / (1.0 + w)) + 4.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w)) + trilog((-1.0 + w) / (-1.0 + yd)) * (2.0 * ln2 + 2.0 * log(1.0 + w) + 4.0 * log(1.0 - yd / w)) + trilog(1.0 - yd) * (4.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 8.0 * log(-w) + 4.0 * log(w / (-1.0 + w)) - 4.0 * log(w / (1.0 + w)) - 8.0 * ln1myd + 4.0 * log((w - yd) / (-1.0 + w)) + 4.0 * log(1.0 - yd / w))
                + trilog((-1.0 + yd) / (-w + yd)) * (2.0 * ln2 + 8.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) - 16.0 * ln1pyd + 4.0 * log(1.0 - yd / w)) + trilog(-1.0) * (-8.0 * log(1.0 + winv) - 8.0 * log((-1.0 + w) / w) + 4.0 * log(1.0 + w) + 4.0 * ln1myd + 4.0 * ln1pyd + 4.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w)) + trilog(w / (-1.0 + w)) * (-8.0 * log(1.0 / (1.0 - w)) - 8.0 * log(1.0 - w) - 4.0 * log(1.0 / (1.0 + w)) + 6.0 * ln1myd - 2.0 * log(yd / (-1.0 + yd)) - 2.0 * log(yd / (1.0 + yd)) + 6.0 * ln1pyd + 4.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w))
                + trilog(2.0 / (1.0 + w)) * (8.0 * log(w / (1.0 + w)) + 10.0 * ln1myd - 4.0 * log((w - yd) / (1.0 + w)) + 10.0 * ln1pyd + 4.0 * log((w + yd) / w) - 4.0 * log((w + yd) / (1.0 + w)) + 4.0 * log(1.0 - yd / w)) + trilog((1.0 - yd) / (1.0 + yd)) * (-6.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 2.0 * log((w + yd) / w) + 4.0 * log((w + yd) / (1.0 + w)) + 4.0 * log(1.0 - yd / w)) + dilog((-1.0 + yd) / (2.0 * yd)) * ln1myd * (4.0 * log(1.0 + winv) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - 4.0 * log((w + yd) / w) + 6.0 * log(1.0 - yd / w))
                + trilog(2.0) * (4.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) - 2.0 * ln1myd - 2.0 * ln1pyd + 8.0 * log((w + yd) / w) + 8.0 * log(1.0 - yd / w)) + log(1.0 / (2.0 * yd)) * ((-2.0 * pisqu * log(1.0 + winv)) / 3.0 - (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + (pisqu * log(1.0 + w)) / 3.0 + (2.0 * pisqu * log((w + yd) / w)) / 3.0 - pisqu * log(1.0 - yd / w)) + log(w / (1.0 - yd)) * ((pisqu * log(1.0 - w)) / 3.0 - (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + pisqu * ln1pyd + (2.0 * pisqu * log(1.0 - yd / w)) / 3.0)
                + log((-0.5) * (1.0 / yd)) * ((-2.0 * pisqu * log(1.0 + winv)) / 3.0 - (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + (pisqu * log(1.0 + w)) / 3.0 - pisqu * log((w + yd) / w) + (2.0 * pisqu * log(1.0 - yd / w)) / 3.0) + dilog(2.0) * (-4.0 * ln2 * log(1.0 + winv) + 4.0 * ln2 * log(1.0 - w) + 2.0 * ln2 * ln1myd + 2.0 * ln2 * ln1pyd - 8.0 * ln2 * log((w + yd) / w) - 8.0 * ln2 * log(1.0 - yd / w))
                + dilog(2.0 / (1.0 + w)) * (2.0 * dilog((1.0 - yd) / (1.0 + w)) + 2.0 * dilog((1.0 + yd) / (1.0 + w)) + ln1myd * (-2.0 * ln2 + 8.0 * log((1.0 + yd) / 2.0) - 8.0 * ln1pyd) + (-2.0 * ln2 + 8.0 * log((1.0 - yd) / 2.0)) * ln1pyd - 4.0 * ln2 * log((w + yd) / w) - 4.0 * ln2 * log(1.0 - yd / w)) + dilog(-2.0 / (-1.0 + yd)) * (-2.0 * ln2 * log(1.0 + winv) + 2.0 * ln2 * log(1.0 - w) + 4.0 * ln2 * log(1.0 - yd / w))
                + dilog((2.0 * w) / (1.0 + w)) * (-2.0 * dilog(yd) + dilog((2.0 * yd) / (-1.0 + yd)) + dilog((2.0 * yd) / (1.0 + yd)) + 2.0 * ln2 * ln1myd + 2.0 * ln2 * ln1pyd + 4.0 * ln2 * log((w + yd) / w) + 4.0 * ln2 * log(1.0 - yd / w)) + log((1.0 + yd) / (-1.0 + yd)) * (-(ln2squ * log(1.0 + winv)) + ln2squ * log(1.0 - w) + 2.0 * ln2squ * log(1.0 - yd / w)) + dilog(ydinv) * ((2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w)) * ln1pyd - 4.0 * log((-1.0 + w) / w) * log((w + yd) / w) + (-4.0 * ln2 - 4.0 * log(1.0 + winv)) * log(1.0 - yd / w))
                + dilog((1.0 + w) / (1.0 - w)) * (-2.0 * dilog((-1.0 + yd) / (-1.0 + w)) - 2.0 * dilog((1.0 + yd) / (1.0 - w)) + (4.0 * lnhalf + 2.0 * log(1.0 + winv) - 4.0 * log(1.0 / (1.0 - w))) * ln1myd + (4.0 * lnhalf + 2.0 * log(1.0 + winv) - 4.0 * log(1.0 / (1.0 - w))) * ln1pyd - 4.0 * log(1.0 + winv) * log((w + yd) / w) - 4.0 * log(1.0 + winv) * log(1.0 - yd / w))
                + dilog((1.0 + w) / (2.0 * w)) * (-4.0 * dilog(yd / w) + 2.0 * dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) + 2.0 * dilog((yd + w * yd) / (w + w * yd)) + (4.0 * lnhalf - 4.0 * log(1.0 / (1.0 - w)) - 2.0 * log(1.0 + w)) * ln1myd + (4.0 * lnhalf - 4.0 * log(1.0 / (1.0 - w)) - 2.0 * log(1.0 + w)) * ln1pyd - 4.0 * log(1.0 + winv) * log((w + yd) / w) - 4.0 * log(1.0 + winv) * log(1.0 - yd / w))
                + dilog((-1.0 + w) / (2.0 * w)) * (dilog((1.0 - yd) / 2.0) - 4.0 * dilog(-(yd / w)) - 4.0 * dilog(yd / w) + 2.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 2.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + dilog((1.0 + yd) / 2.0) + (4.0 * lnhalf + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * ln1myd + (4.0 * lnhalf + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * ln1pyd - 2.0 * log(1.0 - w) * log((w + yd) / w) - 2.0 * log(1.0 - w) * log(1.0 - yd / w))
                + dilog((1.0 - w) / (1.0 + w)) * (2.0 * dilog(yd) - dilog(((-1.0 + w) * yd) / (w - yd)) - dilog((yd - w * yd) / (w + yd)) + (4.0 * lnhalf - 4.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w)) * ln1myd + (4.0 * lnhalf - 4.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w)) * ln1pyd + (2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * log((w + yd) / w) + (2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * log(1.0 - yd / w))
                + dilog(-ydinv) * ((2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w)) * ln1myd + (-4.0 * ln2 - 4.0 * log(1.0 + winv)) * log((w + yd) / w) - 4.0 * log((-1.0 + w) / w) * log(1.0 - yd / w)) + dilog((-1.0 + w) / (1.0 + w)) * (-4.0 * dilog(yd / w) + 2.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 2.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + (4.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * ln1myd + (4.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w)) * ln1pyd + (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w)) * log((w + yd) / w)
                + (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w)) * log(1.0 - yd / w)) + dilog((w - yd) / (w + w * yd)) * (-4.0 * log((w - yd) / (1.0 + w)) * ln1pyd + (2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 6.0 * ln1myd) * log(1.0 - yd / w)) + dilog((-1.0 + yd) / (-w + yd)) * (-8.0 * log(winv) * log((-1.0 + w) / w) + 8.0 * log((1.0 - yd) / 2.0) * ln1pyd + ln1myd * (-2.0 * ln2 - 2.0 * log(1.0 + w) + 8.0 * ln1pyd) - 4.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w))
                + dilog((w - w * yd) / (w - yd)) * (ln1myd * (2.0 * ln2 + 2.0 * log(1.0 + w) - 8.0 * ln1pyd) + 4.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w)) + log((-1.0 + w) / (w - yd)) * (-4.0 * power_of<2>(log(winv)) * log((-1.0 + w) / w) + 4.0 * power_of<2>(log((1.0 - yd) / 2.0)) * ln1pyd + (2.0 * pisqu * log(1.0 - yd / w)) / 3.0 - 2.0 * power_of<2>(log((-1.0 + yd) / (-1.0 + w))) * log(1.0 - yd / w))
                + dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) * ((4.0 * pisqu) / 3.0 + 2.0 * ln2 * log(1.0 - w) + 4.0 * lnhalf * log((-1.0 + w) / w) + 4.0 * power_of<2>(log((-1.0 + w) / w)) + 4.0 * log((-1.0 + w) / w) * log(1.0 / (1.0 + w)) + 2.0 * log(1.0 - w) * log(1.0 + w) + 4.0 * log(yd / w) * log(1.0 - yd / w)) + dilog((-w + yd) / (-1.0 + yd)) * (4.0 * log(1.0 - w) * log(w) - 4.0 * ln1myd * log((w - yd) / (-1.0 + w)) + 8.0 * log((w - yd) / (1.0 + w)) * ln1pyd + (4.0 * ln2 + 6.0 * log(1.0 + winv)) * log(1.0 - yd / w) - 2.0 * ln1pyd * log(1.0 - yd / w))
                + dilog((w - yd) / (w - w * yd)) * (4.0 * ln1myd * log((w - yd) / (-1.0 + w)) + (-4.0 * ln2 - 6.0 * log(1.0 + winv) + 2.0 * ln1pyd) * log(1.0 - yd / w)) + log(((-1.0 + w) * yd) / (w * (-1.0 + yd))) * ((-2.0 * ln2 - 3.0 * log(1.0 + winv)) * power_of<2>(log(1.0 - yd / w)) + ln1pyd * power_of<2>(log(1.0 - yd / w))) + dilog((1.0 + yd) / (-1.0 + yd)) * (ln1myd * (4.0 * log((1.0 + yd) / 2.0) - 4.0 * log((1.0 + yd) / (1.0 - w))) + ln1pyd * (-6.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 4.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w)))
                + dilog((-1.0 + yd) / (1.0 + yd)) * (-2.0 * dilog((yd + w * yd) / (w + w * yd)) + 4.0 * log((1.0 - yd) / 2.0) * ln1pyd - 4.0 * log((-1.0 + yd) / (-1.0 + w)) * ln1pyd + ln1myd * (-6.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 2.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w)))
                + dilog(w) * (6.0 * dilog(yd) + 2.0 * dilog(yd / (-1.0 + yd)) - 2.0 * dilog((2.0 * yd) / (-1.0 + yd)) + 2.0 * dilog(yd / (1.0 + yd)) - 2.0 * dilog((2.0 * yd) / (1.0 + yd)) - 2.0 * ln2 * log((1.0 - yd) / (1.0 + yd)) - 2.0 * ln2 * log((1.0 + yd) / (1.0 - yd)) - 2.0 * power_of<2>(log((w + yd) / w)) + ln1myd * (-4.0 * ln2 - 4.0 * log(1.0 + w) + 8.0 * log((w + yd) / w)) - 2.0 * power_of<2>(log(1.0 - yd / w)) + ln1pyd * (-4.0 * ln2 - 4.0 * log(1.0 + w) + 8.0 * log(1.0 - yd / w)))
                + log((-1.0 + w) / (-1.0 + yd)) * (2.0 * log(1.0 - w) * power_of<2>(log(w)) + (2.0 * ln2 + 3.0 * log(1.0 + winv)) * power_of<2>(log(1.0 - yd / w)) + ln1pyd * (4.0 * power_of<2>(log((w - yd) / (1.0 + w))) - power_of<2>(log(1.0 - yd / w)))) + 2.0 * power_of<2>(log(yd / w)) * log(1.0 - yd / w) * log((w - yd) / (w - w * yd)) + dilog((w - yd) / ((-1.0 + w) * yd)) * (-4.0 * ln1pyd * log(1.0 - yd / w) + 8.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)))
                + log((w * (-1.0 + yd)) / ((-1.0 + w) * yd)) * ((-4.0 * pisqu * log((-1.0 + w) / w)) / 3.0 - 2.0 * ln1pyd * power_of<2>(log(1.0 - yd / w)) + 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w - yd) / (w - w * yd)))) + (2.0 * pisqu * log(1.0 - w) * log(yd / (w - w * yd))) / 3.0 + (2.0 * log(1.0 - w) * power_of<3>(log(yd / (w - w * yd)))) / 3.0 + trilog((1.0 + yd) / (-1.0 + yd)) * (6.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 4.0 * log(1.0 / (1.0 - yd)) - 4.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) - 4.0 * log((w + yd) / (w - w * yd)))
                - 2.0 * log(1.0 + winv) * log((1.0 - yd) / (1.0 + w)) * power_of<2>(log((w + yd) / (w - w * yd))) + dilog((w + yd) / (1.0 + w)) * ((-4.0 * ln2 - 2.0 * log(1.0 - w)) * log((w + yd) / w) - 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd))) + dilog((w + yd) / (yd + w * yd)) * ((4.0 * ln2 + 2.0 * log(1.0 - w)) * log((w + yd) / w) - 4.0 * ln1myd * log((w + yd) / (1.0 + w)) + 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd)))
                + log((w * (-1.0 + yd)) / ((1.0 + w) * yd)) * ((-2.0 * pisqu * log(1.0 + winv)) / 3.0 + (2.0 * ln2 + log(1.0 - w)) * power_of<2>(log((w + yd) / w)) + 2.0 * log(1.0 + winv) * power_of<2>(log((w + yd) / (w - w * yd)))) + trilog(-((1.0 + yd) / (w - yd))) * (2.0 * ln2 + 4.0 * log(1.0 + winv) - 2.0 * ln1myd - 2.0 * log(w / (w - yd)) + 2.0 * log((w - w * yd) / (w - yd))) + trilog(((1.0 + w) * yd) / (-w + yd)) * (4.0 * log((-1.0 + w) / w) - 2.0 * ln1myd - 2.0 * log(w / (w - yd)) - 4.0 * ln1pyd + 2.0 * log((w - w * yd) / (w - yd)))
                + dilog((w * (-1.0 + yd)) / ((-1.0 + w) * yd)) * (ln1myd * (-2.0 * log(1.0 + winv) - 2.0 * ln1pyd) - 4.0 * log(1.0 - w) * log((w - w * yd) / (w - yd))) + dilog(1.0 - yd) * (-2.0 * dilog((1.0 - yd) / (1.0 + w)) + 4.0 * dilog((-1.0 + yd) / (-1.0 + w)) + 4.0 * ln1myd * log((w - yd) / (-1.0 + w)) - 4.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w) - 4.0 * log(1.0 - w) * log((w - w * yd) / (w - yd)))
                + dilog((-1.0 + yd) / (-1.0 + w)) * ((-2.0 * pisqu) / 3.0 - 4.0 * dilog(-yd) - 2.0 * power_of<2>(ln1myd) + 12.0 * log((1.0 - yd) / 2.0) * ln1pyd + 4.0 * power_of<2>(ln1pyd) + ln1myd * (-4.0 * lnhalf + 2.0 * log(1.0 + winv) + 2.0 * ln1pyd) + 4.0 * log(1.0 - w) * log((w - w * yd) / (w - yd))) + log((w - yd) / ((-1.0 + w) * yd)) * ((2.0 * pisqu * log(1.0 - w)) / 3.0 - 2.0 * log(1.0 - w) * power_of<2>(log((w - w * yd) / (w - yd)))) - 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / w) * log((w - w * yd) / (w + yd)) + (pisqu * log(1.0 + winv) * log(w / (yd - w * yd))) / 3.0
                + (log(1.0 + winv) * power_of<3>(log(w / (yd - w * yd)))) / 3.0 + (2.0 * pisqu * log(1.0 - w) * log((w + yd) / (yd - w * yd))) / 3.0 + (2.0 * log(1.0 - w) * power_of<3>(log((w + yd) / (yd - w * yd)))) / 3.0 + trilog((-1.0 + yd) / (1.0 + yd)) * (6.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 4.0 * log(1.0 / (1.0 + yd)) - 2.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w) - 4.0 * log((w - yd) / (w + w * yd)))
                + trilog(1.0 + winv) * (-4.0 * log(1.0 / (1.0 - yd)) + 4.0 * ln1myd - 4.0 * log(1.0 / (1.0 + yd)) + 4.0 * ln1pyd - 4.0 * log((w + yd) / (w - w * yd)) - 4.0 * log((w - yd) / (w + w * yd))) - 2.0 * log(1.0 + winv) * log((1.0 + yd) / (1.0 + w)) * power_of<2>(log((w - yd) / (w + w * yd))) + trilog((1.0 + w) / (2.0 * w)) * (2.0 * ln1myd + 2.0 * ln1pyd + 4.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w) + 4.0 * log((w + yd) / (w - w * yd)) + 4.0 * log((w - yd) / (w + w * yd)))
                + dilog((w - yd) / (1.0 + w)) * (2.0 * dilog(yd) + (-4.0 * ln2 - 2.0 * log(1.0 - w)) * log(1.0 - yd / w) - 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd))) + dilog(1.0 + winv) * (-4.0 * dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) + 4.0 * dilog(yd / (1.0 + yd)) - 4.0 * dilog((yd + w * yd) / (w + w * yd)) + 4.0 * log(1.0 + w) * ln1myd - 2.0 * power_of<2>(ln1myd) + 4.0 * log(1.0 + w) * ln1pyd - 2.0 * power_of<2>(ln1pyd) - 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd)) - 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd)))
                + dilog(-((w - yd) / (yd + w * yd))) * (-4.0 * log((w - yd) / (1.0 + w)) * ln1pyd + (4.0 * ln2 + 2.0 * log(1.0 - w)) * log(1.0 - yd / w) + 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd))) + dilog(1.0 - yd / w) * (-4.0 * ln1myd * log((w - yd) / (-1.0 + w)) + 4.0 * log((w - yd) / (1.0 + w)) * ln1pyd + 2.0 * power_of<2>(ln1pyd) + 4.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w) + 8.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) + 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd)))
                + log(yd / w) * (2.0 * power_of<2>(log((w - yd) / (1.0 + w))) * ln1pyd + 2.0 * log((w - yd) / (1.0 + w)) * power_of<2>(ln1pyd) + 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w - yd) / (w - w * yd))) + 2.0 * log(1.0 + winv) * power_of<2>(log((w - yd) / (w + w * yd)))) + (2.0 * pisqu * log(1.0 - w) * log(-(yd / (w + w * yd)))) / 3.0 + (2.0 * log(1.0 - w) * power_of<3>(log(-(yd / (w + w * yd))))) / 3.0 + ((-1.0 / 3.0) * (pisqu * ln2) - (pisqu * log(1.0 + w)) / 3.0) * log(yd / (w + w * yd)) + ((-1.0 / 3.0) * ln2 - log(1.0 + w) / 3.0) * power_of<3>(log(yd / (w + w * yd)))
                + 2.0 * power_of<2>(log(-(yd / w))) * log((w + yd) / w) * log((w + yd) / (w + w * yd)) + trilog((-1.0 + w) / (2.0 * w)) * (-4.0 * lnhalf + 2.0 * log((1.0 - yd) / 2.0) - 2.0 * ln1myd + 2.0 * log((1.0 + yd) / 2.0) - 2.0 * ln1pyd + 2.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w) + 4.0 * log((w - yd) / (w - w * yd)) + 4.0 * log((w + yd) / (w + w * yd))) + dilog((w + yd) / (yd - w * yd)) * (-4.0 * ln1myd * log((w + yd) / w) + 8.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)))
                + dilog((w + yd) / w) * (2.0 * power_of<2>(ln1myd) - 4.0 * ln1pyd * log((w + yd) / (-1.0 + w)) + 4.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w) + 4.0 * ln1myd * log((w + yd) / (1.0 + w)) + 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd)) + 8.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd))) + log((w * (1.0 + yd)) / ((-1.0 + w) * yd)) * ((-4.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w + yd) / (w + w * yd))))
                + log(-(yd / w)) * (2.0 * log(1.0 + winv) * power_of<2>(log((w + yd) / (w - w * yd))) + 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w + yd) / (w + w * yd)))) + ((-1.0 / 3.0) * (pisqu * ln2) - (pisqu * log(1.0 - w)) / 3.0) * log(-(w / (yd + w * yd))) + ((-1.0 / 3.0) * ln2 - log(1.0 - w) / 3.0) * power_of<3>(log(-(w / (yd + w * yd)))) + ((-1.0 / 3.0) * (pisqu * ln2) - (pisqu * log(1.0 - w)) / 3.0) * log(w / (yd + w * yd)) + ((-1.0 / 3.0) * ln2 - log(1.0 - w) / 3.0) * power_of<3>(log(w / (yd + w * yd))) - (2.0 * pisqu * log(1.0 + winv) * log((w + w * yd) / (yd + w * yd))) / 3.0
                - (2.0 * log(1.0 + winv) * power_of<3>(log((w + w * yd) / (yd + w * yd)))) / 3.0 + (4.0 * 1.0i) * M_PI * H1(yd / (w + yd), 1.0 / (1.0 - w)) * log(1.0 - w) * power_of<2>(log(w * (1.0 + ydinv))) * my_sign(-imag(1.0 / (1.0 - w))) + (4.0 * 1.0i) * M_PI * H1(-(yd / (w - yd)), 1.0 / (1.0 - w)) * log(1.0 - w) * power_of<2>(log((w * (-1.0 + yd)) / yd)) * my_sign(imag(1.0 / (-1.0 + w))) - (4.0 * 1.0i) * M_PI * H2(winv, ydinv) * trilog((2.0 * w) / (w - yd)) * my_sign(imag(winv)) - (4.0 * 1.0i) * M_PI * H2(winv, -ydinv) * trilog((2.0 * w) / (w + yd)) * my_sign(imag(winv))
                + trilog((1.0 + w) / (w + yd)) * (-4.0 * log((-1.0 + w) / w) - 4.0 * ln1myd + 2.0 * ln1pyd - (4.0 * 1.0i) * M_PI * H2(winv, -ydinv) * my_sign(imag(winv))) + trilog((1.0 + w) / (w - yd)) * (-4.0 * log((-1.0 + w) / w) + 2.0 * ln1myd - 4.0 * ln1pyd - (4.0 * 1.0i) * M_PI * H2(winv, ydinv) * my_sign(imag(winv))) + power_of<2>(log(-((w * (1.0 + yd)) / yd))) * ((2.0 * 1.0i) * M_PI * H1(-(yd / w), winv) * ln2 * my_sign(imag(winv)) + (2.0 * 1.0i) * M_PI * H1(-(yd / w), winv) * log(1.0 + w) * my_sign(imag(winv)))
                + power_of<2>(log(w * (-1.0 + ydinv))) * ((2.0 * 1.0i) * M_PI * H1(yd / w, winv) * ln2 * my_sign(imag(winv)) + (2.0 * 1.0i) * M_PI * H1(yd / w, winv) * log(1.0 + w) * my_sign(imag(winv))) - (2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * power_of<2>(log((-1.0 + yd) / (w + yd))) * log((w * (1.0 + yd)) / (w + yd)) * my_sign(-imag(w)) - (2.0 * 1.0i) * M_PI * H2(-w, w / yd) * power_of<2>(log(-((1.0 + yd) / (w - yd)))) * log((w - w * yd) / (w - yd)) * my_sign(-imag(w))
                + trilog(2.0 / (1.0 + yd)) * (2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) - 8.0 * ln1myd - 4.0 * log((w + yd) / w) + (8.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) + (8.0 * 1.0i) * M_PI * H2(w, -(w / yd)) * my_sign(imag(w))) + trilog(-2.0 / (-1.0 + yd)) * (2.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) - 8.0 * ln1pyd - 4.0 * log(1.0 - yd / w) + (8.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) + (8.0 * 1.0i) * M_PI * H2(w, w / yd) * my_sign(imag(w)))
                + power_of<2>(log(winv - ydinv)) * ((-4.0 * 1.0i) * M_PI * H1(-yd, -w) * log((-1.0 + w) / w) * my_sign(-imag(w)) - (8.0 * 1.0i) * M_PI * H1(yd / (-1.0 + yd), w / (-1.0 + w)) * log((-1.0 + w) / w) * my_sign(imag(w / (1.0 - w)))) + power_of<2>(log(winv + ydinv)) * ((-4.0 * 1.0i) * M_PI * H1(yd, -w) * log((-1.0 + w) / w) * my_sign(-imag(w)) - (8.0 * 1.0i) * M_PI * H1(yd / (1.0 + yd), w / (-1.0 + w)) * log((-1.0 + w) / w) * my_sign(imag(w / (1.0 - w))))
                + power_of<2>(log(-((w + yd) / (w * yd)))) * ((-4.0 * 1.0i) * M_PI * H1(-yd, w) * ln2 * my_sign(imag(w)) - (4.0 * 1.0i) * M_PI * H1(-yd, w) * log(1.0 + winv) * my_sign(imag(w)) - (4.0 * 1.0i) * M_PI * H1(yd / (-1.0 + yd), w / (1.0 + w)) * log(1.0 + winv) * my_sign(-imag(w / (1.0 + w)))) + power_of<2>(log(-winv + ydinv)) * ((-4.0 * 1.0i) * M_PI * H1(yd, w) * ln2 * my_sign(imag(w)) - (4.0 * 1.0i) * M_PI * H1(yd, w) * log(1.0 + winv) * my_sign(imag(w)) - (4.0 * 1.0i) * M_PI * H1(yd / (1.0 + yd), w / (1.0 + w)) * log(1.0 + winv) * my_sign(-imag(w / (1.0 + w)))) + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * trilog((-2.0 * yd) / (w - yd)) * my_sign(-imydinv)
                - (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(-1.0 + 2.0 / w) * my_sign(-imydinv) + (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(winv) * my_sign(-imydinv) - (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(w) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(-imydinv) + (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(-((-2.0 + w) * w)) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(-imydinv) - (2.0 * 1.0i) * M_PI * H1(-(w / yd), -ydinv) * log(1.0 + winv) * power_of<2>(log(((-1.0 + w) * yd) / w)) * my_sign(-imydinv) - (2.0 * 1.0i) * M_PI * H1(-winv, -ydinv) * ln2 * power_of<2>(log(-w + yd)) * my_sign(-imydinv)
                - (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * power_of<2>(log(((1.0 + w) * yd) / (-w + yd))) * log((w - w * yd) / (w - yd)) * my_sign(-imydinv) + trilog((2.0 * (w + yd)) / yd) * ((-4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv)) + dilog((2.0 * (w + yd)) / yd) * log(1.0 - power_of<2>(w) / yd2) * ((4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv))
                + trilog(-(yd / (w - yd))) * (-2.0 * lnhalf - 4.0 * log(1.0 + winv) - 8.0 * log((-1.0 + w) / w) - 2.0 * log(w / (1.0 + w)) + 6.0 * ln1myd - 4.0 * log(w / (w - yd)) - 4.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv))
                + trilog(((-1.0 + w) * yd) / (w - yd)) * (2.0 * lnhalf + 4.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 2.0 * log(w / (1.0 + w)) - 4.0 * ln1myd - 4.0 * log(w / (w - yd)) + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv)) + power_of<2>(log(w + yd)) * ((-2.0 * 1.0i) * M_PI * H1(winv, -ydinv) * ln2 * my_sign(-imydinv) - (2.0 * 1.0i) * M_PI * H1(winv, -ydinv) * log(1.0 + w) * my_sign(-imydinv))
                + dilog(((-1.0 + w) * yd) / (w - yd)) * ((-2.0 * pisqu) / 3.0 + dilog(-((1.0 + yd) / (w - yd))) + dilog(((1.0 + w) * yd) / (-w + yd)) - 2.0 * lnhalf * log(1.0 - w) - 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * ln2 * log((-1.0 + w) / w) - 4.0 * log(1.0 + winv) * log((-1.0 + w) / w) - 2.0 * log(1.0 - w) * log(w / (1.0 + w)) + 4.0 * ln1myd * log(yd) - (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * log(-((1.0 + yd) / (w - yd))) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(((1.0 + w) * yd) / (-w + yd)) * my_sign(-imydinv))
                + dilog(-(yd / (w - yd))) * ((2.0 * pisqu) / 3.0 - 4.0 * dilog(1.0 - w) - 2.0 * dilog(((-1.0 + w) * yd) / (w - yd)) - dilog(-((1.0 + yd) / (w - yd))) - dilog(((1.0 + w) * yd) / (-w + yd)) + 4.0 * log(1.0 + winv) * log(-winv) + 8.0 * log(winv) * log((-1.0 + w) / w) - 4.0 * ln1myd * log(yd) + 4.0 * log(yd / w) * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * log(-((1.0 + yd) / (w - yd))) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(((1.0 + w) * yd) / (-w + yd)) * my_sign(-imydinv))
                + dilog((w + yd) / yd) * (-4.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) + (-8.0 * ln2 - 6.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 6.0 * ln1myd + 6.0 * ln1pyd) * log((w + yd) / w) + 4.0 * ln1myd * log((w + yd) / (1.0 + w)) + log(1.0 - power_of<2>(w) / yd2) * ((-4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv))) + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * trilog((2.0 * yd) / (w + yd)) * my_sign(imydinv)
                - (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(-1.0 + 2.0 / w) * my_sign(imydinv) + (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(winv) * my_sign(imydinv) - (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(w) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(imydinv) + (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(-((-2.0 + w) * w)) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(imydinv) - (2.0 * 1.0i) * M_PI * H1(-winv, ydinv) * ln2 * power_of<2>(log(-w - yd)) * my_sign(imydinv) - (2.0 * 1.0i) * M_PI * H1(w / yd, ydinv) * log(1.0 + winv) * power_of<2>(log((-1.0 + winv) * yd)) * my_sign(imydinv)
                - (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * power_of<2>(log(((1.0 + w) * yd) / (w + yd))) * log((w * (1.0 + yd)) / (w + yd)) * my_sign(imydinv) + trilog(2.0 - (2.0 * w) / yd) * ((-4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv)) + dilog(2.0 - (2.0 * w) / yd) * log(1.0 - power_of<2>(w) / yd2) * ((4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv))
                + trilog(yd / (w + yd)) * (-2.0 * lnhalf - 4.0 * log(1.0 + winv) - 8.0 * log((-1.0 + w) / w) - 2.0 * log(w / (1.0 + w)) + 4.0 * ln1myd + 6.0 * ln1pyd - 4.0 * log(w / (w + yd)) - 4.0 * log((w + yd) / w) - (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv))
                + trilog((yd - w * yd) / (w + yd)) * (2.0 * lnhalf + 4.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log(1.0 - w) + 2.0 * log(w / (1.0 + w)) - 4.0 * ln1pyd - 4.0 * log(w / (w + yd)) + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv)) + trilog((2.0 * w) / (-1.0 + w)) * (-4.0 * log(1.0 / (1.0 - w)) + 2.0 * log((-1.0 + yd) / (-1.0 + w)) + 2.0 * log((1.0 + yd) / (1.0 - w)) - (8.0 * 1.0i) * M_PI * H2(-ydinv, -(w / yd)) * my_sign(-imydinv) - (8.0 * 1.0i) * M_PI * H2(ydinv, w / yd) * my_sign(imydinv))
                + trilog((2.0 * w) / (1.0 + w)) * (-2.0 * ln1myd + 2.0 * log((1.0 - yd) / (1.0 + yd)) - 2.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - yd)) - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(-imydinv) - (8.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(imydinv)) + power_of<2>(log(w - yd)) * ((-2.0 * 1.0i) * M_PI * H1(winv, ydinv) * ln2 * my_sign(imydinv) - (2.0 * 1.0i) * M_PI * H1(winv, ydinv) * log(1.0 + w) * my_sign(imydinv))
                + dilog((yd - w * yd) / (w + yd)) * ((-2.0 * pisqu) / 3.0 - 2.0 * lnhalf * log(1.0 - w) - 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * ln2 * log((-1.0 + w) / w) - 4.0 * log(1.0 + winv) * log((-1.0 + w) / w) - 2.0 * log(1.0 - w) * log(w / (1.0 + w)) + 4.0 * log(-yd) * ln1pyd - (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * log((-1.0 + yd) / (w + yd)) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(((1.0 + w) * yd) / (w + yd)) * my_sign(imydinv))
                + dilog(yd / (w + yd)) * ((2.0 * pisqu) / 3.0 - dilog((-1.0 + yd) / (w + yd)) - dilog(((1.0 + w) * yd) / (w + yd)) - 2.0 * dilog((yd - w * yd) / (w + yd)) + 4.0 * log(1.0 + winv) * log(-winv) + 8.0 * log(winv) * log((-1.0 + w) / w) - 4.0 * ln1myd * log(yd) - 4.0 * log(-yd) * ln1pyd + 4.0 * log(-(yd / w)) * log((w + yd) / w) + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * log((-1.0 + yd) / (w + yd)) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(((1.0 + w) * yd) / (w + yd)) * my_sign(imydinv))
                + power_of<2>(log(1.0 - power_of<2>(w) / yd2)) * (log(-1.0 - (2.0 * w) / yd) * ((2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) + (2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv)) + log(-1.0 + (2.0 * w) / yd) * ((2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) + (2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv)))
                + dilog(1.0 - w / yd) * (4.0 * log((w - yd) / (1.0 + w)) * ln1pyd + (-8.0 * ln2 - 6.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 6.0 * ln1myd) * log(1.0 - yd / w) + 6.0 * ln1pyd * log(1.0 - yd / w) - 4.0 * log(1.0 - w) * log((w - w * yd) / (w - yd)) + log(1.0 - power_of<2>(w) / yd2) * ((-4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv))) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), -ydinv) * trilog((1.0 - yd) / ((-1.0 + w) * yd)) * my_sign(-imag(w / yd))
                + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * trilog(-(((-1.0 + w) * yd) / (-1.0 + yd))) * my_sign(-imag(w / yd)) - (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(-1.0 + 2.0 / w) * my_sign(-imag(w / yd)) + (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(winv) * my_sign(-imag(w / yd)) - (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(w) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(-imag(w / yd)) + (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(-((-2.0 + w) * w)) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(-imag(w / yd))
                - 4.0 * pisqu * H2(-w, -(w / yd)) * H2(-(w / yd), -ydinv) * my_HT(-r(-w, -(w / yd)) + r(-(w / yd), -ydinv)) * power_of<2>(log((1.0 - yd) / ((-1.0 + w) * yd))) * my_sign(-imag(w)) * my_sign(-imag(w / yd)) - 4.0 * pisqu * H2(ydinv, -(w / yd)) * H2(-(w / yd), -ydinv) * my_HT(-r(ydinv, -(w / yd)) + r(-(w / yd), -ydinv)) * power_of<2>(log((1.0 + w) / (1.0 - w))) * my_sign(imydinv) * my_sign(-imag(w / yd)) + trilog(-(((-1.0 + w) * (1.0 + yd)) / yd)) * ((-4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd)))
                + dilog(-(((-1.0 + w) * (1.0 + yd)) / yd)) * log(1.0 - ydinv * ydinv) * ((4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd))) + trilog((2.0 * yd) / (-1.0 + yd)) * (-2.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) + 2.0 * log(w / (-1.0 + w)) - 2.0 * log(1.0 / (1.0 + w)) - 8.0 * log(1.0 / (1.0 - yd)) + 8.0 * log(1.0 - yd / w) + 4.0 * log((w - yd) / (w - w * yd)) + 4.0 * log((w + yd) / (w - w * yd)) + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(-imag(w / yd)))
                + trilog(yd / (-1.0 + yd)) * (8.0 * lnhalf + 4.0 * log(1.0 - w) - 2.0 * log(w / (-1.0 + w)) + 6.0 * log(1.0 / (1.0 + w)) + 12.0 * log(1.0 / (1.0 - yd)) + 2.0 * ln1pyd - 4.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(-imag(w / yd))) + power_of<2>(log((1.0 + yd) / w)) * ((4.0 * 1.0i) * M_PI * H1(w, -(w / yd)) * ln2 * my_sign(-imag(w / yd)) + (6.0 * 1.0i) * M_PI * H1(w, -(w / yd)) * log(1.0 + winv) * my_sign(-imag(w / yd)))
                + power_of<2>(log((1.0 + winv) * yd)) * ((-2.0 * 1.0i) * M_PI * H1(w / yd, -ydinv) * ln2 * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H1(ydinv, -(w / yd)) * ln2 * my_sign(-imag(w / yd)) + (2.0 * 1.0i) * M_PI * H1(ydinv, -(w / yd)) * log(1.0 - w) * my_sign(-imag(w / yd))) + power_of<2>(log((-1.0 + yd) / w)) * ((-2.0 * 1.0i) * M_PI * H1(-w, -(w / yd)) * log(1.0 - w) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H1(-w, -(w / yd)) * log((-1.0 + w) / w) * my_sign(-imag(w / yd)))
                + dilog(yd / (-1.0 + yd)) * (-2.0 * pisqu + 4.0 * dilog(1.0 + winv) + 8.0 * dilog((-1.0 + w) / w) - 4.0 * dilog((2.0 * yd) / (-1.0 + yd)) + 4.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 3.0 * dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) + 2.0 * dilog((1.0 + yd) / (-1.0 + yd)) - dilog((w + yd) / (-1.0 + yd)) - 4.0 * log(1.0 - w) * log(w) - 4.0 * log(yd / w) * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * log((w + yd) / (-1.0 + yd)) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) * my_sign(-imag(w / yd)))
                + dilog((2.0 * yd) / (-1.0 + yd)) * (2.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) + dilog((w + yd) / (-1.0 + yd)) + 2.0 * ln2 * log(1.0 + winv) - 2.0 * ln2 * log(1.0 - w) - 2.0 * ln2 * log(w / (-1.0 + w)) + 2.0 * ln2 * log(1.0 / (1.0 + w)) - 4.0 * ln2 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * log((w + yd) / (-1.0 + yd)) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) * my_sign(-imag(w / yd)))
                + log((1.0 + yd) / (1.0 - yd)) * (ln2squ * log(1.0 + winv) - ln2squ * log(1.0 - w) - ln2squ * log(w / (-1.0 + w)) + ln2squ * log(1.0 / (1.0 + w)) - 2.0 * ln2squ * log(1.0 - yd / w) - (2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * power_of<2>(log((w + yd) / (-1.0 + yd))) * my_sign(-imag(winv)) + (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(((1.0 + w) * yd) / (w * (-1.0 + yd)))) * my_sign(-imag(w / yd)))
                + dilog(1.0 + ydinv) * (4.0 * power_of<2>(ln1pyd) + ln1pyd * (6.0 * ln2 + 4.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 2.0 * log(1.0 + w) - 8.0 * ln1myd - 10.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w)) + 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd)) + 8.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) + log(1.0 - ydinv * ydinv) * ((-4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd)))) - (4.0 * 1.0i) * M_PI * H2(w / yd, ydinv) * trilog((1.0 + yd) / (yd - w * yd)) * my_sign(imag(w / yd))
                + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * trilog((yd - w * yd) / (1.0 + yd)) * my_sign(imag(w / yd)) - (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(-1.0 + 2.0 / w) * my_sign(imag(w / yd)) + (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log(1.0 - winv * winv)) * log(winv) * my_sign(imag(w / yd)) - (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(w) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(imag(w / yd)) + (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(-((-2.0 + w) * w)) * power_of<2>(log(1.0 - power_of<2>(w))) * my_sign(imag(w / yd))
                - 4.0 * pisqu * H2(-w, w / yd) * H2(w / yd, ydinv) * my_HT(-r(-w, w / yd) + r(w / yd, ydinv)) * power_of<2>(log((1.0 + yd) / (yd - w * yd))) * my_sign(-imag(w)) * my_sign(imag(w / yd)) - 4.0 * pisqu * H2(-ydinv, w / yd) * H2(w / yd, ydinv) * my_HT(-r(-ydinv, w / yd) + r(w / yd, ydinv)) * power_of<2>(log((1.0 + w) / (1.0 - w))) * my_sign(-imydinv) * my_sign(imag(w / yd)) + trilog(-(((-1.0 + w) * (-1.0 + yd)) / yd)) * ((-4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd)))
                + dilog(-(((-1.0 + w) * (-1.0 + yd)) / yd)) * log(1.0 - ydinv * ydinv) * ((4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd))) + trilog(power_of<2>(-1.0 + w)) * ((-4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(imag(w / yd)))
                + trilog((1.0 - w) / (1.0 + w)) * (-4.0 * ln1myd - 4.0 * ln1pyd - 2.0 * log((w * (1.0 + yd)) / (w + yd)) + 2.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w) - 2.0 * log((w - w * yd) / (w - yd)) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(imag(w / yd)))
                + trilog((2.0 * yd) / (1.0 + yd)) * (-2.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) + 2.0 * log(w / (-1.0 + w)) - 2.0 * log(1.0 / (1.0 + w)) - 8.0 * log(1.0 / (1.0 + yd)) + 8.0 * log((w + yd) / w) + 4.0 * log((w - yd) / (w + w * yd)) + 4.0 * log((w + yd) / (w + w * yd)) + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(imag(w / yd)))
                + trilog(2.0 - 2.0 / w) * ((4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(imydinv) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(imag(w / yd))) + trilog(yd / (1.0 + yd)) * (8.0 * lnhalf + 4.0 * log(1.0 - w) - 2.0 * log(w / (-1.0 + w)) + 6.0 * log(1.0 / (1.0 + w)) + 2.0 * ln1myd + 12.0 * log(1.0 / (1.0 + yd)) - 4.0 * log((w + yd) / w) - (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd))
                + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(imag(w / yd))) + trilog((1.0 + w) / (1.0 - w)) * (8.0 * log(w / (-1.0 + w)) - 2.0 * ln1myd - 4.0 * log((w - yd) / (-1.0 + w)) - 2.0 * ln1pyd - 4.0 * log((w + yd) / (-1.0 + w)) + 4.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), -ydinv) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(w / yd, ydinv) * my_sign(imag(w / yd)))
                + dilog(2.0 - 2.0 / w) * ((-4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log(1.0 - winv * winv) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(1.0 - winv * winv) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(1.0 - winv * winv) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log(1.0 - winv * winv) * my_sign(imag(w / yd)))
                + dilog((-1.0 + w) / w) * (-8.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 8.0 * dilog(yd / (1.0 + yd)) - 8.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) - 4.0 * ln2 * log(1.0 - w) - 4.0 * log(1.0 - w) * log(1.0 + w) - 6.0 * log(1.0 - w) * ln1myd - 6.0 * log(1.0 - w) * ln1pyd + (4.0 * log(1.0 - w) - 4.0 * log((1.0 + yd) / (1.0 - w))) * log((w + yd) / w) + (4.0 * log(1.0 - w) - 4.0 * log((-1.0 + yd) / (-1.0 + w))) * log(1.0 - yd / w) - 8.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) - 8.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd))
                + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log(1.0 - winv * winv) * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(1.0 - winv * winv) * my_sign(imydinv) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * log(1.0 - winv * winv) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log(1.0 - winv * winv) * my_sign(imag(w / yd))) + power_of<2>(log((1.0 - yd) / w)) * ((4.0 * 1.0i) * M_PI * H1(w, w / yd) * ln2 * my_sign(imag(w / yd)) + (6.0 * 1.0i) * M_PI * H1(w, w / yd) * log(1.0 + winv) * my_sign(imag(w / yd)))
                + power_of<2>(log(-(((1.0 + w) * yd) / w))) * ((-2.0 * 1.0i) * M_PI * H1(-(w / yd), ydinv) * ln2 * my_sign(imydinv) + (4.0 * 1.0i) * M_PI * H1(-ydinv, w / yd) * ln2 * my_sign(imag(w / yd)) + (2.0 * 1.0i) * M_PI * H1(-ydinv, w / yd) * log(1.0 - w) * my_sign(imag(w / yd))) + power_of<2>(log(-((1.0 + yd) / w))) * ((-2.0 * 1.0i) * M_PI * H1(-w, w / yd) * log(1.0 - w) * my_sign(imag(w / yd)) + (4.0 * 1.0i) * M_PI * H1(-w, w / yd) * log((-1.0 + w) / w) * my_sign(imag(w / yd)))
                + dilog(1.0 - w) * (4.0 * dilog(((-1.0 + w) * yd) / (w - yd)) - 4.0 * dilog(yd / (w + yd)) + 4.0 * dilog((yd - w * yd) / (w + yd)) + 8.0 * ln2 * log((-1.0 + w) / w) + 8.0 * log(1.0 + winv) * log((-1.0 + w) / w) + ln1myd * (-8.0 * log((-1.0 + w) / w) - 4.0 * log((w - yd) / (-1.0 + w))) + 4.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) + ln1pyd * (-8.0 * log((-1.0 + w) / w) - 4.0 * log((w + yd) / (-1.0 + w))) + 4.0 * log((-1.0 + w) / w) * log((w + yd) / w) + 4.0 * log((-1.0 + w) / w) * log(1.0 - yd / w) + 4.0 * log(1.0 - w) * log((w - w * yd) / (w - yd))
                - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(1.0 - power_of<2>(w)) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(1.0 - power_of<2>(w)) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(1.0 - power_of<2>(w)) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(1.0 - power_of<2>(w)) * my_sign(imag(w / yd)))
                + dilog(power_of<2>(-1.0 + w)) * ((4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(1.0 - power_of<2>(w)) * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(1.0 - power_of<2>(w)) * my_sign(imydinv) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * log(1.0 - power_of<2>(w)) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * log(1.0 - power_of<2>(w)) * my_sign(imag(w / yd)))
                + dilog(yd / (1.0 + yd)) * (-2.0 * pisqu + 2.0 * dilog((-1.0 + yd) / (1.0 + yd)) - 4.0 * dilog((2.0 * yd) / (1.0 + yd)) + 4.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) - dilog((-w + yd) / (1.0 + yd)) + 3.0 * dilog((yd + w * yd) / (w + w * yd)) - 4.0 * log(1.0 - w) * log(w) - 4.0 * log(-(yd / w)) * log((w + yd) / w) + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * log((-w + yd) / (1.0 + yd)) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log((yd + w * yd) / (w + w * yd)) * my_sign(imag(w / yd)))
                + dilog((2.0 * yd) / (1.0 + yd)) * (2.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + dilog((-w + yd) / (1.0 + yd)) + dilog((yd + w * yd) / (w + w * yd)) + 2.0 * ln2 * log(1.0 + winv) - 2.0 * ln2 * log(1.0 - w) - 2.0 * ln2 * log(w / (-1.0 + w)) + 2.0 * ln2 * log(1.0 / (1.0 + w)) - 4.0 * ln2 * log((w + yd) / w) - (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * log((-w + yd) / (1.0 + yd)) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * log((yd + w * yd) / (w + w * yd)) * my_sign(imag(w / yd)))
                + log((1.0 - yd) / (1.0 + yd)) * (ln2squ * log(1.0 + winv) - ln2squ * log(1.0 - w) - ln2squ * log(w / (-1.0 + w)) + ln2squ * log(1.0 / (1.0 + w)) - 2.0 * ln2squ * log((w + yd) / w) - (2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * power_of<2>(log((-w + yd) / (1.0 + yd))) * my_sign(-imag(winv)) + (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log((yd + w * yd) / (w + w * yd))) * my_sign(imag(w / yd)))
                + power_of<2>(log(1.0 - ydinv * ydinv)) * (log((-1.0 + w + w * yd) / yd) * ((2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) + (2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd))) + log((1.0 + w * (-1.0 + yd)) / yd) * ((2.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) + (2.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd)))) + dilog((-1.0 + yd) / yd) * (4.0 * power_of<2>(ln1myd) + ln1myd * (6.0 * ln2 + 4.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 2.0 * log(1.0 + w) - 8.0 * ln1pyd + 2.0 * log((w + yd) / w) - 10.0 * log(1.0 - yd / w)) + 8.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd))
                + 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd)) + log(1.0 - ydinv * ydinv) * ((-4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) - (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd)))) + (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - w), (w - yd) / ((-1.0 + w) * yd)) * log(1.0 - w) * power_of<2>(log(-(((-1.0 + w) * w) / (w - yd)))) * my_sign(imag((w - yd) / ((-1.0 + w) * yd))) - (8.0 * 1.0i) * M_PI * H1(w / (-1.0 + w), (w * (-1.0 + yd)) / ((-1.0 + w) * yd)) * log((-1.0 + w) / w) * power_of<2>(log((1.0 - w) / (w * (-1.0 + yd)))) * my_sign(imag((w * (-1.0 + yd)) / ((-1.0 + w) * yd)))
                - (4.0 * 1.0i) * M_PI * H1(w / (1.0 + w), (w * (-1.0 + yd)) / ((1.0 + w) * yd)) * log(1.0 + winv) * power_of<2>(log((1.0 + w) / (w - w * yd))) * my_sign(imag((w * (-1.0 + yd)) / ((1.0 + w) * yd))) - (8.0 * 1.0i) * M_PI * H1(w / (-1.0 + w), (w * (1.0 + yd)) / ((-1.0 + w) * yd)) * log((-1.0 + w) / w) * power_of<2>(log((-1.0 + w) / (w * (1.0 + yd)))) * my_sign(imag((w * (1.0 + yd)) / ((-1.0 + w) * yd))) + (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - w), (w + yd) / (yd - w * yd)) * log(1.0 - w) * power_of<2>(log(-(((-1.0 + w) * w) / (w + yd)))) * my_sign(imag((w + yd) / (yd - w * yd)))
                - (4.0 * 1.0i) * M_PI * H1(w / (1.0 + w), (w + w * yd) / (yd + w * yd)) * log(1.0 + winv) * power_of<2>(log((1.0 + w) / (w + w * yd))) * my_sign(imag((w + w * yd) / (yd + w * yd))) + (4.0 * 1.0i) * M_PI * trilog((-w + yd) / (2.0 * yd)) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log(1.0 - w / yd) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log(1.0 - w / yd)) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd)
                + trilog(-((w - yd) / (yd + w * yd))) * (-4.0 * ln2 - 4.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * ln1pyd + (4.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd)) + trilog(1.0 - w / yd) * (8.0 * ln2 + 6.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 6.0 * ln1myd - 10.0 * ln1pyd + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv) - (8.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd))
                + power_of<2>(log(1.0 - w / yd)) * ((2.0 * 1.0i) * M_PI * lnhalf * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) + (2.0 * 1.0i) * M_PI * log(w / (1.0 + w)) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd)) + (4.0 * 1.0i) * M_PI * trilog((w + yd) / (2.0 * yd)) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log((w + yd) / yd) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log((w + yd) / yd)) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd)
                + dilog(-w) * (2.0 * dilog((1.0 - yd) / 2.0) - 4.0 * dilog(-yd) - 4.0 * dilog(yd) - 2.0 * dilog(-(yd / (w - yd))) + 2.0 * dilog(((-1.0 + w) * yd) / (w - yd)) + 2.0 * dilog((1.0 + yd) / 2.0) - 2.0 * dilog(yd / (w + yd)) + 2.0 * dilog((yd - w * yd) / (w + yd)) + 2.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) - 4.0 * ln2 * log((w + yd) / w) + ln1pyd * (2.0 * ln2 + 2.0 * log((1.0 - yd) / 2.0) + 2.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) - 4.0 * ln2 * log(1.0 - yd / w) + ln1myd * (2.0 * ln2 + 2.0 * log((1.0 + yd) / 2.0) - 4.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w))
                + 2.0 * log(1.0 - w) * log((w - w * yd) / (w - yd)) + (4.0 * 1.0i) * M_PI * log(1.0 - w / yd) * my_sign(imag(winv)) * T(1.0, 1.0 - w, 1.0 - w / yd) + (4.0 * 1.0i) * M_PI * log((w + yd) / yd) * my_sign(imag(winv)) * T(1.0, 1.0 - w, (w + yd) / yd)) + trilog(1.0 / (1.0 + w)) * (-8.0 * lnhalf + 4.0 * ln2 + 8.0 * log(1.0 + winv) + 16.0 * log((1.0 - w) / 2.0) - 24.0 * log(-w) - 16.0 * log((-1.0 + w) / (1.0 + w)) + 6.0 * log((1.0 - yd) / 2.0) - 4.0 * ln1myd + 4.0 * log(-yd) + 4.0 * log(yd) + 4.0 * log(yd / (-1.0 + yd)) + 4.0 * log(yd / (1.0 + yd)) + 6.0 * log((1.0 + yd) / 2.0) - 4.0 * ln1pyd
                + 2.0 * log((w * (1.0 + yd)) / (w + yd)) - 2.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) + 2.0 * log((w - w * yd) / (w - yd)) - (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(imag(w / yd)) - (4.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd)) + trilog((w + yd) / (yd + w * yd)) * (-4.0 * ln2 - 4.0 * log(1.0 + winv) - 2.0 * log(1.0 - w) + 4.0 * ln1myd + (4.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd))
                + trilog((w + yd) / yd) * (8.0 * ln2 + 6.0 * log(1.0 + winv) - 4.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 10.0 * ln1myd - 6.0 * ln1pyd + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) + (4.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd)) + power_of<2>(log((w + yd) / yd)) * ((2.0 * 1.0i) * M_PI * lnhalf * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) + (2.0 * 1.0i) * M_PI * log(w / (1.0 + w)) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd))
                + dilog(1.0 / (1.0 + w)) * ((-22.0 * pisqu) / 3.0 + 8.0 * dilog(-1.0) - 4.0 * dilog(2.0 / (1.0 + w)) + 2.0 * dilog(1.0 / (1.0 - yd)) - 2.0 * dilog((1.0 - yd) / 2.0) + 2.0 * dilog((1.0 - yd) / (1.0 + w)) - 4.0 * dilog(-yd) - 4.0 * dilog(yd) - dilog(-(yd / (w - yd))) + 2.0 * dilog(((-1.0 + w) * yd) / (w - yd)) + 2.0 * dilog(1.0 / (1.0 + yd)) - 2.0 * dilog((1.0 + yd) / 2.0) + 2.0 * dilog((1.0 + yd) / (1.0 + w)) - dilog(yd / (w + yd)) + 2.0 * dilog((yd - w * yd) / (w + yd)) - 8.0 * log(1.0 + winv) * log(-winv) - 6.0 * power_of<2>(log(-1.0 / (1.0 + w))) - 4.0 * log(1.0) * log(yd)
                + ln1myd * (-4.0 * lnhalf + 4.0 * log(yd) - 2.0 * log((1.0 + yd) / 2.0)) + (-4.0 * lnhalf - 2.0 * log((1.0 - yd) / 2.0)) * ln1pyd + log(-yd) * (-4.0 * log(1.0) + 4.0 * ln1pyd) + 2.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) + 2.0 * log(1.0 - w) * log((w - w * yd) / (w - yd)) - (4.0 * 1.0i) * M_PI * log(1.0 - w / yd) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * log((w + yd) / yd) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd))
                - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * power_of<2>(log((w + yd) / (w - w * yd))) * my_sign(imag(((1.0 + w) * yd) / (w - w * yd))) * T(1.0, -winv, (w + yd) / (w - w * yd)) + power_of<2>(log((w - yd) / (w + w * yd))) * (2.0 * log(1.0 + winv) * log((w + w * yd) / (yd + w * yd)) - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag((yd + w * yd) / (w + w * yd))) * T(1.0, -winv, (w - yd) / (w + w * yd))) - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * power_of<2>(log((w - yd) / (w - w * yd))) * my_sign(-imag(((-1.0 + w) * yd) / (w * (-1.0 + yd)))) * T(1.0, winv, (w - yd) / (w - w * yd))
                - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * power_of<2>(log((w + yd) / (w + w * yd))) * my_sign(imag((yd - w * yd) / (w + w * yd))) * T(1.0, winv, (w + yd) / (w + w * yd)) + power_of<3>(log(1.0 + ydinv)) * (((-4.0 * 1.0i) / 3.0) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) - ((8.0 * 1.0i) / 3.0) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)) + trilog((w + w * yd) / (yd + w * yd)) * (2.0 * ln2 + (8.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv) - (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv))
                + trilog((1.0 + yd) / (2.0 * yd)) * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) - 6.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) - (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)) + trilog(1.0 + ydinv) * (-6.0 * ln2 + 2.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) + 8.0 * ln1myd - 4.0 * ln1pyd + 10.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w))
                + (4.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd)) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) + (16.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)) + log(1.0 + ydinv) * (((-4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) - ((8.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv))
                + power_of<2>(log(1.0 + ydinv)) * ((-4.0 * 1.0i) * M_PI * lnhalf * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) - (4.0 * 1.0i) * M_PI * lnhalf * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv) - (4.0 * 1.0i) * M_PI * log(1.0 / (1.0 + w)) * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)) + log(-ydinv) * (-(pisqu * ln2) - (2.0 * pisqu * log(1.0 + winv)) / 3.0 + (pisqu * log(1.0 - w)) / 3.0 - (pisqu * log(1.0 + w)) / 3.0 - (2.0 * pisqu * ln1pyd) / 3.0 + 2.0 * power_of<3>(ln1pyd) + (5.0 * pisqu * log((w + yd) / w)) / 3.0 - (pisqu * log(1.0 - yd / w)) / 3.0
                + power_of<2>(ln1pyd) * (3.0 * ln2 + 2.0 * log(1.0 + winv) - log(1.0 - w) + log(1.0 + w) - 5.0 * log((w + yd) / w) + log(1.0 - yd / w)) + power_of<2>(log(1.0 - ydinv * ydinv)) * ((-2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w)) - (2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * my_sign(-imag(w / yd))) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * my_sign(imag(w / (1.0 + w))) * T(1.0, -winv, -ydinv) - (8.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(-imag(w / (1.0 - w))) * T(1.0, winv, -ydinv)
                + power_of<2>(log(1.0 + ydinv)) * ((4.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv))) + power_of<3>(log((-1.0 + yd) / yd)) * (((-4.0 * 1.0i) / 3.0) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - ((8.0 * 1.0i) / 3.0) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)) + trilog((w * (-1.0 + yd)) / ((1.0 + w) * yd)) * (2.0 * ln2 + (8.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv) - (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd))
                + trilog((-1.0 + yd) / (2.0 * yd)) * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 + w) + 4.0 * log((w + yd) / w) - 6.0 * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)) + trilog((-1.0 + yd) / yd) * (-6.0 * ln2 + 2.0 * log(1.0 - w) + 8.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - 4.0 * ln1myd + 8.0 * ln1pyd - 2.0 * log((w + yd) / w) + 10.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) + (4.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd))
                + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) + (16.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)) + log((-1.0 + yd) / yd) * (((-4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - ((8.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd))
                + power_of<2>(log((-1.0 + yd) / yd)) * ((-4.0 * 1.0i) * M_PI * lnhalf * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * lnhalf * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * log(1.0 / (1.0 + w)) * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)) + log(ydinv) * (-(pisqu * ln2) - (2.0 * pisqu * log(1.0 + winv)) / 3.0 + (pisqu * log(1.0 - w)) / 3.0 - (pisqu * log(1.0 + w)) / 3.0 + (4.0 * pisqu * ln1pyd) / 3.0 - (pisqu * log((w + yd) / w)) / 3.0 + (5.0 * pisqu * log(1.0 - yd / w)) / 3.0
                + power_of<2>(log(1.0 - ydinv * ydinv)) * ((-2.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(-imag(w)) - (2.0 * 1.0i) * M_PI * H2(-w, w / yd) * my_sign(imag(w / yd))) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * my_sign(imag(w / (1.0 + w))) * T(1.0, -winv, ydinv) - (8.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(w / (-1.0 + w))) * T(1.0, winv, ydinv) + power_of<2>(log((-1.0 + yd) / yd)) * ((4.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)))
                + log(-(w / yd)) * ((4.0 * pisqu * ln2) / 3.0 + pisqu * log(1.0 + winv) + (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + (-4.0 * ln2 - 3.0 * log(1.0 + winv) - 2.0 * log((-1.0 + w) / w)) * power_of<2>(log((w + yd) / w)) + ln1pyd * (-pisqu + 3.0 * power_of<2>(log((w + yd) / w))) + power_of<2>(log(1.0 - power_of<2>(w) / yd2)) * ((-2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imag(winv)) - (2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * my_sign(-imydinv)) - (4.0 * 1.0i) * M_PI * power_of<2>(log((w + yd) / yd)) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * my_sign(-imag(1.0 / (1.0 - w))) * T(1.0, w, -(w / yd)))
                + log(w / yd) * ((4.0 * pisqu * ln2) / 3.0 + pisqu * log(1.0 + winv) + (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + (-4.0 * ln2 - 3.0 * log(1.0 + winv) - 2.0 * log((-1.0 + w) / w)) * power_of<2>(log(1.0 - yd / w)) + ln1pyd * (-pisqu + 2.0 * power_of<2>(log((w - yd) / (1.0 + w))) + 3.0 * power_of<2>(log(1.0 - yd / w))) + power_of<2>(log(1.0 - power_of<2>(w) / yd2)) * ((-2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(-imag(winv)) - (2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * my_sign(imydinv)) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w / yd)) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * my_sign(imag(1.0 / (-1.0 + w))) * T(1.0, w, w / yd))
                + power_of<2>(log((w * (1.0 + yd)) / (w + yd))) * (2.0 * log(1.0 - w) * log((w + yd) / (-1.0 + w)) - 2.0 * log(1.0 - w) * log((w + yd) / (yd - w * yd)) - (4.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag((yd - w * yd) / (w + yd))) * T(1.0, w, (w * (1.0 + yd)) / (w + yd))) - (4.0 * 1.0i) * M_PI * log(1.0 - w) * power_of<2>(log((w - w * yd) / (w - yd))) * my_sign(imag(((-1.0 + w) * yd) / (w - yd))) * T(1.0, w, (w - w * yd) / (w - yd)) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log(1.0 - w) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) + (4.0 * 1.0i) * M_PI * lnhalf * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w)
                - (2.0 * 1.0i) * M_PI * log(1.0 + winv) * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * log(w) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * lnhalf * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * ln2 * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (12.0 * 1.0i) * M_PI * log(-w) * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w)
                - (4.0 * 1.0i) * M_PI * power_of<3>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + trilog((1.0 + w) / (1.0 + yd)) * (2.0 * ln1myd + 4.0 * ln1pyd + (8.0 * 1.0i) * M_PI * H2(w, -(w / yd)) * my_sign(imag(w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w)) + log(yd) * (-2.0 * power_of<2>(log(1.0)) * log(w / (1.0 + w)) - 2.0 * power_of<2>(log((-1.0 + yd) / (-1.0 + w))) * log(1.0 - yd / w) - 2.0 * log(1.0 - w) * power_of<2>(log((w - w * yd) / (w - yd))) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w)) - (4.0 * 1.0i) * M_PI * trilog((w + yd) / (2.0 * w)) * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)
                + trilog((1.0 - yd) / 2.0) * (4.0 * log(1.0 + winv) + 8.0 * log((1.0 - w) / 2.0) + 4.0 * log((-1.0 + w) / w) - 8.0 * log((-1.0 + w) / (1.0 + w)) - 2.0 * log(w / (1.0 + w)) - 2.0 * log(1.0 + w) - 4.0 * log((w - yd) / (-1.0 + w)) + 8.0 * ln1pyd + 2.0 * log(yd / (w + yd)) - 4.0 * log((w + yd) / w) - 4.0 * log((w + yd) / (1.0 + w)) + 2.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w))
                + log((1.0 + yd) / 2.0) * (ln1pyd * (-2.0 * power_of<2>(log((-1.0 + yd) / (-1.0 + w))) - 4.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w)) - (6.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * power_of<2>(log((w + yd) / w)) * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)) + dilog((1.0 - yd) / 2.0) * (-5.0 * dilog((1.0 - yd) / (1.0 + w)) - 2.0 * dilog((-1.0 + yd) / (-1.0 + w)) + 6.0 * dilog(-(yd / w)) + 12.0 * dilog(yd / w) + 2.0 * dilog(w / (w + yd)) - dilog((w - w * yd) / (w + yd)) - 4.0 * log((-1.0 + yd) / (-1.0 + w)) * ln1pyd + 4.0 * ln1pyd * log(1.0 - yd / w)
                - (4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * log((w + yd) / w) * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w) + ln1myd * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(w / (1.0 + w)) + 2.0 * log(1.0 + w) - 2.0 * log(yd / (w + yd)) + 8.0 * log((w + yd) / w) - 6.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)))
                + power_of<2>(log(-yd)) * ln1pyd * (2.0 * log((w * (1.0 + yd)) / (w - yd)) - 2.0 * log(w / (w + yd)) + 2.0 * log((w * (1.0 + yd)) / (w + yd)) - 4.0 * log(1.0 - yd / w) + 4.0 * log((w - yd) / (w + w * yd)) - (4.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, (w - yd) / (1.0 + w), -yd)) + power_of<2>(log((1.0 + yd) / (1.0 - w))) * (-2.0 * log((-1.0 + w) / (w + yd)) * log((w + yd) / w) + log((w + yd) / w) * (2.0 * log((yd - w * yd) / (w + yd)) - (4.0 * 1.0i) * M_PI * my_sign(imag((w + yd) / (-1.0 + w))) * T(1.0, -(yd / w), (1.0 + yd) / (1.0 - w))))
                - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + yd) / (-1.0 + w))) * log(1.0 - yd / w) * my_sign(imag((w - yd) / (-1.0 + w))) * T(1.0, yd / w, (-1.0 + yd) / (-1.0 + w)) + (4.0 * 1.0i) * M_PI * power_of<2>(log((w - yd) / (-1.0 + w))) * ln1pyd * my_sign(imag((-1.0 + yd) / (-1.0 + w))) * T(1.0, (1.0 + yd) / 2.0, (w - yd) / (-1.0 + w)) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log(1.0 - w) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) + (4.0 * 1.0i) * M_PI * lnhalf * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) - (2.0 * 1.0i) * M_PI * log(1.0 + winv) * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w)
                + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * log(w) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) + trilog(1.0 - w) * (-8.0 * ln2 - 8.0 * log(1.0 + winv) + 4.0 * ln1myd + 4.0 * log(w / (w - yd)) + 4.0 * ln1pyd + 4.0 * log(w / (w + yd)) + 4.0 * log((w * (1.0 + yd)) / (w + yd)) - 8.0 * log((w + yd) / w) - 8.0 * log(1.0 - yd / w) + 4.0 * log((w - w * yd) / (w - yd)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(imydinv)
                + (4.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * my_sign(-imag(w / yd)) + (4.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * my_sign(imag(w / yd)) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w)) + trilog((1.0 - w) / 2.0) * (-2.0 * ln1myd - 2.0 * ln1pyd - 2.0 * log((w * (1.0 + yd)) / (w + yd)) - 2.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) - 2.0 * log((w - w * yd) / (w - yd)) + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w))
                + dilog((1.0 - w) / 2.0) * (2.0 * dilog(yd) - dilog(((-1.0 + w) * yd) / (w - yd)) - dilog((yd - w * yd) / (w + yd)) + 2.0 * log(1.0 - w) * log((w + yd) / w) + 2.0 * log(1.0 - w) * log(1.0 - yd / w) + ln1pyd * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 4.0 * log(w / (-1.0 + w)) + 4.0 * log((w - yd) / (-1.0 + w)) + 4.0 * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w))
                + ln1myd * (-2.0 * log(1.0 - w) + 4.0 * log((-1.0 + w) / w) - 4.0 * log(w / (-1.0 + w)) + 4.0 * log((w + yd) / (-1.0 + w)) + 4.0 * log((w + yd) / w) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w))) - ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * lnhalf * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * ln2 * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (12.0 * 1.0i) * M_PI * log(-w) * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)
                - (4.0 * 1.0i) * M_PI * power_of<3>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + trilog((1.0 + w) / (1.0 - yd)) * (4.0 * ln1myd + 2.0 * ln1pyd + (8.0 * 1.0i) * M_PI * H2(w, w / yd) * my_sign(imag(w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)) + li3half * (-8.0 * log(1.0 + winv) - 16.0 * log((1.0 - w) / 2.0) - 8.0 * log((-1.0 + w) / w) + 16.0 * log((-1.0 + w) / (1.0 + w)) + 4.0 * log(w / (1.0 + w)) + 4.0 * log(1.0 + w) - 16.0 * ln1myd + 4.0 * log((w - yd) / (-1.0 + w)) + 4.0 * log((w - yd) / (1.0 + w)) - 2.0 * log(-(yd / (w - yd))) - 16.0 * ln1pyd - 2.0 * log(yd / (w + yd))
                + 2.0 * log((w * (1.0 + yd)) / (w + yd)) + 4.0 * log((w + yd) / (-1.0 + w)) - 12.0 * log((w + yd) / w) + 4.0 * log((w + yd) / (1.0 + w)) - 12.0 * log(1.0 - yd / w) - 4.0 * log((w - yd) / (w - w * yd)) - 4.0 * log((w + yd) / (w - w * yd)) + 2.0 * log((w - w * yd) / (w - yd)) - 4.0 * log((w - yd) / (w + w * yd)) - 4.0 * log((w + yd) / (w + w * yd)) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd)
                - (4.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv) + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w))
                + trilog((1.0 + w) / 2.0) * (4.0 * lnhalf - 2.0 * log((1.0 - yd) / 2.0) + 2.0 * ln1myd - 2.0 * log((1.0 + yd) / 2.0) + 2.0 * ln1pyd - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w) + (12.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (12.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)) + dilog(1.0 + w) * (-4.0 * pisqu - 4.0 * dilog(1.0 - yd) - 4.0 * dilog(1.0 + yd) - 4.0 * power_of<2>(log(-1.0 - w)) + 8.0 * log(1.0 + winv) * log((-1.0 + w) / w) - 4.0 * log((w - yd) / (1.0 + w)) * ln1pyd - 4.0 * ln1myd * log((w + yd) / (1.0 + w))
                + (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)) + log(-yd) * (-2.0 * power_of<2>(log(1.0)) * log(w / (1.0 + w)) - 2.0 * log(1.0 - w) * power_of<2>(log((w * (1.0 + yd)) / (w + yd))) - 2.0 * power_of<2>(log((1.0 + yd) / (1.0 - w))) * log((w + yd) / w) + power_of<2>(ln1pyd) * (2.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w)) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w))
                + dilog((1.0 + w) / 2.0) * (3.0 * dilog((1.0 - yd) / 2.0) + 3.0 * dilog((1.0 + yd) / 2.0) + 4.0 * log(1.0 + winv) * log((w + yd) / w) + 4.0 * log(1.0 + winv) * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + ln1myd * (-4.0 * log(w / (1.0 + w)) + 2.0 * log(1.0 + w) + 8.0 * log((w + yd) / (1.0 + w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w)) - (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)
                + ln1pyd * (-4.0 * log(w / (1.0 + w)) + 2.0 * log(1.0 + w) + 8.0 * log((w - yd) / (1.0 + w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w))) + li2half * (-2.0 * dilog((-1.0 + w) / (2.0 * w)) - 4.0 * dilog(-w) + 14.0 * dilog(1.0 / (1.0 + w)) - 6.0 * dilog((1.0 + w) / 2.0) - dilog(w / (w - yd)) + 4.0 * dilog((-1.0 + yd) / (-1.0 + w)) - 2.0 * dilog(-yd) - 2.0 * dilog(yd) - 10.0 * dilog(-(yd / w)) - 10.0 * dilog(yd / w) - dilog(-(yd / (w - yd))) + 2.0 * dilog(((-1.0 + w) * yd) / (w - yd)) + 4.0 * dilog(yd / (-1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd)))
                - 4.0 * dilog(((1.0 + w) * yd) / (w * (-1.0 + yd))) + 4.0 * dilog(yd / (1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + 4.0 * dilog((1.0 + yd) / (1.0 - w)) - dilog(w / (w + yd)) - dilog(yd / (w + yd)) + 2.0 * dilog((yd - w * yd) / (w + yd)) - 4.0 * dilog((yd + w * yd) / (w + w * yd)) - 4.0 * log((w - yd) / (-1.0 + w)) * ln1pyd + 2.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) - 4.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) - 4.0 * log(1.0 + winv) * log((w + yd) / (w - w * yd)) + 2.0 * log(1.0 - w) * log((w - w * yd) / (w - yd))
                - 4.0 * log(1.0 + winv) * log((w - yd) / (w + w * yd)) - 4.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) - (4.0 * 1.0i) * M_PI * log(1.0 - w / yd) * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * log((w + yd) / yd) * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) + log(1.0 + ydinv) * ((8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv))
                + log((-1.0 + yd) / yd) * ((8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd)) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) + ln1myd * (4.0 * log(1.0 / (1.0 - w)) + 4.0 * log(w / (-1.0 + w)) + 4.0 * log(w / (1.0 + w)) + 4.0 * log((w - yd) / (-1.0 + w)) - 4.0 * log((w + yd) / (-1.0 + w)) - 4.0 * log((w + yd) / w) - 4.0 * log((w + yd) / (1.0 + w)) + (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w)
                    + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w)) + ln1pyd * (4.0 * log(1.0 / (1.0 - w)) + 4.0 * log(w / (-1.0 + w)) + 4.0 * log(w / (1.0 + w)) - 4.0 * log((w - yd) / (1.0 + w)) + 4.0 * log((w + yd) / (-1.0 + w)) - 4.0 * log(1.0 - yd / w) + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) + (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w)))
                + dilog(-1.0) * (-4.0 * dilog((1.0 - yd) / (1.0 + w)) + 4.0 * dilog(w / (w - yd)) - 2.0 * dilog(-yd) - 2.0 * dilog(yd) + 8.0 * dilog(-(yd / w)) + 8.0 * dilog(yd / w) + 2.0 * dilog(-(yd / (w - yd))) - 2.0 * dilog(((-1.0 + w) * yd) / (w - yd)) + 4.0 * dilog(yd / (-1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 4.0 * dilog(yd / (1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) - 4.0 * dilog((1.0 + yd) / (1.0 + w)) + 4.0 * dilog(w / (w + yd)) + 2.0 * dilog(yd / (w + yd)) - 4.0 * dilog((w * (1.0 + yd)) / (w + yd)) - 4.0 * dilog((w - w * yd) / (w - yd))
                - 2.0 * dilog((yd - w * yd) / (w + yd)) - 2.0 * log(1.0 - w) * log((w * (1.0 + yd)) / (w + yd)) + ln1myd * (-4.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 - w)) + 8.0 * log(1.0 - w) + 4.0 * log(1.0 + w) - 4.0 * log(((-1.0 + w) * yd) / (w - yd)) + 4.0 * log((w + yd) / w) - 4.0 * log((w + yd) / (1.0 + w)) + 2.0 * log(1.0 - yd / w)) - 4.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) - 2.0 * log(1.0 - w) * log((w - w * yd) / (w - yd))
                + ln1pyd * (-4.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 - w)) + 8.0 * log(1.0 - w) + 4.0 * log(1.0 + w) - 4.0 * log((w - yd) / (1.0 + w)) + 2.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w) - 4.0 * log((yd - w * yd) / (w + yd))) - 4.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) - (4.0 * 1.0i) * M_PI * log(1.0 - w / yd) * my_sign(imag(winv)) * T(1.0, 1.0 - w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * log((w + yd) / yd) * my_sign(imag(winv)) * T(1.0, 1.0 - w, (w + yd) / yd) - (8.0 * 1.0i) * M_PI * log(1.0 + ydinv) * my_sign(imag(w)) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)
                - (8.0 * 1.0i) * M_PI * log((-1.0 + yd) / yd) * my_sign(imag(w)) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) - (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(imydinv) * T(1.0, 1.0 - yd, 1.0 + w) + log(1.0 - yd / w) * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 - yd, 1.0 - yd / w)) - (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imydinv) * T(1.0, 1.0 + yd, 1.0 + w) + log((w + yd) / w) * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) - 2.0 * log(1.0 + w) - (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + yd, (w + yd) / w)))
                - (4.0 * 1.0i) * M_PI * trilog((w - yd) / (2.0 * w)) * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w) + trilog((1.0 + yd) / 2.0) * (4.0 * log(1.0 + winv) + 8.0 * log((1.0 - w) / 2.0) + 4.0 * log((-1.0 + w) / w) - 8.0 * log((-1.0 + w) / (1.0 + w)) - 2.0 * log(w / (1.0 + w)) - 2.0 * log(1.0 + w) + 8.0 * ln1myd - 4.0 * log((w - yd) / (1.0 + w)) + 2.0 * log(-(yd / (w - yd))) - 4.0 * log((w + yd) / (-1.0 + w)) + 2.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w))
                + log((1.0 - yd) / 2.0) * ((-6.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - yd / w)) * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w)) + dilog((1.0 + yd) / 2.0) * (-2.0 * dilog((1.0 + yd) / (1.0 - w)) - 5.0 * dilog((1.0 + yd) / (1.0 + w)) - dilog((w * (1.0 + yd)) / (w - yd)) + ln1myd * (-4.0 * log((1.0 + yd) / (1.0 - w)) + 4.0 * log((w + yd) / w)) - (4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * log(1.0 - yd / w) * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w)
                + ln1pyd * (-4.0 * log(1.0 + winv) - 4.0 * log((-1.0 + w) / w) + 2.0 * log(w / (1.0 + w)) + 2.0 * log(1.0 + w) - 2.0 * log(-(yd / (w - yd))) - 6.0 * log((w + yd) / w) + 8.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w))) + power_of<2>(log(w / (w + yd))) * ((-2.0 * pisqu) / 3.0 - (4.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(-imag(yd / (w + yd))) * T(1.0, (w * (1.0 + yd)) / (w + yd), w / (w + yd))) + (4.0 * 1.0i) * M_PI * ln2 * power_of<2>(log(1.0 + winv)) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv)
                + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * log(1.0 - w) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) + (4.0 * 1.0i) * M_PI * trilog((1.0 - w) / (w * (-1.0 + yd))) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) - (4.0 * 1.0i) * M_PI * log(winv) * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w)
                + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * log(1.0 / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + trilog(1.0 / (1.0 - yd)) * (-6.0 * ln2 - 2.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log(1.0 + w) - 4.0 * log((w - yd) / (1.0 + w)) + 8.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - w)) - 4.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) + (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w))
                + dilog(1.0 / (1.0 - yd)) * (-4.0 * dilog(winv) - 2.0 * dilog(-yd) + 4.0 * dilog(yd / w) - 4.0 * dilog((1.0 + yd) / (1.0 + w)) + 2.0 * dilog((w + yd) / (-1.0 + w)) - 4.0 * log((w - yd) / (1.0 + w)) * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w) + (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w))
                + log(yd / (-1.0 + yd)) * (-(log((1.0 + yd) / (1.0 - w)) * power_of<2>(log((w + yd) / w))) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w)) - (4.0 * 1.0i) * M_PI * trilog(-((w * (-1.0 + yd)) / (-1.0 + w))) * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd)
                + trilog((w + yd) / (-1.0 + w)) * (-4.0 * log(1.0 / (1.0 - w)) + 8.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 / (1.0 + w)) - 16.0 * ln1myd + 2.0 * log(yd / (-1.0 + yd)) + 4.0 * log((w + yd) / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) + (4.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd))
                + dilog((w + yd) / (-1.0 + w)) * ((-2.0 * pisqu) / 3.0 + 4.0 * dilog((w + yd) / w) - dilog((w + yd) / (1.0 + w)) - dilog((w + yd) / (w - w * yd)) + 4.0 * power_of<2>(ln1myd) - 2.0 * power_of<2>(log((w + yd) / w)) - 8.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) + log((w + yd) / w) * (-2.0 * log(1.0 / (1.0 + w)) - 2.0 * log(yd / (-1.0 + yd)) - (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) - (4.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd))
                + ln1myd * (4.0 * log((w + yd) / w) + 8.0 * log((w + yd) / (1.0 + w)) + (4.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd))) + (4.0 * 1.0i) * M_PI * ln2 * power_of<2>(log(1.0 + winv)) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * log(1.0 - w) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv)
                + trilog((1.0 + w) / (-1.0 + w)) * (-4.0 * log(1.0 / (1.0 - w)) + 10.0 * ln1myd + 2.0 * log((-1.0 + yd) / (-1.0 + w)) + 10.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - w)) - 4.0 * log((w + yd) / w) - 4.0 * log(1.0 - yd / w) - (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) - (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv))
                + dilog(w / (-1.0 + w)) * ((4.0 * pisqu) / 3.0 - 4.0 * dilog(-winv) - 2.0 * dilog((2.0 * w) / (-1.0 + w)) - 2.0 * dilog(w / (1.0 + w)) - 2.0 * dilog((1.0 + w) / (-1.0 + w)) - dilog(1.0 / (1.0 - yd)) - 2.0 * dilog((w - yd) / (-1.0 + w)) + 10.0 * dilog(-yd) + 10.0 * dilog(yd) - dilog(1.0 / (1.0 + yd)) - 2.0 * dilog((w + yd) / (-1.0 + w)) - 4.0 * dilog((w + yd) / w) - 4.0 * dilog(1.0 - yd / w) + 8.0 * log(1.0 - w) * log(w) + ln1myd * (-4.0 * log(1.0 / (1.0 + w)) + 4.0 * log((1.0 - yd) / (1.0 + w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv))
                + ln1pyd * (-4.0 * log(1.0 / (1.0 + w)) + 4.0 * log((1.0 + yd) / (1.0 + w)) - (8.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv))) + dilog((1.0 + w) / (-1.0 + w)) * (dilog((w - yd) / (-1.0 + w)) - 4.0 * dilog(-yd) - 4.0 * dilog(yd) + dilog((w + yd) / (-1.0 + w)) - 4.0 * power_of<2>(ln1myd) - 4.0 * power_of<2>(ln1pyd) + 4.0 * log(1.0 + winv) * log((w + yd) / w) + 4.0 * log(1.0 + winv) * log(1.0 - yd / w)
                + ln1myd * (-2.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 + w)) - 4.0 * log((1.0 - yd) / (1.0 + w)) + (8.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv)) + ln1pyd * (-2.0 * log(1.0 + winv) + 4.0 * log(1.0 / (1.0 + w)) - 4.0 * log((1.0 + yd) / (1.0 + w)) + (8.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv))) + (4.0 * 1.0i) * M_PI * trilog((-1.0 + w) / (w * (1.0 + yd))) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + ((4.0 * 1.0i) / 3.0) * power_of<3>(M_PI) * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)
                - (4.0 * 1.0i) * M_PI * log(winv) * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + ((4.0 * 1.0i) / 3.0) * M_PI * power_of<3>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * log(1.0 / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)
                + trilog(1.0 / (1.0 + yd)) * (-6.0 * ln2 - 2.0 * log(1.0 + winv) + 2.0 * log(1.0 - w) - 4.0 * log(1.0 + w) + 8.0 * ln1myd + 2.0 * log((-1.0 + yd) / (-1.0 + w)) - 2.0 * log((w + yd) / w) - 4.0 * log((w + yd) / (1.0 + w)) - 4.0 * log(1.0 - yd / w) + (8.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w))
                + trilog(w / (1.0 + w)) * (-8.0 * ln2 - 4.0 * log(1.0 - w) - 6.0 * ln1myd + 2.0 * log((-1.0 + yd) / (-1.0 + w)) - 2.0 * log((1.0 - yd) / (1.0 + yd)) - 6.0 * ln1pyd + 2.0 * log((1.0 + yd) / (1.0 - w)) - 2.0 * log((1.0 + yd) / (1.0 - yd)) + 4.0 * log((w + yd) / w) + 4.0 * log(1.0 - yd / w) - 4.0 * log((w - yd) / (w - w * yd)) - 4.0 * log((w + yd) / (w + w * yd)) + (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(-imydinv) + (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(imydinv) + (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)
                + (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) - (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)) + trilog((-1.0 + w) / (1.0 + w)) * (-2.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w) + 4.0 * log((w - yd) / (w - w * yd)) + 4.0 * log((w + yd) / (w + w * yd)) + (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + (4.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w))
                + trilog((-1.0 + w) / w) * (4.0 * ln2 + 4.0 * log(1.0 + w) - 8.0 * log(1.0 / (1.0 - yd)) + 6.0 * ln1myd - 8.0 * log(1.0 / (1.0 + yd)) + 6.0 * ln1pyd - 8.0 * log((w + yd) / w) - 8.0 * log(1.0 - yd / w) - 8.0 * log((w - yd) / (w - w * yd)) - 8.0 * log((w + yd) / (w + w * yd)) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(-imydinv) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * my_sign(imag(w / yd)) - (8.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w)
                - (8.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)) + dilog(1.0 / (1.0 + yd)) * (-4.0 * ln1myd * log((w + yd) / (1.0 + w)) + 2.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w) + (8.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w))
                + dilog(w / (1.0 + w)) * (2.0 * dilog((w - yd) / (-1.0 + w)) + 4.0 * dilog(-(yd / w)) + 4.0 * dilog(yd / w) + 3.0 * dilog(yd / (-1.0 + yd)) - 2.0 * dilog((2.0 * yd) / (-1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) + 3.0 * dilog(yd / (1.0 + yd)) - 2.0 * dilog((2.0 * yd) / (1.0 + yd)) - 4.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + 2.0 * dilog((w + yd) / (-1.0 + w)) - 2.0 * ln2 * log((1.0 - yd) / (1.0 + yd)) - 2.0 * ln2 * log((1.0 + yd) / (1.0 - yd)) + 2.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w) + 2.0 * log((-1.0 + yd) / (-1.0 + w)) * log(1.0 - yd / w)
                - 4.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) - 4.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) + (8.0 * 1.0i) * M_PI * log(1.0 + ydinv) * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv) + (8.0 * 1.0i) * M_PI * log((-1.0 + yd) / yd) * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w))
                + log(yd / (1.0 + yd)) * ((-4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)) + dilog(-yd) * (2.0 * dilog((1.0 - w) / 2.0) + 6.0 * dilog(w) + 2.0 * dilog((1.0 - w) / (1.0 + w)) - 2.0 * dilog((2.0 * w) / (1.0 + w)) - 4.0 * dilog(yd) + 2.0 * dilog(-(yd / w)) - 4.0 * dilog(yd / w) - 2.0 * dilog(w / (w + yd)) + 2.0 * dilog((w + yd) / (1.0 + w)) + 2.0 * dilog((w + yd) / (w - w * yd)) + 2.0 * dilog((w - w * yd) / (w + yd)) + 4.0 * ln2 * log(1.0 + winv) + 2.0 * power_of<2>(log(1.0 + winv))
                + 2.0 * log(1.0 + winv) * log(1.0 - w) + 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * log(1.0 + winv) * log(-2.0 / (-1.0 + w)) + 4.0 * ln2 * log((-1.0 + w) / w) + 4.0 * power_of<2>(log((-1.0 + w) / w)) - 2.0 * ln2 * log((1.0 - w) / (1.0 + w)) + 2.0 * log(1.0 - w) * log((2.0 * w) / (1.0 + w)) + 2.0 * log(1.0 - w) * log((1.0 + w) / 2.0) - 2.0 * ln2 * log((1.0 + w) / (-1.0 + w)) + 2.0 * power_of<2>(log((w + yd) / w)) + (8.0 * ln2 - 6.0 * log((-1.0 + yd) / (-1.0 + w))) * log(1.0 - yd / w) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imydinv) * T(1.0, 1.0 - yd, 1.0 - w)
                + (4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(imydinv) * T(1.0, 1.0 - yd, 1.0 + w) + log((w + yd) / w) * (-4.0 * ln2 + 2.0 * log((1.0 - yd) / (1.0 + w)) + 2.0 * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) + (4.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 - yd, (w + yd) / w)) + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, 1.0 + winv)
                + ln1myd * (2.0 * log(1.0 + winv) - 4.0 * log(1.0 + w) - 4.0 * log((w - yd) / (-1.0 + w)) + 2.0 * log(((1.0 + w) * yd) / (w + yd)) - 8.0 * log((w + yd) / w) + 2.0 * log((w + yd) / (1.0 + w)) + 8.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, 1.0 - yd)) - (12.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w))
                + dilog(-winv) * (-8.0 * dilog(1.0 / (1.0 - yd)) + 2.0 * dilog((w - yd) / (-1.0 + w)) - 4.0 * dilog(-yd) - 4.0 * dilog(yd) + 2.0 * dilog(-(yd / w)) + 2.0 * dilog(yd / w) - 6.0 * dilog(yd / (-1.0 + yd)) + 2.0 * dilog((2.0 * yd) / (-1.0 + yd)) + 4.0 * dilog(((-1.0 + w) * yd) / (w * (-1.0 + yd))) - 8.0 * dilog(1.0 / (1.0 + yd)) - 6.0 * dilog(yd / (1.0 + yd)) + 2.0 * dilog((2.0 * yd) / (1.0 + yd)) + 4.0 * dilog(((-1.0 + w) * yd) / (w * (1.0 + yd))) + 2.0 * dilog((w + yd) / (-1.0 + w)) + 8.0 * dilog((w - yd) / (w - w * yd)) + 8.0 * dilog((w + yd) / (w + w * yd)) + 4.0 * power_of<2>(ln1myd)
                + 2.0 * ln2 * log((1.0 - yd) / (1.0 + yd)) + 4.0 * power_of<2>(ln1pyd) + 2.0 * ln2 * log((1.0 + yd) / (1.0 - yd)) + (-4.0 * ln2 + 8.0 * log(((-1.0 + w) * yd) / (w * (1.0 + yd))) + 2.0 * log((1.0 + yd) / (1.0 - w))) * log((w + yd) / w) + (-4.0 * ln2 + 2.0 * log((-1.0 + yd) / (-1.0 + w)) + 8.0 * log(((-1.0 + w) * yd) / (w * (-1.0 + yd)))) * log(1.0 - yd / w) + 4.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) + 4.0 * log((-1.0 + w) / w) * log((w + yd) / (w + w * yd)) + (8.0 * 1.0i) * M_PI * log(1.0 + ydinv) * my_sign(imag(w)) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv)
                + (8.0 * 1.0i) * M_PI * log((-1.0 + yd) / yd) * my_sign(imag(w)) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) + (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + ln1pyd * (-4.0 * lnhalf + 4.0 * ln2 - 2.0 * log(1.0 - w) + (16.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, 1.0 + yd)) + (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + ln1myd * (-4.0 * lnhalf + 4.0 * ln2 - 2.0 * log(1.0 - w) - 12.0 * ln1pyd + (16.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, 1.0 - yd)))
                - (4.0 * 1.0i) * M_PI * trilog((w * (1.0 + yd)) / (-1.0 + w)) * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd) + trilog((w - yd) / (-1.0 + w)) * (-4.0 * log(1.0 / (1.0 - w)) + 8.0 * log((-1.0 + w) / w) + 2.0 * log(1.0 / (1.0 + w)) + 2.0 * log(yd / (1.0 + yd)) - 16.0 * ln1pyd + 4.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) + (4.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd))
                + dilog(yd) * (-4.0 * dilog(-(yd / w)) + 2.0 * dilog(yd / w) - 2.0 * dilog(1.0 / (1.0 + yd)) - 4.0 * dilog((1.0 + yd) / (1.0 - w)) + 2.0 * dilog((1.0 + yd) / (1.0 + w)) + 2.0 * dilog((w * (1.0 + yd)) / (w - yd)) - 6.0 * dilog((w + yd) / (-1.0 + w)) + 2.0 * dilog((w - yd) / (w + w * yd)) + 4.0 * ln2 * log(1.0 + winv) + 2.0 * power_of<2>(log(1.0 + winv)) + 2.0 * log(1.0 + winv) * log(1.0 - w) + 2.0 * power_of<2>(log(1.0 - w)) - 4.0 * log(1.0 + winv) * log(-2.0 / (-1.0 + w)) + 4.0 * ln2 * log((-1.0 + w) / w) + 4.0 * power_of<2>(log((-1.0 + w) / w)) - 2.0 * ln2 * log((1.0 - w) / (1.0 + w))
                + 2.0 * log(1.0 - w) * log((2.0 * w) / (1.0 + w)) + 2.0 * log(1.0 - w) * log((1.0 + w) / 2.0) - 2.0 * ln2 * log((1.0 + w) / (-1.0 + w)) + (8.0 * ln2 - 6.0 * log((1.0 + yd) / (1.0 - w))) * log((w + yd) / w) + 2.0 * power_of<2>(log(1.0 - yd / w)) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(-imydinv) * T(1.0, 1.0 + yd, 1.0 - w) + (4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imydinv) * T(1.0, 1.0 + yd, 1.0 + w) + log(1.0 - yd / w) * (-4.0 * ln2 + 2.0 * log((1.0 + yd) / (1.0 + w)) + 2.0 * log((yd + w * yd) / (w + w * yd)) + (4.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + yd, 1.0 - yd / w))
                - (12.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, 1.0 + winv) + ln1pyd * (2.0 * log(1.0 + winv) - 4.0 * log(1.0 + w) + 2.0 * log((w - yd) / (1.0 + w)) + 2.0 * log(((1.0 + w) * yd) / (-w + yd)) - 4.0 * log((w + yd) / (-1.0 + w)) + 8.0 * log((w + yd) / w) - 8.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)))
                + dilog(winv) * (2.0 * dilog(-(yd / w)) + 2.0 * dilog(yd / w) - 4.0 * dilog(1.0 / (1.0 + yd)) + 4.0 * dilog((w + yd) / (w - w * yd)) + 4.0 * dilog((w - yd) / (w + w * yd)) - 2.0 * power_of<2>(ln1myd) - 2.0 * power_of<2>(ln1pyd) + (8.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log(((1.0 + w) * yd) / (w * (-1.0 + yd)))) * log((w + yd) / w) + log(1.0 - yd / w) * (8.0 * ln2 + 4.0 * log(1.0 + winv) + 4.0 * log((yd + w * yd) / (w + w * yd))) + ln1myd * (-4.0 * lnhalf + 2.0 * log(1.0 + winv) - 4.0 * ln1pyd + (8.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, (w + yd) / w, 1.0 - yd))
                + ln1pyd * (-4.0 * lnhalf + 2.0 * log(1.0 + winv) + (8.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd))) + dilog((w - yd) / (-1.0 + w)) * ((-2.0 * pisqu) / 3.0 - dilog((w - yd) / (1.0 + w)) - 6.0 * dilog(-yd) + 2.0 * dilog(1.0 / (1.0 + yd)) + 4.0 * dilog(1.0 - yd / w) - dilog((w - yd) / (w + w * yd)) + 8.0 * log((w - yd) / (1.0 + w)) * ln1pyd + 4.0 * power_of<2>(ln1pyd) - 2.0 * power_of<2>(log(1.0 - yd / w)) - 8.0 * log((-1.0 + w) / w) * log((w - yd) / (w - w * yd)) + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv)
                + log(1.0 - yd / w) * (-2.0 * log(1.0 / (1.0 + w)) - 2.0 * log(yd / (1.0 + yd)) - (4.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) - (4.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)) + ln1pyd * (4.0 * log(1.0 - yd / w) + (4.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd))) + power_of<2>(log(1.0 / (1.0 - yd))) * (2.0 * pisqu - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(yd / (-1.0 + yd))) * T(1.0, (w - yd) / (w - w * yd), 1.0 / (1.0 - yd)) - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(yd / (1.0 - yd))) * T(1.0, (w + yd) / (w - w * yd), 1.0 / (1.0 - yd)))
                + power_of<2>(log(w / (w - yd))) * ((-2.0 * pisqu) / 3.0 - (4.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(yd / (w - yd))) * T(1.0, (w - w * yd) / (w - yd), w / (w - yd))) + power_of<2>(log(1.0 / (1.0 + yd))) * (2.0 * pisqu - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(imag(yd / (1.0 + yd))) * T(1.0, (w - yd) / (w + w * yd), 1.0 / (1.0 + yd)) - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(yd / (1.0 + yd))) * T(1.0, (w + yd) / (w + w * yd), 1.0 / (1.0 + yd))) - 4.0 * pisqu * power_of<2>(log(1.0 + winv)) * T(1.0, (w + yd) / w, 1.0 + winv) * T(p(-winv, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w)
                + 8.0 * pisqu * log(1.0 + winv) * log((-1.0 + w) / w) * T(1.0, (w + yd) / w, 1.0 + winv) * T(p(-winv, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w) - 4.0 * pisqu * power_of<2>(log((-1.0 + w) / w)) * T(1.0, (w + yd) / w, 1.0 + winv) * T(p(-winv, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w) - 4.0 * pisqu * power_of<2>(log(1.0 + winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) * T(p(-winv, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w) + 8.0 * pisqu * log(1.0 + winv) * log((-1.0 + w) / w) * T(1.0, 1.0 - yd / w, 1.0 + winv) * T(p(-winv, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w)
                - 4.0 * pisqu * power_of<2>(log((-1.0 + w) / w)) * T(1.0, 1.0 - yd / w, 1.0 + winv) * T(p(-winv, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w) + 4.0 * pisqu * ln2squ * T(1.0, 1.0 - yd, 1.0 + w) * T(p(-w, 1.0 - yd), 1.0 - yd, 2.0) - 8.0 * pisqu * ln2 * log(1.0 + w) * T(1.0, 1.0 - yd, 1.0 + w) * T(p(-w, 1.0 - yd), 1.0 - yd, 2.0) + 4.0 * pisqu * power_of<2>(log(1.0 + w)) * T(1.0, 1.0 - yd, 1.0 + w) * T(p(-w, 1.0 - yd), 1.0 - yd, 2.0) + 4.0 * pisqu * ln2squ * T(1.0, 1.0 + yd, 1.0 + w) * T(p(-w, 1.0 + yd), 1.0 + yd, 2.0) - 8.0 * pisqu * ln2 * log(1.0 + w) * T(1.0, 1.0 + yd, 1.0 + w) * T(p(-w, 1.0 + yd), 1.0 + yd, 2.0)
                + 4.0 * pisqu * power_of<2>(log(1.0 + w)) * T(1.0, 1.0 + yd, 1.0 + w) * T(p(-w, 1.0 + yd), 1.0 + yd, 2.0) - 4.0 * pisqu * power_of<2>(log((-1.0 + w) / w)) * T(1.0, 1.0 - yd / w, 1.0 + yd) * T(p(-yd, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w)
                + power_of<2>(ln1pyd) * (log((w - yd) / (1.0 + w)) * (-2.0 * lnhalf + ln2 + 4.0 * log((-1.0 + yd) / (-1.0 + w)) + 2.0 * log(yd / (-1.0 + yd))) + ln2 * log(((1.0 + w) * yd) / (-w + yd)) + (-ln2 - log(1.0 + w)) * log((-1.0 + w) / (w + yd)) + (-2.0 * lnhalf + log(1.0 + winv)) * log((w + yd) / (-1.0 + w)) + 2.0 * ln2 * log((w + yd) / w) + log((-1.0 + yd) / (2.0 * yd)) * (2.0 * log(1.0 + winv) + 2.0 * log((-1.0 + w) / w) - log(1.0 + w) + 3.0 * log((w + yd) / w) - 2.0 * log(1.0 - yd / w))
                + log((2.0 * yd) / (-1.0 + yd)) * (3.0 * log(1.0 + winv) - log(1.0 - w) + 2.0 * log((-1.0 + w) / w) - log(1.0 + w) - 2.0 * log((w + yd) / w) - log(1.0 - yd / w)) - (2.0 * ln64 * log(1.0 - yd / w)) / 3.0 - log(1.0 + winv) * log((w + yd) / (yd - w * yd)) + (ln2 + log(1.0 + w)) * log((yd - w * yd) / (w + yd)) - ln2 * log(-((w - yd) / (yd + w * yd))) + (2.0 * 1.0i) * M_PI * ln2 * my_sign(-imag(yd)) * T(1.0, 1.0 - w, 1.0 + yd) + (2.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(yd)) * T(1.0, 1.0 - w, 1.0 + yd)
                + (16.0 * 1.0i) * M_PI * log((1.0 - w) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 + yd))) * T(1.0, (1.0 - yd) / 2.0, (1.0 - w) / 2.0) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(winv)) * T(1.0, 1.0 - yd, 1.0 - w) + (8.0 * 1.0i) * M_PI * log((-1.0 + w) / (1.0 + w)) * my_sign(imag((1.0 + w) / (1.0 + yd))) * T(1.0, (w - yd) / (1.0 + w), (-1.0 + w) / (1.0 + w)) + (4.0 * 1.0i) * M_PI * log(w / (1.0 + w)) * my_sign(imag((1.0 + w) / (1.0 + yd))) * T(1.0, (w - yd) / (1.0 + w), w / (1.0 + w)) - (8.0 * 1.0i) * M_PI * log(-w) * my_sign(imag(1.0 / (1.0 + yd))) * T(1.0, -yd, -w) + (4.0 * 1.0i) * M_PI * log(w) * my_sign(imag(1.0 / (1.0 + yd))) * T(1.0, -yd, w)
                + log((1.0 - yd) / 2.0) * (-2.0 * log(1.0 + winv) - 2.0 * log((-1.0 + w) / w) + log(w / (1.0 + w)) + log(1.0 + w) - log(-(yd / (w - yd))) - 3.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w)) + (4.0 * 1.0i) * M_PI * ln2 * my_sign(-imag(yd)) * T(1.0, (w + yd) / w, 1.0 + yd) + (6.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(yd)) * T(1.0, (w + yd) / w, 1.0 + yd) - (2.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)
                + (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd) - (2.0 * 1.0i) * M_PI * log((-1.0 + yd) / (-1.0 + w)) * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd) - 4.0 * pisqu * T(1.0, 1.0 - yd / w, 1.0 + yd) * T(p(-yd, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w)) + ln1pyd * ((-1.0 / 3.0) * (pisqu * lnm1) - power_of<3>(lnm1) / 3.0 + lnm1 * ln2squ - 2.0 * power_of<2>(lnhalf) * log(1.0 + winv) + 2.0 * lnhalf * power_of<2>(log(1.0 / (1.0 - w))) + 2.0 * ln2 * power_of<2>(log(1.0 / (1.0 - w))) - (2.0 * pisqu * log(1.0 - w)) / 3.0 - (2.0 * power_of<3>(log(1.0 - w))) / 3.0 - power_of<2>(log(1.0 + winv)) * log(-2.0 / (-1.0 + w))
                + (2.0 * pisqu * log(-2.0 / w)) / 3.0 + (2.0 * power_of<3>(log(-2.0 / w))) / 3.0 - (2.0 * pisqu * log(-winv)) / 3.0 - (2.0 * power_of<3>(log(-winv))) / 3.0 + (pisqu * log((-0.5) * (1.0 / w))) / 3.0 + power_of<3>(log((-0.5) * (1.0 / w))) / 3.0 - (pisqu * log(1.0 / (2.0 * w))) / 3.0 - power_of<3>(log(1.0 / (2.0 * w))) / 3.0 + pisqu * log(winv) - 3.0 * power_of<2>(log(1.0 - w)) * log(winv) + power_of<3>(log(winv)) + (2.0 * pisqu * log(2.0 / w)) / 3.0 + (2.0 * power_of<3>(log(2.0 / w))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((-1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(log(1.0 / (1.0 - w))) * log((-1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(lnhalf) * log((-1.0 + w) / w) - (2.0 * pisqu * log(w / 2.0)) / 3.0 - (2.0 * power_of<3>(log(w / 2.0))) / 3.0
                + (4.0 * pisqu * log(w)) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(w) - 4.0 * power_of<2>(log((-1.0 + w) / w)) * log(w) + (4.0 * power_of<3>(log(w))) / 3.0 - (pisqu * log(w / (-1.0 + w))) / 3.0 - 2.0 * power_of<2>(lnhalf) * log(w / (-1.0 + w)) - power_of<3>(log(w / (-1.0 + w))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((2.0 * w) / (-1.0 + w)) + power_of<2>(log(1.0 + winv)) * log((2.0 * w) / (-1.0 + w)) - 2.0 * power_of<2>(log(1.0 / (1.0 - w))) * log((2.0 * w) / (-1.0 + w)) + (pisqu * log(-1.0 / (1.0 + w))) / 3.0 + power_of<3>(log(-1.0 / (1.0 + w))) / 3.0 - (2.0 * pisqu * log(1.0 / (1.0 + w))) / 3.0 - (2.0 * power_of<3>(log(1.0 / (1.0 + w)))) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(2.0 / (1.0 + w))
                - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(2.0 / (1.0 + w)) + ln2squ * log((1.0 - w) / (1.0 + w)) - ln2squ * log((-1.0 + w) / (1.0 + w)) - (2.0 * pisqu * log((2.0 * (-1.0 + w)) / (1.0 + w))) / 3.0 - (2.0 * power_of<3>(log((2.0 * (-1.0 + w)) / (1.0 + w)))) / 3.0 - (2.0 * pisqu * log(w / (1.0 + w))) / 3.0 - 2.0 * power_of<2>(lnhalf) * log(w / (1.0 + w)) - (2.0 * power_of<3>(log(w / (1.0 + w)))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((2.0 * w) / (1.0 + w)) - 2.0 * power_of<2>(log(1.0 - w)) * log((2.0 * w) / (1.0 + w)) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((2.0 * w) / (1.0 + w)) - power_of<2>(log(1.0 - w)) * log((1.0 + w) / 2.0) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((1.0 + w) / 2.0)
                + log((1.0 - w) / 2.0) * power_of<2>(log(1.0 + w)) + 2.0 * log(-winv) * power_of<2>(log(1.0 + w)) - log((-1.0 + w) / (2.0 * w)) * power_of<2>(log(1.0 + w)) - (2.0 * pisqu * log((2.0 * (1.0 + w)) / (-1.0 + w))) / 3.0 - (2.0 * power_of<3>(log((2.0 * (1.0 + w)) / (-1.0 + w)))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((1.0 + w) / (2.0 * w)) + power_of<2>(log(1.0 - w)) * log((1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((1.0 + w) / (2.0 * w)) + (2.0 * pisqu * log((-1.0 + power_of<2>(w)) / (2.0 * w))) / 3.0 + (2.0 * power_of<3>(log((-1.0 + power_of<2>(w)) / (2.0 * w)))) / 3.0 - (4.0 * pisqu * log(-2.0 / (w - yd))) / 3.0 - (4.0 * power_of<3>(log(-2.0 / (w - yd)))) / 3.0 - (2.0 * pisqu * log(2.0 / (w - yd))) / 3.0 - (2.0 * power_of<3>(log(2.0 / (w - yd)))) / 3.0
                - (2.0 * pisqu * log((-1.0 + power_of<2>(w)) / (2.0 * (w - yd)))) / 3.0 - (2.0 * power_of<3>(log((-1.0 + power_of<2>(w)) / (2.0 * (w - yd))))) / 3.0 + (2.0 * pisqu * log((w - yd) / (1.0 + w))) / 3.0 + (2.0 * pisqu * log((-2.0 * (-1.0 + w)) / ((1.0 + w) * (-1.0 + yd)))) / 3.0 + (2.0 * power_of<3>(log((-2.0 * (-1.0 + w)) / ((1.0 + w) * (-1.0 + yd))))) / 3.0 - (4.0 * pisqu * log((1.0 + w) / (-1.0 + yd))) / 3.0 - (4.0 * power_of<3>(log((1.0 + w) / (-1.0 + yd)))) / 3.0 - (2.0 * pisqu * log((1.0 + w) / yd)) / 3.0 - (2.0 * power_of<3>(log((1.0 + w) / yd))) / 3.0 + (4.0 * pisqu * log((-2.0 * (1.0 + w)) / ((-1.0 + w) * (1.0 + yd)))) / 3.0 + (4.0 * power_of<3>(log((-2.0 * (1.0 + w)) / ((-1.0 + w) * (1.0 + yd))))) / 3.0
                + 2.0 * pisqu * log((2.0 * (1.0 + w)) / ((-1.0 + w) * (1.0 + yd))) + 2.0 * power_of<3>(log((2.0 * (1.0 + w)) / ((-1.0 + w) * (1.0 + yd)))) + power_of<2>(log((-1.0 + yd) / (-1.0 + w))) * (2.0 * log((2.0 * (w - yd)) / ((-1.0 + w) * (1.0 + yd))) + 2.0 * log(((-1.0 + w) * (1.0 + yd)) / (2.0 * (w - yd)))) - (2.0 * pisqu * log(1.0 / (-w + yd))) / 3.0 - (2.0 * power_of<3>(log(1.0 / (-w + yd)))) / 3.0 + (pisqu * log(-1.0 / (w + yd))) / 3.0 + power_of<3>(log(-1.0 / (w + yd))) / 3.0 + (pisqu * log(1.0 / (w + yd))) / 3.0 + power_of<3>(log(1.0 / (w + yd))) / 3.0 - power_of<2>(log(1.0 + w)) * log((-1.0 + yd) / (w + yd)) - (2.0 * pisqu * log((w + yd) / (-1.0 + w))) / 3.0
                + (pisqu / 3.0 - 2.0 * ln2squ) * log((w + yd) / w) + 2.0 * log(-(yd / w)) * power_of<2>(log((w + yd) / w)) - power_of<2>(log(1.0 + winv)) * log((w + yd) / (-1.0 + yd)) + power_of<2>(log(1.0 + winv)) * log((w + yd) / (w - w * yd)) + power_of<2>(log(1.0 + w)) * log((w - w * yd) / (w + yd)) + (2.0 * pisqu * log(w / (yd - w * yd))) / 3.0 + (2.0 * power_of<3>(log(w / (yd - w * yd)))) / 3.0 - (2.0 * pisqu * log((1.0 - w) / (w + w * yd))) / 3.0 - (2.0 * power_of<3>(log((1.0 - w) / (w + w * yd)))) / 3.0 + (2.0 * pisqu * log(-((1.0 + w) / (w + w * yd)))) / 3.0 + (2.0 * power_of<3>(log(-((1.0 + w) / (w + w * yd))))) / 3.0 - (4.0 * pisqu * log((1.0 + w) / (w + w * yd))) / 3.0
                - (4.0 * power_of<3>(log((1.0 + w) / (w + w * yd)))) / 3.0 - (2.0 * 1.0i) * M_PI * H1(ydinv, -winv) * power_of<2>(log(w + yd)) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H1((-1.0 + w) / (1.0 + w), (-1.0 + w) / w) * power_of<2>(log(1.0 / (-1.0 + w))) * my_sign(imag(winv)) + (4.0 * 1.0i) * M_PI * H1(1.0 + winv, (-1.0 + w) / w) * power_of<2>(log((-2.0 * w) / (-1.0 + power_of<2>(w)))) * my_sign(imag(winv)) - (4.0 * 1.0i) * M_PI * H1((-1.0 + w) / (-1.0 + yd), -2.0 / (-1.0 + yd)) * power_of<2>(log(((1.0 + w) * (-1.0 + yd)) / (2.0 * (-1.0 + w)))) * my_sign(2.0 * imag(1.0 / (1.0 - yd))) + (4.0 * 1.0i) * M_PI * H1(-2.0 / (-1.0 + w), -2.0 / (-1.0 + yd)) * power_of<2>(log((-w + yd) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 - yd)))
                + (4.0 * 1.0i) * M_PI * H1((1.0 + w) / (w - yd), (-1.0 + w) / (w - yd)) * power_of<2>(log((-2.0 * (w - yd)) / (-1.0 + power_of<2>(w)))) * my_sign(imag((-1.0 + w) / (w - yd))) - (4.0 * 1.0i) * M_PI * H1((-1.0 + w) / (1.0 + w), (-1.0 + w) / (w - yd)) * power_of<2>(log((1.0 + yd) / (-1.0 + w))) * my_sign(imag((-1.0 + w) / (w - yd))) - (4.0 * 1.0i) * M_PI * H1(-winv, -ydinv) * power_of<2>(log(-w + yd)) * my_sign(-imydinv) - (2.0 * 1.0i) * M_PI * H1(w / yd, ydinv) * power_of<2>(log((-1.0 + winv) * yd)) * my_sign(imydinv) - (6.0 * 1.0i) * M_PI * H1(-w, -(w / yd)) * power_of<2>(log((-1.0 + yd) / w)) * my_sign(-imag(w / yd)) - (4.0 * 1.0i) * M_PI * H1(ydinv, w / yd) * power_of<2>(log(((-1.0 + w) * yd) / w)) * my_sign(imag(w / yd))
                + power_of<2>(log((1.0 - yd) / w)) * ((-2.0 * 1.0i) * M_PI * H1(-(w / yd), -w) * my_sign(-imag(w)) - (2.0 * 1.0i) * M_PI * H1(w, w / yd) * my_sign(imag(w / yd))) + (8.0 * 1.0i) * M_PI * H1((1.0 + w) / (1.0 + yd), 1.0 / (1.0 + yd)) * power_of<2>(log(-((w * (1.0 + yd)) / (1.0 + w)))) * my_sign(imag(1.0 / (1.0 + yd))) + power_of<2>(log(-w - yd)) * ((2.0 * 1.0i) * M_PI * H1(-winv, ydinv) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - w), 1.0 / (1.0 + yd)) * my_sign(imag(1.0 / (1.0 + yd)))) + power_of<2>(log(w - yd)) * ((8.0 * 1.0i) * M_PI * H1(winv, ydinv) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 + w), 1.0 / (1.0 + yd)) * my_sign(imag(1.0 / (1.0 + yd))))
                + (8.0 * 1.0i) * M_PI * H1(2.0 / (1.0 + w), 2.0 / (1.0 + yd)) * power_of<2>(log((w - yd) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 + yd))) - (12.0 * 1.0i) * M_PI * H1((1.0 + w) / (1.0 + yd), 2.0 / (1.0 + yd)) * power_of<2>(log((-0.5) * (((-1.0 + w) * (1.0 + yd)) / (1.0 + w)))) * my_sign(2.0 * imag(1.0 / (1.0 + yd))) + (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 + yd), (1.0 - w) / (1.0 + yd)) * power_of<2>(log((w * (1.0 + yd)) / (-1.0 + w))) * my_sign(imag((1.0 - w) / (1.0 + yd))) + (8.0 * 1.0i) * M_PI * H1((1.0 + w) / 2.0, (1.0 + w) / (1.0 + yd)) * power_of<2>(log((1.0 - yd) / (1.0 + w))) * my_sign(imag((1.0 + w) / (1.0 + yd))) + (4.0 * 1.0i) * M_PI * H1(1.0 + w, (1.0 + w) / (1.0 + yd)) * power_of<2>(log(-(yd / (1.0 + w)))) * my_sign(imag((1.0 + w) / (1.0 + yd)))
                - (8.0 * 1.0i) * M_PI * H1(2.0 / (1.0 + yd), (1.0 + w) / (1.0 + yd)) * power_of<2>(log(((-1.0 + w) * (1.0 + yd)) / (2.0 * (1.0 + w)))) * my_sign(imag((1.0 + w) / (1.0 + yd))) - (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 + yd), (1.0 + w) / (1.0 + yd)) * power_of<2>(log((w * (1.0 + yd)) / (1.0 + w))) * my_sign(imag((1.0 + w) / (1.0 + yd))) - (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + yd) / yd)) * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) - (4.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w))) * my_sign(imag((1.0 + w) / (-1.0 + w))) * T(1.0, 1.0 / (1.0 - w), -2.0 / (-1.0 + w)) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 + w))) * my_sign(-imag(w / (1.0 + w))) * T(1.0, 1.0 / (1.0 - w), 1.0 / (1.0 + w))
                - (2.0 * 1.0i) * M_PI * power_of<2>(log((w + yd) / yd)) * my_sign(-imag(w / yd)) * T(1.0, 1.0 + w, (w + yd) / yd) - (12.0 * 1.0i) * M_PI * power_of<2>(log((1.0 - w) / 2.0)) * my_sign(imag(w) / 2.0) * T(1.0, (1.0 - yd) / 2.0, (1.0 - w) / 2.0) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * log((1.0 + w) / 2.0) * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) + (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + power_of<2>(log((w + yd) / w)) * (-3.0 * log((1.0 + w) / (1.0 - yd)) + 3.0 * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) + (2.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w))
                - (8.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / (1.0 + w))) * my_sign(2.0 * imag(1.0 / (1.0 + w))) * T(1.0, (w - yd) / (1.0 + w), (-1.0 + w) / (1.0 + w)) + (4.0 * 1.0i) * M_PI * power_of<2>(log(w / (1.0 + w))) * my_sign(-imag(1.0 / (1.0 + w))) * T(1.0, (w - yd) / (1.0 + w), w / (1.0 + w)) + power_of<2>(log((1.0 - yd) / 2.0)) * (-6.0 * log((2.0 * (w - yd)) / ((-1.0 + w) * (1.0 + yd))) - 4.0 * log(((-1.0 + w) * (1.0 + yd)) / (2.0 * (w - yd))) + (8.0 * 1.0i) * M_PI * my_sign(imag(yd) / 2.0) * T(1.0, (w - yd) / (1.0 + w), (1.0 - yd) / 2.0)) + (4.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w))) * my_sign(imag((1.0 + w) / (-1.0 + w))) * T(1.0, (-1.0 + yd) / (-1.0 + w), -2.0 / (-1.0 + w))
                + log(1.0 - yd / w) * ((-2.0 * pisqu) / 3.0 + 4.0 * ln2squ - (8.0 * 1.0i) * M_PI * log(-2.0 / (-1.0 + w)) * my_sign(imag((-1.0 + w) / (w - yd))) * T(1.0, (-1.0 + yd) / (-1.0 + w), -2.0 / (-1.0 + w))) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + yd) / (1.0 + w))) * my_sign(imag((w - yd) / (1.0 + w))) * T(1.0, (-1.0 + yd) / (-1.0 + w), (1.0 + yd) / (1.0 + w)) - (8.0 * 1.0i) * M_PI * power_of<2>(log(-w)) * my_sign(-imag(w)) * T(1.0, -yd, -w)
                + power_of<2>(log((w - yd) / (1.0 + w))) * (4.0 * log((-1.0 + yd) / (-1.0 + w)) - 4.0 * log(((1.0 + w) * (-1.0 + yd)) / ((-1.0 + w) * (1.0 + yd))) - 4.0 * log(((-1.0 + w) * (1.0 + yd)) / ((1.0 + w) * (-1.0 + yd))) - 2.0 * log((w + w * yd) / (yd + w * yd)) - 2.0 * log((yd + w * yd) / (w + w * yd)) + (8.0 * 1.0i) * M_PI * my_sign(imag((1.0 + yd) / (1.0 + w))) * T(1.0, (1.0 - yd) / 2.0, (w - yd) / (1.0 + w)) - (4.0 * 1.0i) * M_PI * my_sign(imag((1.0 + yd) / (1.0 + w))) * T(1.0, -yd, (w - yd) / (1.0 + w)))
                + power_of<2>(log((w + yd) / (-1.0 + w))) * (-2.0 * log(-(yd / w)) + 2.0 * log(((-1.0 + w) * yd) / (w * (1.0 + yd))) - (4.0 * 1.0i) * M_PI * my_sign(imag((1.0 + yd) / (1.0 - w))) * T(1.0, -yd, (w + yd) / (-1.0 + w))) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w) / 2.0)) * my_sign((-0.5) * imag(w)) * T(1.0, (1.0 + yd) / 2.0, (1.0 + w) / 2.0) - (8.0 * 1.0i) * M_PI * log((1.0 - w) / 2.0) * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + power_of<2>(log(1.0 - yd / w)) * ((8.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 - yd, 1.0 - yd / w) - (4.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w))
                + log((1.0 - yd) / 2.0) * ((-4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * log(1.0 - yd / w) * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w)) + (4.0 * 1.0i) * M_PI * power_of<2>(log(w / (-1.0 + w))) * my_sign(-imag(1.0 / (-1.0 + w))) * T(1.0, (w + yd) / (-1.0 + w), w / (-1.0 + w)) + (8.0 * 1.0i) * M_PI * log(1.0 + winv) * log(-2.0 / (-1.0 + w)) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w)
                - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * log(2.0 / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * log((1.0 + yd) / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) + log((-1.0 + yd) / (-1.0 + w)) * (2.0 * power_of<2>(log(1.0 - yd / w)) + (4.0 * 1.0i) * M_PI * log(1.0 - yd / w) * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)) + 16.0 * pisqu * log((-1.0 + w) / w) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) * T(p(winv, 1.0 - yd / w), 1.0 - yd / w, 1.0 + winv)
                + 8.0 * pisqu * log((-1.0 + w) / w) * T(1.0, 1.0 - yd / w, 1.0 + yd) * T(p(-yd, 1.0 - yd / w), 1.0 - yd / w, (-1.0 + w) / w)) - 4.0 * pisqu * power_of<2>(log((-1.0 + w) / w)) * T(1.0, (w + yd) / w, 1.0 - yd) * T(p(yd, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w) + power_of<2>(ln1myd) * (log(((-1.0 + w) * yd) / (w - yd)) * (ln2 + log(1.0 + w) - 4.0 * ln1pyd) + log((w - yd) / ((-1.0 + w) * yd)) * (-log(1.0 + winv) - ln1pyd) + log((w - yd) / (-1.0 + w)) * (-2.0 * lnhalf + log(1.0 + winv) + ln1pyd)
                + log((-1.0 + w) / (w - yd)) * (-ln2 - log(1.0 + w) + 4.0 * ln1pyd) - ln2 * log((1.0 + w) / (w + yd)) + ln2 * log(((1.0 + w) * yd) / (w + yd)) - (2.0 * ln64 * log((w + yd) / w)) / 3.0 + 2.0 * log(-(yd / w)) * log((w + yd) / (1.0 + w)) + (-2.0 * lnhalf + ln2 + 2.0 * log(yd / (1.0 + yd))) * log((w + yd) / (1.0 + w)) + log(ydinv) * (3.0 * ln2 + 2.0 * log(1.0 + winv) - log(1.0 - w) + log(1.0 + w) - 4.0 * ln1pyd + log((w + yd) / w) - 5.0 * log(1.0 - yd / w))
                + log((2.0 * yd) / (1.0 + yd)) * (3.0 * log(1.0 + winv) - log(1.0 - w) + 2.0 * log((-1.0 + w) / w) - log(1.0 + w) - log((w + yd) / w) - 2.0 * log(1.0 - yd / w)) + 2.0 * ln2 * log(1.0 - yd / w) + log(yd) * (-4.0 * log((w + yd) / w) + 2.0 * log(1.0 - yd / w)) + log(2.0 / (1.0 + yd)) * (-3.0 * log(1.0 + winv) + log(1.0 - w) - 2.0 * log((-1.0 + w) / w) + log(1.0 + w) + log((w + yd) / w) + 2.0 * log(1.0 - yd / w)) + log((1.0 + yd) / (2.0 * yd)) * (2.0 * log(1.0 + winv) + 2.0 * log((-1.0 + w) / w) - log(1.0 + w) - 2.0 * log((w + yd) / w) + 3.0 * log(1.0 - yd / w))
                - ln2 * log((w + yd) / (yd + w * yd)) + (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(yd)) * T(1.0, 1.0 - w, 1.0 - yd) + (2.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(imag(yd)) * T(1.0, 1.0 - w, 1.0 - yd) + log((1.0 + yd) / 2.0) * (-2.0 * log(1.0 + winv) - 2.0 * log((-1.0 + w) / w) + log(w / (1.0 + w)) + log(1.0 + w) - log(yd / (w + yd)) + 8.0 * log((w + yd) / (-1.0 + w)) + 2.0 * log((w + yd) / w) - 3.0 * log(1.0 - yd / w) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) - (2.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)) - (8.0 * 1.0i) * M_PI * log(-w) * my_sign(imag(1.0 / (1.0 - yd))) * T(1.0, yd, -w)
                + (4.0 * 1.0i) * M_PI * log(w) * my_sign(imag(1.0 / (1.0 - yd))) * T(1.0, yd, w) + (16.0 * 1.0i) * M_PI * log((1.0 - w) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 - yd))) * T(1.0, (1.0 + yd) / 2.0, (1.0 - w) / 2.0) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(winv)) * T(1.0, 1.0 + yd, 1.0 - w) - (2.0 * 1.0i) * M_PI * log(1.0 - w) * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd) + (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd) + log((1.0 + yd) / (1.0 - w)) * (4.0 * log((w + yd) / (1.0 + w)) - (2.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd))
                + (8.0 * 1.0i) * M_PI * log((-1.0 + w) / (1.0 + w)) * my_sign(imag((1.0 + w) / (1.0 - yd))) * T(1.0, (w + yd) / (1.0 + w), (-1.0 + w) / (1.0 + w)) + (4.0 * 1.0i) * M_PI * log(w / (1.0 + w)) * my_sign(imag((1.0 + w) / (1.0 - yd))) * T(1.0, (w + yd) / (1.0 + w), w / (1.0 + w)) + (4.0 * 1.0i) * M_PI * ln2 * my_sign(imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 - yd) + (6.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 - yd)
                + ln1pyd * (log((1.0 + w) / (w + yd)) - log(((1.0 + w) * yd) / (w + yd)) - 4.0 * log((w + yd) / (-1.0 + w)) - 4.0 * log((w + yd) / (1.0 + w)) - (6.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd) - (2.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 - yd)) - 4.0 * pisqu * T(1.0, (w + yd) / w, 1.0 - yd) * T(p(yd, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w))
                + ln1myd * ((-1.0 / 3.0) * (pisqu * lnm1) - power_of<3>(lnm1) / 3.0 + lnm1 * ln2squ - 2.0 * power_of<2>(lnhalf) * log(1.0 + winv) + 2.0 * lnhalf * power_of<2>(log(1.0 / (1.0 - w))) + 2.0 * ln2 * power_of<2>(log(1.0 / (1.0 - w))) - (2.0 * pisqu * log(1.0 - w)) / 3.0 - (2.0 * power_of<3>(log(1.0 - w))) / 3.0 - power_of<2>(log(1.0 + winv)) * log(-2.0 / (-1.0 + w)) + (2.0 * pisqu * log(-2.0 / w)) / 3.0 + (2.0 * power_of<3>(log(-2.0 / w))) / 3.0 - (2.0 * pisqu * log(-winv)) / 3.0 - (2.0 * power_of<3>(log(-winv))) / 3.0 + (pisqu * log((-0.5) * (1.0 / w))) / 3.0 + power_of<3>(log((-0.5) * (1.0 / w))) / 3.0 - (pisqu * log(1.0 / (2.0 * w))) / 3.0 - power_of<3>(log(1.0 / (2.0 * w))) / 3.0 + pisqu * log(winv)
                - 3.0 * power_of<2>(log(1.0 - w)) * log(winv) + power_of<3>(log(winv)) + (2.0 * pisqu * log(2.0 / w)) / 3.0 + (2.0 * power_of<3>(log(2.0 / w))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((-1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(log(1.0 / (1.0 - w))) * log((-1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(lnhalf) * log((-1.0 + w) / w) - (2.0 * pisqu * log(w / 2.0)) / 3.0 - (2.0 * power_of<3>(log(w / 2.0))) / 3.0 + (4.0 * pisqu * log(w)) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(w) - 4.0 * power_of<2>(log((-1.0 + w) / w)) * log(w) + (4.0 * power_of<3>(log(w))) / 3.0 - (pisqu * log(w / (-1.0 + w))) / 3.0 - 2.0 * power_of<2>(lnhalf) * log(w / (-1.0 + w)) - power_of<3>(log(w / (-1.0 + w))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((2.0 * w) / (-1.0 + w))
                + power_of<2>(log(1.0 + winv)) * log((2.0 * w) / (-1.0 + w)) - 2.0 * power_of<2>(log(1.0 / (1.0 - w))) * log((2.0 * w) / (-1.0 + w)) + (pisqu * log(-1.0 / (1.0 + w))) / 3.0 + power_of<3>(log(-1.0 / (1.0 + w))) / 3.0 - (2.0 * pisqu * log(1.0 / (1.0 + w))) / 3.0 - (2.0 * power_of<3>(log(1.0 / (1.0 + w)))) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(2.0 / (1.0 + w)) - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(2.0 / (1.0 + w)) + ln2squ * log((1.0 - w) / (1.0 + w)) - ln2squ * log((-1.0 + w) / (1.0 + w)) - (2.0 * pisqu * log((2.0 * (-1.0 + w)) / (1.0 + w))) / 3.0 - (2.0 * power_of<3>(log((2.0 * (-1.0 + w)) / (1.0 + w)))) / 3.0 - (2.0 * pisqu * log(w / (1.0 + w))) / 3.0
                - 2.0 * power_of<2>(lnhalf) * log(w / (1.0 + w)) - (2.0 * power_of<3>(log(w / (1.0 + w)))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((2.0 * w) / (1.0 + w)) - 2.0 * power_of<2>(log(1.0 - w)) * log((2.0 * w) / (1.0 + w)) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((2.0 * w) / (1.0 + w)) - power_of<2>(log(1.0 - w)) * log((1.0 + w) / 2.0) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((1.0 + w) / 2.0) + log((1.0 - w) / 2.0) * power_of<2>(log(1.0 + w)) + 2.0 * log(-winv) * power_of<2>(log(1.0 + w)) - log((-1.0 + w) / (2.0 * w)) * power_of<2>(log(1.0 + w)) - (2.0 * pisqu * log((2.0 * (1.0 + w)) / (-1.0 + w))) / 3.0 - (2.0 * power_of<3>(log((2.0 * (1.0 + w)) / (-1.0 + w)))) / 3.0 + 2.0 * power_of<2>(lnhalf) * log((1.0 + w) / (2.0 * w))
                + power_of<2>(log(1.0 - w)) * log((1.0 + w) / (2.0 * w)) - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((1.0 + w) / (2.0 * w)) + (2.0 * pisqu * log((-1.0 + power_of<2>(w)) / (2.0 * w))) / 3.0 + (2.0 * power_of<3>(log((-1.0 + power_of<2>(w)) / (2.0 * w)))) / 3.0 + (pisqu * log(1.0 / (w - yd))) / 3.0 + power_of<3>(log(1.0 / (w - yd))) / 3.0 - (2.0 * power_of<3>(log(-2.0 / (-1.0 + yd)))) / 3.0 + (4.0 * pisqu * log((-1.0 + w) / (-1.0 + yd))) / 3.0 + (4.0 * power_of<3>(log((-1.0 + w) / (-1.0 + yd)))) / 3.0 - (2.0 * pisqu * log((-1.0 + w) / (w * (-1.0 + yd)))) / 3.0 - (2.0 * power_of<3>(log((-1.0 + w) / (w * (-1.0 + yd))))) / 3.0 + 2.0 * pisqu * log((-2.0 * (1.0 + w)) / ((-1.0 + w) * (-1.0 + yd))) + 2.0 * power_of<3>(log((-2.0 * (1.0 + w)) / ((-1.0 + w) * (-1.0 + yd))))
                + (4.0 * pisqu * log((2.0 * (1.0 + w)) / ((-1.0 + w) * (-1.0 + yd)))) / 3.0 + (4.0 * power_of<3>(log((2.0 * (1.0 + w)) / ((-1.0 + w) * (-1.0 + yd))))) / 3.0 + (2.0 * pisqu * log((1.0 + w) / (w * (-1.0 + yd)))) / 3.0 + (2.0 * power_of<3>(log((1.0 + w) / (w * (-1.0 + yd))))) / 3.0 + (4.0 * power_of<3>(log(-ydinv))) / 3.0 - (2.0 * pisqu * log(ydinv)) / 3.0 - (2.0 * power_of<3>(log(ydinv))) / 3.0 - power_of<3>(log(-(w / yd))) - power_of<3>(log(w / yd)) + (2.0 * pisqu * log(w / ((-1.0 + w) * yd))) / 3.0 + (2.0 * power_of<3>(log(w / ((-1.0 + w) * yd)))) / 3.0 - (2.0 * pisqu * log(-((1.0 + w) / yd))) / 3.0 - (2.0 * power_of<3>(log(-((1.0 + w) / yd)))) / 3.0 - 2.0 * log(w / (w - yd)) * power_of<2>(log(yd)) + (2.0 * pisqu * log(-(w / (1.0 + yd)))) / 3.0
                + (2.0 * power_of<3>(log(-(w / (1.0 + yd))))) / 3.0 + pisqu * log(w / (1.0 + yd)) + power_of<3>(log(w / (1.0 + yd))) + (2.0 * pisqu * log((2.0 * (-1.0 + w)) / ((1.0 + w) * (1.0 + yd)))) / 3.0 + (2.0 * power_of<3>(log((2.0 * (-1.0 + w)) / ((1.0 + w) * (1.0 + yd))))) / 3.0 - (4.0 * pisqu * log(-((1.0 + w) / (1.0 + yd)))) / 3.0 - (4.0 * power_of<3>(log(-((1.0 + w) / (1.0 + yd))))) / 3.0 + log((1.0 + w) / (w - yd)) * power_of<2>(ln1pyd) + log((w - yd) / (-1.0 + w)) * ((-2.0 * pisqu) / 3.0 - 4.0 * power_of<2>(ln1pyd)) + log(-ydinv) * ((4.0 * pisqu) / 3.0 - 4.0 * power_of<2>(ln1pyd)) + log(-2.0 / (-1.0 + yd)) * ((-2.0 * pisqu) / 3.0 + 2.0 * power_of<2>(log((1.0 + yd) / 2.0)) - 2.0 * power_of<2>(log((1.0 + yd) / (1.0 - w))))
                - power_of<2>(log(1.0 + w)) * log(-((1.0 + yd) / (w - yd))) + power_of<2>(log(1.0 + w)) * log((w * (1.0 + yd)) / (w - yd)) + (pisqu * log(1.0 / (-w + yd))) / 3.0 + power_of<3>(log(1.0 / (-w + yd))) / 3.0 - power_of<2>(log(1.0 + winv)) * log((-w + yd) / (1.0 + yd)) - (4.0 * pisqu * log(-2.0 / (w + yd))) / 3.0 - (4.0 * power_of<3>(log(-2.0 / (w + yd)))) / 3.0 - (2.0 * pisqu * log(-1.0 / (w + yd))) / 3.0 - (2.0 * power_of<3>(log(-1.0 / (w + yd)))) / 3.0 + (2.0 * pisqu * log(1.0 / (w + yd))) / 3.0 + (2.0 * power_of<3>(log(1.0 / (w + yd)))) / 3.0 - (2.0 * pisqu * log(2.0 / (w + yd))) / 3.0 - (2.0 * power_of<3>(log(2.0 / (w + yd)))) / 3.0 - (2.0 * pisqu * log((-1.0 + power_of<2>(w)) / (2.0 * (w + yd)))) / 3.0
                - (2.0 * power_of<3>(log((-1.0 + power_of<2>(w)) / (2.0 * (w + yd))))) / 3.0 + log(((-1.0 + w) * yd) / (w * (1.0 + yd))) * power_of<2>(log((w + yd) / w)) - 2.0 * log((w * (1.0 + yd)) / ((-1.0 + w) * yd)) * power_of<2>(log((w + yd) / w)) + log((1.0 - yd) / 2.0) * (-2.0 * power_of<2>(log((1.0 + yd) / (1.0 - w))) - 4.0 * log((1.0 + yd) / (1.0 - w)) * log((w + yd) / w)) + (2.0 * pisqu * log((w + yd) / (1.0 + w))) / 3.0 - 2.0 * log((w * (-1.0 + yd)) / ((1.0 + w) * yd)) * power_of<2>(log((w + yd) / (1.0 + w))) + 2.0 * log(-(yd / w)) * power_of<2>(log((w + yd) / (1.0 + w))) - 2.0 * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) * power_of<2>(log((w + yd) / (1.0 + w)))
                + log(-(w / yd)) * (-pisqu + 3.0 * power_of<2>(log((w + yd) / w)) + 2.0 * power_of<2>(log((w + yd) / (1.0 + w)))) + log((1.0 - w) / (1.0 + yd)) * (-power_of<2>(log((w + yd) / w)) + 4.0 * power_of<2>(log((w + yd) / (1.0 + w)))) + power_of<2>(log((1.0 + yd) / (1.0 - w))) * (2.0 * log((-0.5) * (((-1.0 + w) * (-1.0 + yd)) / (w + yd))) + 2.0 * log((-2.0 * (w + yd)) / ((-1.0 + w) * (-1.0 + yd)))) + power_of<2>(log((1.0 - yd) / 2.0)) * (2.0 * log((1.0 + w) / (w + yd)) - 2.0 * log(((1.0 + w) * (1.0 + yd)) / (2.0 * (w + yd))) + 2.0 * log((w + yd) / (1.0 + w)) - 2.0 * log((2.0 * (w + yd)) / ((1.0 + w) * (1.0 + yd)))) + (pisqu / 3.0 - 2.0 * ln2squ) * log(1.0 - yd / w)
                + 2.0 * log(yd / w) * power_of<2>(log(1.0 - yd / w)) + log(w / yd) * (-pisqu + 3.0 * power_of<2>(log(1.0 - yd / w))) - (4.0 * pisqu * log((1.0 + w) / (w - w * yd))) / 3.0 - (4.0 * power_of<3>(log((1.0 + w) / (w - w * yd)))) / 3.0 + (pisqu * log(w / (yd - w * yd))) / 3.0 + power_of<3>(log(w / (yd - w * yd))) / 3.0 + power_of<2>(log(1.0 + winv)) * log((w - yd) / (w + w * yd)) - (2.0 * 1.0i) * M_PI * H1(-ydinv, -winv) * power_of<2>(log(w - yd)) * my_sign(-imag(winv)) - (4.0 * 1.0i) * M_PI * H1((-1.0 + w) / (1.0 + w), (-1.0 + w) / w) * power_of<2>(log(1.0 / (-1.0 + w))) * my_sign(imag(winv))
                + (4.0 * 1.0i) * M_PI * H1(1.0 + winv, (-1.0 + w) / w) * power_of<2>(log((-2.0 * w) / (-1.0 + power_of<2>(w)))) * my_sign(imag(winv)) + (8.0 * 1.0i) * M_PI * H1((1.0 + w) / (1.0 - yd), 1.0 / (1.0 - yd)) * power_of<2>(log((w * (-1.0 + yd)) / (1.0 + w))) * my_sign(imag(1.0 / (1.0 - yd))) - (12.0 * 1.0i) * M_PI * H1((1.0 + w) / (1.0 - yd), -2.0 / (-1.0 + yd)) * power_of<2>(log(((-1.0 + w) * (-1.0 + yd)) / (2.0 * (1.0 + w)))) * my_sign(2.0 * imag(1.0 / (1.0 - yd))) + (8.0 * 1.0i) * M_PI * H1(2.0 / (1.0 + w), -2.0 / (-1.0 + yd)) * power_of<2>(log((w + yd) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 - yd)))
                - (8.0 * 1.0i) * M_PI * H1(-2.0 / (-1.0 + yd), (1.0 + w) / (1.0 - yd)) * power_of<2>(log((-0.5) * (((-1.0 + w) * (-1.0 + yd)) / (1.0 + w)))) * my_sign(imag((1.0 + w) / (1.0 - yd))) + (4.0 * 1.0i) * M_PI * H1(1.0 + w, (1.0 + w) / (1.0 - yd)) * power_of<2>(log(yd / (1.0 + w))) * my_sign(imag((1.0 + w) / (1.0 - yd))) + (8.0 * 1.0i) * M_PI * H1((1.0 + w) / 2.0, (1.0 + w) / (1.0 - yd)) * power_of<2>(log((1.0 + yd) / (1.0 + w))) * my_sign(imag((1.0 + w) / (1.0 - yd))) - (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - yd), (1.0 + w) / (1.0 - yd)) * power_of<2>(log((w - w * yd) / (1.0 + w))) * my_sign(imag((1.0 + w) / (1.0 - yd)))
                + (4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - yd), (-1.0 + w) / (-1.0 + yd)) * power_of<2>(log(-((w * (-1.0 + yd)) / (-1.0 + w)))) * my_sign(imag((-1.0 + w) / (-1.0 + yd))) - (2.0 * 1.0i) * M_PI * H1(-(w / yd), -ydinv) * power_of<2>(log(((-1.0 + w) * yd) / w)) * my_sign(-imydinv) + power_of<2>(log(-w + yd)) * ((-4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 - w), 1.0 / (1.0 - yd)) * my_sign(imag(1.0 / (1.0 - yd))) + (2.0 * 1.0i) * M_PI * H1(-winv, -ydinv) * my_sign(-imydinv)) + power_of<2>(log(w + yd)) * ((-4.0 * 1.0i) * M_PI * H1(1.0 / (1.0 + w), 1.0 / (1.0 - yd)) * my_sign(imag(1.0 / (1.0 - yd))) + (8.0 * 1.0i) * M_PI * H1(winv, -ydinv) * my_sign(-imydinv))
                - (4.0 * 1.0i) * M_PI * H1(-winv, ydinv) * power_of<2>(log(-w - yd)) * my_sign(imydinv) - (4.0 * 1.0i) * M_PI * H1(-ydinv, -(w / yd)) * power_of<2>(log((-1.0 + winv) * yd)) * my_sign(-imag(w / yd)) + power_of<2>(log((1.0 + yd) / w)) * ((-2.0 * 1.0i) * M_PI * H1(w / yd, -w) * my_sign(-imag(w)) - (2.0 * 1.0i) * M_PI * H1(w, -(w / yd)) * my_sign(-imag(w / yd))) - (6.0 * 1.0i) * M_PI * H1(-w, w / yd) * power_of<2>(log(-((1.0 + yd) / w))) * my_sign(imag(w / yd)) + (4.0 * 1.0i) * M_PI * H1(-2.0 / (-1.0 + w), 2.0 / (1.0 + yd)) * power_of<2>(log((-w - yd) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 + yd)))
                - (4.0 * 1.0i) * M_PI * H1((1.0 - w) / (1.0 + yd), 2.0 / (1.0 + yd)) * power_of<2>(log(((1.0 + w) * (1.0 + yd)) / (2.0 - 2.0 * w))) * my_sign(2.0 * imag(1.0 / (1.0 + yd))) - (4.0 * 1.0i) * M_PI * H1((-1.0 + w) / (1.0 + w), (-1.0 + w) / (w + yd)) * power_of<2>(log((1.0 - yd) / (-1.0 + w))) * my_sign(imag((-1.0 + w) / (w + yd))) + (4.0 * 1.0i) * M_PI * H1((1.0 + w) / (w + yd), (-1.0 + w) / (w + yd)) * power_of<2>(log((-2.0 * (w + yd)) / (-1.0 + power_of<2>(w)))) * my_sign(imag((-1.0 + w) / (w + yd))) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + ydinv)) * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv)
                - (4.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w))) * my_sign(imag((1.0 + w) / (-1.0 + w))) * T(1.0, 1.0 / (1.0 - w), -2.0 / (-1.0 + w)) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 + w))) * my_sign(-imag(w / (1.0 + w))) * T(1.0, 1.0 / (1.0 - w), 1.0 / (1.0 + w)) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w / yd)) * my_sign(imag(w / yd)) * T(1.0, 1.0 + w, 1.0 - w / yd) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w) / 2.0)) * my_sign((-0.5) * imag(w)) * T(1.0, (1.0 - yd) / 2.0, (1.0 + w) / 2.0) + (4.0 * 1.0i) * M_PI * power_of<2>(log((w + yd) / (-1.0 + w))) * my_sign(imag((1.0 + yd) / (1.0 - w))) * T(1.0, (1.0 - yd) / 2.0, (w + yd) / (-1.0 + w))
                - (8.0 * 1.0i) * M_PI * log((1.0 - w) / 2.0) * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + log((1.0 + yd) / 2.0) * (ln1pyd * (4.0 * log((w - yd) / (1.0 + w)) + 8.0 * log(1.0 - yd / w)) - (4.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(w)) * T(1.0, 1.0 - yd, 1.0 + w) + (4.0 * 1.0i) * M_PI * log((w + yd) / w) * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)) + (4.0 * 1.0i) * M_PI * power_of<2>(log(w / (-1.0 + w))) * my_sign(imag(1.0 / (1.0 - w))) * T(1.0, (w - yd) / (-1.0 + w), w / (-1.0 + w)) - (8.0 * 1.0i) * M_PI * power_of<2>(log(-w)) * my_sign(-imag(w)) * T(1.0, yd, -w)
                + power_of<2>(log((w - yd) / (-1.0 + w))) * (-2.0 * log((-1.0 + w) / (-1.0 + yd)) - 2.0 * log(yd / w) + 2.0 * log(((-1.0 + w) * yd) / (w * (-1.0 + yd))) - (4.0 * 1.0i) * M_PI * my_sign(imag((-1.0 + yd) / (-1.0 + w))) * T(1.0, yd, (w - yd) / (-1.0 + w))) - (12.0 * 1.0i) * M_PI * power_of<2>(log((1.0 - w) / 2.0)) * my_sign(imag(w) / 2.0) * T(1.0, (1.0 + yd) / 2.0, (1.0 - w) / 2.0) + ln1pyd * (log((1.0 - yd) / 2.0) * (8.0 * log((w + yd) / w) + 4.0 * log((w + yd) / (1.0 + w))) + (8.0 * 1.0i) * M_PI * log((1.0 + w) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 + yd))) * T(1.0, (1.0 - yd) / 2.0, (1.0 + w) / 2.0)
                    + (8.0 * 1.0i) * M_PI * log((1.0 + w) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 - yd))) * T(1.0, (1.0 + yd) / 2.0, (1.0 + w) / 2.0)) + power_of<2>(log((w + yd) / (1.0 + w))) * (-4.0 * log(((-1.0 + w) * (-1.0 + yd)) / ((1.0 + w) * (1.0 + yd))) - 4.0 * log(((1.0 + w) * (1.0 + yd)) / ((-1.0 + w) * (-1.0 + yd))) - (4.0 * 1.0i) * M_PI * my_sign(imag((1.0 - yd) / (1.0 + w))) * T(1.0, yd, (w + yd) / (1.0 + w)) + (8.0 * 1.0i) * M_PI * my_sign(imag((1.0 - yd) / (1.0 + w))) * T(1.0, (1.0 + yd) / 2.0, (w + yd) / (1.0 + w))) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w)) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) - (8.0 * 1.0i) * M_PI * log(1.0 - w) * log((1.0 + w) / 2.0) * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w)
                + (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + w)) * my_sign(-imag(w)) * T(1.0, 1.0 + yd, 1.0 + w) + power_of<2>(log((w + yd) / w)) * ((-4.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w) + (8.0 * 1.0i) * M_PI * my_sign(-imag(yd / w)) * T(1.0, 1.0 + yd, (w + yd) / w)) + power_of<2>(log(1.0 - yd / w)) * (-3.0 * log((1.0 + w) / (1.0 + yd)) + 3.0 * log((yd + w * yd) / (w + w * yd)) + (2.0 * 1.0i) * M_PI * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w)) + (4.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w))) * my_sign(imag((1.0 + w) / (-1.0 + w))) * T(1.0, (1.0 + yd) / (1.0 - w), -2.0 / (-1.0 + w))
                + log((w + yd) / w) * ((-2.0 * pisqu) / 3.0 + 4.0 * ln2squ - (8.0 * 1.0i) * M_PI * log(-2.0 / (-1.0 + w)) * my_sign(imag((-1.0 + w) / (w + yd))) * T(1.0, (1.0 + yd) / (1.0 - w), -2.0 / (-1.0 + w))) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0 - yd) / (1.0 + w))) * my_sign(imag((w + yd) / (1.0 + w))) * T(1.0, (1.0 + yd) / (1.0 - w), (1.0 - yd) / (1.0 + w)) + (8.0 * 1.0i) * M_PI * log(1.0 + winv) * log(-2.0 / (-1.0 + w)) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w)
                - (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * log(2.0 / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + (8.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * log((1.0 - yd) / (1.0 + w)) * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) + log((1.0 + yd) / (1.0 - w)) * (2.0 * power_of<2>(log((w + yd) / w)) + 4.0 * power_of<2>(log((w + yd) / (1.0 + w))) + (4.0 * 1.0i) * M_PI * log((w + yd) / w) * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd)) - (8.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w) / (1.0 + w))) * my_sign(2.0 * imag(1.0 / (1.0 + w))) * T(1.0, (w + yd) / (1.0 + w), (-1.0 + w) / (1.0 + w))
                + (4.0 * 1.0i) * M_PI * power_of<2>(log(w / (1.0 + w))) * my_sign(-imag(1.0 / (1.0 + w))) * T(1.0, (w + yd) / (1.0 + w), w / (1.0 + w)) + power_of<2>(log(yd)) * (-2.0 * log(w / (w + yd)) - 4.0 * log((w + yd) / w) + 4.0 * log((w + yd) / (w - w * yd)) + 2.0 * log((w - w * yd) / (w - yd)) + 2.0 * log((w - w * yd) / (w + yd)) - (4.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / (1.0 + w), yd))
                + power_of<2>(log((1.0 + yd) / 2.0)) * (4.0 * log((-1.0 + w) / (w + yd)) - 4.0 * log((-0.5) * (((-1.0 + w) * (-1.0 + yd)) / (w + yd))) + 6.0 * log((w + yd) / (-1.0 + w)) - 6.0 * log((-2.0 * (w + yd)) / ((-1.0 + w) * (-1.0 + yd))) + (8.0 * 1.0i) * M_PI * my_sign((-0.5) * imag(yd)) * T(1.0, (w + yd) / (1.0 + w), (1.0 + yd) / 2.0)) + power_of<2>(ln1pyd) * (-4.0 * log((w - yd) / (1.0 + w)) - log(((1.0 + w) * yd) / (-w + yd)) + 4.0 * log((-1.0 + w) / (w + yd)) + log((w + yd) / (-1.0 + w)) - log((w + yd) / (yd - w * yd)) - 4.0 * log((yd - w * yd) / (w + yd)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, (w + yd) / w, 1.0 + yd)
                    - (6.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)) + 16.0 * pisqu * log((-1.0 + w) / w) * T(1.0, (w + yd) / w, (-1.0 + w) / w) * T(p(winv, (w + yd) / w), (w + yd) / w, 1.0 + winv) + 8.0 * pisqu * log((-1.0 + w) / w) * T(1.0, (w + yd) / w, 1.0 - yd) * T(p(yd, (w + yd) / w), (w + yd) / w, (-1.0 + w) / w)) - 4.0 * pisqu * ln2squ * T(1.0, 1.0 - yd, (w + yd) / w) * T(p(-(yd / w), 1.0 - yd), 1.0 - yd, 2.0)
                + power_of<2>(log((w + yd) / w)) * ((-log(1.0 - w) + 2.0 * log((-1.0 + w) / w)) * log((1.0 + w) / (1.0 - yd)) + (-2.0 * ln2 - log(1.0 - w)) * log((1.0 - yd) / (1.0 + w)) + (log(1.0 - w) - 2.0 * log((-1.0 + w) / w)) * log(((1.0 + w) * yd) / (w * (-1.0 + yd))) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(-imag(yd / w)) * T(1.0, 1.0 + winv, (w + yd) / w) - (4.0 * 1.0i) * M_PI * ln2 * my_sign(-imag(yd / w)) * T(1.0, (-1.0 + w) / w, (w + yd) / w) - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(yd / w)) * T(1.0, (-1.0 + w) / w, (w + yd) / w) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(-imag(yd / w)) * T(1.0, 1.0 - yd, (w + yd) / w)
                + (4.0 * 1.0i) * M_PI * log(winv) * my_sign(imag(w / (w + yd))) * T(1.0, -(yd / w), winv) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(-imag(yd / w)) * T(1.0, 1.0 + yd, (w + yd) / w) - (2.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(-imag(yd / w)) * T(1.0, 1.0 + yd, (w + yd) / w) - 4.0 * pisqu * T(1.0, 1.0 - yd, (w + yd) / w) * T(p(-(yd / w), 1.0 - yd), 1.0 - yd, 2.0)) - 4.0 * pisqu * ln2squ * T(1.0, 1.0 + yd, 1.0 - yd / w) * T(p(yd / w, 1.0 + yd), 1.0 + yd, 2.0)
                + power_of<2>(log(1.0 - yd / w)) * ((-log(1.0 - w) + 2.0 * log((-1.0 + w) / w)) * log((1.0 + w) / (1.0 + yd)) + (-2.0 * ln2 - log(1.0 - w)) * log((1.0 + yd) / (1.0 + w)) + (2.0 * ln2 + log(1.0 - w)) * log((w + w * yd) / (yd + w * yd)) + (log(1.0 - w) - 2.0 * log((-1.0 + w) / w)) * log((yd + w * yd) / (w + w * yd)) - (4.0 * 1.0i) * M_PI * log((-1.0 + w) / w) * my_sign(imag(yd / w)) * T(1.0, 1.0 + winv, 1.0 - yd / w) - (4.0 * 1.0i) * M_PI * ln2 * my_sign(imag(yd / w)) * T(1.0, (-1.0 + w) / w, 1.0 - yd / w) - (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(imag(yd / w)) * T(1.0, (-1.0 + w) / w, 1.0 - yd / w)
                - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(yd / w)) * T(1.0, 1.0 - yd, 1.0 - yd / w) - (2.0 * 1.0i) * M_PI * log(1.0 + w) * my_sign(imag(yd / w)) * T(1.0, 1.0 - yd, 1.0 - yd / w) + (4.0 * 1.0i) * M_PI * log(winv) * my_sign(imag(w / (w - yd))) * T(1.0, yd / w, winv) - (2.0 * 1.0i) * M_PI * ln2 * my_sign(imag(yd / w)) * T(1.0, 1.0 + yd, 1.0 - yd / w) - 4.0 * pisqu * T(1.0, 1.0 + yd, 1.0 - yd / w) * T(p(yd / w, 1.0 + yd), 1.0 + yd, 2.0))
                + log(1.0 / (1.0 - yd)) * (pisqu * log(1.0 + winv) - (pisqu * log(1.0 - w)) / 3.0 + (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 - 2.0 * log(1.0 - w) * power_of<2>(log(w)) - (pisqu * log(1.0 + w)) / 3.0 - (2.0 * pisqu * log((w + yd) / w)) / 3.0 - (pisqu * log(1.0 - yd / w)) / 3.0 - 2.0 * power_of<2>(log(yd / w)) * log(1.0 - yd / w) + (2.0 * 1.0i) * M_PI * H2(-winv, ydinv) * power_of<2>(log((w + yd) / (-1.0 + yd))) * my_sign(-imag(winv)) - (2.0 * 1.0i) * M_PI * H2(-(w / yd), ydinv) * power_of<2>(log(((1.0 + w) * yd) / (w * (-1.0 + yd)))) * my_sign(-imag(w / yd)) - 12.0 * zeta3)
                + log(1.0 / (1.0 + yd)) * (pisqu * log(1.0 + winv) - (pisqu * log(1.0 - w)) / 3.0 + (2.0 * pisqu * log((-1.0 + w) / w)) / 3.0 - 2.0 * log(1.0 - w) * power_of<2>(log(w)) - (pisqu * log(1.0 + w)) / 3.0 - (pisqu * log((w + yd) / w)) / 3.0 - 2.0 * power_of<2>(log(-(yd / w))) * log((w + yd) / w) - (2.0 * pisqu * log(1.0 - yd / w)) / 3.0 + (2.0 * 1.0i) * M_PI * H2(-winv, -ydinv) * power_of<2>(log((-w + yd) / (1.0 + yd))) * my_sign(-imag(winv)) - (2.0 * 1.0i) * M_PI * H2(w / yd, -ydinv) * power_of<2>(log((yd + w * yd) / (w + w * yd))) * my_sign(imag(w / yd)) - 12.0 * zeta3)
                + log((w * (1.0 + yd)) / (w + yd)) * ((-2.0 * pisqu * log(1.0 - w)) / 3.0 - lnhalf * power_of<2>(log(1.0 - w)) - (2.0 * power_of<3>(log(1.0 - w))) / 3.0 - 2.0 * ln2 * power_of<2>(log((-1.0 + w) / w)) - 2.0 * log(1.0 + winv) * power_of<2>(log((-1.0 + w) / w)) - power_of<2>(log(1.0 - w)) * log(w / (1.0 + w)) - 4.0 * zeta3) + log((w - w * yd) / (w - yd)) * ((-2.0 * pisqu * log(1.0 - w)) / 3.0 - lnhalf * power_of<2>(log(1.0 - w)) - (2.0 * power_of<3>(log(1.0 - w))) / 3.0 - 2.0 * ln2 * power_of<2>(log((-1.0 + w) / w)) - 2.0 * log(1.0 + winv) * power_of<2>(log((-1.0 + w) / w)) - power_of<2>(log(1.0 - w)) * log(w / (1.0 + w)) - 4.0 * zeta3)
                + log((w - yd) / (-1.0 + w)) * (6.0 * power_of<2>(log((1.0 - yd) / 2.0)) * ln1pyd + 8.0 * log((1.0 - yd) / 2.0) * power_of<2>(ln1pyd) + 2.0 * log(1.0 - w) * power_of<2>(log((w - w * yd) / (w - yd))) - 4.0 * zeta3) + log((1.0 + yd) / (1.0 - w)) * ((-2.0 * power_of<3>(log((w + yd) / w))) / 3.0 - 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w + yd) / (w + w * yd))) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) + log((w + yd) / w) * ((-2.0 * pisqu) / 3.0 + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv))
                + power_of<2>(log((w + yd) / w)) * (-log(1.0 / (1.0 + w)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, (w + yd) / w, 1.0 + winv) - (2.0 * 1.0i) * M_PI * my_sign(imag(yd)) * T(1.0, (w + yd) / w, 1.0 - yd)) - 4.0 * zeta3) + log((-1.0 + yd) / (-1.0 + w)) * (-(log(yd / (1.0 + yd)) * power_of<2>(log(1.0 - yd / w))) - (2.0 * power_of<3>(log(1.0 - yd / w))) / 3.0 - 4.0 * log((-1.0 + w) / w) * power_of<2>(log((w - yd) / (w - w * yd))) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + winv)) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) + log(1.0 - yd / w) * ((-2.0 * pisqu) / 3.0 + (4.0 * 1.0i) * M_PI * log(1.0 + winv) * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv))
                + power_of<2>(log(1.0 - yd / w)) * (-log(1.0 / (1.0 + w)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(winv)) * T(1.0, 1.0 - yd / w, 1.0 + winv) - (2.0 * 1.0i) * M_PI * my_sign(-imag(yd)) * T(1.0, 1.0 - yd / w, 1.0 + yd)) - 4.0 * zeta3) + 8.0 * log(1.0 / (1.0 - w)) * zeta3 + 8.0 * log(w / (-1.0 + w)) * zeta3 - 4.0 * log((w + yd) / (-1.0 + w)) * zeta3 - (8.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, 1.0 + winv, 1.0 + ydinv) * zeta3 - (8.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, 1.0 + winv, (-1.0 + yd) / yd) * zeta3 + (8.0 * 1.0i) * M_PI * my_sign(imag(w / yd)) * T(1.0, 1.0 - w, 1.0 - w / yd) * zeta3
                + (8.0 * 1.0i) * M_PI * my_sign(-imag(w / yd)) * T(1.0, 1.0 - w, (w + yd) / yd) * zeta3 - (16.0 * 1.0i) * M_PI * my_sign(-imydinv) * T(1.0, (-1.0 + w) / w, 1.0 + ydinv) * zeta3 - (16.0 * 1.0i) * M_PI * my_sign(imydinv) * T(1.0, (-1.0 + w) / w, (-1.0 + yd) / yd) * zeta3 + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 - yd, 1.0 - w) * zeta3 + (8.0 * 1.0i) * M_PI * my_sign(imag(w)) * T(1.0, 1.0 + yd, 1.0 - w) * zeta3 + (8.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, (w + yd) / w, (-1.0 + w) / w) * zeta3 + (8.0 * 1.0i) * M_PI * my_sign(imag(winv)) * T(1.0, 1.0 - yd / w, (-1.0 + w) / w) * zeta3
                + log((w + yd) / (w - w * yd)) * ((2.0 * pisqu * log(1.0 + winv)) / 3.0 + 2.0 * lnhalf * power_of<2>(log(1.0 + winv)) + (2.0 * power_of<3>(log(1.0 + winv))) / 3.0 + 4.0 * zeta3) + log((w - yd) / (w + w * yd)) * ((2.0 * pisqu * log(1.0 + winv)) / 3.0 + 2.0 * lnhalf * power_of<2>(log(1.0 + winv)) + (2.0 * power_of<3>(log(1.0 + winv))) / 3.0 + 4.0 * zeta3)
                + log(w / (w - yd)) * (2.0 * log(1.0 + winv) * power_of<2>(log(-winv)) + 4.0 * power_of<2>(log(winv)) * log((-1.0 + w) / w) - 2.0 * power_of<2>(log(-yd)) * ln1pyd - (2.0 * pisqu * log(1.0 - yd / w)) / 3.0 + 2.0 * power_of<2>(log(yd / w)) * log(1.0 - yd / w) + (2.0 * 1.0i) * M_PI * H2(-w, w / yd) * power_of<2>(log(-((1.0 + yd) / (w - yd)))) * my_sign(-imag(w)) + (2.0 * 1.0i) * M_PI * H2(-ydinv, w / yd) * power_of<2>(log(((1.0 + w) * yd) / (-w + yd))) * my_sign(-imydinv) + 4.0 * zeta3)
                + log(w / (w + yd)) * (2.0 * log(1.0 + winv) * power_of<2>(log(-winv)) + 4.0 * power_of<2>(log(winv)) * log((-1.0 + w) / w) - (2.0 * pisqu * log((w + yd) / w)) / 3.0 + 2.0 * power_of<2>(log(-(yd / w))) * log((w + yd) / w) + (2.0 * 1.0i) * M_PI * H2(-w, -(w / yd)) * power_of<2>(log((-1.0 + yd) / (w + yd))) * my_sign(-imag(w)) + (2.0 * 1.0i) * M_PI * H2(ydinv, -(w / yd)) * power_of<2>(log(((1.0 + w) * yd) / (w + yd))) * my_sign(imydinv) + 4.0 * zeta3)
                + log((w - yd) / (w - w * yd)) * (ln2 * power_of<2>(log(1.0 - w)) + (4.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + 2.0 * lnhalf * power_of<2>(log((-1.0 + w) / w)) + (4.0 * power_of<3>(log((-1.0 + w) / w))) / 3.0 + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(1.0 / (1.0 + w)) + power_of<2>(log(1.0 - w)) * log(1.0 + w) + 8.0 * zeta3) + log((w + yd) / (w + w * yd)) * (ln2 * power_of<2>(log(1.0 - w)) + (4.0 * pisqu * log((-1.0 + w) / w)) / 3.0 + 2.0 * lnhalf * power_of<2>(log((-1.0 + w) / w)) + (4.0 * power_of<3>(log((-1.0 + w) / w))) / 3.0 + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(1.0 / (1.0 + w)) + power_of<2>(log(1.0 - w)) * log(1.0 + w) + 8.0 * zeta3)
                + log((w + yd) / w) * ((4.0 * pisqu * lnm1) / 3.0 + (4.0 * power_of<3>(lnm1)) / 3.0 - (pisqu * ln2) / 3.0 - 4.0 * lnm1 * ln2squ + 2.0 * power_of<3>(ln2) - (pisqu * ln4) / 3.0 + 2.0 * power_of<2>(log(1.0 + winv)) * log((1.0 - w) / 2.0) + 2.0 * power_of<2>(log(1.0 + winv)) * log(-2.0 / (-1.0 + w)) - 2.0 * power_of<2>(log(1.0 + winv)) * log(-winv) + (pisqu * log(1.0 / (2.0 * w))) / 3.0 + power_of<3>(log(1.0 / (2.0 * w))) / 3.0 - (2.0 * pisqu * log(winv)) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(winv) - (2.0 * power_of<3>(log(winv))) / 3.0 - 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / (2.0 * w)) - 4.0 * log(winv) * power_of<2>(log((-1.0 + w) / w))
                - (2.0 * pisqu * log((-0.5) * w)) / 3.0 - (2.0 * power_of<3>(log((-0.5) * w))) / 3.0 - (2.0 * pisqu * log(w)) / 3.0 + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(w) - (2.0 * power_of<3>(log(w))) / 3.0 + (2.0 * pisqu * log(w / (-1.0 + w))) / 3.0 + (2.0 * power_of<3>(log(w / (-1.0 + w)))) / 3.0 - 2.0 * power_of<2>(log(1.0 + winv)) * log((2.0 * w) / (-1.0 + w)) + (pisqu * log(1.0 / (1.0 + w))) / 3.0 + power_of<3>(log(1.0 / (1.0 + w))) / 3.0 - power_of<2>(log(1.0 - w)) * log(2.0 / (1.0 + w)) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(2.0 / (1.0 + w)) + 2.0 * ln2squ * log((1.0 - w) / (1.0 + w)) - 2.0 * ln2squ * log((-1.0 + w) / (1.0 + w)) - (2.0 * pisqu * log(-(w / (1.0 + w)))) / 3.0
                - (2.0 * power_of<3>(log(-(w / (1.0 + w))))) / 3.0 + (2.0 * pisqu * log(w / (1.0 + w))) / 3.0 + (2.0 * power_of<3>(log(w / (1.0 + w)))) / 3.0 + power_of<2>(log(1.0 - w)) * log((2.0 * w) / (1.0 + w)) - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((2.0 * w) / (1.0 + w)) + power_of<2>(log(1.0 - w)) * log((1.0 + w) / 2.0) - power_of<2>(log(1.0 - w)) * log((1.0 + w) / (2.0 * w)) - (2.0 * pisqu * log(-1.0 / (1.0 + yd))) / 3.0 - (2.0 * power_of<3>(log(-1.0 / (1.0 + yd)))) / 3.0 - (2.0 * pisqu * log(((-1.0 + w) * w) / (w + yd))) / 3.0 - (2.0 * power_of<3>(log(((-1.0 + w) * w) / (w + yd)))) / 3.0 + (4.0 * 1.0i) * M_PI * H1(w / (w + yd), (-1.0 + w) / (w + yd)) * power_of<2>(log((w + yd) / (w - power_of<2>(w)))) * my_sign(imag((-1.0 + w) / (w + yd)))
                - (4.0 * 1.0i) * M_PI * H1(w / (-1.0 + w), w / (w + yd)) * power_of<2>(log(-((1.0 + yd) / w))) * my_sign(imag(w / (w + yd))) + (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 - w))) * my_sign(-imag(w / (1.0 - w))) * T(1.0, (1.0 + yd) / (1.0 - w), 1.0 / (1.0 - w)) + 8.0 * pisqu * ln2 * T(1.0, 1.0 - yd, (w + yd) / w) * T(p(-(yd / w), 1.0 - yd), 1.0 - yd, 2.0) + (21.0 * zeta3) / 2.0)
                + log(1.0 - yd / w) * ((4.0 * pisqu * lnm1) / 3.0 + (4.0 * power_of<3>(lnm1)) / 3.0 - (pisqu * ln2) / 3.0 - 4.0 * lnm1 * ln2squ + 2.0 * power_of<3>(ln2) - (pisqu * ln4) / 3.0 + 2.0 * power_of<2>(log(1.0 + winv)) * log((1.0 - w) / 2.0) + 2.0 * power_of<2>(log(1.0 + winv)) * log(-2.0 / (-1.0 + w)) - 2.0 * power_of<2>(log(1.0 + winv)) * log(-winv) + (pisqu * log(1.0 / (2.0 * w))) / 3.0 + power_of<3>(log(1.0 / (2.0 * w))) / 3.0 - (2.0 * pisqu * log(winv)) / 3.0 + 2.0 * power_of<2>(log(1.0 - w)) * log(winv) - (2.0 * power_of<3>(log(winv))) / 3.0 - 2.0 * power_of<2>(log(1.0 + winv)) * log((-1.0 + w) / (2.0 * w)) - 4.0 * log(winv) * power_of<2>(log((-1.0 + w) / w))
                - (2.0 * pisqu * log((-0.5) * w)) / 3.0 - (2.0 * power_of<3>(log((-0.5) * w))) / 3.0 - (2.0 * pisqu * log(w)) / 3.0 + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(w) - (2.0 * power_of<3>(log(w))) / 3.0 + (2.0 * pisqu * log(w / (-1.0 + w))) / 3.0 + (2.0 * power_of<3>(log(w / (-1.0 + w)))) / 3.0 - 2.0 * power_of<2>(log(1.0 + winv)) * log((2.0 * w) / (-1.0 + w)) + (pisqu * log(1.0 / (1.0 + w))) / 3.0 + power_of<3>(log(1.0 / (1.0 + w))) / 3.0 - power_of<2>(log(1.0 - w)) * log(2.0 / (1.0 + w)) + 2.0 * power_of<2>(log((-1.0 + w) / w)) * log(2.0 / (1.0 + w)) + 2.0 * ln2squ * log((1.0 - w) / (1.0 + w)) - 2.0 * ln2squ * log((-1.0 + w) / (1.0 + w)) - (2.0 * pisqu * log(-(w / (1.0 + w)))) / 3.0
                - (2.0 * power_of<3>(log(-(w / (1.0 + w))))) / 3.0 + (2.0 * pisqu * log(w / (1.0 + w))) / 3.0 + (2.0 * power_of<3>(log(w / (1.0 + w)))) / 3.0 + power_of<2>(log(1.0 - w)) * log((2.0 * w) / (1.0 + w)) - 2.0 * power_of<2>(log((-1.0 + w) / w)) * log((2.0 * w) / (1.0 + w)) + power_of<2>(log(1.0 - w)) * log((1.0 + w) / 2.0) - power_of<2>(log(1.0 - w)) * log((1.0 + w) / (2.0 * w)) - (2.0 * pisqu * log(((-1.0 + w) * w) / (w - yd))) / 3.0 - (2.0 * power_of<3>(log(((-1.0 + w) * w) / (w - yd)))) / 3.0 - (2.0 * pisqu * log(1.0 / (-1.0 + yd))) / 3.0 - (2.0 * power_of<3>(log(1.0 / (-1.0 + yd)))) / 3.0 + (4.0 * 1.0i) * M_PI * H1(w / (w - yd), (-1.0 + w) / (w - yd)) * power_of<2>(log((w - yd) / (w - power_of<2>(w)))) * my_sign(imag((-1.0 + w) / (w - yd)))
                - (4.0 * 1.0i) * M_PI * H1(w / (-1.0 + w), w / (w - yd)) * power_of<2>(log((-1.0 + yd) / w)) * my_sign(imag(w / (w - yd))) + (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 - w))) * my_sign(imag(w / (-1.0 + w))) * T(1.0, (-1.0 + yd) / (-1.0 + w), 1.0 / (1.0 - w)) + 8.0 * pisqu * ln2 * T(1.0, 1.0 + yd, 1.0 - yd / w) * T(p(yd / w, 1.0 + yd), 1.0 + yd, 2.0) + (21.0 * zeta3) / 2.0);

            return result;
        }
    }
}
