/* vim: set sw=4 sts=4 et foldmethod=syntax : */

/*
 * Copyright (c) 2023 Viktor Kuschke
 *
 * This file is part of the EOS project. EOS is free software;
 * you can redistribute it and/or modify it under the terms of the GNU General
 * Public License version 2, as published by the Free Software Foundation.
 *
 * EOS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <eos/maths/power-of.hh>
#include <eos/maths/polylog.hh>
#include <eos/maths/multiplepolylog-li22.hh>

#include <eos/rare-b-decays/charm-loops-impl.hh>

#include <eos/utils/exception.hh>
#include <eos/utils/log.hh>
#include <eos/utils/stringify.hh>

#include <cmath>
#include <complex>

namespace eos
{
	using std::complex;
	using std::log;
	using std::real;
	using std::imag;

	namespace agv_2019a
	{
		complex<double> f279b_helper(const CharmLoopsParameters & clp)
		{
			const complex<double> xb = clp.xb;
			const complex<double> yb = clp.yb;

			const complex<double> xbinv = 1.0 / xb;
            const complex<double> xb2 = power_of<2>(xb);
            const complex<double> xb4 = power_of<4>(xb);
            const complex<double> xb6 = power_of<6>(xb);

            const complex<double> yb2 = power_of<2>(yb);

			// weights appearing in the GPLs [AGV:2019A] p. 34

            const double wx3 = 2.0 + sqrt(3);
            const double wx4 = 2.0 - sqrt(3);

            const complex<double> w4 = (2.0 * xb) / power_of<2>(1.0 - xb);
            const complex<double> w5 = (2.0 * xb) / power_of<2>(1.0 + xb);
            const complex<double> w7 = (8.0 * xb2) / (1.0 - 6.0 * xb2 + xb4);

            const double wx3inv = wx4;
            const double wx4inv = wx3;

            const complex<double> w4inv = 1.0 / w4;
            const complex<double> w5inv = 1.0 / w5;
            const complex<double> w7inv = 1.0 / w7;

            const complex<double> tb = (2.0 * (-2.0 * xb2 + 2.0 * xb2 * yb + sqrt(2) * xb2 * (1.0 + yb) * sqrt((2.0 * xb4 - xb2 * yb + 2.0 * xb4 * yb - xb6 * yb + xb2 * yb2 + 4.0 * xb4 * yb2 + xb6 * yb2) / (xb4 * power_of<2>(1.0 + yb))))) / (-1.0 + 6.0 * xb2 - xb4 + yb + 2.0 * xb2 * yb + xb4 * yb);
            const complex<double> vb = (2.0 * (-2.0 * xb2 - 2.0 * xb2 * yb + sqrt(2) * xb2 * (1.0 - yb) * sqrt((2.0 * xb4 + xb2 * yb - 2.0 * xb4 * yb + xb6 * yb + xb2 * yb2 + 4.0 * xb4 * yb2 + xb6 * yb2) / (xb4 * power_of<2>(1.0 - yb))))) / (1.0 - 6.0 * xb2 + xb4 + yb + 2.0 * xb2 * yb + xb4 * yb);

			const complex<double> result = (-1.0 / 3.0) * (pisqu * ln2) + 8.0 * trilog(-1.0) - 28.0 * li3half - 2.0 * trilog(1.0 / (1.0 - tb)) - 4.0 * trilog((1.0 - tb) / 2.0) + 2.0 * trilog(-tb) - 2.0 * trilog(tb) - 2.0 * trilog(tb / (-1.0 + tb)) + trilog((2.0 * tb) / (-1.0 + tb)) + 2.0 * trilog(1.0 / (1.0 + tb)) - 2.0 * trilog((-1.0 + tb) / (1.0 + tb)) + 2.0 * trilog(tb / (1.0 + tb)) - trilog((2.0 * tb) / (1.0 + tb)) - 4.0 * trilog((1.0 + tb) / 2.0) - 2.0 * trilog((1.0 + tb) / (-1.0 + tb)) + 2.0 * trilog(1.0 / (1.0 - vb)) - 4.0 * trilog((1.0 - vb) / 2.0) - 2.0 * trilog(-vb) + 2.0 * trilog(vb) + 2.0 * trilog(vb / (-1.0 + vb)) - trilog((2.0 * vb) / (-1.0 + vb))
                - 2.0 * trilog(1.0 / (1.0 + vb)) - 2.0 * trilog((-1.0 + vb) / (1.0 + vb)) - 2.0 * trilog(vb / (1.0 + vb)) + trilog((2.0 * vb) / (1.0 + vb)) - 4.0 * trilog((1.0 + vb) / 2.0) - 2.0 * trilog((1.0 + vb) / (-1.0 + vb)) - 2.0 * trilog(1.0 / (1.0 - w4)) + trilog((1.0 + vb) / (1.0 - w4)) + 4.0 * trilog(1.0 - w4) - 2.0 * trilog((1.0 - w4) / (1.0 + vb)) - trilog((tb - w4) / (-1.0 + tb)) + trilog((tb - w4) / (1.0 + tb)) + trilog((-1.0 + tb) / (-1.0 + w4)) - 2.0 * trilog((-1.0 + w4) / (-1.0 + tb)) + trilog((-0.5) * (((1.0 + tb) * (-1.0 + w4)) / (tb - w4))) - 2.0 * trilog(-w4inv) + 2.0 * trilog(w4inv)
                + trilog((tb - w4) / ((-1.0 + tb) * w4)) - 2.0 * trilog((-1.0 + w4) / (2.0 * w4)) + 2.0 * trilog(w4 / (-1.0 + w4)) - 2.0 * trilog(1.0 / (1.0 + w4)) + trilog((1.0 + tb) / (1.0 + w4)) + trilog((1.0 - vb) / (1.0 + w4)) - 2.0 * trilog((1.0 - w4) / (1.0 + w4)) + trilog(((1.0 + tb) * (-1.0 + w4)) / ((-1.0 + tb) * (1.0 + w4))) + trilog(((-1.0 + vb) * (-1.0 + w4)) / ((1.0 + vb) * (1.0 + w4))) - 2.0 * trilog(w4 / (1.0 + w4)) - 2.0 * trilog((1.0 + w4) / (1.0 - w4)) + trilog(((-1.0 + tb) * (1.0 + w4)) / (2.0 * (tb - w4))) + trilog(((-1.0 + tb) * (1.0 + w4)) / ((1.0 + tb) * (-1.0 + w4))) + trilog(((1.0 + vb) * (1.0 + w4)) / ((-1.0 + vb) * (-1.0 + w4)))
                - 2.0 * trilog((1.0 + w4) / (2.0 * w4)) - trilog((-tb + w4) / (-1.0 + w4)) + trilog((-tb + w4) / (1.0 + w4)) + trilog((-0.5) * (((-1.0 + vb) * (-1.0 + w4)) / (vb + w4))) + trilog(((1.0 + vb) * (1.0 + w4)) / (2.0 * (vb + w4))) + trilog((vb + w4) / (-1.0 + vb)) - trilog((vb + w4) / (1.0 + vb)) - trilog((vb + w4) / (-1.0 + w4)) + trilog((vb + w4) / (1.0 + w4)) + trilog((tb - w4) / (tb - tb * w4)) - trilog((tb - w4) / (tb + tb * w4)) - trilog(-((tb - w4) / (w4 + tb * w4))) + trilog((vb + w4) / (vb - vb * w4)) - trilog((vb + w4) / (w4 - vb * w4)) - trilog((vb + w4) / (vb + vb * w4))
                + trilog((vb + w4) / (w4 + vb * w4)) - 2.0 * trilog(1.0 / (1.0 - w5)) + trilog((1.0 + tb) / (1.0 - w5)) + trilog((vb - w5) / (-1.0 + vb)) - trilog((vb - w5) / (1.0 + vb)) + trilog((-1.0 + vb) / (-1.0 + w5)) + trilog((-0.5) * (((1.0 + vb) * (-1.0 + w5)) / (vb - w5))) + 2.0 * trilog(-w5inv) - 2.0 * trilog(w5inv) - trilog((vb - w5) / ((-1.0 + vb) * w5)) - 2.0 * trilog((-1.0 + w5) / (2.0 * w5)) - 2.0 * trilog(w5 / (-1.0 + w5)) - 2.0 * trilog(1.0 / (1.0 + w5)) + trilog((1.0 - tb) / (1.0 + w5)) + trilog((1.0 + vb) / (1.0 + w5)) - 2.0 * trilog((1.0 - w5) / (1.0 + w5))
                + trilog(((-1.0 + tb) * (-1.0 + w5)) / ((1.0 + tb) * (1.0 + w5))) + trilog(((1.0 + vb) * (-1.0 + w5)) / ((-1.0 + vb) * (1.0 + w5))) + 2.0 * trilog(w5 / (1.0 + w5)) + 4.0 * trilog(1.0 + w5) - 2.0 * trilog((1.0 + w5) / (1.0 - tb)) - 2.0 * trilog((1.0 + w5) / (1.0 + vb)) - 2.0 * trilog((1.0 + w5) / (1.0 - w5)) + trilog(((-1.0 + vb) * (1.0 + w5)) / (2.0 * (vb - w5))) + trilog(((1.0 + tb) * (1.0 + w5)) / ((-1.0 + tb) * (-1.0 + w5))) + trilog(((-1.0 + vb) * (1.0 + w5)) / ((1.0 + vb) * (-1.0 + w5))) - 2.0 * trilog((1.0 + w5) / (2.0 * w5)) + trilog((-0.5) * (((-1.0 + tb) * (-1.0 + w5)) / (tb + w5))) + trilog(((1.0 + tb) * (1.0 + w5)) / (2.0 * (tb + w5)))
                - trilog((tb + w5) / (-1.0 + tb)) + trilog((tb + w5) / (1.0 + tb)) + trilog((tb + w5) / (-1.0 + w5)) - trilog((tb + w5) / (1.0 + w5)) + trilog((-vb + w5) / (-1.0 + w5)) - trilog((-vb + w5) / (1.0 + w5)) - trilog((tb + w5) / (tb - tb * w5)) + trilog((tb + w5) / (w5 - tb * w5)) + trilog((tb + w5) / (tb + tb * w5)) - trilog((tb + w5) / (w5 + tb * w5)) - trilog((vb - w5) / (vb - vb * w5)) + trilog((vb - w5) / (vb + vb * w5)) + trilog(-((vb - w5) / (w5 + vb * w5))) - 2.0 * trilog(1.0 + w7inv) + 8.0 * trilog(1.0 / (1.0 - w7)) - 4.0 * trilog((1.0 + vb) / (1.0 - w7))
                - 2.0 * trilog((-1.0 + tb) / (tb - w7)) + trilog((tb - w4) / (tb - w7)) + trilog((tb + w5) / (tb - w7)) - 2.0 * trilog((tb - w7) / (-1.0 + tb)) + 2.0 * trilog((tb - w7) / (1.0 + tb)) - 2.0 * trilog(w4 / (w4 - w7)) + trilog((-tb + w4) / (w4 - w7)) + trilog((vb + w4) / (w4 - w7)) + trilog((tb - w7) / (w4 - w7)) + trilog(((-1.0 + w4) * (tb - w7)) / ((-1.0 + tb) * (w4 - w7))) - trilog(((1.0 + w4) * (tb - w7)) / ((1.0 + tb) * (w4 - w7))) + trilog(((-1.0 + tb) * (w4 - w7)) / ((-1.0 + w4) * (tb - w7))) - trilog(((1.0 + tb) * (w4 - w7)) / ((1.0 + w4) * (tb - w7)))
                - 4.0 * trilog((-1.0 + tb) / (-1.0 + w7)) + trilog(((-1.0 + w4) * (tb - w7)) / ((tb - w4) * (-1.0 + w7))) + trilog(-(((1.0 + w5) * (tb - w7)) / ((tb + w5) * (-1.0 + w7)))) + trilog(-(((-1.0 + tb) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7)))) + trilog(-(((1.0 + vb) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7)))) + trilog((-0.5) * (((1.0 + tb) * (-1.0 + w7)) / (tb - w7))) - 2.0 * trilog(-w7inv) + 2.0 * trilog(w7inv) - 2.0 * trilog((w4 - w7) / ((-1.0 + w4) * w7)) - 2.0 * trilog((-1.0 + w7) / (2.0 * w7)) + 2.0 * trilog((-1.0 + w7) / w7) - 2.0 * trilog(-w7) + 6.0 * trilog(w7) - 2.0 * trilog(w7 / w4) - 2.0 * trilog(-(w7 / w5))
                + trilog(((-1.0 + tb) * w7) / (tb - w7)) + trilog(-(((1.0 + tb) * w7) / (tb - w7))) - trilog(-(((tb + w5) * w7) / (w5 * (tb - w7)))) - trilog(-(w7 / (w4 - w7))) - 2.0 * trilog(((-1.0 + w4) * w7) / (w4 - w7)) + 2.0 * trilog(-(((1.0 + w4) * w7) / (w4 - w7))) - trilog(-(((vb + w4) * w7) / (vb * (w4 - w7)))) + 6.0 * trilog(w7 / (-1.0 + w7)) + trilog(((-1.0 + tb) * w7) / (tb * (-1.0 + w7))) + trilog(((1.0 + vb) * w7) / (vb * (-1.0 + w7))) - 2.0 * trilog(((-1.0 + w4) * w7) / (w4 * (-1.0 + w7))) - 2.0 * trilog(((1.0 + w5) * w7) / (w5 * (-1.0 + w7))) - 4.0 * trilog(1.0 / (1.0 + w7)) + 2.0 * trilog((1.0 + tb) / (1.0 + w7))
                + 2.0 * trilog((1.0 - vb) / (1.0 + w7)) - 2.0 * trilog((1.0 - w7) / (1.0 + w7)) - trilog(((1.0 + w4) * (tb - w7)) / ((tb - w4) * (1.0 + w7))) - trilog(-(((-1.0 + w5) * (tb - w7)) / ((tb + w5) * (1.0 + w7)))) - trilog(-(((1.0 + tb) * (w4 - w7)) / ((tb - w4) * (1.0 + w7)))) - trilog(-(((-1.0 + vb) * (w4 - w7)) / ((vb + w4) * (1.0 + w7)))) + trilog(((1.0 + tb) * (-1.0 + w7)) / ((-1.0 + tb) * (1.0 + w7))) + trilog(((-1.0 + vb) * (-1.0 + w7)) / ((1.0 + vb) * (1.0 + w7))) - 2.0 * trilog(w7 / (1.0 + w7)) + trilog(((-1.0 + vb) * w7) / (vb * (1.0 + w7))) + 2.0 * trilog(((-1.0 + w5) * w7) / (w5 * (1.0 + w7)))
                + 2.0 * trilog((1.0 + w7) / (1.0 - w7)) - trilog(((-1.0 + tb) * (1.0 + w7)) / (2.0 * (tb - w7))) - trilog(((-1.0 + tb) * (1.0 + w7)) / ((1.0 + tb) * (-1.0 + w7))) - trilog(((1.0 + vb) * (1.0 + w7)) / ((-1.0 + vb) * (-1.0 + w7))) + 2.0 * trilog((1.0 + w7) / (2.0 * w7)) - trilog((-1.0 + w7) / (-tb + w7)) - trilog(((-tb + w4) * w7) / (w4 * (-tb + w7))) + trilog((1.0 + w7) / (-tb + w7)) - 3.0 * trilog((-tb + w7) / (-1.0 + w7)) + trilog((-tb + w7) / (1.0 + w7)) - 2.0 * trilog((1.0 + vb) / (vb + w7)) + trilog((vb + w4) / (vb + w7)) + trilog((vb - w5) / (vb + w7))
                + trilog(((1.0 + vb) * (w4 - w7)) / ((-1.0 + w4) * (vb + w7))) - trilog(((-1.0 + vb) * (w4 - w7)) / ((1.0 + w4) * (vb + w7))) - trilog((-1.0 + w7) / (vb + w7)) + trilog((-0.5) * (((-1.0 + vb) * (-1.0 + w7)) / (vb + w7))) + trilog(((1.0 + vb) * w7) / (vb + w7)) - trilog(((vb + w4) * w7) / (w4 * (vb + w7))) - trilog(((-vb + w5) * w7) / (w5 * (vb + w7))) + trilog((1.0 + w7) / (vb + w7)) - trilog(((1.0 + vb) * (1.0 + w7)) / (2.0 * (vb + w7))) + 2.0 * trilog((vb + w7) / (-1.0 + vb)) - 2.0 * trilog((vb + w7) / (1.0 + vb)) + trilog(-((vb + w7) / (w4 - w7)))
                + trilog(((-1.0 + w4) * (vb + w7)) / ((1.0 + vb) * (w4 - w7))) - trilog(((1.0 + w4) * (vb + w7)) / ((-1.0 + vb) * (w4 - w7))) - 3.0 * trilog((vb + w7) / (-1.0 + w7)) + trilog(((-1.0 + w4) * (vb + w7)) / ((vb + w4) * (-1.0 + w7))) + trilog(-(((1.0 + w5) * (vb + w7)) / ((vb - w5) * (-1.0 + w7)))) + trilog((vb + w7) / (1.0 + w7)) - trilog(((1.0 + w4) * (vb + w7)) / ((vb + w4) * (1.0 + w7))) - trilog(-(((-1.0 + w5) * (vb + w7)) / ((vb - w5) * (1.0 + w7)))) - trilog(w7 / (-w4 + w7)) - trilog(((tb - w4) * w7) / (tb * (-w4 + w7))) - 2.0 * trilog(w5 / (w5 + w7)) + trilog((tb + w5) / (w5 + w7))
                + trilog((-vb + w5) / (w5 + w7)) - trilog(((-1.0 + w5) * (tb - w7)) / ((1.0 + tb) * (w5 + w7))) + trilog(((1.0 + w5) * (tb - w7)) / ((-1.0 + tb) * (w5 + w7))) - 2.0 * trilog(w7 / (w5 + w7)) - trilog(((vb - w5) * w7) / (vb * (w5 + w7))) - 2.0 * trilog(((1.0 + w5) * w7) / (w5 + w7)) - trilog(((tb + w5) * w7) / (tb * (w5 + w7))) + trilog((-tb + w7) / (w5 + w7)) + trilog((vb + w7) / (w5 + w7)) - trilog(((-1.0 + w5) * (vb + w7)) / ((-1.0 + vb) * (w5 + w7))) + trilog(((1.0 + w5) * (vb + w7)) / ((1.0 + vb) * (w5 + w7))) - trilog(((1.0 + tb) * (w5 + w7)) / ((-1.0 + w5) * (tb - w7)))
                + trilog(((-1.0 + tb) * (w5 + w7)) / ((1.0 + w5) * (tb - w7))) + trilog(((1.0 + vb) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7))) + trilog(((-1.0 + tb) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7))) - trilog(((-1.0 + vb) * (w5 + w7)) / ((vb - w5) * (1.0 + w7))) - trilog(((1.0 + tb) * (w5 + w7)) / ((tb + w5) * (1.0 + w7))) - trilog(((-1.0 + vb) * (w5 + w7)) / ((-1.0 + w5) * (vb + w7))) + trilog(((1.0 + vb) * (w5 + w7)) / ((1.0 + w5) * (vb + w7))) + trilog((w7 + tb * w7) / (tb + tb * w7)) + trilog((w7 - vb * w7) / (vb + w7)) - 2.0 * trilog((w4 - w7) / (w4 - w4 * w7)) + 2.0 * trilog((w4 - w7) / (w4 + w4 * w7))
                + 2.0 * trilog(-((w4 - w7) / (w7 + w4 * w7))) + 2.0 * trilog((w7 + w4 * w7) / (w4 + w4 * w7)) - 2.0 * trilog((w5 + w7) / (w5 - w5 * w7)) + 2.0 * trilog((w5 + w7) / (w7 - w5 * w7)) + 2.0 * trilog((w7 - w5 * w7) / (w5 + w7)) + 2.0 * trilog((w5 + w7) / (w5 + w5 * w7)) - 2.0 * trilog((w5 + w7) / (w7 + w5 * w7)) + 24.0 * trilog(-1.0i / wx3) + 24.0 * trilog(1.0i / wx3) + 40.0 * trilog(-1.0i / (-1.0i + wx3)) + 8.0 * trilog(wx3 / (-1.0i + wx3)) - 16.0 * trilog((-1.0i + wx3) / (2.0 * wx3)) + 16.0 * trilog((-1.0i + wx3) / wx3) + 40.0 * trilog(1.0i / (1.0i + wx3)) - 16.0 * trilog((1.0i - wx3) / (1.0i + wx3)) + 8.0 * trilog(wx3 / (1.0i + wx3))
                - 16.0 * trilog((1.0i + wx3) / (1.0i - wx3)) - 16.0 * trilog((1.0i + wx3) / (2.0 * wx3)) + 16.0 * trilog((1.0i + wx3) / wx3) + 24.0 * trilog(-1.0i / wx4) + 24.0 * trilog(1.0i / wx4) + 40.0 * trilog(-1.0i / (-1.0i + wx4)) + 8.0 * trilog(wx4 / (-1.0i + wx4)) - 16.0 * trilog((-1.0i + wx4) / (2.0 * wx4)) + 16.0 * trilog((-1.0i + wx4) / wx4) + 40.0 * trilog(1.0i / (1.0i + wx4)) - 16.0 * trilog((1.0i - wx4) / (1.0i + wx4)) + 8.0 * trilog(wx4 / (1.0i + wx4)) - 16.0 * trilog((1.0i + wx4) / (1.0i - wx4)) - 16.0 * trilog((1.0i + wx4) / (2.0 * wx4)) + 16.0 * trilog((1.0i + wx4) / wx4) - 20.0 * trilog((1.0i - xb) / (1.0i + wx3)) - 20.0 * trilog((1.0i - xb) / (1.0i + wx4))
                - 8.0 * trilog((-1.0i + wx3) / (wx3 - xb)) - 8.0 * trilog((1.0i + wx3) / (wx3 - xb)) - 4.0 * trilog((wx3 - xb) / (-1.0i + wx3)) - 4.0 * trilog((wx3 - xb) / (1.0i + wx3)) - 8.0 * trilog((-1.0i + wx4) / (wx4 - xb)) - 8.0 * trilog((1.0i + wx4) / (wx4 - xb)) - 4.0 * trilog((wx4 - xb) / (-1.0i + wx4)) - 4.0 * trilog((wx4 - xb) / (1.0i + wx4)) + 24.0 * trilog(1.0 / 2.0 - (1.0i / 2.0) * xb) + 24.0 * trilog(1.0 - 1.0i * xb) + 8.0 * trilog(((-1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 - xb))) + 8.0 * trilog(((-1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 - xb))) + 24.0 * trilog((1.0 + 1.0i * xb) / 2.0) + 24.0 * trilog(1.0 + 1.0i * xb)
                + 8.0 * trilog(((1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 - xb))) + 8.0 * trilog(((1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 - xb))) + 4.0 * trilog((1.0i * (wx3 - xb)) / ((-1.0i + wx3) * xb)) + 4.0 * trilog(((-1.0i) * (wx3 - xb)) / ((1.0i + wx3) * xb)) + 4.0 * trilog((1.0i * (wx4 - xb)) / ((-1.0i + wx4) * xb)) + 4.0 * trilog(((-1.0i) * (wx4 - xb)) / ((1.0i + wx4) * xb)) + 24.0 * trilog((-1.0i) * xb) + 24.0 * trilog(1.0i * xb) + 8.0 * trilog(-(xb / wx3)) + 8.0 * trilog(xb / wx3) + 8.0 * trilog(-(xb / wx4)) + 8.0 * trilog(xb / wx4) - 8.0 * trilog(-xb2) - 16.0 * trilog(-1.0i / (-1.0i + xb)) + 4.0 * trilog(((-1.0i) * (wx3 - xb)) / (wx3 * (-1.0i + xb)))
                + 4.0 * trilog(((-1.0i) * (wx4 - xb)) / (wx4 * (-1.0i + xb))) - 8.0 * trilog(xb / (-1.0i + xb)) + 24.0 * trilog((2.0 * xb) / (-1.0i + xb)) - 20.0 * trilog((-1.0i + xb) / (-1.0i + wx3)) - 20.0 * trilog((-1.0i + xb) / (-1.0i + wx4)) + 16.0 * trilog((-1.0i + xb) * xbinv) - 4.0 * trilog((wx3 * (-1.0i + xb)) / ((-1.0i + wx3) * xb)) - 4.0 * trilog((wx3 * (-1.0i + xb)) / ((1.0i + wx3) * xb)) - 4.0 * trilog((wx4 * (-1.0i + xb)) / ((-1.0i + wx4) * xb)) - 4.0 * trilog((wx4 * (-1.0i + xb)) / ((1.0i + wx4) * xb)) - 16.0 * trilog(1.0i / (1.0i + xb)) + 4.0 * trilog((1.0i * (wx3 - xb)) / (wx3 * (1.0i + xb))) + 4.0 * trilog((1.0i * (wx4 - xb)) / (wx4 * (1.0i + xb))) - 8.0 * trilog(xb / (1.0i + xb))
                + 24.0 * trilog((2.0 * xb) / (1.0i + xb)) + 8.0 * trilog(((-1.0i + wx3) * (-1.0i + xb)) / ((1.0i + wx3) * (1.0i + xb))) + 8.0 * trilog(((1.0i + wx3) * (-1.0i + xb)) / ((-1.0i + wx3) * (1.0i + xb))) + 8.0 * trilog(((-1.0i + wx4) * (-1.0i + xb)) / ((1.0i + wx4) * (1.0i + xb))) + 8.0 * trilog(((1.0i + wx4) * (-1.0i + xb)) / ((-1.0i + wx4) * (1.0i + xb))) - 20.0 * trilog((1.0i + xb) / (1.0i - wx3)) - 20.0 * trilog((1.0i + xb) / (1.0i + wx3)) - 20.0 * trilog((1.0i + xb) / (1.0i - wx4)) - 20.0 * trilog((1.0i + xb) / (1.0i + wx4)) - 8.0 * trilog(-((1.0i + xb) / (wx3 - xb))) - 8.0 * trilog(-((1.0i + xb) / (wx4 - xb))) + 16.0 * trilog((1.0i + xb) * xbinv)
                - 4.0 * trilog((wx3 * (1.0i + xb)) / ((-1.0i + wx3) * xb)) - 4.0 * trilog((wx3 * (1.0i + xb)) / ((1.0i + wx3) * xb)) - 4.0 * trilog((wx4 * (1.0i + xb)) / ((-1.0i + wx4) * xb)) - 4.0 * trilog((wx4 * (1.0i + xb)) / ((1.0i + wx4) * xb)) + 8.0 * trilog(((-1.0i + wx3) * (1.0i + xb)) / ((1.0i + wx3) * (-1.0i + xb))) + 8.0 * trilog(((1.0i + wx3) * (1.0i + xb)) / ((-1.0i + wx3) * (-1.0i + xb))) + 8.0 * trilog(((-1.0i + wx4) * (1.0i + xb)) / ((1.0i + wx4) * (-1.0i + xb))) + 8.0 * trilog(((1.0i + wx4) * (1.0i + xb)) / ((-1.0i + wx4) * (-1.0i + xb))) - 8.0 * trilog((-1.0i + xb) / (-wx3 + xb)) - 4.0 * trilog((-wx3 + xb) / (-1.0i + xb)) - 4.0 * trilog((-wx3 + xb) / (1.0i + xb))
                - 8.0 * trilog((-1.0i + wx3) / (wx3 + xb)) - 8.0 * trilog((1.0i + wx3) / (wx3 + xb)) + 8.0 * trilog(((1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 + xb))) + 8.0 * trilog(((-1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 + xb))) - 8.0 * trilog((-1.0i + xb) / (wx3 + xb)) - 8.0 * trilog((1.0i + xb) / (wx3 + xb)) - 4.0 * trilog((wx3 + xb) / (-1.0i + wx3)) - 4.0 * trilog((wx3 + xb) / (1.0i + wx3)) + 4.0 * trilog(((-1.0i) * (wx3 + xb)) / ((-1.0i + wx3) * xb)) + 4.0 * trilog((1.0i * (wx3 + xb)) / ((1.0i + wx3) * xb)) - 4.0 * trilog((wx3 + xb) / (-1.0i + xb)) + 4.0 * trilog(((-1.0i) * (wx3 + xb)) / (wx3 * (-1.0i + xb))) - 4.0 * trilog((wx3 + xb) / (1.0i + xb))
                + 4.0 * trilog((1.0i * (wx3 + xb)) / (wx3 * (1.0i + xb))) - 8.0 * trilog((-1.0i + xb) / (-wx4 + xb)) - 4.0 * trilog((-wx4 + xb) / (-1.0i + xb)) - 4.0 * trilog((-wx4 + xb) / (1.0i + xb)) - 8.0 * trilog((-1.0i + wx4) / (wx4 + xb)) - 8.0 * trilog((1.0i + wx4) / (wx4 + xb)) + 8.0 * trilog(((1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 + xb))) + 8.0 * trilog(((-1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 + xb))) - 8.0 * trilog((-1.0i + xb) / (wx4 + xb)) - 8.0 * trilog((1.0i + xb) / (wx4 + xb)) - 4.0 * trilog((wx4 + xb) / (-1.0i + wx4)) - 4.0 * trilog((wx4 + xb) / (1.0i + wx4)) + 4.0 * trilog(((-1.0i) * (wx4 + xb)) / ((-1.0i + wx4) * xb))
                + 4.0 * trilog((1.0i * (wx4 + xb)) / ((1.0i + wx4) * xb)) - 4.0 * trilog((wx4 + xb) / (-1.0i + xb)) + 4.0 * trilog(((-1.0i) * (wx4 + xb)) / (wx4 * (-1.0i + xb))) - 4.0 * trilog((wx4 + xb) / (1.0i + xb)) + 4.0 * trilog((1.0i * (wx4 + xb)) / (wx4 * (1.0i + xb))) + 2.0 * dilog((-1.0 + w7) / (2.0 * w7)) * lnhalf + 2.0 * dilog((1.0 - w7) / (1.0 + w7)) * lnhalf - 2.0 * dilog((1.0 + w7) / (1.0 - w7)) * lnhalf - 2.0 * dilog((1.0 + w7) / (2.0 * w7)) * lnhalf + 16.0 * dilog((-1.0i + wx3) / (2.0 * wx3)) * lnhalf + 16.0 * dilog((1.0i - wx3) / (1.0i + wx3)) * lnhalf + 16.0 * dilog((1.0i + wx3) / (1.0i - wx3)) * lnhalf
                + 16.0 * dilog((1.0i + wx3) / (2.0 * wx3)) * lnhalf + 16.0 * dilog((-1.0i + wx4) / (2.0 * wx4)) * lnhalf + 16.0 * dilog((1.0i - wx4) / (1.0i + wx4)) * lnhalf + 16.0 * dilog((1.0i + wx4) / (1.0i - wx4)) * lnhalf + 16.0 * dilog((1.0i + wx4) / (2.0 * wx4)) * lnhalf + (10.0 * pisqu * ln2) / 3.0 - (2.0 * power_of<3>(ln2)) / 3.0 - (4.0 * pisqu * ln4) / 3.0 + dilog(((-1.0 + tb) * (1.0 + w7)) / (2.0 * (tb - w7))) * log((1.0 - tb) / 2.0) + dilog(((-1.0 + tb) * (1.0 + w7)) / ((1.0 + tb) * (-1.0 + w7))) * log((1.0 - tb) / 2.0) + (pisqu * log(1.0 - tb)) / 12.0 + (ln2squ * log(1.0 - tb)) / 2.0 - dilog(1.0 - tb) * log(1.0 - tb)
                - dilog(tb) * log(1.0 - tb) - dilog(((-1.0 + tb) * w7) / (tb - w7)) * log(1.0 - tb) - dilog(((-1.0 + tb) * w7) / (tb * (-1.0 + w7))) * log(1.0 - tb) + (ln2 * power_of<2>(log(1.0 - tb))) / 2.0 + (log((1.0 - tb) / 8.0) * power_of<2>(log(1.0 - tb))) / 6.0 + power_of<3>(log(1.0 - tb)) / 6.0 - power_of<2>(log(1.0 - tb)) * log(tb) - dilog((-0.5) * (((1.0 + tb) * (-1.0 + w7)) / (tb - w7))) * log((1.0 + tb) / 2.0) - dilog(((1.0 + tb) * (-1.0 + w7)) / ((-1.0 + tb) * (1.0 + w7))) * log((1.0 + tb) / 2.0) + (power_of<2>(log(1.0 - tb)) * log((1.0 + tb) / 2.0)) / 2.0 - (5.0 * pisqu * log(1.0 + tb)) / 12.0 + (ln2squ * log(1.0 + tb)) / 2.0 + dilog(-tb) * log(1.0 + tb)
                + dilog(1.0 + tb) * log(1.0 + tb) - dilog(-(((1.0 + tb) * w7) / (tb - w7))) * log(1.0 + tb) - dilog((w7 + tb * w7) / (tb + tb * w7)) * log(1.0 + tb) + ln2squ * log(1.0 + tb) - 2.0 * ln2 * log(1.0 - tb) * log(1.0 + tb) + log((1.0 - tb) / 2.0) * log(1.0 - tb) * log(1.0 + tb) + log(1.0 - tb) * log((1.0 + tb) / 2.0) * log(1.0 + tb) - (ln2 * power_of<2>(log(1.0 + tb))) / 2.0 - (ln64 * power_of<2>(log(1.0 + tb))) / 6.0 + (log((1.0 - tb) / 2.0) * power_of<2>(log(1.0 + tb))) / 2.0 + log(-tb) * power_of<2>(log(1.0 + tb)) - (log((1.0 + tb) / 8.0) * power_of<2>(log(1.0 + tb))) / 6.0 + power_of<3>(log(1.0 + tb)) / 6.0
                - dilog(((-1.0 + vb) * (-1.0 + w7)) / ((1.0 + vb) * (1.0 + w7))) * log((1.0 - vb) / 2.0) - dilog((-0.5) * (((-1.0 + vb) * (-1.0 + w7)) / (vb + w7))) * log((1.0 - vb) / 2.0) + dilog(-w4inv) * (-log(1.0 + tb) - log(1.0 - vb)) + dilog(1.0 / (1.0 + w4)) * (-log(1.0 + tb) - log(1.0 - vb)) + dilog(1.0 / (1.0 - w5)) * (-log(1.0 + tb) - log(1.0 - vb)) + dilog(w5inv) * (-log(1.0 + tb) - log(1.0 - vb)) - (5.0 * pisqu * log(1.0 - vb)) / 12.0 + (ln2squ * log(1.0 - vb)) / 2.0 + dilog(1.0 - vb) * log(1.0 - vb) + dilog(vb) * log(1.0 - vb)
                - dilog(((-1.0 + vb) * w7) / (vb * (1.0 + w7))) * log(1.0 - vb) - dilog((w7 - vb * w7) / (vb + w7)) * log(1.0 - vb) + ln2squ * log(1.0 - vb) - (ln2 * power_of<2>(log(1.0 - vb))) / 2.0 - (ln64 * power_of<2>(log(1.0 - vb))) / 6.0 - (log((1.0 - vb) / 8.0) * power_of<2>(log(1.0 - vb))) / 6.0 + power_of<3>(log(1.0 - vb)) / 6.0 + dilog(-2.0 / (-1.0 + w7)) * (log(1.0 + tb) + log(1.0 - vb)) + power_of<2>(log(1.0 - vb)) * log(vb) + dilog(((1.0 + vb) * (1.0 + w7)) / ((-1.0 + vb) * (-1.0 + w7))) * log((1.0 + vb) / 2.0) + dilog(((1.0 + vb) * (1.0 + w7)) / (2.0 * (vb + w7))) * log((1.0 + vb) / 2.0) + (power_of<2>(log(1.0 - vb)) * log((1.0 + vb) / 2.0)) / 2.0
                + dilog(1.0 / (1.0 - w4)) * (-log(1.0 - tb) - log(1.0 + vb)) + dilog(1.0 / (1.0 + w5)) * (-log(1.0 - tb) - log(1.0 + vb)) + dilog(2.0 / (1.0 + w7)) * (-log(1.0 - tb) - log(1.0 + vb)) + (pisqu * log(1.0 + vb)) / 12.0 + (ln2squ * log(1.0 + vb)) / 2.0 - dilog(-vb) * log(1.0 + vb) - dilog(1.0 + vb) * log(1.0 + vb) - dilog(((1.0 + vb) * w7) / (vb * (-1.0 + w7))) * log(1.0 + vb) - dilog(((1.0 + vb) * w7) / (vb + w7)) * log(1.0 + vb) - 2.0 * ln2 * log(1.0 - vb) * log(1.0 + vb) + log((1.0 - vb) / 2.0) * log(1.0 - vb) * log(1.0 + vb) + log(1.0 - vb) * log((1.0 + vb) / 2.0) * log(1.0 + vb)
                + (ln2 * power_of<2>(log(1.0 + vb))) / 2.0 + (log((1.0 - vb) / 2.0) * power_of<2>(log(1.0 + vb))) / 2.0 - log(-vb) * power_of<2>(log(1.0 + vb)) + (log((1.0 + vb) / 8.0) * power_of<2>(log(1.0 + vb))) / 6.0 + power_of<3>(log(1.0 + vb)) / 6.0 + dilog(w4inv) * (log(1.0 - tb) + log(1.0 + vb)) + dilog(-w5inv) * (log(1.0 - tb) + log(1.0 + vb)) + dilog((tb - w4) / (-1.0 + tb)) * log(1.0 - tb / w4) - dilog((tb - w4) / (1.0 + tb)) * log(1.0 - tb / w4) - dilog((tb - w4) / ((-1.0 + tb) * w4)) * log(1.0 - tb / w4) + dilog((-tb + w4) / (-1.0 + w4)) * log(1.0 - tb / w4) - dilog((-tb + w4) / (1.0 + w4)) * log(1.0 - tb / w4)
                - dilog((tb - w4) / (tb - tb * w4)) * log(1.0 - tb / w4) + dilog((tb - w4) / (tb + tb * w4)) * log(1.0 - tb / w4) + dilog(-((tb - w4) / (w4 + tb * w4))) * log(1.0 - tb / w4) - dilog((tb - w4) / (tb - w7)) * log(1.0 - tb / w4) - dilog((-tb + w4) / (w4 - w7)) * log(1.0 - tb / w4) + dilog(((-tb + w4) * w7) / (w4 * (-tb + w7))) * log(1.0 - tb / w4) + dilog(((tb - w4) * w7) / (tb * (-w4 + w7))) * log(1.0 - tb / w4) - (power_of<2>(log(1.0 - tb)) * log(1.0 - tb / w4)) / 2.0 - (power_of<2>(log(1.0 + tb)) * log(1.0 - tb / w4)) / 2.0 + 2.0 * dilog((1.0 + w4) / (1.0 - w4)) * log(1.0 / (1.0 - w4))
                + 2.0 * dilog((1.0 + w4) / (2.0 * w4)) * log(1.0 / (1.0 - w4)) + 2.0 * dilog((w4 - w7) / ((-1.0 + w4) * w7)) * log(1.0 / (1.0 - w4)) + 2.0 * dilog((w4 - w7) / (w4 - w4 * w7)) * log(1.0 / (1.0 - w4)) - lnhalf * power_of<2>(log(1.0 / (1.0 - w4))) - ln2 * power_of<2>(log(1.0 / (1.0 - w4))) - dilog(((1.0 + vb) * (1.0 + w4)) / ((-1.0 + vb) * (-1.0 + w4))) * log((1.0 + vb) / (1.0 - w4)) - dilog(((1.0 + vb) * (1.0 + w4)) / (2.0 * (vb + w4))) * log((1.0 + vb) / (1.0 - w4)) - dilog(-(((1.0 + vb) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7)))) * log((1.0 + vb) / (1.0 - w4))
                - dilog(((1.0 + vb) * (w4 - w7)) / ((-1.0 + w4) * (vb + w7))) * log((1.0 + vb) / (1.0 - w4)) + (log((1.0 - vb) / 2.0) * power_of<2>(log((1.0 + vb) / (1.0 - w4)))) / 2.0 + (log(-2.0 / (-1.0 + vb)) * power_of<2>(log((1.0 + vb) / (1.0 - w4)))) / 2.0 + (pisqu * log(1.0 - w4)) / 3.0 + power_of<3>(log(1.0 - w4)) / 3.0 - (pisqu * log((1.0 - w4) / (1.0 + tb))) / 6.0 - power_of<3>(log((1.0 - w4) / (1.0 + tb))) / 6.0 - dilog(((-1.0 + tb) * (1.0 + w4)) / (2.0 * (tb - w4))) * log((-1.0 + tb) / (-1.0 + w4)) - dilog(((-1.0 + tb) * (1.0 + w4)) / ((1.0 + tb) * (-1.0 + w4))) * log((-1.0 + tb) / (-1.0 + w4))
                - dilog(((-1.0 + tb) * (w4 - w7)) / ((-1.0 + w4) * (tb - w7))) * log((-1.0 + tb) / (-1.0 + w4)) - dilog(-(((-1.0 + tb) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7)))) * log((-1.0 + tb) / (-1.0 + w4)) + log((1.0 + tb) / 2.0) * log(1.0 - tb / w4) * log((-1.0 + tb) / (-1.0 + w4)) + (power_of<2>(log(1.0 - tb / w4)) * log((-1.0 + tb) / (-1.0 + w4))) / 2.0 + (log(2.0 / (1.0 + tb)) * power_of<2>(log((-1.0 + tb) / (-1.0 + w4)))) / 2.0 + (log((1.0 + tb) / 2.0) * power_of<2>(log((-1.0 + tb) / (-1.0 + w4)))) / 2.0 - (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log((-2.0 * (tb - w4)) / ((1.0 + tb) * (-1.0 + w4)))) / 2.0 + (power_of<2>(log(1.0 - tb / w4)) * log((-1.0 + w4) / (-1.0 + tb))) / 2.0
                - (pisqu * log((-1.0 + w4) / (-1.0 + vb))) / 6.0 - power_of<3>(log((-1.0 + w4) / (-1.0 + vb))) / 6.0 - (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log((-0.5) * (((1.0 + tb) * (-1.0 + w4)) / (tb - w4)))) / 2.0 + power_of<2>(log(1.0 / (1.0 - w4))) * log((-1.0 + w4) / (2.0 * w4)) - (power_of<2>(log(1.0 - tb / w4)) * log((tb * (-1.0 + w4)) / ((-1.0 + tb) * w4))) / 2.0 - (pisqu * log(w4 / (-1.0 + tb))) / 6.0 - power_of<3>(log(w4 / (-1.0 + tb))) / 6.0 + (pisqu * log(w4 / (1.0 + tb))) / 6.0 + power_of<3>(log(w4 / (1.0 + tb))) / 6.0 + (pisqu * log(w4 / (1.0 - vb))) / 6.0 + power_of<3>(log(w4 / (1.0 - vb))) / 6.0 - (pisqu * log(-(w4 / (1.0 + vb)))) / 6.0 - power_of<3>(log(-(w4 / (1.0 + vb)))) / 6.0
                + power_of<2>(log(1.0 / (1.0 - w4))) * log((2.0 * w4) / (-1.0 + w4)) - (power_of<2>(log(1.0 - tb / w4)) * log(((-1.0 + tb) * w4) / (tb * (-1.0 + w4)))) / 2.0 + (pisqu * log(w4 / (vb * (-1.0 + w4)))) / 6.0 + power_of<3>(log(w4 / (vb * (-1.0 + w4)))) / 6.0 + 2.0 * dilog((-1.0 + w4) / (2.0 * w4)) * log(1.0 / (1.0 + w4)) + 2.0 * dilog((1.0 - w4) / (1.0 + w4)) * log(1.0 / (1.0 + w4)) - 2.0 * dilog((w4 - w7) / (w4 + w4 * w7)) * log(1.0 / (1.0 + w4)) - 2.0 * dilog(-((w4 - w7) / (w7 + w4 * w7))) * log(1.0 / (1.0 + w4)) - lnhalf * power_of<2>(log(1.0 / (1.0 + w4))) - ln2 * power_of<2>(log(1.0 / (1.0 + w4)))
                - dilog((-0.5) * (((1.0 + tb) * (-1.0 + w4)) / (tb - w4))) * log((1.0 + tb) / (1.0 + w4)) - dilog(((1.0 + tb) * (-1.0 + w4)) / ((-1.0 + tb) * (1.0 + w4))) * log((1.0 + tb) / (1.0 + w4)) + dilog(((1.0 + tb) * (w4 - w7)) / ((1.0 + w4) * (tb - w7))) * log((1.0 + tb) / (1.0 + w4)) + dilog(-(((1.0 + tb) * (w4 - w7)) / ((tb - w4) * (1.0 + w7)))) * log((1.0 + tb) / (1.0 + w4)) + log((1.0 - tb) / 2.0) * log(1.0 - tb / w4) * log((1.0 + tb) / (1.0 + w4)) - (power_of<2>(log(1.0 - tb / w4)) * log((1.0 + tb) / (1.0 + w4))) / 2.0 + (log((1.0 - tb) / 2.0) * power_of<2>(log((1.0 + tb) / (1.0 + w4)))) / 2.0
                + (log(-2.0 / (-1.0 + tb)) * power_of<2>(log((1.0 + tb) / (1.0 + w4)))) / 2.0 - dilog(((-1.0 + vb) * (-1.0 + w4)) / ((1.0 + vb) * (1.0 + w4))) * log((1.0 - vb) / (1.0 + w4)) - dilog((-0.5) * (((-1.0 + vb) * (-1.0 + w4)) / (vb + w4))) * log((1.0 - vb) / (1.0 + w4)) + dilog(-(((-1.0 + vb) * (w4 - w7)) / ((vb + w4) * (1.0 + w7)))) * log((1.0 - vb) / (1.0 + w4)) + dilog(((-1.0 + vb) * (w4 - w7)) / ((1.0 + w4) * (vb + w7))) * log((1.0 - vb) / (1.0 + w4)) + (log(2.0 / (1.0 + vb)) * power_of<2>(log((1.0 - vb) / (1.0 + w4)))) / 2.0 + (log((1.0 + vb) / 2.0) * power_of<2>(log((1.0 - vb) / (1.0 + w4)))) / 2.0
                - (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log((2.0 * (tb - w4)) / ((-1.0 + tb) * (1.0 + w4)))) / 2.0 + power_of<2>(log(1.0 / (1.0 + w4))) * log((2.0 * w4) / (1.0 + w4)) + (pisqu * log(1.0 + w4)) / 3.0 + power_of<3>(log(1.0 + w4)) / 3.0 - (pisqu * log((1.0 + w4) / (1.0 - tb))) / 6.0 - power_of<3>(log((1.0 + w4) / (1.0 - tb))) / 6.0 - (power_of<2>(log(1.0 - tb / w4)) * log((1.0 + w4) / (1.0 + tb))) / 2.0 - (pisqu * log((1.0 + w4) / (1.0 + vb))) / 6.0 - power_of<3>(log((1.0 + w4) / (1.0 + vb))) / 6.0 - (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log(((-1.0 + tb) * (1.0 + w4)) / (2.0 * (tb - w4)))) / 2.0 + power_of<2>(log(1.0 / (1.0 + w4))) * log((1.0 + w4) / (2.0 * w4)) + (power_of<2>(log(1.0 - tb)) * log((-tb + w4) / (-1.0 + w4))) / 2.0
                + (power_of<2>(log(1.0 + tb)) * log((-tb + w4) / (1.0 + w4))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log((-0.5) * (((-1.0 + vb) * (-1.0 + w4)) / (vb + w4)))) / 2.0 - (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log(((1.0 + vb) * (1.0 + w4)) / (2.0 * (vb + w4)))) / 2.0 + (pisqu * log((-0.5) * (((-1.0 + w4) * (1.0 + w4)) / (vb + w4)))) / 6.0 + power_of<3>(log((-0.5) * (((-1.0 + w4) * (1.0 + w4)) / (vb + w4)))) / 6.0 + (power_of<2>(log(1.0 + vb)) * log((vb + w4) / (-1.0 + w4))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log((-2.0 * (vb + w4)) / ((-1.0 + vb) * (-1.0 + w4)))) / 2.0 + dilog((1.0 - w4) / 2.0) * (-log(1.0 - tb / w4) - log((vb + w4) / w4))
                + dilog((1.0 + w4) / 2.0) * (-log(1.0 - tb / w4) - log((vb + w4) / w4)) + dilog((-1.0 + w4) / (-1.0 + w7)) * (-log(1.0 - tb / w4) - log((vb + w4) / w4)) + dilog((-w4 + w7) / (-1.0 + w7)) * (-log(1.0 - tb / w4) - log((vb + w4) / w4)) - dilog((vb + w4) / (-1.0 + vb)) * log((vb + w4) / w4) + dilog((vb + w4) / (1.0 + vb)) * log((vb + w4) / w4) + dilog((vb + w4) / (-1.0 + w4)) * log((vb + w4) / w4) - dilog((vb + w4) / (1.0 + w4)) * log((vb + w4) / w4) - dilog((vb + w4) / (vb - vb * w4)) * log((vb + w4) / w4) + dilog((vb + w4) / (w4 - vb * w4)) * log((vb + w4) / w4)
                + dilog((vb + w4) / (vb + vb * w4)) * log((vb + w4) / w4) - dilog((vb + w4) / (w4 + vb * w4)) * log((vb + w4) / w4) - dilog((vb + w4) / (w4 - w7)) * log((vb + w4) / w4) + dilog(-(((vb + w4) * w7) / (vb * (w4 - w7)))) * log((vb + w4) / w4) - dilog((vb + w4) / (vb + w7)) * log((vb + w4) / w4) + dilog(((vb + w4) * w7) / (w4 * (vb + w7))) * log((vb + w4) / w4) - (power_of<2>(log(1.0 - vb)) * log((vb + w4) / w4)) / 2.0 - (power_of<2>(log(1.0 + vb)) * log((vb + w4) / w4)) / 2.0 + log((1.0 - vb) / 2.0) * log((1.0 + vb) / (1.0 - w4)) * log((vb + w4) / w4)
                + log((1.0 + vb) / 2.0) * log((1.0 - vb) / (1.0 + w4)) * log((vb + w4) / w4) + (log((1.0 + vb) / (1.0 - w4)) * power_of<2>(log((vb + w4) / w4))) / 2.0 + (log((1.0 - w4) / (1.0 + vb)) * power_of<2>(log((vb + w4) / w4))) / 2.0 - (log((vb * (-1.0 + w4)) / ((1.0 + vb) * w4)) * power_of<2>(log((vb + w4) / w4))) / 2.0 - (log(((1.0 + vb) * w4) / (vb * (-1.0 + w4))) * power_of<2>(log((vb + w4) / w4))) / 2.0 - (log((1.0 - vb) / (1.0 + w4)) * power_of<2>(log((vb + w4) / w4))) / 2.0 + (log(((-1.0 + vb) * w4) / (vb * (1.0 + w4))) * power_of<2>(log((vb + w4) / w4))) / 2.0 - (log((1.0 + w4) / (1.0 - vb)) * power_of<2>(log((vb + w4) / w4))) / 2.0
                + (log((vb * (1.0 + w4)) / ((-1.0 + vb) * w4)) * power_of<2>(log((vb + w4) / w4))) / 2.0 + dilog((1.0 + w4) / (1.0 + w7)) * (log(1.0 - tb / w4) + log((vb + w4) / w4)) + dilog((-w4 + w7) / (1.0 + w7)) * (log(1.0 - tb / w4) + log((vb + w4) / w4)) + (power_of<2>(log(1.0 - vb)) * log((vb + w4) / (1.0 + w4))) / 2.0 - (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log((2.0 * (vb + w4)) / ((1.0 + vb) * (1.0 + w4)))) / 2.0 + (pisqu * log(w4 / (tb - tb * w4))) / 6.0 + power_of<3>(log(w4 / (tb - tb * w4))) / 6.0 - (pisqu * log(w4 / (tb + tb * w4))) / 6.0 - power_of<3>(log(w4 / (tb + tb * w4))) / 6.0 + (power_of<2>(log(1.0 - tb / w4)) * log((tb + tb * w4) / (w4 + tb * w4))) / 2.0
                + (power_of<2>(log(1.0 - tb / w4)) * log((w4 + tb * w4) / (tb + tb * w4))) / 2.0 - (pisqu * log(-(w4 / (vb + vb * w4)))) / 6.0 - power_of<3>(log(-(w4 / (vb + vb * w4)))) / 6.0 + (pisqu * log((1.0 - power_of<2>(w4)) / (2.0 * tb - 2.0 * w4))) / 6.0 + power_of<3>(log((1.0 - power_of<2>(w4)) / (2.0 * tb - 2.0 * w4))) / 6.0 + (pisqu * log((-1.0 + power_of<2>(w4)) / (2.0 * (tb - w4)))) / 6.0 + power_of<3>(log((-1.0 + power_of<2>(w4)) / (2.0 * (tb - w4)))) / 6.0 - (pisqu * log((-0.5) * ((-1.0 + power_of<2>(w4)) / w4))) / 3.0 - power_of<3>(log((-0.5) * ((-1.0 + power_of<2>(w4)) / w4))) / 3.0 - (pisqu * log((-1.0 + power_of<2>(w4)) / (2.0 * w4))) / 3.0 - power_of<3>(log((-1.0 + power_of<2>(w4)) / (2.0 * w4))) / 3.0 + (pisqu * log((-1.0 + power_of<2>(w4)) / (2.0 * (vb + w4)))) / 6.0 + power_of<3>(log((-1.0 + power_of<2>(w4)) / (2.0 * (vb + w4)))) / 6.0
                - dilog((vb - w5) / (-1.0 + vb)) * log(1.0 - vb / w5) + dilog((vb - w5) / (1.0 + vb)) * log(1.0 - vb / w5) + dilog((vb - w5) / ((-1.0 + vb) * w5)) * log(1.0 - vb / w5) - dilog((-vb + w5) / (-1.0 + w5)) * log(1.0 - vb / w5) + dilog((-vb + w5) / (1.0 + w5)) * log(1.0 - vb / w5) + dilog((vb - w5) / (vb - vb * w5)) * log(1.0 - vb / w5) - dilog((vb - w5) / (vb + vb * w5)) * log(1.0 - vb / w5) - dilog(-((vb - w5) / (w5 + vb * w5))) * log(1.0 - vb / w5) - dilog((vb - w5) / (vb + w7)) * log(1.0 - vb / w5) + dilog(((-vb + w5) * w7) / (w5 * (vb + w7))) * log(1.0 - vb / w5)
                - dilog((-vb + w5) / (w5 + w7)) * log(1.0 - vb / w5) + dilog(((vb - w5) * w7) / (vb * (w5 + w7))) * log(1.0 - vb / w5) - (power_of<2>(log(1.0 - vb)) * log(1.0 - vb / w5)) / 2.0 - (power_of<2>(log(1.0 + vb)) * log(1.0 - vb / w5)) / 2.0 + 2.0 * dilog((1.0 + w5) / (1.0 - w5)) * log(1.0 / (1.0 - w5)) + 2.0 * dilog((1.0 + w5) / (2.0 * w5)) * log(1.0 / (1.0 - w5)) - 2.0 * dilog((w5 + w7) / (w7 - w5 * w7)) * log(1.0 / (1.0 - w5)) - 2.0 * dilog((w5 + w7) / (w5 + w5 * w7)) * log(1.0 / (1.0 - w5)) - lnhalf * power_of<2>(log(1.0 / (1.0 - w5))) - ln2 * power_of<2>(log(1.0 / (1.0 - w5)))
                + dilog(-w7inv) * (-2.0 * lnhalf + 2.0 * log(1.0 / (1.0 + w4)) + 2.0 * log(1.0 / (1.0 - w5))) + dilog(1.0 / (1.0 + w7)) * (-2.0 * lnhalf + log(1.0 - tb) - log(1.0 + tb) - log(1.0 - vb) + log(1.0 + vb) + 2.0 * log(1.0 / (1.0 + w4)) + 2.0 * log(1.0 / (1.0 - w5))) + dilog((1.0 + tb) / (tb - w7)) * (log((1.0 + tb) / 2.0) + log(1.0 + tb) - log((1.0 + tb) / (1.0 + w4)) - log((1.0 + tb) / (1.0 - w5))) - dilog(((1.0 + tb) * (1.0 + w5)) / ((-1.0 + tb) * (-1.0 + w5))) * log((1.0 + tb) / (1.0 - w5)) - dilog(((1.0 + tb) * (1.0 + w5)) / (2.0 * (tb + w5))) * log((1.0 + tb) / (1.0 - w5))
                + dilog(((1.0 + tb) * (w5 + w7)) / ((-1.0 + w5) * (tb - w7))) * log((1.0 + tb) / (1.0 - w5)) + dilog(((1.0 + tb) * (w5 + w7)) / ((tb + w5) * (1.0 + w7))) * log((1.0 + tb) / (1.0 - w5)) + (log((1.0 - tb) / 2.0) * power_of<2>(log((1.0 + tb) / (1.0 - w5)))) / 2.0 + (log(-2.0 / (-1.0 + tb)) * power_of<2>(log((1.0 + tb) / (1.0 - w5)))) / 2.0 + dilog((1.0 + tb) / (-1.0 + tb)) * (log((1.0 + tb) / (1.0 + w4)) + log((1.0 + tb) / (1.0 - w5))) + (pisqu * log(1.0 - w5)) / 3.0 + power_of<3>(log(1.0 - w5)) / 3.0 - (pisqu * log((1.0 - w5) / (1.0 + vb))) / 6.0 - power_of<3>(log((1.0 - w5) / (1.0 + vb))) / 6.0
                + dilog((-1.0 + vb) / (vb + w7)) * (log((1.0 - vb) / 2.0) + log(1.0 - vb) - log((1.0 - vb) / (1.0 + w4)) - log((-1.0 + vb) / (-1.0 + w5))) + dilog((1.0 - vb) / (1.0 + w7)) * (log((1.0 - vb) / 2.0) + log(1.0 - vb) - log((1.0 - vb) / (1.0 + w4)) - log((vb + w4) / w4) - log(1.0 - vb / w5) - log((-1.0 + vb) / (-1.0 + w5))) - dilog(((-1.0 + vb) * (1.0 + w5)) / (2.0 * (vb - w5))) * log((-1.0 + vb) / (-1.0 + w5)) - dilog(((-1.0 + vb) * (1.0 + w5)) / ((1.0 + vb) * (-1.0 + w5))) * log((-1.0 + vb) / (-1.0 + w5)) + dilog(((-1.0 + vb) * (w5 + w7)) / ((vb - w5) * (1.0 + w7))) * log((-1.0 + vb) / (-1.0 + w5))
                + dilog(((-1.0 + vb) * (w5 + w7)) / ((-1.0 + w5) * (vb + w7))) * log((-1.0 + vb) / (-1.0 + w5)) + log((1.0 + vb) / 2.0) * log(1.0 - vb / w5) * log((-1.0 + vb) / (-1.0 + w5)) - (power_of<2>(log(1.0 - vb / w5)) * log((-1.0 + vb) / (-1.0 + w5))) / 2.0 + (log(2.0 / (1.0 + vb)) * power_of<2>(log((-1.0 + vb) / (-1.0 + w5)))) / 2.0 + (log((1.0 + vb) / 2.0) * power_of<2>(log((-1.0 + vb) / (-1.0 + w5)))) / 2.0 + dilog((-1.0 + vb) / (1.0 + vb)) * (log((1.0 - vb) / (1.0 + w4)) + log((-1.0 + vb) / (-1.0 + w5)))
                + dilog((1.0 - vb) / 2.0) * (2.0 * log(1.0 - vb) + 2.0 * log(1.0 + vb) + log((1.0 - vb) / (1.0 + w4)) + log((vb + w4) / w4) + log(1.0 - vb / w5) + log((-1.0 + vb) / (-1.0 + w5))) - (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log((-2.0 * (vb - w5)) / ((1.0 + vb) * (-1.0 + w5)))) / 2.0 - (pisqu * log((-1.0 + w5) / (-1.0 + tb))) / 6.0 - power_of<3>(log((-1.0 + w5) / (-1.0 + tb))) / 6.0 - (power_of<2>(log(1.0 - vb / w5)) * log((-1.0 + w5) / (-1.0 + vb))) / 2.0 - (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log((-0.5) * (((1.0 + vb) * (-1.0 + w5)) / (vb - w5)))) / 2.0 + power_of<2>(log(1.0 / (1.0 - w5))) * log((-1.0 + w5) / (2.0 * w5))
                + (power_of<2>(log(1.0 - vb / w5)) * log((vb * (-1.0 + w5)) / ((-1.0 + vb) * w5))) / 2.0 - (pisqu * log(w5 / (1.0 - tb))) / 6.0 - power_of<3>(log(w5 / (1.0 - tb))) / 6.0 + (pisqu * log(-(w5 / (1.0 + tb)))) / 6.0 + power_of<3>(log(-(w5 / (1.0 + tb)))) / 6.0 + (pisqu * log(w5 / (-1.0 + vb))) / 6.0 + power_of<3>(log(w5 / (-1.0 + vb))) / 6.0 - (pisqu * log(w5 / (1.0 + vb))) / 6.0 - power_of<3>(log(w5 / (1.0 + vb))) / 6.0 + power_of<2>(log(1.0 / (1.0 - w5))) * log((2.0 * w5) / (-1.0 + w5)) - (pisqu * log(w5 / (tb * (-1.0 + w5)))) / 6.0 - power_of<3>(log(w5 / (tb * (-1.0 + w5)))) / 6.0 + (power_of<2>(log(1.0 - vb / w5)) * log(((-1.0 + vb) * w5) / (vb * (-1.0 + w5)))) / 2.0
                + dilog(w7inv) * (2.0 * lnhalf - 2.0 * log(1.0 / (1.0 - w4)) - 2.0 * log(1.0 / (1.0 + w5))) + dilog(1.0 / (1.0 - w7)) * (2.0 * lnhalf + log(1.0 - tb) - log(1.0 + tb) - log(1.0 - vb) + log(1.0 + vb) - 2.0 * log(1.0 / (1.0 - w4)) - 2.0 * log(1.0 / (1.0 + w5))) + dilog(-1.0) * (-2.0 * log(1.0 / (1.0 - w4)) - 2.0 * log(1.0 / (1.0 + w4)) - 2.0 * log(1.0 / (1.0 - w5)) - 2.0 * log(1.0 / (1.0 + w5))) + 2.0 * dilog((-1.0 + w5) / (2.0 * w5)) * log(1.0 / (1.0 + w5)) + 2.0 * dilog((1.0 - w5) / (1.0 + w5)) * log(1.0 / (1.0 + w5)) + 2.0 * dilog((w5 + w7) / (w5 - w5 * w7)) * log(1.0 / (1.0 + w5))
                + 2.0 * dilog((w5 + w7) / (w7 + w5 * w7)) * log(1.0 / (1.0 + w5)) - lnhalf * power_of<2>(log(1.0 / (1.0 + w5))) - ln2 * power_of<2>(log(1.0 / (1.0 + w5))) - dilog(((-1.0 + tb) * (-1.0 + w5)) / ((1.0 + tb) * (1.0 + w5))) * log((1.0 - tb) / (1.0 + w5)) - dilog((-0.5) * (((-1.0 + tb) * (-1.0 + w5)) / (tb + w5))) * log((1.0 - tb) / (1.0 + w5)) - dilog(((-1.0 + tb) * (w5 + w7)) / ((1.0 + w5) * (tb - w7))) * log((1.0 - tb) / (1.0 + w5)) - dilog(((-1.0 + tb) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7))) * log((1.0 - tb) / (1.0 + w5)) + (log(2.0 / (1.0 + tb)) * power_of<2>(log((1.0 - tb) / (1.0 + w5)))) / 2.0
                + (log((1.0 + tb) / 2.0) * power_of<2>(log((1.0 - tb) / (1.0 + w5)))) / 2.0 + dilog((-1.0 + tb) / (1.0 + tb)) * (log((-1.0 + tb) / (-1.0 + w4)) + log((1.0 - tb) / (1.0 + w5))) + dilog((-1.0 + tb) / (tb - w7)) * (-log((1.0 - tb) / 2.0) + log(1.0 - tb) + log((-1.0 + tb) / (-1.0 + w4)) + log((1.0 - tb) / (1.0 + w5))) - dilog((-0.5) * (((1.0 + vb) * (-1.0 + w5)) / (vb - w5))) * log((1.0 + vb) / (1.0 + w5)) - dilog(((1.0 + vb) * (-1.0 + w5)) / ((-1.0 + vb) * (1.0 + w5))) * log((1.0 + vb) / (1.0 + w5)) - dilog(((1.0 + vb) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7))) * log((1.0 + vb) / (1.0 + w5))
                - dilog(((1.0 + vb) * (w5 + w7)) / ((1.0 + w5) * (vb + w7))) * log((1.0 + vb) / (1.0 + w5)) + log((1.0 - vb) / 2.0) * log(1.0 - vb / w5) * log((1.0 + vb) / (1.0 + w5)) + (power_of<2>(log(1.0 - vb / w5)) * log((1.0 + vb) / (1.0 + w5))) / 2.0 + (log((1.0 - vb) / 2.0) * power_of<2>(log((1.0 + vb) / (1.0 + w5)))) / 2.0 + (log(-2.0 / (-1.0 + vb)) * power_of<2>(log((1.0 + vb) / (1.0 + w5)))) / 2.0 + dilog((1.0 + vb) / (-1.0 + vb)) * (log((1.0 + vb) / (1.0 - w4)) + log((1.0 + vb) / (1.0 + w5))) + dilog((1.0 + vb) / (vb + w7)) * (-log((1.0 + vb) / 2.0) + log(1.0 + vb) + log((1.0 + vb) / (1.0 - w4)) + log((1.0 + vb) / (1.0 + w5)))
                + dilog((1.0 + vb) / (1.0 - w7)) * (-log((1.0 + vb) / 2.0) + log(1.0 + vb) + log((1.0 + vb) / (1.0 - w4)) + log((vb + w4) / w4) + log(1.0 - vb / w5) + log((1.0 + vb) / (1.0 + w5))) + dilog((1.0 + vb) / 2.0) * (2.0 * log(1.0 - vb) + 2.0 * log(1.0 + vb) + log((1.0 + vb) / (1.0 - w4)) + log((vb + w4) / w4) + log(1.0 - vb / w5) + log((1.0 + vb) / (1.0 + w5))) - (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log((2.0 * (vb - w5)) / ((-1.0 + vb) * (1.0 + w5)))) / 2.0 + power_of<2>(log(1.0 / (1.0 + w5))) * log((2.0 * w5) / (1.0 + w5)) + (pisqu * log(1.0 + w5)) / 3.0 + power_of<3>(log(1.0 + w5)) / 3.0 - (pisqu * log((1.0 + w5) / (1.0 + tb))) / 6.0
                - power_of<3>(log((1.0 + w5) / (1.0 + tb))) / 6.0 - (pisqu * log((1.0 + w5) / (1.0 - vb))) / 6.0 - power_of<3>(log((1.0 + w5) / (1.0 - vb))) / 6.0 + (power_of<2>(log(1.0 - vb / w5)) * log((1.0 + w5) / (1.0 + vb))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log(((-1.0 + vb) * (1.0 + w5)) / (2.0 * (vb - w5)))) / 2.0 + power_of<2>(log(1.0 / (1.0 + w5))) * log((1.0 + w5) / (2.0 * w5)) - (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log((-0.5) * (((-1.0 + tb) * (-1.0 + w5)) / (tb + w5)))) / 2.0 - (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log(((1.0 + tb) * (1.0 + w5)) / (2.0 * (tb + w5)))) / 2.0 + (pisqu * log((-0.5) * (((-1.0 + w5) * (1.0 + w5)) / (tb + w5)))) / 6.0
                + power_of<3>(log((-0.5) * (((-1.0 + w5) * (1.0 + w5)) / (tb + w5)))) / 6.0 + (power_of<2>(log(1.0 + tb)) * log((tb + w5) / (-1.0 + w5))) / 2.0 - (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log((-2.0 * (tb + w5)) / ((-1.0 + tb) * (-1.0 + w5)))) / 2.0 + dilog((1.0 - w5) / 2.0) * (-log(1.0 - vb / w5) - log((tb + w5) / w5)) + dilog((1.0 + w5) / 2.0) * (-log(1.0 - vb / w5) - log((tb + w5) / w5)) + dilog((1.0 + w5) / (1.0 - w7)) * (-log(1.0 - vb / w5) - log((tb + w5) / w5)) + dilog((w5 + w7) / (-1.0 + w7)) * (-log(1.0 - vb / w5) - log((tb + w5) / w5))
                + dilog((1.0 + tb) / (1.0 + w7)) * (log((1.0 + tb) / 2.0) + log(1.0 + tb) - log(1.0 - tb / w4) - log((1.0 + tb) / (1.0 + w4)) - log((1.0 + tb) / (1.0 - w5)) - log((tb + w5) / w5)) + dilog((tb + w5) / (-1.0 + tb)) * log((tb + w5) / w5) - dilog((tb + w5) / (1.0 + tb)) * log((tb + w5) / w5) - dilog((tb + w5) / (-1.0 + w5)) * log((tb + w5) / w5) + dilog((tb + w5) / (1.0 + w5)) * log((tb + w5) / w5) + dilog((tb + w5) / (tb - tb * w5)) * log((tb + w5) / w5) - dilog((tb + w5) / (w5 - tb * w5)) * log((tb + w5) / w5) - dilog((tb + w5) / (tb + tb * w5)) * log((tb + w5) / w5)
                + dilog((tb + w5) / (w5 + tb * w5)) * log((tb + w5) / w5) - dilog((tb + w5) / (tb - w7)) * log((tb + w5) / w5) + dilog(-(((tb + w5) * w7) / (w5 * (tb - w7)))) * log((tb + w5) / w5) - dilog((tb + w5) / (w5 + w7)) * log((tb + w5) / w5) + dilog(((tb + w5) * w7) / (tb * (w5 + w7))) * log((tb + w5) / w5) - (power_of<2>(log(1.0 - tb)) * log((tb + w5) / w5)) / 2.0 - (power_of<2>(log(1.0 + tb)) * log((tb + w5) / w5)) / 2.0 + log((1.0 - tb) / 2.0) * log((1.0 + tb) / (1.0 - w5)) * log((tb + w5) / w5) + log((1.0 + tb) / 2.0) * log((1.0 - tb) / (1.0 + w5)) * log((tb + w5) / w5)
                - (log((1.0 + tb) / (1.0 - w5)) * power_of<2>(log((tb + w5) / w5))) / 2.0 - (log((1.0 - w5) / (1.0 + tb)) * power_of<2>(log((tb + w5) / w5))) / 2.0 + (log((tb * (-1.0 + w5)) / ((1.0 + tb) * w5)) * power_of<2>(log((tb + w5) / w5))) / 2.0 + (log(((1.0 + tb) * w5) / (tb * (-1.0 + w5))) * power_of<2>(log((tb + w5) / w5))) / 2.0 + (log((1.0 - tb) / (1.0 + w5)) * power_of<2>(log((tb + w5) / w5))) / 2.0 - (log(((-1.0 + tb) * w5) / (tb * (1.0 + w5))) * power_of<2>(log((tb + w5) / w5))) / 2.0 + (log((1.0 + w5) / (1.0 - tb)) * power_of<2>(log((tb + w5) / w5))) / 2.0 - (log((tb * (1.0 + w5)) / ((-1.0 + tb) * w5)) * power_of<2>(log((tb + w5) / w5))) / 2.0
                + dilog((1.0 - w5) / (1.0 + w7)) * (log(1.0 - vb / w5) + log((tb + w5) / w5)) + dilog((w5 + w7) / (1.0 + w7)) * (log(1.0 - vb / w5) + log((tb + w5) / w5)) + dilog((1.0 + tb) / 2.0) * (2.0 * log(1.0 - tb) + 2.0 * log(1.0 + tb) + log(1.0 - tb / w4) + log((1.0 + tb) / (1.0 + w4)) + log((1.0 + tb) / (1.0 - w5)) + log((tb + w5) / w5)) + dilog((-1.0 + tb) / (-1.0 + w7)) * (-log((1.0 - tb) / 2.0) + log(1.0 - tb) + log(1.0 - tb / w4) + log((-1.0 + tb) / (-1.0 + w4)) + log((1.0 - tb) / (1.0 + w5)) + log((tb + w5) / w5))
                + dilog((1.0 - tb) / 2.0) * (2.0 * log(1.0 - tb) + 2.0 * log(1.0 + tb) + log(1.0 - tb / w4) + log((-1.0 + tb) / (-1.0 + w4)) + log((1.0 - tb) / (1.0 + w5)) + log((tb + w5) / w5)) + (power_of<2>(log(1.0 - tb)) * log((tb + w5) / (1.0 + w5))) / 2.0 - (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log((2.0 * (tb + w5)) / ((1.0 + tb) * (1.0 + w5)))) / 2.0 + (power_of<2>(log(1.0 - vb)) * log((-vb + w5) / (-1.0 + w5))) / 2.0 + (power_of<2>(log(1.0 + vb)) * log((-vb + w5) / (1.0 + w5))) / 2.0 + (pisqu * log(-(w5 / (tb + tb * w5)))) / 6.0 + power_of<3>(log(-(w5 / (tb + tb * w5)))) / 6.0 - (pisqu * log(w5 / (vb - vb * w5))) / 6.0 - power_of<3>(log(w5 / (vb - vb * w5))) / 6.0
                + (pisqu * log(w5 / (vb + vb * w5))) / 6.0 + power_of<3>(log(w5 / (vb + vb * w5))) / 6.0 - (power_of<2>(log(1.0 - vb / w5)) * log((vb + vb * w5) / (w5 + vb * w5))) / 2.0 - (power_of<2>(log(1.0 - vb / w5)) * log((w5 + vb * w5) / (vb + vb * w5))) / 2.0 + (pisqu * log((1.0 - power_of<2>(w5)) / (2.0 * vb - 2.0 * w5))) / 6.0 + power_of<3>(log((1.0 - power_of<2>(w5)) / (2.0 * vb - 2.0 * w5))) / 6.0 + (pisqu * log((-1.0 + power_of<2>(w5)) / (2.0 * (vb - w5)))) / 6.0 + power_of<3>(log((-1.0 + power_of<2>(w5)) / (2.0 * (vb - w5)))) / 6.0 - (pisqu * log((-0.5) * ((-1.0 + power_of<2>(w5)) / w5))) / 3.0 - power_of<3>(log((-0.5) * ((-1.0 + power_of<2>(w5)) / w5))) / 3.0 - (pisqu * log((-1.0 + power_of<2>(w5)) / (2.0 * w5))) / 3.0 - power_of<3>(log((-1.0 + power_of<2>(w5)) / (2.0 * w5))) / 3.0
                + (pisqu * log((-1.0 + power_of<2>(w5)) / (2.0 * (tb + w5)))) / 6.0 + power_of<3>(log((-1.0 + power_of<2>(w5)) / (2.0 * (tb + w5)))) / 6.0 - power_of<2>(lnhalf) * log(1.0 + w7inv) + power_of<2>(log(1.0 / (1.0 + w4))) * log(1.0 + w7inv) + power_of<2>(log(1.0 / (1.0 - w5))) * log(1.0 + w7inv) - dilog(w7 / (-w4 + w7)) * log(1.0 - tb / w7) + (log(1.0 - tb) * power_of<2>(log(1.0 - tb / w7))) / 2.0 + (log(1.0 + tb) * power_of<2>(log(1.0 - tb / w7))) / 2.0 - (log(1.0 - tb / w4) * power_of<2>(log(1.0 - tb / w7))) / 2.0 - (log((tb + w5) / w5) * power_of<2>(log(1.0 - tb / w7))) / 2.0 - (pisqu * log(1.0 / (tb - w7))) / 6.0 - power_of<3>(log(1.0 / (tb - w7))) / 6.0 + (pisqu * log(2.0 / (tb - w7))) / 6.0 + power_of<3>(log(2.0 / (tb - w7))) / 6.0
                + (pisqu * log(w4 / (tb - w7))) / 6.0 + power_of<3>(log(w4 / (tb - w7))) / 6.0 + (pisqu * log((-1.0 + w5) / (tb - w7))) / 6.0 + power_of<3>(log((-1.0 + w5) / (tb - w7))) / 6.0 - (pisqu * log((1.0 + w5) / (tb - w7))) / 6.0 - power_of<3>(log((1.0 + w5) / (tb - w7))) / 6.0 + (power_of<2>(log(1.0 - tb / w7)) * log((-tb + w4) / (w4 - w7))) / 2.0 - dilog(((-1.0 + w4) * (tb - w7)) / ((-1.0 + tb) * (w4 - w7))) * log((tb - w7) / (w4 - w7)) + dilog(((1.0 + w4) * (tb - w7)) / ((1.0 + tb) * (w4 - w7))) * log((tb - w7) / (w4 - w7)) - dilog(((-1.0 + w4) * (tb - w7)) / ((tb - w4) * (-1.0 + w7))) * log((tb - w7) / (w4 - w7))
                + dilog(((1.0 + w4) * (tb - w7)) / ((tb - w4) * (1.0 + w7))) * log((tb - w7) / (w4 - w7)) - (power_of<2>(log(1.0 - tb / w4)) * log((tb - w7) / (w4 - w7))) / 2.0 + (power_of<2>(log(1.0 - tb / w4)) * log((w4 * (tb - w7)) / (tb * (w4 - w7)))) / 2.0 + (pisqu * log(w4 - w7)) / 3.0 + power_of<3>(log(w4 - w7)) / 3.0 + (pisqu * log((w4 - w7) / (-1.0 + vb))) / 6.0 + power_of<3>(log((w4 - w7) / (-1.0 + vb))) / 6.0 - (pisqu * log((w4 - w7) / (1.0 + vb))) / 6.0 - power_of<3>(log((w4 - w7) / (1.0 + vb))) / 6.0 - (power_of<2>(log(1.0 - tb / w4)) * log((w4 - w7) / (tb - w7))) / 2.0 + (power_of<2>(log(1.0 - tb / w4)) * log((tb * (w4 - w7)) / (w4 * (tb - w7)))) / 2.0 + (pisqu * log(-w5 - w7)) / 3.0
                + power_of<3>(log(-w5 - w7)) / 3.0 - (power_of<2>(log(1.0 - tb / w7)) * log((-1.0 + tb) / (-1.0 + w7))) / 2.0 + log(1.0 - tb / w4) * log((tb - w7) / (w4 - w7)) * log((-1.0 + tb) / (-1.0 + w7)) + (power_of<2>(log((tb - w7) / (w4 - w7))) * log((-1.0 + tb) / (-1.0 + w7))) / 2.0 + (power_of<2>(log((1.0 - tb) / 2.0)) * log((-2.0 * (tb - w7)) / ((1.0 + tb) * (-1.0 + w7)))) / 2.0 - (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log(((-1.0 + w4) * (tb - w7)) / ((tb - w4) * (-1.0 + w7)))) / 2.0 - (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log(-(((1.0 + w5) * (tb - w7)) / ((tb + w5) * (-1.0 + w7))))) / 2.0
                - (power_of<2>(log((tb - w7) / (w4 - w7))) * log(-(((-1.0 + tb) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7))))) / 2.0 + (pisqu * log(-(((-1.0 + w4) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7))))) / 6.0 + power_of<3>(log(-(((-1.0 + w4) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7))))) / 6.0 + (pisqu * log(((-1.0 + w4) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7)))) / 6.0 + power_of<3>(log(((-1.0 + w4) * (w4 - w7)) / ((tb - w4) * (-1.0 + w7)))) / 6.0 - (pisqu * log(-(((-1.0 + w4) * (w4 - w7)) / (w4 * (-1.0 + w7))))) / 6.0 - power_of<3>(log(-(((-1.0 + w4) * (w4 - w7)) / (w4 * (-1.0 + w7))))) / 6.0 - (pisqu * log(((-1.0 + w4) * (w4 - w7)) / (w4 * (-1.0 + w7)))) / 3.0
                - power_of<3>(log(((-1.0 + w4) * (w4 - w7)) / (w4 * (-1.0 + w7)))) / 3.0 + (pisqu * log(-(((-1.0 + w4) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7))))) / 6.0 + power_of<3>(log(-(((-1.0 + w4) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7))))) / 6.0 + (pisqu * log(((-1.0 + w4) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7)))) / 6.0 + power_of<3>(log(((-1.0 + w4) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7)))) / 6.0 + (power_of<2>(log((tb - w7) / (w4 - w7))) * log((-1.0 + w7) / (-1.0 + tb))) / 2.0 + (power_of<2>(log((1.0 - tb) / 2.0)) * log((-0.5) * (((1.0 + tb) * (-1.0 + w7)) / (tb - w7)))) / 2.0 - (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log(((tb - w4) * (-1.0 + w7)) / ((-1.0 + w4) * (tb - w7)))) / 2.0
                - (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log(-(((tb + w5) * (-1.0 + w7)) / ((1.0 + w5) * (tb - w7))))) / 2.0 - (power_of<2>(log((tb - w7) / (w4 - w7))) * log(-(((tb - w4) * (-1.0 + w7)) / ((-1.0 + tb) * (w4 - w7))))) / 2.0 - (pisqu * log(-2.0 / w7)) / 3.0 - power_of<3>(log(-2.0 / w7)) / 3.0 + (pisqu * log(2.0 / w7)) / 3.0 + power_of<3>(log(2.0 / w7)) / 3.0 + (pisqu * log((-1.0 + w4) / w7)) / 3.0 + power_of<3>(log((-1.0 + w4) / w7)) / 3.0 - (pisqu * log((1.0 + w4) / w7)) / 3.0 - power_of<3>(log((1.0 + w4) / w7)) / 3.0 - (pisqu * log((1.0 - w5) / w7)) / 3.0 - power_of<3>(log((1.0 - w5) / w7)) / 3.0 + (pisqu * log(-((1.0 + w5) / w7))) / 3.0 + power_of<3>(log(-((1.0 + w5) / w7))) / 3.0 - power_of<2>(lnhalf) * log((-1.0 + w7) / (2.0 * w7))
                + power_of<2>(lnhalf) * log((-1.0 + w7) / w7) - power_of<2>(log(1.0 / (1.0 - w4))) * log((-1.0 + w7) / w7) - power_of<2>(log(1.0 / (1.0 + w5))) * log((-1.0 + w7) / w7) + power_of<2>(log(1.0 / (1.0 - w4))) * log((w4 * (-1.0 + w7)) / ((-1.0 + w4) * w7)) + power_of<2>(log(1.0 / (1.0 + w5))) * log((w5 * (-1.0 + w7)) / ((1.0 + w5) * w7)) - (log(1.0 / (1.0 - w7)) * power_of<2>(log(-(w7 / (w4 - w7))))) / 2.0 - (log(1.0 - w7) * power_of<2>(log(-(w7 / (w4 - w7))))) / 2.0 + power_of<2>(lnhalf) * log(w7 / (-1.0 + w7)) - power_of<2>(log(1.0 / (1.0 - w4))) * log(w7 / (-1.0 + w7)) - power_of<2>(log(1.0 / (1.0 + w5))) * log(w7 / (-1.0 + w7)) - power_of<2>(lnhalf) * log((2.0 * w7) / (-1.0 + w7))
                + (pisqu * log(w7 / (tb * (-1.0 + w7)))) / 6.0 + power_of<3>(log(w7 / (tb * (-1.0 + w7)))) / 6.0 + power_of<2>(log(1.0 / (1.0 - w4))) * log(((-1.0 + w4) * w7) / (w4 * (-1.0 + w7))) + power_of<2>(log(1.0 / (1.0 + w5))) * log(((1.0 + w5) * w7) / (w5 * (-1.0 + w7))) + (power_of<2>(log(-(w7 / (w4 - w7)))) * log(1.0 / (1.0 + w7))) / 2.0 - (power_of<2>(log(1.0 - tb / w7)) * log((1.0 + tb) / (1.0 + w7))) / 2.0 - log(1.0 - tb / w4) * log((tb - w7) / (w4 - w7)) * log((1.0 + tb) / (1.0 + w7)) - (power_of<2>(log((tb - w7) / (w4 - w7))) * log((1.0 + tb) / (1.0 + w7))) / 2.0 - (power_of<2>(log((1.0 + tb) / 2.0)) * log((2.0 * (tb - w7)) / ((-1.0 + tb) * (1.0 + w7)))) / 2.0
                + (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log(((1.0 + w4) * (tb - w7)) / ((tb - w4) * (1.0 + w7)))) / 2.0 + (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log(-(((-1.0 + w5) * (tb - w7)) / ((tb + w5) * (1.0 + w7))))) / 2.0 + (power_of<2>(log((tb - w7) / (w4 - w7))) * log(-(((1.0 + tb) * (w4 - w7)) / ((tb - w4) * (1.0 + w7))))) / 2.0 - (pisqu * log(-(((1.0 + w4) * (w4 - w7)) / ((tb - w4) * (1.0 + w7))))) / 6.0 - power_of<3>(log(-(((1.0 + w4) * (w4 - w7)) / ((tb - w4) * (1.0 + w7))))) / 6.0 - (pisqu * log(((1.0 + w4) * (w4 - w7)) / ((tb - w4) * (1.0 + w7)))) / 6.0 - power_of<3>(log(((1.0 + w4) * (w4 - w7)) / ((tb - w4) * (1.0 + w7)))) / 6.0
                + (pisqu * log(-(((1.0 + w4) * (w4 - w7)) / (w4 * (1.0 + w7))))) / 6.0 + power_of<3>(log(-(((1.0 + w4) * (w4 - w7)) / (w4 * (1.0 + w7))))) / 6.0 + (pisqu * log(((1.0 + w4) * (w4 - w7)) / (w4 * (1.0 + w7)))) / 3.0 + power_of<3>(log(((1.0 + w4) * (w4 - w7)) / (w4 * (1.0 + w7)))) / 3.0 - (pisqu * log(-(((1.0 + w4) * (w4 - w7)) / ((vb + w4) * (1.0 + w7))))) / 6.0 - power_of<3>(log(-(((1.0 + w4) * (w4 - w7)) / ((vb + w4) * (1.0 + w7))))) / 6.0 - (pisqu * log(((1.0 + w4) * (w4 - w7)) / ((vb + w4) * (1.0 + w7)))) / 6.0 - power_of<3>(log(((1.0 + w4) * (w4 - w7)) / ((vb + w4) * (1.0 + w7)))) / 6.0 - (pisqu * log((2.0 * (-1.0 + w7)) / (1.0 + w7))) / 3.0 - power_of<3>(log((2.0 * (-1.0 + w7)) / (1.0 + w7))) / 3.0
                + (pisqu * log((-2.0 * (-1.0 + w7)) / ((-1.0 + tb) * (1.0 + w7)))) / 6.0 + power_of<3>(log((-2.0 * (-1.0 + w7)) / ((-1.0 + tb) * (1.0 + w7)))) / 6.0 + (pisqu * log((2.0 * (-1.0 + w7)) / ((1.0 + vb) * (1.0 + w7)))) / 6.0 + power_of<3>(log((2.0 * (-1.0 + w7)) / ((1.0 + vb) * (1.0 + w7)))) / 6.0 - power_of<2>(lnhalf) * log(w7 / (1.0 + w7)) + power_of<2>(log(1.0 / (1.0 + w4))) * log(w7 / (1.0 + w7)) + power_of<2>(log(1.0 / (1.0 - w5))) * log(w7 / (1.0 + w7)) + power_of<2>(lnhalf) * log((2.0 * w7) / (1.0 + w7)) - power_of<2>(log(1.0 / (1.0 - w5))) * log(((-1.0 + w5) * w7) / (w5 * (1.0 + w7))) + (power_of<2>(log(-(w7 / (w4 - w7)))) * log(1.0 + w7)) / 2.0 - (power_of<2>(log((tb - w7) / (w4 - w7))) * log((1.0 + w7) / (1.0 + tb))) / 2.0
                - (power_of<2>(log((1.0 + tb) / 2.0)) * log(((-1.0 + tb) * (1.0 + w7)) / (2.0 * (tb - w7)))) / 2.0 - (power_of<2>(log(1.0 + tb)) * log((tb * (1.0 + w7)) / (tb - w7))) / 2.0 + (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log(((tb - w4) * (1.0 + w7)) / ((1.0 + w4) * (tb - w7)))) / 2.0 + (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log(-(((tb + w5) * (1.0 + w7)) / ((-1.0 + w5) * (tb - w7))))) / 2.0 + (power_of<2>(log((tb - w7) / (w4 - w7))) * log(-(((tb - w4) * (1.0 + w7)) / ((1.0 + tb) * (w4 - w7))))) / 2.0 - (power_of<2>(log(-(w7 / (w4 - w7)))) * log((w4 * (1.0 + w7)) / (w4 - w7))) / 2.0 + (pisqu * log((2.0 * (1.0 + w7)) / (-1.0 + w7))) / 3.0 + power_of<3>(log((2.0 * (1.0 + w7)) / (-1.0 + w7))) / 3.0
                - (pisqu * log((2.0 * (1.0 + w7)) / ((1.0 + tb) * (-1.0 + w7)))) / 6.0 - power_of<3>(log((2.0 * (1.0 + w7)) / ((1.0 + tb) * (-1.0 + w7)))) / 6.0 - (pisqu * log((-2.0 * (1.0 + w7)) / ((-1.0 + vb) * (-1.0 + w7)))) / 6.0 - power_of<3>(log((-2.0 * (1.0 + w7)) / ((-1.0 + vb) * (-1.0 + w7)))) / 6.0 + power_of<2>(lnhalf) * log((1.0 + w7) / (2.0 * w7)) - power_of<2>(log(1.0 / (1.0 - w5))) * log((w5 * (1.0 + w7)) / ((-1.0 + w5) * w7)) - (pisqu * log(1.0 / (-tb + w7))) / 6.0 - power_of<3>(log(1.0 / (-tb + w7))) / 6.0 - (pisqu * log(2.0 / (-tb + w7))) / 6.0 - power_of<3>(log(2.0 / (-tb + w7))) / 6.0 - (pisqu * log((-1.0 + w4) / (-tb + w7))) / 6.0 - power_of<3>(log((-1.0 + w4) / (-tb + w7))) / 6.0
                + (pisqu * log((1.0 + w4) / (-tb + w7))) / 6.0 + power_of<3>(log((1.0 + w4) / (-tb + w7))) / 6.0 + (pisqu * log(w5 / (-tb + w7))) / 6.0 + power_of<3>(log(w5 / (-tb + w7))) / 6.0 - (power_of<2>(log((1.0 - tb) / 2.0)) * log((-1.0 + w7) / (-tb + w7))) / 2.0 + (power_of<2>(log(1.0 - tb)) * log((-1.0 + w7) / (-tb + w7))) / 2.0 + (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log((-1.0 + w7) / (-tb + w7))) / 2.0 + (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log((-1.0 + w7) / (-tb + w7))) / 2.0 - (power_of<2>(log(1.0 - tb)) * log((tb * (-1.0 + w7)) / (-tb + w7))) / 2.0 + (power_of<2>(log((1.0 + tb) / 2.0)) * log((1.0 + w7) / (-tb + w7))) / 2.0 + (power_of<2>(log(1.0 + tb)) * log((1.0 + w7) / (-tb + w7))) / 2.0
                - (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log((1.0 + w7) / (-tb + w7))) / 2.0 - (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log((1.0 + w7) / (-tb + w7))) / 2.0 - (power_of<2>(log((1.0 - tb) / 2.0)) * log((-tb + w7) / (-1.0 + w7))) / 2.0 - log((1.0 - tb) / 2.0) * log(1.0 + tb) * log((-tb + w7) / (-1.0 + w7)) + log(1.0 - tb) * log(1.0 + tb) * log((-tb + w7) / (-1.0 + w7)) + log(1.0 - tb / w4) * log((-1.0 + tb) / (-1.0 + w4)) * log((-tb + w7) / (-1.0 + w7)) + (power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * log((-tb + w7) / (-1.0 + w7))) / 2.0 + (power_of<2>(log((1.0 - tb) / (1.0 + w5))) * log((-tb + w7) / (-1.0 + w7))) / 2.0
                + log((1.0 - tb) / (1.0 + w5)) * log((tb + w5) / w5) * log((-tb + w7) / (-1.0 + w7)) + log(1.0 - tb) * log((1.0 + tb) / 2.0) * log((-tb + w7) / (1.0 + w7)) + (power_of<2>(log((1.0 + tb) / 2.0)) * log((-tb + w7) / (1.0 + w7))) / 2.0 - log(1.0 - tb) * log(1.0 + tb) * log((-tb + w7) / (1.0 + w7)) + power_of<2>(log(1.0 + tb)) * log((-tb + w7) / (1.0 + w7)) - log(1.0 - tb / w4) * log((1.0 + tb) / (1.0 + w4)) * log((-tb + w7) / (1.0 + w7)) - (power_of<2>(log((1.0 + tb) / (1.0 + w4))) * log((-tb + w7) / (1.0 + w7))) / 2.0 - (power_of<2>(log((1.0 + tb) / (1.0 - w5))) * log((-tb + w7) / (1.0 + w7))) / 2.0
                - log((1.0 + tb) / (1.0 - w5)) * log((tb + w5) / w5) * log((-tb + w7) / (1.0 + w7)) + (pisqu * log(-2.0 / (vb + w7))) / 6.0 + power_of<3>(log(-2.0 / (vb + w7))) / 6.0 - (pisqu * log(-1.0 / (vb + w7))) / 6.0 - power_of<3>(log(-1.0 / (vb + w7))) / 6.0 - (pisqu * log(1.0 / (vb + w7))) / 6.0 - power_of<3>(log(1.0 / (vb + w7))) / 6.0 - (pisqu * log(2.0 / (vb + w7))) / 6.0 - power_of<3>(log(2.0 / (vb + w7))) / 6.0 - (pisqu * log((-1.0 + w4) / (vb + w7))) / 6.0 - power_of<3>(log((-1.0 + w4) / (vb + w7))) / 6.0 + (pisqu * log(-(w4 / (vb + w7)))) / 6.0 + power_of<3>(log(-(w4 / (vb + w7)))) / 6.0 + (pisqu * log((1.0 + w4) / (vb + w7))) / 6.0 + power_of<3>(log((1.0 + w4) / (vb + w7))) / 6.0
                + (pisqu * log((1.0 - w5) / (vb + w7))) / 6.0 + power_of<3>(log((1.0 - w5) / (vb + w7))) / 6.0 + (pisqu * log(w5 / (vb + w7))) / 6.0 + power_of<3>(log(w5 / (vb + w7))) / 6.0 - (pisqu * log(-((1.0 + w5) / (vb + w7)))) / 6.0 - power_of<3>(log(-((1.0 + w5) / (vb + w7)))) / 6.0 + (power_of<2>(log((vb + w4) / w4)) * log((vb * (w4 - w7)) / (w4 * (vb + w7)))) / 2.0 - (power_of<2>(log((1.0 + vb) / 2.0)) * log((-1.0 + w7) / (vb + w7))) / 2.0 + (power_of<2>(log(1.0 + vb)) * log((-1.0 + w7) / (vb + w7))) / 2.0 + (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log((-1.0 + w7) / (vb + w7))) / 2.0 + (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log((-1.0 + w7) / (vb + w7))) / 2.0
                + (power_of<2>(log((1.0 + vb) / 2.0)) * log((-0.5) * (((-1.0 + vb) * (-1.0 + w7)) / (vb + w7)))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log(((vb + w4) * (-1.0 + w7)) / ((-1.0 + w4) * (vb + w7)))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log(((-vb + w5) * (-1.0 + w7)) / ((1.0 + w5) * (vb + w7)))) / 2.0 + (power_of<2>(log((1.0 - vb) / 2.0)) * log((1.0 + w7) / (vb + w7))) / 2.0 + (power_of<2>(log(1.0 - vb)) * log((1.0 + w7) / (vb + w7))) / 2.0 - (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log((1.0 + w7) / (vb + w7))) / 2.0 - (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log((1.0 + w7) / (vb + w7))) / 2.0 - (power_of<2>(log(1.0 - vb)) * log((vb * (1.0 + w7)) / (vb + w7))) / 2.0
                - (power_of<2>(log((1.0 - vb) / 2.0)) * log(((1.0 + vb) * (1.0 + w7)) / (2.0 * (vb + w7)))) / 2.0 + (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log(((vb + w4) * (1.0 + w7)) / ((1.0 + w4) * (vb + w7)))) / 2.0 + (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log(((-vb + w5) * (1.0 + w7)) / ((-1.0 + w5) * (vb + w7)))) / 2.0 - dilog(((-1.0 + w4) * (vb + w7)) / ((1.0 + vb) * (w4 - w7))) * log(-((vb + w7) / (w4 - w7))) + dilog(((1.0 + w4) * (vb + w7)) / ((-1.0 + vb) * (w4 - w7))) * log(-((vb + w7) / (w4 - w7))) - dilog(((-1.0 + w4) * (vb + w7)) / ((vb + w4) * (-1.0 + w7))) * log(-((vb + w7) / (w4 - w7)))
                + dilog(((1.0 + w4) * (vb + w7)) / ((vb + w4) * (1.0 + w7))) * log(-((vb + w7) / (w4 - w7))) - (power_of<2>(log((vb + w4) / w4)) * log(-((vb + w7) / (w4 - w7)))) / 2.0 + log((vb + w4) / w4) * log((1.0 + vb) / (1.0 - w7)) * log(-((vb + w7) / (w4 - w7))) - log((vb + w4) / w4) * log((1.0 - vb) / (1.0 + w7)) * log(-((vb + w7) / (w4 - w7))) + (log((1.0 + vb) / (1.0 - w7)) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 + (log((1.0 - w7) / (1.0 + vb)) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 - (log(-(((1.0 + vb) * (w4 - w7)) / ((vb + w4) * (-1.0 + w7)))) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0
                - (log(-(((vb + w4) * (-1.0 + w7)) / ((1.0 + vb) * (w4 - w7)))) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 - (log((1.0 - vb) / (1.0 + w7)) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 + (log(-(((-1.0 + vb) * (w4 - w7)) / ((vb + w4) * (1.0 + w7)))) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 - (log((1.0 + w7) / (1.0 - vb)) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 + (log(-(((vb + w4) * (1.0 + w7)) / ((-1.0 + vb) * (w4 - w7)))) * power_of<2>(log(-((vb + w7) / (w4 - w7))))) / 2.0 + (power_of<2>(log((vb + w4) / w4)) * log((w4 * (vb + w7)) / (vb * (w4 - w7)))) / 2.0 - log(1.0 - vb) * log((1.0 + vb) / 2.0) * log((vb + w7) / (-1.0 + w7))
                - (power_of<2>(log((1.0 + vb) / 2.0)) * log((vb + w7) / (-1.0 + w7))) / 2.0 + log(1.0 - vb) * log(1.0 + vb) * log((vb + w7) / (-1.0 + w7)) + (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log((vb + w7) / (-1.0 + w7))) / 2.0 + log((1.0 + vb) / (1.0 - w4)) * log((vb + w4) / w4) * log((vb + w7) / (-1.0 + w7)) + log(1.0 - vb / w5) * log((1.0 + vb) / (1.0 + w5)) * log((vb + w7) / (-1.0 + w7)) + (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log((vb + w7) / (-1.0 + w7))) / 2.0 + (power_of<2>(log((1.0 + vb) / 2.0)) * log((-2.0 * (vb + w7)) / ((-1.0 + vb) * (-1.0 + w7)))) / 2.0
                - (power_of<2>(log((1.0 + vb) / (1.0 - w4))) * log(((-1.0 + w4) * (vb + w7)) / ((vb + w4) * (-1.0 + w7)))) / 2.0 - (power_of<2>(log((1.0 + vb) / (1.0 + w5))) * log(-(((1.0 + w5) * (vb + w7)) / ((vb - w5) * (-1.0 + w7))))) / 2.0 + dilog(w7 / w4) * (-log(1.0 - tb / w7) - log((vb + w7) / w7)) + dilog(-(w7 / w5)) * (-log(1.0 - tb / w7) - log((vb + w7) / w7)) + dilog(w7 / (w5 + w7)) * (-log(1.0 - tb / w7) - log((vb + w7) / w7)) - dilog(-(w7 / (w4 - w7))) * log((vb + w7) / w7) + (log(1.0 - vb) * power_of<2>(log((vb + w7) / w7))) / 2.0 + (log(1.0 + vb) * power_of<2>(log((vb + w7) / w7))) / 2.0
                - (log((vb + w4) / w4) * power_of<2>(log((vb + w7) / w7))) / 2.0 - (log(1.0 - vb / w5) * power_of<2>(log((vb + w7) / w7))) / 2.0 - (log((1.0 + vb) / (1.0 - w7)) * power_of<2>(log((vb + w7) / w7))) / 2.0 + (log((vb + w4) / (w4 - w7)) * power_of<2>(log((vb + w7) / w7))) / 2.0 - (log((1.0 - vb) / (1.0 + w7)) * power_of<2>(log((vb + w7) / w7))) / 2.0 + (power_of<2>(log((1.0 - vb) / 2.0)) * log((vb + w7) / (1.0 + w7))) / 2.0 + power_of<2>(log(1.0 - vb)) * log((vb + w7) / (1.0 + w7)) + log((1.0 - vb) / 2.0) * log(1.0 + vb) * log((vb + w7) / (1.0 + w7)) - log(1.0 - vb) * log(1.0 + vb) * log((vb + w7) / (1.0 + w7)) - (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log((vb + w7) / (1.0 + w7))) / 2.0
                - log((1.0 - vb) / (1.0 + w4)) * log((vb + w4) / w4) * log((vb + w7) / (1.0 + w7)) - log(1.0 - vb / w5) * log((-1.0 + vb) / (-1.0 + w5)) * log((vb + w7) / (1.0 + w7)) - (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log((vb + w7) / (1.0 + w7))) / 2.0 - (power_of<2>(log((1.0 - vb) / 2.0)) * log((2.0 * (vb + w7)) / ((1.0 + vb) * (1.0 + w7)))) / 2.0 + (power_of<2>(log((1.0 - vb) / (1.0 + w4))) * log(((1.0 + w4) * (vb + w7)) / ((vb + w4) * (1.0 + w7)))) / 2.0 + (power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * log(-(((-1.0 + w5) * (vb + w7)) / ((vb - w5) * (1.0 + w7))))) / 2.0
                + dilog(-(((1.0 + w4) * w7) / (w4 - w7))) * (-log(-(w7 / (w4 - w7))) - log(w7 / (-w4 + w7))) + dilog((w7 + w4 * w7) / (w4 + w4 * w7)) * (-log(-(w7 / (w4 - w7))) - log(w7 / (-w4 + w7))) - (log(1.0 / (1.0 - w7)) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0 - (log(1.0 - w7) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0 + (log(1.0 / (1.0 + w7)) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0 + (log(1.0 + w7) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0 - (log((w4 * (1.0 + w7)) / (w4 - w7)) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0 + (log((w4 * (-1.0 + w7)) / (-w4 + w7)) * power_of<2>(log(w7 / (-w4 + w7)))) / 2.0
                + dilog(((-1.0 + w4) * w7) / (w4 - w7)) * (log(-(w7 / (w4 - w7))) + log(w7 / (-w4 + w7))) + dilog(((-1.0 + w4) * w7) / (w4 * (-1.0 + w7))) * (log(-(w7 / (w4 - w7))) + log(w7 / (-w4 + w7))) - (pisqu * log(-w4 + w7)) / 3.0 - power_of<3>(log(-w4 + w7)) / 3.0 - (pisqu * log((-w4 + w7) / (-1.0 + tb))) / 6.0 - power_of<3>(log((-w4 + w7) / (-1.0 + tb))) / 6.0 + (pisqu * log((-w4 + w7) / (1.0 + tb))) / 6.0 + power_of<3>(log((-w4 + w7) / (1.0 + tb))) / 6.0 - (pisqu * log(((-1.0 + w4) * (-w4 + w7)) / (w4 * (-1.0 + w7)))) / 6.0 - power_of<3>(log(((-1.0 + w4) * (-w4 + w7)) / (w4 * (-1.0 + w7)))) / 6.0 + (pisqu * log(((1.0 + w4) * (-w4 + w7)) / (w4 * (1.0 + w7)))) / 6.0
                + power_of<3>(log(((1.0 + w4) * (-w4 + w7)) / (w4 * (1.0 + w7)))) / 6.0 - (power_of<2>(log((vb + w4) / w4)) * log((-w4 + w7) / (vb + w7))) / 2.0 + (power_of<2>(log(1.0 - tb / w7)) * log((tb + w5) / (w5 + w7))) / 2.0 + (power_of<2>(log((vb + w7) / w7)) * log((-vb + w5) / (w5 + w7))) / 2.0 + (power_of<2>(log((tb + w5) / w5)) * log((w5 * (tb - w7)) / (tb * (w5 + w7)))) / 2.0 + dilog(w7) * (log(1.0 - tb / w7) - log(-(w7 / (w4 - w7))) + log((vb + w7) / w7) - log(w7 / (-w4 + w7)) - 2.0 * log(w7 / (w5 + w7)))
                + dilog(w7 / (-1.0 + w7)) * (log(1.0 - tb / w7) - log(-(w7 / (w4 - w7))) + log((vb + w7) / w7) - log(w7 / (-w4 + w7)) - 2.0 * log(w7 / (w5 + w7))) + 2.0 * dilog(((1.0 + w5) * w7) / (w5 * (-1.0 + w7))) * log(w7 / (w5 + w7)) - 2.0 * dilog(((-1.0 + w5) * w7) / (w5 * (1.0 + w7))) * log(w7 / (w5 + w7)) + 2.0 * dilog(((1.0 + w5) * w7) / (w5 + w7)) * log(w7 / (w5 + w7)) - 2.0 * dilog((w7 - w5 * w7) / (w5 + w7)) * log(w7 / (w5 + w7)) - log(1.0 / (1.0 - w7)) * power_of<2>(log(w7 / (w5 + w7))) - log(1.0 - w7) * power_of<2>(log(w7 / (w5 + w7))) + log(1.0 / (1.0 + w7)) * power_of<2>(log(w7 / (w5 + w7)))
                + log(1.0 + w7) * power_of<2>(log(w7 / (w5 + w7))) + dilog(-w7) * (log(1.0 - tb / w7) + log(-(w7 / (w4 - w7))) + log((vb + w7) / w7) + log(w7 / (-w4 + w7)) + 2.0 * log(w7 / (w5 + w7))) + dilog(w7 / (1.0 + w7)) * (log(1.0 - tb / w7) + log(-(w7 / (w4 - w7))) + log((vb + w7) / w7) + log(w7 / (-w4 + w7)) + 2.0 * log(w7 / (w5 + w7))) - power_of<2>(log(w7 / (w5 + w7))) * log((w5 * (1.0 + w7)) / (w5 + w7)) + dilog((tb - w7) / (1.0 + tb)) * (-log((tb - w7) / (w4 - w7)) - log((-tb + w7) / (w5 + w7)))
                + dilog((-tb + w7) / (1.0 + w7)) * (-log(1.0 - tb / w4) - log((tb + w5) / w5) - log((tb - w7) / (w4 - w7)) - log((-tb + w7) / (w5 + w7))) - dilog(-(((1.0 + w5) * (tb - w7)) / ((tb + w5) * (-1.0 + w7)))) * log((-tb + w7) / (w5 + w7)) + dilog(-(((-1.0 + w5) * (tb - w7)) / ((tb + w5) * (1.0 + w7)))) * log((-tb + w7) / (w5 + w7)) + dilog(((-1.0 + w5) * (tb - w7)) / ((1.0 + tb) * (w5 + w7))) * log((-tb + w7) / (w5 + w7)) - dilog(((1.0 + w5) * (tb - w7)) / ((-1.0 + tb) * (w5 + w7))) * log((-tb + w7) / (w5 + w7)) - (power_of<2>(log((tb + w5) / w5)) * log((-tb + w7) / (w5 + w7))) / 2.0
                + log((tb + w5) / w5) * log((-1.0 + tb) / (-1.0 + w7)) * log((-tb + w7) / (w5 + w7)) - log((tb + w5) / w5) * log((1.0 + tb) / (1.0 + w7)) * log((-tb + w7) / (w5 + w7)) + (log((-1.0 + tb) / (-1.0 + w7)) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0 + (log((-1.0 + w7) / (-1.0 + tb)) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0 - (log((1.0 + tb) / (1.0 + w7)) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0 - (log((1.0 + w7) / (1.0 + tb)) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0 - (log(((tb + w5) * (-1.0 + w7)) / ((-1.0 + tb) * (w5 + w7))) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0
                + (log(((tb + w5) * (1.0 + w7)) / ((1.0 + tb) * (w5 + w7))) * power_of<2>(log((-tb + w7) / (w5 + w7)))) / 2.0 + dilog((tb - w7) / (-1.0 + tb)) * (log((tb - w7) / (w4 - w7)) + log((-tb + w7) / (w5 + w7))) + dilog((-tb + w7) / (-1.0 + w7)) * (log(1.0 - tb / w4) + log((tb + w5) / w5) + log((tb - w7) / (w4 - w7)) + log((-tb + w7) / (w5 + w7))) + dilog((vb + w7) / (-1.0 + vb)) * (-log(-((vb + w7) / (w4 - w7))) - log((vb + w7) / (w5 + w7)))
                + dilog((vb + w7) / (1.0 + w7)) * (-log((vb + w4) / w4) - log(1.0 - vb / w5) - log(-((vb + w7) / (w4 - w7))) - log((vb + w7) / (w5 + w7))) - dilog(-(((1.0 + w5) * (vb + w7)) / ((vb - w5) * (-1.0 + w7)))) * log((vb + w7) / (w5 + w7)) + dilog(-(((-1.0 + w5) * (vb + w7)) / ((vb - w5) * (1.0 + w7)))) * log((vb + w7) / (w5 + w7)) + dilog(((-1.0 + w5) * (vb + w7)) / ((-1.0 + vb) * (w5 + w7))) * log((vb + w7) / (w5 + w7)) - dilog(((1.0 + w5) * (vb + w7)) / ((1.0 + vb) * (w5 + w7))) * log((vb + w7) / (w5 + w7)) - (power_of<2>(log(1.0 - vb / w5)) * log((vb + w7) / (w5 + w7))) / 2.0
                + log(1.0 - vb / w5) * log((1.0 + vb) / (1.0 - w7)) * log((vb + w7) / (w5 + w7)) - log(1.0 - vb / w5) * log((1.0 - vb) / (1.0 + w7)) * log((vb + w7) / (w5 + w7)) + (log((1.0 + vb) / (1.0 - w7)) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0 + (log((1.0 - w7) / (1.0 + vb)) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0 - (log((1.0 - vb) / (1.0 + w7)) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0 - (log((1.0 + w7) / (1.0 - vb)) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0 - (log(((vb - w5) * (-1.0 + w7)) / ((1.0 + vb) * (w5 + w7))) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0
                + (log(((vb - w5) * (1.0 + w7)) / ((-1.0 + vb) * (w5 + w7))) * power_of<2>(log((vb + w7) / (w5 + w7)))) / 2.0 + dilog((vb + w7) / (1.0 + vb)) * (log(-((vb + w7) / (w4 - w7))) + log((vb + w7) / (w5 + w7))) + dilog((vb + w7) / (-1.0 + w7)) * (log((vb + w4) / w4) + log(1.0 - vb / w5) + log(-((vb + w7) / (w4 - w7))) + log((vb + w7) / (w5 + w7))) + (power_of<2>(log(1.0 - vb / w5)) * log((w5 * (vb + w7)) / (vb * (w5 + w7)))) / 2.0 - (pisqu * log(w5 + w7)) / 3.0 - power_of<3>(log(w5 + w7)) / 3.0 - (pisqu * log((w5 + w7) / (-1.0 + tb))) / 6.0 - power_of<3>(log((w5 + w7) / (-1.0 + tb))) / 6.0 + (pisqu * log((w5 + w7) / (1.0 + tb))) / 6.0
                + power_of<3>(log((w5 + w7) / (1.0 + tb))) / 6.0 + (pisqu * log((w5 + w7) / (1.0 - vb))) / 6.0 + power_of<3>(log((w5 + w7) / (1.0 - vb))) / 6.0 - (pisqu * log(-((w5 + w7) / (1.0 + vb)))) / 6.0 - power_of<3>(log(-((w5 + w7) / (1.0 + vb)))) / 6.0 + (power_of<2>(log((tb + w5) / w5)) * log((tb * (w5 + w7)) / (w5 * (tb - w7)))) / 2.0 - (power_of<2>(log((vb + w7) / (w5 + w7))) * log(((1.0 + vb) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7)))) / 2.0 + (pisqu * log(-(((1.0 + w5) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7))))) / 6.0 + power_of<3>(log(-(((1.0 + w5) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7))))) / 6.0 + (pisqu * log(((1.0 + w5) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7)))) / 6.0
                + power_of<3>(log(((1.0 + w5) * (w5 + w7)) / ((vb - w5) * (-1.0 + w7)))) / 6.0 - (pisqu * log(((1.0 + w5) * (w5 + w7)) / (w5 * (-1.0 + w7)))) / 3.0 - power_of<3>(log(((1.0 + w5) * (w5 + w7)) / (w5 * (-1.0 + w7)))) / 3.0 - (power_of<2>(log((-tb + w7) / (w5 + w7))) * log(((-1.0 + tb) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7)))) / 2.0 + (pisqu * log(-(((1.0 + w5) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7))))) / 6.0 + power_of<3>(log(-(((1.0 + w5) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7))))) / 6.0 + (pisqu * log(((1.0 + w5) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7)))) / 6.0 + power_of<3>(log(((1.0 + w5) * (w5 + w7)) / ((tb + w5) * (-1.0 + w7)))) / 6.0
                + (power_of<2>(log((vb + w7) / (w5 + w7))) * log(((-1.0 + vb) * (w5 + w7)) / ((vb - w5) * (1.0 + w7)))) / 2.0 - (pisqu * log(-(((-1.0 + w5) * (w5 + w7)) / ((vb - w5) * (1.0 + w7))))) / 6.0 - power_of<3>(log(-(((-1.0 + w5) * (w5 + w7)) / ((vb - w5) * (1.0 + w7))))) / 6.0 - (pisqu * log(((-1.0 + w5) * (w5 + w7)) / ((vb - w5) * (1.0 + w7)))) / 6.0 - power_of<3>(log(((-1.0 + w5) * (w5 + w7)) / ((vb - w5) * (1.0 + w7)))) / 6.0 + (pisqu * log(-(((-1.0 + w5) * (w5 + w7)) / (w5 * (1.0 + w7))))) / 3.0 + power_of<3>(log(-(((-1.0 + w5) * (w5 + w7)) / (w5 * (1.0 + w7))))) / 3.0 + (pisqu * log(((-1.0 + w5) * (w5 + w7)) / (w5 * (1.0 + w7)))) / 3.0
                + power_of<3>(log(((-1.0 + w5) * (w5 + w7)) / (w5 * (1.0 + w7)))) / 3.0 + (power_of<2>(log((-tb + w7) / (w5 + w7))) * log(((1.0 + tb) * (w5 + w7)) / ((tb + w5) * (1.0 + w7)))) / 2.0 - (pisqu * log(-(((-1.0 + w5) * (w5 + w7)) / ((tb + w5) * (1.0 + w7))))) / 6.0 - power_of<3>(log(-(((-1.0 + w5) * (w5 + w7)) / ((tb + w5) * (1.0 + w7))))) / 6.0 - (pisqu * log(((-1.0 + w5) * (w5 + w7)) / ((tb + w5) * (1.0 + w7)))) / 6.0 - power_of<3>(log(((-1.0 + w5) * (w5 + w7)) / ((tb + w5) * (1.0 + w7)))) / 6.0 - (power_of<2>(log((tb + w5) / w5)) * log((w5 + w7) / (-tb + w7))) / 2.0 - (power_of<2>(log(1.0 - vb / w5)) * log((w5 + w7) / (vb + w7))) / 2.0
                + (power_of<2>(log(1.0 - vb / w5)) * log((vb * (w5 + w7)) / (w5 * (vb + w7)))) / 2.0 - (power_of<2>(log(1.0 - tb)) * log((tb - w7) / (tb - tb * w7))) / 2.0 - (power_of<2>(log(1.0 + tb)) * log((tb - w7) / (tb + tb * w7))) / 2.0 + (pisqu * log(-(w7 / (tb + tb * w7)))) / 6.0 + power_of<3>(log(-(w7 / (tb + tb * w7)))) / 6.0 - (pisqu * log((w4 * w7) / (-(tb * w4) + tb * w7))) / 6.0 - power_of<3>(log((w4 * w7) / (-(tb * w4) + tb * w7))) / 6.0 - (pisqu * log(-((w5 * w7) / (tb * w5 + tb * w7)))) / 6.0 - power_of<3>(log(-((w5 * w7) / (tb * w5 + tb * w7)))) / 6.0 + (pisqu * log(w7 / (vb - vb * w7))) / 6.0 + power_of<3>(log(w7 / (vb - vb * w7))) / 6.0 - (power_of<2>(log(1.0 + vb)) * log((vb + w7) / (vb - vb * w7))) / 2.0
                - (power_of<2>(log(1.0 + vb)) * log((vb - vb * w7) / (vb + w7))) / 2.0 - (pisqu * log((w4 * w7) / (vb * w4 - vb * w7))) / 6.0 - power_of<3>(log((w4 * w7) / (vb * w4 - vb * w7))) / 6.0 + (pisqu * log(w7 / (vb + vb * w7))) / 6.0 + power_of<3>(log(w7 / (vb + vb * w7))) / 6.0 - (power_of<2>(log(1.0 - vb)) * log((vb + w7) / (vb + vb * w7))) / 2.0 - (pisqu * log((w5 * w7) / (vb * w5 + vb * w7))) / 6.0 - power_of<3>(log((w5 * w7) / (vb * w5 + vb * w7))) / 6.0 + (power_of<2>(log(-(w7 / (w4 - w7)))) * log((w4 - w7) / (w4 - w4 * w7))) / 2.0 + (power_of<2>(log(w7 / (-w4 + w7))) * log((w4 - w7) / (w4 - w4 * w7))) / 2.0 + (power_of<2>(log(-(w7 / (w4 - w7)))) * log((w4 - w4 * w7) / (w4 - w7))) / 2.0
                - (power_of<2>(log(-(w7 / (w4 - w7)))) * log((w4 - w7) / (w4 + w4 * w7))) / 2.0 - (power_of<2>(log(w7 / (-w4 + w7))) * log((w4 - w7) / (w4 + w4 * w7))) / 2.0 - power_of<2>(log(1.0 / (1.0 + w4))) * log((w4 + w4 * w7) / (w7 + w4 * w7)) - power_of<2>(log(1.0 / (1.0 + w4))) * log((w7 + w4 * w7) / (w4 + w4 * w7)) + power_of<2>(log(w7 / (w5 + w7))) * log((w5 + w7) / (w5 - w5 * w7)) - (pisqu * log(((1.0 + w5) * (w5 + w7)) / (w5 - w5 * w7))) / 3.0 - power_of<3>(log(((1.0 + w5) * (w5 + w7)) / (w5 - w5 * w7))) / 3.0 + power_of<2>(log(w7 / (w5 + w7))) * log((w5 - w5 * w7) / (w5 + w7)) - power_of<2>(log(w7 / (w5 + w7))) * log((w5 + w7) / (w5 + w5 * w7)) + (8.0 * pisqu * log((-2.0 * 1.0i) / wx3)) / 3.0
                + (8.0 * power_of<3>(log((-2.0 * 1.0i) / wx3))) / 3.0 + (8.0 * pisqu * log((2.0 * 1.0i) / wx3)) / 3.0 + (8.0 * power_of<3>(log((2.0 * 1.0i) / wx3))) / 3.0 - 8.0 * power_of<2>(lnhalf) * log(wx3 / (-1.0i + wx3)) + 8.0 * power_of<2>(lnhalf) * log((2.0 * wx3) / (-1.0i + wx3)) + 8.0 * power_of<2>(lnhalf) * log((-1.0i + wx3) / (2.0 * wx3)) - 8.0 * power_of<2>(lnhalf) * log((-1.0i + wx3) / wx3) - 8.0 * power_of<2>(lnhalf) * log(wx3 / (1.0i + wx3)) + 8.0 * power_of<2>(lnhalf) * log((2.0 * wx3) / (1.0i + wx3)) - (8.0 * pisqu * log((2.0 * (-1.0i + wx3)) / (1.0i + wx3))) / 3.0 - (8.0 * power_of<3>(log((2.0 * (-1.0i + wx3)) / (1.0i + wx3)))) / 3.0 + 8.0 * power_of<2>(lnhalf) * log((1.0i + wx3) / (2.0 * wx3)) - 8.0 * power_of<2>(lnhalf) * log((1.0i + wx3) / wx3)
                - (8.0 * pisqu * log((2.0 * (1.0i + wx3)) / (-1.0i + wx3))) / 3.0 - (8.0 * power_of<3>(log((2.0 * (1.0i + wx3)) / (-1.0i + wx3)))) / 3.0 + (8.0 * pisqu * log((-2.0 * 1.0i) / wx4)) / 3.0 + (8.0 * power_of<3>(log((-2.0 * 1.0i) / wx4))) / 3.0 + (8.0 * pisqu * log((2.0 * 1.0i) / wx4)) / 3.0 + (8.0 * power_of<3>(log((2.0 * 1.0i) / wx4))) / 3.0 - 8.0 * power_of<2>(lnhalf) * log(wx4 / (-1.0i + wx4)) + 8.0 * power_of<2>(lnhalf) * log((2.0 * wx4) / (-1.0i + wx4)) + 8.0 * power_of<2>(lnhalf) * log((-1.0i + wx4) / (2.0 * wx4)) - 8.0 * power_of<2>(lnhalf) * log((-1.0i + wx4) / wx4) - 8.0 * power_of<2>(lnhalf) * log(wx4 / (1.0i + wx4)) + 8.0 * power_of<2>(lnhalf) * log((2.0 * wx4) / (1.0i + wx4)) - (8.0 * pisqu * log((2.0 * (-1.0i + wx4)) / (1.0i + wx4))) / 3.0
                - (8.0 * power_of<3>(log((2.0 * (-1.0i + wx4)) / (1.0i + wx4)))) / 3.0 + 8.0 * power_of<2>(lnhalf) * log((1.0i + wx4) / (2.0 * wx4)) - 8.0 * power_of<2>(lnhalf) * log((1.0i + wx4) / wx4) - (8.0 * pisqu * log((2.0 * (1.0i + wx4)) / (-1.0i + wx4))) / 3.0 - (8.0 * power_of<3>(log((2.0 * (1.0i + wx4)) / (-1.0i + wx4)))) / 3.0 - (2.0 * pisqu * log(wx3 / (1.0i - xb))) / 3.0 - (2.0 * power_of<3>(log(wx3 / (1.0i - xb)))) / 3.0 - (2.0 * pisqu * log(wx4 / (1.0i - xb))) / 3.0 - (2.0 * power_of<3>(log(wx4 / (1.0i - xb)))) / 3.0 - (4.0 * pisqu * log((-2.0 * 1.0i) / (wx3 - xb))) / 3.0 - (4.0 * power_of<3>(log((-2.0 * 1.0i) / (wx3 - xb)))) / 3.0 - (4.0 * pisqu * log((2.0 * 1.0i) / (wx3 - xb))) / 3.0 - (4.0 * power_of<3>(log((2.0 * 1.0i) / (wx3 - xb)))) / 3.0 - (4.0 * pisqu * log((-2.0 * 1.0i) / (wx4 - xb))) / 3.0
                - (4.0 * power_of<3>(log((-2.0 * 1.0i) / (wx4 - xb)))) / 3.0 - (4.0 * pisqu * log((2.0 * 1.0i) / (wx4 - xb))) / 3.0 - (4.0 * power_of<3>(log((2.0 * 1.0i) / (wx4 - xb)))) / 3.0 - 8.0 * dilog(((-1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 - xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((-1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 - xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 8.0 * dilog(-((1.0i + xb) / (wx3 - xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 8.0 * dilog(-((1.0i + xb) / (wx4 - xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((-1.0i + wx3) * (1.0i + xb)) / ((1.0i + wx3) * (-1.0i + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx3) * (1.0i + xb)) / ((-1.0i + wx3) * (-1.0i + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb)
                - 8.0 * dilog(((-1.0i + wx4) * (1.0i + xb)) / ((1.0i + wx4) * (-1.0i + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx4) * (1.0i + xb)) / ((-1.0i + wx4) * (-1.0i + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 8.0 * dilog((1.0i + xb) / (wx3 + xb)) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 + xb))) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 8.0 * dilog((1.0i + xb) / (wx4 + xb)) * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 4.0 * log((1.0i + wx3) / (wx3 - xb)) * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * xb))
                - 8.0 * dilog(((1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 - xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 - xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((-1.0i + wx3) * (-1.0i + xb)) / ((1.0i + wx3) * (1.0i + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx3) * (-1.0i + xb)) / ((-1.0i + wx3) * (1.0i + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((-1.0i + wx4) * (-1.0i + xb)) / ((1.0i + wx4) * (1.0i + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((1.0i + wx4) * (-1.0i + xb)) / ((-1.0i + wx4) * (1.0i + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 8.0 * dilog((-1.0i + xb) / (-wx3 + xb)) * log(1.0 / 2.0 + (1.0i / 2.0) * xb)
                - 8.0 * dilog(((-1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 8.0 * dilog((-1.0i + xb) / (wx3 + xb)) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 8.0 * dilog((-1.0i + xb) / (-wx4 + xb)) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) - 8.0 * dilog(((-1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 + xb))) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 8.0 * dilog((-1.0i + xb) / (wx4 + xb)) * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 4.0 * log((-1.0i + wx3) / (wx3 - xb)) * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * xb)) - 8.0 * dilog(1.0 - 1.0i * xb) * log(1.0 - 1.0i * xb) - 16.0 * dilog((1.0i + xb) * xbinv) * log(1.0 - 1.0i * xb) + 4.0 * dilog((wx3 * (1.0i + xb)) / ((-1.0i + wx3) * xb)) * log(1.0 - 1.0i * xb)
                + 4.0 * dilog((wx3 * (1.0i + xb)) / ((1.0i + wx3) * xb)) * log(1.0 - 1.0i * xb) + 4.0 * dilog((wx4 * (1.0i + xb)) / ((-1.0i + wx4) * xb)) * log(1.0 - 1.0i * xb) + 4.0 * dilog((wx4 * (1.0i + xb)) / ((1.0i + wx4) * xb)) * log(1.0 - 1.0i * xb) - (8.0 * power_of<3>(log(1.0 - 1.0i * xb))) / 3.0 + dilog((1.0i - xb) / (1.0i + wx3)) * (8.0 * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 4.0 * log(1.0 - 1.0i * xb)) + dilog((1.0i - xb) / (1.0i + wx4)) * (8.0 * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 4.0 * log(1.0 - 1.0i * xb)) + dilog((-1.0i + xb) / (-1.0i + wx3)) * (8.0 * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 4.0 * log(1.0 - 1.0i * xb)) + dilog((-1.0i + xb) / (-1.0i + wx4)) * (8.0 * log(1.0 / 2.0 + (1.0i / 2.0) * xb) + 4.0 * log(1.0 - 1.0i * xb))
                + dilog((-2.0 * 1.0i) / (-1.0i + wx3)) * (-8.0 * log(1.0 - 1.0i * xb) - 8.0 * log(1.0 + 1.0i * xb)) + dilog((2.0 * 1.0i) / (1.0i + wx3)) * (-8.0 * log(1.0 - 1.0i * xb) - 8.0 * log(1.0 + 1.0i * xb)) + dilog((-2.0 * 1.0i) / (-1.0i + wx4)) * (-8.0 * log(1.0 - 1.0i * xb) - 8.0 * log(1.0 + 1.0i * xb)) + dilog((2.0 * 1.0i) / (1.0i + wx4)) * (-8.0 * log(1.0 - 1.0i * xb) - 8.0 * log(1.0 + 1.0i * xb)) - 8.0 * dilog(1.0 + 1.0i * xb) * log(1.0 + 1.0i * xb) - 16.0 * dilog((-1.0i + xb) * xbinv) * log(1.0 + 1.0i * xb) + 4.0 * dilog((wx3 * (-1.0i + xb)) / ((-1.0i + wx3) * xb)) * log(1.0 + 1.0i * xb) + 4.0 * dilog((wx3 * (-1.0i + xb)) / ((1.0i + wx3) * xb)) * log(1.0 + 1.0i * xb)
                + 4.0 * dilog((wx4 * (-1.0i + xb)) / ((-1.0i + wx4) * xb)) * log(1.0 + 1.0i * xb) + 4.0 * dilog((wx4 * (-1.0i + xb)) / ((1.0i + wx4) * xb)) * log(1.0 + 1.0i * xb) - (8.0 * power_of<3>(log(1.0 + 1.0i * xb))) / 3.0 + dilog((1.0i + xb) / (1.0i - wx3)) * (8.0 * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog((1.0i + xb) / (1.0i + wx3)) * (8.0 * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog((1.0i + xb) / (1.0i - wx4)) * (8.0 * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog((1.0i + xb) / (1.0i + wx4)) * (8.0 * log(1.0 / 2.0 - (1.0i / 2.0) * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog(-1.0i / wx3) * (-16.0 * lnhalf + 4.0 * log(1.0 - 1.0i * xb) + 4.0 * log(1.0 + 1.0i * xb))
                + dilog(1.0i / wx3) * (-16.0 * lnhalf + 4.0 * log(1.0 - 1.0i * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog(-1.0i / wx4) * (-16.0 * lnhalf + 4.0 * log(1.0 - 1.0i * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog(1.0i / wx4) * (-16.0 * lnhalf + 4.0 * log(1.0 - 1.0i * xb) + 4.0 * log(1.0 + 1.0i * xb)) + dilog(-1.0i / (-1.0i + wx3)) * (-16.0 * lnhalf + 8.0 * log(1.0 - 1.0i * xb) + 8.0 * log(1.0 + 1.0i * xb)) + dilog(1.0i / (1.0i + wx3)) * (-16.0 * lnhalf + 8.0 * log(1.0 - 1.0i * xb) + 8.0 * log(1.0 + 1.0i * xb)) + dilog(-1.0i / (-1.0i + wx4)) * (-16.0 * lnhalf + 8.0 * log(1.0 - 1.0i * xb) + 8.0 * log(1.0 + 1.0i * xb))
                + dilog(1.0i / (1.0i + wx4)) * (-16.0 * lnhalf + 8.0 * log(1.0 - 1.0i * xb) + 8.0 * log(1.0 + 1.0i * xb)) + log((wx3 - xb) / (1.0i + wx3)) * (-2.0 * power_of<2>(log(1.0 - 1.0i * xb)) - 4.0 * log(1.0 - 1.0i * xb) * log(1.0 + 1.0i * xb)) + log((wx4 - xb) / (1.0i + wx4)) * (-2.0 * power_of<2>(log(1.0 - 1.0i * xb)) - 4.0 * log(1.0 - 1.0i * xb) * log(1.0 + 1.0i * xb)) + log((wx3 - xb) / (-1.0i + wx3)) * (-4.0 * log(1.0 - 1.0i * xb) * log(1.0 + 1.0i * xb) - 2.0 * power_of<2>(log(1.0 + 1.0i * xb))) + log((wx4 - xb) / (-1.0i + wx4)) * (-4.0 * log(1.0 - 1.0i * xb) * log(1.0 + 1.0i * xb) - 2.0 * power_of<2>(log(1.0 + 1.0i * xb))) + (8.0 * pisqu * log(-1.0i / xb)) / 3.0 + (8.0 * power_of<3>(log(-1.0i / xb))) / 3.0 + (8.0 * pisqu * log(1.0i / xb)) / 3.0
                + (8.0 * power_of<3>(log(1.0i / xb))) / 3.0 + dilog(1.0 / 2.0 - (1.0i / 2.0) * xb) * (16.0 * (log(xb) - log(1.0i * xb)) - 16.0 * log(1.0 - 1.0i * xb) - 16.0 * log(1.0 + 1.0i * xb) - 16.0 * log((-1.0i) * xb)) + ((4.0 * pisqu) / 3.0 - 8.0 * ln2squ) * log((-1.0i) * xb) + dilog((1.0 + 1.0i * xb) / 2.0) * (16.0 * log(1.0i) - 16.0 * log(1.0 - 1.0i * xb) - 16.0 * log(1.0 + 1.0i * xb) - 16.0 * log(1.0i * xb)) + ((4.0 * pisqu) / 3.0 - 8.0 * ln2squ) * log(1.0i * xb) + dilog((-1.0i) * xb) * (8.0 * log(1.0 - 1.0i * xb) - 8.0 * log(xb)) + dilog(1.0i * xb) * (8.0 * log(1.0 + 1.0i * xb) - 8.0 * log(xb)) - 8.0 * dilog(wx3 / (-1.0i + wx3)) * log(xb) - 8.0 * dilog(wx3 / (1.0i + wx3)) * log(xb) - 8.0 * dilog(wx4 / (-1.0i + wx4)) * log(xb)
                - 8.0 * dilog(wx4 / (1.0i + wx4)) * log(xb) + 4.0 * dilog(-(xb / wx3)) * log(xb) + 4.0 * dilog(xb / wx3) * log(xb) + 4.0 * dilog(-(xb / wx4)) * log(xb) + 4.0 * dilog(xb / wx4) * log(xb) - (2.0 * pisqu * log(wx3 / (-1.0i + xb))) / 3.0 - (2.0 * power_of<3>(log(wx3 / (-1.0i + xb)))) / 3.0 + (4.0 * pisqu * log((2.0 - (2.0 * 1.0i) * wx3) / ((-1.0i + wx3) * (-1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((2.0 - (2.0 * 1.0i) * wx3) / ((-1.0i + wx3) * (-1.0i + xb))))) / 3.0 + (4.0 * pisqu * log((-2.0 - (2.0 * 1.0i) * wx3) / ((1.0i + wx3) * (-1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((-2.0 - (2.0 * 1.0i) * wx3) / ((1.0i + wx3) * (-1.0i + xb))))) / 3.0 - (2.0 * pisqu * log(wx4 / (-1.0i + xb))) / 3.0 - (2.0 * power_of<3>(log(wx4 / (-1.0i + xb)))) / 3.0
                + (4.0 * pisqu * log((2.0 - (2.0 * 1.0i) * wx4) / ((-1.0i + wx4) * (-1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((2.0 - (2.0 * 1.0i) * wx4) / ((-1.0i + wx4) * (-1.0i + xb))))) / 3.0 + (4.0 * pisqu * log((-2.0 - (2.0 * 1.0i) * wx4) / ((1.0i + wx4) * (-1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((-2.0 - (2.0 * 1.0i) * wx4) / ((1.0i + wx4) * (-1.0i + xb))))) / 3.0 - (2.0 * pisqu * log(-(wx3 / (1.0i + xb)))) / 3.0 - (2.0 * power_of<3>(log(-(wx3 / (1.0i + xb))))) / 3.0 - (2.0 * pisqu * log(wx3 / (1.0i + xb))) / 3.0 - (2.0 * power_of<3>(log(wx3 / (1.0i + xb)))) / 3.0 + (4.0 * pisqu * log((2.0 + (2.0 * 1.0i) * wx3) / ((1.0i + wx3) * (1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((2.0 + (2.0 * 1.0i) * wx3) / ((1.0i + wx3) * (1.0i + xb))))) / 3.0
                + (4.0 * pisqu * log(((2.0 * 1.0i) * (1.0i + wx3)) / ((-1.0i + wx3) * (1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log(((2.0 * 1.0i) * (1.0i + wx3)) / ((-1.0i + wx3) * (1.0i + xb))))) / 3.0 - (2.0 * pisqu * log(-(wx4 / (1.0i + xb)))) / 3.0 - (2.0 * power_of<3>(log(-(wx4 / (1.0i + xb))))) / 3.0 - (2.0 * pisqu * log(wx4 / (1.0i + xb))) / 3.0 - (2.0 * power_of<3>(log(wx4 / (1.0i + xb)))) / 3.0 + (4.0 * pisqu * log((2.0 + (2.0 * 1.0i) * wx4) / ((1.0i + wx4) * (1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log((2.0 + (2.0 * 1.0i) * wx4) / ((1.0i + wx4) * (1.0i + xb))))) / 3.0 + (4.0 * pisqu * log(((2.0 * 1.0i) * (1.0i + wx4)) / ((-1.0i + wx4) * (1.0i + xb)))) / 3.0 + (4.0 * power_of<3>(log(((2.0 * 1.0i) * (1.0i + wx4)) / ((-1.0i + wx4) * (1.0i + xb))))) / 3.0 - (4.0 * pisqu * log((-2.0 * 1.0i) / (wx3 + xb))) / 3.0
                - (4.0 * power_of<3>(log((-2.0 * 1.0i) / (wx3 + xb)))) / 3.0 - (4.0 * pisqu * log((2.0 * 1.0i) / (wx3 + xb))) / 3.0 - (4.0 * power_of<3>(log((2.0 * 1.0i) / (wx3 + xb)))) / 3.0 - 4.0 * dilog(((-1.0i) * (wx3 + xb)) / ((-1.0i + wx3) * xb)) * log((wx3 + xb) / wx3) - 4.0 * dilog((1.0i * (wx3 + xb)) / ((1.0i + wx3) * xb)) * log((wx3 + xb) / wx3) + 4.0 * dilog((wx3 + xb) / (-1.0i + xb)) * log((wx3 + xb) / wx3) - 4.0 * dilog(((-1.0i) * (wx3 + xb)) / (wx3 * (-1.0i + xb))) * log((wx3 + xb) / wx3) + 4.0 * dilog((wx3 + xb) / (1.0i + xb)) * log((wx3 + xb) / wx3) - 4.0 * dilog((1.0i * (wx3 + xb)) / (wx3 * (1.0i + xb))) * log((wx3 + xb) / wx3)
                + (2.0 * log((1.0i + wx3) / (1.0i - xb)) - 2.0 * log(((1.0i + wx3) * xb) / (wx3 * (-1.0i + xb))) - 2.0 * log((wx3 * (-1.0i + xb)) / ((1.0i + wx3) * xb)) + 2.0 * log((1.0i - wx3) / (1.0i + xb)) - 2.0 * log(((-1.0i + wx3) * xb) / (wx3 * (1.0i + xb))) + 2.0 * log((1.0i + xb) / (1.0i - wx3)) - 2.0 * log((wx3 * (1.0i + xb)) / ((-1.0i + wx3) * xb))) * power_of<2>(log((wx3 + xb) / wx3)) + dilog((wx3 + xb) / (-1.0i + wx3)) * (4.0 * log(xb) + 4.0 * log((wx3 + xb) / wx3)) + dilog((wx3 + xb) / (1.0i + wx3)) * (4.0 * log(xb) + 4.0 * log((wx3 + xb) / wx3)) + log((1.0i - xb) / (1.0i + wx3)) * (4.0 * log(xb) * log((wx3 + xb) / wx3) + 2.0 * power_of<2>(log((wx3 + xb) / wx3)))
                - (4.0 * pisqu * log((-2.0 * 1.0i) / (wx4 + xb))) / 3.0 - (4.0 * power_of<3>(log((-2.0 * 1.0i) / (wx4 + xb)))) / 3.0 - (4.0 * pisqu * log((2.0 * 1.0i) / (wx4 + xb))) / 3.0 - (4.0 * power_of<3>(log((2.0 * 1.0i) / (wx4 + xb)))) / 3.0 - 4.0 * dilog(((-1.0i) * (wx4 + xb)) / ((-1.0i + wx4) * xb)) * log((wx4 + xb) / wx4) - 4.0 * dilog((1.0i * (wx4 + xb)) / ((1.0i + wx4) * xb)) * log((wx4 + xb) / wx4) + 4.0 * dilog((wx4 + xb) / (-1.0i + xb)) * log((wx4 + xb) / wx4) - 4.0 * dilog(((-1.0i) * (wx4 + xb)) / (wx4 * (-1.0i + xb))) * log((wx4 + xb) / wx4) + 4.0 * dilog((wx4 + xb) / (1.0i + xb)) * log((wx4 + xb) / wx4) - 4.0 * dilog((1.0i * (wx4 + xb)) / (wx4 * (1.0i + xb))) * log((wx4 + xb) / wx4)
                + 2.0 * log((1.0i - xb) / (1.0i + wx4)) * power_of<2>(log((wx4 + xb) / wx4)) + (2.0 * log((1.0i + wx4) / (1.0i - xb)) - 2.0 * log(((1.0i + wx4) * xb) / (wx4 * (-1.0i + xb))) - 2.0 * log((wx4 * (-1.0i + xb)) / ((1.0i + wx4) * xb)) + 2.0 * log((1.0i - wx4) / (1.0i + xb)) - 2.0 * log(((-1.0i + wx4) * xb) / (wx4 * (1.0i + xb))) + 2.0 * log((1.0i + xb) / (1.0i - wx4)) - 2.0 * log((wx4 * (1.0i + xb)) / ((-1.0i + wx4) * xb))) * power_of<2>(log((wx4 + xb) / wx4)) + dilog((wx4 + xb) / (-1.0i + wx4)) * (4.0 * log(xb) + 4.0 * log((wx4 + xb) / wx4)) + dilog((wx4 + xb) / (1.0i + wx4)) * (4.0 * log(xb) + 4.0 * log((wx4 + xb) / wx4))
                + log(1.0 / 2.0 - (1.0i / 2.0) * xb) * (8.0 * log((wx3 - xb) / (1.0i + wx3)) * log(1.0 + 1.0i * xb) + 8.0 * log((wx4 - xb) / (1.0i + wx4)) * log(1.0 + 1.0i * xb) - 8.0 * power_of<2>(log(1.0 + 1.0i * xb)) + log(1.0 + 1.0i * xb) * (8.0 * log((wx3 + xb) / (-1.0i + wx3)) + 8.0 * log((wx4 + xb) / (-1.0i + wx4)))) + log(1.0 / 2.0 + (1.0i / 2.0) * xb) * (8.0 * log((wx3 - xb) / (-1.0i + wx3)) * log(1.0 - 1.0i * xb) + 8.0 * log((wx4 - xb) / (-1.0i + wx4)) * log(1.0 - 1.0i * xb) - 8.0 * power_of<2>(log(1.0 - 1.0i * xb)) + log(1.0 - 1.0i * xb) * (8.0 * log((wx3 + xb) / (1.0i + wx3)) + 8.0 * log((wx4 + xb) / (1.0i + wx4))))
                + power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * xb)) * (4.0 * log((wx3 - xb) / (1.0i + wx3)) + 4.0 * log((1.0i + wx4) / (wx4 - xb)) + 4.0 * log((wx4 - xb) / (1.0i + wx4)) - 4.0 * log(((1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 - xb))) - 4.0 * log(((1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 - xb))) - 4.0 * log(((-2.0 * 1.0i) * (wx3 - xb)) / ((1.0i + wx3) * (-1.0i + xb))) - 4.0 * log(((-2.0 * 1.0i) * (wx4 - xb)) / ((1.0i + wx4) * (-1.0i + xb))) + 4.0 * log((-1.0i + wx3) / (wx3 + xb)) - 4.0 * log(((-1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * (wx3 + xb))) + 4.0 * log((wx3 + xb) / (-1.0i + wx3)) - 4.0 * log(((-2.0 * 1.0i) * (wx3 + xb)) / ((-1.0i + wx3) * (-1.0i + xb))) + 4.0 * log((-1.0i + wx4) / (wx4 + xb))
                    - 4.0 * log(((-1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * (wx4 + xb))) + 4.0 * log((wx4 + xb) / (-1.0i + wx4)) - 4.0 * log(((-2.0 * 1.0i) * (wx4 + xb)) / ((-1.0i + wx4) * (-1.0i + xb)))) + power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * xb)) * (4.0 * log((wx3 - xb) / (-1.0i + wx3)) + 4.0 * log((-1.0i + wx4) / (wx4 - xb)) + 4.0 * log((wx4 - xb) / (-1.0i + wx4)) - 4.0 * log(((-1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 - xb))) - 4.0 * log(((-1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 - xb))) - 4.0 * log(((2.0 * 1.0i) * (wx3 - xb)) / ((-1.0i + wx3) * (1.0i + xb))) - 4.0 * log(((2.0 * 1.0i) * (wx4 - xb)) / ((-1.0i + wx4) * (1.0i + xb))) + 4.0 * log((1.0i + wx3) / (wx3 + xb))
                    - 4.0 * log(((1.0i + wx3) * (1.0 - 1.0i * xb)) / (2.0 * (wx3 + xb))) + 4.0 * log((wx3 + xb) / (1.0i + wx3)) - 4.0 * log(((2.0 * 1.0i) * (wx3 + xb)) / ((1.0i + wx3) * (1.0i + xb))) + 4.0 * log((1.0i + wx4) / (wx4 + xb)) - 4.0 * log(((1.0i + wx4) * (1.0 - 1.0i * xb)) / (2.0 * (wx4 + xb))) + 4.0 * log((wx4 + xb) / (1.0i + wx4)) - 4.0 * log(((2.0 * 1.0i) * (wx4 + xb)) / ((1.0i + wx4) * (1.0i + xb)))) - 4.0 * dilog((1.0i * (wx3 - xb)) / ((-1.0i + wx3) * xb)) * log(1.0 - xb / wx3) - 4.0 * dilog(((-1.0i) * (wx3 - xb)) / ((1.0i + wx3) * xb)) * log(1.0 - xb / wx3) - 4.0 * dilog(((-1.0i) * (wx3 - xb)) / (wx3 * (-1.0i + xb))) * log(1.0 - xb / wx3)
                - 4.0 * dilog((1.0i * (wx3 - xb)) / (wx3 * (1.0i + xb))) * log(1.0 - xb / wx3) + 4.0 * dilog((-wx3 + xb) / (-1.0i + xb)) * log(1.0 - xb / wx3) + 4.0 * dilog((-wx3 + xb) / (1.0i + xb)) * log(1.0 - xb / wx3) + 2.0 * log((-1.0i + xb) / (-1.0i + wx3)) * power_of<2>(log(1.0 - xb / wx3)) + (2.0 * log((-1.0i + wx3) / (-1.0i + xb)) - 2.0 * log(((-1.0i + wx3) * xb) / (wx3 * (-1.0i + xb))) - 2.0 * log((wx3 * (-1.0i + xb)) / ((-1.0i + wx3) * xb)) + 2.0 * log((1.0i + wx3) / (1.0i + xb)) - 2.0 * log(((1.0i + wx3) * xb) / (wx3 * (1.0i + xb))) + 2.0 * log((1.0i + xb) / (1.0i + wx3)) - 2.0 * log((wx3 * (1.0i + xb)) / ((1.0i + wx3) * xb))) * power_of<2>(log(1.0 - xb / wx3))
                + dilog((wx3 - xb) / (-1.0i + wx3)) * (4.0 * log(xb) + 4.0 * log(1.0 - xb / wx3)) + dilog((wx3 - xb) / (1.0i + wx3)) * (4.0 * log(xb) + 4.0 * log(1.0 - xb / wx3)) - 4.0 * dilog((1.0i * (wx4 - xb)) / ((-1.0i + wx4) * xb)) * log(1.0 - xb / wx4) - 4.0 * dilog(((-1.0i) * (wx4 - xb)) / ((1.0i + wx4) * xb)) * log(1.0 - xb / wx4) - 4.0 * dilog(((-1.0i) * (wx4 - xb)) / (wx4 * (-1.0i + xb))) * log(1.0 - xb / wx4) - 4.0 * dilog((1.0i * (wx4 - xb)) / (wx4 * (1.0i + xb))) * log(1.0 - xb / wx4) + 4.0 * dilog((-wx4 + xb) / (-1.0i + xb)) * log(1.0 - xb / wx4) + 4.0 * dilog((-wx4 + xb) / (1.0i + xb)) * log(1.0 - xb / wx4)
                + 2.0 * log((-1.0i + xb) / (-1.0i + wx4)) * power_of<2>(log(1.0 - xb / wx4)) + (2.0 * log((-1.0i + wx4) / (-1.0i + xb)) - 2.0 * log(((-1.0i + wx4) * xb) / (wx4 * (-1.0i + xb))) - 2.0 * log((wx4 * (-1.0i + xb)) / ((-1.0i + wx4) * xb)) + 2.0 * log((1.0i + wx4) / (1.0i + xb)) - 2.0 * log(((1.0i + wx4) * xb) / (wx4 * (1.0i + xb))) + 2.0 * log((1.0i + xb) / (1.0i + wx4)) - 2.0 * log((wx4 * (1.0i + xb)) / ((1.0i + wx4) * xb))) * power_of<2>(log(1.0 - xb / wx4)) + dilog((wx4 - xb) / (-1.0i + wx4)) * (4.0 * log(xb) + 4.0 * log(1.0 - xb / wx4)) + dilog((wx4 - xb) / (1.0i + wx4)) * (4.0 * log(xb) + 4.0 * log(1.0 - xb / wx4))
                + 1.0i * M_PI * H1(-2.0 / (-1.0 + w7), -2.0 / (-1.0 + tb)) * power_of<2>(log((tb - w7) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 - tb))) - 1.0i * M_PI * H1((-1.0 + w7) / (-1.0 + tb), -2.0 / (-1.0 + tb)) * power_of<2>(log(((-1.0 + tb) * (1.0 + w7)) / (2.0 * (-1.0 + w7)))) * my_sign(2.0 * imag(1.0 / (1.0 - tb))) - 1.0i * M_PI * H1(w7 / tb, -1.0 / tb) * power_of<2>(log(tb * (1.0 + w7inv))) * my_sign(-imag(1.0 / tb)) + 1.0i * M_PI * H1(-w7inv, -1.0 / tb) * power_of<2>(log(tb - w7)) * my_sign(-imag(1.0 / tb)) - 1.0i * M_PI * H1(w7 / tb, 1.0 / tb) * power_of<2>(log(tb * (-1.0 + w7inv))) * my_sign(imag(1.0 / tb)) + 1.0i * M_PI * H1(w7inv, 1.0 / tb) * power_of<2>(log(-tb + w7)) * my_sign(imag(1.0 / tb))
                + 1.0i * M_PI * H1((1.0 + w7) / (1.0 + tb), 2.0 / (1.0 + tb)) * power_of<2>(log((-0.5) * (((1.0 + tb) * (-1.0 + w7)) / (1.0 + w7)))) * my_sign(2.0 * imag(1.0 / (1.0 + tb))) - 1.0i * M_PI * H1(2.0 / (1.0 + w7), 2.0 / (1.0 + tb)) * power_of<2>(log((-tb + w7) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 + tb))) + 1.0i * M_PI * H1((1.0 + w7) / (1.0 - vb), -2.0 / (-1.0 + vb)) * power_of<2>(log(((-1.0 + vb) * (-1.0 + w7)) / (2.0 * (1.0 + w7)))) * my_sign(2.0 * imag(1.0 / (1.0 - vb))) - 1.0i * M_PI * H1(2.0 / (1.0 + w7), -2.0 / (-1.0 + vb)) * power_of<2>(log((vb + w7) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 - vb))) - 1.0i * M_PI * H1(-(w7 / vb), -1.0 / vb) * power_of<2>(log((vb * (-1.0 + w7)) / w7)) * my_sign(-imag(1.0 / vb))
                + 1.0i * M_PI * H1(w7inv, -1.0 / vb) * power_of<2>(log(vb + w7)) * my_sign(-imag(1.0 / vb)) + 1.0i * M_PI * H1(-w7inv, 1.0 / vb) * power_of<2>(log(-vb - w7)) * my_sign(imag(1.0 / vb)) - 1.0i * M_PI * H1(-(w7 / vb), 1.0 / vb) * power_of<2>(log(-((vb * (1.0 + w7)) / w7))) * my_sign(imag(1.0 / vb)) + 1.0i * M_PI * H1(-2.0 / (-1.0 + w7), 2.0 / (1.0 + vb)) * power_of<2>(log((-vb - w7) / 2.0)) * my_sign(2.0 * imag(1.0 / (1.0 + vb))) - 1.0i * M_PI * H1((1.0 - w7) / (1.0 + vb), 2.0 / (1.0 + vb)) * power_of<2>(log(((1.0 + vb) * (1.0 + w7)) / (2.0 - 2.0 * w7))) * my_sign(2.0 * imag(1.0 / (1.0 + vb))) + (2.0 * 1.0i) * M_PI * H1((1.0 + w4) / (-1.0 + w4), 1.0 + w4inv) * power_of<2>(log(-1.0 / (1.0 + w4))) * my_sign(-imag(w4inv))
                - (2.0 * 1.0i) * M_PI * H1((-1.0 + w4) / w4, 1.0 + w4inv) * power_of<2>(log((2.0 * w4) / (-1.0 + power_of<2>(w4)))) * my_sign(-imag(w4inv)) - (2.0 * 1.0i) * M_PI * H1((1.0 + w4) / (w4 - w7), 1.0 + w4inv) * power_of<2>(log(-(w7 / (1.0 + w4)))) * my_sign(-imag(w4inv)) + (2.0 * 1.0i) * M_PI * H1(1.0 - w7 / w4, 1.0 + w4inv) * power_of<2>(log((w4 * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7)))) * my_sign(-imag(w4inv)) + (2.0 * 1.0i) * M_PI * H1((-1.0 + w4) / (1.0 + w4), (-1.0 + w4) / w4) * power_of<2>(log(1.0 / (-1.0 + w4))) * my_sign(imag(w4inv)) - (2.0 * 1.0i) * M_PI * H1(1.0 + w4inv, (-1.0 + w4) / w4) * power_of<2>(log((-2.0 * w4) / (-1.0 + power_of<2>(w4)))) * my_sign(imag(w4inv))
                - (2.0 * 1.0i) * M_PI * H1(1.0 - w7 / w4, (-1.0 + w4) / w4) * power_of<2>(log((w4 * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7)))) * my_sign(imag(w4inv)) + (2.0 * 1.0i) * M_PI * H1((-1.0 + w4) / (w4 - w7), (-1.0 + w4) / w4) * power_of<2>(log(w7 / (1.0 - w4))) * my_sign(imag(w4inv)) + 1.0i * M_PI * H1(w4, w4 / tb) * power_of<2>(log((1.0 - tb) / w4)) * my_sign(imag(w4 / tb)) - 1.0i * M_PI * H1(-w4, w4 / tb) * power_of<2>(log(-((1.0 + tb) / w4))) * my_sign(imag(w4 / tb)) - 1.0i * M_PI * H1(1.0 / tb, w4 / tb) * power_of<2>(log((tb * (-1.0 + w4)) / w4)) * my_sign(imag(w4 / tb)) + 1.0i * M_PI * H1(-1.0 / tb, w4 / tb) * power_of<2>(log(-((tb * (1.0 + w4)) / w4))) * my_sign(imag(w4 / tb))
                + 1.0i * M_PI * H1(w7 / tb, w4 / tb) * power_of<2>(log(tb * (-w4inv + w7inv))) * my_sign(imag(w4 / tb)) - 1.0i * M_PI * H1(w4 / w7, w4 / tb) * power_of<2>(log((-tb + w7) / w4)) * my_sign(imag(w4 / tb)) - 1.0i * M_PI * H1(-1.0 / vb, -(w4 / vb)) * power_of<2>(log(vb * (-1.0 + w4inv))) * my_sign(-imag(w4 / vb)) + 1.0i * M_PI * H1(1.0 / vb, -(w4 / vb)) * power_of<2>(log(vb * (1.0 + w4inv))) * my_sign(-imag(w4 / vb)) - 1.0i * M_PI * H1(-w4, -(w4 / vb)) * power_of<2>(log((-1.0 + vb) / w4)) * my_sign(-imag(w4 / vb)) + 1.0i * M_PI * H1(w4, -(w4 / vb)) * power_of<2>(log((1.0 + vb) / w4)) * my_sign(-imag(w4 / vb)) + 1.0i * M_PI * H1(-(w7 / vb), -(w4 / vb)) * power_of<2>(log(vb * (w4inv - w7inv))) * my_sign(-imag(w4 / vb))
                - 1.0i * M_PI * H1(w4 / w7, -(w4 / vb)) * power_of<2>(log((vb + w7) / w4)) * my_sign(-imag(w4 / vb)) + 1.0i * M_PI * H1((-1.0 + w4) / (1.0 + w4), (-1.0 + w4) / (-tb + w4)) * power_of<2>(log((1.0 + tb) / (-1.0 + w4))) * my_sign(imag((-1.0 + w4) / (-tb + w4))) - 1.0i * M_PI * H1((1.0 + w4) / (-tb + w4), (-1.0 + w4) / (-tb + w4)) * power_of<2>(log((2.0 * (tb - w4)) / (-1.0 + power_of<2>(w4)))) * my_sign(imag((-1.0 + w4) / (-tb + w4))) + 1.0i * M_PI * H1((-1.0 + w4) / (w4 - w7), (-1.0 + w4) / (-tb + w4)) * power_of<2>(log((tb - w7) / (-1.0 + w4))) * my_sign(imag((-1.0 + w4) / (-tb + w4)))
                - 1.0i * M_PI * H1((-w4 + w7) / (tb - w4), (-1.0 + w4) / (-tb + w4)) * power_of<2>(log(((-tb + w4) * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7)))) * my_sign(imag((-1.0 + w4) / (-tb + w4))) + 1.0i * M_PI * H1((1.0 + w4) / (-1.0 + w4), (1.0 + w4) / (-tb + w4)) * power_of<2>(log((-1.0 + tb) / (1.0 + w4))) * my_sign(imag((1.0 + w4) / (-tb + w4))) - 1.0i * M_PI * H1((-1.0 + w4) / (-tb + w4), (1.0 + w4) / (-tb + w4)) * power_of<2>(log((2.0 * (-tb + w4)) / (-1.0 + power_of<2>(w4)))) * my_sign(imag((1.0 + w4) / (-tb + w4))) - 1.0i * M_PI * H1((1.0 + w4) / (w4 - w7), (1.0 + w4) / (-tb + w4)) * power_of<2>(log((tb - w7) / (1.0 + w4))) * my_sign(imag((1.0 + w4) / (-tb + w4)))
                + 1.0i * M_PI * H1((-w4 + w7) / (tb - w4), (1.0 + w4) / (-tb + w4)) * power_of<2>(log(((-tb + w4) * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7)))) * my_sign(imag((1.0 + w4) / (-tb + w4))) + 1.0i * M_PI * H1((-1.0 + w4) / (1.0 + w4), (-1.0 + w4) / (vb + w4)) * power_of<2>(log((1.0 - vb) / (-1.0 + w4))) * my_sign(imag((-1.0 + w4) / (vb + w4))) - 1.0i * M_PI * H1((1.0 + w4) / (vb + w4), (-1.0 + w4) / (vb + w4)) * power_of<2>(log((-2.0 * (vb + w4)) / (-1.0 + power_of<2>(w4)))) * my_sign(imag((-1.0 + w4) / (vb + w4))) - 1.0i * M_PI * H1((w4 - w7) / (vb + w4), (-1.0 + w4) / (vb + w4)) * power_of<2>(log(((vb + w4) * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7)))) * my_sign(imag((-1.0 + w4) / (vb + w4)))
                + 1.0i * M_PI * H1((-1.0 + w4) / (w4 - w7), (-1.0 + w4) / (vb + w4)) * power_of<2>(log((vb + w7) / (1.0 - w4))) * my_sign(imag((-1.0 + w4) / (vb + w4))) + 1.0i * M_PI * H1((1.0 + w4) / (-1.0 + w4), (1.0 + w4) / (vb + w4)) * power_of<2>(log(-((1.0 + vb) / (1.0 + w4)))) * my_sign(imag((1.0 + w4) / (vb + w4))) - 1.0i * M_PI * H1((-1.0 + w4) / (vb + w4), (1.0 + w4) / (vb + w4)) * power_of<2>(log((2.0 * (vb + w4)) / (-1.0 + power_of<2>(w4)))) * my_sign(imag((1.0 + w4) / (vb + w4))) + 1.0i * M_PI * H1((w4 - w7) / (vb + w4), (1.0 + w4) / (vb + w4)) * power_of<2>(log(((vb + w4) * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7)))) * my_sign(imag((1.0 + w4) / (vb + w4)))
                - 1.0i * M_PI * H1((1.0 + w4) / (w4 - w7), (1.0 + w4) / (vb + w4)) * power_of<2>(log(-((vb + w7) / (1.0 + w4)))) * my_sign(imag((1.0 + w4) / (vb + w4))) + (2.0 * 1.0i) * M_PI * H1((1.0 + w5) / (-1.0 + w5), 1.0 + w5inv) * power_of<2>(log(-1.0 / (1.0 + w5))) * my_sign(-imag(w5inv)) - (2.0 * 1.0i) * M_PI * H1((-1.0 + w5) / w5, 1.0 + w5inv) * power_of<2>(log((2.0 * w5) / (-1.0 + power_of<2>(w5)))) * my_sign(-imag(w5inv)) + (2.0 * 1.0i) * M_PI * H1((1.0 + w5) / (w5 + w7), 1.0 + w5inv) * power_of<2>(log(w7 / (1.0 + w5))) * my_sign(-imag(w5inv)) - (2.0 * 1.0i) * M_PI * H1((w5 + w7) / w5, 1.0 + w5inv) * power_of<2>(log((w5 - w5 * w7) / (w5 + power_of<2>(w5) + w7 + w5 * w7))) * my_sign(-imag(w5inv))
                + (2.0 * 1.0i) * M_PI * H1((-1.0 + w5) / (1.0 + w5), (-1.0 + w5) / w5) * power_of<2>(log(1.0 / (-1.0 + w5))) * my_sign(imag(w5inv)) - (2.0 * 1.0i) * M_PI * H1(1.0 + w5inv, (-1.0 + w5) / w5) * power_of<2>(log((-2.0 * w5) / (-1.0 + power_of<2>(w5)))) * my_sign(imag(w5inv)) - (2.0 * 1.0i) * M_PI * H1((-1.0 + w5) / (w5 + w7), (-1.0 + w5) / w5) * power_of<2>(log(w7 / (-1.0 + w5))) * my_sign(imag(w5inv)) + (2.0 * 1.0i) * M_PI * H1((w5 + w7) / w5, (-1.0 + w5) / w5) * power_of<2>(log(-((w5 * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7))))) * my_sign(imag(w5inv)) + 1.0i * M_PI * H1(-1.0 / tb, -(w5 / tb)) * power_of<2>(log(tb * (-1.0 + w5inv))) * my_sign(-imag(w5 / tb)) - 1.0i * M_PI * H1(1.0 / tb, -(w5 / tb)) * power_of<2>(log(tb * (1.0 + w5inv))) * my_sign(-imag(w5 / tb))
                + 1.0i * M_PI * H1(-w5, -(w5 / tb)) * power_of<2>(log((-1.0 + tb) / w5)) * my_sign(-imag(w5 / tb)) - 1.0i * M_PI * H1(w5, -(w5 / tb)) * power_of<2>(log((1.0 + tb) / w5)) * my_sign(-imag(w5 / tb)) + 1.0i * M_PI * H1(w7 / tb, -(w5 / tb)) * power_of<2>(log(tb * (w5inv + w7inv))) * my_sign(-imag(w5 / tb)) - 1.0i * M_PI * H1(-(w5 / w7), -(w5 / tb)) * power_of<2>(log((tb - w7) / w5)) * my_sign(-imag(w5 / tb)) - 1.0i * M_PI * H1(w5, w5 / vb) * power_of<2>(log((1.0 - vb) / w5)) * my_sign(imag(w5 / vb)) + 1.0i * M_PI * H1(-w5, w5 / vb) * power_of<2>(log(-((1.0 + vb) / w5))) * my_sign(imag(w5 / vb)) + 1.0i * M_PI * H1(1.0 / vb, w5 / vb) * power_of<2>(log((vb * (-1.0 + w5)) / w5)) * my_sign(imag(w5 / vb))
                - 1.0i * M_PI * H1(-1.0 / vb, w5 / vb) * power_of<2>(log(-((vb * (1.0 + w5)) / w5))) * my_sign(imag(w5 / vb)) - 1.0i * M_PI * H1(-(w5 / w7), w5 / vb) * power_of<2>(log(-((vb + w7) / w5))) * my_sign(imag(w5 / vb)) + 1.0i * M_PI * H1(-(w7 / vb), w5 / vb) * power_of<2>(log(-((vb * (w5 + w7)) / (w5 * w7)))) * my_sign(imag(w5 / vb)) + 1.0i * M_PI * H1((-1.0 + w5) / (1.0 + w5), (-1.0 + w5) / (tb + w5)) * power_of<2>(log((1.0 - tb) / (-1.0 + w5))) * my_sign(imag((-1.0 + w5) / (tb + w5))) - 1.0i * M_PI * H1((1.0 + w5) / (tb + w5), (-1.0 + w5) / (tb + w5)) * power_of<2>(log((-2.0 * (tb + w5)) / (-1.0 + power_of<2>(w5)))) * my_sign(imag((-1.0 + w5) / (tb + w5)))
                - 1.0i * M_PI * H1((-1.0 + w5) / (w5 + w7), (-1.0 + w5) / (tb + w5)) * power_of<2>(log((-tb + w7) / (-1.0 + w5))) * my_sign(imag((-1.0 + w5) / (tb + w5))) + 1.0i * M_PI * H1((w5 + w7) / (tb + w5), (-1.0 + w5) / (tb + w5)) * power_of<2>(log(-(((tb + w5) * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7))))) * my_sign(imag((-1.0 + w5) / (tb + w5))) + 1.0i * M_PI * H1((1.0 + w5) / (-1.0 + w5), (1.0 + w5) / (tb + w5)) * power_of<2>(log(-((1.0 + tb) / (1.0 + w5)))) * my_sign(imag((1.0 + w5) / (tb + w5))) - 1.0i * M_PI * H1((-1.0 + w5) / (tb + w5), (1.0 + w5) / (tb + w5)) * power_of<2>(log((2.0 * (tb + w5)) / (-1.0 + power_of<2>(w5)))) * my_sign(imag((1.0 + w5) / (tb + w5)))
                + 1.0i * M_PI * H1((1.0 + w5) / (w5 + w7), (1.0 + w5) / (tb + w5)) * power_of<2>(log((-tb + w7) / (1.0 + w5))) * my_sign(imag((1.0 + w5) / (tb + w5))) - 1.0i * M_PI * H1((w5 + w7) / (tb + w5), (1.0 + w5) / (tb + w5)) * power_of<2>(log(-(((tb + w5) * (-1.0 + w7)) / ((1.0 + w5) * (w5 + w7))))) * my_sign(imag((1.0 + w5) / (tb + w5))) + 1.0i * M_PI * H1((-1.0 + w5) / (1.0 + w5), (-1.0 + w5) / (-vb + w5)) * power_of<2>(log((1.0 + vb) / (-1.0 + w5))) * my_sign(imag((-1.0 + w5) / (-vb + w5))) - 1.0i * M_PI * H1((1.0 + w5) / (-vb + w5), (-1.0 + w5) / (-vb + w5)) * power_of<2>(log((2.0 * (vb - w5)) / (-1.0 + power_of<2>(w5)))) * my_sign(imag((-1.0 + w5) / (-vb + w5)))
                - 1.0i * M_PI * H1((-1.0 + w5) / (w5 + w7), (-1.0 + w5) / (-vb + w5)) * power_of<2>(log((vb + w7) / (-1.0 + w5))) * my_sign(imag((-1.0 + w5) / (-vb + w5))) + 1.0i * M_PI * H1((w5 + w7) / (-vb + w5), (-1.0 + w5) / (-vb + w5)) * power_of<2>(log(((vb - w5) * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7)))) * my_sign(imag((-1.0 + w5) / (-vb + w5))) + 1.0i * M_PI * H1((1.0 + w5) / (-1.0 + w5), (1.0 + w5) / (-vb + w5)) * power_of<2>(log((-1.0 + vb) / (1.0 + w5))) * my_sign(imag((1.0 + w5) / (-vb + w5))) - 1.0i * M_PI * H1((-1.0 + w5) / (-vb + w5), (1.0 + w5) / (-vb + w5)) * power_of<2>(log((2.0 * (-vb + w5)) / (-1.0 + power_of<2>(w5)))) * my_sign(imag((1.0 + w5) / (-vb + w5)))
                + 1.0i * M_PI * H1((1.0 + w5) / (w5 + w7), (1.0 + w5) / (-vb + w5)) * power_of<2>(log((vb + w7) / (1.0 + w5))) * my_sign(imag((1.0 + w5) / (-vb + w5))) - 1.0i * M_PI * H1((w5 + w7) / (-vb + w5), (1.0 + w5) / (-vb + w5)) * power_of<2>(log(((vb - w5) * (-1.0 + w7)) / ((1.0 + w5) * (w5 + w7)))) * my_sign(imag((1.0 + w5) / (-vb + w5))) - 1.0i * M_PI * H1((w4 - w7) / (1.0 + w4), (w4 - w7) / (vb + w4)) * power_of<2>(log((1.0 - vb) / (w4 - w7))) * my_sign(imag((w4 - w7) / (vb + w4))) + 1.0i * M_PI * H1((w4 - w7) / (-1.0 + w4), (w4 - w7) / (vb + w4)) * power_of<2>(log(-((1.0 + vb) / (w4 - w7)))) * my_sign(imag((w4 - w7) / (vb + w4)))
                - 1.0i * M_PI * H1((-1.0 + w4) / (vb + w4), (w4 - w7) / (vb + w4)) * power_of<2>(log(-(((vb + w4) * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7))))) * my_sign(imag((w4 - w7) / (vb + w4))) + 1.0i * M_PI * H1((1.0 + w4) / (vb + w4), (w4 - w7) / (vb + w4)) * power_of<2>(log(-(((vb + w4) * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7))))) * my_sign(imag((w4 - w7) / (vb + w4))) - (2.0 * 1.0i) * M_PI * H1((w4 - w7) / (1.0 + w4), 1.0 - w7 / w4) * power_of<2>(log(1.0 / (w4 - w7))) * my_sign(imag(w7 / w4)) - (2.0 * 1.0i) * M_PI * H1((-1.0 + w4) / w4, 1.0 - w7 / w4) * power_of<2>(log(-((w4 * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7))))) * my_sign(imag(w7 / w4))
                + (2.0 * 1.0i) * M_PI * H1(1.0 + w4inv, 1.0 - w7 / w4) * power_of<2>(log(-((w4 * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7))))) * my_sign(imag(w7 / w4)) + (2.0 * 1.0i) * M_PI * H1((w4 - w7) / (-1.0 + w4), 1.0 - w7 / w4) * power_of<2>(log(1.0 / (-w4 + w7))) * my_sign(imag(w7 / w4)) - (2.0 * 1.0i) * M_PI * H1((w5 + w7) / (-1.0 + w5), (w5 + w7) / w5) * power_of<2>(log(-1.0 / (w5 + w7))) * my_sign(-imag(w7 / w5)) + (2.0 * 1.0i) * M_PI * H1((w5 + w7) / (1.0 + w5), (w5 + w7) / w5) * power_of<2>(log(1.0 / (w5 + w7))) * my_sign(-imag(w7 / w5)) - (2.0 * 1.0i) * M_PI * H1(1.0 + w5inv, (w5 + w7) / w5) * power_of<2>(log((w5 * (-1.0 + w7)) / ((1.0 + w5) * (w5 + w7)))) * my_sign(-imag(w7 / w5))
                + (2.0 * 1.0i) * M_PI * H1((-1.0 + w5) / w5, (w5 + w7) / w5) * power_of<2>(log((w5 * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7)))) * my_sign(-imag(w7 / w5)) + 1.0i * M_PI * H1((w4 - w7) / (-1.0 + w4), (-w4 + w7) / (tb - w4)) * power_of<2>(log((-1.0 + tb) / (w4 - w7))) * my_sign(imag((-w4 + w7) / (tb - w4))) - 1.0i * M_PI * H1((w4 - w7) / (1.0 + w4), (-w4 + w7) / (tb - w4)) * power_of<2>(log((1.0 + tb) / (w4 - w7))) * my_sign(imag((-w4 + w7) / (tb - w4))) - 1.0i * M_PI * H1((-1.0 + w4) / (-tb + w4), (-w4 + w7) / (tb - w4)) * power_of<2>(log(((tb - w4) * (-1.0 + w7)) / ((-1.0 + w4) * (w4 - w7)))) * my_sign(imag((-w4 + w7) / (tb - w4)))
                + 1.0i * M_PI * H1((1.0 + w4) / (-tb + w4), (-w4 + w7) / (tb - w4)) * power_of<2>(log(((tb - w4) * (1.0 + w7)) / ((1.0 + w4) * (w4 - w7)))) * my_sign(imag((-w4 + w7) / (tb - w4))) + 1.0i * M_PI * H1((w5 + w7) / (1.0 + w5), (w5 + w7) / (tb + w5)) * power_of<2>(log((1.0 - tb) / (w5 + w7))) * my_sign(imag((w5 + w7) / (tb + w5))) - 1.0i * M_PI * H1((w5 + w7) / (-1.0 + w5), (w5 + w7) / (tb + w5)) * power_of<2>(log(-((1.0 + tb) / (w5 + w7)))) * my_sign(imag((w5 + w7) / (tb + w5))) - 1.0i * M_PI * H1((1.0 + w5) / (tb + w5), (w5 + w7) / (tb + w5)) * power_of<2>(log(((tb + w5) * (-1.0 + w7)) / ((1.0 + w5) * (w5 + w7)))) * my_sign(imag((w5 + w7) / (tb + w5)))
                + 1.0i * M_PI * H1((-1.0 + w5) / (tb + w5), (w5 + w7) / (tb + w5)) * power_of<2>(log(((tb + w5) * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7)))) * my_sign(imag((w5 + w7) / (tb + w5))) - 1.0i * M_PI * H1((w5 + w7) / (-1.0 + w5), (w5 + w7) / (-vb + w5)) * power_of<2>(log((-1.0 + vb) / (w5 + w7))) * my_sign(imag((w5 + w7) / (-vb + w5))) + 1.0i * M_PI * H1((w5 + w7) / (1.0 + w5), (w5 + w7) / (-vb + w5)) * power_of<2>(log((1.0 + vb) / (w5 + w7))) * my_sign(imag((w5 + w7) / (-vb + w5))) - 1.0i * M_PI * H1((1.0 + w5) / (-vb + w5), (w5 + w7) / (-vb + w5)) * power_of<2>(log(((-vb + w5) * (-1.0 + w7)) / ((1.0 + w5) * (w5 + w7)))) * my_sign(imag((w5 + w7) / (-vb + w5)))
                + 1.0i * M_PI * H1((-1.0 + w5) / (-vb + w5), (w5 + w7) / (-vb + w5)) * power_of<2>(log(((-vb + w5) * (1.0 + w7)) / ((-1.0 + w5) * (w5 + w7)))) * my_sign(imag((w5 + w7) / (-vb + w5))) + (4.0 * 1.0i) * M_PI * H1(1.0i * wx3, -(wx3 * xbinv)) * power_of<2>(log((-1.0i + xb) / wx3)) * my_sign(-imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1((-1.0i) * wx3, -(wx3 * xbinv)) * power_of<2>(log((1.0i + xb) / wx3)) * my_sign(-imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1((-1.0i) * wx3, wx3 * xbinv) * power_of<2>(log((1.0i - xb) / wx3)) * my_sign(imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(1.0i * wx3, wx3 * xbinv) * power_of<2>(log(-((1.0i + xb) / wx3))) * my_sign(imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(1.0i * wx4, -(wx4 * xbinv)) * power_of<2>(log((-1.0i + xb) / wx4)) * my_sign(-imag(wx4 * xbinv))
                + (4.0 * 1.0i) * M_PI * H1((-1.0i) * wx4, -(wx4 * xbinv)) * power_of<2>(log((1.0i + xb) / wx4)) * my_sign(-imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1((-1.0i) * wx4, wx4 * xbinv) * power_of<2>(log((1.0i - xb) / wx4)) * my_sign(imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(1.0i * wx4, wx4 * xbinv) * power_of<2>(log(-((1.0i + xb) / wx4))) * my_sign(imag(wx4 * xbinv)) + (8.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx3), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log((1.0i / 2.0) * (wx3 - xb))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) + (8.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx4), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log((1.0i / 2.0) * (wx4 - xb))) * my_sign(2.0 * real(1.0 / (1.0i - xb)))
                - (8.0 * 1.0i) * M_PI * H1((-1.0i + wx3) / (-1.0i + xb), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log(((1.0i + wx3) * (1.0 + 1.0i * xb)) / (2.0 * 1.0i - 2.0 * wx3))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) - (8.0 * 1.0i) * M_PI * H1((-1.0i + wx4) / (-1.0i + xb), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log(((1.0i + wx4) * (1.0 + 1.0i * xb)) / (2.0 * 1.0i - 2.0 * wx4))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) - (8.0 * 1.0i) * M_PI * H1((1.0i + wx3) / (1.0i - xb), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log((((-0.5) * 1.0i) * (-1.0i + wx3) * (-1.0i + xb)) / (1.0i + wx3))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) - (8.0 * 1.0i) * M_PI * H1((1.0i + wx4) / (1.0i - xb), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log((((-0.5) * 1.0i) * (-1.0i + wx4) * (-1.0i + xb)) / (1.0i + wx4))) * my_sign(2.0 * real(1.0 / (1.0i - xb)))
                + (8.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + wx3), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log(((-0.5) * 1.0i) * (wx3 + xb))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) + (8.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + wx4), (-2.0 * 1.0i) / (-1.0i + xb)) * power_of<2>(log(((-0.5) * 1.0i) * (wx4 + xb))) * my_sign(2.0 * real(1.0 / (1.0i - xb))) + power_of<2>(log((-1.0i - wx3inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(1.0i / xb, wx3 * xbinv) * my_sign(imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(-(wx3 * xbinv), -1.0i / xb) * my_sign(-real(xbinv))) + power_of<2>(log((-1.0i + wx3inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(1.0i / xb, -(wx3 * xbinv)) * my_sign(-imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(wx3 * xbinv, -1.0i / xb) * my_sign(-real(xbinv)))
                + power_of<2>(log((-1.0i - wx4inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(1.0i / xb, wx4 * xbinv) * my_sign(imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(-(wx4 * xbinv), -1.0i / xb) * my_sign(-real(xbinv))) + power_of<2>(log((-1.0i + wx4inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(1.0i / xb, -(wx4 * xbinv)) * my_sign(-imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(wx4 * xbinv, -1.0i / xb) * my_sign(-real(xbinv))) + power_of<2>(log((1.0i - wx3inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(-1.0i / xb, wx3 * xbinv) * my_sign(imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(-(wx3 * xbinv), 1.0i / xb) * my_sign(real(xbinv))) + power_of<2>(log((1.0i + wx3inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(-1.0i / xb, -(wx3 * xbinv)) * my_sign(-imag(wx3 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(wx3 * xbinv, 1.0i / xb) * my_sign(real(xbinv)))
                + power_of<2>(log((1.0i - wx4inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(-1.0i / xb, wx4 * xbinv) * my_sign(imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(-(wx4 * xbinv), 1.0i / xb) * my_sign(real(xbinv))) + power_of<2>(log((1.0i + wx4inv) * xb)) * ((-4.0 * 1.0i) * M_PI * H1(-1.0i / xb, -(wx4 * xbinv)) * my_sign(-imag(wx4 * xbinv)) + (4.0 * 1.0i) * M_PI * H1(wx4 * xbinv, 1.0i / xb) * my_sign(real(xbinv))) + (8.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + wx3), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log(((-0.5) * 1.0i) * (wx3 - xb))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) + (8.0 * 1.0i) * M_PI * H1((2.0 * 1.0i) / (1.0i + wx4), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log(((-0.5) * 1.0i) * (wx4 - xb))) * my_sign(2.0 * real(1.0 / (1.0i + xb)))
                - (8.0 * 1.0i) * M_PI * H1((1.0i + wx3) / (1.0i + xb), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log(((1.0 + 1.0i * wx3) * (1.0i + xb)) / (2.0 * (1.0i + wx3)))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) - (8.0 * 1.0i) * M_PI * H1((1.0i + wx4) / (1.0i + xb), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log(((1.0 + 1.0i * wx4) * (1.0i + xb)) / (2.0 * (1.0i + wx4)))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) + (8.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx3), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log((1.0i / 2.0) * (wx3 + xb))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) + (8.0 * 1.0i) * M_PI * H1((-2.0 * 1.0i) / (-1.0i + wx4), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log((1.0i / 2.0) * (wx4 + xb))) * my_sign(2.0 * real(1.0 / (1.0i + xb)))
                - (8.0 * 1.0i) * M_PI * H1((1.0i - wx3) / (1.0i + xb), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log((1.0i + wx3 + xb - 1.0i * wx3 * xb) / (2.0 * 1.0i - 2.0 * wx3))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) - (8.0 * 1.0i) * M_PI * H1((1.0i - wx4) / (1.0i + xb), (2.0 * 1.0i) / (1.0i + xb)) * power_of<2>(log((1.0i + wx4 + xb - 1.0i * wx4 * xb) / (2.0 * 1.0i - 2.0 * wx4))) * my_sign(2.0 * real(1.0 / (1.0i + xb))) - (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 - w7) / 2.0)) * my_sign(imag(w7) / 2.0) * T(1.0, 1.0 / 2.0, (1.0 - w7) / 2.0) + 1.0i * M_PI * power_of<2>(log(w7 / (-1.0 + w7))) * my_sign(-imag(1.0 / (1.0 - w7))) * T(1.0, 1.0 / 2.0, w7 / (-1.0 + w7)) + 1.0i * M_PI * power_of<2>(log(w7 / (-1.0 + w7))) * my_sign(imag(1.0 / (-1.0 + w7))) * T(1.0, 1.0 / 2.0, w7 / (-1.0 + w7))
                - (2.0 * 1.0i) * M_PI * power_of<2>(log(w7 / (1.0 + w7))) * my_sign(-imag(1.0 / (1.0 + w7))) * T(1.0, 1.0 / 2.0, w7 / (1.0 + w7)) + (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w7) / 2.0)) * my_sign((-0.5) * imag(w7)) * T(1.0, 1.0 / 2.0, (1.0 + w7) / 2.0) + (16.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx3)) * my_sign(real(wx3) / 2.0) * T(1.0, 1.0 / 2.0, 1.0 / 2.0 - (1.0i / 2.0) * wx3) + (16.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx3)) * my_sign((-0.5) * real(wx3)) * T(1.0, 1.0 / 2.0, 1.0 / 2.0 + (1.0i / 2.0) * wx3) + (8.0 * 1.0i) * M_PI * power_of<2>(log(wx3 / (-1.0i + wx3))) * my_sign(-real(1.0 / (1.0i - wx3))) * T(1.0, 1.0 / 2.0, wx3 / (-1.0i + wx3)) + (8.0 * 1.0i) * M_PI * power_of<2>(log(wx3 / (-1.0i + wx3))) * my_sign(real(1.0 / (-1.0i + wx3))) * T(1.0, 1.0 / 2.0, wx3 / (-1.0i + wx3))
                + (16.0 * 1.0i) * M_PI * power_of<2>(log(wx3 / (1.0i + wx3))) * my_sign(-real(1.0 / (1.0i + wx3))) * T(1.0, 1.0 / 2.0, wx3 / (1.0i + wx3)) + (16.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx4)) * my_sign(real(wx4) / 2.0) * T(1.0, 1.0 / 2.0, 1.0 / 2.0 - (1.0i / 2.0) * wx4) + (16.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx4)) * my_sign((-0.5) * real(wx4)) * T(1.0, 1.0 / 2.0, 1.0 / 2.0 + (1.0i / 2.0) * wx4) + (8.0 * 1.0i) * M_PI * power_of<2>(log(wx4 / (-1.0i + wx4))) * my_sign(-real(1.0 / (1.0i - wx4))) * T(1.0, 1.0 / 2.0, wx4 / (-1.0i + wx4)) + (8.0 * 1.0i) * M_PI * power_of<2>(log(wx4 / (-1.0i + wx4))) * my_sign(real(1.0 / (-1.0i + wx4))) * T(1.0, 1.0 / 2.0, wx4 / (-1.0i + wx4)) + (16.0 * 1.0i) * M_PI * power_of<2>(log(wx4 / (1.0i + wx4))) * my_sign(-real(1.0 / (1.0i + wx4))) * T(1.0, 1.0 / 2.0, wx4 / (1.0i + wx4))
                - (2.0 * 1.0i) * M_PI * log(1.0 + tb) * log((1.0 - w7) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 + tb))) * T(1.0, (1.0 - tb) / 2.0, (1.0 - w7) / 2.0) + 1.0i * M_PI * power_of<2>(log((1.0 - w7) / 2.0)) * my_sign(imag(w7) / 2.0) * T(1.0, (1.0 - tb) / 2.0, (1.0 - w7) / 2.0) - 1.0i * M_PI * power_of<2>(log((-tb + w7) / (1.0 + w7))) * my_sign(imag((1.0 + tb) / (1.0 + w7))) * T(1.0, (1.0 - tb) / 2.0, (-tb + w7) / (1.0 + w7)) + (2.0 * 1.0i) * M_PI * log(1.0 - tb) * log(1.0 - w4) * my_sign(imag(1.0 / tb)) * T(1.0, 1.0 - tb, 1.0 - w4) + 1.0i * M_PI * power_of<2>(log(1.0 - w4)) * my_sign(imag(w4)) * T(1.0, 1.0 - tb, 1.0 - w4) + (2.0 * 1.0i) * M_PI * log(1.0 - tb) * log(1.0 + w5) * my_sign(imag(1.0 / tb)) * T(1.0, 1.0 - tb, 1.0 + w5)
                + 1.0i * M_PI * power_of<2>(log(1.0 + w5)) * my_sign(-imag(w5)) * T(1.0, 1.0 - tb, 1.0 + w5) + 1.0i * M_PI * power_of<2>(log(1.0 - tb / w7)) * my_sign(imag(tb / w7)) * T(1.0, 1.0 - tb, 1.0 - tb / w7) - (2.0 * 1.0i) * M_PI * log(1.0 - tb) * log(1.0 - w7) * my_sign(imag(1.0 / tb)) * T(1.0, 1.0 - tb, 1.0 - w7) + (2.0 * 1.0i) * M_PI * log(1.0 + tb) * log(1.0 - w7) * my_sign(imag(w7inv)) * T(1.0, 1.0 - tb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w7)) * my_sign(imag(w7)) * T(1.0, 1.0 - tb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * log(1.0 - w7) * log((1.0 + w7) / 2.0) * my_sign(imag(w7)) * T(1.0, 1.0 - tb, 1.0 - w7) + (2.0 * 1.0i) * M_PI * log(1.0 - tb) * log((1.0 + w7) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 - tb))) * T(1.0, (1.0 + tb) / 2.0, (1.0 + w7) / 2.0)
                - 1.0i * M_PI * power_of<2>(log((1.0 + w7) / 2.0)) * my_sign((-0.5) * imag(w7)) * T(1.0, (1.0 + tb) / 2.0, (1.0 + w7) / 2.0) + 1.0i * M_PI * power_of<2>(log((-tb + w7) / (-1.0 + w7))) * my_sign(imag((-1.0 + tb) / (-1.0 + w7))) * T(1.0, (1.0 + tb) / 2.0, (-tb + w7) / (-1.0 + w7)) + (2.0 * 1.0i) * M_PI * log(1.0 + tb) * log(1.0 + w4) * my_sign(-imag(1.0 / tb)) * T(1.0, 1.0 + tb, 1.0 + w4) + 1.0i * M_PI * power_of<2>(log(1.0 + w4)) * my_sign(-imag(w4)) * T(1.0, 1.0 + tb, 1.0 + w4) + (2.0 * 1.0i) * M_PI * log(1.0 + tb) * log(1.0 - w5) * my_sign(-imag(1.0 / tb)) * T(1.0, 1.0 + tb, 1.0 - w5) + 1.0i * M_PI * power_of<2>(log(1.0 - w5)) * my_sign(imag(w5)) * T(1.0, 1.0 + tb, 1.0 - w5)
                + 1.0i * M_PI * power_of<2>(log(1.0 - tb / w7)) * my_sign(imag(tb / w7)) * T(1.0, 1.0 + tb, 1.0 - tb / w7) + (2.0 * 1.0i) * M_PI * log(1.0 + tb) * log(1.0 + w7) * my_sign(-imag(1.0 / tb)) * T(1.0, 1.0 + tb, 1.0 + w7) - (2.0 * 1.0i) * M_PI * log(1.0 - tb) * log(1.0 + w7) * my_sign(-imag(w7inv)) * T(1.0, 1.0 + tb, 1.0 + w7) + (2.0 * 1.0i) * M_PI * log((1.0 - w7) / 2.0) * log(1.0 + w7) * my_sign(-imag(w7)) * T(1.0, 1.0 + tb, 1.0 + w7) + (2.0 * 1.0i) * M_PI * log(1.0 + vb) * log((1.0 + w7) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 + vb))) * T(1.0, (1.0 - vb) / 2.0, (1.0 + w7) / 2.0) - 1.0i * M_PI * power_of<2>(log((1.0 + w7) / 2.0)) * my_sign((-0.5) * imag(w7)) * T(1.0, (1.0 - vb) / 2.0, (1.0 + w7) / 2.0)
                + 1.0i * M_PI * power_of<2>(log((vb + w7) / (-1.0 + w7))) * my_sign(imag((1.0 + vb) / (1.0 - w7))) * T(1.0, (1.0 - vb) / 2.0, (vb + w7) / (-1.0 + w7)) + (2.0 * 1.0i) * M_PI * log(1.0 - vb) * log(1.0 + w4) * my_sign(imag(1.0 / vb)) * T(1.0, 1.0 - vb, 1.0 + w4) + 1.0i * M_PI * power_of<2>(log(1.0 + w4)) * my_sign(-imag(w4)) * T(1.0, 1.0 - vb, 1.0 + w4) + (2.0 * 1.0i) * M_PI * log(1.0 - vb) * log(1.0 - w5) * my_sign(imag(1.0 / vb)) * T(1.0, 1.0 - vb, 1.0 - w5) + 1.0i * M_PI * power_of<2>(log(1.0 - w5)) * my_sign(imag(w5)) * T(1.0, 1.0 - vb, 1.0 - w5) + (2.0 * 1.0i) * M_PI * log(1.0 - vb) * log(1.0 + w7) * my_sign(imag(1.0 / vb)) * T(1.0, 1.0 - vb, 1.0 + w7)
                - (2.0 * 1.0i) * M_PI * log(1.0 + vb) * log(1.0 + w7) * my_sign(-imag(w7inv)) * T(1.0, 1.0 - vb, 1.0 + w7) + (2.0 * 1.0i) * M_PI * log((1.0 - w7) / 2.0) * log(1.0 + w7) * my_sign(-imag(w7)) * T(1.0, 1.0 - vb, 1.0 + w7) + dilog((1.0 + w7) / 2.0) * (2.0 * log(w7 / (1.0 + w7)) - log((-tb + w7) / (1.0 + w7)) - log((vb + w7) / (1.0 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7)) * T(1.0, 1.0 + tb, 1.0 + w7) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7)) * T(1.0, 1.0 - vb, 1.0 + w7)) + 1.0i * M_PI * power_of<2>(log((vb + w7) / w7)) * my_sign(-imag(vb / w7)) * T(1.0, 1.0 - vb, (vb + w7) / w7) - (2.0 * 1.0i) * M_PI * log(1.0 - vb) * log((1.0 - w7) / 2.0) * my_sign(2.0 * imag(1.0 / (1.0 - vb))) * T(1.0, (1.0 + vb) / 2.0, (1.0 - w7) / 2.0)
                + 1.0i * M_PI * power_of<2>(log((1.0 - w7) / 2.0)) * my_sign(imag(w7) / 2.0) * T(1.0, (1.0 + vb) / 2.0, (1.0 - w7) / 2.0) - 1.0i * M_PI * power_of<2>(log((vb + w7) / (1.0 + w7))) * my_sign(imag((1.0 - vb) / (1.0 + w7))) * T(1.0, (1.0 + vb) / 2.0, (vb + w7) / (1.0 + w7)) + (2.0 * 1.0i) * M_PI * log(1.0 + vb) * log(1.0 - w4) * my_sign(-imag(1.0 / vb)) * T(1.0, 1.0 + vb, 1.0 - w4) + 1.0i * M_PI * power_of<2>(log(1.0 - w4)) * my_sign(imag(w4)) * T(1.0, 1.0 + vb, 1.0 - w4) + (2.0 * 1.0i) * M_PI * log(1.0 + vb) * log(1.0 + w5) * my_sign(-imag(1.0 / vb)) * T(1.0, 1.0 + vb, 1.0 + w5) + 1.0i * M_PI * power_of<2>(log(1.0 + w5)) * my_sign(-imag(w5)) * T(1.0, 1.0 + vb, 1.0 + w5)
                - (2.0 * 1.0i) * M_PI * log(1.0 + vb) * log(1.0 - w7) * my_sign(-imag(1.0 / vb)) * T(1.0, 1.0 + vb, 1.0 - w7) + (2.0 * 1.0i) * M_PI * log(1.0 - vb) * log(1.0 - w7) * my_sign(imag(w7inv)) * T(1.0, 1.0 + vb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - w7)) * my_sign(imag(w7)) * T(1.0, 1.0 + vb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * log(1.0 - w7) * log((1.0 + w7) / 2.0) * my_sign(imag(w7)) * T(1.0, 1.0 + vb, 1.0 - w7) + dilog((1.0 - w7) / 2.0) * (-2.0 * log(w7 / (-1.0 + w7)) + log((-tb + w7) / (-1.0 + w7)) + log((vb + w7) / (-1.0 + w7)) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7)) * T(1.0, 1.0 - tb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7)) * T(1.0, 1.0 + vb, 1.0 - w7))
                + 1.0i * M_PI * power_of<2>(log((vb + w7) / w7)) * my_sign(-imag(vb / w7)) * T(1.0, 1.0 + vb, (vb + w7) / w7) + 1.0i * M_PI * power_of<2>(log(1.0 - tb)) * my_sign(imag(tb)) * T(1.0, 1.0 - tb / w4, 1.0 - tb) - 1.0i * M_PI * power_of<2>(log(1.0 + tb)) * my_sign(-imag(tb)) * T(1.0, 1.0 - tb / w4, 1.0 + tb) + 1.0i * M_PI * power_of<2>(log(1.0 + w4inv)) * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w4inv) * log((-1.0 + tb) / (-1.0 + w4)) * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * log(1.0 + w4inv) * log((tb - w7) / (w4 - w7)) * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv)
                - 1.0i * M_PI * power_of<2>(log((-1.0 + w4) / w4)) * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * log((-1.0 + w4) / w4) * log((1.0 + tb) / (1.0 + w4)) * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * log((-1.0 + w4) / w4) * log((tb - w7) / (w4 - w7)) * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - 1.0i * M_PI * power_of<2>(log(1.0 - tb / w7)) * my_sign(imag(tb / w7)) * T(1.0, 1.0 - tb / w4, 1.0 - tb / w7) - (2.0 * 1.0i) * M_PI * log((-1.0 + tb) / (-1.0 + w4)) * log(1.0 - w7 / w4) * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4)
                + (2.0 * 1.0i) * M_PI * log((1.0 + tb) / (1.0 + w4)) * log(1.0 - w7 / w4) * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) + 1.0i * M_PI * power_of<2>(log(1.0 - w7 / w4)) * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) + (2.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w4))) * my_sign(imag((1.0 + w4) / (-1.0 + w4))) * T(1.0, 1.0 / (1.0 - w4), -2.0 / (-1.0 + w4)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 + w4))) * my_sign(-imag(w4 / (1.0 + w4))) * T(1.0, 1.0 / (1.0 - w4), 1.0 / (1.0 + w4)) + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w7) / (-1.0 + w4))) * my_sign(imag((w4 - w7) / (-1.0 + w4))) * T(1.0, 1.0 / (1.0 - w4), (-1.0 + w7) / (-1.0 + w4))
                + 1.0i * M_PI * power_of<2>(log(-(w7 / (w4 - w7)))) * my_sign(-imag(w4 / (w4 - w7))) * T(1.0, 1.0 / (1.0 - w4), -(w7 / (w4 - w7))) + 1.0i * M_PI * power_of<2>(log(w7 / (-w4 + w7))) * my_sign(imag(w4 / (-w4 + w7))) * T(1.0, 1.0 / (1.0 - w4), w7 / (-w4 + w7)) - 1.0i * M_PI * power_of<2>(log(-2.0 / (-1.0 + w4))) * my_sign(imag((1.0 + w4) / (-1.0 + w4))) * T(1.0, (1.0 + vb) / (1.0 - w4), -2.0 / (-1.0 + w4)) + (2.0 * 1.0i) * M_PI * log(-2.0 / (-1.0 + w4)) * log((vb + w4) / w4) * my_sign(imag((-1.0 + w4) / (vb + w4))) * T(1.0, (1.0 + vb) / (1.0 - w4), -2.0 / (-1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((1.0 - vb) / (1.0 + w4))) * my_sign(imag((vb + w4) / (1.0 + w4))) * T(1.0, (1.0 + vb) / (1.0 - w4), (1.0 - vb) / (1.0 + w4))
                + (2.0 * 1.0i) * M_PI * log((vb + w4) / w4) * log((-1.0 + w7) / (-1.0 + w4)) * my_sign(imag((-1.0 + w4) / (vb + w4))) * T(1.0, (1.0 + vb) / (1.0 - w4), (-1.0 + w7) / (-1.0 + w4)) - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-1.0 + w4))) * my_sign(imag((w4 - w7) / (-1.0 + w4))) * T(1.0, (1.0 + vb) / (1.0 - w4), (-1.0 + w7) / (-1.0 + w4)) + 1.0i * M_PI * power_of<2>(log(-((vb + w7) / (w4 - w7)))) * my_sign(imag((vb + w4) / (w4 - w7))) * T(1.0, (1.0 + vb) / (1.0 - w4), -((vb + w7) / (w4 - w7))) - 1.0i * M_PI * power_of<2>(log(-2.0 / (-1.0 + w4))) * my_sign(imag((1.0 + w4) / (-1.0 + w4))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), -2.0 / (-1.0 + w4))
                + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log(-2.0 / (-1.0 + w4)) * my_sign(imag((-1.0 + w4) / (-tb + w4))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), -2.0 / (-1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((1.0 + tb) / (1.0 + w4))) * my_sign(imag((-tb + w4) / (1.0 + w4))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), (1.0 + tb) / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((tb - w7) / (w4 - w7))) * my_sign(imag((-tb + w4) / (w4 - w7))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), (tb - w7) / (w4 - w7)) + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log((-1.0 + w7) / (-1.0 + w4)) * my_sign(imag((-1.0 + w4) / (-tb + w4))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), (-1.0 + w7) / (-1.0 + w4))
                - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-1.0 + w4))) * my_sign(imag((w4 - w7) / (-1.0 + w4))) * T(1.0, (-1.0 + tb) / (-1.0 + w4), (-1.0 + w7) / (-1.0 + w4)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 - w4))) * my_sign(imag(w4 / (1.0 - w4))) * T(1.0, 1.0 / (1.0 + w4), 1.0 / (1.0 - w4)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(2.0 / (1.0 + w4))) * my_sign(imag((-1.0 + w4) / (1.0 + w4))) * T(1.0, 1.0 / (1.0 + w4), 2.0 / (1.0 + w4)) - 1.0i * M_PI * power_of<2>(log(-(w7 / (w4 - w7)))) * my_sign(-imag(w4 / (w4 - w7))) * T(1.0, 1.0 / (1.0 + w4), -(w7 / (w4 - w7))) - (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w7) / (1.0 + w4))) * my_sign(imag((w4 - w7) / (1.0 + w4))) * T(1.0, 1.0 / (1.0 + w4), (1.0 + w7) / (1.0 + w4))
                - 1.0i * M_PI * power_of<2>(log(w7 / (-w4 + w7))) * my_sign(imag(w4 / (-w4 + w7))) * T(1.0, 1.0 / (1.0 + w4), w7 / (-w4 + w7)) + 1.0i * M_PI * power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * my_sign(imag((-tb + w4) / (-1.0 + w4))) * T(1.0, (1.0 + tb) / (1.0 + w4), (-1.0 + tb) / (-1.0 + w4)) - 1.0i * M_PI * power_of<2>(log(2.0 / (1.0 + w4))) * my_sign(imag((-1.0 + w4) / (1.0 + w4))) * T(1.0, (1.0 + tb) / (1.0 + w4), 2.0 / (1.0 + w4)) + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log(2.0 / (1.0 + w4)) * my_sign(imag((1.0 + w4) / (-tb + w4))) * T(1.0, (1.0 + tb) / (1.0 + w4), 2.0 / (1.0 + w4)) - 1.0i * M_PI * power_of<2>(log((tb - w7) / (w4 - w7))) * my_sign(imag((-tb + w4) / (w4 - w7))) * T(1.0, (1.0 + tb) / (1.0 + w4), (tb - w7) / (w4 - w7))
                - (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log((1.0 + w7) / (1.0 + w4)) * my_sign(imag((1.0 + w4) / (-tb + w4))) * T(1.0, (1.0 + tb) / (1.0 + w4), (1.0 + w7) / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (1.0 + w4))) * my_sign(imag((w4 - w7) / (1.0 + w4))) * T(1.0, (1.0 + tb) / (1.0 + w4), (1.0 + w7) / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((1.0 + vb) / (1.0 - w4))) * my_sign(imag((vb + w4) / (-1.0 + w4))) * T(1.0, (1.0 - vb) / (1.0 + w4), (1.0 + vb) / (1.0 - w4)) - 1.0i * M_PI * power_of<2>(log(2.0 / (1.0 + w4))) * my_sign(imag((-1.0 + w4) / (1.0 + w4))) * T(1.0, (1.0 - vb) / (1.0 + w4), 2.0 / (1.0 + w4))
                + (2.0 * 1.0i) * M_PI * log(2.0 / (1.0 + w4)) * log((vb + w4) / w4) * my_sign(imag((1.0 + w4) / (vb + w4))) * T(1.0, (1.0 - vb) / (1.0 + w4), 2.0 / (1.0 + w4)) - (2.0 * 1.0i) * M_PI * log((vb + w4) / w4) * log((1.0 + w7) / (1.0 + w4)) * my_sign(imag((1.0 + w4) / (vb + w4))) * T(1.0, (1.0 - vb) / (1.0 + w4), (1.0 + w7) / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (1.0 + w4))) * my_sign(imag((w4 - w7) / (1.0 + w4))) * T(1.0, (1.0 - vb) / (1.0 + w4), (1.0 + w7) / (1.0 + w4)) - 1.0i * M_PI * power_of<2>(log(-((vb + w7) / (w4 - w7)))) * my_sign(imag((vb + w4) / (w4 - w7))) * T(1.0, (1.0 - vb) / (1.0 + w4), -((vb + w7) / (w4 - w7)))
                - 1.0i * M_PI * power_of<2>(log(1.0 - vb)) * my_sign(imag(vb)) * T(1.0, (vb + w4) / w4, 1.0 - vb) + 1.0i * M_PI * power_of<2>(log(1.0 + vb)) * my_sign(-imag(vb)) * T(1.0, (vb + w4) / w4, 1.0 + vb) + 1.0i * M_PI * power_of<2>(log(1.0 + w4inv)) * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w4inv) * log((1.0 + vb) / (1.0 - w4)) * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * log(1.0 + w4inv) * log(-((vb + w7) / (w4 - w7))) * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv)
                + dilog((1.0 + w4) / (-1.0 + w4)) * (-2.0 * log(1.0 / (1.0 + w4)) + log((1.0 + tb) / (1.0 + w4)) + log((1.0 - vb) / (1.0 + w4)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv)) + dilog((1.0 + w4) / (w4 - w7)) * (2.0 * log(1.0 / (1.0 + w4)) - log((1.0 + tb) / (1.0 + w4)) - log((1.0 - vb) / (1.0 + w4)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv))
                - 1.0i * M_PI * power_of<2>(log((-1.0 + w4) / w4)) * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * log((-1.0 + w4) / w4) * log((1.0 - vb) / (1.0 + w4)) * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * log((-1.0 + w4) / w4) * log(-((vb + w7) / (w4 - w7))) * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4)
                + dilog((-1.0 + w4) / (1.0 + w4)) * (-2.0 * log(1.0 / (1.0 - w4)) + log((1.0 + vb) / (1.0 - w4)) + log((-1.0 + tb) / (-1.0 + w4)) - (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4)) + dilog((-1.0 + w4) / (w4 - w7)) * (-2.0 * log(1.0 / (1.0 - w4)) + log((1.0 + vb) / (1.0 - w4)) + log((-1.0 + tb) / (-1.0 + w4)) - (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4))
                + dilog(w4 / (w4 - w7)) * (2.0 * log(1.0 / (1.0 - w4)) - log((1.0 + vb) / (1.0 - w4)) - log((-1.0 + tb) / (-1.0 + w4)) - 2.0 * log(1.0 / (1.0 + w4)) + log((1.0 + tb) / (1.0 + w4)) + log((1.0 - vb) / (1.0 + w4)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4)) - 1.0i * M_PI * power_of<2>(log((vb + w7) / w7)) * my_sign(-imag(vb / w7)) * T(1.0, (vb + w4) / w4, (vb + w7) / w7)
                - (2.0 * 1.0i) * M_PI * log((1.0 + vb) / (1.0 - w4)) * log(1.0 - w7 / w4) * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4) + (2.0 * 1.0i) * M_PI * log((1.0 - vb) / (1.0 + w4)) * log(1.0 - w7 / w4) * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4) + 1.0i * M_PI * power_of<2>(log(1.0 - w7 / w4)) * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4) + dilog((w4 - w7) / (-1.0 + w4)) * (log((tb - w7) / (w4 - w7)) - log(-(w7 / (w4 - w7))) + log(-((vb + w7) / (w4 - w7))) - log(w7 / (-w4 + w7)) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4))
                + dilog(w4 / (1.0 + w4)) * (2.0 * log(1.0 / (1.0 - w4)) - log((1.0 + vb) / (1.0 - w4)) - log((-1.0 + tb) / (-1.0 + w4)) + log((tb - w7) / (w4 - w7)) - log(-(w7 / (w4 - w7))) + log(-((vb + w7) / (w4 - w7))) - log(w7 / (-w4 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) + (2.0 * 1.0i) * M_PI * my_sign(imag(w4inv)) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4) - (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4))
                + dilog((w4 - w7) / (1.0 + w4)) * (-log((tb - w7) / (w4 - w7)) + log(-(w7 / (w4 - w7))) - log(-((vb + w7) / (w4 - w7))) + log(w7 / (-w4 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) + (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4)) + dilog(w4 / (-1.0 + w4)) * (2.0 * log(1.0 / (1.0 + w4)) - log((1.0 + tb) / (1.0 + w4)) - log((1.0 - vb) / (1.0 + w4)) - log((tb - w7) / (w4 - w7)) + log(-(w7 / (w4 - w7))) - log(-((vb + w7) / (w4 - w7))) + log(w7 / (-w4 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv)
                    + (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w4inv)) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) + (2.0 * 1.0i) * M_PI * my_sign(imag(w7 / w4)) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4)) - 1.0i * M_PI * power_of<2>(log(1.0 - vb)) * my_sign(imag(vb)) * T(1.0, 1.0 - vb / w5, 1.0 - vb) + 1.0i * M_PI * power_of<2>(log(1.0 + vb)) * my_sign(-imag(vb)) * T(1.0, 1.0 - vb / w5, 1.0 + vb) - 1.0i * M_PI * power_of<2>(log(1.0 + w5inv)) * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w5inv) * log((-1.0 + vb) / (-1.0 + w5)) * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv)
                - (2.0 * 1.0i) * M_PI * log(1.0 + w5inv) * log((vb + w7) / (w5 + w7)) * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) + 1.0i * M_PI * power_of<2>(log((-1.0 + w5) / w5)) * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) - (2.0 * 1.0i) * M_PI * log((-1.0 + w5) / w5) * log((1.0 + vb) / (1.0 + w5)) * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * log((-1.0 + w5) / w5) * log((vb + w7) / (w5 + w7)) * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) - 1.0i * M_PI * power_of<2>(log((vb + w7) / w7)) * my_sign(-imag(vb / w7)) * T(1.0, 1.0 - vb / w5, (vb + w7) / w7)
                + (2.0 * 1.0i) * M_PI * log((-1.0 + vb) / (-1.0 + w5)) * log((w5 + w7) / w5) * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) - (2.0 * 1.0i) * M_PI * log((1.0 + vb) / (1.0 + w5)) * log((w5 + w7) / w5) * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) + 1.0i * M_PI * power_of<2>(log((w5 + w7) / w5)) * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) + (2.0 * 1.0i) * M_PI * power_of<2>(log(-2.0 / (-1.0 + w5))) * my_sign(imag((1.0 + w5) / (-1.0 + w5))) * T(1.0, 1.0 / (1.0 - w5), -2.0 / (-1.0 + w5)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 + w5))) * my_sign(-imag(w5 / (1.0 + w5))) * T(1.0, 1.0 / (1.0 - w5), 1.0 / (1.0 + w5))
                - (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w7) / (1.0 - w5))) * my_sign(imag((w5 + w7) / (-1.0 + w5))) * T(1.0, 1.0 / (1.0 - w5), (1.0 + w7) / (1.0 - w5)) - (2.0 * 1.0i) * M_PI * power_of<2>(log(w7 / (w5 + w7))) * my_sign(-imag(w5 / (w5 + w7))) * T(1.0, 1.0 / (1.0 - w5), w7 / (w5 + w7)) - 1.0i * M_PI * power_of<2>(log(-2.0 / (-1.0 + w5))) * my_sign(imag((1.0 + w5) / (-1.0 + w5))) * T(1.0, (1.0 + tb) / (1.0 - w5), -2.0 / (-1.0 + w5)) + (2.0 * 1.0i) * M_PI * log(-2.0 / (-1.0 + w5)) * log((tb + w5) / w5) * my_sign(imag((-1.0 + w5) / (tb + w5))) * T(1.0, (1.0 + tb) / (1.0 - w5), -2.0 / (-1.0 + w5)) + 1.0i * M_PI * power_of<2>(log((1.0 - tb) / (1.0 + w5))) * my_sign(imag((tb + w5) / (1.0 + w5))) * T(1.0, (1.0 + tb) / (1.0 - w5), (1.0 - tb) / (1.0 + w5))
                - (2.0 * 1.0i) * M_PI * log((tb + w5) / w5) * log((1.0 + w7) / (1.0 - w5)) * my_sign(imag((-1.0 + w5) / (tb + w5))) * T(1.0, (1.0 + tb) / (1.0 - w5), (1.0 + w7) / (1.0 - w5)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (1.0 - w5))) * my_sign(imag((w5 + w7) / (-1.0 + w5))) * T(1.0, (1.0 + tb) / (1.0 - w5), (1.0 + w7) / (1.0 - w5)) - 1.0i * M_PI * power_of<2>(log((-tb + w7) / (w5 + w7))) * my_sign(imag((tb + w5) / (w5 + w7))) * T(1.0, (1.0 + tb) / (1.0 - w5), (-tb + w7) / (w5 + w7)) - 1.0i * M_PI * power_of<2>(log(-2.0 / (-1.0 + w5))) * my_sign(imag((1.0 + w5) / (-1.0 + w5))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), -2.0 / (-1.0 + w5))
                + (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log(-2.0 / (-1.0 + w5)) * my_sign(imag((-1.0 + w5) / (-vb + w5))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), -2.0 / (-1.0 + w5)) + 1.0i * M_PI * power_of<2>(log((1.0 + vb) / (1.0 + w5))) * my_sign(imag((-vb + w5) / (1.0 + w5))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), (1.0 + vb) / (1.0 + w5)) - (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log((1.0 + w7) / (1.0 - w5)) * my_sign(imag((-1.0 + w5) / (-vb + w5))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), (1.0 + w7) / (1.0 - w5)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (1.0 - w5))) * my_sign(imag((w5 + w7) / (-1.0 + w5))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), (1.0 + w7) / (1.0 - w5))
                - 1.0i * M_PI * power_of<2>(log((vb + w7) / (w5 + w7))) * my_sign(imag((-vb + w5) / (w5 + w7))) * T(1.0, (-1.0 + vb) / (-1.0 + w5), (vb + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 - w5))) * my_sign(imag(w5 / (1.0 - w5))) * T(1.0, 1.0 / (1.0 + w5), 1.0 / (1.0 - w5)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(2.0 / (1.0 + w5))) * my_sign(imag((-1.0 + w5) / (1.0 + w5))) * T(1.0, 1.0 / (1.0 + w5), 2.0 / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 - w7) / (1.0 + w5))) * my_sign(imag((w5 + w7) / (1.0 + w5))) * T(1.0, 1.0 / (1.0 + w5), (1.0 - w7) / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(w7 / (w5 + w7))) * my_sign(-imag(w5 / (w5 + w7))) * T(1.0, 1.0 / (1.0 + w5), w7 / (w5 + w7))
                + 1.0i * M_PI * power_of<2>(log((1.0 + tb) / (1.0 - w5))) * my_sign(imag((tb + w5) / (-1.0 + w5))) * T(1.0, (1.0 - tb) / (1.0 + w5), (1.0 + tb) / (1.0 - w5)) - 1.0i * M_PI * power_of<2>(log(2.0 / (1.0 + w5))) * my_sign(imag((-1.0 + w5) / (1.0 + w5))) * T(1.0, (1.0 - tb) / (1.0 + w5), 2.0 / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * log(2.0 / (1.0 + w5)) * log((tb + w5) / w5) * my_sign(imag((1.0 + w5) / (tb + w5))) * T(1.0, (1.0 - tb) / (1.0 + w5), 2.0 / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * log((tb + w5) / w5) * log((1.0 - w7) / (1.0 + w5)) * my_sign(imag((1.0 + w5) / (tb + w5))) * T(1.0, (1.0 - tb) / (1.0 + w5), (1.0 - w7) / (1.0 + w5))
                - 1.0i * M_PI * power_of<2>(log((1.0 - w7) / (1.0 + w5))) * my_sign(imag((w5 + w7) / (1.0 + w5))) * T(1.0, (1.0 - tb) / (1.0 + w5), (1.0 - w7) / (1.0 + w5)) + 1.0i * M_PI * power_of<2>(log((-tb + w7) / (w5 + w7))) * my_sign(imag((tb + w5) / (w5 + w7))) * T(1.0, (1.0 - tb) / (1.0 + w5), (-tb + w7) / (w5 + w7)) + 1.0i * M_PI * power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * my_sign(imag((-vb + w5) / (-1.0 + w5))) * T(1.0, (1.0 + vb) / (1.0 + w5), (-1.0 + vb) / (-1.0 + w5)) - 1.0i * M_PI * power_of<2>(log(2.0 / (1.0 + w5))) * my_sign(imag((-1.0 + w5) / (1.0 + w5))) * T(1.0, (1.0 + vb) / (1.0 + w5), 2.0 / (1.0 + w5))
                + (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log(2.0 / (1.0 + w5)) * my_sign(imag((1.0 + w5) / (-vb + w5))) * T(1.0, (1.0 + vb) / (1.0 + w5), 2.0 / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log((1.0 - w7) / (1.0 + w5)) * my_sign(imag((1.0 + w5) / (-vb + w5))) * T(1.0, (1.0 + vb) / (1.0 + w5), (1.0 - w7) / (1.0 + w5)) - 1.0i * M_PI * power_of<2>(log((1.0 - w7) / (1.0 + w5))) * my_sign(imag((w5 + w7) / (1.0 + w5))) * T(1.0, (1.0 + vb) / (1.0 + w5), (1.0 - w7) / (1.0 + w5)) + 1.0i * M_PI * power_of<2>(log((vb + w7) / (w5 + w7))) * my_sign(imag((-vb + w5) / (w5 + w7))) * T(1.0, (1.0 + vb) / (1.0 + w5), (vb + w7) / (w5 + w7)) + 1.0i * M_PI * power_of<2>(log(1.0 - tb)) * my_sign(imag(tb)) * T(1.0, (tb + w5) / w5, 1.0 - tb)
                - 1.0i * M_PI * power_of<2>(log(1.0 + tb)) * my_sign(-imag(tb)) * T(1.0, (tb + w5) / w5, 1.0 + tb) - 1.0i * M_PI * power_of<2>(log(1.0 + w5inv)) * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w5inv) * log((1.0 + tb) / (1.0 - w5)) * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w5inv) * log((-tb + w7) / (w5 + w7)) * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv)
                + dilog((1.0 + w5) / (-1.0 + w5)) * (-2.0 * log(1.0 / (1.0 + w5)) + log((1.0 - tb) / (1.0 + w5)) + log((1.0 + vb) / (1.0 + w5)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv)) + dilog((1.0 + w5) / (w5 + w7)) * (-2.0 * log(1.0 / (1.0 + w5)) + log((1.0 - tb) / (1.0 + w5)) + log((1.0 + vb) / (1.0 + w5)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv))
                + 1.0i * M_PI * power_of<2>(log((-1.0 + w5) / w5)) * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5) - (2.0 * 1.0i) * M_PI * log((-1.0 + w5) / w5) * log((1.0 - tb) / (1.0 + w5)) * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * log((-1.0 + w5) / w5) * log((-tb + w7) / (w5 + w7)) * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5)
                + dilog((-1.0 + w5) / (1.0 + w5)) * (-2.0 * log(1.0 / (1.0 - w5)) + log((1.0 + tb) / (1.0 - w5)) + log((-1.0 + vb) / (-1.0 + w5)) - (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) - (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5)) + dilog(w5 / (w5 + w7)) * (-2.0 * log(1.0 / (1.0 - w5)) + log((1.0 + tb) / (1.0 - w5)) + log((-1.0 + vb) / (-1.0 + w5)) + 2.0 * log(1.0 / (1.0 + w5)) - log((1.0 - tb) / (1.0 + w5)) - log((1.0 + vb) / (1.0 + w5)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv)
                    - (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5)) + dilog((-1.0 + w5) / (w5 + w7)) * (2.0 * log(1.0 / (1.0 - w5)) - log((1.0 + tb) / (1.0 - w5)) - log((-1.0 + vb) / (-1.0 + w5)) + (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5)) - 1.0i * M_PI * power_of<2>(log(1.0 - tb / w7)) * my_sign(imag(tb / w7)) * T(1.0, (tb + w5) / w5, 1.0 - tb / w7)
                + (2.0 * 1.0i) * M_PI * log((1.0 + tb) / (1.0 - w5)) * log((w5 + w7) / w5) * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5) - (2.0 * 1.0i) * M_PI * log((1.0 - tb) / (1.0 + w5)) * log((w5 + w7) / w5) * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5) + 1.0i * M_PI * power_of<2>(log((w5 + w7) / w5)) * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5)
                + dilog((w5 + w7) / (1.0 + w5)) * (-2.0 * log(w7 / (w5 + w7)) + log((-tb + w7) / (w5 + w7)) + log((vb + w7) / (w5 + w7)) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5)) + dilog(w5 / (-1.0 + w5)) * (2.0 * log(1.0 / (1.0 + w5)) - log((1.0 - tb) / (1.0 + w5)) - log((1.0 + vb) / (1.0 + w5)) - 2.0 * log(w7 / (w5 + w7)) + log((-tb + w7) / (w5 + w7)) + log((vb + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv)
                    - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w5inv)) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5)) + dilog((w5 + w7) / (-1.0 + w5)) * (2.0 * log(w7 / (w5 + w7)) - log((-tb + w7) / (w5 + w7)) - log((vb + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5))
                + dilog(w5 / (1.0 + w5)) * (2.0 * log(1.0 / (1.0 - w5)) - log((1.0 + tb) / (1.0 - w5)) - log((-1.0 + vb) / (-1.0 + w5)) + 2.0 * log(w7 / (w5 + w7)) - log((-tb + w7) / (w5 + w7)) - log((vb + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) + (2.0 * 1.0i) * M_PI * my_sign(imag(w5inv)) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5) + (2.0 * 1.0i) * M_PI * my_sign(-imag(w7 / w5)) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5)) - 1.0i * M_PI * power_of<2>(log(1.0 + w7inv)) * my_sign(-imag(w7inv)) * T(1.0, 1.0 - tb / w7, 1.0 + w7inv)
                - (2.0 * 1.0i) * M_PI * log(1.0 + w7inv) * log(1.0 - tb / w7) * my_sign(imag(w7 / tb)) * T(1.0, 1.0 - tb / w7, 1.0 + w7inv) + 1.0i * M_PI * power_of<2>(log(1.0 - w4 / w7)) * my_sign(imag(w4 / w7)) * T(1.0, 1.0 - tb / w7, 1.0 - w4 / w7) + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w7) * log(1.0 - w4 / w7) * my_sign(imag(w7 / tb)) * T(1.0, 1.0 - tb / w7, 1.0 - w4 / w7) - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / w7)) * my_sign(imag(w7inv)) * T(1.0, 1.0 - tb / w7, (-1.0 + w7) / w7) - (2.0 * 1.0i) * M_PI * log(1.0 - tb / w7) * log((-1.0 + w7) / w7) * my_sign(imag(w7 / tb)) * T(1.0, 1.0 - tb / w7, (-1.0 + w7) / w7) + 1.0i * M_PI * power_of<2>(log((w5 + w7) / w7)) * my_sign(-imag(w5 / w7)) * T(1.0, 1.0 - tb / w7, (w5 + w7) / w7)
                + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w7) * log((w5 + w7) / w7) * my_sign(imag(w7 / tb)) * T(1.0, 1.0 - tb / w7, (w5 + w7) / w7) + 1.0i * M_PI * power_of<2>(log((-1.0 + tb) / (-1.0 + w4))) * my_sign(imag((-tb + w4) / (-1.0 + w4))) * T(1.0, (tb - w7) / (w4 - w7), (-1.0 + tb) / (-1.0 + w4)) - 1.0i * M_PI * power_of<2>(log((1.0 + tb) / (1.0 + w4))) * my_sign(imag((-tb + w4) / (1.0 + w4))) * T(1.0, (tb - w7) / (w4 - w7), (1.0 + tb) / (1.0 + w4)) - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-w4 + w7))) * my_sign(imag((-1.0 + w4) / (w4 - w7))) * T(1.0, (tb - w7) / (w4 - w7), (-1.0 + w7) / (-w4 + w7))
                + (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log((-1.0 + w7) / (-w4 + w7)) * my_sign(imag((-w4 + w7) / (tb - w4))) * T(1.0, (tb - w7) / (w4 - w7), (-1.0 + w7) / (-w4 + w7)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (-w4 + w7))) * my_sign(imag((1.0 + w4) / (w4 - w7))) * T(1.0, (tb - w7) / (w4 - w7), (1.0 + w7) / (-w4 + w7)) - (2.0 * 1.0i) * M_PI * log(1.0 - tb / w4) * log((1.0 + w7) / (-w4 + w7)) * my_sign(imag((-w4 + w7) / (tb - w4))) * T(1.0, (tb - w7) / (w4 - w7), (1.0 + w7) / (-w4 + w7)) + 1.0i * M_PI * power_of<2>(log(1.0 / (1.0 - w4))) * my_sign(imag(w4 / (1.0 - w4))) * T(1.0, -(w7 / (w4 - w7)), 1.0 / (1.0 - w4))
                - 1.0i * M_PI * power_of<2>(log(1.0 / (1.0 + w4))) * my_sign(-imag(w4 / (1.0 + w4))) * T(1.0, -(w7 / (w4 - w7)), 1.0 / (1.0 + w4)) - 1.0i * M_PI * power_of<2>(log(-((1.0 + w7) / (w4 - w7)))) * my_sign(imag((1.0 + w4) / (w4 - w7))) * T(1.0, -(w7 / (w4 - w7)), -((1.0 + w7) / (w4 - w7))) + 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-w4 + w7))) * my_sign(imag((-1.0 + w4) / (w4 - w7))) * T(1.0, -(w7 / (w4 - w7)), (-1.0 + w7) / (-w4 + w7)) + 1.0i * M_PI * power_of<2>(log((1.0 + vb) / (1.0 - w4))) * my_sign(imag((vb + w4) / (-1.0 + w4))) * T(1.0, -((vb + w7) / (w4 - w7)), (1.0 + vb) / (1.0 - w4))
                - 1.0i * M_PI * power_of<2>(log((1.0 - vb) / (1.0 + w4))) * my_sign(imag((vb + w4) / (1.0 + w4))) * T(1.0, -((vb + w7) / (w4 - w7)), (1.0 - vb) / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log(-((1.0 + w7) / (w4 - w7)))) * my_sign(imag((1.0 + w4) / (w4 - w7))) * T(1.0, -((vb + w7) / (w4 - w7)), -((1.0 + w7) / (w4 - w7))) - (2.0 * 1.0i) * M_PI * log((vb + w4) / w4) * log(-((1.0 + w7) / (w4 - w7))) * my_sign(imag((w4 - w7) / (vb + w4))) * T(1.0, -((vb + w7) / (w4 - w7)), -((1.0 + w7) / (w4 - w7))) - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-w4 + w7))) * my_sign(imag((-1.0 + w4) / (w4 - w7))) * T(1.0, -((vb + w7) / (w4 - w7)), (-1.0 + w7) / (-w4 + w7))
                + (2.0 * 1.0i) * M_PI * log((vb + w4) / w4) * log((-1.0 + w7) / (-w4 + w7)) * my_sign(imag((w4 - w7) / (vb + w4))) * T(1.0, -((vb + w7) / (w4 - w7)), (-1.0 + w7) / (-w4 + w7)) - 1.0i * M_PI * power_of<2>(log(1.0 + w7inv)) * my_sign(-imag(w7inv)) * T(1.0, (vb + w7) / w7, 1.0 + w7inv) - (2.0 * 1.0i) * M_PI * log(1.0 + w7inv) * log((vb + w7) / w7) * my_sign(-imag(w7 / vb)) * T(1.0, (vb + w7) / w7, 1.0 + w7inv) + 1.0i * M_PI * power_of<2>(log(1.0 - w4 / w7)) * my_sign(imag(w4 / w7)) * T(1.0, (vb + w7) / w7, 1.0 - w4 / w7) + (2.0 * 1.0i) * M_PI * log(1.0 - w4 / w7) * log((vb + w7) / w7) * my_sign(-imag(w7 / vb)) * T(1.0, (vb + w7) / w7, 1.0 - w4 / w7)
                - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / w7)) * my_sign(imag(w7inv)) * T(1.0, (vb + w7) / w7, (-1.0 + w7) / w7) - (2.0 * 1.0i) * M_PI * log((-1.0 + w7) / w7) * log((vb + w7) / w7) * my_sign(-imag(w7 / vb)) * T(1.0, (vb + w7) / w7, (-1.0 + w7) / w7) + 1.0i * M_PI * power_of<2>(log((w5 + w7) / w7)) * my_sign(-imag(w5 / w7)) * T(1.0, (vb + w7) / w7, (w5 + w7) / w7) + (2.0 * 1.0i) * M_PI * log((vb + w7) / w7) * log((w5 + w7) / w7) * my_sign(-imag(w7 / vb)) * T(1.0, (vb + w7) / w7, (w5 + w7) / w7) + 1.0i * M_PI * power_of<2>(log(1.0 / (1.0 - w4))) * my_sign(imag(w4 / (1.0 - w4))) * T(1.0, w7 / (-w4 + w7), 1.0 / (1.0 - w4))
                - 1.0i * M_PI * power_of<2>(log(1.0 / (1.0 + w4))) * my_sign(-imag(w4 / (1.0 + w4))) * T(1.0, w7 / (-w4 + w7), 1.0 / (1.0 + w4)) + 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (-w4 + w7))) * my_sign(imag((-1.0 + w4) / (w4 - w7))) * T(1.0, w7 / (-w4 + w7), (-1.0 + w7) / (-w4 + w7)) - 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (-w4 + w7))) * my_sign(imag((1.0 + w4) / (w4 - w7))) * T(1.0, w7 / (-w4 + w7), (1.0 + w7) / (-w4 + w7)) - (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 - w5))) * my_sign(imag(w5 / (1.0 - w5))) * T(1.0, w7 / (w5 + w7), 1.0 / (1.0 - w5)) + (2.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / (1.0 + w5))) * my_sign(-imag(w5 / (1.0 + w5))) * T(1.0, w7 / (w5 + w7), 1.0 / (1.0 + w5))
                + (2.0 * 1.0i) * M_PI * power_of<2>(log((-1.0 + w7) / (w5 + w7))) * my_sign(imag((1.0 + w5) / (w5 + w7))) * T(1.0, w7 / (w5 + w7), (-1.0 + w7) / (w5 + w7)) - (2.0 * 1.0i) * M_PI * power_of<2>(log((1.0 + w7) / (w5 + w7))) * my_sign(imag((-1.0 + w5) / (w5 + w7))) * T(1.0, w7 / (w5 + w7), (1.0 + w7) / (w5 + w7)) - 1.0i * M_PI * power_of<2>(log((1.0 + tb) / (1.0 - w5))) * my_sign(imag((tb + w5) / (-1.0 + w5))) * T(1.0, (-tb + w7) / (w5 + w7), (1.0 + tb) / (1.0 - w5)) + 1.0i * M_PI * power_of<2>(log((1.0 - tb) / (1.0 + w5))) * my_sign(imag((tb + w5) / (1.0 + w5))) * T(1.0, (-tb + w7) / (w5 + w7), (1.0 - tb) / (1.0 + w5))
                - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (w5 + w7))) * my_sign(imag((1.0 + w5) / (w5 + w7))) * T(1.0, (-tb + w7) / (w5 + w7), (-1.0 + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * log((tb + w5) / w5) * log((-1.0 + w7) / (w5 + w7)) * my_sign(imag((w5 + w7) / (tb + w5))) * T(1.0, (-tb + w7) / (w5 + w7), (-1.0 + w7) / (w5 + w7)) + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (w5 + w7))) * my_sign(imag((-1.0 + w5) / (w5 + w7))) * T(1.0, (-tb + w7) / (w5 + w7), (1.0 + w7) / (w5 + w7)) - (2.0 * 1.0i) * M_PI * log((tb + w5) / w5) * log((1.0 + w7) / (w5 + w7)) * my_sign(imag((w5 + w7) / (tb + w5))) * T(1.0, (-tb + w7) / (w5 + w7), (1.0 + w7) / (w5 + w7))
                - 1.0i * M_PI * power_of<2>(log((-1.0 + vb) / (-1.0 + w5))) * my_sign(imag((-vb + w5) / (-1.0 + w5))) * T(1.0, (vb + w7) / (w5 + w7), (-1.0 + vb) / (-1.0 + w5)) + 1.0i * M_PI * power_of<2>(log((1.0 + vb) / (1.0 + w5))) * my_sign(imag((-vb + w5) / (1.0 + w5))) * T(1.0, (vb + w7) / (w5 + w7), (1.0 + vb) / (1.0 + w5)) - 1.0i * M_PI * power_of<2>(log((-1.0 + w7) / (w5 + w7))) * my_sign(imag((1.0 + w5) / (w5 + w7))) * T(1.0, (vb + w7) / (w5 + w7), (-1.0 + w7) / (w5 + w7)) + (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log((-1.0 + w7) / (w5 + w7)) * my_sign(imag((w5 + w7) / (-vb + w5))) * T(1.0, (vb + w7) / (w5 + w7), (-1.0 + w7) / (w5 + w7))
                + 1.0i * M_PI * power_of<2>(log((1.0 + w7) / (w5 + w7))) * my_sign(imag((-1.0 + w5) / (w5 + w7))) * T(1.0, (vb + w7) / (w5 + w7), (1.0 + w7) / (w5 + w7)) - (2.0 * 1.0i) * M_PI * log(1.0 - vb / w5) * log((1.0 + w7) / (w5 + w7)) * my_sign(imag((w5 + w7) / (-vb + w5))) * T(1.0, (vb + w7) / (w5 + w7), (1.0 + w7) / (w5 + w7)) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx3)) * my_sign(real(wx3) / 2.0) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx3) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx3)) * my_sign((-0.5) * real(wx3)) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx3) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx4)) * my_sign(real(wx4) / 2.0) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx4)
                - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx4)) * my_sign((-0.5) * real(wx4)) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx4) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx3 + xb) / (1.0i + wx3))) * my_sign(imag((1.0i - xb) / (1.0i + wx3))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, (wx3 + xb) / (1.0i + wx3)) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx4 + xb) / (1.0i + wx4))) * my_sign(imag((1.0i - xb) / (1.0i + wx4))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, (wx4 + xb) / (1.0i + wx4)) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx3)) * my_sign(real(wx3) / 2.0) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx3) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx3)) * my_sign((-0.5) * real(wx3)) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx3)
                - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 - (1.0i / 2.0) * wx4)) * my_sign(real(wx4) / 2.0) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx4) - (8.0 * 1.0i) * M_PI * power_of<2>(log(1.0 / 2.0 + (1.0i / 2.0) * wx4)) * my_sign((-0.5) * real(wx4)) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx4) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx3 - xb) / (1.0i + wx3))) * my_sign(imag((1.0i + xb) / (1.0i + wx3))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, (wx3 - xb) / (1.0i + wx3)) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx4 - xb) / (1.0i + wx4))) * my_sign(imag((1.0i + xb) / (1.0i + wx4))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, (wx4 - xb) / (1.0i + wx4)) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx3) * log(1.0 - 1.0i * wx3) * my_sign(real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3)
                - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx3)) * my_sign(real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx3) * log(1.0 + 1.0i * wx3) * my_sign(-real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx3)) * my_sign(-real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx4) * log(1.0 - 1.0i * wx4) * my_sign(real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx4)) * my_sign(real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx4) * log(1.0 + 1.0i * wx4) * my_sign(-real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4)
                - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx4)) * my_sign(-real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx3 + xb) / (-1.0i + wx3))) * my_sign(imag((1.0i + xb) / (1.0i - wx3))) * T(1.0, (1.0 + 1.0i * xb) / 2.0, (wx3 + xb) / (-1.0i + wx3)) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx4 + xb) / (-1.0i + wx4))) * my_sign(imag((1.0i + xb) / (1.0i - wx4))) * T(1.0, (1.0 + 1.0i * xb) / 2.0, (wx4 + xb) / (-1.0i + wx4)) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx3) * log(1.0 - 1.0i * wx3) * my_sign(real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx3)) * my_sign(real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3)
                + dilog(1.0 / 2.0 - (1.0i / 2.0) * wx3) * (-16.0 * log(wx3 / (1.0i + wx3)) + 8.0 * log((wx3 - xb) / (1.0i + wx3)) + 8.0 * log((wx3 + xb) / (1.0i + wx3)) - (16.0 * 1.0i) * M_PI * my_sign(real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3) - (16.0 * 1.0i) * M_PI * my_sign(real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3)) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx3) * log(1.0 + 1.0i * wx3) * my_sign(-real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx3)) * my_sign(-real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3)
                + dilog(1.0 / 2.0 + (1.0i / 2.0) * wx3) * (-16.0 * log(wx3 / (-1.0i + wx3)) + 8.0 * log((wx3 - xb) / (-1.0i + wx3)) + 8.0 * log((wx3 + xb) / (-1.0i + wx3)) - (16.0 * 1.0i) * M_PI * my_sign(-real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) - (16.0 * 1.0i) * M_PI * my_sign(-real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3)) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx4) * log(1.0 - 1.0i * wx4) * my_sign(real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 - 1.0i * wx4)) * my_sign(real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4)
                + dilog(1.0 / 2.0 - (1.0i / 2.0) * wx4) * (-16.0 * log(wx4 / (1.0i + wx4)) + 8.0 * log((wx4 - xb) / (1.0i + wx4)) + 8.0 * log((wx4 + xb) / (1.0i + wx4)) - (16.0 * 1.0i) * M_PI * my_sign(real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) - (16.0 * 1.0i) * M_PI * my_sign(real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4)) - (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx4) * log(1.0 + 1.0i * wx4) * my_sign(-real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4) - (4.0 * 1.0i) * M_PI * power_of<2>(log(1.0 + 1.0i * wx4)) * my_sign(-real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4)
                + log(1.0 - 1.0i * xb) * ((2.0 * pisqu) / 3.0 - 16.0 * (log(xb) - log(1.0i * xb)) * ln2 - 20.0 * ln2squ + 16.0 * ln2 * log((-1.0i) * xb) + log(1.0 + 1.0i * xb) * (32.0 * ln2 - 16.0 * log((-1.0i) * xb) - 16.0 * log(1.0i * xb) - 4.0 * log((wx3 + xb) / (-1.0i + wx3)) - 4.0 * log((wx3 + xb) / (1.0i + wx3)) - 4.0 * log((wx4 + xb) / (-1.0i + wx4)) - 4.0 * log((wx4 + xb) / (1.0i + wx4))) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx3) * my_sign(2.0 * real(1.0 / (1.0i + xb))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx3) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx3) * my_sign(2.0 * real(1.0 / (1.0i + xb))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx3)
                    + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx4) * my_sign(2.0 * real(1.0 / (1.0i + xb))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx4) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx4) * my_sign(2.0 * real(1.0 / (1.0i + xb))) * T(1.0, 1.0 / 2.0 + (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx4) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx3) * my_sign(-real(xbinv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx3) * my_sign(-real(xbinv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx4) * my_sign(-real(xbinv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx4) * my_sign(-real(xbinv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4)
                    - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx3) * my_sign(-real(wx3inv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx3) * my_sign(real(wx3inv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx4) * my_sign(-real(wx4inv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx4) * my_sign(real(wx4inv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4))
                + dilog(1.0 / 2.0 + (1.0i / 2.0) * wx4) * (-16.0 * log(wx4 / (-1.0i + wx4)) + 8.0 * log((wx4 - xb) / (-1.0i + wx4)) + 8.0 * log((wx4 + xb) / (-1.0i + wx4)) - (16.0 * 1.0i) * M_PI * my_sign(-real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4) - (16.0 * 1.0i) * M_PI * my_sign(-real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4)) + li2half * (-16.0 * (log(xb) - log(1.0i * xb)) - 16.0 * log(1.0i) - 2.0 * log(1.0 / (1.0 - w4)) - 2.0 * log(1.0 / (1.0 + w4)) - 2.0 * log(1.0 / (1.0 - w5)) - 2.0 * log(1.0 / (1.0 + w5)) + 2.0 * log(w7 / (-1.0 + w7)) - 2.0 * log(w7 / (1.0 + w7)) - log((-tb + w7) / (-1.0 + w7)) + log((-tb + w7) / (1.0 + w7)) - log((vb + w7) / (-1.0 + w7))
                    + log((vb + w7) / (1.0 + w7)) + 16.0 * log(wx3 / (-1.0i + wx3)) + 16.0 * log(wx3 / (1.0i + wx3)) + 16.0 * log(wx4 / (-1.0i + wx4)) + 16.0 * log(wx4 / (1.0i + wx4)) - 8.0 * log((wx3 - xb) / (-1.0i + wx3)) - 8.0 * log((wx3 - xb) / (1.0i + wx3)) - 8.0 * log((wx4 - xb) / (-1.0i + wx4)) - 8.0 * log((wx4 - xb) / (1.0i + wx4)) - 8.0 * log((wx3 + xb) / (-1.0i + wx3)) - 8.0 * log((wx3 + xb) / (1.0i + wx3)) - 8.0 * log((wx4 + xb) / (-1.0i + wx4)) - 8.0 * log((wx4 + xb) / (1.0i + wx4)) + (2.0 * 1.0i) * M_PI * my_sign(imag(w7)) * T(1.0, 1.0 - tb, 1.0 - w7) - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7)) * T(1.0, 1.0 + tb, 1.0 + w7)
                    - (2.0 * 1.0i) * M_PI * my_sign(-imag(w7)) * T(1.0, 1.0 - vb, 1.0 + w7) + (2.0 * 1.0i) * M_PI * my_sign(imag(w7)) * T(1.0, 1.0 + vb, 1.0 - w7) + (16.0 * 1.0i) * M_PI * my_sign(real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3) + (16.0 * 1.0i) * M_PI * my_sign(-real(wx3)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) + (16.0 * 1.0i) * M_PI * my_sign(real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) + (16.0 * 1.0i) * M_PI * my_sign(-real(wx4)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4) + (16.0 * 1.0i) * M_PI * my_sign(real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3) + (16.0 * 1.0i) * M_PI * my_sign(-real(wx3)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3) + (16.0 * 1.0i) * M_PI * my_sign(real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4) + (16.0 * 1.0i) * M_PI * my_sign(-real(wx4)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4))
                + log(1.0 + 1.0i * xb) * ((2.0 * pisqu) / 3.0 - 16.0 * log(1.0i) * ln2 - 20.0 * ln2squ + 16.0 * ln2 * log(1.0i * xb) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx3) * my_sign(2.0 * real(1.0 / (1.0i - xb))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx3) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx3) * my_sign(2.0 * real(1.0 / (1.0i - xb))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx3) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 - (1.0i / 2.0) * wx4) * my_sign(2.0 * real(1.0 / (1.0i - xb))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 - (1.0i / 2.0) * wx4) + (16.0 * 1.0i) * M_PI * log(1.0 / 2.0 + (1.0i / 2.0) * wx4) * my_sign(2.0 * real(1.0 / (1.0i - xb))) * T(1.0, 1.0 / 2.0 - (1.0i / 2.0) * xb, 1.0 / 2.0 + (1.0i / 2.0) * wx4)
                    - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx3) * my_sign(-real(wx3inv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx3) * my_sign(real(wx3inv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx4) * my_sign(-real(wx4inv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 - 1.0i * wx4) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx4) * my_sign(real(wx4inv)) * T(1.0, 1.0 - 1.0i * xb, 1.0 + 1.0i * wx4) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx3) * my_sign(real(xbinv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx3) * my_sign(real(xbinv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx3) - (8.0 * 1.0i) * M_PI * log(1.0 - 1.0i * wx4) * my_sign(real(xbinv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 - 1.0i * wx4)
                    - (8.0 * 1.0i) * M_PI * log(1.0 + 1.0i * wx4) * my_sign(real(xbinv)) * T(1.0, 1.0 + 1.0i * xb, 1.0 + 1.0i * wx4)) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx3 - xb) / (-1.0i + wx3))) * my_sign(imag((-1.0i + xb) / (-1.0i + wx3))) * T(1.0, ((-0.5) * 1.0i) * (1.0i + xb), (wx3 - xb) / (-1.0i + wx3)) + (8.0 * 1.0i) * M_PI * power_of<2>(log((wx4 - xb) / (-1.0i + wx4))) * my_sign(imag((-1.0i + xb) / (-1.0i + wx4))) * T(1.0, ((-0.5) * 1.0i) * (1.0i + xb), (wx4 - xb) / (-1.0i + wx4)) - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx3) / wx3)) * my_sign(real(wx3inv)) * T(1.0, (wx3 + xb) / wx3, (-1.0i + wx3) / wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx3) / wx3)) * my_sign(-real(wx3inv)) * T(1.0, (wx3 + xb) / wx3, (1.0i + wx3) / wx3)
                - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx4) / wx4)) * my_sign(real(wx4inv)) * T(1.0, (wx4 + xb) / wx4, (-1.0i + wx4) / wx4) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx4) / wx4)) * my_sign(-real(wx4inv)) * T(1.0, (wx4 + xb) / wx4, (1.0i + wx4) / wx4) - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx3) / wx3)) * my_sign(real(wx3inv)) * T(1.0, 1.0 - xb / wx3, (-1.0i + wx3) / wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx3) / wx3)) * my_sign(-real(wx3inv)) * T(1.0, 1.0 - xb / wx3, (1.0i + wx3) / wx3) - (4.0 * 1.0i) * M_PI * power_of<2>(log((-1.0i + wx4) / wx4)) * my_sign(real(wx4inv)) * T(1.0, 1.0 - xb / wx4, (-1.0i + wx4) / wx4)
                - (4.0 * 1.0i) * M_PI * power_of<2>(log((1.0i + wx4) / wx4)) * my_sign(-real(wx4inv)) * T(1.0, 1.0 - xb / wx4, (1.0i + wx4) / wx4) + log(xb) * (4.0 * log((1.0i + xb) / (1.0i - wx3)) * log((wx3 + xb) / wx3) + 4.0 * log((1.0i - xb) / (1.0i + wx4)) * log((wx4 + xb) / wx4) + 4.0 * log((1.0i + xb) / (1.0i - wx4)) * log((wx4 + xb) / wx4) + 4.0 * log((-1.0i + xb) / (-1.0i + wx3)) * log(1.0 - xb / wx3) + 4.0 * log((1.0i + xb) / (1.0i + wx3)) * log(1.0 - xb / wx3) + 4.0 * log((-1.0i + xb) / (-1.0i + wx4)) * log(1.0 - xb / wx4) + 4.0 * log((1.0i + xb) / (1.0i + wx4)) * log(1.0 - xb / wx4)
                    + (8.0 * 1.0i) * M_PI * log((-1.0i + wx3) / wx3) * my_sign(-imag(wx3 * xbinv)) * T(1.0, (wx3 + xb) / wx3, (-1.0i + wx3) / wx3) + (8.0 * 1.0i) * M_PI * log((1.0i + wx3) / wx3) * my_sign(-imag(wx3 * xbinv)) * T(1.0, (wx3 + xb) / wx3, (1.0i + wx3) / wx3) + (8.0 * 1.0i) * M_PI * log((-1.0i + wx4) / wx4) * my_sign(-imag(wx4 * xbinv)) * T(1.0, (wx4 + xb) / wx4, (-1.0i + wx4) / wx4) + (8.0 * 1.0i) * M_PI * log((1.0i + wx4) / wx4) * my_sign(-imag(wx4 * xbinv)) * T(1.0, (wx4 + xb) / wx4, (1.0i + wx4) / wx4) + (8.0 * 1.0i) * M_PI * log((-1.0i + wx3) / wx3) * my_sign(imag(wx3 * xbinv)) * T(1.0, 1.0 - xb / wx3, (-1.0i + wx3) / wx3) + (8.0 * 1.0i) * M_PI * log((1.0i + wx3) / wx3) * my_sign(imag(wx3 * xbinv)) * T(1.0, 1.0 - xb / wx3, (1.0i + wx3) / wx3)
                    + (8.0 * 1.0i) * M_PI * log((-1.0i + wx4) / wx4) * my_sign(imag(wx4 * xbinv)) * T(1.0, 1.0 - xb / wx4, (-1.0i + wx4) / wx4) + (8.0 * 1.0i) * M_PI * log((1.0i + wx4) / wx4) * my_sign(imag(wx4 * xbinv)) * T(1.0, 1.0 - xb / wx4, (1.0i + wx4) / wx4)) + power_of<2>(log(1.0 - 1.0i * xb)) * (4.0 * ln2 - 8.0 * log(-1.0i / xb) + 2.0 * log(((-1.0i) * (wx3 - xb)) / ((1.0i + wx3) * xb)) + 2.0 * log(((-1.0i) * (wx4 - xb)) / ((1.0i + wx4) * xb)) - 4.0 * log(1.0i * xb) + 8.0 * log((2.0 * 1.0i) * xb) - 2.0 * log((wx3 + xb) / (-1.0i + wx3)) + 2.0 * log(((-1.0i) * (wx3 + xb)) / ((-1.0i + wx3) * xb)) - 2.0 * log((wx4 + xb) / (-1.0i + wx4)) + 2.0 * log(((-1.0i) * (wx4 + xb)) / ((-1.0i + wx4) * xb))
                    + (4.0 * 1.0i) * M_PI * my_sign(real(xb)) * T(1.0, (wx3 + xb) / wx3, 1.0 - 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(real(xb)) * T(1.0, (wx4 + xb) / wx4, 1.0 - 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(real(xb)) * T(1.0, 1.0 - xb / wx3, 1.0 - 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(real(xb)) * T(1.0, 1.0 - xb / wx4, 1.0 - 1.0i * xb)) + power_of<2>(log(1.0 + 1.0i * xb)) * (4.0 * ln2 - 8.0 * log(1.0i / xb) + 2.0 * log((1.0i * (wx3 - xb)) / ((-1.0i + wx3) * xb)) + 2.0 * log((1.0i * (wx4 - xb)) / ((-1.0i + wx4) * xb)) - 4.0 * log((-1.0i) * xb) + 8.0 * log((-2.0 * 1.0i) * xb) - 2.0 * log((wx3 + xb) / (1.0i + wx3)) + 2.0 * log((1.0i * (wx3 + xb)) / ((1.0i + wx3) * xb)) - 2.0 * log((wx4 + xb) / (1.0i + wx4))
                    + 2.0 * log((1.0i * (wx4 + xb)) / ((1.0i + wx4) * xb)) + (4.0 * 1.0i) * M_PI * my_sign(-real(xb)) * T(1.0, (wx3 + xb) / wx3, 1.0 + 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(-real(xb)) * T(1.0, (wx4 + xb) / wx4, 1.0 + 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(-real(xb)) * T(1.0, 1.0 - xb / wx3, 1.0 + 1.0i * xb) + (4.0 * 1.0i) * M_PI * my_sign(-real(xb)) * T(1.0, 1.0 - xb / wx4, 1.0 + 1.0i * xb)) - 4.0 * pisqu * log(1.0 + w4inv) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) * T(p(-w4inv, 1.0 - tb / w4), 1.0 - tb / w4, (-1.0 + w4) / w4) + 4.0 * pisqu * log(1.0 + w4inv) * T(1.0, 1.0 - tb / w4, 1.0 + w4inv) * T(p(-w4inv, 1.0 - tb / w4), 1.0 - tb / w4, 1.0 - w7 / w4)
                - 4.0 * pisqu * log(1.0 + w4inv) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) * T(p(-w4inv, (vb + w4) / w4), (vb + w4) / w4, (-1.0 + w4) / w4) + 4.0 * pisqu * log(1.0 + w4inv) * T(1.0, (vb + w4) / w4, 1.0 + w4inv) * T(p(-w4inv, (vb + w4) / w4), (vb + w4) / w4, 1.0 - w7 / w4) - 4.0 * pisqu * log((-1.0 + w4) / w4) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) * T(p(w4inv, 1.0 - tb / w4), 1.0 - tb / w4, 1.0 + w4inv) - 4.0 * pisqu * log((-1.0 + w4) / w4) * T(1.0, 1.0 - tb / w4, (-1.0 + w4) / w4) * T(p(w4inv, 1.0 - tb / w4), 1.0 - tb / w4, 1.0 - w7 / w4)
                - 4.0 * pisqu * log((-1.0 + w4) / w4) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4) * T(p(w4inv, (vb + w4) / w4), (vb + w4) / w4, 1.0 + w4inv) - 4.0 * pisqu * log((-1.0 + w4) / w4) * T(1.0, (vb + w4) / w4, (-1.0 + w4) / w4) * T(p(w4inv, (vb + w4) / w4), (vb + w4) / w4, 1.0 - w7 / w4) - 4.0 * pisqu * log(1.0 + w5inv) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) * T(p(-w5inv, 1.0 - vb / w5), 1.0 - vb / w5, (-1.0 + w5) / w5) - 4.0 * pisqu * log(1.0 + w5inv) * T(1.0, 1.0 - vb / w5, 1.0 + w5inv) * T(p(-w5inv, 1.0 - vb / w5), 1.0 - vb / w5, (w5 + w7) / w5)
                - 4.0 * pisqu * log(1.0 + w5inv) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) * T(p(-w5inv, (tb + w5) / w5), (tb + w5) / w5, (-1.0 + w5) / w5) - 4.0 * pisqu * log(1.0 + w5inv) * T(1.0, (tb + w5) / w5, 1.0 + w5inv) * T(p(-w5inv, (tb + w5) / w5), (tb + w5) / w5, (w5 + w7) / w5) - 4.0 * pisqu * log((-1.0 + w5) / w5) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) * T(p(w5inv, 1.0 - vb / w5), 1.0 - vb / w5, 1.0 + w5inv) + 4.0 * pisqu * log((-1.0 + w5) / w5) * T(1.0, 1.0 - vb / w5, (-1.0 + w5) / w5) * T(p(w5inv, 1.0 - vb / w5), 1.0 - vb / w5, (w5 + w7) / w5)
                - 4.0 * pisqu * log((-1.0 + w5) / w5) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5) * T(p(w5inv, (tb + w5) / w5), (tb + w5) / w5, 1.0 + w5inv) + 4.0 * pisqu * log((-1.0 + w5) / w5) * T(1.0, (tb + w5) / w5, (-1.0 + w5) / w5) * T(p(w5inv, (tb + w5) / w5), (tb + w5) / w5, (w5 + w7) / w5) + 4.0 * pisqu * log(1.0 - w7 / w4) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) * T(p(w7 / w4, 1.0 - tb / w4), 1.0 - tb / w4, 1.0 + w4inv) - 4.0 * pisqu * log(1.0 - w7 / w4) * T(1.0, 1.0 - tb / w4, 1.0 - w7 / w4) * T(p(w7 / w4, 1.0 - tb / w4), 1.0 - tb / w4, (-1.0 + w4) / w4)
                + 4.0 * pisqu * log(1.0 - w7 / w4) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4) * T(p(w7 / w4, (vb + w4) / w4), (vb + w4) / w4, 1.0 + w4inv) - 4.0 * pisqu * log(1.0 - w7 / w4) * T(1.0, (vb + w4) / w4, 1.0 - w7 / w4) * T(p(w7 / w4, (vb + w4) / w4), (vb + w4) / w4, (-1.0 + w4) / w4) - 4.0 * pisqu * log((w5 + w7) / w5) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) * T(p(-(w7 / w5), 1.0 - vb / w5), 1.0 - vb / w5, 1.0 + w5inv) + 4.0 * pisqu * log((w5 + w7) / w5) * T(1.0, 1.0 - vb / w5, (w5 + w7) / w5) * T(p(-(w7 / w5), 1.0 - vb / w5), 1.0 - vb / w5, (-1.0 + w5) / w5)
                - 4.0 * pisqu * log((w5 + w7) / w5) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5) * T(p(-(w7 / w5), (tb + w5) / w5), (tb + w5) / w5, 1.0 + w5inv) + 4.0 * pisqu * log((w5 + w7) / w5) * T(1.0, (tb + w5) / w5, (w5 + w7) / w5) * T(p(-(w7 / w5), (tb + w5) / w5), (tb + w5) / w5, (-1.0 + w5) / w5) - (103.0 * zeta3) / 2.0;

			return -result;
		}
	}
}