/* vim: set sw=4 sts=4 et foldmethod=syntax : */

/*
 * Copyright (c) 2022 Viktor Kuschke
 *
 * This code is based on code published by Hjalte Frellesvig, Damiano Tommasini
 * and Christopher Wever, which is in the public domain.
 * For further details see ArXiv:1601.02649.
 *
 * This file is part of the EOS project. EOS is free software;
 * you can redistribute it and/or modify it under the terms of the GNU General
 * Public License version 2, as published by the Free Software Foundation.
 *
 * EOS is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <eos/maths/multiplepolylog-li22-const.hh>

namespace eos
{
    namespace li22_impl
    {
        const double ccli2logA0[100] = {1., 0.0277777777777777777778, -0.000277777777777777777778, 4.72411186696900982615e-6, -9.18577307466196355085e-8, 1.8978869988970999072e-9, -4.06476164514422552681e-11, 8.92169102045645255522e-13, -1.99392958607210756872e-14, 4.51898002961991819165e-16, -1.03565176121812470145e-17, 2.39521862102618674574e-19, -5.58178587432500933628e-21, 1.30915075541832128581e-22, -3.08741980242674029324e-24, 7.31597565270220342036e-26, -1.74084565723400074099e-27, 4.15763564461389971962e-29, -9.96214848828462210319e-31, 2.39403442489616530052e-32, -5.76834735536739008429e-34, 1.39317947964700797783e-35, -3.37212196548508947047e-37, 8.17820877756210262176e-39, -1.98701083115238592556e-40, 4.83577851804055089629e-42, -1.17869372487183843267e-43, 2.877096408117257145e-45, -7.03205909815602801496e-47, 1.72086031450331462909e-48, -4.21607239056044549168e-50, 1.03404064051330395739e-51, -2.53866306259946531616e-53, 6.23855317692459088784e-55, -1.53443980691346503917e-56, 3.777294635578550234e-58, -9.30586212480468658839e-60, 2.29434368222418732072e-61, -5.66068873941414784857e-63, 1.39756872198540085454e-64, -3.45267347330633889778e-66, 8.53498373696321710664e-68, -2.11106753916379301954e-69, 5.22446788920815644493e-71, -1.29363445303169121491e-72, 3.20479645174984764253e-74, -7.94326694999713716406e-76, 1.96969401238294242761e-77, -4.88642119356886536649e-79, 1.2127399993287380323e-80, -3.01107647674682414162e-82, 7.47904589777194783774e-84, -1.85837941991417435344e-85, 4.6193425842611789485e-87, -1.1486235467130135708e-88, 2.8570740556428067213e-90, -7.10896369091622518708e-92, 1.76940464275317093111e-93, -4.40533971491237081972e-95, 1.09713120606298044082e-96, -2.73313083816123243674e-98, 6.81053053662527748214e-100, -1.69752549739977101562e-101, 4.23216763434037815455e-103, -1.05540011102109065058e-104, 2.63254505953694582769e-106, -6.56803912905139478216e-108, 1.6390562839944812655e-109, -4.09116816995417822688e-111, 1.02139414028717896929e-112, -2.55052340302039905225e-114, 6.3701938923623999053e-116, -1.59133256352353330242e-117, 3.97605039816258639081e-119, -9.93626602127902345807e-121, 2.48354935273027793979e-122, -6.20866996208690084797e-124, 1.55238189965646443514e-125, -3.88213719560680557378e-127, 9.70987570883174305432e-129, -2.42898695457098901872e-130, 6.07720263182787102327e-132, -1.52071433809476079929e-133, 3.8058825087439879074e-135, -9.52632528675517774988e-137, 2.38482361980845745438e-138, -5.97099262734982093322e-140, 1.49518472872052581311e-141, -3.74455227876193378591e-143, 9.37908338404674472152e-145, -2.34949819836149205611e-146, 5.88630640090960269216e-148, -1.47489970707240971116e-149, 3.696007761196264006e-151, -9.26302721807284788094e-153, 2.32178307158320397184e-154, -5.82020071424204647756e-156, 1.45915330388174209927e-157, -3.65855485706352121659e-159, 9.17408974648312441359e-161};

        // Coefficients for li2logA1:
        const double ccli2logA1[100] = {-1., 0.013888888888888888889, -0.000069444444444444444444, 7.8735197782816830436e-7, -1.1482216343327454439e-8, 1.8978869988970999072e-10, -3.3873013709535212723e-12, 6.3726364431831803966e-14, -1.2462059912950672305e-15, 2.5105444608999545509e-17, -5.1782588060906235072e-19, 1.0887357368300848844e-20, -2.3257441143020872235e-22, 5.0351952131473895608e-24, -1.1026499294381215333e-25, 2.4386585509007344735e-27, -5.4401426788562523156e-29, 1.2228340131217352117e-30, -2.7672634689679505842e-32, 6.3000905918320139487e-34, -1.4420868388418475211e-35, 3.3170939991595428044e-37, -7.6639135579206578874e-39, 1.7778714733830657873e-40, -4.1396058982341373449e-42, 9.6715570360811017926e-44, -2.2667187016766123705e-45, 5.3279563113282539722e-47, -1.2557248389564335741e-48, 2.9670005422470941881e-50, -7.0267873176007424861e-52, 1.6678074846988773506e-53, -3.9666610353116645565e-55, 9.4523532983705922543e-57, -2.2565291278139191752e-58, 5.3961351936836431914e-60, -1.2924808506673175817e-61, 3.1004644354380909739e-63, -7.4482746571238787481e-65, 1.7917547717761549417e-66, -4.3158418416329236222e-68, 1.0408516752394167203e-69, -2.5131756418616583566e-71, 6.0749626618699493546e-73, -1.4700391511723763806e-74, 3.5608849463887196028e-76, -8.6339858152142795261e-78, 2.0954191621095132209e-79, -5.0900220766342347568e-81, 1.2374897952334061554e-82, -3.0110764767468241416e-84, 7.3323979389921057233e-86, -1.7869032883790138014e-87, 4.3578703625105461778e-89, -1.0635403210305681211e-90, 2.5973400505843697466e-92, -6.3472890097466296313e-94, 1.5521093357483955536e-95, -3.7977066507865265687e-97, 9.2977220852794952612e-99, -2.2776090318010270306e-100, 5.5824020792010471165e-102, -1.3689721753223959803e-103, 3.3588632018574429798e-105, -8.2453133673522707077e-107, 2.0250346611822660213e-108, -4.9757872189783293804e-110, 1.2231763313391651235e-111, -3.0082118896721898727e-113, 7.4014068136752099224e-115, -1.8218024307288564659e-116, 4.4860520368749295108e-118, -1.1050920580024536822e-119, 2.7233221905223194458e-121, -6.713693257620961796e-123, 1.6556995684868519599e-124, -4.0846512908466452947e-126, 1.0080401945821197631e-127, -2.4885494843633369063e-129, 6.1454909549567994015e-131, -1.5181168466068681367e-132, 3.7513596492764635946e-134, -9.272648403016834142e-136, 2.2927003064722818719e-137, -5.6704317183066534225e-139, 1.402837423416739679e-140, -3.4715073414824540309e-142, 8.5930156823018724891e-144, -2.1275865220238260147e-145, 5.2691479685655869222e-147, -1.3052767768674955867e-148, 3.2342342862140674133e-150, -8.0157592775674440824e-152, 1.9871009468797118312e-153, -4.927142137272791426e-155, 1.2219910903069494589e-156, -3.0313545386677325404e-158, 7.5214087828955778313e-160, -1.8666096209507761309e-161, 4.633378659839961825e-163};

        // Coefficients for li3logA1:
        const double ccli3logA1[100] = {0.75, -0.0034722222222222222222, 0.000011574074074074074074, -9.8418997228521038045e-8, 1.1482216343327454439e-9, -1.5815724990809165893e-11, 2.4195009792525151945e-13, -3.9828977769894877479e-15, 6.9233666183059290581e-17, -1.2552722304499772755e-18, 2.3537540027684652306e-20, -4.5363989034586870184e-22, 8.9451696703926431671e-24, -1.7982840046954962717e-25, 3.6754997647937384443e-27, -7.6208079715647952295e-29, 1.6000419643694859752e-30, -3.3967611475603755879e-32, 7.2822722867577646953e-34, -1.5750226479580034872e-35, 3.4335400924805893359e-37, -7.5388499980898700099e-39, 1.6660681647653604103e-40, -3.703898902881387057e-42, 8.2792117964682746899e-44, -1.859914814630981114e-45, 4.1976272253270599454e-47, -9.5142076988004535218e-49, 2.1650428257869544381e-50, -4.9450009037451569801e-52, 1.1333527931614100784e-53, -2.6059491948419958604e-55, 6.0100924777449462977e-57, -1.390051955642734155e-58, 3.2236130397341702504e-60, -7.4946322134495044325e-62, 1.7465957441450237591e-63, -4.0795584676816986499e-65, 9.5490700732357419848e-67, -2.2396934647201936771e-68, 5.2632217580889312466e-70, -1.2391091371897818099e-71, 2.9222972579786725077e-73, -6.9033666612158515393e-75, 1.6333768346359737562e-76, -3.8705271156399126118e-78, 9.1850912927811484321e-80, -2.1827282938640762717e-81, 5.1939000781981987314e-83, -1.2374897952334061554e-84, 2.9520357615164942565e-86, -7.0503826336462555032e-88, 1.6857578192254847183e-89, -4.0350651504727279424e-91, 9.6685483730051647373e-93, -2.3190536165931872738e-94, 5.5677973769707277468e-96, -1.338025289438272029e-97, 3.2183954667682428548e-99, -7.7481017377329127177e-101, 1.866892649017235271e-102, -4.5019371606460057391e-104, 1.0864858534304730003e-105, -2.624111876451127328e-107, 6.3425487441171313136e-109, -1.5341171675623227434e-110, 3.7132740440136786421e-112, -8.9939436127879788493e-114, 2.1798636881682535309e-115, -5.2867191526251499446e-117, 1.2829594582597580746e-118, -3.1153139144964788269e-120, 7.569123684948312892e-122, -1.8400825611637293552e-123, 4.4757955050806411973e-125, -1.0892760318992447104e-126, 2.6523709680822372044e-128, -6.4617961191161523274e-130, 1.5750313192173018394e-131, -3.8409318468479996259e-133, 9.3710916457214082513e-135, -2.2874144202905265821e-136, 5.5859327729017073145e-138, -1.3647025633763582571e-139, 3.3355480695921490721e-141, -8.1560315314926725526e-143, 1.9951191617715253051e-144, -4.8823952740351548234e-146, 1.1952733269796775364e-147, -2.9273044269808816234e-149, 7.1718504223488768502e-151, -1.7577360251163409855e-152, 4.3095479986921742378e-154, -1.0569685887658041655e-155, 2.5932327038277849611e-157, -6.3645369286820284316e-159, 1.5625538859112023404e-160, -3.8374534606610090976e-162, 9.4273213179332127824e-164, -2.3166893299199809125e-165};

        // Coefficients for li4logA1:
        const double ccli4logA1[100] = {-1.2020569031595942854, -0.30555555555555555556, 0.00069444444444444444444, -1.6534391534391534392e-6, 1.0935444136502337561e-8, -1.043837849393404949e-10, 1.2165942300622435303e-12, -1.6130006528350101297e-14, 2.3428810452879339693e-16, -3.6438771675294363464e-18, 5.9774868116665584546e-20, -1.023371305551506622e-21, 1.8145595613834748074e-23, -3.3130258038491270989e-25, 6.2009793265361940404e-27, -1.185645085417334982e-28, 2.3093357489590288574e-30, -4.5715484696271027862e-32, 9.1804355339469610484e-34, -1.8672493042968627424e-35, 3.8415186535561060663e-37, -7.9849769592571845021e-39, 1.6752999995755266689e-40, -3.5448258824794902347e-42, 7.5589773528191572591e-44, -1.6233748620526028804e-45, 3.5092732351527945546e-47, -7.6320495005946544462e-49, 1.6691592454035883372e-50, -3.669564111503312607e-52, 8.1065588585986180002e-54, -1.7989726875577937753e-55, 4.0091526074492244006e-57, -8.9702872802163377578e-59, 2.0145680516561364566e-60, -4.5403000559636200709e-62, 1.0266619470478773195e-63, -2.3287943255266983454e-65, 5.2981278801061021428e-67, -1.208743047245030631e-68, 2.7650536601483872557e-70, -6.3412310338420858393e-72, 1.4577754555173903646e-73, -3.3589623654927270203e-75, 7.7565917541751140891e-77, -1.7949195985010700618e-78, 4.1618571135913038836e-80, -9.668517150295945718e-82, 2.2502353544990477028e-83, -5.2463637153517158903e-85, 1.2252374210231744113e-86, -2.866054137394654618e-88, 6.7146501272821480982e-90, -1.5754745974069950638e-91, 3.7018946334612182958e-93, -8.7104039396442925562e-95, 2.052259837693086083e-96, -4.8415629364962849972e-98, 1.1436113584942495974e-99, -2.7045340056875990377e-101, 6.4033898658949691881e-103, -1.5177989016400286756e-104, 3.6015497285168045913e-106, -8.5550067199249842541e-108, 2.0341952530628894015e-109, -4.8416402626848330638e-111, 1.1534715545581374011e-112, -2.7505733659360582534e-114, 6.5649223451007144886e-116, -1.5682472576750025402e-117, 3.7494462075355673366e-119, -8.9717444633549515704e-121, 2.1484923548251578117e-122, -5.1490637312573557089e-124, 1.23495473903605997e-125, -2.9641029834971133757e-127, 7.1194511888839523558e-129, -1.7112070761820885189e-130, 4.1157937064434091258e-132, -9.9058573535679360969e-134, 2.3856719545639749229e-135, -5.7491359789701891112e-137, 1.3863117698730464134e-138, -3.3448699238932379129e-140, 8.0751630969015281485e-142, -1.9506129061942392234e-143, 4.7144690933483656373e-145, -1.1400680924408716029e-146, 2.7584154090594095047e-148, -6.6775046199981985271e-150, 1.6172952635253489632e-151, -3.9190439466387305192e-153, 9.5012758114396810026e-155, -2.3045711222952803411e-156, 5.592426395586265426e-158, -1.3577134575014580948e-159, 3.2976875278145225034e-161, -8.0130968508266786688e-163, 1.9479459191172635013e-164, -4.7373473959463380816e-166};

        const double ccli2logA10 =  1.6449340668482264365;      //this is dilog::series_coefficient_f1[0]
        const double ccli2logA12 =  -0.25;                      //this is dilog::series_coefficient_f1[2]
        const double ccli2logA1log =  1.;
        const double ccli3logA10 =  1.2020569031595942854;      //this is trilog::series_coefficient_f1[0]
        const double ccli3logA11 =  -1.6449340668482264365;     //this is trilog::series_coefficient_f1[1]
        const double ccli3logA13 =  0.083333333333333333333;    //this is trilog::series_coefficient_f1[3]
        const double ccli3logA1log =  -0.5;
        const double ccli4logA10 =  1.0823232337111381915;      //this is quadlog::series_coefficient_f1[0]
        const double ccli4logA12 =  0.82246703342411321824;     //this is quadlog::series_coefficient_f1[2]
        const double ccli4logA14 =  -0.020833333333333333333;   //this is quadlog::series_coefficient_f1[4]
        const double ccli4logA1log =  0.16666666666666666667;

        // BELOW ARE THE COEFFICIENTS FOR LI22FAST

        // cc1 = Table[(i + 1)^2/((i + 2)^2), {i, 1, 100}];
        // cc2 = Table[1/(i + 1)^2/((i + 2)^2), {i, 1, 100}];
        const double ccli221[100] = {0.444444444444444444444, 0.5625, 0.64, 0.694444444444444444444, 0.734693877551020408163, 0.765625, 0.79012345679012345679, 0.81, 0.82644628099173553719, 0.840277777777777777778, 0.852071005917159763314, 0.862244897959183673469, 0.871111111111111111111, 0.87890625, 0.88581314878892733564, 0.891975308641975308642, 0.897506925207756232687, 0.9025, 0.907029478458049886621, 0.911157024793388429752, 0.914933837429111531191, 0.918402777777777777778, 0.9216, 0.92455621301775147929, 0.92729766803840877915, 0.929846938775510204082, 0.932223543400713436385, 0.934444444444444444444, 0.93652445369406867846, 0.9384765625, 0.940312213039485766758, 0.942041522491349480969, 0.943673469387755102041, 0.945216049382716049383, 0.946676406135865595325, 0.948060941828254847645, 0.949375410913872452334, 0.950625, 0.951814396192742415229, 0.952947845804988662132, 0.954029204975662520281, 0.955061983471074380165, 0.956049382716049382716, 0.956994328922495274102, 0.957899502037120869172, 0.958767361111111111111, 0.959600166597251145356, 0.9604, 0.961168781237985390235, 0.961908284023668639053, 0.962620149519401922392, 0.963305898491083676269, 0.963966942148760330579, 0.964604591836734693878, 0.965220067713142505386, 0.96581450653983353151, 0.966388968687158862396, 0.966944444444444444444, 0.967481859715130341306, 0.968002081165452653486, 0.968505920886873267826, 0.968994140625, 0.969467455621301775148, 0.969926538108356290174, 0.970372020494542214302, 0.970804498269896193772, 0.97122453266120562907, 0.971632653061224489796, 0.972029359254116246776, 0.972415123456790123457, 0.972790392193657346594, 0.973155588020452885318, 0.973511111111111111111, 0.973857340720221606648, 0.974194636532298869961, 0.974523339907955292571, 0.974843775036051914757, 0.97515625, 0.975461057765584514556, 0.975758477096966091612, 0.976048773406880534185, 0.976332199546485260771, 0.976608996539792387543, 0.976879394267171444024, 0.977143612101994979522, 0.977401859504132231405, 0.977654336573664941295, 0.977901234567901234568, 0.978142736384494626253, 0.978379017013232514178, 0.978610243958839172159, 0.978836577636939791761, 0.979058171745152354571, 0.979275173611111111111, 0.979487724519077479009, 0.979695960016659725115, 0.979900010203040506071, 0.9801, 0.980296049406920890109, 0.980488273740868896578};
        const double ccli222[100] = {0.0277777777777777777778, 0.00694444444444444444444, 0.0025, 0.00111111111111111111111, 0.000566893424036281179138, 0.000318877551020408163265, 0.000192901234567901234568, 0.000123456790123456790123, 0.000082644628099173553719, 0.0000573921028466483011938, 0.0000410913872452333990796, 0.0000301895906291510687115, 0.0000226757369614512471655, 0.0000173611111111111111111, 0.0000135164359861591695502, 0.0000106796531248665043359, 8.54963920522553948223e-6, 6.92520775623268698061e-6, 5.66893424036281179138e-6, 4.68506962013455519949e-6, 3.90570076083050820978e-6, 3.28187355597563537072e-6, 2.77777777777777777778e-6, 2.36686390532544378698e-6, 2.02920430840658760887e-6, 1.74967106184037400969e-6, 1.51665898226115654347e-6, 1.32117849121416303343e-6, 1.15620302925193664007e-6, 1.01619406867845993757e-6, 8.96751606978879706152e-7, 7.94354364659492058045e-7, 7.06164818868723960172e-7, 6.29881582262534643487e-7, 5.63626689752815878942e-7, 5.05858857285075747305e-7, 4.55306229864081984261e-7, 4.10913872452333990796e-7, 3.71802498512790005949e-7, 3.37235826315455787709e-7, 3.06594604670784845397e-7, 2.79355827809537431446e-7, 2.55076012651770227528e-7, 2.33377675091600737473e-7, 2.13938339547528969391e-7, 1.96481565313616015291e-7, 1.80769586746263131103e-7, 1.66597251145356101624e-7, 1.53787004998077662438e-7, 1.42184730952364702697e-7, 1.31656278108615376189e-7, 1.22084559672735245959e-7, 1.13367116734120101123e-7, 1.05414066453027491989e-7, 9.81463684273339991583e-8, 9.1494355347241207301e-8, 8.53964839193296990867e-8, 7.97982699735069743688e-8, 7.46513780644390695452e-8, 6.99128410593081816761e-8, 6.55443894133750929747e-8, 6.1511873267825648778e-8, 5.77847633136094674556e-8, 5.43357186713830070473e-8, 5.11402119373119190855e-8, 4.81762031139556054361e-8, 4.54238554460295553041e-8, 4.28652872617225844339e-8, 4.04843548210793938682e-8, 3.82664619257887789264e-8, 3.61983926755303498908e-8, 3.42681642859659119492e-8, 3.24648973297621946271e-8, 3.0778701138811942136e-8, 2.92005724246613551215e-8, 2.77223054445831668609e-8, 2.63364122706190668672e-8, 2.50360519147572504406e-8, 2.38149672306050906874e-8, 2.26674286549483314098e-8, 2.15881839751946584961e-8, 2.05724134140035266054e-8, 1.96156894130201100048e-8, 1.87139405757530957536e-8, 1.78634192971087484238e-8, 1.70606726654721466093e-8, 1.63025162738238451819e-8, 1.55860106203076366776e-8, 1.49084398168647252896e-8, 1.42672923578218661208e-8, 1.36602437293470775056e-8, 1.30851406660472684481e-8, 1.25399868831737202003e-8, 1.20229301323484148969e-8, 1.15322504457906732325e-8, 1.10663494490219538224e-8, 1.06237406352257487517e-8, 1.02030405060708091011e-8, 9.80296049406920890109e-9, 9.42229959060862062773e-9};

        // BELOW ARE THE COEFFICIENTS FOR LI22STUFFLE (almost the same as above)

        const double ccli22stuffle1[100] = {0.25, 0.444444444444444444444, 0.5625, 0.64, 0.694444444444444444444, 0.734693877551020408163, 0.765625, 0.79012345679012345679, 0.81, 0.82644628099173553719, 0.840277777777777777778, 0.852071005917159763314, 0.862244897959183673469, 0.871111111111111111111, 0.87890625, 0.88581314878892733564, 0.891975308641975308642, 0.897506925207756232687, 0.9025, 0.907029478458049886621, 0.911157024793388429752, 0.914933837429111531191, 0.918402777777777777778, 0.9216, 0.92455621301775147929, 0.92729766803840877915, 0.929846938775510204082, 0.932223543400713436385, 0.934444444444444444444, 0.93652445369406867846, 0.9384765625, 0.940312213039485766758, 0.942041522491349480969, 0.943673469387755102041, 0.945216049382716049383, 0.946676406135865595325, 0.948060941828254847645, 0.949375410913872452334, 0.950625, 0.951814396192742415229, 0.952947845804988662132, 0.954029204975662520281, 0.955061983471074380165, 0.956049382716049382716, 0.956994328922495274102, 0.957899502037120869172, 0.958767361111111111111, 0.959600166597251145356, 0.9604, 0.961168781237985390235, 0.961908284023668639053, 0.962620149519401922392, 0.963305898491083676269, 0.963966942148760330579, 0.964604591836734693878, 0.965220067713142505386, 0.96581450653983353151, 0.966388968687158862396, 0.966944444444444444444, 0.967481859715130341306, 0.968002081165452653486, 0.968505920886873267826, 0.968994140625, 0.969467455621301775148, 0.969926538108356290174, 0.970372020494542214302, 0.970804498269896193772, 0.97122453266120562907, 0.971632653061224489796, 0.972029359254116246776, 0.972415123456790123457, 0.972790392193657346594, 0.973155588020452885318, 0.973511111111111111111, 0.973857340720221606648, 0.974194636532298869961, 0.974523339907955292571, 0.974843775036051914757, 0.97515625, 0.975461057765584514556, 0.975758477096966091612, 0.976048773406880534185, 0.976332199546485260771, 0.976608996539792387543, 0.976879394267171444024, 0.977143612101994979522, 0.977401859504132231405, 0.977654336573664941295, 0.977901234567901234568, 0.978142736384494626253, 0.978379017013232514178, 0.978610243958839172159, 0.978836577636939791761, 0.979058171745152354571, 0.979275173611111111111, 0.979487724519077479009, 0.979695960016659725115, 0.979900010203040506071, 0.9801, 0.980296049406920890109};

        const double ccli22stuffle2[100] = {0.0625, 0.0123456790123456790123, 0.00390625, 0.0016, 0.000771604938271604938272, 0.000416493127863390254061, 0.000244140625, 0.000152415790275872580399, 0.0001, 0.0000683013455365070691893, 0.000048225308641975308642, 0.0000350127796645775708133, 0.0000260308204914618908788, 0.0000197530864197530864198, 0.0000152587890625, 0.0000119730367213036242382, 9.52598689224203627496e-6, 7.67336039471765870428e-6, 6.25e-6, 5.14189046744926239581e-6, 4.26883409603169182433e-6, 3.57345778495645741689e-6, 3.01408179012345679012e-6, 2.56e-6, 2.18829872903609817583e-6, 1.88167642315892074567e-6, 1.62692628071636817993e-6, 1.41386521057401513684e-6, 1.23456790123456790123e-6, 1.08281241032959726958e-6, 9.5367431640625e-7, 8.43226488105025545546e-7, 7.48314795081476514888e-7, 6.66389004581424406497e-7, 5.95374180765127267185e-7, 5.33572089057450240401e-7, 4.79585024669853669017e-7, 4.3225653906885889893e-7, 3.90625e-7, 3.53886970624904229339e-7, 3.21368154215578899738e-7, 2.92500206943896412807e-7, 2.66802131001980739021e-7, 2.43865264441396128639e-7, 2.23341111559778588556e-7, 2.04931428919226482223e-7, 1.88380111882716049383e-7, 1.73466525557430343216e-7, 1.6e-7, 1.47815268164242274546e-7, 1.3676867056475613599e-7, 1.26734986118083295556e-7, 1.17604776447432546604e-7, 1.09282152858411310703e-7, 1.01682892544773011245e-7, 9.47328443792303543738e-8, 8.83665756608759460526e-8, 8.25262200243105738948e-8, 7.71604938271604938272e-8, 7.222385408008079827e-8, 6.76757756455998293488e-8, 6.34801292277686715532e-8, 5.9604644775390625e-8, 5.60204474633241133014e-8, 5.27016555065640965967e-8, 4.96250307861284739445e-8, 4.67696746925922821805e-8, 4.41167627772402150233e-8, 4.16493127863390254061e-8, 3.93519814765500952102e-8, 3.72108862978204541991e-8, 3.52134486076091825547e-8, 3.33482555660906400251e-8, 3.16049382716049382716e-8, 2.99740640418658543136e-8, 2.84470410397780379797e-8, 2.70160336918036811831e-8, 2.5673887558796090822e-8, 2.44140625e-8, 2.32305731254187746379e-8, 2.21179356640565143337e-8, 2.10711204890708206892e-8, 2.00855096384736812336e-8, 1.91568587540857987811e-8, 1.82812629339935258004e-8, 1.7455126056469322677e-8, 1.66751331876237961888e-8, 1.59382257321666275835e-8, 1.52415790275872580399e-8, 1.45825821176916163321e-8, 1.39588194724861617847e-8, 1.3368054448513546538e-8, 1.28082143074516551389e-8, 1.22773766315482539268e-8, 1.17737569926697530864e-8, 1.12956977477316233936e-8, 1.0841657847339396451e-8, 1.0410203556852167229e-8, 1.e-8, 9.60980344482816282824e-9};

        // BELOW ARE THE CONSTANTS FOR LI22INV

        const double ccli234fast2o[50] = {1., 0.0277777777777777777778, -0.000277777777777777777778, 4.72411186696900982615e-6, -9.18577307466196355085e-8, 1.8978869988970999072e-9, -4.06476164514422552681e-11, 8.92169102045645255522e-13, -1.99392958607210756872e-14, 4.51898002961991819165e-16, -1.03565176121812470145e-17, 2.39521862102618674574e-19, -5.58178587432500933628e-21, 1.30915075541832128581e-22, -3.08741980242674029324e-24, 7.31597565270220342036e-26, -1.74084565723400074099e-27, 4.15763564461389971962e-29, -9.96214848828462210319e-31, 2.39403442489616530052e-32, -5.76834735536739008429e-34, 1.39317947964700797783e-35, -3.37212196548508947047e-37, 8.17820877756210262176e-39, -1.98701083115238592556e-40, 4.83577851804055089629e-42, -1.17869372487183843267e-43, 2.877096408117257145e-45, -7.03205909815602801496e-47, 1.72086031450331462909e-48, -4.21607239056044549168e-50, 1.03404064051330395739e-51, -2.53866306259946531616e-53, 6.23855317692459088784e-55, -1.53443980691346503917e-56, 3.777294635578550234e-58, -9.30586212480468658839e-60, 2.29434368222418732072e-61, -5.66068873941414784857e-63, 1.39756872198540085454e-64, -3.45267347330633889778e-66, 8.53498373696321710664e-68, -2.11106753916379301954e-69, 5.22446788920815644493e-71, -1.29363445303169121491e-72, 3.20479645174984764253e-74, -7.94326694999713716406e-76, 1.96969401238294242761e-77, -4.88642119356886536649e-79, 1.2127399993287380323e-80};

        const double ccli234fast3o[50] = {1., 0.0787037037037037037037, 0.00012962962962962962963, -3.41935716085375949322e-6, 8.66087175610985134795e-8, -2.14469446836406476093e-9, 5.24958211460082943639e-11, -1.27793960944936953056e-12, 3.10435788796546229428e-14, -7.53847954994926536599e-16, 1.83169799654913833821e-17, -4.45543389782963882643e-19, 1.08515215348745349131e-20, -2.64663397544589903347e-22, 6.46404773360331088903e-24, -1.58091787902874833559e-25, 3.8715536638418473304e-27, -9.49303387191183612642e-29, 2.33044789361030518601e-30, -5.72742160613725968447e-32, 1.40908086040689448401e-33, -3.47010516489959160555e-35, 8.55369656823692105755e-37, -2.11030731665291450123e-38, 5.21069983399591768727e-40, -1.28760990549822459562e-41, 3.18413433597311711513e-43, -7.87951702827426663048e-45, 1.95115865383390980642e-46, -4.83454010781168240474e-48, 1.19859725604737009748e-49, -2.97326667639271410471e-51, 7.3794635575180183245e-53, -1.8324611992094396787e-54, 4.55253558045741042317e-56, -1.131542025142378846e-57, 2.81369922984216864689e-59, -6.99947980008426417277e-61, 1.74191509334634560741e-62, -4.33664474404944952592e-64, 1.08003876644682829566e-65, -2.69077194932209436453e-67, 6.70594984010431247385e-69, -1.67179779623437813933e-70, 4.16909460365277804311e-72, -1.03998992874654137524e-73, 2.59502183718779187431e-75, -6.47698343789186455602e-77, 1.61703745561942237663e-78, -4.03811576717266187617e-80};

        const double ccli234fast4o[50] = {3., 0.349537037037037037037, 0.0057837962962962962963, -0.0000468720273445735058952, 6.87288498095691343361e-7, -1.16484746375160467168e-8, 2.08824156320481762236e-10, -3.83545580557997148124e-12, 7.09427135058547720869e-14, -1.30358747129952561751e-15, 2.34372429995878640122e-17, -4.03060329894385435688e-19, 6.34582686072977605425e-21, -8.12045298247201927683e-23, 3.98617963700514689275e-25, 2.48508176998018023329e-26, -1.37271415334546371147e-27, 5.07010186681135532032e-29, -1.62798381170142547504e-30, 4.86963327032621123181e-32, -1.39616981100772111325e-33, 3.89285144640930887478e-35, -1.06440060614472092673e-36, 2.86889238283884705211e-38, -7.64890313367532442657e-40, 2.02211220200446320537e-41, -5.30989158769658340535e-43, 1.38675191092046775325e-44, -3.60552540612032180222e-46, 9.33949432620220160106e-48, -2.4116919090056764452e-49, 6.21113102484653881392e-51, -1.59601630435541878998e-52, 4.09316022260741678861e-54, -1.04796855290325106558e-55, 2.67917051419157660555e-57, -6.84060534515040188588e-59, 1.74460900347358489715e-60, -4.44496626339249513075e-62, 1.13150072940015602918e-63, -2.87805882958059692979e-65, 7.31542814225657409965e-67, -1.85826275552445348993e-68, 4.71769443563754617679e-70, -1.19710545076412689319e-71, 3.03624354959389570732e-73, -7.69771051272914569414e-75, 1.95085203114530198181e-76, -4.94242415104037870742e-78, 1.25176307692460631384e-79};

        const double ccli234fast2e = -0.25;

        const double ccli234fast3e[50] = {-0.375, -0.00868055555555555555556, 0.0000810185185185185185185, -1.32865646258503401361e-6, 2.52608759553203997648e-8, -5.14011062201297891534e-10, 1.08877544066363183754e-11, -2.36982417730874520998e-13, 5.26175862991250608413e-15, -1.18623225777522852531e-16, 2.70681710318373501515e-18, -6.23754849225569465037e-20, 1.44911748660360819307e-21, -3.38976534885101047219e-23, 7.97583448960241242421e-25, -1.88614997296228681931e-26, 4.48011750023456073049e-28, -1.0682813809077381224e-29, 2.55607757265197540806e-31, -6.13471321379642358259e-33, 1.47642223976665341443e-34, -3.56210662409746357967e-36, 8.61357241183691332131e-38, -2.0871470317736616066e-39, 5.06687761943858411019e-41, -1.232193564693024988e-42, 3.00130346610884786096e-44, -7.32118282422694898505e-46, 1.78832537410002436587e-47, -4.37385329936259134894e-49, 1.0710183895375325241e-50, -2.62549381380331082931e-52, 6.44281913614258243117e-54, -1.58257415149925283552e-55, 3.89090093895914349218e-57, -9.57439265268174191257e-59, 2.35790425459578207476e-60, -5.81133103721257972681e-62, 1.43331541799268487191e-63, -3.53759582752554591305e-65, 8.73694811842762586939e-67, -2.15914767155319480376e-68, 5.3390370903270346715e-70, -1.32095921062365319204e-71, 3.27002042294121945992e-73, -8.09907798947651714009e-75, 2.00694244747268093241e-76, -4.9755291458631618614e-78, 1.23407065857989201858e-79, -3.06216849830506353157e-81};

        const double ccli234fast4e[50] = {-1.3125, -0.0594618055555555555556, -0.0000931712962962962962963, 2.54553706403196199115e-6, -6.54978426555807508188e-8, 1.63388763096609963548e-9, -4.01272130593356455987e-11, 9.78168857407467672864e-13, -2.37694053660934851073e-14, 5.77088101876077603484e-16, -1.4015411534410966561e-17, 3.40704805540420297343e-19, -8.29260790042395521648e-21, 2.0211613448588571643e-22, -4.93313191691034794035e-24, 1.20572545485208052099e-25, -2.95092327283845383275e-27, 7.2314416689179425514e-29, -1.77427288766225303593e-30, 4.35827863132208278384e-32, -1.07171587873323995446e-33, 2.63807222332181655331e-35, -6.4999467167257302572e-37, 1.60296637828116796487e-38, -3.95646747546362172201e-40, 9.77322843008506631662e-42, -2.41599484296734993223e-43, 5.97672332908634543573e-45, -1.47952579007583236141e-46, 3.66486900071009954972e-48, -9.08356517116614264331e-50, 2.25269644154323628994e-51, -5.58965394092187426274e-53, 1.38768668543730038587e-54, -3.44676221290643432737e-56, 8.56514102467500019597e-58, -2.12937218684038391924e-59, 5.29606973505851944718e-61, -1.31774882592882654243e-62, 3.28005176955558441948e-64, -8.16752837191902029178e-66, 2.03449074890585345875e-67, -5.06955142344802475389e-69, 1.26364796476284692638e-70, -3.15079239552729405649e-72, 7.85860167845217726097e-74, -1.9606386122398444444e-75, 4.89296237009538587987e-77, -1.2214164707397377464e-78, 3.04978344474296043649e-80};

        const double ccli22invc1 = 8.38800506126132098425;
        const double ccli22invc2 = 3.28986813369645287294;
        const double ccli22invc3 = 0.125;
        const double ccli22invc4 = -3.28986813369645287294;
        const double ccli22invc5 = -0.333333333333333333333;
        const double ccli22invc6 = 0.822467033424113218236;
        const double ccli22invc7 = 0.25;
        const double ccli22invc8 = 2.;
        const double ccli22invc9 = 0.5;
        const double ccli22invc10 = 1.64493406684822643647;

        // BELOW ARE THE CONSTANTS USED FOR LI22BERNOULLI
        const double ccli22logA0a[101][101] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
            {-1., -0.25, 0.138888888888888888889, -0.0243055555555555555556, 0.00108796296296296296296, 0.000225694444444444444444, -0.0000204317838246409674981, -3.7399218946837994457e-6, 4.34902613308697964783e-7, 7.1763852145796590241e-8, -9.67944963330364965767e-9, -1.47086242414525242808e-9, 2.20319673226086697976e-10, 3.13325376813200717691e-11, -5.08647497264620637035e-12, -6.85058417642191892633e-13, 1.18640957924287091386e-13, 1.5266023393364573573e-14, -2.78944260938921180769e-15, -3.45199863373743750751e-16, 6.60101391768498650278e-17, 7.89684467928820084854e-18, -1.57052211752080345064e-18, -1.82363235919039218142e-19, 3.75372496961790665796e-20, 4.2444830086013091828e-21, -9.0071734872085183486e-22, -9.94451054596609438261e-23, 2.16870590817321169545e-23, 2.34313110005600825826e-24, -5.23743299661054926304e-25, -5.5479482032991709271e-26, 1.26821535664705660921e-26, 1.31923459962264118653e-27, -3.07822014184558936429e-28, -3.14879758378846817e-29, 7.487437339640070293e-30, 7.540792952937665342e-31, -1.82475165270186907285e-31, -1.81127604515170401026e-32, 4.4548604737580857258e-33, 4.36231268749658875125e-34, -1.08932448150290869703e-34, -1.05317734473315484038e-35, 2.66756382232289501579e-36, 2.54825125800861874757e-37, -6.54117081954042272446e-38, -6.17810337000615361101e-39, 1.60595738123629267529e-39, 1.50060713810987478754e-40, -3.94739182459218986063e-41, -3.6510127811206159267e-42, 9.71288756617458249383e-43, 8.89687090408070355428e-44, -2.39230388511954301089e-44, -2.17114219686626349368e-45, 5.89773682941721819672e-46, 5.30543744459093185058e-47, -1.4552228678892445082e-47, -1.29806273723310370729e-48, 3.59356237828511976269e-49, 3.17962126121433597498e-50, -8.88077889356802868649e-51, -7.79699999096725161419e-52, 2.19627975087513258733e-52, 1.91391394953787814851e-53, -5.4352209982926264932e-54, -4.70254576593936964651e-55, 1.34593293058621339364e-55, 1.15647117800463357732e-56, -3.33496541108976335597e-57, -2.84646131466812178348e-58, 8.26812781824103225542e-59, 7.01170861487019788084e-60, -2.0509650398431118748e-60, -1.72850892275673571797e-61, 5.09017617477374195104e-62, 4.2641372412034205833e-63, -1.26392110830839759918e-63, -1.05265592841849102826e-64, 3.13985515233771887904e-65, 2.60029470958383648239e-66, -7.8035525380849017163e-67, -6.42725909460339824799e-68, 1.94025784935188164196e-68, 1.58958359347749891054e-69, -4.8261711308030281613e-70, -3.93353832356079220708e-71, 1.20092125229514140313e-71, 9.73900937651699352137e-73, -2.989425556884540919e-73, -2.41249955117835753091e-74, 7.44415929024276401128e-75, 5.97903517703588857186e-76, -1.854351190071768693e-76, -1.48250905719248060376e-77, 4.62073245485422444069e-78, 3.67754095036823461176e-79, -1.15177223186847723906e-79, -9.12648723984637039617e-81, 2.87179932792282844229e-81},
            {-0.0625, 0.0972222222222222222222, -0.0121527777777777777778, 0.000127314814814814814815, 0.000112847222222222222222, -7.6766817838246409675e-7, -1.86996094734189972285e-6, -1.219302021220010638e-8, 3.58819260728982951205e-8, 8.5393618003947489277e-10, -7.3543121207262621404e-10, -3.210682096700454445e-11, 1.56662688406600358846e-11, 1.02543892185947783691e-12, -3.42529208821095946316e-13, -3.04063524111012948994e-14, 7.63301169668228678652e-15, 8.64768710115353191979e-16, -1.72599931686871875376e-16, -2.39557772785719260658e-17, 3.94842233964410042427e-18, 6.51870113855310322122e-19, -9.11816179595196090708e-20, -1.7512983335023027396e-20, 2.1222415043006545914e-21, 4.66046854432398982639e-22, -4.97225527298304719131e-23, -1.23121189773344937221e-23, 1.17156555002800412913e-24, 3.23406402385648810477e-25, -2.77397410164958546355e-26, -8.45611130325372325235e-27, 6.59617299811320593265e-28, 2.20276200922971506551e-28, -1.574398791894234085e-29, -5.72032239405035585153e-30, 3.770396476468832671e-31, 1.48165859854523076409e-31, -9.05638022575852005131e-33, -3.82933448625671672561e-33, 2.18115634374829437562e-34, 9.87835186860254427096e-35, -5.26588672366577420191e-36, -2.54415834914640538314e-36, 1.27412562900430937378e-37, 6.54326512330431178389e-38, -3.0890516850030768055e-39, -1.68078484832233606931e-39, 7.50303569054937393768e-41, 4.31281616115662123486e-41, -1.82550639056030796335e-42, -1.10559215026825275941e-42, 4.44843545204035177714e-44, 2.83178302880438849756e-44, -1.08557109843313174684e-45, -7.24761727761763152334e-46, 2.65271872229546592529e-47, 1.85367903781034968954e-47, -6.49031368616551853644e-49, -4.73813101622613063076e-49, 1.58981063060716798749e-50, 1.2104260801428848975e-50, -3.8984999954836258071e-52, -3.090654177851551478e-52, 9.56956974768939074257e-54, 7.88792990162549126272e-54, -2.35127288296968482326e-55, -2.01230319680545712173e-55, 5.78235589002316788658e-57, 5.13164763849650874322e-57, -1.42323065733406089174e-58, -1.30817810217681540608e-58, 3.50585430743509894042e-60, 3.33377047630439997196e-60, -8.64254461378367858986e-62, -8.49325495447071732919e-62, 2.13206862060171029165e-63, 2.16317688981660290948e-63, -5.26327964209245514128e-65, -5.50805304410913530094e-65, 1.3001473547919182412e-66, 1.40216895785803050658e-66, -3.21362954730169912399e-68, -3.56866628452621417102e-68, 7.94791796738749455272e-70, 9.08074379085643009818e-70, -1.96676916178039610354e-71, -2.31021689317373453199e-71, 4.86950468825849676068e-73, 5.87631906058237911832e-73, -1.20624977558917876545e-74, -1.49445976873718903299e-74, 2.98951758851794428593e-76, 3.80009003468317747975e-76, -7.41254528596240301878e-78, -9.66136569681660792757e-78, 1.83877047518411730588e-79, 2.45596388238760646123e-79, -4.56324361992318519809e-81, -6.24234535174298733999e-81, 1.13291752437599258328e-82},
            {0.112654320987654320988, 0.00347222222222222222222, 0.000763888888888888888889, -0.000117669753086419753086, -0.0000241323381204333585286, 3.34624590576971529352e-6, 7.67558823941099073374e-7, -9.0900879384675680972e-8, -2.36814875325477377746e-8, 2.40926210693326293775e-9, 7.10252548814624231858e-10, -6.2947350476886270311e-11, -2.08275624014164614919e-11, 1.63033282338103031813e-12, 6.00062747392810380337e-13, -4.19902185400254597372e-14, -1.70475096421074454861e-14, 1.07744199780289716144e-15, 4.78840878840722739981e-16, -2.75742281424325701761e-17, -1.33246202248802214247e-17, 7.04351536410352137731e-19, 3.67886117230751949937e-19, -1.79663732829836238012e-20, -1.008977754286839756e-20, 4.57783164795316834238e-22, 2.75148449215608946654e-22, -1.16543971708668123172e-23, -7.46617016708021438439e-24, 2.96500235480347633064e-25, 2.01716652970591828314e-25, -7.53913106244828966736e-27, -5.42900055832799339739e-27, 1.91611296333880786915e-28, 1.45618679061569094314e-28, -4.86807765249278640274e-30, -3.89394017317381141137e-30, 1.23639277864703273744e-31, 1.03841072674827383738e-31, -3.13934293222321083962e-33, -2.76229866455940923318e-33, 7.96931833298080158746e-35, 7.3314874155026275521e-35, -2.02263451982789362746e-36, -1.94186558573054839128e-36, 5.13261617301950075773e-38, 5.1336562710208097722e-38, -1.30225102215282237309e-39, -1.35481785714278014265e-39, 3.30364269090803635398e-41, 3.56976712619706594902e-41, -8.37993311128167612201e-43, -9.39194550377684039302e-43, 2.12541057186069598042e-44, 2.46759702882281692409e-44, -5.39019887122049111683e-46, -6.47496467009146422624e-46, 1.36688066647689047526e-47, 1.69700214002160844738e-47, -3.46596284440656623129e-49, -4.44265826321367176266e-49, 8.78795560479250124002e-51, 1.16184847863842950185e-50, -2.22805146652881024992e-52, -3.03549762323350254773e-52, 5.6485687918846264213e-54, 7.92336037296078705312e-54, -1.43195577569191620996e-55, -2.06638453252898371073e-55, 3.62995016626213297686e-57, 5.38463505590670135357e-57, -9.20138658937574508387e-59, -1.40205243600091895139e-58, 2.33232437155830393515e-60, 3.64798459754234308759e-60, -5.91165421605557187417e-62, -9.48503670182497169379e-62, 1.49835492789780957001e-63, 2.46454976259008683283e-63, -3.79758116715017004393e-65, -6.39974803025248102502e-65, 9.62469761584581755633e-67, 1.66084078768919873512e-66, -2.4392463917302279066e-68, -4.30769735987111016024e-68, 6.18178075534116263072e-70, 1.11667243760968621519e-69, -1.56661255652022832892e-71, -2.89321329294722806546e-71, 3.97008997481122329717e-73, 7.49236738251478449616e-73, -1.00607519711784392178e-74, -1.93932641634229816931e-74, 2.54948485332107746074e-76, 5.0174689366661759283e-76, -6.46051052076800246502e-78, -1.29756332227902979615e-77, 1.63709587494419355977e-79, 3.35420950198618731078e-79, -4.14834333381145102644e-81, -8.66715924603076725034e-81},
            {-0.03515625, -0.00336805555555555555556, 0.000512152777777777777778, 0.0000719049193751574703956, -0.0000190194712144116906022, -2.31402199511491839534e-6, 6.50898138962375073486e-7, 7.79200666137369480323e-8, -2.09182732659689730397e-8, -2.60260237467584931629e-9, 6.43587260481169041744e-10, 8.52355933404577924618e-11, -1.91995587339778256886e-11, -2.73292819136726470804e-12, 5.59935929463764894983e-13, 8.59040794403578406178e-14, -1.60510091017350531741e-14, -2.65267646178365018773e-15, 4.53939112588919283204e-16, 8.06423134813732023661e-17, -1.26990816803696619723e-17, -2.41818954436504725719e-18, 3.52103123004621617585e-19, 7.16472195063851462992e-20, -9.69007583785174035387e-21, -2.1004778278174215885e-21, 2.64994344292216557491e-22, 6.10072643578818365545e-23, -7.20753155526683638424e-24, -1.75729625970552588592e-24, 1.95114117266353774456e-25, 5.02454585881624394825e-26, -5.2601351481318741756e-27, -1.4271501448896122165e-27, 1.41293013646167346892e-28, 4.02948646259445857474e-29, -3.78298783478103015074e-30, -1.13157754626186709645e-30, 1.00992045236917410365e-31, 3.16219384718103858258e-32, -2.68907481184991498935e-33, -8.79731021915752516079e-34, 7.14315063165994918398e-35, 2.43743620540178335386e-35, -1.89339422821448480895e-36, -6.72796461315523751537e-37, 5.00884551925271429729e-38, 1.85067319910614798957e-38, -1.32266702844658260443e-39, -5.07441067643245492333e-40, 3.48692171277290376722e-41, 1.3872453988963247763e-41, -9.17842038793476441557e-43, -3.78202266355175082872e-43, 2.41255349856480452653e-44, 1.02844303651685341104e-44, -6.3330533855497280223e-46, -2.7899455284337123232e-46, 1.66041227618076144762e-47, 7.55157634701406591642e-48, -4.34831288600530271255e-49, -2.03970225536817478801e-49, 1.13752186425947311466e-50, 5.49842863192148993734e-51, -2.97277397391876848641e-52, -1.4794613490694996037e-52, 7.76164220787104941716e-54, 3.97381946053781334442e-54, -2.02469231748327989255e-55, -1.06560083711889200023e-55, 5.27715892324807433249e-57, 2.853000843077382009e-57, -1.37434965256259510684e-58, -7.6272173222346014493e-59, 3.57658700760431533606e-60, 2.03619987875456865587e-60, -9.30104941339297650679e-62, -5.42869530248010673694e-62, 2.41714386883069030675e-63, 1.44550554663637258856e-63, -6.27762040298030647855e-65, -3.84432172586795433851e-65, 1.62938287123593059769e-66, 1.02122148613784734069e-66, -4.22667995153183111011e-68, -2.70983796848417113347e-68, 1.09581036568395504264e-69, 7.18308894352467636639e-70, -2.8395019567480150956e-71, -1.90214528925836186753e-71, 7.35410534293145276489e-73, 5.03221689408193255676e-73, -1.9037413490740336582e-74, -1.33007389336671444303e-74, 4.92589749603696175343e-76, 3.51244385863813332137e-76, -1.27400309178845083535e-77, -9.26777920381656769e-78, 3.2936020187143827173e-79, 2.44336966612377841356e-79, -8.5112756745053411961e-81},
            {0.00534444444444444444444, 0.0000752314814814814814815, -0.0001508172713529856387, 0.0000222623771730914588057, 6.55743907645362671818e-6, -1.38739620076425631981e-6, -2.58249324901711866599e-7, 6.33277444356989811535e-8, 9.57938533402848078472e-9, -2.50792337575635296433e-9, -3.41265949653824700099e-10, 9.12396912222382533964e-11, 1.1795551901407713886e-11, -3.13514067832200626122e-12, -3.97861020427752801045e-13, 1.03376598341009257599e-13, 1.31445900536784436491e-14, -3.30380575648253783803e-15, -4.26505026161608851027e-16, 1.03026452969247694361e-16, 1.36197157281526906517e-17, -3.14980283749770685381e-18, -4.28770332986201296492e-19, 9.47388590155655807734e-20, 1.33268617073167367566e-20, -2.81076492531628438151e-21, -4.09472575147790301153e-22, 8.24246462815313488211e-23, 1.24506670873914582849e-23, -2.39290627913756179134e-24, -3.75015828945283756823e-25, 6.88642377885361822481e-26, 1.11986062468243705189e-26, -1.96662571977742036495e-27, -3.317881971193247456e-28, 5.57815822753217195558e-29, 9.75952082780150885358e-30, -1.57260751251313452487e-30, -2.85182249712005412556e-31, 4.40940848849987931258e-32, 8.28267815334575794195e-33, -1.2302724874754571747e-33, -2.39208665483813927819e-34, 3.41728841091278295863e-35, 6.87263293041244991951e-36, -9.45351284761827476268e-37, -1.96504829048519059352e-37, 2.60546990191606394899e-38, 5.59338333012275699863e-39, -7.15635392291191290805e-40, -1.58547846722491067394e-40, 1.95941603468076208439e-41, 4.47662838154372506982e-42, -5.34925943559738093663e-43, -1.25937786620658825996e-43, 1.45641338826415234043e-44, 3.530814540623768672e-45, -3.95532210786608770889e-46, -9.86730052533376118586e-47, 1.07166513242610425262e-47, 2.74921918709995131897e-48, -2.89723021459463937011e-49, -7.63807538802905450513e-50, 7.81652741561694983277e-51, 2.11637124896678439753e-51, -2.10477843099154614496e-52, -5.84921105795066373131e-53, 5.6573160283493422414e-54, 1.61272168658690628471e-54, -1.51799921218441547182e-55, -4.43642247351637394452e-56, 4.06659939914557575708e-57, 1.21777838305985917297e-57, -1.08774789201292626225e-58, -3.33589502888960941715e-59, 2.90534252289431828228e-60, 9.12029209761075675487e-61, -7.74945474404607967418e-62, -2.48884489314695124677e-62, 2.06433269919142993215e-63, 6.7798066633836464063e-64, -5.49225614884055392302e-65, -1.84375125876056187528e-65, 1.4595205850825685737e-66, 5.00594101599101973417e-67, -3.87419968495847304134e-68, -1.35705740993266954056e-68, 1.02727909835230146273e-69, 3.67340303998409119733e-70, -2.72113702662230867792e-71, -9.92941807949778002239e-72, 7.20090942337150963266e-73, 2.68033584463710499562e-73, -1.90378313521701539858e-74, -7.22584537953065617938e-75, 5.02872469995410295572e-76, 1.94555978620274969105e-76, -1.32716377497795045236e-77, -5.23212495679748951673e-78, 3.49971354121356500045e-79, 1.40542990697184966103e-79},
            {-0.000265239197530864197531, 0.000102473859914336104812, -9.0053382464096749811e-6, -9.47638250258951317152e-6, 1.55249133475406623555e-6, 5.3585570390211543811e-7, -1.10761476041884291043e-7, -2.49916019207761186755e-8, 5.90437164506822343841e-9, 1.04696975601750548495e-9, -2.68938976772450954305e-10, -4.09501688377128939654e-11, 1.10792856771750092139e-11, 1.52651570884194702856e-12, -4.25458741099979077648e-13, -5.48933643192193962558e-14, 1.55085899630133271438e-14, 1.91878404719357844053e-15, -5.42990337655118260459e-16, -6.55307676840127534883e-17, 1.84103183915828561935e-17, 2.19458586266897037944e-18, -6.08043408146829018622e-19, -7.22629649623971133962e-20, 1.9647935113202330852e-20, 2.34441877187475496014e-21, -6.23258565153272299293e-22, -7.50633921065658852482e-23, 1.94595639736264280371e-23, 2.37510014014053603482e-24, -5.99274565013662855837e-25, -7.43511201793190952273e-26, 1.82342922588853539154e-26, 2.30495736461979981376e-27, -5.48951007647613535135e-28, -7.08220796142003763598e-29, 1.63707782573511999119e-29, 2.15833796144606611474e-30, -4.84089078124002427108e-31, -6.5281802312089389434e-32, 1.42058236531409594628e-32, 1.96079537253439457097e-33, -4.14005142971119269379e-34, -5.85138809116185827667e-35, 1.19898496679197310146e-35, 1.73567512693324637615e-36, -3.45243738709400675912e-37, -5.1196206965156882766e-38, 9.88890197046479324867e-39, 1.50219700681645641057e-39, -2.81878556601105913348e-40, -4.38612372646552341358e-41, 7.99886577972632640485e-42, 1.27476994952143231606e-42, -2.26042516121419022061e-43, -3.68892858224813503447e-44, 6.36319069840458965186e-45, 1.06315470697620004982e-45, -1.7848323461278451737e-46, -3.0522608328116005687e-47, 4.98954352928834628619e-48, 8.73109645648024381188e-49, -1.39045966501447689627e-49, -2.48899243098357596443e-50, 3.86344533151643610374e-51, 7.07237216982111656719e-52, -1.07050058640104627403e-52, -2.00339472877543939038e-53, 2.9584554260439126517e-54, 5.65842559692263991473e-55, -8.15592786228740368131e-56, -1.59373186275952180542e-56, 2.24321484974997153826e-57, 4.47696745118548512977e-58, -6.15618547995360687144e-59, -1.25445791929070429196e-59, 1.68595423707052066409e-60, 3.5065699293056566252e-61, -4.60807188416035752708e-62, -9.77936294741300541654e-63, 1.25711430010018267086e-63, 2.72135131530708583407e-64, -3.42335490105250804319e-65, -7.55694314307708164755e-66, 9.30652376932742505556e-67, 2.09427696413977006013e-67, -2.52589728686932192031e-68, -5.79275325861694660031e-69, 6.84492061531196937796e-70, 1.59931215062433919519e-70, -1.85214707398915358909e-71, -4.4076900431081021641e-72, 5.00454627787646084075e-73, 1.21268748705326626762e-73, -1.35039937649269077168e-74, -3.33100656577325081355e-75, 3.63908752194180531115e-76, 9.13519702427020060996e-77, -9.79441518849557006108e-78, -2.50150738208930826583e-78, 2.63294550551499873164e-79},
            {-0.0000413002266288223528262, -6.72201751070798689846e-6, 7.58537082528484644887e-6, -7.15916189006466784245e-7, -7.07288936962908824381e-7, 1.12912075732241677408e-7, 4.50655138011811045567e-8, -8.92518012144324080372e-9, -2.35580694185641774551e-9, 5.32961982937903089915e-10, 1.09041668147927777122e-10, -2.70450575258368998709e-11, -4.64823955917654549155e-12, 1.23130833560268118604e-12, 1.86704431121145310756e-13, -5.18452931293794215728e-14, -7.1685468335436753672e-15, 2.05744165953230244396e-15, 2.65628429267034578014e-16, -7.79329615330148608119e-17, -9.56273343337235354499e-18, 2.84294948747938332996e-18, 3.36085365475507307043e-19, -1.00534863283406491943e-19, -1.15729033502017474876e-20, 3.46351121161756553999e-21, 3.91526778498460383318e-22, -1.16691471316546620504e-22, -1.30422210926158040975e-23, 3.85662483398486254547e-24, 4.28520189896762739051e-25, -1.25339562412285652892e-25, -1.39072650416995805703e-26, 4.01378864991275411634e-27, 4.4635442243658906508e-28, -1.26861617365878410152e-28, -1.41815033866983632674e-29, 3.96298531662428032829e-30, 4.46418942300798273616e-31, -1.22502625463023700055e-31, -1.39336245511095145508e-32, 3.75092659783725247593e-33, 4.31488436431812080755e-34, -1.13862483190373956544e-34, -1.32649814921078788008e-35, 3.42925892576868226349e-36, 4.05039604196382586036e-37, -1.0253791948936735531e-37, -1.22896378623713967986e-38, 3.04568905846688103865e-39, 3.70688249661980593298e-40, -8.99137937100669421408e-41, -1.11190296725246877208e-41, 2.63939666454943871767e-42, 3.31786424664676298138e-43, -7.70720850268901222775e-44, -9.85181688365739881839e-45, 2.2395552972466978749e-45, 2.9117963280663851248e-46, -6.47799983975719053437e-47, -8.5684741634951612367e-48, 1.86579068132382217077e-48, 2.51099462899599622979e-49, -5.35234423965971855113e-50, -7.32962687438553499848e-51, 1.52964254709434849634e-51, 2.13156511247844749404e-52, -4.35609135392585889594e-53, -6.17698352538239415222e-54, 1.23638330436134440929e-54, 1.78398027338507155336e-55, -3.49815522832184897484e-56, -5.13580874256555070053e-57, 9.86799495631117314383e-58, 1.47400004218267874684e-58, -2.77581741333698706897e-59, -4.21809493917887016352e-60, 7.78731936200786561339e-61, 1.20370980428056606882e-61, -2.1791063835585709746e-62, -3.4258363917079026014e-63, 6.08297753617633877034e-64, 9.72523896620876158626e-65, -1.69414835523033442878e-65, -2.75403348212593362336e-66, 4.70793786991681611836e-67, 7.78067101164227739741e-68, -1.30556198632914132144e-68, -2.19323336150446765833e-69, 3.61320240904138344165e-70, 6.16895012335890363593e-71, -9.98051596256606490621e-72, -1.73154095255897658352e-72, 2.75178861905930854206e-73, 4.85046971488699137055e-74, -7.57376401659119335037e-75, -1.35611613939266114475e-75, 2.08101064944645688053e-76, 3.78445031684059655736e-77, -5.70863149130215269013e-78, -1.05421869072855292374e-78},
            {5.18422067901234567901e-6, -2.80917890561574424008e-6, -9.60200341710758377425e-8, 5.7890145675082092831e-7, -6.17376709844355046375e-8, -5.55502835064033896066e-8, 8.8171992836685180414e-9, 3.83441731422291422837e-9, -7.39066511498169346494e-10, -2.18574763479267974428e-10, 4.78533302684271167204e-11, 1.09872931105422970479e-11, -2.63967123280679958051e-12, -5.05263796223130270983e-13, 1.30298899147891093643e-13, 2.17429482107857889788e-14, -5.92413879715218585123e-15, -8.88747265927525569175e-16, 2.5275235059992334067e-16, 3.48652386012360340366e-17, -1.02497555734912409135e-17, -1.3225073611381160103e-18, 3.98735610148033877985e-19, 4.87751247120092914646e-20, -1.49829353322088973073e-20, -1.7564072885642636368e-21, 5.46689574561689405869e-22, 6.1959138839359477281e-23, -1.94498201280361280755e-23, -2.14670076726271654014e-24, 6.76956419437742475683e-25, 7.32045639965974625909e-26, -2.31124914920685532003e-26, -2.4612450355463294464e-27, 7.75780970690409965967e-28, 8.170418326885366169e-29, -2.56474163039425672806e-29, -2.68120590905143990025e-30, 8.36450272207880358989e-31, 8.7067849294351005204e-32, -2.69468288380121637284e-32, -2.80033369196979514363e-33, 8.58506406180632915857e-34, 8.92725004288459744254e-35, -2.70756019458691126652e-35, -2.82274362943203897805e-36, 8.46031218962151827353e-37, 8.85780873672453928648e-38, -2.62118157671795317121e-38, -2.75999742447252855267e-39, 8.05749686938028190336e-40, 8.54319989880342715063e-41, -2.45896537933650688095e-41, -2.62810806877890410707e-42, 7.45388513241158737356e-43, 8.03785350067898690223e-44, -2.24540985089407121376e-44, -2.44488964942045610534e-45, 6.72473194066067548689e-46, 7.39836041270398248603e-47, -2.00302529181012343977e-47, -2.22788007397965418586e-48, 5.93580839563183700956e-49, 6.67791697328037557784e-50, -1.7506178015109831698e-50, -1.99290588889714770068e-51, 5.13978190373549787204e-52, 5.92276831585129542248e-53, -1.50263332784722953817e-53, -1.75324768074359692696e-54, 4.37542113083699973561e-55, 5.17040193122961251867e-56, -1.26922979542103530319e-56, -1.5193014366761258482e-57, 3.6686109626347225755e-58, 4.44910907656097416072e-59, -1.05678028974447734531e-59, -1.29860689457414562794e-60, 3.03433776327012412579e-61, 3.77850198604213897382e-62, -8.68577010445044239953e-63, -1.09611648383487551271e-63, 2.47903106290388028508e-64, 3.17061172082847559192e-65, -7.05576920485561370292e-66, -9.14596630037616095183e-67, 2.00286168123906430363e-67, 2.63126243399014275204e-68, -5.67091905466432328929e-69, -7.55078002901003950526e-70, 1.60176995936791099121e-70, 2.16149894928577240729e-71, -4.51373693061183147315e-72, -6.17296601141035392945e-73, 1.26912412190597359867e-73, 1.75892075147989025422e-74, -3.56076611355157260774e-75, -5.0008983506369752318e-76, 9.96991902698782682886e-77, 1.41883889824838600624e-77, -2.78601707830830334881e-78},
            {5.7818123248384859202e-7, 2.89980639889700736262e-7, -2.87297087923641154361e-7, 4.83622276326100279924e-9, 4.69814259285221065211e-8, -5.25278145033497613751e-9, -4.54687022673329898504e-9, 7.14728224374379647188e-10, 3.31497601519704179887e-10, -6.24356412738474521559e-11, -2.01949211811198957366e-11, 4.29944158389121498121e-12, 1.08625140575488394772e-12, -2.53527072203070347356e-13, -5.33187606097997065435e-14, 1.33791434588312417123e-14, 2.4399281366541466771e-15, -6.49132685547424739723e-16, -1.0562902525602717862e-16, 2.94793225906003403531e-17, 4.37165882884654977552e-18, -1.26896219700366874638e-18, -1.74311741966940095488e-19, 5.22559444537092582685e-20, 6.73559304786042590573e-21, -2.07306759030993473186e-21, -2.53381411748437577879e-22, 7.96598727826288037316e-23, 9.31302503234650880848e-24, -2.97772621846267733898e-24, -3.35416603492529233923e-25, 1.08657481616292462476e-25, 1.18654633119350179675e-26, -3.88152839431556803696e-27, -4.13086670502959763827e-28, 1.36063884000505053589e-28, 1.41763503490103825204e-29, -4.68968934477516289136e-30, -4.80235691448701430434e-31, 1.59198733231327253871e-31, 1.60776518925337238786e-32, -5.33036696626240351334e-33, -5.32486696065075892813e-34, 1.76253659734672878096e-34, 1.74619997515984627584e-35, -5.76173593650938517217e-36, -5.67428293349154338606e-37, 1.86386470772209232382e-37, 1.82831999922157934536e-38, -5.9714999907878593635e-39, -5.84488880928745576162e-40, 1.89618579144205250009e-40, 1.85486857185221603557e-41, -5.97161154717728601773e-42, -5.84613136542111612664e-43, 1.86624971805643502549e-43, 1.83074299251831962371e-44, -5.79086693823313264133e-45, -5.69844611196713217582e-46, 1.78491843357500786031e-46, 1.76362826238358334394e-47, -5.46738488215608472199e-48, -5.42896304611763007756e-49, 1.66492855196806956759e-49, 1.66269170973281743791e-50, -5.04218996089579961297e-51, -5.06765302380022914513e-52, 1.51911266564183853116e-52, 1.53747585086095040304e-53, -4.55444615434972871387e-54, -4.64423051334315035472e-55, 1.35916758766176245925e-55, 1.3970554346450990849e-56, -4.03840527275466174664e-57, -4.18592738538925160241e-58, 1.19493807447373403387e-58, 1.24946977989850581028e-59, -3.52185179517105294686e-60, -3.71610790866530096864e-61, 1.03412175001994201495e-61, 1.10140488504227648051e-62, -3.02569930309902972045e-63, -3.25360648931702894357e-64, 8.82279833912390710467e-65, 9.58079638801218545346e-66, -2.56437403787575471447e-66, -2.81262804294553502045e-67, 7.43043353763147426717e-68, 8.23283282504676245663e-69, -2.14666283538971830816e-69, -2.40304393321513268027e-70, 6.18423133221083969568e-71, 6.99513065846760570872e-72, -1.7767716607578790163e-72, -2.03093177069517430248e-73, 5.09155094519853761722e-74, 5.8816812465777258659e-75, -1.45541476619861137853e-75, -1.69923450741173292813e-76, 4.15034857936592415545e-77, 4.8976506487480862386e-78},
            {-1.14053948482685255172e-7, 7.23927154966216213611e-8, 1.53725457826738490519e-8, -2.65852152092438940365e-8, 1.17770608118467792964e-9, 3.92313856097802117611e-9, -4.55765382359573276681e-10, -3.82306650093853181082e-10, 5.9711014788079133953e-11, 2.90417912365196195204e-11, -5.36899711667330394169e-12, -1.86539731066231383338e-12, 3.8785767007448396359e-13, 1.06148149041856113052e-13, -2.41474971255810095875e-14, -5.51096698838047476202e-15, 1.3477090881232618197e-15, 2.66271016037703946535e-16, -6.91291827605499296279e-17, -1.21417112172997549045e-17, 3.31464467212998794045e-18, 5.2789932577314639968e-19, -1.50386143929616131243e-19, -2.20546361679967365485e-20, 6.51495316277318397802e-21, 8.90687613471926522074e-22, -2.71374251593215053074e-22, -3.49363403158531137852e-23, 1.09283287202685008644e-23, 1.33598039164676892773e-24, -4.27335225364762236794e-25, -4.99610755918317787609e-26, 1.62840603778795516908e-26, 1.83179097108358188065e-27, -6.06478574747214498132e-28, -6.59861163175629514883e-29, 2.2130789584966930157e-29, 2.33957373650953234818e-30, -7.92886769082545961303e-31, -8.17687158490907465926e-32, 2.79401972518402748371e-32, 2.8207752483836512167e-33, -9.69873669126963225684e-34, -9.61541914645467984265e-35, 3.32080341808649467645e-35, 3.24198019083412055996e-36, -1.12283272388593047285e-36, -1.08209636083722755362e-37, 3.75293628222090426609e-38, 3.57817531137563586348e-39, -1.24108146110367579576e-39, -1.17296907592165006666e-40, 4.06393999156485289619e-41, 3.81415279629613550976e-42, -1.31862012328638962655e-42, -1.23090984835811647055e-43, 4.24221692976617728707e-44, 3.94437013512243454943e-45, -1.35398653238898136833e-45, -1.25556351716101948653e-46, 4.28950801027309421982e-47, 3.97171488978221941128e-48, -1.34950516117308085999e-48, -1.24896178670423222212e-49, 4.21792922558186972931e-50, 3.90563638434054374165e-51, -1.31023479033077526602e-51, -1.21488174905588105897e-52, 4.04647687680328628073e-53, 3.76004637841402641111e-54, -1.24286305993712021022e-54, -1.15818382880616391435e-55, 3.79766407421421999961e-56, 3.55129433607482057665e-57, -1.15471663740206361616e-57, -1.08420907868838453506e-58, 3.49469535428247424728e-59, 3.29641771568877436188e-60, -1.05297831020109172977e-60, -9.98283450595408637983e-62, 3.15936272819803920484e-62, 3.01177201443483296186e-63, -9.44140362513431204031e-64, -9.0534921505619169817e-65, 2.81068133816035745283e-65, 2.71206890934122677862e-66, -8.3368130303988829095e-67, -8.09723086626699490697e-68, 2.46417937238658748284e-68, 2.40979700837200808626e-69, -7.259290586205829166e-70, -7.14967082391683309315e-71, 2.13170572756674206775e-71, 2.1149672944315723814e-72, -6.2406421141398512206e-73, -6.23850862831006803877e-74, 1.82160608641734183728e-74, 1.83511064785908407768e-75, -5.30217165121913710087e-76, -5.38381914906939989307e-77, 1.53912957028376659703e-77},
            {-9.28275160229795292213e-9, -1.01212167231362156807e-8, 9.53486248934435007621e-9, 8.09876660561779290053e-10, -2.43401906580239215417e-9, 1.47713428120529057144e-10, 3.35405270259019631268e-10, -4.00591523883978152824e-11, -3.28318668403428191185e-11, 5.10131475587512976018e-12, 2.57462854107328834248e-12, -4.68576505315250131418e-13, -1.72640986823438100673e-13, 3.5169618020436219008e-14, 1.03004420198551201045e-14, -2.290433106872868138e-15, -5.61337459087058491227e-16, 1.34061239780917103468e-16, 2.84549458650924872949e-17, -7.21557893885354686221e-18, -1.3595288101759684213e-18, 3.62868424001369542722e-19, 6.18308531506495469249e-20, -1.72501845817857621855e-20, -2.69713670692413224693e-21, 7.82035992857872981657e-22, 1.13518690149442896096e-22, -3.40421142116268763379e-23, -4.63196112499207203402e-24, 1.43060490577488164286e-24, 1.83938500166667336612e-25, -5.82963681533196128375e-26, -7.13132064908751419141e-27, 2.31177678977092380611e-27, 2.70647957712543512691e-28, -8.94816062616980053813e-29, -1.00772528835630737622e-29, 3.38921790259587470563e-30, 3.68808727976656624268e-31, -1.25884704844248715232e-31, -1.32887047239916440493e-32, 4.5935808649849028271e-33, 4.72052934230258701484e-34, -1.64939051216184773557e-34, -1.65519728841793084772e-35, 5.83564333866294949053e-36, 5.73479535667351279869e-37, -2.03691106083613910897e-37, -1.96515868393735738796e-38, 7.02159719911423349279e-39, 6.66567807086894221666e-40, -2.39270869898518274946e-40, -2.23961617880119671403e-41, 8.06674443820973400563e-42, 7.45876302371167983267e-43, -2.69269495375841782294e-43, -2.46363304114126023828e-44, 8.90530709106063478977e-45, 8.07472802396826906089e-46, -2.91975972085249243736e-46, -2.62740545409556419354e-47, 9.4955510583277816363e-48, 8.4910033700307962542e-49, -3.06467471947734139549e-49, -2.72641658087965915235e-50, 9.82056869353957552552e-51, 8.7012257746524413027e-52, -3.12576746393555886169e-52, -2.76098676783585742702e-53, 9.88573586336648565429e-54, 8.71310422135319689189e-55, -3.10773977645207228792e-55, -2.73542549493970213601e-56, 9.71409883758862562847e-57, 8.54534793729941260724e-58, -3.0200262349515484096e-58, -2.65698260697743767655e-59, 9.34087621692721154334e-60, 8.22423625444711158272e-61, -2.87503304306329606281e-61, -2.53476364482839580247e-62, 8.80801594893939200213e-63, 7.78028434844864600274e-64, -2.68650660313915739943e-64, -2.37873021896463895861e-65, 8.15943963006112068216e-66, 7.24531504064113628572e-67, -2.46818363092640607492e-67, -2.19886133739595244214e-68, 7.43731244120877254952e-69, 6.65011091049173359003e-70, -2.23278952458362272985e-70, -2.00451183972019425864e-71, 6.67943921131364297993e-72, 6.02270800694894911011e-73, -1.99138752673243899179e-73, -1.80397289801509049577e-74, 5.91772016435057869529e-75, 5.38730882599971227973e-76, -1.75303954539405342242e-76, -1.60421784571373621854e-77},
            {2.60229397185829064136e-9, -1.79782041333515515198e-9, -8.13654675119457420673e-10, 1.04917583267443598779e-9, 3.0543902645312814576e-11, -2.21938759725867749104e-10, 1.60585408988357557482e-11, 2.91826567033059318201e-11, -3.56432962003289113027e-12, -2.86672392197182556195e-12, 4.43657675525692417297e-13, 2.3059871539741928995e-13, -4.14131356275567129008e-14, -1.60239881523632786642e-14, 3.20656198641785761643e-15, 9.95400581861702517121e-16, -2.16884494977080408643e-16, -5.65823307720863200399e-17, 1.32241329233006364357e-17, 2.99271930569232562748e-18, -7.42310668107274960983e-19, -1.49114439909360972293e-19, 3.89375547182325420063e-20, 7.06530420728658812242e-21, -1.92985258117611558273e-21, -3.20692182208822525595e-22, 9.11451539985040549059e-23, 1.40258101479239561165e-23, -4.12940925540026243366e-24, -5.93880961731884030361e-25, 1.80428049301578007568e-25, 2.44389903909053261838e-26, -7.63608056186286388073e-27, -9.80560453870353119978e-28, 3.14158523956489993902e-28, 3.84629874839990150856e-29, -1.26021978636859729876e-29, -1.47836087211215643095e-30, 4.94161467079870520121e-31, 5.57870731797652005351e-32, -1.89828439873292696264e-32, -2.07029118476185136329e-33, 7.1571006926622300292e-34, 7.56669206548874617331e-35, -2.65278736687516904131e-35, -2.72714892832821420286e-36, 9.67996950159461891493e-37, 9.70339393460844769795e-38, -3.48172022895607932469e-38, -3.4117509913937329466e-39, 1.23578011673785979081e-39, 1.18644678459527600667e-40, -4.33253015022029916476e-41, -4.0838849882943171602e-42, 1.50167130196655188694e-42, 1.3923694704141344567e-43, -5.14969512597303828406e-44, -4.70502498638507998455e-45, 1.74850899839973791053e-45, 1.57666646820679345181e-46, -5.88180539402749941625e-47, -5.24214337504083511044e-48, 1.96137503585775424229e-48, 1.73009292285929442246e-49, -6.48702941687978386832e-50, -5.67027066187529208511e-51, 2.12899315737579154488e-51, 1.84619886572566137625e-52, -6.93642995381303021576e-53, -5.97373507092880028529e-54, 2.24442685424413236158e-54, 1.92152568485776599669e-55, -7.21510913698043591995e-56, -6.14621877757514087665e-57, 2.30513324001279588406e-57, 1.95546604811969335236e-58, -7.321519379817969251e-59, -6.18988955228630943306e-60, 2.31251548311304259653e-60, 1.9498793265757414467e-61, -7.26546376445224142352e-62, -6.11391474544942743139e-63, 2.27115088945174598603e-63, 1.90856015073156028779e-64, -7.06535108516851975211e-65, -5.93265664643591336925e-66, 2.18786699255672904861e-66, 1.8366487413081973294e-67, -6.7452111000899077937e-68, -5.66380415899409479059e-69, 2.07080869586646494299e-69, 1.74005419649139754067e-70, -6.33186051655244958215e-71, -5.32663348072781872575e-72, 1.92859908326422836075e-72, 1.62494112595331414138e-73, -5.85247763820043695153e-74, -4.94052421162125728349e-75, 1.76965515060159451124e-75, 1.49730966830779902236e-76, -5.33271964463386100406e-77},
            {1.5599404747590560183e-10, 3.19204835017540004352e-10, -2.93347208338223134959e-10, -6.22726810163826593899e-11, 1.085598544558534175e-10, -3.4741289476692839014e-13, -2.02790502517555072353e-11, 1.6440276594305397982e-12, 2.57567259383396722456e-12, -3.20392116949667975956e-13, -2.53726398638851270253e-13, 3.91433339969259338419e-14, 2.08391090940534472927e-14, -3.69969286644416888657e-15, -1.49220355836947169436e-15, 2.93934678423811708653e-16, 9.59688294388785059145e-17, -2.05322796494124118e-17, -5.6605704286407544639e-18, 1.29712586332730559459e-18, 3.10923838706968389404e-19, -7.55553645038320886024e-20, -1.60886341469345230553e-20, 4.11475010003030408084e-21, 7.91282168404198299997e-22, -2.11724504840106150295e-22, -3.72523622278469212953e-23, 1.03771216753803204149e-23, 1.6883033850051393631e-24, -4.87595298267691942138e-25, -7.40002916298637195505e-26, 2.20791003861464656656e-26, 3.14895955774498798123e-27, -9.67610703419053853211e-28, -1.30510083921410762423e-28, 4.11873774893875420268e-29, 5.28252180937003329926e-30, -1.7079467977605953663e-30, -2.09296646624442263695e-31, 6.91734210713581399701e-32, 8.13335002231899335186e-33, -2.74226754108548659448e-33, -3.10534242322478769058e-34, 1.06612630394716993459e-34, 1.16662939392031941855e-35, -4.07148120611821283839e-36, -4.31827126422755147415e-37, 1.52957060757793361507e-37, 1.57667804806471373887e-38, -5.65996975527727602927e-39, -5.68430385266845885916e-40, 2.06527309369291675062e-40, 2.02539032695216302075e-41, -7.43870536064766793837e-42, -7.13824171046388876365e-43, 2.6470698252488289403e-43, 2.49024652925358310842e-44, -9.31394239562247442469e-45, -8.60494176718714091851e-46, 3.24279316264142049784e-46, 2.94690685072658573225e-47, -1.11791771990420507633e-47, -1.00076480188148332446e-48, 3.81826682484410582115e-49, 3.37176908468491322014e-50, -1.29278489747309436655e-50, -1.12755603506230546015e-51, 4.3411721550431100817e-52, 3.74412790958740005373e-53, -1.44646338896165594784e-53, -1.23497574740168549242e-54, 4.78421078285425166472e-55, 4.04772694897575290657e-56, -1.57138936184422235961e-56, -1.31870321122098917487e-57, 5.12723443148922783968e-58, 4.27162859228537060283e-59, -1.6624627984608814048e-59, -1.3761585120972376233e-60, 5.35825136084877678722e-61, 4.41043485700296990878e-62, -1.7171968435440298165e-62, -1.40648145267157256573e-63, 5.47340722682030860775e-64, 4.46396623761713694064e-65, -1.7355738861088534899e-65, -1.41036120536159066027e-66, 5.47615786986944270607e-67, 4.43654429381545670746e-68, -1.71968792262706819974e-68, -1.38976529031604802512e-69, 5.37590408139931283307e-70, 4.33603298836911960112e-71, -1.67326014490493213602e-71, -1.34761562750228982334e-72, 5.18635677687088136462e-73, 4.1727814075905491805e-74, -1.60110770393855967774e-74, -1.28745307622073942737e-75, 4.92386298612796422809e-76, 3.95858481236522498103e-77},
            {-6.03648201373728122427e-11, 4.36134262614717112698e-11, 3.33458805708316834316e-11, -3.76949168080555500145e-11, -4.3559359037690029678e-12, 1.08678904742539657646e-11, -2.69130084488546911899e-13, -1.85968939347588835141e-12, 1.63502975574934387272e-13, 2.30017723748618824939e-13, -2.90541763022058810061e-14, -2.27110345980436533699e-14, 3.49485939568686455103e-15, 1.89797579110252558115e-15, -3.33594185473903084299e-16, -1.39431761794213222659e-16, 2.7082552554133971481e-17, 9.24199259147755950694e-18, -1.94502050126028044216e-18, -5.63189658094349198881e-19, 1.26752234711419056085e-19, 3.19971531993413707916e-20, -7.62924655416068994277e-21, -1.71317513547970740395e-21, 4.29689114451084571393e-22, 8.71741584785730285289e-23, -2.28706559354540642531e-23, -4.24422046877150543943e-24, 1.15937927570567911622e-24, 1.98798149773260324185e-25, -5.6323987825342373768e-26, -8.99895531447038244189e-27, 2.63560849666909309112e-27, 3.95159676172020713899e-28, -1.19290672944171915514e-28, -1.68862082177806326385e-29, 5.24074798537689696447e-30, 7.04114046410480375154e-31, -2.2414600822352131963e-31, -2.87151298968770728935e-32, 9.35669119290656405172e-33, 1.14763670308149188558e-33, -3.82047829611549179139e-34, -4.5027717620645845762e-35, 1.52877316123764603192e-35, 1.73699694895675693149e-36, -6.00510115682166073809e-37, -6.59696694813774670718e-38, 2.31891534981908569639e-38, 2.46962542468582893803e-39, -8.81452341907290072467e-40, -9.12257752424189508581e-41, 3.30188505548700046201e-41, 3.32822601640516686966e-42, -1.22017106779113229765e-42, -1.20028273620197316232e-43, 4.45221072750038820883e-44, 4.28212962457187535132e-45, -1.60541639645327020311e-45, -1.51230560234594826879e-46, 5.72509644755109093226e-47, 5.29045228865283322271e-48, -2.02049080604674859486e-48, -1.83427691531075274186e-49, 7.06120946883616695376e-50, 6.30637071607668183288e-51, -2.44509158067936295381e-51, -2.15100286874709216535e-52, 8.39324351290542138714e-53, 7.28176525783858217326e-54, -2.85752135046094937952e-54, -2.44758959482527357491e-55, 9.65303508741592864152e-56, 8.17156366579595677784e-57, -3.23689039136321126144e-57, -2.71070688765547345814e-58, 1.07781315754188242826e-58, 8.93729182125924593878e-60, -3.56500417484473074574e-60, -2.92954754962622790843e-61, 1.17170034585735237928e-61, 9.54954475887835575996e-63, -3.8277371977546258895e-63, -3.09642403452054391015e-64, 1.24324551692170381947e-64, 9.98928924042875917655e-66, -4.01580885244980486276e-66, -3.20700157934712942244e-67, 1.29031348560440749712e-67, 1.02480699839748623484e-68, -4.12497673299714619505e-69, -3.26021022338804296534e-70, 1.31233179951325643648e-70, 1.03273024880805186179e-71, -4.15573494699503664268e-72, -3.25790493650625254684e-73, 1.31013189315517838149e-73, 1.02368950975114918298e-74, -4.11264617943088082232e-75, -3.20435456989139420408e-76, 1.28569680929617600761e-76},
            {-2.64187450166103020858e-12, -9.50207659443050680757e-12, 8.59660653838926095172e-12, 3.15605237078738821369e-12, -4.3814777380246999106e-12, -2.71819504922714358187e-13, 1.06885399099776250161e-12, -4.30865536911489893329e-14, -1.71287840184135208777e-13, 1.60090812554927133457e-14, 2.0745693878775085085e-14, -2.65482861984086224491e-15, -2.05230895591429815639e-15, 3.15164775283304791316e-16, 1.74052683832722112851e-16, -3.03227268846290099335e-17, -1.3072273886859629139e-17, 2.50734162663015087369e-18, 8.89695995877634225553e-19, -1.8446642071334190807e-19, -5.58092954948479645836e-20, 1.23550938838189610797e-20, 3.26836397226522401761e-21, -7.65739867244392004692e-22, -1.80493018750134304564e-22, 4.44526071796188794123e-23, 9.47437095873918097657e-24, -2.43982194583636465944e-24, -4.75764561571447524477e-25, 1.2754921768785117059e-25, 2.29760549809039645498e-26, -6.38925780337440998521e-27, -1.07177305482859488588e-27, 3.08180648503658685031e-28, 4.84699054184390815474e-29, -1.43719341738528148724e-29, -2.13176324843351313051e-30, 6.50239327036771142101e-31, 9.14246049386121902391e-32, -2.86253249416271361834e-32, -3.83216995026785749534e-33, 1.22924509810174906571e-33, 1.57308650662356328727e-34, -5.1603908601585993918e-35, -6.33498779669491799279e-36, 2.12181231771340170744e-36, 2.50663800477320593297e-37, -8.55923450260029502121e-38, -9.7584274601247804543e-39, 3.39238376539252583762e-39, 3.74226133166394113498e-40, -1.32276813062898215794e-40, -1.41521217510569548701e-41, 5.08014841254865342991e-42, 5.28275612797902655852e-43, -1.92369192533590579551e-43, -1.94817213524716458648e-44, 7.18899274326528133407e-45, 7.10331902486205953701e-46, -2.65363594742669178195e-46, -2.56253552731933832846e-47, 9.68251585701597703372e-48, 9.15234119971499115533e-49, -3.49471005665237212019e-49, -3.2381914455759885774e-50, 1.24849238341636370461e-50, 1.13556792966003356601e-51, -4.41737811123036456722e-52, -3.94890520864118860198e-53, 1.54873924204315562394e-53, 1.3623496302568986961e-54, -5.38318727620982504334e-55, -4.66475064741807409759e-56, 1.85585400630080585776e-56, 1.58584965139697784514e-57, -6.34851176054473880309e-58, -5.35479048962451538468e-59, 2.15571334140885240208e-59, 1.7964357801375129459e-60, -7.2686880352040694953e-61, -5.98964740572100672373e-62, 2.43450653794977328332e-62, 1.98533361673076377706e-63, -8.10195293501038630167e-64, -6.54368399404436373358e-65, 2.67989152606065568288e-65, 2.14523048712269406487e-66, -8.81272132796800023018e-67, -6.99660999041677057981e-68, 2.88188877138731572772e-68, 2.27068184257450037308e-69, -9.37391182387958140366e-70, -7.33443771191184106976e-71, 3.03344942043637140719e-71, 2.35831010015234330051e-72, -9.76820677683397190035e-73, -7.54979650985529853884e-74, 3.13068743266115736717e-74, 2.40681101379823615729e-75, -9.98828669963511651531e-76, -7.64168474190536555663e-77},
            {1.4145008517316864803e-12, -1.04101326453083759103e-12, -1.2093184541557034347e-12, 1.27067626360088350818e-12, 2.74733767198654070222e-13, -4.80851201264519179614e-13, -1.33478322513558521462e-14, 1.04052818219238458773e-13, -5.42651322100181365239e-15, -1.58470992155578606086e-14, 1.55396270058242693804e-15, 1.88694084979676865716e-15, -2.4420076202977740695e-16, -1.86977507886859634194e-16, 2.86642984806746015226e-17, 1.60584404843870441511e-17, -2.77574869823290193176e-18, -1.22953810390688324985e-18, 2.3316990704433674772e-19, 8.56607476198812680728e-20, -1.75206330069677555798e-20, -5.51423058732317776463e-21, 1.20239226084880770541e-21, 3.31886323610664948569e-22, -7.6504659922141492359e-23, -1.88515582075102332354e-23, 4.56456238896328419842e-24, 1.01815515338842216889e-24, -2.57640988649132449921e-25, -5.26073156003447735752e-26, 1.38546443883743033137e-26, 2.61361312338056772188e-27, -7.13887379252244571743e-28, -1.25382989965600137579e-28, 3.54140120451088277995e-29, 5.82898999853073977277e-30, -1.6980656001393441593e-30, -2.63410149509102626869e-31, 7.89635849871225949696e-32, 1.16010681626240715877e-32, -3.57141504607851871822e-33, -4.99090424241876491479e-34, 1.57496713357715294022e-34, 2.10154895677841420173e-35, -6.78666243980878572954e-36, -8.67633679082479326975e-37, 2.86294929374127212143e-37, 3.51753521785055916226e-38, -1.18430882513186282976e-38, -1.40229245346712319908e-39, 4.81114904949119925045e-40, 5.50383142847256596726e-41, -1.92191219758705251338e-41, -2.12907397961915550259e-42, 7.55835527694059171495e-43, 8.12531378303689469425e-44, -2.92945166172801638268e-44, -3.06193650910245756752e-45, 1.12001002812717412705e-45, 1.14026365379002972628e-46, -4.22771880885867281974e-47, -4.19934785715510367481e-48, 1.57680006636986615033e-48, 1.53042521023064348506e-49, -5.81488423204763507482e-50, -5.5227750145593156432e-51, 2.12168210730182115635e-51, 1.97449817742446441595e-52, -7.66393120528974893805e-53, -6.99728764971286764463e-54, 2.74214948058384580121e-54, 2.45911123919621279901e-55, -9.72335865213304498603e-56, -8.57409223552497853175e-57, 3.41843800085747939763e-57, 2.9670956473301204102e-58, -1.19209473941710128795e-58, -1.01945361055464507074e-59, 4.12512675732281408383e-60, 3.47891225049069046696e-61, -1.41698993145350711635e-61, -1.17949651329658427835e-62, 4.83334148626069450529e-63, 3.97424491268522099026e-64, -1.6376368901779028717e-64, -1.33117859868274088769e-65, 5.51322982184289762284e-66, 4.43356250938678336957e-67, -1.84473267584082889669e-67, -1.46861523445518268632e-68, 6.13638289396162890325e-69, 4.83948545204780277824e-70, -2.02977956451240519572e-70, -1.58678304939171798587e-71, 6.6779319142532631284e-72, 5.17784211593902263944e-73, -2.18567254592604678298e-73, -1.68179676750454252847e-74, 7.1181319127731448245e-75, 5.4383548385793185323e-76, -2.30710602020492571319e-76},
            {4.37981647583129266798e-14, 2.72764540578612335976e-13, -2.43568997075779753032e-13, -1.34425131071111192379e-13, 1.64657571799268852184e-13, 2.2365025750909409711e-14, -5.09529134906979763263e-14, -1.91667128760981067989e-16, 1.00702985375235298661e-14, -6.19495307406920805946e-16, -1.47251177318504080163e-15, 1.50110489051935440704e-16, 1.72883226645170617278e-16, -2.25940382197135095672e-17, -1.71555011860305458334e-17, 2.62623068993986253556e-18, 1.4895893149095241223e-18, -2.55677615926838895075e-19, -1.16001625247408473808e-19, 2.17730729616119753583e-20, 8.25153250199103715448e-21, -1.66684446081968764855e-21, -5.4367210377436120418e-22, 1.16905794678233297089e-22, 3.35436018753412432061e-23, -7.61673421252600792571e-24, -1.95493932343540530575e-24, 4.65902043529790735204e-25, 1.08386650025252062401e-25, -2.69793971470644684402e-26, -5.74993473932520542229e-27, 1.48899512819769476751e-27, 2.93291804416141697173e-28, -7.87523117654167617478e-29, -1.44431147049207566385e-29, 4.00983354832384344764e-30, 6.89056798350468789326e-31, -1.97311868000153649284e-31, -3.19431319452962346342e-32, 9.41382586204676956664e-33, 1.44260709508998574125e-33, -4.36704017304965656075e-34, -6.36123767638462103239e-35, 1.97458036777320872917e-35, 2.74417771445711654092e-36, -8.72072612726195333812e-37, -1.16014522939327065916e-37, 3.76904923276785384593e-38, 4.81402564072567742329e-39, -1.59672020951826763685e-39, -1.96333023836116521471e-40, 6.64018222219147400628e-41, 7.87947416613952235772e-42, -2.71427073627187628759e-42, -3.1152698838126357913e-43, 1.09183568894026202309e-43, 1.21455484498653101169e-44, -4.32663669710513961596e-45, -4.67357164822397170083e-46, 1.69062159752657524644e-46, 1.77640611049760599803e-47, -6.5195915572964155634e-48, -6.67446920202450676798e-49, 2.48321067255578936582e-49, 2.48064064469886688156e-50, -9.34839865835743686711e-51, -9.125366287430541137e-52, 3.48077656253399807589e-52, 3.32445655119321759261e-53, -1.28260097753198328441e-53, -1.20005116286779534526e-54, 4.6797615206029560606e-55, 4.29432365984585188298e-56, -1.69158590657698578367e-56, -1.52404217761335514986e-57, 6.06048183573467544512e-58, 5.36640430900556223546e-59, -2.15304151638809334526e-59, -1.87550428338084112008e-60, 7.58761866368767036358e-61, 6.50808748967031268386e-62, -2.65356486595476063521e-62, -2.24300958823241064613e-63, 9.21249065394653485818e-64, 7.680392681250403951e-65, -3.17606461699649342352e-65, -2.61356672751673098863e-66, 1.08767452547978596569e-66, 8.84090903111981662943e-68, -3.70109176414993949971e-68, -2.97359178161712331884e-69, 1.2516938505785620973e-69, 9.94690710054693013892e-71, -4.20835812954154513972e-71, -3.3098785728435582277e-72, 1.40694112454307299848e-72, 1.0958286335704994834e-73, -4.6782573747017270773e-74, -3.61047094797258862989e-75, 1.54749036724897191148e-75, 1.18400868579143725914e-76},
            {-3.33913910947334977356e-14, 2.4539962496706656223e-14, 4.07813255664031171612e-14, -4.09042978813640634679e-14, -1.35836553719859651784e-14, 1.9734131779004823703e-14, 1.6943605815511091688e-15, -5.27702803270869672467e-15, 7.43078541903822600395e-17, 9.71405120781892189518e-16, -6.71637503146121868714e-17, -1.37389860578671975353e-16, 1.44629999301728908997e-17, 1.59407411278071250969e-17, -2.10130640924463705839e-18, -1.58380181537639908732e-18, 2.42160393557287157077e-19, 1.38842449856027804492e-19, -2.36811639613536847549e-20, -1.0975925030229261924e-20, 2.04087669451842440743e-21, 7.95421928348064671372e-22, -1.58850467495173265266e-22, -5.35208370839597681054e-23, 1.13610199871836384944e-23, 3.37751330161175954402e-24, -7.56273629775504447977e-25, -2.01535706398487795382e-25, 4.73235670994513007474e-26, 1.14466938592527753941e-26, -2.80561880479183177708e-27, -6.22273714706504609887e-28, 1.58599590253001588454e-28, 3.25290205618974752249e-29, -8.59373711791153488332e-30, -1.64156150806558885496e-30, 4.48311347542589707112e-31, 8.02420016758712792166e-32, -2.26002331289605594002e-32, -3.81035539004520822866e-33, 1.10449890942270134582e-33, 1.7621525001298513712e-34, -5.24723782475337593899e-35, -7.9541407662120933698e-36, 2.42911181493157398306e-36, 3.51121105458158793971e-37, -1.09805645007327041547e-37, -1.51837515305489210654e-38, 4.85582725059723268395e-39, 6.44200989097492131802e-40, -2.1041315774938905451e-40, -2.68518644898481112287e-41, 8.9471699773523666199e-42, 1.10095021364952506999e-42, -3.73823905315516694819e-43, -4.44505854051218719254e-44, 1.53647361228179178114e-44, 1.76902552896552388446e-45, -6.21896462130458573343e-46, -6.94588174972130826036e-47, 2.48119504802396244645e-47, 2.69284724932824108402e-48, -9.76630852495867165117e-49, -1.03159724959207884483e-49, 3.79550967851726057519e-50, 3.9076720069691595737e-51, -1.4574502469208929793e-51, -1.4645567540063295355e-52, 5.53336028192984659313e-53, 5.43404463937551859871e-54, -2.078356153869047649e-54, -1.99709231446842136649e-55, 7.72734256941021277912e-56, 7.27348281405765903431e-57, -2.84540552466821001972e-57, -2.62634355951269155917e-58, 1.03817315118021983959e-58, 9.40603658868119234216e-60, -3.75491113330917493952e-60, -3.34253517460872220189e-61, 1.34682969787155066545e-61, 1.17900574839034515803e-62, -4.79264561671437779668e-63, -4.12925964143168705961e-64, 1.69255470821082180841e-64, 1.43641774814714334621e-65, -5.93416655745103670187e-66, -4.96442214354035888879e-67, 2.06614985480159950953e-67, 1.70511997098751375456e-68, -7.14621075311717489387e-69, -5.8217149078074477449e-70, 2.45595669725093247616e-70, 1.97633830984665565231e-71, -8.38896139309369185909e-72, -6.67243431961281200631e-73, 2.84867794410731142072e-73, 2.24084841842327634167e-74, -9.61889310132999865577e-75, -7.48743275478021931848e-76, 3.23032846066464411863e-76},
            {-6.8325685152587533816e-16, -7.64066832503569235094e-15, 6.73175742751636427104e-15, 5.18057391379560452949e-15, -5.86540355731829474506e-15, -1.28311691088297011433e-15, 2.24955971332051390584e-15, 1.16258588947362517196e-16, -5.38125755941432018933e-16, 1.50304461888121014852e-17, 9.35451060033377046256e-17, -7.06133236094001411442e-18, -1.28683405531673187935e-17, 1.39181655643107852971e-18, 1.47807055114779288556e-18, -1.96332351939821103602e-19, -1.47016403436598279097e-19, 2.24552173055650555241e-20, 1.29974658200063565032e-20, -2.20422129917585168047e-21, -1.04134899113671851137e-21, 1.91971011318621083786e-22, 7.67421207232079609622e-23, -1.51649462438011892913e-23, -5.26306864586667807266e-24, 1.1039165675880565649e-24, 3.39055071602921139312e-25, -7.49361287976459775644e-26, -2.06743354274104378546e-26, 4.78780920252171866937e-27, 1.20074688294754242017e-27, -2.90067428194571023582e-28, -6.6774528436995469696e-29, 1.67653278767563325931e-29, 3.57138582678092514079e-30, -9.29100352508998511437e-31, -1.84405111904011957151e-31, 4.95781091003429279527e-32, 9.22216889598657119071e-33, -2.55657658002730382766e-33, -4.47963012426986516865e-34, 1.27794848585828229559e-34, 2.118697595377008846e-35, -6.20894876587500563853e-36, -9.77803696092462640665e-37, 2.93893071268484909251e-37, 4.41182590017902863716e-38, -1.35806361333732828185e-38, -1.94941254733101323619e-39, 6.13761404784717961305e-40, 8.44817214929944328007e-41, -2.71724618781293954387e-41, -3.59568517498959825283e-42, 1.18014265077227244102e-42, 1.50483003946525457583e-43, -5.03474781229685991213e-44, -6.19948417937321335931e-45, 2.11234274815989651616e-45, 2.51661258180440129115e-46, -8.7247239073347961151e-47, -1.0075364254562744066e-47, 3.55103022056608333687e-48, 3.98148241983744232692e-49, -1.42544300898325621185e-49, -1.55415301352020170046e-50, 5.64784422743039950298e-51, 5.99660719899899250473e-52, -2.21038707174235947928e-52, -2.28851544612631829251e-53, 8.55059277782845733509e-54, 8.64351318223313473354e-55, -3.27139335115013971869e-55, -3.23256457405258953766e-56, 1.23857880490952592111e-56, 1.1976757905765467333e-57, -4.64297076714268126539e-58, -4.39810239479819098258e-59, 1.72409039563778443674e-59, 1.60143728350478337758e-60, -6.34470039210725315023e-61, -5.78421751940709952511e-62, 2.31489200715445364054e-62, 2.07314239887609619422e-63, -8.37698954726727586951e-64, -7.37585719222691047428e-65, 3.00774217986643022505e-65, 2.60575707191060467751e-66, -1.07185511181642455232e-66, -9.14373557784491216754e-68, 3.79238498654481728692e-68, 3.18789299663507170517e-69, -1.33259746248073443681e-69, -1.10455832825985252518e-70, 4.65175905645413414198e-71, 3.8043983219821597472e-72, -1.61354563739168382704e-72, -1.30285744090066662477e-73, 5.56286518059438147541e-74, 4.43727856168134462798e-75, -1.906646960684752038e-75, -1.50326385644501054849e-76},
            {7.92926784750291544318e-16, -5.72298526523881991414e-16, -1.31027530449019056822e-15, 1.27155946403015675942e-15, 5.90286336966107303303e-16, -7.64242280161038252322e-16, -1.14617588965957929214e-16, 2.47816592463919099133e-16, 6.62710110797329819526e-18, -5.42867405423177890532e-17, 2.1190220977525104617e-18, 9.00209748352842131571e-18, -7.27920320715397085019e-19, -1.2096078399543927773e-18, 1.33893123095092853798e-19, 1.37733301359467684442e-19, -1.84202878230751923727e-20, -1.37130888458820334233e-20, 2.09265633871649050074e-21, 1.22150069425746935111e-21, -2.06077787844613901555e-22, -9.90501236818924172574e-23, 1.81158779749321319741e-23, 7.41109867647019950857e-24, -1.45026483664701557155e-24, -5.17172367786188207728e-25, 1.07275171142186118017e-25, 3.39533074931767456823e-26, -7.41340371380284763652e-27, -2.11211978242566550785e-27, 4.82817107614044310054e-28, 1.25233540823731445038e-28, -2.98430386380960580512e-29, -7.11305871807634884748e-30, 1.76078064561560674958e-30, 3.88658830407700033861e-31, -9.96464337336828116257e-32, -2.0503940768371260321e-32, 5.43102506389411810823e-33, 1.04767980178998046866e-33, -2.86073442724806122657e-34, -5.19913408224053353923e-35, 1.4606742682228073721e-35, 2.51180554882933638502e-36, -7.24842486219343660563e-37, -1.18388916292698291208e-37, 3.50382001111883724461e-38, 5.45404538703147282205e-39, -1.65319252755756419951e-39, -2.45998467802839196042e-40, 7.6271928150571802411e-41, 1.0879241818301253513e-41, -3.44633266923951870059e-42, -4.72386967517575488858e-43, 1.52728427556467609575e-43, 2.0162915194723155542e-44, -6.64674913854223200973e-45, -8.46911302760471209824e-46, 2.84398760562233915302e-46, 3.50413589035967217644e-47, -1.1976504948393305778e-47, -1.42946327794939117828e-48, 4.9685540220943126961e-49, 5.75401106388642230357e-50, -2.0323780139165458508e-50, -2.28718010761874999407e-51, 8.20348293598987836273e-52, 8.98382915485341860514e-53, -3.26984757503644926324e-53, -3.48922920176300046314e-54, 1.28790186780171714039e-54, 1.34078252780905013262e-55, -5.0157034610861278057e-56, -5.10014611476376004085e-57, 1.93251137350665439552e-57, 1.92140764326985797892e-58, -7.3702512335826273233e-59, -7.17249868891353309581e-60, 2.78371544901882753176e-60, 2.65413313659150282492e-61, -1.04171029980011109659e-61, -9.73980914380480236333e-63, 3.86395688971388452674e-63, 3.54581587742395522664e-64, -1.42118957043825579821e-64, -1.28106639266212426045e-65, 5.18520713857210909114e-66, 4.59471666662937466228e-67, -1.8772589571512196129e-67, -1.63647885747079594662e-68, 6.74631183248544811891e-69, 5.78963658877708726396e-70, -2.40726723880117279692e-70, -2.03515994951870722652e-71, 8.53142205000637579375e-72, 7.10987954510591925206e-73, -3.00382075427269330797e-73, -2.46914200213858268276e-74, 1.05097297838750370453e-74, 8.52604752303491901624e-76, -3.65491502778507946315e-76},
            {9.20315678026061585125e-18, 2.10349341874377616609e-16, -1.82513528032684653138e-16, -1.86853855006699781423e-16, 2.0041111780852530049e-16, 6.24016632646068510195e-17, -9.34815723092797602859e-17, -9.70316913064619849401e-18, 2.66453362344093849709e-17, 2.04657521206180002817e-19, -5.43471865157819611677e-18, 2.61734909536196955064e-19, 8.66267189555300405006e-19, -7.40498025392115018337e-20, -1.14079370856742919118e-19, 1.28832988015086169576e-20, 1.28916968858997236019e-20, -1.73471385768540795956e-21, -1.28465935189701251323e-21, 1.95890144558315778133e-22, 1.15204628680858596573e-22, -1.93438998805099596718e-23, -9.44379484687946494754e-24, 1.71467424029493595998e-24, 7.16418296010097360806e-25, -1.38929019625518632292e-25, -5.079567530287992369e-26, 1.04275827276954137011e-26, 3.39339864036605097218e-27, -7.32528006173715874669e-28, -2.15028393004566420115e-28, 4.85583790138900738098e-29, 1.29970190012980203141e-29, -3.05764615849948122568e-30, -7.52905097722258151381e-31, 1.83898816009413131031e-31, 4.19708147193413235258e-32, -1.06130882753757361816e-32, -2.25935220203509864129e-33, 5.90034146176829085515e-34, 1.17806276383742858286e-34, -3.17062968123422819662e-35, -5.96558922835712184052e-36, 1.65162598995670634622e-36, 2.94070906013433171161e-37, -8.36141031716321343634e-38, -1.41403622890941028338e-38, 4.12305307371150819914e-39, 6.64469310355077245717e-40, -1.98420859467558969032e-40, -3.05637018959833340749e-41, 9.3357004936143300338e-42, 1.3781319095570464808e-42, -4.30108982090428257434e-43, -6.09962173873873855401e-44, 1.94309062371858183054e-44, 2.65314104814400855209e-45, -8.61868481145845220239e-46, -1.13535753831703723027e-46, 3.75768350801356788777e-47, 4.78461269095888596179e-48, -1.61206490826997472999e-48, -1.98743135685150620035e-49, 6.81144785684920814458e-50, 8.1437567560755319995e-51, -2.83704834867658132147e-51, -3.29436158745623972392e-52, 1.16575860600879954843e-52, 1.31653277006813567903e-53, -4.7291295608527222465e-54, -5.20094811468603486791e-55, 1.89528919918213036272e-55, 2.03225926141595054346e-56, -7.50861758551399954144e-57, -7.85882580937216101756e-58, 2.9422735231338068654e-58, 3.00910377610340682995e-59, -1.14097150186570085733e-59, -1.14135571571707991305e-60, 4.38075472366719561937e-61, 4.2904067851517800559e-62, -1.66611224378424495694e-62, -1.59899059538885150276e-63, 6.27951360180080118267e-64, 5.91055132993830432002e-65, -2.34631932213974495297e-65, -2.16769747335714466582e-66, 8.69459335623810447729e-67, 7.89045577817818794105e-68, -3.19642029196692503008e-68, -2.85150020556119365584e-69, 1.16619964527689639966e-69, 1.02338611914020090666e-70, -4.22386156388487757535e-71, -3.64854522715865850797e-72, 1.51914614459247693242e-72, 1.29248745503672209666e-73, -5.42700941502535720083e-74, -4.55056322506986284116e-75, 1.92621160221984140985e-75, 1.5927074937810473934e-76},
            {-1.89222798416278517997e-17, 1.3210231331138384812e-17, 4.06676792695666806105e-17, -3.84585205428251897976e-17, -2.36052114339201748702e-17, 2.82622024240356614584e-17, 6.23057849052247669554e-18, -1.09399108443113192019e-17, -7.72532134234168119827e-19, 2.81445355553533434911e-18, -2.08418182382839064693e-20, -5.41085138472115267116e-19, 3.01988471627679627012e-20, 8.33930476597499816867e-20, -7.46376026121240507144e-21, -1.07920380342015791774e-20, 1.24034381595753032309e-21, 1.21147311211607589887e-21, -1.63921263500500854145e-22, -1.20819157399813283404e-22, 1.84104537033623477981e-23, 1.09005994795929688759e-23, -1.82235204794487697111e-24, -9.02411443584688815859e-25, 1.62744376617515064569e-25, 6.93261634063885415304e-26, -1.33308189389390672482e-26, -4.98771970542887822826e-27, 1.01401799421262343136e-27, 3.38603703479487219344e-28, -7.23172850726860233879e-29, -2.18270936616821835799e-29, 4.87285622289438979762e-30, 1.34312755337417949709e-30, -3.12176419219915561067e-31, -7.92532607475371855228e-32, 1.9114513038168184508e-32, 4.50174467849865279827e-33, -1.12354297017903118165e-33, -2.46983384617856557631e-34, 6.36378312325387851262e-35, 1.31265385377129630162e-35, -3.48457930867370978431e-36, -6.77555363655492350797e-37, 1.84978105642730207211e-37, 3.40436953301672047186e-38, -9.5433009081435119601e-39, -1.6683989782167696315e-39, 4.79547112421914875387e-40, 7.98938637935122071852e-41, -2.35156543601458768476e-41, -3.74433404779565449993e-42, 1.12725848442728130574e-42, 1.71992789355603455813e-43, -5.29054020586632726452e-44, -7.75328863180969878572e-45, 2.43438148058221008516e-45, 3.43410679474977537346e-46, -1.09959557975971666214e-46, -1.4960941599580582875e-47, 4.88119026886739100614e-48, 6.41719391006336829794e-49, -2.13164505544738326506e-49, -2.7124376357533126256e-50, 9.16661758117943975442e-51, 1.13072638799464653401e-51, -3.88492177409965355846e-52, -4.65226393482331056811e-53, 1.62396762091797876547e-53, 1.8905155359179294658e-54, -6.70054026034248171417e-55, -7.59245275894264272422e-56, 2.73067780805815809075e-56, 3.01526783944671273828e-57, -1.09983618577467462885e-57, -1.1848103697263373355e-58, 4.3805766155702045244e-59, 4.60862267435912490751e-60, -1.72627970649985725442e-60, -1.77540565416792673288e-61, 6.73414223158676388432e-62, 6.77671098168429490226e-63, -2.60162394516323714399e-63, -2.56397193664164299883e-64, 9.95828022797606799649e-65, 9.61937560103358890102e-66, -3.77812212569340478505e-66, -3.5799382133003382203e-67, 1.42128946084796074758e-67, 1.32204175525285952941e-68, -5.30342963753600570031e-69, -4.84610479106183658725e-70, 1.96355138388737333306e-70, 1.76379118667659758434e-71, -7.21562141182089326303e-72, -6.37572279714344660071e-73, 2.63255889162960361842e-73, 2.28956889879366442455e-74, -9.53838599505853695548e-75, -8.17010613401189230554e-76, 3.43302458899491411788e-76},
            {-7.52798091638810559286e-20, -5.71727603855561360638e-18, 4.87244187448442325612e-18, 6.42640074073546531631e-18, -6.62294182764237328009e-18, -2.74312692716653926196e-18, 3.69877614714610249413e-18, 5.93197838181300444829e-19, -1.23967919739575442795e-18, -5.64996972902798819646e-20, 2.93347870483993583497e-19, -5.77100773473696594139e-21, -5.3655748770668299038e-20, 3.34448574855476740766e-21, 8.0333611692952581493e-21, -7.47373292321052999044e-22, -1.02384729631076448112e-21, 1.19509129328902230888e-22, 1.14257177665766105047e-22, -1.55377407820355259537e-23, -1.14029595029108451373e-23, 1.73654303572019199603e-24, 1.0344638726564599916e-24, -1.72248557342553819108e-25, -8.64107121551243503924e-26, 1.54862139268378929575e-26, 6.71548162985525462841e-27, -1.28119214147339476271e-27, -4.89699802436211702113e-28, 9.8656475269523747177e-29, 3.37430958472302028875e-29, -7.1346957444446947627e-30, -2.21009725434023840219e-30, 4.88096982314539651825e-31, 1.38289645229459165152e-31, -3.17763777370477893212e-32, -8.30208350860477401881e-33, 1.97849351487853408791e-33, 4.79972106557115602681e-34, -1.18312836155100517338e-34, -2.68088780080695695295e-35, 6.81976022790351236627e-36, 1.45078356719693692113e-36, -3.80108391528872129613e-37, -7.62551315766072376862e-38, 2.05415981211072928369e-38, 3.90153249595962153577e-39, -1.07892804328224579701e-39, -1.94694136474718263795e-40, 5.51955823936753279893e-41, 9.4925609754461926495e-42, -2.75543071490388805508e-42, -4.52908263757044539231e-43, 1.34456081781636155627e-43, 2.11762612476542128048e-44, -6.42295127774931767361e-45, -9.71532844858779115701e-46, 3.00776990191085939155e-46, 4.37865010353712404139e-47, -1.38244089915933337727e-47, -1.94069631183816247979e-48, 6.24348939345062670309e-49, 8.46699819784332233315e-50, -2.77351514213431362323e-50, -3.63948844590210415218e-51, 1.21300147651625029407e-51, 1.54256348167558139161e-52, -5.22746465786806819073e-53, -6.45152192720862538124e-54, 2.22157542983056602952e-54, 2.6643855315713625465e-55, -9.31720089689143273824e-56, -1.08723724911104959272e-56, 3.85881902902410286117e-57, 4.38631775232891888437e-58, -1.57919710592906343325e-58, -1.75049960060129715309e-59, 6.38969464646938366938e-60, 6.91402589213825497149e-61, -2.55750731100380182119e-61, -2.70403765402166890634e-62, 1.01312218718937396121e-62, 1.04760861490127186213e-63, -3.97388701351874355368e-64, -4.0222512761453363624e-65, 1.54406388542602351454e-65, 1.53105510389243855155e-66, -5.94547121897573876527e-67, -5.7799094629291422274e-68, 2.26956531635760571734e-68, 2.164747483714009734e-69, -8.59188479861141777739e-70, -8.04614639053950992787e-71, 3.2267713706999286007e-71, 2.96888493311231114285e-72, -1.20259110071694804318e-72, -1.08779296385539066942e-73, 4.4490363475647928736e-74, 3.95878815233468632182e-75, -1.63430431896477236549e-75, -1.43136577752475375438e-76},
            {4.53463379458858310562e-19, -3.01684904568315797534e-19, -1.22991053742172528117e-18, 1.13767722970728813938e-18, 8.8975543574499761288e-19, -1.00659233819239960401e-18, -2.9958044215772747898e-19, 4.5900589946359667922e-19, 5.40511192233194687252e-20, -1.37119379635170208162e-19, -3.56112334727952592824e-21, 3.02660435508481642849e-20, -9.03929794072309548314e-22, -5.30520225770349902152e-21, 3.60563246234770704484e-22, 7.7451678459212186903e-22, -7.44820541607370868641e-23, -9.73895087594875433552e-23, 1.15256371058947857156e-23, 1.08112440895891082697e-23, -1.47696886957799610158e-24, -1.07967773732928389626e-24, 1.64335374131337466823e-25, 9.8437254045286664169e-26, -1.63301933401267749871e-26, -8.29045853418023261619e-27, 1.47713587378078895704e-27, 6.51184589459110880043e-28, -1.23321480060082382581e-28, -4.80799204126811399507e-29, 9.6039958004050550586e-30, 3.35909792469448118235e-30, -7.03570241853703211215e-31, -2.23307155453499073448e-31, 4.88166194619866035745e-32, 1.41928782054278616247e-32, -3.22616163112140072607e-33, -8.65974748330404921211e-34, 2.04045110479156917124e-34, 5.09037748043360628477e-35, -1.24006768644505342874e-35, -2.89169436567146508445e-36, 7.26702103975271517352e-37, 1.59182992535457455066e-37, -4.11882186078064133399e-38, -8.51195541689270644482e-39, 2.263836144391297866e-39, 4.4307780764925635106e-40, -1.20944350093933217697e-40, -2.24945984149168263961e-41, 6.29351173093780115033e-42, 1.11575199917228027826e-42, -3.19571466773842663103e-43, -5.41523689280923814047e-44, 1.58608887213424312636e-44, 2.5753249825888551706e-45, -7.70578187375937077023e-46, -1.20159819330850471559e-46, 3.66959604247166978229e-47, 5.50677453157900407043e-48, -1.7149853595305717768e-48, -2.48142104668723784532e-49, 7.87451357252070797995e-50, 1.10048543767657482175e-50, -3.5558771679008362037e-51, -4.80761701161305014784e-52, 1.58063222065220028157e-52, 2.07055824361421324001e-53, -6.92220309866007411876e-54, -8.79791678449454336075e-55, 2.98900199486471226907e-55, 3.69066943090202380285e-56, -1.2734709434567324789e-56, -1.52946380473809272127e-57, 5.35700214222063826297e-58, 6.26524141937738939551e-59, -2.22634387693093661932e-59, -2.53827457271804530374e-60, 9.14637085750219288265e-61, 1.0175663219153067044e-61, -3.71640127140510116493e-62, -4.03846531295260271945e-63, 1.4942695007041821554e-63, 1.58742058323372246349e-64, -5.94796963533129801273e-65, -6.18257952296320300996e-66, 2.34492991273293741125e-66, 2.38681129766770228061e-67, -9.15984576586103036102e-68, -9.13682426812990978911e-69, 3.54656979872118362185e-69, 3.46936341276117278718e-70, -1.36158805913697467647e-70, -1.3071376261103288635e-71, 5.18495971038076884809e-72, 4.88811411809248719923e-73, -1.95904537584127714104e-73, -1.81482106885932242788e-74, 7.34636021469848890412e-75, 6.69138049067072916009e-76, -2.73495661103629671555e-76},
            {-1.22618615034903929987e-21, 1.53884673767939008971e-19, -1.28409421787563001487e-19, -2.13206100585021046943e-19, 2.12958137759625723872e-19, 1.12394907325969780047e-19, -1.405353196472272911e-19, -3.11482045244999610219e-20, 5.47609894434342202209e-20, 4.70615473665503832137e-21, -1.48871854968580797727e-20, -1.51476725289435215297e-22, 3.09817384982637799035e-21, -1.1923519211454795482e-22, -5.23442734216017486018e-22, 3.81503296822854509974e-23, 7.47442969755205661135e-23, -7.39699188459154269014e-24, -9.28650609423858615891e-24, 1.11267869851402473319e-24, 1.02604333757876473719e-24, -1.40761989470196649637e-25, -1.02528470472493168616e-25, 1.55982372395990253416e-26, 9.39052491659403508396e-27, -1.55250030106221890809e-27, -7.9686536406289029181e-28, 1.41208235264433958166e-28, 6.32079310653545938133e-29, -1.18878378848765480527e-29, -4.72111844879883321464e-30, 9.35501312283809508276e-31, 3.34113267815391306947e-31, -6.93593260905221068112e-32, -2.25218524631514552051e-32, 4.87619283405135148687e-33, 1.45257091401634158823e-33, -3.26814720357160521707e-34, -8.99890445152574922843e-35, 2.09766269970395546637e-35, 5.37326850295541561354e-36, -1.2943953017960341876e-36, -3.10155483849454976856e-37, 7.70460576524281835573e-38, 1.73522107550886005556e-38, -4.43663982655324856623e-39, -9.43142806680903474569e-40, 2.47794430914942685619e-40, 4.99056593281999624992e-41, -1.34538467574522384753e-41, -2.57560606896664869283e-42, 7.11530658738133663833e-43, 1.29865005486847452399e-43, -3.67209984268165702578e-44, -6.40682106011504473216e-45, 1.85229711652990932287e-45, 3.09687384012835187254e-46, -9.14565135766518004939e-47, -1.46849763201916367949e-47, 4.42587271673098132346e-48, 6.8388378365257657787e-49, -2.10176162883545486141e-49, -3.13111392761558728589e-50, 9.80487615672109557073e-51, 1.41069648403206327104e-51, -4.49788168378060299186e-52, -6.25984590838305767417e-53, 2.03085195906519933033e-53, 2.73801832996404878268e-54, -9.03270407427166815717e-55, -1.18133267227205924003e-55, 3.96061700192640428223e-56, 5.03115437714196386009e-57, -1.71326297545640247607e-57, -2.11639785131516692746e-58, 7.31625419703270789442e-59, 8.79865415462939109945e-60, -3.08619763295683887428e-60, -3.61710956213737096821e-61, 1.28669804701463639151e-61, 1.4711419792181568898e-62, -5.30491207362649279358e-63, -5.92244867832951138736e-64, 2.16393157597467666607e-64, 2.36099270384922499122e-65, -8.73722731364194158698e-66, -9.3242761030819851149e-67, 3.49346652528559462967e-67, 3.64948837876476630281e-68, -1.38378498091798311505e-68, -1.41613320322718412349e-69, 5.43219185210638844981e-70, 5.44980343366246383831e-71, -2.1141289115875552145e-71, -2.08066783646737476833e-72, 8.15988337482755308497e-73, 7.88319587923753850389e-74, -3.12442669288877114706e-74, -2.96486212972476596386e-75, 1.18719099641886040663e-75, 1.1072032260450249444e-76},
            {-1.09067331310962725176e-20, 6.80799557328598995511e-21, 3.64534190014321028627e-20, -3.30425715987189523186e-20, -3.20716265672657791891e-20, 3.47482651586898193037e-20, 1.32659884080414732328e-20, -1.84562791855276974419e-20, -3.10688690742618508452e-21, 6.33969518136757001645e-21, 3.88353611965762982673e-22, -1.59294250441867027502e-21, 4.53377367096928485121e-24, 3.15188909359191258551e-22, -1.44611983745995096291e-23, -5.15674376276419798364e-23, 3.98215169242559930426e-24, 7.22049126312490774773e-24, -7.32738010420070380827e-25, -8.87526018646240328192e-25, 1.07531304627317545484e-25, 9.76438071295381412973e-26, -1.34474981406076537547e-26, -9.76253682105689610661e-27, 1.48459979669841687327e-27, 8.97891645222984884661e-28, -1.47972664398180916499e-28, -7.67252618578478023432e-29, 1.3526925616623158129e-29, 6.14144359022320161743e-30, -1.14757036274720532732e-30, -4.63666301659717799399e-31, 9.11834148103629405897e-32, 3.32101927608154119435e-32, -6.83630421692589758507e-33, -2.26792698147371936508e-33, 4.86563253292026493003e-34, 1.48300182609298664183e-34, -3.30432664043873121287e-35, -9.32025379350726918913e-36, 2.15046176097541437119e-36, 5.64810474781237756759e-37, -1.34616951259370029429e-37, -3.30988032162069040521e-38, 8.13180425478470323328e-39, 1.88043599845422604583e-39, -4.75354122410850108563e-40, -1.03805833743730059434e-40, 2.695682760511550724e-41, 5.57927447550225637449e-42, -1.48626688712324957496e-42, -2.92490896145424743908e-43, 7.98275327641785367298e-44, 1.49807526722633938759e-44, -4.18407088389822913163e-45, -7.50726462597661267183e-46, 2.14349188100795290377e-46, 3.68584792341108382712e-47, -1.07483284273333187139e-47, -1.7751264550995109554e-48, 5.28224237782194195357e-49, 8.39537124923683810889e-50, -2.54721413791005115957e-50, -3.90311133076144061204e-51, 1.20656071020790683274e-51, 1.78545034124493240085e-52, -5.61949033744891064201e-53, -8.04309826804469687791e-54, 2.57573470215231083551e-54, 3.57093268350641588434e-55, -1.16284809659248269776e-55, -1.56365338137199797728e-56, 5.17482626868049201307e-57, 6.75762678525201138699e-58, -2.2715781847862034098e-58, -2.88413732218795564318e-59, 9.84247557730460500747e-60, 1.21635288614822593576e-60, -4.21202520052871791342e-61, -5.07179418372484243271e-62, 1.78128856063613277097e-62, 2.09190808080330411166e-63, -7.44842193774250854695e-64, -8.53903119721097350073e-65, 3.08102795363559920118e-65, 3.451059674112317883e-66, -1.26133125071665965057e-66, -1.38151280668955625247e-67, 5.11273000042412851477e-68, 5.48006261739401805051e-69, -2.05278332948801539649e-69, -2.15478347492818981406e-70, 8.16705665149862382379e-71, 8.40154558156187024034e-72, -3.22089095973608228247e-72, -3.24932692459991444658e-73, 1.25956675581253007892e-73, 1.24692261119013158529e-74, -4.88584180690334716827e-75, -4.74923026840713015155e-76, 1.88044761045034763896e-76},
            {9.42095045525037503028e-23, -4.11035570550004456879e-21, 3.34675537125371590913e-21, 6.87622304805480831255e-21, -6.69271599559590684909e-21, -4.36879326812538187374e-21, 5.16072259726349614817e-21, 1.48520368269413420991e-21, -2.31513628513227137073e-21, -2.98458246368745200909e-22, 7.16916362361476478095e-22, 2.97726006426740303297e-23, -1.68482241204300247707e-22, 2.32193681251784869238e-24, 3.19086787742932791992e-23, -1.66895737381065811897e-24, -5.07475281161530351931e-24, 4.11464950658307829361e-25, 6.98250141599163102027e-25, -7.24481233272110570051e-26, -8.50022910299644600701e-26, 1.04032315781641436617e-26, 9.31573167371049017324e-27, -1.2875410528503302897e-27, -9.31870517959451706136e-28, 1.41656493193812296939e-28, 8.60375651024940078854e-29, -1.41369673172871906244e-29, -7.39936195207637797035e-30, 1.29831094637938868919e-30, 5.97296486273283147158e-31, -1.10927993016148852854e-31, -4.55481243128666338565e-32, 8.89353011233180472997e-33, 3.29925936453265428489e-33, -6.73752440590080779823e-34, -2.28072769508578140146e-34, 4.85088924208714920429e-35, 1.51082166122733651494e-35, -3.33535803025185411703e-36, -9.62456922882388378952e-37, 2.19917143611001465872e-37, 5.91472531644640000473e-38, -1.39546629326423647539e-38, -3.51618046200073777281e-39, 8.54811794310334844779e-40, 2.02700382548818246504e-40, -5.06867346938852005416e-41, -1.13562111966050237606e-41, 2.91631565572862121065e-42, 6.19523450586327614296e-43, -1.63161843030178475572e-43, -3.29679555553810939187e-44, 8.89354867529451239502e-45, 1.71406257113533593915e-45, -4.73094349495890712662e-46, -8.71941500536756018621e-47, 2.45984206917147460818e-47, 4.34553076602437946313e-48, -1.25187365430887394511e-48, -2.12428013832210825339e-49, 6.24394487112580483197e-50, 1.01969094087338317183e-50, -3.05566395521274651984e-51, -4.81114105997650819828e-52, 1.46879006520646459996e-52, 2.23331614472251680658e-53, -6.94133393894916472739e-54, -1.02080626220175700008e-54, 3.22806850023205994309e-55, 4.59798644801471523889e-56, -1.47848294725636774958e-56, -2.0423875865235831203e-57, 6.6741146983912393032e-58, 8.95254957090651053069e-59, -2.971531416847695867e-59, -3.87493725065634510571e-60, 1.3057492775057025754e-60, 1.65708376509805697786e-61, -5.66624849267007883238e-62, -7.00521542102919706083e-63, 2.42959143938752600783e-63, 2.92897453494339390549e-64, -1.02991574249942097044e-64, -1.21180395674989351615e-65, 4.31832150543934750186e-66, 4.96322987382714282436e-67, -1.79173342601245527332e-67, -2.0132249979346124781e-68, 7.35977850565983181746e-69, 8.09069477182158300297e-70, -2.9940930763725654868e-70, -3.22258575273535934567e-71, 1.20681517187452356257e-71, 1.27261953625841860447e-72, -4.82111078944762721241e-73, -4.98436463692706963768e-74, 1.90955135866554086118e-74, 1.93674244734057325926e-75, -7.50122438023453463942e-76, -7.46811749196447096925e-77},
            {2.63168332092033099668e-22, -1.51490775592377152531e-22, -1.06315832396625404844e-21, 9.44919320105859470296e-22, 1.11605385437414146556e-21, -1.1682925096898440394e-21, -5.52889477143442080068e-22, 7.15767776640902236995e-22, 1.59264042659174274293e-22, -2.80299184961218535783e-22, -2.76314683532811078156e-23, 7.95710023639973820149e-23, 2.01939205490219366028e-24, -1.76543123909409948499e-23, 4.07952421133739261153e-25, 3.21771719019585941936e-24, -1.86438314486806291271e-25, -4.99038984191186681331e-25, 4.21874143805082465815e-26, 6.75951690206385729078e-26, -7.15337045545093201484e-27, -8.15716722214616378818e-27, 1.00755770371099892619e-27, 8.90836363268644620502e-28, -1.23530493475104810283e-28, -8.91539706905534518098e-29, 1.35478958638772033445e-29, 8.26069486587449439799e-30, -1.35356989994997794017e-30, -7.14679934704644203612e-31, 1.2483754469942435258e-31, 5.81457689213691111045e-32, -1.07364875018982094428e-32, -4.47567853852775629477e-33, 8.68007346094165773551e-34, 3.2762685123953334097e-34, -6.64013334785718986641e-35, -2.29096690381206253173e-35, 4.83273362408864160968e-36, 1.53625567490928021883e-36, -3.36183120844614850795e-37, -9.91266891014068377988e-38, 2.24410115780536890815e-38, 6.17307411330227752732e-39, -1.44237422660999129797e-39, -3.72005253320389615611e-40, 8.95322608727214300915e-41, 2.17450216718191753107e-41, -5.38131486223958333298e-42, -1.2355262269620499795e-42, 3.13917259731019295161e-43, 6.83675758784618368479e-44, -1.7809850294567306838e-44, -3.69061036707484129011e-45, 9.84532022487808404131e-46, 1.94656584825212032081e-46, -5.31189196453169236498e-47, -1.00455587512553135684e-47, 2.80139081017800082106e-48, 5.07890347989941002576e-49, -1.44609730250017731021e-49, -2.5186356443681931418e-50, 7.31579509565268832489e-51, 1.22638334441005272545e-51, -3.63127866768978491325e-52, -5.86922354979064632629e-53, 1.77028788374895363946e-53, 2.76326556506192027004e-54, -8.48456938633008615042e-55, -1.28090169998958505636e-55, 4.00128694838151098414e-56, 5.85054702302149203497e-57, -1.8582601139489943213e-57, -2.63497366829166502707e-58, 8.50504686298953723456e-59, 1.17096676378526684035e-59, -3.83895457558883852912e-60, -5.13772070077414308867e-61, 1.7100012606576668993e-61, 2.22692118020278445384e-62, -7.52122751294276884998e-63, -9.54073244511871817281e-64, 3.26838943458816070275e-64, 4.04221989697173070447e-65, -1.40397529005676164516e-65, -1.69443292495458712457e-66, 5.96456577582179838102e-67, 7.03051519139578570919e-68, -2.50721486646778948995e-68, -2.88860793288552643625e-69, 1.04324173176905035993e-69, 1.17570478486526466335e-70, -4.29867904271907664629e-71, -4.74215578628461312614e-72, 1.75471802506001949679e-72, 1.89614531384057385959e-73, -7.09835762320671440877e-74, -7.51843791951543956153e-75, 2.84664781731673311501e-75, 2.9571808839841202847e-76, -1.1320714389597209938e-76},
            {-3.67525391255328092228e-24, 1.09119805254187120398e-22, -8.63722794141719216056e-23, -2.16759643997980815262e-22, 2.06286489180594092958e-22, 1.62932404817797692417e-22, -1.84081628448682374767e-22, -6.60900905052293971791e-23, 9.42639087411219592433e-23, 1.6460755682977043162e-23, -3.29998419097089962124e-23, -2.45843373500626697482e-24, 8.6993135208638961651e-24, 1.03504137901129584991e-25, -1.83586467721783071063e-24, 5.7215831661081838308e-26, 3.23460766081513284524e-25, -2.03562730838718798837e-26, -4.90509134025434916978e-26, 4.29948363624662075843e-27, 6.55056689858418624377e-27, -7.05612540520327808111e-28, -7.84244114603502643171e-28, 9.76865344088489038364e-29, 8.53714186555518472633e-29, -1.18745763008690691525e-29, -8.54761084789955654951e-30, 1.29849448242947875947e-30, 7.94603005052300500692e-31, -1.29863596893319268637e-31, -6.9127764986346430274e-32, 1.2024019528543870055e-32, 5.66555377759189615591e-33, -1.04044073895075853929e-33, -4.39931684797073690451e-34, 8.47743791664341580235e-35, 3.25239084263712600755e-35, -6.54453880732998393229e-36, -2.29897854809882982147e-36, 4.81181954433658432659e-37, 1.559513084744186313e-37, -3.38427371967445764339e-38, -1.01853924853645288212e-38, 2.28554454209356245125e-39, 6.42317966223171081451e-40, -1.48699045736301618989e-40, -3.92117111623724561118e-41, 9.34695615135682309454e-42, 2.32255477052223623618e-42, -5.69086158878790974801e-43, -1.33748635502573658172e-43, 3.36364707439093483021e-44, 7.50215958254508673911e-45, -1.93393308964130722784e-45, -4.10563304475744920432e-46, 1.08356636258786713527e-46, 2.19546701268582133839e-47, -5.92597484184811616759e-48, -1.14874492607962471496e-48, 3.16806758880431883802e-49, 5.88864000510740241734e-50, -1.65783390594044812002e-50, -2.96073631330362559267e-51, 8.50216957145293868245e-52, 1.46162288875463474674e-52, -4.27804724078916245657e-53, -7.09157557767629909872e-54, 2.1141373778371813622e-54, 3.38462103778507245027e-55, -1.0270738349497609627e-55, -1.59036183212507700609e-56, 4.90939599892512165637e-57, 7.36262300723333805117e-58, -2.31079225185814572595e-58, -3.36068723893864545721e-59, 1.07182272157698009161e-59, 1.51345336540025841481e-60, -4.90245718657061585855e-61, -6.72856129233835012595e-62, 2.21264650823615370249e-62, 2.95485721260348288326e-63, -9.86000606221798421395e-64, -1.28246186120038815763e-64, 4.34061702171464666333e-65, 5.50381356998081962752e-66, -1.88869284428187382539e-66, -2.33667448970117431715e-67, 8.12678538526635156535e-68, 9.8183694271190327442e-69, -3.45957412624021764435e-69, -4.08476463876885250728e-70, 1.45767117910045720651e-70, 1.6832571587065380708e-71, -6.08142160281683545875e-72, -6.87304382087891588523e-73, 2.51318556256616573019e-73, 2.78171965320606363933e-74, -1.0291382232055134951e-74, -1.11631104482053666972e-75, 4.17733811971875578947e-76, 4.44323157395281001131e-77},
            {-6.36790929938647430799e-24, 3.3129427278974838064e-24, 3.06005870835099296411e-23, -2.66640846364180706923e-23, -3.77442125840819445456e-23, 3.84020204566570288927e-23, 2.19803779898016490738e-23, -2.69088410622900255488e-23, -7.54541449006648359038e-24, 1.19232954879700791542e-23, 1.64583075716781017327e-24, -3.79859214307426146152e-24, -2.08568593393703360047e-25, 9.39395705969809483693e-25, 4.34732888690693254112e-28, -1.8971857014804340133e-25, 7.24813278416328310394e-27, 3.24334232990472275499e-26, -2.18560216509334113331e-27, -4.81991873824899250666e-27, 4.36100211122474172364e-28, 6.35469256849725737523e-28, -6.95539133907351861501e-29, -7.55292732898360668903e-29, 9.48099320375483047641e-30, 8.19773085588028998765e-30, -1.14350123915006805343e-30, -8.21111757084860785e-31, 1.24702183811709871575e-31, 7.65659489707895572207e-32, -1.24829134130901554778e-32, -6.69548711394807721795e-33, 1.15997166477492373122e-33, 5.52522317928391105638e-34, -1.00944448044669612514e-34, -4.3257406902337673891e-35, 8.28508050020587867843e-36, 3.22791111903330892884e-36, -6.45104353988836692114e-37, -2.30505631532524640313e-37, 4.78870170432739284167e-38, 1.58078733714249395891e-38, -3.40315666601652896197e-39, -1.04435837159825584435e-39, 2.32377824156287605541e-40, 6.66513803183719362697e-41, -1.52941748401425980319e-41, -4.11927852691145318882e-42, 9.72925806401364350697e-43, 2.47082874940060634302e-43, -5.9968151961309620684e-44, -1.4412327140848209338e-44, 3.58919397670327847738e-45, 8.18977983101717146075e-46, -2.09005194480193709534e-46, -4.54109423633276224904e-47, 1.1862174535087838017e-47, 2.46058493610617093474e-48, -6.57215851248775511289e-49, -1.30463391968983687487e-49, 3.55970048308314111586e-50, 6.77710749123331389481e-51, -1.88733781081799448672e-51, -3.45298014579938174741e-52, 9.80700084660050280923e-53, 1.72737594090453779246e-53, -4.99975969619382299372e-54, -8.49251805192348858019e-55, 2.50337307901108301974e-55, 4.1070026125417151265e-56, -1.2321630151904678412e-56, -1.95526632762790706786e-57, 5.96689777262956573416e-58, 9.17079824513986881243e-59, -2.84518683993295419941e-59, -4.24065753415846942865e-60, 1.33682226701129241574e-60, 1.93449483525432007819e-61, -6.19346324646380668703e-62, -8.7111309653008794363e-63, 2.83117251939307817973e-63, 3.87436836901186391581e-64, -1.27770104221534428371e-64, -1.70285440433797324532e-65, 5.69590384647349061606e-66, 7.39981044600575434981e-67, -2.5095243966741096724e-67, -3.18077523771372835472e-68, 1.09326719933168025761e-68, 1.35302309320321870552e-69, -4.71156438474528339129e-70, -5.69792178611815065623e-71, 2.00952653819649527904e-71, 2.37648769431240871192e-72, -8.4856887655659934746e-73, -9.82022844186275465338e-74, 3.54903287275869335285e-74, 4.02183963394028178172e-75, -1.4706794363135521807e-75, -1.63300302182747562879e-76, 6.04029247000130499862e-77},
            {1.19674748291418272738e-25, -2.88242740037453367533e-24, 2.20915347801513060033e-24, 6.70523830294467708184e-24, -6.25273070021829332401e-24, -5.87593355005132088399e-24, 6.40340056277569959071e-24, 2.78900049091570817479e-24, -3.71493174781942544873e-24, -8.29062130747508573947e-25, 1.46044087728061746132e-24, 1.59439106539440209424e-25, -4.29285677773348834543e-25, -1.658871442501659126e-26, 1.00408517276736369217e-25, -9.40824238193027614288e-28, -1.95039374014762607433e-26, 8.66217223727304306518e-28, 3.24541719008403905757e-27, -2.31690297022960471996e-28, -4.73565059534556226747e-28, 4.4066745864733178662e-29, 6.17097051970083081454e-29, -6.85291223379145644967e-30, -7.28592876138989074847e-30, 9.21120053160864723963e-31, 7.88644685404980343222e-31, -1.10300878544404804884e-31, -7.90231948190492428073e-32, 1.19981290382201500941e-32, 7.38966517538323075738e-33, -1.20202009756054872577e-33, -6.49334356745547169968e-34, 1.12072076952268253086e-34, 5.39296437911565899042e-35, -9.80470493012931931326e-36, -4.254932066673557546e-36, 8.10246175714515373057e-37, 3.20306473508475877817e-37, -6.35986704225930007888e-38, -2.30945843035076910272e-38, 4.76385060134524148353e-39, 1.60025667332864474385e-39, -3.41890027857507288117e-40, -1.06880774996289476681e-40, 2.35906149163811999567e-41, 6.89909848276939950473e-42, -1.5697606383358460046e-42, -4.31417606080519277447e-43, 1.01001820120885288928e-43, 2.61903157484761393134e-44, -6.29877076276081693436e-45, -1.54651541168893029812e-45, 3.81532647830790597908e-46, 8.89799648803443652476e-47, -2.24895527902016697464e-47, -4.99618966304084718428e-48, 1.2922474797351452914e-48, 2.74168404023069922311e-49, -7.24933855178575408546e-50, -1.47230160931607282133e-50, 3.97602821981895063618e-51, 7.74637098708129036273e-52, -2.13479204987212345969e-52, -3.99761122901854100985e-53, 1.12337786665569044021e-53, 2.0255556779953780323e-54, -5.79999134630045871541e-55, -1.00863891023276895018e-55, 2.94096334442303719056e-56, 4.94027447050069693159e-57, -1.46591508362820187465e-57, -2.38198268314125896017e-58, 7.18871291539023497366e-59, 1.13141435261630629332e-59, -3.47100976548994243983e-60, -5.2978680534888152193e-61, 1.65134508393581217407e-61, 2.44713117274577741066e-62, -7.74622479273111334576e-63, -1.1157107625056350919e-63, 3.58497068899589990977e-64, 5.02375917917529967703e-65, -1.63786926243871476423e-65, -2.2352071919823323352e-66, 7.39110339310819660786e-67, 9.83180427209702938189e-68, -3.2960890512709369266e-68, -4.2773687699727568756e-69, 1.45330763766532351796e-69, 1.84135574823604082379e-70, -6.33843110676433428928e-71, -7.84683714706214858931e-72, 2.73562488336997199494e-72, 3.31143047794361869887e-73, -1.16884267176533288274e-73, -1.38439289474393168369e-74, 4.94589129727331014974e-75, 5.73555796208802696457e-76, -2.07337158106261521491e-76, -2.35562583391052327276e-77},
            {1.54471785865653708736e-25, -7.0838075110012082723e-26, -8.71148947586391430768e-25, 7.43710112050942523236e-25, 1.24660612308891603183e-24, -1.23779602993247952762e-24, -8.41121708262803247251e-25, 9.84628852935140992135e-25, 3.36908438159653558648e-25, -4.90368239375261883791e-25, -8.81256124181551721269e-26, 1.74278181614587596566e-25, 1.49560754035669690093e-26, -4.77819118383130518595e-26, -1.19038213707726422803e-27, 1.06409694689943395192e-26, -1.90719470751529756278e-28, -1.99640948450883770229e-27, 9.96856181040237579543e-29, 3.24207303153967542969e-28, -2.43182482884445709058e-29, -4.65285156203879959956e-29, 4.43927504533252885383e-30, 5.99852590244139309098e-30, -6.75000002879288426383e-31, -7.03910689783332086217e-31, 8.95796472862060115311e-32, 7.60014160534125965999e-32, -1.06561221469334783431e-32, -7.61813820526950669733e-33, 1.15639025967768331265e-33, 7.14288611618056954702e-34, -1.1593789239065598779e-34, -6.30494595175221705276e-35, 1.08433196142416058221e-35, 5.2682055548140873912e-36, -9.53348764681732805165e-37, -4.1868499747452930136e-37, 7.92905448354705285498e-38, 3.17804597632057984879e-38, -6.27116285295687996481e-39, -2.31241192916300428157e-39, 4.73766520412878638158e-40, 1.61808488218171484157e-40, -3.43187912156645842991e-41, -1.09196903644940369101e-41, 2.39163615144859302294e-42, 7.12525147221813180487e-43, -1.60812612564049150047e-43, -4.50571607425185846931e-44, 1.04598594091675915798e-44, 2.7669079642665573374e-45, -6.59640589544947331483e-46, -1.65310343769380093055e-46, 4.04161252404073480143e-47, 9.62523850001451496889e-48, -2.41028187679300459807e-48, -5.47009245432874272467e-49, 1.40142337819437523797e-49, 3.03848243463662411565e-50, -7.95635882905440055878e-51, -1.65178398522203665269e-51, 4.41671182854905725653e-52, 8.79820166331413497684e-53, -2.40031322660124856798e-53, -4.5967140190810119794e-54, 1.27855568577671082253e-54, 2.35801269979650651799e-55, -6.68209125514501419284e-56, -1.18874633876119315396e-56, 3.42979510153721383557e-57, 5.89449202479228766143e-58, -1.73051999691361641866e-58, -2.87713842643660748529e-59, 8.59010288105058484195e-60, 1.38341087004517923621e-60, -4.19824600914998162756e-61, -6.55714221775250662111e-62, 2.02160376252231390263e-62, 3.06568834909061298686e-63, -9.59781305471647955931e-64, -1.41465383512897075188e-64, 4.49538253878280335866e-65, 6.44648998516783225292e-66, -2.07841113416940511008e-66, -2.90251419895320982666e-67, 9.49080091446166802191e-68, 1.29186251740473174349e-68, -4.28254797739949182008e-69, -5.68655583093825928825e-70, 1.91045757380646371527e-70, 2.47663340581426258874e-71, -8.42953671147430013352e-72, -1.06765515028942744888e-72, 3.68031557832429639028e-73, 4.55747714955779902839e-74, -1.59057730848587867107e-74, -1.9270823902147748178e-75, 6.80732414738558180076e-76, 8.07435363776434532342e-77, -2.88605448825945592251e-77},
            {-3.58420025905640434145e-27, 7.58255810782796045338e-26, -5.60307458591428371259e-26, -2.04157389428081022064e-25, 1.86780337400981550783e-25, 2.06078705165602972326e-25, -2.17922236614666207119e-25, -1.12790376185118293286e-25, 1.42284047991937878898e-25, 3.90787439547450607008e-26, -6.24394345291184693394e-26, -9.09262212720432448976e-27, 2.03551384657359617758e-26, 1.35409307421479318423e-27, -5.25117270606716700915e-27, -6.90956430912206384215e-29, 1.1196047631576871993e-27, -2.84801086091225175509e-29, -2.03606943334105996051e-28, 1.11732452888676616295e-29, 3.23433911382465678616e-29, -2.53238730289936546971e-30, -4.57192421567426531864e-30, 4.4610887717622072998e-31, 5.83653886315019240766e-31, -6.64763769436668464309e-32, -6.81042580573641768708e-32, 8.72006550992521864767e-33, 7.33610987247332949771e-33, -1.03099272535260347159e-33, -7.35592565835678382596e-34, 1.11634374436486669862e-34, 6.91421290765565680174e-35, -1.11998500508762189077e-35, -6.12905605079707614694e-36, 1.05052744669288216653e-36, 5.15042065051267572377e-37, -9.27926551793949674197e-38, -4.12143680006878068294e-38, 7.76434945448700002236e-39, 3.15301486238355897937e-39, -6.18503233930068780049e-40, -2.31411644759243570204e-40, 4.71048368697666133242e-41, 1.6344221596956121223e-41, -3.44242688566442619666e-42, -1.11392136854787104374e-42, 2.42172708979649319675e-43, 7.34381868235074326943e-44, -1.64461951977441866695e-44, -4.69379488478648329688e-45, 1.08084866790166021756e-45, 2.91423677150443439652e-46, -6.8894706163986965403e-47, -1.76078434508805839227e-47, 4.26767109848131416422e-48, 1.0369994694054832435e-48, -2.57369583715404130486e-49, -5.9619638331441404059e-50, 1.51351853933676791486e-50, 3.35065951877186122433e-51, -8.69202840609777647841e-52, -1.8430781073510257849e-52, 4.88134573420457661015e-53, 9.93408785546905272391e-54, -2.68395666056929734303e-54, -5.25221017543097044168e-55, 1.44649649342594145282e-55, 2.72652721312619317239e-56, -7.64917455152883021526e-57, -1.39098782522935947885e-57, 3.97266081574977251252e-58, 6.97985038163584715705e-59, -2.02815563405689276677e-59, -3.44759222716601350348e-60, 1.01865933434902864231e-60, 1.67743980843423738097e-61, -5.03725823273783764615e-62, -8.04511503579460254902e-63, 2.45416480835683465637e-63, 3.80579529777263418747e-64, -1.17880884012849522418e-64, -1.77681549005259943096e-65, 5.58573266327893358861e-66, 8.19148542891727037671e-67, -2.61254449015099001372e-67, -3.73105157434595629224e-68, 1.20677952415556853346e-68, 1.67980662750992005408e-69, -5.50797939062286925614e-70, -7.47903239878159722346e-71, 2.48520944257597174813e-71, 3.29440273675351453369e-72, -1.10900619932294288847e-72, -1.43624819754526491415e-73, 4.89652498281308748681e-74, 6.19969510421416211084e-75, -2.13991907640537688931e-75, -2.65067534668352796404e-76, 9.26029573982775472979e-77, 1.12288936726123907247e-77},
            {-3.755575360830298329e-27, 1.46874049215293205655e-27, 2.45710555450125501912e-26, -2.05306868786727974819e-26, -4.03572180592676718673e-26, 3.92187825628280928189e-26, 3.11833843329889789691e-26, -3.51834810348047416565e-26, -1.43523097595179244204e-26, 1.95770033143991131533e-26, 4.37919995789321779071e-27, -7.72013980352106157399e-27, -9.12324439577372313451e-28, 2.33522341745081097148e-27, 1.17478542098826945655e-28, -5.70934234259604796899e-28, -1.69732731693868093566e-30, 1.17083053741291075691e-28, -3.75801274126193101162e-30, -2.07012631810975929136e-29, 1.22827154564388506786e-30, 3.22306958262059859941e-30, -2.62036185235283804523e-31, -4.49314819807276472945e-31, 4.47400411349715137359e-32, 5.68424678020959489232e-32, -6.54655667918748228115e-33, -6.59810614034034774115e-33, 8.49637334780529237565e-34, 7.09201529733186097014e-34, -9.98872922817497574596e-35, -7.11339251349777555464e-35, 1.07931918054259724476e-35, 6.70186219042178333924e-36, -1.08350623010409548964e-36, -5.96457538412772888841e-37, 1.01906314373934709131e-37, 5.03912609285519403806e-38, -9.04066424898514381915e-39, -4.05862322335502807703e-39, 7.60785900179071921009e-40, 3.12810282076712745119e-40, -6.10153570295587310663e-41, -2.31474756507257308689e-41, 4.68259251891028456634e-42, 1.64940601854215583828e-42, -3.45084075844290155253e-43, -1.13474090215995919334e-43, 2.44954280432219923281e-44, 7.5550447747313195572e-45, -1.67934462500057416081e-45, -4.87834645226846147124e-46, 1.1146311510135821891e-46, 3.06082795027688814955e-47, -7.17777815719108024161e-48, -1.86936370398502601614e-48, 4.49316841385445762852e-49, 1.11308204087610607872e-49, -2.73888636664867953555e-50, -6.47096226624209859745e-51, 1.62831413066371498747e-51, 3.67786299986353932551e-52, -9.45513632303023086452e-53, -2.04614593513374694063e-53, 5.36946817841417301381e-54, 1.11552482859021739587e-54, -2.98572165680651221561e-55, -5.9658576374879335279e-56, 1.62742235111444753914e-56, 3.13280271556357815649e-57, -8.7041181968690606331e-58, -1.61675671196758777662e-58, 4.57224761847467491309e-59, 8.2066348048170765829e-60, -2.36097733580803550313e-60, -4.10040442384493464929e-61, 1.19938997607307726347e-61, 2.01808320471023954678e-62, -5.99874402108345729612e-63, -9.79019194307431027357e-64, 2.95592946052131526282e-64, 4.68439202901504350585e-65, -1.43596505810985951256e-65, -2.21196392537849159385e-66, 6.88134851244297689318e-67, 1.03134206262495547828e-67, -3.25484323756825585921e-68, -4.75061591436571745938e-69, 1.52035497414806001861e-69, 2.16286241901962265195e-70, -7.01674593698305884523e-71, -9.73725781599335873911e-72, 3.2011555792736883137e-72, 4.33669547810388780301e-73, -1.44427729927511685602e-73, -1.9114849461067264897e-74, 6.44686587059953938205e-75, 8.34138282431913355427e-76, -2.84821138371083689557e-76, -3.60509715237354712042e-77, 1.24590003121924056804e-77},
            {1.02366867727194769171e-28, -1.98775822898077522983e-27, 1.40966994610372708162e-27, 6.13261441929185723401e-27, -5.50817995861315623771e-27, -7.05885581585159584988e-27, 7.2747783233561663268e-27, 4.40351932240789664255e-27, -5.3138900912339936991e-27, -1.74916389506241884072e-27, 2.58911920101523398899e-27, 4.76181561769143490097e-28, -9.31553580985375001778e-28, -8.9055107183207389665e-29, 2.63894464564772694545e-28, 9.62644676532400674217e-30, -6.15102336739812626641e-29, 3.65626921133185356637e-31, 1.21802381944496841596e-29, -4.63377148235054640109e-31, -2.09925291900391931345e-30, 1.33036519481782241706e-31, 3.20897365187903628413e-31, -2.69729934902420624095e-32, -4.41670988972691246957e-32, 4.47958588603988007894e-33, 5.54094386969587222794e-33, -6.44729548551649890588e-34, -6.40058704943222035635e-34, 8.28584681600042989909e-35, 6.86583052362808563218e-35, -9.69010411375128708485e-36, -6.88855033179720801873e-36, 1.0450092734892530816e-36, 6.50427227306914123535e-37, -1.04965321646715497811e-37, -5.81052662560074848469e-38, 9.89723852834631374255e-39, 4.93387751160562440615e-39, -8.81644541139109177095e-40, -3.99833198329192917437e-40, 7.45911905537410530265e-41, 3.10341739875382472458e-41, -6.02070077807264970529e-42, -2.31445974628876539197e-42, 4.65423416215819485827e-43, 1.66316220854938277426e-43, -3.45738537947132711587e-44, -1.15450050958945909742e-44, 2.47527619068669166328e-45, 7.75919060840803815101e-46, -1.71240263241641518669e-46, -5.05933678877168553975e-47, 1.14736212625800735032e-47, 3.20651964075994179954e-48, -7.4611966436338287768e-49, -1.97866439192480971356e-49, 4.71781411828969022741e-50, 1.19063420563657111531e-50, -2.90556724810612943815e-51, -6.99625120735724501287e-52, 1.74560009435421274952e-52, 4.01971530419780401279e-53, -1.02444643974508076133e-53, -2.26091808657025162539e-54, 5.88057089996815195585e-55, 1.24626468975445692978e-55, -3.30555678716165666812e-56, -6.73925163934545426419e-57, 1.82151626945888292868e-57, 3.57846108532431540234e-58, -9.84955980350171820289e-59, -1.86742002975393024578e-59, 5.23112849744525438072e-60, 9.58517369760769255867e-61, -2.73110846188975008979e-61, -4.84280742485006578005e-62, 1.40278559371110606921e-62, 2.4101197614611407232e-63, -7.09369246606055621108e-64, -1.18224960949774565337e-64, 3.53411264456176090991e-65, 5.71972918573116590764e-66, -1.73577709627643594389e-66, -2.730783792986469614e-67, 8.40956734464818880551e-68, 1.28729825212085840847e-68, -4.02127401036251046418e-69, -5.99475406255243025229e-70, 1.89886083901546155379e-70, 2.75912383317403992012e-71, -8.8588510883603494533e-72, -1.25566545729404137532e-72, 4.08525429327398740371e-73, 5.65280299238289337698e-74, -1.86298412238770753845e-74, -2.51834287329529915079e-75, 8.40480628734551696363e-76, 1.11068633203018565411e-76, -3.7527090942100773158e-77, -4.85120007948286537364e-78},
            {9.14917089602836869693e-29, -2.91084526633316748907e-29, -6.87549428854606942731e-28, 5.61545607539811827163e-28, 1.28431082856155653813e-27, -1.22392701628552068306e-27, -1.12546859006484530503e-27, 1.23105549328520517963e-27, 5.88227883674607634204e-28, -7.61232649088245031242e-28, -2.05564383990600220953e-28, 3.31469959991211645381e-28, 5.03948635551919762102e-29, -1.10131564855808800343e-28, -8.44695419387407423829e-30, 2.94415043307932264028e-29, 7.22453830561047603491e-31, -6.57516380179033778452e-30, 9.08781230597766910511e-32, 1.261447134974495925e-30, -5.47326051243334731234e-32, -2.12404768163847830888e-31, 1.42426807725229121416e-32, 3.19264053120889965103e-32, -2.76455617842451699072e-33, -4.34272499486820494728e-33, 4.47913427981529463412e-34, 5.40597920214792515922e-34, -6.35024423389655116987e-35, -6.21649450273007069803e-35, 8.08752820658005615627e-36, 6.65578850164277995333e-36, -9.4119252799367099852e-37, -6.67966443627655965769e-37, 1.0131462126852960078e-37, 6.32007030976621892109e-38, -1.01817277476961812614e-38, -5.66603782678090749985e-39, 9.62319215180501424431e-40, 4.83426656326905350635e-40, -8.60549120706890103112e-41, -3.94048075599058976642e-41, 7.31769009465882495827e-42, 3.07904618274527757634e-42, -5.94253007330800056669e-43, -2.31338892330693089255e-43, 4.62561359637798847031e-44, 1.67580562152426433337e-44, -3.46229639956154490302e-45, -1.17326960375250922921e-45, 2.4991054004655248785e-46, 7.95652769340452569335e-47, -1.74389151160227493318e-47, -5.23675903858623320134e-48, 1.17907332372968835031e-48, 3.35117541179457232102e-49, -7.73964163417566300073e-50, -2.0885257714788111338e-50, 4.94135759797365202065e-51, 1.26952599628962122197e-51, -3.07347606602101348436e-52, -7.53700556658555927404e-53, 1.86517586649741428533e-53, 4.37581937902720304562e-54, -1.10587981832243067075e-54, -2.48729747459433898695e-55, 6.4141080374612746664e-56, 1.3857008806241050282e-56, -3.64336509375216647191e-57, -7.57382737117272942095e-58, 2.02892427082101441965e-58, 4.06503897038324420502e-59, -1.10878991050091224479e-59, -2.14431331979699614648e-60, 5.95175542482720030885e-61, 1.11257944969114157709e-61, -3.1406319875855029862e-62, -5.68217638691011568019e-63, 1.63043462614526980607e-63, 2.85850908103121557359e-64, -8.33334071166449232964e-65, -1.41738054727894719297e-65, 4.19622045402953709233e-66, 6.93135947340568374506e-67, -2.08303086285237231868e-67, -3.34489246820804400502e-68, 1.01997308644629410022e-68, 1.59371044270655929171e-69, -4.92922523279672196405e-70, -7.50098242360763316547e-71, 2.35229736473451574855e-71, 3.48910143973713565215e-72, -1.10902814391869476063e-72, -1.60468310659245473971e-73, 5.16809464521211397526e-74, 7.30008425974264307806e-75, -2.38147046183265845953e-75, -3.28626059318908170683e-76, 1.08558918549905164884e-76, 1.4644514136509594329e-77, -4.89734056729561718995e-78},
            {-2.83685925685627962806e-30, 5.19551463165426451206e-29, -3.51841362367563772967e-29, -1.82078922267529832792e-28, 1.6058932238245410483e-28, 2.36931994197469924008e-28, -2.38729640158890787243e-28, -1.66874608880033651959e-28, 1.94056525684133803015e-28, 7.50632399403542602185e-29, -1.04471579003285344577e-28, -2.34132089825761918145e-29, 4.13025509912724000462e-29, 5.20069541028401910457e-30, -1.27964465714471835678e-29, -7.75968250930887221322e-31, 3.24872484448823813742e-30, 4.58695571189380454558e-32, -6.98120323562873300008e-31, 1.45454522532712106853e-32, 1.30136571666542848038e-31, -6.27551589569480679748e-33, -2.14504113480640242919e-32, 1.51062193174321740164e-33, 3.17455997716799297461e-33, -2.82331820705283940667e-34, -4.27125578935604686251e-34, 4.47373229614885855513e-35, 5.27875381167032838405e-35, -6.25567875080210930756e-36, -6.04461484818593747581e-36, 7.90053824271034493325e-37, 6.46034262930070197435e-37, -9.15231989251840181406e-38, -6.48521528531783990502e-38, 9.83495618317392523228e-39, 6.14804507216681258981e-39, -9.88842521965376543909e-40, -5.53032897807246275155e-40, 9.36680317837758022053e-41, 4.73991791574553507338e-41, -8.40679105163376578791e-42, -3.88498435081609134015e-42, 7.18315733502476339416e-43, 3.05506006353395223864e-43, -5.8670064134208638294e-44, -2.31165475872255565991e-44, 4.59690385192313475255e-45, 1.68744116298552128973e-45, -3.46578367036947667834e-46, -1.1911140584993224544e-46, 2.52119474304823833664e-47, 8.14733368273159387806e-48, -1.77390558909740954389e-48, -5.41062916730440480989e-49, 1.20979865486157205667e-49, 3.49468167803784367078e-50, -8.0130694612738258829e-51, -2.198802795870653006e-51, 5.16358442474261174722e-52, 1.34963497911497898048e-52, -3.24237325521083336151e-53, -8.09241703910150455695e-54, 1.98685086092205528214e-54, 4.74576389714585124681e-55, -1.18969362455212443171e-55, -2.72516278218885228588e-56, 6.96950424263954735769e-57, 1.53388369493491250269e-57, -3.99900914426759434667e-58, -8.47086401403932323231e-59, 2.24975761065453323302e-59, 4.59398536173738270658e-60, -1.24213016953553869922e-60, -2.44873618304678112615e-61, 6.73645428086578351711e-62, 1.28387827661789621788e-62, -3.59158313858223922814e-63, -6.62600051940500593284e-64, 1.88392421429601492423e-64, 3.36837532931984116543e-65, -9.72913100582162449937e-66, -1.68774811955146052243e-66, 4.95002653717926268304e-67, 8.34012148856859391286e-68, -2.48276122631947462245e-68, -4.06685120078551329854e-69, 1.22831682094501302771e-69, 1.95791722661969312988e-70, -5.99752858388892134884e-71, -9.3109940132163962828e-72, 2.89164435444359065061e-72, 4.37589180867504404404e-73, -1.37733321148026574563e-73, -2.03328185284344322468e-74, 6.48415782278808756431e-75, 9.34480270102622098234e-76, -3.01839562519886099502e-76, -4.24967246551646767652e-77, 1.38990149303411157586e-77, 1.91300299056240027947e-78},
            {-2.23296358806227852013e-30, 5.36232285200119608111e-31, 1.91071884811111871394e-29, -1.52305254698424958719e-29, -4.02684323760349485187e-29, 3.7683531917452792593e-29, 3.96932336864615893668e-29, -4.22744317668948030184e-29, -2.33355732090756466437e-29, 2.89102833892679437481e-29, 9.21760950024924281675e-30, -1.38392145140100404316e-29, -2.59411144740038509333e-30, 5.03029479488654809078e-30, 5.23813978838558967909e-31, -1.46497152511318210785e-30, -6.85883978916358562917e-32, 3.5509255738299101783e-31, 1.75483825309755912488e-33, -7.36896237723055269501e-32, 1.99873046741164771391e-33, 1.33804047499698133606e-32, -7.04036925951050389447e-34, -2.16270249512647929057e-33, 1.59003810658381705187e-34, 3.15513922710933185786e-34, -2.87462234035753316745e-35, -4.20232433106192971474e-35, 4.46428408153476544781e-36, 5.15871734081339172246e-36, -6.16378676843162195747e-37, -5.88387263884674764218e-37, 7.72407041434876863378e-38, 6.27813392695967548253e-38, -8.90963273294234135721e-39, -6.30386662266110198376e-39, 9.55851557774614031252e-40, 5.98712424423799914707e-40, -9.61466416795571684509e-41, -5.40270052431547320367e-41, 9.12656829466439674412e-42, 4.65048642511527009058e-42, -8.21942976664866655192e-43, -3.83175637634968521876e-43, 7.05513038586766342728e-44, 3.03151596101831891428e-44, -5.79409746154449981442e-45, -2.30936262736640407936e-45, 4.56825070691042672611e-46, 1.69816457994346610992e-46, -3.46803409376766356033e-47, -1.20809620129024217949e-47, 2.54169559938756617164e-48, 8.33188873427173910434e-49, -1.80253527434318671441e-49, -5.58098219951369145982e-50, 1.23957353703540469213e-50, 3.63694530163938934748e-51, -8.28147131765466794842e-52, -2.30936507473058809791e-52, 5.38431298351950103332e-53, 1.43084628114036687457e-53, -3.41204102718212635734e-54, -8.66169842214589983607e-55, 2.11044475601112524375e-55, 5.12912788685782943559e-56, -1.27576979118675130856e-56, -2.9743717490301897928e-57, 7.54616201253815396542e-58, 1.69084290745394932018e-58, -4.37231588584784708386e-59, -9.4314898962346144446e-60, 2.48409510141604873905e-60, 5.16666023205496809787e-61, -1.38517046754463018317e-61, -2.78194853151832475238e-62, 7.58742141987432604412e-63, 1.47343446774168555039e-63, -4.08594304446547454617e-64, -7.68185530854127650696e-65, 2.16483430245628896229e-65, 3.94499056594701328399e-66, -1.12926687306777441725e-66, -1.99683884318228901257e-67, 5.80354774265281393117e-68, 9.96811654100677463814e-69, -2.9402409816760849456e-69, -4.91017126176382758073e-70, 1.46931680695782241015e-70, 2.38792015082550417813e-71, -7.24647296192899531069e-72, -1.14708517163667617668e-72, 3.52889061030654029196e-73, 5.44534259732824808187e-74, -1.6976912847926016022e-74, -2.55563133680948806664e-75, 8.07207312089166973045e-76, 1.18629869507283508037e-76, -3.79492478480066982773e-77, -5.44856987341818013528e-78, 1.76477235544120817901e-78},
            {7.70187751137402171977e-32, -1.35454106207379013718e-30, 8.71110979874287456659e-31, 5.35125036626299980417e-30, -4.63410668844947610146e-30, -7.8135567935402074575e-30, 7.71523128003981940251e-30, 6.16383487795142140746e-30, -6.94576772237905870131e-30, -3.1094727707766503489e-30, 4.11348594343303303201e-30, 1.09526307113937137887e-30, -1.77976588396489324708e-30, -2.80352614785641034329e-31, 6.00844824429198599189e-31, 5.14813013997658433873e-32, -1.65584133735587020353e-31, -5.76138721019411893159e-33, 3.84934234614998981371e-32, -1.23466533918029722137e-34, -7.73855276964949033724e-33, 2.53799705981091240946e-34, 1.37172333991995656109e-33, -7.76823907464874396396e-35, -2.17744609442366687079e-34, 1.66309216932483356881e-35, 3.13471695596826808635e-35, -2.91937565206154930588e-36, -4.135922602043058301e-36, 4.451546017724331832e-37, 5.04536450680151749747e-37, -6.07468814856586503052e-38, -5.73331196379138240661e-38, 7.55738526872562904562e-39, 6.10796384948556368676e-39, -8.68239597094029265416e-40, -6.13443906632583282007e-40, 9.30032419296291552292e-41, 5.83635539511717316026e-41, -9.35871040073209252421e-42, -5.28252351948572294249e-42, 8.90114574248398351617e-43, 4.56565451794033219959e-43, -8.04257718836359619774e-44, -3.78071049515779002806e-44, 6.93324255232904181529e-45, 3.00845910142138520812e-45, -5.72375934489315249128e-46, -2.30660535068085506899e-46, 4.53977667846334080036e-47, 1.70806323854839619744e-47, -3.46921416133641543166e-48, -1.22427485954476975959e-48, 2.56074732489323792287e-49, 8.51047259886615198463e-50, -1.82986690119307255478e-50, -5.74786894704329807538e-51, 1.26843433542041865407e-51, 3.77789138089213204885e-52, -8.54486802615318538753e-53, -2.4200959249789171198e-53, 5.60339130079285766125e-54, 1.51305252479720323509e-54, -3.58228221818233496433e-55, -9.24408704239641667828e-56, 2.23578761839783701201e-56, 5.5254848174422433896e-57, -1.36399296567568958274e-57, -3.2347642517990620706e-58, 8.14346826308955499447e-59, 1.85658947733777472256e-59, -4.76308125871613915773e-60, -1.0456688542302344168e-60, 2.73198549119820611118e-61, 5.78433412090632295096e-62, -1.53808238719274690715e-62, -3.14516750775957923352e-63, 8.50672172017106760639e-64, 1.68225729887157235709e-64, -4.62563337652989667607e-65, -8.85737590347688634275e-66, 2.47473222266721840901e-66, 4.59375795598645054204e-67, -1.30356818105034299582e-67, -2.34828112790154035135e-68, 6.76501935115577276594e-69, 1.18386791151599852586e-69, -3.46096879116432378043e-70, -5.88931526278582059078e-71, 1.74649408133635367735e-71, 2.8923984265558532735e-72, -8.69781114478393047708e-73, -1.40311664833684096903e-73, 4.2770589880411330638e-74, 6.72621214982276966846e-75, -2.07768326414097435504e-75, -3.18769163179071923927e-76, 9.9748666685756308732e-77, 1.49413105093022632268e-77, -4.73491951967543484148e-78, -6.92908671011733925658e-79},
            {5.45888787304374421485e-32, -8.58998463024419883279e-33, -5.27812170026726057638e-31, 4.09907526154637521706e-31, 1.24624996014482709173e-30, -1.14626234243391180015e-30, -1.3720283308664998753e-30, 1.4274912657740353491e-30, 9.00195325382614509789e-31, -1.07493439352377202208e-30, -3.97877720191850527284e-31, 5.63413757468342970426e-31, 1.26461605517766736418e-31, -2.23213919691864505899e-31, -2.9608178513892332852e-32, 7.05782157493317415118e-32, 4.92997206629390261056e-33, -1.85092845672675324759e-32, -4.48516444268279241089e-34, 4.14285496874010246608e-33, -4.34844202696475554721e-35, -8.09030383536668910278e-34, 3.0697207447255879358e-35, 1.40265432195109470262e-34, -8.45996842523981210307e-36, -2.18963742640258580192e-35, 1.7303213538776057696e-36, 3.11357478899696058702e-36, -2.95837220424155389872e-37, -4.07202030917443093045e-37, 4.4361520266973481132e-38, 4.93823156970017221131e-38, -5.98845055254892188647e-39, -5.59208066640965481249e-39, 7.39980485882410568576e-40, 5.94877164562828298374e-40, -8.46930378676241215636e-41, -5.97588809068890697002e-41, 9.0587747673794848121e-42, 5.69488995946044823923e-42, -9.11902480151811746587e-43, -5.16923116033723757251e-43, 8.6893346907294346966e-44, 4.48512978101374454234e-44, -7.87547901942667976756e-45, -3.73176135924454317031e-45, 6.81714990556732586992e-46, 2.98592492340290392207e-46, -5.65593956089592556798e-47, -2.30346471436919325618e-47, 4.51158441782957697201e-48, 1.71721684872961958951e-48, -3.46947221380449525267e-49, -1.23970544602857865866e-49, 2.57847812584756809541e-50, 8.68336231275372823193e-51, -1.85598265921747920145e-51, -5.91135317326520629468e-52, 1.29641790450392987169e-52, 3.91746122321039099795e-53, -8.80330543146306518787e-54, -2.53089142598597453365e-54, 5.82069408529491675249e-55, 1.59615368963331625526e-55, -3.7529190940672735363e-56, -9.83884740738982054872e-57, 2.36271989318275513287e-57, 5.93440617496952529101e-58, -1.45425102714749618018e-58, -3.50616516791989973022e-59, 8.76080017738068206098e-60, 2.0311172318800761959e-60, -5.17107454289113542958e-61, -1.15473054098111424735e-61, 2.99344985691935136913e-62, 6.44818855049204916308e-63, -1.70101623217854104462e-63, -3.53956503237968149593e-64, 9.49628795895991158946e-65, 1.91134165519439988311e-65, -5.21251192421785279122e-66, -1.01602318576896984513e-66, 2.81516777632893366284e-67, 5.32019505579953064136e-68, -1.49699818267336497951e-68, -2.74583629254548368594e-69, 7.8428701906264535525e-70, 1.39763416481451666351e-70, -4.05065629215564227574e-71, -7.01969387613255311208e-72, 2.06355715586608280027e-72, 3.48072064294259762097e-73, -1.03747594246292174091e-73, -1.70472594496162296194e-74, 5.15022700730807910031e-75, 8.2503225219761579193e-76, -2.52560613031053868055e-76, -3.94733601123437380251e-77, 1.22402012029462464496e-77, 1.86779851010000195715e-78, -5.86512729695531756999e-79},
            {-2.06047780933054449335e-33, 3.52372050684949982068e-32, -2.13876806718118625021e-32, -1.55870157820172199857e-31, 1.32489303283258793462e-31, 2.53711009672026317868e-31, -2.45931021542737880001e-31, -2.22642717213144938989e-31, 2.44147683739026023062e-31, 1.24972046991822787213e-31, -1.58424329349055378341e-31, -4.91784198585691165602e-32, 7.47391266998148067241e-32, 1.42342715824549241796e-32, -2.74006417301630571071e-32, -3.05899726178313161511e-33, 8.17128493199878299172e-33, 4.58537617171244392282e-34, -2.04904246003104768387e-33, -3.04818770032943563037e-35, 4.4305932646051470727e-34, -7.55729237128617732448e-36, -8.42470449107583635685e-35, 3.59187604308784147953e-36, 1.43105980794146388688e-35, -9.11669957607974655388e-37, -2.19959871123782908692e-36, 1.79222392357846327724e-37, 3.0919468101700297655e-37, -2.99230774595234145369e-38, -4.01057089076546211373e-38, 4.41863423954314209298e-39, 4.83689291331809588612e-39, -5.90510162229496360298e-40, -5.4594169517580850846e-40, 7.25070746844844367889e-41, 5.79961540782404513519e-41, -8.26919096590283190317e-42, -5.82728557836800211376e-42, 8.8324401500232343872e-43, 5.56196968988998492949e-43, -8.89423712828442307144e-44, -5.06231148376111260792e-44, 8.49005763120999543432e-45, 4.40864275327908436609e-45, -7.71744876909302847267e-46, -3.68482529751097612065e-46, 6.70653021182667387239e-47, 2.96394067586189237821e-47, -5.59057930475668862213e-48, -2.30001279651527683144e-48, 4.48375960161775596094e-49, 1.72569813523559956009e-49, -3.46894044887362879329e-50, -1.25444007186210753237e-50, 2.59500589899748815279e-51, 8.85083039139362343297e-52, -1.88096059404825222583e-52, -6.07150914311445969525e-53, 1.32356121412659254781e-53, 4.05561049625489797287e-54, -9.05685035373501758633e-55, -2.64165949339348187547e-55, 6.03611998452213819546e-56, 1.6800569175720956055e-56, -3.92379213969441257994e-57, -1.04452731853565760572e-57, 2.49109228636684861959e-58, 6.35546456602245675571e-59, -1.54643549624101366673e-59, -3.78838701860356291588e-60, 9.3975303689184106681e-61, 2.21440451139181546763e-61, -5.59604242135841426477e-62, -1.27040551324777770723e-62, 3.26848397888225947814e-63, 7.15931716056363231209e-64, -1.87410197461995734429e-64, -3.96626593534296406332e-65, 1.05579213561272240704e-65, 2.16166533250386864393e-66, -5.84836905612747835791e-67, -1.15981033739653995712e-67, 3.18766881768573228458e-68, 6.12991734241277846891e-69, -1.71074271042307396714e-69, -3.19338923444695489383e-70, 9.04569790139376597396e-71, 1.64067943176111627669e-71, -4.71521455748858558622e-72, -8.31765822599758077342e-73, 2.42439651655919485303e-73, 4.16295351163893714253e-74, -1.23019905651214245705e-74, -2.057930721663258557e-75, 6.1635430197713295319e-76, 1.00527049701271552643e-76, -3.05049665039276806617e-77, -4.85447178091227625372e-78, 1.49206053630453414787e-78, 2.31836625416604440184e-79},
            {-1.33655450107482443481e-33, 9.36489129493155508793e-35, 1.45031438869135165618e-32, -1.09529406580165589097e-32, -3.81284399900290122638e-32, 3.44874738946186321076e-32, 4.65927000142731294408e-32, -4.74760836901891055612e-32, -3.38893339833322455495e-32, 3.92091646019741970199e-32, 1.66259087012759591493e-32, -2.24192944935905310913e-32, -5.89865648887596147447e-33, 9.64839106824236949697e-33, 1.56566174914357804305e-33, -3.30185762257494175828e-33, -3.09275771611142172401e-34, 9.34169669288873607205e-34, 4.11792306445929705379e-35, -2.24912763299874022958e-34, -1.46814087222143415254e-36, 4.71190012056866046437e-35, -1.08357059694569202352e-36, -8.74235682535872199688e-36, 4.10293503646367685888e-37, 1.45715173280960648341e-36, -9.73977752342765457676e-38, -2.20761394034573378629e-37, 1.84925979954011352768e-38, 3.07002742704403540368e-38, -3.02179250500790813446e-39, -3.95151614370705059567e-39, 4.39943993682066847042e-40, 4.74095780337485760846e-40, -5.82463847486595186359e-41, -5.33463797878186810753e-41, 7.10952267711536203815e-42, 5.65965613425927397091e-42, -8.08101476487289916106e-43, -5.68780428935736049976e-43, 8.62004912941961948036e-44, 5.43691515158961994747e-44, -8.68312387329594329116e-45, -4.96130104928632286976e-45, 8.3023453018695817614e-46, 4.33594491030728286197e-46, -7.56786064557465954823e-47, -3.63982081072351382068e-47, 6.60108178513792967787e-48, 2.9425267591347219783e-48, -5.5276153310500535819e-49, -2.29631313018184544258e-49, 4.45637339671343721128e-50, 1.73357345603684400878e-50, -3.46773670396935204429e-51, -1.26852767828926448103e-51, 2.61043902788239286791e-52, 9.01314343792442964358e-53, -1.90487466010224704016e-53, -6.22841951290824996496e-54, 1.34990104693047018091e-54, 4.1923075486787339517e-55, -9.30558704683336301405e-56, -2.75231898213425688702e-56, 6.24958905522596178387e-57, 1.76467627557445137855e-57, -4.09475885438012180067e-58, -1.10626886082022876911e-58, 2.62076556159960038373e-59, 6.78823638799968842627e-60, -1.6404418511237110387e-60, -4.08123239187898882291e-61, 1.00530314047894630463e-61, 2.40641576018130413348e-62, -6.03771275128452736846e-63, -1.39275291110331567663e-63, 3.55706066976514821672e-64, 7.91872745747437692509e-65, -2.05745027670222806046e-65, -4.42634662420975498157e-66, 1.1693293136624105199e-66, 2.43418668138827400007e-67, -6.53492500573886661695e-68, -1.31786591607049951331e-68, 3.59373733575531270013e-69, 7.02862213299975427949e-70, -1.94598879724422052303e-70, -3.69493886858911795269e-71, 1.03822445863075551247e-71, 1.91568405342895709931e-72, -5.46074008382223995986e-73, -9.80048825436272742423e-74, 2.8330784147176640273e-74, 4.94986770358003093267e-75, -1.45056204852145337992e-75, -2.46924697735057811596e-76, 7.33323798965639442416e-77, 1.21717370727406618473e-77, -3.66215253659851316092e-78, -5.93115843779822280136e-79, 1.80736911603185217135e-79},
            {5.4524805137535226471e-35, -9.14907363412796721198e-34, 5.20451779279015204412e-34, 4.50425256534554122068e-33, -3.75593074965009560922e-33, -8.12570049940633809265e-33, 7.74224629453407639169e-33, 7.8852207518226459943e-33, -8.4423932926675304567e-33, -4.89228872681657439725e-33, 5.98030025194951676923e-33, 2.13284682171028466226e-33, -3.06585593939313791906e-33, -6.89034900990195456049e-34, 1.21679846038109080778e-33, 1.68580278946211962832e-34, -3.91528404136727900946e-34, -3.05834240547718929333e-35, 1.05620723752672891804e-34, 3.53259526436305635212e-36, -2.45025813329004572325e-35, 2.37979657947449006706e-38, 4.98629822462205425782e-36, -1.41615798612698299806e-37, -9.04393964955445989875e-37, 4.6017806712120277587e-38, 1.48112736319272666283e-37, -1.03306762874452260382e-38, -2.21393340219385869225e-38, 1.90185199670199159905e-39, 3.04797788713111737245e-39, -3.04736229044144701037e-40, -3.8947897864622865048e-40, 4.37894547957467460845e-41, 4.65006735698719479723e-41, -5.74703511906969442703e-42, -5.21713010814466639635e-42, 6.97572679216400640768e-43, 5.52814426304710245269e-43, -7.90383948381420216837e-44, -5.55670472697515985289e-44, 8.42046601579188781632e-45, 5.31911591187934374006e-45, -8.48458947487676892629e-46, -4.86577945811445907536e-46, 8.12532373047909385054e-47, 4.26680682930918943282e-47, -7.42614328086496258831e-48, -3.59666891727602926561e-48, 6.50052230979918108484e-49, 2.92169785223567280219e-49, -5.4669814395106117998e-50, -2.29242172157603081302e-50, 4.42948456410516564795e-51, 1.74090337007001511778e-51, -3.46596603833045525425e-52, -1.28201418036892746316e-52, 2.62487713232035283061e-53, 9.17056109337002552795e-54, -1.92779481235713948404e-54, -6.38217351846927815381e-55, 1.37547375597803670573e-55, 4.3275318905167277919e-56, -9.54961410769488656763e-57, -2.86279882610400954138e-57, 6.46104044205396016654e-58, 1.84993248725885917971e-58, -4.26569256986408722418e-59, -1.16904493828148839745e-59, 2.75161027010786280215e-60, 7.23230410462089169549e-61, -1.73616976196652925751e-61, -4.38449615000613380946e-62, 1.07266797360404379558e-62, 2.60710305225018437844e-63, -6.49579804144178520287e-64, -1.52182033147465516626e-64, 3.85913203663502317894e-65, 8.72734307951256341995e-66, -2.25115356484329999344e-66, -4.92083424137348524017e-67, 1.29039469687823122601e-67, 2.72984258291481120931e-68, -7.27382791840340278066e-69, -1.49095359709914148051e-69, 4.03484602459316252103e-70, 8.02207301884925890302e-71, -2.20392143502153904709e-71, -4.25458844401928437849e-72, 1.18613730496076019384e-72, 2.22543488238104164964e-73, -6.29350047209295775036e-74, -1.14863773890763296145e-74, 3.29383804926197858628e-75, 5.85294086888236509043e-76, -1.70131891174671253372e-76, -2.94570007658954034735e-77, 8.67663298868949201105e-78, 1.46492707862371795891e-78, -4.37115099280795197039e-79, -7.2017224750550748859e-80},
            {3.27698366677765892701e-35, 7.04054477167461606167e-37, -3.96646490043375195828e-34, 2.9069105933607962178e-34, 1.15463271876745927766e-33, -1.02734664443454609964e-33, -1.55754623899997150367e-33, 1.55736931981248828295e-33, 1.24868160522460585847e-33, -1.40549288694713340133e-33, -6.754465781602960475e-34, 8.73745472098776460421e-34, 2.65128230889940995239e-34, -4.07191966537853642679e-34, -7.8605853736747570293e-35, 1.50382996282055029096e-34, 1.77895106990473424384e-35, -4.57769550320445154507e-35, -2.95337946660358711962e-36, 1.18257069297828344843e-35, 2.83537883722901032856e-37, -2.65163040629860382826e-36, 2.05410040697766995912e-38, 5.25346064874017001945e-37, -1.75159110758260201058e-38, -9.33018005841574692262e-38, 5.087633131497629752e-39, 1.50316949966687044455e-38, -1.08909429920497772797e-39, -2.21877771237526445662e-39, 1.95038854768320559764e-40, 3.02593168669632591332e-40, -3.06948811298649548039e-41, -3.84032019878498446125e-41, 4.35746780283800343787e-42, 4.56389173767260947184e-42, -5.67224825796733597485e-43, -5.10634053637027508731e-43, 6.84883865266875975863e-44, 5.40440824569770947871e-44, -7.73682328963545978329e-45, -5.43332398307335116834e-45, 8.23267331841709407571e-46, 5.20802214297678014027e-46, -8.29765030910970473305e-47, -4.77536458464378963087e-47, 7.95820306403519250307e-48, 4.20101652153607704794e-48, -7.29177418343252579714e-49, -3.55529338356276979443e-49, 6.40458766504753678805e-50, 2.90146386137954014011e-50, -5.40860965736547142494e-51, -2.28838794223942469816e-51, 4.40314125651254987948e-52, 1.7477431569339757211e-52, -3.46372213664853839196e-53, -1.2949426173523297743e-53, 2.6384117695503227422e-54, 9.32333526748614828366e-55, -1.94978712656070942381e-55, -6.53286542434020001486e-56, 1.40031507292033346941e-56, 4.46127282245378198108e-57, -9.78904178726898999419e-58, -2.97303721948966154723e-58, 6.67043025579339036115e-59, 1.93575264304083100381e-59, -4.43648130304988700181e-60, -1.23279431866569857515e-60, 2.88350642979522473558e-61, 7.6872581643281737136e-62, -1.83352325504794284315e-62, -4.69796742844364167442e-63, 1.14178590834296522192e-63, 2.81640754343607331149e-64, -6.96999863920166982718e-65, -1.6576446176528468747e-65, 4.17463165940251289677e-66, 9.58600648845542195502e-67, -2.45528713741482968675e-67, -5.45070626233936380561e-68, 1.41913021449540503788e-68, 3.04954674126890911563e-69, -8.06665259436653975152e-70, -1.67983198640168466451e-70, 4.51243532638192150102e-71, 9.11608491709838104418e-72, -2.48572057538674678528e-72, -4.87653583531820506538e-73, 1.34920437980097938018e-73, 2.57282017621513015946e-74, -7.21991995146442229836e-75, -1.33944138580599433282e-75, 3.81107223817104739059e-76, 6.88435795630691249194e-77, -1.98536359206420328009e-77, -3.49483400315377526384e-78, 1.02121425482361015153e-78, 1.75307508685641087307e-79, -5.18886461563271560775e-80},
            {-1.43084972698944640502e-36, 2.37147922285146456497e-35, -1.25418598163080476014e-35, -1.29241963490104083473e-34, 1.0565190893044289073e-34, 2.57070339874830275981e-34, -2.40989173898054820098e-34, -2.74418350150701932678e-34, 2.87606183222919687278e-34, 1.87130212766429511923e-34, -2.21658069014466070307e-34, -8.97680553495189244456e-35, 1.23100389544193409023e-34, 3.20593077612011042516e-35, -5.27379617433257169475e-35, -8.77678118623337380935e-36, 1.82606128107464139753e-35, 1.84087705848184350799e-36, -5.28615474321355317824e-36, -2.77670346787622134669e-37, 1.3126258866921809522e-36, 2.03293206540284092511e-38, -2.85255401647561339491e-37, 3.96521460428208693997e-39, 5.51318517864910196782e-38, -2.08824841387948974024e-39, -9.6018314428272865e-39, 5.55998772781046036225e-40, 1.52344695676660700092e-39, -1.14221558178174885434e-40, -2.2223413831462191577e-40, 1.99522469267424558531e-41, 3.00399906856518546971e-41, -3.08858451420459732099e-42, -3.78803252294857759828e-42, 4.33527392787818448352e-43, 4.48212757736381694343e-43, -5.60022183282805996383e-44, -5.00177009516072606895e-44, 6.7284157956201948629e-45, 5.28784481108220763152e-45, -7.57920691868793895913e-46, -5.31706622561676897872e-46, 8.05575698806146746701e-47, 5.10313740807991285444e-47, -8.12142099756927349765e-48, -4.68970841662793418319e-48, 7.80026790735210250031e-49, 4.13837791863205367703e-49, -7.16427482758314986493e-50, -3.51562086542238823692e-50, 6.31303077424744102661e-51, 2.8818307189597160392e-51, -5.35243117639908587364e-52, -2.28425531137531245455e-52, 4.37738255604453869292e-53, 1.75414329150631525006e-53, -3.46108855430481440963e-54, -1.30735330577203508004e-54, 2.65112708700863686265e-55, 9.47170959912686007532e-56, -1.97091393945020413648e-56, -6.6805932009172711487e-57, 1.4244599585022959587e-57, 4.59352820290679041181e-58, -1.00239896577004307228e-58, -3.08298084283139077786e-59, 6.87772964088053486429e-60, 2.02206989663815186118e-60, -4.60702665239675194099e-61, -1.29745898148921353218e-61, 3.01634316696726994869e-62, 8.15269859774153673117e-63, -1.93241081657414225913e-63, -5.02143143555891254996e-64, 1.21259633263067697524e-64, 3.03426084436145390106e-65, -7.46000563445629383972e-66, -1.80025264828631755116e-66, 4.50347667330993510916e-67, 1.04954820053257402796e-67, -2.66991028966817315991e-68, -6.01689048797763526054e-69, 1.55566573807630035796e-69, 3.39418827650558562048e-70, -8.91489986231768708833e-71, -1.88525292009405780768e-71, 5.02791092758766829625e-72, 1.03165098237482409005e-72, -2.79255837847230675908e-73, -5.5650638969363485881e-74, 1.52832929486136510869e-74, 2.96082426009189822172e-75, -8.2465648846983599861e-76, -1.55445590027922246777e-76, 4.38933167390953789198e-77, 8.0570089698092977739e-78, -2.30572705476589605381e-78, -4.12471885146879001653e-79, 1.19592740462815886978e-79, 2.08653232332453929331e-80},
            {-8.04486367762974225955e-37, -9.41900244232988845567e-38, 1.08024285380892529397e-35, -7.66527061505339121127e-36, -3.46458052225626898553e-35, 3.03265260879592789469e-35, 5.13393543341910707985e-35, -5.04487743697723501755e-35, -4.51367477554281488566e-35, 4.95865772106184628328e-35, 2.6769359064793388397e-35, -3.34111149958406185239e-35, -1.15433547193073848493e-35, 1.68124436697251238113e-35, 3.78262471071713331675e-36, -6.68281295338411107782e-36, -9.60709991257655130647e-37, 2.18324064801504618219e-36, 1.86803505609580971838e-37, -6.03754047001099381964e-37, -2.52817616071424249344e-38, 1.44578038960925951031e-37, 1.13231543348460176242e-39, -3.05244172688538079455e-38, 5.9574573120877331483e-40, 5.7653721469781796254e-39, -2.42475669565229917378e-40, -9.85965666887786260374e-40, 6.01856278198458067452e-41, 1.54211521900656397559e-40, -1.1925892745306839399e-41, -2.22479597302851736503e-41, 2.03668518346061659041e-42, 2.98227076939639593635e-42, -3.10501677553416549417e-43, -3.73785026877919866531e-43, 4.31258885851510560665e-44, 4.40449561902985293779e-44, -5.53089058236916361215e-45, -4.90296703359073789647e-45, 6.61405096650035842222e-46, 5.1779106372713892963e-46, -7.43030395586658600623e-47, -5.2073945553547811738e-47, 7.88889379514878992251e-48, 5.00401244237105564301e-48, -7.95510265295356919948e-49, -4.60849341675656745228e-49, 7.65086894157135095904e-50, 4.07870949974870691231e-50, -7.0432063001042742446e-51, -3.47758098137982822059e-51, 6.22562049353070153569e-52, 2.86280105717915498533e-52, -5.2983770916479692932e-53, -2.28006218235317948311e-53, 4.35223979085688856587e-54, 1.76014987661325350551e-54, -3.4581398221883065839e-55, -1.31928399226189856001e-55, 2.66310042775216742566e-56, 9.61591910344630832528e-57, -1.99123400233458555173e-57, -6.82545740007922969223e-58, 1.44794248841376090902e-58, 4.7243033419030816483e-59, -1.02545845945712668418e-59, -3.19258413539554570038e-60, 7.08292302076683771645e-61, 2.10882315432290947883e-61, -4.77724274409994297652e-62, -1.3629841038194830592e-62, 3.15001833192241015162e-63, 8.62823632837714329605e-64, -2.03274544525370998993e-64, -5.3546710636546325329e-65, 1.28503989410790125056e-65, 3.26058631074130916113e-66, -7.96550349082815023449e-67, -1.94966211764141881873e-67, 4.8455697466106883271e-68, 1.14564591163871287489e-68, -2.89506744192993497289e-69, -6.62026538525924931374e-70, 1.70011951195961110829e-70, 3.76463059894463724131e-71, -9.81999651888677823975e-72, -2.10795993638144971967e-72, 5.58264168520272504731e-73, 1.16292233332401243573e-73, -3.1255967114596717116e-74, -6.32453095819092285853e-75, 1.72442111611261020444e-75, 3.39252201843002928574e-76, -9.38012937903503577483e-77, -1.7957622947176922928e-77, 5.03331285368387416128e-78, 9.38448431665144501647e-79, -2.66557391816035281649e-79, -4.84395658459164700824e-80, 1.39386233357555067319e-80},
            {3.73043588759724872327e-38, -6.13778879720329866761e-37, 2.98940612452774589035e-37, 3.68483477404915108157e-36, -2.95063369018497910717e-36, -8.04362673675454762348e-36, 7.423807956128540049e-36, 9.40146915463128486338e-36, -9.66509145780117823654e-36, -7.01158566024472514642e-36, 8.07932459412972737112e-36, 3.68007324112788451092e-36, -4.84668694741937973717e-36, -1.44212333192157020734e-36, 2.23531993223543073843e-36, 4.36557571627200469658e-37, -8.30792813884996609929e-37, -1.03212340997229496518e-37, 2.57479229821099879943e-37, 1.85754932861220327974e-38, -6.8286352972535475133e-38, -2.20851495877672924036e-39, 1.58148647552242061402e-38, 1.40775808954698144929e-41, -3.25079940741626872757e-39, 8.01813008117836368182e-41, 6.01000545309977541206e-40, -2.75996232751395915278e-41, -1.0104415372012501401e-40, 6.46325609599097490159e-42, 1.55931719990536938793e-41, -1.24037086670323894744e-42, -2.22629285842273031864e-42, 2.07506659929995491182e-43, 2.96082114748838828131e-43, -3.11910715881034669251e-44, -3.68969653246100330184e-44, 4.28960215505705003713e-45, 4.33073856882182418928e-45, -5.4641828291663753038e-46, -4.80952163231806853353e-46, 6.50536895185807362706e-47, 5.07411520107207309868e-47, -7.2894924413040710605e-48, -5.10382400878027399327e-48, 7.73134049409743905385e-49, 4.91023977382610353152e-49, -7.79797275291761256986e-50, -4.53142933220305440877e-50, 7.50941563177472434478e-51, 4.02184304680622645847e-51, -6.9281654351518691664e-52, -3.44110633393306626176e-52, 6.14214054942849341358e-53, 2.84437477644266844002e-53, -5.24637897959640770257e-54, -2.27584234560966977568e-54, 4.3277376636942192364e-55, 1.76580503691598685517e-55, -3.454942427154657128e-56, -1.33077000390724792481e-56, 2.67440289024072450471e-57, 9.75618997036176177272e-58, -2.01080264282667482618e-58, -6.96756020331765740824e-59, 1.4707957685468971875e-59, 4.85361001103072978173e-60, -1.04809590370314074288e-60, -3.30180861428294490498e-61, 7.28600650919961025574e-62, 2.19595676205697607339e-62, -4.94705523200805302327e-63, -1.42931802229601604489e-63, 3.28443809772442259184e-64, 9.11349422863192772984e-65, -2.13444466167153805852e-65, -5.69746832276435065213e-66, 1.35905870337827569333e-66, 3.49530024940880888898e-67, -8.4861724166957419937e-68, -2.10588230040031317762e-68, 5.2008009476132080561e-69, 1.24695559832933907669e-69, -3.13078925933822619894e-70, -7.26166073306785651576e-71, 1.85259862394281488175e-71, 4.16171054569562725079e-72, -1.07832957713749674818e-72, -2.34868691666111643519e-73, 6.17795795777097057085e-74, 1.30601119732536122832e-74, -3.48598489553695962962e-75, -7.15936152686763631711e-76, 1.93839236867910060231e-76, 3.87107327205673097106e-77, -1.06274211127851445271e-77, -2.06552379754352798588e-78, 5.74784977050118894978e-79, 1.08810679145983303371e-79, -3.06819870556421662787e-80, -5.66168510274915026398e-81},
            {1.97732098419305545099e-38, 4.2813719989192959659e-39, -2.93089580881246389284e-37, 2.00871470296225415493e-37, 1.03100680158706282736e-36, -8.87767533588094754784e-37, -1.67090997393871665396e-36, 1.61551309006240260383e-36, 1.60381464396346600323e-36, -1.72412814971512591327e-36, -1.03780783439067629901e-36, 1.25550451765765289752e-36, 4.88785770294223364054e-37, -6.80329424810218770571e-37, -1.75618130227190232781e-37, 2.9032933244803739799e-37, 4.93793572371453250061e-38, -1.01557913562081520583e-37, -1.08909831167215897968e-38, 2.99987090356446502848e-38, 1.80718047132877508315e-39, -7.65619749915080556077e-39, -1.81913429944156111567e-40, 1.7192422861144317035e-39, -9.34422672834347676961e-42, -3.44721616283453449237e-40, 1.01356894277385067036e-41, 6.24713642575857738573e-41, -3.09290462926604017239e-42, -1.03368545127776075616e-41, 6.89410873151953132874e-43, 1.57518405222899810528e-42, -1.28571189690042591961e-43, -2.22696566810422808317e-43, 2.1106396075201657499e-44, 2.93971079831390611546e-44, -3.13114031095366985018e-45, -3.64349491438097735761e-45, 4.2664734225489060698e-46, 4.26061914412558336573e-46, -5.40002265788767625881e-47, -4.72106152450120555166e-47, 6.40202370946476469335e-48, 4.97601461687269923201e-48, -7.15620759945982694691e-49, -5.00591552483729643574e-49, 7.58242448781123901312e-50, 4.8214490555620312689e-50, -7.6493763873043528564e-51, -4.45825039008995692149e-51, 7.37536986432218618442e-52, 3.96762251604648448502e-52, -6.81878137735697094527e-53, -3.40613249162328682938e-53, 6.06238853111891084743e-54, 2.82654952525275846927e-54, -5.196369346510374206e-55, -2.27162555857232806219e-55, 4.30389522010104229769e-56, 1.77114727711576671456e-56, -3.45155568241561770988e-57, -1.34184439453447683318e-57, 2.68509984464337456545e-58, 9.8927394846852597214e-59, -2.02967193066787647687e-59, -7.10700461948277158646e-60, 1.49305187462487584773e-60, 4.98146555919302109939e-61, -1.0703249492444449941e-61, -3.41062223982532457931e-62, 7.48698647534150635132e-63, 2.28342019459691078652e-63, -5.11640035349192567557e-64, -1.49641217588753842384e-64, 3.41951654981339531584e-65, 9.60810795069641378591e-66, -2.23743048157889821418e-66, -6.04960560914276996328e-67, 1.43459650089029968793e-67, 3.7383130398869667164e-68, -9.02169049004350072465e-69, -2.26891479558351818112e-69, 5.56904949778317901889e-70, 1.35353230988760763793e-70, -3.3770937533852002417e-71, -7.9418585321308456864e-72, 2.01319950694030957219e-72, 4.58623775924175359825e-73, -1.18060781235907740811e-73, -2.6081568911309693163e-74, 6.81515031434476009921e-75, 1.46150613884395280514e-75, -3.87485769715639228725e-76, -8.07403725984879925656e-77, 2.17115716034567087706e-77, 4.39971709288983468577e-78, -1.19953474741644973457e-78, -2.36598299655897509855e-79, 6.53790544551824180466e-80, 1.256172823516106516e-80, -3.51702176684617683253e-81},
            {-9.67539522417585094919e-40, 1.58644803489764146033e-38, -7.03567708619375775249e-39, -1.0445598962551307258e-37, 8.18555570915939522713e-38, 2.49184062299734453221e-37, -2.26527881883295856478e-37, -3.17562034785329161602e-37, 3.20755862873164131232e-37, 2.57898188500515491789e-37, -2.89992345199647407581e-37, -1.47381461305436159147e-37, 1.8740829469772144057e-37, 6.29926660273678984115e-38, -9.28174690301791160097e-38, -2.09024776138429275045e-38, 3.69428676601864442082e-38, 5.48231273771131894969e-39, -1.22308651246360845428e-38, -1.1290649866302579951e-39, 3.45741305252997203649e-39, 1.71527875863566242996e-40, -8.51701822809174530681e-40, -1.36200264407276652273e-41, 1.85859164153256693794e-40, -2.0861282660404601587e-42, -3.64135493236526364739e-41, 1.22997101715523815325e-42, 6.47687018567879479251e-42, -3.42279155375462817713e-43, -1.05577015050821420258e-42, 7.31127497745759093118e-44, 1.58983599325008601141e-43, -1.32875880948402497789e-44, -2.22693241903903838402e-44, 2.14365112647918328193e-45, 2.91898874558348262539e-45, -3.14136794817598148692e-46, -3.5991702023279090993e-46, 4.2433369048402082292e-47, 4.19391830277708081844e-47, -5.33833161381315437535e-48, -4.63724761896239689616e-48, 6.30369577120853914429e-49, 4.88320630988940172575e-49, -7.02993552065737899605e-50, -4.9132707251346652796e-50, 7.4415357572031088866e-51, 4.73730300321617424964e-51, -7.508718668218490584e-52, -4.38871282630747928796e-52, 7.24824038032977566866e-53, 3.91590301487806412018e-53, -6.71471252096319062747e-54, -3.37259794187351742785e-54, 5.98617494009268665304e-55, 2.80932110557470148184e-55, -5.14828197173561466995e-56, -2.26743801184362675674e-56, 4.28072667980585105682e-57, 1.77621180745967242663e-57, -3.44803250054122528207e-58, -1.35253808582440602902e-58, 2.69525140810252347153e-59, 1.00257760433542340422e-59, -2.04789084451730238233e-60, -7.24389381205182543865e-61, 1.51474181194116820293e-61, 5.10789212446101095534e-62, -1.09215952557150455798e-62, -3.51899882617663993742e-63, 7.68587825080986083594e-64, 2.3711677497720046289e-64, -5.28522404212238598245e-65, -1.56422103327336847104e-65, 3.55517527268850808641e-66, 1.01117265596698241025e-66, -2.3416293593603651594e-67, -6.41086682053054899061e-68, 1.51159879139332605469e-68, 3.98953017250950341503e-69, -9.57173555206630088083e-70, -2.438754245341672338e-70, 5.95018540967917224344e-71, 1.46542470372169066438e-71, -3.63398735731659948794e-72, -8.66159414079994360089e-73, 2.18200846336086347164e-73, 5.03899428786108073897e-74, -1.28895526477695260433e-74, -2.88708100291090969608e-75, 7.49546859363752322866e-76, 1.62999453935144171716e-76, -4.29333355722735421418e-77, -9.07308825011597980286e-78, 2.42362942854714333579e-78, 4.98176610382163319168e-79, -1.34909020956625175068e-79, -2.6994588214205071853e-80, 7.408563376247836433e-81, 1.44421074659939594749e-81},
            {-4.86532372062080298295e-40, -1.55512601016235040871e-40, 7.92499310678307735467e-39, -5.23200718133248824134e-39, -3.04517938077288223379e-38, 2.57884493435386063082e-38, 5.37609553999623608231e-38, -5.11885275913422336892e-38, -5.61106750221186957541e-38, 5.91494139810046251674e-38, 3.94467212422147920839e-38, -4.64263115237147779328e-38, -2.01926292151031418363e-38, 2.70236189872632534816e-38, 7.90474106229140305654e-39, -1.23522456737118990856e-38, -2.43687517981063633032e-39, 4.6163818511967762564e-39, 5.98122516866649981245e-40, -1.45355879901075146961e-39, -1.14972830199609593674e-40, 3.9461845591848509762e-40, 1.58072980749092764671e-41, -9.40796600786443400328e-41, -8.39516195187840564654e-43, 1.99912287061902506994e-41, -3.30739848017687348148e-43, -3.83294371139936887619e-42, 1.45008320553726024003e-43, 6.69935418293367818693e-43, -3.74897774894441933723e-44, -1.07676593631153594864e-43, 7.71499752950994656215e-45, 1.603383120216154093e-44, -1.36965219296514796586e-45, -2.22629738883830661084e-45, 2.17432636587079086252e-46, 2.89869427987795427139e-46, -3.15001291946574371744e-47, -3.55664887176115290593e-47, 4.22030533994347482812e-48, 4.13043363848048618588e-48, -5.27903002223982694087e-49, -4.55777053820584466105e-49, 6.21008989446244994834e-50, 4.79532439586398807541e-50, -6.91020765373643775896e-51, -4.82552738345754753225e-51, 7.30811986159948268342e-52, 4.65749384856738864479e-52, -7.37545812822665110014e-53, -4.32259270302888573328e-53, 7.1275778929439490922e-54, 3.86654987389890097088e-54, -6.6156437795986456076e-55, -3.34044402241560602876e-55, 5.9133222980307865977e-56, 2.79268381534210288242e-56, -5.10205216610673757288e-57, -2.26330273967467253964e-57, 4.25824215118743662428e-58, 1.78103083937178531192e-58, -3.44442008030705906128e-59, -1.36288000250209963356e-59, 2.70491288152525941502e-60, 1.0155499249403591562e-60, -2.06550543732226386639e-61, -7.37833053832199908776e-62, 1.53589549161090719806e-62, 5.23291593293995941674e-63, -1.11361373167254406528e-63, -3.62691749554006237495e-64, 7.88270496707947860313e-65, 2.45915825040245642323e-65, -5.45348109696529303248e-66, -1.6327020081933044411e-66, 3.69134293868201264332e-67, 1.06240129937844791713e-67, -2.44697210715584448281e-68, -6.78103833018093557956e-69, 1.59001294963716325089e-69, 4.24885320501749068326e-70, -1.01359868849314602395e-70, -2.61538902536880739947e-71, 6.34407101019274002275e-72, 1.58267542533460629401e-72, -3.9014659690225458626e-73, -9.4215576012372275121e-74, 2.3591022049035836298e-74, 5.52073438784485665388e-75, -1.40348585890201066271e-75, -3.18615762368123153391e-76, 8.22012128530687875637e-77, 1.81206159044782299331e-77, -4.7425130500554973299e-78, -1.01610846709398029811e-78, 2.69672131385726689335e-79, 5.62060080698049051058e-80, -1.51211518545891049947e-80, -3.06834339740522103101e-81, 8.36501896900315492885e-82},
            {2.49892881843733377017e-41, -4.09563669450069762226e-40, 1.63103191629014081925e-40, 2.94564052951219774392e-39, -2.25662870528541781396e-39, -7.64984055639989965048e-39, 6.85178336829033142312e-39, 1.05896453495276295548e-38, -1.05228013558743309002e-38, -9.32854921505508300643e-39, 1.02621292536910549691e-38, 5.78003175579596657195e-39, -7.1267648346972100426e-39, -2.68105686120090691313e-39, 3.78153688739986357222e-39, 9.68621782465320635599e-40, -1.60831074017202644121e-39, -2.78766145667600185137e-40, 5.67656363908350565157e-40, 6.41748712045799638655e-41, -1.70705636636127068875e-40, -1.14907920743129414965e-41, 4.46482294940062932775e-41, 1.40289662251303357738e-42, -1.03260203239771282837e-41, -2.54389279849377170082e-44, 2.14046695770868134213e-42, -4.59157008267380151367e-44, -4.02176747402764989791e-43, 1.67306959811345061922e-44, 6.91476861023827775831e-44, -4.07094493653785968268e-45, -1.0967403423401453773e-44, 8.10558704324180417267e-46, 1.6159261995166302792e-45, -1.40852630955732637123e-46, -2.22515275679281800289e-46, 2.20287073138737622677e-47, 2.87885850406931593907e-47, -3.1572727353358984447e-48, -3.5158594435776007668e-48, 4.19747320331381957134e-49, 4.06997792782626646425e-49, -5.222038007820919343e-50, -4.48234749793295492349e-50, 6.12093293883850629587e-51, 4.71203566108198075439e-51, -6.79659599181656565954e-52, -4.74235548145815080547e-52, 7.18167184901557339387e-53, 4.58174023509601447327e-53, -7.24910096112601690891e-54, -4.25968397688130521089e-54, 7.01297079362452681624e-55, 3.81943780485895537445e-55, -6.52128414716687196719e-56, -3.309614837420203407e-56, 5.84366431227981553005e-57, 2.77663073787430758242e-57, -5.05761696183827624832e-58, -2.25923998170882778851e-58, 4.2364482457101181617e-59, 1.78563385385644910884e-59, -3.44076051732038211314e-60, -1.3728972011396035627e-60, 2.71413515051094260063e-61, 1.02821000658493604239e-61, -2.08255899848299226315e-62, -7.51041668514639107962e-63, 1.55654172030047075162e-63, 5.35656667621485566531e-64, -1.13470174322868328649e-64, -3.7343621741485110857e-65, 8.07749651219509239723e-66, 2.54735475571290244162e-66, -5.62113440750585286908e-67, -1.70181536562733120403e-67, 3.82795490281362844435e-68, 1.11446443743481131314e-68, -2.55339379440675560875e-69, -7.15990983135643159536e-70, 1.66978830070013392296e-70, 4.51618064026712093849e-71, -1.07141266892176320773e-71, -2.79880190455935268313e-72, 6.75056235092425131603e-73, 1.70532148940972335372e-73, -4.17951595644644533639e-74, -1.02223951234433565469e-74, 2.54454840137205257239e-75, 6.03218450791959587634e-76, -1.52430672524331720904e-76, -3.50607161309261767224e-77, 8.99027520543323164693e-78, 2.0082893746603699333e-78, -5.22347756239954061683e-79, -1.13426288101321753696e-79, 2.99134166135870722722e-80, 6.31966397905264774856e-81, -1.68932243985134621342e-81, -3.47509880099291691832e-82},
            {1.19836319861660457762e-41, 5.10802282818687197992e-42, -2.13625743513567376287e-40, 1.35458975187604023295e-40, 8.93296452334119924729e-40, -7.43777868949084415384e-40, -1.71174281617818028219e-39, 1.60616591397573178266e-39, 1.93562251285315524605e-39, -2.00425662875685442868e-39, -1.47280330544876254149e-39, 1.6914433357221445929e-39, 8.1597217482372282365e-40, -1.05512999643582445402e-39, -3.46232373195950827381e-40, 5.15457526137657677642e-40, 1.1617496584644653759e-40, -2.05396880629862181124e-40, -3.13348486385960432995e-41, 6.88070222145760132143e-41, 6.77452311986726811956e-42, -1.98347635369381095351e-41, -1.1253961178843958706e-42, 5.01187487951445409857e-42, 1.18156102459622635645e-43, -1.12682960386493293215e-42, 3.90439372225742246289e-45, 2.28229523794675161175e-43, -5.93230738355827771834e-45, -4.2076608250671289725e-44, 1.89818745615117953372e-45, 7.12331842352479658367e-45, -4.38828448516724071976e-46, -1.11575792879828830944e-45, 8.48340534541665944421e-47, 1.62755741904264612593e-46, -1.44550884506739966132e-47, -2.22358004205165421521e-47, 2.2294715889766286525e-48, 2.85950563430623304154e-48, -3.16332263577112477591e-49, -3.4767327310482298161e-49, 4.17491944252288168348e-50, 4.01237781500779969715e-50, -5.16727627615183880304e-51, -4.41071956627154793797e-51, 6.0359719467433531981e-52, 4.6330360543160730724e-52, -6.68870885227462489243e-53, -4.66345376456882932138e-53, 7.06173094222827243612e-54, 4.50978449307486265544e-54, -7.12919598355092090039e-55, -4.19979678527773836259e-55, 6.90404136720843333628e-56, 3.77445013616820754731e-56, -6.43136451543013864292e-57, -3.28005716309963352909e-57, 5.7770450973474870012e-58, 2.76115398640093982714e-58, -5.01491524721535265131e-59, -2.25526750206537486123e-59, 4.21534860667044290256e-60, 1.79004784513291787888e-60, -3.43709134720122373544e-61, -1.382614992325038126e-61, 2.72296505299551509966e-62, 1.04057610156048948923e-62, -2.09909221149940609656e-63, -7.64025288779325735736e-64, 1.57670820088231358755e-64, 5.47887695959369054407e-65, -1.15543773417107677763e-65, -3.84132112790593361463e-66, 8.2702885963324207065e-67, 2.63572428359151850048e-67, -5.7881542326221800357e-68, -1.7715241212398252428e-68, 3.9649528068450338655e-69, 1.16733121858163595639e-69, -2.66083363195711013667e-70, -7.54727506358714387082e-71, 1.75087617804795166721e-71, 4.79140872821160577965e-72, -1.13058413763890417191e-72, -2.98897067227554612781e-73, 7.1695105085964361293e-74, 1.83339465873201366269e-74, -4.46811512175350229606e-75, -1.10647106974365081003e-75, 2.73840623294559201525e-76, 6.57404343693432982213e-77, -1.65151841267880846429e-77, -3.84749371367345544374e-78, 9.80705543876184247061e-79, 2.21925603291957107113e-79, -5.73728818192302888566e-80, -1.26223475199340440531e-80, 3.30839464984996922133e-81, 7.08245516792647615751e-82, -1.88142962431777938379e-82},
            {-6.43199283935248066417e-43, 1.05621043020688008898e-41, -3.71110700195141768492e-42, -8.26717232811992182641e-41, 6.18453727568616103671e-41, 2.32911539761052073323e-40, -2.05567852639042862898e-40, -3.49016080023416308658e-40, 3.41549762130534565853e-40, 3.32333101209716023361e-40, -3.58416843803139458167e-40, -2.22430757318073779044e-40, 2.66864090876922284452e-40, 1.11493506290767981866e-40, -1.51375705538795278401e-40, -4.36199936952135038954e-41, 6.86548675277909665911e-41, 1.3664869277996067573e-41, -2.57835095061605072485e-41, -3.46473132648875003707e-42, 8.23356488092726348008e-42, 7.03661499129481756969e-43, -2.28257327980797237222e-42, -1.07723851586178593897e-43, 5.58582852790202601933e-43, 9.16866594622867265464e-45, -1.22320602075870477073e-43, 1.09188565326651279934e-45, 2.4243168195247826869e-44, -7.32363318634646482768e-46, -4.3905013763740024685e-45, 2.12478004129426357946e-46, 7.32522673209323206891e-46, -4.70068202014545001043e-47, -1.1338801707013557991e-46, 8.8488516975827433109e-48, 1.63836109754443069238e-47, -1.48072082397191340147e-48, -2.22165136428253013119e-48, 2.25429988944603719735e-49, 2.84065409682103406185e-49, -3.16831826086124343338e-50, -3.43920200077940787162e-50, 4.15270978814207646464e-51, 3.95747262122753836696e-51, -5.11466670686315837327e-52, -4.34264925051754206987e-52, 5.95497240780761265945e-53, 4.55804761678545476353e-53, -6.5861871677488284828e-54, -4.58854672620932476581e-54, 6.94787588856526231417e-55, 4.44139024158993535406e-55, -7.01533021523937019571e-56, -4.14275592308160456491e-56, 6.80044244764271568949e-57, 3.73147811834963341619e-57, -6.34563571826104875722e-58, -3.25172034649191923492e-58, 5.71331845020368444682e-59, 2.74624491057877805241e-59, -4.97388785692761842872e-60, -2.25140087104441253117e-60, 4.19494436445376574737e-61, 1.79429754177185796187e-61, -3.43344602906606683166e-62, -1.39205705611574397655e-62, 2.73144571611761170584e-63, 1.05266564160163640079e-63, -2.11514330616483243871e-64, -7.7679382202384348783e-65, 1.59642154187091254701e-65, 5.59988181400802206219e-66, -1.17583581075386947724e-66, -3.9477865354735278428e-67, 8.46112191639167445313e-68, 2.72423754463068392626e-68, -5.95451753160118493226e-69, -1.84179393614799038407e-69, 4.10228419492404369137e-70, 1.22097223443350810592e-70, -2.7692348442692290243e-71, -7.94293243146856113321e-72, 1.83322996215084236384e-72, 5.07443219569633744399e-73, -1.19108226912907802579e-73, -3.18586873222321941493e-74, 7.60076277923055621943e-75, 1.96692181818009723803e-75, -4.76723362155096060901e-76, -1.194906780670257785e-76, 2.94072694112151764501e-77, 7.14698259668669762514e-78, -1.78521512026222358807e-78, -4.21108007262230298302e-79, 1.06715455210757317299e-79, 2.44553501698297560226e-80, -6.2849847835272237556e-81, -1.40048851014619151462e-81, 3.64877854761763359836e-82, 7.91252532063333830096e-83},
            {-2.95445189231387884804e-43, -1.58423712733999642803e-43, 5.7422643956855507152e-42, -3.48603996226745789875e-42, -2.60413226900342588647e-41, 2.13091248391378070302e-41, 5.3982779355100061841e-41, -4.99431901891120413737e-41, -6.59190845286728405015e-41, 6.71389337455666810405e-41, 5.41028353242365585445e-41, -6.07810855172500927074e-41, -3.23218331287120704753e-41, 4.05455748996403822574e-41, 1.48012287370283216881e-41, -2.11265521667396500057e-41, -5.37459455780309351369e-42, 8.95862418898005736454e-42, 1.57879383749298830442e-42, -3.18715866365104536978e-42, -3.77150604570701588096e-43, 9.73885227285122446799e-43, 7.18908626434808485203e-44, -2.60397928586792120508e-43, -1.00343480836349582394e-44, 6.18514118900267812205e-44, 6.09264573186832570333e-46, -1.32147426992895777184e-44, 1.84678582055829172982e-46, 2.56627586779428314253e-45, -8.75994608597893059923e-47, -4.57020382016819843934e-46, 2.35226946370517319518e-47, 7.52072935046025347516e-47, -5.00790389488648743975e-48, -1.15116541772202532019e-47, 9.20235160068834907865e-49, 1.64841434785413009147e-48, -1.51427664681400076633e-49, -2.21943054915696663941e-49, 2.27751165776178933545e-50, 2.82231745385251971682e-50, -3.17239797859174059236e-51, -3.40320306723256402978e-51, 4.1308987105681289874e-52, 3.90511326676554925746e-52, -5.06413279726435247031e-53, -4.27791836714613713764e-53, 5.87771668895415262752e-54, 4.48681578810147570626e-54, -6.48870121795279301432e-55, -4.51738195987543726961e-55, 6.83972087936094084476e-56, 4.37634027300517751895e-56, -6.90712499189048140242e-57, -4.08839948570976109318e-57, 6.70185445639104825536e-58, 3.69042029257502475037e-58, -6.26386677634760194686e-59, -3.22455620029557005066e-59, 5.65234717677546377814e-60, 2.73189427079516302793e-60, -4.93447762688191418393e-61, -2.24765371405051212375e-61, 4.17523452868972640221e-62, 1.79840560741924623505e-62, -3.4298543761508812428e-63, -1.40124555081597840476e-63, 2.73961686470504770641e-64, 1.06449526386623628284e-64, -2.13074820466957972734e-65, -7.8935699467219904224e-66, 1.61570727384281396947e-66, 5.71961826504737425108e-67, -1.19590995651498294511e-67, -4.05375409652963068978e-68, 8.65004141047617518695e-69, 2.81286868854780728414e-69, -6.12020734489515832055e-70, -1.91259300874624294088e-70, 4.23990214259842078383e-71, 1.27535951711564053731e-71, -2.87854453280582376208e-72, -8.34668552619746331177e-73, 1.91680510222270893316e-73, 5.36514490785697772933e-74, -1.25287686791207487746e-74, -3.38946566246408661034e-75, 8.04416377042287832947e-76, 2.10592534148825465073e-76, -5.07683484135328335882e-77, -1.28759912187516693787e-77, 3.15155437425163571016e-78, 7.75164646268838321088e-79, -1.92548494462053829187e-79, -4.59747188169837656767e-80, 1.15847878360955117741e-80, 2.68769442447406139748e-81, -6.86758530152433320641e-82, -1.54948966366399673869e-82, 4.01338459246026416404e-83},
            {1.65082394721084564717e-44, -2.72118240184866672141e-43, 8.24287361205099477902e-44, 2.31014676427018722112e-42, -1.6854702321058783256e-42, -7.0377742507439618045e-42, 6.12105190166399895495e-42, 1.13801399195985147898e-41, -1.09768555986206419136e-41, -1.16760321268156185002e-41, 1.2366575553490951389e-41, 8.41355327909838118468e-42, -9.85051060071729897241e-42, -4.54054993377812113016e-42, 5.96115129273462005646e-42, 1.91506554324409552125e-42, -2.87757118056843712694e-42, -6.49012989826009998309e-43, 1.14780366547654515223e-42, 1.79405570290714861201e-43, -3.88559429504382130169e-43, -4.04382428345035680921e-44, 1.13992526650716108236e-43, 7.21843100864896189516e-45, -2.947223489935084127e-44, -9.0306615357464857405e-46, 6.80826241609197109255e-45, 2.59463622913513557605e-47, -1.4213941835183880446e-45, 2.65195045051046236141e-47, 2.70794885146255103065e-46, -1.02360271666066870837e-47, -4.74671465852653022233e-47, 2.58014971909268910502e-48, 7.71007033173951281652e-48, -5.30978534494203189463e-49, -1.16766890793802098213e-48, 9.54434771104047726238e-50, 1.65778769298770081821e-49, -1.54628421668420936403e-50, -2.21697409827819310153e-50, 2.29924935362247978255e-51, 2.80450518627813367079e-51, -3.17568491651375618376e-52, -3.3686743361694881353e-52, 4.10953108029313069777e-53, 3.85516129468814931489e-53, -5.01559998755642932283e-54, -4.21632615748177022632e-54, 5.80400261352891413592e-55, 4.41910703595360677266e-55, -6.39594774283242524907e-56, -4.44972782818777051754e-56, 6.7369119598760644036e-57, 4.31443468212665762804e-57, -6.80423253786705662284e-58, -4.0365776581070170655e-58, 6.60798277399020005942e-59, 3.65118191610056269033e-59, -6.18584331943442680707e-60, -3.19851889596198964706e-60, 5.59400246680145098308e-61, 2.71809238514185345926e-61, -4.89662942069607120019e-62, -2.24403793174027450636e-62, 4.15621632616669249554e-63, 1.80239282301569819693e-63, -3.42634293960509553339e-64, -1.41020121520991420743e-64, 2.74751510365432886129e-65, 1.07608083867784860558e-65, -2.14594066121140890154e-66, -8.01724332573456946428e-67, 1.63458987133812822906e-67, 5.83812495318974929413e-68, -1.21567398669167193802e-68, -4.1592226729279402852e-69, 8.83709559378063657256e-70, 2.90159506331229457801e-70, -6.28521222212780858842e-71, -1.98389196503253425996e-71, 4.37776490047317291521e-72, 1.33046652855395751001e-72, -2.98871353318038323647e-73, -8.75834355942621751897e-74, 2.00155912339635134912e-74, 5.66344046505758899172e-75, -1.31593845106910172007e-75, -3.59972774153316825942e-76, 8.49955639649506317384e-77, 2.25042344889287378545e-77, -5.39687622325149887137e-78, -1.3845968831205084236e-78, 3.37092552424063469152e-79, 8.38865309667541437241e-80, -2.07241013946383005456e-80, -5.00729512638525409644e-81, 1.2547784202502362097e-81, 2.94629641371324949829e-82, -7.48608517531071543077e-83, -1.70970417751902322702e-83},
            {7.29037291308979484852e-45, 4.73442782595716970613e-45, -1.53954177440712239837e-43, 8.91665294672376689092e-44, 7.5480918469575039253e-43, -6.06706375678801853541e-43, -1.68754789932755041075e-42, 1.53995452219935530807e-42, 2.21860067802596199045e-42, -2.22518966543360076867e-42, -1.95812395024668102749e-42, 2.15634087842554008905e-42, 1.25730170706080222197e-42, -1.53509929069917185969e-42, -6.19055601206984642303e-43, 8.51506889392704707094e-43, 2.42128800894031280213e-43, -3.83555972106968666146e-43, -7.69421899172963000653e-44, 1.44668902033928514878e-43, 2.00718326995841215262e-44, -4.67832966859086108803e-44, -4.27177842238335110264e-45, 1.32165090129806046964e-44, 7.11239463459680555624e-46, -3.31175010437643020449e-45, -7.75447665122385629273e-47, 7.45365312269380656097e-46, -1.31616043394211963041e-48, -1.52274260925627494711e-46, 3.50420807955051667191e-48, 2.84914182360485561591e-47, -1.17470386044784999757e-48, -4.92000754066550499194e-48, 2.80798002831847370097e-49, 7.89349832748948816521e-49, -5.60622014959706208613e-50, -1.18344282153474805417e-49, 9.87529250745922207056e-51, 1.66654563561347639479e-50, -1.57684512909101392571e-51, -2.21433204072302366163e-51, 2.31964311116960132932e-52, 2.78722335587205270963e-52, -3.17828873737372628626e-53, -3.33555680912023959925e-53, 4.08864357917165001452e-54, 3.80748798616021628543e-54, -4.9689958923061145936e-55, -4.15768761696089545114e-55, 5.73364217449793212694e-56, 4.35470676537837854856e-56, -6.30764738653991185677e-57, -4.38537140583270757944e-57, 6.63912386274986010205e-58, 4.2554892079409149213e-58, -6.70633293705767628521e-59, -3.98715163184594851937e-59, 6.5185554023505838616e-60, 3.61367443903897158236e-60, -6.11136616603936616256e-61, -3.17356485672866275514e-61, 5.53816331411376674078e-62, 2.70482925318234402784e-62, -4.86029013374624139078e-63, -2.2405638948855594384e-63, 4.13788549207149255169e-64, 1.80627825225133261695e-64, -3.42293535077758392415e-65, -1.41894346444549802279e-65, 2.75517417633905817846e-66, 1.08743749840968215748e-66, -2.16075239489265699131e-67, -8.13905145876727346658e-68, 1.65309277899013464462e-68, 5.95544179984059857217e-69, -1.23514151083134338682e-69, -4.26419396051314785519e-70, 9.02233596807362408653e-71, 2.9903969870863942611e-71, -6.44952569475168612171e-72, -2.05566374863470547503e-72, 4.5158355533677188234e-73, 1.38626814300993235742e-73, -3.09969626828135937728e-74, -9.17772171837806933027e-75, 2.08745162141438172353e-75, 5.96921273936970635359e-76, -1.3802383179072155058e-76, -3.81661844099158282126e-77, 8.96678278158059079277e-78, 2.40043055414684589284e-78, -5.72731004639092522118e-79, -1.48594535542817802441e-79, 3.59887105155521285386e-80, 9.05859477572160549488e-81, -2.22606738408283096723e-81, -5.44116043557936662468e-82, 1.35614966280022764312e-82, 3.22189669513067327166e-83, -8.14145695609355556167e-84},
            {-4.22690544184940810292e-46, 7.00457657043079101638e-45, -1.77183309270461014833e-45, -6.42955333591730582816e-44, 4.56889969957590556557e-44, 2.11177774766287772557e-43, -1.80982954755701768144e-43, -3.67419102047039488351e-43, 3.49544577621945552712e-43, 4.05017079021182936977e-43, -4.21878542976986884938e-43, -3.13271851759297171258e-43, 3.5877775587117890128e-43, 1.81430996223467397666e-43, -2.31191650069022647058e-43, -8.21811586262234176062e-44, 1.18567522757320927057e-43, 2.99808119801889086629e-44, -5.01463204714885961476e-44, -8.96827563656959434706e-45, 1.79669649895703021731e-44, 2.21271459158476399485e-45, -5.56948967697026746765e-45, -4.44568019875143055039e-46, 1.51914944375979375981e-45, 6.86001424152166977738e-47, -3.69693510225326888756e-46, -6.20108121656778178402e-48, 8.11980107826395003333e-47, -5.62883962285131163703e-49, -1.62531327490852513147e-47, 4.40043993292727711572e-49, 2.98968778876013178925e-48, -1.32885162122280606486e-49, -5.0900791563014989652e-49, 3.03537855118307574663e-50, 8.07126364130605682827e-50, -5.89715163495517409994e-51, -1.19853636350359382541e-50, 1.01956424084270680199e-51, 1.67474718235896841065e-51, -1.60605490543225957013e-52, -2.21154868119390728056e-52, 2.33881186631841108593e-53, 2.77047516626086380238e-53, -3.18030719309893111466e-54, -3.30379405839771520375e-54, 4.06826590211845012331e-55, 3.7619735582659265721e-55, -4.92425045787318049202e-56, -4.10183201057173790083e-56, 5.66646036819160282108e-57, 4.29341747016683000013e-57, -6.22354242916294060851e-58, -4.32411665985046245927e-58, 6.54605720823574292669e-59, 4.19933376050251781598e-59, -6.61313144942694206068e-60, -3.93999263500349486381e-60, 6.43332088139244567827e-61, 3.57781502746781797946e-61, -6.04025004306112327193e-62, -3.14965265186268094772e-62, 5.48471597940755187826e-63, 2.69209465999848112944e-63, -4.82540867955527206524e-64, -2.23724061699912401515e-64, 4.12023652102452029713e-65, 1.81007939183914342756e-65, -3.41965262668947510674e-66, -1.42749047980970898056e-66, 2.76262520104173759007e-67, 1.09857966700790485321e-67, -2.17521321582509836893e-68, -8.25908517718012515814e-69, 1.67123844084059238693e-69, 6.07160971430474162969e-70, -1.25432590249222129606e-70, -4.36867218941561608306e-71, 9.20581649759624122814e-72, 3.07925753291486488907e-72, -6.61314579071664881116e-73, -2.12788351152074030402e-73, 4.65408169548739129485e-74, 1.4427406240058135705e-74, -3.21145059922765535753e-75, -9.60464145052488797165e-76, 2.17444424669735326847e-76, 6.28235635458998381419e-77, -1.44574860799477562814e-77, -4.0400988850375852792e-78, 9.44568507587610472295e-79, 2.5559575997111932721e-79, -6.06808416039883627808e-80, -1.59168652128414158712e-80, 3.83541579621341740896e-81, 9.76203870388883689674e-82, -2.38652805804543437982e-82, -5.89966302322445968501e-83, 1.46268482087514426358e-83, 3.51504409575418526027e-84},
            {-1.80045470588298523375e-46, -1.37858432793323025951e-46, 4.11784235528894827883e-45, -2.26640122336712016489e-45, -2.17627467004523495549e-44, 1.71729865212072995002e-44, 5.23286363711944423043e-44, -4.71121498490210007368e-44, -7.38634250973220959063e-44, 7.30209281503638179929e-44, 6.99083826151151087795e-44, -7.55929584215888672916e-44, -4.81035411679901252716e-44, 5.73213975357075567999e-44, 2.53828080550697445286e-44, -3.378726245680702871e-44, -1.06517692918897206299e-44, 1.61392357576789735327e-44, 3.64234981402709786125e-45, -6.44340678062233901247e-45, -1.02898192673587905312e-45, 2.20182325852816503831e-45, 2.40491460203500537074e-46, -6.56264865885801765668e-46, -4.556178331328492069e-47, 1.73242924475988317003e-46, 6.45162574137197985671e-48, -4.10210132287437552961e-47, -4.36769063500351444692e-49, 8.80523323347808740274e-48, -1.033116152294725506e-49, -1.72891642009375552799e-48, 5.33760703425970075026e-50, 3.12944419078955238541e-49, -1.48563575647651355416e-50, -5.2569456329027182183e-50, 3.26201651492999222206e-51, 8.24361586306338759463e-51, -6.18256486424015239316e-52, -1.21299586675992689763e-51, 1.05058530877709674412e-52, 1.68244632505615188269e-52, -1.63400325490001785347e-53, -2.2086632578575862326e-53, 2.35686438036412437576e-54, 2.75426143848108542546e-54, -3.18182748667622617668e-55, -3.27333218015441652728e-55, 4.04842178202543148066e-56, 3.71850643612463175891e-56, -4.88129606151710351138e-57, -4.04860155096677974468e-57, 5.6022941364405933538e-58, 4.23505709455727817631e-58, -6.14339476939895522729e-59, -4.26578283616197103282e-59, 6.45743602295133298857e-60, 4.14581110949044805508e-60, -6.52435612848534492301e-61, -3.89498106150896583584e-61, 6.35204642867740305732e-62, 3.54352612838217241554e-62, -5.97232242984292877367e-63, -3.12674289305786345994e-63, 5.4335534926123566213e-64, 2.67987826346769209169e-64, -4.79193596242356914548e-65, -2.23407590738343202373e-65, 4.10326288345010280943e-66, 1.8138123080440367742e-66, -3.41651344283703255723e-67, -1.43585929266538652007e-67, 2.76989688726193712352e-68, 1.10952108975092518077e-68, -2.18935114447175128486e-69, -8.37743296143554678705e-70, 1.68904833197660993189e-70, 6.18667033728926609014e-71, -1.27324027506493008143e-71, -4.47266385072927496399e-72, 9.38759314480713979708e-73, 3.16816232596346886147e-73, -6.77607458851640532662e-74, -2.20052850619235372045e-74, 4.7924751218459748633e-75, 1.49986159664895509504e-75, -3.32393767570866409293e-76, -1.00389306854961273792e-76, 2.26250067944902740483e-77, 6.60276711373784917278e-78, -1.51244234872161953744e-78, -4.27012827803152923705e-79, 9.93610619035385272106e-80, 2.7170123792188750891e-80, -6.4191426723459301033e-81, -1.70185924532660739706e-81, 4.08057927288703208921e-82, 1.0499527793425489148e-82, -2.55385851962009047639e-83, -6.38338271355758085409e-84, 1.57447241539090786625e-84},
            {1.08012338815338102488e-47, -1.80159472259124895373e-46, 3.63068902534660562126e-47, 1.78285540258545097096e-45, -1.23216569738320507644e-45, -6.29595875724126858544e-45, 5.31602692251856239362e-45, 1.17548536216040880686e-44, -1.10355993917381534413e-44, -1.38848347014797373287e-44, 1.42407137567060072316e-44, 1.14966989887360547406e-44, -1.29054994036838120421e-44, -7.12466573192322856093e-45, 8.8392696398619832863e-45, 3.45446027729404827548e-45, -4.8080606508520482869e-45, -1.35107536434227200704e-45, 2.15267028252506409739e-45, 4.34853439662668991213e-46, -8.15077421286642500172e-46, -1.16328533464677975144e-46, 2.66585132434520606108e-46, 2.57786952565725213312e-47, -7.66083738430967573794e-47, -4.59435270301868910588e-48, 1.96142789638800229713e-47, 5.87884439275814071693e-49, -4.52653198470205104124e-48, -2.25323948003056468188e-50, 9.50852529303987109364e-49, -1.5409874309628253461e-50, -1.83337825578222243795e-49, 6.31277086405023559098e-51, 3.26829054350967156117e-50, -1.64468070161411759626e-51, -5.42063938605868994402e-51, 3.48761277541798619011e-52, 8.4108019877804999044e-52, -6.46247987416617678623e-53, -1.22686490900281278558e-52, 1.08063757792369341798e-53, 1.68969248139855644402e-53, -1.66077435326470717481e-54, -2.20571052126127669268e-54, 2.37390016838941611652e-55, 2.73858101442801494653e-55, -3.18292746730954619884e-56, -3.2441197313747404743e-56, 4.02912986523205609897e-57, 3.67698259190423329439e-57, -4.84006756475654371556e-58, -3.99785021904382154342e-58, 5.54099140619387043795e-59, 4.17945757803360907611e-59, -6.06698412661777976023e-60, -4.2102030257739930853e-60, 6.37300553595977637426e-61, 4.09477571427381257043e-61, -6.43975570137091688824e-62, -3.8520056884034029816e-62, 6.27451627498990119486e-63, 3.51073507245813766758e-63, -5.90742251312447354855e-64, -3.10479813367172800138e-64, 5.38457519207605423762e-65, 2.66816966727297158368e-65, -4.75982483947932823011e-66, -2.23107650692844872446e-66, 4.086957212031632409e-67, 1.81749176077026502002e-67, -3.41353437698236213636e-68, -1.44406586283760462852e-68, 2.77701573361524766657e-69, 1.12027486292315275724e-69, -2.20319252433637359393e-70, -8.49418088772034267396e-71, 1.70654299177539717791e-71, 6.30066581697082489266e-72, -1.29189746286672231501e-72, -4.57617744757297589291e-73, 9.56772345997808542756e-74, 3.25709935300272505948e-74, -6.93831780802514813302e-75, -2.27357798000319041169e-75, 4.93099153595245559867e-76, 1.55761001624009885953e-76, -3.43712178699708871694e-77, -1.04804240012724325971e-77, 2.3515865972734931349e-78, 6.93034237787739059765e-79, -1.5802934934580896666e-79, -4.5066643009716171168e-80, 1.04378904552184224198e-80, 2.88359984655454174707e-81, -6.78042658818437063308e-82, -1.81649946424224434436e-82, 4.33437614865961048569e-83, 1.12715815035878385564e-83, -2.72812038575010413758e-84, -6.89288404193506307119e-85},
            {4.4499167399744497559e-48, 3.93790355416348512387e-48, -1.09900216199900059873e-46, 5.72285602186361619439e-47, 6.24404511297575656818e-46, -4.83405469789579548367e-46, -1.61053139613793156623e-45, 1.43078089418680715978e-45, 2.43455219760613703889e-45, -2.37410309088814943541e-45, -2.46459811964603194171e-45, 2.62059386647723028787e-45, 1.81254618727986755541e-45, -2.11287501527463109657e-45, -1.02204537996685124839e-45, 1.3211680283625958207e-45, 4.58626706004739796998e-46, -6.68159933079330135749e-46, -1.68033527133714840474e-46, 2.81928727916624128184e-46, 5.10860188469363554629e-47, -1.01655819975985817611e-46, -1.296829324544475728e-47, 3.19232099095482223964e-47, 2.72557410366212339454e-48, -8.86655859102842638163e-48, -4.5517868644736774677e-49, 2.20602038464429720153e-48, 5.13452466075998857359e-50, -4.96948263041965704252e-49, 1.41821401156905913798e-52, 1.02283089259707085937e-49, -2.08509956282795788597e-51, -1.93854030064980376136e-50, 7.32310860586293865861e-52, 3.40612621656260864614e-51, -1.80564386430022785214e-52, -5.58120637478798565359e-52, 3.71192881278699410307e-53, 8.57306493783287553017e-53, -6.73694582970512730066e-54, -1.2401844381474395018e-53, 1.10976543953878097896e-54, 1.69653089767452605277e-54, -1.68644712980655949642e-55, -2.2027212442431719124e-55, 2.39001034067662198525e-56, 2.72343109932229153908e-56, -3.18367668069471221089e-57, -3.21610765542862350307e-57, 4.01040446039372517884e-58, 3.63730494408154086727e-58, -4.80050233104238290655e-59, -3.9494427095835830928e-59, 5.48241021684022005287e-60, 4.12646355996862488399e-60, -5.99410643518466177676e-61, -4.1572228879182597949e-61, 6.292530216941370825e-62, 4.04609267813179277973e-62, -6.35909767867097351636e-63, -3.81096297094470507307e-63, 6.20053017247261423067e-64, 3.47937371100565795575e-64, -5.84540024093859020483e-65, -3.08378277128663413687e-65, 5.33768629789574792516e-66, 2.65695848176968400555e-66, -4.72903007473190674954e-67, -2.22824820869337327757e-67, 4.07131146232842002726e-68, 1.82113131638669563079e-68, -3.41073012716249177212e-69, -1.45212515174635522014e-69, 2.78400620890396061744e-70, 1.13085346314955135269e-70, -2.21676212817170747834e-71, -8.60941259765638779726e-72, 1.72374205817009050263e-72, 6.41363861405917851491e-73, -1.31031000676654746311e-73, -4.67922326864011999211e-74, 9.74626621918206984953e-75, 3.34605878375566661825e-75, -7.0998844356091132024e-76, -2.34701307210779805881e-76, 5.06961027359734077475e-77, 1.61596613393886906544e-77, -3.55097021469279123443e-78, -1.09289627411257946633e-78, 2.44166963660958152968e-79, 7.2649813999794597603e-80, -1.64927695130831962771e-80, -4.74966347809428792659e-81, 1.09508842073141387516e-81, 3.05572241110924604882e-82, -7.15187440989139940301e-83, -1.93564037477419863497e-83, 4.59681670234280533406e-84, 1.20786967261957413429e-84, -2.9093708116777137412e-85},
            {-2.7554013487347850783e-49, 4.6303424320357270948e-48, -6.8844369759697451038e-49, -4.92680943427541395118e-47, 3.30647934428563464777e-47, 1.86587516373442076648e-46, -1.55185299430825991698e-46, -3.72911709635730303354e-46, 3.45620130267294734273e-46, 4.7084646481211917059e-46, -4.75969690238142977921e-46, -4.16311202336234974461e-46, 4.58832004374954463119e-46, 2.75344261430267812097e-46, -3.33468992853359474023e-46, -1.42491606480637533128e-46, 1.9207589128067693392e-46, 5.95411404572185808659e-47, -9.08981995265124061622e-47, -2.05255633449304563032e-47, 3.63192833038393546708e-47, 5.91209676143090480074e-48, -1.25163481063980407229e-47, -1.42644227907536014607e-48, 3.78451137156160385251e-48, 2.84201034333662404907e-49, -1.01818091889859119228e-48, -4.42062098933436724198e-50, 2.46602701796115733179e-49, 4.2127045525128360648e-51, -5.43019156845181577209e-50, 2.81571870610219126598e-52, 1.09632769696009043613e-50, -2.66400554240142835601e-52, -2.04425863395555446097e-51, 8.36592389186274184229e-53, 3.54286838189514655796e-52, -1.96821379255324902726e-53, -5.73870371688611016096e-53, 3.93476415221281114265e-54, 8.73064241988297595811e-54, -7.00603598277652804582e-55, -1.2529929023587834819e-54, 1.13801233156043754164e-55, 1.7030030163042255943e-55, -1.71109555586359561124e-56, -2.19972267146850880442e-56, 2.40527836488729247409e-57, 2.70880755252739318122e-57, -3.18413729321886513678e-58, -3.18924919980838649488e-58, 3.99225617988661704024e-59, 3.59938281097862464102e-59, -4.76254021579779809328e-60, -3.90325348690070650347e-60, 5.42641792647561428099e-61, 4.07593122414958871619e-61, -5.92457240766055893359e-62, -4.106699510593671148e-62, 6.21579202621318946175e-63, 3.99963681164801954288e-63, -6.28216666570043742952e-64, -3.7717564067755848653e-64, 6.12990205502904493594e-65, 3.4493780838585916011e-65, -5.78611546492376016249e-66, -3.06366295392127833053e-66, 5.29279751687049782621e-67, 2.64623437451447438247e-67, -4.69950828722619045194e-68, -2.22559596505449120841e-68, 4.05631705105817221645e-69, 1.82474345035672944112e-69, -3.40811370677148723454e-70, -1.46005119058427337936e-70, 2.79089091781339585001e-71, 1.14126877619332513315e-71, -2.23008325792097227375e-72, -8.72320928738899703424e-73, 1.74066430245666919843e-73, 6.52563133265202750263e-74, -1.32849014369297280069e-74, -4.78181318245056413009e-75, 9.92328110571635653671e-76, 3.4350328036719115269e-76, -7.26078638109075689934e-77, -2.42081671343259656914e-77, 5.20831404243442913886e-78, 1.67491146015959321853e-78, -3.66545308805706331497e-79, -1.138439508720489536e-79, 2.53271934913402711899e-80, 7.60658561738902476051e-81, -1.71936860937639211832e-81, -4.99908151487247591696e-82, 1.14749363115627667167e-82, 3.23338021895394636395e-83, -7.53342268977078759079e-84, -2.0593126189092429975e-84, 4.86790726456796512806e-85, 1.29213487080336730408e-85},
            {-1.10062260688338823733e-49, -1.10838765080295412361e-49, 2.92718104146534624378e-48, -1.43500145187578184092e-48, -1.78339910905153300479e-47, 1.3536383835790652664e-47, 4.92243905903530109232e-47, -4.31546681511501211709e-47, -7.94995704907349738099e-47, 7.65208897897006975142e-47, 8.58806739863205170641e-47, -8.99040678001508108823e-47, -6.73414487059213118384e-47, 7.69413969914405393735e-47, 4.04723768932802276581e-47, -5.09562520903712425483e-47, -1.9363525955679786166e-47, 2.72429090710794148056e-47, 7.5742723592040422392e-48, -1.21314847907542668087e-47, -2.46600991327014396841e-48, 4.6093528189674520045e-48, 6.74624364636251526513e-49, -1.52310048099171592606e-48, -1.54873616903562753988e-49, 4.44542743754285695447e-49, 2.9212170857678415181e-50, -1.1608107456907285301e-49, -4.19358757890709655223e-51, 2.74122100425093139723e-50, 3.10853882108186386546e-52, -5.90788890126469927132e-51, 5.76553904127140879399e-53, 1.17121869472883408562e-51, -3.27623034566631897911e-53, -2.15040309659775313777e-52, 9.43865383946392001681e-54, 3.67845012105014917143e-53, -2.13210827936657693053e-54, -5.89319762303562589763e-54, 4.15595219279301569263e-55, 8.88376605871594001497e-55, -7.26984333291838797654e-56, -1.26532638166352032888e-55, 1.16542057224931216511e-56, 1.70914681088315986005e-56, -1.73478893017858981582e-57, -2.19673891610360351969e-57, 2.41978075626574343743e-58, 2.69470513456169991752e-58, -3.18436490630020029492e-59, -3.16349982887459023786e-59, 3.97469248982033257333e-60, 3.56313141321894566659e-60, -4.72612353527209098366e-61, -3.85916593748026250284e-61, 5.37289048927693484504e-62, 4.02772726600628082757e-62, -5.85820624667226947154e-63, -4.05850039169417972033e-63, 6.14258885057272521029e-64, 3.95529179231714079486e-64, -6.20876285083724444463e-65, -3.73429596147480137185e-65, 6.06245883336232447683e-66, 3.4206881152811813649e-66, -5.72943716175713646676e-67, -3.04440649009540939733e-67, 5.24982467669969837505e-68, 2.63598711199240203837e-68, -4.67121789499742727986e-69, -2.22312398298148423846e-69, 4.04196497506003967734e-70, 1.8283396406371403576e-70, -3.40569661923953614555e-71, -1.4678571438350299744e-71, 2.79769075256804339921e-72, 1.15153212506526618655e-72, -2.24317783863718020506e-73, -8.83564971285379496639e-74, 1.75732766425181271841e-74, 6.63668657400617873699e-75, -1.34644979945952327831e-75, -4.88396045062962806541e-76, 1.00988284304659555855e-76, 3.52401545765125902675e-77, -7.42103816424988357414e-78, -2.49497352996269887673e-78, 5.34708867694646855785e-79, 1.73442872628100317782e-79, -3.78054324262541974485e-80, -1.18465760961321650236e-80, 2.62470715414531599496e-81, 7.95505890629600503273e-82, -1.79054534838989841429e-82, -5.25487360875260431637e-83, 1.20098986213463371576e-83, 3.41657141983309944122e-84, -7.92500654353349909882e-85, -2.18754446545957584528e-85, 5.14765063814251456549e-86},
            {7.01882952721246738563e-51, -1.18925839048657817228e-49, 1.12339832954731169866e-50, 1.35717849195139932658e-48, -8.82992535554434779113e-49, -5.49913515882273568648e-48, 4.50386628778697672404e-48, 1.17378404949305675643e-47, -1.0743091704149319125e-47, -1.5806221689943328702e-47, 1.57615366533698308064e-47, 1.48895691887402242242e-47, -1.61352821944889385793e-47, -1.04851879235271493746e-47, 1.24235448898760506407e-47, 5.77653751008019663164e-48, -7.56604465974006794811e-48, -2.57116527702623765661e-48, 3.77921749330769959977e-48, 9.45781817366385744539e-49, -1.59129909350752255397e-48, -2.91757325969756017585e-49, 5.77075021185040614618e-49, 7.59609174198991188506e-50, -1.83366756945954390727e-49, -1.66015292028956271416e-50, 5.17779281845296167118e-50, 2.95735015672586150443e-51, -1.3146523771774564423e-50, -3.86403224157587349494e-52, 3.03133558819316242944e-51, 1.81822471466635687457e-53, -6.40180424647462598454e-52, 8.98739836482713104596e-54, 1.24738631835198452866e-52, -3.9202884931785792387e-54, -2.2568564653113941368e-53, 1.05388730604811341469e-54, 3.81281868979543118565e-54, -2.29707245181051155984e-55, -6.04476161212188653938e-55, 4.3753564227918714445e-56, 9.03266075937122548914e-56, -7.52847689964792737274e-57, -1.27721871886666965378e-56, 1.19203123864700837892e-57, 1.71499709135121995672e-57, -1.75759215755778849756e-58, -2.19379131016791191424e-58, 2.43358770258855798301e-59, 2.68111771690883116141e-59, -3.18440927486631364828e-60, -3.13881713380513946264e-60, 3.95771818218464158664e-61, 3.52847142030103684077e-61, -4.6911970193664646142e-62, -3.81707160829071962527e-62, 5.32171179696584316098e-63, 3.98172796771795198793e-63, -5.79484448794589227071e-64, -4.0125025262036064837e-64, 6.07273310251213864104e-65, 3.91294940911984053387e-65, -6.13870064981269578163e-66, -3.69849754876337395919e-66, 5.99803930929326338891e-67, 3.39324733526652174181e-67, -5.67524272548999769771e-68, -3.02598276285503367939e-68, 5.20868838720289786308e-69, 2.62620659385076016697e-69, -4.64411905619922637267e-70, -2.22083580881316065617e-70, 4.02824591353542575605e-71, 1.83193045271698704291e-71, -3.4034890145418756012e-72, -1.47555536842119745186e-72, 2.80442503176960492122e-73, 1.16165429733126329482e-73, -2.25606650664439976749e-74, -8.94681020846754869449e-75, 1.77374928628697124899e-75, 6.7468468106490939562e-76, -1.36420058441457220103e-76, -4.98567955864923065005e-77, 1.02729688871396908107e-77, 3.61300250421499616911e-78, -7.58065662866154890308e-79, -2.56946974955634909984e-79, 5.4859229083023343942e-80, 1.79450184517353045783e-80, -3.89621608264002774473e-81, -1.23153677014797368325e-81, 2.71760628781423883052e-82, 8.31030780143079205555e-83, -1.86278505245461941897e-83, -5.5169947340122044789e-84, 1.25556263825568720516e-84, 3.60529242001262170024e-85, -8.32656012390172692854e-86, -2.32036198738830943214e-86},
            {2.72410134354025826704e-51, 3.08350498599768844295e-51, -7.78191898008284680735e-50, 3.57118297676107205494e-50, 5.07223459742578708545e-49, -3.77164465039338455279e-49, -1.49479921536277945412e-48, 1.29323204345292384704e-48, 2.57364675058820767584e-48, -2.44636121993043744548e-48, -2.96030479634490497561e-48, 3.0542062807220965268e-48, 2.4694677310655812854e-48, -2.77010103548151854378e-48, -1.57818873116163332912e-48, 1.94012464514268475534e-48, 8.02967838246409896876e-49, -1.0949534251313625314e-48, -3.34307269444556332345e-49, 5.13884288764215429148e-49, 1.16096938074666987128e-49, -2.05476131329273809156e-49, -3.4026962790086731933e-50, 7.1355694869365173531e-50, 8.44469166268075325964e-51, -2.18594862912110930313e-50, -1.75700924513354131406e-51, 5.98404760778453215356e-51, 2.94473322311594721372e-52, -1.4797713628076457047e-51, -3.42592180102497680435e-53, 3.33607069216990646565e-52, 3.38923294513099621525e-55, -6.91117326471881868449e-53, 1.24765977446501366791e-54, 1.32471977649878086211e-53, -4.59469876342309477435e-55, -2.36351361942982663042e-54, 1.16642952245896271456e-55, 3.94593393408231144285e-55, -2.46287688064591913897e-56, -6.19347497386198506769e-56, 4.59286699667403986649e-57, 9.17754425677335711669e-57, -7.78205852688587599179e-58, -1.28870164809010518841e-57, 1.2178840815354988839e-58, 1.7205857817847262939e-58, -1.77956601838366969489e-59, -2.19089871425991614415e-59, 2.44676363004349717754e-60, 2.66803846019578557362e-60, -3.184314942070727204e-61, -3.11516074144064072178e-61, 3.94133578053948336783e-62, 3.49532853698523711829e-62, -4.65770775255493677227e-63, -3.77686952093412446706e-63, 5.27277307808321994531e-64, 3.93781836837587376991e-64, -5.73433495930041467166e-65, -3.9685915868913152055e-65, 6.00605046338077609469e-66, 3.87250888229022874949e-66, -6.07180748766171647879e-67, -3.66428255945937877522e-67, 5.93649319595261543649e-68, 3.36700262386788329754e-68, -5.62341732350949352624e-69, -3.00836264779181834602e-69, 5.1693137264877453963e-70, 2.61688288075523012993e-70, -4.61817360850929919486e-71, -2.21873440373682863713e-71, 4.01515031580633756721e-72, 1.83552561708335624351e-72, -3.40149982951422469605e-73, -1.48315746876093004265e-73, 2.8111116275347375807e-74, 1.17164557153558968071e-74, -2.26876869221640491946e-75, -9.05676471687442952971e-76, 1.78994554878714017855e-76, 6.85615427852515581333e-77, -1.38175379148663389477e-77, -5.08698606257410722323e-78, 1.04457633387026206127e-78, 3.7019912796093931692e-79, -7.73966068079102404177e-80, -2.64429311242988914178e-80, 5.62480814855460466762e-81, 1.8551158709769535197e-81, -4.01244944771726370701e-82, -1.27906386875255861497e-82, 2.81139175007390147531e-83, 8.67224168402296580723e-84, -1.93606661364688638265e-84, -5.78539990213897857186e-85, 1.31119785858217620615e-85, 3.79953812112769664e-86, -8.73801705656394747227e-87},
            {-1.78567232420123842575e-52, 3.05259904863084999031e-51, -1.1878324152222821923e-52, -3.72756975617435068646e-50, 2.34683075256869803605e-50, 1.61236094080851942346e-49, -1.29996994593897986107e-49, -3.66772347454198480095e-49, 3.31576252847424807078e-49, 5.256412161167357987e-49, -5.17407993804386592966e-49, -5.26433095780163751092e-49, 5.61602604957673396537e-49, 3.93850083942319188389e-49, -4.57415327710038721596e-49, -2.30458758256465386872e-49, 2.94115144200567888148e-49, 1.08982173878186663086e-49, -1.54849237269310939691e-49, -4.26406274476564059703e-50, 6.86221255434454222721e-50, 1.40279056090882065224e-50, -2.61546679587305625043e-50, -3.91539845443503319523e-51, 8.72335693167182030446e-51, 9.27329570599968390848e-52, -2.58244077638173572895e-51, -1.83553905844223349796e-52, 6.86635042902308189936e-52, 2.87789973920639387145e-53, -1.65619519080259093134e-52, -2.87384185069612733751e-54, 3.65509902949897554461e-53, -1.33132123733434856519e-55, -7.4352431104582158103e-54, 1.62277652021926765492e-55, 1.4031150563393794282e-54, -5.29799638129337460087e-56, -2.47028071508288475302e-55, 1.28127726703531817957e-56, 4.07776684966526736572e-56, -2.62931573695311716267e-57, -6.33942144836053884223e-57, 4.8083976480250834139e-58, 9.31862681867974228198e-58, -8.03072014946791920608e-59, -1.29980491971401845724e-58, 1.2430174700029053494e-59, 1.72594217316484309016e-59, -1.80076742731746739056e-60, -2.18807779162000392891e-60, 2.45936771569544165036e-61, 2.65545996544413876871e-61, -3.18412180071967106635e-62, -3.09249222332127058837e-62, 3.92554588889190019466e-63, 3.46363312563518306819e-63, -4.62560510619107004181e-64, -3.73846555305414876309e-64, 5.2259723494526899833e-65, 3.89589151808122974776e-65, -5.67653584236770220331e-66, -3.92666118760610998595e-66, 5.94237875365399444939e-67, 3.83387624975621058072e-67, -6.00792270243412500259e-68, -3.63157743398654694394e-68, 5.87768023212184927637e-69, 3.3419039764410219066e-69, -5.57385330967533318687e-70, -2.99151843503435521072e-70, 5.13162995013978807318e-71, 2.60800621682047903689e-71, -4.59334500769750906807e-72, -2.21682221103012122437e-72, 4.00266847652489142674e-73, 1.83913409982434460817e-73, -3.39973691372575580012e-74, -1.49067434800152152855e-74, 2.81776708195372828969e-75, 1.18151574268299138781e-75, -2.28130269705306891421e-76, -9.16558482771405588901e-77, 1.80593210323571487029e-77, 6.96465088511482360172e-78, -1.39912039625181098594e-78, -5.18789645046050194092e-79, 1.06172726316868273682e-79, 3.79098057132119470914e-80, -7.89807105238851877445e-81, -2.71943278539874421232e-81, 5.76373828858579440964e-82, 1.91625695849827410592e-82, -4.12922348405898953337e-83, -1.32722646382586178157e-83, 2.90604024982038813363e-84, 9.0407729408770197044e-85, -2.01036993208689380499e-85, -6.06004439913287653114e-86, 1.36788182711873439419e-86, 3.99930214526782504155e-87},
            {-6.74666895349508869727e-53, -8.49731531795968102195e-53, 2.06522380460222768369e-51, -8.81383616935890028611e-52, -1.43695245682316825458e-50, 1.04590890452203517495e-50, 4.51196017684680042041e-50, -3.8519573944322724578e-50, -8.26465283457942662995e-50, 7.76125220987808570796e-50, 1.01015880550235133676e-49, -1.02803940541295070829e-49, -8.94638032401085728501e-50, 9.86670018503820717264e-50, 6.06675333110757265973e-50, -7.29762090360310146291e-50, -3.27494748041007590065e-50, 4.34176350251604899957e-50, 1.4473997708819492671e-50, -2.14477960212442665346e-50, -5.34376467674210419245e-51, 9.01391458846661696938e-51, 1.67028726331912545945e-51, -3.28586265160792782382e-51, -4.44829281788151845367e-52, 1.05536049003820954759e-51, 1.00615734316211640776e-52, -3.02551322575773569579e-52, -1.89193284767212039708e-53, 7.82658405010246206923e-53, 2.75162654820629538072e-54, -1.84391675518989553801e-53, -2.20298569549401013666e-55, 3.98807167830401801222e-54, -3.19366226750137198873e-56, -7.97327692002612290228e-55, 2.02349838081076638753e-56, 1.48247485056166569351e-55, -6.02874298685647016143e-57, -2.57707437799491194219e-56, 1.39822944792647404182e-57, 4.20829827671025863117e-57, -2.7962050147171425964e-58, -6.48268809549316218585e-58, 5.02188291217263897185e-59, 9.45611107335313078161e-59, -8.27460146042156878366e-60, -1.31055642086543860332e-59, 1.26746835990514660194e-60, 1.73109315331998006359e-60, -1.82124968013540676959e-61, -2.18534325085788461277e-61, 2.4714543516942959871e-62, 2.64337440237588003518e-62, -3.18386559048471766755e-63, -3.0707750058949569271e-63, 3.91034749192787419132e-64, 3.4333198610551283198e-64, -4.59484066482079735174e-65, -3.7017718795052417138e-65, 5.18121391479904833677e-66, 3.85584780631197884062e-66, -5.62131482549351215608e-67, -3.88661221968657812128e-67, 5.881566915668985098e-68, 3.79696381281218475333e-68, -5.94689655681868976378e-69, -3.60031327385929153523e-69, 5.82146938044483405669e-70, 3.31790428788780915561e-70, -5.52644968890327964572e-71, -2.97542375514680495345e-71, 5.09557022164915767623e-72, 2.59956704742840901326e-72, -4.56959826606029332153e-73, -2.21510121599714597523e-73, 3.99079060000496755729e-74, 1.84276416701069519146e-74, -3.39820714246185613139e-75, -1.49811625568545594017e-75, 2.82440671380223032692e-76, 1.19127414674324301401e-76, -2.29368576683487147822e-77, -9.27333982366803290333e-78, 1.82172390537094702958e-78, 7.07237813168444790675e-79, -1.41631105869915168849e-79, -5.28842801715485027999e-80, 1.07875574353894347741e-80, 3.8799705004873739988e-81, -8.05591008434841422532e-82, -2.7948792799123472687e-82, 5.90270950918573678299e-83, 1.97791232254413031393e-83, -4.24652052042559881328e-84, -1.37601278652016735159e-84, 3.00153014900448374584e-85, 9.41581709723510919595e-86, -2.0856759120769396083e-86, -6.34088400111873286923e-87, 1.42560127893094088006e-87},
            {4.53805881077445840936e-54, -7.83095068295803395896e-53, -1.40399548697419802456e-54, 1.02098311137651742303e-51, -6.2081605238940498994e-52, -4.70472949707156089998e-51, 3.73268349779395285167e-51, 1.1382573510989613739e-50, -1.01657630915508621627e-50, -1.73274450490312547197e-50, 1.68463068248326147558e-50, 1.84135928971495879562e-50, -1.93585026618838974462e-50, -1.46067209065163933423e-50, 1.66550823638588465748e-50, 9.05881828363094094454e-51, -1.12913693216496224579e-50, -4.54072570326162849467e-51, 6.25799362325324472198e-51, 1.88458900318707445886e-51, -2.91514620326012055523e-51, -6.58885134420290678941e-52, 1.16638028165097461201e-51, 1.96169324960888877374e-52, -4.07882005436257374189e-52, -4.99263340185655045418e-53, 1.26456133671879788028e-52, 1.07878353756458599206e-53, -3.5173977896586574636e-53, -1.92237357983356709067e-54, 8.86636388405035316827e-54, 2.56095982063711218111e-55, -2.04289779461381300355e-54, -1.40913642480938505721e-56, 4.33462311936573252975e-55, -5.24853006097990845819e-57, -8.52455744658525359361e-56, 2.44919064795586552488e-57, 1.56270842497153178248e-56, -6.78553466646323274767e-58, -2.6838209230457823174e-57, 1.51709833605148396355e-58, 4.33751772020413175644e-58, -2.96338083235174003225e-59, -6.62336433005476113944e-59, 5.23327563277000485396e-60, 9.5901919380817457297e-60, -8.51384792539554639606e-61, -1.32098229088057807415e-60, 1.29127228149873288553e-61, 1.73606341608003319951e-61, -1.84106268810564081661e-62, -2.18270806112062239773e-62, 2.48307356590649032418e-63, 2.63177361814838029793e-63, -3.18357833877722510489e-64, -3.04997428262675920403e-64, 3.89573821353070499394e-65, 3.40432741472120582907e-65, -4.56536814858128393577e-66, -3.66670646671850496238e-66, 5.13840790601116835958e-67, 3.8175943561367608501e-67, -5.56854833772509750253e-68, -3.84835225322291556107e-68, 5.82347409607347130519e-69, 3.76168963451166255554e-69, -5.88858934559117006202e-70, -3.57042548810353406714e-70, 5.76773810048433449844e-71, 3.29495915418133069827e-71, -5.48111162810233927739e-72, -2.96005350883931687326e-72, 5.06107136242359756501e-73, 2.59155603312913958438e-73, -4.54689989127750048479e-74, -2.21357299941991877017e-74, 3.97950685512146844085e-75, 1.84642344343522944916e-75, -3.39691651819370934546e-76, -1.50549283209144412289e-76, 2.83104471635625276874e-77, 1.20092968415852328986e-77, -2.30593415913217556834e-78, -9.38009673229331406967e-79, 1.83733524729627923265e-79, 7.17937704802198795469e-80, -1.43333612641259575032e-80, -5.38859875133521646427e-81, 1.09566781032641973225e-81, 3.96896241268943023081e-82, -8.21320153031770057544e-83, -2.87062437388181339652e-83, 6.04172010462887216242e-84, 2.04007019745307917079e-84, -4.36432494901259184025e-85, -1.42541173172533313884e-85, 3.09784140611393101214e-86, 9.79729292591620705389e-87, -2.16196645483327967048e-87, -6.62787516963113293734e-88},
            {1.67194230386526195376e-54, 2.32335066717923848431e-54, -5.47195193007556230242e-53, 2.15512716135740839208e-53, 4.05592145494483660114e-52, -2.88720466530820405347e-52, -1.3542457100860317434e-51, 1.14074852431838472611e-51, 2.63402300226659802329e-51, -2.44458571274977154769e-51, -3.41462255093019043046e-51, 3.43039599490737796936e-51, 3.20455209485845405398e-51, -3.47900673260355092242e-51, -2.30133616528632592569e-51, 2.71363408306059493881e-51, 1.31531301919285931029e-51, -1.69978450329924362563e-51, -6.15646166033981504541e-52, 8.82719144497081320699e-52, 2.40963183237927084911e-52, -3.89473986059535839789e-52, -8.00248762619979342846e-53, 1.48866536280152197178e-52, 2.27440043046384937561e-53, -5.0075423936436949415e-53, -5.53838240499996840351e-54, 1.50183654512559283286e-53, 1.14292587594066847463e-54, -4.06018210203606583855e-54, -1.92306890757351716711e-55, 9.98704877295203819554e-55, 2.30123407490820874107e-56, -2.25307224948754751935e-55, -4.88643657418915666035e-58, 4.69437575241999523492e-56, -7.49570848246701744739e-58, -9.08838994518928648669e-57, 2.89918581247389280351e-58, 1.64373144010433131746e-57, -7.56700830359262151017e-59, -2.79045560634985216519e-58, 1.63770916357194784355e-59, 4.46542228682026221432e-59, -3.1306978214872631938e-60, -6.76154110138253155178e-60, 5.4425447275469487902e-61, 9.72105662864248411146e-61, -8.74860909745781193076e-62, -1.33110703138656535516e-61, 1.314463342340326947e-62, 1.74087565152183680046e-62, -1.86025319966226704526e-63, -2.18018364299881595797e-63, 2.49427140321109079505e-64, 2.62064922938276194428e-64, -3.18328875212876190832e-65, -3.03005692854166986742e-65, 3.88171453947947431706e-66, 3.3765981656237160156e-66, -4.53714333332999116276e-67, -3.63319261450473812296e-67, 5.09746986300589382176e-68, 3.78104447692178163605e-68, -5.51812085504089082885e-69, -3.81179499594997315538e-69, 5.76796881685072648765e-70, 3.72797708506801621174e-70, -5.83287058831075485768e-71, -3.54185347104023279214e-71, 5.71637168868110279101e-72, 3.27302668962241357378e-72, -5.43775000893090968952e-73, -2.94538380037220481009e-73, 5.02807361986410336246e-74, 2.58396406021921817126e-74, -4.52521782612639089546e-75, -2.21223878524903222745e-75, 3.96880742202869920186e-76, 1.85011896623304506339e-76, -3.39587026175718493118e-77, -1.51281314947951927173e-77, 2.83769424708542221693e-78, 1.21049084234735879052e-78, -2.31806320693944542221e-79, -9.48592038236860868823e-80, 1.85277978861734696427e-80, 7.28568813819122918012e-81, -1.45020563892575942097e-81, -5.4884272337282981652e-82, 1.11246945540832159707e-82, 4.05795877663477628274e-83, -8.36997037845486203895e-84, -2.94666103726731380457e-84, 6.18077031811617969969e-85, 2.10271979705003446237e-85, -4.4826231113085281063e-86, -1.47541284754116262175e-86, 3.1949555194737498006e-87, 1.01851225350453157997e-87, -2.23922444828895690882e-88},
            {-1.15221057155283717731e-55, 2.0078392762115054935e-54, 1.52641830196300126588e-55, -2.78928725361602499543e-53, 1.63458357426589293265e-53, 1.36661332103086022536e-52, -1.06650642874257593841e-52, -3.51001321303436545128e-52, 3.09714441569253858736e-52, 5.66510126416655041438e-52, -5.44271456171847214834e-52, -6.37632995593451024998e-52, 6.61214740124607337427e-52, 5.35314838867165068297e-52, -6.00101104820196001617e-52, -3.51195046103719368883e-52, 4.28407759333432715898e-52, 1.86203327240175913751e-52, -2.4963677704440129795e-52, -8.17836233803500180131e-53, 1.22094088626559237917e-52, 3.02976786749819016104e-53, -5.12251650679131939398e-53, -9.583837489674049191e-54, 1.8761769038672805093e-53, 2.60494032729345430642e-54, -6.08547485665198025991e-54, -6.07429329364576956421e-55, 1.76904175279589136533e-54, 1.19621100854350123976e-55, -4.65580530133916707377e-55, -1.890279582205410124e-56, 1.118975351641979657e-55, 1.96808504947602726785e-57, -2.47434949682894840023e-56, 5.61603701469526077494e-59, 5.06694391331961228388e-57, -9.93440832773810169973e-59, -9.66410440360281832131e-58, 3.3727925906675301401e-59, 1.72546573814355468498e-58, -8.37184648186370710411e-60, -2.8969219136909635348e-59, 1.75989965626831709938e-60, 4.59201572899523800665e-60, -3.29802760774212912051e-61, -6.8973101986732954248e-61, 5.64967318969471996709e-62, 9.84888473314487036971e-62, -8.97903719150187464851e-63, -1.3409536108162106185e-62, 1.33707424223116592625e-63, 1.74555071903155389014e-63, -1.87886500939336385071e-64, -2.17778003805301738085e-64, 2.50509027129481792285e-65, 2.60999269992036356843e-65, -3.1830225640331589023e-66, -3.01099141757709528395e-66, 3.8682720093476270148e-67, 3.3500779352223495507e-67, -4.51012396979654952406e-68, -3.60115854023135967996e-68, 5.05832034856560836342e-69, 3.74611716909521604512e-69, -5.46992427105702001972e-70, -3.77685980345038226781e-70, 5.71492822517573399948e-71, 3.69575442924368199642e-71, -5.77961829799384846196e-72, -3.51454030826653596889e-72, 5.6672626782140573544e-73, 3.25206735842951961511e-73, -5.39628101832880242741e-74, -2.93139187452030980111e-74, 4.996520452098365813e-75, 2.57678224850580079745e-75, -4.50452138938826715102e-76, -2.21109948317257737608e-76, 3.95868253178242923045e-77, 1.85385723385481473095e-77, -3.39507289432713674032e-78, -1.52008575045583149523e-78, 2.84436750993071945161e-79, 1.21996571720955002524e-79, -2.33008737809607838066e-80, -9.59087346366864649748e-81, 1.86807058654368116003e-81, 7.39135133599620539437e-82, -1.46692933303867533787e-82, -5.58793254551949735465e-83, 1.12916661706903360391e-83, 4.14696309024321198711e-84, -8.52624268985267465855e-85, -3.02298336136642710591e-85, 6.31986218845018814041e-86, 2.16585127520741123632e-86, -4.60140318895902145396e-87, -1.52600632349339005637e-87, 3.29285547072835494374e-88, 1.05792314365168476872e-88},
            {-4.14576439301995358307e-56, -6.31084024106345664018e-56, 1.44763332065211288949e-54, -5.21369842247275619153e-55, -1.14088501151494231646e-53, 7.9351704966355110218e-54, 4.04327452619757918501e-53, -3.3599696912386100588e-53, -8.33565177961688457913e-53, 7.64743680156627044268e-53, 1.14407562659568987189e-52, -1.13530580233899752047e-52, -1.13574232504825836203e-52, 1.21503680313559560228e-52, 8.62208212233992969106e-53, -9.98190745758642495594e-53, -5.2075719012193908628e-53, 6.57476944449064571958e-53, 2.57599808513507992713e-53, -3.58519283113049261795e-53, -1.06626542864285532295e-53, 1.65885307142173442941e-53, 3.75087549207630142335e-54, -6.64118279432325400538e-54, -1.13276387069095694395e-54, 2.33725384183928961881e-54, 2.94897975675800092516e-55, -7.32621700931863732059e-55, -6.58800619798484467889e-56, 2.06798040729479480902e-55, 1.23619605024769452521e-56, -5.30605589818317837648e-56, -1.82034409674571958276e-57, 1.24753626708779896868e-56, 1.5574571900546664525e-58, -2.70661743297586143216e-57, 1.74420754129319226869e-59, 5.45193741987786207016e-58, -1.25633366958609603886e-59, -1.0251057206462968045e-58, 3.86930384717246662963e-60, 1.8078391045812260231e-59, -9.19878114828944900595e-61, -3.00317088763999628369e-60, 1.88351951945152450302e-61, 4.71730758725049109974e-61, -3.46525738543744937603e-62, -7.0307636654706391273e-62, 5.85465630280385001012e-63, 9.97384833650251726509e-63, -9.20528588279555234725e-64, -1.35054356329735286797e-63, 1.35913629755205152097e-64, 1.75010780476320574231e-64, -1.8969391545512778595e-65, -2.17550605948165332659e-65, 2.51556925440732134437e-66, 2.59979540637968375602e-66, -3.18280284443969243969e-67, -2.99274774299861259076e-67, 3.85540538188513010023e-68, 3.32471574427054127826e-68, -4.4842697027664345542e-69, -3.57053700091352491566e-69, 5.02088459489316979646e-70, 3.71273667532574520718e-70, -5.42385732537941552634e-71, -3.74347123512227387458e-71, 5.6642374135569689131e-72, 3.66495445130778710594e-72, -5.72871831762135999765e-73, -3.48843250802623108195e-73, 5.62031029257812993849e-74, 3.23204381940001338512e-74, -5.35662577321556332579e-75, -2.91805605695381752154e-75, 4.96635832807815214593e-76, 2.57000195669235506665e-76, -4.48478121820205967053e-77, -2.21015572662790519296e-77, 3.94912249980629231323e-78, 1.85764425081989385707e-78, -3.39452831115276978966e-79, -1.5273186836595460777e-79, 2.85107583081000044889e-80, 1.22936203364489888016e-80, -2.34202033084561003451e-81, -9.69501658924422512049e-82, 1.88322012491394440464e-82, 7.49640596899012994471e-83, -1.48351664891433360031e-83, -5.68713418605285220113e-84, 1.14576517143895875925e-84, 4.23597979367423339835e-85, -8.68204545224564733826e-86, -3.09958649172434253659e-86, 6.4589994073212857459e-87, 2.22945568716454220264e-87, -4.72065509961752781813e-88, -1.57718297772052540468e-88, 3.39152566881279607023e-89},
            {2.92307141531608922093e-57, -5.14552589361941820366e-56, -6.96366413833549005384e-57, 7.6018694341938352276e-55, -4.28355098701607073687e-55, -3.95290864942638753185e-54, 3.03293659797721672358e-54, 1.07590167195733807652e-53, -9.37985359601651976655e-54, -1.83793324777572714325e-53, 1.7456242552869389869e-53, 2.18732172650593320122e-53, -2.23902793631112963984e-53, -1.94012730522776419003e-53, 2.14087827222468796747e-53, 1.34406388611301885915e-53, -1.60740659327650676092e-53, -7.52354389842532167843e-54, 9.83629263691753398021e-54, 3.48955639003153141803e-54, -5.04537011495893810345e-54, -1.36637474928965654308e-54, 2.21731331346836584059e-54, 4.57712257002851709596e-55, -8.49709344938566034048e-55, -1.32238509711874318766e-55, 2.88059708186229278996e-55, 3.30132949766518428117e-56, -8.74343963472292740092e-56, -7.06615220170664574258e-57, 2.40039570111887361905e-56, 1.26038907356430802069e-57, -6.01257155344780973198e-57, -1.70969967025658739506e-58, 1.38445452095521303743e-57, 1.06560648792935098248e-59, -2.94974538346396753e-58, 3.06129249231511840244e-60, 5.84896467759437604797e-59, -1.5380762037828972687e-60, -1.08486323121632996029e-59, 4.38800350211893406763e-61, 1.89078501244131937028e-60, -1.00465962216574786364e-61, -3.10916049450201165799e-61, 2.00842989341613761354e-62, 4.84131242219241690574e-62, -3.63228858613105626532e-63, -7.16199330881352559083e-63, 6.05750004882000905736e-64, 1.00961121841374060666e-63, -9.42750929884706260243e-65, -1.35989708195446654727e-64, 1.38067947280655925026e-65, 1.75456456493450286034e-65, -1.91451409943082492879e-66, -2.17336942613811561482e-66, 2.52574439819781386776e-67, 2.59004869328009797312e-67, -3.18265027542542665287e-68, -2.97529734103654117868e-68, 3.84310877754532412873e-69, 3.30046358949217648966e-69, -4.45954199107672474104e-70, -3.54126494928415257615e-70, 4.98509217895867644201e-71, 3.68083207315640191489e-71, -5.37982508358034340184e-72, -3.71155865103678231119e-72, 5.61578880275503558943e-73, 3.63551411366281091483e-73, -5.68006371731180013181e-74, -3.46347975547364465676e-74, 5.57541994740923262109e-75, 3.21292078250270723859e-75, -5.31870997612827312242e-76, -2.90535569788584212299e-76, 4.93753654184986833926e-77, 2.56361478575890246147e-77, -4.4659692120530096615e-78, -2.20940790675551939437e-78, 3.94011775401901348118e-79, 1.86148556863484110823e-79, -3.39423984791330024542e-80, -1.534519536961365616e-80, 2.85782972693721105613e-81, 1.23868716510509181524e-81, -2.35387496577420021983e-82, -9.79840835942695000696e-83, 1.89824034212059070238e-83, 7.6008907299908387054e-84, -1.49997673679796987277e-84, -5.7860519989915980157e-85, 1.16227092532125620167e-85, 4.32501418885027759168e-86, -8.8374064477247374898e-87, -3.17646656457085716955e-87, 6.59818718659803985463e-88, 2.29352495172817784812e-88, -4.84037039772774557368e-89, -1.62893424333317765232e-89},
            {1.02855192429683201735e-57, 1.70460289151188538806e-57, -3.82435352232219537464e-56, 1.24559825389415098687e-56, 3.19883035346741314533e-55, -2.17167026599135060362e-55, -1.20119109124794137642e-54, 9.84553620718517003748e-55, 2.62042200840115432177e-54, -2.37697004765969616392e-54, -3.80154590803896184932e-54, 3.72828433593246185328e-54, 3.98538307140595344735e-54, -4.20531232838693776234e-54, -3.19296977142252235823e-54, 3.6342921351137945046e-54, 2.03438544428937197157e-54, -2.51422283889316555764e-54, -1.06152643826150961358e-54, 1.43798443837987801939e-54, 4.63679056209202489835e-55, -6.96988695230713931233e-55, -1.72322607795265095123e-55, 2.9197061260075250175e-55, 5.51063457538424681077e-56, -1.07401083586618699401e-55, -1.52573802018283758642e-56, 3.5152209016452675065e-56, 3.65596450586143678215e-57, -1.03508067958779706437e-56, -7.49446343288719268194e-58, 2.76796390517658646061e-57, 1.26626831989063277627e-58, -6.77684050055103644429e-58, -1.55489974976146897085e-59, 1.52977696933124554362e-58, 4.89099363284490834442e-61, -3.20358682684609861835e-59, 4.51453892455308084137e-61, 6.2576353782729936694e-60, -1.83845746809876575297e-61, -1.14562420137852918674e-60, 4.92817251075560278689e-62, 1.97424235549893018744e-61, -1.09141293092563226688e-62, -3.2148550313313594941e-62, 2.13450279138201298712e-63, 4.96404912810026073817e-63, -3.79903563930244826282e-64, -7.29109029033187288013e-64, 6.25821969005738400188e-65, 1.0215833875500710083e-64, -9.64586117782173791191e-66, -1.36903310673127665934e-65, 1.40173241758238230584e-66, 1.75893725627230338927e-66, -1.93162590805677401022e-67, -2.1713768818319511829e-67, 2.53564896844500241904e-68, 2.58074391923962469595e-68, -3.1825833970028768879e-69, -2.95861301782606580719e-69, 3.83137580129071239615e-70, 3.27727623829658970745e-70, -4.43590402901992235761e-71, -3.51328322036405467541e-71, 4.95087672400756200541e-72, 3.65033690472785117719e-72, -5.33773846348227728642e-73, -3.68105584539171892046e-73, 5.56948158086737071917e-74, 3.60737424569388146324e-74, -5.63355424583963941313e-75, -3.43963468760934351384e-75, 5.53250279570817553787e-76, 3.1946648763708441363e-76, -5.28246359891042473815e-77, -2.89327111883439297127e-77, 4.91000703990305963467e-78, 2.55761258065633148945e-78, -4.44805847853074724881e-79, -2.20885620273705508459e-79, 3.9316588583316912319e-80, 1.86538632322593152681e-80, -3.39421034045901182778e-81, -1.54169546835077078043e-81, 2.86463897048887623359e-82, 1.24794815220308696568e-82, -2.36566347435788868208e-83, -9.90110542689934160532e-84, 1.91314265792374556375e-84, 7.7048436551790177766e-85, -1.51631846422395999966e-85, -5.8847061061789141641e-86, 1.17868961024897078625e-86, 4.41407236505136919052e-87, -8.99235413327828407264e-88, -3.25362064667695570325e-88, 6.73743213503229516647e-89, 2.35805181445189308143e-89, -4.96054218015337851725e-90},
            {-7.41032751001312864358e-59, 1.31805012079164508397e-57, 2.58112483690278703733e-58, -2.06711273079229120856e-56, 1.11718406499103358033e-56, 1.13882910271519868712e-55, -8.58644969214541738917e-56, -3.27934806591936513119e-55, 2.82474551416887888678e-55, 5.91972031231037957491e-55, -5.56006770765955540012e-55, -7.43722767981283238289e-55, 7.52009061218099772067e-55, 6.95845129455503621433e-55, -7.56620000020772129465e-55, -5.08206916001067170509e-55, 5.96768842547039100284e-55, 2.99816382044273142281e-55, -3.83073421243288538256e-55, -1.46570889792137803298e-55, 2.05852489800454878867e-55, 6.0527058374583185514e-56, -9.46657037029615483188e-56, -2.14129599302021849184e-56, 3.79197263670466825938e-56, 6.55118707387649117341e-57, -1.3423414738468206227e-56, -1.74078792671631012252e-57, 4.25040353604402199148e-57, 4.0060541352241268296e-58, -1.21619038245915262331e-57, -7.85788621217638676962e-59, 3.17228902721799712044e-58, 1.25129996267795827032e-59, -7.60020435917841537066e-59, -1.35262825135486426078e-60, 1.68353196583489281683e-59, -1.75191764034205606825e-62, -3.46798192532410686001e-60, 6.10521633079783267926e-62, 6.67756282514644638407e-61, -2.15723427576299210621e-62, -1.20733273476834506374e-61, 5.48909400182552936245e-63, 2.05815517574001905494e-62, -1.18002726752097453459e-63, -3.3202245725639505092e-63, 2.26162053030204685597e-64, 5.08554032052975927361e-64, -3.96542482240207857839e-65, -7.41814478816458416288e-65, 6.45683850786340431334e-66, 1.03331640796518664855e-65, -9.86049417028527781037e-67, -1.37796940689450382678e-66, 1.42232250746663125874e-67, 1.76324085480064301804e-67, -1.94830840568551912147e-68, -2.16953430161169456018e-68, 2.54531368621221356869e-69, 2.57187249553448469114e-69, -3.18261882652410440659e-70, -2.94266887967582467641e-70, 3.8201996483650483153e-71, 3.25511103989886657367e-71, -4.41332066960349672611e-72, -3.4865362454515144006e-72, 4.91817562486278086547e-73, 3.62118883973995373871e-73, -5.29751380304523803652e-74, -3.65190071277253566453e-74, 5.52522119274768635518e-75, 3.58047925978923523943e-75, -5.58909583091512163851e-76, -3.41685268690700369734e-76, 5.49147531215976091414e-77, 3.17724452576267338285e-77, -5.24782059186308213899e-78, -2.88178356234615215038e-78, 4.88372426058986410068e-79, 2.55198743058852387573e-79, -4.43102328094739737062e-80, -2.20850060890889979832e-80, 3.92373653213161257704e-81, 1.86935126920089344235e-81, -3.39444217861951823277e-82, -1.54885323467718116453e-82, 2.87151264710378271059e-83, 1.25715172040807912123e-83, -2.3773973843364138607e-84, -1.0003162562276063938e-84, 1.92793799915536292188e-85, 7.80830210795767631125e-86, -1.53255042359430023568e-86, -5.98311684850220782785e-87, 1.19502687763138905632e-87, 4.5031611301775561307e-88, -9.14691753306873642785e-89, -3.33104667851478986468e-89, 6.87674214381050447043e-90, 2.42302981187057459017e-90},
            {-2.55313594493202170655e-59, -4.58205507895468151065e-59, 1.00897130135008995616e-57, -2.93118231467939927076e-58, -8.94172094093271799755e-57, 5.91894961854949001375e-57, 3.55190370983552317345e-56, -2.87086510076984042919e-56, -8.18623872327671799934e-56, 7.3430329781318995306e-56, 1.25334954684471770201e-55, -1.2153757362112210308e-55, -1.38546766293069429185e-55, 1.44307106632228108193e-55, 1.16959680924600344462e-55, -1.31039462528372908471e-55, -7.84855283365687697662e-56, 9.51085490387446202029e-56, 4.3124817195968023208e-56, -5.69935702766029096574e-56, -1.98403199684998541676e-56, 2.89088640463819399308e-56, 7.77228586928890908015e-57, -1.26589232435747485475e-56, -2.62426589790522771355e-57, 4.862612982152209646e-57, 7.69592806351033306224e-58, -1.66033199827608571773e-57, -1.96496232141084467272e-58, 5.0956378341187127759e-58, 4.34400078674017537925e-59, -1.41901717028128854995e-58, -8.14069487896536851702e-60, 3.61489870628422510058e-59, 1.21295431786542780066e-60, -8.48386210497887819994e-60, -1.0997107913048169835e-61, 1.8457308977420715982e-60, -9.3009563058692455273e-63, -3.74275985993608539809e-61, 7.83421655181181950212e-63, 7.10836591782638619059e-62, -2.49413635659280387234e-63, -1.26993582060684502925e-62, 6.07005765760383154588e-64, 2.14247238929600059752e-63, -1.27039735855107222677e-64, -3.42524445530362989778e-64, 2.38967516276529483651e-65, 5.20581179089782087685e-65, -4.13139319669607942812e-66, -7.54324571998048567282e-66, 6.65338668203092915615e-67, 1.04482467665257204834e-66, -1.00715592641372073893e-67, -1.38672265841480922067e-67, 1.44247588772154920194e-68, 1.76748916405428561687e-68, -1.96459332966472618144e-69, -2.16784678652009531422e-69, 2.55476694170658140869e-70, 2.56342591812184631291e-70, -3.18277145471322424793e-71, -2.92744026664560420774e-71, 3.80957319533934153966e-72, 3.23392775137426048078e-72, -4.39175834999365591263e-73, -3.46097179079859420212e-73, 4.88692979488889739026e-74, 3.59332936824820980859e-74, -5.25907246568887812026e-75, -3.62403494387094901369e-75, 5.48291887460684814074e-76, 3.55477689182535207694e-76, -5.54660012328374467323e-77, -3.39509169186302009079e-77, 5.45225891272033072933e-78, 3.16062983814472696657e-78, -5.21471861603513177701e-79, -2.87087514453120607199e-79, 4.85864498468981854026e-80, 2.54673166811680045253e-80, -4.41483898787107896962e-81, -2.20834095899867100089e-81, 3.9163416662887906756e-82, 1.87338481122506100248e-82, -3.39493735468727548516e-83, -1.55599921839892245881e-83, 2.87845920965839275411e-84, 1.26630429685680303898e-84, -2.38908760211963986022e-85, -1.01046327197326263558e-85, 1.94263682432375407521e-86, 7.91130276784265513495e-87, -1.54868094002932271688e-87, -6.08130473312330823873e-88, 1.21128829486317953311e-88, 4.59228794729662961904e-89, -9.30112614143973766322e-90, -3.40874342059857011186e-90, 7.016126280405281896e-91},
            {1.87743052636436768052e-60, -3.37480691300026149148e-59, -8.68927349903683146282e-60, 5.60896749829548830507e-58, -2.89948439744398489897e-58, -3.26867530161944169757e-57, 2.42046087047688076387e-57, 9.9424952428357746702e-57, -8.46126798198707290093e-57, -1.89367147355979734101e-56, 1.75937956025927040474e-56, 2.50778530028723136488e-56, -2.50621128277472159143e-56, -2.47129868089015623561e-56, 2.65028435861404695363e-56, 1.89989345889202013495e-56, -2.19347718025209571381e-56, -1.17941045966749545661e-56, 1.47542549303930348785e-56, 6.06673822457835973963e-57, -8.29777642606240779184e-57, -2.63702658184690275846e-57, 3.98912300636844416374e-57, 9.82943496026253975517e-58, -1.66868213292884200301e-57, -3.17481324131952494844e-58, 6.16266272695146086326e-58, 8.93913427002227845496e-59, -2.03390208212713781751e-58, -2.19514553787446186592e-59, 6.06058275894220214301e-59, 4.6614854283885656728e-60, -1.64488480990998929719e-59, -8.32660427964712756409e-61, 4.09724124434787357299e-60, 1.14872044863835856941e-61, -9.4288749792123431666e-61, -7.93123174063529736101e-63, 2.01636969968713005593e-61, -1.77815148522388419037e-63, -4.02774097186710526389e-62, 9.70208641224404081222e-64, 7.54967082944381136078e-63, -2.84887104669047740121e-64, -1.33338332031988360062e-63, 6.67036341411278582529e-65, 2.22714751423238978228e-64, -1.36242341384534443637e-65, -3.52989480192902834335e-65, 2.51856791643644692181e-66, 5.32489202155177330934e-66, -4.2968876248176389002e-67, -7.66648051862092110234e-67, 6.84790029648325745524e-68, 1.05612194486785766288e-67, -1.02792053152862349178e-68, -1.39530851644494047332e-68, 1.46221751875170754074e-69, 1.77169491369985373057e-69, -1.98051047021487459849e-70, -2.16631874813219641128e-70, 2.56403498889298391195e-71, 2.55539579406873058973e-71, -3.18305462098682901495e-72, -2.91290368938031614344e-72, 3.79948907841614657805e-73, 3.213688377320191248e-73, -4.37118501937636432771e-74, -3.43654071854607914578e-74, 4.85708343269588657903e-75, 3.56670352028196731304e-75, -5.22234047934851695018e-76, -3.59740374769463172672e-76, 5.44249122923286982783e-77, 3.53021796371220934702e-77, -5.50598408026420197335e-78, -3.37431202288757863026e-78, 5.41477960606582866291e-79, 3.1447924986319007844e-79, -5.18309879656520977318e-80, -2.86052881026101424948e-80, 4.83472819626933976601e-81, 2.54183786728754576996e-81, -4.39948202460182288018e-82, -2.2083769477927117007e-82, 3.90946533615184695029e-83, 1.87749103277007176757e-83, -3.39569750711901157596e-84, -1.56313945248317406664e-84, 2.885486527721063618e-85, 1.27541202631377342054e-85, -2.40074445242100560214e-86, -1.02055671022959423732e-86, 1.95724914713576213207e-87, 8.01388162373554662952e-88, -1.56471807940582051006e-88, -6.17929038649144214473e-89, 1.22747934228313451202e-89, 4.68146087611562656947e-90, -9.4550098357275473649e-91, -3.48671040287980239489e-91},
            {6.34069010160169203101e-61, 1.22651032077548006343e-60, -2.65861635410076315933e-59, 6.76885483572806228868e-60, 2.49234349873414113215e-58, -1.60676918461622310823e-58, -1.04567460681182789328e-57, 8.33214442875578909815e-58, 2.54234261970937304203e-57, -2.25530930147355580066e-57, -4.10189705048046551681e-57, 3.93442467865161109867e-57, 4.77412208100259423995e-57, -4.91188050155294062845e-57, -4.24048075839951771098e-57, 4.68138619811280125782e-57, 2.99249700570452553594e-57, -3.56093810013029683463e-57, -1.72872669723823012188e-57, 2.23349474156958226545e-57, 8.36243353180611387343e-58, -1.18440610912795408176e-57, -3.44623887036341219707e-58, 5.41643254181520831559e-58, 1.22558301071290289439e-58, -2.1707063040031780677e-58, -3.79440819133727379872e-59, 7.72564513101600820764e-59, 1.02720041513095653171e-59, -2.46923542820121177974e-59, -2.42767994444650997376e-60, 7.15501637816096748952e-60, 4.94951849269683675967e-61, -1.89509151503973538906e-60, -8.39887925155395134463e-62, 4.62068367087140425329e-61, 1.05611915398641560349e-62, -1.04361721429160888137e-61, -4.29997409905305305112e-64, 2.19543032917360916342e-62, -2.72162017622170036909e-64, -4.32273871439080385755e-63, 1.17090594309714450438e-64, 8.00111240692967822378e-64, -3.22112754767391444757e-65, -1.39762793386191180016e-64, 7.28932455501037931875e-66, 2.31213840285097623206e-65, -1.45601106744864679678e-66, -3.63416007842945773582e-66, 2.648208645990800873e-67, 5.44281175535343237226e-67, -4.4618638656198580013e-68, -7.78793495297179275557e-68, 7.04042045810085640394e-69, 1.06722134292739927789e-68, -1.04835786689569321501e-69, -1.40374168312970520392e-69, 1.48157122258000964823e-70, 1.77586984945439139156e-70, -1.9960878017026322906e-71, -2.16495398402937873798e-71, 2.57314212270795030206e-72, 2.54777386319518392443e-72, -3.18348027039809345095e-73, -2.89903676912256781646e-73, 3.78993976070084916504e-74, 3.19435702192869567898e-74, -4.35157006939234515923e-75, -3.4131967677561455393e-75, 4.82858380684818960576e-76, 3.54125960961215264115e-76, -5.18724820597426047147e-77, -3.57195559763605657919e-77, 5.40385983778385215855e-78, 3.50675616585884427921e-78, -5.46716958483398976437e-79, -3.35447622212122784937e-79, 5.37896767386070648467e-80, 3.12970567258945112246e-80, -5.15290549519744887977e-81, -2.85072829088608087801e-81, 4.81193495305409007674e-82, 2.53729884095499297514e-82, -4.38492982659430459374e-83, -2.2086081505083392925e-83, 3.90309881193952270106e-84, 1.8816737224688535251e-84, -3.3967239599397553666e-85, -1.57027964358997147293e-85, 2.89260193305226300659e-86, 1.28448078631420815936e-86, -2.41237771530102400481e-87, -1.03060152264782621119e-87, 1.9717845589594785679e-88, 8.11607397100324710473e-89, -1.58066965651040198161e-89, -6.27709451260609059822e-90, 1.24360541088126261446e-90, 4.77068851903528640282e-91, -9.60859879802482026198e-92},
            {-4.7539166355894846525e-62, 8.63759860598333519642e-61, 2.76610989979141495474e-61, -1.51890308526918657887e-59, 7.48721983937282304332e-60, 9.34864443494482798669e-59, -6.79503912564678259521e-59, -2.99934161613038495513e-58, 2.52161305739051345519e-58, 6.01875836879818873884e-58, -5.53264641565735795331e-58, -8.38986671257234854151e-58, 8.29112667178614956142e-58, 8.69586000989289053232e-58, -9.20514028904164563751e-58, -7.0270704812582969921e-58, 7.98589516549072975194e-58, 4.58343636647874120305e-58, -5.62308991103738944996e-58, -2.47683705965710936626e-58, 3.30648926966363995801e-58, 1.13124680480352686081e-58, -1.66018627572542907473e-58, -4.43375869704141639884e-59, 7.24583050930906337827e-59, 1.50797074278322394027e-59, -2.78937678903750248514e-59, -4.48311961117844341242e-60, 9.58750144844539233575e-60, 1.16824891347803539785e-60, -2.97275356822437709951e-60, -2.65837315791515647067e-61, 8.38879087501063488145e-61, 5.19849475449404460837e-62, -2.17090539368166534761e-61, -8.3404397628833479228e-63, 5.18651073415519225918e-62, 9.32714364511888389496e-64, -1.15065569009784213724e-62, -7.62553277206516448245e-67, 2.3828821916280170499e-63, -3.7624965576296857095e-65, -4.62756142214637267509e-64, 1.38550863507447394396e-65, 8.46233532366261778684e-65, -3.61058077530705642934e-66, -1.46262514952772553421e-65, 7.92627026729720963363e-67, 2.39740698056230204678e-66, -1.55107128464582496153e-67, -3.73802868670964994934e-67, 2.7785153012817883052e-68, 5.55960361431491686758e-68, -4.62628574176475218757e-69, -7.90769298762889059709e-69, 7.23099251680989461441e-70, 1.07813540528785911333e-69, -1.06848228585486239928e-70, -1.41203597098987404761e-70, 1.50055972970415077105e-71, 1.78002481510718378675e-71, -2.01135160497153587926e-72, -2.16375574522504989226e-72, 2.582110840533967805e-73, 2.5405520156248539963e-73, -3.18405909425857815702e-74, -2.8858181808081032184e-74, 3.78091758991322288699e-75, 3.17589975238803230172e-75, -4.33288426724212574921e-76, -3.39089635361660709368e-76, 4.80138105701252967907e-77, 3.51694899929457169471e-77, -5.15373003854211379666e-78, -3.54764199906155749336e-78, 5.36695090455934961111e-79, 3.48434785765197015929e-79, -5.43008309680171082637e-80, -3.33554890590724338234e-80, 5.34475737713240116772e-81, 3.115343915265890191e-81, -5.12408610027969114304e-82, -2.84145806433471809825e-82, 4.79022826559570510998e-83, 2.53310763744634979989e-83, -4.37116079481386380962e-84, -2.20903404011420528172e-84, 3.89723356688172643958e-85, 1.88593639828866580276e-85, -3.39801775828267773308e-86, -1.57742519366384746482e-86, 2.89981226148535053645e-87, 1.29351620152397255574e-87, -2.42399666079281131274e-88, -1.040602498599367597e-88, 1.98625225025472472241e-89, 8.21791441185337850255e-90, -1.59654324324689434929e-90, -6.3747378560430512599e-91, 1.2596718006637121361e-91, 4.85997997146680562613e-92},
            {-1.57544614181627601623e-62, -3.27099223535389498887e-62, 6.99713655598973792203e-61, -1.52526202165019760335e-61, -6.9282162282278301452e-60, 4.34466687627049292764e-60, 3.06566407453177793936e-59, -2.40748668419972920335e-59, -7.85167238234986604683e-59, 6.88874103366312056199e-59, 1.33313878538406015964e-58, -1.26523797144760200619e-58, -1.63145679741525239966e-58, 1.65902929049369472048e-58, 1.5225969850169262619e-58, -1.65781105342482614841e-58, -1.12840048652900141718e-58, 1.32025366207589877678e-58, 6.84350459496595192741e-59, -8.65904310703750002899e-59, -3.47526636933480972395e-59, 4.79613377190999035876e-59, 1.50399257904937305485e-59, -2.28856169867854872133e-59, -5.6216684904357339955e-60, 9.56076195124532288902e-60, 1.83246079274300892934e-60, -3.54386232713357978639e-60, -5.23943360819547221743e-61, 1.17865016879727341367e-60, 1.31551635202983523959e-61, -3.55108885041225809835e-61, -2.88251061779566161205e-62, 9.77178999819109826338e-62, 5.39825090830120913001e-63, -2.4735605482357205544e-62, -8.13396066736058028576e-64, 5.7959247143111814378e-63, 7.76122995415236973634e-65, -1.26407133419275393489e-63, 4.76538519170757972986e-66, 2.57868350574959111854e-64, -4.90252285626233053622e-66, -4.94201390603841448947e-65, 1.61398643005443558637e-66, 8.93299501180034929327e-66, -4.01689482002721146282e-67, -1.5283331805305732263e-66, 8.58054772152323739146e-68, 2.48291899288321698923e-67, -1.6475202419683389334e-68, -3.84149258900407244912e-68, 2.90941341447537055081e-69, 5.67530176230419203182e-69, -4.79012437544139248642e-70, -8.02583667575836864463e-70, 7.41966537620922336093e-71, 1.0888760956312699349e-70, -1.08830783707315530451e-71, -1.42020436212415036682e-71, 1.5192047258328955998e-72, 1.78416982737426048744e-72, -2.02632658128332907112e-73, -2.16272679643748828784e-73, 2.59096198942855537197e-74, 2.53372230583796216058e-74, -3.18480065624622761375e-75, -2.87322759913576897659e-75, 3.77241484781110371889e-76, 3.15828447263590024523e-76, -4.31509969150916791107e-77, -3.36959838309722019375e-77, 4.7754280101283807975e-78, 3.49372588687634359905e-78, -5.12172412296232017698e-79, -3.52441727633863179247e-79, 5.33169493155161199434e-80, 3.46295188424503414062e-80, -5.3946553329825143996e-81, -3.31749662877967305304e-81, 5.31208668632232943701e-82, 3.10168308788326753444e-82, -5.09659083271900168659e-83, -2.83270331745971516177e-83, 4.76957298457242671741e-84, 2.52925753669513383702e-84, -4.35815425299823061036e-85, -2.20965400281529374596e-85, 3.89186128341851283239e-86, 1.8902823297141459313e-86, -3.39957970045223799999e-87, -1.58458122004780418088e-87, 2.90712389149284752231e-88, 1.30252365735102624029e-88, -2.43561008127098375079e-89, -1.05056427143458749792e-89, 2.00066103100176866829e-90, 8.31943685855282111564e-91, -1.61234617684617652298e-91, -6.47224116929951101985e-92, 1.27568371959465009649e-92},
            {1.20317472809904484208e-63, -2.20991363270970949966e-62, -8.48822604948253423983e-63, 4.10539055827742255299e-61, -1.92320784487134023443e-61, -2.66485561616917340012e-60, 1.90004099048634875342e-60, 9.00529813837688065182e-60, -7.47847721395367647561e-60, -1.90134474246705333944e-59, 1.72954918327948802752e-59, 2.78607206647896806198e-59, -2.72375518099659927348e-59, -3.03317481852037549854e-59, 3.17155054597109249945e-59, 2.57298763123471780566e-59, -2.88123418995322611443e-59, -1.76092463139202953083e-59, 2.12165976791159090252e-59, 9.98241812189071114648e-60, -1.30319980731139055989e-59, -4.78312535868358045269e-60, 6.82789164376655682911e-60, 1.96763282201174966795e-60, -3.10656636432527723305e-60, -7.03142227409369116612e-61, 1.24556429795672261555e-60, 2.20081070406010272183e-61, -4.45509824835470123317e-61, -6.0600873231490592428e-62, 1.43631384106275676739e-61, 1.46711325434668361814e-62, -4.21105705768695919969e-62, -3.09487284171310654588e-63, 1.13138892667328305247e-62, 5.538124694460425942e-64, -2.80425380248528521244e-63, -7.76196529952432368874e-65, 6.45004595581302981758e-64, 5.84023326531730776746e-66, -1.38392132588027516825e-64, 1.02487871011586462682e-66, 2.78278260248412781605e-65, -6.14320269050233203482e-67, -5.26589888312717378547e-66, 1.85628644613280907146e-67, 9.41275839960586103392e-67, -4.43972604345763945606e-68, -1.59471289117334288162e-67, 9.25152373376022176787e-69, 2.56864376169848889157e-68, -1.74527918610996579002e-69, -3.94454696249649400203e-69, 3.04083560806746772283e-70, 5.78994160729042656331e-70, -4.95335748765300599533e-71, -8.14244608028783171767e-71, 7.60649088507513548536e-72, 1.099454831736188699e-71, -1.10784824669966457593e-72, -1.42825906347129323928e-72, 1.53752689810708234596e-73, 1.78831414424567674012e-73, -2.04103595840574764744e-74, -2.16186947000018368726e-74, 2.59971490045333816098e-75, 2.52727696373778369249e-75, -3.18571350559382281069e-76, -2.86124564749530306117e-76, 3.76442379242544026516e-77, 3.14148080657974235944e-77, -4.29818967071138921815e-78, -3.34926408552070287563e-78, 4.7506800103197424461e-79, 3.47154710738272001178e-79, -5.0911721025487650445e-80, -3.50223837744527956318e-80, 5.29802641992591983503e-81, 3.44252940813549063535e-81, -5.36082097362508023486e-82, -3.30028775794195128058e-82, 5.28089703283728967885e-83, 3.08870027966313411407e-83, -5.07037256651759238541e-84, -2.82444991050546778291e-84, 4.74993569561643915898e-85, 2.52574204595026013954e-85, -4.34589040678650853316e-86, -2.21046735189536801351e-86, 3.88697385772581332816e-87, 1.89471455811443785636e-87, -3.40141036685748457855e-88, -1.59175257422599607791e-88, 2.914542779716174343e-89, 1.31150831284264300786e-89, -2.44722632171506539001e-90, -1.06049132461182411743e-90, 2.01501935016110130867e-91, 8.42067453908833048712e-92, -1.62808556803512190797e-92, -6.5696251840529276003e-93},
            {3.91620448636848723805e-64, 8.69502324166035937217e-64, -1.83950898985758941332e-62, 3.3235641226531827826e-63, 1.92099332058946572721e-61, -1.17025613140122156836e-61, -8.95246917394045054061e-61, 6.92657836254412602544e-61, 2.41212025230999543628e-60, -2.09310675697065427053e-60, -4.30434207739328230148e-60, 4.04318230863573194616e-60, 5.53144412059613867317e-60, -5.5624881613262291235e-60, -5.41722580677330905377e-60, 5.82193578870319241667e-60, 4.21064245538791861335e-60, -4.84955183742409323744e-60, -2.67731684626158808368e-60, 3.32278465766127739282e-60, 1.42523958943618787363e-60, -1.9206201449977100178e-60, -6.46695271487395205207e-61, 9.55430582482544714604e-61, 2.53593604686858058636e-61, -4.15732098141428377346e-61, -8.68316553625315854743e-62, 1.60363255882530463236e-61, 2.61405511282943131246e-62, -5.54578197499552484951e-62, -6.93992002261066773967e-63, 1.73600061982206351176e-62, 1.62079773138357232426e-63, -4.95963005130904266933e-63, -3.28975667397556714206e-64, 1.30249191539350886005e-63, 5.60701455860956551756e-65, -3.16414202309757799899e-64, -7.20691237129603626517e-66, 7.14991402226999563065e-65, 3.54161993652408884211e-67, -1.51025232348645900122e-65, 1.63961816544488433409e-67, 2.99511915312230954786e-66, -7.48581547766417158396e-68, -5.59901825154981676948e-67, 2.11233581532255563986e-68, 9.90130447704834992322e-68, -4.8787258357683890378e-69, -1.66172771503781915419e-68, 9.93858606135126023998e-70, 2.65455395158312637778e-69, -1.84427427678852881954e-70, -4.04718988223672447429e-70, 3.1727211250372368999e-71, 5.90355953902070248671e-71, -5.11596875662443067474e-72, -8.2575992192049795886e-72, 7.79152330105489748665e-73, 1.10988250996216245221e-72, -1.12711690532037394548e-73, -1.43621155836941305692e-73, 1.55554598049734598499e-74, 1.79246632742283979205e-74, -2.05550158936123884693e-75, -2.16118571410787979719e-75, 2.60838751131448065101e-76, 2.52120840316996675668e-76, -3.18680527876497485371e-77, -2.84985384963123702277e-77, 3.75693669405787268811e-78, 3.12545998998304292991e-78, -4.28212872456198467882e-79, -3.32985685667199630809e-79, 4.72709476138773168282e-80, 3.45037195240363954328e-80, -5.06201888295908380435e-81, -3.48106469450389661427e-81, 5.26588359588522016408e-82, 3.42304375416733488123e-82, -5.32851839263105609756e-83, -3.28389235731317194461e-83, 5.25113308014904652009e-84, 3.07637373531320483701e-84, -5.04538666264471466909e-85, -2.81668434357403048758e-85, 4.73128462110953055085e-86, 2.52255489515266043345e-86, -4.33435030466870626622e-87, -2.21147334008868812851e-87, 3.88256340280229579754e-88, 1.89923591545235735127e-88, -3.40351014612619919941e-89, -1.59894385929374996926e-89, 2.92207449371235011398e-90, 1.32047511290218246998e-90, -2.45885330800883545519e-91, -1.07038799768335789884e-91, 2.029335314198710506e-92, 8.52166000491433259497e-93, -1.6437683091285307689e-93},
            {-3.04382565454722623635e-65, 5.65204870032654850832e-64, 2.53787136995887577898e-64, -1.10764622705878614931e-62, 4.91256406006566520316e-63, 7.57224455201951607593e-62, -5.29263172577813234476e-62, -2.69166647246637851285e-61, 2.20768058720613555829e-61, 5.97182358774058303281e-61, -5.37628516928611179692e-61, -9.18700422376293015304e-61, 8.88847072449710618873e-61, 1.04926219101136836071e-60, -1.084383976295998922e-60, -9.33164722088344017444e-61, 1.03058668782627574706e-60, 6.6925531863695106689e-61, -7.92910633610199808867e-61, -3.97461726601983924499e-61, 5.08294379380883735169e-61, 1.99509144561169788472e-61, -2.77654526525003352244e-61, -8.6002784023966303444e-62, 1.31584269017197031379e-61, 3.22300867107657649098e-62, -5.49050642180762685825e-62, -1.05950078574006663772e-62, 2.04204813842621319602e-62, 3.07238222700573425505e-63, -6.84035502181043458842e-63, -7.87174297532674554648e-64, 2.08216694105011292433e-63, 1.77397347169757903039e-64, -5.80390878548942743681e-64, -3.46099985008785409579e-65, 1.49146313931754445997e-64, 5.59343896505025898887e-66, -3.55433999839595668594e-65, -6.45127583326755007713e-67, 7.89648938187359028683e-66, 8.43596850216294666089e-69, -1.64310117949270128292e-66, 2.32282166500422608951e-68, 3.21562532383495283815e-67, -8.93143100795427696168e-69, -5.94117422086164110047e-68, 2.38204413009813355791e-69, 1.03983247109537339836e-68, -5.33354305889100953615e-70, -1.72934356726158698401e-69, 1.06411443794332482638e-70, 2.74062534670211584842e-70, -1.94443641781382099645e-71, -4.14942203047380020769e-71, 3.30501538185507538437e-72, 6.01619269840992460739e-72, -5.27794723103895123476e-73, -8.37137203130114877545e-73, 7.97481881874491817832e-74, 1.12016952921336765891e-73, -1.14612685898253761141e-74, -1.44407265464221654681e-74, 1.57328079814225934958e-75, 1.79663429938628012536e-75, -2.06974404432738445754e-76, -2.16067713601572778081e-76, 2.61699647840568753036e-77, 2.51550922827252515276e-77, -3.188082790861007139e-78, -2.83903458391880753614e-78, 3.74994586586471563537e-79, 3.11019477029144512394e-79, -4.26689250789781980004e-80, -3.31134211521158985136e-80, 4.70463218083198724403e-81, 3.43016200377749084457e-81, -5.03421241573232719432e-82, -3.46085789875744733754e-82, 5.23520815864395782464e-83, 3.40446026673679650518e-83, -5.29768940936601562074e-84, -3.26828208031006295918e-84, 5.22274251268834219663e-85, 3.0646827875418985414e-85, -5.02159081511853924877e-86, -2.80939372497451848277e-86, 4.71358952843344854702e-87, 2.51969003205764767943e-87, -4.32351580070298854534e-88, -2.21267117063423499755e-88, 3.8786222503217322306e-89, 1.90384904147899304543e-89, -3.40587925867837984027e-90, -1.60615944624632708356e-90, 2.92972424214889821229e-91, 1.32942879985848411684e-91, -2.47049857340782004769e-92, -1.08025849212817112667e-92, 2.04361670471229982338e-93, 8.62242514047409684011e-94},
            {-9.73896763643864686591e-66, -2.30462629667096879853e-65, 4.83088890496603076293e-64, -6.89341385265297445481e-65, -5.31349373576677196176e-63, 3.14011411371103243378e-63, 2.60460131662020104775e-62, -1.98471831981153199763e-62, -7.37334113001540426397e-62, 6.32800284424256872228e-62, 1.38111119893920668649e-61, -1.28429300975946451103e-61, -1.86149665536379249255e-61, 1.85201198371535728057e-61, 1.91074455102301822031e-61, -2.02834648671817617891e-61, -1.55573386103103187277e-61, 1.76557407526124682442e-61, 1.03580036756717570241e-61, -1.26266392639886598832e-61, -5.77253649957412557848e-62, 7.60979922408343219434e-62, 2.7422403406341026785e-62, -3.94330079931613957774e-62, -1.12628891271751989839e-62, 1.78572835528846411418e-62, 4.04296846578712426325e-63, -7.16280798701823249902e-63, -1.27822607524594576155e-63, 2.57379017567672425403e-63, 3.57501504414157826289e-64, -8.36497247589504610909e-64, -8.84622905006779724929e-65, 2.47945207731166261003e-64, 1.92369098894854447437e-65, -6.7510969893422361606e-65, -3.60200822554705994998e-66, 1.69926684779262832258e-65, 5.48559461683202317466e-67, -3.97591883399698055787e-66, -5.477617536289224217e-68, 8.69065553848240618833e-67, -2.27484357325927786069e-69, -1.78249565386563930182e-67, 3.07639917106503245565e-69, 3.44422685545091065398e-68, -1.04809240000642428023e-69, -6.29217030827849077322e-69, 2.66530572657473729032e-70, 1.0903523329037263819e-69, -5.80382620025508836216e-71, -1.79752875265920437491e-70, 1.13586309805011621909e-71, 2.82683663857704622883e-71, -2.04570107994643974263e-72, -4.2512464305751517969e-72, 3.43766954463810671293e-73, 6.12787877528529446722e-73, -5.43928679400260250316e-74, -8.48383835918623525626e-74, 8.15643515515255075904e-75, 1.13032581427923312067e-74, -1.16489080365823382607e-75, -1.45185252943321966345e-75, 1.59074931044949196908e-76, 1.80082539558284168072e-76, -2.08378269615466999602e-77, -2.16034504073803539733e-77, 2.62555727923716437877e-78, 2.510172237981597153e-78, -3.18955211785865637432e-79, -2.82877104012739825638e-79, 3.74344368974168812648e-80, 3.09565931373982887757e-80, -4.25245775721649666353e-81, -3.29368717028478338014e-81, 4.68325426444634015195e-82, 3.41088098052681641531e-82, -5.00770349874330114833e-83, -3.44158178866038221615e-83, 5.20594504847409243279e-84, 3.38674617810385916749e-84, -5.26827906008922117267e-85, -3.25343007061376399429e-85, 5.19567584095577915342e-86, 3.05360779420601801981e-86, -4.99894490827811079691e-87, -2.80256574134621765621e-87, 4.69682164420232262665e-88, 2.51714161716956236902e-88, -4.31336951894344047331e-89, -2.21406000714920162884e-89, 3.87514295142910738152e-90, 1.9085563995440000684e-90, -3.4085177780088717904e-91, -1.61340348917111660896e-91, 2.9374969026579777132e-92, 1.33837392442008080903e-92, -2.48216928329840695167e-93, -1.09010687702394676196e-93, 2.0578709951944097111e-94},
            {7.69743595089408972736e-67, -1.44508713981826578828e-65, -7.44183887918735867773e-66, 2.98339790547628200623e-64, -1.24737965533605301756e-64, -2.14522628902299443965e-63, 1.46883188827332214137e-63, 8.01117417758542039811e-63, -6.48838705985174421173e-63, -1.86541124392952524742e-62, 1.66224409142323073882e-62, 3.00924644271717135692e-62, -2.88221127245280607843e-62, -3.60130312385425320787e-62, 3.68061069024570365719e-62, 3.35393641048234393822e-62, -3.65607400900089495141e-62, -2.51766420972843227916e-62, 2.93637241062632684612e-62, 1.5644805816637645706e-62, -1.9628479899922423855e-62, -8.21590073139583753881e-63, 1.11694795293954085313e-62, 3.70586632826555536709e-63, -5.50926972292589155981e-63, -1.45397846688959588123e-63, 2.39053503987239179616e-63, 5.00957404539886044731e-64, -9.23832505400242971859e-64, -1.52566533194747377845e-64, 3.21307137483662824338e-64, 4.1200989643783536444e-65, -1.0147461069951660322e-64, -9.85182247923855214454e-66, 2.9326633215823119319e-65, 2.06665185294311470462e-66, -7.80847576470189712657e-66, -3.70578505401922553353e-67, 1.9268536368347022464e-66, 5.27141296100702446279e-68, -4.42990482310844987774e-67, -4.26865267250896150962e-69, 9.53322153022644787142e-68, -5.83388929116365673523e-70, -1.92845511862442921003e-68, 3.90211020954191872926e-70, 3.68084406849773121338e-69, -1.21349884862830284806e-70, -6.65181221119611526396e-70, 2.96200180562468525786e-71, 1.14166174902969435605e-70, -6.28922526102027844067e-72, -1.86625387116989101092e-71, 1.20905012348737650388e-72, 2.9131692248262722632e-72, -2.1480081185469108272e-73, -4.35266820376796125748e-73, 3.57064012840932407179e-74, 6.23865583145639400672e-74, -5.59998567384314759207e-75, -8.59506994682811752369e-75, 8.33643118626744305125e-76, 1.14036083847619977281e-75, -1.18342108260331511298e-76, -1.45956077099918674815e-76, 1.60796865283082896513e-77, 1.80504641217479180978e-77, -2.09763579994147310715e-78, -2.1601904657307765539e-78, 2.63408430613717816328e-79, 2.50519042897277999055e-79, -3.19121867065274959114e-80, -2.81904717854820408951e-80, 3.73742263812934508518e-81, 3.08182911914202776147e-81, -4.23880223975044253519e-82, -3.27686109933059654568e-82, 4.66292496062183912367e-83, 3.39249459783975316713e-83, -4.98244559206314206623e-84, -3.42320214989364571067e-84, 5.17804223299683774982e-85, 3.36987048682295793443e-85, -5.24023538723154714265e-86, -3.23931087024284616917e-86, 5.16988622142867670353e-87, 3.04313007973126019509e-87, -4.97741088432055376323e-88, -2.79618862945159612513e-88, 4.6809535740420952977e-89, 2.514904018545182931e-89, -4.3038948195181825419e-90, -2.21563898244389511218e-90, 3.87211827663589710701e-91, 1.91336029113996974036e-91, -3.41142564990337759684e-92, -1.62067993942171251372e-92, 2.94539704754237754509e-93, 1.34731485604543249394e-93, -2.49387225836382956762e-94, -1.09993709455299109409e-94},
            {2.42291320375502407424e-67, 6.09257064566567808242e-67, -1.26741927691113382939e-65, 1.3187714884527319391e-66, 1.4663539369714531341e-64, -8.39382220209319762941e-65, -7.55097032616505653484e-64, 5.66467860824933676492e-64, 2.24320462195125451193e-63, -1.90398647481011448404e-63, -4.40533477275113940736e-63, 4.05615809502455994137e-63, 6.22031469627806656935e-63, -6.12517296554624038971e-63, -6.68430683728971621054e-63, 7.01322681392688737414e-63, 5.69441935292085779652e-63, -6.37362075949903590486e-63, -3.96522496669987845551e-63, 4.75355498473706359067e-63, 2.31061035631587090091e-63, -2.98464994434351492294e-63, -1.14767387565052257649e-63, 1.60977821989160779302e-63, 4.92978133684657956219e-64, -7.58110411430409837361e-64, -1.85198216876869570008e-64, 3.15979695158251432482e-64, 6.13581544174728749887e-65, -1.17889415891519797972e-64, -1.80255380455189563365e-65, 3.9753512458416560883e-65, 4.70459718915860046175e-66, -1.22172670528380287618e-65, -1.08746687963512521812e-66, 3.44676072226236960387e-66, 2.19921560768391129533e-67, -8.98337930287573712326e-67, -3.76496174464094606128e-68, 2.17515803667713035388e-67, 4.93861447445862454997e-69, -4.91727874861994457868e-68, -2.80730809245387002548e-70, 1.04249247245786866678e-68, -9.85288445914763937261e-71, -2.08099124794405617898e-69, 4.80156894116990241278e-71, 3.92539279449768177445e-70, -1.38941519039283625018e-71, -7.01990856610675384226e-71, 3.27200239518367917081e-72, 1.19373373574978192987e-71, -6.78939340182658905439e-73, -1.93549172187439391518e-72, 1.28362338458418728958e-73, 2.99960701883969849024e-73, -2.25130158850887744972e-74, -4.45369434701683674486e-74, 3.70388861915407186245e-75, 6.34856214638311489111e-75, -5.76004599807136536266e-76, -8.70513644924156976085e-76, 8.51486662912474891668e-77, 1.1502836455364191501e-76, -1.20172968614303598028e-77, -1.46720641766369092159e-77, 1.6249551769812663286e-78, 1.80930364975137491819e-78, -2.1113205670803077362e-79, -2.16021421198721208907e-79, 2.64259095202602558377e-80, 2.50055699727893324609e-80, -3.19308726176758031667e-81, -2.80984769136514720738e-81, 3.7318752922777214505e-82, 3.06868093781935211619e-82, -4.22590470499717725195e-83, -3.26083463519340450839e-83, 4.64361005356908760388e-84, 3.37497043701417604182e-84, -4.95839464786702008422e-85, -3.40568662623439629861e-85, 5.15145051008014272975e-86, 3.35380384540454772833e-86, -5.21350924493011550405e-87, -3.22590033431865335021e-87, 5.14532928998248660708e-88, 3.03323188047639520634e-88, -4.95695262026404631903e-89, -2.79025114954109954527e-89, 4.66595922751632875266e-90, 2.51297180651372537727e-90, -4.29507576629586647637e-91, -2.21740720638721420408e-91, 3.86954121495004320572e-92, 1.91826286928852689958e-92, -3.4146027097892513009e-93, -1.62799255884653742591e-93, 2.95342896750929652907e-94, 1.35625579275929699253e-94, -2.50561399626451791786e-95},
            {-1.94592567657464794851e-68, 3.693585652073463119e-67, 2.14945920904546265049e-67, -8.02274408956052378109e-66, 3.14688924860613450579e-66, 6.06017645628538668076e-65, -4.06173961838707255703e-65, -2.37473954882304575172e-64, 1.89887780415686186618e-64, 5.79673151933500672049e-64, -5.11300235811394222495e-64, -9.79466515200685329736e-64, 9.28945411534778550392e-64, 1.22686552437116812354e-63, -1.24058458023684378186e-63, -1.19516552719886944279e-63, 1.28686057804479582777e-63, 9.37973290203170969912e-64, -1.07798842197344584904e-63, -6.09154819791493323113e-64, 7.50788907432882714194e-64, 3.34271598539552114336e-64, -4.44711218034228554156e-64, -1.57558736900703543982e-64, 2.2812405710260656694e-64, 6.46216085982334541447e-65, -1.02860139386088129648e-64, -2.3294049190799118031e-65, 4.12746841108167554841e-65, 7.4334715024598934171e-66, -1.48946539772147392642e-65, -2.10910985652014688633e-66, 4.87734121774843870327e-66, 5.32419502667513417517e-67, -1.46053951131462139984e-66, -1.18985645797482828482e-67, 4.02684157731994432153e-67, 2.31740906740160127857e-68, -1.02831718810535057338e-67, -3.77182957792817130825e-69, 2.44509640835268847475e-68, 4.47476033269874821467e-70, -5.4389755743649152683e-69, -1.07677368871933984473e-71, 1.13664338458658569612e-69, -1.43503141524760225042e-71, -2.24010868920824235359e-70, 5.77624977688340943885e-72, 4.17778523527637669377e-71, -1.5758788795143633704e-72, -7.39627160366732261417e-72, 3.59516815849358258495e-73, 1.2465426085843543786e-72, -7.30398836795836654795e-74, -2.00521720661528246841e-73, 1.3595330929534414614e-74, 3.08613627023482893264e-74, -2.35552955853478091116e-75, -4.55433353043705654709e-75, 3.83738111816612975407e-76, 6.45763608298796770176e-76, -5.91947338705734327913e-77, -8.81410545227559373587e-77, 8.69180176433406902551e-78, 1.16010287070691240814e-77, -1.21982825348067825005e-78, -1.4747979941210299668e-78, 1.6417244896443986087e-79, 1.81360295336543162834e-79, -2.12485323416388177633e-80, -2.1604168719277128819e-80, 2.65108968898427300861e-81, 2.49626533879186834778e-81, -3.19516216550362524732e-82, -2.80115796615127418803e-82, 3.72679435743833740941e-83, 3.05619269917317196898e-83, -4.21374483861858035045e-84, -3.2455800617288007517e-84, 4.6252770547428926534e-85, 3.35827782539077323794e-85, -4.93550895316442549634e-86, -3.3890046003186763512e-86, 5.12612332586735884145e-87, 3.33851845640673887268e-87, -5.18805411938734700049e-88, -3.21317555196688305763e-88, 5.12196300766971400185e-89, 3.02389629374015888487e-89, -4.93753581357375838938e-90, -2.78474256019711988206e-90, 4.6518137478292979878e-91, 2.51133974835380279568e-91, -4.28689709607770132623e-92, -2.21936377292033338951e-92, 3.86740497235877222444e-93, 1.9232661508661015978e-93, -3.41804869840209890417e-94, -1.63534493213931113734e-94, 2.96159669359263334268e-95, 1.36520077044421155403e-95},
            {-6.03020853701953667713e-69, -1.60688006087247517067e-68, 3.32203595801947041507e-67, -2.15142661612506932302e-68, -4.03786747864813631012e-66, 2.23524193203598217775e-66, 2.18174528398112918968e-65, -1.61069375002481830804e-65, -6.79383369376949580552e-65, 5.70261395334569393342e-65, 1.39728519575989505254e-64, -1.27405280812467051873e-64, -2.06462717701846838222e-64, 2.01290534627987135814e-64, 2.32015595821084175231e-64, -2.40736801462079185674e-64, -2.06584496397798326737e-64, 2.2822667921013520532e-64, 1.5028411947326436034e-64, -1.77367287293001155478e-64, -9.14623381487600438748e-65, 1.15929871088860906253e-64, 4.74414559725217593033e-65, -6.50315587624722303817e-65, -2.12838852051299629912e-65, 3.18261372353214731143e-65, 8.35510008754817518258e-66, -1.37741085338267346477e-65, -2.89537468669731641462e-66, 5.33224459402494898739e-66, 8.91264032943101955725e-67, -1.86438535600591094621e-66, -2.44495703612285249796e-67, 5.93700196137819113918e-67, 5.97321396134329532039e-68, -1.73443396300273542865e-67, -1.29049263201946344436e-68, 4.67812487572475643208e-68, 2.41693767779373926787e-69, -1.17152262603106579935e-68, -3.71837191228561981349e-70, 2.73756513819640075212e-69, 3.8673011604005549848e-71, -5.99588448389940908133e-70, 9.39452889953210593575e-73, 1.23583521780277645889e-70, -1.93437970165827330468e-72, -2.40580571140506608198e-71, 6.8274934083449269832e-73, 4.43793075262872436442e-72, -1.77291340389794270772e-73, -7.78071770922940206793e-73, 3.93135205414041300879e-74, 1.30006397404176165821e-73, -7.83267371457720552901e-75, -2.07540723407430269699e-74, 1.43673179461176184724e-75, 3.17274539585219913985e-75, -2.46064392643876975933e-76, -4.65459591273180713627e-76, 3.9710880080243918693e-77, 6.56591597140844665196e-77, -6.07827658419915202798e-78, -8.9220425007301246021e-78, 8.8672971945802234102e-79, 1.16982676103714760535e-78, -1.23772807618184152948e-79, -1.48234354527000678317e-79, 1.65829148983218751876e-80, 1.8179497492234896579e-80, -2.13824912711471261082e-81, -2.16079885442234545853e-81, 2.65959214026714666754e-82, 2.49230904882652005253e-82, -3.19744717220079801836e-83, -2.79296405137668492349e-83, 3.72217267539085137076e-84, 3.04434344145107083171e-84, -4.20230321861792945912e-85, -3.23107111717397743236e-85, 4.60789510181627798318e-86, 3.34238772539835284052e-86, -4.91374898424731884258e-87, -3.3731270834309075698e-87, 5.10201660660950636707e-88, 3.32398797623416551814e-88, -5.16382596276368823869e-89, -3.20111477285114269077e-89, 5.09974751781032094565e-90, 3.015107230135465364e-90, -4.9191278757569223478e-91, -2.77965259456982893186e-91, 4.63849344596619124521e-92, 2.51000280296129715031e-92, -4.27934418925202015292e-93, -2.22150776630596585772e-93, 3.86570296976722094712e-94, 1.92837202795854128322e-94, -3.42176327593099079545e-95, -1.64274047837368963177e-95, 2.96990401741068498826e-96},
            {4.91786482934127652863e-70, -9.43791498421625392651e-69, -6.13370000718378444138e-69, 2.15412849984680802253e-67, -7.88277227434184593483e-68, -1.70734909967816070203e-66, 1.11926693569887222413e-66, 7.0124028757117013762e-66, -5.53468816376230837307e-66, -1.79243452976335428642e-65, 1.5650349043904580799e-65, 3.16886817367617774327e-65, -2.9767158131327442192e-65, -4.15006785397614066586e-65, 4.15371953729080543084e-65, 4.2243802009360036764e-65, -4.49557088472039732827e-65, -3.46244259373565127162e-65, 3.9246327290480659229e-65, 2.34753444007705429372e-65, -2.84569884963195107873e-65, -1.34455068723047029082e-65, 1.75320881578727084414e-65, 6.61453684648666577197e-66, -9.34633079434585510546e-66, -2.83213158157416241786e-66, 4.37609029477497516592e-66, 1.06639858973919904496e-66, -1.82207658922726882914e-66, -3.55881837650817572571e-67, 6.81786618152653061559e-67, 1.05812492427259762722e-67, -2.31335621926864720702e-67, -2.80904844017434633164e-68, 7.17353335268431505617e-68, 6.64453609352474744586e-69, -2.04680095156197770466e-68, -1.38727774744164580926e-69, 5.40593585378426362644e-69, 2.49319863315087881926e-70, -1.32869035721784200389e-69, -3.59629646651118143113e-71, 3.05343911664327433887e-70, 3.10362264799378034026e-72, -6.58884922665890220082e-71, 3.25752787531092308875e-73, 1.34012208919791643819e-71, -2.48500849205136317256e-73, -2.57807482811182080986e-72, 7.95651314026025113666e-74, 4.70573659112466832856e-73, -1.98052955584849725045e-74, -8.17306789764472993875e-74, 4.28040085454142263504e-75, 1.35427471535830796169e-74, -8.37511985137594916841e-76, -2.14604062500444587298e-75, 1.51517435058364711903e-76, 3.25942482098124686446e-76, -2.56660023684182037505e-77, -4.75449297323263310341e-77, 4.10498363943084343915e-78, 6.67344000871090392444e-78, -6.23646711958187283681e-79, -9.0290111332784713635e-79, 9.04141363508014996876e-80, 1.17946319484468592337e-79, -1.25544010303587466974e-80, -1.48985066774646855697e-80, 1.67467040448798628086e-81, 1.82234907832684811922e-81, -2.1515227208781138137e-82, -2.161360407247261596e-82, 2.66810914635409241154e-83, 2.4886819209013617901e-83, -3.19994563722414678256e-84, -2.78525262381829461778e-84, 3.71800323465894222065e-85, 3.03311324729602008076e-85, -4.19156127370125085928e-86, -3.21728290462321831385e-86, 4.5914348646087139374e-87, 3.32727263192104824871e-87, -4.89307727185827853314e-88, -3.35802661353920570861e-88, 5.07908860310431539128e-89, 3.31018742599082523435e-89, -5.14078303943936341014e-90, -3.18969733888069839132e-90, 5.07864501344685044975e-91, 3.00684936907873247353e-91, -4.90169783329531328929e-92, -2.77497143792264738949e-92, 4.62597573895673924082e-93, 2.50895611553657131617e-93, -4.2724030418488473711e-94, -2.22383826669144656026e-94, 3.86442884048255741124e-95, 1.93358227832578108451e-95, -3.42574603478880066577e-96, -1.65018246177979708708e-96},
            {1.50137446475919448224e-70, 4.22908124467990176638e-70, -8.6996150000641917493e-69, 2.1609666634200606281e-70, 1.10960015272530257282e-67, -5.929672023621872458e-68, -6.28371038890721377224e-67, 4.56322111170693323345e-67, 2.04878856663033239042e-66, -1.70051914671624857117e-66, -4.40823882020148719547e-66, 3.9809429033302489425e-66, 6.80912780984192496858e-66, -6.57476962860598494701e-66, -7.99374594655923018053e-66, 8.20642411414676975474e-66, 7.4314018394419027886e-66, -8.1092314128534485601e-66, -5.64196256017283179237e-66, 6.56175738504374852126e-66, 3.58231427526793761826e-66, -4.46128331489355082166e-66, -1.93826406242166169116e-66, 2.60092360453151194774e-66, 9.07106476964369911808e-67, -1.32182821004404706587e-66, -3.71580063947313062547e-67, 5.93625718319141494139e-67, 1.34466801102127113099e-67, -2.38290048727416382932e-67, -4.32821201742664711265e-68, 8.63340487567143479073e-68, 1.244455083534067143e-68, -2.84696199802800726748e-68, -3.19959425833363416405e-69, 8.60735758369798013648e-69, 7.32953932249158437006e-70, -2.40116478801933657739e-69, -1.47787525669890096711e-70, 6.21569081330025350124e-70, 2.54129544929741317442e-71, -1.50055347497012744943e-70, -3.39706731649307715804e-72, 3.39357048583451049074e-71, 2.17108789356730223491e-73, -7.21866873327766368784e-72, 5.8932290084892713359e-74, 1.4495522453107511693e-72, -3.08850687391213139308e-74, -2.75690339305301378199e-73, 9.16440142568748490544e-75, 4.98110853714950922226e-74, -2.19872664615796477129e-75, -8.57314821063183352058e-75, 4.64215653006961620008e-76, 1.40915297322541312484e-75, -8.93100492467866493587e-77, -2.21709801918018298056e-76, 1.59481790705990119323e-77, 3.34616683045832136613e-77, -2.6733575023513324142e-78, -4.85403735921288227488e-78, 4.23904603806356675976e-79, 6.78024617279159685758e-79, -6.39405900433878633487e-80, -9.13507292288528096505e-80, 9.21421173240935128542e-81, 1.18901970035795264792e-80, -1.27297494603819386264e-81, -1.49732653931312287553e-81, 1.69087482259826387912e-82, 1.82680562733329950641e-82, -2.16468769499546303296e-83, -2.16210163724280440155e-83, 2.67665082556604355887e-84, 2.48537794486741245862e-84, -3.20266052521148470401e-85, -2.77801095776625873485e-85, 3.71427917872431035044e-86, 3.02248318370409606808e-86, -4.18150124372873033941e-87, -3.20419180901191707261e-87, 4.57586845742562306359e-88, 3.31290647727404451817e-88, -4.87345827617619729381e-89, -3.34367716087137186539e-89, 5.05729974666172949157e-90, 3.29709310879579234532e-90, -5.11888578359296712353e-91, -3.1789036206763797123e-91, 5.05861961430636215636e-92, 2.99910811716316051513e-92, -4.88521623533940289227e-93, -2.77068970640996814102e-93, 4.6142390919728928333e-94, 2.50819501231469571673e-94, -4.26606023893283905044e-95, -2.22635435505574217446e-95, 3.86357642732167764273e-96, 1.9388985750505907594e-96, -3.42999651113960535772e-97},
            {-1.24254308346243007123e-71, 2.4109312127845250814e-70, 1.73302652312991983201e-70, -5.77550340861931127293e-69, 1.95899222839158609418e-69, 4.79778808676156650956e-68, -3.07378410445158845716e-68, -2.06314016548845582357e-67, 1.60692501167486239795e-67, 5.51642156710117896495e-67, -4.76793451003806184266e-67, -1.0193571160993794684e-66, 9.48585891915120441975e-67, 1.39438221764100490685e-66, -1.3819041778550385481e-66, -1.48159844022116429813e-66, 1.55925063052466162263e-66, 1.26698088387326136504e-66, -1.41749339022873827578e-66, -8.95873871027222074497e-67, 1.0692233918963812612e-66, 5.34988816770068119466e-67, -6.84669097555789501478e-67, -2.74383027979644331854e-67, 3.79050614103956641133e-67, 1.22493905598206309538e-67, -1.84169121288878971926e-67, -4.81114611201091755526e-68, 7.95163909766684086344e-68, 1.67625133681479696412e-68, -3.08318360786485343513e-68, -5.21130799758766172921e-69, 1.08335271892977385958e-68, 1.45046115971708094256e-69, -3.47668251453094285552e-69, -3.61399326435404436787e-70, 1.02600959842845550783e-69, 8.01804343374240937158e-71, -2.80117476991669003946e-70, -1.55971170547168796994e-71, 7.11288232813200460929e-71, 2.55605370601918867095e-72, -1.68784035317244389702e-71, -3.11193629536441142912e-73, 3.75878763925137320879e-72, 1.057076394023219575e-74, -7.88609796406334489568e-73, 8.86192877639865564625e-75, 1.56416840702066114995e-73, -3.74637894471081470721e-75, -2.9422741668471674862e-74, 1.04521365189463622165e-75, 5.26395151748172388888e-75, -2.42749365880544259099e-76, -8.98079004444615051424e-76, 5.01645750632599807793e-77, 1.46467812237920047348e-76, -9.50001555368955107938e-78, -2.28856178451427146367e-77, 1.67562185692746024942e-78, 3.4329654292436982435e-78, -2.78087802908564408705e-79, -4.95324274723288593618e-79, 4.37325663054846740119e-80, 6.88637214887496377403e-80, -6.55106845313175228413e-81, -9.24028752159533566612e-81, 9.38575190849602547044e-82, 1.19850347354268835807e-81, -1.29034288727383242124e-82, -1.50477794625510469632e-82, 1.70691772777155147037e-83, 1.83132375688396861128e-83, -2.17775698535287703357e-84, -2.16302252841196250261e-84, 2.68522662973216414843e-85, 2.48239130449970410543e-85, -3.20559445006378589976e-86, -2.77122689592657804602e-86, 3.71099381250803268655e-87, 3.01243524604887099318e-87, -4.17210614216226694636e-88, -3.19177542006873590402e-88, 4.56116935731341467146e-89, 3.29926454314311167434e-89, -4.85485827080239913893e-90, -3.33005404039412733121e-90, 5.03661251561952065727e-91, 3.28468253302632650022e-91, -5.09809666714517063894e-92, -3.16871495841614058337e-92, 5.03963725249090882104e-93, 2.99186956920392792616e-93, -4.86965506763897313751e-94, -2.766798427014364331e-94, 4.6032629639934540809e-95, 2.50771499535827589718e-95, -4.26030292927423918725e-96, -2.22905511760324295685e-96, 3.86313977941040194198e-97, 1.94432249543889312614e-97},
            {-3.73939277167760227417e-72, -1.11089294959487128974e-71, 2.27628581728409657636e-70, 3.57438064417994178527e-72, -3.04316407587694722721e-69, 1.56696279171156897779e-69, 1.80428474310934059647e-68, -1.28826542162884959279e-68, -6.15323570191396221647e-68, 5.04969459686174064353e-68, 1.38365761580664229442e-67, -1.23767777854104912305e-67, -2.23199378876977912258e-67, 2.13502833940329932867e-67, 2.73469510742680517376e-67, -2.77895375044714645634e-67, -2.6518232187080910228e-67, 2.86002193934898921856e-67, 2.09903740329685671805e-67, -2.40777084718694613862e-67, -1.38905710050540178569e-67, 1.70159444300241825446e-67, 7.83151957605583394613e-68, -1.03028537141402923952e-67, -3.81904348146887711793e-68, 5.43373094034646583247e-68, 1.63042328010993915077e-68, -2.53052028676542623621e-68, -6.15241596304640159848e-69, 1.05262920719041814027e-68, 2.06710927631541676609e-69, -3.94945682234425555548e-69, -6.21484241530053928828e-70, 1.34787343861363354555e-69, 1.67597993567366324907e-70, -4.21490266775919482962e-70, -4.04876889675479921432e-71, 1.21545401568947972235e-70, 8.69826706343097110428e-72, -3.25059645947897325624e-71, -1.62998015656610487399e-72, 8.10306494617244850119e-72, 2.53203768974196162856e-73, -1.89127310457175663208e-72, -2.73197353487134716427e-74, 4.14989445578528964641e-73, -2.5098033548543407699e-76, -8.59184895701228311779e-74, 1.21785728555567390668e-75, 1.68400811524740892496e-74, -4.46004537679757781965e-76, -3.13416585409463853074e-75, 1.18205891729520265833e-76, 5.55417014083363805795e-76, -2.66681034464487665372e-77, -9.39583041505022096795e-77, 5.40313980222031937379e-78, 1.52083074482250660991e-77, -1.00818474362992291928e-78, -2.3604159286912966129e-78, 1.75754779426073745966e-79, 3.51981621206147649049e-79, -2.88912724720756864561e-80, -5.05212371736195240609e-80, 4.50759998862498402562e-81, 6.99185526718544418936e-81, -6.70751363236318281965e-82, -9.34471270872966958535e-82, 9.55609422692562039791e-83, 1.20792139512455101661e-82, -1.30755388651424923561e-83, -1.5122113089201195717e-83, 1.72281152931332588338e-84, 1.83590752761702780062e-84, -2.19074283237980461491e-85, -2.16412295817189995819e-85, 2.69384539534217486993e-86, 2.47971637464912544678e-86, -3.20874971110731984462e-87, -2.76488882192415404425e-87, 3.70814060735405767715e-88, 3.00295230586011201987e-88, -4.1633597204164610981e-89, -3.18001246074586736174e-89, 4.5473123277770043715e-90, 3.28632337890458133944e-90, -4.83724523500644102929e-91, -3.31713383061867359701e-91, 5.01699131152555211205e-92, 3.27293434100272542912e-92, -5.07838007720566054141e-93, -3.1591136067155695519e-93, 5.02166556618974978334e-94, 2.98512047176065553068e-94, -4.8549876722306141482e-95, -2.76328901857488821188e-95, 4.593027756789011446e-96, 2.50751173742895409505e-96, -4.25511880123903844646e-97, -2.23193964966072152836e-97, 3.86311314873320575962e-98},
            {3.13865455396960112919e-73, -6.15716811877974615249e-72, -4.85605514104189093249e-72, 1.54635060039467034329e-70, -4.82475381894662477752e-71, -1.34491305751647437846e-69, 8.41322021069202680377e-70, 6.04889292888360964955e-69, -4.64803753840052058967e-69, -1.69013297193641222456e-68, 1.44603882123852686633e-68, 3.26115999474788703511e-68, -3.00683894226255827948e-68, -4.65493540647025949204e-68, 4.56947375902994612736e-68, 5.15808893986940911327e-68, -5.37101778599245528099e-68, -4.59762848887360863471e-68, 5.08072212214378402639e-68, 3.3871803873603912251e-68, -3.9839537915089707723e-68, -2.10686488388878946649e-68, 2.64965377210897143226e-68, 1.12534372093633374663e-68, -1.52237025189161015712e-68, -5.23232361169308654177e-69, 7.67061847046358180081e-69, 2.14094858068948624336e-69, -3.43206537900481129278e-69, -7.77597535585190807733e-70, 1.37814331686404227236e-69, 2.52309298429801589024e-70, -5.01170482962019577455e-70, -7.34422585726563491595e-71, 1.66355769147015344424e-70, 1.92042754420113734443e-71, -5.07491710368035676776e-71, -4.49951044789443631904e-72, 1.43146180497708585788e-71, 9.35679534885277516144e-73, -3.75330277683716697312e-72, -1.68564490637723476903e-73, 9.19184147520733584372e-73, 2.46356768666182178932e-74, -2.11156619545452743204e-73, -2.24809693104232367509e-75, 4.56766975024967072638e-74, -1.76556648860474065434e-76, -9.33659204424576956648e-75, 1.58576633571994169685e-76, 1.80910407460795463806e-75, -5.23084536818859030967e-77, -3.33255361041010005065e-76, 1.3270529318852148412e-77, 5.85166918583302048925e-77, -2.91664825340221975206e-78, -9.81811216744202395507e-78, 5.80203805653489639009e-79, 1.57759260035430744065e-78, -1.06762058386059048333e-79, -2.4326460135845530651e-79, 1.84055946316154953419e-80, 3.60671624167283522779e-80, -2.99807354696540241548e-81, -5.15069563920525766512e-81, 4.64206359056981964556e-82, 7.09673245051888355701e-82, -6.86341443191679589409e-83, -9.44840444166543853678e-83, 9.72529827900700601988e-84, 1.21728004682494018088e-83, -1.32461758936684033815e-84, -1.5196327055327778798e-84, 1.73856809183335817501e-85, 1.84056072406953169716e-85, -2.20365682595261967676e-86, -2.16540271194835157289e-86, 2.7025153905792850326e-87, 2.47734771803877309589e-87, -3.21212832581059753311e-88, -2.75898563431531210072e-88, 3.70571320471966968741e-89, 2.99401806207113996355e-89, -4.15524643402220617628e-90, -3.16888272068252280597e-90, 4.53427334754544669771e-91, 3.27406072579729195863e-91, -4.82058875355935015025e-92, -3.304894298209815173e-92, 4.99840234418633188083e-93, 3.26182824267396663178e-93, -5.05970220224189194238e-94, -3.15008268322909831028e-94, 5.0046738007707098131e-95, 2.97884818895831478116e-95, -4.8411886724437982501e-96, -2.76015327384220847773e-96, 4.58351476699929477309e-97, 2.50758107695064118456e-97, -4.25049605984126782279e-98, -2.23500705912806703618e-98},
            {9.31669936900347998532e-74, 2.91296464973215655837e-73, -5.95117300301286439734e-72, -3.38339215306738448245e-73, 8.3304568618604216689e-71, -4.12456002188538993854e-71, -5.16573534758442971492e-70, 3.62463447483271180763e-70, 1.84083966979627612134e-69, -1.49347480364158648243e-69, -4.32192764352355629029e-69, 3.82950926349332505845e-69, 7.27391002953040936682e-69, -6.89444075693982337624e-69, -9.29255022165504037056e-69, 9.35072661304819660193e-69, 9.39036020938367925531e-69, -1.00154317345286265286e-68, -7.74227596584909329404e-69, 8.76607874922786187777e-69, 5.33485129301217326656e-69, -6.43491654738334062476e-69, -3.13110329343427293652e-69, 4.0437473824908789264e-69, 1.58933726920817055228e-69, -2.21173930051731290704e-69, -7.06347996922248874406e-70, 1.06744513453440499664e-69, 2.77578149153965348765e-70, -4.5985279772450094443e-70, -9.71981050395250204542e-71, 1.78570922659931201671e-70, 3.04978987610399532243e-71, -6.30358156556316283368e-71, -8.60322106431199484763e-72, 2.03768421354736173468e-71, 2.18274970221508844794e-72, -6.07093047038856924971e-72, -4.96081976046273320348e-73, 1.67653556035420987518e-72, 9.97855793473194849177e-74, -4.31326500348967419372e-73, -1.72344734641408963958e-74, 1.03848499238389374228e-73, 2.34473769745412955102e-75, -2.34942521359932289416e-74, -1.65110035904151073936e-76, 5.01286692227387864793e-75, -3.49905297799919570602e-77, -1.01209572082777165619e-75, 1.99132464688003294644e-77, 1.93948449262424329391e-76, -6.06003891570048778561e-78, -3.53740951937924301246e-77, 1.48026326757790539492e-78, 6.15635403892033094004e-78, -3.17697170408333529992e-79, -1.02474841352755693278e-78, 6.21298645055248529502e-80, 1.63494659499610732949e-79, -1.1282805981112734539e-80, -2.50523907265211611825e-80, 1.92462270215357812571e-81, 3.69366393534743284559e-81, -3.1076881206006958448e-82, -5.24897456874290726313e-82, 4.77663759894505882493e-83, 7.20104017057425116706e-83, -7.0187922583981616623e-84, -9.55141690849742132755e-84, 9.89342308732739193514e-85, 1.22658572683062671013e-84, -1.34154333584031711609e-85, -1.52704789440398691681e-85, 1.75419876342791067993e-86, 1.84528687665008287506e-86, -2.21650994724004953993e-87, -2.16686149628234323323e-87, 2.71124435859176811044e-88, 2.47528008177702942217e-88, -3.21573205939853468354e-89, -2.75350672202349595864e-89, 3.70370541875167854107e-90, 2.98561699547341311178e-90, -4.14775141051443235455e-91, -3.15836699429732808269e-91, 4.52202954400636167681e-92, 3.26245544646720014331e-92, -4.80485992354352423551e-93, -3.29331432792441149878e-93, 4.98081352485595147893e-94, 3.25134495390332520075e-94, -5.04203092626038965136e-95, -3.14160612068513724279e-95, 4.98863271666585404511e-96, 2.97304067044216699347e-96, -4.82823390282457578267e-97, -2.75738334250024664522e-97, 4.57470614109229439011e-98, 2.50791901307494787191e-98, -4.24642340490225050977e-99},
            {-7.92654595072259049915e-75, 1.57206570648915165712e-73, 1.35113899622536414079e-73, -4.13479670449196476e-72, 1.1759463948433548688e-72, 3.76123844482988448768e-71, -2.29523018963213011808e-71, -1.76757361733820643597e-70, 1.33960164382054925929e-70, 5.15611090340643511348e-70, -4.36669221410263053057e-70, -1.03788516339766008751e-69, 9.48273070143976694506e-70, 1.54446410470077477206e-69, -1.50214552346827161269e-69, -1.78313739895009985471e-69, 1.83793613919965256886e-69, 1.6551662119154977031e-69, -1.80779205230952239612e-69, -1.2693355521399415718e-69, 1.47256554568790675067e-69, 8.21615598991760883087e-70, -1.01652549037243698759e-69, -4.56592732955481213898e-70, 6.05731906591594094008e-70, 2.20870237779630555513e-70, -3.16305744256195560083e-70, -9.40429310441578189399e-71, 1.46572649662972372704e-70, 3.55596656314185807993e-71, -6.09161053999001621407e-71, -1.20229145541167543221e-71, 2.29137718044843781788e-71, 3.65235370623756753039e-72, -7.86261522392467455619e-72, -9.99361100647538075226e-73, 2.47817145764676360076e-72, 2.46137345838355868787e-73, -7.21805348157295535442e-73, -5.42626371642099966112e-74, 1.95328346037258537859e-73, 1.05468168898055035155e-74, -4.93454378235984906701e-74, -1.73991282277496941509e-75, 1.16877511527474106655e-74, 2.16943336638341810678e-76, -2.60554578502754968604e-75, -9.31680500145732396589e-78, 5.48621378573032990502e-76, -5.4636716346284010202e-78, -1.09455355520371011014e-76, 2.43589040943470938364e-78, 2.07517341247554525912e-77, -6.9488093528052332314e-79, -3.74870303972862584245e-78, 1.64174872473952578837e-79, 6.4681310855886213645e-79, -3.44773869452726971732e-80, -1.06838012564037331626e-79, 6.63581953415273799581e-81, 1.69287674782823969412e-80, -1.1901373333428927503e-81, -2.57818353144832252982e-81, 2.0097053851762184634e-82, 3.78065895909816573099e-82, -3.217944810365733984e-83, -5.34697715506351912114e-83, 4.91131465374990355995e-84, 7.30481441202744905325e-84, -7.17366984800883615288e-85, -9.65380258198434973664e-85, 1.00605270247698310241e-85, 1.23584446452038502949e-85, -1.35834016920962635614e-86, -1.53446233464799427105e-86, 1.7697144024834159959e-87, 1.85008928184829660963e-87, -2.22931260771018485637e-88, -2.16849895060066194173e-88, 2.72003955732790362023e-89, 2.47350839364928521063e-89, -3.21956245167016706713e-90, -2.74844194111642122953e-90, 3.70211123790437585943e-91, 2.97773432613886655486e-91, -4.14086041895829804135e-92, -3.14844702314177417131e-92, 4.51055913096163598119e-93, 3.25148745944946277177e-93, -4.79003126758377398658e-94, -3.28237385744846537897e-94, 4.96419436690628748324e-95, 3.24146613898925174381e-95, -5.02533573035610968834e-96, -3.13366862209318818299e-96, 4.97351450351867038237e-97, 2.96768642131545657971e-97, -4.816100343609781719e-98, -2.75497171509766368872e-98, 4.56658483301031344641e-99, 2.508521700857067553e-99},
            {-2.32202015343229728984e-75, -7.62604313425364913813e-75, 1.55469099137270205643e-73, 1.5328865947775187446e-74, -2.27632503197975749785e-72, 1.08129387227108811047e-72, 1.47487276793636024131e-71, -1.01646734512865029644e-71, -5.48669259941527524769e-71, 4.39995339423414244533e-71, 1.34371316430894735705e-70, -1.17944430381839104659e-70, -2.35738061949965399139e-70, 2.2144525952860753399e-70, 3.13733161459926997186e-70, -3.12722641217413125551e-70, -3.30092129696378991807e-70, 3.48342591168048683568e-70, 2.83235376505471214642e-70, -3.16758816866595170793e-70, -2.03032143349325551961e-70, 2.41362358118654791312e-70, 1.23933114741217832608e-70, -1.57313805610483647034e-70, -6.54175374478573133002e-71, 8.91768824082744636063e-71, 3.02342124750918503513e-71, -4.45758168423902606602e-71, -1.23588681431966045842e-71, 1.98757983760402327188e-71, 4.50416320430300373233e-72, -7.98360850948417038107e-72, -1.47245553790330538218e-72, 2.91341006312327563278e-72, 4.3353203875055530099e-73, -9.73040133001066298736e-73, -1.15148608723554126287e-73, 2.99359083598934237342e-73, 2.75416089412649582319e-74, -8.532295046938289373e-74, -5.88833269724193859096e-75, 2.26441473592047923537e-74, 1.10431639957133012186e-75, -5.62128019180805045654e-75, -1.73135834931887185338e-76, 1.31062172771067932972e-75, 1.93134993951368851146e-77, -2.88061263398963477195e-76, -8.04621780318491561052e-80, 5.98841256127661170736e-77, -7.67149247766669929975e-79, -1.18108808590234764544e-77, 2.92077491075605485129e-79, 2.2161910376468716338e-78, -7.89826610027280602694e-80, -3.96640142324874804773e-79, 1.81155996697771207338e-80, 6.78690805831081389352e-80, -3.72890175134673993325e-81, -1.11269246494927353666e-80, 7.0703729625428192879e-82, 1.7513681566805730747e-81, -1.25316438282351537414e-82, -2.65146913133689366567e-82, 2.09577736007972960647e-83, 3.86770212924975599614e-83, -3.32881996279692892074e-84, -5.44472055614547795853e-84, 5.04608968007619542804e-85, 7.40809064343769231231e-85, -7.32807109733973758525e-86, -9.75561227427453554492e-86, 1.02266677471876447314e-86, 1.24506203447369944341e-86, -1.37501684508181712473e-87, -1.54188120551187860476e-87, 1.78512540315120947913e-88, 1.85497102083189936679e-88, -2.24207468550285175738e-89, -2.17031465778548709259e-89, 2.72890779622898294199e-90, 2.4720277582413156111e-90, -3.22362084129422808045e-91, -2.743781592847427116e-91, 3.70092482573549607547e-92, 2.97035597359047866806e-92, -4.13455984103112901229e-93, -3.13910544217969863423e-93, 4.49984135038575284821e-94, 3.24113767819240756193e-94, -4.77607665299370338953e-95, -3.27205381674127012274e-95, 4.94851589337932351386e-96, 3.23217435708929172882e-96, -5.00958760104360423268e-97, -3.12625561888342899242e-97, 4.95929270010685375226e-98, 2.96277447392056407113e-98, -4.80476605941533517558e-99, -2.75291120783602437683e-99, 4.5591345643226640039e-100},
            {2.00144096213446121323e-76, -4.01291041686908622954e-75, -3.7366307308625285427e-75, 1.10421763770536058895e-73, -2.83096074628319877122e-74, -1.0495346960591547025e-72, 6.24145791003031352513e-73, 5.14870579361216376793e-72, -3.84742177791571229751e-72, -1.56655001054307929829e-71, 1.31317474170776621759e-71, 3.2866883473984036372e-71, -2.97602039312559053248e-71, -5.0943965896907422946e-71, 4.91041964697080097869e-71, 6.12287060421583544247e-71, -6.24961681023548550534e-71, -5.91355810339375678495e-71, 6.38731130662317255986e-71, 4.71668872873332887877e-71, -5.40118066456087776244e-71, -3.17423746443708690607e-71, 3.8673905525096358141e-71, 1.83363913759851899486e-71, -2.3885681092533047344e-71, -9.21934183693450003821e-72, 1.29186277582795982993e-71, 4.08044846551833662974e-72, -6.19622729510369885987e-72, -1.60437136837329262966e-72, 2.66378844805706125555e-72, 5.64441396346778906303e-73, -1.03585373266231961439e-72, -1.78634271123916422707e-73, 3.67244685754782498136e-73, 5.10241120900371896771e-74, -1.19527825406024420528e-73, -1.31637773922327127338e-74, 3.5931771816873302962e-74, 3.05836515972548887677e-75, -1.00305507552542809146e-74, -6.33840509721231629759e-76, 2.61273488060705218515e-75, 1.14475267988787105425e-76, -6.37768696198796708255e-76, -1.69390103512800926183e-77, 1.4645920847992346945e-76, 1.62401008830347133278e-78, -3.17529877978267635811e-77, 9.119778679620718945e-80, 6.52014001519729420988e-78, -1.01344039180590733926e-79, -1.27175112223399977676e-78, 3.44724238475855486408e-80, 2.36255404714344369594e-79, -8.90944758308999063053e-81, -4.19047010421093958093e-80, 1.9897401382118646867e-81, 7.11259434439054112804e-81, -4.02040872189659350924e-82, -1.15767216564030059501e-81, 7.51648415050318095894e-83, 1.81040696306111775255e-82, -1.31733640042759313579e-83, -2.72508685645028293639e-83, 2.18281038539708259849e-84, 3.95479532092061993292e-84, -3.44029228931038483727e-85, -5.54222236290548795616e-85, 5.18095970939486622665e-86, 7.51090379417448685267e-86, -7.48202091051063827276e-87, -9.85689519198429889126e-87, 1.03919021381270973694e-87, 1.25424396978788457477e-87, -1.39158184057957653683e-88, -1.54930942441495698055e-88, 1.80044171954475771769e-89, 1.85993497656861261379e-89, -2.2548055593562403559e-90, -2.17230815366436414089e-90, 2.73785547004800055966e-91, 2.47083345293960948785e-91, -3.22790838782843672128e-92, -2.73951640288806297564e-92, 3.70014052099914012777e-93, 2.96346851951965576575e-93, -4.12883664358058056663e-94, -3.13032572968735998146e-94, 4.48985641789434392228e-95, 3.23138795426343010516e-95, -4.76297121637641265029e-96, -3.26233607153021850277e-96, 4.93375055087638513793e-97, 3.22345301224411842523e-97, -4.99475894483613995534e-98, -3.1193532317595809453e-98, 4.94594211959712247137e-99, 2.95829436133526409933e-99, -4.7942101418300760986e-100, -2.75119494816473722612e-100},
            {5.78904760264104081216e-77, 1.99352171830847125656e-76, -4.05851221651566258384e-75, -5.71949276616085088235e-76, 6.20949995862547771214e-74, -2.8229204396074721956e-74, -4.19977133523229098596e-73, 2.84141167737920433428e-73, 1.62951631220716754823e-72, -1.29145492267918828279e-72, -4.15914859358180769308e-72, 3.61651312177668972732e-72, 7.59948384880841588729e-72, -7.07618438485734349902e-72, -1.05270942346635214086e-71, 1.03975143788094367111e-71, 1.15224323327661667965e-71, -1.20364494431872282114e-71, -1.02805488376878295576e-71, 1.13635702820430299114e-71, 7.6599775324598794867e-72, -8.98206507051627538001e-72, -4.85868711724512791733e-72, 6.0681505348955016863e-72, 2.66452125341944931534e-72, -3.56297745714344826538e-72, -1.27939392590595389321e-72, 1.84348669912687495685e-72, 5.43418806617561019507e-73, -8.50296110148847200826e-73, -2.05875026047416849398e-73, 3.5309252716798548377e-73, 7.00184081114700272356e-74, -1.33132865067751943848e-73, -2.1476689080769362014e-74, 4.5916629092200245861e-74, 5.95632524646695758118e-75, -1.4580014079317154633e-74, -1.49341687708033093787e-75, 4.28683646444399404173e-75, 3.37058916815300504572e-76, -1.17305880152268674914e-75, -6.76671788436969685778e-77, 3.00114066089665716081e-76, 1.17381827640619441043e-77, -7.20803989316389676437e-77, -1.62346709326570077576e-78, 1.6312524829097120247e-77, 1.24078145579308047798e-79, -3.49026486336976020849e-78, 2.05508881811714278423e-80, 7.08204772846293919284e-79, -1.2864095745084740858e-80, -1.36659107236034795865e-79, 4.016510150458176441e-81, 2.51427590022271667913e-80, -9.9833242722526085445e-82, -4.42087306117542907637e-81, 2.17632545978195839196e-82, 7.44510125684484472449e-82, -4.32220351021744257606e-83, -1.20330658546038639532e-82, 7.97399285071308481418e-84, 1.86998031665182180566e-83, -1.38262910872132525899e-84, -2.79902886390536501194e-84, 2.27077806605617702679e-85, 4.04194138300928249784e-85, -3.55234273312032302356e-86, -5.63950053079623175431e-86, 5.31592371363182104721e-87, 7.61328823664070959188e-87, -7.63554506121360501673e-88, -9.95769899127108424239e-88, 1.05562862641655881337e-88, 1.26339557473073441663e-88, -1.40804336357238079591e-89, -1.55675166378870982353e-89, 1.81567288871183277334e-90, 1.86498384959759672138e-90, -2.2675141402628267403e-91, -2.1744789355290448402e-91, 2.74688859003722086807e-92, 2.46992092384728215271e-92, -3.23242609168302383756e-93, -2.73563750168307482129e-93, 3.69975283713953112063e-94, 2.95705917286550362973e-94, -4.1236783525827738904e-95, -3.12209216049536174455e-95, 4.48058547165442112394e-96, 3.22222102440892343092e-96, -4.75069129325890437853e-97, -3.25320337063155692828e-97, 4.91987212928763742906e-98, 3.21528630672518234421e-98, -4.98082350858614011963e-99, -3.11294823406427896204e-99, 4.93343877972675208288e-100, 2.95423609246572806365e-100, -4.78441265563189946898e-101},
            {-5.05276111234657467522e-78, 1.02412392232815380484e-76, 1.02793257374322719706e-76, -2.94533036310971709921e-75, 6.71357591726411144502e-76, 2.92236698243846947375e-74, -1.69183180518998658356e-74, -1.49519503763039832675e-73, 1.10129578247582995365e-73, 4.74093670353357349221e-73, -3.93332062182931798199e-73, -1.03584240715990697835e-72, 9.29611660805040960059e-73, 1.67097124003201259824e-72, -1.59655143480939669576e-72, -2.08894494264799980595e-72, 2.11219737370321815671e-72, 2.09749257126008720112e-72, -2.24158178062671980577e-72, -1.73853726545366898211e-72, 1.96647072985623757478e-72, 1.21543772485998660872e-72, -1.45958528339064929618e-72, -7.29200699356551394965e-73, 9.33775437685974737588e-73, 3.8073092506098128299e-73, -5.22778802685906489985e-73, -1.7499371294230368503e-73, 2.59386291060567832218e-73, 7.14685955783733675574e-74, -1.15285214576769000271e-73, -2.61304743341074605797e-74, 4.63207118157322980315e-74, 8.60226707966870562286e-75, -1.6958792632791176269e-74, -2.55988974390304020058e-75, 5.69692581820947482557e-75, 6.89852284913744819303e-76, -1.76669139503098120548e-75, -1.68165083140894219119e-76, 5.08515082571658535668e-76, 3.68674721057347603699e-77, -1.3651028172050346252e-76, -7.16234312674940642095e-78, 3.43261497997524173737e-77, 1.18917808335966177417e-78, -8.11666952715735097905e-78, -1.51580130541664334739e-79, 1.81116733749742470416e-78, 7.74893802572840341266e-81, -3.82615859633345534256e-79, 3.35832523833043360479e-81, 7.67476248075077555055e-80, -1.58720447359582962995e-81, -1.46565311448596249906e-80, 4.62974900623061548035e-82, 2.67136712984274974638e-81, -1.11208018148031355186e-82, -4.65757315220717144294e-82, 2.37134580588230288378e-83, 7.7843422712855123596e-83, -4.63422675912965829145e-84, -1.24958370434900373334e-83, 8.44274166238349287396e-85, 1.93007633965280299149e-84, -1.44901930163158749555e-85, -2.87328841725729864234e-85, 2.35965578859765547743e-86, 4.129144059290508465e-86, -3.66495434242773802969e-87, -5.73657331829292258427e-87, 5.45098245122616563623e-88, 7.71527777314570404132e-88, -7.78867006833938278987e-89, -1.00580698326022576052e-88, 1.07198753395897303949e-89, 1.27252193675618810855e-89, -1.42440936189661707364e-90, -1.56421236680140018332e-90, 1.8308280524343951196e-91, 1.87012017256402972286e-91, -2.28020890101674517708e-92, -2.17682646978045120114e-92, 2.756012812725752434e-93, 2.46928578164842934594e-93, -3.23717481222647734158e-94, -2.73213640586290715738e-94, 3.69975646127628677362e-95, 2.95111573708605172908e-95, -4.11907302842747864658e-96, -3.1143897623177953501e-96, 4.47201052448947051485e-97, 3.21362046116924993009e-97, -4.73921435237604840184e-98, -3.244639296800929259e-98, 4.90685568690896155683e-99, 3.20765919745335647868e-99, -4.96775630514291666456e-100, -3.10702801747286239259e-100, 4.92175983754111661902e-101, 2.95059012862704955456e-101},
            {-1.44371061875866197271e-78, -5.20415882375179796982e-78, 1.05873043403604346743e-76, 1.94622340269146163209e-77, -1.6910968658529928393e-75, 7.33781812613386151414e-76, 1.19287597466870037199e-74, -7.91814863398868545775e-75, -4.82310538854505383624e-74, 3.77703331653067627141e-74, 1.28189917484924718466e-73, -1.10421974788775701832e-73, -2.43741740193903555796e-73, 2.25001328805931406373e-73, 3.51151126950262122971e-73, -3.437604476266905675e-73, -3.99521871730509522385e-73, 4.13291454193825763717e-73, 3.70359556178644797132e-73, -4.04842061576025157327e-73, -2.86600801302285329728e-73, 3.31737812284633281461e-73, 1.88746854518069434308e-73, -2.32163630024561427762e-73, -1.07449070544345905881e-73, 1.41112992463875252677e-73, 5.3552090040746971158e-74, -7.55312984205568470091e-74, -2.36119353671701215568e-74, 3.60182925161869483237e-74, 9.28872433832667180976e-75, -1.54544604098437910232e-74, -3.28234422144977784763e-75, 6.01756756186642508498e-75, 1.04717638243157250015e-75, -2.14212230684926972509e-75, -3.02608362728047096434e-76, 7.01694588007829162777e-76, 7.92900213603029641074e-77, -2.12729973003575482711e-76, -1.87976046063143435264e-77, 5.99938102439671750146e-77, 4.00202970049107390573e-78, -1.58113259240435180024e-77, -7.51317033508702347688e-79, 3.9102216457306500433e-78, 1.18833696769374717867e-79, -9.10795311506553716992e-79, -1.36647682541377658543e-80, 2.00489834082720323128e-79, 2.1945564855821270284e-82, -4.1836143244207672867e-80, 4.83112817892926690745e-82, 8.29888673506228464715e-81, -1.91695027228026586546e-82, -1.56897936986240513255e-81, 5.28808384855460695407e-83, 2.83383562424154441717e-82, -1.23227242199145939187e-83, -4.90053242460320557925e-83, 2.57482525606601689397e-84, 8.13023323161539651823e-84, -4.95641648081475589071e-85, -1.29649212080965686932e-84, 8.92257647607647479738e-86, 1.9906840912137929424e-85, -1.51648484241655597984e-86, -2.94785982315040680075e-86, 2.44942065637700206399e-87, 4.21640791524171245923e-87, -3.77811214978376884336e-88, -5.83345923166244784572e-88, 5.58613832440006237717e-89, 7.81690562685254721632e-89, -7.94142308397758654972e-90, -1.01580524349716139592e-89, 1.08827236992779362403e-90, 1.2816279379105513918e-90, -1.44068753251586662163e-91, -1.57169576204556509853e-91, 1.84591597790870784892e-92, 1.87534632362025606793e-92, -2.2928979038028087234e-93, -2.1793501987869823134e-93, 2.76523346648833365363e-94, 2.46892379744878546706e-94, -3.24215528421139026993e-95, -2.72900500065260271332e-95, 3.7001462527603656018e-96, 2.94562657946515669641e-96, -4.11500924246073580027e-97, -3.10720427493577416255e-97, 4.46411441895238135153e-98, 3.2055706267758468248e-98, -4.72851893425293104969e-99, -3.23662822084333280319e-99, 4.89467748053282045859e-100, 3.2005573552575490443e-100, -4.9555335439221255105e-101, -3.10158055984666441279e-101, 4.91088352834786239489e-102},
            {1.27540996741265565046e-79, -2.61309166530909338266e-78, -2.81468797969679922917e-78, 7.84720594291511042657e-77, -1.5623548375472140532e-77, -8.12053603994507022819e-76, 4.57140754783341224313e-76, 4.32945466365143396519e-75, -3.14214610385804136678e-75, -1.42940138300491678625e-74, 1.17362202594801235783e-74, 3.24969525340350366405e-74, -2.89074130815333676685e-74, -5.45142207454447892504e-74, 5.16411675917873253411e-74, 7.08303646325874383052e-74, -7.09702429832295938127e-74, -7.38807538719020793444e-74, 7.81576076408154474671e-74, 6.35870699766761859522e-74, -7.10876840239332267758e-74, -4.61444084456191466451e-74, 5.46620045561155029971e-74, 2.87289683995576739624e-74, -3.62023623808153602348e-74, -1.55635253316259789187e-74, 2.09682625139938594293e-74, 7.42192210202748998844e-75, -1.07564943469585077721e-74, -3.14539483466834650573e-75, 4.93992456525646338353e-75, 1.1938144117052666135e-75, -2.04974996381073597111e-75, -4.08263744131698653098e-76, 7.74579910042809559211e-76, 1.26361204616659788576e-76, -2.6843162280815561023e-76, -3.54882561760152164656e-77, 8.58342010733274084712e-77, 9.04607044476519800641e-78, -2.54625945161908859756e-77, -2.08602808359164415264e-78, 7.04146640591544426472e-78, 4.31087119917838052396e-79, -1.82317463649440038857e-78, -7.80589441675491612193e-80, 4.43710008937912920472e-79, 1.16864319090264500635e-80, -1.01863069168613748279e-79, -1.17090521361480740899e-81, 2.21300369859503889204e-80, -4.32529675846544198471e-83, -4.56325269780020115887e-81, 6.48290789135795505487e-83, 8.95499920950213210618e-82, -2.2767486948702410496e-83, -1.67660907630209801303e-82, 5.99259448615927342452e-84, 3.00168689624909674149e-83, -1.35898770729027434937e-84, -5.14971240029537923937e-84, 2.78678262396132642817e-85, 8.48269252720053454962e-85, -5.28870863832767260702e-86, -1.34402104633646025736e-85, 9.41334686023756621952e-87, 2.05179353215412207669e-86, -1.5850046575832493616e-87, -3.02273837110645849511e-87, 2.54005142515369661632e-88, 4.30373827023659483969e-88, -3.89180305749823014681e-89, -5.93017697545881313868e-89, 5.721395246906969854e-90, 7.91820443628654455121e-90, -8.09383179268467629846e-91, -1.02576901293596358128e-90, 1.1044884778777305785e-91, 1.29071826565660581085e-91, -1.45688533058100886182e-92, -1.57920587726096374492e-92, 1.86094507735752755403e-93, 1.88066453878775659672e-93, -2.30558882596628482716e-94, -2.18204954703443285239e-94, 2.77455557608851918163e-95, 2.46883089861622737992e-95, -3.24736813268036617374e-96, -2.72623552321956504384e-96, 3.70091724136975839892e-97, 2.94058060231126516007e-97, -4.11147605471860360299e-98, -3.10052211202226732491e-98, 4.45688078515722877312e-99, 3.19805663008111717239e-99, -4.71858459376424968606e-100, -3.22915525873540122553e-100, 4.88331490013540129852e-101, 3.19396712676180311027e-101, -4.94413256601615470422e-102, -3.09659439509065606361e-102},
            {3.60147200651261570827e-80, 1.3568525145817088525e-79, -2.76002641517062526241e-78, -6.27319252444607331462e-79, 4.59833223874369408552e-77, -1.89868622914429680055e-77, -3.37994932369147278437e-76, 2.19986183129824014986e-76, 1.42290874496687748929e-75, -1.10082492402837600892e-75, -3.93488796103678570398e-75, 3.35771499567208081346e-75, 7.77964226833605748974e-75, -7.12043873745074274592e-75, -1.16472808313471873433e-74, 1.13040093339543446694e-74, 1.3764074738540014479e-74, -1.41054024083935176206e-74, -1.32467013508392954614e-74, 1.43270289043058443293e-74, 1.063824213991915201e-74, -1.21632715799871955112e-74, -7.26848145372249188232e-75, 8.81280076641665373583e-75, 4.29180374497796501343e-75, -5.54186913562742452223e-75, -2.21837923326909841573e-75, 3.06697691612162982649e-75, 1.01443024968910090371e-75, -1.5112680747480780803e-75, -4.13967828535397120921e-76, 6.69669818879459118672e-76, 1.51814437714565162809e-76, -2.69141880376409124432e-76, -5.03065221915577908971e-77, 9.88400239073099221923e-77, 1.51202405911134731167e-77, -3.33847928676186245907e-77, -4.13005293346919602546e-78, 1.04311689799597778372e-77, 1.0246112652015148906e-78, -3.03049528475063913147e-78, -2.29830655942876068442e-79, 8.22402252568258498147e-79, 4.60692182404941461487e-80, -2.09333399739737318902e-79, -8.02600898910119334124e-81, 5.01646007727582838748e-80, 1.12729235611671039319e-81, -1.13561788614918362707e-80, -9.24346603343082887302e-83, 2.43603744381687507992e-81, -1.1881486394232474748e-83, -4.96568044013175419153e-82, 8.32302813352038213212e-84, 9.64365552372953530317e-83, -2.66767725444728569294e-84, -1.7885787610699990099e-83, 6.74431662264019732622e-85, 3.17492434009500781216e-84, -1.49229907527866659633e-85, -5.40507433812954454747e-85, 3.00723196167885458786e-86, 8.84164124402136938031e-86, -5.63103768054391518829e-87, -1.39216029817931143201e-86, 9.9149063946162616622e-88, 2.11339549013963776883e-87, -1.65455872733041065668e-88, -3.0979202763761367298e-88, 2.63152843940375486341e-89, 4.39114113475992945319e-89, -4.00601572893719466833e-90, -6.02674540823489235758e-90, 5.85675852156290145102e-91, 8.01920625294831317827e-91, -8.24592432100858313834e-92, -1.03570249112714463895e-91, 1.12064111006763372682e-92, 1.29979742314252727615e-92, -1.4730099783570913528e-93, -1.58674655216035881592e-93, 1.87592342662519989161e-94, 1.88607692336586868567e-94, -2.31828898409225337385e-95, -2.18492392663780524422e-95, 2.78398388536316139944e-96, 2.46900316464092683591e-96, -3.25281388649592601492e-97, -2.72382054690604760134e-97, 3.70206462520516850173e-98, 2.93596721591557812401e-98, -4.10846299278893913149e-99, -3.09433032541302576033e-99, 4.45029400117739516418e-100, 3.19106428629306544424e-100, -4.70939184637643935103e-101, -3.22220623153399793365e-101, 4.87274640781458795236e-102, 3.18787549870711757035e-102, -4.93353178350612846605e-103}
        };

        const double ccli22logA0b[101][101] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
            {1., -0.25, 0.0277777777777777777778, 0, -0.000277777777777777777778, 0, 4.72411186696900982615e-6, 0, -9.18577307466196355085e-8, 0, 1.8978869988970999072e-9, 0, -4.06476164514422552681e-11, 0, 8.92169102045645255522e-13, 0, -1.99392958607210756872e-14, 0, 4.51898002961991819165e-16, 0, -1.03565176121812470145e-17, 0, 2.39521862102618674574e-19, 0, -5.58178587432500933628e-21, 0, 1.30915075541832128581e-22, 0, -3.08741980242674029324e-24, 0, 7.31597565270220342036e-26, 0, -1.74084565723400074099e-27, 0, 4.15763564461389971962e-29, 0, -9.96214848828462210319e-31, 0, 2.39403442489616530052e-32, 0, -5.76834735536739008429e-34, 0, 1.39317947964700797783e-35, 0, -3.37212196548508947047e-37, 0, 8.17820877756210262176e-39, 0, -1.98701083115238592556e-40, 0, 4.83577851804055089629e-42, 0, -1.17869372487183843267e-43, 0, 2.877096408117257145e-45, 0, -7.03205909815602801496e-47, 0, 1.72086031450331462909e-48, 0, -4.21607239056044549168e-50, 0, 1.03404064051330395739e-51, 0, -2.53866306259946531616e-53, 0, 6.23855317692459088784e-55, 0, -1.53443980691346503917e-56, 0, 3.777294635578550234e-58, 0, -9.30586212480468658839e-60, 0, 2.29434368222418732072e-61, 0, -5.66068873941414784857e-63, 0, 1.39756872198540085454e-64, 0, -3.45267347330633889778e-66, 0, 8.53498373696321710664e-68, 0, -2.11106753916379301954e-69, 0, 5.22446788920815644493e-71, 0, -1.29363445303169121491e-72, 0, 3.20479645174984764253e-74, 0, -7.94326694999713716406e-76, 0, 1.96969401238294242761e-77, 0, -4.88642119356886536649e-79, 0, 1.2127399993287380323e-80, 0, -3.01107647674682414162e-82},
            {-0.375, -0.0277777777777777777778, 0, 0.000555555555555555555556, 0, -0.0000141723356009070294785, 0, 3.67430922986478542034e-7, 0, -9.489434994485499536e-9, 0, 2.43885698708653531608e-10, 0, -6.24518371431951678865e-12, 0, 1.59514366885768605498e-13, 0, -4.06708202665792637249e-15, 0, 1.03565176121812470145e-16, 0, -2.63474048312880542031e-18, 0, 6.69814304919001120354e-20, 0, -1.70189598204381767156e-21, 0, 4.32238772339743641054e-23, 0, -1.09739634790533051305e-24, 0, 2.78535305157440118558e-26, 0, -7.06798059584362952335e-28, 0, 1.79318672789123197857e-29, 0, -4.54866540730271407099e-31, 0, 1.15366947107347801686e-32, 0, -2.92567690725871675344e-34, 0, 7.41866832406719683503e-36, 0, -1.88098801883928360301e-37, 0, 4.76882599476572622136e-39, 0, -1.20894462951013772407e-40, 0, 3.06460368466677992494e-42, 0, -7.76816030191659429151e-44, 0, 1.96897654748368784419e-45, 0, -4.99049491205961242436e-47, 0, 1.2648217171681336475e-48, 0, -3.20552598559124226791e-50, 0, 8.12372180031828901172e-52, 0, -2.05872254838511499299e-53, 0, 5.21709534350578113318e-55, 0, -1.3220531224524925819e-56, 0, 3.35011036492968717182e-58, 0, -8.48907162422949308665e-60, 0, 2.15106172097737618246e-61, 0, -5.45051801574306333269e-63, 0, 1.38106938932253555911e-64, 0, -3.49934333215491901372e-66, 0, 8.86648366448793068205e-68, 0, -2.24652119235950727132e-69, 0, 5.69199159333944134562e-71, 0, -1.44215840328743143914e-72, 0, 3.65390279699868309547e-74, 0, -9.25756185819982940975e-76, 0, 2.34548217291305537592e-77, 0, -5.94242599671081635829e-79, 0, 1.50553823837341207081e-80, 0},
            {0.0787037037037037037037, 0.00694444444444444444444, -0.00148148148148148148148, -0.000115740740740740740741, 0.0000566893424036281179138, 2.75573192239858906526e-6, -1.95963158926121889085e-6, -6.88932980599647266314e-8, 6.32628999632366635734e-8, 1.73972974898900824827e-9, -1.95108558966922825287e-9, -4.40349178223957765404e-11, 5.82883813336488233608e-11, 1.1152113775570565694e-12, -1.70148658011486512531e-12, -2.82473358026881905569e-14, 4.88049843198951164698e-14, 7.15505171356487047011e-16, -1.38086901495749960193e-15, -1.81239058213171822753e-17, 3.86428604192224794979e-17, 4.59083569030019126267e-19, -1.07170288787040179257e-18, -1.16287205715104361173e-20, 2.94995303554261729736e-20, 2.94558919969122289308e-22, -8.06845708367521463301e-22, -7.461264522531289042e-24, 2.19479269581066102611e-23, 1.88996037694806921693e-25, -5.94208651002538919591e-25, -4.78732555739350203772e-27, 1.60207560172455602529e-26, 1.21264372967905408489e-28, -4.30364814693895674858e-28, -3.07166245055442514848e-30, 1.15232856985002089798e-29, 7.78061188091253722669e-32, -3.07645192286260804496e-31, -1.9708520130838582788e-33, 8.19189534032440690963e-33, 4.99222646873511192055e-35, -2.17614270839304440494e-34, -1.26454573705690855143e-36, 5.76836325777380304922e-36, 3.20313177121182352686e-38, -1.52602431832503239083e-37, -8.11362756053890919606e-40, 4.02981543170045908024e-39, 2.05520587016723413092e-41, -1.06239594401781704065e-40, -5.20589728485061974429e-43, 2.79653770868997394494e-42, 1.31866918705374285813e-44, -7.35084577727243461831e-44, -3.34022807162411330711e-46, 1.92965803266305013742e-45, 8.46089654630796359303e-48, -5.05928686867253459002e-47, -2.14317013186822645827e-49, 1.32495074071104680407e-48, 5.4287133626948457763e-51, -3.466121301469136645e-50, -1.37510915890804371292e-52, 9.05837921289450596914e-52, 3.48319219044956324571e-54, -2.36508322238928744704e-53, -8.82302888975242397523e-56, 6.16958123811163204887e-55, 2.23489932605064222178e-57, -1.60805297516624984247e-56, -5.66106612592285100794e-59, 4.18794200128654992275e-58, 1.43396480139011707545e-60, -1.08987127196187059911e-59, -3.63227527445741153617e-62, 2.834269368186392933e-61, 9.2006607530705556257e-64, -7.36570340972018964861e-63, -2.330554594481778756e-65, 1.9129743549113557275e-64, 5.90336375139955849876e-67, -4.96523085211324118195e-66, -1.49533950690768672217e-68, 1.28800548361945083556e-67, 3.78773921967591342257e-70, -3.33930173475913892276e-69, -9.59445552665170984394e-72, 8.65295041972458863483e-71, 2.43030397591030112892e-73, -2.24106038215919229855e-72, -6.15603188624778130214e-75, 5.80140543113855976344e-74, 1.55934109313649608852e-76, -1.50110859066435544059e-75, -3.94985713146816617125e-78, 3.88238498451773335408e-77, 1.00051049944620887665e-79, -1.00369215891560804721e-78, -2.5343227012619103192e-81, 2.59373311734731151013e-80},
            {-0.00868055555555555555556, 0.000393518518518518518519, 0.000260416666666666666667, -0.0000718458679768203577727, -0.0000103339947089947089947, 4.08766901822457378013e-6, 3.61689814814814814815e-7, -1.81675232969424888617e-7, -1.17431758056758056758e-8, 7.11062205750002521133e-9, 3.63288072034765156458e-10, -2.57066843587640177881e-10, -1.08733109311813015517e-11, 8.79999167241851170906e-12, 3.17782527780242143765e-13, -2.89459190762482201346e-13, -9.12269093479520984939e-15, 9.23534912598629527491e-15, 2.58265657953769847424e-16, -2.8765244253827662969e-16, -7.2305662122228012387e-18, 8.78654650322200483347e-18, 2.00595429858555023023e-19, -2.64101239155698732668e-19, -5.52297974942104292452e-21, 7.83139311061074715205e-21, 1.51090606581258603101e-22, -2.29557111929598801026e-22, -4.11066381986205054681e-24, 6.66213427134172626563e-24, 1.11305319209398922377e-25, -1.91673428895601173794e-25, -3.0012932309556588601e-27, 5.47256305611344965712e-27, 8.06311393270536601477e-29, -1.55194668423690717947e-28, -2.15911979695322908041e-30, 4.374575973167438988e-30, 5.76474213827028546549e-32, -1.22641050514427647536e-31, -1.53510963913604691557e-33, 3.42140990991408221197e-33, 4.07816000200853007835e-35, -9.50255902413753591761e-35, -1.08105697278399044031e-36, 2.62853046613597958969e-36, 2.86005371508996549161e-38, -7.24388405918660190912e-38, -7.55288157286458543114e-40, 1.98951357255376756112e-39, 1.99125571145536205219e-41, -5.44696824413259452761e-41, -5.24171001853862786105e-43, 1.48695513477158563586e-42, 1.37784407954494673918e-44, -4.04825072147137029105e-44, -3.61703327354665443602e-46, 1.09937361379479190962e-45, 9.48352783351690207785e-48, -2.97855180999356730987e-47, -2.48363636343289194266e-49, 8.05217716766341742256e-49, 6.49739077584050654356e-51, -2.17235040615849511742e-50, -1.69805619284416208228e-52, 5.84937404141890201677e-52, 4.43357201710059304755e-54, -1.57217745003037368065e-53, -1.15656040123120734977e-55, 4.21843911611513121285e-55, 3.01451771205391816173e-57, -1.1300603580462691709e-56, -7.85095728761089098807e-59, 3.02266004359612147093e-58, 2.04315484188229398909e-60, -8.07327817376523625027e-60, -5.31338158489824587384e-62, 2.15335625826640229203e-61, 1.38085359723045391293e-63, -5.73610610007229363712e-63, -3.586293478975231788e-65, 1.52609487795392616864e-64, 9.30848843050034984551e-67, -4.05540952684742384958e-66, -2.41468375254339480689e-68, 1.07646686473501582377e-67, 6.26038223114024067317e-70, -2.85431356094773808248e-69, -1.62222790392012600355e-71, 7.56064006077476575257e-71, 4.20149176236411073871e-73, -2.00074043203916080754e-72, -1.08764041246270602174e-74, 5.28952196063767758415e-74, 2.81427320617106839702e-76, -1.39718087901551055655e-75, -7.27871388347116957764e-78, 3.68735854070572771307e-77, 1.881734605686968412e-79, -9.72343367611606731437e-79, -4.86278215465759833475e-81},
            {0.00012962962962962962963, -0.000208333333333333333333, 0.0000439342403628117913832, 0.0000165343915343915343915, -4.88683127572016460905e-6, -8.68055555555555555556e-7, 3.18958889034646610404e-7, 3.75781625781625781626e-8, -1.64021191315656110121e-8, -1.45315228813906062583e-9, 7.33367250305815855493e-10, 5.2191892469670247448e-11, -2.98835620284915326098e-11, -1.77958215556935600509e-12, 1.13954748345169106853e-12, 5.83852219826893430361e-14, -4.1340120820706990029e-14, -1.85951273726714290145e-15, 1.4424857093425731439e-15, 5.78445296977824099096e-17, -4.87851132776807958979e-17, -1.7652397827552842026e-18, 1.60816071636834740136e-18, 5.30206055944420120754e-20, -5.18877628988482639407e-20, -1.57134230844508947225e-21, 1.64400400797912786461e-21, 4.60394347824549661243e-23, -5.12806239427492534011e-23, -1.33566383051278706852e-24, 1.57799871451028323784e-24, 3.84165533562324334093e-26, -4.79830913957492840262e-26, -1.09658349484792977801e-27, 1.44376607923679274235e-27, 3.10913250761264987579e-29, -4.30360733213940453734e-29, -8.76240805017083390754e-31, 1.27208979088613229624e-30, 2.45617542261767506491e-32, -3.73174347107402235488e-32, -6.85130880337433053162e-34, 1.08723516053275766155e-33, 1.90266027209982317495e-35, -3.14789388016734873693e-35, -5.26249883576553650456e-37, 9.0622140803380166897e-37, 1.45015326199000040278e-38, -2.59519614784657652705e-38, -3.98251142291072410438e-40, 7.39618035364535937405e-40, 1.0902756838560345951e-41, -2.09848331163496977579e-41, -2.97614321181708495663e-43, 5.92933592947064494474e-43, 8.10215453274450593668e-45, -1.66892133013258126029e-44, -2.20017845737592128206e-46, 4.68067771972389932361e-46, 5.96072727223894066238e-48, -1.30835986639065238916e-47, -1.6113529124084456228e-49, 3.64572582633530774307e-49, 4.34702385368105493064e-51, -1.0128922011180489279e-50, -1.17046301251455656455e-52, 2.8063473694931740653e-52, 3.14584429134888399138e-54, -7.75511895052348519133e-54, -8.44064959375097085284e-56, 2.13780588246336628102e-55, 2.26107569883193660456e-57, -5.87948781322333044857e-57, -6.04773833197159020772e-59, 1.61345214368558243696e-58, 1.61526800180906674565e-60, -4.41842792733004174995e-60, -4.30826322335901620835e-62, 1.20759273392649913046e-61, 1.14761391327207417216e-63, -3.29425154740819600044e-63, -3.05318420520411474933e-65, 8.97048689841271455837e-65, 8.11333740854580655115e-67, -2.43856822568294941918e-66, -2.15357148751224279157e-68, 6.61831683404049085597e-68, 5.71024222179884353251e-70, -1.79343545938824699552e-69, -1.51253703445107986594e-71, 4.85265268560129205675e-71, 4.00251671786275816002e-73, -1.31116004589587817323e-72, -1.05816672552032171728e-74, 3.5378650992851135764e-74, 2.79502613125292911781e-76, -9.5336741872043814517e-76, -7.37639965429291617506e-78, 2.56587647425729701538e-77, 1.9451128618630393339e-79, -6.89745933326559629339e-79},
            {0.0000810185185185185185185, -3.62181909800957420005e-6, -0.0000137786596119929453263, 3.21195865177346658828e-6, 1.20563271604938271605e-6, -3.56189105663011386917e-7, -7.30686494575383464272e-8, 2.55385376075835307961e-8, 3.63288072034765156458e-9, -1.45908592073838007602e-9, -1.59475226990659089425e-10, 7.22548570460467305867e-11, 6.4262688951115633517e-12, -3.24033361193094964657e-12, -2.43271758261205595984e-13, 1.35073059803776037885e-13, 8.78103237042817481241e-15, -5.32261579280348944722e-15, -3.05290573404962718967e-16, 2.00577667215219814561e-16, 1.02972320660724911818e-17, -7.28861568157940136252e-18, -3.38742757964490632704e-19, 2.56974094437744963631e-19, 1.09120993642020102239e-20, -8.83201928725217646409e-21, -3.45295760868412245932e-22, 2.96999051410868159617e-22, 1.07595141902418958298e-23, -9.80049177960258613441e-24, -3.30809209456445954358e-25, 3.181045778872163751e-25, 1.00520153694393562984e-26, -1.01758033655616865948e-26, -3.02276771573452071257e-28, 3.21328468842121429446e-28, 9.00580827378669040498e-30, -1.00300765343167834812e-29, -2.66085670783581465365e-31, 3.09839791198144590782e-31, 7.80287947050965421657e-33, -9.48154522293213544883e-33, -2.27262199167478879231e-34, 2.87674977850681342878e-34, 6.5781235447069206307e-36, -8.66023053673956178624e-36, -1.89325564759805608141e-37, 2.58847541393009270717e-37, 5.42064054785070780874e-39, -7.68589909088609532125e-39, -1.54455721879604900972e-40, 2.26830481534849149909e-40, 4.3815441729529306306e-42, -6.65671299517333796941e-42, -1.23782916472485507366e-43, 1.9433209779854552863e-43, 3.4836158908452086966e-45, -5.64562552818656869815e-45, -9.76896969616937497445e-47, 1.63268836940205565319e-46, 2.73034799046986619419e-48, -4.70159782694203787958e-48, -7.60729174394184612863e-50, 1.3485092250732163596e-49, 2.11333599481794935267e-51, -3.85330578599228354368e-51, -5.85476576445486742841e-53, 1.0971846725858820032e-52, 1.61779117213560274679e-54, -3.11372392141378203346e-54, -4.45934373936298608122e-56, 8.80875883919667704659e-56, 1.2263469395386835699e-57, -2.48460425846759880693e-57, -3.3651416704355557201e-59, 6.98836295684973240181e-59, 9.2148963388512291123e-61, -1.96034282356368647007e-60, -2.51837497634705165557e-62, 5.48510418467787586755e-62, 6.86966446170925818599e-64, -1.53104415209797350214e-63, -1.87057501363694984374e-65, 4.26373691514217958686e-65, 5.08482156773723992454e-67, -1.18478441165228646557e-66, -1.37997520360138718702e-68, 3.28532054070300583368e-68, 3.73932766850405855746e-70, -9.09171917759945206614e-70, -1.01174728145975275712e-71, 2.51120320017613676153e-71, 2.73359737426083110297e-73, -6.92341887123835001818e-73, -7.37576340191745183867e-75, 1.90544049896356535862e-74, 1.98752990685114685828e-76, -5.23524859473674730126e-76, -5.34906037012335816823e-78, 1.43606995789102659134e-77, 1.43787113221168221254e-79},
            {-3.41935716085375949322e-6, 5.90513983371126228269e-6, -1.01568405139833711262e-6, -1.03339947089947089947e-6, 2.54669322580577991833e-7, 9.39454064454064454064e-8, -2.76928983948650789746e-8, -6.22779552059597411071e-9, 2.10715775877025562085e-9, 3.41732629265698048767e-10, -1.30001357233467397795e-10, -1.65246914445725914758e-11, 6.9712141160688213527e-12, 7.29815274783616787952e-13, -3.37907734319522150529e-13, -3.01063966986108850711e-14, 1.51726244575479184118e-14, 1.17754935456199905887e-15, -6.41552643944229295676e-16, -4.4130994568882105065e-17, 2.58431655290536266395e-17, 1.59693014468974155418e-18, -1.00020823795910539674e-18, -5.61193681587531954373e-20, 3.74330695929979969299e-20, 1.92379066769543965591e-21, -1.36145204664482892631e-21, -6.45570851414513749787e-23, 4.83105110245353705618e-23, 2.12663063222000970658e-24, -1.67784084695955675257e-24, -6.8928105390441300332e-26, 5.7181540932312487225e-26, 2.20230219289229366202e-27, -1.91641521120933505218e-27, -6.94733781120687545527e-29, 6.32751842010489322526e-29, 2.16669760495202050369e-30, -2.06133486400793057573e-30, -6.68818240329398932849e-32, 6.63436963116247751629e-32, 2.04535979250730991308e-33, -2.11189750146710166269e-33, -6.20223077072366802323e-35, 6.65563553292867929294e-35, 1.86620913834665528024e-36, -2.07834486461987949791e-36, -5.57551599207501374614e-38, 6.43546725716637721839e-38, 1.6548827344243382247e-39, -1.97725246640272643227e-39, -4.88229207843326555981e-41, 6.03138129937760179478e-41, 1.43234517632447515666e-42, -1.82755159898499692399e-42, -4.18033906901425043592e-44, 5.50329355223187828841e-44, 1.21414337652390803254e-45, -1.64762138217841423485e-45, -3.51044741631839939253e-47, 4.90611418998402481399e-47, 1.01068304598084527137e-48, -1.4534886767266116439e-48, -2.89828936432175911223e-50, 4.28562423681446869236e-50, 8.28031158115759822018e-52, -1.25796234701115379507e-51, -2.35735285082616400247e-53, 3.67692174125682354302e-53, 6.68901560904447912184e-55, -1.07045147363541018657e-54, -1.8920781352882546507e-56, 3.10462900323253155557e-56, 5.33615322026209549901e-58, -8.97220820105117762542e-58, -1.50071168947005731257e-59, 2.5841394115393114315e-59, 4.20928388903721491002e-61, -7.41879746605041400147e-61, -1.17765676486444426046e-62, 2.12334534167946034624e-62, 3.28686752396206901114e-64, -6.05955782932633821897e-64, -9.15267882192703186418e-66, 1.72446184954525631072e-65, 2.54309716092255638751e-67, -4.89456071331370961333e-67, -7.05130360346479613692e-69, 1.38571125861938313183e-68, 1.95122689995809460301e-70, -3.91362059622853280729e-70, -5.38909196639992417442e-72, 1.10274886055825182081e-71, 1.48568948524337244179e-73, -3.10033471995661833795e-73, -4.0886329512366449656e-75, 8.69789530256009409187e-75, 1.12330267772590521533e-76, -2.43517718382868012659e-76, -3.08115242616789045544e-78, 6.80444537830732875162e-78},
            {-1.32865646258503401361e-6, -5.60988284202569916856e-8, 5.42534722222222222222e-7, -1.061969448400725457e-7, -8.22022306397306397306e-8, 2.07551919798316754535e-8, 7.62904951273006828562e-9, -2.23837830893095128419e-9, -5.38228891093474426808e-10, 1.7781891395328634331e-10, 3.18100310308022385909e-11, -1.16394578814461914378e-11, -1.66032975013272819259e-12, 6.65407438208758243532e-13, 7.90292913338535733116e-14, -3.4399779995987001164e-14, -3.50320932982194720015e-15, 1.6450456220688255083e-15, 1.46735556941532999341e-16, -7.39187491232213792898e-17, -5.8687182817348002116e-18, 3.15642676954041215771e-18, 2.25880456838981611635e-19, -1.29172385643548790329e-19, -8.4165841711675484946e-21, 5.09909655444508293404e-21, 3.05032227293357746774e-22, -1.95154395382807476137e-22, -1.07926504585165492609e-23, 7.27101467084136454373e-24, 3.73934971743144054301e-25, -2.64595571506316156228e-25, -1.27182951639529958981e-26, 9.43034550030777991257e-27, 4.25524440936421121635e-28, -3.29928836898444535639e-28, -1.40293669920643327614e-29, 1.13526071252005275623e-29, 4.56468449024814771669e-31, -3.84826035645808234786e-31, -1.46754565112399486263e-32, 1.28687696457144769012e-32, 4.66717865496956018748e-34, -4.25051141891617511497e-34, -1.46963969644799103319e-35, 1.38815071447613929526e-35, 4.5858619034816988062e-37, -4.48669105160334194152e-37, -1.41906194476887002768e-38, 1.43636508386623751019e-38, 4.35744568000168951213e-40, -4.55792470910487859732e-40, -1.32850015104095070781e-41, 1.43454123177776980069e-41, 4.02357635392621604457e-43, -4.4807714588578390558e-43, -1.21110801808259826246e-44, 1.38966816646204639572e-44, 3.62453695734874737279e-46, -4.28144584655126310669e-46, -1.07890415158455232719e-47, 1.31091318416270443659e-47, 3.19536402416473942123e-49, -3.99050320957551504187e-49, -9.41885442356676797545e-51, 1.2080999020151561709e-50, 2.7639962175936772929e-52, -3.63862658343917540497e-52, -8.07698634792120853962e-54, 1.09058089927473831092e-53, 2.3509070830956564035e-55, -3.25371824447083894464e-55, -6.81693573888482699999e-57, 9.66518691312364598099e-57, 1.96968409242945022275e-58, -2.85921694815268012235e-58, -5.67201004047764709126e-60, 8.42522096396661749965e-60, 1.62811047742509419008e-61, -2.47341443608796841163e-61, -4.65913471521623282329e-63, 7.2355552104081443599e-63, 1.32942659888490137827e-64, -2.1094958619431774109e-64, -3.78285702687230262643e-66, 6.13034340159233045275e-66, 1.07356097362751521185e-67, -1.77604165917896444761e-67, -3.03903589668473234418e-69, 5.13029660685511683133e-69, 8.58212895649187924777e-71, -1.47777306922571659668e-70, -2.41795963723358864901e-72, 4.24522254351197088088e-72, 6.79735228143092225531e-74, -1.21637902798810989498e-73, -1.90680629543972410302e-75, 3.47663030969179848668e-75, 5.33809657833587021405e-77, -9.91315528586749996864e-77, -1.49146866660555841571e-78},
            {8.66087175610985134795e-8, -1.6075102880658436214e-7, 1.77407246611190815135e-8, 4.87124329716922309515e-8, -1.02812909047404269995e-8, -6.78137734464894958722e-9, 1.74105384122775853131e-9, 6.37900907962636357698e-10, -1.86416300776252878614e-10, -4.71259718974847979125e-11, 1.52906640037989148267e-11, 2.9516973335692945646e-12, -1.0488029363997775752e-12, -1.63912604247992596498e-13, 6.31881108750059098547e-14, 8.30390359661498595592e-15, -3.44857321791663864807e-15, -3.9129481851075466491e-16, 1.74071934110176606996e-16, 1.73887949088438524788e-17, -8.24712118669510981116e-18, -7.36202970438162289774e-19, 3.70746536244549047641e-19, 2.99256326085957279808e-20, -1.59454453368679398121e-20, -1.17493894957441502461e-21, 6.60345950671758854233e-22, 4.47695130131056858231e-23, -2.64666622337368332244e-23, -1.661933207747306908e-24, 1.03088979845522080681e-24, 6.02941400365179064801e-26, -3.91544685359848740835e-26, -2.14338236916123231638e-27, 1.45421412286322251429e-27, 7.48232906243431080607e-29, -5.29395157609834779788e-29, -2.56974830562117945532e-30, 1.89281114715736398743e-30, 8.69656682147552511189e-32, -6.65818726966166015807e-32, -2.90402227420328189443e-33, 2.30764751718039924413e-33, 9.57987357684616377191e-35, -7.89053927524337413217e-35, -3.125179963854194742e-36, 2.66475012229777842278e-36, 1.00911071628008535302e-37, -8.89710868545663643546e-38, -3.22773754074199223121e-39, 2.93943719637496185538e-39, 1.0234371533945101749e-40, -9.61701581890034369178e-41, -3.21886108314097283565e-42, 3.11802118514978790535e-42, 1.00477109648334078071e-43, -1.00242269381266231212e-43, -3.11441694112929403884e-45, 3.19741702401806164486e-45, 9.59025912519602068616e-47, -1.0123814126334458801e-46, -2.93500102960316806098e-48, 3.18335342088644054878e-48, 8.9304693793818244508e-50, -9.94494988639145017905e-50, -2.70257407942492890861e-51, 3.08789594448265364118e-51, 8.13681587642432860288e-53, -9.53270521275615319445e-53, -2.43797771580290293696e-54, 2.92685820213319355312e-54, 7.27139812147714879999e-56, -8.94018638489046303912e-56, -2.15935737540413802198e-57, 2.71749131012016183858e-57, 6.38626315668594339164e-59, -8.22194911654222256504e-59, -1.88137210724677550854e-60, 2.47666156047145202613e-60, 5.52193744025627593871e-62, -7.42910878560052733226e-62, -1.61500712753425056323e-63, 2.21958227757596131971e-63, 4.70755541121886549066e-65, -6.60618232305055764137e-65, -1.36779620343653789954e-66, 1.95906787173336194027e-66, 3.96200235419639179686e-68, -5.78945789642423135765e-68, -1.1442838608655838997e-69, 1.70522282967544458548e-69, 3.29558943148874304754e-71, -5.00657092534408253967e-71, -9.4659424363630621037e-73, 1.465456626902653586e-72, 2.71190228684760761318e-74, -4.27693641127118671472e-74, -7.75012540262096712558e-76, 1.24471662925214239974e-75, 2.20958320978601246772e-77, -3.61271533651675602728e-77},
            {2.52608759553203997648e-8, 4.80255786292342328898e-9, -1.87890812890812890813e-8, 2.87087187730635993132e-9, 4.3594568644171818775e-9, -9.62531505226978478007e-10, -5.74110817166372721928e-10, 1.49127360436068060367e-10, 5.45314817670895518701e-11, -1.58803609571881850971e-11, -4.17454337176228802708e-12, 1.33528797833093970917e-12, 2.73968209957359054147e-13, -9.51268432554048835552e-14, -1.60146712220431872007e-14, 5.98770764347480588922e-15, 8.55258674744935196159e-16, -3.42242062013930757832e-16, -4.24783418487471253411e-17, 1.81037277694737057451e-17, 1.98774802018303818239e-18, -8.98558987730036082832e-19, -8.84943707139902241718e-20, 4.22823597045282936761e-20, 3.77658948077490543625e-21, -1.90137910622608154487e-21, -1.55414166602638309357e-22, 8.22253151639260365549e-23, 6.19663667460067289985e-24, -3.43686821962645833574e-24, -2.40315215288407084399e-25, 1.39421654812049894525e-25, 9.09406519486979997094e-27, -5.50792021861427574789e-27, -3.36704807809543986273e-28, 2.12507218299152681266e-28, 1.22246597967407536946e-29, -8.02667511936469333488e-30, -4.36070707762558473468e-31, 2.97418101445992631327e-31, 1.53083459883001574149e-32, -1.08302336806475781503e-32, -5.29630153462780768533e-34, 3.88162470902300278684e-34, 1.80813983622992695787e-35, -1.37112229012285934903e-35, -6.09791189980680149039e-37, 4.77899306762812899352e-37, 2.03347465066745510566e-38, -1.64529943999952956494e-38, -6.710823620115431004e-40, 5.60017768482998483325e-40, 2.19342390951177720372e-41, -1.88609480383823503017e-41, -7.10516703941790980642e-43, 6.28998055016256665809e-43, 2.28242270114189691704e-44, -2.07848119307902785591e-44, -7.27489656497012426336e-46, 6.80946194730944202989e-46, 2.30187937893162752211e-47, -2.21301208987754445609e-47, -7.23368019729927780515e-49, 7.13792472522759796555e-49, 2.25857976637654773077e-50, -2.2859740193675127408e-50, -7.00928567640552878219e-52, 7.27208555016347130964e-52, 2.16283451644800389122e-53, -2.29877981720178225347e-53, -6.63774771374842583313e-55, 7.22329873532066349688e-55, 2.02671113662931240063e-56, -2.2568923276497132174e-56, -6.15818232966144541337e-58, 7.01374236121893382476e-58, 1.86255838617430775345e-59, -2.16855068906340170428e-59, -5.6087107428888745606e-61, 6.6723471843149887379e-61, 1.68191456567495522942e-62, -2.04351432933690727024e-62, -5.02363413168641788789e-64, 6.23103775548566757179e-64, 1.49480585089850213306e-65, -1.89196877030408533705e-65, -4.43178263333682110992e-67, 5.72163084935808819887e-67, 1.30938767507618957666e-68, -1.72366980656735699138e-68, -3.85583963484182936563e-70, 5.17354094819947955598e-70, 1.13185625989084042583e-71, -1.547348112158114493e-71, -3.31239493607814929896e-73, 4.61229564840371385878e-73, 9.66551353784014900091e-75, -1.37035817877177399679e-74, -2.81248377131333872677e-76, 4.05876879950971006481e-76, 8.16177722901442063755e-78},
            {-2.14469446836406476093e-9, 4.2702457475184747912e-9, -1.32678061561347587491e-10, -1.98157130200780994432e-9, 3.49363378630921787354e-10, 3.9143919352252685586e-10, -8.92749304300073267461e-11, -4.95740743337177744274e-11, 1.29930616288905890696e-11, 4.74379928609350912169e-12, -1.37738727635545790063e-12, -3.73593013578216892019e-13, 1.18122659030987592484e-13, 2.54778860350687069102e-14, -8.68271681254791537716e-15, -1.55501577226351853847e-15, 5.6717110914500991496e-16, 8.68875174178918472886e-17, -3.37362026857179768586e-17, -4.51760913677963223271e-18, 1.85923652849814735867e-18, 2.2123592678497556043e-19, -9.6161863936011649957e-20, -1.02997894930224693716e-20, 4.71359204485618152062e-21, 4.59178219507795004919e-22, -2.20650384379600983314e-22, -1.97165712373657774086e-23, 9.92454923704417494568e-24, 8.1925641575593324227e-25, -4.31041993822341447197e-25, -3.30693279813447271671e-26, 1.81509652476457325296e-26, 1.30090493926414721969e-27, -7.43575325019157206684e-28, -5.00099718957576287507e-29, 2.97191809106823456136e-29, 1.88303260170195704452e-30, -1.16169294826726609399e-30, -6.95833908559098064316e-32, 4.45035367931976960911e-32, 2.52778027789054457709e-33, -1.67390057681719156135e-33, -9.04069918114963478936e-35, 6.19125494371224538158e-35, 3.18754485671719168816e-36, -2.25496109326486249454e-36, -1.10916799127315733036e-37, 8.09724310987664734471e-38, 3.81296796597467670682e-39, -2.86971888227083411715e-39, -1.29611412834786834766e-40, 1.0047559964088287039e-40, 4.35998886509735374485e-42, -3.47833953368159935532e-42, -1.45245080981757076539e-43, 1.19153427332101475643e-43, 4.79481819054849099176e-45, -4.04170361011716687138e-45, -1.56946321290792785599e-46, 1.35836721237649416012e-46, 5.09645650264267299908e-48, -4.52596323313871614686e-48, -1.64260346645567107692e-49, 1.49578829618070475988e-49, 5.25696425730414658664e-51, -4.90567924646067698339e-51, -1.67128121725527573412e-52, 1.59729590563776886937e-52, 5.28002659048170236727e-54, -5.16536127281503045604e-54, -1.65821820269671014597e-55, 1.65959926782640158277e-55, 5.17847150448803364306e-57, -5.29954713022312787942e-57, -1.6085731516959930598e-58, 1.68244927479562813008e-58, 4.97135724937877517872e-60, -5.3117499132385870747e-60, -1.5290132415226865722e-61, 1.66817414772986084943e-61, 4.68111362270779848645e-63, -5.21267708059529839284e-63, -1.42686013040311567247e-64, 1.62104866586015274467e-64, 4.33106030076098426651e-66, -5.01811330109478150535e-66, -1.30938767507618957666e-67, 1.54661166317006604066e-67, 3.94347235381550730575e-69, -4.74679105780598089833e-69, -1.18330427170406044518e-70, 1.45102009330860806166e-70, 3.53824004535620493298e-72, -4.41848057553128690616e-72, -1.0544196586734708001e-73, 1.34049772548129802241e-73, 3.132084199871672673e-75, -4.05243649623156478268e-75, -9.27474685115275072448e-77, 1.22090836773377624253e-76},
            {-5.14011062201297891534e-10, -1.98061578851754284787e-10, 6.0548012005794192743e-10, -6.23136024284301589986e-11, -1.99344033738323861781e-10, 3.81314537603145637577e-11, 3.53444789231135984343e-11, -8.25977918372409809216e-12, -4.34848267891905002821e-12, 1.14782025557707784785e-12, 4.18562542990409666058e-13, -1.21224987690480073965e-13, -3.37346083612483804459e-14, 1.05641403885579701092e-14, 2.37571854095815332267e-15, -7.97200395800233986837e-16, -1.5044412738097940225e-16, 5.3756354064228484799e-17, 8.74241027395317719107e-18, -3.31047965700497376836e-18, -4.73199065623419948696e-19, 1.89163587602254060409e-19, 2.41282105716174513983e-20, -1.01497390736087151356e-20, -1.16920379967262616993e-21, 5.16125222596402336069e-22, 5.42205709027558878737e-23, -2.50560200535088442638e-23, -2.41984070950132133596e-24, 1.16810871950182780673e-24, 1.04413341126282888555e-25, -5.2548638294718014938e-26, -4.3724860458600503773e-27, 2.29024735327315187033e-27, 1.78276288702469324713e-28, -9.70291709616985231798e-29, -7.09624323048793071407e-30, 4.0073346779558671922e-30, 2.76400691455419508881e-31, -1.61732761554848099643e-31, -1.05558231974873667062e-32, 6.39204378127546895841e-33, 3.9594914006331270883e-34, -2.47839980042736664103e-34, -1.46095805932871285707e-35, 9.44243367344192079937e-36, 5.30962825452057722034e-37, -3.53985273002643946447e-37, -1.90295345709291735646e-38, 1.30741197343888365382e-38, 6.73259283336253836143e-40, -4.76259020326316096981e-40, -2.35358658180718262338e-41, 1.71278836403649615509e-41, 8.13641425870028067647e-43, -6.0866179437007588254e-43, -2.78365833840176282577e-44, 2.13896724420551726854e-44, 9.4313113442337516531e-46, -7.43872711680566772247e-46, -3.16640954932706813184e-47, 2.56177559639635927047e-47, 1.05400389097572227436e-48, -8.74153129211129247835e-49, -3.48030504071524519394e-50, 2.95713667833733152794e-50, 1.14049468251586871856e-51, -9.92216040427302643326e-52, -3.710685353866307497e-53, 3.30360283098144769772e-53, 1.19913742250567650371e-54, -1.09193330146276631671e-54, -3.85028946120730649572e-56, 3.58423839951097676603e-56, 1.22877115754555025401e-57, -1.16880821802561904496e-57, -3.89883295391094682998e-59, 3.7877113578009635994e-59, 1.23028935822519873263e-60, -1.22019456724601861241e-60, -3.86191873873393375132e-62, 3.90860595242631112674e-62, 1.20622527690559686015e-63, -1.24528515329564063783e-63, -3.7495753529736298974e-65, 3.94707769378918340197e-65, 1.16026296763695687487e-66, -1.2449195503871313271e-66, -3.57468466146794597438e-68, 3.90803135142059792217e-68, 1.09674775553311528299e-69, -1.22127215640676023858e-69, -3.35149959851796078374e-71, 3.80001825170015279583e-71, 1.02024865121646017232e-72, -1.17748103977648752317e-72, -3.09438318635469883527e-74, 3.63403270612887813767e-74, 9.35203640824569031386e-76, -1.11726931779227870422e-75, -2.81683566600317091595e-77},
            {5.24958211460082943639e-11, -1.11780945241466201987e-10, -7.04956195067935179675e-12, 7.36039509187657335805e-11, -1.02371138133458948404e-11, -1.95754037112629160559e-11, 3.95624694095271472172e-12, 3.21118720904791386699e-12, -7.64960784016008091757e-13, -3.86365424298839691746e-13, 1.02575007241312717587e-13, 3.73675661847674368016e-14, -1.0798937805226293033e-14, -3.07015934523822890929e-15, 9.53657294666437509991e-16, 2.22194403516523424861e-16, -7.35927645214786533929e-17, -1.45258509167222021021e-17, 5.10104746439908694743e-18, 8.73598274997082982209e-19, -3.23870690173885692544e-19, -4.89988276223615936088e-20, 1.91107838621249987217e-20, 2.59023611004397182262e-21, -1.0597483452725054491e-21, -1.30129370166614130897e-22, 5.57088965307993577306e-23, 6.25435752609572283757e-24, -2.79554922737125114024e-24, -2.89144636965091075999e-25, 1.3467574933866619652e-25, 1.29156510893096872683e-26, -6.25777688379362386553e-27, -5.59513275312365265254e-28, 2.8154889783754166266e-28, 2.35813621197752774498e-29, -1.23061334195090018613e-29, -9.69528579259009969613e-31, 5.24014435218911609544e-31, 3.89753471907225847613e-32, -2.17905094996233464403e-32, -1.53506435839930465577e-33, 8.86752439604028160828e-34, 5.93373734865815683488e-35, -3.53785890766828467809e-35, -2.25454984345796817356e-36, 1.38604385997272632137e-36, 8.43154762527323382554e-38, -5.3398043668864650517e-38, -3.10735053847501770528e-39, 2.02548908045325224695e-39, 1.12972155926744765922e-40, -7.57313615666544141083e-41, -4.05568956895213990643e-42, 2.79381208501810442771e-42, 1.43893723338921893763e-43, -1.01785172060121181277e-43, -5.04937899660514703889e-45, 3.66513426682373813797e-45, 1.75370375039653004225e-46, -1.30536551649858839421e-46, -6.03214534527644132402e-48, 4.60151501943132529809e-48, 2.05605713174562177611e-49, -1.60642276663500863561e-49, -6.94824452732744634693e-51, 5.55712568694311132736e-51, 2.32916865288838993658e-52, -1.90586791724984846909e-52, -7.74827257619052510088e-54, 6.48321509042228753103e-54, 2.55896161114085600946e-55, -2.18841587613739638234e-55, -8.39345221461883558126e-57, 7.33302884046683363849e-57, 2.73518127228214116072e-58, -2.44011546172268566668e-58, -8.85808337922143087497e-60, 8.06600421262235006548e-60, 2.85187845321890492405e-61, -2.64950444770631257934e-61, -9.13019748057774854147e-63, 8.65080394243451727268e-63, 2.90736304292109148967e-64, -2.80835916099834671394e-64, -9.21070294308722688361e-66, 9.06700826289077190294e-66, 2.90374384808473149919e-67, -2.91201854515338375901e-67, -9.11144289212126542791e-69, 9.30550572747350901557e-69, 2.84619658212602208096e-70, -2.95932343504439370097e-70, -8.85261906593974672596e-72, 9.36778278836262818575e-72, 2.74209956206201004479e-73, -2.95225122398280853408e-73, -8.45999601238225523776e-75, 9.26440227077843596383e-75, 2.60015599938754238396e-76, -2.89534425231487569869e-76},
            {1.08877544066363183754e-11, 6.74245307753334118503e-12, -1.863996159631080266e-11, 8.60577171952771334014e-13, 8.2623457222862957379e-12, -1.33150299751269614076e-12, -1.89751971443740364867e-12, 3.99176188339796230128e-13, 2.93537367811456129443e-13, -7.1017730866150972878e-14, -3.46984543144269056015e-14, 9.25623125400907239051e-15, 3.36920083990429016669e-15, -9.7183174354170490203e-16, -2.81350056400792648363e-16, 8.67872727736146277669e-17, 2.08455393025688744452e-17, -6.82743738761939907638e-18, -1.40116086963817854939e-18, 4.8478045459755999958e-19, 8.68615580578228250338e-20, -3.16222099817050097704e-20, -5.0290947850853738634e-21, 1.9203769216330131833e-21, 2.74623670806166185334e-22, -1.09702320966181766096e-22, -1.42550616341532384155e-23, 5.94345728859798342514e-24, 7.07841091791164517219e-25, -3.0741930274086336392e-25, -3.37987492791675582411e-26, 1.52633548958380173061e-26, 1.55864412408444609606e-27, -7.3072862205878734248e-28, -6.96722062629724106472e-29, 3.3860855843685518647e-29, 3.02820290015314152847e-30, -1.52361633439714127965e-30, -1.28314941725300977104e-31, 6.67558185220980199154e-32, 5.31291755212226871121e-33, -2.85479533126079672097e-33, -2.15386959603890238357e-34, 1.1940842225178163195e-34, 8.56436141833059338657e-36, -4.8939406023011809504e-36, -3.34524389548178303078e-37, 1.96852824312956567314e-37, 1.28531317727830277809e-38, -7.78215102542103027307e-39, -4.86367138827479089651e-40, 3.02747585797585865918e-40, 1.81452604740780804904e-41, -1.16031141547718078177e-41, -6.68078001216423078185e-43, 4.38551833450681014066e-43, 2.42960378992494412716e-44, -1.63612293210108485857e-44, -8.73435569190999053509e-46, 6.03000674067670842857e-46, 3.10616315506767400646e-47, -2.19710876913432272606e-47, -1.09344856551926249002e-48, 7.91977856503981999737e-49, 3.81251079583876114491e-50, -2.82600080418610237025e-50, -1.31734149134142054205e-51, 9.98795230461697950568e-52, 4.51311720833954611395e-53, -3.49826261760101272273e-53, -1.53371530330065590697e-54, 1.21481124403123044973e-54, 5.17232866991771101728e-56, -4.18444679139301394977e-56, -1.73168944186694002059e-57, 1.43026972933798410446e-57, 5.75775419649393006873e-59, -4.85303171450648284706e-59, -1.90186959185442555649e-60, 1.63522056427952414366e-60, 6.24292074483660338582e-62, -5.47330379011622805323e-62, -2.03704202812458293335e-63, 1.82039221140715066838e-63, 6.60897841046193877038e-65, -6.01791273740692105629e-65, -2.13255473518430605557e-66, 1.9779144059934475755e-66, 6.84541521180798967539e-68, -6.46483678057872760198e-68, -2.18639646536044423492e-69, 2.10182755643173454607e-69, 6.94988081215659337122e-71, -6.79862046721669465355e-71, -2.19902140204323532813e-72, 2.18835480928623508457e-72, 6.92730842312598951612e-74, -7.01086582573323091081e-74, -2.17298751377387470659e-75, 2.23594666483577803401e-75, 6.78856473051401688277e-77},
            {-1.27793960944936953056e-12, 2.89954958164834708045e-12, 4.93278401678187566714e-13, -2.57050755804462534068e-12, 2.53184879731755158654e-13, 8.85509200070788369381e-13, -1.56228790938555991772e-13, -1.82645473304906036098e-13, 3.96249367996754791988e-14, 2.69876866889987043567e-14, -6.61348264600850300069e-15, -3.14458745057733748891e-15, 8.42254186152113390401e-16, 3.06358950303085328217e-16, -8.82214469829797653316e-17, -2.59411155765301548651e-17, 7.95383329633735061455e-18, 1.96162521749344996914e-18, -6.36279071370313732873e-19, -1.3511797920105772783e-19, 4.61490259411065149185e-20, 8.6053399655905286107e-21, -3.08370593290263523571e-21, -5.12630852171510212624e-22, 1.92177360346925033728e-22, 2.88269024157321043513e-23, -1.12779613983874936786e-23, -1.54152059990075828194e-24, 6.28070369554243199767e-25, 7.8863748318057635896e-26, -3.34015089116919970555e-26, -3.87929204216573250576e-27, 1.70514715216110768235e-27, 1.84244278784304819267e-28, -8.39239047353522042843e-29, -8.47896812042879627971e-30, 3.99702320531717455706e-30, 3.79241938877000665662e-31, -1.84790914025304142157e-31, -1.65290768288248359904e-32, 8.31560390260762401666e-33, 7.03597401372708111966e-34, -3.65087428606238657426e-34, -2.93091479649535862563e-35, 1.56704506297404821259e-35, 1.1968539270501490399e-36, -6.58766131239480835559e-37, -4.79850252850566370488e-38, 2.7166819396993955092e-38, 1.89142776210686312642e-39, -1.1005741318275064473e-39, -7.33874979173824588725e-41, 4.3855273600167611159e-41, 2.80592760510897692838e-42, -1.7208319874990540995e-42, -1.05822742850064233094e-43, 6.65598079114093301957e-44, 3.94016490101717350805e-45, -2.54005163057689027594e-45, -1.44954280569824786968e-46, 9.57177312627647898729e-47, 5.27285197150399911855e-48, -3.56443891394929758382e-48, -1.89778315170640554769e-49, 1.31262122453791874759e-49, 6.76235298888595878252e-51, -4.78312770671371401856e-51, -2.38693754574402661138e-52, 1.725682310272043222e-52, 8.35022776241468216017e-54, -6.16762105498492784469e-54, -2.89650405515391816968e-55, 2.18472065071401311686e-55, 9.96683478763416589627e-57, -7.67348461654245208548e-57, -3.40347248059418977396e-58, 2.67356159605149294929e-58, 1.15380088572501817094e-59, -9.24395262201685685204e-60, -3.88448401900944210673e-61, 3.17286984152676840968e-61, 1.29918013793723400416e-62, -1.08148378504874876306e-62, -4.31786589483513332998e-64, 3.66182215912112544928e-64, 1.42644216731216916162e-65, -1.23200140824421008958e-65, -4.68530641163746848893e-67, 4.11984494343426627362e-67, 1.53047752575231096444e-68, -1.36967551392356348613e-68, -4.9730258255876068123e-70, 4.52820613398621056389e-70, 1.60772898060494316212e-71, -1.48903369539233161596e-71, -5.17239028926740550537e-73, 4.87130155436629270183e-73, 1.65629937160986449858e-74, -1.58574947395027529574e-74, -5.27999479039979090882e-76, 5.1375391703030616969e-76},
            {-2.36982417730874520998e-13, -2.09958313173886446263e-13, 5.56119423615423751589e-13, 9.49068604480708556216e-15, -3.19294182717832344729e-13, 4.13003024042727053787e-14, 9.22008398894958355303e-14, -1.73135913359066590976e-14, -1.75160466491097360008e-14, 3.89455764923080197201e-15, 2.4945044680060609888e-15, -6.17908305024116452853e-16, -2.87211515909142495204e-16, 7.71937655504667566121e-17, 2.80613029073042540608e-17, -8.06891111669687504149e-18, -2.40487706952321991409e-18, 7.33473072607620126678e-19, 1.85137615732218521306e-19, -5.9543400463773143556e-20, -1.30321254286587332326e-20, 4.40094280309470155791e-21, 8.50277134611399150746e-22, -3.00498904300222387024e-22, -5.19715788745170150565e-23, 1.91704995214980824353e-23, 3.00151847576830338551e-24, -1.15296420254504416763e-24, -1.64931396722860921225e-25, 6.58483341811931665068e-26, 8.67245576734166161143e-27, -3.59263637022765089267e-27, -4.38465951914571565083e-28, 1.88183196684424079586e-28, 2.14012416501207598406e-29, -9.50313588265534698436e-30, -1.01191959652276619924e-30, 4.64322528550358952823e-31, 4.64880285810698512231e-32, -2.20175196044000730652e-32, -2.08034808578949754259e-33, 1.01592782260390172095e-33, 9.08865405643993419966e-35, -4.57198953311563942406e-35, -3.88402115749447404776e-36, 2.01082497998023074953e-36, 1.62641552047908313074e-37, -8.65854789719535569296e-38, -6.68365098629107883615e-39, 3.65598867044331154964e-39, 2.69910749551911447295e-40, -1.51588378368342600579e-40, -1.07245790676040223945e-41, 6.17982573919462212063e-42, 4.19729629092802847608e-43, -2.47986600378433307584e-43, -1.61963509152388622567e-44, 9.80541620861429391789e-45, 6.16752588001417963783e-46, -3.82376992843020940016e-46, -2.31954786246449961225e-47, 1.47187368681791921531e-47, 8.62213979981996751233e-49, -5.59673912913783216696e-49, -3.16985296354029317931e-50, 2.1037264154670750253e-50, 1.15330395840035901175e-51, -7.82188757940607357929e-52, -4.15504121831692117104e-53, 2.8784436104024544893e-53, 1.48306577823986675515e-54, -1.04897024586106490761e-54, -5.24696350599010175789e-56, 3.78743467450832236917e-56, 1.84082045224445360371e-57, -1.35551573901899468106e-57, -6.40692318755959609344e-59, 4.81091361060770815637e-59, 2.21303536659912927715e-60, -1.69389680043108484223e-60, -7.58896090189297747621e-62, 5.91893354819509600178e-62, 2.58449184570660624799e-63, -2.05327377730685057107e-63, -8.74381616982219077434e-65, 7.07354128673624249989e-65, 2.93957926307062325868e-66, -2.42071795619887031418e-66, -9.8230168119198804689e-68, 8.23172863079539167057e-68, 3.26354819804186697057e-69, -2.78222400924638734687e-69, -1.0782605422807190919e-70, 9.34878045377781535757e-71, 3.54358469336829463709e-72, -3.12378267083577708453e-72, -1.15861326235209271415e-73, 1.03816136435069543527e-73, 3.7696116652613891825e-75, -3.4323916870571856261e-75, -1.22066965250437211621e-76},
            {3.10435788796546229428e-14, -7.47723594777040338271e-14, -2.15822246006593807068e-14, 8.58606205627784456414e-14, -4.66430963283671074974e-15, -3.7190254745342858029e-14, 5.57925498214113532835e-15, 9.420394836495992471e-15, -1.85247697858394313967e-15, -1.67697779361751999247e-15, 3.80431612114078681631e-16, 2.31700046447711592769e-16, -5.79232600737705174893e-17, -2.6410638030404003822e-17, 7.11962746007803763282e-18, 2.5867585285627911681e-18, -7.42842698172158931342e-19, -2.24032072818819050992e-19, 6.80098333940527157647e-20, 1.75221854502974564471e-20, -5.59321448422409469191e-21, -1.25755273690425420615e-21, 4.2043881493864924075e-22, 8.385330373031316715e-23, -2.92730089128760997088e-23, -5.2463516215109840688e-24, 1.90761945516865944774e-24, 3.104590997136205576e-25, -1.17332077419223686391e-25, -1.74906670937983091323e-26, 6.85827393788082816811e-27, 9.43254484791011097993e-28, -3.83131495603191071348e-28, -4.89171237717045939214e-29, 2.05532349769462251395e-29, 2.44901549410551819648e-30, -1.06306884834696079064e-30, -1.18759333518027182957e-31, 5.31971304715957904012e-32, 5.59421333993814465235e-33, -2.58316257352263890782e-33, -2.56620820417127553873e-34, 1.2203207618710704245e-34, 1.14888693062021417211e-35, -5.62129733923802254073e-36, -5.02958749190170245472e-37, 2.52989975131099058413e-37, 2.15674115860149098578e-38, -1.11439403053965861052e-38, -9.07263023703904024522e-40, 4.81197000971421049948e-40, 3.74909654800275068581e-41, -2.03968575579273267728e-41, -1.52372436779908260644e-42, 8.49777015272159116207e-43, 6.09744975632521873192e-44, -3.48368715768848516803e-44, -2.40481681371981458147e-45, 1.40672678930979479604e-45, 9.35615944523495641915e-47, -5.60040701298137890494e-47, -3.59376583253000326564e-48, 2.20006338130973720805e-48, 1.36383589691817656118e-49, -8.53475630903456932263e-50, -5.11718058853268536305e-51, 3.27185165425630308453e-51, 1.89944741408773539248e-52, -1.24029111262580125292e-52, -6.97913307406996120069e-54, 4.65199997734341834993e-54, 2.53970670542041900214e-55, -1.72734929306654034574e-55, -9.15769502293039103692e-57, 6.3528012072650968032e-57, 3.27345319162708775194e-58, -2.31525559884114769558e-58, -1.16044879727550980584e-59, 8.36508610412313754386e-60, 4.08145796404328200401e-61, -2.99747496232523759533e-61, -1.42472827796935604931e-62, 1.06565877124351572167e-62, 4.93768442531135479022e-64, -3.76020025680241959593e-64, -1.6995214562962931109e-65, 1.31727579359724002183e-65, 5.81126372738789567236e-67, -4.58298998004622507919e-67, -1.97458378368919682253e-68, 1.58399093510962381867e-68, 6.66890553881184245076e-70, -5.44008240482265273546e-70, -2.23930730202769543453e-71, 1.85702432217943629634e-71, 7.47743685282695129805e-73, -6.3022093981997123721e-73, -2.4835088618192681673e-74, 2.12681132541269434551e-74, 8.20618253784451842829e-76, -7.13868483881448495093e-76},
            {5.26175862991250608413e-15, 6.21405253619675099592e-15, -1.62181172174137063989e-14, -1.40031813471805951835e-15, 1.17080431605708997499e-14, -1.11769133786085973274e-15, -4.15195179830749297796e-15, 6.85089231302375376183e-16, 9.50287416383261329066e-16, -1.93676556902039260553e-16, -1.60473735873044695733e-16, 3.70207717714593365957e-17, 2.16175963137751290543e-17, -5.44723088826170785137e-18, -2.44304972142041388098e-18, 6.60304620315861481779e-19, 2.39797292757921132358e-19, -6.87825948618506427143e-20, -2.09617255572076978979e-20, 6.33695815983948949055e-21, 1.66276417435118056146e-21, -5.27221435750740084208e-22, -1.21432006513157216132e-22, 4.02370174716607236812e-23, 8.25814607089691936755e-24, -2.85145478470682051144e-24, -5.27780469513154947919e-25, 1.89460305164444500536e-25, 3.19366625083058014897e-26, -1.18955987502779601374e-26, -1.84109301290689943942e-27, 7.1035194522879954888e-28, 1.01638912725652878481e-28, -4.05618770973400834579e-29, -5.39690451478808639596e-30, 2.22480766711417484975e-30, 2.76665262158663326221e-31, -1.1767335220794421057e-31, -1.37369016458481107574e-32, 6.02171930486694933237e-33, 6.62461895669399648331e-34, -2.99000670693303072519e-34, -3.11050498623472799931e-35, 1.44419570248750259308e-35, 1.42504978937214902884e-36, -6.80051651547040948367e-37, -6.38235624341700480608e-38, 3.12800398218960415421e-38, 2.79907443979760019417e-39, -1.40784448625232724861e-39, -1.20387655819199438689e-40, 6.2097660664585967491e-41, 5.08472464958138306816e-42, -2.68800633734446091855e-42, -2.1115242674681775979e-43, 1.14330145610920795189e-43, 8.63062034257222344239e-45, -4.78360233856160851449e-45, -3.47563997169283751422e-46, 1.97086004785494215071e-46, 1.38027228456800495795e-47, -8.00322838198012721697e-48, -5.40988239110876702602e-49, 3.20590143891189994983e-49, 2.09425353715874715784e-50, -1.26778637097843503355e-50, -8.01285409128122448901e-52, 4.95291048326891905714e-52, 3.03204559106817203275e-53, -1.91282850159625597621e-53, -1.13534296053423916133e-54, 7.30723667035093413096e-55, 4.20914797165059825067e-56, -2.76269138406572554248e-56, -1.54579734049056921619e-57, 1.0342753030962777105e-57, 5.62602768753200865125e-59, -3.83593145087646103675e-59, -2.03014742433708434496e-60, 1.41002912801968965915e-60, 7.2661142176437158515e-62, -5.13909044204511998604e-62, -2.58039730522752652185e-63, 1.85785427180696650286e-63, 9.09558705314127238982e-65, -6.66437613895765918655e-65, -3.18328113066914729608e-66, 2.37287592740082714816e-66, 1.10649824619324251574e-67, -8.38869168180075085754e-68, -3.82103587723774824864e-69, 2.94540259353467640248e-69, 1.31123883129843943778e-70, -1.02741554278968353993e-70, -4.47261500641315790606e-72, 3.56132247956339766668e-72, 1.51678004190369378069e-73, -1.22700480780270721993e-73, -5.11518711525641648697e-75, 4.20291917698969248513e-75, 1.7158103584205250898e-76},
            {-7.53847954994926536599e-16, 1.92056651258846523145e-15, 8.01749614771903887981e-16, -2.77295759066152888813e-15, 1.82874650855236447264e-17, 1.4750355072934514527e-15, -1.80556478362890181266e-16, -4.50136144602597471663e-16, 7.94384043545454328213e-17, 9.50173436090396224735e-17, -1.99296428772984324153e-17, -1.53598710650507495912e-17, 3.59437759106364163942e-18, 2.02515963749323782239e-18, -5.13841255523906292106e-19, -2.2717638261276738855e-19, 6.1542321720625388621e-20, 2.23407864491292569701e-20, -6.40142531565131474555e-21, -1.96906283804745066489e-21, 5.93051846900143373607e-22, 1.58181166378981110488e-22, -4.98545773153296692889e-23, -1.17352602060114117328e-23, 3.85741844607671712295e-24, 8.12504143855778011929e-25, -2.77797159891841614867e-25, -5.2947624684822776154e-26, 1.87888967603727691548e-26, 3.27036258871620295159e-27, -1.20228416479538455699e-27, -1.9257899253281598028e-28, 7.32302915416120202512e-29, 1.08648209310865423498e-29, -4.26749908543986611681e-30, -5.89733848285571826945e-31, 2.3896831675919326162e-31, 3.09080287031582492042e-32, -1.29064389093597390978e-32, -1.56898870026963074605e-33, 6.74476452416036304093e-34, 7.73533476839952094564e-35, -3.42007282816471033989e-35, -3.71262971441691457513e-36, 1.68684618583276140115e-36, 1.73835229261489473008e-37, -8.11006304273241328463e-38, -7.9552641973194952887e-39, 3.80813055286331289307e-39, 3.56410823148945706645e-40, -1.74935331076638119946e-40, -1.56555995789742583941e-41, 7.87376737289291186103e-42, 6.75132101308904153014e-43, -3.47712994800860546703e-43, -2.86173200832657935195e-44, 1.50844031360297171783e-44, 1.19360793764714551475e-45, -6.43559761302361404331e-46, -4.90359890570212287694e-47, 2.70298265543445207182e-47, 1.98599629884124473718e-48, -1.11864453206490331139e-48, -7.93611866712788396656e-50, 4.56563917038371733078e-50, 3.13133903304016272794e-51, -1.83910748648920683411e-51, -1.22079730377218505529e-52, 7.31672461547822797306e-53, 4.70569779695112283971e-54, -2.87682828142237946873e-54, -1.7944262405457813595e-55, 1.11856297893604913945e-55, 6.77303308399157301306e-57, -4.30326555573812330022e-57, -2.53171245938940389306e-58, 1.63889535557206739968e-58, 9.37607560450416585633e-60, -6.18198265101360526753e-60, -3.44184357677860224545e-61, 2.31058195086200631156e-61, 1.252850796880206956e-62, -8.56076046576088644103e-63, -4.52385777116763284652e-64, 3.14535007370485522122e-64, 1.62096025995915789945e-65, -1.14643285286916481574e-65, -5.76543823016478995041e-67, 4.14666087490053578243e-67, 2.03620990826485268513e-68, -1.48886988257327963991e-68, -7.14280100207307798999e-70, 5.30826895336115000737e-70, 2.48936335225363920298e-71, -1.87978806966953612187e-71, -8.62169708029468043762e-73, 6.61362158952974062224e-73, 2.96815462872115746152e-74, -2.31234355457336649781e-74, -1.01594034380162669791e-75, 8.03618475939410774575e-76},
            {-1.18623225777522852531e-16, -1.78044052912303173085e-16, 4.64878184316785725363e-16, 7.49535439099761538953e-17, -4.12142274096699670606e-16, 2.44634035768887662308e-17, 1.76082668329839599209e-16, -2.49276172987187353521e-17, -4.77881345798405160087e-17, 8.86989808735893758264e-18, 9.44180309586943136636e-18, -2.02781470021098713277e-18, -1.47121891312008747686e-18, 3.48535751687273040425e-19, 1.90427261895996193343e-19, -4.86115810251536302133e-20, -2.12237471266727941216e-20, 5.76128278394068273015e-21, 2.09068142510332261772e-21, -5.98485315811701594877e-22, -1.85630251132980773778e-22, 5.57211572952278376526e-23, 1.50832609118440791978e-23, -4.72810667817247358509e-24, -1.13511608332792516372e-24, 3.70417861691083045082e-25, 7.98886219509237769618e-26, -2.70716711810555489473e-26, -5.29991113641949360685e-27, 1.86118437262043119277e-27, 3.33614784123025330544e-28, -1.21201439338071141549e-28, -2.0036008011150770745e-29, 7.51916365112809070406e-30, 1.15345002679383901447e-30, -4.46566500981556624636e-31, -6.39068946421183799722e-32, 2.54952548984658277535e-32, 3.41947243205822465535e-33, -1.40423653136772923834e-33, -1.77230170134800788725e-34, 7.48470322239063060839e-35, 8.92123081376064472906e-36, -3.87113229342189030546e-36, -4.37144473584039704181e-37, 1.94744039894037935728e-37, 2.08942674359009096847e-38, -9.54919919343601589808e-39, -9.75936695151966037901e-40, 4.57255087131733106941e-40, 4.46184588000766364231e-41, -2.14172746042928664422e-41, -1.9995824294649014179e-42, 9.82730328890315775255e-43, 8.79561749618022183173e-44, -4.42338436044365023918e-44, -3.80199234256428997788e-45, 1.95548495487512942069e-45, 1.61674540390943521913e-46, -8.4998997155503601584e-47, -6.76991091281471367763e-48, 3.63638113845512928813e-48, 2.79398060133884620823e-49, -1.53256823500765390576e-49, -1.13741285464841204971e-50, 6.36839215787392865558e-51, 4.57080872853526933936e-52, -2.61116299771848686983e-52, -1.81446170935380060084e-53, 1.05715869405625904535e-53, 7.11964999557723251165e-55, -4.22894659631797393685e-55, -2.76299908455773875562e-56, 1.67252359175956216762e-56, 1.06108536900879427871e-57, -6.54339505325904054649e-58, -4.03447017923223371994e-59, 2.53367046259747244705e-59, 1.51947270845431822659e-60, -9.71454789866887789834e-61, -5.6709922835254073685e-62, 3.68990770883453484288e-62, 2.09827167797981088205e-63, -1.38902707214548305675e-63, -7.6995612348060000224e-65, 5.18415654829622212813e-65, 2.80302041013599934942e-66, -1.91900746330256023065e-66, -1.01271498672819585016e-67, 7.04782872138918827526e-68, 3.63232439193657407197e-69, -2.56893977700290140109e-69, -1.2937367774800530799e-70, 9.29616357416391781777e-71, 4.57710683233291123233e-72, -3.34063033170840273538e-72, -1.6089144060979685887e-73, 1.19246138829578870127e-73, 5.62054054909076417284e-75, -4.229229633746388199e-75, -1.95176265973771815181e-76},
            {1.83169799654913833821e-17, -4.91934586578609233188e-17, -2.73329337755063048231e-17, 8.72258781157036339907e-17, 3.88780257330199240518e-18, -5.58992597872506664157e-17, 5.21985849362999173117e-18, 2.02277818327367263529e-17, -3.15549458578764207705e-18, -4.99566301368752982347e-18, 9.64631413488681135557e-19, 9.34107246425452366258e-19, -2.04648312931723745677e-19, -1.41057231034071254328e-19, 3.37761746828713297444e-20, 1.7967193334749455341e-20, -4.61140090306916152488e-21, -1.99112516676506915973e-21, 5.41486714306936768491e-22, 1.96434128183048437861e-22, -5.61833426375654475864e-23, -1.75572349238396689075e-23, 5.25414682914943952786e-24, 1.44141724867038116028e-24, -4.49615527907099654999e-25, -1.09899691572699375715e-25, 3.56274068863794099216e-26, 7.85172020210295349163e-27, -2.63921350434482560386e-27, -5.29547276385754492927e-28, 1.84204635021974686806e-28, 3.39233998072394002032e-29, -1.21919906304394617402e-29, -2.07498946618997494666e-30, 7.694147727577173944e-31, 1.21727418365939771376e-31, -4.65121748197001302805e-32, -6.87512975757738290494e-33, 2.70405517322545675722e-33, 3.75090307163599552857e-34, -1.51703953367007501011e-34, -1.98249573639125438424e-35, 8.23774773232154260122e-36, 1.01769083797342576635e-36, -4.34098635690200258701e-37, -5.08537725953143833597e-38, 2.22505479760074804932e-38, 2.47856938451292962007e-39, -1.11161877644240536254e-39, -1.18038250793853535511e-40, 5.42285076362400202056e-41, 5.5014966313320039011e-42, -2.58741883213165799094e-42, -2.51303357033720623764e-43, 1.20923884148174266381e-43, 1.12651624964867851196e-44, -5.54294297845662950989e-45, -4.96144092205011866188e-46, 2.49502010947234141754e-46, 2.14917806756022656433e-47, -1.10404734150891455386e-47, -9.16543900968298756138e-49, 4.80744208812992583164e-49, 3.8515567564813953006e-50, -2.06181043004810513576e-50, -1.59615542901231627724e-51, 8.71674488445640281729e-52, 6.52822202307187517763e-53, -3.63549983270407664179e-53, -2.63690740576934537469e-54, 1.49687354827902079112e-54, 1.05257107983151952595e-55, -6.08836586841681580636e-56, -4.15451414320903580024e-57, 2.4477850813959594059e-57, 1.62232663291878181331e-58, -9.73298142491573658975e-59, -6.27083974917655141134e-60, 3.82952092777821921561e-60, 2.40042001419064862159e-61, -1.49169192023598028544e-61, -9.1036125711293382184e-63, 5.75500772610719419231e-63, 3.42202721546933334329e-64, -2.200025582899009029e-64, -1.27544844059098383095e-65, 8.3367294079480933211e-66, 4.71528671069212882615e-67, -3.13263715939648766621e-67, -1.72967828187455908189e-68, 1.16767294136848540605e-68, 6.29755468402988800798e-70, -4.3188711767385416297e-70, -2.27644466793277066581e-71, 1.58558661762172404664e-71, 8.17226365002142775212e-73, -5.77970147772609882432e-73, -2.91435435878780364518e-74, 2.09235046392276216416e-74, 1.03267865594588262e-75, -7.52468445234538811849e-76},
            {2.70681710318373501515e-18, 4.98890435611885930901e-18, -1.31464840222232749795e-17, -3.17280457703411750506e-18, 1.40416800900988516116e-17, -2.9498845591197023301e-19, -7.11359791725430328678e-18, 8.33915877551910948626e-19, 2.25880456838981611635e-18, -3.77968206859709821603e-19, -5.16217162498276307669e-19, 1.02917124231334718747e-19, 9.2125894909812087157e-20, -2.0529192691395827945e-20, -1.35398705752298527091e-20, 3.2727585087575013817e-21, 1.70055426922279830149e-21, -4.38565497443352695282e-22, -1.87505304174728054321e-22, 5.1075766034073620357e-23, 1.85233028741944832254e-23, -5.29379050450940780559e-24, -1.66556107920524904406e-24, 4.97049133176029422884e-25, 1.38031909271931034091e-25, -4.28626490979484876096e-26, -1.06505391258190780616e-26, 3.43198198118405169698e-27, 7.71517443346709297111e-28, -2.57418278123901447323e-28, -5.28328547237149510341e-29, 1.82191901949065645417e-29, 3.44011411499916899051e-30, -1.2242236371974786513e-30, -2.14042230858769693687e-31, 7.85005103951859823707e-32, 1.27798464632479103281e-32, -4.82476240227140606742e-33, -7.34925745375569458828e-34, 2.85311035739003343122e-34, 4.08356179194466513117e-35, -1.62866312676455449587e-35, -2.19850437007177862921e-36, 9.00047517272349779463e-37, 1.14968457183186823624e-37, -4.82750178004659825156e-38, -5.85250713520158261963e-39, 2.51870345554652699593e-39, 2.90577416427931311102e-40, -1.28084444760430144729e-40, -1.40959399333889382251e-41, 6.35997744030388816341e-42, 6.69140278417538407294e-43, -3.08851954022426585721e-43, -3.112742268766085362e-44, 1.46895256250747496146e-44, 1.42077626404162488954e-45, -6.85164778924955033828e-46, -6.37041058781607826125e-47, 3.13781222903778308169e-47, 2.80883429937892513544e-48, -1.41244746212900241899e-48, -1.2190453561782023882e-49, 6.25545904732540885849e-50, 5.21232574306653521156e-51, -2.72822164382676827908e-51, -2.19741827427323645333e-52, 1.17271821432676896354e-52, 9.14085844727220442086e-54, -4.9720167051353654794e-54, -3.75450593308324309377e-55, 2.08066446864912372751e-55, 1.52365315347833777076e-56, -8.59972781833752530959e-57, -6.1128336048973238181e-58, 3.51271074220033670652e-58, 2.42582485033935015123e-59, -1.41879016337924136068e-59, -9.52702584579494273496e-61, 5.66941313746516354833e-61, 3.7046040630361254329e-62, -2.24239858487223626432e-62, -1.42693622884283445391e-63, 8.78291805199483819359e-64, 5.44659202501173717285e-65, -3.40800231302223472049e-65, -2.06096383263983716875e-66, 1.31059330220322783169e-66, 7.73389643259222709103e-68, -4.99694137798561846146e-68, -2.87909736870361626393e-69, 1.88955779069721632404e-69, 1.06361158767289500247e-70, -7.08888630439913612568e-71, -3.90039856023749960897e-72, 2.63931778436982064213e-72, 1.42022483943797991034e-73, -9.75500324900948979058e-74, -5.13621752562557408371e-75, 3.58017539132728939003e-75, 1.84534446182236184568e-76},
            {-4.45543389782963882643e-19, 1.25748977603874804151e-18, 8.83197463874231506021e-19, -2.68623445201891074309e-18, -2.65998244039311051546e-19, 2.0412933153860174649e-18, -1.28280842922746823233e-19, -8.64238269644799209735e-19, 1.16638491135743804262e-19, 2.46886469020914755842e-19, -4.35797243677327348059e-20, -5.28722527308486761075e-20, 1.08240778620223004101e-20, 9.06582638515390137917e-21, -2.05014377481759164551e-21, -1.30129370166614130897e-21, 3.17172859918336560313e-22, 1.61417609680852846764e-22, -4.18093920128154690932e-23, -1.77179418796642883025e-23, 4.83346089542222517741e-24, 1.75245991812030551592e-24, -5.00475398724087315615e-25, -1.58436626294738230435e-25, 4.71617313910945137117e-26, 1.32437138694967666331e-26, -4.09563564158707623558e-27, -1.03316248935124549352e-27, 3.31089335876456581212e-28, 7.58036611253301471359e-29, -2.51207772468900756819e-29, -5.26487029773785862895e-30, 1.80115369550025814643e-30, 3.48051279744260284517e-31, -1.22741897344509033701e-31, -2.20035617367224890866e-32, 7.98878080260783369293e-33, 1.33564765898690449474e-33, -4.98694785300346803698e-34, -7.81203125415501155528e-35, 2.99662341738404025696e-35, 4.41612616944852924651e-36, -1.7387903039514698874e-36, -2.41933622942010533192e-37, 9.76982234669758110616e-38, 1.28755156974434817632e-38, -5.32863680754746570166e-39, -6.67064677712816227226e-40, 2.82736314632958489546e-40, 3.37076824494083305382e-41, -1.46226836487472413806e-41, -1.66412277936883464771e-42, 7.38429366525480036772e-43, 8.03899525063936828274e-44, -3.64676558501363843181e-44, -3.80520947238974318242e-45, 1.76375622955814243421e-45, 1.76709650218550344812e-46, -8.36485509226294137961e-47, -8.06013320691343734517e-48, 3.89470259218032805832e-48, 3.61473449092840882067e-49, -1.78216777406603786684e-49, -1.5954249230951481691e-50, 8.02239992459681497493e-51, 6.93619855270595506573e-52, -3.55573604674115556879e-52, -2.97276613850417778557e-53, 1.55303436454527067774e-53, 1.25694329064091181835e-54, -6.68941158501208878097e-55, -5.24666651110801528018e-56, 2.84350491568683814723e-56, 2.1634115453854006904e-57, -1.19360499834495233813e-57, -8.81734597775520315838e-59, 4.95072575529999960416e-59, 3.55399485899654820287e-60, -2.03011808008380305654e-60, -1.4174137284659958178e-61, 8.23462443053694428944e-62, 5.59607164528798555404e-63, -3.30557515676973466183e-63, -2.18810914396123702075e-64, 1.31379568445301521819e-64, 8.47683385077080852887e-66, -5.17214070978793008539e-66, -3.25496162902142427136e-67, 2.01765586246685673141e-67, 1.23926365000720873969e-68, -7.80225317327162551856e-69, -4.67989098576073801088e-70, 2.99186031620357198659e-70, 1.75348352664590199812e-71, -1.13803093238158602671e-71, -6.52068448020220341443e-73, 4.29529649396182456622e-73, 2.40732282288016037489e-74, -1.60911001721250942197e-74, -8.82556046958520882716e-76, 5.98483150941806304624e-76},
            {-6.23754849225569465037e-20, -1.3755775179949335748e-19, 3.67758288074017542208e-19, 1.2000691340278485493e-19, -4.65771292201174619968e-19, -9.10388738481071532676e-21, 2.76076113914310858665e-19, -2.53604725132996108978e-20, -1.01399799776447131864e-19, 1.50813658353945513388e-20, 2.65410316287791965381e-20, -4.88747727074159139816e-21, -5.37833747849408038169e-21, 1.12598366031851699771e-21, 8.90766521973846729353e-22, -2.04047046910281078276e-22, -1.25226756716693379136e-22, 3.07504743457533999911e-23, 1.53625805583597102941e-23, -3.99470404687703085931e-24, -1.67944075486529278609e-24, 4.58769115497038804113e-25, 1.66295585932374055358e-25, -4.74599063359999324705e-26, -1.51093957836520651072e-26, 4.48710959704640503449e-27, 1.27300378152207034023e-27, -3.92190526682391902123e-28, -1.00319527719434936785e-28, 3.19857089523551295657e-29, 7.44812008390296270326e-30, -2.45285387722507493026e-30, -5.24148653424391976088e-31, 1.78002831778207408368e-31, 3.51445777739317534022e-32, -1.22906885752148535811e-32, -2.25523047182114231155e-33, 8.112082312056466581e-34, 1.39035556249544550894e-34, -5.13844055112658208669e-35, -8.2627122575197680148e-36, 3.13460131338891832359e-36, 4.74746732320730986759e-37, -1.84716782721064913214e-37, -2.64407911643928643351e-38, 1.05430722896364254231e-38, 1.4307478504118141699e-39, -5.84245918098996225335e-40, -7.53741232549269613423e-41, 3.14999436224946873919e-41, 3.87304765912627587651e-42, -1.6555053934665568066e-42, -1.94435222431138689219e-43, 8.49563594664128452221e-44, 9.55077377494647842413e-45, -4.26354723794488260483e-45, -4.59655459199443456446e-46, 2.09535949697390063249e-46, 2.17015888130586001536e-47, -1.00973048546896276898e-47, -1.00624454181995189988e-48, 4.77650730220052612407e-49, 4.58684665389855098617e-50, -2.22038938752476096905e-50, -2.05746365799511960779e-51, 1.01526435631863053043e-51, 9.08935043538678168167e-53, -4.57029362137222951803e-53, -3.95787500445858542801e-54, 2.02711038174221047968e-54, 1.69996158980940256995e-55, -8.86554069509966135111e-56, -7.20707933472636460157e-57, 3.82586260630161285682e-57, 3.01784162929121536671e-58, -1.63015753797271547785e-58, -1.24883430461962041017e-59, 6.86223655972800456185e-60, 5.1100014774260206368e-61, -2.85548233732786257727e-61, -2.06854791174038037444e-62, 1.17515818472977441346e-62, 8.28789753139286006469e-64, -4.78549281665923423421e-64, -3.28813694013034338769e-65, 1.9291556972251258531e-65, 1.29229726580791070773e-66, -7.70198141283698820458e-67, -5.03327914993007200427e-68, 3.0465274037612323849e-68, 1.94345472880897314618e-69, -1.19436619100924522972e-69, -7.44186758630076264678e-71, 4.64250507988013808191e-71, 2.82692372802416953582e-72, -1.78975473839632086943e-72, -1.06562246385826146753e-73, 6.84536242039407894682e-74, 3.98726214072331755941e-75, -2.59829884783870664445e-75, -1.48131177183134965761e-76},
            {1.08515215348745349131e-20, -3.20952687773688036836e-20, -2.75047723050059078486e-20, 8.12982619114777518489e-20, 1.2731163188127728576e-20, -7.22817461884741157233e-20, 2.22421666498705493157e-21, 3.53977482855960896687e-20, -4.00785462828892638025e-21, -1.15815410743763766712e-20, 1.85056617125909696928e-21, 2.8162930796478093635e-21, -5.36816708187523497027e-22, -5.44177366151295456477e-22, 1.16135293346340177576e-22, 8.7431044689473195615e-23, -2.02567555408597168795e-23, -1.20666087294752633582e-23, 2.98295408182183064411e-24, 1.46569374970061915877e-24, -3.824765730720090635e-25, -1.59643762495079093143e-25, 4.3663113829120258186e-26, 1.58236581297883445487e-26, -4.51322362156641163636e-27, -1.44428065394503980419e-27, 4.27992302211492565016e-28, 1.22572222959018686399e-28, -3.76306952658622350992e-29, -9.75026629165478753882e-30, 3.09420637741164580541e-30, 7.31902119690787341156e-31, -2.39643526656949804507e-31, -5.21417735700514741386e-32, 1.75876225887893599016e-32, 3.54276205027903083124e-33, -1.2294166265226391299e-33, -2.3054623145379023712e-34, 8.2215444029234630815e-35, 1.44221886676708678077e-35, -5.27990863615038413683e-36, -8.70081283962357881188e-37, 3.26710922579349740142e-37, 5.07663190356342995234e-38, -1.95359783343566783236e-38, -2.87190113973571426104e-39, 1.13178353401050732571e-39, 1.57874527253956108121e-40, -6.36715769971858538738e-41, -8.45028580173005645783e-42, 3.48555859275461493064e-42, 4.41191195625565607538e-43, -1.86012621858564762277e-43, -2.25050960224193382503e-44, 9.69337421908127988574e-45, 1.12323079484373091902e-45, -4.93992460452021910543e-46, -5.49247484141410389341e-47, 2.46529169551214844644e-47, 2.63453116403769224696e-48, -1.20630135529229247347e-48, -1.24095051290928070317e-49, 5.79392572278885477954e-50, 5.74593487032818857739e-51, -2.73443942158101817059e-51, -2.61773292539139312432e-52, 1.26926938972850301923e-52, 1.17440945586843843973e-53, -5.7997383520189932603e-54, -5.19260994705417512275e-55, 2.61084835113742995809e-55, 2.26433328916493782391e-56, -1.15876848527354051607e-56, -9.74488497022036089322e-58, 5.07402749929391388813e-58, 4.14158867568397750574e-59, -2.19345081874136357163e-59, -1.73925868468027466038e-60, 9.36656362125494223538e-61, 7.22111271007550967077e-62, -3.95321699895368877561e-62, -2.96556042577839065588e-63, 1.64992267251834537686e-63, 1.20525164932777677629e-64, -6.8128528433969707827e-65, -4.84963919386823218321e-66, 2.78447551711302254098e-66, 1.93277919357314764964e-67, -1.12691454158832077102e-67, -7.63247675314069453774e-69, 4.51798385178363419953e-69, 2.9875715691912879862e-70, -1.79501067105332750855e-70, -1.15955271462227754051e-71, 7.06986414739519660233e-72, 4.46398937587169894763e-73, -2.76134687864423971314e-73, -1.70509828272386234541e-74, 1.06987433672550821942e-74, 6.46390591344588941503e-76, -4.11315413315339690554e-76},
            {1.44911748660360819307e-21, 3.74715496482943943683e-21, -1.01962703066234638607e-20, -4.24013992502634714316e-21, 1.51090606581258603101e-20, 9.4041890337095112837e-22, -1.0358872826052367378e-20, 6.77499341848485802867e-22, 4.35760324704796781106e-21, -5.65021970110836321287e-22, -1.29511805502198591131e-21, 2.18735225128419008885e-22, 2.95748568560486661129e-22, -5.80176390173193333047e-23, -5.48271601313586092904e-23, 1.1897788471381850136e-23, 8.57576707362372395861e-24, -2.00712555465149173755e-24, -1.164221623926077091e-24, 2.89550481652017908954e-25, 1.40155477106883819231e-25, -3.66924923637341503382e-26, -1.52150558940272543737e-26, 4.16605257375358827275e-27, 1.50949065002617036391e-27, -4.30292730059910103666e-28, -1.38354933942036142675e-28, 4.0917974233825399505e-29, 1.1820975019146690578e-29, -3.61741869018976050963e-30, -9.48535355786555500662e-31, 2.99707766865199960838e-31, 7.19347210623619835524e-32, -2.3427256337109967826e-32, -5.18380734781630765441e-33, 1.73752806278466572427e-33, 3.56614154004608644374e-34, -1.22867092920108061871e-34, -2.35144380451155453386e-35, 8.3186078600698508311e-36, 1.49136006030337262244e-36, -5.41200933222887888522e-37, -9.12605233500114916182e-38, 3.39425703891265703568e-38, 5.40282405050615141083e-39, -2.05793015912538779571e-39, -3.10204965758191349568e-40, 1.20920269083217044511e-40, 1.73103680721058848844e-41, -6.90104864964239814309e-42, -9.40666846860528678279e-43, 3.83303224556533756654e-43, 4.98649702837886675279e-44, -2.07566845297112715819e-44, -2.58267950319419734725e-45, 1.09764710676214191189e-45, 1.30882552659115351975e-46, -5.67664699687640569004e-47, -6.49821649992574592688e-48, 2.87490030339512337175e-48, 3.16463132472684460256e-49, -1.42751896108649678195e-49, -1.51335241149948110525e-50, 6.95745836155787041334e-51, 7.11340468856356827261e-52, -3.33173506109338808453e-52, -3.28952481367831837215e-53, 1.56908796423540500644e-53, 1.49786825395793513156e-54, -7.27369615689773273416e-55, -6.7210561676718472198e-56, 3.32154041853004873941e-56, 2.9739824532863141522e-57, -1.4952721659671678102e-57, -1.29857504463335415105e-58, 6.64039473862055469031e-59, 5.59878422744068348032e-60, -2.91095928061609847448e-60, -2.38489926461523939795e-61, 1.26038600389791803213e-61, 1.00422405722428780571e-62, -5.39306363194290197753e-63, -4.18210229490825553645e-64, 2.28168457435613090095e-64, 1.72332496437625307514e-65, -9.54933029736907422313e-66, -7.02975710037056210362e-67, 3.95533660799363444021e-67, 2.8398429390866296566e-68, -1.62207562004422368749e-68, -1.13657614045320738605e-69, 6.58883514885216937952e-70, 4.50829441721872120684e-71, -2.65190914752534752241e-71, -1.77290547954770652184e-72, 1.05797212497111989432e-72, 6.91448718328656553112e-74, -4.18504193411622483027e-74, -2.67527878524725356224e-75, 1.64199477729814515171e-75, 1.02716226537774653883e-76},
            {-2.64663397544589903347e-22, 8.18219222136450803633e-22, 8.33699894435434850867e-22, -2.42491096982266893865e-21, -5.26550169948519530551e-22, 2.49380271738297733173e-21, 7.04817051445010658171e-24, -1.39873684473144645787e-21, 1.26872926044798566589e-22, 5.19646133187833853303e-22, -7.41810531908798243723e-23, -1.42397458936530614618e-22, 2.51403542081153406461e-23, 3.07979726663804533668e-23, -6.19099556717878294949e-24, -5.50543071393127957837e-24, 1.21234621042220853173e-24, 8.40826728391055676832e-25, -1.98587388975315796316e-25, -1.12470444591943805556e-25, 2.81263842600813030023e-26, 1.3430574029912946762e-26, -3.5265399207872529378e-27, -1.45358358891408998006e-27, 3.98419194499916938312e-28, 1.44333233556815482173e-28, -4.11217162765638529252e-29, -1.32803546511401091679e-29, 3.92036837945739588371e-30, 1.14175552085418717672e-30, -3.48348681617769237163e-31, -9.23606295121684727093e-32, 2.90653948148661618449e-32, 7.07173718436669130633e-33, -2.29161644230121428409e-33, -5.15109333562212486318e-34, 1.7164607714560014028e-34, 3.58522604761946894977e-35, -1.22701069945696117194e-35, -2.39354083752393136934e-36, 8.40457542273906209597e-37, 1.53790881941686032171e-37, -5.53538033389000148076e-38, -9.53831900274542779936e-39, 3.51618825919382838239e-39, 5.72538794825303787166e-40, -2.16005542788864076073e-40, -3.33384866573891116291e-41, 1.28638435552797034918e-41, 1.88714027919550506445e-42, -7.44257822781236029455e-43, -1.04039258987164010027e-43, 4.19141761495357869231e-44, 5.59580559025409425238e-45, -2.30164644468152060961e-45, -2.94081784987148074808e-46, 1.23435390452906996608e-46, 1.51223927189630013237e-47, -6.47417493297097617622e-48, -7.61855689286092219134e-49, 3.32535254899063360408e-49, 3.76469766564377089763e-50, -1.67461700114601056158e-50, -1.82665206817434839593e-51, 8.27733475270890439439e-52, 8.71114904362962087441e-53, -4.01973029394351590711e-53, -4.08677634721856375401e-54, 1.91970467779297332046e-54, 1.88770404709301881791e-55, -9.02343637928741263341e-56, -8.59150486504935199523e-57, 4.17782980394470217588e-57, 3.85564565721384781885e-58, -1.90672044436532239647e-58, -1.70728358540475162918e-59, 8.58369911101007487328e-60, 7.46385140222176774545e-61, -3.8140498991471258785e-61, -3.22343524541129419117e-62, 1.67369894557608318154e-62, 1.37596328591734580304e-63, -7.25746836919401632852e-64, -5.80824339845329740139e-65, 3.11122995773214415433e-65, 2.42570013525132359008e-66, -1.31924792339971812332e-66, -1.00270997602318034789e-67, 5.53558254600445160559e-68, 4.10430272941436000519e-69, -2.29946194033525100728e-69, -1.66417287746715758129e-70, 9.45992190722932655977e-71, 6.6866990617509178077e-72, -3.85575726233088274655e-72, -2.66335802615482524162e-73, 1.55756330835867685531e-73, 1.0519460408657410612e-74, -6.2379243459664918636e-75, -4.12133007713293364344e-76, 2.47758974555301677733e-76},
            {-3.38976534885101047219e-23, -1.01119894799491099724e-22, 2.80596840793765977187e-22, 1.43008800532412615359e-22, -4.80947666923859913977e-22, -5.14644345493038239606e-23, 3.77658948077490543625e-22, -1.4287540403620026442e-23, -1.80391443378062323361e-22, 1.98496888898480901465e-23, 6.04172075773565607735e-23, -9.27150710607538626829e-24, -1.54429834369993416168e-23, 2.82762087901350414662e-24, 3.18528491306024032749e-24, -6.53910314768329715936e-25, -5.51342097616420793809e-25, 1.22997990193010785529e-25, 8.24247686795245317859e-26, -1.96273383295683955485e-26, -1.08787649642294868772e-26, 2.73422001196700402887e-27, 1.28953629816521411089e-27, -3.3952428562761115877e-28, -1.39178475215500643524e-28, 3.81844508282378510355e-29, 1.38305407724016279763e-29, -3.93850334326545999419e-30, -1.27713510404118365625e-30, 3.76363753460381304668e-31, 1.10436924145264302368e-31, -3.36001090655289432072e-32, -9.00131118752960279134e-33, 2.82201483014330545945e-33, 6.95397600308986856529e-34, -2.24299257133230881513e-34, -5.11662974510264211545e-35, 1.69566535327889706047e-35, 3.60056928844671390274e-36, -1.22458942951768340906e-36, -2.43209294727780625162e-37, 8.48062247513165848151e-38, 1.58199833745534881072e-38, -5.65063401590027664216e-39, -9.93763765303920144866e-40, 3.63307099123344918384e-40, 6.04379136688954037962e-41, -2.25989889793957226796e-41, -3.56669512767950457181e-42, 1.36317385525149047715e-42, 2.04660085179035488296e-43, -7.99032190746288309242e-44, -1.14394254280765841074e-44, 4.55975129649130647571e-45, 6.23873501008449844414e-46, -2.53755981578775048217e-46, -3.32476605635486557673e-47, 1.37928950560207021156e-47, 1.73376587576106415012e-48, -7.33270376415764343311e-49, -8.8577957933075580977e-50, 3.81763959035012830163e-50, 4.43876452566366660211e-51, -1.94873763043454510872e-51, -2.18400951022428351923e-52, 9.76345151032290576833e-53, 1.056139773159768833e-53, -4.80586606799447319591e-54, -5.0239894853347057968e-55, 2.32622502655926821737e-55, 2.35284497518565825355e-56, -1.10817206059651710842e-56, -1.08563965576692772156e-57, 5.19965896715085323914e-58, 4.93892751492088864157e-59, -2.40473509258661199146e-59, -2.2167638664598650204e-60, 1.09691988758306547486e-60, 9.82226768351755787109e-62, -4.93819817350295133452e-62, -4.29890243757319324464e-63, 2.19533384213542874481e-63, 1.85946763656197706807e-64, -9.64288691816770972308e-65, -7.95283115771683948461e-66, 4.18705729688460870106e-66, 3.36480819096921519598e-67, -1.79809699485739682714e-67, -1.40894849411181529893e-68, 7.64036432902086508627e-69, 5.84124679990972311032e-70, -3.21361951790024773884e-70, -2.39861447772236494502e-71, 1.33852420025894383039e-71, 9.75930476726732392107e-73, -5.52295388336288359957e-73, -3.93578097289625119898e-74, 2.25830657756909156748e-74, 1.5737593280251902327e-75, -9.15387699708253467591e-76, -6.24130037170979042884e-77},
            {6.46404773360331088903e-24, -2.08400836663804969794e-23, -2.47517036495766118083e-23, 7.14405022486370163998e-23, 2.00395357383226843341e-23, -8.4146821322305585317e-23, -3.19113260024411559308e-24, 5.35910919319442446059e-23, -3.61011631724826333608e-24, -2.24360983045886432581e-23, 2.81180643859243612296e-24, 6.88175389234983923507e-24, -1.11762187366161304892e-24, -1.6560101935273397989e-24, 3.12623615636553274014e-25, 3.2758787762885479526e-25, -6.84952253187173687643e-26, -5.50956013454646737667e-26, 1.2434649675888442207e-26, 8.0797193368282661157e-27, -1.93833377982373674647e-27, -1.0535203709148168333e-27, 2.66007044221029860146e-28, 1.2404235456872205895e-28, -3.27414885046356005801e-29, -1.33536255733532959771e-29, 3.66688242304025595409e-30, 1.32794949810117770093e-30, -3.77985421940779471655e-31, -1.23033178092867392559e-31, 3.61990558199362109872e-32, 1.06965183342526844841e-32, -3.24589782604187665541e-33, -8.78008641238933007183e-34, 2.74298727255690060472e-34, 6.8402689430549910509e-35, -2.1967363347262941009e-35, -5.08090944682666258955e-36, 1.67522263463395778312e-36, 3.61265795882114456475e-37, -1.22153882957902605037e-37, -2.46741385258287825121e-38, 8.54780782622810179735e-39, 1.62376254489977402981e-39, -5.75835376822490882347e-40, -1.03241422819014960331e-40, 3.74509063833629815164e-41, 6.35761041326426279113e-42, -2.35741503728770384044e-42, -3.80005463197148121505e-43, 1.43943977486531766225e-43, 2.20899249645616796556e-44, -8.54298152207264989719e-45, -1.25105667576230260578e-45, 4.93711042596769488534e-46, 6.9141023559209936662e-47, -2.78290079695294832938e-47, -3.73426496317767663102e-48, 1.53226111178040452991e-48, 1.97362028285897846209e-49, -8.25218810824122539487e-50, -1.02197549291142244314e-50, 4.35258275689752494412e-51, 5.19064329220413271413e-52, -2.25092880271522292002e-52, -2.58852294535709920874e-53, 1.14253204197322859871e-53, 1.26865729178743764418e-54, -5.69752440275236014635e-55, -6.11614874186192331162e-56, 2.79384505641546113437e-56, 2.90271823080388101681e-57, -1.34826424216314958152e-57, -1.35722252134165534023e-58, 6.40820661101611349305e-59, 6.25633091223686042892e-60, -3.00189463054619479698e-60, -2.84507063936370641783e-61, 1.38688080425880117894e-61, 1.27712751461060382865e-62, -6.32317907991596969234e-63, -5.66225158295265165556e-64, 2.8466540563497666822e-64, 2.48077704017904595064e-65, -1.2661082465662151692e-65, -1.07459656815038066206e-66, 5.56625648359315490505e-67, 4.60430913725664840392e-68, -2.42001229709916849702e-68, -1.95224694108388623846e-69, 1.04094365486617751792e-69, 8.19473593449975079359e-71, -4.43173740586948134856e-71, -3.4066963060275327003e-72, 1.86822535880973184793e-72, 1.4031006969688492338e-73, -7.80107587932271605085e-74, -5.72731511419246949408e-75, 3.22776767489692674131e-75, 2.3177242759665004245e-76, -1.32378280437302265487e-76},
            {7.97583448960241242421e-25, 2.7084913877293595487e-24, -7.67323913040916102072e-24, -4.66143923942756123213e-24, 1.50633198663386541617e-23, 2.31614651616378475215e-24, -1.34308539039317057469e-23, 1.22836083758051719083e-25, 7.22940945370078504982e-24, -6.49184347511916569295e-25, -2.71022159464147989628e-24, 3.73336901381128114991e-25, 7.70760299950379140972e-25, -1.31038315573120572419e-25, -1.75926823171051649306e-25, 3.40885057690457385682e-26, 3.35334956337210915642e-26, -7.12568409026415895637e-27, -5.49620414147206744414e-27, 1.25346604315570537349e-27, 7.92091241835954878367e-28, -1.91315926193993125549e-28, -1.02143519132515571999e-28, 2.58998614176361082226e-29, 1.19523191860260982511e-29, -3.1622061084292598243e-30, -1.28368451483113844423e-30, 3.52786393811394166634e-31, 1.27741855279137626101e-31, -3.6344694980079970338e-32, -1.18718147932014362361e-32, 3.48771927503124687699e-33, 1.03735095020451714552e-33, -3.14019735316788374905e-34, -8.57144812000100730452e-35, 2.66899395992804851336e-35, 6.73063683511729501059e-36, -2.15273028974050948624e-36, -5.04434092768730185522e-37, 1.65519404798233159711e-37, 3.62191984039634844529e-38, -1.21797195563971813985e-38, -2.49979246109878791996e-39, 8.60708419871620078919e-40, 1.66333403430635213867e-40, -5.8590919155489444378e-41, -1.06980530781224570177e-41, 3.85244403836761457929e-42, 6.66651559510058618098e-43, -2.45258277718385625166e-43, -4.03345666945515113712e-44, 1.51507163058797227097e-44, 2.37391865511933222849e-45, -9.09938070094119891249e-46, -1.36148064909802282686e-46, 5.32261708911420011438e-47, 7.62066664707740675441e-48, -3.03716044429173785306e-48, -4.16896827650828660325e-49, 1.69305610946882579508e-49, 2.2319440085929707431e-50, -9.23236642534319907002e-51, -1.17077843146382104552e-51, 4.93084138752361600178e-52, 6.02390833580016297342e-53, -2.58214314697980690137e-53, -3.04321125671974239832e-54, 1.32720262000298947611e-54, 1.5109152632673714255e-55, -6.70198680925670161849e-56, -7.37863807064838396742e-57, 3.32782196081906767344e-57, 3.54720997244479550033e-58, -1.62614614655341554823e-58, -1.67994070791545326332e-59, 7.82581527022402700574e-60, 7.84326263913476102595e-61, -3.7117166813883412845e-61, -3.61222115552209058201e-62, 1.73611772754010546539e-62, 1.64205295905626898011e-63, -8.01323111096697467532e-64, -7.37188930334686864591e-65, 3.65180925185163902869e-65, 3.27022288949467695305e-66, -1.64404019633396824857e-66, -1.43415703127142270655e-67, 7.31540339743312809755e-68, 6.22067821597223503886e-69, -3.2187699711139325594e-69, -2.66986520137590646226e-70, 1.40106903835191346761e-70, 1.13430369596990811021e-71, -6.035704249152021301e-72, -4.77227459277676498657e-73, 2.57433882156824021312e-73, 1.98900461928684156628e-74, -1.08751119371187882983e-74, -8.21504493370348483795e-76, 4.5518097529649876241e-76, 3.36348331764594763008e-77},
            {-1.58091787902874833559e-25, 5.30408234820909747976e-25, 7.2287848066788882804e-25, -2.08248661746617338641e-24, -7.21695070571750187276e-25, 2.78520011832685142217e-24, 2.07450174994317365968e-25, -1.99891505632279770963e-24, 8.63130563211877126441e-26, 9.36712532710188904244e-25, -1.00642292899078925775e-25, -3.19670170486332362615e-25, 4.73359165381887572258e-26, 8.51258821795411206322e-26, -1.50313221485274660917e-26, -1.85438685532098202198e-26, 3.67505241035775654229e-27, 3.41929750736741523022e-27, -7.37089149348156061753e-28, -5.47528508181535630208e-28, 1.26054506442772052709e-28, 7.76667311376270478335e-29, -1.88758501607427419773e-29, -9.91436614509077274284e-30, 2.52375233478057262405e-30, 1.15354138429526265726e-30, -3.05849660409834373536e-31, -1.23621150270133186549e-31, 3.39998759491070690805e-32, 1.23094853846558670651e-32, -3.50085155710118107143e-33, -1.14730059008794523007e-33, 3.36582918713344284202e-34, 1.00724390350242251735e-34, -3.04208010258918975e-35, -8.37452509438557443715e-36, 2.59961946208115674598e-36, 6.62505605710083423381e-37, -2.11085916738415263223e-37, -5.00726245216085038519e-38, 1.63562544175910465515e-38, 3.62873099191759536769e-39, -1.21398587972245706667e-39, -2.52949415355343873622e-40, 8.65930819618985252184e-41, 1.70084254007016021709e-41, -5.95336880527199144853e-42, -1.10596572084618019592e-42, 3.95533478732295894093e-43, 6.9702592214086713199e-44, -2.54540138566303232432e-44, -4.26648974883197958116e-45, 1.58997766711943102674e-45, 2.54101227135806103631e-46, -9.65845916330040368289e-47, -1.47496773814401421053e-47, 5.71544121317073823447e-48, 8.35714838839218743048e-49, -3.29983383664861119752e-49, -4.62845531735869508938e-50, 1.86144631995152537292e-50, 2.50881092456533081183e-51, -1.02727852162658025941e-51, -1.33247741990049687891e-52, 5.55292185250483158345e-53, 6.94188742892291468741e-54, -2.94323817124357917817e-54, -3.55099900583575772813e-55, 1.53121933980967628262e-55, 1.78515437193106063728e-56, -7.82639721499399530452e-57, -8.82715845677506714368e-58, 3.93344600423998364787e-58, 4.29662254789436203292e-59, -1.9454434856898099122e-59, -2.0602118453026791635e-60, 9.4759112367972245944e-61, 9.7380155575134700022e-62, -4.54863308112509395608e-62, -4.54023859646894648879e-63, 2.153172457497918969e-63, 2.08926816661673927061e-64, -1.00571921343043997296e-64, -9.49419548562970728305e-66, 4.63788444313305990318e-66, 4.26281698235054214621e-67, -2.11270171113611222443e-67, -1.89200351269201618693e-68, 9.51146148878339895946e-69, 8.30488023469463991716e-70, -4.23399058682086267077e-70, -3.60677212082597509698e-71, 1.86439058241443091177e-71, 1.55043944143208263389e-72, -8.12434000274337497292e-73, -6.59946233127431303097e-74, 3.50487941920391686829e-74, 2.7825152194802126064e-75, -1.49744914127139250094e-75, -1.1624942342094289044e-76, 6.33835517072113649438e-77},
            {-1.88614997296228681931e-26, -7.21086113020815007147e-26, 2.08697473517622979457e-25, 1.47993689585553746531e-25, -4.65200450798127123315e-25, -9.41694436622274090746e-26, 4.67418714678930067876e-25, 9.64945466174515803197e-27, -2.8161939291610205203e-25, 1.94078807609356428548e-26, 1.17465008767068249625e-25, -1.42965625944066589947e-26, -3.69673820240895168263e-26, 5.79704901128067892311e-27, 9.29191689358035172653e-27, -1.69404484503070632005e-27, -1.94177778705024550251e-27, 3.92487558138958888663e-28, 3.47515400128151385983e-28, -7.58825298035479000295e-29, -5.44838814338310432539e-29, 1.26517689196377540197e-29, 7.6173955403553027647e-30, -1.86189956805658828666e-30, -9.63356220720720430359e-31, 2.4611518224261220647e-31, 1.11498817646661074506e-31, -2.96221635630038961916e-32, -1.19248139663853712193e-32, 3.28204833478235725058e-33, 1.18809899469236569623e-33, -3.37771518115150397383e-34, -1.11035615655493344316e-34, 3.25315578211014698334e-35, 9.7913359131555476986e-36, -2.95081934009012747592e-36, -8.18851217402441472649e-37, 2.5344903118405912927e-37, 6.52347015588628029709e-38, -2.07101116629568084422e-38, -4.96995376155955141415e-39, 1.6165501444545692066e-39, 3.63342209772277352951e-40, -1.20966396827398939348e-40, -2.55676222348908782634e-41, 8.70524961970401091389e-42, 1.73641385266474627743e-42, -6.0416727450736307381e-43, -1.14092928419394091971e-43, 4.0539695409056208621e-44, 7.26866410873206866143e-45, -2.63588689992361789836e-45, -4.498796510604842977e-46, 1.66408280000453709534e-46, 2.70993533786157783293e-47, -1.02192662720938154774e-47, -1.59128030197079689544e-48, 6.11480221448165137349e-49, 9.12224652526837642076e-50, -3.57042435613213907882e-50, -5.11224295081146612626e-51, 2.03719182314096890585e-51, 2.8042331908035241428e-52, -1.1372822446604961878e-52, -1.5073171518620337387e-53, 6.21918740061574096175e-54, 7.94765618008714310488e-55, -3.33497759347876790768e-55, -4.11470388099195980942e-56, 1.75539617549486813795e-56, 2.0935965262243451275e-57, -9.07772945876935606854e-58, -1.04776474416863591385e-58, 4.61601406799211566649e-59, 5.16162989259561320596e-60, -2.30986487211511649354e-60, -2.50481068273541518268e-61, 1.1382918530728375845e-61, 1.19817287960694503783e-62, -5.52795851994035408231e-63, -5.65318142928300895314e-64, 2.64726177166791988888e-64, 2.6323884681600470732e-65, -1.25086063847337036336e-65, -1.21040115824285329259e-66, 5.83503508378322745266e-67, 5.49863520876117204328e-68, -2.68861174325468802391e-68, -2.46909100943130512192e-69, 1.22426819127748826168e-69, 1.09641208543643057636e-70, -5.5117560982974938978e-71, -4.81672080781109292402e-72, 2.45447024300536718087e-72, 2.09433368163823834873e-73, -1.08157966863079824868e-73, -9.0161888631217664951e-75, 4.7180316323176556228e-75, 3.84449871205682899528e-76, -2.0380937221210609511e-76, -1.62421855813166191692e-77},
            {3.8715536638418473304e-27, -1.34915538435635057427e-26, -2.08318258853112348565e-26, 6.01471289920810826105e-26, 2.49705854273542771194e-26, -9.06509022407621949821e-26, -1.01949248728853987079e-26, 7.2822792511638510424e-26, -1.32155620651287633536e-27, -3.79684876822846867474e-26, 3.38169183961494890363e-27, 1.43388633305559337993e-26, -1.91434805118022453605e-27, -4.20482703871110866009e-27, 6.9094569521255018037e-28, 1.0042325524946724215e-27, -1.88170864304215910578e-28, -2.02190778256378988208e-28, 4.15866702660341942657e-29, 3.52219031491433006894e-29, -7.78064691287545044571e-30, -5.41681460647488196601e-30, 1.26776282225200511562e-30, 7.47330886377286152036e-31, -1.83632416090688383647e-31, -9.37040568505272868578e-32, 2.40197070658392857891e-32, 1.07925589029103965783e-32, -2.87265893215245144913e-33, -1.15209599485320309937e-33, 3.17300517017262494542e-34, 1.14848960031540590484e-34, -3.26395175968321840106e-35, -1.07605792661749857536e-35, 3.14876196495857376122e-36, 9.52845052977386440901e-37, -2.86577592601802233611e-37, -8.01266637329062307198e-38, 2.47327020116718643887e-38, 6.42579880282447051527e-39, -2.03307878574123517577e-39, -4.93264575690849254915e-40, 1.59799143414694657766e-40, 3.63628405118448046413e-41, -1.20507782618930013047e-41, -2.58181938497222880847e-42, 8.74560007341757395814e-43, 1.77016907123423560877e-43, -6.12446054672450415556e-44, -1.17473359333043533922e-44, 4.14855511788638113049e-45, 7.56161352893581688255e-46, -2.72406905681114169719e-46, -4.73006895335839039929e-47, 1.73732671423523189811e-47, 2.88037808195117983497e-48, -1.07809541604882275988e-48, -1.71019086372708147848e-49, 6.51996964036377782837e-50, 9.91465299551314642668e-51, -3.84844715445323111467e-51, -5.6197966167214059589e-52, 2.22004436316462741813e-52, 3.11816719900347989582e-53, -1.25317099049851192886e-53, -1.69549998508525719571e-54, 6.9298685251594051037e-55, 9.0440360050893985306e-56, -3.75803361075677282761e-56, -4.73702648357831624809e-57, 2.00049693100683276235e-57, 2.43843431370155267222e-58, -1.04627593124757644503e-58, -1.23462016016832445169e-59, 5.38080503957246103321e-60, 6.15323189940659568108e-61, -2.72318521976247823355e-61, -3.02084798737266142871e-62, 1.35721685439986000204e-62, 1.46183277363277807273e-63, -6.66585353434503201466e-64, -6.97715892974945810109e-65, 3.22827111052418565243e-65, 3.28642253874423197019e-66, -1.54258024386533861462e-66, -1.52850950449603489526e-67, 7.27660707867665902768e-68, 7.02319220460460123569e-69, -3.39030440905642336281e-69, -3.18956243036052531304e-70, 1.5609494004652409109e-70, 1.43236626850463207761e-71, -7.10523858174987919874e-72, -6.36338961047254641715e-73, 3.1988665295639052118e-73, 2.79775072601111784575e-74, -1.42501198724031733876e-74, -1.21781292535456724537e-75, 6.28367041517689062941e-76, 5.24999937981951326681e-77, -2.74371642238515729734e-77},
            {4.48011750023456073049e-28, 1.91018857001353847479e-27, -5.64949314062241667783e-27, -4.6007813176613787285e-27, 1.4191080521561444186e-26, 3.58938038658895392967e-27, -1.59602135390782693624e-26, -8.22255995851141423132e-28, 1.06989002292585882011e-26, -5.06842974637308247004e-28, -4.93833718120664513201e-27, 5.19952246735709607465e-28, 1.71145237154370551725e-27, -2.45503400507790090997e-28, -4.71627242395505548997e-28, 8.05793714088414191484e-29, 1.07617672297750106627e-28, -2.06505815034372959376e-29, -2.09526881162361001255e-29, 4.37698644929257043145e-30, 3.56152990729325730782e-30, -7.95070934594388479042e-31, -5.38163323302049515556e-31, 1.26864212483961726278e-31, 7.33452057890749636221e-32, -1.81102739117598838429e-32, -9.12350093215670147176e-33, 2.34600202014130292738e-33, 1.04606818508018535683e-33, -2.78920161533420860183e-34, -1.11471049442377631941e-34, 3.07195459734891143607e-35, 1.11179040046153315803e-35, -3.15860041722767535041e-36, -1.0441518369913485192e-36, 3.05183072626704082516e-37, 9.28222546659188877693e-38, -2.78638578691550477579e-38, -7.84630271274676807699e-39, 2.41565575967225849959e-39, 6.33194469553813132732e-40, -1.9969593259537676755e-40, -4.89552852811269238957e-41, 1.57996453274530006327e-41, 3.63757285264113831174e-42, -1.20028895608896703975e-42, -2.60486928793576795939e-43, 8.7809808444333108294e-44, 1.80222411804109482307e-44, -6.20215849139305132833e-45, -1.20741893445910624415e-45, 4.23929625808130849567e-46, 7.84904231444385655442e-47, -2.80998866344405046515e-47, -4.96004385079828406117e-48, 1.80966212238718760995e-48, 3.05205788868182187952e-49, -1.13427706718240887571e-49, -1.83148286359241898413e-50, 6.93026300973998390799e-51, 1.07330650753891747583e-51, -4.13343190393749672416e-52, -6.15054042384082988937e-53, 2.40975035266279604714e-53, 3.45051941936231184516e-54, -1.37485542916163148812e-54, -1.89718819803156168417e-55, 7.6850735918296333086e-56, 1.02335951642389241906e-56, -4.21298993194980321258e-57, -5.42054231214681016226e-58, 2.26723424705154600933e-58, 2.82182159947390285021e-59, -1.19880409008075610719e-59, -1.44490027998399661392e-60, 6.23305719872755429529e-61, 7.2827084780967103324e-62, -3.1892295956079250665e-62, -3.61574766685071388578e-63, 1.60698068787084403337e-63, 1.76944457487858648047e-64, -7.97928268621159100609e-65, -8.54033333360574133429e-66, 3.90674402457677729716e-66, 4.06780755228783480191e-67, -1.8871942500885508296e-67, -1.91305358818024764209e-68, 8.99924090551836208636e-69, 8.88780347055869340075e-70, -4.23843544985029015168e-70, -4.08102078208672687766e-71, 1.97253782838717166196e-71, 1.85286932775524145676e-72, -9.0753358546978405789e-73, -8.32158304178828695108e-74, 4.1295620794644102142e-74, 3.69850016514228629264e-75, -1.85919606224901032696e-75, -1.62730056678086810651e-76, 8.28500269825067533661e-77, 7.09067356879919713096e-78},
            {-9.49303387191183612642e-29, 3.43004940680646726868e-28, 5.93719612571482607554e-28, -1.7232026347610325083e-27, -8.37823012455972248918e-28, 2.90703889461782763386e-27, 4.41350778043701293106e-28, -2.59830434139137142027e-27, -2.00828187060807408553e-29, 1.4991380728663029865e-27, -1.05199074217388873668e-28, -6.23457649633778438425e-28, 7.39732978673569201384e-29, 2.00441578018089858324e-28, -3.0457512994812439272e-29, -5.2271440830335766076e-29, 9.23111882149218682747e-30, 1.14491474349432975686e-29, -2.24331528672518712571e-30, -2.16235744371376336546e-30, 4.58053141161875975654e-31, 3.59416219491011640746e-31, -8.10083537282592089761e-32, -5.34372213606117592104e-32, 1.26810181531094186115e-32, 7.20104895002368223307e-33, -1.78613657377825755482e-33, -8.89157957318157553306e-34, 2.29304792295935525256e-34, 1.01518277170736771946e-34, -2.71129377587276406443e-35, -1.08002496044834649638e-35, 2.9781089648146653304e-36, 1.07771386032321329304e-36, -3.06082456945826410053e-37, -1.01441464027754213062e-37, 2.96164682020099595502e-38, 9.0512706293471646031e-39, -2.71214944118474704078e-39, -7.68878998743915946889e-40, 2.3613728486033568094e-40, 6.2417988733436827967e-41, -1.96255514964779828883e-41, -4.85875802459923474497e-42, 1.56247821923679463144e-42, 3.63751389851030454329e-43, -1.19535017541465314195e-43, -2.62609800057416674219e-44, 8.81195007112740680722e-45, 1.83268945408971483487e-45, -6.275163576962580012e-46, -1.23902739392292307038e-46, 4.32639391266500893803e-47, 8.13092902684432994314e-48, -2.89369535407041954748e-48, -5.18849841075909719519e-49, 1.88105318020444243796e-49, 3.22471804196808056849e-50, -1.19040522948999759994e-50, -1.95495113873159968812e-51, 7.34505102619307161122e-52, 1.15761957263004191132e-52, -4.42492492622424929318e-53, -6.70386630047534872773e-54, 2.60605349842466673569e-54, 3.80115206819895037436e-55, -1.50223569054941543717e-55, -2.1125064303321779222e-56, 8.48479951639834809063e-57, 1.15186524133119715948e-57, -4.70034541533592064114e-58, -6.16769578170724480117e-59, 2.55626922615377615461e-59, 3.24586527182119239341e-60, -1.36598873239705809518e-60, -1.6802248845894553124e-61, 7.17794769388220130035e-62, 8.56157393972151180811e-63, -3.71185769053723392082e-63, -4.29722253899085288115e-64, 1.89026987732826195566e-64, 2.125932976258286325e-65, -9.48596876045223753451e-66, -1.03729092583339787449e-66, 4.69386774337913591878e-67, 4.99443633199914652275e-68, -2.29150437557396212629e-68, -2.37431321284925095134e-69, 1.10429593188773527762e-69, 1.11499317796298073622e-70, -5.25588092384303872667e-71, -5.17479933680213863994e-72, 2.47177146914181710154e-72, 2.37462316085315759783e-73, -1.14913090974507826444e-73, -1.07784861955575200528e-74, 5.28340350929733938044e-75, 4.84121918617308261688e-76, -2.40334258260478644222e-76, -2.15252590481404198618e-77, 1.08203260707795683713e-77},
            {-1.0682813809077381224e-29, -5.03905101404463318166e-29, 1.52303263173323580279e-28, 1.40580987291063852716e-28, -4.28225426395723767614e-28, -1.30695446753649432551e-28, 5.35845592290308079096e-28, 4.47194358086730831108e-29, -3.97498731441822761573e-28, 1.00033308378103358781e-29, 2.02046460529465234675e-28, -1.78736418512942130202e-29, -7.67684494934603413613e-29, 9.96936950650534132995e-30, 2.30997528921938360184e-29, -3.6803666388283629637e-30, -5.7342110469623417957e-30, 1.04191337492248269193e-30, 1.21041052194415205222e-30, -2.41593671569117294395e-31, -2.22366095392166292886e-31, 4.77008198036469474778e-32, 3.62095649792024125963e-32, -8.23318875393760964959e-33, -5.30380288827501847974e-33, 1.26638489252570647034e-33, 7.07284738775807144675e-34, -1.76174660157556609534e-34, -8.67348916904863834386e-35, 2.2429209182080495684e-35, 9.86386432732707027415e-36, -2.63844706122737554513e-36, -1.0477773642031240349e-36, 2.89077876004391609493e-37, 1.0460083622390480724e-37, -2.96989276061048246256e-38, -9.86649449916210282914e-39, 2.87758165915806265738e-39, 8.83434203102226656147e-40, -2.64262320213514115326e-40, -7.53954661889577846234e-41, 2.3101733082219095791e-41, 6.15524480389044468954e-42, -1.92977377350607921673e-42, -4.82246160787350981118e-43, 1.54553613671164535897e-43, 3.63630573311826960514e-44, -1.19030682766613829283e-44, -2.64567543246116240892e-45, 8.83900923224832087526e-46, 1.86166994793974552241e-46, -6.34384494275881571265e-47, -1.2696021334003562327e-47, 4.41004396562705967478e-48, 8.4072890915077963811e-49, -2.97524568392975922943e-49, -5.4152462068403373183e-50, 1.95147405391285583185e-50, 3.39812634804777218516e-51, -1.24642172291575125566e-51, -2.08040217808513424299e-52, 7.76375030948043476546e-53, 1.2442782148609548775e-53, -4.72249078452768167075e-54, -7.2791422181419293785e-55, 2.80869707458250494944e-55, 4.16988853462033436664e-56, -1.63520318567681680854e-56, -2.3415442405848831146e-57, 9.32894232070719803634e-58, 1.2901282843049245228e-58, -5.22051816918169810787e-59, -6.98079610227537589659e-60, 2.86821159875591120999e-60, 3.71261811620144797564e-61, -1.5484355239934004122e-61, -1.94220890299237999351e-62, 8.22057415134686348011e-63, 1.00015322561529530441e-63, -4.29494904512029085324e-64, -5.07324914788909236648e-65, 2.20983343719263431715e-65, 2.53647318143604446581e-66, -1.12043437914687587541e-66, -1.25071111849305226475e-67, 5.60145525454954778472e-68, 6.08567654303532756468e-69, -2.76279728942175336566e-69, -2.92357217959148568461e-70, 1.34512383799093345039e-70, 1.38735150569989996366e-71, -6.46782743227173451203e-72, -6.50622759981231311525e-73, 3.0728599377766168827e-73, 3.01670594278019816293e-74, -1.44314177043784197001e-74, -1.38349656035838514178e-75, 6.70255073622641493197e-76, 6.2782005557076224597e-77, -3.07970533874288366635e-77, -2.82010855408737051425e-78},
            {2.33044789361030518601e-30, -8.71687992724904434029e-30, -1.67641748944657214139e-29, 4.90178548497489845282e-29, 2.74291420265610456915e-29, -9.20052845267937560292e-29, -1.77121919964759697789e-29, 9.10012994079848611549e-29, 3.13414424983390136862e-30, -5.78193368764765377448e-29, 2.93437380987519859539e-30, 2.63624564238273986233e-29, -2.72782604957670970931e-30, -9.2545909838360042554e-30, 1.29029592006395172552e-30, 2.62552111530231230074e-30, -4.3528162801355975821e-31, -6.23486500969642710522e-31, 1.16135448560153693095e-31, 1.27268353483592790841e-31, -2.58256852248714201757e-32, -2.2796482880388164369e-32, 4.94646031393934080976e-33, 3.64267543360064862202e-33, -8.34971620053850756402e-34, -5.2624683266626032386e-34, 1.26369726075143362847e-34, 6.9498228000008167334e-35, -1.737926877722003169e-35, -8.46818241137777098258e-36, 2.19544440407990990209e-36, 9.59490877235293233863e-37, -2.570227097248210678e-37, -1.01773786596231704342e-37, 2.80935801679369962675e-38, 1.01645285142401313725e-38, -2.88516290375162476046e-39, -9.60682026902898303346e-40, 2.79908079066149265349e-40, 8.63032363371217884401e-41, -2.5774117576078200517e-41, -7.39803668003366643131e-42, 2.2618321023317496828e-42, 6.07216151579621585128e-43, -1.89852784012481047171e-43, -4.78674268206983661853e-44, 1.52913785263387829432e-44, 3.63412332853170798301e-45, -1.18519781867149703157e-45, -2.66375668226672650265e-46, 8.86260899937918692838e-47, 1.88926485987715967219e-47, -6.40854539390368026039e-48, -1.29918680396591066493e-48, 4.49043630292007788993e-49, 8.6781688020589189457e-50, -3.0547015157842651666e-50, -5.64013339803159644087e-51, 2.02090763121240368968e-51, 3.57207369210166133931e-52, -1.30227586766070315687e-52, -2.20765419361657494958e-53, 8.18582376720872933199e-54, 1.33315927429244875104e-54, -5.02571341757391073073e-55, -7.87571952166765854939e-56, 3.01742587151306666872e-56, 4.55651852221923200679e-57, -1.77364227769251451707e-57, -2.58435872531670095188e-58, 1.02173074311872583158e-58, 1.43833255143861481113e-59, -5.77384999011565332491e-60, -7.86201483430894865429e-61, 3.20362035611395454788e-61, 4.22407278107086777602e-62, -1.74672331292996590873e-62, -2.23245648452126328679e-63, 9.36593841660764916143e-64, 1.16144336613041224288e-64, -4.94238913569136750274e-65, -5.95204199650175140149e-66, 2.56847349477476076374e-66, 3.00647887307073930731e-67, -1.31534976930446312687e-67, -1.49771499024144468524e-68, 6.64192429747497054566e-69, 7.36238208660240592119e-70, -3.30884152275335306912e-70, -3.57314696221595857094e-71, 1.62710618031621817175e-71, 1.71292732993468847677e-72, -7.90185333344407316676e-73, -8.11489102572988122684e-74, 3.79156240436612067396e-74, 3.80076638521349686008e-75, -1.79835467727382091979e-75, -1.76069090306331415245e-76, 8.43493290735488023554e-77, 8.07026295287323835558e-78, -3.91388974575590512004e-78},
            {2.55607757265197540806e-31, 1.32459135399217166414e-30, -4.09096382580611825761e-30, -4.23396069128170867132e-30, 1.27977275469600337334e-29, 4.59656962222409350084e-30, -1.77213056741865255933e-29, -2.06326691604788041962e-30, 1.44765708119298399015e-29, -3.3188749776625366048e-32, -8.06730809360733175915e-30, 5.74501737384277195651e-31, 3.34696110016926168936e-30, -3.88345096462573310145e-31, -1.09561219473141603527e-30, 1.61802071717931106177e-31, 2.94866924142785913472e-31, -5.05727361531710942146e-32, -6.72704154127561894445e-32, 1.28072371461751163172e-32, 1.33179452617004539209e-32, -2.74300789942198452028e-33, -2.33076450676252028371e-33, 5.11050157658721166507e-34, 3.65998737004729924489e-34, -8.45216394573888369784e-35, -5.22020524601565106516e-35, 1.26021353743730022568e-35, 6.83184941910402125136e-36, -1.71472675877799748478e-36, -8.27470703901414540782e-37, 2.15045277978639557055e-37, 9.34329273939841436099e-38, -2.50624644396196382001e-38, -9.8970409217601279153e-39, 2.73331222460680240464e-39, 9.88852402127870509234e-40, -2.80606924443422700878e-40, -9.36357669432080757286e-41, 2.72565346018316140505e-41, 8.43821176211358795211e-42, -2.5161618846825597531e-42, -7.26376614408404467623e-43, 2.21614480979502473991e-43, 5.99242598920772779689e-44, -1.86873500746528058348e-44, -4.75168456264409036274e-45, 1.51327971979190025677e-45, 3.6311209510899061273e-46, -1.18005650410403156483e-46, -2.68048330119413556499e-47, 8.88315450047865414367e-48, 1.91556791171214346912e-48, -6.46958296806675803814e-49, -1.3278250761045037635e-49, 4.56775416068334779694e-50, 8.94364010259296007052e-51, -3.13212865960438807369e-51, -5.86303524049468173212e-52, 2.0893443665243761774e-52, 3.74637256766361628662e-53, -1.35792384275502850735e-53, -2.33653704389150228472e-54, 8.61077870718307500803e-55, 1.42414326688802397077e-55, -5.33419688540531528304e-56, -8.49293941096351589837e-57, 3.23198784927074641525e-57, 4.96080287649138160162e-58, -1.91743180352381911581e-58, -2.84097715235281286378e-59, 1.11496196152184448714e-59, 1.59663925319311806882e-60, -6.36061103032948165317e-61, -8.81338493794861509658e-62, 3.5630047798020300079e-62, 4.78215678526396925118e-63, -1.96140329450650683201e-63, -2.55255560842044735785e-64, 1.06189323915152257299e-64, 1.34122329800870292859e-65, -5.65805639855008758468e-66, -6.94202753323326346823e-67, 2.96903610441490221913e-67, 3.54158920624762671809e-68, -1.53531252203437671958e-68, -1.78191788998294320754e-69, 7.82827368304285016409e-70, 8.84689695231364780008e-71, -3.93788200353862526726e-71, -4.33641076683465872276e-72, 1.95529588352832234111e-72, 2.09949924958921212794e-73, -9.58800054534381705511e-74, -1.00448825894928131302e-74, 4.64526125698803196075e-75, 4.75121778277761991966e-76, -2.22458228801815437626e-76, -2.22265963882516331552e-77, 1.05347080672108487898e-77, 1.02876599075916181346e-78},
            {-5.72742160613725968447e-32, 2.21448184302895290298e-31, 4.69589804980470795868e-31, -1.38550896519795237e-30, -8.80046136964325734639e-31, 2.87781887016704261772e-30, 6.74832935374926857611e-31, -3.13452815301044966529e-30, -1.94257458301038998558e-31, 2.18345945553474791202e-30, -6.72344870481544965092e-32, -1.08704719492676875381e-30, 9.56146192671190052566e-32, 4.15146501137545107381e-31, -5.25987793729191245716e-32, -1.27691659457844612102e-31, 1.97795383223990781839e-32, 3.2772766483137630755e-32, -5.78825939279965979018e-33, -7.20914415875523146713e-33, 1.39942902366268855531e-33, 1.38783413650531834557e-33, -2.89717119561911644096e-34, -2.37742769336405762916e-34, 5.26303338174440298501e-35, 3.67347776571471741622e-35, -8.54209508508675152786e-36, -5.17741295009022693123e-36, 1.25608192311055532e-36, 6.7187792197123402884e-37, -1.69217984205978575286e-37, -8.09219656061856970297e-38, 2.10779125818409072319e-38, 9.10753338384194107305e-39, -2.446158597117693979e-39, -9.63497212329719983356e-40, 2.66216825754016408525e-40, 9.63034526111057417038e-41, -2.73211151815169026056e-41, -9.13538595328536587407e-42, 2.65686386896046779205e-42, 8.25710168515536702512e-43, -2.45855710460862958916e-43, -7.13627938315906045327e-44, 2.1729254187570599831e-44, 5.91591496830617518096e-45, -1.84031778296455775421e-45, -4.7173537142364592423e-46, 1.49795557587297711795e-46, 3.62743466685816066487e-47, -1.17491145045994057327e-47, -2.69598446833560932691e-48, 8.90101004387987030946e-49, 1.94066741892196703896e-49, -6.52725250309481490969e-50, -1.35556026626195292237e-50, 4.64217369627479797365e-51, 9.20379606128937217778e-52, -3.20759573047688490677e-52, -6.08385288765886405519e-53, 2.15678125038826660156e-53, 3.92085560926522748062e-54, -1.41332807838794464739e-54, -2.46689204064934066732e-55, 9.03816477270155578666e-56, 1.51711481785587591689e-56, -5.64756578947980130346e-57, -9.13013862738869662292e-58, 3.45213552412993685931e-58, 5.38247808066843462796e-59, -2.06644644970589018471e-59, -3.11139957032505059564e-60, 1.21255324773090307944e-60, 1.76518792346948045951e-61, -6.98100459999364941839e-62, -9.83680113663984558219e-63, 3.94682580247660212731e-63, 5.38872850666538886658e-64, -2.19299848392166260628e-64, -2.9040732378536017827e-65, 1.1984325902703267532e-65, 1.54069499954094365862e-66, -6.44581024542044237123e-67, -8.05181819540058723943e-68, 3.41440233561406319121e-68, 4.1476550316696997167e-69, -1.7823471939060859903e-69, -2.1071241743972107011e-70, 9.17405734894111457782e-71, 1.05630518679305789401e-71, -4.65863239788926120295e-72, -5.22781294627057378865e-73, 2.33510260773857148249e-73, 2.55557839100201769951e-74, -1.155883667791292727e-74, -1.2345044495422191928e-75, 5.65303104345217771681e-76, 5.89543055198355283975e-77, -2.732721409752339108e-77, -2.78440937669858610479e-78, 1.30627237293347599716e-78},
            {-6.13471321379642358259e-33, -3.47133467236015319826e-32, 1.09530100627135423844e-31, 1.25957903181664262643e-31, -3.79172080866603588146e-31, -1.57270434687721609988e-31, 5.78193368764765377448e-31, 8.69664593340961511731e-32, -5.17833965468038187243e-31, -1.09994071762214196988e-32, 3.15096788259178240124e-31, -1.68670512526502058871e-32, -1.42215727078875249623e-31, 1.44950946666232771621e-32, 5.04727167451615527565e-32, -6.85880283474134758066e-33, -1.4681313634000168372e-32, 2.36769879800388860904e-33, 3.6094431227281260251e-33, -6.5407079284706516517e-34, -7.67997403917470084475e-34, 1.51698453404555342359e-34, 1.440913946586188982e-34, -3.04506755659168402579e-35, -2.42002758214314154109e-35, 5.40486161661405505845e-36, 3.68365934894933037742e-36, -8.62090673928913226458e-37, -5.13441844425314653121e-37, 1.25142828528372728796e-37, 6.61044975796476403438e-38, -1.67030735228089785797e-38, -7.91986180067876902771e-39, 2.0673154910350107898e-39, 8.88630874885180930595e-40, -2.38965286383456786677e-40, -9.38958662958280981612e-41, 2.59550594224410574754e-41, 9.38846083442367668545e-42, -2.66284588586285875954e-42, -8.92101729362394045484e-43, 2.59232381686306864599e-43, 8.08617603078225971631e-44, -2.40431311996342684209e-44, -7.01515592525495773148e-45, 2.13200438477116251556e-45, 5.84250632310502012915e-46, -1.81320332215247247233e-46, -4.68380246511212502065e-47, 1.48315731209989828937e-47, 3.62318453210778848056e-48, -1.16978708830835395291e-48, -2.71037807764304450643e-49, 8.91650335154958157655e-50, 1.96464646698100609357e-50, -6.58182717596200284198e-51, -1.38243504353015367238e-51, 4.71386373608550924418e-52, 9.4587469557453014804e-53, -3.28117319405523550199e-53, -6.30251046921755147054e-54, 2.22322089271401762582e-54, 4.09537415126718244568e-55, -1.46845668457416374148e-55, -2.59857166436800368197e-56, 9.46757176749639741284e-57, 1.61196298874099082944e-57, -5.96546542209680830265e-58, -9.7866544020802416107e-59, 3.67762711590935484205e-59, 5.8212604123176115536e-60, -2.2205579879457983574e-60, -3.39560136359298031638e-61, 1.3144637459657428506e-61, 1.94409752193726677891e-62, -7.63517202551958343905e-63, -1.09340214226460559232e-63, 4.35549763986291576195e-64, 6.04557408501820749494e-65, -2.44200346562016641709e-65, -3.2885510159120547416e-66, 1.34667565143815612693e-66, 1.76106320935889870906e-67, -7.309480101593667458e-68, -9.29018677701692875734e-69, 3.90747970361180076459e-69, 4.83072454306063237084e-70, -2.05852798181068663999e-70, -2.47732115091804320952e-71, 1.0693356551161304343e-71, 1.25361541529150448486e-72, -5.48026545370179177358e-73, -6.26289380011102580819e-74, 2.77229338325649103734e-74, 3.09043174699589331711e-75, -1.3849507367944483374e-75, -1.50691984987525543194e-76, 6.83570231885759881229e-77, 7.26392202934678442609e-78, -3.33481105200289705716e-78, -3.46286625318571780185e-79},
            {1.40908086040689448401e-33, -5.62413867148320533218e-33, -1.30635007634728025689e-32, 3.89393664561338729803e-32, 2.77607468969284922271e-32, -8.90670144438662969111e-32, -2.47361510384202119662e-32, 1.0635870921038011548e-31, 9.60545812144237935388e-33, -8.08977633528057099164e-32, 8.33038454226472462578e-34, 4.38148581501027726695e-32, -3.15855743561097574501e-33, -1.81416696901736004773e-32, 2.06377710104668133674e-33, 6.03083486890892667399e-33, -8.67853675401351172141e-34, -1.66803533271132910017e-33, 2.78472636753601582278e-34, 3.94350399957622636444e-34, -7.31000049767779730979e-35, -8.13866670729041273529e-35, 1.63299747936875139908e-35, 1.49115948578781507025e-35, -3.186777363742083156e-36, -2.45892536771970705553e-36, 5.53676100947416370374e-37, 3.69098116660046477211e-37, -8.68984647195847362619e-38, -5.09148890215514559773e-38, 1.24635958532486229148e-38, 6.50669005447292962482e-39, -1.64912082346450002102e-39, -7.75698324675125844422e-40, 2.02889108049086888915e-40, 8.67843693619977287241e-41, -2.336449971104827282e-41, -9.1594739848035870102e-42, 2.53295096460125589322e-42, 9.16150684839429058263e-43, -2.59787731900753365287e-43, -8.71936824885378454647e-44, 2.53168648305837703092e-44, 7.9246947551018777968e-45, -2.35317390532867712003e-45, -6.90000746759514572377e-46, 2.09322691896930817046e-46, 5.77208005970172017949e-47, -1.78732320621768588184e-47, -4.65107128640280934603e-48, 1.46887533541384716638e-48, 3.61847650930521988022e-49, -1.16470427374116496566e-49, -2.72377173856160023242e-50, 8.92992934843099551395e-51, 1.98758311778404635823e-51, -6.63355999255380008603e-52, -1.40849120265270214599e-52, 4.78298566257935986207e-53, 9.70861689738262100724e-54, -3.35293257274739918396e-54, -6.51895243590668322548e-55, 2.28867070974734932921e-55, 4.26979682977027562634e-56, -1.52328291736315326189e-56, -2.73143921070360448634e-57, 9.89862742384176387653e-58, 1.70858151307177517209e-58, -6.28756169328249160045e-59, -1.04618287256028962452e-59, 3.90822748239693632547e-60, 6.27684976068535514195e-61, -2.37963637737542145496e-61, -3.69353572845591121026e-62, 1.42064723105356162035e-62, 2.13346759466264505819e-63, -8.32319749731304186267e-64, -1.21066695412431369603e-64, 4.78938963945885866543e-65, 6.75440516747020229341e-66, -2.70888438881104877045e-66, -3.70750149338715517696e-67, 1.50707211820305439417e-67, 2.00353193650686011712e-68, -8.25285547939151866049e-69, -1.06660413530992139638e-69, 4.45119399795684545962e-70, 5.59702853095732483795e-71, -2.36597330007105680578e-71, -2.89667233315110150545e-72, 1.24007505776546394435e-72, 1.47929712351788029359e-73, -6.41240155066167279147e-74, -7.45829484512487732499e-75, 3.27299177026936475869e-75, 3.71410283923041133419e-76, -1.64977788111002434137e-76, -1.82763635141459531131e-77, 8.21592010262903343187e-78, 8.89054237018156046687e-79, -4.04408819678592898249e-79},
            {1.47642223976665341443e-34, 9.07341548854996993979e-34, -2.92401836025913698204e-33, -3.70761748372529722385e-33, 1.11469706721566488808e-32, 5.26081146969897849459e-33, -1.86355003317332680969e-32, -3.45455589574850003225e-33, 1.82242214146430445416e-32, 8.27887671742435452945e-34, -1.20637979399855619499e-32, 4.27129051732959515688e-34, 5.90324172458029856801e-33, -5.16704815626525680221e-34, -2.26432444711782045452e-33, 2.80613503931116321483e-34, 7.0978060250292819464e-34, -1.07145776910922266938e-34, -1.87545153581799776429e-34, 3.22645914040793766268e-35, 4.27801711537060156598e-35, -8.0919749486762919104e-36, -8.58463611170884988551e-36, 1.74715589606689368012e-36, 1.53870482412252730886e-36, -3.32243473025781591064e-37, -2.49445430490031410423e-37, 5.65946919598068816025e-38, 3.69583657183300861764e-38, -8.75002764672215443339e-39, -5.04884191650494111914e-39, 1.24096675680115007145e-39, 6.40732498953263289074e-40, -1.62862422738600052934e-40, -7.60290415350834802925e-41, 1.9923930276380800286e-41, 8.48285838519355402593e-42, -2.28629829063938836954e-42, -8.94337573295633128305e-43, 2.47416887524527014559e-43, 8.948264973335294153e-44, -2.53685317265009418656e-44, -8.52944862835446309875e-45, 2.4746411460797939894e-45, 7.771986433280246557e-46, -2.30490834615614866899e-46, -6.79047513739024101702e-47, 2.05645147683900240246e-47, 5.70451905640002684749e-48, -1.7626132089618740746e-48, -4.61919070876508838189e-49, 1.45509894395008715573e-49, 3.61340414401364914838e-50, -1.15968077151080630385e-50, -2.73626369389684037718e-51, 8.9415535518945649834e-52, 2.00955063528654756726e-52, -6.68268521463944186731e-53, -1.43376949174411234533e-53, 4.84969340998574562147e-54, 9.95354092930562560862e-55, -3.42294578932163451411e-55, -6.73314115463774233384e-56, 2.35314220498648005211e-56, 4.44400823963681682301e-57, -1.57778468276611041966e-57, -2.86536838608557167138e-58, 1.03309951562688863381e-58, 1.80686895389075662257e-59, -6.6135408769331500018e-60, -1.11550119983852678988e-60, 4.14370886555190833724e-61, 6.74893311066455570959e-62, -2.54355074137450887666e-62, -4.00513605225130253597e-63, 1.53105289995077025717e-63, 2.33337947141053622612e-64, -9.04511285238818285124e-65, -1.33562383012429702249e-65, 5.24882829701262224434e-66, 7.51685742340582560603e-67, -2.99407917962995861357e-67, -4.16240487175387361328e-68, 1.68005696317435051839e-68, 2.26930122805560199414e-69, -9.27967708360017185045e-70, -1.2188400958440035224e-70, 5.04848155266066074562e-71, 6.45296541127495078962e-72, -2.70684042463146177889e-72, -3.36951011467961622429e-73, 1.43112863508530097275e-73, 1.7361708329951866447e-74, -7.4650956645119700438e-75, -8.83176468791358494913e-76, 3.84367562749516932588e-76, 4.43742965175570546587e-77, -1.95440705957900315295e-77, -2.20309593898455152229e-78, 9.81819672323582335692e-79, 1.08126554761377087887e-79},
            {-3.47010516489959160555e-35, 1.42800896663818317727e-34, 3.6123039722560230095e-34, -1.08877387960599826278e-33, -8.63092549561410949543e-34, 2.73031749046324625606e-33, 8.79611192677604001697e-34, -3.56008046239538544534e-33, -4.25213055292500235428e-34, 2.94581112488019535986e-33, 3.16170097712275438304e-35, -1.7297871099932967897e-33, 9.66204484653031761044e-35, 7.74083008665859550731e-34, -7.78598776891522905998e-35, -2.77309630745330085348e-34, 3.68181799334284892822e-35, 8.24326372720003668489e-35, -1.29601605481258946204e-35, -2.08926417262285192757e-35, 3.69033710752244041123e-36, 4.61174637629010307803e-36, -8.88291863945229482261e-37, -9.01752594602039260078e-37, 1.85921731349051495396e-37, 1.58368843078554825687e-37, -3.4522133851116017617e-38, -2.52692081888117333392e-38, 5.77368334425052266181e-39, 3.69857024116059640123e-39, -8.80244357218575773245e-40, -5.00665394530922011928e-40, 1.23532712607893370439e-40, 6.31217856465693080568e-41, -1.60881566579728675079e-41, -7.45702434791433353907e-42, 1.95770515292891713942e-42, 8.29862073825482833008e-43, -2.23897058368484489878e-43, -8.7401657879088919634e-44, 2.41886000182915957324e-44, 8.74764382582399587569e-45, -2.4794577375890691946e-45, -8.3503668190127300217e-46, 2.42090868321622561384e-46, 7.62744067758020095633e-47, -2.2593073392529504509e-47, -6.68622698703631053752e-48, 2.02154842205508624695e-48, 5.63970958628295674533e-49, -1.73901306061296047568e-49, -4.58818293635221496515e-50, 1.44181663177282001555e-50, 3.6080500335802523113e-51, -1.15473167128410883951e-51, -2.74794365941509295245e-52, 8.95161510209444533882e-53, 2.0306177220282893449e-53, -6.72941971551446576805e-54, -1.45830948499128933336e-54, 4.91413354382346652709e-55, 1.0193662538765512231e-55, -3.49128462771535572499e-56, -6.94505473729288582573e-57, 2.41665033481444468987e-57, 4.61790765478442132155e-58, -1.63194407781552924183e-58, -3.00024286762325634539e-59, 1.07643718340797374839e-59, 1.90672879507283067572e-60, -6.94310921227627859975e-61, -1.18655661201451258522e-61, 4.38385147235422612129e-62, 7.23718770371921411733e-63, -2.71217022739326538259e-63, -4.33031818182699513591e-64, 1.64562610711668973878e-64, 2.54389748109720758469e-65, -9.80090224765050123433e-66, -1.46840935713044035095e-66, 5.73409939727537081847e-67, 8.33448975483740739774e-68, -3.29799794178767866526e-68, -4.65470623987218827635e-69, 1.86604993423190562864e-69, 2.55956420127240739705e-70, -1.03936289321695716666e-70, -1.38663721860884989061e-71, 5.70228199061197484526e-72, 7.40508618226101705105e-73, -3.08332024736454845241e-73, -3.90032796435662860182e-74, 1.64404472630923770796e-74, 2.02719808069086240576e-75, -8.64882295368846854278e-76, -1.04021606720226769991e-76, 4.49117358298457014136e-77, 5.27205981677931050333e-78, -2.3031479041843100318e-78, -2.64029959301037075073e-79, 1.16689589001853653358e-79},
            {-3.56210662409746357967e-36, -2.36619618224896717468e-35, 7.78557818565264833139e-35, 1.0812902109630283957e-34, -3.25398148807981122535e-34, -1.72670693438837324366e-34, 5.94004556087034932952e-34, 1.31450085373465363123e-34, -6.31945069472636144272e-34, -4.43990628219877915492e-35, 4.53541742254340011933e-34, -7.63754394395138090682e-36, -2.39862750467968674534e-34, 1.74704275718031684883e-35, 9.91489533429811003599e-35, -1.10822436361745159351e-35, -3.34025819544524768107e-35, 4.69422472934430598371e-36, 9.46191146914007774295e-36, -1.54067640947392038138e-36, -2.30842958857536756068e-36, 4.17386687060583552789e-37, 4.94364365887703341584e-37, -9.67955015146201071533e-38, -9.43716775551255197415e-38, 1.96899855813239885646e-38, 1.62625003920235157466e-38, -3.57631536192278512537e-39, -2.55660592612376037269e-39, 5.88005863061135938342e-40, 3.69948431768136941186e-40, -8.847980388436328763e-41, -4.96506728561429313374e-41, 1.22950645085533332165e-41, 6.22107629911921949906e-42, -1.58968871770286666281e-42, -7.31879467547862077226e-43, 1.92471951204206381813e-43, 8.1248658682501174183e-44, -2.1942611858716794524e-44, -8.54883373887345051488e-45, 2.36675511315320241303e-45, 8.55866310884397883045e-46, -2.42540760307987625253e-46, -8.18131802168386299916e-47, 2.37023771937206242926e-47, 7.49050151929067826847e-48, -2.21618128343481839881e-48, -6.58695570859101433615e-49, 1.9883988432140263679e-49, 5.57754167373636774866e-50, -1.71646621376834901877e-50, -4.55806320761052938883e-51, 1.42901633581044881824e-51, 3.60248711447710356571e-52, -1.14986974670205718586e-52, -2.75889359018366806228e-53, 8.96032947063904219808e-54, 2.05084876021225113011e-54, -6.77396425960488233215e-55, -1.48214949219412076396e-55, 4.97644540415885385479e-56, 1.04291315317773989478e-56, -3.5580202935750014992e-57, -7.15468508598805853311e-58, 2.47921295022165657583e-58, 4.79140781686396980658e-59, -1.68574696762632577202e-59, -3.13595583978996042953e-60, 1.11984855981786760992e-60, 2.00806947698464907022e-61, -7.27599239156124586893e-62, -1.25928670742653066044e-62, 4.62844391129332936858e-63, 7.74128388935258276791e-64, -2.88536475845417715528e-64, -4.66898257201377733532e-65, 1.7643090439221224908e-65, 2.76507016971846223512e-66, -1.0590506688849416968e-66, -1.60914788337575886731e-67, 6.24545024075366436248e-68, 9.20878412976931261547e-69, -3.62102351918297642993e-69, -5.18581327918550390033e-70, 2.06545520030438094637e-70, 2.87550434302422807137e-71, -1.15983314645425119214e-71, -1.57091268400847628905e-72, 6.41553146510762826164e-73, 8.46007944818596880206e-74, -3.49763217750359305834e-74, -4.49377224206361350369e-75, 1.88041215638593636574e-75, 2.3554781787811882229e-76, -9.97446317346465954389e-77, -1.21894465054248914132e-77, 5.22266030704298510977e-78, 6.23046306399398463739e-79, -2.70057913327694822056e-79, -3.14682464486893134894e-80},
            {8.55369656823692105755e-37, -3.62503111289647118075e-36, -9.9358323727464751803e-36, 3.03016265556638505641e-35, 2.6498532119360415194e-35, -8.29720649772366255553e-35, -3.05149770074115904263e-35, 1.17695589658395726341e-34, 1.75763787036171922357e-35, -1.05586437350216722355e-34, -3.40978768037654835893e-36, 6.70092763212102963777e-35, -2.63060341380699243615e-36, -3.2315214422897543821e-35, 2.81658791152412411066e-36, 1.24420199449389119972e-35, -1.51146755680783038163e-36, -3.96499147278250876847e-36, 5.84507678327260239473e-37, 1.07482435870175844095e-36, -1.80445634537463804431e-37, -2.53198257237723192938e-37, 4.67465726026892398145e-38, 5.27283023800066396016e-38, -1.0478993884137415498e-38, -9.84354521083328148894e-39, 2.07636669202574906398e-39, 1.66652830739919194664e-39, -3.69496199372987013701e-40, -2.58376682504730562098e-40, 5.97920803468964173077e-41, 3.69884377679625647212e-41, -8.88742871431662985775e-42, -4.92419584311235575163e-42, 1.22356063956764379329e-42, 6.13384696611541550437e-43, -1.57123351301998043929e-43, -7.18771202736200863672e-44, 1.89333582276624130203e-44, 7.96081871979749889217e-45, -2.15198356558718491541e-45, -8.36847059531411263422e-46, 2.31761170960965953019e-46, 8.38044004760844379174e-47, -2.37444769392289274752e-47, -8.02157411378007027269e-48, 2.32240131953690190861e-48, 7.36066161721916522643e-49, -2.17535790113520381259e-49, -6.49237655143915822595e-50, 1.95689350427315863005e-50, 5.517909322229042985e-51, -1.69491961511031540566e-51, -4.52884094391407305403e-52, 1.41668563550486691256e-52, 3.59677979164685614045e-53, -1.14510576546880081945e-53, -2.76918837886860575876e-54, 8.96789088160453311789e-55, 2.07030405258861313062e-55, -6.81650470412517563916e-56, -1.5053264983433198058e-56, 5.03676129637762285832e-57, 1.06601022233557528197e-57, -3.62322305946375270117e-58, -7.36203613765765519488e-59, 2.54085030664462351349e-59, 4.96443379505373629903e-60, -1.73918259694923600931e-60, -3.27240951804905774406e-61, 1.16330937414193773672e-61, 2.11080438578161329749e-62, -7.61193496031577435878e-63, -1.33363070601756663981e-63, 4.87728350360615628712e-64, 8.26088768297040815307e-65, -3.06300568503367927283e-65, -5.02101630818717586822e-66, 1.88704136307382478866e-66, 2.99693150766278900156e-67, -1.14138283882145111407e-67, -1.75795201800040634479e-68, 6.78309192311609714771e-69, 1.01411459681849854051e-69, -3.96351219576845388064e-70, -5.75709440952575609634e-71, 2.27866113188225818236e-71, 3.21829307538667734983e-72, -1.28973356012469024084e-72, -1.77258807485801251091e-73, 7.19115641262992832453e-74, 9.62475663273730553594e-75, -3.95201922143948677173e-75, -5.15463372880370078832e-76, 2.14185705910924077829e-76, 2.72424455232353128727e-77, -1.14532841171526799458e-77, -1.4214686101556646432e-78, 6.04565069189732979126e-79, 7.32594097218163911923e-80, -3.15154908039763053949e-80},
            {8.61357241183691332131e-38, 6.15824622206351401555e-37, -2.06810899141285127712e-36, -3.12784994818961581088e-36, 9.43817725979688612231e-36, 5.57611161591301747257e-36, -1.87432309112207552059e-35, -4.8384459919505439916e-36, 2.16190632592708658006e-35, 2.0693757945499779939e-36, -1.67692577244687040986e-35, -3.63546157091398717692e-38, 9.55733085813703899661e-36, -5.52740541261389937355e-37, -4.24588648272687846215e-36, 4.22100580212518398515e-37, 1.53347749073742123755e-36, -1.99335439275821649192e-37, -4.64597991248737849854e-37, 7.13460181070709468434e-38, 1.20966811471005266596e-37, -2.08628236537265874353e-38, -2.75903907802360323497e-38, 5.19044386943405031822e-39, 5.59857854508970762136e-39, -1.12787505583178037758e-39, -1.02367638700203145357e-39, 2.18123104708769340327e-40, 1.70465910348166523528e-40, -3.80838679282898569712e-41, -2.60863855845843163731e-41, 6.07170305675474308195e-42, 3.69688110567333078422e-42, -8.92149411374637160906e-43, -4.88412991487956492385e-43, 1.21753720398249032622e-43, 6.05032382485224690604e-44, -1.55343758858668680377e-44, -7.06331489041689107975e-45, 1.86346091290843532489e-45, 7.8057776786423345855e-46, -2.11196820037692246554e-46, -8.19825656831260805713e-47, 2.27121083766537567154e-47, 8.21217774540174029434e-48, -2.32634787107735387895e-48, -7.87047488393252500197e-49, 2.27719413814692230079e-49, 7.2374571769076561619e-50, -2.13668034170956346446e-50, -6.40222542695432439362e-51, 1.92693191205713893322e-51, 5.46071064268709010812e-52, -1.6743234853325774649e-52, -4.50052072008390745582e-53, 1.40481191373497492484e-53, 3.59098493013042152235e-54, -1.14044875745604156985e-54, -2.77889649121474613842e-55, 8.97447447565967954379e-56, 2.08904005963216019562e-56, -6.85721312291178524275e-57, -1.52787612756388064934e-57, 5.09520671642546605183e-58, 1.08867319022490603868e-58, -3.68696198177890687974e-59, -7.56712229124722696742e-60, 2.60158463460792577459e-60, 5.13692191786770692382e-61, -1.79224323445911677508e-61, -3.40951466763005787942e-62, 1.20679806664889767891e-62, 2.21485180448316805448e-63, -7.95069965246713805817e-64, -1.40952962234707419194e-64, 5.13017648653720375114e-65, 8.79566304745630150829e-66, -3.24496634587189662476e-66, -5.38629499986916830159e-67, 2.0137607496496399923e-67, 3.23950207563775587804e-68, -1.22707349307064369009e-68, -1.91492316436657838666e-69, 7.34720163849798316877e-70, 1.1132905013365023796e-70, -4.32579450986753259011e-71, -6.36987734587403530061e-72, 2.50604020353700483737e-72, 3.58908758331968660575e-73, -1.4294117711620922804e-73, -1.99258738175223792567e-74, 8.03206782335242183968e-75, 1.09060374899107622847e-75, -4.44874326668298112838e-76, -5.88783895914211135139e-77, 2.43003971112530271202e-77, 3.13686070946889593911e-78, -1.30969242761576448117e-78, -1.65000338883059667726e-79, 6.96799304545299106891e-80, 8.57263408609335177163e-81},
            {-2.11030731665291450123e-38, 9.20048487475736544949e-38, 2.72005942935285733788e-37, -8.39760452515777101792e-37, -8.04630020326389093143e-37, 2.50151437693275069479e-36, 1.03692197466333318026e-36, -3.84710603453175948483e-36, -6.92438349359876704954e-37, 3.73010568339245835848e-36, 2.02840493917069087695e-37, -2.55108637992826185983e-36, 5.6857905124262472534e-38, 1.32221996850875712264e-36, -9.7155647391149063536e-38, -5.45763749121248564236e-37, 6.00466030120219073988e-38, 1.86018924929378597524e-37, -2.55803093156013148436e-38, -5.38150225112789387177e-38, 8.56172719596274088692e-39, 1.35016805945835902988e-38, -2.38502344405853732678e-39, -2.98879628325872205705e-39, 5.71910472908965601658e-40, 5.92029477202335405452e-40, -1.20766658170140389169e-40, -1.06170257508916093957e-40, 2.28353628361164619134e-41, 1.740774279822357669e-41, -3.91682986436032838721e-42, -2.63143568063401494892e-42, 6.1580750619381737727e-43, 3.69380038049885857878e-43, -8.95080646086229120458e-44, -4.84494016148709906982e-44, 1.21147648840990186994e-44, 5.97034546830209168637e-45, -1.53628657058593664385e-45, -6.94517936591000756157e-46, 1.83500819530873880472e-46, 7.65910623306574408432e-47, -2.07406072492667393532e-47, -8.03745055932936284127e-48, 2.22735434464853030963e-48, 8.05315515203153912194e-49, -2.28090000518461233711e-49, -7.72742042872925764288e-50, 2.23442995397467559078e-50, 7.12046348258943235267e-51, -2.1000055252994618207e-51, -6.31625718438468062796e-52, 1.89842148640609054396e-52, 5.40584790555533177962e-53, -1.65463110883166664394e-53, -4.47310308511410340502e-54, 1.39338248599862649306e-54, 3.58515272657685817084e-55, -1.13590624676463877349e-55, -2.78808054380307646997e-56, 8.98023824499387578236e-57, 2.10710963047011006378e-57, -6.89624885399572905916e-58, -1.54983262670315443804e-58, 5.15190060007003426088e-59, 1.11091795339586949096e-59, -3.74930467825277023965e-60, -7.76996700149428784222e-61, 2.66143976450640576991e-61, 5.30881877648393925132e-62, -1.8449238478727628658e-62, -3.54719012400785908919e-63, 1.25029559311443554843e-63, 2.32013483291559020763e-64, -8.29206667908819141459e-65, -1.48692640299357979076e-65, 5.38693812413466011646e-66, 9.34527391660085873602e-67, -3.43112254597903165901e-67, -5.76468454465519421238e-68, 2.1444034407976653134e-68, 3.49279022049842053891e-69, -1.31610632347267445957e-69, -2.08015207793242030695e-70, 7.93792498217085423429e-71, 1.2185316624892496929e-71, -4.70817616208868680922e-72, -7.02544803543428016446e-73, 2.7479490060094492418e-73, 3.9890288977051571626e-74, -1.57920754415127060305e-74, -2.23183513816742485439e-75, 8.94115602924236189533e-76, 1.23109360054789600984e-76, -4.99008059073013199286e-77, -6.69844143762797121233e-78, 2.74665140051686761703e-78, 3.5968158978957107452e-79, -1.49173749012336406095e-79, -1.90687218549465271516e-80, 7.99786140749122976144e-81},
            {-2.0871470317736616066e-39, -1.59989168029467783622e-38, 5.48176962058910052559e-38, 8.98258938633746636851e-38, -2.72155499342220561702e-37, -1.77548479393623168272e-37, 5.85971243222661514125e-37, 1.7338667123874915765e-37, -7.30479029664356428536e-37, -8.89742747585852786409e-38, 6.10607249269866380339e-37, 1.31981838942132981067e-38, -3.74016852203171574969e-37, 1.59038348153168283364e-38, 1.78131223671518628605e-37, -1.54687059592930906059e-38, -6.88097782493395830655e-38, 8.20928967852197869607e-39, 2.22485255104500427199e-38, -3.20877423989934332558e-39, -6.16951793835833501153e-39, 1.01242734027590402107e-39, 1.49578184361235117763e-39, -2.69951894557577374088e-40, -3.22053072089233380281e-40, 6.25866903769645300301e-41, 6.23750262864882052e-41, -1.28708984674023336046e-41, -1.09846080712864514021e-41, 2.38325638400689007314e-42, 1.77500082716840730582e-42, -4.02053356262618813681e-43, -2.65235388433043039615e-43, 6.2388170328311726096e-44, 3.68978081742883239345e-44, -8.97592829377761666888e-45, -4.80668091174876733453e-45, 1.20541271164090688507e-45, 5.89375637857085363905e-46, -1.51976471820729439467e-46, -6.83291560699893002338e-47, 1.80789717331367385817e-47, 7.52022573166881588065e-48, -2.03812031163316715502e-48, -7.88538108636421539023e-49, 2.18586250496858682307e-49, 7.90271839215876395051e-50, -2.23791544856754749849e-50, -7.59186453722382532787e-51, 2.19393953156241941387e-51, 7.00929095878244419686e-52, -2.06520269278187205825e-52, -6.23424404293441271437e-53, 1.87127682044905201511e-53, 5.35322753473146171388e-54, -1.63579863406876477563e-54, -4.44658525671268659244e-55, 1.38238470356245562531e-55, 3.57932747591015326446e-56, -1.13148445280328449049e-56, -2.79679782896194701522e-57, 8.98532476388339742197e-58, 2.12456222577224087548e-58, -6.93375947347446322295e-59, -1.57122886464091726615e-59, 5.20695558785876192209e-60, 1.13276046702340335255e-60, -3.81031715650022535556e-61, -7.97060152413769212595e-62, 2.72044079948884340414e-62, 5.4800802980621415651e-63, -1.89722180791887387789e-63, -3.68536232024693981591e-64, 1.29378523872217861737e-64, 2.42658128266313368631e-65, -8.63583298644454963775e-66, -1.565766032600856841e-66, 5.64739273943813769172e-67, 9.90938597884478523638e-68, -3.62135295973717012909e-68, -6.15604276362846619983e-69, 2.27890469648213064357e-69, 3.75679317408072760066e-70, -1.40846232981362284454e-70, -2.25371944057618172368e-71, 8.55537823188973343773e-72, 1.32995634337457275891e-72, -5.11093899792207389855e-73, -7.72504994402808907924e-74, 3.00472835586625937605e-74, 4.41924022497318338066e-75, -1.73945243492801065711e-75, -2.49125468888650623102e-76, 9.92128600399148727871e-77, 1.38465467680596719736e-77, -5.57831761091213599787e-78, -7.59161281412340059601e-79, 3.09341135092545071571e-79, 4.10772049958639772391e-80, -1.69269616365492379407e-80, -2.19450436174721398652e-81},
            {5.21069983399591768727e-40, -2.33473772660405346254e-39, -7.41522458376987810068e-39, 2.31827222154864009968e-38, 2.41951983199826288836e-38, -7.48712147507216131624e-38, -3.46174943210602908006e-38, 1.24447181628710234498e-37, 2.63052435256434431932e-38, -1.30031712355605972743e-37, -1.00101144890719434438e-38, 9.55783970137652294509e-38, -4.72901259521563993041e-40, -5.31074455666639389629e-38, 3.16176668449881858143e-39, 2.3445390281940017655e-38, -2.30666601226748893593e-39, -8.52827242281669783051e-39, 1.08733809468321185875e-39, 2.6276562647843840333e-39, -3.94802681723725562521e-40, -7.00774457344562042402e-40, 1.18191397449374476094e-40, 1.64598553259448471199e-40, -3.02860145553852393817e-41, -3.45359506679402307407e-41, 6.80732054734160476471e-42, 6.54982841517701450061e-42, -1.36598894206333991984e-42, -1.13398455684228328322e-42, 2.48038948650065921679e-43, 1.80746032224114511468e-43, -4.11973915049941995315e-44, -2.671571559025667465e-44, 6.31438556997202255021e-45, 3.68497986490766191396e-45, -8.99736224944349445038e-46, -4.76939291682042459522e-46, 1.19937485162459096737e-46, 5.82040726062020658602e-47, -1.50385535615249676063e-47, -6.72616462956713966965e-48, 1.78205297817644374049e-48, 7.38860907471216632838e-49, -2.00401825093395479562e-49, -7.7414384249718504005e-50, 2.14657196087091290672e-50, 7.76027324479312047711e-51, -2.19722284429034769543e-51, -7.46330891795823694431e-52, 2.15556876024078292169e-52, 6.9035816908448509916e-53, -2.03215213281060049007e-53, -6.15597416593786546689e-54, 1.84541902013262184001e-54, 5.30276005769463245807e-55, -1.61778488503723673637e-55, -4.42096170937616090872e-56, 1.37180603525542390616e-56, 3.57354824641100594669e-57, -1.12718846469855703407e-57, -2.80510079143664101394e-58, 8.98986273710816341762e-59, 2.14144413140057579486e-59, -6.96988169890331886973e-60, -1.59209634406838590102e-60, 5.26047829917748212609e-61, 1.15421665371718842498e-61, -3.87006368545111781334e-62, -8.16906379835350295418e-63, 2.77861383099427469748e-63, 5.65067088676726885705e-64, -1.9491366191677791369e-64, -3.82396482520827455803e-65, 1.33725244171269890418e-65, 2.53412355231939918189e-66, -8.98181149634618227312e-67, -1.64599561245762537378e-67, 5.91137368036830973749e-68, 1.04876682397219654868e-68, -3.81553946656603622905e-69, -6.56022091090583133815e-70, 2.41719922388127039683e-70, 4.03149812972633749328e-71, -1.50412017246245257183e-71, -2.4356964442991288149e-72, 9.19965059070220482403e-73, 1.44767573041591163579e-73, -5.53434204799745267469e-74, -8.46988366099563096915e-75, 3.27670349126732185089e-75, 4.88082551292050200363e-76, -1.91046952962003818502e-76, -2.77176659349978881744e-77, 1.09752931642790199181e-77, 1.55200318755459760188e-78, -6.21574688707481885496e-79, -8.57263408609335177163e-80, 3.47206371950643954041e-80, 4.67330121401358790387e-81, -1.91383258865044825275e-81},
            {5.06687761943858411019e-41, 4.14988841472427809968e-40, -1.45015326199000040278e-39, -2.56295270508752344356e-39, 7.80572238890501924459e-39, 5.58360967979635224528e-39, -1.81639928930415363543e-38, -6.07636063738376679559e-39, 2.44016958080094612679e-38, 3.62349735353075488735e-39, -2.19220238257104079464e-38, -9.09701565304322603649e-40, 1.43955075855169911146e-38, -3.87170186992974738116e-40, -7.33291993924506935167e-39, 5.42934390743319153174e-40, 3.02300039498140820971e-39, -3.2789860008826451071e-40, -1.04099914149543044043e-39, 1.40317289094163339354e-40, 3.06849751747895464524e-40, -4.77744779651289556008e-41, -7.89372636269780540603e-41, 1.36424777998632600928e-41, 1.80027827949901202797e-41, -3.37111508429899340806e-42, -3.68741403969327241885e-42, 7.36339692667576094666e-43, 6.85698746924631721472e-43, -1.4442332022773429635e-43, -1.16831158701459550179e-43, 2.57495346389409400749e-44, 1.83826860040191671954e-44, -4.21468426549962878167e-45, -2.68925126311346390742e-45, 6.38520302340816076772e-46, 3.679535897104438209e-46, -9.01555767020956934364e-47, -4.73310564895541054718e-47, 1.19338739786879074664e-47, 5.75015520885122706227e-48, -1.48854121793883380453e-48, -6.62459545549724870379e-49, 1.75740593857204800486e-49, 7.2637752030055021843e-50, -1.97163670367408925222e-50, -7.60506777989725806757e-51, 2.10933393051873378761e-51, 7.62527860085860719289e-52, -2.15866622138550792537e-52, -7.34129814698777984171e-53, 2.11917702993359645774e-53, 6.80300634423005813511e-54, -2.00074406148478763693e-54, -6.08125036403703594659e-55, 1.82077511355403206505e-55, 5.25436002310111379492e-56, -1.6005511839333559757e-56, -4.39622467249966731569e-57, 1.36163413174184995495e-57, 3.56784947472515744284e-58, -1.123022392719833392e-58, -2.81303746112067126755e-59, 8.99396838604462102884e-60, 2.15779866206715280627e-60, -7.00474222583512742723e-61, -1.6124652230440551486e-61, 5.31256961022376219519e-62, 1.17530232775460397822e-62, -3.92860670269250562583e-63, -8.36539745321843759731e-64, 2.83598569204243910046e-64, 5.82056262968936089109e-65, -2.00066967575539273377e-65, -3.96293789564842212487e-66, 1.3806846269363478925e-66, 2.6426984875755832065e-67, -9.32983033950104320475e-68, -1.72756441514739269785e-68, 6.17872323020319726606e-69, 1.10797943810149976941e-69, -4.01356742615402801394e-70, -6.97706506110511258944e-71, 2.55922155817796301383e-71, 4.31688327255569000598e-72, -1.60305650289470140705e-72, -2.62614537819703459718e-73, 9.87080637710954941301e-74, 1.57179415513199773006e-74, -5.97862261080368632315e-75, -9.26110679238830571667e-76, 3.56418434300807877579e-76, 5.37486824109725006003e-77, -2.09257325362876533163e-77, -3.07428716513474546245e-78, 1.21059796579777507601e-78, 1.73386084302985961577e-79, -6.90466338512113174857e-80, -9.6468868890127297539e-81, 3.88437468445287667092e-81, 5.29739607735655084687e-82},
            {-1.28760990549822459562e-41, 5.92382868459967484795e-41, 2.01384795307907278126e-40, -6.37722417394200918676e-40, -7.21233010587510596921e-40, 2.22597952120607063166e-39, 1.13807582111732230827e-39, -3.98720519738716687385e-39, -9.70813323079971039894e-40, 4.4775375461009820152e-39, 4.4817579193610008785e-40, -3.52831068272475272417e-39, -4.50258228958451284965e-41, 2.09683168197367179173e-39, -9.50369206341866075757e-41, -9.87908625810917715591e-40, 8.55105874001272548008e-41, 3.8272027260861413251e-40, -4.49143231069581827369e-41, -1.25347120812048800868e-40, 1.77151600434714132217e-41, 3.54701756493773935729e-41, -5.69797528297450555134e-42, -8.82489352695594131359e-42, 1.55898496439678633066e-42, 1.95818556029462996099e-42, -3.72592982050453781968e-43, -3.9214797618238742241e-43, 7.92538617079240851745e-44, 7.15877197925609988839e-44, -1.52171442032736581769e-44, -1.20148274536072988205e-44, 2.66698215689944976555e-45, 1.86753559938434993571e-45, -4.30560103213567800273e-46, -2.70554110081208691838e-46, 6.45165967132049024898e-47, 3.67357056087225491816e-47, -9.0309164680899519878e-48, -4.69783922291766916852e-48, 1.18747099238692564032e-48, 5.68286374858832609393e-49, -1.47380471751044725911e-49, -6.52790255172063104798e-50, 1.73389118156345421142e-50, 7.14528427032830619093e-51, -1.94086760203252434614e-51, -7.47576333417510509107e-52, 2.07401264407627232045e-52, 7.49724075468523268148e-53, -2.12210333390095308178e-53, -7.22541523488486566637e-54, 2.08463580961815962261e-54, 6.70726143092320141169e-55, -1.97087763393339492565e-55, -6.00988891531173146478e-56, 1.79727752187177578716e-56, 5.20794589470957320894e-57, -1.58406118488907868458e-57, -4.3723645523592615721e-58, 1.3518568754253602434e-58, 3.56226149079823567378e-59, -1.11898949986819297526e-59, -2.82065184583941543303e-60, 8.99774669010268446604e-61, 2.17366635459370179346e-61, -7.03845850135768520525e-62, -1.63236434410361663641e-62, 5.36332493185396559434e-63, 1.19603313260884524471e-63, -3.98600675176843061372e-64, -8.55965092601376601631e-65, 2.89258374388822675428e-65, 5.9897345645012916103e-66, -2.05182404009279898351e-66, -4.10222804443922229767e-67, 1.42407104929754307217e-67, 2.75224723001422856276e-68, -9.67973209058889756596e-69, -1.81042391846650289119e-69, 6.44929247222146837585e-70, 1.1685443934040425497e-70, -4.21532589977001244269e-71, -7.40641737938476226516e-72, 2.70490640254913042482e-72, 4.61291876072191534635e-73, -1.70524627223859746538e-73, -2.82512021347254493965e-74, 1.056888715122815557e-74, 1.70240933683608560968e-75, -6.44399736439988974632e-76, -1.00998341131729372043e-76, 3.86746587067368885135e-77, 5.90243042325706849408e-78, -2.28606924503279283244e-78, -3.39972714319580316817e-79, 1.33161111217785235006e-79, 1.93095366650990097198e-80, -7.64736100605604358959e-81, -1.08198449292413211742e-81, 4.3321296353955045818e-82},
            {-1.232193564693024988e-42, -1.07489713300256374727e-41, 3.82933790664492702344e-41, 7.27015455580373974533e-41, -2.22772675787891684095e-40, -1.73671680674921537166e-40, 5.58646882051498655401e-40, 2.08942154507123750982e-40, -8.06589377417720072596e-40, -1.41782833177035909351e-40, 7.76837634618754426319e-40, 4.80163604617142660509e-41, -5.45604162146210517237e-40, 5.9765004890796948634e-42, 2.96605219287814777248e-40, -1.80971634053542492093e-41, -1.30227031535191700505e-40, 1.26934313819514486756e-41, 4.7669293589825466264e-41, -5.97073257280321861116e-42, -1.49091672372383000457e-41, 2.19503981294858799924e-42, 4.06263740467791175857e-42, -6.70989523038226372157e-43, -9.7986129881305070654e-43, 1.76563695468870118373e-43, 2.11926123706101836993e-43, -4.09195249846874663504e-44, -4.15534684353209251763e-44, 8.4919209136508065934e-45, 7.45504011152007042198e-45, -1.5983442674319107437e-45, -1.23354097871423113885e-45, 2.75652217827107706444e-46, 1.89536533161286308843e-46, -4.39271468992957470328e-47, -2.72057600014362049865e-47, 6.51411588626272806074e-48, 3.66719082197144583053e-48, -9.04379832667936591583e-49, -4.66360600404167577018e-49, 1.18164297657025081586e-49, 5.61840278489927154169e-50, -1.45962816316146372421e-50, -6.4358035323404484726e-51, 1.71144826380739788725e-51, 7.03273340346064635137e-52, -1.91161167907018792664e-52, -7.35306304786436282222e-53, 2.04048397490476257864e-53, 7.37570840892289466179e-54, -2.08740420839230955571e-54, -7.11527772676036633273e-55, 2.05182739978335024363e-55, 6.61606687890479072163e-56, -1.9424600702277064567e-56, -5.94171849133466613752e-57, 1.77486358462280040832e-57, 5.16343992859066643268e-58, -1.56828071846093079147e-58, -4.34937028958921160954e-59, 1.34246241857654521173e-59, 3.55681098142937275759e-60, -1.1150923163252848524e-60, -2.82798428786425488435e-61, 9.00129249923391194499e-62, 2.18908515062875119569e-62, -7.07113943856217511651e-63, -1.65182126909361319315e-63, 5.41283448419166368133e-64, 1.216424489917419417e-64, -4.04232244436453602026e-65, -8.75187668117673024535e-66, 2.94843569211597352794e-66, 6.15817200548666612582e-67, -2.10260424273064524168e-67, -4.24178762647797314205e-68, 1.46740264694846050497e-68, 2.86271505788914448533e-69, -1.00313730120817350013e-69, -1.89452782148826521696e-70, 6.7229411169079291247e-71, 1.2304303283726726322e-71, -4.42070782368091645215e-72, -7.84811727932869035575e-73, 2.85418893016917062752e-73, 4.91956765587821110567e-74, -1.81066301820827698164e-74, -3.03266718206396883138e-75, 1.12939137680296607218e-75, 1.83961264204221356221e-76, -6.93066349527342517756e-77, -1.0987137950356466196e-77, 4.18682845444482868374e-78, 6.46455180878479841044e-79, -2.49125428695148140608e-79, -3.74899049773331244442e-80, 1.46084138882527689434e-80, 2.14401087314518958432e-81, -8.44612938218389549452e-82, -1.20970656070953368308e-82},
            {3.18413433597311711513e-43, -1.50283449921159400165e-42, -5.45059084035254479875e-42, 1.74855534203326302987e-41, 2.13313168383369317842e-41, -6.57727649811575775416e-41, -3.69125885872933576265e-41, 1.26619313587083603849e-40, 3.49834474048416283776e-41, -1.52436064151604642146e-40, -1.88574507601731911436e-41, 1.28474338558202023681e-40, 3.96178414139351299333e-42, -8.14824904307657199382e-41, 2.51317849801066497409e-42, 4.08863736744450923849e-41, -3.04744651796979783132e-42, -1.68371542641798628012e-41, 1.80287760199110859916e-42, 5.85114487801050265946e-42, -7.74238112298518315161e-43, -1.75383290224586077427e-42, 2.67600477323663031212e-43, 4.61459207893844257269e-43, -7.81291321767297614406e-44, -1.08122309151188559855e-43, 1.98368288091463639844e-44, 2.28308868082367045497e-44, -4.46813490533932927158e-45, -4.38862738640426787105e-45, 9.06177131816968815377e-46, 7.74570637200181364172e-46, -1.67405192773609831633e-46, -1.26453053067605356239e-46, 2.84363021168502707539e-47, 1.92185595179956889565e-47, -4.47624263108882482706e-48, -2.73447889215682149476e-48, 6.57290424789879578665e-49, 3.66049075034214551018e-49, -9.05452531393996664692e-50, -4.63041195555472039511e-50, 1.17591785851391654498e-50, 5.55664848377167777559e-51, -1.44599392499924620361e-51, -6.34803709474636455565e-52, 1.69002083145545742362e-52, 6.92575296885639607708e-53, -1.88377760992038304029e-53, -7.23654409932057589459e-54, 2.00863423826429787436e-54, 7.26026829175850209951e-55, -2.05444987019796608699e-55, -7.01053426262817069673e-56, 2.02064383473819981571e-56, 6.52916386670435765753e-57, -1.91540588064096825389e-57, -5.87657917910545281545e-58, 1.75347513318689717825e-58, 5.12076803906352461199e-59, -1.55317764645914399908e-59, -4.32722966193520670584e-60, 1.33343921182009878137e-60, 3.55152140000461896419e-61, -1.11133273907334225205e-61, -2.83507178753127324665e-62, 9.00469153149931785237e-63, 2.2040905688735910381e-63, -7.1028860758595492578e-64, -1.67086231822619119919e-64, 5.4611835656362424491e-65, 1.2364915582764406807e-65, -4.09761044306051938951e-66, -8.94213051966516651024e-67, 3.00356942867386748688e-67, 6.32586592446828296505e-68, -2.15301610163901519599e-68, -4.3815744433201396349e-69, 1.51067190399195990142e-69, 2.97405122165705030285e-70, -1.03846223123977139485e-70, -1.97983204535134947309e-71, 6.99953729904599713554e-72, 1.29360665192859318769e-72, -4.62961014021570931427e-73, -8.30200247437258870361e-74, 3.00700505100815896835e-74, 5.23678680193385712165e-75, -1.91927913097008998639e-75, -3.24882534519153187591e-76, 1.20458883508639872409e-76, 1.98348935677378619931e-77, -7.43879983401261180627e-78, -1.19240487703170168416e-78, 4.52253833381054012174e-79, 7.06224926969233800851e-80, -2.7084162935258891312e-80, -4.12297336209354193271e-81, 1.59855726205210097154e-81, 2.37376381724134911396e-82, -9.30325093950495938356e-83},
            {3.00130346610884786096e-44, 2.78063510079866061386e-43, -1.00951452208892092139e-42, -2.0514010098850954991e-42, 6.32889713870978868864e-42, 5.34883085958285167093e-42, -1.7057285889908502915e-41, -7.06741678490757870435e-42, 2.64023248367158367115e-41, 5.37686813122853861217e-42, -2.71970005008829992035e-41, -2.24505762055676768999e-42, 2.03854160881617941312e-41, 1.0807790172875591347e-43, -1.18027113548234743813e-41, 5.63652189057594758752e-43, 5.50845170371316499051e-42, -4.75423845942147167652e-43, -2.13947091218466818376e-42, 2.47325012684767158159e-43, 7.08793035657096238838e-43, -9.83035296052850667627e-44, -2.04255183159984077564e-43, 3.2162672460932042518e-44, 5.20196294935820050136e-44, -9.00622634260396164633e-45, -1.18631078513386798151e-44, 2.21258041533674420914e-45, 2.44928115210724753733e-45, -4.8534795047563741313e-46, -4.62098604546077698378e-46, 9.63383706974533111365e-47, 8.03073310875968656725e-47, -1.74878194780944348677e-47, -1.29449629287879459021e-47, 2.92837073735680323726e-48, 1.94709989379794006944e-48, -4.55639376193089798619e-49, -2.74736179410211139054e-49, 6.62833157473580207468e-50, 3.65355307894713413892e-50, -9.06338597220925031575e-51, -4.5982577685242024875e-51, 1.1703077129623000015e-51, 5.49748310492740721323e-52, -1.43288456497169361454e-52, -6.26436116391477219608e-53, 1.66955630702360348769e-53, 6.82400327739126201824e-54, -1.85728125012276161582e-54, -7.12581887894815946803e-55, 1.97835913426470808376e-55, 7.15054130127906008973e-56, -2.02313122353459855534e-56, -6.91086153647175111536e-57, 1.99098591435470736717e-57, 6.44631289036948909059e-58, -1.88963617745773747506e-58, -5.81432158974278920178e-59, 1.7330581069267119761e-59, 5.0798596576022234132e-60, -1.53872172663181974145e-60, -4.30592954052847593371e-61, 1.32477602474263462283e-61, 3.54641332899246054274e-62, -1.10771211867037138344e-62, -2.8419482970479745012e-63, 9.00802126813209044589e-64, 2.21871586701277458804e-64, -7.13379218497514620259e-65, -1.68951261212572486619e-65, 5.50845281451650483448e-66, 1.25624920045695458345e-66, -4.15192546098178448413e-67, -9.1304709694122820574e-68, 3.05801289673330353901e-68, 6.4928123831479629085e-69, -2.2030665592632073986e-69, -4.52155136713074423313e-70, 1.55387272238114449315e-70, 3.08620877657710359041e-71, -1.07393614227563523558e-71, -2.06629472107257858848e-72, 7.27895735106034919378e-73, 1.35804361463502222621e-73, -4.84193389154572125941e-74, -8.76790992872803746838e-75, 3.16329164613736005475e-75, 5.56452765187670873589e-76, -2.03106609862837287793e-76, -3.47362714877268367439e-77, 1.28247961803150293017e-77, 2.13411896836937458287e-78, -7.96856798885840008662e-79, -1.29115559451346847759e-79, 4.87484808515767829782e-80, 7.69651635966699312856e-81, -2.9378343443422109337e-81, -4.52256308971145925961e-82, 1.74502283513744907734e-82, 2.62094500936945851674e-83},
            {-7.87951702827426663048e-45, 3.81215274075536571713e-44, 1.47065700027985630395e-43, -4.77986637049410614247e-43, -6.26440957518546355216e-43, 1.9323638560595646659e-42, 1.18292259562079599163e-42, -3.98804347183959491586e-42, -1.23541124978666508018e-42, 5.13509799667021663282e-42, 7.59031190483179438172e-43, -4.61879357521987503393e-42, -2.27598464716519123097e-43, 3.11987754693935196931e-42, -5.0203785931804541901e-44, -1.6640917034993617314e-42, 1.03693163256609759781e-43, 7.27120883441782333781e-43, -7.02807077922590809844e-44, -2.67656111367015362918e-43, 3.29805796298484060841e-44, 8.48444606972241552957e-44, -1.22568873140120803246e-44, -2.35725314068819155586e-44, 3.81729467592032257319e-45, 5.82370749065717009102e-45, -1.02885931772090240753e-45, -1.29486472097418121554e-45, 2.45177505546608741139e-46, 2.61748160617009045935e-46, -5.24704319963130542051e-47, -4.85213524892892950637e-47, 1.02071388769402242268e-47, 8.31012305498414988679e-48, -1.82249229472763834042e-48, -1.32348328445566276048e-48, 3.01081412424054446687e-49, 1.97118405646766873195e-49, -4.63336811862747699486e-50, -2.75932680088315025876e-50, 6.68068085740225556969e-51, 3.64645056608842351107e-51, -9.07063894508418432466e-52, -4.56713981024738445406e-52, 1.16482252407813858139e-52, 5.44079480110639655072e-53, -1.42028293672651906584e-53, -6.18455122202732557737e-54, 1.65000560142532236891e-54, 6.72717166893707362367e-55, -1.83204495868765144727e-55, -7.02053145943762263355e-56, 1.94956281540606769879e-56, 7.0461791050180511372e-57, -1.99334806433313116919e-57, -6.81596160156550175173e-58, 1.96276234792681706881e-58, 6.36729203464140411887e-59, -1.86507806236994703738e-59, -5.75480604567524610447e-60, 1.71356220721332499185e-60, 5.04064758800326483429e-61, -1.5248844866793492515e-61, -4.28545610664263763486e-62, 1.31646196007477492964e-62, 3.54150480093670668611e-63, -1.10423133488601367243e-63, -2.84864498729752038016e-64, 9.01135175714643609668e-65, 2.23299219364868531265e-65, -7.16394483131646047429e-66, -1.70779611586595783932e-66, 5.55471846212117131496e-67, 1.27571195782417759096e-67, -4.20532027523739213399e-68, -9.31695874840532859318e-69, 3.11179397560501395232e-69, 6.65901201341073241607e-70, -2.25276353581970850632e-70, -4.66168598420038024845e-71, 1.59700030265135838339e-71, 3.19914441430397831811e-72, -1.10954832960747917643e-72, -2.15387616642813315317e-73, 7.56108555811313015551e-74, 1.42371236744800720291e-74, -5.05758428079992461641e-75, -9.24567671388745451502e-76, 3.32298677216119852752e-76, 5.90273704301931561452e-77, -2.14599473312259354277e-77, -3.7070989632374310936e-78, 1.36306074950290095823e-78, 2.29157545375886922806e-79, -8.52011346947875486518e-80, -1.39506086743054868456e-80, 5.24399713090810334683e-81, 8.36832303173183300764e-82, -3.17977876232837747962e-82, -4.94863743027799859805e-83, 1.90049769028383764807e-83},
            {-7.32118282422694898505e-46, -7.18490695672486664179e-45, 2.65727072483668299699e-44, 5.76060557540679615935e-44, -1.79043147040559394583e-43, -1.63276964200877701604e-43, 5.17316959790513491445e-43, 2.35619473238218232677e-43, -8.56426384215551628452e-43, -1.98770815679223140905e-43, 9.41499364221032478278e-43, 9.7638207532073945229e-44, -7.51587751368475962958e-43, -1.64374520665549245178e-44, 4.6255918308186436267e-43, -1.58491378111212778413e-44, -2.29062677229806766201e-43, 1.71733468836686410575e-44, 9.42387588876452339114e-44, -9.97296086314992925783e-45, -3.30173019222688340184e-44, 4.29472460726107660776e-45, 1.00469178671514902903e-44, -1.50423351417604776433e-45, -2.6979776953010811574e-45, 4.48018623551662271408e-46, 6.47868635662620992276e-46, -1.1658400333325784903e-46, -1.40663179307321235939e-46, 2.70070796841283172832e-47, 2.78736206180048005672e-47, -5.6479395023520717028e-48, -5.08183064177770621446e-48, 1.07808097845574073088e-48, 8.58391281191762403616e-49, -1.89515261237945839834e-49, -1.35153623817779847356e-49, 3.0910350360492726817e-50, 1.99419002287545731302e-50, -4.70735668126464343147e-51, -2.77046699007055088189e-51, 6.73021308338564331246e-52, 3.63924718707380870413e-52, -9.07651619450482666275e-53, -4.53705092073393917218e-53, 1.15947047961032527039e-53, 5.38647739519563228353e-54, -1.4081722611675450429e-54, -6.10839880316220128564e-55, 1.63132284935654748673e-55, 6.63496992713023298083e-56, -1.80799699523573390445e-56, -6.92035447814272879546e-57, 1.92215706203551934172e-57, 6.9468611336710386789e-58, -1.96500820795417478001e-58, -6.7255594772913753075e-59, 1.93588899540925837407e-59, 6.29189542392728221328e-60, -1.84166408004261168162e-60, -5.69790183886487652258e-61, 1.69494058513763620435e-61, 5.00306786034930572937e-62, -1.51163910705646930819e-62, -4.26579503482099946188e-63, 1.30848646264807651192e-63, 3.53681158294857230489e-64, -1.10089086266613116195e-64, -2.85519049019432640213e-65, 9.01474633531259216448e-66, 2.2469487306120503243e-66, -7.19342489024160127347e-67, -1.72573568418600843251e-67, 5.60005257622813332718e-68, 1.29489403090202090454e-68, -4.25784575150729501063e-69, -9.50165629272050262198e-70, 3.16494038325577751419e-70, 6.8244695422340472303e-71, -2.30211579740153070264e-71, -4.80195025799333672748e-72, 1.64005103308558649348e-72, 3.31281829506213876154e-73, -1.14528917303826549042e-73, -2.24253885371274719461e-74, 7.84581389969159136159e-75, 1.49058500929755626194e-75, -5.27647070470557095431e-76, -9.73514077681251682382e-77, 3.48602983828322334277e-77, 6.25135792149708309416e-78, -2.26403537740381900378e-78, -3.94926160578726957599e-79, 1.44632792025148900095e-79, 2.45592757153794369165e-80, -9.09356679447391467004e-81, -1.50421170398548952479e-81, 5.6302122735552041683e-82, 9.07861550130178651158e-83, -3.43451123038801261543e-83, -5.40206382002654511892e-84},
            {1.95115865383390980642e-46, -9.66908125996453852058e-46, -3.95684088584872716206e-45, 1.30297806813142639333e-44, 1.82785470827980716061e-44, -5.64712470726486462396e-44, -3.75020095818536333293e-44, 1.24652053323121224674e-43, 4.28724653968399420162e-44, -1.71292931762111172136e-43, -2.95310265721459775065e-44, 1.6408933363210391394e-43, 1.11705108778909481044e-44, -1.17818843254120097574e-43, 1.25982437448600022329e-46, 6.66797137095213978286e-44, -3.32644930017851730287e-45, -3.08618157760709537955e-44, 2.6567753699995255321e-45, 1.20140929671673470112e-44, -1.36976450009726273805e-45, -4.02137843155641196805e-45, 5.48029633113166236651e-46, 1.17806433479033563208e-45, -1.82050636427243936725e-46, -3.06464175933975362168e-46, 5.20569730835283888775e-47, 7.16568762683169908875e-47, -1.31137246737828743434e-47, -1.52136720722053492375e-47, 2.95882252902389187728e-48, 2.95862264784459049263e-48, -6.05533942890491992408e-49, -5.30986679463650297753e-49, 1.13540865255486152432e-49, 8.85216717403002508997e-50, -1.96674266320043051251e-50, -1.3786992750743902411e-50, 3.16911110512893322801e-51, 2.0161943007660929095e-51, -4.7785413411462645725e-52, -2.78086724626302731388e-52, 6.77716894848403559932e-53, 3.63199917761157443803e-53, -9.08122585549324234656e-54, -4.50798108187912565379e-54, 1.15425822367875657671e-54, 5.33443014389213679526e-55, -1.39653618244918465604e-55, -6.03571013514121258815e-56, 1.61346516626128377355e-56, 6.54713198192060631982e-57, -1.78507098204433042426e-57, -6.82498637693996782488e-58, 1.89606055153473005089e-58, 6.85229191708439017684e-59, -1.93802671660090749335e-59, -6.63940101914093977541e-60, 1.9102881934588331722e-60, 6.21993183189928041452e-61, -1.81933172973874196341e-61, -5.64348655332449301247e-62, 1.67714955921971623855e-62, 4.96705958570450359694e-63, -1.4989603120170899852e-63, -4.24693164736124861562e-64, 1.30083932411887423759e-64, 3.53234742906432584123e-65, -1.09769082969145786111e-65, -2.86161111890813426617e-66, 9.01826227722432538974e-67, 2.26061282606822157241e-67, -7.22230752256902142907e-68, -1.74335310723131079546e-68, 5.64452329456494113251e-69, 1.31380926516629172057e-69, -4.30955087754899538968e-70, -9.68462734258554850615e-71, 3.21747959424917209658e-71, 6.98919335796301122128e-72, -2.35113283756570203162e-72, -4.94232021147671903605e-73, 1.68302238689277629408e-73, 3.42719388169745380229e-74, -1.18115007185134648078e-74, -2.33224736997304449561e-75, 8.13304178174610346451e-76, 1.55863462469564921728e-76, -5.49850676154178097668e-77, -1.02361416258431769963e-77, 3.65236175838947991075e-78, 6.61033001722417571653e-79, -2.38515809480976892666e-79, -4.20013084359185691776e-80, 1.53227564990682821003e-80, 2.62723915549902263979e-81, -9.68904457717368599073e-82, -1.61869531745107876464e-82, 6.03370824860421451076e-83, 9.82831624176369482325e-84, -3.70228494228924231261e-84},
            {1.78832537410002436587e-47, 1.85457638125119484334e-46, -6.98461597650388442817e-46, -1.61055658902421141511e-45, 5.04523680743099190542e-45, 4.94407045358202413001e-45, -1.55912756350863224592e-44, -7.75485947042582645708e-45, 2.75464808758504800332e-44, 7.19223556156206676947e-45, -3.22520414380342175675e-44, -4.04036838134794612986e-45, 2.73679507370855775243e-44, 1.06049953422754207431e-45, -1.78718354926773652487e-44, 3.67029324263587784042e-46, 9.37463933762155304949e-45, -5.94917089131657989464e-46, -4.07876573148659461228e-45, 3.91249738049407592788e-46, 1.50896237698213953786e-45, -1.83142500982825988543e-46, -4.84151204674021947855e-46, 6.87126726769232115765e-47, 1.36900141287120655514e-46, -2.17614102846432288978e-47, -3.4570511779604968331e-47, 5.99426643877187154452e-48, 7.88344825559731733215e-48, -1.46523905891657342153e-48, -1.63883580524808507852e-48, 3.22556968957065140968e-49, 3.13099042028566210055e-49, -6.46847138566404169222e-50, -5.53607320131344829295e-50, 1.19263010758363394869e-50, 9.1149742041752006849e-51, -2.03725094128030965301e-51, -1.40501565222665346013e-51, 3.24512183434802399317e-52, 2.03726857508360339578e-52, -4.84709498515162844652e-53, -2.79060501076049183311e-53, 6.82177045404623457686e-54, 3.62475594828211827648e-54, -9.08495477064413593479e-55, -4.47991797977649983527e-55, 1.14919107426369275987e-55, 5.28455749449824663282e-56, -1.38535880824760220193e-56, -5.96630491267811992843e-57, 1.59639242517804496982e-57, 6.46341186355349304043e-58, -1.76320542309123936664e-58, -6.73414895299672827724e-59, 1.87119820913191068324e-59, 6.76219871824103866154e-60, -1.91232521348463501031e-60, -6.55725101902109091975e-61, 1.88588815551200094995e-61, 6.1512234313195179324e-62, -1.79802302800059288814e-62, -5.59144544585105718389e-63, 1.66014835987283930515e-63, 4.93256481300107401908e-64, -1.48682426836581444365e-64, -4.22885104438766783312e-65, 1.29351068427907912275e-65, 3.52812430428391600904e-66, -1.09463106662237332724e-66, -2.86793106805582843372e-67, 9.02195137921456851598e-68, 2.27401011886817687145e-68, -7.25066261247181582346e-69, -1.76066915629651946879e-69, 5.68819504787894578142e-70, 1.33247114127297719102e-70, -4.36048280374182905259e-71, -9.86593658022176787757e-72, 3.26943877118390511712e-72, 7.15319511485517610955e-73, -2.39982477117642362889e-73, -5.08277562831054982402e-74, 1.72591282696776026927e-74, 3.54223777665184971199e-75, -1.21712338252336813783e-75, -2.42296837111778196504e-76, 8.42267576283753998245e-77, 1.62783531247343062389e-77, -5.72361023781758218974e-78, -1.07485209402325390099e-78, 3.82192508040071044836e-79, 6.97959047080891332948e-80, -2.50933284158846491189e-80, -4.45971787681103686347e-81, 1.62089743989374679963e-81, 2.80556940758213620366e-82, -1.03066505852344390805e-82, -1.73859525242233636011e-83, 6.45468829104145543397e-84, 1.06183241001479137241e-84},
            {-4.83454010781168240474e-48, 2.45222594816722334645e-47, 1.06183914894026370842e-46, -3.54266022797817833552e-46, -5.30204479161837823417e-46, 1.64218036350182815248e-45, 1.17739026876884618167e-45, -3.86851305278287613057e-45, -1.46519028903398716815e-45, 5.66167797641036506936e-45, 1.11797367571949065744e-45, -5.76516153541512165766e-45, -5.02897519589959694613e-46, 4.39223075667494569672e-45, 6.24704776584224291309e-47, -2.63307061298813596548e-45, 9.8100051644027427145e-47, 1.28881096358111524674e-45, -9.71285823893367367404e-47, -5.29780979812131314744e-46, 5.54656770346451182838e-47, 1.86978491877739711097e-46, -2.39369983243226254945e-47, -5.76770571040169347687e-47, 8.48343346244894874612e-48, 1.57785507759213959574e-47, -2.57256787880416451802e-48, -3.87491524427664750224e-48, 6.84604362532951977113e-49, 8.63067282424838994135e-49, -1.62720220560695353464e-49, -1.75881302059630413396e-49, 3.50041231727738012811e-50, 3.30421802451274819422e-50, -6.88662027469116271445e-51, -5.76031057455139801152e-51, 1.24968725272103988487e-51, 9.37244097308578760934e-52, -2.10667344236760935365e-52, -1.43052757088194911568e-52, 3.31914769262268497786e-53, 2.05747996556070160577e-53, -4.91318166816825559393e-54, -2.79975096247456593268e-54, 6.86422239175578608162e-55, 3.61756088681710095656e-55, -9.08787074161929938729e-56, -4.45284747720433372451e-56, 1.14427321054258379058e-56, 5.23676883982038371442e-57, -1.37462473742025976717e-57, -5.90001518779580357444e-58, 1.58006705185702485884e-58, 6.38358187675113588508e-59, -1.74234327325746671268e-59, -6.64758518064373292151e-60, 1.84750062997668128115e-60, 6.67632942735682501636e-61, -1.88783127267303775517e-61, -6.47889150756414116367e-62, 1.86262243665710140483e-62, 6.08560466806307555486e-63, -1.77768411632578959339e-63, -5.54167087949757468487e-64, 1.64389889776550952548e-64, 4.89952838919975558874e-65, -1.47520849139645248963e-65, -4.21153821310404501805e-66, 1.28649102963179794217e-66, 3.52415258362792477024e-67, -1.09171115097351441321e-67, -2.87417259576074655423e-68, 9.02586048501399046505e-69, 2.28716465460794841406e-69, -7.27855517069907445399e-70, -1.77770362915595746308e-70, 5.73112877248877609211e-71, 1.35089276903520816822e-71, -4.41068688908439122327e-72, -1.00456493138401988948e-72, 3.32084470792639183384e-73, 7.3164893729555008968e-74, -2.44820223937410560121e-74, -5.22329977235103262616e-75, 1.76872171779892926571e-75, 3.65791956269234153802e-76, -1.25320235924785013459e-76, -2.51467053113328992262e-77, 8.71462927722467232166e-78, 1.69816220665901494043e-78, -5.95170307673690580301e-79, -1.12721231090303757646e-79, 3.99466409500865345093e-80, 7.35907441415671095025e-81, -2.63652962353429141257e-81, -4.72802980067110604782e-82, 1.71218591736534159317e-82, 2.99097318848927356867e-83, -1.0946476770389340505e-83, -1.86399151879109865616e-84, 6.8933447105429887582e-85},
            {-4.37385329936259134894e-49, -4.78250250628445037388e-48, 1.83348204781326773505e-47, 4.48467726596894061272e-47, -1.4165006059445593713e-46, -1.48609054295511573655e-46, 4.67162541169394105826e-46, 2.52302599938834634772e-46, -8.79050001600556681822e-46, -2.55489923100058817758e-46, 1.09403211593111519176e-45, 1.61097159070239497154e-46, -9.85041225254293377013e-46, -5.51004480258177866538e-47, 6.81364763887280798084e-46, -4.4793071784088426724e-48, -3.77975846921596079672e-46, 1.95675504520137572939e-47, 1.73650432271754153166e-46, -1.49143560370856493133e-47, -6.77386992504442988446e-47, 7.62529562790934773491e-48, 2.28853118392254328892e-47, -3.06809770849074206569e-48, -6.80507672353335059564e-48, 1.03317751660070233424e-48, 1.80489473220254370499e-48, -3.01101697848944958572e-49, -4.31786000066929683908e-49, 7.7609190549511653304e-50, 9.40604975049894813163e-50, -1.79700894149416295478e-50, -1.88108552448138033162e-50, 3.7828286300495593793e-51, 3.47808226211948447187e-51, -7.30912600552976667204e-52, -5.98246743983809191555e-52, 1.30652993554618627375e-52, 9.62468988479346466427e-53, -2.17501257643902130063e-53, -1.45527603412027403051e-53, 3.39126937450987207585e-54, 2.07689128415145431907e-54, -4.9769568504649128841e-55, -2.80836963581853890049e-55, 6.90471371954515045064e-56, 3.61045206265719807546e-56, -9.09012453055307880163e-57, -4.4267540105031372276e-57, 1.13950783442711705629e-57, 5.19097827487648332032e-58, -1.36431907757904789244e-58, -5.83668436508795377563e-59, 1.56445383663782604624e-59, 6.30743096818389278664e-60, -1.72243155176204917404e-60, -6.56505727023421126609e-61, 1.82490356358393649667e-61, 6.59445068357625011425e-62, -1.86447787512724699051e-62, -6.40412023402310202396e-63, 1.84042945534663420824e-63, 6.02292124534867985487e-64, -1.75826490857921637094e-64, -5.49406180484826394234e-65, 1.62836555356146192473e-65, 4.86789782350885671239e-66, -1.46409175751925103749e-66, -4.19497811928341571335e-67, 1.27977118979200489277e-67, 3.52044122913501968294e-68, -1.08893044543478119436e-68, -2.88035618929720287115e-69, 9.03003195928416287305e-70, 2.30009899386406777021e-70, -7.30604570586734003515e-71, -1.79447539465700313106e-71, 5.773382112339271591e-72, 1.36908688455582359791e-72, -4.46020675131437978662e-73, -1.02238312027351867795e-73, 3.37172378313299467767e-74, 7.47909327052719496207e-75, -2.49627632463241583979e-75, -5.36387912482517333718e-76, 1.81144924409370757647e-76, 3.77421164804303426106e-77, -1.28938109729612592382e-77, -2.60732448747558112637e-78, 9.0088223573584272221e-79, 1.76959149042058735321e-79, -6.18271133119098288889e-80, -1.18067957048180915158e-80, 4.17052492577435656422e-81, 7.74871550665542380059e-82, -2.76671863770028751044e-82, -5.00507004611816158874e-83, 1.80613297031045248403e-83, 3.18350130446163954697e-84, -1.16086042654569978279e-84, -1.99496073188501038022e-85},
            {1.19859725604737009748e-49, -6.21870677607665710023e-49, -2.84271232296358485264e-48, 9.60882265196987702405e-48, 1.5296624156607406871e-47, -4.75349109160491458727e-47, -3.66384900832221475719e-47, 1.19260599425739742022e-46, 4.93971859821323153582e-47, -1.85533993657057409569e-46, -4.13724564866101431973e-47, 2.00460622437278471297e-46, 2.13963483883573868879e-47, -1.61771170623322744599e-46, -4.81814999668973812412e-48, 1.02559868017165697141e-46, -2.50459021252494234968e-48, -5.30080460298175481682e-47, 3.41812511692173512589e-48, 2.29752513003202822537e-47, -2.18866351290320195785e-48, -8.53833002480994104402e-48, 1.02186020188110551387e-48, 2.76973162291917039506e-48, -3.86609982886215157899e-49, -7.95826959365734363988e-49, 1.24303658357498647472e-49, 2.05031226713522291963e-49, -3.49252393780906013956e-50, -4.78544080014078763057e-50, 8.73855157194664560092e-51, 1.02082651413347943378e-50, -1.97439509675015405768e-51, -2.00545161524130817485e-51, 4.07231485207482227731e-52, 3.65238260883275255444e-52, -7.73538156856131553447e-53, -6.20245702016085342977e-53, 1.36311521317145230994e-53, 9.87185551692667516458e-54, -2.24227620902181360096e-54, -1.4793007450711319627e-54, 3.46156719851277983656e-55, 2.09556128845702167815e-55, -5.03856768160130770924e-56, -2.81651998104405502777e-56, 6.94341883342653790115e-57, 3.60346284631120271778e-57, -9.09185164040172368008e-58, -4.40162092273302712294e-58, 1.13489730999096546334e-58, 5.14710435813296093272e-59, -1.35442745462788209888e-59, -5.77616629081848858924e-60, 1.5495197616816819084e-60, 6.23476326398726677616e-61, -1.70342099468087291561e-61, -6.4863449346651640468e-62, 1.80334745299192741705e-62, 6.51634619629258543987e-63, -1.84220292276313458368e-63, -6.33274930262778096668e-64, 1.81925206508489903388e-64, 5.96302920594045605952e-65, -1.73971877356715173647e-65, -5.44852328465095324507e-66, 1.61351498681123824409e-66, 4.83762315621151388086e-67, -1.45345402310312748132e-67, -4.17915578359725343933e-68, 1.27334233217504640146e-68, 3.51699794736119740062e-69, -1.08628813134614062945e-69, -2.88650071587237447703e-70, 9.03450411448065024779e-71, 2.31283431306838164999e-71, -7.33319056637063820062e-72, -1.81100243632596224935e-72, 5.81500961069769385566e-73, 1.38706585000364320355e-73, -4.50908432003654032978e-74, -1.04005480189355000603e-74, 3.42210192273408135244e-75, 7.64102622643269463522e-76, -2.54405847495217078921e-76, -5.50450313846864239318e-77, 1.85409633570067348031e-77, 3.89108911641352977593e-78, -1.32565447920971647109e-78, -2.70090278357014463181e-79, 9.30518135784403290284e-80, 1.84210040391735062655e-80, -6.41656510372275133102e-81, -1.23523898975513256742e-81, 4.3494556024301576235e-82, 8.14844642895438404498e-83, -2.89987040013938952572e-83, -5.29083879882262310237e-84, 1.9027298740469146518e-84, 3.3832007889514025668e-85, -1.22931043463778174227e-85},
            {1.0710183895375325241e-50, 1.23221958975763132012e-49, -4.80703812277333924385e-49, -1.24414781209085868288e-48, 3.96340837326270899157e-48, 4.43683359070814787935e-48, -1.39213438914135784154e-47, -8.12331782285679401123e-48, 2.78453150677213006707e-47, 8.93076689103619683801e-48, -3.67712076696046621762e-47, -6.23737160595077846943e-48, 3.50695840088285774923e-47, 2.57515077816229579613e-48, -2.56539855756442353428e-47, -1.95580614628985339943e-49, 1.50271579368290862358e-47, -5.99546465161673757777e-49, -7.27947409980076739531e-48, 5.51156396245286073247e-49, 2.9900494154678880474e-48, -3.09971890096409792522e-49, -1.06231095324100493829e-48, 1.33993614668701086658e-49, 3.31775864689104676075e-49, -4.79905633318766936036e-50, -9.23144971014683474202e-50, 1.47923057687435814074e-50, 2.31422765867934754469e-50, -4.01793794683498512008e-51, -5.27715401374086825936e-51, 9.77839634517566468237e-52, 1.10360144928396756588e-51, -2.15908896072717238641e-52, -2.1317213968993785412e-52, 4.3683872007656081285e-53, 3.82693971965638222826e-53, -8.16483079670492575094e-54, -6.42021439988205582737e-54, 1.41940667027402782091e-54, 1.01140819120363615055e-54, -2.30847681821307461892e-55, -1.50264003816915469158e-55, 3.53012062240622619294e-56, 2.11354492836684829176e-56, -5.09815331629706423889e-57, -2.82425587216353695786e-57, 6.98049874076110519324e-58, 3.59662245436003774479e-58, -9.09317389982987453471e-59, -4.3774307430704323296e-59, 1.13044328392265210447e-59, 5.10506987922804089913e-60, -1.34493601593130319937e-60, -5.71832442610095134883e-61, 1.53523384225639456744e-61, 6.16539675719813433317e-62, -1.68526574206798620524e-62, -6.41124383828786631987e-63, 1.78277702202883991969e-63, 6.441815241956799611e-64, -1.82094880349662904921e-64, -6.26460394708287934302e-65, 1.7990371701518556069e-65, 5.90579410159678228997e-66, -1.72200224878744682714e-66, -5.40496605780110913916e-67, 1.59931596202538679028e-67, 4.8086568324660578803e-68, -1.44327634908549798209e-68, -4.16405634500310167908e-69, 1.2671959553549498136e-69, 3.51382932962812562773e-70, -1.08378323793980975193e-70, -2.89262355994747021561e-71, 9.03931159590198749853e-72, 2.32539049847540860722e-72, -7.36004225527020285739e-73, -1.82730189479703570199e-73, 5.85606289171662726533e-74, 1.40484165559213520498e-74, -4.55735989192879594262e-75, -1.05758654413419171509e-75, 3.47200457020903191185e-76, 7.80230967002731296026e-77, -2.59156043632213506968e-77, -5.64516400787495968313e-78, 1.89666459841960391817e-78, 4.00852958228603477477e-79, -1.36201812379206031417e-79, -2.79537980922504464952e-80, 9.60363868257808654037e-81, 1.91566724682363779524e-81, -6.65319847563729960648e-82, -1.29087608135020928214e-82, 4.53140611909359519212e-83, 8.55819933642248794334e-84, -3.03595586060745179832e-84, -5.58533339652201205601e-85, 2.00196740935410060926e-85, 3.59011517812916462022e-86},
            {-2.97326667639271410471e-51, 1.57691197678278853502e-50, 7.59366854339611157409e-50, -2.60033141949511066114e-49, -4.39119694432597059691e-49, 1.37003701788514581231e-48, 1.13092927964871936002e-48, -3.65377679195496432081e-48, -1.64516987021500092752e-48, 6.03125628443251072731e-48, 1.50163648925099351719e-48, -6.90258478903927556991e-48, -8.73780390161874807183e-49, 5.89091520625904663428e-48, 2.68691721344448287329e-49, -3.94363509876572845129e-48, 4.48709821066968126878e-50, 2.14917806756022656433e-48, -1.14861338800502713738e-49, -9.80862771211688142533e-49, 8.40676864924221194675e-50, 3.83331254026648342812e-49, -4.26458654337811802492e-50, -1.30603832449044380423e-49, 1.72427371872976921906e-50, 3.93679813035891471009e-50, -5.87809437305125357439e-51, -1.06283048028236702052e-50, 1.74296779601591694211e-51, 2.59669483215820501651e-51, -4.5879314419132667667e-52, -5.79244781846399907592e-52, 1.08797313395914175401e-52, 1.18880124462007671028e-52, -2.35081447722474099701e-53, -2.25971678684472093478e-53, 4.67058330567039156113e-54, 4.00159394870955648923e-54, -8.59696591817477628337e-55, -6.63569395287041707241e-55, 1.47537378494482405492e-55, 1.03515202629430656531e-55, -2.37363075523029058144e-56, -1.52533083719173601585e-56, 3.59700785706157685002e-57, 2.13089358397100724969e-57, -5.15584525077275646267e-58, -2.83162656724218844669e-58, 7.01610214088361266915e-59, 3.58995642950220640788e-59, -9.09420087518388762024e-60, -4.35416542080190578275e-60, 1.12614678967022563125e-60, 5.06480163454655690896e-61, -1.33583142846861403016e-61, -5.66303109550050857269e-62, 1.52156698087397846396e-62, 6.09916212764104954663e-63, -1.6679230557698681649e-63, -6.33956420637018374416e-64, 1.76314090497292653971e-64, 6.37067131549909740597e-65, -1.80066200118682960517e-65, -6.19952142728466458375e-66, 1.77973538021225612328e-66, 5.85109024034977211573e-67, -1.70507478187389682784e-67, -5.36330613906796296914e-68, 1.58573919018365106731e-68, 4.78095358129985748339e-69, -1.43354083092932206836e-69, -4.14966511308464359846e-70, 1.26132388140743395983e-70, 3.51094097699444268497e-71, -1.08141466788264814848e-71, -2.89874074836405432731e-72, 9.04448572924932510687e-73, 2.33778623366096948541e-73, -7.38664972034646819805e-74, -1.84339010892512979277e-74, 5.89659083215388393518e-75, 1.42242592338048430675e-75, -4.60507218725362268692e-76, -1.07498488787042978564e-76, 3.52145666362057775946e-77, 7.96296679629346164826e-78, -2.63879419265251578966e-78, -5.78585645527846712465e-79, 1.93915625030578766863e-79, 4.1265130517131611493e-80, -1.39846833784682770148e-80, -2.89073173965133068361e-81, 9.90413251645976210611e-82, 1.99027137621931737998e-82, -6.89254942718580507206e-83, -1.34757678440176318092e-83, 4.71632847897230944863e-84, 8.97790627440945641596e-85, -3.17494650513415054606e-85, -5.88854870486794196967e-86, 2.10383597253092166855e-86},
            {-2.62549381380331082931e-52, -3.17230361842658527504e-51, 1.25886946281909814281e-50, 3.43970063159085778034e-50, -1.10543458154154951557e-49, -1.31643990166665612673e-49, 4.12734519787945508576e-49, 2.59068771504015805308e-49, -8.75953461391709421717e-49, -3.07754923232330127921e-49, 1.22527952325927714394e-48, 2.35737804842571467411e-49, -1.23582468082124979341e-48, -1.12736794795626007165e-49, 9.54594049265782117437e-49, 2.1054347971702767123e-50, -5.89592651218494531351e-49, 1.64164643748206963969e-50, 3.00740967505223029358e-49, -1.96685310891292401329e-50, -1.29904520767739691993e-49, 1.22968975673533416635e-50, 4.84746294105187774675e-50, -5.72622392356127699609e-51, -1.58823182769346584744e-50, 2.18255254940357147704e-51, 4.63082645225488294547e-51, -7.11403819202689519966e-52, -1.21520529158633211198e-51, 2.03535236243068830081e-52, 2.89770763049697494756e-52, -5.20301093471871564745e-53, -6.33073203782054170254e-53, 1.20416823169064195866e-53, 1.27630008068458239273e-53, -2.54929400548154075767e-54, -2.389271386895997996e-54, 4.97846314910521851029e-55, 4.17620390425271894132e-55, -9.03132498270551582328e-56, -6.8488670182330785302e-56, 1.53099134205355549306e-56, 1.05843269414764673846e-56, -2.43775759728196015637e-57, -1.54740863487648707809e-57, 3.66230556298662155834e-58, 2.1476552934436782763e-58, -5.21176767056813667416e-59, -2.83867712547984405254e-59, 7.05036641914968473868e-60, 3.58348706379009305327e-60, -9.09503112941526702259e-61, -4.33180652094030571696e-61, 1.12200833755031903989e-61, 5.02623021155462658923e-62, -1.32710087307438321421e-62, -5.61016680337064777714e-63, 1.50849183317850979911e-63, 6.03590167906710373387e-64, -1.65135306451500481203e-64, -6.271129576194424009e-65, 1.74439131364974118001e-65, 6.30274091826148405044e-66, -1.7812927452023141481e-66, -6.13735003438327787242e-67, 1.76130069933212248754e-67, 5.79880000333142205244e-68, -1.68889849668709210547e-68, -5.32346445130903700827e-69, 1.57275718413101052886e-69, 4.7544702999046134262e-70, -1.42423053353400412384e-70, -4.13596761096245950517e-71, 1.25571824749680682012e-71, 3.5083376116854909571e-72, -1.07918121958199491163e-72, -2.90486706441838190925e-73, 9.0500548345506798744e-74, 2.350039080973455681e-74, -7.41305862132708178308e-75, -1.85928265548427546551e-75, 5.9366397235863906536e-76, 1.43982991257030669802e-76, -4.65225840703523255349e-77, -1.09225633181740489566e-77, 3.57048261850026606959e-78, 8.12302234410381104257e-79, -2.68577191245719795866e-79, -5.92657753098250373056e-80, 1.98157406309183424486e-80, 4.24502178878613699004e-81, -1.43500207059394287027e-81, -2.98693647368570197984e-82, 1.02066065628085755422e-82, 2.06589320047247762239e-83, -7.13455975052650336163e-84, -1.40532749085338596716e-84, 4.90417672701495098524e-85, 9.40749955744399438137e-86, -3.31681444733598306025e-86, -6.20047747209188190206e-87},
            {7.3794635575180183245e-53, -3.99839432359415787296e-52, -2.02435385661042532061e-51, 7.02211545594631950335e-51, 1.25478248820479903693e-50, -3.9327557220489100569e-50, -3.46497341702399159297e-50, 1.11287387650758120079e-49, 5.41907533021785889598e-50, -1.9458533371859488142e-49, -5.35903826819293607256e-50, 2.35511998727225767082e-49, 3.45684412891348007023e-50, -2.12237287380183815688e-49, -1.30956994115359816245e-50, 1.49812127753781240721e-49, 2.80310950428500054352e-52, -8.59686338873491140993e-50, 3.63172204660785173216e-51, 4.12599966706468500623e-50, -3.13702003815181295977e-51, -1.69360491836254190259e-50, 1.73984010051044637331e-51, 6.053409645997924421e-51, -7.53026328661661528363e-52, -1.91208318028588715168e-51, 2.72255235833652597992e-52, 5.40359276060225097932e-52, -8.51734124029758489708e-53, -1.38054557085711957799e-52, 2.35738347880266092671e-53, 3.21720576016289563444e-53, -5.86352860222953916052e-54, -6.89138703615298085998e-54, 1.32632461866956871544e-54, 1.3659755025827244126e-54, -2.75425068278079310751e-55, -2.52023024693365073581e-55, 5.29160960775128961089e-56, 4.35064505376592581571e-56, -9.4674892266558254624e-57, -7.05971980612623928777e-57, 1.58623889295244356891e-57, 1.08126618258366938261e-57, -2.500879582515313577e-58, -1.56890748980103941574e-58, 3.72608861614839700573e-59, 2.16387497009282405196e-59, -5.26603780284977084431e-60, -2.84544878514349820607e-60, 7.08341856044851944995e-61, 3.57723377213134923723e-61, -9.09575334545061993561e-62, -4.31033538737786339762e-62, 1.11802799276147076919e-62, 4.98928978245171256408e-63, -1.31873203565954485086e-63, -5.55961961109108909681e-64, 1.49598268457388595875e-64, 5.97546838029443875795e-65, -1.63551853328509161767e-65, -6.20577567336515352659e-66, 1.72648373765762755893e-66, 6.23786246670816530159e-67, -1.76279469502845108425e-67, -6.07794819207740117854e-68, 1.74369024550081255653e-68, 5.7488132238453918263e-69, -1.67343798137859311153e-69, -5.28536648723887547131e-70, 1.56034412648382207102e-70, 4.72916594325434575678e-71, -1.41532943073328352442e-71, -4.1229496101594256012e-72, 1.2503714969196304841e-72, 3.50602317650893538625e-73, -1.07708160665812871078e-73, -2.91101615191550639195e-74, 9.0560445098862590012e-75, 2.36216555733982391649e-75, -7.43931157614608980856e-76, -1.87499438738684107971e-76, 5.97625342548709335955e-77, 1.45706452601746122061e-77, -4.69895429037653466487e-78, -1.10940731965129965207e-78, 3.61910631578611890531e-79, 8.28250239565594566017e-80, -2.73250590162571819007e-80, -6.06732642764470200065e-81, 2.02392130836825572547e-81, 4.36404018785643008866e-82, -1.47161687068218306413e-82, -3.08397357172268619759e-83, 1.05110097873906352935e-83, 2.14251416967821423877e-84, -7.37917495696350167408e-85, -1.4641150676002166938e-85, 5.09490697184489800421e-86, 9.84691211448834843008e-87, -3.46153250930990537744e-87},
            {6.44281913614258243117e-54, 8.16099017326285292056e-53, -3.2931998891523143414e-52, -9.4795115421595220417e-52, 3.07394326518974451297e-51, 3.88359389288443994966e-51, -1.21779127900661242511e-50, -8.1905834267156220156e-51, 2.7376724440927851282e-50, 1.04705048363760342779e-50, -4.04980950192319440749e-50, -8.72936594527236779733e-51, 4.31314352660546715384e-50, 4.71496223966562905375e-51, -3.51291064357712144547e-50, -1.28996708085167019353e-51, 2.28464022235499689946e-50, -3.56572069022457069635e-52, -1.22549533160771668655e-50, 6.73342058461655232058e-52, 5.55981412593763755899e-51, -4.75616460046566295519e-52, -2.17649048118491991568e-51, 2.39504944575572328326e-52, 7.47266755162233434698e-52, -9.72468869973089668457e-53, -2.28073720415030073803e-52, 3.35209313852696566266e-53, 6.25860606316900049186e-53, -1.00980300046681876124e-53, -1.55908359950173994791e-53, 2.70995614337749224766e-54, 3.55508061388844250713e-54, -6.5696943012263903122e-55, -7.47377168921524299825e-55, 1.45433126065796573908e-55, 1.45770893311097403069e-55, -2.96541042528014317372e-56, -2.65244954576638334363e-56, 5.60962866457974389203e-57, 4.5248083894483953107e-57, -9.90508042826484823578e-58, -7.26825151592437692253e-58, 1.64110025973162934319e-58, 1.10366868871285240285e-58, -2.5630211177473149354e-59, -1.58986003694891233255e-59, 3.78842993166498169908e-60, 2.17959460814863919825e-60, -5.31876626783363543681e-61, -2.85197930606431522882e-61, 7.11537598807847591295e-62, 3.57121342220219802905e-62, -9.09644732942201557804e-63, -4.28973327856298037917e-63, 1.11420544296025193014e-63, 4.95391790742965009708e-64, -1.3107130961388550302e-64, -5.51128456912678514592e-65, 1.4840153366675290869e-65, 5.91772499877172528449e-66, -1.6203846543404021227e-66, -6.14334939903076885763e-67, 1.70937667396698286957e-67, 6.17588530820755651258e-68, -1.74512465592579954487e-68, -6.02118364354177041932e-69, 1.72686399725142132963e-69, 5.70102662223818097375e-70, -1.65866009607914979447e-70, -5.24894199810457086762e-71, 1.54847574882076411993e-71, 4.70500141900107611296e-72, -1.4068223490388528659e-72, -4.11059715860535353727e-73, 1.24527636977953047748e-73, 3.50400092360199843476e-74, -1.07511447493463781694e-74, -2.91720061013467912726e-75, 9.06247788798104549208e-76, 2.37418120480801305548e-76, -7.46544838794119869226e-77, -1.8905394703858112759e-77, 6.01547350955433801887e-78, 1.47414031771847777241e-78, -4.74519417148606666022e-79, -1.12644422913502579866e-79, 3.66735109411024239789e-80, 8.4414341952680618263e-81, -2.77900856168582457021e-81, -6.20810430764088118672e-82, 2.06620170818280050901e-82, 4.48355465153045648495e-83, -1.50831084570817883558e-83, -3.18182419378618877451e-84, 1.08172961697568812647e-84, 2.2201167631600207442e-85, -7.62634417978124045676e-86, -1.52392687486129201894e-86, 5.28847739820162215589e-87, 1.02960778023353136797e-87},
            {-1.8324611992094396787e-54, 1.01376489125024601927e-53, 5.38643113790163046763e-53, -1.89253969685189494269e-52, -3.57023717946214278502e-52, 1.12463933415722602692e-51, 1.05434056313575790961e-51, -3.37101457668141452353e-51, -1.76714608884872825121e-51, 6.23338216247506601899e-51, 1.8842263104347019325e-51, -7.96644046891681433264e-51, -1.33285300742556780131e-51, 7.56979812188726729387e-51, 5.90875135630846111785e-52, -5.6263527863966341554e-51, -8.62305655408020215963e-53, 3.39526225268182701405e-51, -1.04856838612614505483e-52, -1.71150994548453395006e-51, 1.13348485402720747935e-52, 7.37001907341535381895e-52, -6.93616573437746538932e-53, -2.76042570003959365803e-52, 3.22143123541784923327e-53, 9.12720392332536396094e-53, -1.23594976110247200331e-53, -2.69727238916425207765e-53, 4.07897954924156760306e-54, 7.19912669546045964752e-54, -1.18656589845472735649e-54, -1.75100985460177019008e-54, 3.09386308034590679164e-55, 3.91118089332999190487e-55, -7.32158773051676468934e-56, -8.07723046891715087901e-56, 1.58806837909125569957e-56, 1.55138606827940518326e-56, -3.18250360320289022083e-57, -2.78579620992158666517e-57, 5.9321493513456858172e-58, 4.69859916094738172324e-58, -1.03437582926595918918e-58, -7.47447264930532504166e-59, 1.69556308183560444517e-59, 1.12565650004125416083e-59, -2.62420835059328458748e-60, -1.61029750900533791513e-60, 3.84940033567984978579e-61, 2.19485347714837692516e-61, -5.37005742524230208741e-62, -2.85830328008347566131e-62, 7.14634733365613537776e-63, 3.56544062611904432635e-63, -9.09718490734093572378e-64, -4.26998147991137750905e-64, 1.1105400568204250294e-64, 4.92005534762531099314e-65, -1.30303271565293632188e-65, -5.46506319849254480564e-66, 1.47256700268629517003e-66, 5.86254331642581766917e-67, -1.60591885758887105594e-67, -6.08370791554774223628e-68, 1.69303138261458164801e-68, 6.11666883191883207709e-69, -1.72824232215759545427e-69, -5.9669327146933200117e-70, 1.7107845643977057752e-70, 5.65534329086826432099e-71, -1.64453379814234772207e-71, -5.21412470687805822967e-72, 1.53712922106654220688e-72, 4.68193948755329913154e-73, -1.3986949153129337919e-73, -4.09889660279562130334e-74, 1.24042589343550192976e-74, 3.50227349369713809402e-75, -1.07327841725309370621e-75, -2.92343208054718025488e-76, 9.0693758684022697371e-77, 2.38610065618656964206e-77, -7.49150625435802546229e-78, -1.90593141824422592589e-78, 6.05433939569440066793e-79, 1.49106750106585970923e-79, -4.79101103606661212262e-80, -1.14337336301578598617e-80, 3.71523974581963029963e-81, 8.59984598586446694243e-82, -2.82529235301247125216e-82, -6.34891414274555311955e-83, 2.10841938973746685454e-83, 4.60355347440520409446e-84, -1.54508262414526311377e-84, -3.28047103810212020411e-85, 1.11254244624266288685e-85, 2.29868447448760186066e-86, -7.87602007382763860757e-87, -1.58475078114302869138e-87, 5.48484827100907979937e-88},
            {-1.58257415149925283552e-55, -2.09805613472723835727e-54, 8.60634568025409238642e-54, 2.60474432985237654875e-53, -8.52385015707399816783e-53, -1.13960107386184403063e-52, 3.57693628159181767316e-52, 2.56882513187608999606e-52, -8.50391276916847241957e-52, -3.52135406160532244912e-52, 1.32834086551848238985e-51, 3.1758591795252555642e-52, -1.49169551225425561379e-51, -1.9049338118879229022e-52, 1.27929514713317134076e-51, 6.60333418301534087432e-53, -8.7493296511416311516e-52, 2.78953367695030156347e-54, 4.92930353077332967971e-52, -2.18589578527954977524e-53, -2.34606715753289656635e-52, 1.79047168858971032449e-53, 9.62401810805659236882e-53, -9.80405719922120025237e-54, -3.45883859085293770013e-53, 4.24717850272988326466e-54, 1.10392890316699819196e-53, -1.54863554412213699754e-54, -3.16468397495015228397e-54, 4.91095007209734405405e-55, 8.22816169232551286153e-55, -1.38292760686244582538e-55, -1.9564753292200479868e-55, 3.50979766507223972738e-56, 4.28531797502504950482e-56, -8.1191705173905712564e-57, -8.70109969064399422921e-57, 1.72740925341992693005e-57, 1.64689717115952623441e-57, -3.40526642521725847529e-58, -2.92014748758426642392e-58, 6.25882347360734614834e-59, 4.87193567933227182014e-59, -1.07832178966276481527e-59, -7.678403501412627364e-60, 1.74961840260299154649e-60, 1.14724589499045454632e-60, -2.68446879846143808388e-61, -1.63024976594527634509e-61, 3.90906847720881165838e-62, 2.20968830498761003047e-62, -5.42000971275165946219e-63, -2.86445241252233629024e-63, 7.17643314345062449317e-64, 3.55992799852339957485e-64, -9.0980307271906431989e-65, -4.25106139651155264317e-65, 1.10703093479313461982e-65, 4.88764588770159041102e-66, -1.29568002256076116198e-66, -5.4208630167946418131e-67, 1.4616162110949770647e-67, 5.80980341889751583243e-68, -1.59209063826341789435e-68, -6.02671781968473160537e-69, 1.67741166562354852915e-69, 6.06008166431183564084e-70, -1.7121100447409662221e-70, -5.915079645629861076e-71, 1.69541698027261452304e-71, 5.61167222412192828021e-72, -1.63102998311878853145e-72, -5.18085204380615069058e-73, 1.52628305009373151185e-73, 4.65994466720542919667e-74, -1.39093350807626860453e-74, -4.0878346049736505491e-75, 1.23581337283942657392e-75, 3.50084298695389707898e-76, -1.07157198637953569671e-76, -2.92972132604627001074e-77, 9.07675732780770507762e-78, 2.39793769612129872712e-78, -7.51751996060224033606e-79, -1.92118312637331924074e-79, 6.09288848006182038179e-80, 1.50785595769661007091e-80, -4.83643657678618151891e-81, -1.16020094148664742936e-81, 3.762794516188948893e-82, 8.7577668616107776855e-83, -2.87136976248952164653e-83, -6.48976056538887482185e-84, 2.15057884388100594415e-84, 4.72402673247058712651e-85, -1.58193131958144218333e-85, -3.37989828047396481729e-86, 1.14353579583043563691e-86, 2.37820179441667631446e-87, -8.12815871285098219616e-88, -1.64657517512930007848e-88},
            {4.55253558045741042317e-56, -2.57018667658005394061e-55, -1.43071414897951453926e-54, 5.09110066474336298122e-54, 1.01180798313066421131e-53, -3.20463329576078526713e-53, -3.18785591198860968999e-53, 1.0158385038268882293e-52, 5.70975818029692564537e-53, -1.98346901307107603228e-52, -6.53717342898661801456e-53, 2.67286679402607066503e-52, 5.02947658157927048495e-53, -2.67432801947909336058e-52, -2.53178410298678220643e-53, 2.09030976294292812757e-52, 6.05904841571239347535e-54, -1.32487209522761430126e-52, 2.56486148612960471688e-54, 7.00626116434944956134e-53, -3.94423626166332840541e-54, -3.16151319491714145449e-53, 2.69985155744612674565e-54, 1.23953108921211996632e-53, -1.3502150741982257234e-54, -4.28578458673529381508e-54, 5.50242843508793482834e-55, 1.32313532900858365144e-54, -1.91582506642599415758e-55, -3.68586953279403738198e-55, 5.85563127262613470686e-56, 9.34846358450334742925e-56, -1.59973974532650616431e-56, -2.17559401806278314781e-56, 3.95835764308617497549e-57, 4.6772709799509217991e-57, -8.96229805165982736042e-58, -9.3447129782086424895e-58, 1.87222184906119415389e-58, 1.74413727848686971301e-58, -3.63344206496365496792e-59, -3.05539049191325610855e-59, 6.58932516278767719322e-60, 5.04474819416481797828e-60, -1.12231872153544162647e-60, -7.88007281407584940907e-61, 1.80326029316326575e-61, 1.16845306017685155696e-61, -2.7438310276741829766e-62, -1.64974533090862408951e-62, 3.96750077300964473991e-63, 2.22413344986363221833e-63, -5.46871597420787464521e-64, -2.87045577746550795759e-64, 7.20572652622586979883e-65, 3.5546863851374599177e-65, -9.0990429769992132095e-66, -4.23295462913813627164e-66, 1.1036769531142436017e-66, 4.85663616787925748736e-67, -1.28864459758652612567e-67, -5.37859710453929001966e-68, 1.45114271671597463182e-68, 5.75939305034430214022e-69, -1.57887140011103634264e-69, -5.97225439381456266054e-70, 1.66248366663253241856e-70, 6.00600094013888397353e-71, -1.69669262105279388009e-71, -5.86551598305234488665e-72, 1.6807285131706280575e-72, 5.56992788899317386497e-73, -1.61812133984799640484e-73, -5.14906490236664903769e-74, 1.51591698667173907355e-74, 4.63898314415982126433e-75, -1.38352521217987597146e-75, -4.07739815608332676919e-76, 1.23143238085635891453e-76, 3.49971102628276435187e-77, -1.06999370623655067965e-77, -2.93607830337557349636e-78, 9.08463931043163810814e-79, 2.409705317928063132e-79, -7.54352205756208828461e-80, -1.93630690395471578715e-80, 6.13115625556054512502e-81, 1.52451524678438696032e-81, -4.88150124761026301035e-82, -1.1769330960267448273e-82, 3.81003710535080708494e-83, 8.91522663528168662395e-84, -2.9172532751765712156e-84, -6.63064973077558034973e-85, 2.19268488711329887711e-85, 4.84496617807071636523e-86, -1.61885649716339522328e-86, -3.48009151471074461123e-87, 1.1747064266594037291e-87, 2.45865419211226186511e-88, -8.38271948546304257734e-89},
            {3.89090093895914349218e-57, 5.39038174712527300715e-56, -2.24703163667777427956e-55, -7.1374860411036114643e-55, 2.35735285082616400247e-54, 3.32751240304955348656e-54, -1.04616204125455653466e-53, -7.9972006637585480988e-54, 2.6262990556868618679e-53, 1.17186915641282911244e-53, -4.32559892679272416793e-53, -1.13759987897763190659e-53, 5.11486616945148559581e-53, 7.48710987429600302808e-54, -4.61294371992735738173e-53, -3.07879867897159032e-54, 3.31359268166735943579e-53, 3.11915924544684595614e-55, -1.95846660692156255329e-53, 6.58054275406393691203e-55, 9.76766016937086986686e-54, -6.54205245489968294055e-55, -4.19431948524442299904e-54, 3.9263759705474488584e-55, 1.57632801964144601941e-54, -1.81879648504938465518e-55, -5.25586592311938452588e-55, 7.01910839862663867272e-56, 1.57258527401297842246e-55, -2.34291567085190418977e-56, -4.26361697382785930728e-56, 6.9204973295782096557e-57, 1.0562532151660889611e-56, -1.83779911804976048873e-57, -2.40844550460159406073e-57, 4.44004946300620741499e-58, 5.0867915209737024042e-58, -9.85073093118017115998e-59, -1.00074060051346831508e-58, 2.02237027765553872036e-59, 1.84300633296857175503e-59, -3.86678156047986693629e-60, -3.1914217253916876208e-60, 6.923350293183968143e-61, 5.21697784386045040835e-61, -1.16634247469941406397e-61, -8.07951657602031897487e-62, 1.85648551108318865307e-62, 1.18929402213263497796e-62, -2.80232437670516327637e-63, -1.66881143071857607171e-63, 4.02476137959868051677e-64, 2.23822106144805172727e-64, -5.5162637760514331437e-65, -2.87634004938095104214e-65, 7.23431374734979518432e-66, 3.5497250653305522295e-66, -9.10027402821496390326e-67, -4.21564303612717638189e-67, 1.10047680195858760082e-67, 4.82697552516116667222e-68, -1.2819164584296781114e-68, -5.33818370785643526728e-69, 1.44112741871120508032e-69, 5.71120702692074915406e-70, -1.5662343125053122232e-70, -5.92020092670832848819e-71, 1.64821568902271405494e-71, 5.95431164079151684549e-72, -1.68195710394615426448e-72, -5.81814002732996988582e-73, 1.66668849497083073575e-73, 5.53002983224324332684e-74, -1.6057822182401605341e-74, -5.11870741386504798356e-75, 1.50601193998341968648e-75, 4.61902268726454480271e-76, -1.37645777658944211567e-76, -4.06757458513163080641e-77, 1.22727674864271900869e-77, 3.49887881397997447147e-78, -1.06854208166545157066e-78, -2.94251222937612314647e-79, 9.09303720076510254608e-80, 2.42141577648068402806e-80, -7.56954302621448619869e-81, -1.9513145045728517959e-81, 6.16917642520293753824e-82, 1.54105461464823880265e-82, -4.92623431682331319143e-83, -1.19357586445487655249e-83, 3.85698867252790780984e-84, 9.07225571905904032073e-85, -2.96295534957544061862e-85, -6.77158918917986050621e-86, 2.23474262683607932673e-86, 4.9663651402897683759e-87, -1.65585814214251537026e-87, -3.58103769431105773999e-88, 1.20605150973706937344e-88, 2.54002809497678745649e-89},
            {-1.131542025142378846e-57, 6.51583324637299915365e-57, 3.79396351993828596298e-56, -1.36714746941036851842e-55, -2.85685060708717551274e-55, 9.10082968779854483337e-55, 9.58183000803559428414e-55, -3.04624579781408998763e-54, -1.82926557519375103212e-54, 6.27158087977404083999e-54, 2.24089077197157649797e-54, -8.89910435447234445005e-54, -1.86305465096508660604e-54, 9.36347316803813221644e-54, 1.04439424899373564874e-54, -7.68687614637001360414e-54, -3.2938594473203523292e-55, 5.1111597446585932418e-54, -3.92158685935123822349e-56, -2.83237867380265489097e-54, 1.3095557035546651119e-55, 1.33787324094374718693e-54, -1.0245438877501888619e-55, -5.48515135252201597473e-55, 5.54442236660821521541e-56, 1.98129162801932059592e-55, -2.40339723061976753776e-56, -6.38414899972128771338e-56, 8.8307679009270592096e-57, 1.85451442523581287185e-56, -2.83537058964182744048e-57, -4.90059486738202003494e-57, 8.11283484614718478435e-58, 1.18726186846557453698e-57, -2.09784683503774541682e-58, -2.6550775958686267727e-58, 4.95529306489849421851e-59, 5.51360811384802344265e-59, -1.078414591735644637e-59, -1.0688520572311518049e-59, 2.17771609810492573771e-60, 1.94340925282758111126e-60, -4.10504451488115327229e-61, -3.32814659467485237318e-61, 7.26061579600310195385e-62, 5.38857567829027073303e-62, -1.21037172458545491472e-62, -8.27677695601833787477e-63, 1.90929319117912317535e-63, 1.20978459144884346541e-63, -2.85997871818472051891e-64, -1.68747403969985672893e-64, 4.08091218745337957884e-65, 2.25198123170256730309e-65, -5.56273571090407095704e-66, -2.88212971335869195105e-66, 7.26227477360260783685e-67, 3.54505193178880201128e-67, -9.10177101261654017268e-68, -4.19910878328021955744e-68, 1.09742901851612572115e-68, 4.7986158434334981483e-69, -1.2754860440853137939e-69, -5.29954587419323865165e-70, 1.43155228484445952548e-70, 5.66514670285676835448e-71, -1.55415418007563931075e-71, -5.87044809655501660823e-72, 1.6345780305955583697e-72, 5.904905992940524532e-73, -1.66787262831461575366e-73, -5.77285632860520844392e-74, 1.65326816515612674084e-74, 5.49190232059257426571e-75, -1.59398850848136808278e-75, -5.08972673907360777763e-76, 1.49654989901089079389e-76, 4.6000325672781077471e-77, -1.36971957505038133868e-77, -4.05835156551115514503e-78, 1.22334055614222272088e-78, 3.49834718239829056768e-79, -1.06721560689760609096e-79, -2.94903164161276348074e-80, 9.10196488018219809775e-81, 2.43308063743342332464e-81, -7.59561142942721729922e-82, -1.96621715539211910198e-82, 6.20698100871446314805e-83, 1.55748300457036501257e-83, -4.970663918608699053e-84, -1.21013518704930032447e-84, 3.90366984220343761832e-85, 9.22888501756493001881e-86, -3.00848839612932011319e-86, -6.91258776776040668725e-87, 2.27675742960194196329e-87, 5.08821843060767524779e-88, -1.69293663041930093144e-88, -3.68272507556700749698e-89, 1.23756860548808041098e-89},
            {-9.57439265268174191257e-59, -1.38410761288391240962e-57, 5.8615622178826186478e-57, 1.95076532577017103395e-56, -6.50320961990435470179e-56, -9.67116668970181189474e-56, 3.0474721447536286712e-55, 2.47262131236493562031e-55, -8.06670729101371194999e-55, -3.86240220056454690797e-55, 1.39899365958995592099e-54, 4.01884740683066616993e-55, -1.7396307838363921167e-54, -2.87635062740901860444e-55, 1.64785086471096306127e-54, 1.35281235340662654345e-55, -1.2417813630843240827e-54, -2.75632908958354567236e-56, 7.6909799334939240095e-55, -1.74666095661940839872e-56, -4.01523551176957941972e-55, 2.30954792120159642378e-56, 1.80298956494936636206e-55, -1.53726855198946796196e-56, -7.07889017659882056715e-56, 7.63831150975984551744e-57, 2.4634487988054968894e-56, -3.12271830824404355546e-57, -7.68608132359206663273e-57, 1.09724007268485335106e-57, 2.17113713830672828037e-57, -3.39868795779097194742e-58, -5.5993449231377639697e-58, 9.4397128389339856831e-59, 1.32807323384330465583e-58, -2.38056810702477572224e-59, -2.91550896036206875681e-59, 5.50442698627006236562e-60, 5.95743024652387147298e-60, -1.17621463282830830323e-60, -1.138740808168496098e-60, 2.33811946803073991852e-61, 2.04525594878066109004e-61, -4.34799962419425116714e-62, -3.46547892353812701128e-62, 7.60085889739955958567e-63, 5.55950175165724506604e-63, -1.25438775709158357016e-63, -8.47190135597932048338e-64, 1.96168456598058745114e-64, 1.22994031758316852163e-64, -2.91682425492751730427e-65, -1.70575792570385683605e-65, 4.13601283321827015037e-66, 2.26544213580227296072e-66, -5.60820968768258311147e-67, -2.88784725602843835339e-67, 7.28968377279422623097e-68, 3.54067364999211749721e-68, -9.10357634003284494929e-69, -4.18333438363737529796e-69, 1.09453201565837777579e-69, 4.77151141209065146716e-70, -1.26934419907180396883e-70, -5.26261111789130152092e-71, 1.42240028149452755472e-71, 5.62111948375849718304e-72, -1.54260732360515732184e-72, -5.82289340970523946906e-73, 1.62154283308365420495e-73, 5.85768292119542185302e-74, -1.65441025328577958007e-74, -5.72957522697892762061e-75, 1.64044052865148750263e-75, 5.45547401078239964088e-76, -1.58271753053737347226e-76, -5.06207287546485810253e-77, 1.48751386016387517109e-77, 4.58198348046539235275e-78, -1.36329956941943266118e-78, -4.04971711875454288541e-79, 1.21961812274667268776e-79, 3.49811663929629935427e-80, -1.06601277289181852746e-80, -2.95564445388701887363e-81, 9.1114348690821050754e-82, 2.44471082303887272402e-82, -7.62175405217715130948e-83, -1.98102558491951218084e-83, 6.24460044276025106943e-84, 1.57380906673219190749e-84, -5.01481710309087120926e-85, -1.22661690360268182195e-85, 3.95010071191187565905e-86, 9.38514583203380497292e-87, -3.0538647586225468004e-87, -7.05365546127114722857e-88, 2.31873489213033364447e-88, 5.21052225365549430279e-89, -1.73009270098365122157e-89, -3.78514316221722569365e-90},
            {2.81369922984216864689e-59, -1.65179052715283186944e-58, -1.0045426644142467406e-57, 3.66521403235313924484e-57, 8.03840351688791352807e-57, -2.57633652941989742849e-56, -2.86420678081807926425e-56, 9.09280508732661073032e-56, 5.81467261031562433353e-56, -1.97118480411892028007e-55, -7.5979280038162410507e-56, 2.94137181454920310926e-55, 6.79041978130281092635e-56, -3.25055513038874905238e-55, -4.18222086581346495965e-56, 2.79947579309812395943e-55, 1.59337697549670843384e-56, -1.95058903988417329086e-55, -8.14716840464788116512e-58, 1.13149493873741572689e-55, -4.07837297753987287828e-57, -5.58891481581173447654e-56, 3.78140783812747743296e-57, 2.39380082684202777691e-56, -2.22984654890311738476e-57, -9.02461086372581247937e-57, 1.03025173093448180673e-57, 3.03231701533495231538e-57, -3.99685813996608125614e-58, -9.17740943002452658632e-58, 1.34802611504590418644e-58, 2.524636145383445829e-58, -4.03837176305822203552e-59, -6.36227647054483326314e-59, 1.0907957708883993735e-59, 1.47886481903297107978e-59, -2.68659262340972562168e-60, -3.18973173277677345403e-60, 6.08771366746001041994e-61, 6.41795210866001714725e-61, -1.27842718214071075913e-61, -1.2103432464017062889e-61, 2.50344015596125694843e-62, 2.14846129741072140347e-62, -4.59542505580639994147e-63, -3.60334046995866842637e-63, 7.94383630305728099086e-64, 5.72972428302632712144e-64, -1.29837426531976279857e-64, -8.66494157201449447723e-65, 2.01366271343116939467e-65, 1.24977645280533072293e-65, -2.97289134577764665536e-66, -1.72368669745581942686e-66, 4.19012072639337692936e-67, 2.27863016366079519391e-67, -5.65275920792226681519e-68, -2.89351333901508467091e-68, 7.31660957198906125013e-69, 3.53659579986564800141e-69, -9.10572816330698681837e-70, -4.16830272868349670242e-70, 1.09178410677235877585e-70, 4.74561879280687229127e-71, -1.26348215772127625477e-71, -5.22731111288070031581e-72, 1.41365530893687273679e-72, 5.5790383823712040001e-73, -1.53157147108846699984e-73, -5.77744068939822429339e-74, 1.60908394497658013952e-74, 5.81254754924828978185e-75, -1.64154281843766695092e-75, -5.6882124323774217782e-76, 1.62818022608497806998e-76, 5.42067764668174237516e-77, -1.57194793295492912712e-77, -5.03569847872674040178e-78, 1.47888776058759339293e-78, 4.56484747632606008219e-79, -1.35718727546521067443e-79, -4.04165961612629185667e-80, 1.21610399815819593287e-80, 3.49818740843614288605e-81, -1.06493207367537149531e-81, -2.96235800709524460022e-82, 9.12145845595416067865e-83, 2.4563166548043109937e-83, -7.64799603111936896832e-84, -1.99575004939816116645e-84, 6.2820636751563638728e-85, 1.59004116819259577076e-85, -5.05871988477242938698e-86, -1.24302675129559279954e-86, 3.99630086137279813438e-87, 9.54106977461960267003e-88, -3.09909669818083664194e-88, -7.19480333107498391399e-89, 2.36068081487520851792e-89, 5.33327412288924168185e-90, -1.76732743015061637586e-90},
            {2.35790425459578207476e-60, 3.55210557166084332135e-59, -1.52775385056211932741e-58, -5.31882126122534029011e-58, 1.78980364148888953445e-57, 2.79872597671848708807e-57, -8.84359230990464043242e-57, -7.59625488502041787126e-57, 2.4649189499545691359e-56, 1.26175135522239863609e-56, -4.49547310065285515176e-56, -1.4021473100969419213e-56, 5.87129200369037466827e-56, 1.0837713065189890176e-56, -5.83446135029015176167e-56, -5.69872856630796018903e-57, 4.60731061761754673384e-56, 1.61997280081492390177e-57, -2.98702603735971757365e-56, 3.48726032225278264194e-58, 1.63072067237141015465e-56, -7.81858155286308370492e-58, -7.64977462555722237807e-57, 5.87654788625818982073e-58, 3.13473826157206086313e-57, -3.14575739739444309409e-58, -1.13755173909881823632e-57, 1.36417703726977870987e-58, 3.69786367783820380343e-58, -5.04724370661786829019e-59, -1.08740989665069240788e-58, 1.63916777360756697228e-59, 2.91715341026694010866e-59, -4.75990496128023609539e-60, -7.19166275719307405563e-60, 1.25241329303808328438e-60, 1.63979166544158071932e-60, -3.01649542722387504629e-61, -3.47771405659594001108e-61, 6.70534485631753682891e-62, 6.89485598873297853574e-62, -1.38500075374898568889e-62, -1.28359726162395403226e-62, 2.67353842485025612384e-63, 2.25294507876174834043e-63, -4.84710869863181300276e-64, -3.74166045204859694588e-64, 8.28932334801998860613e-65, 5.89921888144191982205e-65, -1.34231715829814650251e-65, -8.85595305252045352394e-66, 2.06523232953436724506e-66, 1.26930792395442812382e-66, -3.02821035755246174389e-67, -1.74128285251200850848e-67, 4.24329108754648781407e-68, 2.29157004256600063107e-68, -5.69645362823951546619e-69, -2.89914695660855461402e-69, 7.34311607783837407618e-70, 3.53282300168016955004e-70, -9.10826079619902190668e-71, -4.15399711231800640799e-71, 1.0891835272611054206e-71, 4.72089669406526893767e-72, -1.25789152865487817523e-72, -5.19358141000714860382e-73, 1.4053021414548100468e-73, 5.53882161258067296647e-74, -1.52102565796215090685e-74, -5.73399960939358316317e-75, 1.5971767963177300063e-75, 5.76941074460207092806e-76, -1.62924481261644779243e-76, -5.64868864019462114655e-77, 1.61646341523327959297e-77, 5.38744978091416212379e-78, -1.56165960006860852137e-78, -5.01055869736817443738e-79, 1.47065641664381841742e-79, 4.54859788925671179073e-80, -1.35137273095545727468e-80, -4.03416777840018837963e-81, 1.21279295348079014554e-81, 3.49855946593566668145e-82, -1.06397201180950696389e-82, -2.96917911584738848896e-83, 9.13204581462879890954e-84, 2.46790789321276229509e-84, -7.67436097436403087776e-85, -2.01040035788036043113e-85, 6.31939825341408904748e-86, 1.60618740284464779522e-86, -5.10239728932277742415e-87, -1.25937036328486761547e-87, 4.04228936272584756444e-88, 9.69668869191891151407e-89, -3.14419637960072915994e-89, -7.33604341189960975156e-90, 2.40260117794420309296e-90, 5.45647278099348481635e-91},
            {-6.99947980008426417277e-61, 4.18717722005914186031e-60, 2.65595457869602669498e-59, -9.81077551630946855919e-59, -2.25444345314216629695e-58, 7.27139812147714879999e-58, 8.51770282886096223647e-58, -2.70228151550574986751e-57, -1.83487242883272104563e-57, 6.16046313793169039315e-57, 2.55042133193083871942e-57, -9.65501351717972723226e-57, -2.43963377039105273719e-57, 1.11935221461122170835e-56, 1.63464008680261762648e-57, -1.01019551319614358016e-56, -7.19101779534129947114e-58, 7.36799755882063668166e-57, 1.19276289432842792778e-58, -4.46938258353645746089e-57, 1.14961365079205014403e-58, 2.3062653871124366725e-57, -1.3522321168294171824e-58, -1.03098058380592223943e-57, 8.77757057935991979622e-59, 4.05305471486319682718e-58, -4.33481622154340050669e-59, -1.41888398897791820013e-58, 1.77710590351169332104e-59, 4.47046290845284656574e-59, -6.29655117389357400323e-60, -1.27922579176150262543e-59, 1.97448678198572376316e-60, 3.35078212909218043036e-60, -5.56872490750472096867e-61, -8.08963888284513154866e-61, 1.42945231468485916132e-61, 1.81098739391625616873e-61, -3.37079820695048480441e-62, -3.77940254197215119737e-62, 7.35744702857105301059e-63, 7.38781535023564654123e-63, -1.4958792593734154392e-63, -1.35844244008300974008e-63, 2.84827579753053880028e-64, 2.35863188495804148218e-64, -5.10284830385810699549e-65, -3.88037508645957392739e-65, 8.63711312717348553678e-66, 6.06796783228253297011e-66, -1.38620438159642271305e-66, -9.04499424329007300082e-67, 2.11639952378577848478e-67, 1.28854931085888629627e-67, -3.08281153980081045823e-68, -1.75856782525805678059e-68, 4.29557699556794037145e-69, 2.30428495143776229692e-69, -5.73935840905193289419e-70, -2.90476557915925051892e-70, 7.36926266223852320502e-71, 3.52935902802129877775e-71, -9.11120508927188373486e-72, -4.14040124872094697941e-72, 1.08672845314286621476e-72, 4.69730585305090995946e-73, -1.25256427953719500996e-73, -5.16136117676036043838e-74, 1.39732637188036269507e-74, 5.50039221789977051578e-75, -1.51095013562832329241e-75, -5.69248526800737664902e-76, 1.58579828428000918463e-76, 5.72818870253810099973e-77, -1.6174922540954038894e-77, -5.61092917923356440448e-78, 1.60526766255166597773e-78, 5.35573051874242645417e-79, -1.55183356681688352522e-79, -4.98661101933328403725e-80, 1.46280546710905041309e-80, 4.53320927395043390511e-81, -1.34584646586291232138e-81, -4.02723067412150075776e-82, 1.20967997256183245358e-82, 3.49923257282458895255e-83, -1.06313110308543507149e-83, -2.97611411122250149363e-84, 9.14320611084825772584e-85, 2.47949377471911119839e-85, -7.70087107224628697313e-86, -2.02498589603080781294e-86, 6.35663040795030765911e-87, 1.62225560129806280244e-87, -5.14587339869497826029e-88, -1.27565326791466569252e-88, 4.08808479165638483561e-89, 9.85203459686962405895e-90, -3.18917585976327586766e-90, -7.47738862580588660018e-91, 2.44450211918353606858e-91},
            {-5.81133103721257972681e-62, -9.11136760427782120003e-61, 3.97877521840236197876e-60, 1.44690766617776601992e-59, -4.9148779660308774333e-59, -8.06643351698099433795e-59, 2.55713373403121607866e-58, 2.31978480643097651989e-58, -7.49515612491689079916e-58, -4.08803389877461571234e-58, 1.43572208934269555995e-57, 4.83682422659325005249e-58, -1.96713844492779590058e-57, -4.01517085193087846375e-58, 2.04843178144495588984e-57, 2.32444535428523566115e-58, -1.69325827099789325327e-57, -8.17932049215566047945e-59, 1.14795785536039147112e-57, -5.65931936173990409008e-61, -6.54716651892950208938e-58, 2.50452364528898978297e-59, 3.20555426651985555698e-58, -2.18884999858234296505e-59, -1.36976885190491961985e-58, 1.27013058224005648801e-59, 5.1788754103826322193e-59, -5.853442648421789931e-60, -1.75256972348322661869e-59, 2.28155335938649008449e-60, 5.36085069546772459286e-60, -7.7686180573607076351e-61, -1.49480637518081228644e-60, 2.35787553313971261218e-61, 3.82755985354514605538e-61, -6.47020118604539663739e-62, -9.05820118622496551593e-62, 1.62251223303946762186e-62, 1.99256532719332052132e-62, -3.74997093147529398897e-63, -4.09472462184113430322e-63, 8.04408675513096476406e-64, 7.89649760141980247253e-64, -1.61100279267584257835e-64, -1.43482022561885183893e-64, 3.02751571449242969587e-65, 2.46545100572638754399e-65, -5.36245153303857688081e-66, -4.01942714196797200165e-66, 8.98701561895657323088e-67, 6.23595944134544506635e-67, -1.43002574959536441765e-67, -9.23212601056970625035e-68, 2.16717163537312591113e-68, 1.3075148304234830966e-68, -3.1367249194786751131e-69, -1.77556203449827574249e-69, 4.34702944189160185706e-70, 2.31679662721335319867e-70, -5.7815353498167376883e-71, -2.91038528356118275202e-71, 7.39510451626878334418e-72, 3.52620690342582452734e-72, -9.11458876823245906079e-73, -4.12749928507988212912e-73, 1.08441701712343864414e-73, 4.67480892451708925791e-74, -1.24749272218171474995e-74, -5.13059295739569437981e-75, 1.38971436020059668047e-75, 5.46367773109936565538e-76, -1.50132628748579827304e-76, -5.65281779855733651289e-77, 1.57492666846131431336e-77, 5.68880256546301365811e-78, -1.60626258095618354931e-78, -5.57486368884958773844e-79, 1.59457184380959423828e-79, 5.32546328218271591937e-80, -1.54245194045568717937e-80, -4.96381512964111138672e-81, 1.45532132067861832941e-81, 4.51865734434144596559e-82, -1.34059947453480435217e-82, -4.02083771661080651992e-83, 1.2067602435982636354e-83, 3.50020630420454618709e-84, -1.06240788054412124448e-84, -2.98316888000181457268e-85, 9.15494759917594639116e-86, 2.49108304621670211307e-86, -7.72754719980897876189e-87, -2.03951564871196612239e-87, 6.3937851302813531863e-88, 1.63825334064383436539e-88, -5.18917139456382730537e-89, -1.29188088846839428675e-89, 4.13370523922893978682e-90, 1.00071396082567966846e-90, -3.23404707791084013466e-91, -7.61885270286999755666e-92},
            {1.74191509334634560741e-62, -1.06137913864015272161e-61, -7.01274653679767060764e-61, 2.62218831462510835332e-60, 6.30350106347443222231e-60, -2.04642503109553269897e-59, -2.5208289325791995795e-59, 7.99763938917070832905e-59, 5.75087193966384661419e-59, -1.91496803773332507119e-58, -8.48228995613397242376e-59, 3.14852625793989094652e-58, 8.65255355160291020775e-59, -3.82508145920925424146e-58, -6.25990792791916568091e-59, 3.61355222452340855734e-58, 3.095044115535105824e-59, -2.75606589352933578886e-58, -7.81669010280444742828e-60, 1.74652388711352109088e-58, -2.66666792196205577905e-60, -9.40625962376482711701e-59, 4.65615257222715443501e-60, 4.38479885200872830224e-59, -3.37805934231309936787e-60, -1.79597364178941405148e-59, 1.79016807543224934987e-60, 6.54522353733293479216e-60, -7.76487277029503199873e-61, -2.14509294237739769599e-60, 2.89103210116531690405e-61, 6.38007915837089413937e-61, -9.48834890352814653392e-62, -1.73576950887340424835e-61, 2.79327941887639979614e-62, 4.34946269664996589182e-62, -7.469615865605229045e-63, -1.00992079061676196307e-62, 1.83216256462288296765e-63, 2.1846196648643468378e-63, -4.15443376122949017362e-64, -4.42359079391576158166e-64, 8.76527596073692534177e-65, 8.42056657506044322459e-65, -1.73030834961189211602e-65, -1.5126740463354599603e-65, 3.21112409400743285849e-66, 2.57333629587559878238e-66, -5.625735928356280007e-67, -4.15876551019878751354e-67, 9.33885681246748142776e-68, 6.40318743309432767662e-68, -1.47377278906318794687e-68, -9.41741113383287930578e-69, 2.21755706826729475776e-69, 1.32621832552205362584e-69, -3.18998021298967884696e-70, -1.79228493028368917159e-70, 4.39769738994909467628e-71, 2.32912546385380718659e-71, -5.82304281115346629737e-72, -2.91602087205027819811e-72, 7.4206929751155402602e-73, 3.52336899309030303195e-73, -9.11843673869560754923e-74, -4.11527580999959981005e-74, 1.08224732246658606574e-74, 4.65337037624095271233e-75, -1.24266949806091643454e-75, -5.10122245164068537849e-76, 1.38245318589756314008e-76, 5.42860986200522032266e-77, -1.49213655176667497699e-77, -5.61492201266479270151e-78, 1.56454147495732163894e-78, 5.65117807420063509604e-79, -1.59553455069710497835e-79, -5.5404258225305615953e-80, 1.58435605295952293124e-80, 5.29659459252684402093e-81, -1.53349782853227015247e-81, -4.94213277815652707222e-82, 1.44819110740551687778e-82, 4.50491891590793064639e-83, -1.33562318968302729999e-83, -4.01497865992996031569e-84, 1.20402915101727953805e-84, 3.50148007536892521272e-85, -1.06180089790187222721e-85, -2.99034890068835423893e-86, 9.16727771116067422084e-87, 2.50268399715585593678e-87, -7.75440901165787145814e-88, -2.05399822140392290389e-88, 6.43088624650201733295e-89, 1.65418795406553259321e-89, -5.23231360009159371015e-90, -1.30805854338884909981e-90, 4.17916832426986036509e-91, 1.0162035897123899865e-91, -3.27882184758748737175e-92},
            {1.43331541799268487191e-63, 2.33602492012763007444e-62, -1.03542820628786329849e-61, -3.92771476401164290279e-61, 1.34679254183210271641e-60, 2.31605443394598754583e-60, -7.3687651807914731442e-60, -7.0447752984832971581e-60, 2.26850059854563123818e-59, 1.31441155625561829547e-59, -4.5586354538035686012e-59, -1.65127002893977687179e-59, 6.54513938575805725762e-59, 1.46552718744017885492e-59, -7.13444926380262715167e-59, -9.23878835840446239041e-60, 6.16699188825624025234e-59, 3.80060858503562643914e-60, -4.36780247324287411276e-59, -4.73224133895909751818e-61, 2.59998663446627785439e-59, -7.39512581402413972114e-61, -1.32743226784742868774e-59, 7.91817086188296704261e-61, 5.90982779563183256256e-60, -5.02475817990884146353e-61, -2.32607174942139682614e-60, 2.46723784532886902512e-61, 8.18802143645936590621e-61, -1.01393131804931528087e-61, -2.60329041897971355738e-61, 3.62002584752133665731e-62, 7.53947063597832511976e-62, -1.14816163536933482044e-62, -2.00372683204643727837e-62, 3.28467990926270302285e-63, 4.9184005683199227911e-63, -8.57214615853588761868e-64, -1.12143809463036471007e-63, 2.05894246571128943563e-64, 2.38722668998154860057e-64, -4.58455917543183573771e-65, -4.76589674017523547293e-65, 9.52097702991718587629e-66, 8.95968473598695514947e-66, -1.85373048667406412554e-66, -1.5919494110724430758e-66, 3.39896980413877294786e-67, 2.68222602905641457924e-67, -5.89252881810786899179e-68, -4.29834479483101278395e-68, 9.69247784608765071604e-69, 6.56965039951657785417e-69, -1.51743859361337017827e-69, -9.60091386083059334263e-70, 2.26756514346752388658e-70, 1.34467325795130115797e-70, -3.24260675334364720228e-71, -1.80875503970732411089e-71, 4.44762783841524746461e-72, 2.3412906044478900336e-72, -5.86393592429259456828e-73, -2.92168598042411282188e-73, 7.44607581646048198985e-74, 3.52084708188854650415e-74, -9.12277136089458283421e-75, -4.10371585829522650306e-75, 1.0802174549447737196e-75, 4.63295639069520707964e-76, -1.23808756425967013963e-76, -5.0731983103559896588e-77, 1.37553060371931676798e-77, 5.39512421080150423507e-78, -1.48336435054962846164e-78, -5.5787270732493449025e-79, 1.55462340837153818404e-79, 5.61524524816815379463e-80, -1.58528814818186059267e-80, -5.507552975442870458e-81, 1.57460151846024041354e-81, 5.26907386963457424777e-82, -1.52495527254810865247e-82, -4.92152765667821961728e-83, 1.44140263373851195385e-83, 4.49197185115240859251e-84, -1.33090945806318506815e-84, -4.0096435939993897436e-85, 1.20148226763736635832e-85, 3.50305316519953702554e-86, -1.06130873245390907307e-86, -2.99765927659334744428e-87, 9.18020313558018418549e-88, 2.51430448948264819055e-88, -7.78147502979422384572e-89, -2.06844186051100357596e-89, 6.46795648633570128505e-90, 1.67006654026860067119e-90, -5.27532152003878562079e-91, -1.32419144690214510548e-91, 4.22449120616191834703e-92, 1.0316755639448711246e-92},
            {-4.33664474404944952592e-64, 2.69031978982189664498e-63, 1.84929295039462431867e-62, -6.99865544722878160428e-62, -1.75741867983606993387e-61, 5.74380763592673123165e-61, 7.42667082586725636893e-61, -2.35766884325861740943e-60, -1.791020909099904488e-60, 5.92227790467485594427e-60, 2.79702127638691385398e-60, -1.02036150317613950585e-59, -3.03303429330491358588e-60, 1.29760469621460174044e-59, 2.35538445068573089197e-60, -1.28187972627311589522e-59, -1.28591662368941833111e-60, 1.0213848555018313215e-59, 4.15662938506776410998e-61, -6.75546160853996244646e-60, 3.16382106724285522867e-62, 3.79392700137606200559e-60, -1.52747176655464993177e-61, -1.84263784700579456314e-60, 1.2687626565183068326e-61, 7.85688458998433171787e-61, -7.25448114008177223839e-62, -2.97845416676003583264e-61, 3.33492490297500918488e-62, 1.01460685882953526387e-61, -1.30540373877467380284e-62, -3.13433023107959685192e-62, 4.48395549338266164313e-63, 8.85057221616780756534e-63, -1.37751593177434906117e-63, -2.30027794734216242462e-63, 3.83607851640566667405e-64, 5.53621337855496502441e-64, -9.78284942531342803509e-65, -1.24053085821825976578e-64, 2.30336055065351790778e-65, 2.60044598947602788296e-65, -5.04067426205077926249e-66, -5.12152531877202366305e-66, 1.0311107726265965196e-66, 9.51351513479001624913e-67, -1.98120191943035992033e-67, -1.6725939794782172193e-67, 3.59092505563127933864e-68, 2.79206274147917219477e-68, -6.16266716883832755048e-69, -4.43812492012645565898e-69, 1.00477341640168731613e-69, 6.7353512961056727447e-70, -1.56101768856510821661e-70, -9.78269951820666798469e-71, 2.31720596679978452174e-71, 1.36289270480278718815e-71, -3.29463343045729759304e-72, -1.82499001146171308415e-72, 4.49686588704905055658e-73, 2.35331002687058787585e-73, -5.90426678834378522407e-74, -2.92739317668015059106e-74, 7.47129753459849618505e-75, 3.51864244478744604226e-75, -9.12761269746940431933e-76, -4.09280491276605235683e-76, 1.07832549311562973861e-76, 4.61353477257556687826e-77, -1.2337401798985707104e-77, -5.04647194667908857165e-78, 1.36893500260609698783e-78, 5.36316000446289453318e-79, -1.47499402438620342838e-79, -5.54416619439387336685e-80, 1.54515427101269956501e-80, 5.58093809170460091047e-81, -1.57550450113747892894e-81, -5.47618603373080334878e-82, 1.56529052635854201641e-82, 5.24285324652130124452e-83, -1.51680918679803306891e-83, -4.90196528460202883047e-84, 1.4349443408559908767e-84, 4.47979500808592711526e-85, -1.32645051772092039948e-85, -4.00482293902891774538e-86, 1.19911534711226205123e-86, 3.50492473712280130893e-87, -1.06092998751949816204e-87, -3.00510476624375140164e-88, 9.19372989150638814651e-89, 2.52595198555407698516e-89, -7.80876272497924479183e-90, -2.08285447260680909825e-90, 6.50501754802631246289e-91, 1.68589597270486295575e-91, -5.31821587924606424457e-92, -1.34028470998834023516e-92, 4.26969059793240386981e-93},
            {-3.53759582752554591305e-65, -5.98660681375840136894e-64, 2.69266451459938513022e-63, 1.06406045545993715277e-62, -3.68312340290756304627e-62, -6.62611123459544705151e-62, 2.1165436206526224471e-61, 2.12817154947929552947e-61, -6.83561621789581587074e-61, -4.19611451753887945439e-61, 1.43943854912348251718e-60, 5.58371196021487760317e-61, -2.16337666073440907051e-60, -5.27820142429936020023e-61, 2.4659536942104583374e-60, 3.59374157904765057819e-61, -2.22681795606973939088e-60, -1.67297811333048789378e-61, 1.64609543415884474548e-60, 3.67194465583757750906e-62, -1.02177352196150760832e-60, 1.8916431602481380289e-62, 5.43518338962585831369e-61, -2.76762299715380859096e-62, -2.51904984824984661409e-61, 1.9457993095706774177e-62, 1.03133810676934357646e-61, -1.02154470722092307109e-62, -3.77348102853646962585e-62, 4.43124441230048300684e-63, 1.24609979479122283934e-62, -1.65934260392450092409e-63, -3.74568859862816141605e-63, 5.49913901458149081837e-64, 1.03251112409108427014e-63, -1.63964798263068124094e-64, -2.62700514699937707246e-64, 4.45148175218772176549e-65, 6.20466813988710769218e-65, -1.11066504355096451437e-65, -1.36734489608974907677e-65, 2.56589497295849829223e-66, 2.82432167335528642588e-66, -5.52306312355118433081e-67, -5.49034842600300450741e-67, 1.11355458996781952214e-67, 1.00817231263029554144e-67, -2.11265406416834417993e-68, -1.75455760913407070876e-68, 3.78686572408241388449e-69, 2.90279306869959250812e-69, -6.4359973940974591018e-70, -4.57807075921987853605e-70, 1.04044946956606113931e-70, 6.90029698159220331063e-71, -1.60450590569360427496e-71, -9.96283417163466024065e-72, 2.36649031079757666909e-72, 1.38088935769854621513e-72, -3.34608864286079427164e-73, -1.84100665900801346976e-73, 4.54545480414273156632e-74, 2.36520062343134894346e-74, -5.94408465591097587041e-75, -2.93315405097135315374e-75, 7.49639959235567666136e-76, 3.51675590962186933843e-76, -9.13297873711879939103e-77, -4.08252890345932062555e-77, 1.07656951713771803916e-77, 4.59507486183815061662e-78, -1.22962089304408436925e-78, -5.02099736132102480079e-79, 1.36265536751990928904e-79, 5.33265985418566553548e-80, -1.46701077203400129648e-80, -5.51117636555829339909e-81, 1.53611688860904195572e-81, 5.54819432410940644476e-82, -1.56616580249453837212e-82, -5.44626914358600757528e-83, 1.55640634950598195257e-83, 5.21788739791160763659e-84, -1.50904530192456088117e-84, -4.88341290248327931477e-85, 1.42880526602063092104e-85, 4.46836819154963501039e-86, -1.32223897669336268919e-86, -4.00050743940104155894e-87, 1.19692431665779067559e-87, 3.5070938578776507835e-88, -1.06066329448465290643e-88, -3.01268981134185123539e-89, 9.20786339486128434973e-90, 2.53763357417436725363e-90, -7.83628859213900968501e-91, -2.09724364266840338147e-91, 6.54209015932749033472e-92, 1.70168290857448197714e-92, -5.3610166595203931691e-93, -1.35634334164819350924e-93},
            {1.08003876644682829566e-65, -6.81903010978001932312e-65, -4.87085486002700765241e-64, 1.86546294544226048561e-63, 4.88641979644747755727e-63, -1.60801034807416710131e-62, -2.17866430184383032181e-62, 6.92433425048009205013e-62, 5.54471154564883727119e-62, -1.82265090107436849279e-61, -9.14998240615381602407e-62, 3.28718201061258738159e-61, 1.05186582508876485029e-61, -4.37142788464025536228e-61, -8.72634034046790492079e-62, 4.51143872074907632213e-61, 5.19601342616667684704e-62, -3.75178446531930426319e-61, -1.99558303157253920917e-62, 2.587587266759120249e-61, 1.56113273746762392302e-63, -1.51407451182993204053e-61, 4.68053966507658774726e-63, 7.65523220740694127738e-62, -4.63780377653050547579e-63, -3.39535179183322988136e-62, 2.88326974815471699468e-63, 1.33785968723040391926e-62, -1.40805393900837134477e-63, -4.73352248733607916179e-63, 5.7988253297522465899e-64, 1.51772124287560829773e-63, -2.08489533291866093197e-64, -4.44512544717909024182e-64, 6.68274608760281786766e-65, 1.19749522370341974813e-64, -1.93737399600082164228e-65, -2.98546868395960863948e-65, 5.1348871582194551721e-66, 6.92545689694079937586e-66, -1.2548330773973687926e-66, -1.50201342552607825118e-66, 2.84699373558563528756e-67, 3.0588835801726140972e-67, -6.03196935756832648907e-68, -5.87222872820431717711e-68, 1.19941339635340412708e-68, 1.06639778712802018386e-68, -2.24801752572592636341e-69, -1.83779238284241374367e-69, 3.9866716091868804996e-70, 3.01436757808716282209e-70, -6.71237512847766570171e-71, -4.71815178228526722095e-71, 1.0762641061593940287e-71, 7.06449779818348810986e-72, -1.64790026733870618699e-72, -1.01413843300431377623e-72, 2.41542950931783173441e-73, 1.39867552441254584597e-73, -3.39700025928568913698e-74, -1.85682100225063164919e-74, 4.59343609476762445017e-75, 2.37697827492455336295e-75, -5.98343610760044539293e-76, -2.93897929768969137494e-76, 7.52142065269831205147e-77, 3.51518791307671798085e-77, -9.13888559659574759404e-78, -4.07287420485812653578e-78, 1.07494761631168847545e-78, 4.57754745191660380699e-79, -1.22572352811455696778e-79, -4.99673098081341246756e-80, 1.35668124394765824231e-80, 5.30356953190794932993e-81, -1.45940059484175227088e-81, -5.47969809788583352569e-82, 1.52749504193911767158e-82, 5.51695513120456607815e-83, -1.55725523893687563077e-83, -5.41774949830644920798e-84, 1.54793318235187941438e-84, 5.19413338155866365864e-85, -1.50165011277244811228e-85, -4.86583937288089409172e-86, 1.42297500670559148463e-86, 4.45767210721483579851e-87, -1.31826779306219307435e-87, -3.9966881571255279584e-88, 1.19490527005939787783e-88, 3.50955951432035851416e-89, -1.06050731449178324662e-89, -3.02041856248674291663e-90, 9.22260851906679707201e-91, 2.549355994886568213e-91, -7.86406822027635834983e-92, -2.11161665134915142463e-92, 6.5791941348301999879e-93, 1.71743379759188795092e-93, -5.4037431349639465063e-94},
            {8.73694811842762586939e-67, 1.53357613667387846149e-65, -6.99764581263459861072e-65, -2.87719243955973150336e-64, 1.00531675049403778332e-63, 1.88929470783531769219e-63, -6.06066304418371749371e-63, -6.39736106875367459281e-63, 2.05111532399384784076e-62, 1.33064160442790374555e-62, -4.52127071851777609911e-62, -1.87147001409281919598e-62, 7.1057634494075160489e-62, 1.87816245981864198115e-62, -8.4615591937482675693e-62, -1.37236754442807670605e-62, 7.97500340960895642238e-62, 7.08219876825053033026e-63, -6.14741710951263671382e-62, -2.08546814000954813826e-63, 3.97567265301437851335e-62, -3.36523063015392957805e-64, -2.20155875307180172889e-62, 9.26699829461669085885e-64, 1.06137501983054808734e-62, -7.36417513154910964027e-64, -4.51667047850091597936e-63, 4.15389576855934710522e-64, 1.71643166451874806284e-63, -1.90491929831948767664e-64, -5.88298555242459468294e-64, 7.48506280590964107182e-65, 1.83418035200829086391e-64, -2.59191227370277482916e-65, -5.24065909107625036423e-65, 8.05274837626383068464e-66, 1.38120556434500572592e-65, -2.27356600809380933649e-66, -3.3772025837351011467e-66, 5.89027045861484394811e-67, 7.70019540934255305984e-67, -1.41125202646590032524e-67, -1.64465753469299396427e-67, 3.14707519876516228138e-68, 3.30414845852187960954e-68, -6.56759857730344707115e-69, -6.2670212651997110836e-69, 1.28866831300262427235e-69, 1.12599536392428838355e-69, -2.3872225347530406163e-70, -1.92225261887589836648e-70, 4.19022663823635647143e-71, 3.12674059915879163006e-71, -6.991664974421035538e-72, -4.85834172443770292211e-72, 1.1122066808813583576e-72, 7.22796718922648457062e-73, -1.69119887933376068946e-73, -1.03184166890514921239e-73, 2.4640353636607169072e-74, 1.41626313246686801152e-74, -3.44739558879671654212e-75, -1.87244830764742139721e-75, 4.6408495691541238724e-76, 2.38865791947147654972e-76, -6.02236521597556393797e-77, -2.94487879040866756438e-77, 7.54639679175905557741e-78, 3.51393855062551238167e-78, -9.1453477032564874231e-79, -4.0638276313634437317e-79, 1.0734578955090363571e-79, 4.5609247128048329609e-80, -1.22204217378487640177e-80, -4.97363150761667060502e-81, 1.35100270486787220642e-81, 5.2758377642040666409e-82, -1.45215024537667095467e-82, -5.44967519058012015037e-83, 1.51927340384085427392e-83, 5.48716493646011319135e-84, -1.54875692509366175606e-84, -5.39057714174419508753e-85, 1.53985608081084499438e-85, 5.17155049124497619968e-86, -1.49461083016942597181e-86, -4.84921508791956589566e-87, 1.41744368726593619703e-87, 4.44768831811020856007e-88, -1.31453025626279268506e-88, -3.99335646496686671934e-89, 1.19305446095652830968e-89, 3.51232062846752614866e-90, -1.06046073981983982167e-90, -3.02829490284843198503e-91, 9.23796965033286825204e-92, 2.56112566064376084336e-92, -7.8921163573178357762e-93, -2.12598049133827562187e-93, 6.61634842985572255349e-94, 1.7331548905058512986e-94},
            {-2.69077194932209436453e-67, 1.72833420673505146409e-66, 1.28149149977792063187e-65, -4.96602250244042760433e-65, -1.35516957280774524474e-64, 4.49073225563010392606e-64, 6.36556538736023785478e-64, -2.02640309117464485473e-63, -1.70696218014612602588e-63, 5.58349697166351867661e-63, 2.97109595265234900987e-63, -1.05302277623749936628e-62, -3.61213833585231150861e-63, 1.46293222205165830867e-62, 3.18866602807866027725e-63, -1.57578380623598657021e-62, -2.05209361701498761945e-63, 1.36650416470491743819e-62, 8.99752443274549446553e-64, -9.81943245624033247273e-63, -1.65760229441842668387e-64, 5.98134335924929264898e-63, -1.28346899175637649128e-64, -3.14576210696764854801e-63, 1.64278770628153850507e-64, 1.45023214761505314277e-63, -1.12293309466709440513e-64, -5.93513117731181559077e-64, 5.84417548680993791407e-65, 2.17953982815730465663e-64, -2.5349164636454970687e-65, -7.24832717420143859472e-65, 9.54223859867780347648e-66, 2.20044541354225693004e-65, -3.1909355834565670903e-66, -6.14054040052177244415e-66, 9.6278664053593074201e-67, 1.58484386309014686342e-66, -2.65114194192555533696e-67, -3.80371098533788765606e-67, 6.72157386218065882849e-68, 8.5304225142811313448e-68, -1.58036902736222302872e-68, -1.79538669252212976374e-68, 3.46652875580610924325e-69, 3.56012111631525756135e-69, -7.13012094162697719236e-70, -6.67457492832228776752e-70, 1.38129773969979228538e-70, 1.18693309298059989496e-70, -2.5301993377244402872e-71, -2.00789486668871799858e-71, 4.39741902045618008604e-72, 3.23987005358586574384e-72, -7.27374022824188310643e-73, -4.99861827303132788378e-73, 1.14826766771506359325e-73, 7.39072135137483381649e-74, -1.73440083221909563966e-74, -1.0493997909242455748e-74, 2.51232005907060222108e-75, 1.43366373434932084088e-75, -3.49730135829478687474e-76, -1.88790312671480556219e-76, 4.68773341066831725253e-77, 2.40025361651983567145e-77, -6.06091369951074537476e-78, -2.95086165034455678316e-78, 7.57136169485569213465e-79, 3.51300762108827816566e-79, -9.15237796013379001065e-80, -4.05537643138550207848e-80, 1.07209848063003985495e-80, 4.5451801187075236794e-81, -1.21857117138762027227e-81, -4.95165978110237097983e-82, 1.34561031998911474713e-82, 5.24941604201060971111e-83, -1.44524717992489905257e-83, -5.42105451553890700832e-84, 1.51143748111550123182e-84, 5.45877118992288671213e-85, -1.54065584286482292335e-85, -5.36470478670111386497e-86, 1.53216090675373346433e-86, 5.15010012048324980364e-87, -1.48791533629557540075e-87, -4.83351188305470857974e-88, 1.41220192794965508839e-88, 4.43839920353245126336e-89, -1.31101996956126617994e-89, -3.99050403933117729902e-90, 1.19136829639865769421e-90, 3.51537607095718580431e-91, -1.06052229499337299598e-91, -3.03632246996802490345e-92, 9.25395073807530398586e-93, 2.57294867897505766526e-93, -7.92044697028856163674e-94, -2.14034188285361154345e-94, 6.65357119112764005163e-95},
            {-2.15914767155319480376e-68, -3.9270119487552656322e-67, 1.81737155071673496984e-66, 7.76591687907212661751e-66, -2.73905626996839084261e-65, -5.3697307661999146328e-65, 1.73036477950098274632e-64, 1.91413376818410448492e-64, -6.13002974402211706559e-64, -4.19325124958038293063e-64, 1.41300675294655632189e-63, 6.22109248118939690379e-64, -2.31996453203077500743e-63, -6.60989656367760184018e-64, 2.8833786577951253379e-63, 5.15707659913849908123e-64, -2.83382918341951573382e-63, -2.90908582640267957696e-64, 2.2759031427823345546e-63, 1.03975923497791447436e-64, -1.53225771240028175884e-63, -2.61001092167539339773e-66, 8.82607269576901980915e-64, -2.92732973308956120721e-65, -4.42273913330575436692e-64, 2.71744225637306449639e-65, 1.95482495125746307156e-64, -1.65808758260629198792e-65, -7.71039442441891873679e-65, 8.05577685733405983351e-66, 2.74102672240157282543e-65, -3.32381672828150583762e-66, -8.8580540677428596875e-66, 1.20276093665880115559e-66, 2.62173278417339049827e-66, -3.89318383348617623387e-67, -7.15322678358295270073e-67, 1.14275138945102419045e-67, 1.80961382415325431256e-67, -3.07305599013175397549e-68, -4.26646499354772045361e-68, 7.63269552011206465576e-69, 9.41760009643074827568e-69, -1.76261487463281483743e-69, -1.95429929004078292058e-69, 3.80571564961729851883e-70, 3.82679553136173494725e-70, -7.71967366959487705867e-71, -7.09473381709597262319e-71, 1.47727772839282719284e-71, 1.24917974290025621517e-71, -2.67687854303128174988e-72, -2.09467789031808104162e-72, 4.60814135818149267658e-73, 3.35371728635920220304e-73, -7.55848259088811741659e-74, -5.13896277386160182037e-74, 1.18443858980261734782e-74, 7.55277891851268456761e-75, -1.77750611021410896886e-75, -1.06681944253536323007e-75, 2.56029609059622216619e-76, 1.45088851404934131168e-76, -3.54674369636382192514e-77, -1.90319933291071626212e-77, 4.73412424295337790004e-78, 2.4117786063442210863e-78, -6.09912106708927480797e-79, -2.95693630893188845602e-79, 7.59634683694005146006e-80, 3.51239466639546792306e-80, -9.15998789529360130453e-81, -4.04750828031288741527e-81, 1.07086752321450803373e-81, 4.53028837997681648287e-82, -1.21530510380462260821e-82, -4.93077864851408093235e-83, 1.34049512708457383053e-83, 5.22425844479550459341e-84, -1.43867951453184306739e-84, -5.39378581861428091794e-85, 1.50397356089185094898e-85, 5.43172417336625123688e-86, -1.53293778542230537301e-86, -5.34008764697374005948e-87, 1.52483427671591782036e-87, 5.12974563602852008441e-88, -1.48155214333634424171e-88, -4.81870295656881503269e-89, 1.40724081606124202947e-89, 4.42978792020405381239e-90, -1.30773083361786880612e-90, -3.98812285298626061485e-91, 1.18984333066676315108e-91, 3.51872467308904708462e-92, -1.06069073765441538496e-92, -3.04450467584188554718e-93, 9.27055534090747298445e-94, 2.584830871753104946e-94, -7.94907330117574182561e-95, -2.15470728831235220718e-95},
            {6.70594984010431247385e-69, -4.38046514376487051554e-68, -3.36793827031976259122e-67, 1.32040589197902341911e-66, 3.74924399841298897969e-66, -1.2512250342446130619e-65, -1.85280762351192176299e-65, 5.91015780198402104458e-65, 5.2272848687447547889e-65, -1.70290627327848968492e-64, -9.58053708122163896309e-65, 3.35512804632284247846e-64, 1.22916092955302156767e-64, -4.86492582721243529034e-64, -1.15075060645702533276e-64, 5.46437076401123263451e-64, 7.94906517116131444143e-65, -4.93710983054073148717e-64, -3.88324760652653832881e-65, 3.69324670994615976306e-64, 1.0289110965975305139e-65, -2.34011224415798401827e-64, 2.78327395109279493904e-66, 1.27923129020723110527e-64, -5.5993752118301759926e-66, -6.12530515573357151836e-65, 4.2798051787293027529e-66, 2.60184328353418893385e-65, -2.38403864797488292492e-66, -9.91016835072017721675e-66, 1.09069109119920974264e-66, 3.41613333344229653372e-66, -4.30053519444775864121e-67, -1.07427099449056000905e-66, 1.50034632618462127617e-67, 3.10349466191604719756e-67, -4.71053278434914452225e-68, -8.28735627933599392497e-68, 1.34717403675525349017e-68, 2.05671770133720813832e-68, -3.54228939479528474104e-69, -4.76690002011587947154e-69, 8.62748012809535681014e-70, 1.03631135953956006807e-69, -1.95840368317359472321e-70, -2.12148320418676382155e-70, 4.16496990499269314016e-71, 4.10415591829712505261e-71, -8.33636351833318137855e-72, -7.52733847945635022051e-72, 1.57658233181821825188e-72, 1.31270488162257933856e-72, -2.8271914264333836054e-73, -2.18256264145270318407e-73, 4.82229072032272593168e-74, 3.46824689931778693874e-74, -7.84578186815061684917e-75, -5.27935995566625526735e-75, 1.22071195261678111791e-75, 7.71416067486116309833e-76, -1.82051550743670453541e-76, -1.08410722828823092557e-76, 2.60797619738125946446e-77, 1.46794829465251228481e-77, -3.59574812256203339039e-78, -1.9183501568970389817e-78, 4.78005719589247017823e-79, 2.42324536536857200298e-79, -6.13702475357685732973e-80, -2.96311056505098298244e-80, 7.62138164878870240188e-81, 3.51209900707781105991e-81, -9.16818779704651674098e-82, -4.04021127258764580452e-82, 1.06976320431338704713e-82, 4.51622537906942506056e-83, -1.21223878483986976953e-83, -4.91095284509327777561e-84, 1.3356486052622151598e-84, 5.20032147791792937856e-85, -1.43243598428134174683e-85, -5.3678215360325306341e-86, 1.49686866105942759952e-86, 5.40597682023625679479e-87, -1.52558930547543900653e-87, -5.31668328187518351359e-88, 1.51786351445680670962e-88, 5.11045226039550655978e-89, -1.47551035514329327506e-89, -4.80476279436766812362e-90, 1.40255187910751666595e-90, 4.42183836554918537038e-91, -1.30465703106155884164e-91, -3.98620516767734803158e-92, 1.18847625935323458256e-92, 3.5223652375880868081e-93, -1.06096485922712341173e-93, -3.05284472543350931355e-94, 9.28778666860738297397e-95, 2.5967777936619452712e-95, -7.97800791881210589651e-96},
            {5.3390370903270346715e-70, 1.00522059387862622644e-68, -4.71705663287546892509e-68, -2.0925659966798205803e-67, 7.44985485505688640107e-67, 1.52156772097356211881e-66, -4.92651147685695225767e-66, -5.7020709363605122432e-66, 1.82505365516677586014e-65, 1.31364307387053350371e-65, -4.39485111139234760067e-65, -2.05216110683297267584e-65, 7.53116144447988371509e-65, 2.30281035120066140423e-65, -9.76053898026663156205e-65, -1.91045276100328465214e-65, 9.99456949444011907951e-65, 1.16615737389664438701e-65, -8.35611296800651165221e-65, -4.81228314923862524818e-66, 5.85191980361726179967e-65, 7.0166278450392107236e-67, -3.50363851548772318688e-65, 8.45846485680087127203e-67, 1.8235182762585933702e-65, -9.74123089604501094081e-67, -8.36541094944096890331e-66, 6.49202240413674874592e-67, 3.42232627970373169505e-66, -3.35126653737433492071e-67, -1.26106911370418203507e-66, 1.45336691287190815693e-67, 4.2215328376940611171e-67, -5.49726247737014919173e-68, -1.2934850965536901671e-67, 1.85371457209542695216e-68, 3.65140592582119653881e-68, -5.65549279303012113975e-69, -9.55172202288154241881e-69, 1.57811727872312482347e-69, 2.32735311993609413818e-69, -4.06184168246442422218e-70, -5.3064135880037714329e-70, 9.70971064758300242718e-71, 1.13682729840492737706e-70, -2.16813269460145435323e-71, -2.29701637623942485082e-71, 4.54459935403472421917e-72, 4.39217774823980087818e-72, -8.98026920703982473234e-73, -7.97222704095528359858e-73, 1.67918392754325225861e-73, 1.37747894364589910959e-73, -2.98107019906776966347e-74, -2.27151222391575426431e-74, 5.03976868304859797533e-75, 3.58342658800826656911e-75, -8.13553566431391556676e-76, -5.41979767223714386917e-76, 1.25708118044480951627e-76, 7.87488929486477633663e-77, -1.86343055087732930576e-77, -1.10126969989691836441e-77, 2.6553733045424392357e-78, 1.48485354677166438413e-78, -3.64433954137086698877e-79, -1.93336822019809716405e-79, 4.82556597012430284075e-80, 2.43466565761053729224e-80, -6.174660246986271631e-81, -2.9693916373934701242e-81, 7.64649367013217221407e-82, 3.51211977394316926549e-82, -9.17698683641910284073e-83, -4.03347391308035650898e-83, 1.06878373771571497848e-83, 4.50296811027395671636e-84, -1.2093672490623279341e-84, -4.89214888263083437616e-85, 1.33106265002342385523e-85, 5.17756392204874942782e-86, -1.4265059055413032861e-86, -5.34311662465211427392e-87, 1.49011048441787065754e-87, 5.38148454911014302125e-88, -1.51859766742934797057e-88, -5.29445145217494690524e-89, 1.51123660704019117482e-89, 5.09218696264939890098e-90, -1.46977963165267280911e-90, -4.79166709968099591481e-91, 1.39812705977046377499e-91, 4.41453514296573776824e-92, -1.30179301200609254717e-92, -3.98474352669148234455e-93, 1.18726391369265483949e-93, 3.52629654822068986974e-94, -1.06134348540161202225e-94, -3.06134563374408370092e-95, 9.3056476204234045761e-96, 2.60879474945682511947e-96},
            {-1.67179779623437813933e-70, 1.11019942645673324455e-69, 8.84249915711594513855e-69, -3.50677349499119994796e-68, -1.0348944720243363981e-67, 3.47848922011246218522e-67, 5.37351572190426728372e-67, -1.71816764471092199203e-66, -1.59280916447915168884e-66, 5.17182807306707572055e-66, 3.06918664869879873731e-66, -1.06351376720077175615e-65, -4.14735678866942891788e-66, 1.60805814617419600448e-65, 4.10613821202289320944e-66, -1.88184559720164256341e-65, -3.02796557083972252723e-66, 1.77001407696689655687e-65, 1.62171663012276352518e-66, -1.37729913276158871038e-65, -5.36704272737351272887e-67, 9.07072259346301624189e-66, -2.01474888647360391005e-68, -5.15016656020489424753e-66, 1.81442167409206017369e-67, 2.55953186685139661574e-66, -1.59294975502306147215e-67, -1.12766306534299205278e-66, 9.55460896764277536903e-68, 4.45205023721509257045e-67, -4.61951916919127245019e-68, -1.58971789399754463523e-67, 1.90913106016090416307e-68, 5.17535635238504385412e-68, -6.94957900801042835783e-69, -1.54690103261390592285e-68, 2.27010557542526022662e-69, 4.27135024230663391142e-69, -6.74118331851830079432e-70, -1.09552473078546303165e-69, 1.83769568946724908585e-70, 2.62271016418577208753e-70, -4.634722399081850245e-71, -5.88636357028495511053e-71, 1.08831011096448729214e-71, 1.24343141549030715789e-71, -2.39218221315177535825e-72, -2.48096739802051149769e-72, 4.94488673436084006797e-73, 4.69082871867921722413e-73, -9.65144377321296940625e-74, -8.42923622876910347301e-74, 1.78505351803658889935e-74, 1.44347328514843497584e-74, -3.13844824109287137636e-75, -2.36149185110123314133e-75, 5.26048134212637046659e-76, 3.69922698263805057737e-76, -8.42764907261417674017e-77, -5.56026666139877475329e-77, 1.29354055616387926046e-77, 8.03498910762228888759e-78, -1.90625342965597420365e-78, -1.11831334447608658596e-78, 2.70250047187106932337e-79, 1.50161439762512308472e-79, -3.69254224011390491096e-80, -1.9482655672833089881e-80, 4.87068289990473191589e-81, 2.44605058252718803335e-81, -6.21206120772948420306e-82, -2.97578621240504982101e-82, 7.67170869081467715708e-83, 3.51245593634967006337e-83, -9.18639317814230010206e-84, -4.02728510792974563466e-84, 1.06792737261361090607e-84, 4.49049462297313040439e-85, -1.20668574210558248702e-85, -4.8743349457711269928e-86, 1.32672954997536858544e-86, 5.15594669362981798846e-87, -1.42087914092913385248e-87, -5.31962840486749769917e-88, 1.48368737622407560343e-88, 5.35820510950819749742e-89, -1.51195080310160136692e-89, -5.27335398649844702827e-90, 1.50494216413682721824e-90, 5.07491835680499567332e-91, -1.46435015583523427258e-91, -4.77939272730499688318e-92, 1.39395869256547365883e-92, 4.40786352897837209542e-93, -1.29913348044331649663e-93, -3.98373074741516359669e-94, 1.1862032551354712739e-94, 3.53051737837919231409e-95, -1.06182547646032890842e-95, -3.07001024156112425116e-96, 9.32414082004750911302e-97},
            {-1.32095921062365319204e-71, -2.57224288249820142688e-70, 1.22362016335922885885e-69, 5.62945491365006014793e-69, -2.02291819618839712643e-68, -4.29916662036660701893e-68, 1.39888248078736830634e-67, 1.6915472035464643732e-67, -5.41382537595123033314e-67, -4.09247617206655691893e-67, 1.36067202568334033508e-66, 6.72090704224085779475e-67, -2.4314355124639247073e-66, -7.94795880885652542377e-67, 3.2831664496632935097e-66, 6.98713029967043071046e-67, -3.49980056127545455563e-66, -4.58031649740822711362e-67, 3.04368377868302959659e-66, 2.11951777686972189861e-67, -2.21553612008782495641e-66, -4.96189695709331532593e-68, 1.3777384073489295975e-66, -2.0690819494974187871e-68, -7.44248905133928828774e-67, 3.3725652596081218567e-68, 3.54128414504102718178e-67, -2.49033007640227880169e-68, -1.5016741642371228015e-67, 1.37121533690548023353e-68, 5.73191064186013085723e-68, -6.25876733905273668029e-69, -1.98642354113602418519e-68, 2.47554861587601946136e-69, 6.29721075442425606292e-69, -8.69655135448528556519e-70, -1.83816529812634419263e-69, 2.75726143655793294322e-70, 4.9694056304212246877e-70, -7.98130498717655170185e-71, -1.25069614380356270537e-70, 2.12806988605659212554e-71, 2.94396873214385254926e-71, -5.26394337739107113181e-72, -6.5080668337494017689e-72, 1.21512904559203741262e-72, 1.35624006557565127193e-72, -2.63091565713032585941e-73, -2.673396099963837303e-73, 5.366090841924620782e-74, 5.00006967206530910558e-74, -1.03499168501683157183e-74, -8.89820229655004501818e-75, 1.89416100754804751411e-75, 1.51066022827799473011e-75, -3.29926030391020447485e-76, -2.45246879771418353117e-76, 5.48433930090514674151e-77, 3.81562149371121802254e-77, -8.72203436532245034452e-78, -5.70076032007372822546e-78, 1.33008516425843555516e-78, 8.19448588378800879368e-79, -1.94898693011328274567e-79, -1.13524457467514318771e-79, 2.74937084866617128916e-80, 1.51824064060085669674e-80, -3.74037989024512806251e-81, -1.9630536961110574551e-81, 4.915439014159799697e-82, 2.45741061952219154336e-82, -6.24925958043283598004e-83, -2.98230048820277467547e-83, 7.69705088098088596528e-84, 3.51310632743871527623e-84, -9.1964140812828250948e-85, -4.02163415498623002393e-85, 1.06719239577769442659e-85, 4.47878396821991387988e-86, -1.2041897114099253307e-86, -4.85748079545579242844e-87, 1.32264196507352129971e-87, 5.13543271544762043927e-88, -1.41554606677328472993e-88, -5.2973164150819679804e-89, 1.47758828484929224494e-89, 5.3360984390115969996e-90, -1.50563727069462499126e-90, -5.25335465731832640355e-91, 1.49896938027909094719e-91, 5.05861660722909897381e-92, -1.45921260297158059887e-92, -4.76791762205401184813e-93, 1.39003948205566160907e-93, 4.40180944216394747682e-94, -1.29667338145413003403e-94, -3.98315991392272779928e-95, 1.18529137015631611594e-95, 3.53502649873876513038e-96, -1.06240972746758983346e-96, -3.07884122999407944215e-97},
            {4.16909460365277804311e-72, -2.81365493534392839244e-71, -2.31937618544066663072e-70, 9.3032036197846327215e-70, 2.8503721692018102876e-69, -9.64998627979788954468e-69, -1.55311152990982035525e-68, 4.97953104869305742688e-68, 4.83062681376271963714e-68, -1.56439950692623398859e-67, -9.77197497568576538923e-68, 3.3545804823123915481e-67, 1.38834231172881578044e-67, -5.28463687743033394819e-67, -1.45001527465802123985e-67, 6.43809666876906194713e-67, 1.13648110637783341674e-67, -6.29892226996853786387e-67, -6.59776222528551959886e-68, 5.09451733910970985534e-67, 2.55775631387639198883e-68, -3.48484655948200640288e-67, -2.63449599203557599855e-69, 2.05363690572623162578e-67, -5.46240222330652051233e-69, -1.05859134097907893806e-67, 5.77204342375074478168e-69, 4.83423718406097541535e-68, -3.75947202951660649051e-69, -1.97703737843098320657e-68, 1.92593175208386886072e-69, 7.3082946065312831271e-69, -8.3501605077848905317e-70, -2.46162197246372800369e-69, 3.17233881947617304457e-70, 7.60818874374739796479e-70, -1.07808102909653957218e-70, -2.17111215418455387453e-70, 3.32342069924790027765e-71, 5.75182966578069077988e-71, -9.39010966651684413117e-72, -1.42159765273107904652e-71, 2.45144077822367681142e-72, 3.29229615629444521155e-72, -5.95251155855952583202e-73, -7.17279825640219016041e-73, 1.35178373645071790204e-73, 1.47536257202080595347e-73, -2.88467971255378822668e-74, -2.87435413601873008421e-74, 5.80844772235865557016e-75, 5.31985546237431486846e-75, -1.10756968574842122476e-75, -9.37896185625428659198e-76, 2.00647545670548634946e-76, 1.57901309578462195474e-76, -3.4634426837534488255e-77, -2.54441234699530399622e-77, 5.71125763750859116865e-78, 3.93258616278929775679e-78, -9.01861068579404867245e-79, -5.84127449463644839016e-79, 1.36671083700708160492e-79, 8.35340664302378682152e-80, -1.99163437631064259659e-80, -1.15206972048729758227e-80, 2.79599763407332063277e-81, 1.53474174516965871588e-81, -3.78787555148249787933e-82, -1.97774358717751501269e-82, 4.95986409561886701723e-83, 2.46875566935625559756e-83, -6.28628569876912312983e-84, -2.9889402148263540474e-84, 7.72254291119927780184e-85, 3.5140696666511505618e-85, -9.2070559905267033204e-86, -4.01651073397720000934e-86, 1.06657713330635500451e-86, 4.467816148420274196e-87, -1.2018747973916703877e-87, -4.84155767894826614708e-88, 1.3187929062809595862e-88, 5.11598679648365656012e-89, -1.41049754286787984358e-89, -5.27614227677551164005e-90, 1.47180272528575701393e-90, 5.31512653073858370382e-91, -1.49964621675026878247e-91, -5.23441906575051788249e-92, 1.49330799982297812668e-92, 5.04325334049507184772e-93, -1.4543581120661261854e-93, -4.75722076111577913879e-94, 1.38636248250406137251e-94, 4.39635941374695642125e-95, -1.2944078891820233007e-95, -3.98302436962674555583e-96, 1.18452546528858267628e-96, 3.53982268407994500796e-97, -1.06309516834049078132e-97},
            {3.27002042294121945992e-73, 6.57994763351330250835e-72, -3.17235678988824640695e-71, -1.5121314433157206995e-70, 5.48434724713928588427e-70, 1.211419165256401304e-69, -3.96200235419639179686e-69, -4.99828140058377361171e-69, 1.60036271398200948258e-68, 1.26826403170843768578e-68, -4.19429666945572327661e-68, -2.18627289909984985407e-68, 7.80884401939578081489e-68, 2.71940924065911580626e-68, -1.09768314850660251589e-67, -2.52583823118528482013e-68, 1.21714807081256676731e-67, 1.76775641224316265666e-68, -1.10023356582816339277e-67, -9.00259936934083831819e-69, 8.3182352741658620268e-68, 2.73834838673103673674e-69, -5.36883109325874347122e-68, 3.11112456782404347759e-70, 3.00812992806954104366e-68, -1.11683108169860092904e-69, -1.48361072200492004126e-68, 9.3424576302845804865e-70, 6.51690098816138908833e-69, -5.5162000329320062701e-70, -2.57517047502168711975e-69, 2.6547083901690237305e-70, 9.23344027219153147745e-70, -1.09869739365331507819e-70, -3.0267570800476557676e-70, 4.02148166910359931534e-71, 9.13087142238791303811e-71, -1.32486106244389418056e-71, -2.54975744188055909284e-71, 3.97731020506206199999e-72, 6.62504448890894947734e-72, -1.09823689769805045946e-72, -1.60914653769333867492e-72, 2.81004394894392466441e-73, 3.66884508517123519699e-73, -6.7034223802398532333e-74, -7.88179008781996335041e-74, 1.49862160038407030908e-74, 1.60090145430110879914e-74, -3.15380457632015904271e-75, -3.08388556113882697164e-75, 6.2721718866954664769e-76, 5.65013576959788887029e-76, -1.18287730982442069031e-76, -9.87135262307244504275e-77, 2.12196531582769727133e-77, 1.64850623707626783816e-77, -3.63093336927428072453e-78, -2.63729373445805907035e-78, 5.94115585441802495553e-79, 4.05009951869492698725e-79, -9.31730374441066287332e-80, -5.98180728575151631013e-80, 1.40341410374926197133e-80, 8.51177948022862900819e-81, -2.03419957553825001789e-81, -1.16879502253469666958e-81, 2.84239404236347139262e-82, 1.55112686703156062489e-82, -3.83505167833007612638e-83, -1.99234573111905225045e-83, 5.00398673795238396493e-84, 2.48009509268541791136e-84, -6.32316838373808160527e-85, -2.99571073114896934866e-85, 7.74820606335246690317e-86, 3.51534457981427224317e-86, -9.2183246190201123918e-87, -4.01190489649335221866e-87, 1.06607995200445158224e-87, 4.45757206992823124576e-88, -1.19973682502393655088e-88, -4.82653824592908952868e-89, 1.31517571654036278653e-89, 5.09757552028183212733e-90, -1.40572488433591565972e-90, -5.25606956928593277378e-91, 1.4663207452669294762e-91, 5.2952533103205430584e-92, -1.49396734083874818598e-92, -5.21651453444056026753e-93, 1.4879482843955050339e-93, 5.02880156318713971031e-94, -1.44977825922960980566e-94, -4.74728210002944017135e-95, 1.38292107885554989063e-95, 4.391500559768543344e-96, -1.2923323955181756837e-96, -3.98331771001639788827e-97, 1.18390286237680751566e-97, 3.54490471936062154727e-98},
            {-1.03998992874654137524e-73, 7.13067210514341100463e-73, 6.07818140031118409576e-72, -2.46549077044223641151e-71, -7.83442670366912637451e-71, 2.67167990917339107181e-70, 4.47442708628202989427e-70, -1.43888755502877975457e-69, -1.45848665119150108257e-69, 4.71386988325443425193e-69, 3.09326204790101147438e-69, -1.05314080181661379621e-68, -4.61318261804887667744e-69, 1.7271238350628361264e-68, 5.07159070521761780431e-69, -2.18867784961300717398e-68, -4.20947915585722633307e-69, 2.22574722357845241794e-68, 2.62684424609252310198e-69, -1.86973320348383512091e-68, -1.15125188165887674802e-69, 1.32745823734419481431e-68, 2.31629348647099575112e-70, -8.113836968818941876e-69, 1.45043993735523558928e-70, 4.33522613572866245823e-69, -2.0262579482709409736e-70, -2.05077303823260495786e-69, 1.45077514884113862978e-70, 8.68251783536283119797e-70, -7.9025396050288292912e-71, -3.32071778020874258929e-70, 3.5989198301993577259e-71, 1.15657800511311521589e-70, -1.42755383929562670491e-71, -3.69430861744965512531e-71, 5.04731536358371974454e-72, 1.08893237402990910309e-71, -1.61498730411926122908e-72, -2.97829172828074651829e-72, 4.72813477989375305784e-73, 7.59562176883219304594e-73, -1.2773341647503777723e-73, -1.81426405310665476774e-73, 3.2061442053019744746e-74, 4.07475161882800303081e-74, -7.5196537350369582064e-75, -8.63623162160438313221e-75, 1.65598126544768117375e-75, 1.7329526754651250465e-75, -3.43860427702537007624e-76, -3.30202739781694804108e-76, 6.75745753913514910551e-77, 5.99085586265385650696e-77, -1.26091177588636407276e-77, -1.0375214079500986394e-77, 2.24059863801325893718e-78, 1.71911504668719634706e-78, -3.80167216558951050526e-79, -2.73108608903004567072e-79, 6.1739578132742809492e-80, 4.168142439372310316e-80, -9.61804551998341338886e-81, -6.12235886689771517073e-81, 1.44019214312904651345e-81, 8.66963340891121156005e-82, -2.07668676845419989663e-82, -1.18542662665249138666e-82, 2.88857327264079756796e-83, 1.56740485839785579144e-83, -3.88193012859096692202e-84, -2.00687015492026823996e-84, 5.04783440086848267755e-85, 2.49143774593558140136e-85, -6.35993503580435778388e-86, -3.0026169987424603076e-86, 7.77406033305276668265e-87, 3.51692961705586071116e-87, -9.23022502358010895986e-88, -4.00780705587952859259e-88, 1.06569926044017166543e-88, 4.44803349837121387633e-89, -1.19777179581284999313e-89, -4.8123964701961352251e-90, 1.31178405296307341037e-90, 5.08016714114299696167e-91, -1.4012198354331859576e-91, -5.23706371350383379402e-92, 1.46113289378734712695e-92, 5.27644452159946780307e-93, -1.48859086275730347376e-93, -5.19961000789079880137e-94, 1.4828809826260046646e-94, 5.01523558519593704416e-95, -1.44546503287529122038e-95, -4.73808252202799881271e-96, 1.37970896894947746692e-96, 4.38722055473834033149e-97, -1.29044249945085494272e-97, -3.98403377550519404663e-98, 1.1834209940384277018e-98},
            {-8.09907798947651714009e-75, -1.68267608904306196681e-73, 8.22030996984282535835e-73, 4.05584562478070953502e-72, -1.48462916301159371968e-71, -3.40470892828866134095e-71, 1.11940812475981033667e-70, 1.47139347341678881338e-70, -4.71502129260549786558e-70, -3.91082979005886276363e-70, 1.28748649562583098438e-69, 7.06659897087751353386e-70, -2.49534379198746352898e-69, -9.22925923839951993285e-70, 3.64868742638221151989e-69, 9.03408610852983127184e-70, -4.20521611489480445842e-69, -6.7186395417766202157e-70, 3.94817868688758051301e-69, 3.71730649671325704611e-70, -3.09815912501802184923e-69, -1.3496048209283699123e-70, 2.07404259596214525482e-69, 7.3162662990794991701e-72, -1.20452362711073608848e-69, 3.47574907830614640261e-71, 6.15382187950355444733e-70, -3.41842537334357522644e-71, -2.79838355734275910252e-70, 2.18046654554514296712e-71, 1.14408217610757973185e-70, -1.10905470521236613111e-71, -4.24182187268525280083e-71, 4.80687545413339648719e-72, 1.43702649567380942527e-71, -1.83361442497339461836e-72, -4.47781546575318020285e-72, 6.27662397805073743127e-73, 1.29090832238255610569e-72, -1.95382084546167090834e-73, -3.46107288953504057821e-73, 5.5855649820749088456e-74, 8.67026775745766989031e-74, -1.4778740093317015416e-74, -2.03787345861024333307e-74, 3.64203033255143837044e-75, 4.5111336890085425814e-75, -8.40416049629160205163e-76, -9.43726914985221370584e-76, 1.82419231369401189064e-76, 1.8716059053820781459e-76, -3.73937706235842247253e-77, -3.52881018876154737825e-77, 7.26447980619935880851e-78, 6.34195731166370748683e-78, -1.3416687808921013816e-78, -1.08903880644436827701e-78, 2.36234327310147800938e-79, 1.79081597606281328849e-79, -3.97560079708858021227e-80, -2.82576437236879513484e-80, 6.40959165740549358115e-81, 4.28669801953158293524e-81, -9.92077396787586655776e-82, -6.26293131579260092546e-82, 1.47704273820404623425e-82, 8.82699822020058620475e-83, -2.11910058350133356825e-83, -1.20197057961408604231e-83, 2.93454848251835197982e-84, 1.58358427832680179511e-84, -3.92853217352521671595e-85, -2.02132644678188412912e-85, 5.09143346314692880502e-86, 2.50279201470655735215e-86, -6.39661172127981698507e-87, -3.00966363296414460223e-87, 7.80012452427562852612e-88, 3.51882326877356265903e-88, -9.24276167300524514996e-89, -4.00420797709992885716e-89, 1.06543350972278614231e-89, 4.439183016535345549e-90, -1.19597588015303361309e-90, -4.79910757654385460412e-91, 1.30861187014730976669e-91, 5.06373148751952273415e-92, -1.39697454514008093856e-92, -5.21909186375599532695e-93, 1.45623019182779687651e-93, 5.25866762033997372669e-94, -1.48350749203465761495e-94, -5.18367595963766673238e-95, 1.47809730197816633255e-95, 5.00253094808647407619e-96, -1.44141081058764852217e-96, -4.72960379050749024256e-97, 1.37672014687224584934e-97, 4.38350760668371924354e-98, -1.28873399703531555242e-98, -3.98516664440544213053e-99},
            {2.59502183718779187431e-75, -1.80709323112434870482e-74, -1.59148263334287978644e-73, 6.52740181586937262655e-73, 2.14909981929963623929e-72, -7.38247652171344451421e-72, -1.2850853668050541012e-71, 4.14606412348583802756e-71, 4.38489360319481865567e-71, -1.4151583942362777845e-70, -9.73783911339982264121e-71, 3.29134951774690529988e-70, 1.52221794910943907626e-70, -5.61470657727633027195e-70, -1.7581125163774585376e-70, 7.39555331078273854575e-70, 1.54062736620462812407e-70, -7.81145030523994424079e-70, -1.02681292102365063942e-70, 6.81076796897629653834e-70, 4.97649672864628913885e-71, -5.01536704208767263531e-70, -1.37652839404910189636e-71, 3.17752469374014968144e-70, -2.8796567209114580813e-72, -1.75865495051045426977e-70, 6.83703736366308881875e-72, 8.61246839153518213631e-71, -5.48218447064943462341e-72, -3.77260072408234176811e-71, 3.19031335740419169849e-72, 1.49198609237579262194e-71, -1.52863619627348318241e-72, -5.37039292528993534318e-72, 6.33448666985098981388e-73, 1.77186676494319388672e-72, -2.33039125023086088641e-73, -5.39189425931829885961e-73, 7.73871493412504510006e-74, 1.52171424533918152065e-73, -2.34709255235425599506e-74, -4.00261823355035083108e-74, 6.55972314473274873959e-75, 9.85580855490354242803e-75, -1.70146965647098202859e-75, -2.28089818063132045454e-75, 4.12001007819226073407e-76, 4.97908967332704608423e-76, -9.35986960215012293097e-77, -1.02860061705586134661e-76, 2.0035750983214606528e-77, 2.01694479606155826255e-77, -4.05640584284187696571e-78, -3.7642585333745876696e-78, 7.7933959581401060765e-79, 6.70337865089771250081e-79, -1.42514267997959429286e-79, -1.14167192930360474401e-79, 2.48716704361739358826e-80, 1.86358653948336309968e-80, -4.15266299113699207787e-81, -2.92130531701411577809e-81, 6.64798972429643725494e-82, 4.40575144413223826155e-82, -1.02254327358402857186e-82, -6.40352845795196647972e-83, 1.51396423430123810436e-83, 8.983904356111974051e-84, -2.16144599527162655717e-84, -1.21843282585718083161e-84, 2.98033276534551837731e-85, 1.59967340304458786993e-85, -3.97487850935230911634e-86, -2.03572377970397161929e-86, 5.13480927360885563042e-87, 2.51416584488474301778e-87, -6.43322325331524346457e-88, -3.01685493150765658796e-88, 7.82641633684383717321e-89, 3.5210239798632588278e-89, -9.25593851014240177499e-90, -4.00109876663591957248e-90, 1.06528119403878971817e-90, 4.43100398465124353413e-91, -1.1943454100463287811e-91, -4.78664797243183558813e-92, 1.30565340454465411171e-92, 5.0482398720392518718e-93, -1.39298154440192515221e-93, -5.20212280721803852533e-94, 1.45160410510918110711e-94, 5.24189167531340635877e-95, -1.47870839955597072424e-95, -5.16868430574095911719e-96, 1.47358888251616991553e-96, 4.99066435815557393336e-97, -1.43760833753474078761e-97, -4.72182850440387248504e-98, 1.37394888736658267691e-98, 4.38035043351613710883e-99, -1.28720287194358058531e-99},
            {2.00694244747268093241e-76, 4.30183143627351639759e-75, -2.12899825418231817022e-74, -1.08635623623772450798e-73, 4.01315359199994353414e-73, 9.54541623894366906377e-73, -3.15535158334028589658e-72, -4.31606836877227716664e-72, 1.38471776476007073373e-71, 1.20025846439581192832e-71, -3.93622931570620075026e-71, -2.27038498695812926341e-71, 7.93567950891639384941e-71, 3.10852854451362398204e-71, -1.20607866127448214535e-70, -3.19960715624109764622e-71, 1.443757649355196615e-70, 2.51887651787843317507e-71, -1.40690051451731540604e-70, -1.50003005157914295163e-71, 1.14507970928188270479e-70, 6.22011730389752450715e-72, -7.94566906699810634627e-71, -1.02887629055723041247e-72, 4.78007103102268666966e-71, -9.7995664237646893752e-73, -2.52816321383502950015e-71, 1.21498009763811695919e-72, 1.1894674015489917873e-71, -8.461191011789207248e-73, -5.02851987879285729373e-72, 4.56285886501767690582e-73, 1.92678698710717928083e-72, -2.0734457229251299027e-73, -6.74237353272164613195e-73, 8.24593746329024844574e-74, 2.16898622238885508253e-73, -2.93296260181993851607e-74, -6.45225341108862681247e-74, 9.46548598453989855896e-75, 1.78419257943973436041e-74, -2.80090221662681075725e-75, -4.60759626035296541614e-75, 7.66116794406225175908e-76, 1.1159175690837124272e-75, -1.94977291843680437331e-76, -2.544260107798985087e-76, 4.64240538727654314087e-77, 5.47969723161510422786e-77, -1.03896756839746242909e-77, -1.11835038201075179323e-77, 2.19444062898274974973e-78, 2.16904726572402883136e-78, -4.38995868251987827572e-79, -4.00839160618912782811e-79, 8.34434661486090892973e-80, 7.0750559939658741501e-80, -1.51132665620717370396e-80, -1.19540558126551476829e-80, 2.61503790381219091381e-81, 1.93740531487270035178e-81, -4.33280454465182588079e-82, -3.01768736394327612513e-82, 6.88908844995124525231e-83, 4.52528986770161764904e-83, -1.05319708883327437135e-83, -6.54415572164294018141e-84, 1.55095549949769454388e-84, 9.14038279579790670612e-85, -2.20372828651014018959e-85, -1.23481920508573926878e-85, 3.02593913061219269864e-86, 1.61568023619479346777e-86, -4.02098926983780466182e-87, -2.05007093384043518226e-87, 5.17798620003682406761e-88, 2.52556677163038681627e-88, -6.46979326784529400792e-89, -3.02419490063775574092e-89, 7.85295244734094559772e-90, 3.52353016238816718956e-90, -9.26975900830036516528e-91, -3.99847086246468889875e-91, 1.06524085097932056559e-91, 4.42348050293122051954e-92, -1.19287687216789907182e-92, -4.7749951840857595154e-93, 1.30290315980036620113e-93, 5.03366500763896479707e-94, -1.38923372489071189271e-94, -5.18612687025688075921e-95, 1.44724651871435432585e-95, 5.22608727616945936458e-96, -1.47418519113972447323e-96, -5.1546083240945166824e-97, 1.46934777245312270883e-97, 4.97961362382830648673e-98, -1.43405070630655270588e-98, -4.7147400562757861072e-99, 1.37138973122108104971e-99, 4.37773824063904994044e-100},
            {-6.47698343789186455602e-77, 4.57953857879034114418e-76, 4.16364811735315300767e-75, -1.72648255216473543345e-74, -5.88423639920611064264e-74, 2.03617653661775886233e-73, 3.68002069484499394897e-73, -1.19142764199035834298e-72, -1.31299778187144708457e-72, 4.23347317707531888472e-72, 3.04961060054489066118e-72, -1.0241929617914979705e-71, -4.98997862760420403346e-72, 1.81601775542015847057e-71, 6.04421603157466278647e-72, -2.48445252246020104e-71, -5.57727694262661453578e-72, 2.72365637364221701032e-71, 3.95011015283016463079e-72, -2.46310051882144105836e-71, -2.08600557332453871975e-72, 1.88005075864440319498e-71, 7.05975075079473759941e-73, -1.23384899839670264608e-71, 1.94955296727129288577e-75, 7.06960056591854931163e-72, -2.18710182182334785605e-73, -3.58201167148392034803e-72, 2.02385566460657317601e-73, 1.6224743773679470902e-72, -1.26650456228695559546e-73, -6.63132180459770626629e-73, 6.39861155910492873503e-74, 2.46551782729729760157e-73, -2.77220588684333662242e-74, -8.39799699835684851175e-74, 1.06143529783753261603e-74, 2.63700791583622139292e-74, -3.65805151686599114514e-75, -7.67570263008398306078e-75, 1.14914815804240208777e-75, 2.08132609106104204381e-75, -3.32171620209521832205e-76, -5.28081815300942173785e-76, 8.9008777207564270421e-77, 1.2587392112268663062e-76, -2.22447081591740970851e-77, -2.82887802163013161054e-77, 5.21154790503310657282e-78, 6.01401235177406570729e-78, -1.1496437221164317667e-78, -1.21307815044153923658e-78, 2.39709051916290709351e-79, 2.32798578867460101321e-79, -4.74028932801798680821e-80, -4.26122365586228392747e-80, 8.91745692986181896024e-81, 7.45692360304300516787e-81, -1.6002128802618197721e-81, -1.25022494003226887689e-81, 2.74592408289657428275e-82, 2.01225194016720975484e-82, -4.51597337537167979211e-83, -3.11489060001063292639e-83, 7.13282826686341508504e-84, 4.6453022994362472409e-84, -1.08403426398784878887e-84, -6.68482000351718760475e-85, 1.58801588760244151554e-85, 9.29646495362032538737e-86, -2.24595301347187061879e-86, -1.25113545063688354575e-86, 3.07138048719173150217e-87, 1.63161251896957289791e-87, -4.06688403973867303744e-88, -2.0643763176804900933e-88, 5.22098767607269586197e-89, 2.53700194639313788243e-89, -6.50634429481010785997e-90, -3.03168727930881204411e-90, 7.8797485839829028556e-91, 3.52634020685100938576e-91, -9.28422622254186188096e-92, -3.99631602415845734809e-92, 1.06531106168772316469e-92, 4.41659737621845308038e-93, -1.19156690126416899411e-93, -4.76412779670360604135e-94, 1.30035589299894194454e-94, 5.01998092933331936189e-95, -1.38572431917210442643e-95, -5.171075831157149266e-96, 1.44314971343151974748e-96, 5.21122644756283173978e-97, -1.46992988291303141959e-97, -5.14142257911059928333e-98, 1.46536640534339687436e-98, 4.96935759707237318302e-99, -1.4307313380717211746e-99, -4.70832259290698735013e-100, 1.36903747156977601522e-100},
            {-4.9755291458631618614e-78, -1.09948079758899497249e-76, 5.51128502875167561082e-76, 2.90596411881279143828e-75, -1.08331524965662573881e-74, -2.66986422765328974787e-74, 8.87432103409037072222e-74, 1.26174924211324035232e-73, -4.05423338530398481904e-73, -3.66715487682297778006e-73, 1.19879216517934070247e-72, 7.25288850704391086367e-73, -2.51207653219522369081e-72, -1.03952909057337528692e-72, 3.96544001400737733198e-72, 1.12293069010190552651e-72, -4.92686496800199425589e-72, -9.32795506454446720345e-73, 4.97972271110293583146e-72, 5.93704548660942959163e-73, -4.20105428258914020383e-72, -2.73891139228571543084e-73, 3.01966852766218109508e-72, 6.78490933959066153947e-74, -1.88063411111744563341e-72, 2.26845534899706111235e-74, 1.02910617577915050322e-72, -4.16738199713178673684e-74, -5.00662736295776683859e-73, 3.21877188585392070607e-74, 2.18741517859993783089e-73, -1.84817440757034558436e-74, -8.65748027394380374207e-74, 8.81863676439877134711e-75, 3.12761424950005838951e-74, -3.65837060771526586772e-75, -1.03820372134456969043e-74, 1.3522461028852806166e-75, 3.18531342343874969088e-75, -4.52409928606320975669e-76, -9.08015806976115452582e-76, 1.38539386253802575824e-76, 2.41623456037673474453e-76, -3.91636368999397375001e-77, -6.02722908601574088149e-77, 1.02902327745614125766e-77, 1.41475586543218387557e-77, -2.52728224207405494409e-78, -3.13566616235531763748e-78, 5.82977475828133120753e-79, 6.58306859194585304796e-79, -1.26829732013115470182e-79, -1.31288177038268549524e-79, 2.61181698971398834975e-80, 2.49382768838266504492e-80, -5.10763776819715815513e-81, -4.52276448370047860484e-81, 9.51283774684493956253e-82, 7.84891441406907152215e-82, -1.69179266030534321416e-82, -1.30611559064392703061e-82, 2.87979421354049945463e-83, 2.08810710585390211295e-83, -4.70211955949621417919e-84, -3.21289669567863202426e-84, 7.37915349709299990697e-85, 4.76577949399494837637e-85, -1.11505070978939150433e-85, -6.82552954424072949308e-86, 1.62514520351551685102e-86, 9.45218258797690357987e-87, -2.28812597436512506882e-87, -1.26738718851411156441e-87, 3.11666962911828454236e-88, 1.64747774008439649583e-88, -4.11258186891253916249e-89, -2.07864798811220918571e-89, 5.26383624613108047985e-90, 2.54847816209818933591e-90, -6.54289782495733483047e-91, -3.03933556134840022664e-91, 7.90681959593172569141e-92, 3.52945249221431856963e-92, -9.29934283633315641345e-93, -3.99462632313664971147e-93, 1.06549045085258308249e-93, 4.41034008061775357658e-94, -1.19041227386742955652e-94, -4.75402539846698198978e-95, 1.29800660175170234748e-95, 5.00716292118655414478e-96, -1.38244688217153165017e-96, -5.15694283873405224249e-97, 1.43930634368567659835e-97, 5.19728256904941291802e-98, -1.46593487834543527506e-98, -5.12910285136894252705e-99, 1.46163757879254734426e-99, 4.95987611853609050493e-100, -1.42764396495417051882e-100, -4.70256097825658440335e-101},
            {1.61703745561942237663e-78, -1.16052503347260552454e-77, -1.08844582413725655344e-76, 4.56232787747471247753e-76, 1.60821984987643823559e-75, -5.60606373726261629304e-75, -1.05087650428623406488e-74, 3.4148401402867518546e-74, 3.91652661155041355571e-74, -1.26216327985541464617e-73, -9.50333715617709099552e-74, 3.17384532253662830864e-73, 1.62563484644413238466e-73, -5.84508815400955816427e-73, -2.06183063832090798477e-73, 8.29969795004503528959e-73, 1.99885741489482449998e-73, -9.43733367491321903572e-73, -1.49826381069892155945e-73, 8.8462647757963908657e-73, 8.53121655071628419205e-74, -6.99445046109072874842e-73, -3.3407268375393920307e-74, 4.75211778023096593484e-73, 4.19969083995748307773e-75, -2.81711890189159865763e-73, 6.45675289805419772203e-75, 1.47596121426085515049e-73, -7.27379222444026425201e-75, -6.90914204251789970715e-74, 4.94003265797978541897e-75, 2.91684354042063666326e-74, -2.63914499319710524885e-75, -1.11960220556790859655e-74, 1.19673137507954911003e-75, 3.93510864330646287575e-75, -4.77059207314041442683e-76, -1.27440484412201786273e-75, 1.70632417233592269199e-76, 3.82406306074608832849e-76, -5.5513334861404862612e-77, -1.06846432851930187431e-76, 1.65928217429278706222e-77, 2.79217105278904249654e-77, -4.59203163559875184284e-78, -6.8518994316171572653e-78, 1.18409968423681499255e-78, 1.58468410573955951673e-78, -2.85995469179698033546e-79, -3.46553292842071667364e-79, 6.49942462298174719781e-80, 7.18787650553889667938e-80, -1.39520602622119420551e-80, -1.41785509284664790446e-80, 2.83890292285827584187e-81, 2.66663543149525915547e-81, -5.49223081739019607038e-82, -4.7930199010239734849e-82, 1.0130586724620624863e-82, 8.25096051997040984461e-83, -1.7860565821914396345e-83, -1.36306355495091307044e-83, 3.01661744668054134165e-84, 2.1649525442256542177e-84, -4.89119535723071628632e-85, -3.31168884338144252168e-85, 7.62801224175889640111e-86, 4.88671384786175500448e-86, -1.14624280152319482188e-86, -6.96629381346839132011e-87, 1.66234367084143960368e-87, 9.60756771990517562315e-88, -2.33025318063429092636e-88, -1.28357993699929290484e-88, 3.16181922362449631468e-89, 1.66328314556554926726e-89, -4.15810128692293675064e-90, -2.09289366942215855969e-90, 5.3065536083741469001e-91, 2.5600018766347569358e-91, -6.57947437250957651993e-92, -3.04714301587092737225e-92, 7.9341795174939850545e-93, 3.53286539479863383125e-93, -9.315111203983219463e-94, -3.99339413309718946351e-94, 1.06577768656845898529e-94, 4.4046947319860785095e-95, -1.18940990231237771981e-95, -4.74466852808201664958e-96, 1.29585051206810553935e-96, 4.99518744809159348604e-97, -1.37939527384221820049e-97, -5.14370233637880041371e-98, 1.43570941693625104259e-98, 5.18423030030885877706e-99, -1.46219294681351021034e-99, -5.11762607185649698074e-100, 1.45815443456940368927e-100, 4.95114996613985635799e-101, -1.42478261353945236013e-101},
            {1.23407065857989201858e-79, 2.80937315913829532636e-78, -1.42603374043516791725e-77, -7.76357234060742625284e-77, 2.92045210802617497543e-76, 7.45091328707832925609e-76, -2.49052250832943556313e-75, -3.67664388259418038929e-75, 1.18353226993961008174e-74, 1.11564599047538973638e-74, -3.63747901089858475329e-74, -2.3044763166751244212e-74, 7.91692391214398801842e-74, 3.45294569593750953615e-74, -1.2971063928373282864e-73, -3.90770856040272869027e-74, 1.67155351556733600321e-73, 3.41586166070902644886e-74, -1.7511993535760202326e-73, -2.31098884444741770468e-74, 1.53036472494541508706e-73, 1.16594004251092869384e-74, -1.1387727999672701397e-73, -3.65406171176429841757e-75, 7.33782313328370219629e-74, -2.59733510754021399616e-76, -4.1520326747037375286e-74, 1.36441139127785335818e-75, 2.08758502315820106082e-74, -1.19798058300594943203e-75, -9.42099734269049886835e-75, 7.36650461084197915117e-76, 3.84945935555625716172e-75, -3.6981585932406947834e-76, -1.43498322707040187574e-75, 1.60152455111726455726e-76, 4.91282382981087229788e-76, -6.15319548908244303697e-77, -1.55385935110660066022e-76, 2.13405607208592772757e-77, 4.56421335609158276489e-77, -6.76183021716177590783e-78, -1.25092862096488681558e-77, 1.97508482921747150139e-78, 3.21251783233178211204e-78, -5.35625855247106708771e-79, -7.76001593777298800941e-79, 1.3565297958932462627e-79, 1.7692457581937343018e-79, -3.22426107550345445814e-80, -3.81937970707850933114e-80, 7.22283408163070921921e-81, 7.82942323557960996437e-81, -1.53064302904973462521e-81, -1.52808808023922745375e-81, 3.07862196123192568903e-82, 2.84646692081219649818e-82, -5.89428271593713501444e-83, -5.07199216496140231371e-83, 1.0770789426844589437e-83, 8.66299361401133473448e-84, -1.88299464033646556069e-84, -1.42105531662330536245e-84, 3.15636355363807243071e-85, 2.24277101584532707832e-85, -5.08315522763917796862e-86, -3.41125169680489213471e-86, 7.87935626808232679994e-87, 5.00809930113253953872e-87, -1.17760735526002020694e-87, -7.10712340354317341747e-88, 1.69961190163645723473e-88, 9.76265256057142111621e-89, -2.37234083085301806465e-89, -1.29971910676577560895e-89, 3.20684180119300741775e-90, 1.67903574832589713022e-90, -4.2034603179961927157e-91, -2.10712077128379617605e-91, 5.34916065579974388732e-92, 2.57157923476883741823e-92, -6.61609353396437393682e-93, -3.05511270607129978253e-93, 7.96184162760945443036e-94, 3.53657729617468605012e-94, -9.33153338926227792379e-95, -3.99261212064774613767e-95, 1.06617148008381113755e-95, 4.39964805616885604037e-96, -1.18855682904033274583e-96, -4.73603862559661607962e-97, 1.2938830669569663636e-97, 4.98403209199496869302e-98, -1.37656364294615472248e-98, -5.1313299911220336875e-99, 1.43235227442956102237e-99, 5.17204551128869818386e-100, -1.45869720357962290847e-100, -5.10697026045553604789e-101, 1.45491044001479859378e-101, 4.94316080687301106971e-102},
            {-4.03811576717266187617e-80, 2.94089449837218972834e-79, 2.84325597876561094796e-78, -1.20456357990978597471e-77, -4.38790852185468630183e-77, 1.54085357207250432567e-76, 2.99289507239178888072e-76, -9.76314498771732222314e-76, -1.16398662978772559089e-75, 3.75076749861175616396e-75, 2.94756061518753868787e-75, -9.79619372967311648744e-75, -5.26492505612025789973e-75, 1.87250628258924075014e-74, 6.98214468374812994284e-75, -2.75778189437035232853e-74, -7.09741024396792716128e-75, 3.25033213353124967414e-74, 5.61127241998804991092e-75, -3.15605519875106646742e-74, -3.41839613847461589768e-75, 2.58332718511093689099e-74, 1.50041544735074763345e-75, -1.81592592692374448292e-74, -3.25483360855552730849e-76, 1.11315017415247508658e-74, -1.65028143475290932345e-76, -6.02728672511164110993e-75, 2.53129040952603108517e-76, 2.91432367292824775599e-75, -1.8909376440218977757e-76, -1.27019197590745185808e-75, 1.07231800276998854723e-76, 5.03089658312140051555e-76, -5.0963224901541576193e-77, -1.82369975500555108027e-76, 2.11623066540928004511e-77, 6.08856505000103204826e-77, -7.85665847709286741698e-78, -1.88254591286605686431e-77, 2.64697820151548828033e-78, 5.41753178018884062808e-78, -8.17957030387505572325e-79, -1.45753123874312336565e-78, 2.33735034605629139624e-79, 3.68078197048407301625e-79, -6.21692724324182320295e-80, -8.75687294459525058469e-80, 1.5475608886693302785e-80, 1.9691667260821439102e-80, -3.6219966339686401538e-81, -4.19809983254563261558e-81, 8.00233427102840195216e-82, 8.50867226496842559477e-82, -1.67487684504777806882e-82, -1.64366692565418080619e-82, 3.33123864682661318692e-83, 3.03337578552615853863e-83, -6.31399574242239683092e-84, -5.35968039250701265138e-84, 1.14335203739010158014e-84, 9.08494539541582847458e-85, -1.98259635956525540501e-85, -1.48007784210668049613e-85, 3.29900301650902001729e-86, 2.32154629365888492501e-86, -5.27795583408550695763e-87, -3.51157131131599784154e-87, 8.1331408949642181466e-88, 5.12993124456083434805e-88, -1.20914160509031562793e-88, -7.2480299313333277984e-89, 1.73695086817188098402e-89, 9.91746944682807735283e-90, -2.41439528701590829078e-90, -1.31581000142374598336e-90, 3.25174974739997782346e-91, 1.69474233750982091432e-91, -4.24867649620615750012e-92, -2.1213364057857413046e-92, 5.39167751549935550882e-93, 2.58321608859311500973e-93, -6.6527740432769305933e-94, -3.06324750653514473533e-94, 7.98981850500116360421e-95, 3.54058659015353582158e-95, -9.34861120055172297808e-96, -3.99227323615322122182e-96, 1.06667058545322979527e-96, 4.39518736087564749813e-97, -1.18785022117737639778e-97, -4.72811798626122030054e-98, 1.29209991570788163521e-98, 4.97367549223655032926e-99, -1.37394641186642000715e-99, -5.1198026273362870911e-100, 1.42922857320427699112e-100, 5.16070521689972308543e-101, -1.45544109107821617022e-101, -5.09711446836653077474e-102, 1.4518993706503296777e-102},
            {-3.06216849830506353157e-81, -7.17669370587322516361e-80, 3.68819982714645808753e-79, 2.07162335805588594254e-78, -7.8631187440813365073e-78, -2.07491020092304343022e-77, 6.97511286235887041303e-77, 1.06804010574502273548e-76, -3.4452926198588399403e-76, -3.38028448301837696149e-76, 1.09979948160969318091e-75, 7.28450330962991936988e-76, -2.48444905741479674787e-75, -1.13965737464874259839e-75, 4.2219650650927558844e-75, 1.34908770341742926845e-75, -5.63949379457019917688e-75, -1.23807911328309004045e-75, 6.12014415345438765487e-75, 8.86461294653852219333e-76, -5.53684249262436886224e-75, -4.83329860296493107165e-76, 4.26274570680965586352e-75, 1.7820199872457609187e-76, -2.84025431033750086524e-75, -1.43906530999591837588e-77, 1.66092138311581615328e-75, -4.17820250792258379873e-77, -8.62579718038865907985e-76, 4.34920800199878464064e-77, 4.01878265367007190973e-76, -2.88718559295302236839e-77, -1.69442671516057891591e-76, 1.52896290997477185573e-77, 6.51455634133426236407e-77, -6.91887458995173665123e-78, -2.2992179152735856075e-77, 2.7640813431696188342e-78, 7.49330904079984077639e-78, -9.93809200445894507638e-79, -2.26698572121510351643e-78, 3.25783565622081092532e-79, 6.39660874570049089439e-79, -9.83048930004253024377e-80, -1.69050347201098405024e-79, 2.75090458423507508759e-80, 4.2005907021857423681e-80, -7.18225659644424987124e-81, -9.84786369920049495711e-81, 1.75847272876429609942e-81, 2.18517588190957722433e-81, -4.05497596799659199887e-82, -4.6025776674525081542e-82, 8.84024781820742154819e-83, 9.22656330947114895844e-83, -1.82817116160856870355e-83, -1.76467418120867140552e-83, 3.59700859498894459281e-84, 3.22741166728180009245e-84, -6.75156083265886512453e-85, -5.65608095287795754206e-85, 1.21188440549348492675e-85, 9.51674793940140850967e-86, -2.08485090828198278352e-86, -1.54011859790669324664e-86, 3.44450710774063938794e-87, 2.40126314515041378175e-87, -5.47555604142671761022e-88, -3.61263508573144942593e-88, 8.38932487794254302221e-89, 5.25220643168473825721e-89, -1.24084318134780509791e-89, -7.38902594765221804421e-90, 1.77436187659936009906e-90, 1.00720507840941380685e-90, -2.45642305303281343639e-91, -1.33185781843684173504e-91, 3.29655529635123623051e-92, 1.71040948759281265395e-92, -4.29376688078100584933e-93, -2.13554740354929786216e-93, 5.43412358614569507698e-94, 2.59491801661848291652e-94, -6.68953382365973109894e-95, -3.07155011918989731326e-95, 8.01812207932701518487e-96, 3.54489168896780354469e-96, -9.36634622284340288135e-97, -3.99237070481188970166e-97, 1.06727379910896018512e-97, 4.39130050909560141109e-98, -1.18728736537318552486e-98, -4.72088971721875452386e-99, 1.29049690380692898408e-99, 4.96409728970080207132e-100, -1.37153826237599036626e-100, -5.10909816473072585457e-101, 1.42633226925665184682e-101, 5.15018751592374929106e-102, -1.45241836141201888034e-102, -5.08803872417823340987e-103}
        };

        const double ccli22logA0c[101] = {0, 0, -0.5, 0.166666666666666666667, -0.0243055555555555555556, 0.000810185185185185185185, 0.000225694444444444444444, -0.000015707671957671957672, -3.7399218946837994457e-6, 3.43044882562078329274e-7, 7.1763852145796590241e-8, -7.78156263440654975047e-9, -1.47086242414525242808e-9, 1.79672056774644442708e-10, 3.13325376813200717691e-11, -4.19430587060056111483e-12, -6.85058417642191892633e-13, 9.87016620635660156991e-14, 1.5266023393364573573e-14, -2.33754460642721998853e-15, -3.45199863373743750751e-16, 5.56536215646686180133e-17, 7.89684467928820084854e-18, -1.33100025541818477607e-18, -1.82363235919039218142e-19, 3.19554638218540572433e-20, 4.2444830086013091828e-21, -7.69802273179019706279e-22, -9.94451054596609438261e-23, 1.85996392793053766613e-23, 2.34313110005600825826e-24, -4.505835431340328921e-25, -5.5479482032991709271e-26, 1.09413079092365653511e-26, 1.31923459962264118653e-27, -2.66245657738419939233e-28, -3.14879758378846817e-29, 6.49122249081160808268e-30, 7.540792952937665342e-31, -1.5853482102122525428e-31, -1.81127604515170401026e-32, 3.87802573822134671737e-33, 4.36231268749658875125e-34, -9.50006533538207899247e-35, -1.05317734473315484038e-35, 2.33035162577438606874e-36, 2.54825125800861874757e-37, -5.72334994178421246228e-38, -6.17810337000615361101e-39, 1.40725629812105408274e-39, 1.50060713810987478754e-40, -3.463813972788134771e-41, -3.6510127811206159267e-42, 8.53419384130274406116e-43, 8.89687090408070355428e-44, -2.10459424430781729639e-44, -2.17114219686626349368e-45, 5.19453091960161539523e-46, 5.30543744459093185058e-47, -1.28313683643891304529e-47, -1.29806273723310370729e-48, 3.17195513922907521352e-49, 3.17962126121433597498e-50, -7.8467382530547247291e-51, -7.79699999096725161419e-52, 1.94241344461518605572e-52, 1.91391394953787814851e-53, -4.81136568060016740441e-54, -4.70254576593936964651e-55, 1.19248894989486688972e-55, 1.15647117800463357732e-56, -2.95723594753190833257e-57, -2.84646131466812178348e-58, 7.33754160576056359659e-59, 7.01170861487019788084e-60, -1.82153067162069314273e-60, -1.72850892275673571797e-61, 4.52410730083232716618e-62, 4.2641372412034205833e-63, -1.12416423610985751373e-63, -1.05265592841849102826e-64, 2.79458780500708498926e-65, 2.60029470958383648239e-66, -6.95005416438858000563e-67, -6.42725909460339824799e-68, 1.72915109543550234001e-68, 1.58958359347749891054e-69, -4.30372434188221251681e-70, -3.93353832356079220708e-71, 1.07155780699197228164e-71, 9.73900937651699352137e-73, -2.66894591170955615475e-73, -2.41249955117835753091e-74, 6.64983259524305029487e-75, 5.97903517703588857186e-76, -1.65738178883347445024e-76, -1.48250905719248060376e-77, 4.13209033549733790404e-78, 3.67754095036823461176e-79, -1.03049823193560343583e-79, -9.12648723984637039617e-81};

        const double ccli22logA0d[101] = {0, 1., -0.25, 0.0277777777777777777778, 0, -0.000277777777777777777778, 0, 4.72411186696900982615e-6, 0, -9.18577307466196355085e-8, 0, 1.8978869988970999072e-9, 0, -4.06476164514422552681e-11, 0, 8.92169102045645255522e-13, 0, -1.99392958607210756872e-14, 0, 4.51898002961991819165e-16, 0, -1.03565176121812470145e-17, 0, 2.39521862102618674574e-19, 0, -5.58178587432500933628e-21, 0, 1.30915075541832128581e-22, 0, -3.08741980242674029324e-24, 0, 7.31597565270220342036e-26, 0, -1.74084565723400074099e-27, 0, 4.15763564461389971962e-29, 0, -9.96214848828462210319e-31, 0, 2.39403442489616530052e-32, 0, -5.76834735536739008429e-34, 0, 1.39317947964700797783e-35, 0, -3.37212196548508947047e-37, 0, 8.17820877756210262176e-39, 0, -1.98701083115238592556e-40, 0, 4.83577851804055089629e-42, 0, -1.17869372487183843267e-43, 0, 2.877096408117257145e-45, 0, -7.03205909815602801496e-47, 0, 1.72086031450331462909e-48, 0, -4.21607239056044549168e-50, 0, 1.03404064051330395739e-51, 0, -2.53866306259946531616e-53, 0, 6.23855317692459088784e-55, 0, -1.53443980691346503917e-56, 0, 3.777294635578550234e-58, 0, -9.30586212480468658839e-60, 0, 2.29434368222418732072e-61, 0, -5.66068873941414784857e-63, 0, 1.39756872198540085454e-64, 0, -3.45267347330633889778e-66, 0, 8.53498373696321710664e-68, 0, -2.11106753916379301954e-69, 0, 5.22446788920815644493e-71, 0, -1.29363445303169121491e-72, 0, 3.20479645174984764253e-74, 0, -7.94326694999713716406e-76, 0, 1.96969401238294242761e-77, 0, -4.88642119356886536649e-79, 0, 1.2127399993287380323e-80, 0};

        // BELOW ARE THE CONSTANTS USED FOR LI22 logA1 (FF2)

        const double ccli22logA1k1[100][100] = {{0.671455219927412574303, 2.14637335433310236078, -0.243824499708327438326, -0.0142667172678378131558, -6.16257838451875667523e-6, 0.00007762602707798592666, -5.36948753858956307543e-7, -9.60743433136409655885e-7, 2.19508850797957700092e-8, 1.49278918533279638692e-8, -6.75924666082845154959e-10, -2.51587421467854300407e-10, 1.86512127989029850063e-11, 4.30377162885720974452e-12, -4.81111939322468641825e-13, -7.13002882526103787262e-14, 1.17780712759534274267e-14, 1.08160034503070086431e-15, -2.75156524731197021809e-16, -1.33032887143998239518e-17, 6.13715150789251316192e-18, 6.76933068322489427917e-20, -1.30223413893097881582e-19, 3.18760571013114907547e-21, 2.60652412438611495327e-21, -1.62189164587997786632e-22, -4.83901658567896662895e-23, 5.23022004915030591973e-24, 8.04133735373074353099e-25, -1.40833238431022380913e-25, -1.08983193914542585834e-26, 3.37275994963437413905e-27, 7.74549707296287257904e-29, -7.29158662073215879237e-29, 1.85827289728193951443e-30, 1.4058855428851865004e-30, -1.11692400708661364223e-31, -2.29323347801488552879e-32, 3.67731875346758117151e-33, 2.58551726922104413003e-34, -9.66675878125466042111e-35, 8.66260261411108178609e-37, 2.16081401876360979678e-36, -1.75896039757171857864e-37, -4.03260472234478058932e-38, 7.25246453516814504418e-39, 5.4320554508167380467e-40, -2.23810649436465327872e-40, -4.60109302361954973139e-43, 5.91467958896334271874e-42, -3.16199926737654213748e-43, -1.38470093141921140135e-43, 1.52578311705620205754e-44, 2.85820702794006161639e-45, -5.27677497995209857966e-46, -4.94696045227640550224e-47, 1.56230745493197717383e-47, 5.82749377537524666987e-49, -4.1716288071781892558e-49, 2.60778686511176876944e-51, 1.02373042196292440151e-50, -4.73043854688719145735e-52, -2.31820858129599623138e-52, 2.0485992678592138587e-53, 4.75131908803526077033e-54, -7.01452233289295390067e-55, -1.00972587363605313212e-55, 1.24350925795804495549e-56, -2.25334131281143019638e-57, -2.24510453453998233502e-57, -8.23765813076748599562e-58, -3.50668222300535697404e-58, -1.5462011652720298708e-58, -6.29218317674526740623e-59, -2.42061712458310318608e-59, -8.90302657227524520692e-60, -3.11338134597087582873e-60, -1.0321049871626933621e-60, -3.2411795037734176578e-61, -9.62756159076817581276e-62, -2.69929355873204500686e-62, -7.12798267511748445424e-63, -1.76869546124129359657e-63, -4.11286602003280104536e-64, -8.93540958144509288842e-65, -1.80743649046585615685e-65, -3.39058837140015374829e-66, -5.87173079542828600821e-67, -9.33741300928878706049e-68, -1.35502762521808232684e-68, -1.78122441233353315234e-69, -2.10222254952492188032e-70, -2.20359903800081549177e-71, -2.02432132129202516848e-72, -1.60245351974094213341e-73, -1.06912983244656754607e-74, -5.82970444658763671059e-76, -2.47872860201899258282e-77, -7.54729107387941248614e-79, -1.31690504080761518602e-80},
            {0.740582907873157380554, -0.0685896468259419494268, 0.000652277266736069681496, 0.00106384037656281401956, -0.0000285693267747090667799, -0.0000248193439697303966107, 1.06544118217261545574e-6, 6.08493003685348226934e-7, -3.64929711717156144418e-8, -1.48907793477337566991e-8, 1.17871913736426575088e-9, 3.58060763338408383156e-10, -3.6341241352550406325e-11, -8.38265697693077608524e-12, 1.07612717316432749848e-12, 1.89384768354356708838e-13, -3.07072575495936628311e-14, -4.08246495531534475626e-15, 8.45820347578861172485e-16, 8.25055113792337372229e-17, -2.25038665159041153772e-17, -1.51281959139096039419e-18, 5.78193392664016359668e-19, 2.32615437601453719467e-20, -1.43292282616144890586e-20, -2.1850769549562231559e-22, 3.41759173171592092537e-22, -3.0157072083385660048e-24, -7.81479253052297750121e-24, 2.58355494045604804632e-25, 1.70278941265383424991e-25, -9.99729596989161918603e-27, -3.50028481776304488015e-27, 3.06526995003454605767e-28, 6.67084598206494832374e-29, -8.19244611544011715652e-30, -1.13927106879461165617e-30, 1.95442048713119442617e-31, 1.60570308748102121117e-32, -4.12157933928517670807e-33, -1.34042815668499712241e-34, 7.26451699248769996004e-35, -1.75095279881785437421e-36, -8.47175946428283494168e-37, 1.22566056007856069779e-37, -6.01341059377715495091e-39, -3.69010770011661276717e-39, 8.42037212550747512896e-40, 7.40997468936097885831e-41, -3.70739709682368274069e-41, -6.2196074570613191563e-43, 1.2598382694201635529e-42, -3.1243447397799130495e-44, -3.73980170654644765279e-44, 2.2327335374816495224e-45, 1.00932268567018600309e-45, -9.560344256789460623e-47, -2.51178457151909137274e-47, 3.37694179520326589612e-48, 5.76604823883225284568e-49, -1.06594516188009855674e-49, -1.20602672347746995419e-50, 3.10093896650556788369e-51, 2.18745049287923713598e-52, -8.61819993879964074218e-53, -3.96963641883626019183e-54, 1.76178717500196246049e-54, -2.02053349173792640596e-55, -1.62137818254196296442e-55, -5.02942506992617083109e-56, -2.19096972108160980374e-56, -1.00161648347280279393e-56, -4.11017631865360750379e-57, -1.59187841572015903629e-57, -5.91120073200681260207e-58, -2.08634513194384718568e-58, -6.97355892836221355706e-59, -2.20672485901180058317e-59, -6.60154319621430256184e-60, -1.86284172719875924396e-60, -4.94718058855309272695e-61, -1.23351523879159648225e-61, -2.87956752857187387129e-62, -6.27363321921717173414e-63, -1.27099391592797362442e-63, -2.38444811429686717786e-64, -4.12233126474697676031e-65, -6.53030804883244633574e-66, -9.41517216773194327087e-67, -1.22547643092674274355e-67, -1.42582710336738288719e-68, -1.46480261360801205875e-69, -1.30815832357512661724e-70, -9.94876854146405526843e-72, -6.26052684791750820649e-73, -3.11868030934327092965e-74, -1.13400662313253163644e-75, -2.41341804980818228602e-77, 6.45403442429469895421e-80, 2.01854560555394608681e-80},
            {-0.0843784055072337627096, 0.00743618560816980617967, 0.00300497502684943149823, -0.000290071009240459058105, -0.00011212444672001640899, 0.0000125790535770838344346, 3.56743146796517012134e-6, -4.88603507654560730482e-7, -1.01734654853144101114e-7, 1.72636421559492594398e-8, 2.65102780932119639133e-9, -5.66272449087996556433e-10, -6.32268842296843673631e-11, 1.74879538241271196641e-11, 1.3573718460743828746e-12, -5.13045364308755700769e-13, -2.48746317889946611073e-14, 1.43751859911561112263e-14, 3.20839627105798829472e-16, -3.85768095366173240479e-16, 8.80282842978944067666e-19, 9.92181199445091616411e-18, -2.62857997217285469408e-19, -2.44240927155378333516e-19, 1.25767759914363277848e-20, 5.73296272283714928356e-21, -4.51366425513068883912e-22, -1.27397492181653826027e-22, 1.40613404836716557302e-23, 2.64561813556754700696e-24, -3.97673732446970330372e-25, -5.00826861540117675285e-26, 1.03728202822699986475e-26, 8.17632281431997595682e-28, -2.49873669203639022803e-28, -9.67075650573256664072e-30, 5.49262751249716593568e-30, -9.15095704676163805275e-34, -1.06340859610049905033e-31, 4.83729778232616737669e-33, 1.63070649798243051741e-33, -1.97149340053046164128e-34, -1.06272376131144390235e-35, 5.49039899823707802588e-36, -5.38738706319094349792e-37, -1.14412075338287851578e-37, 3.31444399455171146426e-38, 1.36413610866888073349e-39, -1.26565517305414817377e-39, 2.43788102897401378601e-41, 4.01658589529347724801e-41, -2.49637737349894126967e-42, -1.13573893700917304744e-42, 1.16552379288943791757e-43, 2.92717861739158217045e-44, -4.33020347704197564093e-45, -6.89302881566143273151e-46, 1.4218617353338501602e-46, 1.45998639569697036463e-47, -4.29042764266142565627e-48, -2.64839032058533922632e-49, 1.21009670474147542957e-49, 3.38050197827417462417e-51, -3.26838293770702778464e-51, -2.04023916401732675712e-53, 6.88761048068744705144e-53, -8.93927572983131892092e-54, -5.25081961861977038287e-54, -1.46528580670839569493e-54, -6.74244372096365150669e-55, -3.1592000584263531523e-55, -1.30081013745546170055e-55, -5.07456045687375172919e-56, -1.90163517477126133102e-56, -6.76355391809907464427e-57, -2.27567541854156250319e-57, -7.24425776611208601341e-58, -2.17831633354341909572e-58, -6.17203438366121028971e-59, -1.64393006817639064473e-59, -4.10554300602983277431e-60, -9.58466164048750668424e-61, -2.08440456871844423351e-61, -4.20571191277981039592e-62, -7.83622044557778699909e-63, -1.34077209983632136868e-63, -2.0924721969032068221e-64, -2.9541491933419194301e-65, -3.73379240609472116199e-66, -4.16781997025554013786e-67, -4.03292544045932440181e-68, -3.29094124897896769642e-69, -2.16182087058166718338e-70, -1.0341570870823980153e-71, -2.45227252815013712432e-73, 1.03674960136337766433e-74, 1.44403196063272061816e-75, 7.74896311427519382308e-77, 2.19280056766888558889e-78, -8.31958836594083705757e-82},
            {-0.00376592262874783882455, 0.00378843327161178541821, -0.00028224795460597995021, -0.000241045707602375709383, 0.0000277336263306208497469, 0.00001092018690258792534, -1.65687283898447660027e-6, -3.95571688961731981692e-7, 7.77099474802201734007e-8, 1.21333692641295652266e-8, -3.1312021222625485737e-9, -3.18808061061287545091e-10, 1.13189625635502304046e-10, 6.92005978656410596849e-12, -3.75902526104082915555e-12, -1.03931678419498635649e-13, 1.16266502411011882271e-13, -2.47534307927750268112e-16, -3.3746892571257306692e-15, 1.02908195603834960431e-16, 9.22116493008375803913e-17, -5.47560048158904360599e-18, -2.36996134757452891858e-18, 2.15534501729272780894e-19, 5.69698517630121233917e-20, -7.31144517166281516722e-21, -1.26398939790349481406e-21, 2.24264404411116657769e-22, 2.51470721163334840966e-23, -6.33826899955765363471e-24, -4.17196128015760587404e-25, 1.65949181316908021382e-25, 4.34664553087191525789e-27, -4.00555243181614608903e-27, 4.80114848265738631844e-29, 8.74792871793883635026e-29, -4.78355795560485525178e-30, -1.64482527079318929142e-30, 1.89008322968802217631e-31, 2.25644741848442674485e-32, -5.67650136902511924039e-33, -6.32146951883905843129e-36, 1.40275421884338620302e-34, -1.5016132741820441961e-35, -2.73379687001938074444e-36, 7.51147594687646671061e-37, 2.99050835245699651069e-38, -2.71376747583347041912e-38, 6.64788379755853325941e-40, 8.38075139021638920617e-40, -6.13402732265555752177e-41, -2.31877987137942910597e-41, 2.81140013798117319626e-42, 5.81851874947237017977e-43, -1.03760726306990442965e-43, -1.31224811695923584879e-44, 3.39784681249188008167e-45, 2.55582905317638589602e-46, -1.0236312420427400486e-46, -3.75378591492070196932e-48, 2.88150684871109746127e-48, 1.05130902266605719427e-50, -7.72866159411670056051e-50, 1.5505860780348688498e-51, 1.6741917185380151137e-51, -2.36029920628276412678e-52, -1.10073322995784347018e-52, -2.72625993841617024846e-53, -1.339168324771201812e-53, -6.43239729518975688297e-54, -2.65050627146175599566e-54, -1.03972489839905323634e-54, -3.92580439618260791934e-55, -1.4040581582470035535e-55, -4.74330937464155040075e-56, -1.51456741974397643207e-56, -4.56194819030862275985e-57, -1.2925346718975467769e-57, -3.43567600158304151729e-58, -8.54230567166738173704e-59, -1.97954243360882434117e-59, -4.25715528691086989876e-60, -8.4531257683193214759e-61, -1.53998837405671778255e-61, -2.55342285615810995945e-62, -3.81237146607521534697e-63, -5.04898345270652073345e-64, -5.79511317298682044045e-65, -5.53049450219415929905e-66, -3.98896094591102429492e-67, -1.46151639599829666155e-68, 1.18683773183484773013e-69, 2.94359721467181721843e-70, 3.2855734943700288508e-71, 2.49697987651945360047e-72, 1.35938667382487539151e-73, 5.1491859405942502154e-75, 1.17617657051655727777e-76, 1.78841305114582018657e-79, 1.35597683109854321792e-80},
            {0.00171192730310597128895, -0.000074346475030802548683, -0.000271341292323566348197, 0.0000294340149861973039389, 0.0000196590713080238604987, -3.02919081145806958098e-6, -9.70020069207919775735e-7, 1.99123250842455519426e-7, 3.71705799115673765481e-8, -1.02282564848493410205e-8, -1.14714994344376515408e-9, 4.46036301095242051154e-10, 2.73548139392439164706e-11, -1.7225076053690253228e-11, -3.72930814876410932536e-13, 6.03132273373622356762e-13, -7.68239094954504335406e-15, -1.9402108612759434802e-14, 8.80047890675869616295e-16, 5.76935364242207319713e-16, -4.56277896530777111496e-17, -1.58563461980294539399e-17, 1.85936095066541005013e-18, 3.99689809487201273587e-19, -6.60650231762655204226e-20, -9.04879090094181543688e-21, 2.12443934640163222062e-21, 1.74437971833222245916e-22, -6.2771550276498256647e-23, -2.39130341823739174688e-24, 1.71012649199975446122e-24, -2.84463128786112519721e-27, -4.26636738714162395305e-26, 1.81343316446643486759e-27, 9.52809596454715358905e-28, -8.77781849623231451001e-29, -1.7909201436741549077e-29, 3.06071421391543204535e-30, 2.24853126840154227742e-31, -8.88311012376690079454e-32, 1.54192814564373851421e-33, 2.18877002746693750233e-33, -2.4388480380770304484e-34, -4.3268056167586800713e-35, 1.14042642839612805466e-35, 4.96685517401616247245e-37, -4.07339754925028553603e-37, 9.76398442304381326424e-39, 1.25745424490331717754e-38, -9.68418768514213362229e-40, -3.47666516889685059633e-40, 4.55277288624385826601e-41, 8.6523601640998072376e-42, -1.71247778577456606294e-42, -1.89943453699942860159e-43, 5.69723468528884233243e-44, 3.42333756795729362626e-45, -1.73890072576375491453e-45, -3.6813041672976666779e-47, 4.94480340920488729167e-47, -6.38707409333905953067e-49, -1.33127372212755169572e-48, 5.31059232853995879102e-50, 2.97126057677792022097e-50, -4.41091604647549198089e-51, -1.69709150897495527405e-51, -3.57803446775274583077e-52, -1.91349333089053060023e-52, -9.45758696347924879581e-53, -3.8824142051045429652e-53, -1.52633298740701267905e-53, -5.79123459876781037465e-54, -2.07512229385959651528e-54, -7.00663358495912774108e-55, -2.23196010628481750569e-55, -6.68995404451489060966e-56, -1.87992911325049794893e-56, -4.93565743736225984546e-57, -1.20569913527812850995e-57, -2.72561506489340042758e-58, -5.66177793640389751657e-59, -1.07038920664222740244e-59, -1.8159283945279360976e-60, -2.70127790538990675965e-61, -3.36948008223221647594e-62, -3.14012334525080397462e-63, -1.14420940346397693806e-64, 3.2227423011383844102e-65, 9.63734640921220400439e-66, 1.64369720915443518605e-66, 2.10599200505232847851e-67, 2.1439543063319943692e-68, 1.74733346394309425608e-69, 1.12297538385133627617e-70, 5.49828985958066098938e-72, 1.9254972153109823863e-73, 4.12053342138377536372e-75, 1.16177528065264393035e-77, 3.6304516581588497083e-79, 6.10884936661725532103e-79},
            {0.0000196725023276101129555, -0.000159544628675091843137, 0.0000167612082069115944642, 0.0000217938936340920033894, -3.43070887183262007686e-6, -1.57841180485814023133e-6, 3.33678513658354814904e-7, 7.94467994510538946235e-8, -2.25489264592407460545e-8, -3.01897780423517863393e-9, 1.21318501701328203494e-9, 8.44647049065924181011e-11, -5.54810379516584857048e-11, -1.24707039575547926459e-12, 2.23489225283310514175e-12, -3.78182734458080625197e-14, -8.09012733337713374484e-14, 4.34305903884421100203e-15, 2.65803144181726238673e-15, -2.43792402024531799816e-16, -7.93772005098119758581e-17, 1.07589351846509551103e-17, 2.13542015351769700304e-18, -4.11722331587103892027e-19, -5.03270418597720105819e-20, 1.41700144420086066215e-20, 9.58470806084879954836e-22, -4.45286847595428441498e-22, -1.02082719638782493763e-23, 1.28194651989585470805e-23, -2.37706535563757076813e-25, -3.35559320533006382869e-25, 2.10273296139182410462e-26, 7.78785158282615958589e-27, -9.26284844743671882641e-28, -1.49292604321222690538e-28, 3.21122673133089987338e-29, 1.76460145797153509063e-30, -9.49245779068414257825e-31, 2.50451652501764219117e-32, 2.40681351442437817238e-32, -2.75161704628732101261e-33, -4.93915690338017237102e-34, 1.27097791135319123683e-34, 6.09040933448120099182e-36, -4.59537780297891395937e-36, 1.02060586698918273575e-37, 1.4415542186496835543e-37, -1.13116623523285794405e-38, -4.0402958272361622835e-39, 5.52771086525454958867e-40, 1.0114757460096452788e-40, -2.14053609602412819591e-41, -2.19389750410563144691e-42, 7.29845329704935555967e-43, 3.69943816398585185851e-44, -2.27493487703266432554e-44, -2.40743151870567030856e-46, 6.5833660118827223352e-46, -1.65317728578507634219e-47, -1.79228086894936975847e-47, 9.97300515094463452099e-49, 4.13097150686193943417e-49, -6.34218114762825196385e-50, -2.05516607563767930441e-50, -3.41776069749064572764e-51, -2.07190785318488611219e-51, -1.06124337041107752047e-51, -4.30540452706365057873e-52, -1.68585933587674680626e-52, -6.39504060097235305095e-53, -2.27941024934504775627e-53, -7.62072536206970763104e-54, -2.39390709210381845929e-54, -7.03476837285377145523e-55, -1.92213174730631469738e-55, -4.85104347817478069797e-56, -1.12021597067269517542e-56, -2.33122470126352377753e-57, -4.25711472007283258078e-58, -6.44654757661581119646e-59, -6.79673857670303142577e-60, 7.68009072743449981592e-63, 2.43222040529031042819e-61, 8.03166780831748973101e-62, 1.815550835808986779e-62, 3.29941970468509021708e-63, 5.03551094717198542115e-64, 6.53356114319577579531e-65, 7.19739375926885666244e-66, 6.66522174437215089237e-67, 5.09783926973919108591e-68, 3.1338365105884970498e-69, 1.4854456412669839532e-70, 5.06843923242286333449e-72, 1.0615985954212715497e-73, 4.00188540956831609807e-76, 6.96535588472931309403e-78, 1.20885392661624009312e-77, -4.80153823461820290105e-79},
            {-0.0000393123705932698996507, 5.21512938302686417144e-6, 0.0000146622991555166738651, -2.51137992727169541043e-6, -1.73400107573983764312e-6, 3.86055069990984949316e-7, 1.2107599830364994607e-7, -3.55568887298632898483e-8, -5.89490292175512658613e-9, 2.41534842174523628897e-9, 2.02306371958723467367e-10, -1.33061365007707192483e-10, -3.6668708183525285627e-12, 6.25295131781674462071e-12, -1.08700294962069910517e-13, -2.57876576133070497222e-13, 1.50235357535677795059e-14, 9.47274097012564124135e-15, -9.48534836832372745807e-16, -3.11167944207338045101e-16, 4.62416217748701855811e-17, 9.0596117186150460472e-18, -1.932214766754140893e-18, -2.26246406374207864855e-19, 7.19568546785501412734e-20, 4.36292155719116324834e-21, -2.42805810104151217764e-21, -3.43354031442488409809e-23, 7.45401621945449932715e-23, -2.19566411320700598177e-24, -2.06631369536550017484e-24, 1.58482311505417917595e-25, 5.03725460688873434278e-26, -6.98465547027476689142e-27, -9.99864315635095505315e-28, 2.49346173342334452738e-28, 1.14918618206830858508e-29, -7.65453027537127121548e-30, 2.39809706463633365366e-31, 2.02335236859586383497e-31, -2.35337950343057531683e-32, -4.35178090603662660065e-33, 1.10350451787296981047e-33, 5.78828021283252165041e-35, -4.09475403991395219456e-35, 8.23943618106974098328e-37, 1.3189632779436305381e-36, -1.04161432108547033736e-37, -3.7837832926663045939e-38, 5.32532260327803693911e-39, 9.62804315073174746704e-40, -2.13499466836930334549e-40, -2.08920957508394461762e-41, 7.50045738880724803906e-42, 3.34070617354333246292e-43, -2.40001024548858592573e-43, -7.12709692898945452864e-46, 7.1046019107881872146e-45, -2.4490856121243218669e-46, -1.96676177828224655302e-46, 1.34742992247983856245e-47, 4.69004572468552826749e-48, -7.36526243734101703074e-49, -2.03560512614465495226e-49, -2.28332893843710910431e-50, -1.7314310834020471859e-50, -9.31526613683177502594e-51, -3.67661355431343902543e-51, -1.4152951267672818585e-51, -5.30708218254162810449e-52, -1.85028687519025261054e-52, -5.98198603674007639207e-53, -1.79435401005918078735e-53, -4.93495682368280559186e-54, -1.21995121450988227385e-54, -2.61946962423237891428e-55, -4.49093883052270698954e-56, -4.28805371152690354347e-57, 8.04967221529177201238e-58, 6.14243802288562729803e-58, 2.23341885798621846379e-58, 6.25021845789930795086e-59, 1.47559444640032742309e-59, 3.03132445073296784523e-60, 5.4804293813155682885e-61, 8.74045601708598422075e-62, 1.22591553678292612222e-62, 1.50131309958201925194e-63, 1.58772090533350384821e-64, 1.42795102847075244003e-65, 1.06952461806016680695e-66, 6.47861764574354246928e-68, 3.03995917761451181662e-69, 1.02973122695659895072e-70, 2.14828599957071932986e-72, 9.65766708927200623928e-75, 1.01537604378565072806e-76, 1.97366528463683604288e-76, -9.09965602315947774015e-78, -5.26332441578795994848e-78},
            {6.46489529363071965322e-7, 5.5551795600912011097e-6, -1.17722882894843557935e-6, -1.27699049942348579978e-6, 3.13837815399094093023e-7, 1.32700560074412611892e-7, -4.12072886497344226428e-8, -8.62361863257693341306e-9, 3.63099229116734519059e-9, 3.75192351098207916099e-10, -2.45489799556424972863e-10, -8.81589110076110989656e-12, 1.36498329966205162513e-11, -2.09677871013897229675e-13, -6.48867819423275487146e-13, 3.92588975003688673094e-14, 2.69298929447852783474e-14, -2.85280870826151957641e-15, -9.83173268029039897694e-16, 1.55610595342585479041e-16, 3.13377578736932996014e-17, -7.16602350699510310447e-18, -8.41932171793749527032e-19, 2.9097144371520581732e-19, 1.68691722415310688472e-20, -1.0614243181962105754e-20, -9.71059961152276654756e-23, 3.49716761193023699161e-22, -1.28413673285926112394e-23, -1.03352434635976312009e-23, 8.97102873578565245032e-25, 2.66725990733109428863e-25, -4.09278009237284284254e-26, -5.54671696674641727198e-27, 1.52857681375978057767e-27, 6.40417714305844808973e-29, -4.92144645275762315303e-29, 1.67601684690699509516e-30, 1.36585100115965136326e-30, -1.60679494394165474448e-31, -3.09493980195776953091e-32, 7.76994322034026155964e-33, 4.44378528160581582081e-34, -2.98510594927929648026e-34, 5.33998538155628272382e-36, 9.9427052773247991236e-36, -7.85520542414232483023e-37, -2.93940805313271266985e-37, 4.21964910602927742261e-38, 7.66077023567935032503e-39, -1.75813373910742498277e-39, -1.68001657954146467467e-40, 6.38762210834536136339e-41, 2.58517911888148360593e-42, -2.10611402618727976303e-42, 5.6012022434546225007e-45, 6.40230126037770153928e-44, -2.67913000072583489987e-45, -1.81007695313917822868e-45, 1.43363740482061078131e-46, 4.47252500802551091196e-47, -7.13279245844968483444e-48, -1.69512287070426335731e-48, -7.83577690316124061087e-50, -1.09344457363878473158e-49, -6.37154219122763009742e-50, -2.35802851168003214457e-50, -8.617383854518214549e-51, -3.088130909931920131e-51, -9.95021982812655185042e-52, -2.8270091131411098942e-52, -6.8338491880920712272e-53, -1.2023650313071582455e-53, -2.51933665199352396512e-55, 1.01505877613715725107e-54, 5.98916994861439376391e-55, 2.42730350117860704199e-55, 8.13672458179967905922e-56, 2.38026520739851530227e-56, 6.2079522046432605405e-57, 1.45681097412934277995e-57, 3.08566860523113566409e-58, 5.89639988418858612372e-59, 1.0134700382268508712e-59, 1.55869412414300213003e-60, 2.129176753854827616e-61, 2.55783578379503931756e-62, 2.66805246800944116949e-63, 2.37690800069733680353e-64, 1.76963322537690856753e-65, 1.06867700500795601741e-66, 5.01167388533542617537e-68, 1.69974858879675470313e-69, 3.56080312062168763081e-71, 1.80285271351312404631e-73, 1.12480226566578229553e-75, 2.73432724197779208699e-75, -1.43324003294645279742e-76, -7.4727607226524281746e-77, 4.28871906721640869654e-78},
            {9.30567341925624088076e-7, -3.32931469284870018274e-7, -6.06031299115325199537e-7, 1.77818100112842303486e-7, 1.0404039064536986616e-7, -3.54068082004986459168e-8, -9.48590823413496698519e-9, 4.18677319256841246817e-9, 5.39593944518685029593e-10, -3.5505544092993136254e-10, -1.67712932428358946432e-11, 2.37256557638986115333e-11, -2.7243973680211380741e-13, -1.31586614092664921607e-12, 8.05848555131047052577e-14, 6.23362817540531301933e-14, -6.86520899734718395491e-15, -2.553377631606845586e-15, 4.23335504249126778927e-16, 8.99877796176212149452e-17, -2.16492657291291833355e-17, -2.63427883587061274628e-18, 9.64474303976389028253e-19, 5.61528087919295798715e-20, -3.82455978871213537504e-20, -2.54523910867074799583e-22, 1.35944287260091687463e-21, -5.65111503452309855722e-23, -4.30583899085670655323e-23, 4.05796920989291511534e-24, 1.18359485251428233815e-24, -1.94960505913332380691e-25, -2.60251245310877103943e-26, 7.68748095164888784088e-27, 3.10786324483611979772e-28, -2.61182322671099212164e-28, 9.24496824692906433076e-30, 7.64570389090424533873e-30, -9.05916647663147881319e-31, -1.83160694326392997841e-31, 4.5641141715152869142e-32, 2.83927530138638226107e-33, -1.82658756083559207286e-33, 2.83752841949572243848e-35, 6.32292034119913280691e-35, -4.97966695159513063472e-36, -1.93603272811046752661e-36, 2.82010732000468412335e-37, 5.19833076339141408677e-38, -1.22466821572244552789e-38, -1.16171159582589264302e-39, 4.61455495529959418354e-40, 1.74639936718093274394e-41, -1.57233750513545860837e-41, 1.08157865882618317609e-43, 4.92320147459480244375e-43, -2.35127371510494747319e-44, -1.42655824913364949254e-44, 1.25827282898440619823e-45, 3.65695090737426224359e-46, -5.89316460288176794951e-47, -1.21061429888336153965e-47, 4.15475690941450948481e-49, -4.5874315689958956771e-49, -3.20078633854949638998e-49, -9.79556666890088713931e-50, -2.88108589369749568844e-50, -7.86269325881704708032e-51, -1.13474419082616208659e-51, 3.89868774532669896943e-52, 4.35600953063083395276e-52, 2.50550599155207677069e-52, 1.14366919951041907073e-52, 4.51489940089528351622e-53, 1.59240465984008762288e-53, 5.09483147661462613511e-54, 1.48923388848674775347e-54, 3.98857825171176748565e-55, 9.7932340310598904267e-56, 2.20179729129246811694e-56, 4.52101972012962811835e-57, 8.44504201604460772532e-58, 1.42760310654335143786e-58, 2.16946530630052289618e-59, 2.93883307045782036269e-60, 3.51139239192128958334e-61, 3.65176124670142113948e-62, 3.25034216846102531358e-63, 2.42223707236911879329e-64, 1.4667185279630222083e-65, 6.90803706062650533328e-67, 2.35629912984656074249e-68, 4.97655169308136405481e-70, 2.7431389876901117821e-72, 8.74521670071426170911e-75, 3.28127404622751729153e-74, -1.92686523647850996184e-75, -9.19965279903493942281e-76, 5.83815624799950941566e-77, 2.51321363459522615263e-77},
            {-4.36059958873303864285e-8, -1.68568408159675487068e-7, 6.75421488806326484567e-8, 5.70646959839307075149e-8, -2.24104213874112791722e-8, -7.81473953122106176425e-9, 3.72077571014725673995e-9, 6.0222903970777068276e-10, -4.06565444925046048682e-10, -2.50645913840565914594e-11, 3.32460287143785662848e-11, -2.01598842885843456157e-13, -2.18016264076164446057e-12, 1.32968786396791227422e-13, 1.19147146616948479546e-13, -1.35124801517463264787e-14, -5.52637866396842572263e-15, 9.50921098021415141171e-16, 2.17294968655437047913e-16, -5.43834953876550091172e-17, -7.0061382770097874581e-18, 2.67352203197351668965e-18, 1.62061469552928411805e-19, -1.15823291130690336087e-19, -6.88344700766099776548e-22, 4.46191286785108092393e-21, -1.99601266601759546298e-22, -1.52151878478349930507e-22, 1.51890880462911547941e-23, 4.47726999822981220363e-24, -7.76669487219803532967e-25, -1.04856409118920904078e-25, 3.25336265627897195769e-26, 1.32619085836442983068e-27, -1.17156641806660441933e-27, 4.19275193683902832518e-29, 3.62997149399055850216e-29, -4.31870490760526238581e-30, -9.21800021419101045603e-31, 2.28345586159455898315e-31, 1.54277575150848790505e-32, -9.5632608965068359113e-33, 1.24811529468584899234e-34, 3.4537847806830938032e-34, -2.70477716744152872892e-35, -1.09955731002305409191e-35, 1.61964821469534929323e-36, 3.0556429189459650738e-37, -7.34813604817621877273e-38, -7.00609314629757932795e-39, 2.87810971972186574599e-39, 1.04419144070225772477e-40, -1.01581504959153269718e-40, 1.02080236936500705132e-42, 3.28429673111819362688e-42, -1.72616003623710399252e-43, -9.78217925783746778796e-44, 9.37674863393948703238e-45, 2.60440383550463729072e-45, -4.2256275193455610278e-46, -7.52656060942729196989e-47, 1.00156661040681724977e-47, -2.67424775951550948082e-49, -8.59068853161282633801e-49, -4.19365817294492319645e-51, 1.09505900995797845862e-49, 7.95987757276593600762e-50, 4.82252402740371345626e-50, 2.51565983836910528825e-50, 1.15752696979912827096e-50, 4.83652426952442159928e-51, 1.85844431861372503521e-51, 6.59554108095503522186e-52, 2.16699913844575734485e-52, 6.59854990028695602948e-53, 1.86154935359549045346e-53, 4.85879728826572869836e-54, 1.17074925758705582154e-54, 2.59652624429595562279e-55, 5.28019863995330678394e-56, 9.79856270291758934454e-57, 1.6496562267751589194e-57, 2.5017614013732097871e-58, 3.38777413831009583902e-59, 4.05230950725382287477e-60, 4.22450430860728117091e-61, 3.77375060493421035604e-62, 2.82572857983155324584e-63, 1.72120018158162510588e-64, 8.16433610064396529611e-66, 2.80775031333451360754e-67, 5.99063832937746491851e-69, 3.5160300422625139596e-71, 2.75398797179307252084e-74, 3.46485664492949451013e-73, -2.25415722157630583367e-74, -9.97516049958656396116e-75, 6.92853810331231207349e-76, 2.78181255822889803792e-76, -2.05172244565215433953e-77},
            {-2.12930457297274287229e-8, 1.57144282775488799963e-8, 2.08408247670104282218e-8, -1.02055802381124499965e-8, -4.75392592091641908992e-9, 2.53637795670818205232e-9, 5.1997133522452903676e-10, -3.69643701585413695447e-10, -2.94459514275469659867e-11, 3.78056644982019549065e-11, 2.94706791583605490745e-14, -2.97644828780537110089e-12, 1.78901545857097437891e-13, 1.89841755475687024035e-13, -2.20733866267522396694e-14, -1.00660061977690993455e-14, 1.78953185248562007191e-15, 4.4540105659068265024e-16, -1.15250562094146249119e-16, -1.59664685533826374804e-17, 6.28749791613770539811e-18, 4.07119590705576611257e-19, -2.99024499415882844613e-19, -1.96952244180251142755e-21, 1.25388388701301729283e-20, -5.85241424334020550411e-22, -4.62237140342208149617e-22, 4.81145035932195110641e-23, 1.46248294873733470454e-23, -2.63841912495399761045e-24, -3.66971977961056482391e-25, 1.1796876194036633385e-25, 5.00421872765562851324e-27, -4.5187537395064483671e-27, 1.60319494216791027767e-28, 1.48612033940924113812e-28, -1.77132426998198538632e-29, -4.00931411286727873589e-30, 9.8842170059845428655e-31, 7.24528343635960795099e-32, -4.34782009388990880287e-32, 4.53261815845800650128e-34, 1.6433588204234601136e-33, -1.2772966987961597858e-34, -5.45696040060518983222e-35, 8.10931064304390728076e-36, 1.57538095523580643139e-36, -3.85152517102358106204e-37, -3.72673832503478676124e-38, 1.57118722023594804334e-38, 5.58300155374441165937e-40, -5.75555084971781850181e-40, 7.14319307408354307828e-42, 1.92553445726689172712e-41, -1.08766931015286332467e-42, -5.90981149870484370155e-43, 6.05266137394652690277e-44, 1.63571179938593507209e-44, -2.66491766344879433791e-45, -4.12075648183614523898e-46, 1.0498469569890630014e-46, 1.67887804128383445307e-47, 3.58907172852706363299e-48, 4.51049631177630446886e-48, 2.81507819365774711095e-48, 1.44525594861005467851e-48, 7.07189635659954779725e-49, 3.23250148630280022257e-49, 1.36923137021071970891e-49, 5.40817858751072784113e-50, 1.99655879876941289661e-50, 6.8844023441137981742e-51, 2.21528978589562809173e-51, 6.64514280246324991089e-52, 1.85488687566923007117e-52, 4.80652944899155867675e-53, 1.1528863347179323423e-53, 2.55072084125632140482e-54, 5.18350599780010262851e-55, 9.62641254528471975612e-56, 1.6238675912413311486e-56, 2.47007146209730254657e-57, 3.35800937783290341781e-58, 4.03584888891926578136e-59, 4.23070014007887091397e-60, 3.80316467241437623099e-61, 2.86797954258668851667e-62, 1.76080993779546075718e-63, 8.42612660085495956981e-65, 2.92600640901050791765e-66, 6.31311211723015612225e-68, 3.88447485515635670244e-70, -4.87156736321748904581e-73, 3.25968454073321592087e-72, -2.32853625987597689387e-73, -9.64419354044602902226e-74, 7.27133021579963727303e-75, 2.74606297619765405389e-75, -2.19175381732985217195e-76, -7.75481671466218747387e-77},
            {1.71663607851655900942e-9, 4.56900519287929175582e-9, -3.18143425968666474163e-9, -2.07458468010519483896e-9, 1.30592226799457703312e-9, 3.44101020472342469375e-10, -2.65886725372528636439e-10, -2.71951194340302247464e-11, 3.49500162945816234018e-11, 3.17719940209323478275e-13, -3.36379071115631846507e-12, 1.97947923705544094964e-13, 2.5369168354045550494e-13, -3.02205635543197837502e-14, -1.55351713489296322808e-14, 2.85023874006017221436e-15, 7.80308405257721697749e-16, -2.082069486109440343e-16, -3.13665256748688915983e-17, 1.26783664044440865581e-17, 8.92506543132485525946e-19, -6.65160822654288351697e-19, -5.53475311368698860308e-21, 3.04901342970346561332e-20, -1.45420851559156109472e-21, -1.21991772150525605476e-21, 1.31023930159761765438e-22, 4.16648764180831564469e-23, -7.75200690553134318396e-24, -1.12566286150163911869e-24, 3.71455227125791821226e-25, 1.6760647606271963332e-26, -1.51815833516408548664e-26, 5.25650843381983499144e-28, 5.31307891216759454163e-28, -6.33365644673552532126e-29, -1.52583071514373450317e-29, 3.74718108622035332078e-30, 2.9776049837785054881e-31, -1.73654895725608854134e-31, 1.32731341342859278744e-33, 6.88768982574243737611e-33, -5.30479461911386778621e-34, -2.39189652963824636656e-34, 3.58008284319040158996e-35, 7.19574170826155760728e-36, -1.78334602608838451284e-36, -1.76446545438597048038e-37, 7.59004848936024899411e-38, 2.69008715288447120119e-39, -2.89073408433649922958e-39, 4.0851675889962914074e-41, 1.00253911319244292707e-40, -5.98734292602525819212e-42, -3.17750816752114827479e-42, 3.43449478229397656533e-43, 9.15084459034513792388e-44, -1.49405808505909405509e-44, -2.0047617480353213104e-45, 8.13442631978747597117e-46, 1.96476303041716246109e-46, 7.13758607075724029707e-47, 5.20268337990221906844e-47, 2.87211216349664956552e-47, 1.40242684362448380587e-47, 6.56864463166744674595e-48, 2.90457660341649801301e-48, 1.20257664854280306923e-48, 4.67398027095255312065e-49, 1.70592342527485186547e-49, 5.83706692041153665891e-50, 1.86929955118433414486e-50, 5.59330405392124028449e-51, 1.56025664204435302112e-51, 4.04648395605321543134e-52, 9.72610512358390135983e-53, 2.15859006597729138639e-53, 4.40417467519515947991e-54, 8.21796082543365655773e-55, 1.39377268511744930752e-55, 2.13277223632164569889e-56, 2.91837890154870691368e-57, 3.53215535624195187403e-58, 3.73061651489762124944e-59, 3.3806658671564269457e-60, 2.57137259789914434216e-61, 1.59333277802872123817e-62, 7.70074015244812084476e-64, 2.70265128880756594189e-65, 5.89942093761488886912e-67, 3.76235201565787641837e-69, -1.15623167198851407466e-71, 2.75983988094291950268e-71, -2.1486580836895219218e-72, -8.39679922208233606854e-73, 6.82488082604312293061e-74, 2.44164066788489198504e-74, -2.09526137202367951101e-75, -7.03872652477855777361e-76, 6.23122511377508017425e-77},
            {4.62017443125115721373e-10, -6.134946166314462382e-10, -6.15046180915214937128e-10, 4.92838238660296025795e-10, 1.71366358003713374728e-10, -1.49710134972822727993e-10, -1.96637480963730818103e-11, 2.61948437533497380388e-11, 4.99840154144554974799e-13, -3.15048360606256046679e-12, 1.80907497121015929364e-13, 2.85260457132897526465e-13, -3.48936674753753555416e-14, -2.04045400371911895542e-14, 3.86895573674178711608e-15, 1.1740859190189983183e-15, -3.23047896197725790596e-16, -5.33589100201297259529e-17, 2.20918179438065752978e-17, 1.71087214529253494588e-18, -1.28510203614592083899e-18, -1.4110553759598012453e-20, 6.46769355796607246461e-20, -3.10489837807404303961e-21, -2.81957097232499909696e-21, 3.10269127516718195823e-22, 1.04343424285602911162e-22, -1.99103092766365304369e-23, -3.04815304303368595364e-24, 1.02614536245507797113e-24, 4.99814362962449536224e-26, -4.48761232229854292214e-26, 1.49543499224785258945e-27, 1.67517304155751026166e-27, -1.99478789025445292661e-28, -5.13064512868956859494e-29, 1.2562826400470122405e-29, 1.08143770704472922566e-30, -6.15037805661442454541e-31, 2.88727996967211049146e-33, 2.56586958062795359437e-32, -1.95554617506141295616e-33, -9.34036040320937634524e-34, 1.4064826242314286175e-34, 2.93596512045567998632e-35, -7.36065308499181552722e-36, -7.49178712227395577769e-37, 3.27357853949148385963e-37, 1.17500351787120031413e-38, -1.29828469686774202574e-38, 1.99062071778188059436e-40, 4.67518691427696066412e-40, -2.91712077036897409695e-41, -1.53310763439199714327e-41, 1.73277938787981626435e-42, 4.59773541658849882069e-43, -7.51165628611270004311e-44, -8.72831322385733310151e-45, 5.1903618486390709271e-45, 1.50463068427873101674e-45, 6.249012997892550767e-46, 4.05205851427042702176e-46, 2.16132702716043634214e-46, 1.04300765521512618369e-46, 4.82897489016009425328e-47, 2.11692064249858637666e-47, 8.7219518433549441486e-48, 3.38204074935433692865e-48, 1.23383538699694515154e-48, 4.22653937488425618141e-49, 1.35684861031102177024e-49, 4.07423807676354020359e-50, 1.14151926285523546318e-50, 2.97575793492630758793e-51, 7.19390856576038628247e-52, 1.60670234841193332966e-52, 3.30043120912637516313e-53, 6.20280898580000036904e-54, 1.05996931613197698862e-54, 1.63481633199773962064e-55, 2.25542901266145047452e-56, 2.75315296175328917341e-57, 2.93373387517196040705e-58, 2.68319019192862410601e-59, 2.06064937743977695131e-60, 1.28987152911393621998e-61, 6.30105156821395435629e-63, 2.23632901294648784102e-64, 4.93938479065664022956e-66, 3.23693348041561637194e-68, -1.54055045438610478752e-70, 2.12043012254980807778e-70, -1.78772313584651623029e-71, -6.63748646360165895763e-72, 5.78185284100834939084e-73, 1.97143555252956096335e-73, -1.80884724748288000304e-74, -5.80273453791293821436e-75, 5.48996247106763733151e-76, 1.6999035275286051323e-76},
            {-5.5953724144584738358e-11, -1.11132581426334969046e-10, 1.29061892714416236554e-10, 6.21795968211305287835e-11, -6.46970630817604099069e-11, -1.10147597682556901818e-11, 1.57954827960507425367e-11, 4.92676627316384925986e-13, -2.44006026808294882499e-12, 1.36698818149042862717e-13, 2.70091900374577238998e-13, -3.40943189209377765735e-14, -2.28613977320039064994e-14, 4.49586048836507546617e-15, 1.52202556173691164431e-15, -4.327257456129956852e-16, -7.88566600576327960803e-17, 3.3454694202206886624e-17, 2.87258000268946286793e-18, -2.16951106510058663642e-18, -3.13754149137062655933e-20, 1.20431418449279144954e-19, -5.75192759869388801701e-21, -5.74341842034996706454e-21, 6.44460819970753270878e-22, 2.31147745389095264413e-22, -4.5072131284067613865e-23, -7.32889024303299423113e-24, 2.50704694637278923205e-24, 1.33086707729951379637e-25, -1.17639755276120556703e-25, 3.72243612215554087926e-27, 4.6946463992459676404e-27, -5.57937685147473311808e-28, -1.5362213574476025341e-28, 3.75393119607144996103e-29, 3.49856784791263743793e-30, -1.94630894319400526508e-30, 3.0500683430187710098e-33, 8.55902951742132547938e-32, -6.44703304218125909177e-33, -3.27284377320792189493e-33, 4.95424702108034285772e-34, 1.0774149944853445366e-34, -2.72841153765685590017e-35, -2.87053838119196446183e-36, 1.26985625117921064953e-36, 4.67398215463779512609e-38, -5.25186033214666219402e-38, 8.45680389257159553873e-40, 1.96663551590173932485e-39, -1.27064513178977484456e-40, -6.68388031932994844584e-41, 7.84368212327028956633e-42, 2.08898418905330286295e-42, -3.4114561863400259054e-43, -3.41955891340162664008e-44, 2.8502132453874968223e-44, 9.22322575490892543174e-45, 4.10324676531555957925e-45, 2.54634884279871728992e-45, 1.34504212702516397555e-45, 6.49674290929405071383e-46, 3.00857378359982612571e-46, 1.32053230322465737379e-46, 5.4569198340245023288e-47, 2.12475647000085358305e-47, 7.79032326667440220675e-48, 2.68397240161180274832e-48, 8.67157888984952781736e-49, 2.62190198459080404297e-49, 7.40030026227045878994e-50, 1.94412675664156644055e-50, 4.73798725583609162625e-51, 1.06705785531984685806e-51, 2.21082044517906883387e-52, 4.19176753250638635859e-53, 7.22796770290577155567e-54, 1.12509762521103933196e-54, 1.56687174606321520957e-55, 1.93111299752170705752e-56, 2.07812265270000808481e-57, 1.91995133704391849654e-58, 1.48993636703012134833e-59, 9.42755148304892996699e-61, 4.65736601494338665647e-62, 1.67222401297203858519e-63, 3.73719417649894311079e-65, 2.49979898995865806876e-67, -1.59078095827776951228e-69, 1.48879648381735660909e-69, -1.35157334289073050734e-70, -4.79618764152605963594e-71, 4.45480111434652562538e-72, 1.45537438276835120652e-72, -1.42087153113820486188e-73, -4.37472894999625156924e-74, 4.40196890043609088932e-75, 1.3082104100679895348e-75, -1.32510057359859256868e-76},
            {-9.34892773976294429099e-12, 2.10842552033801958151e-11, 1.55215438731662714934e-11, -2.07547907015785327057e-11, -4.68669559586162578018e-12, 7.55868333980998562565e-12, 3.49396226261767064722e-13, -1.55386107110405183573e-12, 8.52333773793826606366e-14, 2.14957425827890766631e-13, -2.82169057029400086017e-14, -2.18589434657595320084e-14, 4.48286573812839482058e-15, 1.70272149054193141338e-15, -5.02083723601332050002e-16, -1.014561759807708161e-16, 4.42055588854194927055e-17, 4.23023843769925376638e-18, -3.21467864408575992536e-18, -6.01468710396995213162e-20, 1.97789132559882221408e-19, -9.30980350961133557184e-21, -1.03619591416724612241e-20, 1.18196165388488561556e-21, 4.55204189981935578413e-22, -9.0510602529544567231e-23, -1.57203811952459693611e-23, 5.45171625086130546655e-24, 3.17299201369610144031e-25, -2.75225906951613667959e-25, 8.15368585527715651899e-27, 1.17686809062985547992e-26, -1.39507259574827788459e-27, -4.12195774035694378418e-28, 1.00618304501708926885e-28, 1.0146979834182614437e-29, -5.53771888451910620015e-30, -9.69038357664771255357e-33, 2.57218803729593750275e-31, -1.91269136009349083542e-32, -1.0351913135121877944e-32, 1.57448674871237802467e-33, 3.57655301661148527671e-34, -9.1392786486920978863e-35, -9.9779250517236888029e-36, 4.45767254159522133081e-36, 1.69949335915127928257e-37, -1.92518001631507696215e-37, 3.17822902864005735956e-39, 7.50698647720336298767e-39, -4.98793831016459493866e-40, -2.64838793490533839706e-40, 3.20918966359865136242e-41, 8.63278382411900252339e-42, -1.40809586366737751949e-42, -1.21052209540252716696e-43, 1.37937800053709218713e-43, 4.82310219020752732228e-44, 2.24695909973189028751e-44, 1.36983442813154666302e-44, 7.24106200851336085457e-45, 3.52122559303846510887e-45, 1.64038376166801096655e-45, 7.24552057672011249923e-46, 3.01568749963590840209e-46, 1.18334581571888368329e-46, 4.37415720634740387027e-47, 1.51988408460943770101e-47, 4.95404186576492308497e-48, 1.51153240804077724707e-48, 4.3060790402397642383e-49, 1.14200372464461963131e-49, 2.81005042782221215963e-50, 6.39061946048871666567e-51, 1.33719268096618205422e-51, 2.56076507906262646759e-52, 4.4603114333005505515e-53, 7.01391557397962868198e-54, 9.86901745321617119409e-55, 1.229064628290916646e-55, 1.33669579933864626754e-56, 1.24832928767272321439e-57, 9.79461318960615490531e-59, 6.26795109785273881817e-60, 3.13267108208648584502e-61, 1.13818236795129110874e-62, 2.57358102342243187517e-64, 1.74781555895423855923e-66, -1.38382112164188832747e-68, 9.60971224954926943365e-69, -9.34561013669970291296e-70, -3.18641152241968566591e-70, 3.14163689881269762459e-71, 9.88029751920371283022e-72, -1.02200995982910517714e-72, -3.03363732414460047458e-73, 3.23268993068126424977e-74, 9.26217733020385505433e-75, -9.94537805293816669967e-76, -2.82533458531222021946e-76},
            {1.63844789514887506389e-12, 2.38357032268015564207e-12, -4.66656164885912513852e-12, -1.46434092355739276436e-12, 2.8077321160726439598e-12, 1.84403304679547580593e-13, -8.05538709243521209138e-13, 4.36382342775202561221e-14, 1.43169032992263699242e-13, -1.97508811286269970209e-14, -1.78101973229227186882e-14, 3.83710594930711379297e-15, 1.64417807266755520953e-15, -5.05467365041526998959e-16, -1.13757482833522111191e-16, 5.10978157757645499063e-17, 5.46890501447166693139e-18, -4.1940553245804674926e-18, -9.94135026302154932238e-20, 2.87530307754295397203e-19, -1.32303788543501496948e-20, -1.66210287887822982551e-20, 1.92387315702967120921e-21, 8.0007139876331375973e-22, -1.62050606555885003155e-22, -3.01979931359224987391e-23, 1.06054533341513128902e-23, 6.79133560921253370022e-25, -5.77624529369216222315e-25, 1.5769722967683775803e-26, 2.65262280651630830438e-26, -3.13527031558694847278e-27, -9.9627302680627645586e-28, 2.4319143024725007632e-28, 2.65250319946333344264e-29, -1.42401177426483939421e-29, -7.50192769362757400726e-32, 6.99989829860936512832e-31, -5.13303598679473983171e-32, -2.9705013634979137865e-32, 4.53833801484126251302e-33, 1.07920564315735138278e-33, -2.78093691116590187931e-34, -3.16059464115651959735e-35, 1.42342984481654661142e-35, 5.66596841765599276159e-37, -6.42797761525469567737e-37, 1.06725157935200829609e-38, 2.61350455536129293542e-38, -1.77614935712903575781e-39, -9.58479844894789466142e-40, 1.19405392566985186695e-40, 3.26089697059134723974e-41, -5.30969600599080939378e-42, -3.88290666492105489855e-43, 5.97199714603107842074e-43, 2.21735964050449884803e-43, 1.07053859978826655162e-43, 6.49187686198112814187e-44, 3.45311219843116432872e-44, 1.69608820770494878309e-44, 7.97470131514868460348e-45, 3.55530140526113985878e-45, 1.49427560222717066875e-45, 5.92252155176193403772e-46, 2.21161504570360149884e-46, 7.76446700728081844542e-47, 2.55742575651253185889e-47, 7.88579858184910358008e-48, 2.27053668749592676098e-48, 6.08638677394962801544e-49, 1.51381706425436505565e-49, 3.48006241919114017755e-50, 7.36102070803493613867e-51, 1.42504399594305104811e-51, 2.50930581361150449051e-52, 3.9893035876454755454e-53, 5.67521670755731278483e-54, 7.14640565383169033251e-55, 7.8594830424824784997e-56, 7.42331184117094236869e-57, 5.89168455256419262978e-58, 3.81466889017810585165e-59, 1.92941854322252534215e-60, 7.09486409881145268642e-62, 1.62289600581083397092e-63, 1.11432268209080600675e-65, -1.0518727422375609153e-67, 5.73172028031577413255e-68, -5.94306315528966215467e-69, -1.95602637722048501923e-69, 2.03901120374670091138e-70, 6.19903049582199103744e-71, -6.76797713526493153023e-72, -1.94459024445795807995e-72, 2.18613696436735451584e-73, 6.06305139099539728533e-74, -6.87401690145360151646e-75, -1.88776306355308293706e-75, 2.10630696916761700628e-76},
            {1.7121586234219900952e-13, -6.59167338666495298689e-13, -3.16683475544241891788e-13, 7.81512165073863962342e-13, 7.23178846755881990758e-14, -3.34719148681294672185e-13, 1.82008209423053287952e-14, 7.92039495056288696828e-14, -1.16456821231845920129e-14, -1.23227158822925645467e-14, 2.81525088430621595662e-15, 1.36863573156779787794e-15, -4.41613726639605265799e-16, -1.11155736373195857239e-16, 5.1735250817659333297e-17, 6.2093633140022144301e-18, -4.82755367983787787744e-18, -1.42179992401417231476e-19, 3.70921026778644720192e-19, -1.6564271716502584981e-20, -2.37720939640921660786e-20, 2.7900465515206184531e-21, 1.2589110107471506283e-21, -2.59708071969157152363e-22, -5.21106773486456683068e-23, 1.85316035067862218445e-23, 1.30812996069039791804e-24, -1.0920017903114331833e-24, 2.69589450725366732971e-26, 5.39857331095838002053e-26, -6.36126909502849303085e-27, -2.17841421552331428772e-27, 5.32351640063498240682e-28, 6.27730289926100033343e-29, -3.32386711113879804337e-29, -2.99157482191753834395e-31, 1.73244989501727768704e-30, -1.25151619367722818088e-31, -7.76599253441560026786e-32, 1.19172713179794731622e-32, 2.97232468127700278853e-33, -7.72096470467627841297e-34, -9.15848317517381485553e-35, 4.15293157084209605352e-35, 1.73658920655963147007e-36, -1.96347474301039654214e-36, 3.22525839732127206099e-38, 8.33449044734533414797e-38, -5.76834501154786594543e-39, -3.18184951944375273088e-39, 4.06103371588572345157e-40, 1.13067884829667538201e-40, -1.83733812121035858384e-41, -1.13014403489962176485e-42, 2.33727851573244252859e-42, 9.1200499704169464425e-43, 4.53778387171888873211e-43, 2.75643116569644927341e-43, 1.48025512272612625591e-43, 7.35895234708494207181e-44, 3.49957841513297339082e-44, 1.57787604905547549158e-44, 6.70840795552411041203e-45, 2.68983410198751912069e-45, 1.01617531041514297815e-45, 3.60929802194578878923e-46, 1.20274631433123252916e-46, 3.75212477647576507217e-47, 1.09299229478785528404e-47, 2.96414312187814808118e-48, 7.4585800405260918694e-49, 1.73461783558073455147e-49, 3.71175959610587565756e-50, 7.26921462804450593086e-51, 1.29486705748349716099e-51, 2.08247676324118237082e-52, 2.99697073892122586818e-53, 3.81785162791806662428e-54, 4.24797852410228029699e-55, 4.05958948582324400719e-56, 3.2604272913633108566e-57, 2.13654181751088496559e-58, 1.09387436902611587091e-59, 4.07157597953666255265e-61, 9.42048062752006741314e-63, 6.51755000897658366376e-65, -7.13074231577220833614e-67, 3.17325104737136858344e-67, -3.49239499432435969971e-68, -1.11424630097957826379e-68, 1.22366902996040236331e-69, 3.60997139879071931426e-70, -4.14573118351324879012e-71, -1.15721734741908589994e-71, 1.36780251954393663571e-72, 3.6854046972716392192e-73, -4.39607899015768531615e-74, -1.17146904545238290338e-74, 1.37784690688225538325e-75, 3.7338842780633901343e-76},
            {-4.44936104018315620287e-14, -4.22700635632890972498e-14, 1.53636766217722979064e-13, 2.05351610343891596773e-14, -1.08880465448401595797e-13, 6.11376149572090254695e-15, 3.59832821752665783893e-14, -5.7439743932399393231e-15, -7.19817548604467319263e-15, 1.76435373046694158091e-15, 9.793365350304610288e-16, -3.34389655971733476804e-16, -9.45452973814915421215e-17, 4.58835294538948730743e-17, 6.1899391936948147656e-18, -4.90730381035596950682e-18, -1.76635498157552981482e-19, 4.25301224405890901955e-19, -1.83079069364765672007e-20, -3.03780979685786947518e-20, 3.61556420321063102929e-21, 1.77753564409615250329e-21, -3.73711410016330925601e-22, -8.09789622077142036711e-23, 2.91796867035096665109e-23, 2.27248186345014346837e-24, -1.86584004812036355215e-24, 4.06666589976788770125e-26, 9.95490157042366851027e-26, -1.1694556366647479355e-26, -4.32443112787433645953e-27, 1.05926991967995433283e-27, 1.34988244454377668614e-28, -7.06806419373757150432e-29, -9.16023173473981469997e-31, 3.91369991458341005927e-30, -2.7824110727907756258e-31, -1.85647525742110498562e-31, 2.86164245350733656153e-32, 7.49851614500514270277e-33, -1.96333504171387665715e-33, -2.43583527263134285423e-34, 1.11123210546330955163e-34, 4.90449169667218384063e-36, -5.50755231952091320483e-36, 8.81737698762283297587e-38, 2.44373735125057439227e-37, -1.71638097143614158321e-38, -9.724499149372068215e-39, 1.26802828321936648345e-39, 3.61206320049817903028e-40, -5.85686508392722494423e-41, -2.98387387501473664296e-42, 8.33328371240708808387e-42, 3.39464943840103439943e-42, 1.73504784765615358281e-42, 1.06037232630184069294e-42, 5.76181085080539662233e-43, 2.90338281900446646582e-43, 1.39857009993785920055e-43, 6.38629219847629833182e-44, 2.75002587054684402675e-44, 1.11679959865349691437e-44, 4.27290954669617808736e-45, 1.53695121295767122182e-45, 5.18644742842469455308e-46, 1.63834202196563426153e-46, 4.83222426925942481245e-47, 1.32679288022639623778e-47, 3.37991275376861065337e-48, 7.957387581683248428e-49, 1.72360418281484196454e-49, 3.41674377776410171091e-50, 6.16023225869691986438e-51, 1.00272923477733059933e-51, 1.46052484949498588833e-52, 1.88307887117863074706e-53, 2.12063300336818771922e-54, 2.05126593840717474223e-55, 1.66765750326325735939e-56, 1.10632335453819882909e-57, 5.73473013216160504793e-59, 2.16087833978686386011e-60, 5.056533848335406127e-62, 3.51542983552634489838e-64, -4.36841248362600452082e-66, 1.63708880447234601998e-66, -1.90438939213613990877e-67, -5.91224724999375533074e-68, 6.81821220423556473476e-69, 1.95858496618148873303e-69, -2.3586112549317297983e-70, -6.41740274040121346392e-71, 7.95020826996596517726e-72, 2.08801050026459996535e-72, -2.61199794241874506862e-73, -6.77735565182733207343e-74, 8.3737614202927314612e-75, 2.204615855534199505e-75, -2.62489087427428063885e-76},
            {-2.63544746664799083738e-15, 1.90842423711805684854e-14, 3.98932515946076237194e-15, -2.67312263145062322199e-14, 1.62749590734851860102e-15, 1.32025382513763611724e-14, -2.34463515907772364174e-15, -3.51938421004483579815e-15, 9.39091326239040167879e-16, 5.99628676545953957872e-16, -2.18809406920230126674e-16, -6.98367394573847467714e-17, 3.56055072906575513427e-17, 5.41205733905173406326e-18, -4.40535247463791683664e-18, -1.91202924952379240176e-19, 4.33773984845566255096e-19, -1.78800291863143748026e-20, -3.47299256184205059303e-20, 4.1953912500902289963e-21, 2.25591630262121003923e-21, -4.83952619632545056173e-22, -1.13534596940240623859e-22, 4.1506678416089659801e-23, 3.56709685211678561023e-24, -2.88906557363456699267e-24, 5.38158011520307539752e-26, 1.66789146063494094977e-25, -1.95384544548416154251e-26, -7.81651722384141256121e-27, 1.92169212476584158927e-27, 2.64586331969626150747e-28, -1.37343684770919356674e-28, -2.35719026270781090367e-30, 8.09480458078456837854e-30, -5.65807809067858330495e-31, -4.07043297295759186611e-31, 6.30387761892806159247e-32, 1.73803010853167439843e-32, -4.58738492460543668706e-33, -5.96335153160152660064e-34, 2.73587646546333049142e-34, 1.27897486161919866812e-35, -1.42326094073177553708e-35, 2.18873805147296345357e-37, 6.60927018222838530587e-37, -4.69728268023346039229e-38, -2.74493259545962704814e-38, 3.64859453332679119368e-39, 1.06653828104762410194e-39, -1.72565753408506389578e-40, -7.12780540373026813332e-42, 2.72300449662341862267e-41, 1.15288601789158710677e-41, 6.04095076423709130496e-42, 3.72560103297113208256e-42, 2.05164274166821001318e-42, 1.04901716993195729048e-42, 5.12425279778614665057e-43, 2.3722994154672873033e-43, 1.03567627037412274448e-43, 4.26372082207635557083e-44, 1.65352640191063692946e-44, 6.02801731878120017146e-45, 2.06141587138800084021e-45, 6.59833529726595040752e-46, 1.97180697223180476118e-46, 5.4848237894140088855e-47, 1.41534850722373240768e-47, 3.37508450037768522472e-48, 7.40403345654937744849e-49, 1.48635910386169206851e-49, 2.71366882983139418409e-50, 4.47265093027644217274e-51, 6.5961687322615102126e-52, 8.61075344599614826458e-53, 9.81807262326664708175e-54, 9.61567576913077620538e-55, 7.91555559089026904734e-56, 5.3173939083945432804e-57, 2.7911388927131558101e-58, 1.06477873882536631232e-59, 2.51971574629818559646e-61, 1.75654552017272157253e-63, -2.44114109540910230467e-65, 7.89745177830403223793e-66, -9.67159343270709333953e-67, -2.93173689083796605667e-67, 3.54000635019368439599e-68, 9.93292103732916104021e-69, -1.25078989450617770171e-69, -3.32737033615753468462e-70, 4.3082875381086966674e-71, 1.10630861703144495253e-71, -1.44711727910625132309e-72, -3.66759154414910963866e-73, 4.74535262009660221609e-74, 1.21783149027148064894e-74, -1.52227638938182432239e-75, -4.06612205385468295527e-76},
            {1.13696357048192069624e-15, 4.7109514699689209535e-16, -4.66331006257994746249e-15, 3.35279683041968291852e-16, 3.81715045947979516256e-15, -7.79614149699667786916e-16, -1.42259419195733176559e-15, 4.20892269069678133942e-16, 3.12045375872964524938e-16, -1.23155544363034560617e-16, -4.4632045880806460347e-17, 2.41169295776540164212e-17, 4.1421552301339506947e-18, -3.48909190816522051948e-18, -1.80679370576946286058e-19, 3.93517808898210360239e-19, -1.54271424398917478028e-20, -3.55436128354754548605e-20, 4.36494173239787622887e-21, 2.57613455429547495016e-21, -5.64925750273015294897e-22, -1.43807101478001018284e-22, 5.34368446079468588579e-23, 5.06709521591196037949e-24, -4.06235302037496117495e-24, 6.16711407561513881462e-26, 2.54477564212348768812e-25, -2.97382767401920497449e-26, -1.28953336024812270532e-26, 3.18649992600716431928e-27, 4.73920427383223033836e-28, -2.44498416982525315831e-28, -5.28739885516644538942e-30, 1.53689390118035703833e-29, -1.05513275172119299858e-30, -8.20705886989392453852e-31, 1.27745432404015473877e-31, 3.71083393107515418425e-32, -9.87620455637844896572e-33, -1.34720232447491618638e-33, 6.21506705457060049827e-34, 3.08538103745552216964e-35, -3.39800331291504157394e-35, 4.94491053747631193107e-37, 1.65346786131605566062e-36, -1.18628350944071354253e-37, -7.17598248078087605924e-38, 9.7057344781775852146e-39, 2.91889823995097735114e-39, -4.71335417673315730257e-40, -1.53068837505836957069e-41, 8.19414454673654594074e-41, 3.59465574215884946798e-41, 1.92855098677213061238e-41, 1.2028532345609152447e-41, 6.72133580357032692904e-42, 3.49018260556186541311e-42, 1.73043111402687953315e-42, 8.12912833407699804841e-43, 3.6009051104043156819e-43, 1.50392772729918045828e-43, 5.91601630578848355117e-44, 2.18729968123917365042e-44, 7.58495258187411748499e-45, 2.46157568907275880427e-45, 7.45717692604394449676e-46, 2.10254826902842404834e-46, 5.49875293403667326946e-47, 1.32876993516283559523e-47, 2.95357391268688825187e-48, 6.00719009596837624311e-49, 1.11104312406825470393e-49, 1.85493710681977109957e-50, 2.7708716538698195118e-51, 3.66357153015096057806e-52, 4.23073773717482733423e-53, 4.19655497177204779597e-54, 3.498830670173670373e-55, 2.38054365815129614008e-56, 1.26555198424854304838e-57, 4.88825988946488054733e-59, 1.16972936133888854575e-60, 8.16304866109333189743e-63, -1.25318820435574827247e-64, 3.5733092790249611186e-65, -4.58943323630900312703e-66, -1.36260757672315069901e-66, 1.71810132643996161061e-67, 4.72259786838610668075e-68, -6.202486230797513855e-69, -1.61776964793852785022e-69, 2.1836599238401798711e-70, 5.49787448343175852964e-71, -7.49979291469832214215e-72, -1.86197621862514137578e-72, 2.51564879263528767283e-73, 6.31258681618183708561e-74, -8.25816576518124329086e-75, -2.15063364772067646591e-75, 2.66158577448040005542e-76},
            {2.53486262450551668356e-17, -5.16448199090320900589e-16, 5.13675151185438686686e-17, 8.37697217609771169052e-16, -2.06278627661789053357e-16, -4.67153897843763533234e-16, 1.5692119043668696662e-16, 1.36725434277937062906e-16, -5.92204932104720338409e-17, -2.45473312739854521758e-17, 1.42041957466826858971e-17, 2.76674710167574739555e-18, -2.43311963802405968528e-18, -1.49137125310209201265e-19, 3.17270072735696111731e-19, -1.17446924639031529165e-20, -3.25615718875436927742e-20, 4.07448447340023333116e-21, 2.64828027364068495391e-21, -5.95034392831221519752e-22, -1.64702456751750619828e-22, 6.23480492872347540591e-23, 6.5214332041934987595e-24, -5.19536898007997734058e-24, 5.94788257694055852667e-26, 3.54200729213079511797e-25, -4.1314504589520270308e-26, -1.94547548536807250411e-26, 4.83930763249478360152e-27, 7.77379867438908550478e-28, -3.99597349561001971802e-28, -1.05364652382626578894e-29, 2.68440166996836776563e-29, -1.80833874399671847325e-30, -1.52508941739689287972e-30, 2.38695649492463848938e-31, 7.31452772254314327808e-32, -1.96383290524125746975e-32, -2.81457195598719294903e-33, 1.30587687507931476905e-33, 6.89705893188147913871e-35, -7.51337556583175974016e-35, 1.01788690919661425582e-36, 3.83569071132188783087e-36, -2.77253861677039686312e-37, -1.74169795935513802823e-37, 2.39360857462327690866e-38, 7.42249259289810621458e-39, -1.19648676541994050227e-39, -2.91575755190792478036e-41, 2.27984379623002364773e-40, 1.0339950020737365518e-40, 5.67546848284011234609e-41, 3.58592102055593511149e-41, 2.03522687559899923758e-41, 1.07407401913522664757e-41, 5.40911541630933367054e-42, 2.58038241049982205497e-42, 1.16054017228348003324e-42, 4.92044429377990044525e-43, 1.96449577435006179125e-43, 7.37049075093003479058e-44, 2.59317876131615958004e-44, 8.53710507634956894098e-45, 2.62312214607593741571e-45, 7.50012410131489527648e-46, 1.98883948758123406858e-46, 4.87232323221798616932e-47, 1.09780764779896081475e-47, 2.26301468072045241606e-48, 4.24164810073327969319e-49, 7.17589716751961852248e-50, 1.08609750813408062224e-50, 1.45489670849161575158e-51, 1.70214527968220251242e-52, 1.71045848673410773015e-53, 1.44468740613308870781e-54, 9.95748209013585645246e-56, 5.36215970300257563839e-57, 2.09723084168390339546e-58, 5.07456495951307049762e-60, 3.54065137500502795729e-62, -5.9433209704387279165e-64, 1.52051503643162055556e-64, -2.0407737704455378271e-65, -5.95146026184741388851e-66, 7.81693921687587262221e-67, 2.11051829242685984587e-67, -2.88423243297622718313e-68, -7.39508845255710261558e-69, 1.03812958144407511024e-69, 2.56937947385523977713e-70, -3.64626875581689763963e-71, -8.89164654187276160356e-72, 1.25117060742449259666e-72, 3.0784932275180526387e-73, -4.20291972052256804627e-74, -1.07041996539136321009e-74, 1.38652432213400030483e-75, 3.74737450142647240336e-76},
            {-2.75112060922322631654e-17, 5.40394234436400485956e-18, 1.312628502952997116e-16, -4.1903449568786954385e-17, -1.21511559636914561769e-16, 4.78343191993529407629e-17, 4.97884122587547367915e-17, -2.4100186402514825929e-17, -1.1533420743913096486e-17, 7.23496079640915005438e-18, 1.60595779303598731433e-18, -1.48925509798791966218e-18, -1.07452748581032270369e-19, 2.26944393318808827924e-19, -7.87016823144731810144e-21, -2.6681661557765986618e-20, 3.41229593952706530057e-21, 2.45060559628819604641e-21, -5.65776339462752455052e-22, -1.70628983037084566821e-22, 6.59803884410553886334e-23, 7.6105637522300260084e-24, -6.04994400037217321842e-24, 4.48645816610027760839e-26, 4.50345732865134562128e-25, -5.24693513260007097142e-26, -2.68815211236928057126e-26, 6.74222738731940089954e-27, 1.169775685909288248e-27, -6.00624586854965043501e-28, -1.88663680294181926016e-29, 4.32122997656123685422e-29, -2.8534455781987718555e-30, -2.61685445312442161918e-30, 4.12068245004962414059e-31, 1.33361023987049026958e-31, -3.61406288010677371663e-32, -5.44802676682456774373e-33, 2.5431434664546700201e-33, 1.43082159394852600878e-34, -1.54183089559880676005e-34, 1.90826921506946158973e-36, 8.26842954589651321122e-36, -6.01152640959740696082e-37, -3.93306642739521859111e-37, 5.48602846938145966117e-38, 1.75754586140840152105e-38, -2.82923883991421095788e-39, -4.78496680553023230718e-41, 5.88428511302102365079e-40, 2.75471829927865286339e-40, 1.5461777224506804223e-40, 9.90970804606721200548e-41, 5.7175210671911359319e-41, 3.06857587692461214757e-41, 1.57072899872162302327e-41, 7.61387151196501014065e-42, 3.47897125682346346323e-42, 1.49820443913976241039e-42, 6.07432758264254931861e-43, 2.31384796378702599894e-43, 8.26374216884344075054e-44, 2.761070440346965121e-44, 8.60850288748931248271e-45, 2.49714054380210870964e-45, 6.71685815708003958523e-46, 1.66887726823773268402e-46, 3.81303074010849895945e-47, 7.96939599343697999376e-48, 1.51429211553079305765e-48, 2.59678895829731202807e-49, 3.98354232464161494417e-50, 5.40797697323731968646e-51, 6.41166350564539488219e-52, 6.52881419643994775043e-53, 5.58758094449438854783e-54, 3.9021502363224114947e-55, 2.12884226339370923159e-56, 8.43179020481119427092e-58, 2.06295705372980355573e-59, 1.43783983237034581643e-61, -2.61593945222520543872e-63, 6.09928144001246847413e-64, -8.52572661526497133436e-65, -2.44848725202007189682e-65, 3.34249205220707284604e-66, 8.88622997249124724994e-67, -1.26089374212103182929e-67, -3.18566431049721001992e-68, 4.6409595700679275433e-69, 1.13187355940037449638e-69, -1.66729242311361118415e-70, -4.00339885770000862458e-71, 5.85313360662776788524e-72, 1.41581255414761337897e-72, -2.0120175876328859966e-73, -5.02541686584243694122e-74, 6.79360502659987721089e-75, 1.79482607928765621583e-75, -2.26306541879275499632e-76},
            {3.03696191707737980364e-19, 1.31070769270206071803e-17, -6.16328086168182965834e-18, -2.40996853411122896056e-17, 1.16286487205423397149e-17, 1.47976973065690101431e-17, -8.19330879983620516121e-18, -4.58331979623429033919e-18, 3.16333897651643902514e-18, 8.05362621842325031865e-19, -7.96531053753235489199e-19, -6.74360159237068146113e-20, 1.43647192437687627121e-19, -4.62478574498783072896e-21, -1.95278949854392206991e-20, 2.56215608605269511982e-21, 2.03992588607085677128e-21, -4.8556355195000491164e-22, -1.59882090571668892619e-22, 6.33513272215840569705e-23, 8.05685448283940083768e-24, -6.41905049849248401875e-24, 1.96653074463646633829e-26, 5.23533421575647212689e-25, -6.09833478733731064857e-26, -3.40577990598037789122e-26, 8.62836756087452066758e-27, 1.61700281905292597642e-27, -8.31427426530328094187e-28, -3.05807574976055539339e-29, 6.42057046462861352347e-29, -4.15159570100057629344e-30, -4.15262954044625816584e-30, 6.58338063012622997922e-31, 2.25269170479109496553e-31, -6.1662388101539995424e-32, -9.78612514026014117226e-33, 4.59864893718699033262e-33, 2.75844409591491944946e-34, -2.94187456650284889543e-34, 3.25050763707044964929e-36, 1.65936150350314855767e-35, -1.2118187868333484009e-36, -8.27879342481410537126e-37, 1.17102565948893307127e-37, 3.88252864451429519613e-38, -6.24423951586730368163e-39, -6.27199978534936827412e-41, 1.41282992018237759997e-39, 6.8193692257740566672e-40, 3.91299548346800050013e-40, 2.54684820447063308753e-40, 1.49488046041523064688e-40, 8.16388875732226953107e-41, 4.25003825256323516568e-41, 2.09457288462806628777e-41, 9.72853411716689290084e-42, 4.25764872493761340709e-42, 1.75385547351092678764e-42, 6.7862333496338015116e-43, 2.46135739923314895916e-43, 8.35002241237858521343e-44, 2.64278489952218113996e-44, 7.7806673034001712876e-45, 2.12372862153172718105e-45, 5.35351861543415659858e-46, 1.24077932497747137651e-46, 2.63021180543731802393e-47, 5.06818713635786573999e-48, 8.81250282772769819407e-49, 1.37056532442358293692e-49, 1.88619929347480605926e-50, 2.26676972281793495612e-51, 2.33949522745738709185e-52, 2.02923616861225643589e-53, 1.4361394534410835523e-54, 7.93866777407783655816e-56, 3.18444971754293819814e-57, 7.87830533157595358809e-59, 5.48215434590338416559e-61, -1.07273091755724724666e-62, 2.31123834549837162819e-63, -3.35415155734884238745e-64, -9.50836160905052683428e-65, 1.34629701310565257727e-65, 3.53248289775588891355e-66, -5.19398389603550327722e-67, -1.2959943896669317018e-67, 1.95544882524931851239e-68, 4.71002132127357000713e-69, -7.18682746058377703592e-70, -1.70308205579332878243e-70, 2.58150881265031929921e-71, 6.15366388114247561112e-72, -9.08127229466454653514e-73, -2.23021211700371492615e-73, 3.13832360731376596578e-74, 8.12764075283771458552e-75, -1.07000326487352437923e-75, -2.98088906471189928903e-76},
            {6.30949728574487674598e-19, -5.8874824211424186134e-19, -3.42609113882607831098e-18, 2.17166631611313294668e-18, 3.49808168481020056821e-18, -2.28543478994067579222e-18, -1.51988293089423838484e-18, 1.17541608494118664993e-18, 3.46229939136316473253e-19, -3.7005398202273643004e-19, -3.67313898494291265669e-20, 8.01625252231552456836e-20, -2.37063945276037960499e-21, -1.27371888467391748042e-20, 1.72249166417152118433e-21, 1.52562304387551376489e-21, -3.75878916012789916407e-22, -1.35423801210102351078e-22, 5.51794316842016493957e-23, 7.73756104848164117753e-24, -6.20700052281925669125e-24, -1.014041807659030035e-26, 5.56784218306743943821e-25, -6.49155302793667705004e-26, -3.9597203438116327337e-26, 1.01523960552884472151e-26, 2.05548482066392076151e-27, -1.06110474577701485347e-27, -4.5102796581729782188e-29, 8.81595894749930211026e-29, -5.57601521034086941819e-30, -6.10224239917066943398e-30, 9.74750470313538102295e-31, 3.53016456357350805019e-31, -9.76830114637264786076e-32, -1.63351317078786472449e-32, 7.73297490429638912008e-33, 4.9479591711297349095e-34, -5.22737828579883919455e-34, 5.00389719939379628492e-36, 3.10526828137918240849e-35, -2.27531000459122782662e-36, -1.62700594714856840517e-36, 2.33229920703929758907e-37, 8.01492501571646677604e-38, -1.28854380386558385889e-38, -4.78653478896290210812e-41, 3.16327459567723044949e-39, 1.57290702006630863724e-39, 9.22580229842736405505e-40, 6.10400301604156800398e-40, 3.64725987641341737705e-40, 2.02794565181434362459e-40, 1.0742963737962310497e-40, 5.38591140917480299083e-41, 2.54413075422035164417e-41, 1.13207643235953297124e-41, 4.74023395250053210414e-42, 1.86392303339419238245e-42, 6.86854298254579200805e-43, 2.36684110243558110902e-43, 7.60745658968952506092e-44, 2.27404760277409067702e-44, 6.30085610007926315179e-45, 1.61203520853965150282e-45, 3.79127765395980368402e-46, 8.15386263518437570587e-47, 1.59381387903593371463e-47, 2.81081655469014430724e-48, 4.43325887742678811209e-49, 6.18655906224129784319e-50, 7.53809135383668157285e-51, 7.88728320627656446778e-52, 6.93503979324402974839e-53, 4.97479048025834309293e-54, 2.78676283840745644827e-55, 1.13224840111074424473e-56, 2.83264381757828599694e-58, 1.96743372768416899772e-60, -4.11206102555600257252e-62, 8.2887921165939909465e-63, -1.24527532925405829923e-63, -3.49196311133020775642e-64, 5.11850378466459792086e-65, 1.32831679690394287278e-65, -2.02018325058635288713e-66, -4.9886201074868509079e-67, 7.78152150993020924932e-68, 1.85495508746018023262e-68, -2.92635725434787482968e-69, -6.85859218525465846827e-70, 1.07567878894281323367e-70, 2.5325451480088074943e-71, -3.87273554894708198732e-72, -9.37375738822177989832e-73, 1.36979910451004767695e-73, 3.48652785871628267693e-74, -4.77986225118221363809e-75, -1.30426319127938197608e-75, 1.65430028228017409252e-76},
            {-2.78176629668040822904e-20, -3.11327510188726412787e-19, 2.93229602736245214888e-19, 6.32807876175351288255e-19, -5.09828498815964391436e-19, -4.12853133884182376003e-19, 3.66190777844444571249e-19, 1.2628891578194678576e-19, -1.48155207696710025276e-19, -1.72712943556641691235e-20, 3.92482139000935717992e-20, -1.0523298450213025654e-21, -7.38138757641508461716e-21, 1.03463874696325247053e-21, 1.02318960181217923571e-21, -2.62118846281975295314e-22, -1.03579913829741803846e-22, 4.35714989014745239942e-23, 6.7386082750748896724e-24, -5.46906984221616141525e-24, -3.66941861973044299241e-26, 5.41825557565632973222e-25, -6.3313853531311219885e-26, -4.2267552916961448997e-26, 1.09899861345394318544e-26, 2.40457342940015355954e-27, -1.24954450906455006498e-27, -6.07495254961715120275e-29, 1.11970096512628475978e-28, -6.91963856449897313307e-30, -8.31251531663844309e-30, 1.33906962309782073882e-30, 5.13802938935420442322e-31, -1.43855881858803713816e-31, -2.53675179731197420501e-32, 1.21083550719124558433e-32, 8.26674552719903934089e-34, -8.6617428700281191331e-34, 6.88799139900088707418e-36, 5.42631457444390641618e-35, -3.98556269840567047298e-36, -2.98962155207667871717e-36, 4.34125105180251976096e-37, 1.54845417637207448414e-37, -2.48999699024689833562e-38, 5.27487565765755024937e-41, 6.6180852751638607604e-39, 3.38811337357428140422e-39, 2.03142340891475008149e-39, 1.36743667079146466487e-39, 8.32300158848239954868e-40, 4.71406680304724224829e-40, 2.542519256528977037e-40, 1.29734093606769238986e-40, 6.23553687710286381703e-41, 2.822449984260002246e-41, 1.20183453207448050298e-41, 4.80455016626029622845e-42, 1.79953118206301145848e-42, 6.30126391596952179276e-43, 2.05759520890628015567e-43, 6.24718548124626937292e-44, 1.75774356163077488077e-44, 4.56575444708781669072e-45, 1.08998660675425582565e-45, 2.37912184140419877978e-46, 4.71882320756413629418e-47, 8.44309620245953255117e-48, 1.35083232194318718772e-48, 1.91195860065003670458e-49, 2.36259331157872689433e-50, 2.50671117882793802965e-51, 2.2347333038559676067e-52, 1.62514066604950959926e-53, 9.22686918192013345589e-55, 3.79751818056541740024e-56, 9.60813144561438019564e-58, 6.66109036956311796079e-60, -1.47771613771913884943e-61, 2.81789273520776266331e-62, -4.37130103608075475722e-63, -1.21488151187702536705e-63, 1.84029547918908210109e-64, 4.73292532117729036268e-65, -7.43292028203103558613e-66, -1.82004468535683117226e-66, 2.93005176097731232275e-67, 6.92599508964789840997e-68, -1.12771795050824357424e-68, -2.61928148110152039213e-69, 4.24268833639893522823e-70, 9.88629226175608467881e-71, -1.5634389973693184043e-71, -3.73795822602648377355e-72, 5.6601313588009496549e-73, 1.4192876530127610284e-73, -2.02140276584468778555e-74, -5.41656014702204204324e-75, 7.15823914242438813448e-76, 2.0760178702269882813e-76},
            {-1.36605536165417651074e-20, 2.55960250279910746849e-20, 8.23081229634306021088e-20, -8.75477797623600998848e-20, -8.94824015843894535152e-20, 9.38998866473361681935e-20, 3.85464512585860442242e-20, -5.05852333697299086654e-20, -6.95839479515228988367e-21, 1.67522176305919412805e-20, -4.00549308718887340302e-22, -3.78522411717732343987e-21, 5.53642987543603949799e-22, 6.13788873385935151405e-22, -1.64350797479879334875e-22, -7.14243291364479452887e-23, 3.11557414754075503838e-23, 5.31758252746644002499e-24, -4.38849424856187321099e-24, -5.35643755639199113224e-26, 4.82385122662817990031e-25, -5.65846949196724228423e-26, -4.14302453473569161905e-26, 1.09486024804633651696e-26, 2.58989474594289717272e-27, -1.35841843673670100917e-27, -7.49224328913248963533e-29, 1.31634305592846539999e-28, -7.93902699737514220291e-30, -1.05052188686263114328e-29, 1.70835618729511526456e-30, 6.95185461509688263263e-31, -1.97145177660878113207e-31, -3.66855090881136076624e-32, 1.7673371963495180427e-32, 1.28763161215761493236e-33, -1.33995213798788784735e-33, 8.29687182591500489175e-36, 8.86505233733044877372e-35, -6.52207092707748211315e-36, -5.14263380833148362542e-36, 7.56258836796771615124e-37, 2.8032983159961288327e-37, -4.51198116117369964507e-38, 3.37915645533624925826e-40, 1.29613943211288884907e-38, 6.82916340951468325874e-39, 4.18599051217696666324e-39, 2.86912093534618188743e-39, 1.77992473433899232548e-39, 1.02745953295073906317e-39, 5.64488659931470446573e-40, 2.93301815646784106798e-40, 1.43508836612490880555e-40, 6.6106370447021879167e-41, 2.86381447919706408699e-41, 1.16443230687336701909e-41, 4.43471114406543713636e-42, 1.5785752252151142849e-42, 5.23866944835146290918e-43, 1.61608932776205119181e-43, 4.61909920113704237588e-44, 1.21854198020384031865e-44, 2.95382855722865871092e-45, 6.5453336433393363822e-46, 1.31770903993913753104e-46, 2.39267202494066122005e-47, 3.88426507646099583391e-48, 5.57760503797438406919e-49, 6.99134658669778120239e-50, 7.52354264186447524668e-51, 6.80192744946097982191e-52, 5.01550558241852953125e-53, 2.88657097967851558427e-54, 1.20360813987526417544e-55, 3.08008393027686775705e-57, 2.13197077258722160427e-59, -4.99110401941766924383e-61, 9.09421813423535674577e-62, -1.45336300837635804984e-62, -4.01026927059359058347e-63, 6.26774596431645319055e-64, 1.60045330401589685871e-64, -2.5914550970703293879e-65, -6.3036170329296882786e-66, 1.04572768331168871844e-66, 2.45557773707869339711e-67, -4.12003831899026578091e-68, -9.50088505882617983466e-69, 1.5867206836595817593e-69, 3.66650079223539224463e-70, -5.98544143288192586015e-71, -1.41644590152119586993e-71, 2.2180848385132618534e-72, 5.4914923892250403911e-73, -8.1074243681998211441e-74, -2.13853982319647090748e-74, 2.9375647142532497864e-75, 8.35882212498375431361e-76, -1.06121222849099773365e-76},
            {1.0957613275196074694e-21, 6.85891164566211008758e-21, -1.08824085557486428566e-20, -1.48828807773522639365e-20, 1.93081433565899914476e-20, 9.66106224115743180021e-21, -1.45263423212789127852e-20, -2.37780356497933876354e-21, 6.18212885515710233678e-21, -1.28962170899104356255e-22, -1.70870069244601369203e-21, 2.6290293697427166002e-22, 3.28219459926359457668e-22, -9.24147317485782244411e-23, -4.43052780796951454389e-23, 2.01399871454380217118e-23, 3.79738953913586935717e-24, -3.20369939402761106415e-24, -5.82289124793308232292e-26, 3.92704970905179851808e-25, -4.63280597782942885518e-26, -3.72850097110152225215e-26, 1.00385434946719657826e-26, 2.5687712115605752504e-27, -1.36370031264743142931e-27, -8.47670948964259641479e-29, 1.43306281864027527892e-28, -8.42444169328632514648e-30, -1.23243808893866331943e-29, 2.02547134049429333396e-30, 8.75010732994718814554e-31, -2.51620512950599646888e-31, -4.94436471380355047872e-32, 2.40679188075054491312e-32, 1.87128217523066018975e-33, -1.93711907682051965271e-33, 8.31734594148118567351e-36, 1.35541913656331749164e-34, -9.98259103893365480555e-36, -8.29011817170917928329e-36, 1.23447248502271103548e-36, 4.7610026893133816271e-37, -7.67573315401426807867e-38, 9.53802841215817403772e-40, 2.37994066297947067514e-38, 1.29023719696325013495e-38, 8.08665671255591472772e-39, 5.64792957779662377008e-39, 3.57333199563455132361e-39, 2.10330475990683347344e-39, 1.177692484280529712e-39, 6.23407166077424798137e-40, 3.10656797966176447868e-40, 1.45697018867286480501e-40, 6.42422895516109777552e-41, 2.65784868400245051963e-41, 1.02966882314736012607e-41, 3.72730145699999205519e-42, 1.25757217771566169915e-42, 3.94321596911390044222e-43, 1.14527827178985383744e-43, 3.06946479117114319345e-44, 7.55754182101859205004e-45, 1.70062964132236338094e-45, 3.47611936602407974656e-46, 6.40730151167579078717e-47, 1.05570506837261217013e-47, 1.53834366024007749018e-48, 1.95646800688739412434e-49, 2.13588181539316753568e-50, 1.95868062321115403915e-51, 1.46468064545950691553e-52, 8.54639451563734415868e-54, 3.61078569224626924369e-55, 9.3471436306155694353e-57, 6.4627657247821579652e-59, -1.58807243118624783935e-60, 2.78971524309014089252e-61, -4.58398475646952213629e-62, -1.25777238512451299925e-62, 2.0252851281894497437e-63, 5.14351763952915323559e-64, -8.57463008806642435753e-65, -2.07551183015412001141e-65, 3.54298558970815623572e-66, 8.27888945399712770885e-67, -1.42925290966290587437e-67, -3.27798763401950833233e-68, 5.63567952124716841122e-69, 1.29372288895539024679e-69, -2.17649259013287769614e-70, -5.1078930165517070505e-71, 8.25686942060040203894e-72, 2.02249243040763407742e-72, -3.08902305935548934356e-73, -8.03864700924896604613e-74, 1.14521562628983169327e-74, 3.20494835499920828433e-75, -4.23086959352909407486e-76, -1.27905999096716075141e-76},
            {2.76257161344550777078e-22, -8.74281983677938133403e-22, -1.7838217510214271282e-21, 3.06300880596818467654e-21, 1.93614030168145674546e-21, -3.4429915690883717795e-21, -6.79734447851081690317e-22, 1.95140384128459479912e-21, -3.44490918570290636601e-23, -6.74468071477236228995e-22, 1.10231317503491463318e-22, 1.55779205896887994653e-22, -4.64444387855766181911e-23, -2.46525841727333474588e-23, 1.17432099158718848117e-23, 2.44969039013053280071e-24, -2.12465440746953433642e-24, -5.24491676503332643361e-26, 2.92073644999429394003e-25, -3.47283647281357544035e-26, -3.07935678925371811313e-26, 8.4688463000981441173e-27, 2.34599560346032553431e-27, -1.26418779861321268235e-27, -8.80943560940856607297e-29, 1.44505734772673406659e-28, -8.2692316825578542831e-30, -1.3427008287578052031e-29, 2.23287541440296083784e-30, 1.02507953237976036762e-30, -2.99278456179399081223e-31, -6.21424996340310217862e-32, 3.06022270431931973938e-32, 2.5389864971854950965e-33, -2.61910019657814329041e-33, 5.91390589162458380114e-36, 1.94113696675228501721e-34, -1.43054192341124317833e-35, -1.25353709375881186724e-35, 1.89018486047010284672e-36, 7.59287182049433588243e-37, -1.22717081637574415203e-37, 2.08032659475837101901e-39, 4.10257253664369161747e-38, 2.28822923017256667604e-38, 1.46681932273511801364e-38, 1.04466644302518292721e-38, 6.74435093649191668908e-39, 4.04998000933821664262e-39, 2.31226489806241555914e-39, 1.24757553801865228732e-39, 6.33462262497944270894e-40, 3.02612822395270145525e-40, 1.3586603800212017792e-40, 5.72186365239047082656e-41, 2.25575437760321437659e-41, 8.30711473126661976364e-42, 2.85055671692587093002e-42, 9.08810192594637209159e-43, 2.68317606767722065226e-43, 7.3082068571121032587e-44, 1.82826097224262184251e-44, 4.17908522352432439515e-45, 8.67539792070023591521e-46, 1.62370668292724181015e-46, 2.71601592257064023089e-47, 4.01721287403922388877e-48, 5.18506707252778275058e-49, 5.74379411302449189478e-50, 5.34381653369526577699e-51, 4.05329454539462020867e-52, 2.39823524526452276186e-53, 1.0268098838499516434e-54, 2.6893018195775645121e-56, 1.85862491606159689119e-58, -4.76990565835519218619e-60, 8.14307214272400773952e-61, -1.37354960690342565882e-61, -3.75299681953040558891e-62, 6.21764003059620534524e-63, 1.57306267691353245737e-63, -2.69642805128485767628e-64, -6.50513061104675926322e-65, 1.14115564539771350977e-65, 2.6577120381235614895e-66, -4.71460804757008241473e-67, -1.07717193237933029024e-67, 1.903732386772125602e-68, 4.3488802430923783914e-69, -7.52832870792266177679e-70, -1.7552454014773320812e-70, 2.92402997166818836172e-71, 7.09970752971010560083e-72, -1.11975148113416537918e-72, -2.88073592417748013254e-73, 4.24787267192647888372e-74, 1.17177595245458873316e-74, -1.60494736299768443712e-75, -4.76858819968662538392e-76, 6.07227312810701852158e-77},
            {-3.43683917332983957811e-23, -1.37187196136175141866e-22, 3.52322423711636588117e-22, 2.98260759553580262244e-22, -6.55984766907942841696e-22, -1.59503573198490766866e-22, 5.19453615415170058678e-22, -7.41732184001548008341e-24, -2.30818858771451925198e-22, 4.05475461061430920317e-23, 6.52641250960925798315e-23, -2.07716354319784958329e-23, -1.22599936084691398812e-23, 6.1582189497344700068e-24, 1.42420864987022734872e-24, -1.27754379216721023865e-24, -4.0653614327358540703e-26, 1.98206084104561936054e-25, -2.38133005523401750392e-26, -2.33215357816790140323e-26, 6.57024405198738356416e-27, 1.97208610633713787958e-27, -1.08194177790576333572e-27, -8.41626731467239953675e-29, 1.3496617601159363687e-28, -7.50749587182736147292e-30, -1.35870776120670672046e-29, 2.28942671452538115376e-30, 1.11808830108838544787e-30, -3.31866463132345732382e-31, -7.28651936422936581497e-32, 3.63495711959521911419e-32, 3.21795087987712235646e-33, -3.31399992506483556062e-33, 2.78325404154592244186e-37, 2.60577570251367986832e-34, -1.92098613951192685617e-35, -1.77929425970146292697e-35, 2.71723964171977471717e-36, 1.13802550891232214784e-36, -1.84548168600872402371e-37, 3.89135018348311083393e-39, 6.64696295056657259116e-38, 3.81421002560215162695e-38, 2.50145696278545394775e-38, 1.81792784525477745931e-38, 1.19829423662414087424e-38, 7.34479891280209471445e-39, 4.27795377329527508017e-39, 2.35377025540902798201e-39, 1.21832424008933009319e-39, 5.93086894050068076813e-40, 2.71256411162461798897e-40, 1.16332699155517225691e-40, 4.66889636457882062398e-41, 1.74984207076529812494e-41, 6.10911253289754802835e-42, 1.98107258658312895227e-42, 5.94756510065676208712e-43, 1.64684527584685822888e-43, 4.18722469304246129585e-44, 9.72556101411570257709e-45, 2.05103216917952257111e-45, 3.89896733653963495868e-46, 6.62289107100910777594e-47, 9.94563233230553362634e-48, 1.30309670858408662358e-48, 1.465072890855460575e-49, 1.38314913239504755044e-50, 1.06435294139105461884e-51, 6.38685633172804456259e-53, 2.77161930198962254346e-54, 7.34578597094292362474e-56, 5.07887278540329320546e-58, -1.35498032878042230703e-59, 2.26398827602524180297e-60, -3.91515068768213482127e-61, -1.06662422759472088352e-61, 1.81589765843844426768e-62, 4.58370822103862065309e-63, -8.06912931235924027585e-64, -1.94313094582861495701e-64, 3.49873324348319520936e-65, 8.13362008251896484816e-66, -1.48074663682714253251e-66, -3.37537889003167319502e-67, 6.12427505617927464275e-68, 1.39440256678706649779e-68, -2.48028947732804963707e-69, -5.75464400765655000648e-70, 9.86432651473427539683e-71, 2.3783944480836219399e-71, -3.86708590193627872643e-72, -9.85403794246791508369e-73, 1.50123905551562409373e-73, 4.09028689995929986451e-74, -5.80117321534960996194e-75, -1.69771429420105481033e-75, 2.24310159337722579043e-76, 7.02645117042821289329e-77},
            {-5.09942876665500749779e-24, 2.62136378041006349091e-23, 3.31491964547597717562e-23, -9.66260819798252588772e-23, -2.99103143206937731136e-23, 1.1440443979886720453e-22, -1.22781928738376752838e-24, -6.77361409926364078823e-23, 1.29776340306766951513e-23, 2.39695242629944944677e-23, -8.22208645213505754755e-24, -5.42453208074189093781e-24, 2.89378124478542834091e-24, 7.43996885249020619956e-25, -6.94742784802641782951e-25, -2.75748629118688473097e-26, 1.22518302806041401952e-25, -1.49172975486398692039e-26, -1.61785712388730794825e-26, 4.6835000275564667476e-27, 1.52487992392901147109e-27, -8.54426459943804226e-28, -7.39437030479413419589e-29, 1.16730056509358930801e-28, -6.30204016996493549212e-30, -1.27701787483027849176e-29, 2.18354857746237538861e-30, 1.13562220929102647267e-30, -3.43180263610350489583e-31, -7.97307536443295575363e-32, 4.03499376336403809471e-32, 3.8112090758772978976e-33, -3.9261514932187008429e-33, -8.7579661568545136718e-36, 3.28066464655567671215e-34, -2.41888590312352032179e-35, -2.37228268252031053304e-35, 3.67010731174436401303e-36, 1.6041298408732201046e-36, -2.61254718610818001939e-37, 6.48997819168992550382e-39, 1.0132048704415318252e-37, 5.98211368420610497392e-38, 4.01522934471663400075e-38, 2.97970540829124722697e-38, 2.00646474393864351496e-38, 1.25595733060888299084e-38, 7.46657386035255617831e-39, 4.19140255746122149836e-39, 2.21261140410569457975e-39, 1.098103770370242197e-39, 5.11834698466735903749e-40, 2.23627985699134971217e-40, 9.1404869248174345819e-41, 3.48775806839244772031e-41, 1.23932570061087562939e-41, 4.08922146485028424639e-42, 1.24879392480251761336e-42, 3.51640870857842964656e-43, 9.08984904687835447812e-44, 2.1459667200343018379e-44, 4.59894117673419124174e-45, 8.88211155106640992628e-46, 1.53251444367732257782e-46, 2.33718572503831614221e-47, 3.10926687911112859375e-48, 3.54877296989530150978e-49, 3.40046036694388862126e-50, 2.65521369742200081238e-51, 1.61620480063174141329e-52, 7.10992122717792404583e-54, 1.90729173047573641817e-55, 1.32052911141062672997e-57, -3.64662357505692498951e-59, 6.00057199255899805395e-60, -1.06285860707245774995e-60, -2.89045983011692162045e-61, 5.05124803482622527371e-62, 1.27393239584552728561e-62, -2.30062191915348204651e-63, -5.53783634053788666858e-64, 1.02231970989017254236e-64, 2.37563476820440796932e-65, -4.43341339879082136763e-66, -1.00972300298763909786e-66, 1.87854432977755573386e-67, 4.26931761646975935712e-68, -7.7929801249584911295e-69, -1.80206820330751896791e-69, 3.1740559522217958232e-70, 7.61214965512626783666e-71, -1.27396755990460010367e-71, -3.22112857909288749507e-72, 5.06153440178894485321e-73, 1.36472146649879844138e-73, -2.00061595753745775727e-74, -5.77847645544509173383e-75, 7.9065006886378903947e-76, 2.43861874862359171543e-76, -3.13760558193581788355e-77},
            {9.53727075906917113179e-25, 2.3644041659959798755e-24, -1.03374713895090751198e-23, -4.30690028191405544702e-24, 2.02980311582181488937e-23, -1.42705285435579842101e-25, -1.68019143702084271599e-23, 3.57584032493786760425e-24, 7.65009191134938082863e-24, -2.86078322966764471387e-24, -2.12331225741022626955e-24, 1.21289881236230586945e-24, 3.47914014789038414805e-25, -3.40617650354304702388e-25, -1.64969687351074096244e-26, 6.88336471711885848855e-26, -8.52241507635599831225e-27, -1.02651265413270250438e-26, 3.0639167439946426246e-27, 1.08352833230844991093e-27, -6.22135478875282170215e-28, -5.97425665597588126839e-29, 9.34449794214986121272e-29, -4.88838036286250056968e-30, -1.11454146498389237422e-29, 1.93704768426236605166e-30, 1.07403535532168721463e-30, -3.30970987499577972312e-31, -8.14251612052717054346e-32, 4.18678571261601201834e-32, 4.21909180140560561252e-33, -4.35654163766983935707e-33, -2.04310795688561673179e-35, 3.87540380605955816742e-34, -2.85768142104102517593e-35, -2.97242913558559303588e-35, 4.66041634062013634559e-36, 2.12774154264703534565e-36, -3.48373523095592062326e-37, 9.83475227907421286847e-39, 1.45426787789915265652e-37, 8.83590144248176190817e-38, 6.07225871115530018581e-38, 4.6045558363719859958e-38, 3.16933067049650671324e-38, 2.0270561910763910071e-38, 1.23062358840245389237e-38, 7.05160445705267877277e-39, 3.79827096756796105769e-39, 1.92266640495671808739e-39, 9.13701438847027660315e-40, 4.06871655086082233837e-40, 1.69436300066320188116e-40, 6.58482711834780587171e-41, 2.38234981242046722179e-41, 8.00110234156317850659e-42, 2.48634699246126930243e-42, 7.12213444321822484993e-43, 1.87236643797191483284e-43, 4.49437509926775582764e-44, 9.790622550752924961e-45, 1.92164785356824542502e-45, 3.36876826123647341872e-46, 5.21887466089683916832e-47, 7.0513079501036306155e-48, 8.17201064528257976184e-49, 7.94937389484156197833e-50, 6.29981096055804198945e-51, 3.89045983945934200043e-52, 1.73528244825817196361e-53, 4.71271740754269686069e-55, 3.27098148447313812649e-57, -9.31275104276240163436e-59, 1.5173223534024359672e-59, -2.75105002138456859879e-60, -7.47600741668093587221e-61, 1.33974004924255763039e-61, 3.38040376737245885138e-62, -6.25632261921955411389e-63, -1.50732913166392239476e-63, 2.85003641780262157312e-64, 6.62882081149283521792e-65, -1.26677633591096414481e-65, -2.88647630200742310483e-66, 5.50038423215795972903e-67, 1.24949581991573846275e-67, -2.3377325596275474048e-68, -5.39566808633311411202e-69, 9.75265000855432695345e-70, 2.3300351970049435448e-70, -4.00822704147209162932e-71, -1.00725471989739376136e-71, 1.62998541851136241056e-72, 4.35684782557798411924e-73, -6.59064349434241794982e-74, -1.8823300929655435808e-74, 2.66248891465868324796e-75, 8.10169741386376503384e-76, -1.07906107952014572916e-76, -3.46368955094863011109e-77},
            {8.13537169011352378833e-26, -7.1613140140113581024e-25, -4.46550835465882054471e-25, 2.78950464508002031382e-24, -9.11535128740873929009e-27, -3.45541229376150875149e-24, 8.36477915137192310597e-25, 2.09815293803818996559e-24, -8.67378139012972147386e-25, -7.30075388309756264514e-25, 4.5087345862336316157e-25, 1.44960148850375592686e-25, -1.49974050002112965039e-25, -8.73288541736782633765e-27, 3.50543185645687166295e-26, -4.43109393107231628641e-27, -5.94579256171940672484e-27, 1.83667405009851404863e-27, 7.06616789661138730917e-28, -4.17225618806410170415e-28, -4.43709153919561878596e-29, 6.91892260211002805457e-29, -3.50085734727794281862e-30, -9.0289894481317049803e-30, 1.59787728337909621899e-30, 9.45671694373255091261e-31, -2.97666189990957782448e-31, -7.7607365300339427392e-32, 4.06108958691367156531e-32, 4.36614592535151031279e-33, -4.52857287912257689013e-33, -3.30517512389401389766e-35, 4.29666677185915344145e-34, -3.16884594928863592577e-35, -3.50145207843175562199e-35, 5.56645439864667120675e-36, 2.65699013249889649352e-36, -4.37803707427945021815e-37, 1.36859154348432737728e-38, 1.96685456986773669178e-37, 1.23007735283197260409e-37, 8.65907334814959619383e-38, 6.71397503266019501541e-38, 4.72646307347235481717e-38, 3.09046199037812492667e-38, 1.91700659679018060791e-38, 1.12183837300970640504e-38, 6.16865032031395686627e-39, 3.18631679036046767384e-39, 1.54453062350391955179e-39, 7.01280826823350220394e-40, 2.97663275222738945112e-40, 1.17867939854769888808e-40, 4.34354225163359884479e-41, 1.48537610489115859416e-41, 4.69854252003068540723e-42, 1.36961594902364728909e-42, 3.66306553343801348912e-43, 8.9427644951619759545e-44, 1.98084327477793216817e-44, 3.95225276438575016982e-45, 7.04160580995875227944e-46, 1.1084338706461409435e-46, 1.52138893344921399695e-47, 1.79077961170268086361e-48, 1.76883730189564018135e-49, 1.4230034243749731507e-50, 8.91744861219585988e-52, 4.03361643422392498806e-53, 1.10931268103346322529e-54, 7.72765682838811683652e-57, -2.2601643163503827973e-58, 3.66293953016922993222e-59, -6.79590514900826530469e-60, -1.84717691168621446565e-60, 3.3914982784057753178e-61, 8.57200574258177309197e-62, -1.62437028207517121443e-62, -3.92201047092687055042e-63, 7.58825524652275585108e-64, 1.76872224616564103113e-64, -3.45788104122109074648e-65, -7.89275512099423640981e-66, 1.53892818143387645652e-66, 3.4988782338407707082e-67, -6.70240350206459557842e-68, -1.54616126334426219482e-68, 2.86452307900713443785e-69, 6.82757321500671936101e-70, -1.20568356430620163558e-70, -3.01597451444060118923e-71, 5.01914278335026686052e-72, 1.33217499406548671073e-72, -2.07630209209514259093e-73, -5.87404164660017948152e-74, 8.57527828626146591977e-75, 2.57905208457826702746e-75, -3.54992995386476143458e-76, -1.12432493695609359131e-76, 1.47671260529864829124e-77},
            {-2.42582098675863872712e-26, -2.95913149421914031117e-26, 2.78868777316207108764e-25, 5.28978369057451845768e-29, -5.73549301611943514941e-25, 1.63035701889085028631e-25, 4.87351021891962338919e-25, -2.26637914663840413354e-25, -2.18552000790842991233e-25, 1.47595313836222934685e-25, 5.35042773903494167837e-26, -5.90193321490288957667e-26, -4.09144313729385801591e-27, 1.61280089867787325051e-26, -2.09117189300493449842e-27, -3.13660900440408968022e-27, 1.00692394714616730536e-27, 4.22239366018468646222e-28, -2.57356107461581977645e-28, -3.02704039988108221591e-29, 4.73384759823396436238e-29, -2.31214913911852076292e-30, -6.78498716503037422633e-30, 1.22509942266515435886e-30, 7.74872945881547907763e-31, -2.49591233007522740034e-31, -6.9019954863786023969e-32, 3.68206226883354482552e-32, 4.22368761662355476058e-33, -4.41010908321709945942e-33, -4.43822837797188870908e-35, 4.47177231455103249939e-34, -3.29915892714970213669e-35, -3.87873713835403056004e-35, 6.25605904464341858375e-36, 3.1246712633186458063e-36, -5.18735403303523773485e-37, 1.76039301972015740498e-38, 2.50803850010890373797e-37, 1.61503520753652409523e-37, 1.16513245364162772692e-37, 9.24388127497477856242e-38, 6.65961667923518145783e-38, 4.4541672907349883604e-38, 2.82449991509677377591e-38, 1.68895168077131197433e-38, 9.48536338128766003352e-39, 5.00195372567558506194e-39, 2.47429973217719818695e-39, 1.14598799916875018376e-39, 4.95998271436789449583e-40, 2.0019747575126887694e-40, 7.51731821689821155598e-41, 2.61857964331020643959e-41, 8.43458260721105673054e-42, 2.50286168052443496132e-42, 6.81228278375979112583e-43, 1.69202835934542444895e-43, 3.81203715775456177459e-44, 7.73412745469440912243e-45, 1.40084841496456618003e-45, 2.24119309561638801579e-46, 3.1257875767218966417e-47, 3.73774932651033636973e-48, 3.74970992045291344461e-49, 3.06290102758579329015e-50, 1.94812776500677624895e-51, 8.93809646656650320417e-53, 2.48988403871583149899e-54, 1.7429982601159137136e-56, -5.22012314568516826228e-58, 8.44734272181031840895e-59, -1.60365796591722545739e-59, -4.36353934988530245927e-60, 8.20184613014439696571e-61, 2.0790009428544817002e-61, -4.03037278960843383899e-62, -9.76366456005707567891e-63, 1.93137695975935535166e-63, 4.5167268628310445709e-64, -9.02564783820988246634e-65, -2.06614723243505721741e-65, 4.11824243674596249029e-66, 9.38254192362764953986e-67, -1.83835996657775029075e-67, -4.24407125069737545926e-68, 8.05061928257147054941e-69, 1.91692209763669284548e-69, -3.47083183663818142386e-70, -8.65488616461872723996e-71, 1.47930803393918608279e-71, 3.90482572327872548157e-72, -6.2617753557008908924e-73, -1.75764335273099326864e-73, 2.644337860011108578e-74, 7.87394822438585447891e-75, -1.1183433246319277781e-75, -3.50093453324120047921e-76, 4.74819350784075947555e-77, 1.54079091760287636415e-77},
            {-9.37384805843943838171e-28, 1.80715698209388275809e-26, 3.22540844307227396509e-29, -7.38620255935454910018e-26, 2.57937983842127777557e-26, 9.40195165586960462034e-26, -5.03019574389958292314e-26, -5.63181726605419792956e-26, 4.21707258558547264673e-26, 1.73687218348363284495e-26, -2.06370869884458230145e-26, -1.69318205100875846552e-27, 6.67666835468944895799e-27, -8.92893688949360464622e-28, -1.50271149941315465553e-27, 5.03662247196929404918e-28, 2.30721248217135696956e-28, -1.45757122161024004674e-28, -1.89477068263603425707e-29, 2.98916482704295475932e-29, -1.40625405602443595007e-30, -4.72555055031125210064e-30, 8.72438052601461282025e-31, 5.9052510555190036846e-31, -1.95029775169551164893e-31, -5.72558046807379295276e-32, 3.11976354379712029887e-32, 3.81883144252985976622e-33, -4.02317786826007714671e-33, -5.22777677753022413997e-35, 4.36897915039390675498e-34, -3.22546294319399682398e-35, -4.04112027125834058085e-35, 6.6176041356534057047e-36, 3.46152067177685784644e-36, -5.79665346320478803112e-37, 2.10188181409664532791e-38, 3.01670622243224423875e-37, 2.00092091467575095224e-37, 1.48016753776674024951e-37, 1.2024482086013844585e-37, 8.87092830931519075211e-38, 6.07248047285720583539e-38, 3.93874179065299852449e-38, 2.40787491159103862292e-38, 1.38187558696392494331e-38, 7.44309510826100212056e-39, 3.75902032999985054526e-39, 1.77676476028336703044e-39, 7.84484210920482228552e-40, 3.22887073674585539108e-40, 1.23590194982492377296e-40, 4.3869605853773342183e-41, 1.43943701985726137665e-41, 4.34968191077264813231e-42, 1.20523397464964998582e-42, 3.04660845098305207994e-43, 6.9835171155418448654e-44, 1.44118407827155151452e-44, 2.65447173127740295158e-45, 4.31754425970605315127e-46, 6.12042484546631222815e-47, 7.43686912825112185691e-48, 7.57918352831434001871e-49, 6.28741420400969062954e-50, 4.0597456608045879048e-51, 1.88970419929836821774e-52, 5.33366499613808221293e-54, 3.75680199531222333667e-56, -1.14885917262774060766e-57, 1.86207772690835657818e-58, -3.61779906595548570551e-59, -9.86248870840153722959e-60, 1.8964800138871641229e-60, 4.82639088956796760801e-61, -9.56468063800450219256e-62, -2.32735136363172202905e-62, 4.70327276070172547425e-63, 1.10477506764479199389e-63, -2.25467252233590252141e-64, -5.18219895263109885568e-65, 1.05501054126173051561e-65, 2.41135420588534325165e-66, -4.82817447212260682807e-67, -1.11681918095857347997e-67, 2.16694208120141583757e-68, 5.16099671754266871488e-69, -9.57090128629659034794e-70, -2.38231937920221544339e-70, 4.17712089992080683311e-71, 1.09813541497772386385e-71, -1.80950965610428799947e-72, -5.04710233830685311726e-73, 7.81468674218172240527e-74, 2.30749702471379026915e-74, -3.37701995176225874091e-75, -1.04661216978933565353e-75, 1.46370171430258975102e-76, 4.69725317282788657055e-77, -6.36690579368959897804e-78},
            {5.72706687843442760302e-28, -4.95661266151362284309e-30, -6.9290050352675912587e-27, 3.18762912986281025036e-27, 1.46627255054116344016e-26, -9.30219698506540055534e-27, -1.23099033302976357697e-26, 1.03981494449963270396e-26, 4.91441222429105996106e-27, -6.36537513173253414298e-27, -6.16512089591247824786e-28, 2.47478877358987986949e-27, -3.43590223503423326255e-28, -6.5155803282561553076e-28, 2.29196827122610560646e-28, 1.15001213968614108277e-28, -7.56391183700886636332e-29, -1.08657264588303830748e-29, 1.73933610907080219238e-29, -7.86225299208492196341e-31, -3.04699986830537658172e-30, 5.76567525420439774652e-31, 4.18242041996624519578e-31, -1.41930646821857404136e-31, -4.42803012924721423423e-32, 2.46922417556278185805e-32, 3.22613865526268072412e-33, -3.43734931444744890058e-33, -5.53419307596989817999e-35, 4.00679369563609284217e-34, -2.96132822828219460585e-35, -3.96001479623129010797e-35, 6.58928832827188552753e-36, 3.61274170552086061091e-36, -6.11029094052308001142e-37, 2.33609357805524974727e-38, 3.42391934974106731561e-37, 2.34022486649641145849e-37, 1.77614434712376459641e-37, 1.47850781845504653354e-37, 1.11766823685896834075e-37, 7.83517700673805515885e-38, 5.20123568745159443919e-38, 3.25254463787679176214e-38, 1.90846958999542112267e-38, 1.05047962135623128809e-38, 5.41909725704186751649e-39, 2.61523546387605259085e-39, 1.17845275612913784461e-39, 4.94825259611974721027e-40, 1.93148863495716959922e-40, 6.9890751741619895526e-41, 2.33692157493635108391e-41, 7.1938038066465079675e-42, 2.02993660597867556192e-42, 5.22401193294760978564e-43, 1.21873752809383568705e-43, 2.55906480080211736609e-44, 4.79455159312520671347e-45, 7.93050604019185117996e-46, 1.14295264058139720543e-46, 1.4115843812877689687e-47, 1.46180761775089961561e-48, 1.23184168611963537344e-49, 8.07644902289397353336e-51, 3.81488530247580583856e-52, 1.09129014140136656216e-53, 7.74392547651622873974e-56, -2.41229963493829421309e-57, 3.92548439884756811778e-58, -7.80842800086068332321e-59, -2.1342708188924315002e-59, 4.19604081069617311682e-60, 1.07323804125277385616e-60, -2.17271475055752296009e-61, -5.31582705037426760826e-62, 1.09669781438513329017e-62, 2.59016922601483004781e-63, -5.39479764597989855938e-64, -1.24626029799519196655e-64, 2.5894492332901450639e-65, 5.94394909255805903051e-66, -1.21519812960576941196e-66, -2.81957141919251938486e-67, 5.59076249223649530167e-68, 1.33347327643567558116e-68, -2.5302388894342181951e-69, -6.29472802452055883654e-70, 1.13099614185830089705e-70, 2.96524273833827454524e-71, -5.01490594678637231948e-72, -1.39190664697697868224e-72, 2.21523131018119942302e-73, 6.4960240813664923546e-74, -9.78331144624801218347e-75, -3.00636384743123996054e-75, 4.3297338069437382005e-76, 1.37622510371966686011e-76, -1.92136499020355899784e-77, -6.21795125879526940828e-78},
            {-8.04287011331467986952e-31, -4.21752055424382160282e-28, 2.89406135927650384831e-28, 1.77662605687102439555e-27, -1.39543293031567925618e-27, -2.23791859250895986378e-27, 2.1804206817367256091e-27, 1.19819006475522963865e-27, -1.71627463584376088779e-27, -1.96356202081310908213e-28, 8.16400818860726076183e-28, -1.1859004055038564029e-28, -2.54612254525089748536e-28, 9.4557273567293804338e-29, 5.21332693141810741805e-29, -3.58745922850194239345e-29, -5.69754672671090203614e-30, 9.30917917594040019989e-30, -4.03209274176376371849e-31, -1.81643601021415881889e-30, 3.53211361770207598182e-31, 2.75024150940536654772e-31, -9.61176501764117193997e-32, -3.19039679542648844194e-32, 1.82457831928997023014e-32, 2.54538412095959396637e-33, -2.7494960577788354238e-33, -5.33252576923385439901e-35, 3.44857874251963970582e-34, -2.55301344383760730238e-35, -3.64955948337210600669e-35, 6.17625489702983850831e-36, 3.55245276809236812331e-36, -6.07636358650098180095e-37, 2.42136841845677036936e-38, 3.66787602985093575079e-37, 2.58463950917262876379e-37, 2.01387061042647462388e-37, 1.7190551383824178213e-37, 1.33246286244355396149e-37, 9.57193042440451765787e-38, 6.50703519624302226591e-38, 4.16474654559406469e-38, 2.49985264277529815666e-38, 1.40689295142560792746e-38, 7.41712241287288210975e-39, 3.65641640341804780535e-39, 1.68229937568796078786e-39, 7.20953492760471766358e-40, 2.87103093596835215835e-40, 1.05947175954302178277e-40, 3.61142422050144890731e-41, 1.13293550008952739334e-41, 3.25683213478529724763e-42, 8.5357887560012618134e-43, 2.02741394839589427088e-43, 4.33289218786639979951e-44, 8.260103123464125894e-45, 1.38982367407108359142e-45, 2.03699984747184488532e-46, 2.55773323571961924974e-47, 2.69215175580796824358e-48, 2.30506752843999905187e-49, 1.5349304279848180283e-50, 7.3590061891619476688e-52, 2.13421931195598740282e-53, 1.52768735301819671516e-55, -4.83811470073865012556e-57, 7.91812424448775627061e-58, -1.61345029537548107256e-58, -4.42487574873531428049e-59, 8.88989712114207121399e-60, 2.28749775843943583747e-60, -4.72777984614680669168e-61, -1.16420553792817230975e-61, 2.45045508497533727004e-62, 5.82479400031790849957e-63, -1.23730547513304987384e-63, -2.87569381927672969609e-64, 6.09384945591477349382e-65, 1.40625240690337236361e-65, -2.93329544583619621651e-66, -6.83418878496347111722e-67, 1.38368910077316529174e-67, 3.30874438697399687407e-68, -6.41805009286813884798e-69, -1.59772403929619402845e-69, 2.93873125789318287758e-70, 7.69355423811505797369e-71, -1.33400519670090835817e-71, -3.68935001935073607723e-72, 6.02835102723575375403e-73, 1.75804433580737625398e-73, -2.72141343074903850191e-74, -8.30370146327433879363e-75, 1.23003919804612439485e-75, 3.87795857815706301418e-76, -5.56983035886430977465e-77, -1.7869096759938828119e-77, 2.52415202732545431768e-78},
            {-1.25551400588990454264e-29, 1.72528376032777190771e-29, 1.56990539461923485061e-28, -1.63274977339251033418e-28, -3.29303315220583722088e-28, 3.81315107849394333561e-28, 2.48018967684687990327e-28, -3.99905911657910888704e-28, -5.4263591661546422117e-29, 2.37928275578965023864e-28, -3.65010963996504150021e-29, -8.92201463536430007069e-29, 3.52194072910688770331e-29, 2.14179980211622250083e-29, -1.55037801952438760439e-29, -2.72524786344366211822e-30, 4.57266797242655297866e-30, -1.89187378409523883923e-31, -9.99500399578465192368e-31, 2.00306676917158212757e-31, 1.67703289026599521685e-31, -6.05118326961307827375e-32, -2.13962607952179936104e-32, 1.25778817797595886792e-32, 1.87446443075936379848e-33, -2.05794488643808520347e-33, -4.71115205512493467102e-35, 2.78459968410287468204e-34, -2.06635678226653899712e-35, -3.16262650649984298094e-35, 5.44908217551874664564e-36, 3.29086510618985079835e-36, -5.70063989041987574692e-37, 2.34327817481556096534e-38, 3.70912006132800740785e-37, 2.6961720549515517974e-37, 2.15814735261375808101e-37, 1.89054332328291234762e-37, 1.5035899923399639285e-37, 1.1075511102649999199e-37, 7.71513494851638481588e-38, 5.05703338459142486898e-38, 3.10693060982991917973e-38, 1.78878220153826204499e-38, 9.64254637431878671161e-39, 4.85806633705684420138e-39, 2.28330220152936860945e-39, 9.99146479288052826579e-40, 4.06106147492336672297e-40, 1.52896254863076859575e-40, 5.31526869858247360239e-41, 1.69993292269033748074e-41, 4.98022916559932584171e-42, 1.3297772960154341974e-42, 3.21676253074985659641e-43, 6.99940954707591951318e-44, 1.35814643220663070627e-44, 2.3252683495356631382e-45, 3.46683706905763436493e-46, 4.42692958513869674733e-47, 4.73719640576618020939e-48, 4.1222401317360608624e-49, 2.78857775159405910003e-50, 1.35734683966084818738e-51, 3.99218657734632215906e-53, 2.88609115210493526747e-55, -9.27841697052805688164e-57, 1.52893650480195875792e-57, -3.19357633912634827403e-58, -8.79410228850835430478e-59, 1.80469909861261915458e-59, 4.67604459726165299403e-60, -9.86108679248152159282e-61, -2.44627793292836003959e-61, 5.25018173508714973969e-62, 1.25719456313506789611e-62, -2.72199906480674901165e-63, -6.37075114045116741496e-64, 1.37598423572822985217e-64, 3.19524259789299009888e-65, -6.79543986291124110259e-66, -1.5913872384295216333e-66, 3.28748086933838666742e-67, 7.88959509103374620255e-68, -1.56313432468397421972e-68, -3.89817893461450563639e-69, 7.33326404461827396201e-70, 1.91931604580847883556e-70, -3.40858554500081405996e-71, -9.40490673497197469275e-72, 1.57609901132776721913e-72, 4.57702859009340317012e-73, -7.27438967002802875508e-74, -2.20686042737542623105e-74, 3.35865177512918328334e-75, 1.0516859398642494845e-75, -1.55226069614872907291e-76, -4.94331954170735367118e-77, 7.17433597357663036804e-78, 2.28819152656344716913e-78},
            {5.12480701228836401188e-31, 9.00755472564177824286e-30, -1.39985256805448817015e-29, -3.76869774663383222565e-29, 5.41314492823221301861e-29, 4.2732887559679009055e-29, -7.93424537347928564025e-29, -1.28719712845236873129e-29, 6.06986936257458122484e-29, -9.94774508812512664576e-30, -2.78640557242963501763e-29, 1.17836630656328439432e-29, 7.94034962034447374821e-30, -6.08317634930084772742e-30, -1.18562285645635594395e-30, 2.05594516228464902174e-30, -8.09641037615712870571e-32, -5.06653079867537298039e-31, 1.04983056001511809542e-31, 9.46903615397820595438e-32, -3.53711559790009761248e-32, -1.33419400127148431833e-32, 8.08156778715708587642e-33, 1.28741353634619327775e-33, -1.44037150263672818501e-33, -3.83314174683206327948e-35, 2.10843488095426837651e-34, -1.56965086586091181397e-35, -2.57622396474760700974e-35, 4.52424660966535028195e-36, 2.87147934298971096409e-36, -5.04496936568366483534e-37, 2.11858379347260059472e-38, 3.54089682276566372387e-37, 2.65673258004141292409e-37, 2.18622532183859082036e-37, 1.96695944851751937308e-37, 1.60631459415347971869e-37, 1.21408544754178246787e-37, 8.67175810671144068532e-38, 5.82472425970103969503e-38, 3.66502682619939035982e-38, 2.15986567724250350103e-38, 1.19111702613498311241e-38, 6.13622025337903494113e-39, 2.94758872286406761891e-39, 1.31764703169385734263e-39, 5.46871620012285405887e-40, 2.10153441337753084728e-40, 7.45391734496809460436e-41, 2.43133163670374941351e-41, 7.2619853005791020345e-42, 1.97617723873773579228e-42, 4.87035420370989978024e-43, 1.07933673278389187473e-43, 2.13236110886008727835e-44, 3.71598979402342284825e-45, 5.63758409748566188799e-46, 7.32302294679074889848e-47, 7.9689520670502001631e-48, 7.04941939705778584692e-49, 4.84570060090473832413e-50, 2.39527363407083377052e-51, 7.14691155237741183859e-53, 5.22426917804941653502e-55, -1.70320711601686368903e-56, 2.82742077980489122413e-57, -6.05840904050620790287e-58, -1.67629444628573112858e-58, 3.51257559131161226867e-59, 9.17256784555990761938e-60, -1.97275521374560486869e-60, -4.93452720542633553338e-61, 1.07929956600416493408e-61, 2.60581950434602861111e-62, -5.74757879664453350917e-63, -1.35583516888115953996e-63, 2.98300398820623360945e-64, 6.97676933315255668795e-65, -1.5118835689463665303e-65, -3.56213745427516639543e-66, 7.50301939381183233283e-67, 1.80893437420057488667e-67, -3.65794417317005990464e-68, -9.14795465672782033945e-69, 1.75863014730124190474e-69, 4.60668648382961982558e-70, -8.37179750657261525461e-71, -2.30726175829770492867e-71, 3.96172335381446338991e-72, 1.14705614865999997001e-72, -1.86984461288743709191e-73, -5.64714937178367151858e-74, 8.8209424807823577411e-75, 2.74674930692319260863e-75, -4.16192913072057888348e-76, -1.31728205651487434156e-76, 1.96229018869315412904e-77, 6.21934686636108279807e-78, -9.22576842114505477077e-79},
            {2.52732673909729038038e-31, -7.84350827782228780779e-31, -3.14795635950206204564e-30, 5.9960272906031134396e-30, 5.96300063714099842091e-30, -1.31426801421677162447e-29, -2.58340438523860169735e-30, 1.33990430624109385011e-29, -2.3794008452566490524e-30, -7.69784531130988997706e-30, 3.51995270132868479512e-30, 2.64281872047866261627e-30, -2.15771048111401271695e-30, -4.67495970529697809972e-31, 8.43485242993358423501e-31, -3.14873081910713454387e-32, -2.36045960364391678773e-31, 5.07525282032009617292e-32, 4.94207703560401145651e-32, -1.91683735096146828776e-32, -7.7254178017002273624e-33, 4.83438284595950564237e-33, 8.23875534675109545909e-34, -9.41917976191677525106e-34, -2.87992814050772161012e-35, 1.49612270870363453228e-34, -1.11853866722686752468e-35, -1.97178525801899706508e-35, 3.53392325693152187196e-36, 2.35934955344732112847e-36, -4.21076966525649062099e-37, 1.78974364756350713701e-38, 3.1909482345208045623e-37, 2.47289546740229482553e-37, 2.09363009703252589854e-37, 1.93623524566055956472e-37, 1.62485871018251646427e-37, 1.26103504389602349902e-37, 9.24183531082752713136e-38, 6.36536594449566047762e-38, 4.10448316984993029458e-38, 2.47734482991953363703e-38, 1.39846208086904096481e-38, 7.37062355026856891413e-39, 3.62041343747229598778e-39, 1.65412840001845003645e-39, 7.01350014015442325706e-40, 2.75216618119329488913e-40, 9.96389751690467117261e-41, 3.31605067748664199131e-41, 1.01017796869660811918e-41, 2.80268548183443451761e-42, 7.0398258634941977221e-43, 1.58951349495961657812e-43, 3.19839598703894537087e-44, 5.67508972808858519346e-45, 8.76360581176260633843e-46, 1.15833944813178892823e-46, 1.28221391240125243814e-47, 1.1533725899823725275e-48, 8.05824458964726777324e-50, 4.04619724283574369702e-51, 1.22518164420048875929e-52, 9.06541350853111230438e-55, -2.99550508718593993643e-56, 5.00973288920467877375e-57, -1.10205815701300100374e-57, -3.0661110716750792838e-58, 6.55841688797479955671e-59, 1.7275025074044445842e-59, -3.78746916147061357847e-60, -9.5603893265911582356e-61, 2.13010479211746505073e-61, 5.18963796423396882054e-62, -1.16553031950147391633e-62, -2.77348789292500585933e-63, 6.21259742251735120729e-64, 1.4647156790118958903e-64, -3.23238603444834994137e-65, -7.66890285997905543766e-66, 1.64598917168087670895e-66, 3.99036468242776249649e-67, -8.23000916641404027296e-68, -2.06603013863549429162e-68, 4.05575081233093227156e-69, 1.06439959183645696889e-69, -1.97776902990467275833e-70, -5.45043413459624336134e-71, 9.58052083974812519311e-72, 2.76878931861424424977e-72, -4.62501693219744303985e-73, -1.3921774107612513975e-73, 2.22978591467968202863e-74, 6.91296282489584014216e-75, -1.0743045206726229006e-75, -3.38335415666337470414e-76, 5.16839617955532179884e-77, 1.62966217864494096836e-77, -2.47787306402160538962e-78, -7.71805340407377597929e-79},
            {-2.17094187894648578148e-32, -1.70792738728560403399e-31, 4.86624899185230091025e-31, 6.47405658164338713454e-31, -1.76881370235471201392e-30, -4.30182629870079214743e-31, 2.52143394528703712826e-30, -4.93960346395648508569e-31, -1.86383711143530870917e-30, 9.31772539903687392592e-31, 7.84812104550595682818e-31, -6.88307559331038523059e-31, -1.66361893862403576821e-31, 3.14598694621880050315e-31, -1.10794213776022129187e-32, -1.00798523216687405335e-31, 2.25792258688733083616e-32, 2.37938228476713716304e-32, -9.61358664454229112262e-33, -4.14740213035178966227e-33, 2.68883567489817104709e-33, 4.90692109431519107073e-34, -5.74924231460776098465e-34, -2.00114698116064206404e-35, 9.94156304805086268869e-35, -7.47302136953568882073e-36, -1.4172071175966642275e-35, 2.59577660432621978917e-36, 1.82473272162315649658e-36, -3.31360175547065530477e-37, 1.41233310915497705381e-38, 2.7140961662349245144e-37, 2.17412462293952269732e-37, 1.8953199042405387361e-37, 1.80334218850411274381e-37, 1.55633949274310702939e-37, 1.24117501467318327733e-37, 9.33999291631840781224e-38, 6.60089428414880572383e-38, 4.36466210483760856382e-38, 2.69974667742355444021e-38, 1.56090830734752722817e-38, 8.42131520776739749643e-39, 4.23207084156917363822e-39, 1.97725968967181893703e-39, 8.56879817585287944986e-40, 3.43519017191383074517e-40, 1.270005817454533365e-40, 4.31435265602570329809e-41, 1.34102243584172091352e-41, 3.79480327530344568706e-42, 9.71837251061262757836e-43, 2.23644815849609734438e-43, 4.58502435489348037247e-44, 8.28615623463692066198e-45, 1.30284520000105436677e-45, 1.75280438139071235492e-46, 1.9742318019805197503e-47, 1.80628205728076780515e-48, 1.28304666034112212429e-49, 6.546050741174475762e-51, 2.01220932145360649602e-52, 1.50860216281894222104e-54, -5.05200405944924499955e-56, 8.50837011491035196247e-57, -1.92308073240140683659e-57, -5.38390303198799740645e-58, 1.17528643586080562636e-58, 3.12510458292053698956e-59, -6.98198978486544692096e-60, -1.77993536156868910201e-60, 4.03815363880727741981e-61, 9.93558723213019649946e-62, -2.27112041085075466302e-62, -5.45589100719713516587e-63, 1.2436911359740129929e-63, 2.95815817410600434607e-64, -6.64473840387753928077e-65, -1.58879450444811207067e-65, 3.47285345514394492061e-66, 8.47327966070127591654e-67, -1.78131779193698105178e-67, -4.4929377203395304541e-68, 9.00010837947180907789e-69, 2.36879988563600847944e-69, -4.49686119137146621213e-70, -1.24049179384387916687e-70, 2.23031995957932932558e-71, 6.44078650964815386354e-72, -1.10151902434950074901e-72, -3.30836258588422804517e-73, 5.428549894446125245e-74, 1.67751557936875988775e-74, -2.67139746989888664868e-75, -8.3805412582651024323e-76, 1.31170348711412109054e-76, 4.11908152864212475244e-77, -6.41434725386462128728e-78, -1.99001583601064238322e-78, 3.11572576060206888022e-79},
            {-4.52834109165666909381e-33, 2.57867551883040215753e-32, 5.13030083135353353851e-32, -1.85882374985859055965e-31, -5.78254135051241088352e-32, 3.96554146072219962803e-31, -8.77306517815849322418e-32, -3.90921137171397740119e-31, 2.16565858377715752246e-31, 2.06369073996183325015e-31, -1.96242534267993786073e-31, -5.31554137932859833995e-32, 1.06203165581001367821e-31, -3.50878373646558860433e-33, -3.93266691018346537455e-32, 9.21923141801322440175e-33, 1.05421183125052560483e-32, -4.45301157469230300721e-33, -2.06060082694998553337e-33, 1.38829674978219607945e-33, 2.71624598571596542382e-34, -3.27148782564939469617e-34, -1.28696573045597284331e-35, 6.18052053645753131036e-35, -4.67762287475370294674e-36, -9.55882706116130333045e-36, 1.79198480920294793788e-36, 1.32771956765203105016e-36, -2.45751558156331897546e-37, 1.04033756931695893318e-38, 2.17831646363645690988e-37, 1.8051148209019910027e-37, 1.62176722046636579172e-37, 1.58898741862058237694e-37, 1.4114973910152621085e-37, 1.1576232895450431855e-37, 8.95134220177045387075e-38, 6.49596981024402660571e-38, 4.40755086152751931115e-38, 2.79571213224075634036e-38, 1.65654023742800138725e-38, 9.15389845941125137155e-39, 4.70911300231008015469e-39, 2.25102187809278901555e-39, 9.97577014726556588254e-40, 4.08769674960412123028e-40, 1.54395716602543931831e-40, 5.35619049531592798154e-41, 1.69943606136947586042e-41, 4.90695272671857709294e-42, 1.28174789088888333978e-42, 3.00741666396820266419e-43, 6.28415847916590123124e-44, 1.15712133564838948539e-44, 1.85306703458055533047e-45, 2.53837706510886992625e-46, 2.9099922452905767585e-47, 2.70884110687472037004e-48, 1.95681483094825034883e-49, 1.01471467685298305336e-50, 3.16760689046734112748e-52, 2.40846277733891202117e-54, -8.17706283183174229084e-56, 1.3856932166610175414e-56, -3.22032391105042881502e-57, -9.07936230426408956949e-58, 2.02236336887605249109e-58, 5.43267705364838666673e-59, -1.23643574528192770232e-59, -3.18583057019264495192e-60, 7.35700126274666436626e-61, 1.82940409582440774385e-61, -4.25454111591687617648e-62, -1.0325836454563051367e-62, 2.39438853160973736152e-63, 5.74993015045705946957e-64, -1.314044090400571756e-64, -3.16899690683094656296e-65, 7.05093836868766447099e-66, 1.73280930273492558765e-66, -3.71105622549743840077e-67, -9.41281700099354602075e-68, 1.92285196489014020061e-68, 5.08015768292961911644e-69, -9.84615812073266346293e-70, -2.72148411138392734608e-70, 5.00113551521072815314e-71, 1.44462489770242200593e-71, -2.52752297924300687008e-72, -7.58247593732436441564e-73, 1.27359966547240458803e-73, 3.92694557780592558814e-74, -6.4030289035891448114e-75, -2.00301361740008826649e-75, 3.2096754964275570467e-76, 1.00481655647915466241e-76, -1.60133208375513212002e-77, -4.95314241803767659148e-78, 7.93172020568610023738e-79, 2.39841079100968782688e-79},
            {6.73266214159535532031e-34, 2.63889141313418047118e-33, -1.43185054220881369505e-32, -6.0257999073775828928e-33, 5.07189923161773745483e-32, -1.30782251183322694891e-32, -6.99662487673936614205e-32, 4.36852742831541616651e-32, 4.7603545790114947045e-32, -4.96285245972830140323e-32, -1.51551338049250298917e-32, 3.22803131335850519877e-32, -9.93814725195235478655e-34, -1.3965307372849665579e-32, 3.443732480268000828e-33, 4.2862863869796142579e-33, -1.90038926473819944506e-33, -9.45486523330060432353e-34, 6.64196434003404750044e-34, 1.39523544123074896186e-34, -1.73302285809808110673e-34, -7.66118292155734727529e-36, 3.59093078239636750608e-35, -2.74068922985079171287e-36, -6.04521873540568417346e-36, 1.16187312037261668677e-36, 9.0832475429984932106e-37, -1.71680939402082959697e-37, 7.14473878049731012634e-39, 1.64912541512962274791e-37, 1.41496336507836084944e-37, 1.31136343894324366015e-37, 1.32437671665979817292e-37, 1.21196328843177402988e-37, 1.02304623256174188882e-37, 8.13515101778244435326e-38, 6.06659961579940880516e-38, 4.22679729351714427556e-38, 2.75119281404804951086e-38, 1.67171861936426403314e-38, 9.46744863563108273804e-39, 4.98858825927822673152e-39, 2.44111448798982403004e-39, 1.10686484473128223553e-39, 4.63817600077273330316e-40, 1.79066733856850297839e-40, 6.34668510833755240176e-41, 2.0564401992150737279e-41, 6.06122996515434209118e-42, 1.61552640883934347201e-42, 3.86633492704583170605e-43, 8.2373088247072385405e-44, 1.54593848692467319027e-44, 2.52246493536190792893e-45, 3.51930041920160098872e-46, 4.10770229083114093978e-47, 3.89157909618133957682e-48, 2.85975989572161266719e-49, 1.5076926513784309085e-50, 4.78133997608591187497e-52, 3.68989104661755876171e-54, -1.27111470920652616963e-55, 2.16498916248413151822e-56, -5.17671322560158060198e-57, -1.47104023785662542501e-57, 3.34292354657270614677e-58, 9.07895368462865665225e-59, -2.10434330086886313309e-59, -5.48410715436527191666e-60, 1.28869722661749438343e-60, 3.24089767276028158546e-61, -7.66588327273907665399e-62, -1.88100219017736503463e-62, 4.43532327059452793583e-63, 1.07613136212526011994e-63, -2.50109405815425903303e-64, -6.08818316391319527333e-65, 1.37823676099601260698e-65, 3.41433435182307804255e-66, -7.44541571912951891488e-67, -1.90065564410678034337e-67, 3.95722273601779725236e-68, 1.0503970869046287991e-68, -2.0771928774288488024e-69, -5.75800785012812156179e-70, 1.08075355320997612625e-70, 3.12569697788836475097e-71, -5.59060878664270917356e-72, -1.67687081335980571259e-72, 2.88104054315113032097e-73, 8.87243958783291551993e-74, -1.48016050069115216013e-74, -4.62167426021253535979e-75, 7.57658872596738016422e-76, 2.3668758451692057067e-76, -3.85751834674484347999e-77, -1.1906976676868271314e-77, 1.94886321400139090635e-78, 5.88224618080983370476e-79, -9.74461445349973624377e-80},
            {6.61817315323230685946e-35, -7.20102495995764774855e-34, -4.56213525745829696735e-34, 5.06898617009058167139e-33, -1.59374002731455233971e-33, -1.04752221648869237922e-32, 7.53465865776983291345e-33, 9.52011607938124955486e-33, -1.10289740919903683262e-32, -3.82641850285105356356e-33, 8.77841212071616019817e-33, -2.49816923718366326313e-34, -4.49365226437490679549e-33, 1.17241821150051947629e-33, 1.59403232894920186153e-33, -7.4512345813194270302e-34, -3.99658870063157109961e-34, 2.93817360393045070519e-34, 6.63796194531774130536e-35, -8.53244600888311373984e-35, -4.2198100766411427142e-36, 1.94737089343531472037e-35, -1.50159273174161807452e-36, -3.58119682804584884827e-36, 7.06936499036495811551e-37, 5.83815808694536124036e-37, -1.1290137825704830783e-37, 4.56682199608643454357e-39, 1.17712881070625088474e-37, 1.04674280356687323145e-37, 1.00172801778576650325e-37, 1.04385167178261186568e-37, 9.85013431649959264404e-38, 8.56539298426666959295e-38, 7.01016057966976359433e-38, 5.37617070119943558266e-38, 3.84924032177150551231e-38, 2.57279701069028906866e-38, 1.60424711804634549751e-38, 9.31715583819713376428e-39, 5.03156440883780294381e-39, 2.52193728022795172782e-39, 1.17063022309571253978e-39, 5.01904602592824401346e-40, 1.98161011676747343147e-40, 7.17910286084797500511e-41, 2.37661723561487300434e-41, 7.15373105086977705754e-42, 1.94639687864757167056e-42, 4.75320347684850996668e-43, 1.03293353931302953775e-43, 1.97658246791647203382e-44, 3.28717114368896986778e-45, 4.67268954155634174105e-46, 5.55466194911523533832e-47, 5.35742168533899575374e-48, 4.00617903550932806199e-49, 2.14802437468380263327e-50, 6.92283449692591702927e-52, 5.42632060425056327929e-54, -1.89890026151170363467e-55, 3.24630865430970259026e-56, -7.99075965302391381634e-57, -2.29062300603529660331e-57, 5.31017924285418090271e-58, 1.45909687168330426745e-58, -3.44340549932400576451e-59, -9.08267520573834670116e-60, 2.17126427602943532745e-60, 5.52618557502428773633e-61, -1.32908703168827069349e-61, -3.29934239413210392145e-62, 7.90850401917829660971e-63, 1.94000709381211556304e-63, -4.58387643947282405989e-64, -1.12704982351819309164e-64, 2.5948771213063809697e-65, 6.48483236111453179542e-66, -1.43919630585181649314e-66, -3.70055382012581690381e-67, 7.84857246595637009639e-68, 2.0948140300487267756e-68, -4.22428176461431759884e-69, -1.17539691356002644545e-69, 2.25194899318029276439e-70, 6.52692386361186761595e-71, -1.19262653283783699548e-71, -3.57994183535855193703e-72, 6.28718378585379472677e-73, 1.93566836432969987289e-73, -3.30166777313288122056e-74, -1.02996102903445172924e-74, 1.72623309046887306102e-75, 5.38606117647537523913e-76, -8.97137564619005876951e-77, -2.76583081580309507036e-77, 4.62411387377166850272e-78, 1.39430637499694523343e-78, -2.3578914143160940366e-79, -6.90198828550716376358e-80},
            {-1.7822685385526068428e-35, -2.22624514526001946384e-35, 3.71538111084911729223e-34, -1.52753731595495309723e-34, -1.27642395019625804695e-33, 1.08941784988307792883e-33, 1.625889718025102776e-33, -2.12866768851265466157e-33, -8.47551702210476451179e-34, 2.11954765514132526653e-33, -5.52076044677546430817e-35, -1.30323278327427099017e-33, 3.62182811306223360556e-34, 5.40134391622781969892e-34, -2.67535548223721112444e-34, -1.55184976618821535436e-34, 1.19879692345239826039e-34, 2.9187066806896093806e-35, -3.89695595736831941292e-35, -2.14876365402087366465e-36, 9.84258282161640623731e-36, -7.68384283609641410044e-37, -1.98497056321443272424e-36, 4.03249775230084258171e-37, 3.52227567388826650685e-37, -6.9838499216600002752e-38, 2.71011375924965195083e-39, 7.91743325749818094188e-38, 7.30429497068611395434e-38, 7.2258627969150679162e-38, 7.77767221603142407443e-38, 7.57547926745552540876e-38, 6.79231694943448868362e-38, 5.72651489017468836709e-38, 4.52023691223159765991e-38, 3.32843081401044062168e-38, 2.28619504397609757745e-38, 1.46388959842922560683e-38, 8.72474980439174084667e-39, 4.8319623186152757689e-39, 2.48220771615298495887e-39, 1.18019220275559093143e-39, 5.18014080753836640195e-40, 2.09264539691831760267e-40, 7.75327232185580071277e-41, 2.62362610508792156345e-41, 8.06868646338561900343e-42, 2.24200911041127332805e-42, 5.58912804568124755194e-43, 1.23937981034075712051e-43, 2.41907592635840506611e-44, 4.10195610605887757629e-45, 5.94294820450015861582e-46, 7.19759556462303817962e-47, 7.06965863210264672566e-48, 5.38124028701190902204e-49, 2.93533943743660947761e-50, 9.61771505202641777491e-52, 7.66138678939339321359e-54, -2.72763471764027601137e-55, 4.67353856133566870325e-56, -1.1847141091274629814e-56, -3.42908898959546666002e-57, 8.10876518679420950325e-58, 2.25578798201276310678e-58, -5.41931465469680399455e-59, -1.44774337323098754957e-59, 3.52006313856259033339e-60, 9.07278824624423223761e-61, -2.21817597724669772822e-61, -5.57435999850510630627e-62, 1.3579274570852207308e-62, 3.37005193987660466384e-63, -8.09279149007623383732e-64, -2.01118518820427829054e-64, 4.70771874384857653738e-65, 1.1876725879527115292e-65, -2.68151519801905991425e-66, -6.94993746050477524455e-67, 1.50086099608720797934e-67, 4.03114020181092623037e-68, -8.28501660351006597935e-69, -2.31590490058200688115e-69, 4.52654203044436018031e-70, 1.31589496934977883768e-70, -2.45491693609002553667e-71, -7.38115224392300468884e-72, 1.32422413007493391697e-72, 4.07948530937917758797e-73, -7.10999463755441378001e-74, -2.21787804096739169316e-74, 3.79795478431087084396e-75, 1.18458436959820796418e-75, -2.01533383457648944989e-76, -6.21079499002136056986e-77, 1.06003967389276209372e-77, 3.19569085284640295286e-78, -5.51359152018340581746e-79, -1.61409559929112818461e-79, 2.8294182253752082361e-80},
            {-5.22717328483371091366e-37, 1.77819554976177154048e-35, -1.0829402468340894759e-35, -1.21615980268290757294e-34, 1.28499756519144833383e-34, 2.32434270166422100373e-34, -3.51487144816120581026e-34, -1.62761334904596679488e-34, 4.50113884427230693439e-34, -1.06004688978890803508e-35, -3.38490878195747846811e-34, 1.009894657623929559e-34, 1.66005827970291648794e-34, -8.76250170771972954357e-35, -5.51675073231353776373e-35, 4.4982924385045139807e-35, 1.18310656965554150335e-35, -1.64741698984522584579e-35, -1.01024878444563857066e-36, 4.62858366997463696295e-36, -3.66717050998874802099e-37, -1.02804455895889795596e-36, 2.15398992938559447494e-37, 1.99265605039046458588e-37, -4.0599228741193097282e-38, 1.48802395860214113145e-39, 5.01460525815988429971e-38, 4.80509315766224767436e-38, 4.91948132436169026909e-38, 5.47583212783826404007e-38, 5.51095089134207953635e-38, 5.09994251598769393516e-38, 4.43336614592376768594e-38, 3.60504871306312989905e-38, 2.73228032861361181754e-38, 1.93010984095510550422e-38, 1.27007133212795060639e-38, 7.7733886993027404319e-39, 4.41795627984043612748e-39, 2.32752629365316140107e-39, 1.13422789146069452869e-39, 5.09948172986463254345e-40, 2.10899267029266772867e-40, 7.99519263272965670522e-41, 2.76688110695124496997e-41, 8.69813458299802304825e-42, 2.46941739264427240969e-42, 6.28698390962708033824e-43, 1.42317519855432375421e-43, 2.83451932707998930755e-44, 4.90253905943965172046e-45, 7.2419795607952728723e-46, 8.93902441321982186926e-47, 8.9446041618021066533e-48, 6.93263926611100448008e-49, 3.84847056526373788668e-50, 1.28243056803303676361e-51, 1.03871130977534126423e-53, -3.7690541555523660572e-55, 6.46248187832624884918e-56, -1.68744487390393289685e-56, -4.93656027910782653219e-57, 1.19067962560162329966e-57, 3.35586132783047058689e-58, -8.2059390230475008104e-59, -2.22162614520303104201e-59, 5.49305311935054503957e-60, 1.4346581801254497983e-60, -3.56488178341891248408e-61, -9.07474445344450626525e-62, 2.24611751317979013954e-62, 5.64302484176621870582e-63, -1.37686703916842257914e-63, -3.46071355706346265481e-64, 8.23333109423070688166e-65, 2.09823944067412181727e-65, -4.81775908518001909875e-66, -1.25951898102998622991e-66, 2.76834343331711566089e-67, 7.48795189849764940967e-68, -1.56777141940514742598e-68, -4.40601869334354658245e-69, 8.78089935507723376651e-70, 2.56243942755296027303e-70, -4.8780668565916115183e-71, -1.47033351735782957769e-71, 2.6931449403497491778e-72, 8.30884777287880226095e-73, -1.4788117965199471232e-73, -4.61665126267686678621e-74, 8.0727719321360482586e-75, 2.51906415241168872109e-75, -4.37492819775841142615e-76, -1.34880185138576267037e-76, 2.34888729239802335571e-77, 7.08511444692233680934e-78, -1.2465162470420907335e-78, -3.65217656056193421483e-79, 6.52420173450498853112e-80, 1.8488248730431430563e-80},
            {4.18517719960772281121e-37, -5.07567638560247278601e-37, -8.50180089119775971535e-36, 1.18833952376793675964e-35, 2.70582758518021018678e-35, -4.86735139256822175279e-35, -2.66902620935521994283e-35, 8.30848407927943547685e-35, -1.74243049761836932089e-36, -7.81298479088411828219e-35, 2.52571541619773596218e-35, 4.60281571172825758616e-35, -2.60614166551577779069e-35, -1.7885138329260940992e-35, 1.54712656280234725494e-35, 4.40828453999808646793e-36, -6.42987916077889653938e-36, -4.3779752594398371338e-37, 2.021221024046384978e-36, -1.62970473738871171096e-37, -4.96748836738691086173e-37, 1.07600648620257327859e-37, 1.05579959038229684038e-37, -2.21571235255670596033e-38, 7.52233344232577162935e-40, 2.98833173881576347136e-38, 2.97784464137115834905e-38, 3.15913836436150832107e-38, 3.64085288830895298115e-38, 3.79039397915735107e-38, 3.62417907410527277956e-38, 3.2516426654511173367e-38, 2.72640754419375917016e-38, 2.12873127784519595739e-38, 1.54781636099326927676e-38, 1.04750422554612585176e-38, 6.58865576277959304396e-39, 3.84549960784883400137e-39, 2.07909130309210166218e-39, 1.03907064407346042766e-39, 4.78816419248789136985e-40, 2.02843892377353413875e-40, 7.87258871270973202365e-41, 2.7877267366297658018e-41, 8.96265601201642385266e-42, 2.60103070003960325989e-42, 6.76599827422073061609e-43, 1.56420008007549345855e-43, 3.18031290616235987938e-44, 5.61286167344333290831e-45, 8.45690124860453962592e-46, 1.06426588917091058518e-46, 1.08526127446548933237e-47, 8.56791560598302671045e-49, 4.8420591071064299125e-50, 1.64162363883918513298e-51, 1.35247376459863278386e-53, -5.01180410726299486959e-55, 8.58666783826125805108e-56, -2.30952996883134348811e-56, -6.83603227344116234193e-57, 1.68169400841794448963e-57, 4.80522877286133282768e-58, -1.1958280006951725809e-58, -3.28299729608935123e-59, 8.25350427105951033859e-60, 2.18561058054083815244e-60, -5.51877023450354609818e-61, -1.42388577886693798196e-61, 3.58021428441730970864e-62, 9.1109535232692120534e-63, -2.25821916168245466718e-63, -5.74410988394982310546e-64, 1.38857491565355734897e-64, 3.57698112481958437494e-65, -8.34981161119589085582e-66, -2.20335750476418275296e-66, 4.92715260832064620056e-67, 1.34307814196869869477e-67, -2.86346690738633619271e-68, -8.09683260610912913866e-69, 1.6445648965803797889e-69, 4.82128362341844027008e-70, -9.3608618591214301821e-71, -2.83081238754990778662e-71, 5.29093171423704674478e-72, 1.63606346325249359911e-72, -2.97199287902203622046e-73, -9.29297192636663400109e-74, 1.65845346508326638988e-74, 5.18154294846656888651e-75, -9.18157820760158512231e-76, -2.83399428562943103798e-76, 5.03310874337178241537e-77, 1.52011766677419577753e-77, -2.72585366307279494105e-78, -7.99864524959333981571e-79, 1.45546125940441228036e-79, 4.13192764539488531796e-80, -7.64824830714077268619e-81},
            {-1.19382527675973837923e-38, -3.88110908063618472884e-37, 8.08956361684776712766e-37, 2.46393964140437421718e-36, -5.4998721598666965196e-36, -3.66301072887422949716e-36, 1.31299850178732223768e-35, -2.40595224506498222343e-37, -1.58747536745378267175e-35, 5.6225121015262517246e-36, 1.14394829593744102941e-35, -7.00096142646468433798e-36, -5.26358004354456111918e-36, 4.85823554721915168923e-36, 1.50472359774421967078e-36, -2.31018079257407442881e-36, -1.74499187268114295886e-37, 8.17761516197619709516e-37, -6.73139960637492510486e-38, -2.23545655606065340842e-37, 5.01911661078232675243e-38, 5.23205370156965616123e-38, -1.13385624731252331328e-38, 3.47592991116083384355e-40, 1.67398022369353398141e-38, 1.73706882323407835804e-38, 1.91213426302132895851e-38, 2.28468340180872510816e-38, 2.46339620685979023132e-38, 2.43630725278969174638e-38, 2.2584291678402662603e-38, 1.95449012797619250561e-38, 1.57355675478758572416e-38, 1.17869768278973868336e-38, 8.21083528056163497173e-39, 5.31160558284220778094e-39, 3.18601123844006224715e-39, 1.76896656624551792121e-39, 9.07288493279667084446e-40, 4.2878713335724106308e-40, 1.8618269788333603863e-40, 7.40193171890826323164e-41, 2.68340058453786838151e-41, 8.82772421509020530983e-42, 2.620073240720936059e-42, 6.96697531461782231679e-43, 1.64568163320341431552e-43, 3.41718051716187974681e-44, 6.1565176063723906778e-45, 9.46509420073323736876e-46, 1.21488488663932009e-46, 1.26296669178388334762e-47, 1.01599607286358068557e-48, 5.84748832764596057805e-50, 2.0178037293100084406e-51, 1.69144268975081591086e-53, -6.41479478940160397747e-55, 1.09671611294280578845e-55, -3.03789556528811436615e-56, -9.10794944472018191047e-57, 2.28514742498987532937e-57, 6.62412965179835669922e-58, -1.67757048041393024189e-58, -4.67300533431433800673e-59, 1.1943909888089964361e-59, 3.20867579343566231346e-60, -8.23220057855335213926e-61, -2.15394586627629496567e-61, 5.50098280066828708794e-62, 1.41877903135611603426e-62, -3.57157759303148221054e-63, -9.19920931373050158934e-64, 2.25910482805459300969e-64, 5.88590153415066327994e-65, -1.39644776037166926682e-65, -3.7218346343093276349e-66, 8.46492214490885775643e-67, 2.32692153468353482786e-67, -5.04987246955067206624e-68, -1.437705123200727347e-68, 2.97485178808414372378e-69, 8.76787532759850394488e-70, -1.73543058550455796742e-70, -5.26937239623157079472e-71, 1.00449514551981103457e-71, 3.11555471347481485892e-72, -5.77358032790634938905e-73, -1.8095686566716883055e-73, 3.29431257002264744285e-74, 1.0312950662605201686e-74, -1.86363516105361154423e-75, -5.76314262606705603103e-76, 1.04332708053277188839e-76, 3.157313643356962544e-77, -5.76800354291152398789e-78, -1.69623997788325863979e-78, 3.14264480393705739116e-79, 8.94350209548109893243e-80, -1.68456960978071261269e-80, -4.63357970798659486682e-81},
            {-8.70595718684482849704e-39, 3.61234381389449853458e-38, 1.64644403516910713923e-37, -4.87234087489002623203e-37, -4.09230003671354909966e-37, 1.74125400302994433731e-36, -2.72487158272307897731e-38, -2.80580113029342033152e-36, 1.10365295055010456138e-36, 2.52865665347979247551e-36, -1.68779091740991316556e-36, -1.39858713754150446667e-36, 1.38646664859231509501e-36, 4.68671871798099639953e-37, -7.61469452346183743095e-37, -6.38044757842955171252e-38, 3.05745675498032805248e-37, -2.57865676428184262183e-38, -9.35033162346506293854e-38, 2.18234587015955089586e-38, 2.42114019339719644983e-38, -5.43314922896732630101e-39, 1.45151500851216116421e-40, 8.80497365030032162373e-39, 9.52855953734532941981e-39, 1.0899245877979902146e-38, 1.35203461129122442571e-38, 1.51175837810470159118e-38, 1.54836080805494495992e-38, 1.48461739895782146338e-38, 1.32750659219215615424e-38, 1.10314445998611203332e-38, 8.52071892472683311404e-39, 6.1148929989607307808e-39, 4.07176396066161307549e-39, 2.51193153579191538841e-39, 1.43334842560954457172e-39, 7.54979665700889462158e-40, 3.66177760800194993032e-40, 1.63067664883170018443e-40, 6.64483232759071946291e-41, 2.46763030812336572795e-41, 8.31105663884085179806e-42, 2.52407402862968068187e-42, 6.86423788762907766433e-43, 1.65744936678754442342e-43, 3.51643852983195689978e-44, 6.47009170731791601453e-45, 1.01541270277767343214e-45, 1.32983037429712628908e-46, 1.40991094047496978201e-47, 1.15614742281878065879e-48, 6.77915632325912367342e-50, 2.38189263720457320031e-51, 2.03196526251492749786e-53, -7.90439914475152497939e-55, 1.34703033779961023078e-55, -3.84101176558547342337e-56, -1.16779511202219459324e-56, 2.98804309315008209213e-57, 8.79299323268456314223e-58, -2.26603403397715274833e-58, -6.4082915182871953619e-59, 1.66512842797115234338e-59, 4.54054329171113213001e-60, -1.18353716445512780842e-60, -3.1420946858599663352e-61, 8.1498202621899696839e-62, 2.13145407634659771064e-62, -5.44880592168581901371e-63, -1.4218866879872501435e-63, 3.54657729348791924797e-64, 9.35114021523930140521e-65, -2.25437851578157688906e-65, -6.07219391657761362724e-66, 1.40424642188170219084e-66, 3.89522777533871148687e-67, -8.60190062574735772005e-68, -2.46741586142791520432e-68, 5.1991570752466941304e-69, 1.54164398166765164971e-69, -3.10939930742725925136e-70, -9.48632274950903015964e-71, 1.84358970832409098997e-71, 5.73968616754927425379e-72, -1.08458894792355263665e-72, -3.40983096815026320098e-73, 6.32949586486421797896e-74, 1.98681689510798205187e-74, -3.65986559088620821524e-75, -1.13469440084100231252e-75, 2.09305017610611659418e-76, 6.35068081189806768646e-77, -1.18149852282995054153e-77, -3.48432232085542517286e-78, 6.57020522488982561861e-79, 1.87549730102003318261e-79, -3.59338228020210181462e-80, -9.91639056771081853543e-81, 1.93057833457174914192e-81},
            {7.98374345814140747061e-40, 7.18210171968164667598e-39, -3.17618210422693785296e-38, -3.5741111295960893133e-38, 1.88522481887051735974e-37, -2.4606736494813450723e-39, -4.24873929533783138732e-37, 1.8879292956796155855e-37, 4.92407403403231104258e-37, -3.62335376893298885811e-37, -3.33348764959074371548e-37, 3.57650792683887738441e-37, 1.3258446989587911628e-37, -2.29350242545716906861e-37, -2.13342216145656278144e-38, 1.0532152092334197871e-37, -9.1391879782660964052e-39, -3.62676927738747671009e-38, 8.82748562396786703764e-39, 1.04434432121734563945e-38, -2.43393682978751542067e-39, 5.37089984537986036298e-41, 4.34329994417799354252e-39, 4.90965103019069727987e-39, 5.84485648583065786639e-39, 7.53885846653957019596e-39, 8.75361052685515778936e-39, 9.29663531643260730136e-39, 9.23116277934535457498e-39, 8.53807778046823898935e-39, 7.33091204404555019947e-39, 5.84457773241970446605e-39, 4.32509321856868275156e-39, 2.96703838492653954345e-39, 1.88412384411108943175e-39, 1.10576495669639042758e-39, 5.98582044691441102692e-40, 2.98156134315189754776e-40, 1.36265362228731260414e-40, 5.69488867672020097351e-41, 2.16768787295498132047e-41, 7.47882076266197804259e-42, 2.32538999499635832369e-42, 6.47098120188700292766e-43, 1.59800774061525384266e-43, 3.46566840422542683047e-44, 6.51523702936051389604e-45, 1.04421964392085659633e-45, 1.39594551767532471489e-46, 1.50999534477395793515e-47, 1.26266250569607594863e-48, 7.54576575592277541862e-50, 2.70060278709063528813e-51, 2.34493656364111299277e-53, -9.37742962939879435805e-55, 1.59161771263897749872e-55, -4.66877028767702690589e-56, -1.44120224062929965822e-56, 3.76047411478418355406e-57, 1.124125549450176845e-57, -2.94791531029803356001e-58, -8.46819615166288515984e-59, 2.23686222019249674193e-59, 6.19451890877643534185e-60, -1.64037832643004143101e-60, -4.42102999529618398321e-61, 1.16450726250016594997e-61, 3.08992431185395038599e-62, -8.02057568587594198697e-63, -2.12163948152579064943e-63, 5.37414789643298695201e-64, 1.43476702910833466077e-64, -3.51406220082368662513e-65, -9.57116773955148078787e-66, 2.25002997248030264004e-66, 6.30192005783370324439e-67, -1.41569580673963002431e-67, -4.09406487052671894897e-68, 8.78200510424617079519e-69, 2.62154496336365363205e-69, -5.38600875559300941659e-70, -1.65217800565231625306e-70, 3.27211080313598340107e-71, 1.02327004998299909346e-71, -1.97086445497031934135e-72, -6.21960353686654323245e-73, 1.17670463088741182509e-73, 3.70613507998075158916e-74, -6.9563762689083822072e-75, -2.16370255218033488403e-75, 4.0650732145090480962e-76, 1.23744865369264576152e-76, -2.34358967486617155171e-77, -6.93512041737488570226e-78, 1.33048211022571049612e-78, 3.8117614231907008108e-79, -7.42615962516056594959e-80, -2.05722911567990501764e-80, 4.07050846155244583953e-81, 1.09204071053723201838e-81},
            {1.53729934256889278478e-40, -1.35671802716110169741e-39, -2.28823669089308635481e-39, 1.6008663257137755746e-38, -1.73104487968368196655e-40, -5.40252612445192764904e-38, 2.77239240673157938579e-38, 8.346905511385185051e-38, -6.86122251084665245726e-38, -7.07139579548441147565e-38, 8.28541021454811184037e-38, 3.38804240905831941783e-38, -6.28302735472614753409e-38, -6.49879869211842376313e-39, 3.33117378006054020856e-38, -2.98826728981730764574e-39, -1.30106779586846766536e-38, 3.31417707585892635014e-39, 4.19037683780228823168e-39, -1.01753770845385242234e-39, 1.69237787335695790763e-41, 2.00635240073927597171e-39, 2.37321158898535908299e-39, 2.94550408633339436868e-39, 3.95676576266880578455e-39, 4.77810981225316134224e-39, 5.26916576969767086396e-39, 5.42523173810023217863e-39, 5.19665123028231394719e-39, 4.6154014790809387385e-39, 3.80198941510882490584e-39, 2.90408967549392443333e-39, 2.05434446440875736386e-39, 1.34399891417307505195e-39, 8.11930111978745416085e-40, 4.52058076858377589234e-40, 2.31417881588708564993e-40, 1.08619310131499172039e-40, 4.658836671253963254e-41, 1.81876738336848514991e-41, 6.43180852500458247662e-42, 2.04861080500167431346e-42, 5.83650760900054303429e-43, 1.47484637836130734393e-43, 3.27125338377133867495e-44, 6.28633429264739299081e-45, 1.02939943598598002169e-45, 1.40530549846883216746e-46, 1.5515651497507526586e-47, 1.32357181199638698644e-48, 8.0647659058658903254e-50, 2.94128542543925070723e-51, 2.59966249994348619646e-53, -1.07108242031722790776e-54, 1.80982314742636991797e-55, -5.45628561117379752587e-56, -1.7122540027483106411e-56, 4.55561850662487743491e-57, 1.38429598986971543351e-57, -3.69405720402184119794e-58, -1.07848333311593941394e-58, 2.89605172701609771141e-59, 8.14897490501706856354e-60, -2.19227255858789187509e-60, -6.00110878739325285476e-61, 1.60517130949773622721e-61, 4.32334835726023503273e-62, -1.13940269144330251309e-62, -3.05678885321391198199e-63, 7.86225458637687733683e-64, 2.12649030169050404192e-64, -5.29039362839653151678e-65, -1.4578718610016760064e-65, 3.48319953272032590119e-66, 9.8562189398946400037e-67, -2.2518116270050178686e-67, -6.56930263709444028743e-68, 1.43409143209855760334e-68, 4.31250851612938122987e-69, -9.02218847921726587505e-70, -2.78455007597521022983e-70, 5.6179152899907681134e-71, 1.76589234253937495073e-71, -3.46544340271264096399e-72, -1.09847476519659273476e-72, 2.11739038164250769609e-73, 6.69578323029465548106e-74, -1.2801407334760120994e-74, -3.9971103841228045208e-75, 7.64594951283805085659e-76, 2.33653172595031160047e-76, -4.50315651269540955249e-77, -1.33791904599978062976e-77, 2.61055892031213614613e-78, 7.51057156348208289016e-79, -1.48737667134602379692e-79, -4.13850291302999572122e-80, 8.31957749246421773844e-81, 2.2420933836257180771e-81, -4.5657127045773531008e-82},
            {-2.86092901710614271942e-41, -9.54447077120200489163e-41, 1.00047367054448075131e-39, -9.74156109986706933889e-42, -5.61148215689643729554e-39, 3.42621972501353247227e-39, 1.21299711257288975568e-38, -1.13247845665277240375e-38, -1.32231930114389591573e-38, 1.71032356619482409995e-38, 7.76961768742118199387e-39, -1.55697791017466945113e-38, -1.7954210913489229994e-39, 9.63516886192114323908e-39, -8.98480714197911735982e-40, -4.30379618865523568391e-39, 1.15186930410163223295e-39, 1.5603870185498470632e-39, -3.96174413755298395825e-40, 4.08848102477650488114e-42, 8.66536570977844251328e-40, 1.07462812516965366565e-39, 1.39314004197246500922e-39, 1.95250333178322863458e-39, 2.45607131882440833966e-39, 2.81655843333935326399e-39, 3.01120402528378485215e-39, 2.99091717279094528272e-39, 2.7510454501032567875e-39, 2.34417970805662681868e-39, 1.85012674075109706984e-39, 1.35091174065179568693e-39, 9.11366811715525784638e-40, 5.6722741927924167131e-40, 3.25090366696199746197e-40, 1.71169488978283327931e-40, 8.25702792165818686077e-41, 3.63719881878555358769e-41, 1.45727513468789381425e-41, 5.28554008680846861654e-42, 1.72559271093814082051e-42, 5.03613709409712499509e-43, 1.30289961731621836033e-43, 2.95706839191688539084e-44, 5.81163391080558775955e-45, 9.72777635173052176816e-46, 1.35676964542711207743e-46, 1.52962775980188382591e-47, 1.33171735268146176075e-48, 8.27685979470387062958e-50, 3.07737081411572390625e-51, 2.76872390744567005377e-53, -1.1777379886424450252e-54, 1.98115144766057899218e-55, -6.1316448526218321234e-56, -1.95866035301388161543e-56, 5.31319430389870781848e-57, 1.6422309401395054533e-57, -4.45961707486526955094e-58, -1.32394563820698043852e-58, 3.61428782907069414924e-59, 1.03385873221827743894e-59, -2.82562474069803217045e-60, -7.85990209090536861225e-61, 2.1348787729142464715e-61, 5.83946306944825977305e-62, -1.56246478311720049094e-62, -4.25335669685302096141e-63, 1.11076322452948489179e-63, 3.04509542997760194878e-64, -7.69427162274502797022e-65, -2.14636615342524243755e-65, 5.21103068188868255344e-66, 1.49054257348530296326e-66, -3.46254665586198447178e-67, -1.01962186964246692254e-67, 2.26465253753011270593e-68, 6.86449999033092850945e-69, -1.46195499254244527557e-69, -4.54258242868764531447e-70, 9.33323319707242178074e-71, 2.95069025986028678726e-71, -5.89794120702660861124e-72, -1.87902106959143539977e-72, 3.68893530971439556666e-73, 1.1719734543743961426e-73, -2.28151150012892782695e-74, -7.1556128641273935515e-75, 1.39317035130303828606e-75, 4.27640097441275231092e-76, -8.38449138530332766463e-77, -2.50249240300035079873e-77, 4.96467833903174467271e-78, 1.43511722053868416254e-78, -2.8881112137717056694e-79, -8.07544612383007224858e-80, 1.64887346692809351841e-80, 4.46604067565316560267e-81, -9.23337430210861187904e-82, -2.43223872021191820934e-82},
            {-1.94490315006228453282e-42, 4.09620471050672313294e-41, -5.20729783030880461577e-43, -4.57343286314569563224e-40, 3.46746263316324211696e-40, 1.48108007270714620887e-39, -1.6047127487861665387e-39, -2.15369151195421973423e-39, 3.11597143014289868101e-39, 1.58642726081316315746e-39, -3.4674186551862536445e-39, -4.47445041962598865546e-40, 2.53669641903716252624e-39, -2.47471284609387379757e-40, -1.30815338262564293297e-39, 3.6949979223550323093e-40, 5.37799965107421336902e-40, -1.43319100252936302432e-40, 4.32501740648321803204e-43, 3.49268909768895457233e-40, 4.55097667438723441039e-40, 6.17511288196394914424e-40, 9.04674275925198425364e-40, 1.18749823546091624144e-39, 1.41840416104449947563e-39, 1.57692886848033128796e-39, 1.62642556886275897137e-39, 1.55128592537285791273e-39, 1.36897592352007025403e-39, 1.11764265909367793844e-39, 8.43228053954127539963e-40, 5.87189409353211331891e-40, 3.7686635350834087777e-40, 2.22527211640319867066e-40, 1.20609405389172792365e-40, 5.98414960748112893089e-41, 2.70917510297590668831e-41, 1.11477753897416155784e-41, 4.14967585976755422352e-42, 1.38949682662427706589e-42, 4.15662582263919084462e-43, 1.10159002321551954812e-43, 2.559691994938465989e-44, 5.14756211888838064078e-45, 8.8116891345837202941e-46, 1.25620849356530177818e-46, 1.44683249005759389792e-47, 1.28612768665291732938e-48, 8.15708113037334912939e-50, 3.09316274351018702097e-51, 2.83279950046272538054e-53, -1.24650783420354654141e-54, 2.08842460442772629082e-55, -6.62650243666692882877e-56, -2.15749667581620815307e-56, 5.96638796404439409571e-57, 1.87704661442060070132e-57, -5.18741135385148547478e-58, -1.56678973203785754613e-58, 4.34861570902019813751e-59, 1.2651413119594389774e-59, -3.51296596371185912375e-60, -9.93445470082668400292e-61, 2.74015229641478423576e-61, 7.61510435054620988463e-62, -2.06865443586631090078e-62, -5.71671291547814470322e-63, 1.51573122534697414152e-63, 4.21380890494705546518e-64, -1.08129216121553070984e-64, -3.05494963035081945897e-65, 7.53571393086417956264e-66, 2.18004373573435517116e-66, -5.14832303361927758844e-67, -1.53111791942682631891e-67, 3.45921387918074588026e-68, 1.05752898474053415496e-68, -2.29216997738019613127e-69, -7.17466979436963747125e-70, 1.50077526453560163006e-70, 4.7750019400336072792e-71, -9.71854971110890284414e-72, -3.11383526697883811844e-72, 6.22429438433258554093e-73, 1.9878407340470608277e-73, -3.93914951150960652108e-74, -1.24169105424199733587e-74, 2.45987656450490525959e-75, 7.58863845632994316896e-76, -1.51317450618609286344e-76, -4.53943326033906552587e-77, 9.15402409507919313198e-78, 2.66005068900689078104e-78, -5.43844843795868219392e-79, -1.52888750858199662767e-79, 3.16986267490388167839e-80, 8.63317944812664878905e-81, -1.81164218261644618103e-81, -4.79869719413026157998e-82, 1.01519384677965323229e-82},
            {8.27021471727401129631e-43, -3.02128632986503917029e-44, -2.74402960611991224982e-41, 2.76176662029511382922e-41, 1.4779428528354950343e-40, -1.91339183499082347489e-40, -3.00875988221130251639e-40, 4.95075212329004455886e-40, 2.85637458057320450111e-40, -6.88534079623185659831e-40, -9.99404361454409863793e-41, 6.0454486335530060215e-40, -6.21636186691306301386e-41, -3.63884292426392334779e-40, 1.0901939474942734925e-40, 1.7103624946565674014e-40, -4.80448504928743948875e-41, -2.6006226746586090822e-43, 1.31104866093192077451e-40, 1.79915702227319737555e-40, 2.56089273648038650945e-40, 3.93006068183107736536e-40, 5.39332366706091207075e-40, 6.72154198952411885954e-40, 7.78340647767676457305e-40, 8.3482453222258567344e-40, 8.2682880657606971666e-40, 7.56635778304644079422e-40, 6.3974873818461457241e-40, 4.9929003978788406503e-40, 3.59258464531150205882e-40, 2.38005691321096974133e-40, 1.44921402407347921443e-40, 8.09251706305002105573e-41, 4.13318310638951919704e-41, 1.9246283348311110286e-41, 8.13940722802295963836e-42, 3.1117041743394705058e-42, 1.06935535516121202674e-42, 3.28096081451569771772e-43, 8.9125883404167954769e-44, 2.12145817980670886795e-44, 4.36776611280737361173e-45, 7.65037112226210882245e-46, 1.11534373300069427431e-46, 1.31294783748152157682e-47, 1.19220723624755960848e-48, 7.71959817224003847592e-50, 2.98679907356396663584e-51, 2.78428314556590970446e-53, -1.26961198273529730978e-54, 2.12059937024190434687e-55, -6.88741760355731105181e-56, -2.28866836255388974688e-56, 6.45131475080741370761e-57, 2.0672136515876545445e-57, -5.81440961031418392278e-58, -1.78761649837913273018e-58, 5.04478632312173238786e-59, 1.49342399443971865373e-59, -4.21339726137422149145e-60, -1.21189784378786161632e-60, 3.39463063326174897532e-61, 9.58935674741910760091e-62, -2.6447445486963302545e-62, -7.42293399774181221299e-63, 1.99815320122432787381e-63, 5.63581974703398202163e-64, -1.46858798578651268526e-64, -4.20433191794985323286e-65, 1.05358948652921869241e-65, 3.08428378486605431378e-66, -7.40352001039018422757e-67, -2.22491566735361696597e-67, 5.11216204421977129619e-68, 1.57713852979441193264e-68, -3.47820084163829105153e-69, -1.09735161872110267459e-69, 2.33632732086508768668e-70, 7.48532997668380412913e-71, -1.55086081081287081111e-71, -5.00014056549002785778e-72, 1.01737676402585685573e-72, 3.26810515928553671953e-73, -6.59042010094253617565e-74, -2.08906674085379399066e-74, 4.20994861986485967957e-75, 1.30598040312372597792e-75, -2.64773175618602449121e-76, -7.98780643573684610108e-77, 1.63688529287753395889e-77, 4.78403077178985142541e-78, -9.93408883075611536558e-79, -2.80922012938646535222e-79, 5.91270472603773713252e-80, 1.62000156319717956825e-80, -3.44962495302231935762e-81, -9.19238936098438366867e-82, 1.97275732983958588154e-82, 5.14349018633197408609e-83},
            {-1.2147636961243818429e-45, -1.07858382658581149874e-42, 1.62547015149879048041e-42, 1.1576899583006873672e-41, -1.86766565206332890926e-41, -3.5332083893206347339e-41, 6.7558932670712524592e-41, 4.48073323497802757148e-41, -1.20742974309681385335e-40, -1.98497458518397310596e-41, 1.29565527737044780183e-40, -1.41665740931263726997e-41, -9.21967165345622620803e-41, 2.94664602315139369887e-41, 5.00153860542648260397e-41, -1.48795596602523936559e-41, -2.25348717574226772467e-43, 4.5722665530586524909e-41, 6.62577318293253153636e-41, 9.91792133470596927635e-41, 1.5980364712530991814e-40, 2.29753206647766884113e-40, 2.99324671718105717856e-40, 3.61650454381237621271e-40, 4.04031973009659886459e-40, 4.16144262815581628427e-40, 3.95440062868922686772e-40, 3.46716791679585915178e-40, 2.80245248292272263552e-40, 2.08592078805206584942e-40, 1.4279172513037332489e-40, 8.9747713396979942151e-41, 5.1680627529285752289e-41, 2.71947764955848520973e-41, 1.30355959325779127088e-41, 5.6703188851453715489e-42, 2.22797532195922467763e-42, 7.8634937507331602429e-43, 2.47614294144116983254e-43, 6.89879761179671738039e-44, 1.68315733216874142155e-44, 3.54981725086660760268e-45, 6.36544306772329409297e-46, 9.49515756749373948565e-47, 1.14297787111702760281e-47, 1.06068922951524798096e-48, 7.01497488092262282169e-50, 2.7706109837627711671e-51, 2.62876320976135829469e-53, -1.24412822340330072886e-54, 2.07460848555857167319e-55, -6.88534491486960610894e-56, -2.33823285130979587185e-56, 6.71721839612031286056e-57, 2.19375742214265152502e-57, -6.28049836676434703818e-58, -1.96648216764697779059e-58, 5.64337375914935372973e-59, 1.70070942887765546449e-59, -4.87572258634082879159e-60, -1.42701078907590592178e-60, 4.05960071867072422679e-61, 1.16617805477780697515e-61, -3.26558619938029116696e-62, -9.31272632160607932547e-63, 2.54513757222379319143e-63, 7.28636283079224320804e-64, -1.9280321404549565978e-64, -5.59565557831199586469e-65, 1.42444692895009017356e-65, 4.2216760048572381024e-66, -1.02991106510338723723e-66, -3.1291866063956390086e-67, 7.31096201247058495428e-68, 2.27731594877609285404e-68, -5.10920172314981892031e-69, -1.62562367443485705379e-69, 3.52196811090298812726e-70, 1.13690695532492833168e-70, -2.39727013847258284427e-71, -7.78186765888448233327e-72, 1.61131844416069200585e-72, 5.20902753910599947012e-73, -1.06871604114757158414e-73, -3.408486657986064825e-74, 6.98561558022158664017e-75, 2.18020832273799073126e-75, -4.4930757203572406987e-76, -1.36381089525358965943e-76, 2.83938182379114361298e-77, 8.35036715612549928563e-78, -1.76071474285372131496e-78, -5.01078147382626337379e-79, 1.07039101733558167596e-79, 2.95166405280290657738e-80, -6.37644417592674076859e-81, -1.71014743029782589236e-81, 3.72217346298727714083e-82, 9.76640519385484194993e-83, -2.13011428450891963866e-83},
            {-2.08911652007197658028e-44, 6.30111930074012983455e-44, 6.6774860738845445781e-43, -1.43382012486850030146e-42, -3.39208597463716733178e-42, 7.76058438652253413113e-42, 6.03018808275500921315e-42, -1.8475958784623862993e-41, -3.47197015391063035493e-42, 2.47753578772671575165e-41, -2.91068433771414049642e-42, -2.11594280566034205303e-41, 7.26193894311348040695e-42, 1.33935526747307618394e-41, -4.24238637553364072419e-42, -1.11983571233003051928e-43, 1.47748094821650902596e-41, 2.26760649728917758263e-41, 3.57940722839527761471e-41, 6.07063250064767519847e-41, 9.16463373504575216014e-41, 1.25073107889366668704e-40, 1.57971993749520483171e-40, 1.84147109695407146972e-40, 1.97559647809769076807e-40, 1.9522941492524811827e-40, 1.77749765137140797573e-40, 1.48986975676000872531e-40, 1.14850148311918961108e-40, 8.1329091591027220315e-41, 5.28195721648744877183e-41, 3.13962670050201050314e-41, 1.70369707934573550928e-41, 8.41390460779766150952e-42, 3.76755961472488489203e-42, 1.52263567517655427772e-42, 5.52331839450000776688e-43, 1.78624963292067132622e-43, 5.10763629126319710639e-44, 1.27809406205199497763e-44, 2.76285475389306713718e-45, 5.07487756730527789744e-46, 7.74962580066713765387e-47, 9.54416553436728108437e-48, 9.05630863713122971208e-49, 6.12061642224651707039e-50, 2.46878564533390461748e-51, 2.38396786142329517791e-53, -1.17259735663075312626e-54, 1.95580864005778671782e-55, -6.62094809119620720404e-56, -2.30082386513259467609e-56, 6.73517796881391818e-57, 2.24335359509914459327e-57, -6.53788327426450764312e-58, -2.08581826720346400511e-58, 6.08792700756920028722e-59, 1.86855913888655558244e-59, -5.44418144326184736556e-60, -1.62204343396384722167e-60, 4.68698826026815675883e-61, 1.36975845820056241661e-61, -3.89470198169560918223e-62, -1.12901227259927776721e-62, 3.13278326688750029184e-63, 9.10731752978955408446e-64, -2.44710652202852712579e-64, -7.20320873850207828993e-65, 1.86260862947926757646e-65, 5.59141751922477858432e-66, -1.38620722430056779916e-66, -4.26021956804803768576e-67, 1.01197535476694674914e-67, 3.18439186443460084361e-68, -7.2665639437786786447e-69, -2.3329337103999198984e-69, 5.14235184011491573544e-70, 1.67338947834917968099e-70, -3.59027917093031674649e-71, -1.17404712330284945954e-71, 2.47335284280480745477e-72, 8.0510349217498819629e-73, -1.68015769758692640579e-73, -5.39426940041998579602e-74, 1.12408527703226782173e-74, 3.53135908651403915645e-75, -7.39609999708661167469e-76, -2.2598422359991037343e-76, 4.77898095816928021182e-77, 1.41489354423317651218e-77, -3.02877151623749106316e-78, -8.67832456775446966696e-79, 1.88113436339615902238e-79, 5.22310344424481095369e-80, -1.14447146336943872068e-80, -3.09060933348696922771e-81, 6.82075112552358720877e-82, 1.80180723593052692856e-82, -3.98395867020838429698e-83, -1.03721751760363243565e-83},
            {1.21475287805274303354e-45, 2.5230754552934210575e-44, -8.12502978758009592562e-44, -2.55696122587429899001e-43, 7.29984568272672878178e-43, 6.82245557636751775385e-43, -2.4294645937542639518e-42, -5.28368533105513745267e-43, 4.1862527145197328352e-42, -5.3511868724459098476e-43, -4.36982590057916741517e-42, 1.6228760191814498634e-42, 3.26889551521797120982e-42, -1.10903524443415045614e-42, -4.37484812641615926964e-44, 4.41006265854147922623e-42, 7.19248340078661336802e-42, 1.20092832824412995028e-41, 2.14987337189238364171e-41, 3.41656663654891708808e-41, 4.89546020680220705753e-41, 6.47708529235886490973e-41, 7.89307668379575844775e-41, 8.83570590161814815039e-41, 9.09485219797730012857e-41, 8.61139602658095048609e-41, 7.49525470879208168939e-41, 5.99168626394780221943e-41, 4.39430868516545063657e-41, 2.9522430400684441151e-41, 1.81328958782497259817e-41, 1.01569513451740283465e-41, 5.17282834249646585404e-42, 2.38645324569040714614e-42, 9.92834239371042866605e-43, 3.70437582386009164865e-43, 1.2312782500472830189e-43, 3.61588481416994502221e-44, 9.28611298787339756476e-45, 2.05879856071418399224e-45, 3.87600065643964469031e-46, 6.0627041728999536343e-47, 7.64329354590164066721e-48, 7.41965015111222125844e-49, 5.12687929261684312509e-50, 2.11294098332523455802e-51, 2.07645047857422822675e-53, -1.06262536417599388405e-54, 1.77695542324957816799e-55, -6.12439403480565664783e-56, -2.18059835090169405118e-56, 6.50326496779421564801e-57, 2.21062515118609989303e-57, -6.55911537875373392985e-58, -2.13325305125663385669e-58, 6.33365677376824311851e-59, 1.9807533842170172924e-59, -5.86600046299573691468e-60, -1.77990594526791654162e-60, 5.22469892964301457771e-61, 1.55403157478620060774e-61, -4.487119501579594141e-62, -1.32275971717274109408e-62, 3.72681371672101067446e-63, 1.10063245329266935126e-63, -3.00312816748844755624e-64, -8.96961787140310691346e-65, 2.35592505619315616076e-65, 7.16675386194928321443e-66, -1.8054815369042810608e-66, -5.61535223409555988178e-67, 1.35601754538917771787e-67, 4.31266595810612452353e-68, -1.00083331315994318722e-68, -3.24386969764417585489e-69, 7.2735381836601429477e-70, 2.38727008569295707019e-70, -5.21066318764783241929e-71, -1.71737493674323820758e-71, 3.68031902844874358135e-72, 1.20687519321803069814e-72, -2.56134801086181844655e-73, -8.28227560749309105918e-74, 1.75450814106106560089e-74, 5.55079854234480363108e-75, -1.18126760700785314819e-75, -3.63487307236864671133e-76, 7.80642446932676562622e-77, 2.32777425085914847696e-77, -5.0578051938546877052e-78, -1.45972714805728754295e-78, 3.21012427661303437564e-79, 8.9783667082528989819e-80, -1.99506324760598862518e-80, -5.42698871515503428452e-81, 1.21419370372164936911e-81, 3.23057186205395161842e-82, -7.23996303319153249662e-83, -1.89803114353791905879e-83, 4.23366909011082819753e-84},
            {4.69416208712823214364e-46, -3.02641109556456095241e-45, -1.41935633837638443604e-44, 5.40127495706245740025e-44, 6.31047285398969178814e-44, -2.69038652283210092438e-43, -6.8878840704457287791e-44, 6.17561898351860336529e-43, -8.72195353080334680239e-44, -8.05657132121518421561e-43, 3.2672639446881830841e-43, 7.23094355844650108872e-43, -2.64571988757005314418e-43, -1.44622311321872352243e-44, 1.2115882211992453694e-42, 2.10774280447864943973e-42, 3.73550287389644343412e-42, 7.08062753552222782095e-42, 1.18782258625710715938e-41, 1.791422131306422877e-41, 2.48852366077144717728e-41, 3.1768047664181838008e-41, 3.71766670062530002105e-41, 3.99290000661724924674e-41, 3.93801547190706911744e-41, 3.5645781658763800167e-41, 2.95901838393219512025e-41, 2.25046246425018341549e-41, 1.56589873638130185356e-41, 9.94934286605418971992e-42, 5.75871210602515947302e-42, 3.02743261546690876701e-42, 1.44032692851922488158e-42, 6.17374846209395986565e-43, 2.37124342619457960002e-43, 8.10683688781489176292e-44, 2.44684978085335865171e-44, 6.45362067245714942763e-45, 1.46842859439941096266e-45, 2.83528061928771238552e-46, 4.54531479054920773096e-47, 5.86923937589534824263e-48, 5.83192068003350411975e-49, 4.12226692148450910071e-50, 1.73672509079636792519e-51, 1.73686939785041145223e-53, -9.25562864612557783955e-55, 1.55597601186873075446e-55, -5.44970150123948023368e-56, -1.99047738922209292853e-56, 6.04688357442497356564e-57, 2.09909601225819529846e-57, -6.34188678326325688971e-58, -2.10371201301700527221e-58, 6.35482586407994441721e-59, 2.02585439602382272489e-59, -6.09939060251819581732e-60, -1.8855892992890639206e-60, 5.623582980790790265e-61, 1.70308579495593982729e-61, -4.99432548359220797987e-62, -1.49780440478447649336e-62, 4.2852484856406248611e-63, 1.28618736898745411332e-63, -3.56390967587714077382e-64, -1.08053467533478389702e-64, 2.88284613754288362475e-65, 8.89070002538605149058e-66, -2.27591308970652243682e-66, -7.16672736152476760905e-67, 1.75924799413835054022e-67, 5.65770376990306264503e-68, -1.33512543132939438772e-68, -4.37085367591956924818e-69, 9.96810090482560231436e-70, 3.30145746245971914424e-70, -7.32976745066710406595e-71, -2.43609110589679412719e-71, 5.30959857247650297034e-72, 1.75494274146643427227e-72, -3.78706729073452415904e-73, -1.23392931423717275129e-73, 2.65681179080736506307e-74, 8.46874909724522530976e-75, -1.83092471542556570715e-75, -5.67637173398831910236e-76, 1.23784678468586888614e-76, 3.71914162801976889722e-77, -8.20106929676113958598e-78, -2.38506990093515854392e-78, 5.3204136744464050992e-79, 1.4995590053575787452e-79, -3.37856742911364056715e-80, -9.26127027569953292483e-81, 2.10022042423213024228e-81, 5.63044242284985513588e-82, -1.27870512555263453323e-82, -3.37691673070476644013e-83, 7.63252535703942360476e-84, 2.00212842730696224544e-84},
            {-5.58318542227418640907e-47, -5.15968135985543600896e-46, 2.94978917581502799115e-45, 4.58202140481885680153e-45, -2.44060819149000931513e-44, -7.53529588157728108117e-45, 7.83279787736774645812e-44, -1.24586065987045448599e-44, -1.3132675182551292644e-43, 5.8793701581862687948e-44, 1.44012387614873040196e-43, -5.72791533501809923638e-44, -4.15433376916021189388e-45, 3.05117937091633541104e-43, 5.6863205570421559349e-43, 1.07386313822907915542e-42, 2.16279496267915071022e-42, 3.84186907636043212365e-42, 6.11557112057757751065e-42, 8.94185194064800126025e-42, 1.19852188134073631989e-41, 1.46930055891906391679e-41, 1.6497396301157650907e-41, 1.69774117843138354663e-41, 1.60072531553252775432e-41, 1.38190213876215061163e-41, 1.09139317821260357792e-41, 7.87514839424307616119e-42, 5.18230143209176933611e-42, 3.10292951509830084581e-42, 1.68561403746998617692e-42, 8.27810924981331428049e-43, 3.65916677794943531608e-43, 1.44801866325574190328e-43, 5.09610102124641106091e-44, 1.58207181856888383926e-44, 4.28860261258306470535e-45, 1.00215486230883388611e-45, 1.98580327454710176329e-46, 3.26483102102141991032e-47, 4.32057217412600734572e-48, 4.39689900700900249029e-49, 3.18101001221593877201e-50, 1.37070363522403714187e-51, 1.39501750295744482258e-53, -7.74576700357681995068e-55, 1.31307017428991152281e-55, -4.66510520300030838296e-56, -1.74987254746488801715e-56, 5.41421102969714831519e-57, 1.92056880024684546154e-57, -5.90944230127837330129e-58, -2.00030670530408413855e-58, 6.14916515520451643782e-59, 1.99911648251765877389e-59, -6.12032888411677035625e-60, -1.92849966043857559945e-60, 5.8447713627387577146e-61, 1.80297370376111491793e-61, -5.37066750744249461715e-62, -1.63924566219031198103e-62, 4.76298622521374721578e-63, 1.45347008601538283605e-63, -4.09027314058731319934e-64, -1.2593788405690677171e-64, 3.41309964768553304461e-65, 1.06758905519060495467e-65, -2.77695773803487961548e-66, -8.8574890337539982131e-67, 2.21010948565336572804e-67, 7.19053923961553798115e-68, -1.72533506413439831829e-68, -5.70778024022890949357e-69, 1.32382203475958945244e-69, 4.42659558944210975209e-70, -9.99519678593553245409e-71, -3.35146690649765235712e-71, 7.42830460916788961739e-72, 2.47583232763196758681e-72, -5.43164504747804066836e-73, -1.78412589585368889134e-73, 3.90387863431756307374e-74, 1.25431730013493909023e-74, -2.75456348333152802607e-75, -8.60795217904054331444e-76, 1.90574751880662327931e-76, 5.77176958330757187266e-77, -1.29145670012348552986e-77, -3.78622391763487797403e-78, 8.56605565853018053805e-79, 2.433950394461215573e-79, -5.55936635307334707233e-80, -1.53626319896686429965e-80, 3.53067343960017197525e-81, 9.54083291525940821958e-82, -2.19540006776538426186e-82, -5.84267071448255715671e-83, 1.33787963556875978335e-83, 3.53529690464725351153e-84, -8.00141760117059824921e-85},
            {-9.22435086044086577672e-48, 1.05845462900332254078e-46, 2.44873258799639962435e-46, -1.7421229388160747308e-45, -6.72504659774732330124e-46, 8.37060428473532735595e-45, -1.53673462314617058816e-45, -1.86996047286856926351e-44, 9.36590745792647932789e-45, 2.56186685586827850022e-44, -1.11800857221118284169e-44, -1.04760046592576322768e-45, 7.0098081309241054889e-44, 1.40645988205319584322e-43, 2.84288092024843099794e-43, 6.10773609800957101753e-43, 1.15282163140135927433e-42, 1.94288768375610430345e-42, 2.99841068036959847711e-42, 4.23027021317660270154e-42, 5.44508739078835342602e-42, 6.40465819346583968665e-42, 6.8903637614826820748e-42, 6.7788794170111845989e-42, 6.09587209674307247351e-42, 5.00683786549927167069e-42, 3.7516616699738396538e-42, 2.56021144723502433628e-42, 1.58767155528249217802e-42, 8.92210408481023682049e-43, 4.5277160023025354518e-43, 2.06594084829488673086e-43, 8.43089176785947320394e-44, 3.05704308812829345932e-44, 9.76958810307310725805e-45, 2.72391770149041108531e-45, 6.54183082759516052245e-46, 1.33124841384231175457e-46, 2.24608163428086795165e-47, 3.04818239294783735254e-48, 3.17893951457312518091e-49, 2.35529289069881529519e-50, 1.03857774833482526191e-51, 1.07570059005281307184e-53, -6.22568170219360581365e-55, 1.067771949572509264e-55, -3.84180379056495176011e-56, -1.48144804385090504101e-56, 4.66786493322446527571e-57, 1.69307815905161867765e-57, -5.30650580793676577782e-58, -1.83379768357950522554e-58, 5.73827220144170093742e-59, 1.90330394189550743976e-59, -5.92660989759369374749e-60, -1.90419843449952589016e-60, 5.865881852815403491e-61, 1.84384769138644970075e-61, -5.58006629183388074554e-62, -1.7340530877779571149e-62, 5.11767860721211028338e-63, 1.588436021982663795e-63, -4.54028773556588534593e-64, -1.42021920670611944939e-64, 3.91005882317028279899e-65, 1.240970050677478901e-65, -3.2800407817878983622e-66, -1.06019563950057309464e-66, 2.68891098105263219783e-67, 8.85430306418435564726e-68, -2.16008997122942390659e-68, -7.22463218846974145586e-69, 1.70395333051922144729e-69, 5.75503102822341105898e-70, -1.32148092384412464583e-70, -4.47246557965573072811e-71, 1.00794662891552840404e-71, 3.38921046338359344935e-72, -7.55831376365962555163e-73, -2.50391793311184051283e-73, 5.56719114603014926514e-74, 1.80379779538032452035e-74, -4.02320448216603904689e-75, -1.26778966079908778744e-75, 2.84922693741823002611e-76, 8.70188459876620073153e-77, -1.97547752305264677509e-77, -5.84068049404845438315e-78, 1.3400238355579009814e-78, 3.83990458667296940333e-79, -8.89039813632498408619e-80, -2.47756443055136514244e-80, 5.76971792266758501425e-81, 1.5721487408882646241e-81, -3.66485526336832743329e-82, -9.83244192712141538827e-83, 2.28063604504685528597e-83, 6.07310176005450421719e-84, -1.39236321969501074433e-84, -3.71103037381915476214e-85},
            {1.87857494239301523565e-48, 8.56036718677679127957e-48, -9.18013635288478386678e-47, -4.69838957470049704104e-47, 7.33086661954267082935e-46, -1.60521342130812918026e-46, -2.29035977294029449404e-45, 1.30509951773402701683e-45, 4.03127364815577392621e-45, -1.95188888077248920423e-45, -2.32483669079989055888e-46, 1.46094274813335574568e-44, 3.17410217378799916264e-44, 6.90208658469489943936e-44, 1.58892570315644649128e-43, 3.19920162086643015725e-43, 5.72827740188054690755e-43, 9.35975459556475211708e-43, 1.393818456035095616e-42, 1.8884409787441367883e-42, 2.33221183459424489966e-42, 2.62847416636368712448e-42, 2.70341510073718788867e-42, 2.53666876117233694382e-42, 2.17025865371599949299e-42, 1.69121168101408234503e-42, 1.19849216495389858866e-42, 7.70744540738802011581e-43, 4.48595158589665590849e-43, 2.35498650032845744702e-43, 1.11036821717103258383e-43, 4.67746521454458944781e-44, 1.74904711835162681299e-44, 5.75888152366199144382e-45, 1.65286765135514107504e-45, 4.08285811344422144489e-46, 8.53884807490918649292e-47, 1.47947748050447787842e-47, 2.0603687216189041959e-48, 2.20341355029946267526e-49, 1.67287910854547182266e-50, 7.55294543166451992839e-52, 7.96203328641614807219e-54, -4.80395111485388263627e-55, 8.36536506574202482459e-56, -3.04363086629139236363e-56, -1.20765964075980271696e-56, 3.8747818529695180704e-57, 1.43790832156932750828e-57, -4.59170371102806968844e-58, -1.62075921017401005929e-58, 5.16389604320556256437e-59, 1.74822277131391058643e-59, -5.53822636169219340345e-60, -1.81515450650347032654e-60, 5.68473099563033114312e-61, 1.82155117537822156011e-61, -5.60168475326619517583e-62, -1.77303151709221437499e-62, 5.31586448767143011184e-63, 1.67883894930082530462e-63, -4.8746598471485996326e-64, -1.54973146940882735123e-64, 4.33466762407245885387e-65, 1.39647939239711121569e-65, -3.75079474869390290471e-66, -1.22907887914644827748e-66, 3.16853449638668856926e-67, 1.05646932665924277292e-67, -2.6203898851218913606e-68, -8.86450505851910836277e-69, 2.12593527800327392321e-69, 7.25581748317823706164e-70, -1.69416759057281329996e-70, -5.79003295991245209058e-71, 1.32668085026067847317e-71, 4.50246136416918218468e-72, -1.02058290299973961132e-72, -3.41140063011274544591e-73, 7.70633737115350034465e-74, 2.51896736099144949958e-74, -5.70557027652812441124e-75, -1.81375208229444190376e-75, 4.13737811438860589554e-76, 1.27474577191210152963e-76, -2.93577671940619344303e-77, -8.75675268486345129774e-78, 2.03712893006824750916e-78, 5.8892862879106605692e-79, -1.38197717369350356859e-79, -3.88529348250288451953e-80, 9.16724263341158461021e-81, 2.51966024521141656446e-81, -5.94955901838219309778e-82, -1.609717804045307185e-82, 3.78156937281112148137e-83, 1.01514314294166388046e-83, -2.35723417602739316153e-84, -6.3303459463501811508e-85, 1.44353429424496567079e-85},
            {1.46758864433140440981e-49, -3.1781728039359794585e-48, -2.40632418773001317093e-48, 5.05358846635205837865e-47, -1.38238045820369204811e-47, -2.36467379733752473569e-46, 1.56669167256267963252e-46, 5.54372813072294233533e-46, -3.01880894997240896767e-46, -4.53024797669266906041e-47, 2.74384141470605233125e-45, 6.49929818597462702926e-45, 1.52941167681192316425e-44, 3.79212745591872700227e-44, 8.1811282649894898276e-44, 1.5624009730309264689e-43, 2.71229374967621633648e-43, 4.27648714457988532393e-43, 6.1157642036546162836e-43, 7.95018090785361801029e-43, 9.40782548071027978395e-43, 1.01365640306793799047e-42, 9.94346007601701421302e-43, 8.87688868455544187603e-43, 7.20559286311326048077e-43, 5.31050144152070471385e-43, 3.54648268338150516636e-43, 2.1405930849479522478e-43, 1.16387628000144600536e-43, 5.67685994681935299367e-44, 2.47110772586030543499e-44, 9.53826893703056737944e-45, 3.23866993392473776656e-45, 9.57688174887183520606e-46, 2.4351475364634923308e-46, 5.23805700650708497139e-47, 9.32693997699804200825e-48, 1.33382404985555562052e-48, 1.4636830853561721221e-49, 1.13945165730303997317e-50, 5.27058374242284871708e-52, 5.65571445131899380288e-54, -3.55728945640553425983e-55, 6.31220175674487511072e-56, -2.31963969444321532489e-56, -9.47788217925536967021e-57, 3.09655140346323585139e-57, 1.17635325828545245449e-57, -3.82825217059478263906e-58, -1.38087681050818814019e-58, 4.48098781196209663765e-59, 1.54907539747731445323e-59, -4.99398834423348534909e-60, -1.67033315438154047293e-60, 5.3197041244642180796e-61, 1.73831135015510880965e-61, -5.43332718070381037647e-62, -1.75228312193194293557e-62, 5.33814505080596585041e-63, 1.71605041952740771452e-63, -5.06234133406910770779e-64, -1.63633729885496212024e-64, 4.65039706592170018257e-65, 1.52140053737663474466e-65, -4.15270969902313665867e-66, -1.38012226173256412682e-66, 3.6165623952103740802e-67, 1.22151878538022646626e-67, -3.08032978476734763885e-68, -1.05443464840815469921e-68, 2.57130177944190379605e-69, 8.87210528170721211575e-70, -2.10634034735274836813e-70, -7.27247272617263893874e-71, 1.69406935076523950041e-71, 5.80529965351354999269e-72, -1.33739519028717987921e-72, -4.51248863767522017909e-73, 1.03560339096746094715e-73, 3.41639132007717594381e-74, -7.85774878045722335891e-75, -2.52087494047344889006e-75, 5.8361597473486220294e-76, 1.81468818509555527937e-76, -4.23938219197613271618e-77, -1.27617485415129811668e-77, 3.01003336924464071231e-78, 8.78225331147593687161e-79, -2.08852225494023383676e-79, -5.92559769363801685004e-80, 1.41640391750747001212e-80, 3.92828954752674144328e-81, -9.39456923421582515647e-82, -2.56419303741931564789e-82, 6.10023825700505254236e-83, 1.65139995341201028927e-83, -3.88330102067406311157e-84, -1.05114064874202803499e-84, 2.42766519212016916071e-85, 6.62121117433658589758e-86},
            {-5.43868544347475434347e-50, -8.00842295707079238743e-50, 2.5723922116424018271e-48, -9.43918109791858406349e-49, -2.0015613429509982307e-47, 1.58799434643274781542e-47, 6.56047454513861956813e-47, -4.08670917707955737523e-47, -7.70610048144843716914e-48, 4.60694045861652050898e-46, 1.19940228321919850522e-45, 3.07567394005598425663e-45, 8.26274544607949413314e-45, 1.91986108825486115928e-44, 3.92808211702728413613e-44, 7.27327026267764013606e-44, 1.21841599894518941052e-43, 1.84488416165692226322e-43, 2.53141192613904655946e-43, 3.1531140727372486723e-43, 3.56714302427255172132e-43, 3.66574362109992053737e-43, 3.42123824663955036619e-43, 2.89781074077390128907e-43, 2.22464323859234522856e-43, 1.54508751638289012427e-43, 9.68451668431230432149e-44, 5.46064534412958579809e-44, 2.75857516014231461724e-44, 1.242198372732954254e-44, 4.95458918024950366368e-45, 1.73655747413374326583e-45, 5.29544601376939021503e-46, 1.38724743430735649142e-46, 3.07158861764083827206e-47, 5.62505916486203727412e-48, 8.26660806409170273543e-49, 9.31485576764905544641e-50, 7.44035070656210877554e-51, 3.52803523487745718801e-52, 3.85460240484463989128e-54, -2.52675588757537363425e-55, 4.58568950193265092525e-56, -1.70058494285071348405e-56, -7.1597793502106752166e-57, 2.38208299551892546789e-57, 9.26892500691505852325e-58, -3.07493804083851530644e-58, -1.13398411825545014462e-58, 3.74910946331168729359e-59, 1.32401866973340506705e-59, -4.34516820066026348127e-60, -1.48371589733772700742e-60, 4.80669713688000919867e-61, 1.60237447463121335681e-61, -5.09180472672476939755e-62, -1.67384639668550208528e-62, 5.18229744041335980664e-63, 1.6964102757103063748e-63, -5.08525717469945194971e-64, -1.67189974407390328606e-64, 4.82838366468025553639e-65, 1.6047263016455750528e-65, -4.45170854000381451344e-66, -1.5011297404809109779e-66, 3.9986914856583104486e-67, 1.36870120696666417372e-67, -3.50913675010623631027e-68, -1.21602076700383125892e-68, 3.01513221175342201971e-69, 1.05221192587122453389e-69, -2.53992927714764268773e-70, -8.86317229799617584334e-71, 2.09884328586688737537e-71, 7.265501331847525198e-72, -1.70102752780594588529e-72, -5.79585085313166949456e-73, 1.35122567604825318743e-73, 4.50063216889427151565e-74, -1.05106095864484893904e-74, -3.40424712062644234284e-75, 7.99823936543318616394e-76, 2.5107611805278159366e-76, -5.94942471653480595348e-77, -1.80810802112505032918e-77, 4.32352272789879197767e-78, 1.27353997040978840391e-78, -3.06905908061191346238e-79, -8.79052246172496886898e-80, 2.12848926294977214154e-80, 5.95861312274248785076e-81, -1.44313545635736957066e-81, -3.97496662455306246265e-82, 9.57538722122231764293e-83, 2.6149098284476534318e-83, -6.22623960694586658666e-84, -1.69929109664529621191e-84, 3.97433026692033484275e-85, 1.09227192063080235071e-85, -2.49532702122325913426e-86},
            {-1.28908758897152713692e-51, 8.60301714253822329931e-50, -4.80390004242893728875e-50, -1.33400189376890060686e-48, 1.32214962915363174505e-48, 6.54678318339651022578e-48, -4.76898456139246511549e-48, -1.13359577729652620411e-48, 6.8479345180463801858e-47, 1.97895049629207291126e-46, 5.576018492691037035e-46, 1.63445804310132041465e-45, 4.11446234353500411622e-45, 9.06518532752548897627e-45, 1.79831835956613443382e-44, 3.21328269912795978278e-44, 5.16938365642348818981e-44, 7.51005940362448268942e-44, 9.87393987200868256574e-44, 1.17581387856583265497e-43, 1.26870781401504807992e-43, 1.24045136069804776055e-43, 1.09841517116819414839e-43, 8.79906529387425631469e-44, 6.36583595210490528641e-44, 4.14965582097252358879e-44, 2.42978411265311086955e-44, 1.27292352442361886184e-44, 5.93673465411531643309e-45, 2.4495463653820618816e-45, 8.87162741900107616955e-46, 2.79252092436421819059e-46, 7.54391026343391801825e-47, 1.7208589624648179072e-47, 3.24383754876389045025e-48, 4.90271066124662239048e-49, 5.67681253522079647864e-50, 4.65578806941668156097e-51, 2.26458514175341026415e-52, 2.51990832711106823495e-54, -1.7208373599414271953e-55, 3.20597898365150020627e-56, -1.19919418790366752578e-56, -5.20480252300971699962e-57, 1.76366938250680489906e-57, 7.03275541010124731705e-58, -2.37912928733637957905e-58, -8.97448750884460444789e-59, 3.02404434351209717406e-59, 1.09146517533832755512e-59, -3.64760402354246674737e-60, -1.27208796561295302765e-60, 4.19333056327488629371e-61, 1.42666596179101181443e-61, -4.61018343716658834452e-62, -1.54536774487248830318e-62, 4.86363832059374726387e-63, 1.6218170024273460706e-63, -4.94116067883375604998e-64, -1.6529772529467365228e-64, 4.85175750696654965651e-65, 1.63874794627400986948e-65, -4.62087277303164935435e-66, -1.5815892385587380597e-66, 4.28297975348898818212e-67, 1.48627882237270442075e-67, -3.87438530013798393351e-68, -1.3596959964424202301e-68, 3.42801672316522207411e-69, 1.2104429524766485161e-69, -2.97079944068692082326e-70, -1.04817866913525497976e-70, 2.52321915111218624006e-71, 8.82693888063771357532e-72, -2.10014349295108384003e-72, -7.22898320099964844041e-73, 1.71198824805304944044e-73, 5.75950542784328346138e-74, -1.36565538873555345432e-74, -4.46720190099929205309e-75, 1.0650812011018509535e-75, 3.37664376058675884657e-76, -8.11519438248493945076e-77, -2.49080697835034773633e-77, 6.03780712151804043327e-78, 1.79613791961635671283e-78, -4.385946012975846509e-79, -1.26861869836838064992e-79, 3.11141689503218378279e-80, 8.79486461802288254704e-81, -2.15697074050683506767e-81, -5.99739104634639786464e-82, 1.46275561985661695927e-82, 4.03094646879398442895e-83, -9.71740444729133112957e-84, -2.67495607396976907553e-84, 6.33472710516047418818e-85, 1.7549254978860593833e-85, -4.06030157100356574359e-86, -1.13912674564112900891e-86},
            {1.42154217432764957234e-51, -1.62795067527681910389e-51, -6.56658039186082611138e-50, 8.68763087407507195852e-50, 5.35785618449606228188e-49, -4.70172236306757708436e-49, -1.42286751240913289637e-49, 8.90294084796143155343e-48, 2.89088349486091177362e-47, 9.04045533685982464821e-47, 2.91557267167040045161e-46, 8.00727398687654359914e-46, 1.9110775917688294981e-45, 4.08255084768589069622e-45, 7.81566908338376546604e-45, 1.3411366674948318997e-44, 2.07011641755040280632e-44, 2.88174442668374588545e-44, 3.62223236821945379429e-44, 4.11404080645123770944e-44, 4.22347704999165474629e-44, 3.91792176581977296334e-44, 3.28116155693176679123e-44, 2.47700948361595669575e-44, 1.68194467845141601973e-44, 1.02423572891881545061e-44, 5.57217092918466654591e-45, 2.69502672900196807997e-45, 1.1516986175836545963e-45, 4.31494236678017398505e-46, 1.40345846665054324037e-46, 3.91356159090060689196e-47, 9.20575125416115586458e-48, 1.78771690459902907178e-48, 2.78104684801258695511e-49, 3.31156359891304345195e-50, 2.79069392873014086684e-51, 1.39334214143942794823e-52, 1.57969390038286488669e-54, -1.12318637257595878297e-55, 2.15586727272162742765e-56, -8.13284429244854279862e-57, -3.63999676289129580064e-57, 1.25655382735459414245e-57, 5.13726450615711785383e-58, -1.77284555176196116422e-58, -6.84362951528895042613e-59, 2.35120596737137627816e-59, 8.67676708723741771764e-60, -2.95393156026915120668e-60, -1.05257557775392635294e-60, 3.5317203361896814257e-61, 1.22677530904458213863e-61, -4.03253535488500975692e-62, -1.3788785630556583562e-62, 4.41255545927242706543e-63, 1.49942672408803420152e-63, -4.64399469628780506889e-64, -1.58136995432135609752e-64, 4.71826556101066327546e-65, 1.62022528315394247166e-65, -4.64441852123273845376e-66, -1.61416934215332228178e-66, 4.44421483788893680803e-67, 1.56417889229869905334e-67, -4.14596487851396017891e-68, -1.47414161298708836974e-68, 3.7791067475956771719e-69, 1.35074167984136224685e-69, -3.37066083849267358086e-70, -1.20295005821312359955e-70, 2.94368912300878036148e-71, 1.04109368750756445647e-71, -2.51717028140219849136e-72, -8.75652626149186851743e-73, 2.10647262005634712222e-73, 7.16047982209846054938e-74, -1.72379221576013771579e-74, -5.69689007149343353313e-75, 1.37829586551206903703e-75, 4.41456418091187090972e-76, -1.07603832806233808803e-76, -3.33661912302164549348e-77, 8.1988304982274884235e-78, 2.46399285473557307653e-78, -6.09637971942406861299e-79, -1.781296606642920805e-79, 4.42495330823739820479e-80, 1.26331798860260708489e-80, -3.13727159963811811364e-81, -8.80839818227395605748e-82, 2.17499962962325228055e-82, 6.05013330755770234932e-83, -1.47653155299027385862e-83, -4.10082472908166478922e-84, 9.83220947554514617426e-85, 2.74654578858675690012e-85, -6.43480499388572115873e-86, -1.81910569669880957948e-86, 4.14764160084797788359e-87},
            {-2.79002673233973951019e-53, -2.12384922484973360847e-51, 4.22857677144333138384e-51, 3.45345103547028647967e-50, -3.80972393538390835857e-50, -1.49557303843137795354e-50, 9.96833441562171189126e-49, 3.69378465479976621579e-48, 1.29803954573173039841e-47, 4.65249434814857812104e-47, 1.40563748399977787983e-46, 3.65951091378901064498e-46, 8.46873002072467748982e-46, 1.74593334773159326004e-45, 3.20986629608679285299e-45, 5.28477377892909994323e-45, 7.81640085426230162917e-45, 1.04026410240358110287e-44, 1.2471264465609083634e-44, 1.34766857696463493028e-44, 1.31266512369822339109e-44, 1.1516652126344972721e-44, 9.0892800465577358419e-45, 6.44014635638404434646e-45, 4.08518794318676901442e-45, 2.31136906416143339011e-45, 1.16090646426921532124e-45, 5.1447555041789398055e-46, 1.99634559205014847777e-46, 6.7169801909401717985e-47, 1.93540078914507374682e-47, 4.69916089010117342766e-48, 9.40989151829768520192e-49, 1.50800655367319510346e-49, 1.84816553087831366955e-50, 1.60157417016297713312e-51, 8.21397318791519310476e-53, 9.49289230789637466057e-55, -7.02256119332941801336e-56, 1.39358391696967676415e-56, -5.3037995552382274493e-57, -2.448196648486083497e-57, 8.61305925058994123857e-58, 3.6119353816816617074e-58, -1.27206262298505953521e-58, -5.0274642940295962071e-59, 1.7618196101181973965e-59, 6.65067400867869167254e-60, -2.30740642470674877457e-60, -8.40427775421792356407e-61, 2.87131282598786673738e-61, 1.01869863100116841628e-61, -3.40734049717562874207e-62, -1.18894742470981687725e-62, 3.86975542847577750981e-63, 1.3405266201392337072e-63, -4.22167880723032073132e-64, -1.463838702148001757e-64, 4.44062790874423834149e-65, 1.55089295924370517517e-65, -4.52011330389575897918e-66, -1.59581563337008206694e-66, 4.46758337648728532891e-67, 1.59540843353524203401e-67, -4.30014244914973181484e-68, -1.54968688783431610642e-68, 4.03984728903084511811e-69, 1.46218868773227852047e-69, -3.70998290696172738014e-70, -1.33982271864424136246e-70, 3.33288824305846764285e-71, 1.19214919460731359016e-71, -2.9291142987421348789e-72, -1.03017579317992021068e-72, 2.51727699463452789717e-73, 8.64925101499949465267e-74, -2.11398000960266094159e-74, -7.0609916577238836155e-75, 1.73347878471420946741e-75, 5.61118284534077274014e-76, -1.38710541692676662154e-76, -4.3467879342404981718e-77, 1.08269654571679923965e-77, 3.28820736580476390721e-78, -8.24299799007544687228e-79, -2.43377343655922521733e-79, 6.12321230368348621848e-80, 1.76623449472864007783e-80, -4.44109015302699462957e-81, -1.25948265190073427663e-81, 3.14832729309643347388e-82, 8.84275661347826708035e-83, -2.18457404687401289207e-83, -6.12337338813509743917e-84, 1.48627562817030501971e-84, 4.18770914072479568106e-85, -9.93405626228540227151e-86, -2.83072990278175937021e-86, 6.53657199904444993788e-87, 1.89180896139598014554e-87},
            {-3.39261404042548350615e-53, 1.35811613564570992728e-52, 1.64426632954263666206e-51, -2.43750146179558989947e-51, -1.28183933199461073988e-51, 9.41891531475553388391e-50, 4.06470802318762604369e-49, 1.63054244856213075002e-48, 6.57667791791160825315e-48, 2.20793560394361111688e-47, 6.32260035354511940528e-47, 1.59610139118764839482e-46, 3.56470155369144314552e-46, 7.05760135555969843019e-46, 1.24494326127461964434e-45, 1.96403952822390360488e-45, 2.77721158215138437047e-45, 3.52527904674834091764e-45, 4.0210769906546027202e-45, 4.12274028513678299651e-45, 3.79791267867094212965e-45, 3.1401461665828671696e-45, 2.32605629307829962587e-45, 1.53964035882260211672e-45, 9.07412244628243253136e-46, 4.73984985288962949367e-46, 2.18132152791986498184e-46, 8.77767326172415115901e-47, 3.05877687962540185455e-47, 9.11698604741108348969e-48, 2.28725689362301176744e-48, 4.72746709626108409481e-49, 7.81188750081632024395e-50, 9.86242847096679457978e-51, 8.79575039907005283781e-52, 4.63733300721304951092e-53, 5.46636878686959563926e-55, -4.20396888776331184614e-56, 8.65391541312873527248e-57, -3.32531017051418519345e-57, -1.58298481288000352593e-57, 5.67859227419135153646e-58, 2.44357683921594107376e-58, -8.78682582193966457622e-59, -3.55710135699639632529e-59, 1.27208116772874950138e-59, 4.91416144302435427148e-60, -1.73823056608261123953e-60, -6.47425269139913015991e-61, 2.25311829984498908159e-61, 8.1678667353932040809e-62, -2.78089715639720928959e-62, -9.90598412898222072938e-63, 3.28025148778738339177e-63, 1.15882729194388258516e-63, -3.71180646594969475727e-64, -1.31105732757492030575e-64, 4.04454927165693018539e-65, 1.43719387240609799888e-65, -4.2596233374263242279e-66, -1.52822060567779386432e-66, 4.35090492603393850706e-67, 1.57708468791342040494e-67, -4.32296682439430076888e-68, -1.57964922925832688316e-68, 4.18777919058584629872e-69, 1.53549349755313215382e-69, -3.96152885899662918923e-70, -1.44827183890865939933e-70, 3.66239560764571180398e-71, 1.32541807348640775112e-71, -3.30939394367833248706e-72, -1.17717358662925007676e-72, 2.92185565935207783313e-73, 1.01513375642088724399e-73, -2.51898266601983672049e-74, -8.5065197642508345037e-75, 2.11909589808773078717e-75, 6.93459791164031945861e-76, -1.73854933510677244334e-76, -5.50763414102724007211e-77, 1.39055999289345286596e-77, 4.26915120755109947585e-78, -1.08430554519114160613e-78, -3.23599803762314505408e-79, 8.2455883759268697893e-80, 2.40372214515130933182e-80, -6.11942795848025932159e-81, -1.75347121658447636274e-81, 4.43701053545583436858e-82, 1.25871681871451223242e-82, -3.14761326113207806164e-83, -8.90697501443467501851e-84, 2.18843588357790696493e-84, 6.22135064006635602411e-85, -1.49415383491490082849e-85, -4.29291651373083703718e-86, 1.00383822479841792664e-86, 2.92728689233358937917e-87, -6.65007043838889533648e-88},
            {2.17080660793038818248e-54, 5.14353314497378362313e-53, -1.15579850290562016326e-52, -8.61241939816331436362e-53, 7.30410272689890454525e-51, 3.77447221765769258552e-50, 1.76436926631226740594e-49, 8.13577947222716757211e-49, 3.07303229513531566987e-48, 9.77687473496524539605e-48, 2.71481016910433797011e-47, 6.61428634392477763537e-47, 1.4186320353223053455e-46, 2.69486692742979657181e-46, 4.55505271204770463803e-46, 6.87028091282319488563e-46, 9.26579238402042720291e-46, 1.11905305005188218882e-45, 1.21107793324500648014e-45, 1.1743706212835938732e-45, 1.01952490470324342916e-45, 7.91171514046259606359e-46, 5.47487525921746229961e-46, 3.36699299904517428467e-46, 1.83201659982487490992e-46, 8.76828624194502448764e-47, 3.66402944339928082041e-47, 1.3240709963405690152e-47, 4.08731155239058495324e-48, 1.06071393021992648782e-48, 2.26523598658055949574e-49, 3.8634465164471523092e-50, 5.02913707170644647115e-51, 4.62000034603299203338e-52, 2.50596352723172574291e-53, 3.01503840409258880254e-55, -2.40837131790178505151e-56, 5.15888917265741790646e-57, -2.0038362110997309718e-57, -9.83577759232968589718e-58, 3.60006063218671438479e-58, 1.5901960967473237222e-58, -5.84157146683367321172e-59, -2.42333978659913121264e-59, 8.84816914547832906767e-60, 3.4995660531207675171e-60, -1.26260673143713600416e-60, -4.81107244988425476716e-61, 1.70619619602185726905e-61, 6.32249598410738760314e-62, -2.19195519437979645411e-62, -7.974033508015724017e-63, 2.68731237627583170213e-63, 9.68530158144846898261e-64, -3.15616605739926827223e-64, -1.13602202415227655162e-64, 3.56481431107434373325e-65, 1.28929620671502750956e-65, -3.88671688082699134054e-66, -1.41756748182829285524e-66, 4.10496585714362201437e-67, 1.51087190846328862432e-67, -4.21234129038674298269e-68, -1.56130476129252767736e-68, 4.20971527805063154826e-69, 1.56426504068148908516e-69, -4.10393616998231192546e-70, -1.51937744885922251799e-70, 3.90610045118655726213e-71, 1.43077558330983778594e-71, -3.63054379058262831861e-72, -1.30658861597290862957e-72, 3.29432152633944378671e-73, 1.15771116863514309193e-73, -2.91667922116370457366e-74, -9.9614885279720440044e-75, 2.51810118559282643419e-75, 8.33335411666608781106e-76, -2.11884052790721585182e-76, -6.78783585829803766432e-77, 1.737168308510013891e-77, 5.39292548788949134295e-78, -1.38776364260150879534e-78, -4.18756381272406976601e-79, 1.08064377605962088908e-79, 3.18466683936270085089e-80, -8.20852959788770022246e-81, -2.37718213490802171954e-81, 6.08895864846861029097e-82, 1.74515729678179845903e-82, -4.41713853121918950598e-83, -1.26223567439297856733e-83, 3.13914469174352525894e-84, 9.00666904099557345023e-85, -2.18977991581398141801e-85, -6.34563043820850327695e-86, 1.50246134506020899334e-86, 4.41585780084953259367e-87, -1.01602173604190013338e-87, -3.03474664428985555628e-88},
            {7.94136125691778961781e-55, -3.61805967738681196991e-54, -4.25861437446079904502e-54, 4.46411124603546755641e-52, 2.87621371790077083084e-51, 1.61141398538545750969e-50, 8.67219609127038623911e-50, 3.74390802243061992878e-49, 1.33991005506478238762e-48, 4.13385792452557070911e-48, 1.10786036543108943152e-47, 2.59209996203378293298e-47, 5.3342392739326510301e-47, 9.70970590237425949593e-47, 1.56907810862756567895e-46, 2.25723324622917743773e-46, 2.89647337345645548714e-46, 3.31903333412592175128e-46, 3.39722063078432549396e-46, 3.10449851773739497518e-46, 2.52960495774631040251e-46, 1.8338298202613252696e-46, 1.17904747138383806365e-46, 6.69422268887120934096e-47, 3.33741961665670073657e-47, 1.45038105503655501347e-47, 5.44269654447033757074e-48, 1.74227830336289534531e-48, 4.68264768569806463029e-49, 1.03440666377883713086e-49, 1.82280286941506219307e-50, 2.44892011766092498235e-51, 2.31943506928673090888e-52, 1.2954542573354764763e-53, 1.59213108351966752083e-55, -1.31964486161463375427e-56, 2.95011385247578287995e-57, -1.16020538578533983781e-57, -5.86999789076234536235e-58, 2.19395065002764976462e-58, 9.95080733914616006647e-59, -3.73659469069148068187e-59, -1.5891896413793503524e-59, 5.92744520344887873305e-60, 2.40133708488106408813e-60, -8.84123331283012694377e-61, -3.4480008459442045535e-61, 1.24662925587980924368e-61, 4.72400684413781645354e-62, -1.6683667260642455985e-62, -6.20071911535996112747e-63, 2.12747648360915361935e-63, 7.82543495741876688526e-64, -2.59518403903882139931e-64, -9.52244645238800299859e-65, 3.04028438369864291354e-65, 1.11960095017399417248e-65, -3.4337051095342849781e-66, -1.27360141137595413683e-66, 3.75188272025643867505e-67, 1.40273319309108692899e-67, -3.97833978684844748788e-68, -1.49629487625015715106e-68, 4.10367080740732730117e-69, 1.54592674047614560465e-69, -4.1246958336892142915e-70, -1.54702827823508206938e-70, 4.04359185570290800648e-71, 1.49967070101542912773e-71, -3.86743443143106783385e-72, -1.40870696454467579458e-72, 3.60806345120214366267e-73, 1.28300413460920795431e-73, -3.28183645189721623189e-74, -1.13398021978315516261e-74, 2.90881181027772255186e-75, 9.73815523383176364214e-76, -2.51117022763669402144e-76, -8.13761871264756729906e-77, 2.11105471290503333662e-77, 6.62889675434266045573e-78, -1.7282875968326458635e-78, -5.2744376169919082442e-79, 1.37849215607519757078e-79, 4.10796619864664459655e-80, -1.07200854196819085318e-80, -3.1385246953889707725e-81, 8.13739167470920753549e-82, 2.35695705045682336575e-82, -6.0380384029187858125e-83, -1.74288230289575513332e-83, 4.38716915694910017165e-84, 1.27076108339624148742e-84, -3.1274964223474871374e-85, -9.14358006030611461961e-86, 2.19192475490790492045e-86, 6.49500356319457907973e-87, -1.51338894028786860654e-87, -4.5541205784426579734e-88, 1.03126511487752810595e-88},
            {-5.6405014926184604867e-56, -1.38004099226040420178e-55, 2.01671386377702848573e-53, 1.72701008751847985965e-52, 1.2079475415143753116e-51, 7.80446726210679112072e-51, 3.93117776295724687323e-50, 1.60778779791509228005e-49, 5.58014038302139355707e-49, 1.66159943645084742843e-48, 4.27639434953915798889e-48, 9.60016543560133549647e-48, 1.89307491607913269662e-47, 3.29447077585397569746e-47, 5.0778080397837429079e-47, 6.95015569839096934821e-47, 8.46180333173233661529e-47, 9.17058064812741196583e-47, 8.84594897088728006885e-47, 7.58719554772320178009e-47, 5.77532234370554688616e-47, 3.89001140659221702495e-47, 2.30899477301627385497e-47, 1.20119440106011186923e-47, 5.43759361282795164595e-48, 2.12207626380649520626e-48, 7.05402785408978358965e-49, 1.9659783353880133919e-49, 4.49759301293249867419e-50, 8.19783351139947212234e-51, 1.13789908575726376812e-51, 1.11223128363144339533e-52, 6.40229311995914209107e-54, 8.04513181882263860364e-56, -6.91223684069359937593e-57, 1.61702486709088171327e-57, -6.45175659369074059453e-58, -3.36309708146755169865e-58, 1.28479965992348489117e-58, 5.98516467462041444958e-59, -2.29895658807834948371e-59, -1.00285646031945349964e-59, 3.82326789455969758473e-60, 1.58725618347938771493e-60, -5.96673320351511926056e-61, -2.38267733422061152547e-61, 8.78658821923880550735e-62, 3.4063519888076699853e-62, -1.22599986839391525073e-62, -4.65713200495744945854e-63, 1.62736935239774732226e-63, 6.11147376893444961354e-64, -2.06329456306937830131e-64, -7.72074533070634590487e-65, 2.50878580480068015465e-65, 9.41041972550582456321e-66, -2.93685538274961619046e-66, -1.10822054053514791541e-66, 3.32183753477204891849e-67, 1.26204841166027909003e-67, -3.6417008813739520979e-68, -1.39038505832257607272e-68, 3.87915831591493371612e-69, 1.48209542351614319629e-69, -4.02195713942161907051e-70, -1.52878453438279183221e-70, 4.06296662247032749597e-71, 1.52626521065693426722e-71, -4.00049495393126487996e-72, -1.47534940214272704936e-72, 3.83883467504989798183e-73, 1.3817211722103929134e-73, -3.58864404922209456972e-74, -1.25491283556143423474e-74, 3.26664791370626123975e-75, 1.10665878271623929024e-75, -2.89433454932417681151e-76, -9.49049014963270486539e-77, 2.49570935641558821844e-77, 7.92904676826539079745e-78, -2.0945364816647949945e-78, -6.46672665396838981609e-79, 1.71168812716454436855e-79, 5.15950277547875409086e-80, -1.36317018563938838035e-80, -4.03576310928160153638e-81, 1.05915707834178619901e-81, 3.10112734533690303074e-82, -8.04066205064161683649e-83, -2.34506956558437762817e-83, 5.97449613248603925358e-84, 1.74754623112243749492e-84, -4.35346434816089984866e-85, -1.28446981615629204016e-85, 3.11733529729222314339e-86, 9.31552121403882069489e-87, -2.19797998311164489374e-87, -6.66566889061128352679e-88, 1.52880447010701479949e-88, 4.70373797317604902989e-89},
            {-2.21193631878764065812e-57, 5.98932415354014661376e-55, 7.66202870787856687738e-54, 7.13634450797751991291e-53, 5.76641772836081083874e-52, 3.48580760594084777279e-51, 1.6630988117786182596e-50, 6.59646616142283738999e-50, 2.2097353681161314862e-49, 6.31890368599226242213e-49, 1.56036998599632037376e-48, 3.35659668903076813651e-48, 6.32811385418172787781e-48, 1.05037773860091669652e-47, 1.5403654049266220905e-47, 2.0004077496469986777e-47, 2.30345514106307992095e-47, 2.35260954611989813358e-47, 2.12993840768394935979e-47, 1.70662330661876017936e-47, 1.20698114366401749413e-47, 7.50539904180188609059e-48, 4.08192752601457720189e-48, 1.92812497937213266542e-48, 7.83802673276802122847e-49, 2.70955730674985456935e-49, 7.84157965598903250498e-50, 1.86020646727916274541e-50, 3.5113014542730825259e-51, 5.04111335846059098854e-52, 5.09042367181150799738e-53, 3.02283493279045439343e-54, 3.88783558428612297389e-56, -3.45902230352475969665e-57, 8.48846129422497442662e-58, -3.44418957105091253852e-58, -1.84870156248550787869e-58, 7.22701681632787831167e-59, 3.45870396777165110041e-59, -1.35999807176770213285e-59, -6.08761032250407119596e-60, 2.37366274039614651461e-60, 1.01033131168109083716e-60, -3.87991584970768425854e-61, -1.58716923199892224158e-61, 5.97280169116582615848e-62, 2.36990110717768779771e-62, -8.69649520444206172341e-63, -3.37774578804594740101e-63, 1.20257479903036029887e-63, 4.61273008396692326246e-64, -1.58592046684751750162e-64, -6.05428566301896634928e-65, 2.00280452247422232046e-65, 7.6549851500118152624e-66, -2.43167297307121220254e-66, -9.33867903978240731682e-67, 2.84884963987482171091e-67, 1.10027828390116764728e-67, -3.23081008847921428949e-68, -1.25262487112809374655e-68, 3.5557864500939605996e-69, 1.37834717896151476106e-69, -3.80479863088417238724e-70, -1.46623149727300491882e-70, 3.96252225768854686022e-71, 1.50824653947652155583e-71, -4.01836928842903405728e-72, -1.50094689522930287834e-72, 3.96782474049132437845e-73, 1.44605868948180546138e-73, -3.81368028734529979545e-74, -1.35008642967508388016e-74, 3.56658600485480888547e-75, 1.22306112923823457968e-75, -3.24443633582846937329e-76, -1.07677820147073629898e-76, 2.87046525333370488132e-77, 9.22971146200372426025e-78, -2.47036682111755481658e-78, -7.71816875208544966083e-79, 2.06907822971676137645e-79, 6.31012279924903850622e-80, -1.68794062613467639459e-80, -5.05471263199656594192e-81, 1.34278838588188071206e-81, 3.97534359168844570227e-82, -1.04320718785866348246e-82, -3.07497943410419838718e-83, 7.92877846129223275716e-84, 2.34260764628103015842e-84, -5.90692665442459371903e-85, -1.75930391211341047259e-85, 4.3224079830374579087e-86, 1.30299753118883224803e-86, -3.11295925738106351334e-87, -9.51671778174734928026e-88, 2.21054326782669218126e-88, 6.85167493931551872125e-89, -1.55007153443335790969e-89},
            {8.78028681363327591485e-57, 2.23307898212496994088e-55, 3.11563468253095300608e-54, 3.35880704787795639927e-53, 2.53821684343618298771e-52, 1.45306159910031873353e-51, 6.72372615692219904024e-51, 2.57410958123221700274e-50, 8.28083440054175607168e-50, 2.27200942127945993637e-49, 5.3761182393407891843e-49, 1.10567651555036061554e-48, 1.98818916389039163655e-48, 3.13991368087506773595e-48, 4.36891508350185754089e-48, 5.36614143991923838858e-48, 5.82317934437996026215e-48, 5.58213336226957891103e-48, 4.72118647508328107254e-48, 3.51470671465945468082e-48, 2.29482365333254189851e-48, 1.30749465492891321684e-48, 6.45665650860424093977e-49, 2.73874043611214596295e-49, 9.86172908576221927822e-50, 2.96800622467739878711e-50, 7.31096991536718663416e-51, 1.43095191165782492213e-51, 2.12742778511775951807e-52, 2.22178113940026084605e-53, 1.36247930859761825096e-54, 1.7956775820341425232e-56, -1.65269238805803810503e-57, 4.26381193774328770216e-58, -1.76409935483597585474e-58, -9.74433797689666784605e-59, 3.90300995441105619184e-59, 1.91937968365196988645e-59, -7.73261037226132059766e-60, -3.55326524900206228895e-60, 1.41798046005689025124e-60, 6.19095844862646462024e-61, -2.43018983388655615039e-61, -1.01886619920417401223e-61, 3.91471026484315635233e-62, 1.59047380289460925673e-62, -5.95331020612990786478e-63, -2.36524947521444130632e-63, 8.58347154592533987754e-64, 3.36409524324474333616e-64, -1.17831714374983426366e-64, -4.59087423010975358601e-65, 1.54662306108708655586e-65, 6.02581904017563784519e-66, -1.94888728421069908031e-66, -7.62022570761059766291e-67, 2.36639951669662583635e-67, 9.29437086593145226246e-68, -2.77777625862373824136e-68, -1.0940780359073969967e-68, 3.16044751015446114355e-69, 1.24341695782388580077e-69, -3.49191050902019384752e-70, -1.36475321245112841278e-70, 3.75100270957845044683e-71, 1.4471581263320659598e-71, -3.91950877216531454776e-72, -1.48330537245773066267e-72, 3.98417902088059989654e-73, 1.47071394134470317575e-73, -3.93884414692370587891e-74, -1.41207508036648325757e-74, 3.78600554561111146191e-75, 1.31459671021102881821e-75, -3.53725402999058040853e-76, -1.18857527615301274694e-76, 3.21215573699077834347e-77, 1.04559348680147988221e-77, -2.83571309835275360775e-78, -8.96786437718713536088e-79, 2.43495033173871650008e-79, 7.51525061083160564951e-80, -2.0354084003685933274e-80, -6.16691008147113269259e-81, 1.65829493407723484499e-81, 4.96534305763101480377e-82, -1.31877232827197710987e-82, -3.92972749700262019958e-83, 1.02550934248848947881e-83, 3.06135607596228917527e-84, -7.81302569537034329094e-85, -2.34966895460803914608e-85, 5.84382655854956415942e-86, 1.77758463101158737079e-86, -4.29978523011697243624e-87, -1.32549604098777275833e-87, 3.11788894502048823102e-88, 9.73849651878290235971e-89, -2.23145735578473440431e-89, -7.04557142126972644368e-90},
            {3.20720121056209382018e-57, 8.93672869601908851959e-56, 1.44625674279008172031e-54, 1.45734745878059123159e-53, 1.042760609838676772e-52, 5.79000288398153418337e-52, 2.58606643172699138547e-51, 9.50762902037920416417e-51, 2.93463375145012004959e-50, 7.71551584547733153622e-50, 1.74547211128618596699e-49, 3.42395233157958753691e-49, 5.85797042785634746631e-49, 8.77780378287649996856e-49, 1.15514448850073327971e-48, 1.33709473221921745902e-48, 1.36185362855313219053e-48, 1.21956265117125813188e-48, 9.58344670716661954156e-49, 6.58651617507791551303e-49, 3.94031650742755233314e-49, 2.03842463251006307816e-49, 9.03921940004127805292e-50, 3.39623809157717388228e-50, 1.06466207412875913605e-50, 2.72720504687172873313e-51, 5.54252659727211133617e-52, 8.54405943618618755435e-53, 9.23945487274271676157e-54, 5.85764082220937690943e-55, 7.92119463605944207267e-57, -7.53440365179838247117e-58, 2.04752810654875226567e-58, -8.66383843544569750462e-59, -4.9215984790230728764e-59, 2.02271896634548552535e-59, 1.02232702978598832083e-59, -4.22380564555201856856e-60, -1.99339019255978969244e-60, 8.14747881908878630592e-61, 3.6506438176161993423e-61, -1.46570766566020793759e-61, -6.30101162155844012701e-62, 2.4732147762737077555e-62, 1.029345400633325868e-62, -3.93213015769219660778e-63, -1.59870399026944573458e-63, 5.91628678954813256368e-64, 2.37023251366601790537e-64, -8.46112449826478994229e-65, -3.36576660218675508569e-65, 1.15514977115973673011e-65, 4.58947577299570845594e-66, -1.51173385194208900435e-66, -6.02036166099085567104e-67, 1.90367195181351177087e-67, 7.60653542179195411734e-68, -2.31434887614070373007e-68, -9.26368490665317993739e-69, 2.72365028788093618231e-69, 1.08799052332194118577e-69, -3.10895235794240629906e-70, -1.23277087404950781171e-70, 3.44634790589947981323e-71, 1.34818217924597346307e-71, -3.71239259696549882737e-72, -1.4239147488357295383e-72, 3.88649995906837706971e-73, 1.45360338992452608594e-73, -3.95374832816820619269e-74, -1.43583885553763216099e-74, 3.90748737935046118541e-75, 1.37421542114438121702e-75, -3.75096936687264532622e-76, -1.2764447511577460033e-76, 3.49739430984277849408e-77, 1.15281889949319777584e-77, -3.16819406217191163418e-78, -1.01444425651483340811e-78, 2.78990187306898219205e-79, 8.71660743959587894846e-80, -2.39034808715933840414e-80, -7.32933896545301891776e-81, 1.9950502255849168367e-81, 6.04326854628213392972e-82, -1.62451324160836918479e-82, -4.89494197492377606401e-83, 1.29281872046200385539e-83, 3.90036412920596531085e-84, -1.00750416170493410806e-84, -3.06025231559382008834e-85, 7.70440994149766471873e-86, 2.36540379284382988539e-86, -5.79278078516822442278e-87, -1.8011817369199419596e-87, 4.29024640378104100666e-88, 1.35073630309540642057e-88, -3.13455088511654199295e-89, -9.97024695032992883926e-90, 2.26165024855032134693e-90},
            {1.26315150388669495614e-57, 4.0928642689937021989e-56, 6.1868406740769151389e-55, 5.90174940734447320226e-54, 4.09612270065933701037e-53, 2.19539759151249751181e-52, 9.41643392566106048339e-52, 3.32164811277957225774e-51, 9.82454660674533082669e-51, 2.46953001065371259839e-50, 5.328668546360664705e-50, 9.9454476082449223363e-50, 1.6144456935871936763e-49, 2.28800726590440006087e-49, 2.83756385230729863537e-49, 3.08277540525391052121e-49, 2.93321286467183330179e-49, 2.44052474090830093567e-49, 1.77049838680410562808e-49, 1.11491677588615019116e-49, 6.05602149785646901808e-50, 2.8132912982769228816e-50, 1.1050157317416329432e-50, 3.61442036524860033816e-51, 9.64353419439407937554e-52, 2.03802635280236750883e-52, 3.26204512783076659101e-53, 3.65731073225516141579e-54, 2.39994031163526046722e-55, 3.33471585178486988274e-57, -3.2750637793645388781e-58, 9.39103397503318102786e-59, -4.07694781971460984287e-59, -2.38021366178354972776e-59, 1.00535572401600834401e-59, 5.22337374802373797572e-60, -2.21545062018920196853e-60, -1.07432255467940554171e-60, 4.50087356479014818405e-61, 2.0707314192750314987e-61, -8.50916455622513732021e-62, -3.75277733635333330649e-62, 1.50566822113745688765e-62, 6.42251449810079300831e-63, -2.50516246799239260172e-63, -1.04277181482072285173e-63, 3.93705177152013454388e-64, 1.61298660609301696526e-64, -5.8707586256785903244e-65, -2.3853233862664674457e-65, 8.34311784568563278559e-66, 3.38155271973462109993e-66, -1.13477868476508595287e-66, -4.60459504994905829052e-67, 1.48296992078139780095e-67, 6.03052010893476784555e-68, -1.8683844400429967325e-68, -7.60304943233135895567e-69, 2.27568701694768572115e-69, 9.23319325393669121823e-70, -2.6851017031154395623e-70, -1.08059466138340851619e-70, 3.07319391372263226055e-71, 1.2194170358297384311e-71, -3.41433282487473168799e-72, -1.32774212049500860465e-72, 3.68304331819567235228e-73, 1.39615208416247281458e-73, -3.85713630488350927298e-74, -1.41939744877577750046e-74, 3.92108703071331041002e-75, 1.39713493702833589901e-75, -3.86883487818704392155e-76, -1.33370533553588170401e-76, 3.70518158831194205461e-77, 1.23707030610392512571e-77, -3.44529852821872942409e-78, -1.11724135388216524192e-78, 3.11238882102767457631e-79, 9.84619719579843009966e-80, -2.73407036513583846317e-80, -8.48613334100884685038e-81, 2.33835589079511797409e-81, 7.16749348362983143492e-82, -1.9501167948279784765e-82, -5.94326380953139457035e-83, 1.58866678063641810303e-83, 4.84510808436512465475e-84, -1.26671653188532196356e-84, -3.88709270445971951162e-85, 9.90579737271073489708e-86, 3.07045810578643771294e-86, -7.61262042115687602875e-87, -2.38814749911840177501e-87, 5.75977677633909748771e-88, 1.82840053859104939812e-88, -4.29690485229212439735e-89, -1.37724559916804575618e-89, 3.16408120775513675018e-90, 1.02005574720765569491e-90},
            {5.71065547860638441418e-58, 1.726567009902854103e-56, 2.47019234953277861065e-55, 2.2858671880598052926e-54, 1.53144139209812803137e-53, 7.88223165637907053536e-53, 3.24382214563654974473e-52, 1.09648725492956862092e-51, 3.10066317821040418367e-51, 7.43384790603714836256e-51, 1.52619422808559861829e-50, 2.70268823100783248497e-50, 4.14945400518879156072e-50, 5.54195605208054393579e-50, 6.45092192082965602575e-50, 6.54713339477933326557e-50, 5.78786031634308104161e-50, 4.44581029025582250142e-50, 2.95511137036361375026e-50, 1.68961218266973392851e-50, 8.24121042010391590489e-51, 3.39101236620089811987e-51, 1.15951902828797228479e-51, 3.22791401260098419359e-52, 7.10518201861186348951e-53, 1.18255887565811433116e-53, 1.37651339545031446758e-54, 9.36125836957361235309e-56, 1.3386327156965635805e-57, -1.35637491832630275514e-58, 4.1097880244152606944e-59, -1.83672492514472678194e-59, -1.10140217636466635624e-59, 4.789366736406374521e-60, 2.55843375095398266639e-60, -1.11524483015433660225e-60, -5.55942859864352110016e-61, 2.38942127570346659549e-61, 1.12935442916955385742e-61, -4.75321344588928111552e-62, -2.15169691914982808336e-62, 8.82985422214746502478e-63, 3.86204419756549129911e-63, -1.53905590941104908715e-63, -6.56173489299978868935e-64, 2.52882294452455344865e-64, 1.05994298567733880122e-64, -3.93519395222872822447e-65, -1.63378426942372709041e-65, 5.82605072128339770643e-66, 2.40989348871743284772e-66, -8.24187857574163948706e-67, -3.40885484983277751281e-67, 1.11854090999461015256e-67, 4.630928393397632631e-68, -1.46137796548142274757e-68, -6.04803285184236845466e-69, 1.84329182494360022167e-69, 7.59905048894382631666e-70, -2.24943304633518227018e-70, -9.19105109819943721061e-71, 2.65960455010890661008e-71, 1.0707882953109471971e-71, -3.04909646593332816881e-72, -1.20254876692264572381e-72, 3.39057139739292133184e-73, 1.3030985613804845887e-73, -3.65705643198099993684e-74, -1.36410145308416481628e-74, 3.82567313028021627748e-75, 1.38147147239491230499e-75, -3.8813317548555265825e-76, -1.35582466783988832332e-76, 3.81944265795524351148e-77, 1.29202260089848714015e-77, -3.64686902334929647138e-78, -1.19799950914021350647e-78, 3.38081295703183115808e-79, 1.08323150208980005802e-79, -3.04590867767001195813e-80, -9.57239705768472065628e-81, 2.67026892960572495107e-81, 8.28431279592721521835e-82, -2.28143358051131227032e-82, -7.03426337252340913281e-83, 1.90306619427719171356e-83, 5.8686097161696891458e-84, -1.55291756126340028675e-84, -4.81546854075118106747e-85, 1.24217091440394307415e-85, 3.88825840387079651997e-86, -9.75942432577020411759e-87, -3.0897446358385524825e-87, 7.54517379466086847289e-88, 2.41562519647192375451e-88, -5.74870721477832095723e-89, -1.85724794944005359078e-89, 4.32110370320501787599e-90, 1.40346505425210726201e-90, -3.2062669620523036874e-91},
            {2.37607665532242378732e-58, 6.79776860082475870209e-57, 9.43558596442740386864e-56, 8.42863736389272452235e-55, 5.42263988464208618172e-54, 2.67789816361161136692e-53, 1.05604758055423726891e-52, 3.41289900702946947212e-52, 9.20518401146213152324e-52, 2.09982993657351038292e-51, 4.09036040352647883076e-51, 6.85084543395626400794e-51, 9.91237265232391347089e-51, 1.242568159000327638e-50, 1.35117542331280417315e-50, 1.27410563172681676169e-50, 1.03983403817129089174e-50, 7.31821566927400478668e-51, 4.41663020773385018505e-51, 2.26755869478352697927e-51, 9.79641738595526414462e-52, 3.50907263286157845936e-52, 1.02118639897365538808e-52, 2.34527211915903669701e-53, 4.06540978553167445618e-54, 4.92028761419079150147e-55, 3.47260492598369171244e-56, 5.11903606975297596404e-58, -5.34786673145747747215e-59, 1.71434699960178598689e-59, -7.91485995954629144158e-60, -4.87232410010151119989e-60, 2.18528057903252672946e-60, 1.20051097828162176387e-60, -5.38487538969754345409e-61, -2.76079816458068927735e-61, 1.21841289761459219689e-61, 5.91945370562954202846e-62, -2.55364998816645756608e-62, -1.18718124291746908205e-62, 4.98623153329788954989e-63, 2.23739960907148903403e-63, -9.11471362226789442625e-64, -3.98219791851562118289e-64, 1.56736392818216271796e-64, 6.72404566297976665216e-65, -2.54764780064504462531e-65, -1.08125085419165833741e-65, 3.93265967888163767593e-66, 1.66081818712057904745e-66, -5.79087350823524703317e-67, -2.44230554882337627182e-67, 8.16744204394116516371e-68, 3.44400622903812604391e-68, -1.10729568590300656806e-68, -4.66240190595348872914e-69, 1.44727566487286688652e-69, 6.06461314678046488573e-70, -1.82774115935544496974e-70, -7.58495855616637907882e-71, 2.23363201783881637741e-71, 9.12795846440551325395e-72, -2.64379556253788330414e-72, -1.05786068693548332639e-72, 3.03208316965006073728e-73, 1.1818521597928301834e-73, -3.36975979383256660193e-74, -1.27444995047229339857e-74, 3.62908213226819651558e-75, 1.32849434553802447361e-75, -3.78743399904758596171e-76, -1.34100929982368321787e-76, 3.8310721990969472499e-77, 1.31338302891963833107e-77, -3.75750898403444815144e-78, -1.2507317877430730393e-78, 3.57588010749836851172e-79, 1.16069066830451199244e-79, -3.30520494261313848304e-80, -1.05198974824310377589e-80, 2.97102290110765549396e-81, 9.33161312587337315013e-82, -2.60127923179903649834e-82, -8.11612274366277268631e-83, 2.2224187124655216922e-83, 6.93143819329365940548e-84, -1.85644242566867441364e-84, -5.81866893447274462656e-85, 1.51930666037607673462e-85, 4.80384450651801443025e-86, -1.22064640127225803548e-86, -3.90096356185023738836e-87, 9.64512710607127866546e-88, 3.11513821741476988892e-88, -7.5068144664220455033e-89, -2.44520610822827049903e-89, 5.76110185068013595656e-90, 1.88564482454379170811e-90, -4.36236971215845793495e-91, -1.42791366685763103639e-91},
            {9.22634548955838032625e-59, 2.5612755099464214767e-57, 3.43192654654548853102e-56, 2.94391235657194786705e-55, 1.81724155557916611949e-54, 8.59963010086407971885e-54, 3.24237914850177124235e-53, 9.9945314393621023118e-53, 2.56486676066469027546e-52, 5.55134866430550874283e-52, 1.02275799711143993519e-51, 1.61433674891731020674e-51, 2.19229000544363436163e-51, 2.56727854372211398484e-51, 2.59374858443877521764e-51, 2.25793667361297859838e-51, 1.68840369019824763691e-51, 1.07888962427678909997e-51, 5.84672301510247988356e-52, 2.65875670971843967014e-52, 9.99922200812063895234e-53, 3.04821799113989099697e-53, 7.31798608819997618625e-54, 1.3234924303603511465e-54, 1.66813555381617211977e-55, 1.22363254677163551072e-56, 1.86288423906798611708e-58, -2.00561499917932505807e-59, 6.80894649814536923215e-60, -3.25909346786731955147e-60, -2.05873858812484376904e-60, 9.54272805135720222067e-61, 5.39275149458565150626e-61, -2.49230733689231546473e-61, -1.31487215741492861232e-61, 5.9643898298907562862e-62, 2.98025095608356705601e-62, -1.3188800928345531978e-62, -6.30038414708648526795e-63, 2.7102503138199462904e-63, 1.24829295866469101925e-63, -5.20173973324199624088e-64, -2.33000231098821552607e-64, 9.37114498474245964492e-65, 4.11669703459747816044e-65, -1.59257226481147392126e-65, -6.91246463123118955517e-66, 2.56546252802871787939e-66, 1.10660844976010655086e-66, -3.93531719085766812425e-67, -1.69310540430063609037e-67, 5.7724782707354789669e-68, 2.48011617110619834913e-68, -8.12658102121927227932e-69, -3.48268769168555444092e-69, 1.10136780546783666846e-69, 4.6928056301333071476e-70, -1.44026636335489283575e-70, -6.0727392066644932777e-71, 1.82028260327347643195e-71, 7.55314292612229496063e-72, -2.22560622690176978252e-72, -9.03781221621243559637e-73, 2.63384579474205296569e-73, 1.04152316909018671624e-73, -3.01753023998689665008e-74, -1.15748844826697475959e-74, 3.34706010422721622144e-75, 1.2424568284925109723e-75, -3.59474691631232778098e-76, -1.29044382141731118098e-76, 3.73912789806820087995e-77, 1.2994427666148441554e-77, -3.76851712775718125346e-78, -1.27137208062780896138e-78, 3.68287740940320564833e-79, 1.21132587694076669928e-79, -3.49354156417744052064e-80, -1.12639992948034767392e-80, 3.22091095965948360521e-81, 1.02442846100042595531e-81, -2.8907889688223237165e-82, -9.12917641735077497885e-83, 2.5302890351699215791e-83, 7.98338936404189529041e-84, -2.16422724690581190465e-84, -6.85807567859476964146e-85, 1.81262727454588201988e-85, 5.79067470823942495414e-86, -1.48956849525184237077e-86, -4.8065767448209058518e-87, 1.20324301883663143362e-87, 3.92142226284183544689e-88, -9.56854527770727389568e-89, -3.14325144082153889301e-89, 7.49921636158431982493e-90, 2.47418205840119625617e-90, -5.79610664441863752448e-91, -1.91164251167699646994e-91, 4.41855698510518804077e-92},
            {3.42968149393195933193e-59, 9.19115519584372856809e-58, 1.18261409477637702892e-56, 9.73339301495280753292e-56, 5.75755582212713659929e-55, 2.60495952537187846447e-54, 9.36794352230469032983e-54, 2.74749517774129985996e-53, 6.68993689149676445641e-53, 1.36947165469836666361e-52, 2.37775016518777079379e-52, 3.52255485149011635339e-52, 4.46882695811864919382e-52, 4.86217865593312892974e-52, 4.53496954699091798827e-52, 3.61711088113404965736e-52, 2.45574093936594984292e-52, 1.40905627742026572824e-52, 6.76326404243755817144e-53, 2.67727913058988308748e-53, 8.56893512123898077435e-54, 2.15490721478585659714e-54, 4.07379875677752435562e-55, 5.35658032981634783707e-56, 4.09033929783123075099e-57, 6.44397415594153103178e-59, -7.14786098354694827931e-60, 2.57197336798942247675e-60, -1.28093315232603406953e-60, -8.30096483836445923334e-61, 3.98479759498366517355e-61, 2.31721001169775877589e-61, -1.10495665881144862669e-61, -6.00191996564994467491e-62, 2.80123914950952752647e-62, 1.44045587781164499873e-62, -6.54481910272268815377e-63, -3.2145577009812813928e-63, 1.41733492855285151551e-63, 6.70431359552800196408e-64, -2.85959482189609557338e-64, -1.31389654289592324247e-64, 5.40308856247339122668e-65, 2.43164228875002587212e-65, -9.60992044967243306104e-66, -4.26770442938095993588e-66, 1.61697529212482279596e-66, 7.1270434383106430618e-67, -2.58606386398017903512e-67, -1.13545572896426107013e-67, 3.94820606419701316756e-68, 1.72907691495791032568e-68, -5.77598749940265600086e-69, -2.52035383286571895488e-69, 8.12229559923640444754e-70, 3.52038725759237830676e-70, -1.10054581619300442876e-70, -4.71640398146345711868e-71, 1.43932113235603808076e-71, 6.06631997794964694561e-72, -1.81885949029270494233e-72, -7.49849343313294430723e-73, 2.22225578144674626898e-73, 8.91801148473582741665e-74, -2.62584680324475178853e-74, -1.02189849029395618556e-74, 3.00118897967426010862e-75, 1.13003442494307739134e-75, -3.3184941254104742901e-76, -1.20813507790279862944e-76, 3.55095600290695359669e-77, 1.25130176566511539046e-77, -3.67901316607459878807e-78, -1.25829090028885976373e-78, 3.69349890499595075586e-79, 1.23128252480627674707e-79, -3.59688998372165082179e-80, -1.17508860182175069426e-80, 3.40239271327275828837e-81, 1.09607733123315900746e-81, -3.13119910231852508544e-82, -1.00110751626750478404e-82, 2.8086935975063016123e-83, 8.96691658993656606348e-84, -2.4605555142265591355e-84, -7.88484521649463261394e-85, 2.10956994152032859781e-85, 6.81078352876301148768e-86, -1.77362548488812243948e-86, -5.78013773352275044683e-87, 1.46498679343326361186e-87, 4.8189705470114160847e-88, -1.19061503420068188385e-88, -3.94537942055295582185e-89, 9.53143257083993050435e-90, 3.17063882608146750317e-90, -7.52100278058092327615e-91, -2.50004618807636379229e-91, 5.8507082912986334458e-92, 1.93363014620411428483e-92},
            {1.21448872267905380461e-59, 3.12529402378955627484e-58, 3.85831933250001493078e-57, 3.04304170390478808891e-56, 1.72099074334083345775e-55, 7.42678913631517976426e-55, 2.54120121403959184581e-54, 7.07155694720027716516e-54, 1.62853761020867902817e-53, 3.14172151126840724869e-53, 5.11977608058966861683e-53, 7.08555495956356918385e-53, 8.35162522140221965333e-53, 8.38871233992970056314e-53, 7.16869223662751557033e-53, 5.19134900703070141976e-53, 3.16476499201117251007e-53, 1.60832490954181208774e-53, 6.71994283562248691289e-54, 2.26380804317851065617e-54, 5.97700970397161885906e-55, 1.18357236290627591489e-55, 1.62660706593902924953e-56, 1.29528061233138392166e-57, 2.11611222670483474339e-59, -2.41839561852349238223e-60, 9.22854688008224055359e-61, -4.79965311977517561566e-61, -3.19063353961231298884e-61, 1.58966260080385824484e-61, 9.5161857213898171686e-62, -4.68895162404871479051e-62, -2.62388478547975993174e-62, 1.26144158246560045504e-62, 6.67973071217162472395e-63, -3.11887447184210213789e-63, -1.57598601013964793004e-63, 7.12776658207267723994e-64, 3.46465519162319383704e-64, -1.51366493746675275854e-64, -7.13782567692252035857e-65, 3.00303734442270668934e-65, 1.38526731711048111724e-65, -5.59582842263821560306e-66, -2.54378463416622657229e-66, 9.84420131574571221663e-67, 4.43562349382028130118e-67, -1.64293117102640000277e-67, -7.36477731907258111722e-68, 2.61281892642996349069e-68, 1.16682249625623962756e-68, -3.97504323387050398788e-69, -1.7667546552175319789e-69, 5.80396320341573313754e-70, 2.55983912463999647782e-70, -8.15369791591393129193e-71, -3.55285578086089193656e-71, 1.10413227048903513685e-71, 4.72846487250490113839e-72, -1.44291620200582303133e-72, -6.04118145501228688448e-73, 1.82104285197450299125e-73, 7.41871435783916156062e-74, -2.22037680988418728439e-74, -8.76941440594242693217e-75, 2.61617455915379793081e-75, 9.99473102804563060984e-76, -2.97953949922815644408e-76, -1.10038978809642882793e-76, 3.28122591125159038917e-77, 1.17272597956428867753e-77, -3.49605358066634976373e-78, -1.21250700135604418551e-78, 3.60690638941686758394e-79, 1.21900555570050131574e-79, -3.60733000401261660905e-80, -1.19439599793030202506e-80, 3.50211676088975744292e-81, 1.14298823353654661908e-81, -3.30583193399692118265e-82, -1.07030014959503502967e-82, 3.03978392059281303438e-83, 9.82207955427623185196e-84, -2.72828387794292444949e-84, -8.84324770753774206454e-85, 2.395089020722542879e-85, 7.81647111321216246877e-86, -2.06070957565757372556e-86, -6.78421054991319985666e-87, 1.74090094230571855579e-87, 5.78138776688566992628e-88, -1.44630308055018312359e-88, -4.83581152524297470243e-89, 1.18293757539929519164e-89, 3.96855323972751597655e-90, -9.53173450047823163191e-91, -3.19414673992993187331e-91, 7.56807544080648349544e-92, 2.52075492781242365573e-92, -5.92018981175933327706e-93},
            {4.07573358516857700752e-60, 1.00632398079637617305e-58, 1.19051879657529600316e-57, 8.97725677429383049073e-57, 4.84255321998702753776e-56, 1.9883472216458087046e-55, 6.4552645752371672946e-55, 1.69897886104192726539e-54, 3.68730957574385661768e-54, 6.67650777110443770021e-54, 1.01639706711592460951e-53, 1.30691269590413916081e-53, 1.42209612197959417497e-53, 1.30873590222243029293e-53, 1.01542103661944270978e-53, 6.60271355646394499098e-54, 3.5650397437003568474e-54, 1.57707820213894863426e-54, 5.607549276948012777e-55, 1.55828803718946299866e-55, 3.23955104199853821459e-56, 4.66305580649388961758e-57, 3.87959943656786388808e-58, 6.58762529926834530125e-60, -7.75931305845025855558e-61, 3.14139774494282921892e-61, -1.71229703909502402355e-61, -1.16781411815157512716e-61, 6.0523944280205994677e-62, 3.73169667559792919114e-62, -1.90297009249330836207e-62, -1.09777255257670565312e-62, 5.44267650344294541195e-63, 2.96991668985486244541e-63, -1.42641267446901230496e-63, -7.42018350485419449381e-64, 3.44529741669704549053e-64, 1.72195028068798787234e-64, -7.71131282746138929148e-65, -3.73409370874318746763e-65, 1.60834004214072503677e-65, 7.60831947551514313391e-66, -3.14328780958034778198e-66, -1.46335422699286981003e-66, 5.78718457833728128387e-67, 2.66689617596230382667e-67, -1.00880509696280069268e-67, -4.61895983775711508609e-68, 1.67260267497569858597e-68, 7.61989919029544753044e-69, -2.64831598427804907865e-69, -1.19943507801090743734e-69, 4.01787769940897319872e-70, 1.80396559378215966442e-70, -5.85624780098585253329e-71, -2.59551290523915115512e-71, 8.21628484202734600625e-72, 3.57651404485765027578e-72, -1.11103831514193980098e-72, -4.72566128359057677543e-73, 1.44920921877028230407e-73, 5.99533906598473785485e-74, -1.82428527485791837947e-74, -7.31433306402219567524e-75, 2.21696634235480626965e-75, 8.59597637567641813737e-76, -2.60179915243179789111e-76, -9.75019700966434277304e-77, 2.95004910595105400467e-77, 1.06966258502395606104e-77, -3.23371642214075041931e-78, -1.1375568427009877255e-78, 3.42983822178186059237e-79, 1.17543882569179491367e-79, -3.52404860615558379473e-80, -1.18283693839184361695e-80, 3.51253712330315600652e-81, 1.16167881538470405284e-81, -3.40199668428596807411e-82, -1.11560979286413049478e-82, 3.20771485902847816309e-83, 1.04924648871640087302e-83, -2.95043273368796747332e-84, -9.67543052924339005806e-85, 2.6528231721338882861e-85, 8.75356580172735160406e-86, -2.33638490483657391639e-86, -7.77206960169762118037e-87, 2.01927853310931227025e-87, 6.77168680718984736483e-88, -1.71527565844910739666e-88, -5.78819140591374617405e-89, 1.43368304473051774495e-89, 4.85190215834187219659e-90, -1.17992188126806891136e-90, -3.98706394826058991203e-91, 9.5640461111383505274e-92, 3.21123679838809467683e-92, -7.63422880663229099746e-93, -2.53497241927220955843e-93},
            {1.29544325144194211176e-60, 3.06510023419460345508e-59, 3.46690207143480073879e-58, 2.49350004636633970997e-57, 1.27978183529589305207e-56, 4.98583748593880783417e-56, 1.53093971090684628918e-55, 3.79726445791155246578e-55, 7.73503063048955709411e-55, 1.30837401862172850458e-54, 1.85056821751828138065e-54, 2.19670535676374235415e-54, 2.19003229863123707358e-54, 1.82986802364139613356e-54, 1.27481002780251490214e-54, 7.34170128488343767007e-55, 3.45054811032280583358e-55, 1.29896252642854132642e-55, 3.80984009906599237487e-56, 8.33599779973929224018e-57, 1.25958431794842460423e-57, 1.09718933016668763724e-58, 1.94109798341520497858e-60, -2.35798228286083209949e-61, 1.01307261961963631926e-61, -5.80789406856732538578e-62, -4.06548578515589974074e-62, 2.19680239507872465441e-62, 1.39594568074942753095e-62, -7.37938102652965168166e-63, -4.39168753366018716427e-63, 2.2483059945018785573e-63, 1.26516537608834738148e-63, -6.25686367315476728265e-64, -3.35306905840727241635e-64, 1.59973483406934558648e-64, 8.22632664724483322622e-65, -3.77909745491228940771e-65, -1.88026307821711550022e-65, 8.29676331872492370371e-66, 4.0270787812341149036e-66, -1.70262026984156684838e-66, -8.12173019252027841681e-67, 3.28415108228491058422e-67, 1.5485654550601781022e-67, -5.98521913898006997316e-68, -2.80031200543269040637e-68, 1.03548331398889201685e-68, 4.81442925841125185068e-69, -1.70772082134558674718e-69, -7.88448326371127681655e-70, 2.69410251957686750897e-70, 1.23185328026840771381e-70, -4.0769251662785091548e-71, -1.83856941215423021659e-71, 5.93008344155690564504e-72, 2.62473910951043713187e-72, -8.30255372333330325416e-73, -3.58877385390618722941e-73, 1.11991102965828268215e-73, 4.70631406097618131491e-74, -1.45623510641634476192e-74, -5.92904416425164994829e-75, 1.82616885074656919867e-75, 7.1884426040698823049e-76, -2.20948638459887031347e-76, -8.40412718387907038267e-77, 2.58051577273161045034e-77, 9.49499470320791086533e-78, -2.91131918282214259072e-78, -1.03904501164721529434e-78, 3.1757465784777930696e-79, 1.10390569437029079511e-79, -3.35344411767315215405e-80, -1.14128882851358333771e-80, 3.43285300670597597009e-81, 1.15072954139712977169e-81, -3.41250743356021942314e-82, -1.13371415100746564907e-82, 3.30043000231716624359e-83, 1.09312861956733288164e-83, -3.11194497852842953936e-84, -1.03270818711282742661e-84, 2.866600156780166216e-85, 9.56602748799052852987e-86, -2.58500144403565155499e-86, -8.69089732120858592451e-87, 2.28622450818362251425e-87, 7.74400011166681592855e-88, -1.98616935291725051681e-88, -6.76594406311361241706e-89, 1.69689688791716224544e-89, 5.79438656944222931289e-90, -1.42674079307114738254e-90, -4.86257468670851885262e-91, 1.18087618315587659484e-91, 3.99782398625065441997e-92, -9.62041391185861078342e-93, -3.22028260502349830144e-93, 7.71203329368131629513e-94},
            {3.89552967212667523055e-61, 8.81235285362661408305e-60, 9.5071285018024765208e-59, 6.50599127283139920626e-58, 3.16828933001187787587e-57, 1.16741511634112752232e-56, 3.37818948714438748236e-56, 7.86440703472525459715e-56, 1.49653403929375180831e-55, 2.35187616252454414054e-55, 3.07092658639613698857e-55, 3.33987373142188365099e-55, 3.02309391210792865339e-55, 2.26802616534682729149e-55, 1.39940387769518995671e-55, 7.01514858011664200614e-56, 2.80569045425154786708e-56, 8.71221013805870272281e-57, 2.01186123497001176928e-57, 3.19918047503708393658e-58, 2.92430516093005517402e-59, 5.40436162765417023356e-61, -6.77802513916295791841e-62, 3.09064462804429584115e-62, -1.87008989938991947048e-62, -1.3444642578672829866e-62, 7.59224996196544391793e-63, 4.97610193956606668273e-63, -2.73155670517928022702e-63, -1.67846224226645927333e-63, 8.88456460753404256776e-64, 5.1598215129650317434e-64, -2.63042452063337777436e-64, -1.45327928677218174794e-64, 7.13104368231323752839e-65, 3.77544039709905287598e-65, -1.78065500313288183446e-65, -9.10856345854505456044e-66, 4.12053359986554416701e-66, 2.05328294342767382742e-66, -8.88977784515693758934e-67, -4.34722527287014478382e-67, 1.79843754221727047105e-67, 8.68120348398159033544e-68, -3.43008081243482985847e-68, -1.64066152491386767064e-68, 6.19788712016808621061e-69, 2.94225181128376256612e-69, -1.0655682038244595757e-69, -5.01727407654751328282e-70, 1.74939600979108999327e-70, 8.14928057540307544726e-71, -2.75053638840954944406e-71, -1.26262231638639370868e-71, 4.1505946501332775111e-72, 1.86867598006752158844e-72, -6.02048731327513920207e-73, -2.64555301981145400491e-73, 8.40288446137411583956e-74, 3.58824606574618117664e-74, -1.12927938573732150638e-74, -4.67046183874218551892e-75, 1.46210162742003645708e-75, 5.84461481864313314247e-76, -1.82462423902992390543e-76, -7.04622103136988443936e-77, 2.19606547610728422917e-77, 8.20196426937152806058e-78, -2.55108155564931793368e-78, -9.23954635147158381325e-79, 2.86311584131206784899e-79, 1.00969172691703420228e-79, -3.10831728350712879753e-80, -1.07288204498004553675e-80, 3.2691100700234181552e-81, 1.11096113496973864733e-81, -3.33656702369885798287e-82, -1.12325539740972325363e-82, 3.31108654567238169922e-83, 1.11067558323826792961e-83, -3.20136342540192252836e-84, -1.07532424887116347822e-84, 3.02209469300990267417e-85, 1.02013862587439173191e-85, -2.79112207093193575938e-86, -9.48624706615541350885e-87, 2.52672243511451058877e-87, 8.64671983268232276746e-88, -2.24555858894845109012e-88, -7.72399732673130770328e-89, 1.96150342502532108141e-89, 6.75984773643509710029e-90, -1.68527149917151840879e-90, -5.79448184723859123037e-91, 1.42461662979494180732e-91, 4.86415144039866675098e-92, -1.18480719409347422639e-92, -3.99889051554107127095e-93, 9.69145652774854085099e-94, 3.22088174566133641984e-94},
            {1.10592608204083570697e-61, 2.38622869414590533642e-60, 2.44943729950905686518e-59, 1.59043395445679024257e-58, 7.32529961627542073861e-58, 2.54369149626437894914e-57, 6.908630413564854411e-57, 1.5024589836528331427e-56, 2.65631770161493312343e-56, 3.85378871121933360728e-56, 4.61035483219948900051e-56, 4.55233866169731608349e-56, 3.69980637764670986106e-56, 2.45832449897346494521e-56, 1.32029220018492828057e-56, 5.63206150996276414352e-57, 1.85797665611200460452e-57, 4.54225605660862592266e-58, 7.62233974633226324682e-59, 7.32985598157271702272e-60, 1.41901614238763010671e-61, -1.84023691820157810179e-62, 8.90558594491953705072e-63, -5.70676502551804114564e-63, -4.21792609309495331699e-63, 2.49512780873365152099e-63, 1.68838864280771094166e-63, -9.64128288559997464847e-64, -6.12253504425337620332e-64, 3.35555038740454120495e-64, 2.01301185065406297037e-64, -1.05905956768377933685e-64, -6.03704943246441070203e-65, 3.0496939609274816063e-65, 1.66355660470106416089e-65, -8.06224074756509768706e-66, -4.24273406236077928119e-66, 1.96923024108773541618e-66, 1.00800116209789908185e-66, -4.47213703715260007405e-67, -2.24316773285570855004e-67, 9.49990336545077944763e-68, 4.69678363822851334079e-68, -1.89817289242694894562e-68, -9.28633270908758089852e-69, 3.58565051977593946486e-69, 1.73873465319265549527e-69, -6.43209075333326681551e-70, -3.08996957036067879759e-70, 1.09982063355517470046e-70, 5.22174695844407860049e-71, -1.79799646322586419441e-71, -8.4046920952279129616e-72, 2.81676378831429821975e-72, 1.29042341914867907171e-72, -4.23569896779600307311e-73, -1.89283077189064322541e-73, 6.12083551327058038538e-74, 2.65683256992463564108e-74, -8.50658855188600752678e-75, -3.57482098940632801365e-75, 1.13770367610839457703e-75, 4.61976142938340117303e-76, -1.46516599914167390028e-76, -5.74608085173387973886e-77, 1.81810211925230012404e-77, 6.89428804932105638508e-78, -2.1756233910115200666e-78, -7.9983506561475886458e-79, 2.51325271520448016485e-79, 8.99401968596760301989e-80, -2.80629063309078036116e-80, -9.82611647098994534388e-81, 3.03344549175660986129e-81, 1.04533331273808569441e-81, -3.17986656218077141112e-82, -1.08500780680474719232e-82, 3.23888674524781371527e-83, 1.10058760301494199798e-83, -3.21216889187895066635e-84, -1.09234095701756058993e-84, 3.10840651073789557282e-85, 1.06162998651645710659e-85, -2.94108901416651025392e-86, -1.01072823287243953797e-86, 2.72599240270902942295e-87, 9.42683416742450211445e-88, -2.47898143137374573986e-88, -8.61186785888703648127e-89, 2.21447811538481656737e-89, 7.70399526017381125163e-90, -1.94467596856606629159e-90, -6.74708130901971101274e-91, 1.67936171848451857389e-91, 5.78418778859118864751e-92, -1.42610171868433277379e-92, -4.85435484036998704072e-93, 1.19055858760460473241e-93, 3.98983243544469779155e-94, -9.76784597471226641137e-95},
            {2.9575168019908773242e-62, 6.07170178978146807351e-61, 5.91357709936680530634e-60, 3.63160001865070244266e-59, 1.57632631394273546677e-58, 5.1375204628106213574e-58, 1.30349389204979926296e-57, 2.63375398320765129466e-57, 4.29863773653858372998e-57, 5.71383587138073151196e-57, 6.20598257955944873038e-57, 5.50211084614440885678e-57, 3.96033706372593446238e-57, 2.29045433430851439154e-57, 1.04676269120924089753e-57, 3.68303288196903626276e-58, 9.56542603484124686874e-59, 1.69918156874744804893e-59, 1.72378080498965677298e-60, 3.50631117054445755614e-62, -4.71131943213452947044e-63, 2.41957447937475672579e-63, -1.64748439442669388574e-63, -1.25351685200144160905e-63, 7.78634667015974509472e-64, 5.44605942692968952746e-64, -3.24103559962400351362e-64, -2.1292917927699990174e-64, 1.21007770248642468155e-64, 7.50573582097665916546e-65, -4.08018793508206117245e-65, -2.40179059194964068005e-65, 1.25039865838539634826e-65, 7.0327755250638644852e-66, -3.505489543990385812e-66, -1.89913152831284000379e-66, 9.05117965076053272508e-67, 4.76219697395966956145e-67, -2.1666422979675443119e-67, -1.11533439606111233305e-67, 4.8385667850800099141e-68, 2.45144738771812148356e-68, -1.01395419690460441664e-68, -5.07614070390287685011e-69, 2.00437570601725439941e-69, 9.93286404001529641785e-70, -3.75499609006524333719e-70, -1.84126912378538681546e-70, 6.69283238574774865575e-71, 3.240017642579968081e-71, -1.13855691550893594186e-71, -5.42170775147722777995e-72, 1.85310667310063670189e-72, 8.64177315215919815662e-73, -2.89082415260001254524e-73, -1.31420745040479029249e-73, 4.32782229479985050476e-74, 1.910150435954871958e-74, -6.22358889631783656261e-75, -2.65837893257195639146e-75, 8.60301399359130875666e-76, 3.54961981402875893825e-76, -1.14391376333969096205e-76, -4.55723811834199969548e-77, 1.46417687282803218915e-77, 5.63868872652560347171e-78, -1.80568404075152709498e-78, -6.73997063658728116175e-79, 2.1479128102525224789e-79, 7.80200847563558643253e-80, -2.46772599429937759912e-80, -8.76737027407131138205e-81, 2.74260718699729159465e-81, 9.58582091142579376486e-82, -2.95388335475859466141e-82, -1.02178338615452320906e-82, 3.0891762216878241367e-83, 1.06360239977042411257e-83, -3.14356280932924049965e-84, -1.08251318354188952865e-84, 3.11931857126868316982e-85, 1.07814195189707335324e-85, -3.02451180593565796875e-86, -1.05121073188868035017e-86, 2.87097586635325719315e-87, 1.00349859185059441026e-87, -2.67223679269474309749e-88, -9.37787924781131035759e-89, 2.44183828504577165829e-89, 8.57743859318388877193e-90, -2.19226957446989998341e-90, -7.67689124252324723187e-91, 1.93446985186921164291e-91, 6.72274648152137359651e-92, -1.67773388602233992745e-92, -5.76088406815286400762e-93, 1.42980481309555610611e-93, 4.83273051789609210342e-94, -1.19699108759405763681e-94, -3.97227007713154984307e-95},
            {7.43316586614002726016e-63, 1.44791461608564058355e-61, 1.33377078042928028463e-60, 7.7191068796196991944e-60, 3.1447280245999801642e-59, 9.57453375520335605497e-59, 2.25697810671533172624e-58, 4.20988276120387649535e-58, 6.29523922869210805004e-58, 7.59700235003350453727e-58, 7.40865571929151941156e-58, 5.81716357110990007841e-58, 3.64449167261521366701e-58, 1.79355457214280773163e-58, 6.76069535477901570113e-59, 1.87265400440297308877e-59, 3.53360169240093747362e-60, 3.79354582709536484631e-61, 8.13394534524192047842e-63, -1.135310547429591655e-63, 6.18688714890947574287e-64, -4.49066622096227020842e-64, -3.52338035995861192378e-64, 2.30363240378531412491e-64, 1.66778459991095219968e-64, -1.03633787329968637713e-64, -7.05230242274253585201e-65, 4.16219524615949409367e-65, 2.67211486636674819817e-65, -1.5028465972882991632e-65, -9.14364486259847638744e-66, 4.91129068112576607954e-66, 2.8505151642363685147e-66, -1.46274945135465176021e-66, -8.16407145498480822205e-67, 3.9987911962187793421e-67, 2.16397124446001520069e-67, -1.01038835304627376124e-67, -5.34115592851101534118e-68, 2.3751789839713142647e-68, 1.23385540720569209086e-68, -5.22617435202387832244e-69, -2.6787198466042038052e-69, 1.08225459424901345381e-69, 5.48355805680785223338e-70, -2.11945084099705130105e-70, -1.06128678548848904391e-70, 3.9412882582160134669e-71, 1.94627568659430138664e-71, -6.98256198374053571282e-72, -3.38859620113162371079e-72, 1.18160482095414165462e-72, 5.61126752505555751347e-73, -1.9135698550431247886e-73, -8.85316145788573251189e-74, 2.96986867208576419695e-74, 1.33329802033683399711e-74, -4.42180259670710001513e-75, -1.92039645393643026021e-75, 6.32108269332979966118e-76, 2.65090229467586895871e-76, -8.68259483531318389922e-77, -3.5148284002984044147e-77, 1.14692339180075955534e-77, 4.48691857008888943035e-78, -1.45837024728301934271e-78, -5.52832221995738977979e-79, 1.78712624071109834922e-79, 6.59055286860869870258e-80, -2.11347995751148948181e-80, -7.62069277870444768096e-81, 2.41599699506783943917e-81, 8.56657147363694738261e-82, -2.67449704116280936384e-82, -9.38091411975376566388e-83, 2.87279235952242613534e-83, 1.00240636101916180925e-83, -3.00056438798353912786e-84, -1.04655096939286452843e-84, 3.0540345395057712131e-85, 1.06848088207115685364e-85, -3.03545286872483668775e-86, -1.06724190445028137755e-86, 2.95174290385647006723e-87, 1.04305969131350772944e-87, -2.81279726057697960709e-88, -9.97405233609960353165e-89, 2.62988756795577458459e-89, 9.32979031887807801778e-90, -2.41448193266946895101e-90, -8.53562583514685436767e-91, 2.17754585318737450376e-91, 7.63720974655130030332e-92, -1.92922815411639668658e-92, -6.68388494367001238959e-93, 1.67875413460318062186e-93, 5.72409783607244239261e-94, -1.43436608055226336428e-94, -4.80127233519351120756e-95, 1.20323124507618820899e-95},
            {1.75113693763927080052e-63, 3.22617239550939457861e-62, 2.80068089070573554286e-61, 1.52130711720532431987e-60, 5.78974180162993092065e-60, 1.63774666979785515697e-59, 3.56394566193832191291e-59, 6.09056938129134531739e-59, 8.26856294496196593982e-59, 8.95922145731148503317e-59, 7.7377609188299844961e-59, 5.28815029529584014524e-59, 2.81909807392135654458e-59, 1.14426922315633889309e-59, 3.39544455603673812191e-60, 6.83253132193583567573e-61, 7.78948384762666428931e-62, 1.76678764713059665652e-63, -2.56976907138701341351e-64, 1.48587084063721702666e-64, -1.15329102607274810456e-64, -9.35071235895435704509e-65, 6.4504396631447390789e-65, 4.84191891680690607871e-65, -3.14761412266191778933e-65, -2.22170051022641138957e-65, 1.36391857764527224638e-65, 9.07354978868971321263e-66, -5.28688855635467998425e-66, -3.32803181711969359342e-66, 1.84644400794430560354e-66, 1.10685587094618561379e-66, -5.85339792775062771311e-67, -3.36828905967183086422e-67, 1.69705848529084242324e-67, 9.45233588095762151269e-68, -4.53296849265546770356e-68, -2.46223604029401155236e-68, 1.12318592705288323767e-68, 5.98591052766615149773e-69, -2.59807308917553855172e-69, -1.36412185652177072289e-69, 5.64234568268241970642e-70, 2.92445878326127434663e-70, -1.15625499112841973776e-70, -5.91516378275302069989e-71, 2.24534567983737939332e-71, 1.13153640142471677953e-71, -4.14629613135228620141e-72, -2.05148601151903147882e-72, 7.30079722956173651323e-73, 3.53194955862938241981e-73, -1.22831278725328908673e-73, -5.78540923836011258165e-74, 1.97760927766343077891e-74, 9.03383099386919238591e-75, -3.05046742899008634345e-75, -1.34745417244159286305e-75, 4.51227625343346117818e-76, 1.9239815627434433524e-76, -6.40629845390443606654e-77, -2.6359183377129385326e-77, 8.73774496620824671775e-78, 3.473435651911112605e-78, -1.14611082613503125677e-78, -4.41338840577727031652e-79, 1.44751297666828932481e-79, 5.42089921660420858292e-80, -1.76283673354203955216e-80, -6.45258148200419126613e-81, 2.07355359678547170571e-81, 7.46051677719577051192e-82, -2.36015470092365646116e-82, -8.39608904310714074127e-83, 2.60477265994557656096e-83, 9.21313166109005973666e-84, -2.79340598551627092519e-84, -9.87035043455196249383e-85, 2.91727447735803268711e-85, 1.03333647642922234469e-85, -2.97312357126772911149e-86, -1.0576766625589664023e-86, 2.9626124071433493095e-87, 1.0586325254048927115e-87, -2.89114474460668486668e-88, -1.03610379728375690644e-88, 2.76656558375941522575e-89, 9.9143951392892037973e-90, -2.59805553295091316065e-90, -9.27418331195124183764e-91, 2.39537613943501639476e-91, 8.48043921891203787419e-92, -2.16844094786477788474e-92, -7.58167393192551029737e-93, 1.92707810249460265683e-93, 6.63000900979134654921e-94, -1.68083638990085806248e-94, -5.67621366356363506627e-95, 1.43874947485897928248e-95, 4.76570619381398177574e-96},
            {3.85515599854233079386e-64, 6.69340161251018779396e-63, 5.45368208267343734844e-62, 2.76737796302420729491e-61, 9.78503644146798048152e-61, 2.55518758874008249684e-60, 5.09435120398841070982e-60, 7.90391816967693874103e-60, 9.63431190890195457024e-60, 9.24493210822936282547e-60, 6.94959149738665594312e-60, 4.04130088125334163095e-60, 1.77688070882042737239e-60, 5.6774156659980616261e-61, 1.22375878412588924558e-61, 1.48741074646343465169e-62, 3.58262767372805383929e-64, -5.45085395248227027271e-65, 3.34424136605750011722e-65, -2.78421244131206179874e-65, -2.33870777888281715692e-65, 1.70628604806424629865e-65, 1.3305554847381304417e-65, -9.06698068054370198812e-66, -6.64845841466566107705e-66, 4.25268909376362040329e-66, 2.93540049300236571661e-66, -1.77450280058149792483e-66, -1.15695926524600592747e-66, 6.63863290560876937651e-67, 4.11402567667895775598e-67, -2.24453624390703635894e-67, -1.33274915827333741162e-67, 6.91382040035589595784e-68, 3.9664019724234474787e-68, -1.95531421420613818225e-68, -1.09206662495976725478e-68, 5.11399979970344345053e-69, 2.79776015815611235984e-69, -1.24516237666363432119e-69, -6.70079736912371430608e-70, 2.83921713202026808778e-70, 1.50612383250072692776e-70, -6.09465922291004492677e-71, -3.18695065886398823849e-71, 1.2371203075674037296e-71, 6.36520776094999528924e-72, -2.38327365955983277796e-72, -1.20273439839647662331e-72, 4.37009593000199703067e-73, 2.15458621757907240039e-73, -7.64406488734287291011e-74, -3.66676540571841500402e-74, 1.27761158882254659015e-74, 5.94051742020173056513e-75, -2.0430148433512018004e-75, -9.18159429803563145943e-76, 3.12897135430342762991e-76, 1.35688716651981097057e-76, -4.59422750732807290579e-77, -1.92191062714049783822e-77, 6.4735419684369475982e-78, 2.61556955733303212989e-78, -8.76351593876921974325e-79, -3.42890682506420831514e-79, 1.14125987126730151172e-79, 4.3413212839884971951e-80, -1.43189290961037135293e-80, -5.32180337538128361374e-81, 1.73379223303945119687e-81, 6.33128863600630140082e-82, -2.02987780584256558897e-82, -7.32548049815662387731e-83, 2.30263598448615219594e-83, 8.25763065821542089059e-84, -2.53632743516766818461e-84, -9.0811175139103079117e-85, 2.71871285064906547329e-85, 9.75200676918160054207e-86, -2.84197784470934033326e-86, -1.0231898461589940879e-86, 2.90281034960540405311e-87, 1.04911783111850983857e-87, -2.90183220873397411164e-88, -1.05123932550056360603e-88, 2.84272034608704383483e-89, 1.02930800902166172914e-89, -2.73134004609225019652e-90, -9.84721613380001050919e-91, 2.57508726562109422485e-91, 9.20464564490029789139e-92, -2.38247329080225334955e-92, -8.40831854795664149906e-93, 2.16285993455593916572e-93, 7.50978356607878728412e-94, -1.92621211371942684925e-94, -6.56389284236947355582e-95, 1.68277852407539292128e-95, 5.62394479105777967589e-96, -1.44270727431619830968e-96},
            {7.90387624923890067953e-65, 1.28798669580666382159e-63, 9.80344700180238533535e-63, 4.62176435210130108196e-62, 1.50859529544878908846e-61, 3.6092122510612250982e-61, 6.53284128793898307594e-61, 9.1003429586436645819e-61, 9.82367131813920535411e-61, 8.20467529750022479787e-61, 5.24787200863272475921e-61, 2.51690127975330692367e-61, 8.71084519782487560325e-62, 2.02156574294422122998e-62, 2.63132710684116831427e-63, 6.75908102466124509604e-65, -1.08060276069658739265e-65, 7.03642322370979272902e-66, -6.30233421442606095006e-66, -5.5013076382084135336e-66, 4.25513822361245377634e-66, 3.45495867055351185916e-66, -2.47298853022463444742e-66, -1.88716199526706497366e-66, 1.25994353140819429007e-66, 9.03632626147873215745e-67, -5.67602622801147815735e-67, -3.83756024766216889892e-67, 2.28033801861345892915e-67, 1.46237676412870761517e-67, -8.24066533927213900101e-68, -5.05341816651250935643e-68, 2.70195755467516882296e-68, 1.59782714419102248918e-68, -8.10432355104986026066e-69, -4.65732425520287085463e-69, 2.24070577940954854443e-69, 1.25915612629286209781e-69, -5.75040536757370572671e-70, -3.17357595918757239569e-70, 1.37835827057915036127e-70, 7.48743426102992598104e-71, -3.10276262146793396724e-71, -1.65921949045434637592e-71, 6.5899360246366531471e-72, 3.46337645391482513214e-72, -1.32565070344910245766e-72, -6.82656417556480828422e-73, 2.53350944964010886621e-73, 1.27350844591599548014e-73, -4.61096411415312081775e-74, -2.25346352102512674098e-74, 8.00617606277708658752e-75, 3.79053236342713196176e-75, -1.3281219087755576196e-75, -6.07475964366085762672e-76, 2.10737442503464503538e-76, 9.29730383417079793628e-77, -3.20189024538816380682e-77, -1.36223080037150873437e-77, 4.66348674425870830757e-78, 1.91566422062258302029e-78, -6.51896337582234307075e-79, -2.59239236752895853559e-79, 8.7579656795545003883e-80, 3.38482688530114980792e-80, -1.13255948234407031527e-80, -4.27502632273936133008e-81, 1.41225983665578122142e-81, 5.23540239685064646662e-82, -1.7014067004304446384e-82, -6.23017818628210250167e-83, 1.98450810791665731362e-83, 7.21723224440533822914e-84, -2.24596586470052839996e-84, -8.15017301328649724928e-85, 2.47185142540627517074e-85, 8.98076568620701818662e-86, -2.65118798342945951763e-86, -9.66197794455224260097e-87, 2.77656057384902478193e-87, 1.01517909391885839468e-87, -2.84410758494687960925e-88, -1.04175584753787339609e-88, 2.85311790894508077784e-89, 1.04402592378092386275e-89, -2.80550884184419390195e-90, -1.02177035959776237575e-90, 2.70539130593211910485e-91, 9.76579990076769183194e-92, -2.55879362339945068284e-92, -9.11738446546736211779e-93, 2.37348662141429056657e-93, 8.31875209378831739968e-94, -2.15879021054080198685e-94, -7.42468052128975448902e-95, 1.92526596467577186275e-95, 6.49322553965871560949e-96, -1.68429365224544819909e-96, -5.58177339928962286741e-97},
            {1.5031538282622949079e-65, 2.28822247561528789671e-64, 1.61813461980143335839e-63, 7.04227185993406298123e-63, 2.10598207298270859539e-62, 4.57419661768135335001e-62, 7.43365919494994577847e-62, 9.17046171018162408432e-62, 8.61600587798315653629e-62, 6.12283898277447126666e-62, 3.22987788929053578931e-62, 1.21929458359489829691e-62, 3.06476417463989390274e-63, 4.29404894770520979231e-64, 1.1818926325109957214e-65, -1.99602716933575805743e-66, 1.38023706136328064311e-66, -1.33390374516324747546e-66, -1.21433073771436161472e-66, 9.98161773251090743653e-67, 8.46122985587475741126e-67, -6.37482561573600530878e-67, -5.07301266464717862948e-67, 3.54159768263881052369e-67, 2.64345138036446035649e-67, -1.7280626025771769521e-67, -1.21312350553218070633e-67, 7.47546444038942447236e-68, 4.96643152505180735161e-68, -2.89415755311419987983e-68, -1.83465546288550813082e-68, 1.01213725311302205356e-68, 6.17477916012548101476e-69, -3.2254427763671467175e-69, -1.9086018610016160861e-69, 9.44207551443020256923e-70, 5.45375302547783380976e-70, -2.55766672024004861674e-70, -1.44846367885235840735e-70, 6.45286485638648892455e-71, 3.5914919620495398806e-71, -1.52502440142705892076e-71, -8.34423345159674902922e-72, 3.39263528145013381797e-72, 1.82214553955145027905e-72, -7.13328994984858702796e-73, -3.75003884965957062762e-73, 1.4221473273597578567e-73, 7.2914340059130663323e-74, -2.69528416502968818519e-74, -1.34256083482392559572e-74, 4.86547343710957664967e-75, 2.34643801082365235967e-75, -8.37880995909437445151e-76, -3.90181570582428567044e-76, 1.37829617398939700264e-76, 6.18827915861307385941e-77, -2.16832492363037584552e-77, -9.38473592501004681821e-78, 3.26624732000037804478e-78, 1.3644695242726232786e-78, -4.71712868994810873595e-79, -1.90703864545104519842e-79, 6.54087406540829628768e-80, 2.56905535082911125577e-80, -8.72221587514314344743e-81, -3.34455010450984029562e-81, 1.12056426714717587525e-81, 4.21805622454922496265e-82, -1.38972585243213567022e-82, -5.16469315728024002841e-83, 1.66736709453920472199e-83, 6.15080335097954666193e-84, -1.93959260667505277252e-84, -7.13506856083274709126e-85, 2.1925087342618353546e-85, 8.07024343305299867966e-86, -2.41358799760322870812e-86, -8.90579385925361116801e-87, 2.59259336441345528331e-87, 9.59166322983680126374e-88, -2.72200095493767408632e-88, -1.00830708860614425675e-88, 2.79703508431676963358e-89, 1.03457822672507131741e-89, -2.81552216372750907168e-90, -1.03608910205478540359e-90, 2.7777526146621309231e-91, 1.01280300229307095673e-91, -2.68643926717784709784e-92, -9.66618554436621957999e-93, 2.54673904003551455702e-93, 9.01187677220982607407e-94, -2.36622711715850476096e-94, -8.21520611521412986139e-95, 2.15471783573413884061e-95, 7.33497008264553300971e-96, -1.92391388799258770734e-96, -6.43449233866316716503e-97, 1.68700433591525968772e-97},
            {2.6396555138197538681e-66, 3.73327229144564688938e-65, 2.43710012642961182831e-64, 9.71731000946051989734e-64, 2.63818564653250097396e-63, 5.14469627115580399678e-63, 7.40415777131253656406e-63, 7.94981897195852484667e-63, 6.35512965270739548317e-63, 3.72454408429077914679e-63, 1.54642367853863869975e-63, 4.23940905797919447812e-64, 6.43199114372678828779e-65, 1.90708427076223727532e-66, -3.42314942964408994713e-67, 2.51633592981471873247e-67, -2.63165380494743261271e-67, -2.50902928661394378004e-67, 2.19705356696719099065e-67, 1.95034176456269601387e-67, -1.55000432345348932301e-67, -1.28926900870603342821e-67, 9.42965246570096711636e-68, 7.33795337292171650371e-68, -5.00068518564277949529e-68, -3.65032682345027473571e-68, 2.33612731287041881402e-68, 1.60977213369903886735e-68, -9.71362268058547878513e-69, -6.37179844003006356819e-69, 3.63107558337983812267e-69, 2.28733791800277301285e-69, -1.2317362048252982419e-69, -7.51084226826358794238e-70, 3.82413137579854244446e-70, 2.27194742966789267006e-70, -1.09501746948035662451e-70, -6.36757996682953035415e-71, 2.9117753806466178021e-71, 1.6614420805940127115e-71, -7.2334796549575972016e-72, -4.05177626453644634819e-72, 1.68738740267436587005e-72, 9.26627785476658955981e-73, -3.71201896315379997529e-73, -1.99310856580000362339e-73, 7.7273002510022633532e-74, 4.04271723245192675569e-74, -1.52632897024667084732e-74, -7.75217290638968626448e-75, 2.86679806042621380371e-75, 1.40881264270889606706e-75, -5.12878704474542489912e-76, -2.43245278248077120167e-76, 8.75234536194381009029e-77, 4.0004201087276564852e-77, -1.4265792703980989756e-77, -6.2831788751805465515e-78, 2.22379625262139557519e-78, 9.45017454613570175385e-79, -3.31987418897132767358e-79, -1.36483282312490037301e-79, 4.75373342726865858434e-80, 1.89795999103114481372e-80, -6.539837127556608682e-81, -2.54809571519839328634e-81, 8.66020738690003205272e-82, 3.31088959957668884267e-82, -1.10612182744371365652e-82, -4.17291019994669045032e-83, 1.36563708140212851462e-83, 5.11109944023787465323e-84, -1.63345397600128003437e-84, -6.0927438592146315906e-85, 1.89715968195875357083e-85, 7.07615588758182290676e-86, -2.14425295863656184218e-86, -8.01241127133336846037e-87, 2.36315092961208517542e-87, 8.84847900574513633465e-88, -2.54386101302539734822e-88, -9.53182217827971517939e-89, 2.67834231548021001309e-89, 1.00160879308034307227e-89, -2.76069146841680007806e-90, -1.02670156089182165118e-90, 2.78730926514037182809e-91, 1.02673985706026629039e-91, -2.75713827543881522379e-92, -1.00200058937848921408e-92, 2.67195311628519469146e-93, 9.54783877818807916606e-94, -2.53659801384771784696e-94, -8.891849790612932997e-95, 2.35905213366288344158e-95, 8.10709272018812544017e-96, -2.15028038892721810183e-96, -7.25901214504836003629e-97, 1.92398010093807702741e-97, 6.42214388559534820322e-98},
            {4.25747341572904011561e-67, 5.55852827431633729435e-66, 3.32441863132553758688e-65, 1.20337993856598255992e-64, 2.93327273440936697023e-64, 5.06559232507244054198e-64, 6.34502885036499418562e-64, 5.7964326511356143625e-64, 3.8213803740718669342e-64, 1.76268034628316691543e-64, 5.31427700123668963685e-65, 8.79206377806146140119e-66, 2.82533343099824912218e-67, -5.42816269613630233201e-68, 4.24902282242236409086e-68, -4.8229866229289960422e-68, -4.83908913086232107827e-68, 4.52528149183403034156e-68, 4.22169607069746340134e-68, -3.54699305439244563037e-68, -3.09187559499108045936e-68, 2.37388682912815740275e-68, 1.92981048260630781977e-68, -1.37343498349662847389e-68, -1.04412659462732115139e-68, 6.95075193983977565719e-69, 4.97419571338865065257e-69, -3.11228253513586204538e-69, -2.11486132304807392853e-69, 1.24644027660928041519e-69, 8.11500309046603637143e-70, -4.50983695743305727669e-70, -2.83620005885157770823e-70, 1.48759353613196996668e-70, 9.09722672218452395269e-71, -4.50993762562619772349e-71, -2.69466373240001617057e-71, 1.26575748175842382607e-71, 7.4088104943828087913e-72, -3.30947876018427831712e-72, -1.89884965901483598536e-72, 8.10470368712172830333e-73, 4.55300355485498257057e-73, -1.8673831763883536137e-73, -1.02456210846196466012e-73, 4.06287368106400557153e-74, 2.1699529956906397914e-74, -8.37142404655955212318e-75, -4.33711515368435082381e-75, 1.63731328354968284827e-75, 8.20215069120035828909e-76, -3.04535457193165789755e-76, -1.47152900616670436294e-76, 5.39512243429130738875e-77, 2.51120001997988154525e-77, -9.1168505148704108217e-78, -4.08742076859069758607e-78, 1.4715707415207932135e-78, 6.36329960687333012039e-79, -2.27222260807157134624e-79, -9.50174348032877570426e-80, 3.36161721645462520797e-80, 1.36466755232988373045e-80, -4.77348832113371198616e-81, -1.89029176894655278605e-81, 6.51853161157247587701e-82, 2.53167996380612877014e-82, -8.57819212228365231097e-83, -3.28587488337174391531e-83, 1.09027575422303226482e-83, 4.14085474262074112188e-84, -1.34143072175143369413e-84, -5.07443195575354433982e-85, 1.60136490380547816032e-85, 6.05377147866240869344e-86, -1.85893172508621892933e-86, -7.03593778560092341302e-87, 2.10264658308216849472e-87, 7.96992865753076695641e-88, -2.3214146024597238755e-88, -8.8004764244634982778e-89, 2.50506356111251789119e-89, 9.47348091346002735587e-90, -2.64475744186782775931e-90, -9.942403387631377464e-91, 2.73341145301220672669e-91, 1.01745099012655992216e-91, -2.7661929542075005832e-92, -1.01557178280699500561e-92, 2.74110037632590602994e-93, 9.89308602205747221714e-94, -2.65952009895220118939e-94, -9.4146676134793539145e-95, 2.52662827419454143863e-95, 8.7673662694724554613e-96, -2.35156696316227099175e-96, -8.01441980153146936269e-97, 2.14748460083516507797e-97, 7.23506714850701594301e-98, -1.9317674319698888112e-98},
            {6.26743607602489224108e-68, 7.49665677387913513911e-67, 4.07037935628217247884e-66, 1.32284372745100733543e-65, 2.85546611837237656626e-65, 4.2917734078872466415e-65, 4.57382031539515380177e-65, 3.4457919626323788509e-65, 1.78786858945239031957e-65, 5.98778518498752996732e-66, 1.08926455323893440881e-66, 3.82053854611341474345e-68, -7.9204259999063399254e-69, 6.61904606503738055819e-69, -8.179039748069927206e-69, -8.68465570011406778984e-69, 8.6955202813135018016e-69, 8.55983503539556044562e-69, -7.62071155956512481198e-69, -6.98229939614125716925e-69, 5.63942787907328912925e-69, 4.79995862175237750056e-69, -3.57427967412261639419e-69, -2.83488273846562079503e-69, 1.96631674951656827423e-69, 1.46346175572431867727e-69, -9.50859007730330124175e-70, -6.70121418635853651937e-70, 4.08998104685893908021e-70, 2.75486164162137454884e-70, -1.58179828605869768073e-70, -1.02687168910180857616e-70, 5.55396211791953537222e-71, 3.49887187842230244465e-71, -1.78572289314651054953e-71, -1.09707341642111668864e-71, 5.29768900972962328528e-72, 3.18298030265570433958e-72, -1.45981920651038300903e-72, -8.58456206585088904212e-73, 3.75763551798891780495e-73, 2.16063203943142036682e-73, -9.07803624361070414702e-74, -5.09211107877008296016e-74, 2.06639080270605257169e-74, 1.12720199593745265118e-74, -4.44555593508513942725e-75, -2.35039083507201460635e-75, 9.06174396419639941819e-76, 4.62935071069696625944e-76, -1.75366886775534212093e-76, -8.63654046425940879027e-77, 3.22760507225810893012e-77, 1.53041028265887935393e-77, -5.65833672880669925401e-78, -2.58316761027907967554e-78, 9.46312355748885069489e-79, 4.16505877402467290423e-79, -1.51217099295770440376e-79, -6.43381756567710291265e-80, 2.3126992546663880811e-80, 9.5485606791618321436e-81, -3.39143614762926108758e-81, -1.3653018183329058071e-81, 4.77812579663273468682e-82, 1.88565555844720694656e-82, -6.48141330523846330796e-83, -2.52141121319025955151e-83, 8.48402365559610306095e-84, 3.27059744507488476997e-84, -1.07415495290458692625e-84, -4.12187271333876535419e-85, 1.31849192306319552933e-85, 5.05300441144866121448e-86, -1.5725571518619140231e-86, -6.03017601437928000083e-87, 1.82618066088493641671e-87, 7.00867723248161849146e-88, -2.06849596253350962889e-88, -7.93545173582938049448e-89, 2.28848246647142352244e-89, 8.75364455388763091531e-90, -2.47546945525732331117e-90, -9.40876661105201141373e-91, 2.61969431005954148027e-91, 9.85555413201174689571e-92, -2.71299438788745558459e-92, -1.00642738838559778697e-92, 2.74963649152560768383e-93, 1.00252940190024825473e-93, -2.72719438956007320207e-94, -9.75126728764172577496e-95, 2.64733405108832856237e-95, 9.27718972734096405406e-96, -2.51640931989213553908e-96, -8.65976288273474623531e-97, 2.34593187250143058999e-97, 7.97879237339806703723e-98, -2.15325575408566432684e-98, -7.34482519893532491284e-99},
            {8.35830751715847207093e-69, 9.07620847627117659716e-68, 4.42440206480916323819e-67, 1.27333451089651530371e-66, 2.39214564752000116113e-66, 3.05900203528315083504e-66, 2.68840882671690776251e-66, 1.59395050216541210481e-66, 6.00429475331829648722e-67, 1.21317716537724050047e-67, 4.68305502328995292924e-69, -1.05738786157552718577e-69, 9.4690326027753160386e-70, -1.27784604693299649439e-69, -1.44522039419632391367e-69, 1.5535091247286565581e-69, 1.62113875365914712581e-69, -1.53309398723487353348e-69, -1.48140588004059667896e-69, 1.26146917660736563965e-69, 1.12698115403532888621e-69, -8.79825224051708415658e-70, -7.29432582401402211078e-70, 5.28101548931962077799e-70, 4.09406344068867797338e-70, -2.76662360381905973389e-70, -2.02478040542073555298e-70, 1.28151281405917020791e-70, 8.93995357850719826802e-71, -5.30996660028991514501e-71, -3.56169166674527947179e-71, 1.98859049846588802307e-71, 1.29161580488994426431e-71, -6.79285972406244639994e-72, -4.29423949843813746178e-72, 2.13355592217155874254e-72, 1.31672290836211747498e-72, -6.20491221769552399955e-73, -3.74205529961654942801e-73, 1.6809097938458788917e-73, 9.89830921142628750568e-74, -4.26290912478435809544e-74, -2.44590025949669303824e-74, 1.01626278147089189615e-74, 5.66468448234964624476e-75, -2.2850039383339292388e-75, -1.23340484890485790354e-75, 4.85860214214669661614e-76, 2.53226887628459824211e-76, -9.79110948156665804204e-77, -4.91643183393146536459e-77, 1.87353603771965696093e-77, 9.0529396348370448646e-78, -3.4098800809005283101e-78, -1.5856374800633295762e-78, 5.91256975691923187154e-79, 2.64959969727830502319e-79, -9.78366937055390339671e-80, -4.23651154978799965736e-80, 1.54769586108312763779e-80, 6.50070516145557691045e-81, -2.34506917312159135679e-81, -9.59980565051895404453e-82, 3.41038749640147826083e-82, 1.36791444313897939621e-82, -4.77070867164253662783e-83, -1.88528204494682943593e-83, 6.43421396757196767445e-84, 2.51819998357831452647e-84, -8.38632548325995245194e-85, -3.26515481498057222271e-85, 1.05886070695866958899e-85, 4.1147383452112820412e-86, -1.29802416727125636973e-86, -5.04388512025875120014e-87, 1.54812341597648487471e-87, 6.01721097342129095838e-88, -1.79963610238311958028e-88, -6.98807530500047397427e-89, 2.04193265528072941399e-89, 7.90177350722283813488e-90, -2.26373191514719476532e-90, -8.70080966756743775531e-91, 2.45367383234183104308e-91, 9.33162717716278634475e-92, -2.60108993058279453885e-92, -9.75170104688876380037e-93, 2.69699362153674074367e-93, 9.93574576486708085872e-94, -2.73522147966568771939e-94, -9.88011542796624703875e-95, 2.71359048545008307764e-95, 9.60529821825026042579e-96, -2.63495704471883980911e-96, -9.157672994176862684e-97, 2.50821727388182228204e-97, 8.61333995188263247174e-98, -2.34959749196872289071e-98, -8.08891762180801614809e-99, 2.18505980096850132006e-99},
            {1.00075278254624962185e-69, 9.75645636351174568692e-69, 4.21164796555266969505e-68, 1.05490024754969452147e-67, 1.68609635467942769199e-67, 1.77802654074250447583e-67, 1.22971904051353207079e-67, 5.29286390291153692346e-68, 1.20268683355704991757e-68, 5.16056740310612529807e-70, -1.28279163957835773089e-70, 1.23739337020952898049e-70, -1.83003813417611031104e-70, -2.22100185352777926778e-70, 2.57061621097728945172e-70, 2.85872059389519903307e-70, -2.87923499808961886465e-70, -2.94535692391509437633e-70, 2.65058165034230378734e-70, 2.49253181066561763617e-70, -2.04447096024357667567e-70, -1.77559970109610883509e-70, 1.34437245116207515166e-70, 1.08743843909353509606e-70, -7.65579992706106298527e-71, -5.82658208265384329467e-71, 3.82979843723245526428e-71, 2.77033279615637839013e-71, -1.70433276783596704939e-71, -1.18238284096629567156e-71, 6.82247248539164983209e-72, 4.57276316315692611252e-72, -2.48064685643337853867e-72, -1.61493194027315975957e-72, 8.26270894168745347958e-73, 5.24161315688338801298e-73, -2.53993642558567265535e-73, -1.57193125993886083621e-73, 7.25118878849522846347e-74, 4.37554874461356140977e-74, -1.93278655425456652789e-74, -1.13495400374716720414e-74, 4.8310747830499993831e-75, 2.7530238602034565132e-75, -1.13639867528351371762e-75, -6.26546351325426858486e-76, 2.52287569982119568636e-76, 1.34204845438131707076e-76, -5.2987194430665464742e-77, -2.71384225839391203779e-77, 1.05496837748390623517e-77, 5.19665701477537058735e-78, -1.99480548746085546128e-78, -9.45174143075453360207e-79, 3.58857161012384674156e-79, 1.63786537277883187052e-79, -6.15287365176017896406e-80, -2.71237421556574648352e-80, 1.00735051721155453598e-80, 4.30556285771285402471e-81, -1.57794742598330193289e-81, -6.57011318851045098695e-82, 2.36993156592516052399e-82, 9.66379773225860307988e-83, -3.42049723859080075645e-83, -1.37342304963479766549e-83, 4.75528970003797942006e-84, 1.88990612532115959666e-84, -6.38333516324711987125e-85, -2.52220828671382966367e-85, 8.29362387625989677921e-86, 3.26869351564435749348e-86, -1.04536248720919862863e-86, -4.11720396080979752808e-87, 1.28094474143793381438e-87, 5.04325233037838782259e-88, -1.52871025969376083864e-88, -6.00961030870367464431e-89, 1.77945150857420148116e-89, 6.96790664922484918534e-90, -2.02244769962933743379e-90, -7.86250908816615038107e-91, 2.24592811252112549978e-91, 8.63643029359833661651e-92, -2.43779330503272227934e-92, -9.23844589320589298351e-93, 2.58664268014654974321e-93, 9.630279235867122535e-94, -2.68307308070569745551e-94, -9.7928089074038499392e-95, 2.72113644856837674026e-95, 9.73092298391930043238e-96, -2.69984305922164806644e-96, -9.4779236740393214796e-97, 2.62473660800325205545e-97, 9.10230786246738946971e-98, -2.50990133017462002429e-98, -8.72245628702495407894e-99, 2.38133466979060896811e-99, 8.53865237370705782576e-100},
            {1.06398432606064406973e-70, 9.18556801888308517814e-70, 3.45089909175145766811e-69, 7.35378735808277026716e-69, 9.69250930441319797524e-69, 8.04316203178765208501e-69, 4.03799682378076341525e-69, 1.04827686913363116677e-69, 5.06149227243552557105e-71, -1.40266373064648391894e-71, 1.4678047030800904352e-71, -2.38847219111178058074e-71, -3.13736647395015225648e-71, 3.92263881640494314223e-71, 4.67686705779220542218e-71, -5.03107569397764405095e-71, -5.47201429240139978042e-71, 5.21759535383066681903e-71, 5.18084264951123911135e-71, -4.47511817618184558746e-71, -4.08114113159457940319e-71, 3.23808683605230993637e-71, 2.73801032831718830439e-71, -2.0118426152736928554e-71, -1.59467736950920369555e-71, 1.09027687228608883092e-71, 8.18819704221893663602e-72, -5.22486929365235692523e-72, -3.75310543576533923581e-72, 2.24075023283238945888e-72, 1.55128454609936758314e-72, -8.68971190007444781802e-73, -5.83062668873853567804e-73, 3.07496669250311449581e-73, 2.00660478466980532013e-73, -1.00068320688255843767e-73, -6.3597295791119037654e-74, 3.0149257917929020424e-74, 1.86541330045363922387e-74, -8.45707216328322392845e-75, -5.08535574830225785692e-75, 2.21893065228096880398e-75, 1.29339521647969083476e-75, -5.46632884621339387722e-76, -3.07984278813291537239e-76, 1.26829854052230151567e-76, 6.88902478466759898836e-77, -2.77866662569781507312e-77, -1.45218129439881007913e-77, 5.76100426165822469936e-78, 2.89402015324240610699e-78, -1.13258569838548598978e-78, -5.46988804346380421774e-79, 2.11533649426958362781e-79, 9.83620233776375932634e-80, -3.76052421934540892806e-80, -1.6881626271852386656e-80, 6.37575804854997706392e-81, 2.77380978354808002318e-81, -1.03307057371587627794e-81, -4.37620772657279053634e-82, 1.60323374619159365892e-82, 6.6477400695651425558e-83, -2.38857255645451895488e-83, -9.74717976484471229329e-84, 3.42453858618963431177e-84, 1.3824015062938901427e-84, -4.73648369239598619942e-85, -1.89971483189765617836e-85, 6.3352008842925331637e-86, 2.53286921476623776843e-86, -8.2135315202118395498e-87, -3.27954178041275240705e-87, 1.03441208720281530195e-87, 4.12627453575317980017e-88, -1.26781386469160944786e-88, -5.04681424594888006653e-89, 1.51448454900955193822e-89, 6.00212600843387604997e-90, -1.76522836043093520212e-90, -6.9426197913623592666e-91, 2.00898738002818895894e-91, 7.81269659521302444137e-92, -2.23339665379080755207e-92, -8.55716918820017276099e-93, 2.42571606886963637328e-93, 9.12865987795427149236e-94, -2.57414933961897813963e-94, -9.49497841769014403684e-95, 2.6694805450271061163e-95, 9.64595921715803187918e-96, -2.7069385670944685995e-96, -9.60045500782148631497e-97, 2.68832238814854593199e-97, 9.4163060541175301162e-98, -2.62477027998863735635e-98, -9.20941671462637545667e-99, 2.54122277498277751468e-99, 9.19316431301150373281e-100, -2.48472938323479452172e-100},
            {9.90871535477197407056e-72, 7.4447380174309225799e-71, 2.37951690610892901112e-70, 4.18130844791430043958e-70, 4.3366548110038685281e-70, 2.61206983401170411125e-70, 7.90872667786332585108e-71, 4.36402800488997011365e-72, -1.3685959456199092911e-72, 1.56856993079507783647e-72, -2.82162481049743630341e-72, -4.05143770010866720438e-72, 5.4925664965492528252e-72, 7.06934906426371242491e-72, -8.14843258608720170974e-72, -9.46895635722644919626e-72, 9.59339965220782833602e-72, 1.00942125288590446012e-71, -9.20513203976786732531e-72, -8.83844242089950536396e-72, 7.36506163622186048156e-72, 6.52352884774745865144e-72, -5.01253041558737310839e-72, -4.14489550995577768993e-72, 2.95266777171553490018e-72, 2.30547388437395444726e-72, -1.52810373974724718002e-72, -1.1378595100961854489e-72, 7.03833396357499282383e-73, 5.0381387977638749761e-73, -2.9174402836814298137e-73, -2.01939262911488119257e-73, 1.0988397037188891528e-73, 7.38211295688352754322e-74, -3.79204859310966438722e-74, -2.47661439458876471585e-74, 1.2075298671877517478e-74, 7.6657242337527264707e-75, -3.56939794004441013588e-75, -2.19917433804159090679e-75, 9.84263882166067215658e-76, 5.87157575095543146428e-76, -2.54219853813536958847e-76, -1.46442516720369590688e-76, 6.17070314066969476411e-77, 3.42398470610780843363e-77, -1.41153461202664599388e-77, -7.53056893524799090737e-78, 3.05011410884465576677e-78, 1.56316589595110625937e-78, -6.23938064519526318538e-79, -3.07255053971783948365e-79, 1.21074381975681163328e-79, 5.73765435318871059033e-80, -2.23319069879422702518e-80, -1.02121851129252140971e-80, 3.92339011549765072363e-81, 1.73790433887937960964e-81, -6.57958846372575361977e-82, -2.83642231627984806791e-82, 1.05566275189733100614e-82, 4.45223462128739742228e-83, -1.62433572373116489802e-83, -6.73825428849987582967e-84, 2.40282654131142327949e-84, 9.85428858979440174929e-85, -3.42573989256132869484e-85, -1.39503415881286286248e-85, 4.71899799523507767683e-86, 1.91435124199513614844e-86, -6.29563450059295359573e-87, -2.5489767871300256969e-87, 8.1520590845272131381e-88, 3.29541488462080719311e-88, -1.02648342120894038838e-88, -4.13853973070637854929e-89, 1.25880244731875325789e-89, 5.05025252630543326016e-90, -1.50514863498346844872e-90, -5.99004201286218304879e-91, 1.75609397399426331734e-91, 6.907869263768538964e-92, -2.00010210172905797393e-92, -7.7493194631271611334e-93, 2.22424766975832867461e-93, 8.46247151079405746507e-94, -2.41541332152878505181e-94, -9.0056896710289408055e-95, 2.56195387249056909413e-95, 9.35582827366803126218e-96, -2.65578631537472571345e-96, -9.51744586482427771308e-97, 2.69497095493262693645e-97, 9.53586865033781683188e-98, -2.68720920017972069385e-98, -9.52080923783585983451e-99, 2.65543771232456491435e-99, 9.69360312218453336158e-100, -2.64803660934662552898e-100, -1.04814919879422686228e-100},
            {7.94464977006875702157e-73, 5.0782450916521876845e-72, 1.33840649680208288923e-71, 1.85059698281313571036e-71, 1.3930397367341314784e-71, 5.05987290855175430539e-72, 3.25603641252284904773e-73, -1.17681329814789953687e-73, 1.49623378121999177691e-73, -2.9928229037985457567e-73, -4.75194127498675785449e-73, 7.01659704980447523787e-73, 9.82597712791986639772e-73, -1.21799827976985051611e-72, -1.52059695543161846032e-72, 1.64209771077142158338e-72, 1.83822828545470937177e-72, -1.77462103125899997217e-72, -1.79932322228492409808e-72, 1.57851524250642886457e-72, 1.46793992956975830439e-72, -1.18197700421395286282e-72, -1.02149351625101224945e-72, 7.59565267662668619405e-73, 6.17527460857995745623e-73, -4.25835471858371444669e-73, -3.29115022017303779344e-73, 2.11205746827780457728e-73, 1.56488191568922812561e-73, -9.37894347855675022324e-74, -6.70341227551680812848e-74, 3.76752811408952510187e-74, 2.6079240758295281224e-74, -1.38118282267591161787e-74, -9.2769828629776056876e-75, 4.65593236631477091219e-75, 3.03469582576683010212e-75, -1.45235905215538384104e-75, -9.17425431494712442961e-76, 4.21443740728546121872e-76, 2.57444124462482476678e-76, -1.14258264002363508452e-76, -6.73276898870408039452e-77, 2.9045003664030078279e-77, 1.64715347540365445048e-77, -6.94368588864920724746e-78, -3.78325704524356176047e-78, 1.56517406642293695354e-78, 8.18671712244506133118e-79, -3.33422693666205337277e-79, -1.67479594277851614313e-79, 6.72722118654341878041e-80, 3.25011657902921419617e-80, -1.28829985323694526916e-80, -6.00306718628673851411e-81, 2.34685462490929730063e-81, 1.05875946451356635169e-81, -4.07590661730728131066e-82, -1.78862792876638450764e-82, 6.76479113103255888038e-83, 2.90265743843279135732e-83, -1.07557859979591544135e-83, -4.53682943534784301588e-84, 1.64242496124011728233e-84, 6.84482957937620212037e-85, -2.4148837158479931867e-85, -9.98677263350843640952e-86, 3.42745416779592564835e-86, 1.411110330848608311e-86, -4.70716965945362097929e-87, -1.93297189262634276367e-87, 6.26932046131416208745e-88, 2.56883430986598044034e-88, -8.11311595424980941037e-89, -3.31367022718623592108e-89, 1.02174255688740286745e-89, 4.15053051683578039225e-90, -1.25369979516194669918e-90, -5.04965204451037226368e-91, 1.50000127792422614983e-91, 5.96963544794738980852e-92, -1.75082629443725442467e-92, -6.86098342249991657662e-93, 1.9941422607535184192e-93, 7.67183743541807011767e-94, -2.21665708240492518087e-94, -8.35543045555294158157e-95, 2.40535581195052443463e-95, 8.87890719927622295522e-96, -2.54964918279969892339e-96, -9.23413717316850506174e-97, 2.64425824938424907785e-97, 9.45344434772764812604e-98, -2.6933273968971774866e-98, -9.63752446767360715291e-99, 2.71709253605164584586e-99, 1.00104437210787980853e-99, -2.76401104441143877179e-100, -1.1029618442671785746e-100, 2.93400958864960243107e-101},
            {5.36162536152713421568e-74, 2.82592535609030192783e-73, 5.86028330509092441005e-73, 5.88062048470270373019e-73, 2.66925258343527376841e-73, 2.0593270717742913179e-74, -8.77724798021683816689e-75, 1.2593289713041119062e-74, -2.822377638744833881e-74, -5.02315112686512609418e-74, 8.12271599724791811466e-74, 1.24889706897877985343e-73, -1.67199468743863499746e-73, -2.25665644338146857313e-73, 2.60684138964986910971e-73, 3.11863667450508001237e-73, -3.19702276566239642764e-73, -3.43437902185841992773e-73, 3.18032605201733373114e-73, 3.1130528281531803592e-73, -2.63271131185594214056e-73, -2.38271084771056126395e-73, 1.85303897630783033788e-73, 1.5712021996652868833e-73, -1.12914606843449086301e-73, -9.07029240655127058057e-74, 6.04779744667332613491e-74, 4.64363282316576803613e-74, -2.88422262044084407102e-74, -2.13077226887141072461e-74, 1.23831985543052778272e-74, 8.84003394852490299962e-75, -4.8317308130204143554e-75, -3.34023686350141895843e-75, 1.72710110964684850286e-75, 1.15662285990734088296e-75, -5.69385185055134841406e-76, -3.68992150593277507753e-76, 1.74102970540803760343e-76, 1.08969707671455399757e-76, -4.96059349288791066015e-77, -2.99172156495840156853e-77, 1.32207786731001656615e-77, 7.66651395560139569156e-78, -3.30655875931562479073e-78, -1.84071395487807062869e-78, 7.78213454714325095799e-79, 4.1560684275218655409e-79, -1.72785654719701078373e-79, -8.85621067192491170708e-80, 3.62759207966785306072e-80, 1.78736972970049896175e-80, -7.2180870717790307232e-81, -3.42832650173417671556e-81, 1.36432118792144076498e-81, 6.27054386804505607814e-82, -2.45542438706455436054e-82, -1.09715605016754993968e-82, 4.2180622184290713e-83, 1.84186770516572096064e-83, -6.93383867530035958733e-84, -2.97462759914766868441e-84, 1.09353983337782256806e-84, 4.63224331015637790086e-85, -1.6589416370371965659e-85, -6.96883970740626710644e-86, 2.42706457489110678071e-86, 1.01434900550234745919e-86, -3.43282470839574670245e-87, -1.4300584315161814494e-87, 4.70455527674921920018e-88, 1.95435011258340836269e-88, -6.25940046525202609073e-89, -2.59044465148517935023e-89, 8.09824076930665602068e-90, 3.33158669671839328573e-90, -1.020049648656764898e-90, -4.1590700689965321896e-91, 1.25195942730076227018e-91, 5.04189200124939289763e-92, -1.49803927233536066593e-92, -5.93858735274363369687e-93, 1.74802083155539655919e-93, 6.80144324920640681296e-94, -1.98950648568861268628e-94, -7.58297800876531558515e-95, 2.20924502407488837583e-95, 8.24460873791141615905e-96, -2.3951669430996099862e-96, -8.76828617268067146678e-97, 2.53938441684017873152e-97, 9.17418300819355841291e-98, -2.64273852052238443924e-98, -9.55226771997189829284e-99, 2.72238476959503358157e-99, 1.01244331026184543045e-99, -2.82572612885413549825e-100, -1.13696110021684497738e-100, 3.05732337297220425279e-101, 1.42716958469226636131e-101},
            {2.95215943332106391326e-75, 1.22425278922321592612e-74, 1.84239974005197318523e-74, 1.1147456321938697285e-74, 1.07335944809696185727e-75, -5.56136842677745017666e-76, 9.21499216065366921713e-76, -2.33806445181449989996e-75, -4.74024910511758853814e-75, 8.45311079260222281722e-75, 1.44202426598016915565e-74, -2.09582854461172326797e-74, -3.08003887516111339722e-74, 3.82172668105259027571e-74, 4.9108969066200834494e-74, -5.36423030443684665193e-74, -6.12806618823158497953e-74, 6.00752982429029238131e-74, 6.20713735139324213676e-74, -5.52721089287418514232e-74, -5.25021265531462898547e-74, 4.27958796757475789755e-74, 3.79126047515203140201e-74, -2.84467298557509944202e-74, -2.37856629980054357144e-74, 1.65043322540333447833e-74, 1.31489978965722907681e-74, -8.47538329324873190062e-75, -6.47901218416315342457e-75, 3.89816777496989430558e-75, 2.87263646576165259268e-75, -1.62210432755293886107e-75, -1.15515776585054301743e-75, 6.15921780418766679068e-76, 4.24126025823637748358e-76, -2.14942869107409078024e-76, -1.43002933607832941658e-76, 6.93544676536571057907e-77, 4.45039537754767556748e-77, -2.07939872241268223025e-77, -1.28425213229318793039e-77, 5.81708067604107948585e-78, 3.45100826431055431183e-78, -1.52364584370896597653e-78, -8.67023399785512969026e-79, 3.7477974916556013969e-79, 2.04447682993700402038e-79, -8.68053466277848762121e-80, -4.54182437210267756272e-80, 1.89793679620920562309e-80, 9.54041033934356095545e-81, -3.92676478421606381032e-81, -1.90170684510532209199e-81, 7.70650414101153986214e-82, 3.60959112741087822109e-82, -1.43820320530131752934e-82, -6.54536536423132439912e-83, 2.55872951904794709803e-83, 1.1373451111676381953e-83, -4.35112947141289932173e-84, -1.89898606223334275878e-84, 7.09101513152581789372e-85, 3.0538824082638730794e-85, -1.11046396621610380675e-85, -4.7395592013987035954e-86, 1.67544555407127438033e-86, 7.10974228483581611845e-87, -2.44158519234853616577e-87, -1.03206915623912185746e-87, 3.44448078876362600834e-88, 1.45101511851469085383e-88, -4.71361270826791014288e-89, -1.97701368991624466278e-89, 6.26723905957120053338e-90, 2.61172330840421140323e-90, -8.10658006345092887756e-91, -3.3466442685671621746e-91, 1.02099187925348790853e-91, 4.1615980626517454015e-92, -1.25277939985066722415e-92, -5.02499919547575179387e-93, 1.49809613393816197298e-93, 5.89640632881239865671e-94, -1.74630474195032825816e-94, -6.73159260719380115436e-95, 1.98497807061589960654e-95, 7.49038978606066981629e-96, -2.20167122630730023667e-96, -8.14833038685503603557e-97, 2.38684074192293437841e-97, 8.71540491631471850564e-98, -2.53860080293995608332e-98, -9.27031104288070226524e-99, 2.67098327237635337147e-99, 1.00285203944291111131e-99, -2.82941412600494508068e-100, -1.14810032202323365838e-100, 3.12102047407120609714e-101, 1.46737599070325489012e-101, -3.77441600155642566555e-102},
            {1.26554620929920075351e-76, 3.80838885637737786931e-76, 3.4555383531170935372e-76, 4.42569921556531211217e-77, -2.90940399469999065296e-77, 5.7486025063482228464e-77, -1.67557685711801361371e-76, -3.94642473279418937914e-76, 7.8317968597674836092e-76, 1.50065905723201637047e-75, -2.38285830399313600983e-75, -3.84445246376788209373e-75, 5.14873005332489981266e-75, 7.14740129099692360467e-75, -8.35142472691107840178e-75, -1.01883666166197363219e-74, 1.06081210938661094593e-74, 1.16059434592350645549e-74, -1.09114911604167008925e-74, -1.09048819970536896111e-74, 9.33834914216542925736e-75, 8.66043119645744995632e-75, -6.79803764824751781043e-75, -5.92628274089952976129e-75, 4.28661046002545402297e-75, 3.54843533382916567368e-75, -2.37705929570858410563e-75, -1.88252668563985011546e-75, 1.17410032640025988094e-75, 8.94065646143190134813e-76, -5.22159608308197574862e-76, -3.8339475602973313819e-76, 2.11009654162800103687e-76, 1.4952580746799434092e-76, -7.80795630260857011097e-77, -5.33682578898166222228e-77, 2.66251078177734462347e-77, 1.752757706513992478e-77, -8.41155379553956159871e-78, -5.32315008835223421161e-78, 2.47295911588532882983e-78, 1.50172136594310853096e-78, -6.79104418713638339864e-79, -3.95212691615379663344e-79, 1.7475794243768199966e-79, 9.74221360321089766005e-80, -4.22639762019574288706e-80, -2.2582611687278335422e-80, 9.63161592086741127873e-81, 4.94123937023867483618e-81, -2.07368069539728740292e-81, -1.02435087164259120166e-81, 4.22869957575715026088e-82, 2.0191012896848819851e-82, -8.18868170732264197607e-83, -3.79689672280524849697e-83, 1.50975568441140399073e-83, 6.83311121715560845896e-84, -2.65737920189160370433e-84, -1.18018264061802393136e-84, 4.47755762007069721168e-85, 1.96101993573631645511e-85, -7.24198324056461118706e-86, -3.1412371879983185856e-86, 1.12736921966038121635e-86, 4.85858137092067123117e-87, -1.69345619542334249942e-87, -7.26516101032805607088e-88, 2.46033756516176185729e-88, 1.05124633463833022394e-88, -3.46429345034825158483e-89, -1.47292178293543100032e-89, 4.73550379191310262662e-90, 1.99940297239417303709e-90, -6.29237698233077070661e-91, -2.63071571092686677432e-91, 8.13511305661598283779e-92, 3.35678679810744521916e-92, -1.02394500900306418775e-92, -4.15646816544888659185e-93, 1.25521457033857540585e-93, 4.99851561868891395913e-94, -1.49902244998392918753e-94, -5.84505395021331100242e-95, 1.74462949845564252975e-95, 6.65810984295251100301e-96, -1.98025659971416885989e-96, -7.41052439916087607362e-97, 2.19574694553271988149e-97, 8.10482849779493274783e-98, -2.38729182899675839609e-98, -8.80895541261353047291e-99, 2.56606241498287547454e-99, 9.72857633388923392165e-100, -2.77484562093293654429e-100, -1.13569751844144530273e-100, 3.12125073989885370718e-101, 1.47827057487682923255e-101, -3.84440283215158828712e-102, -2.23061175373660791312e-102},
            {3.89587631143332686891e-78, 7.06808721618537720123e-78, 1.3530814838287192591e-78, -1.2058344111649933081e-78, 2.97587296268761022333e-78, -1.01824575420411288386e-77, -2.85503368475921012523e-77, 6.38318445737877149621e-77, 1.39401549870805277374e-76, -2.43781080417953549935e-76, -4.35915527839740265029e-76, 6.33814542732857554022e-76, 9.56759457546719761783e-76, -1.2012948308169955814e-75, -1.5724197734041708097e-75, 1.74525191647827306136e-75, 2.0289647209150686968e-75, -2.02017409630781212032e-75, -2.12995957457234284615e-75, 1.92112156138703975133e-75, 1.8691822532046816916e-75, -1.53826665474253444881e-75, -1.40060467843095301539e-75, 1.05803130255911666014e-75, 9.11368538930734145646e-76, -6.35510298024434427922e-76, -5.22066174158358919285e-76, 3.37985292225348152175e-76, 2.66245848861223406995e-76, -1.61016896082134383851e-76, -1.2201491316624165474e-76, 6.93899046430871579527e-77, 5.06436396978911034244e-77, -2.72735426943020814848e-77, -1.91664358556609240763e-77, 9.84433880450950476292e-78, 6.65303749800915831159e-78, -3.28178534052442849399e-78, -2.12936466462491305811e-78, 1.0152683112070836721e-78, 6.31432392794078307936e-79, -2.92647926888779822145e-79, -1.74263811370145173822e-79, 7.88702328551876672337e-80, 4.49519818344370801946e-80, -1.99355894798820319022e-80, -1.08826827703313608411e-80, 4.73953910754909031223e-81, 2.48251703201419506911e-81, -1.06272870945778404679e-81, -5.35651252294465187423e-82, 2.25349456340050078518e-82, 1.09723995530877507615e-82, -4.53117095500313802301e-83, -2.14121186117992569375e-83, 8.66308203801551958271e-84, 3.99349419993466891447e-84, -1.5792460081001541241e-84, -7.13903229149414786345e-85, 2.75272267333754280139e-85, 1.22634456354185938529e-85, -4.60073365595261105306e-86, -2.02855969362580146984e-86, 7.39319893189670285196e-87, 3.23667848317729624893e-87, -1.1452688377232635206e-87, -4.98785883461459076111e-88, 1.71429859429514101465e-88, 7.43115531894831345451e-89, -2.48470732201459553699e-89, -1.07113810573139751052e-89, 3.49321479333045948685e-90, 1.49463859952199818427e-90, -4.77003514715280890208e-91, -2.02003551367501030457e-91, 6.33267502381475192566e-92, 2.64580523496810934696e-92, -8.17910820721065806815e-93, -3.36066714889721053566e-93, 1.02816187632684500872e-93, 4.14326062389818794606e-94, -1.25832497532212332714e-94, -4.96403859518834316116e-95, 1.4999349570785515401e-95, 5.7902290015057033086e-96, -1.74273577693149554676e-96, -6.59544887991168200469e-97, 1.9769525907329975181e-97, 7.37780784274135588421e-98, -2.19776425242674241829e-98, -8.19577912793736031698e-99, 2.41397867551953530515e-99, 9.24280041289507230985e-100, -2.66535305831564026144e-100, -1.10050423941484357253e-100, 3.05799675463137426885e-101, 1.45919306221544335007e-101, -3.83694484068788568211e-102, -2.24128221801732941665e-102, 5.53283388553165256364e-103}
        };

        const double ccli22logA1k2[100][100] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
            {0, 1., 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
            {0.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
            {-0.0833333333333333333333, 0.0138888888888888888889, 0, -0.000231481481481481481481, 0, 5.51146384479717813051e-6, 0, -1.37786596119929453263e-7, 0, 3.47945949797801649654e-9, 0, -8.80698356447915530808e-11, 0, 2.2304227551141131388e-12, 0, -5.64946716053763811138e-14, 0, 1.43101034271297409402e-15, 0, -3.62478116426343645507e-17, 0, 9.18167138060038252534e-19, 0, -2.32574411430208722345e-20, 0, 5.89117839938244578616e-22, 0, -1.4922529045062578084e-23, 0, 3.77992075389613843385e-25, 0, -9.57465111478700407544e-27, 0, 2.42528745935810816978e-28, 0, -6.14332490110885029697e-30, 0, 1.55612237618250744534e-31, 0, -3.9417040261677165576e-33, 0, 9.9844529374702238411e-35, 0, -2.52909147411381710285e-36, 0, 6.40626354242364705372e-38, 0, -1.62272551210778183921e-39, 0, 4.11041174033446826184e-41, 0, -1.04117945697012394886e-42, 0, 2.63733837410748571625e-44, 0, -6.68045614324822661422e-46, 0, 1.69217930926159271861e-47, 0, -4.28634026373645291654e-49, 0, 1.08574267253896915526e-50, 0, -2.75021831781608742584e-52, 0, 6.96638438089912649142e-54, 0, -1.76460577795048479505e-55, 0, 4.46979865210128444357e-57, 0, -1.13221322518457020159e-58, 0, 2.86792960278023415089e-60, 0, -7.26455054891482307233e-62, 0, 1.84013215061411112514e-63, 0, -4.66110918896355751201e-65, 0, 1.18067275027991169975e-66, 0, -2.99067901381537344434e-68, 0, 7.57547843935182684514e-70, 0, -1.91889110533034196879e-71, 0, 4.86060795182060225784e-73, 0, -1.23120637724955626043e-74, 0, 3.11868218627299217704e-76, 0, -7.8997142629363323425e-78, 0, 2.0010209988924177533e-79, 0, -5.0686454025238206384e-81},
            {0.00694444444444444444444, 0, -0.000347222222222222222222, 0, 0.0000137786596119929453263, 0, -4.8225308641975308642e-7, 0, 1.56575677409010742344e-8, 0, -4.84384096046353541944e-10, 0, 1.44977479082417354022e-11, 0, -4.23710037040322858354e-13, 0, 1.21635879130602797992e-14, 0, -3.44354210605026463232e-16, 0, 9.6407549496304016516e-18, 0, -2.67460573144740030697e-19, 0, 7.36397299922805723269e-21, 0, -2.01454142108344804134e-22, 0, 5.48088509314940072908e-24, 0, -1.48407092279198563169e-25, 0, 4.00172430794087848013e-27, 0, -1.07508185769404880197e-28, 0, 2.87882639593763877388e-30, 0, -7.68632285102704728732e-32, 0, 2.04681285218139588743e-33, 0, -5.43754666934470677113e-35, 0, 1.44140929704532058709e-36, 0, -3.81340495345328732215e-38, 0, 1.00705087638194472415e-39, 0, -2.65500761527381606959e-41, 0, 6.98894669138483714807e-43, 0, -1.83712543939326231891e-44, 0, 4.82271103139553924802e-46, 0, -1.26447037780225361038e-47, 0, 3.31151515124385592354e-49, 0, -8.66318770112067539141e-51, 0, 2.26407492379221610971e-52, 0, -5.9114293561341240634e-54, 0, 1.54208053497494313303e-55, 0, -4.01935694940522421564e-57, 0, 1.04679430501478546508e-58, 0, -2.72420645584305865213e-60, 0, 7.08450877986432783179e-62, 0, -1.84113812964060521724e-63, 0, 4.78172463863364238399e-65, 0, -1.2411317907333799794e-66, 0, 3.21957833672452640919e-68, 0, -8.34717630818698756423e-70, 0, 2.16297053856016800474e-71, 0, -5.60198901648548098495e-73, 0, 1.45018721661694136232e-74, 0, -3.75236427489475786269e-76, 0, 9.70495184462822610352e-78, 0, -2.50897947424929121601e-79, 0},
            {0, -0.000208333333333333333333, 0, 0.0000165343915343915343915, 0, -8.68055555555555555556e-7, 0, 3.75781625781625781626e-8, 0, -1.45315228813906062583e-9, 0, 5.2191892469670247448e-11, 0, -1.77958215556935600509e-12, 0, 5.83852219826893430361e-14, 0, -1.85951273726714290145e-15, 0, 5.78445296977824099096e-17, 0, -1.7652397827552842026e-18, 0, 5.30206055944420120754e-20, 0, -1.57134230844508947225e-21, 0, 4.60394347824549661243e-23, 0, -1.33566383051278706852e-24, 0, 3.84165533562324334093e-26, 0, -1.09658349484792977801e-27, 0, 3.10913250761264987579e-29, 0, -8.76240805017083390754e-31, 0, 2.45617542261767506491e-32, 0, -6.85130880337433053162e-34, 0, 1.90266027209982317495e-35, 0, -5.26249883576553650456e-37, 0, 1.45015326199000040278e-38, 0, -3.98251142291072410438e-40, 0, 1.0902756838560345951e-41, 0, -2.97614321181708495663e-43, 0, 8.10215453274450593668e-45, 0, -2.20017845737592128206e-46, 0, 5.96072727223894066238e-48, 0, -1.6113529124084456228e-49, 0, 4.34702385368105493064e-51, 0, -1.17046301251455656455e-52, 0, 3.14584429134888399138e-54, 0, -8.44064959375097085284e-56, 0, 2.26107569883193660456e-57, 0, -6.04773833197159020772e-59, 0, 1.61526800180906674565e-60, 0, -4.30826322335901620835e-62, 0, 1.14761391327207417216e-63, 0, -3.05318420520411474933e-65, 0, 8.11333740854580655115e-67, 0, -2.15357148751224279157e-68, 0, 5.71024222179884353251e-70, 0, -1.51253703445107986594e-71, 0, 4.00251671786275816002e-73, 0, -1.05816672552032171728e-74, 0, 2.79502613125292911781e-76, 0, -7.37639965429291617506e-78, 0, 1.9451128618630393339e-79},
            {-0.0000462962962962962962963, 0, 0.000011022927689594356261, 0, -9.6450617283950617284e-7, 0, 5.84549195660306771418e-8, 0, -2.90630457627812125167e-9, 0, 1.2758018159252727154e-10, 0, -5.14101511608925068136e-12, 0, 1.94617406608964476787e-13, 0, -7.02482589634253984992e-15, 0, 2.44232458723970175174e-16, 0, -8.23778565285799294546e-18, 0, 2.70994206371592506163e-19, 0, -8.72967949136160817914e-21, 0, 2.76236608694729796746e-22, 0, -8.60761135219351666382e-24, 0, 2.64647367565156763486e-25, 0, -8.04161229555148503873e-27, 0, 2.41821417258761657006e-28, 0, -7.20464661902935232398e-30, 0, 2.12868536626865172292e-31, 0, -6.24230357640772337326e-33, 0, 1.81809759333983103384e-34, 0, -5.26249883576553650456e-36, 0, 1.51460451807844486512e-37, 0, -4.33651243828056624699e-39, 0, 1.23564577503683920778e-40, 0, -3.50523533836234450448e-42, 0, 9.90263331779884058928e-44, 0, -2.78689271267616695728e-45, 0, 7.81517575693549997956e-47, 0, -2.18427839237589295535e-48, 0, 6.0858333951534769029e-50, 0, -1.69066879585435948213e-51, 0, 4.68381261156389394273e-53, 0, -1.29423293770848219744e-54, 0, 3.56747499149038886498e-56, 0, -9.81077551630946855919e-58, 0, 2.69211333634844457608e-59, 0, -7.37191707108098328984e-61, 0, 2.01469998107764132446e-62, 0, -5.49573156936740654879e-64, 0, 1.49646001090955987499e-65, 0, -4.06785725418979193963e-67, 0, 1.10398016288110974962e-68, 0, -2.99146213480324684596e-70, 0, 8.09397825167802205692e-72, 0, -2.18687789940866488237e-73, 0, 5.90061072153396147094e-75, 0, -1.59002392548091748662e-76, 0, 4.27924829609868653458e-78, 0},
            {0, 3.93675988914084152179e-6, 0, -6.88932980599647266314e-7, 0, 6.26302709636042969376e-8, 0, -4.15186368039731607381e-9, 0, 2.27821752843798699178e-10, 0, -1.10164609630483943172e-11, 0, 4.86543516522411191968e-13, 0, -2.00709311324072567141e-14, 0, 7.85032903041332705916e-16, 0, -2.94206630459214033767e-17, 0, 1.06462009645982770278e-18, 0, -3.74129121058354636249e-20, 0, 1.28252711179695977061e-21, 0, -4.30380567609675833191e-23, 0, 1.41775375481333980439e-24, 0, -4.59520702602942002213e-26, 0, 1.46820146192819577468e-27, 0, -4.63155854080458363684e-29, 0, 1.44446506996801366913e-30, 0, -4.45878826886265955233e-32, 0, 1.36357319500487327538e-33, 0, -4.13482051381577868216e-35, 0, 1.24413942556443685349e-36, 0, -3.71701066138334249742e-38, 0, 1.1032551562828921498e-39, 0, -3.25486138562217703987e-41, 0, 9.54896784216316771109e-43, 0, -2.78689271267616695728e-44, 0, 8.09428917682605355026e-46, 0, -2.34029827754559959502e-47, 0, 6.7378869732056351425e-49, 0, -1.93219290954783940815e-50, 0, 5.52020772077173214678e-52, 0, -1.57156856721744266831e-53, 0, 4.45934373936298608122e-55, 0, -1.26138542352550310047e-56, 0, 3.55743548017473033268e-58, 0, -1.00047445964670487505e-59, 0, 2.80618925935814327335e-61, 0, -7.8510450990962950697e-63, 0, 2.19124501597471267409e-64, 0, -6.10178588128468790945e-66, 0, 1.69539810728170425834e-67, 0, -4.70086906897653075794e-69, 0, 1.30081793330539640201e-70, 0, -3.59272797759994944961e-72, 0, 9.90459656828914961193e-74, 0, -2.72575530082442997707e-75, 0, 7.48868451817270143552e-77, 0, -2.05410161744526030363e-78},
            {5.90513983371126228269e-7, 0, -3.10019841269841269841e-7, 0, 4.69727032227032227032e-8, 0, -4.3594568644171818775e-9, 0, 3.0755936633912824389e-10, 0, -1.81771605890298506234e-11, 0, 9.48759857218701824337e-13, 0, -4.51595950479163276067e-14, 0, 2.00183390275539840009e-15, 0, -8.38488896808759996235e-17, 0, 3.35355330384845726377e-18, 0, -1.29074546765132349506e-19, 0, 4.80947666923859913977e-21, 0, -1.74304129881918712442e-22, 0, 6.1672288334380281491e-24, 0, -2.13677126710368031029e-25, 0, 7.26759723654456908465e-27, 0, -2.43156823392240640934e-28, 0, 8.01678113832247586365e-30, 0, -2.60839113728465583811e-31, 0, 8.38597514927997064361e-33, 0, -2.66695923141117724999e-34, 0, 8.39794112255994876109e-36, 0, -2.62049251627525646068e-37, 0, 8.10892539867925730105e-39, 0, -2.4899689600009654355e-40, 0, 7.59142943451971833032e-42, 0, -2.29918648795783773975e-43, 0, 6.92061724618627578547e-45, 0, -2.07116397562785564159e-46, 0, 6.16516658048315615539e-48, 0, -1.8259222995227082407e-49, 0, 5.38220252775243884312e-51, 0, -1.57942641005352988166e-52, 0, 4.61542077024069059407e-54, 0, -1.343375476054660802e-55, 0, 3.89539185079132971428e-57, 0, -1.12553376710254298443e-58, 0, 3.24114859455865548072e-60, 0, -9.3034884424291096576e-62, 0, 2.66236269440927589902e-63, 0, -7.59672342219943644727e-65, 0, 2.16163258678417292939e-66, 0, -6.13463413501437263912e-68, 0, 1.73659194096270419668e-69, 0, -4.90407368942393099872e-71, 0, 1.38169122127633637086e-72, 0, -3.88420130367481271732e-74, 0, 1.08960359739412805887e-75, 0, -3.05034090190621155089e-77, 0},
            {0, -8.037551440329218107e-8, 0, 2.43562164858461154757e-8, 0, -3.39068867232447479361e-9, 0, 3.18950453981318178849e-10, 0, -2.35629859487423989562e-11, 0, 1.4758486667846472823e-12, 0, -8.19563021239962982491e-14, 0, 4.15195179830749297796e-15, 0, -1.95647409255377332455e-16, 0, 8.6943974544219262394e-18, 0, -3.68101485219081144887e-19, 0, 1.49628163042978639904e-20, 0, -5.87469474787207512306e-22, 0, 2.23847565065528429115e-23, 0, -8.30966603873653454002e-25, 0, 3.014707001825895324e-26, 0, -1.07169118458061615819e-27, 0, 3.74116453121715540304e-29, 0, -1.28487415281058972766e-30, 0, 4.34828341073776255594e-32, 0, -1.45201113710164094722e-33, 0, 4.78993678842308188596e-35, 0, -1.562589981927097371e-36, 0, 5.04555358140042676509e-38, 0, -1.6138687703709961156e-39, 0, 5.11718576697255087451e-41, 0, -1.60943054157048641783e-42, 0, 5.02385548241670390353e-44, 0, -1.55720847056464701942e-45, 0, 4.79512956259801034308e-47, 0, -1.46750051480158403049e-48, 0, 4.4652346896909122254e-50, 0, -1.35128703971246445431e-51, 0, 4.06840793821216430144e-53, 0, -1.21898885790145146848e-54, 0, 3.6356990607385744e-56, 0, -1.07967868770206901099e-57, 0, 3.19313157834297169582e-59, 0, -9.40686053623387754268e-61, 0, 2.76096872012813796936e-62, 0, -8.07503563767125281617e-64, 0, 2.35377770560943274533e-65, 0, -6.83898101718268949768e-67, 0, 1.98100117709819589843e-68, 0, -5.72141930432791949851e-70, 0, 1.64779471574437152377e-71, 0, -4.73297121818153105185e-73, 0, 1.35595114342380380659e-74, 0, -3.87506270131048356279e-76, 0, 1.10479160489300623386e-77},
            {-9.18577307466196355085e-9, 0, 8.35070279514723959168e-9, 0, -1.93753638418541416778e-9, 0, 2.55160363185054543079e-10, 0, -2.42362141187064674978e-11, 0, 1.85535260967212801204e-12, 0, -1.21763648869937357399e-13, 0, 7.11763165424141653364e-15, 0, -3.80114966553304531626e-16, 0, 1.88792630438876112627e-17, 0, -8.83443564525794747729e-19, 0, 3.93308314284400996319e-20, 0, -1.67848421367773574944e-21, 0, 6.90729629345059152699e-23, 0, -2.75406074426696573327e-24, 0, 1.06806762350403148622e-25, 0, -4.04180675327546665375e-27, 0, 1.49646581248686216121e-28, 0, -5.43318213188477941983e-30, 0, 1.93809203450025988208e-31, 0, -6.80370932813340329553e-33, 0, 2.35391179316791452681e-34, 0, -8.03617704991078647943e-36, 0, 2.71018306658080066239e-37, 0, -9.03766511407757824738e-39, 0, 2.982588275606858224e-40, 0, -9.74855070894123201655e-42, 0, 3.15785201751907102507e-43, 0, -1.01441008939639862979e-44, 0, 3.23328736220894411705e-46, 0, -1.02305750174739000983e-47, 0, 3.21496897657745680229e-49, 0, -1.00381322950068788034e-50, 0, 3.11523807840245723653e-52, 0, -9.61259785088001729429e-54, 0, 2.95011009499930037028e-55, 0, -9.0076050516858328917e-57, 0, 2.73696992429397573927e-58, 0, -8.27803727188581223756e-60, 0, 2.49276033017283313805e-61, 0, -7.47517584744424546411e-63, 0, 2.23272628074951906129e-64, 0, -6.64358155954889836918e-66, 0, 1.9696811703719204933e-67, 0, -5.81950077811639811849e-69, 0, 1.71370650437414638472e-70, 0, -5.03047226618151300368e-72, 0, 1.47217552714584413287e-73, 0, -4.29578379459562177818e-75, 0, 1.24999278725037276745e-76, 0},
            {0, 1.70809829900738991648e-9, 0, -7.92628520803123977727e-10, 0, 1.56575677409010742344e-10, 0, -1.9829629733487109771e-11, 0, 1.89751971443740364867e-12, 0, -1.49437205431286756807e-13, 0, 1.01911544140274827641e-14, 0, -6.22006308905407415389e-16, 0, 3.47550069671567389154e-17, 0, -1.80704365471185289308e-18, 0, 8.84943707139902241718e-20, 0, -4.11991579720898774864e-21, 0, 1.83671287803118001968e-22, 0, -7.88662849494631096344e-24, 0, 3.27702566302373296908e-25, 0, -1.32277311925378908668e-26, 0, 5.20361975705658887877e-28, 0, -2.00039887583030515003e-29, 0, 7.53213040680782817808e-31, 0, -2.78333563423639225726e-32, 0, 1.01111211115621783084e-33, 0, -3.61627967245985391574e-35, 0, 1.27501794268687667526e-36, 0, -4.43667196509262932144e-38, 0, 1.52518718638987068273e-39, 0, -5.18445651339147339062e-41, 0, 1.74399554603894149794e-42, 0, -5.80980323927028306155e-44, 0, 1.9179272762193963967e-45, 0, -6.27785285163171142395e-47, 0, 2.03858260105706919963e-48, 0, -6.57041386582268430769e-50, 0, 2.10278570292165863466e-51, 0, -6.68512486902110293648e-53, 0, 2.11201063619268094691e-54, 0, -6.63287281078684058389e-56, 0, 2.07138860179521345722e-57, 0, -6.43429260678397223919e-59, 0, 1.98854289975151007149e-60, 0, -6.11605296609074628882e-62, 0, 1.87244544908311939458e-63, 0, -5.70744052161246268988e-65, 0, 1.7324241203043937066e-66, 0, -5.23755070030475830664e-68, 0, 1.5773889415262029223e-69, 0, -4.73321708681624178073e-71, 0, 1.41529601814248197319e-72, 0, -4.2176786346938832004e-74, 0, 1.2528336799486690692e-75, 0, -3.70989874046110028979e-77},
            {1.58157249908091658933e-10, 0, -2.20174589111978882702e-10, 0, 7.24887395412086770111e-11, 0, -1.28525377902231267034e-11, 0, 1.5812664286978363739e-12, 0, -1.52204561087421696748e-13, 0, 1.22671303131812292531e-14, 0, -8.63897651257510299151e-16, 0, 5.47069554112652371817e-17, 0, -3.17905828143751897857e-18, 0, 1.7207238749942543589e-19, 0, -8.7738947533154368721e-21, 0, 4.25165018062773152703e-22, 0, -1.97165712373657774086e-23, 0, 8.79942076182298667623e-25, 0, -3.79684876822846867474e-26, 0, 1.58999492576729104629e-27, 0, -6.48277413463524817139e-29, 0, 2.58045208381379298693e-30, 0, -1.00509342347425275957e-31, 0, 3.83848116272267880225e-33, 0, -1.43981505477568257756e-34, 0, 5.31257476119531948026e-36, 0, -1.93077391073475535285e-37, 0, 6.91983075306515402348e-39, 0, -2.44821557576819576779e-40, 0, 8.55849666111702772137e-42, 0, -2.9586960940728293369e-43, 0, 1.01223939578245920937e-44, 0, -3.42956776153954605567e-46, 0, 1.15142165430075204794e-47, 0, -3.83274142172989917948e-49, 0, 1.26556546935099825234e-50, 0, -4.14725339096679534023e-52, 0, 1.34934012867865727163e-53, 0, -4.36049971820246001348e-55, 0, 1.40010525862083872572e-56, 0, -4.46825875471109183277e-58, 0, 1.41775743778579884726e-59, 0, -4.47377948445526811867e-61, 0, 1.40433408681233954593e-62, 0, -4.38627373420217040056e-64, 0, 1.36348194653586541724e-65, 0, -4.2191380641343886359e-67, 0, 1.29988533144288944523e-68, 0, -3.98817365648405557451e-70, 0, 1.21872712673380392136e-71, 0, -3.70999509533258244479e-73, 0, 1.12523024958352684919e-74, 0, -3.40074051208934193231e-76, 0},
            {0, -3.72603150804887339957e-11, 0, 2.45346503062552445268e-11, 0, -6.52513457042097201865e-12, 0, 1.07039573634930462233e-12, 0, -1.28788474766279897249e-13, 0, 1.24558553949224789339e-14, 0, -1.02338644841274296976e-15, 0, 7.40648011721744749537e-17, 0, -4.84195030557406736736e-18, 0, 2.91199424999027660736e-19, 0, -1.63329425407871978696e-20, 0, 8.63412036681323940873e-22, 0, -4.33764567222047102989e-23, 0, 2.08478584203190761252e-24, 0, -9.63815456550303586664e-26, 0, 4.30521702976989575611e-27, 0, -1.86504425104121755085e-28, 0, 7.86045403992509248328e-30, 0, -3.23176193086336656538e-31, 0, 1.29917823969075282538e-32, 0, -5.11688119466434885258e-34, 0, 1.97791244955271894496e-35, 0, -7.51516614485989391186e-37, 0, 2.81051587509107794185e-38, 0, -1.03578351282500590176e-39, 0, 3.7657385308914921974e-41, 0, -1.35189652298404663548e-42, 0, 4.7964574446307297921e-44, 0, -1.68312633220171567963e-45, 0, 5.84567916798843347416e-47, 0, -2.01071511509214710801e-48, 0, 6.85352377248540592036e-50, 0, -2.31608150910914878231e-51, 0, 7.76389550962796645525e-53, 0, -2.58275752539684170029e-54, 0, 8.52987203713618669821e-56, 0, -2.79781740487294519375e-57, 0, 9.11727090760713720241e-59, 0, -2.95269445974047695832e-60, 0, 9.50626151072968308017e-62, 0, -3.04339916019258284716e-63, 0, 9.69121014307030496558e-65, 0, -3.0702343143624089612e-66, 0, 9.67914616028243833064e-68, 0, -3.03714763070708847597e-69, 0, 9.4873219404200736032e-71, 0, -2.95087302197991557532e-72, 0, 9.14033187354003348263e-74, 0, -2.81999867079408507925e-75, 0, 8.66718666462514127986e-77},
            {-2.90340117510301823343e-12, 0, 5.73537279886486235693e-12, 0, -2.54226022224193715012e-12, 0, 5.83852219826893430361e-13, 0, -9.03191900958326552133e-14, 0, 1.06764474813621248005e-14, 0, -1.03667718150901235898e-15, 0, 8.65692481233208148809e-17, 0, -6.41401209309811521391e-18, 0, 4.3112642142713186135e-19, 0, -2.67266332485608692412e-20, 0, 1.54741378002626888105e-21, 0, -8.44995910172819031797e-23, 0, 4.38617281050868874323e-24, 0, -2.17797259012666005298e-25, 0, 1.03996151628207871511e-26, 0, -4.79582807410598798789e-28, 0, 2.14376019270684340453e-29, 0, -9.31754738508658931836e-31, 0, 3.94815205308618391088e-32, 0, -1.63474386219146729576e-33, 0, 6.62729106473508425713e-35, 0, -2.63518812871710565741e-36, 0, 1.0293058139943947787e-37, 0, -3.9548097762409316249e-39, 0, 1.49651427331532027585e-40, 0, -5.58315706894710168937e-42, 0, 2.05562461912745562518e-43, 0, -7.47570396899982808355e-45, 0, 2.68749405904922785695e-46, 0, -9.55742509251592001987e-48, 0, 3.36445712467465381545e-49, 0, -1.17308024487346496766e-50, 0, 4.05335843489667859092e-52, 0, -1.38865144871986034275e-53, 0, 4.71912401015586432914e-55, 0, -1.59148574459006492839e-56, 0, 5.32827520574443083257e-58, 0, -1.77161667584428617499e-59, 0, 5.85190643647515555844e-61, 0, -1.92089869071895488795e-62, 0, 6.267821624998716718e-64, 0, -2.03353181860367346781e-65, 0, 6.56170687749017247869e-67, 0, -2.10628160363322759243e-68, 0, 6.7273737395705976459e-70, 0, -2.13842486527895180653e-71, 0, 6.76621969859457024039e-73, 0, -2.13147951480799677419e-74, 0, 6.68611542699653755875e-76, 0},
            {0, 8.28442737613813451556e-13, 0, -7.3443073086989295448e-13, 0, 2.53002628591653819823e-13, 0, -5.21844209442588674566e-14, 0, 7.71076762542820124478e-15, 0, -8.98453557307810711117e-16, 0, 8.75311286580243794907e-17, 0, -7.41174730758004424718e-18, 0, 5.60464347855271419755e-19, 0, -3.86051369145879222372e-20, 0, 2.45866856159729388877e-21, 0, -1.46465957763288632178e-22, 0, 8.23625783306631552895e-24, 0, -4.4043445711450236627e-25, 0, 2.25324995194450388274e-26, 0, -1.10836915490449500165e-27, 0, 5.26412225098013769334e-29, 0, -2.42256232012251322277e-30, 0, 1.08354839679143047332e-31, 0, -4.72259337966423885441e-33, 0, 2.01027828963630889133e-34, 0, -8.37404227570102464465e-36, 0, 3.41958264871471154258e-37, 0, -1.37100072243018962996e-38, 0, 5.40407932030532321835e-40, 0, -2.09678565478235596778e-41, 0, 8.01693601459707693822e-43, 0, -3.02350693857326380268e-44, 0, 1.1257614002906210023e-45, 0, -4.14155087342356534195e-47, 0, 1.50652913471542831959e-48, 0, -5.42223757630401585054e-50, 0, 1.93210085396741679501e-51, 0, -6.81982155926864746109e-53, 0, 2.38577936068990918862e-54, 0, -8.27572587186833762765e-56, 0, 2.84766708218119025608e-57, 0, -9.72420708741197078275e-59, 0, 3.29657395921433763126e-60, 0, -1.10985257685984060192e-61, 0, 3.71194325124924001188e-63, 0, -1.23367596995289523714e-64, 0, 4.07554904946334046177e-66, 0, -1.33865897475356242541e-67, 0, 4.37279293072088846984e-69, 0, -1.42086452159645908923e-70, 0, 4.5935113731569804632e-72, 0, -1.47782579693354443011e-73, 0, 4.7322839188853271388e-75, 0, -1.50856994011422597395e-76},
            {5.57605688778528284701e-14, 0, -1.48298512964113000424e-13, 0, 8.51451153914219585943e-14, 0, -2.45868906371988894747e-14, 0, 4.6709457730959296002e-15, 0, -6.65201191468282930346e-16, 0, 7.65897375757713320544e-17, 0, -7.48301410861446774956e-18, 0, 6.41300551872858643758e-19, 0, -4.93700308619249390149e-20, 0, 3.47523344764232886202e-21, 0, -2.26740569229706440199e-22, 0, 1.38590876998712040151e-23, 0, -8.00404926871547569471e-25, 0, 4.39817057927629123266e-26, 0, -2.31265487129110976305e-27, 0, 1.16924253843885750689e-28, 0, -5.7069977733655359575e-30, 0, 2.69845225739404319798e-31, 0, -1.23968076216186269928e-32, 0, 5.54759489543866011358e-34, 0, -2.42364108171731578658e-35, 0, 1.03573897533185974607e-36, 0, -4.33710805461088834864e-38, 0, 1.78230692967762102297e-39, 0, -7.19761998805097192788e-41, 0, 2.85988775136107263854e-42, 0, -1.11927901091414092695e-43, 0, 4.31902691073036326844e-45, 0, -1.64467356800378123675e-46, 0, 6.18546096657199896599e-48, 0, -2.29923727995199133662e-49, 0, 8.45294123610744847815e-51, 0, -3.07547722240095736466e-52, 0, 1.10801099155117897895e-53, 0, -3.95484207530631134706e-55, 0, 1.39919026826402713544e-56, 0, -4.90885453931854294321e-58, 0, 1.70851285001589229158e-59, 0, -5.90142764426434473908e-61, 0, 2.02372290717146066032e-62, 0, -6.89197825521761666132e-64, 0, 2.33168431195258420649e-65, 0, -7.83887803485499535648e-67, 0, 2.61947114984530145837e-68, 0, -8.70279519477831192152e-70, 0, 2.87536144608191757841e-71, 0, -9.44955918231545236558e-73, 0, 3.08963536627224723774e-74, 0, -1.00522977740303711533e-75, 0},
            {0, -1.86930898694260084568e-14, 0, 2.14651551406946114103e-14, 0, -9.29756368633571450725e-15, 0, 2.35509870912399811775e-15, 0, -4.19244448404379998117e-16, 0, 5.79250116119278981924e-17, 0, -6.60265950760100095549e-18, 0, 6.46689632140697792025e-19, 0, -5.6008018204704762748e-20, 0, 4.38054636257436411178e-21, 0, -3.14388184226063551536e-22, 0, 2.09633259325782917875e-23, 0, -1.3115879053777460172e-24, 0, 7.76147749284051393999e-26, 0, -4.37266677344957728307e-27, 0, 2.35813621197752774498e-28, 0, -1.22292809429261484803e-29, 0, 6.12253873526379549121e-31, 0, -2.96898333795067957391e-32, 0, 1.39855333498453616309e-33, 0, -6.41552051042818884682e-35, 0, 2.87221732655053543027e-36, 0, -1.25739687297542561368e-37, 0, 5.39185289650372746446e-39, 0, -2.26815755925976006131e-40, 0, 9.37274137000687671453e-42, 0, -3.80931091949770651611e-43, 0, 1.52436243908130468298e-44, 0, -6.01204203429953645368e-46, 0, 2.33903986130873910479e-47, 0, -8.98441458132500816411e-49, 0, 3.40958974229544140295e-50, 0, -1.27929514713317134076e-51, 0, 4.74861853521933848119e-53, 0, -1.74478326851749030017e-54, 0, 6.34926676355104750535e-56, 0, -2.28942375573259775923e-57, 0, 8.18363297906771937985e-59, 0, -2.90112199318877451459e-60, 0, 1.020364491010820501e-61, 0, -3.56182069492339012329e-63, 0, 1.23442110632783869755e-64, 0, -4.24880364074073277725e-66, 0, 1.45281593184697391809e-67, 0, -4.93645945922299205632e-69, 0, 1.66722638470296061269e-70, 0, -5.59826825506923858633e-72, 0, 1.86935921320673782451e-73, 0, -6.20877215454817041824e-75, 0, 2.05154563446112960707e-76},
            {-1.10773865892894864929e-15, 0, 3.81602758056793091739e-15, 0, -2.75483368484021170585e-15, 0, 9.76929834895880700696e-16, 0, -2.23597039149002665663e-16, 0, 3.77585260877752225254e-17, 0, -5.08649325030003036571e-18, 0, 5.74835228569509148466e-19, 0, -5.64228924136285017313e-20, 0, 4.93217071934298774068e-21, 0, -3.91238629259101308579e-22, 0, 2.85722368266252273252e-23, 0, -1.94309319315221632178e-24, 0, 1.2418363988544822304e-25, 0, -7.51450882548371799758e-27, 0, 4.33198355978093985745e-28, 0, -2.39150382883889125838e-29, 0, 1.2698598858324909167e-30, 0, -6.50977087432149002873e-32, 0, 3.23221215196426135469e-33, 0, -1.55873387216329329019e-34, 0, 7.31883526172877176307e-36, 0, -3.35305832793446830315e-37, 0, 1.50173088080400113084e-38, 0, -6.58605750540611810394e-40, 0, 2.8326507251576338515e-41, 0, -1.19640579990150189839e-42, 0, 4.9682923940427708186e-44, 0, -2.0307341982522878688e-45, 0, 8.17797640398314709229e-47, 0, -3.24769949310118813636e-48, 0, 1.27291350379029812377e-49, 0, -4.92765538154999331257e-51, 0, 1.88537743324264105624e-52, 0, -7.13422492016040478293e-54, 0, 2.67139520125703332077e-55, 0, -9.90387758035434882511e-57, 0, 3.63717021291898639105e-58, 0, -1.32377122059576674147e-59, 0, 4.77681746902843375285e-61, 0, -1.70967393356322725918e-62, 0, 6.07152307112359181612e-64, 0, -2.14013813015088762113e-65, 0, 7.49007324863328775549e-67, 0, -2.60352528516057062526e-68, 0, 8.99067265232411352621e-70, 0, -3.08526783834926926535e-71, 0, 1.05238000150897833084e-72, 0, -3.56889421624398536634e-74, 0, 1.20357343888386270282e-75, 0},
            {0, 4.26792558352992273656e-16, 0, -6.16212797924784197362e-16, 0, 3.27785668287433656155e-16, 0, -1.00030254356132771481e-16, 0, 2.11149652464532494385e-17, 0, -3.41330468112238879804e-18, 0, 4.50035474998497293865e-19, 0, -5.04836405806149752333e-20, 0, 4.96461921091761266002e-21, 0, -4.37569519566100147752e-22, 0, 3.51513703064402467751e-23, 0, -2.60783560133586927396e-24, 0, 1.80556476412395113762e-25, 0, -1.1766138818849505812e-26, 0, 7.26747241936933989243e-28, 0, -4.27953316739591067289e-29, 0, 2.41440465135256496661e-30, 0, -1.3105196628568262821e-31, 0, 6.86845082292405537871e-33, 0, -3.48664155615473499121e-34, 0, 1.71896328186656021014e-35, 0, -8.25028825425981016696e-37, 0, 3.86300509469976606684e-38, 0, -1.76783648829322117527e-39, 0, 7.92024051442101570322e-41, 0, -3.4790221286609463098e-42, 0, 1.50029355846423145114e-43, 0, -6.35940446294795411545e-45, 0, 2.65246208366032336612e-46, 0, -1.08968864571158286154e-47, 0, 4.41332510853609941596e-49, 0, -1.76358192602841865924e-50, 0, 6.95853118453369495098e-52, 0, -2.71288289727152234509e-53, 0, 1.04571062154469396438e-54, 0, -3.98761386787951413222e-56, 0, 1.50511846310923844735e-57, 0, -5.62602768753200865125e-59, 0, 2.08357235655648130141e-60, 0, -7.64854128173022721211e-62, 0, 2.78411288195601545779e-63, 0, -1.00530172692614063256e-64, 0, 3.60213391102035088767e-66, 0, -1.28120849559217554454e-67, 0, 4.52491090725522818918e-69, 0, -1.58728911157179510889e-70, 0, 5.53191856056364267328e-72, 0, -1.91593268450992898614e-73, 0, 6.59589917493590547004e-75, 0, -2.25764520844805932868e-76},
            {2.25949001480995909583e-17, 0, -9.78690914351127842869e-17, 0, 8.67667945466736148644e-17, 0, -3.70700354378609682546e-17, 0, 1.00606599115453717913e-17, 0, -1.98774802018303818239e-18, 0, 3.09730297498965784601e-19, 0, -4.00899498728413038617e-20, 0, 4.46815728982585139402e-21, 0, -4.40143457916488972151e-22, 0, 3.90800528701012155323e-23, 0, -3.17542334986191141006e-24, 0, 2.38971807016405297626e-25, 0, -1.68186572528260583077e-26, 0, 1.11577076556199865407e-27, 0, -7.02346913943211222198e-29, 0, 4.21810694971595173579e-30, 0, -2.42831584588176634624e-31, 0, 1.34540830825512378889e-32, 0, -7.19888933064889401127e-34, 0, 3.7311614765221218679e-35, 0, -1.87815385552855678507e-36, 0, 9.20304154913767798276e-38, 0, -4.39879314440019151258e-39, 0, 2.05460356874098113242e-40, 0, -9.39335974738455503645e-42, 0, 4.20964721992610824821e-43, 0, -1.85170894656425722773e-44, 0, 8.00419440539850521658e-46, 0, -3.4036745345461794087e-47, 0, 1.42524440269783445845e-48, 0, -5.88206442387125517521e-50, 0, 2.39455337820718326254e-51, 0, -9.62275521796898808287e-53, 0, 3.81991938811326442282e-54, 0, -1.49887368327941737087e-55, 0, 5.8168401780162921171e-57, 0, -2.23386393475535637623e-58, 0, 8.49362142996259730514e-60, 0, -3.19888991253540679283e-61, 0, 1.19389311232113839337e-62, 0, -4.41741405890486501483e-64, 0, 1.62096025995915789945e-65, 0, -5.90109560028631441984e-67, 0, 2.13203155100672810561e-68, 0, -7.64699871986647173046e-70, 0, 2.72365637364221701032e-71, 0, -9.63601438385876048911e-73, 0, 3.38718822336414439726e-74, 0, -1.18327169454542403639e-75, 0},
            {0, -9.83869173157218466376e-18, 0, 1.74451756231407267981e-17, 0, -1.11798519574501332831e-17, 0, 4.04555636654734527058e-18, 0, -9.99132602737505964694e-19, 0, 1.86821449285090473252e-19, 0, -2.82114462068142508657e-20, 0, 3.59343866694989106821e-21, 0, -3.98225033353013831946e-22, 0, 3.92868256366096875721e-23, 0, -3.5114469847679337815e-24, 0, 2.88283449734076232057e-25, 0, -2.19799383145398751429e-26, 0, 1.57034404042059069833e-27, 0, -1.05909455277150898585e-28, 0, 6.78467996144788004063e-30, 0, -4.14997893237994989331e-31, 0, 2.43454836731879542751e-32, 0, -1.37502595151547658099e-33, 0, 7.50180614327199105715e-35, 0, -3.96499147278250876847e-36, 0, 2.0353816759468515327e-37, 0, -1.01707545190628766719e-38, 0, 4.95713876902585924013e-40, 0, -2.36076501587707071022e-41, 0, 1.10029932626640078022e-42, 0, -5.02606714067441247528e-44, 0, 2.25303249929735702393e-45, 0, -9.92288184410023732377e-47, 0, 4.29835613512045312866e-48, 0, -1.83308780193659751228e-49, 0, 7.7031135129627906012e-51, 0, -3.19231085802463255448e-52, 0, 1.30564440461437503553e-53, 0, -5.27381481153869074937e-55, 0, 2.1051421596630390519e-56, 0, -8.30902828641807160049e-58, 0, 3.24465326583756362662e-59, 0, -1.25416794983531028227e-60, 0, 4.80084002838129724317e-62, 0, -1.82072251422586764368e-63, 0, 6.84405443093866668657e-65, 0, -2.55089688118196766191e-66, 0, 9.43057342138425765231e-68, 0, -3.45935656374911816378e-69, 0, 1.2595109368059776016e-70, 0, -4.55288933586554133162e-72, 0, 1.63445273000428555042e-73, 0, -5.82870871757560729035e-75, 0, 2.06535731189176524001e-76},
            {-4.70750800553693046113e-19, 0, 2.50409219470919523418e-18, 0, -2.67460573144740030697e-18, 0, 1.35497103185796253082e-18, 0, -4.30248489217107831686e-19, 0, 9.83270785711002490798e-20, 0, -1.75477895066308737442e-20, 0, 2.57902296671044813508e-21, 0, -3.23915098899580628856e-22, 0, 3.57152960332815341565e-23, 0, -3.52824816651323490007e-24, 0, 3.17249729372428389345e-25, 0, -2.62917922422725779221e-26, 0, 2.0286741192036339165e-27, 0, -1.46955703494611294688e-28, 0, 1.00634008997552287684e-29, 0, -6.5525983142841314105e-31, 0, 4.07699487350037511785e-32, 0, -2.43425646919007815773e-33, 0, 1.39985856262013230253e-34, 0, -7.7782129370374573927e-36, 0, 4.18762737156529262708e-37, 0, -2.18987537491784425951e-38, 0, 1.11476326384792049898e-39, 0, -5.53480793196059640195e-41, 0, 2.68494093969313109049e-42, 0, -1.27455291127150172818e-43, 0, 5.92903289288778164191e-45, 0, -2.70624050293642836103e-46, 0, 1.21341154053639585929e-47, 0, -5.35016057024557168655e-49, 0, 2.3219911546251474061e-50, 0, -9.92823951060292421249e-52, 0, 4.18555861766330753015e-53, 0, -1.74111589471851512778e-54, 0, 7.15143987253951065479e-56, 0, -2.90219648281588146811e-57, 0, 1.16434925807568072726e-58, 0, -4.6206187625511431452e-60, 0, 1.81467158967522718761e-61, 0, -7.05638869149738177694e-63, 0, 2.71797376922444657888e-64, 0, -1.03744610000223565197e-65, 0, 3.92564539550445175e-67, 0, -1.47312313001756706496e-68, 0, 5.48399498800688812178e-70, 0, -2.02592683366265714757e-71, 0, 7.42933059092857068375e-73, 0, -2.70519017035805697208e-74, 0, 9.78327147738204587373e-76, 0},
            {0, 2.2863450473431782573e-19, 0, -4.88406264003438316925e-19, 0, 3.71144239161094084528e-19, 0, -1.57134230844508947225e-19, 0, 4.48884489128935919712e-20, 0, -9.61313686015430474682e-21, 0, 1.64833207002798206894e-21, 0, -2.36598854848389328903e-22, 0, 2.93486563056096085025e-23, 0, -3.22144397812077969137e-24, 0, 3.18629076021873730168e-25, 0, -2.88066593263160418973e-26, 0, 2.40794797627213938784e-27, 0, -1.87847725336590089731e-28, 0, 1.37824838409691176611e-29, 0, -9.57249145043247023446e-31, 0, 6.32820508625927790031e-32, 0, -4.00064758849499801575e-33, 0, 2.42845028906709908135e-34, 0, -1.42036931893727482823e-35, 0, 8.02932030808823499365e-37, 0, -4.39879314440019151258e-38, 0, 2.34100285408063304785e-39, 0, -1.21284486856875677677e-40, 0, 6.12866953625606009785e-42, 0, -3.02567778067060845037e-43, 0, 1.46163550011624877868e-44, 0, -6.91856267707226033167e-46, 0, 3.21290273124636990567e-47, 0, -1.46547876489335224458e-48, 0, 6.57224452896074331032e-50, 0, -2.90077258744572394382e-51, 0, 1.26112700958290092104e-52, 0, -5.40502934273486870103e-54, 0, 2.28535143752893057881e-55, 0, -9.53939365656002778214e-57, 0, 3.93347553706436489164e-58, 0, -1.60315381413730966516e-59, 0, 6.46180883453917855067e-61, 0, -2.57711586993817421419e-62, 0, 1.01746757187054282801e-63, 0, -3.97838026174770367408e-65, 0, 1.54124251832196518707e-66, 0, -5.91811205276622594792e-68, 0, 2.25320663637674316308e-69, 0, -8.50889270138316001977e-71, 0, 3.18815186662891272385e-72, 0, -1.18557899640040062081e-73, 0, 4.37695058705483704525e-75, 0, -1.60464735810640160494e-76},
            {9.98007758760911144058e-21, 0, -6.39579631433073986449e-20, 0, 8.10037029915086295596e-20, 0, -4.80132372024888449853e-20, 0, 1.76347477872081968458e-20, 0, -4.61583158761377331097e-21, 0, 9.35363039738100935946e-22, 0, -1.54915916865016822496e-22, 0, 2.17785663855118920237e-23, 0, -2.67175314058429744244e-24, 0, 2.92076653020050919321e-25, 0, -2.89209714664998357144e-26, 0, 2.62772100585253306213e-27, 0, -2.21391962003838320041e-28, 0, 1.74468743859886846583e-29, 0, -1.29532523198312394839e-30, 0, 9.11562875520681697544e-32, 0, -6.11210048242291363517e-33, 0, 3.92213995099329097662e-34, 0, -2.41800967390512262425e-35, 0, 1.43699343609039443736e-36, 0, -8.25646490992575629146e-38, 0, 4.59839846337267205828e-39, 0, -2.48825713115098116505e-40, 0, 1.31085431747699063204e-41, 0, -6.73573505935004500262e-43, 0, 3.38148212923719459512e-44, 0, -1.6610041347733005955e-45, 0, 7.9940079860772775034e-47, 0, -3.7741893587928000267e-48, 0, 1.74999050751295982588e-49, 0, -7.97712461547574084551e-51, 0, 3.57819766607846888311e-52, 0, -1.58075659745857072725e-53, 0, 6.88326087731927900524e-55, 0, -2.95645493879896099121e-56, 0, 1.25340510169154166984e-57, 0, -5.24842022485428759427e-59, 0, 2.17188574716455723508e-60, 0, -8.88695909117568806401e-62, 0, 3.59747462911370499902e-63, 0, -1.44137348372049740256e-64, 0, 5.71849902631364067424e-66, 0, -2.24747350575288818736e-67, 0, 8.75352895640012522482e-69, 0, -3.37992126749386634119e-70, 0, 1.29423784109578480814e-71, 0, -4.91638909221594701882e-73, 0, 1.85325645888393298702e-74, 0, -6.9343689403883783642e-76, 0},
            {0, -5.34921146289480061394e-21, 0, 1.35497103185796253082e-20, 0, -1.20469576980790192872e-20, 0, 5.89962471426601494479e-21, 0, -1.93025684572939611186e-21, 0, 4.69382179941301560584e-22, 0, -9.06962276918825760796e-23, 0, 1.45718407815788659358e-23, 0, -2.01110145491254389304e-24, 0, 2.44282291616769859796e-25, 0, -2.66072937491798488572e-26, 0, 2.63727635496472409145e-27, 0, -2.40713442324173300699e-28, 0, 2.04287038265031143999e-29, 0, -1.6250443819424645898e-30, 0, 1.21983686615131223526e-31, 0, -8.6902955950085790231e-33, 0, 5.90460341713171805207e-34, 0, -3.84243719089650395199e-35, 0, 2.40369811127847796794e-36, 0, -1.45013547327059646865e-37, 0, 8.46105317260571658723e-39, 0, -4.78650189955952376841e-40, 0, 2.63124212089926846868e-41, 0, -1.40838096695500940964e-42, 0, 7.3531865937594267923e-44, 0, -3.75084933706988970838e-45, 0, 1.87205132473955153171e-46, 0, -9.15412473569017315568e-48, 0, 4.39088527339615374494e-49, 0, -2.06825085484880117195e-50, 0, 9.57655811721364762899e-52, 0, -4.3628882089856552072e-53, 0, 1.95734909311406406622e-54, 0, -8.65434991175695853791e-56, 0, 3.77388881527489637318e-57, 0, -1.62414749503672681554e-58, 0, 6.90264779280662917623e-60, 0, -2.89876447446712443397e-61, 0, 1.20351878501258494513e-62, 0, -4.94260070963065109313e-64, 0, 2.00875274887962796048e-65, 0, -8.08273198978038697201e-67, 0, 3.22129865595524608273e-68, 0, -1.27207945885678242296e-69, 0, 4.97928594865214664366e-71, 0, -1.93258785770379590085e-72, 0, 7.43998229311949824605e-74, 0, -2.84183047120643724235e-75, 0, 1.07731765224098156917e-76},
            {-2.14684072089423436011e-22, 0, 1.6314032490597542177e-21, 0, -2.41744970530013764961e-21, 0, 1.65741965216837878048e-21, 0, -6.97216519527674849769e-22, 0, 2.0721888880351774581e-22, 0, -4.73197709696778657806e-23, 0, 8.77234562101737748646e-24, 0, -1.37212273177979583338e-24, 0, 1.8627545982817233456e-25, 0, -2.2424876337101411077e-26, 0, 2.4344089430443606998e-27, 0, -2.41518504004187258226e-28, 0, 2.21367894307257828279e-29, 0, -1.89135600306347049248e-30, 0, 1.51765656925848880106e-31, 0, -1.15095553699779173684e-32, 0, 8.29409175650609224706e-34, 0, -5.70582646407373830998e-35, 0, 3.76231008721848725417e-36, 0, -2.3861760964853961959e-37, 0, 1.46016837360018386589e-38, 0, -8.64451848080984225732e-40, 0, 4.96327945213106159309e-41, 0, -2.7696588915369415815e-42, 0, 1.50506695497684588525e-43, 0, -7.97839524540618680446e-45, 0, 4.13228720511071575561e-46, 0, -2.0941208425458456316e-47, 0, 1.0397146399881193483e-48, 0, -5.06341011956295136409e-50, 0, 2.4213638583991697684e-51, 0, -1.13814475017017092362e-52, 0, 5.26323970188530939545e-54, 0, -2.3965892063326962105e-55, 0, 1.07536898682749555517e-56, 0, -4.75837192525810264351e-58, 0, 2.07772007141336664168e-59, 0, -8.95805476390509356852e-61, 0, 3.81583882338438303673e-62, 0, -1.60675849155886048914e-63, 0, 6.69136367185320885831e-65, 0, -2.75731994300200492022e-66, 0, 1.12476113605928993658e-67, 0, -4.54374870253860745056e-69, 0, 1.81852182472513181769e-70, 0, -7.21327106754995393094e-72, 0, 2.83664876727633043495e-73, 0, -1.10631794932585048498e-74, 0, 4.28044605639560569958e-76, 0},
            {0, 1.2587988032868473902e-22, 0, -3.730632261265644521e-22, 0, 3.83661956520458051036e-22, 0, -2.15190283804837916596e-22, 0, 7.99455589519744389698e-23, 0, -2.19073013748508637873e-23, 0, 4.73814964098160821028e-24, 0, -8.46989340604812242826e-25, 0, 1.29357958214008565667e-25, 0, -1.73031453218375085471e-26, 0, 2.06624215844814565569e-27, 0, -2.23628244448321535395e-28, 0, 2.22051128548946895651e-29, 0, -2.04313148479078602583e-30, 0, 1.75654695516028796419e-31, 0, -1.42093276172566881091e-32, 0, 1.08795956682564481636e-33, 0, -7.9247589778801920972e-35, 0, 5.51573238095302915349e-36, 0, -3.68237051926758672207e-37, 0, 2.36601356833363126417e-38, 0, -1.46743369273006581529e-39, 0, 8.80828915115851980255e-41, 0, -5.12899794729063255833e-42, 0, 2.90329273722385394531e-43, 0, -1.60060398441790784657e-44, 0, 8.60893167731399115751e-46, 0, -4.52433515364843192012e-47, 0, 2.32652195676353866518e-48, 0, -1.17208567582475726021e-49, 0, 5.79184256252887830404e-51, 0, -2.81023395103745907066e-52, 0, 1.34017677594301859606e-53, 0, -6.2873482264900980831e-55, 0, 2.90416007245079818139e-56, 0, -1.32176997923836184542e-57, 0, 5.93176254955976587515e-59, 0, -2.62659013139192558336e-60, 0, 1.14828483111104119161e-61, 0, -4.95913114678660644795e-63, 0, 2.11686659371899354314e-64, 0, -8.93575907454353446367e-66, 0, 3.7318463619251132155e-67, 0, -1.54263073234335438136e-68, 0, 6.3143118914067077003e-70, 0, -2.5602659653340885866e-71, 0, 1.02872293257706427811e-72, 0, -4.09747388639203883326e-74, 0, 1.61837852440883240185e-75, 0, -6.34050781097374406683e-77},
            {4.67553841220829030647e-24, 0, -4.15699023398171818054e-23, 0, 7.12515062109422094781e-23, 0, -5.59494737892578583148e-23, 0, 2.67246582782314553127e-23, 0, -8.95069741886763863311e-24, 0, 2.28784939807397653582e-24, 0, -4.71894061194109678146e-25, 0, 8.16803107579882657494e-26, 0, -1.22110768414110417461e-26, 0, 1.61166888358955361144e-27, 0, -1.91042414542994683094e-28, 0, 2.06190333652593545961e-29, 0, -2.04896900331875970019e-30, 0, 1.89205200598693875e-31, 0, -1.63610257992984151656e-32, 0, 1.33352758333771893205e-33, 0, -1.03021866712442497264e-34, 0, 7.58019221496687720808e-36, 0, -5.33417672362476133739e-37, 0, 3.60310066263378703944e-38, 0, -2.3437012406745908307e-39, 0, 1.47224261526506688128e-40, 0, -8.95376498798450426611e-42, 0, 5.28399278174741418046e-43, 0, -3.03200126191163686365e-44, 0, 1.69472969304838283072e-45, 0, -9.2425703853103680654e-47, 0, 4.92557934274794900256e-48, 0, -2.56854203816453948165e-49, 0, 1.31226604345297157003e-50, 0, -6.57594744542765422534e-52, 0, 3.23556964477671632478e-53, 0, -1.56465151579225012297e-54, 0, 7.44294738568104562489e-56, 0, -3.48569625953430852378e-57, 0, 1.60835504558063366158e-58, 0, -7.31692965173464983936e-60, 0, 3.284094616977577808e-61, 0, -1.45515076792852709201e-62, 0, 6.36874435196028628836e-64, 0, -2.75476686898070676751e-65, 0, 1.17819720855064288661e-66, 0, -4.98490102365809658663e-68, 0, 2.08733110238787451693e-69, 0, -8.6536989628292194227e-71, 0, 3.5535029299590591778e-72, 0, -1.44582292848404798831e-73, 0, 5.83078662651296473923e-75, 0, -2.331495300778059604e-76, 0},
            {0, -2.97715480948292813991e-24, 0, 1.02057860355195737714e-23, 0, -1.20209744746150836167e-23, 0, 7.6558702759920349437e-24, 0, -3.20515690065552046544e-24, 0, 9.83107698907119890724e-25, 0, -2.36572884789619971272e-25, 0, 4.679826823269354218e-26, 0, -7.87080019220923910953e-27, 0, 1.15424561954689515939e-27, 0, -1.50502910130688119042e-28, 0, 1.77203363669602941357e-29, 0, -1.90766079619332799673e-30, 0, 1.89707071157311100132e-31, 0, -1.75761682989810560798e-32, 0, 1.52807404775038349773e-33, 0, -1.25429805891276143883e-34, 0, 9.77181277579284435843e-36, 0, -7.25844206689523227078e-37, 0, 5.16093994117306366392e-38, 0, -3.52487693226125464458e-39, 0, 2.31966077842824861401e-40, 0, -1.47487746884307086187e-41, 0, 9.08230059037751827304e-43, 0, -5.42864947424497316436e-44, 0, 3.15570356636595423652e-45, 0, -1.78722382251757515111e-46, 0, 9.87728907988713380885e-48, 0, -5.33466423311096661574e-49, 0, 2.81945754694139780298e-50, 0, -1.45996498987346063305e-51, 0, 7.41520470314876102018e-53, 0, -3.69788992193871315534e-54, 0, 1.81236755969633949168e-55, 0, -8.73735534551703330231e-57, 0, 4.14674032971983002401e-58, 0, -1.93888931620236477176e-59, 0, 8.93761558890980061274e-61, 0, -4.06438662766243773976e-62, 0, 1.82446787801514832664e-63, 0, -8.08893083278950236509e-65, 0, 3.54396720025577992948e-66, 0, -1.53513795450054380294e-67, 0, 6.57758448179521200559e-69, 0, -2.78892420154840891209e-70, 0, 1.17067656207139297051e-71, 0, -4.86670900861076100043e-73, 0, 2.00442956709835604829e-74, 0, -8.18187873456067070583e-76, 0, 3.31103467995214346357e-77},
            {-1.02913993414224676441e-25, 0, 1.05837781109091876148e-24, 0, -2.07769929190877988437e-24, 0, 1.8525315729560973444e-24, 0, -9.97159924648384144803e-25, 0, 3.73823668226411020176e-25, 0, -1.06311765510397122893e-25, 0, 2.42657687132485033526e-26, 0, -4.6253097425822195261e-27, 0, 7.58097122961664475054e-28, 0, -1.0925396439116619012e-28, 0, 1.40887612596573202758e-29, 0, -1.64859574979670320705e-30, 0, 1.7705993308015702679e-31, 0, -1.76195662453982932553e-32, 0, 1.63749169561399120498e-33, 0, -1.43082889683381675245e-34, 0, 1.18226870620703549028e-35, 0, -9.28363701395488966979e-37, 0, 6.95771162439627842099e-38, 0, -4.99575150399496337281e-39, 0, 3.44798960151556954478e-40, 0, -2.29425384042255467402e-41, 0, 1.47559352801689062313e-42, 0, -9.19519392427667059445e-44, 0, 5.56338850959331191327e-45, 0, -3.2743705587852858324e-46, 0, 1.87790434358347976119e-47, 0, -1.05112643407964231095e-48, 0, 5.75030107104591255621e-50, 0, -3.07854346012823550772e-51, 0, 1.61486680201906351106e-52, 0, -8.30883908386229375644e-54, 0, 4.19753276788929985975e-55, 0, -2.08402105278258127655e-56, 0, 1.01774318215839778861e-57, 0, -4.89270341026868344873e-59, 0, 2.31715959712476312182e-60, 0, -1.08182932953582910703e-61, 0, 4.98237400761667666484e-63, 0, -2.26490063318106066223e-64, 0, 1.01681231770301636495e-65, 0, -4.5106522613719682111e-67, 0, 1.97814762933989338835e-68, 0, -8.58024581513411729498e-70, 0, 3.6825726915529744307e-71, 0, -1.56455682202745946236e-72, 0, 6.58244771417484825734e-74, 0, -2.74345464729219526383e-75, 0, 1.1331096460280668742e-76, 0},
            {0, 7.07210979761212997301e-26, 0, -2.77664882328823118188e-25, 0, 3.71360015776913522956e-25, 0, -2.66522007509706361284e-25, 0, 1.24895004361358520566e-25, 0, -4.26226893981776483487e-26, 0, 1.13501176239388160843e-26, 0, -2.47251580709464269598e-27, 0, 4.5590633431565536403e-28, 0, -7.30038010908714173611e-29, 0, 1.03555641516836063778e-29, 0, -1.32191548601210303238e-30, 0, 1.53805517906035020967e-31, 0, -1.64828200360177582066e-32, 0, 1.64126471795411560868e-33, 0, -1.52973412011726030676e-34, 0, 1.34299187133656335647e-35, 0, -1.11660334591807659162e-36, 0, 8.83340807613444564509e-38, 0, -6.67634993621446718026e-39, 0, 4.83830798922346049025e-40, 0, -3.37265887140458498163e-41, 0, 2.26779005342688028946e-42, 0, -1.47462096112824026123e-43, 0, 9.29367896187822842654e-45, 0, -5.68865299844263944154e-46, 0, 3.38801636181074804841e-47, 0, -1.96662365085868561404e-48, 0, 1.11428645178562499073e-49, 0, -6.17127375647826011917e-51, 0, 3.34508123275377441577e-52, 0, -1.77663655986732917188e-53, 0, 9.25584990523055291655e-55, 0, -4.73466534111434363751e-56, 0, 2.38020582924141418304e-57, 0, -1.17695446090334228582e-58, 0, 5.72883006385914937722e-60, 0, -2.74694912707023888467e-61, 0, 1.29840207433512933363e-62, 0, -6.05365146195859531839e-64, 0, 2.78569088882231902749e-65, 0, -1.26589273141729430441e-66, 0, 5.68375597646738952827e-68, 0, -2.52267135025602158258e-69, 0, 1.10731736462595198895e-70, 0, -4.80902949443463346265e-72, 0, 2.06725258857611017851e-73, 0, -8.79928310836575070796e-75, 0, 3.7100202926402834752e-76, 0, -1.54999231227923853921e-77},
            {2.28624239146943856886e-27, 0, -2.69287062603384489622e-26, 0, 6.0025864619113177202e-26, 0, -6.03120922166361377905e-26, 0, 3.63379861827228454233e-26, 0, -1.51567753247829999516e-26, 0, 4.76998477730187313887e-27, 0, -1.19895701852649699697e-27, 0, 2.50551972522612322904e-28, 0, -4.48406967907292110946e-29, 0, 7.03017824952658622631e-30, 0, -9.82889747142619711574e-31, 0, 1.24304028480092958756e-31, 0, -1.43869442124723967105e-32, 0, 1.53868567308198338313e-33, 0, -1.53303096089337509191e-34, 0, 1.43271762136120444278e-35, 0, -1.26339818234265131595e-36, 0, 1.05658221600315028729e-37, 0, -8.41738084630487780269e-39, 0, 6.412843563302646986e-40, 0, -4.6882865777068045542e-41, 0, 3.29904803030850042109e-42, 0, -2.24053400343838229346e-43, 0, 1.47216681831476247705e-44, 0, -9.37892143062202407926e-46, 0, 5.80489872336108771226e-47, 0, -3.49669075853106817152e-48, 0, 2.05326490576877018766e-49, 0, -1.17706406777656469945e-50, 0, 6.59644251717608532421e-52, 0, -3.61836540748841824877e-53, 0, 1.94492535724133385639e-54, 0, -1.02550402323705072321e-55, 0, 5.3092953303122062057e-57, 0, -2.7014148725475421e-58, 0, 1.35195450860469150174e-59, 0, -6.66016760334917833028e-61, 0, 3.23201378417472926797e-62, 0, -1.54602952207347746817e-63, 0, 7.29442765068775348792e-65, 0, -3.39663028149683493316e-66, 0, 1.56180794611981070012e-67, 0, -7.095013172595060701e-69, 0, 3.18592388313716789925e-70, 0, -1.41472527153087816304e-71, 0, 6.21512362298205538584e-73, 0, -2.7023660408235333532e-74, 0, 1.16337920814474406388e-75, 0, -4.96064349942816644552e-77, 0},
            {0, -1.68644423044543821783e-27, 0, 7.51839112401013532631e-27, 0, -1.13313627800952743728e-26, 0, 9.102849063954813803e-27, 0, -4.74606096028558584342e-27, 0, 1.79235791631949172491e-27, 0, -5.25603379838888582511e-28, 0, 1.25529069061834052687e-28, 0, -2.52738472820473735261e-29, 0, 4.40273789364291258618e-30, 0, -6.77101825809360245751e-31, 0, 9.34163607971607690045e-32, 0, -1.17130071063159108572e-32, 0, 1.34906986286379957228e-33, 0, -1.44011999356650387422e-34, 0, 1.43561200039425738105e-35, 0, -1.3450724082718732192e-36, 0, 1.19105631622173305113e-37, 0, -1.001583296661327884e-38, 0, 8.03224850353058814409e-40, 0, -6.16580719613561568643e-41, 0, 4.54535506398060058016e-42, 0, -3.22727423121528601059e-43, 0, 2.21271133904279451096e-44, 0, -1.46841699166304417403e-45, 0, 9.45201691116977110319e-47, 0, -5.91258619169798799911e-48, 0, 3.60047260243897479372e-49, 0, -2.1377385796588518481e-50, 0, 1.23933162443914330334e-51, 0, -7.02474577090175744862e-53, 0, 3.89770899875434986977e-54, 0, -2.11937498135657149464e-55, 0, 1.13050450063617481633e-56, 0, -5.92128310447289531011e-58, 0, 3.04804289212694084028e-59, 0, -1.54327520021040556461e-60, 0, 7.69153987425824460135e-62, 0, -3.77605998421582678589e-63, 0, 1.82729096704097259091e-64, 0, -8.72144866218682262636e-66, 0, 4.10802817343028996274e-67, 0, -1.91063688062004361908e-68, 0, 8.77899025575575154461e-70, 0, -3.9869530379506566413e-71, 0, 1.79045783563079009701e-72, 0, -7.95423701309068302143e-74, 0, 3.49718840751389730719e-75, 0, -1.52226615669320905672e-76, 0, 6.56249922477439158351e-78},
            {-5.12013428598235512056e-29, 0, 6.84787047348171718525e-28, 0, -1.72013097231047808315e-27, 0, 1.93457133807009325605e-27, 0, -1.29683639142528341832e-27, 0, 5.98586324994744864486e-28, 0, -2.07448772308327941484e-28, 0, 5.71669384721824907875e-29, 0, -1.30445663391212250457e-29, 0, 2.53971977166498183339e-30, 0, -4.31700594823425128221e-31, 0, 6.52319179760060018855e-32, 0, -8.89032797443332892389e-33, 0, 1.10587890086747896627e-33, 0, -1.26796143646083073555e-34, 0, 1.35116423566518341746e-35, 0, -1.34762472783216140368e-36, 0, 1.26563859029254365964e-37, 0, -1.1251182383747743972e-38, 0, 9.51066995484456736605e-40, 0, -7.67508447944015918463e-41, 0, 5.93397397346993016917e-42, 0, -4.40917921532259189302e-43, 0, 3.15741731871002176896e-44, 0, -2.184514082474054331e-45, 0, 1.46353810237467423533e-46, 0, -9.51399068417437158112e-48, 0, 6.01217436460398068021e-49, 0, -3.69946410749311742973e-50, 0, 2.21997922859687149592e-51, 0, -1.30097758489565754646e-52, 0, 7.45520051374646047197e-54, 0, -4.18244778104522647898e-55, 0, 2.29962205822007476869e-56, 0, -1.2404357774835059625e-57, 0, 6.57035431775370928759e-59, 0, -3.42038981754412466692e-60, 0, 1.75139427876848074414e-61, 0, -8.82752542799601252412e-63, 0, 4.38272444466753198276e-64, 0, -2.14478130288313512785e-65, 0, 1.03519191922493834355e-66, 0, -4.93067582095495127504e-68, 0, 2.31885283415787592981e-69, 0, -1.07730951158287192736e-70, 0, 4.94669185707482045777e-72, 0, -2.24590221546089873546e-73, 0, 1.00867673233797417589e-74, 0, -4.4830305032027712638e-76, 0, 1.97248553549196134123e-77, 0},
            {0, 4.03535224330172619845e-29, 0, -2.027297217365920598e-28, 0, 3.42004575837391486337e-28, 0, -3.05682863693102520032e-28, 0, 1.76369185043094469e-28, 0, -7.33479587804445221677e-29, 0, 2.35813621197752774498e-29, 0, -6.14958127415714895012e-30, 0, 1.34695852175803500807e-30, 0, -2.54394993378089807702e-31, 0, 4.22842611165896047937e-32, 0, -6.28673192477785402475e-33, 0, 8.47182229414550850949e-34, 0, -1.04606818508018535683e-34, 0, 1.19433267259690319936e-35, 0, -1.27061760052746646633e-36, 0, 1.26789865920378034475e-37, 0, -1.19342898856181427132e-38, 0, 1.06485536815848995331e-39, 0, -9.04563527934018761046e-41, 0, 7.34329279216903858435e-42, 0, -5.71618591129321734702e-43, 0, 4.27942811589447593328e-44, 0, -3.0895270594990196967e-45, 0, 2.15610524010554686455e-46, 0, -1.45767928696814478868e-47, 0, 9.56579885511097640369e-49, 0, -6.10411577736364375905e-50, 0, 3.79378593172715360999e-51, 0, -2.2999425161548231625e-52, 0, 1.36190537956475518979e-53, 0, -7.88690152997099850322e-55, 0, 4.47194360964582396983e-56, 0, -2.485301682743738732e-57, 0, 1.35513557803670254056e-58, 0, -7.25611268436146447196e-60, 0, 3.81866502567199105107e-61, 0, -1.97673515834053566165e-62, 0, 1.00724399290841315389e-63, 0, -5.05555592822453280136e-65, 0, 2.50109761912739567647e-66, 0, -1.22034226568635044057e-67, 0, 5.875807449410760615e-69, 0, -2.79330966217558935452e-70, 0, 1.31175667995644792496e-71, 0, -6.08799921976722192935e-73, 0, 2.79367430688606776215e-74, 0, -1.26805719947735530033e-75, 0, 5.6955519837330383728e-77, 0, -2.53238341742828468963e-78},
            {1.15489879017052769989e-30, 0, -1.74060872198084091747e-29, 0, 4.89400487309398591559e-29, 0, -6.12394962617494947538e-29, 0, 4.5428426450494029894e-29, 0, -2.30910240605103125343e-29, 0, 8.77353708496689615557e-30, 0, -2.63997175910786697354e-30, 0, 6.55338405367124776652e-31, 0, -1.3833263107933166311e-31, 0, 2.54132680448190049012e-32, 0, -4.13823599762313286814e-33, 0, 6.06148901517144969114e-34, 0, -8.08325415743779593914e-35, 0, 9.91255905034130096441e-36, 0, -1.12729878026595088847e-36, 0, 1.19745984480357032559e-37, 0, -1.19543812827319779703e-38, 0, 1.1275993713328117519e-39, 0, -1.00963908925968760703e-40, 0, 8.61662470730946109982e-42, 0, -7.03456549016050821662e-43, 0, 5.51138469471258264135e-44, 0, -4.15577798070659383445e-45, 0, 3.02362906566989989591e-46, 0, -2.12762279764542345418e-47, 0, 1.45097386674326426595e-48, 0, -9.60833039029462443554e-50, 0, 6.18885280781752836377e-51, 0, -3.8835729691974539259e-52, 0, 2.37760248924015342056e-53, 0, -1.42203224555537700285e-54, 0, 8.31901967787649071829e-56, 0, -4.76558689670895356187e-57, 0, 2.67605056066843784526e-58, 0, -1.47443232491991374035e-59, 0, 7.97805268831471531039e-61, 0, -4.2429921328016548293e-62, 0, 2.21966731770557713544e-63, 0, -1.14303225784605177647e-64, 0, 5.79799902615896270455e-66, 0, -2.89882649306976510378e-67, 0, 1.42938413542063115971e-68, 0, -6.95505890632608864535e-70, 0, 3.34122534810455506813e-71, 0, -1.58554457794274281561e-72, 0, 7.43568868549978641743e-74, 0, -3.44766393460594075764e-75, 0, 1.58113892612386873346e-76, 0, -7.17508634938013995395e-78, 0},
            {0, -9.68542214138782704477e-31, 0, 5.44642831663877605869e-30, 0, -1.02228093918659728921e-29, 0, 1.01112554897760956839e-29, 0, -6.42437076405294863831e-30, 0, 2.92916182486971095814e-30, 0, -1.02828788709288936171e-30, 0, 2.91724568366923588971e-31, 0, -6.92762778855158567246e-32, 0, 1.41409281648436434268e-32, 0, -2.53294254226535159656e-33, 0, 4.04741714844516513558e-34, 0, -5.84718702962511470955e-35, 0, 7.72202533333424081489e-36, 0, -9.40909156819752331397e-37, 0, 1.06610097470588137096e-37, 0, -1.13081985106924115935e-38, 0, 1.12939205713779237472e-39, 0, -1.06742447433655367038e-40, 0, 9.58924848190242093779e-42, 0, -8.22004075559296270146e-43, 0, 6.74684612866246205698e-44, 0, -5.31860298007759624282e-45, 0, 4.03791480947967553667e-46, 0, -2.95972964696302944739e-47, 0, 2.09918317764128852466e-48, 0, -1.44354089329545629437e-49, 0, 9.64240978006546549522e-51, 0, -6.26681488670177382319e-52, 0, 3.96897076900184593257e-53, 0, -2.45294910401841661064e-54, 0, 1.48128808254716527893e-55, 0, -8.75079946851962061044e-57, 0, 5.06279835802136889643e-58, 0, -2.87150969479633439098e-59, 0, 1.59814727937623867903e-60, 0, -8.73557203812105406033e-62, 0, 4.69341420118985308447e-63, 0, -2.48050720502362587421e-64, 0, 1.29049262903379138098e-65, 0, -6.61337999611305711276e-67, 0, 3.34053208118971034145e-68, 0, -1.66412776693493853915e-69, 0, 8.18042454066933991243e-71, 0, -3.97016329135106507882e-72, 0, 1.90325258881632052974e-73, 0, -9.01654558414431247427e-75, 0, 4.22307376134832984453e-76, 0, -1.95632322562590461383e-77, 0, 8.96695883652582039508e-79},
            {-2.62161802323279529031e-32, 0, 4.42266359546607379202e-31, 0, -1.38353811318486851172e-30, 0, 1.91581682964178655063e-30, 0, -1.56503468237079350287e-30, 0, 8.72141415525116946935e-31, 0, -3.61833632450730993444e-31, 0, 1.18444561592585517326e-31, 0, -3.18775053127336122673e-32, 0, 7.27247734191958804805e-33, 0, -1.43977786612977880225e-33, 0, 2.51974541271623814455e-34, 0, -3.9567431027538370215e-35, 0, 5.64346513082773088125e-36, 0, -7.38578315578813108255e-37, 0, 8.94562923136664368413e-38, 0, -1.01008570155658533632e-38, 0, 1.06995036992001382868e-39, 0, -1.06902962392202217214e-40, 0, 1.01227856154819541328e-41, 0, -9.12239109417685184011e-43, 0, 7.85272015576653478511e-44, 0, -6.47829836671105707772e-45, 0, 5.13695628393955714891e-46, 0, -3.92553616334043905654e-47, 0, 2.89781978507474115134e-48, 0, -2.07088422887799293959e-49, 0, 1.43548656876162569027e-50, 0, -9.66880011091130818435e-52, 0, 6.33841647621046673743e-53, 0, -4.05013250558228787742e-54, 0, 2.52598599339621868618e-55, 0, -1.53961434258164753597e-56, 0, 9.18155611996055772797e-58, 0, -5.36303013674743956932e-59, 0, 3.07132665119223012301e-60, 0, -1.72609648993850602034e-61, 0, 9.52798371670120550982e-63, 0, -5.16989922731239919046e-64, 0, 2.75951957667075390038e-65, 0, -1.44997113298238154442e-66, 0, 7.50489463052244699268e-68, 0, -3.82874508783527212767e-69, 0, 1.92639771890047914329e-70, 0, -9.56421292142015978387e-72, 0, 4.68801163982125267326e-73, 0, -2.26972891847482392209e-74, 0, 1.08593325291814196002e-75, 0, -5.13645165705688639963e-77, 0, 2.40287528521639277354e-78, 0},
            {0, 2.33103351897784516103e-32, 0, -1.45843048968205512631e-31, 0, 3.02928302122846591339e-31, 0, -3.29950331895836806872e-31, 0, 2.29837837424710306529e-31, 0, -1.14426020518607237243e-31, 0, 4.36996316986889586717e-32, 0, -1.34412273113520644318e-32, 0, 3.44976489296185586895e-33, 0, -7.58857279868971733382e-34, 0, 1.46087803842665089008e-34, 0, -2.50255546669900803069e-35, 0, 3.86681870075233412234e-36, 0, -5.44990836851602834866e-37, 0, 7.07239917864456872464e-38, 0, -8.51810164275638916102e-39, 0, 9.58687724614941165584e-40, 0, -1.01420759192602103511e-40, 0, 1.01372055380111307057e-41, 0, -9.6161957403003851306e-43, 0, 8.69168598437407055275e-44, 0, -7.51187303490427416134e-45, 0, 6.22727891400650019049e-46, 0, -4.96563548866995709716e-47, 0, 3.81835228090332701565e-48, 0, -2.83787838772169402833e-49, 0, 2.04280780939154425153e-50, 0, -1.42690554343363465513e-51, 0, 9.6882063803046022924e-53, 0, -6.4040556712198569002e-54, 0, 4.12721643080550261118e-55, 0, -2.59672846384141122876e-56, 0, 1.59696296616407991251e-57, 0, -9.61067223935652276097e-59, 0, 5.66576640070361539785e-60, 0, -3.27515744244742167962e-61, 0, 1.85809255102050574686e-62, 0, -1.03545275122524690339e-63, 0, 5.67234579648988301745e-65, 0, -3.05691919774063345548e-66, 0, 1.62178421004309858802e-67, 0, -8.47559810042167077834e-69, 0, 4.365952664915473386e-70, 0, -2.21802544673390600116e-71, 0, 1.11190019662427146737e-72, 0, -5.50296099607428819858e-74, 0, 2.69008251684422915738e-75, 0, -1.29947836793917809768e-76, 0, 6.20571637050900298921e-78, 0, -2.93095723863009063663e-79},
            {5.9850860622404132513e-34, 0, -1.12338564745779921892e-32, 0, 3.88894441914465218611e-32, 0, -5.93018839758733720459e-32, 0, 5.31111759454398140762e-32, 0, -3.23176193086336656538e-32, 0, 1.45862284183461794485e-32, 0, -5.17668889693964643657e-33, 0, 1.50577575733335060226e-33, 0, -3.7019929463878215642e-34, 0, 7.87689645043559061e-35, 0, -1.47786045803711690461e-35, 0, 2.48207957142886311907e-36, 0, -3.77811215276854397684e-37, 0, 5.26607019923399644226e-38, 0, -6.77994846970745029167e-39, 0, 8.12293518018335284894e-40, 0, -9.11416281933518903175e-41, 0, 9.63034526111057417038e-42, 0, -9.62919059940889916456e-43, 0, 9.14976132679378508188e-44, 0, -8.29351387772539458083e-45, 0, 7.19503171821021305793e-46, 0, -5.99231417754361038887e-47, 0, 4.80389996421756412374e-48, 0, -3.71608669959773177493e-49, 0, 2.77987495142876359634e-50, 0, -2.01502201741641650623e-51, 0, 1.4178820959283627409e-52, 0, -9.7012789289695399799e-54, 0, 6.46411330176159125183e-55, 0, -4.20038374488941789301e-56, 0, 2.66520170704410634048e-57, 0, -1.65329537306768290199e-58, 0, 1.00375942585438375494e-59, 0, -5.97052349981293492677e-61, 0, 3.48266806522356955526e-62, 0, -1.99394617634591464504e-63, 0, 1.12143809463036471007e-64, 0, -6.20058880514687948199e-66, 0, 3.37287283683287665806e-67, 0, -1.80621867626553713749e-68, 0, 9.52839669437633718702e-70, 0, -4.95458927493398191881e-71, 0, 2.5408422060697879072e-72, 0, -1.28575940029897895883e-73, 0, 6.42348082062669313661e-75, 0, -3.16967358666245468422e-76, 0, 1.5455588203848773661e-77, 0, -7.45017644035567633445e-79, 0},
            {0, -5.62413867148320533218e-34, 0, 3.89393664561338729803e-33, 0, -8.90670144438662969111e-33, 0, 1.0635870921038011548e-32, 0, -8.08977633528057099164e-33, 0, 4.38148581501027726695e-33, 0, -1.81416696901736004773e-33, 0, 6.03083486890892667399e-34, 0, -1.66803533271132910017e-34, 0, 3.94350399957622636444e-35, 0, -8.13866670729041273529e-36, 0, 1.49115948578781507025e-36, 0, -2.45892536771970705553e-37, 0, 3.69098116660046477211e-38, 0, -5.09148890215514559773e-39, 0, 6.50669005447292962482e-40, 0, -7.75698324675125844422e-41, 0, 8.67843693619977287241e-42, 0, -9.1594739848035870102e-43, 0, 9.16150684839429058263e-44, 0, -8.71936824885378454647e-45, 0, 7.9246947551018777968e-46, 0, -6.90000746759514572377e-47, 0, 5.77208005970172017949e-48, 0, -4.65107128640280934603e-49, 0, 3.61847650930521988022e-50, 0, -2.72377173856160023242e-51, 0, 1.98758311778404635823e-52, 0, -1.40849120265270214599e-53, 0, 9.70861689738262100724e-55, 0, -6.51895243590668322548e-56, 0, 4.26979682977027562634e-57, 0, -2.73143921070360448634e-58, 0, 1.70858151307177517209e-59, 0, -1.04618287256028962452e-60, 0, 6.27684976068535514195e-62, 0, -3.69353572845591121026e-63, 0, 2.13346759466264505819e-64, 0, -1.21066695412431369603e-65, 0, 6.75440516747020229341e-67, 0, -3.70750149338715517696e-68, 0, 2.00353193650686011712e-69, 0, -1.06660413530992139638e-70, 0, 5.59702853095732483795e-72, 0, -2.89667233315110150545e-73, 0, 1.47929712351788029359e-74, 0, -7.45829484512487732499e-76, 0, 3.71410283923041133419e-77, 0, -1.82763635141459531131e-78, 0, 8.89054237018156046687e-80},
            {-1.37341603699223573436e-35, 0, 2.85270083927720681174e-34, 0, -1.08750933386894135423e-33, 0, 1.81809759333983103384e-33, 0, -1.77797282094078483333e-33, 0, 1.17695589658395726341e-33, 0, -5.75926021910273031026e-34, 0, 2.20909702157836141904e-34, 0, -6.92468880490661653307e-35, 0, 1.82970881543219294077e-35, 0, -4.17367523450790396681e-36, 0, 8.37525474313058525415e-37, 0, -1.50117543816831932572e-37, 0, 2.43361395600030644315e-38, 0, -3.60569421642244743185e-39, 0, 4.92569943073652792111e-40, 0, -6.2510487702757394056e-41, 0, 7.41746746683741271146e-42, 0, -8.27595940018883319603e-43, 0, 8.72524461751837198346e-44, 0, -8.73001460813199429561e-45, 0, 8.32141329595557375488e-46, 0, -7.58242578856609420195e-47, 0, 6.62485379257584489465e-48, 0, -5.5653844452683188756e-49, 0, 4.50652752074642768965e-50, 0, -3.52527233562307233988e-51, 0, 2.66952555502130768505e-52, 0, -1.9605372051576073827e-53, 0, 1.39879950414059741008e-54, 0, -9.71077163834695181329e-56, 0, 6.56891819964657788667e-57, 0, -4.33561779476762616879e-58, 0, 2.79548135227860650866e-59, 0, -1.76279897940561621715e-60, 0, 1.08829385350100174622e-61, 0, -6.58432498601420069228e-63, 0, 3.90744980707444149851e-64, 0, -2.27646777698588900109e-65, 0, 1.3030476391456556317e-66, 0, -7.33351943746909815223e-68, 0, 4.06088280171109620807e-69, 0, -2.2139524176152214577e-70, 0, 1.18911228862829611942e-71, 0, -6.29557601099995198987e-73, 0, 3.28732694115084509687e-74, 0, -1.6938252029221333119e-75, 0, 8.61635579308642434061e-77, 0, -4.32919966024946874719e-78, 0, 2.1493618916922453876e-79, 0},
            {0, 1.36000853965541254978e-35, 0, -1.03692750438666501217e-34, 0, 2.6003023718697583391e-34, 0, -3.39055282132893851937e-34, 0, 2.80553440464780510463e-34, 0, -1.64741629523171122828e-34, 0, 7.3722191301510433403e-35, 0, -2.64104410233647700331e-35, 0, 7.85072735923813017608e-36, 0, -1.98977540249795421674e-36, 0, 4.39213940599057436003e-37, 0, -8.58811994859085009598e-38, 0, 1.50827469598623643512e-38, 0, -2.40659125607730793707e-39, 0, 3.52244784872437752498e-40, 0, -4.76824185267544773264e-41, 0, 6.01159863300660076731e-42, 0, -7.10192795039460337054e-43, 0, 7.90344832214745555246e-44, 0, -8.32396741705608758419e-45, 0, 8.33108935792761511971e-46, 0, -7.95273030382164763972e-47, 0, 7.26422921674304852984e-48, 0, -6.36783522574886717859e-49, 0, 5.37115198693614928127e-50, 0, -4.36969803462115710967e-51, 0, 3.43623812721928791552e-52, 0, -2.617089199442945669e-53, 0, 1.93392164002694223324e-54, 0, -1.38886617618218031748e-55, 0, 9.7082500369195354581e-57, 0, -6.61433784504084364355e-58, 0, 4.3980072902708774491e-59, 0, -2.85737415964119651942e-60, 0, 1.81593218578364826259e-61, 0, -1.13005391620429770021e-62, 0, 6.89255971782782296888e-64, 0, -4.12411255412094774849e-65, 0, 2.42275950580686436637e-66, 0, -1.39848510202899081042e-67, 0, 7.9376092903213403788e-69, 0, -4.43305356178303645367e-70, 0, 2.43768019168800704481e-71, 0, -1.32060687486557132439e-72, 0, 7.05246303072477814386e-74, 0, -3.71459806129202723983e-75, 0, 1.9306648387532022912e-76, 0, -9.90681968764064476101e-78, 0, 5.02100934931362905079e-79, 0, -2.51457104096225785784e-80},
            {3.16631699919774540415e-37, 0, -7.24239831223502170362e-36, 0, 3.02695952379517323288e-35, 0, -5.52562377755381332979e-35, 0, 5.87855878579196413276e-35, 0, -4.2189929512031629017e-35, 0, 2.23128139970203418171e-35, 0, -9.22315845050986980092e-36, 0, 3.10721692599557923821e-36, 0, -8.80177811082797929576e-37, 0, 2.14737636146545819598e-37, 0, -4.59873828732747294497e-38, 0, 8.77876070280237392944e-39, 0, -1.51279073414172239503e-39, 0, 2.37823807081280034669e-40, 0, -3.44138076063383201103e-41, 0, 4.61866724243190058952e-42, 0, -5.78704772011090185959e-43, 0, 6.80818109346848443931e-44, 0, -7.558014761162899924e-45, 0, 7.95240347802181443245e-46, 0, -7.96154707799439891204e-47, 0, 7.61052839226405860387e-48, 0, -6.96790839003784024974e-49, 0, 6.1274006591544319406e-50, 0, -5.18841085928964441736e-51, 0, 4.24005879777723664077e-52, 0, -3.35115080416474750298e-53, 0, 2.5664126420313191277e-54, 0, -1.90776628856953593499e-55, 0, 1.37874371366894954787e-56, 0, -9.70151770397897576543e-58, 0, 6.65552101022144979824e-59, 0, -4.4571235505711347038e-60, 0, 2.91716822306042830654e-61, 0, -1.8679716064973479723e-62, 0, 1.17142949528049363762e-63, 0, -7.20119431567682117945e-65, 0, 4.34323960187328124216e-66, 0, -2.57215829741252300942e-67, 0, 1.49688175197745010913e-68, 0, -8.56631081839005824694e-70, 0, 4.82401235273070130264e-71, 0, -2.67488776095277029895e-72, 0, 1.46131412465904771074e-73, 0, -7.86984134714973842052e-75, 0, 4.18025324843126837552e-76, 0, -2.19114249188947741665e-77, 0, 1.13390200050464106169e-78, 0, -5.79577959441300896501e-80, 0},
            {0, -3.29548282990588289159e-37, 0, 2.7546933232421682331e-36, 0, -7.54291499793060232321e-36, 0, 1.06995990598541569401e-35, 0, -9.59876703183788385043e-36, 0, 6.0917523928372996707e-36, 0, -2.93774676571795852918e-36, 0, 1.13109272226717381793e-36, 0, -3.60453770252955342588e-37, 0, 9.77113053365234946318e-38, 0, -2.30180233852475629944e-38, 0, 4.7934820345460581456e-39, 0, -8.94867746439389226267e-40, 0, 1.51502573399926540604e-40, 0, -2.34887893186118692816e-41, 0, 3.3625852516329604292e-42, 0, -4.47654167555668704694e-43, 0, 5.57622451465037773125e-44, 0, -6.53428366123818966975e-45, 0, 7.23710792708863535651e-46, 0, -7.60770054119464784929e-47, 0, 7.61858186146222162885e-48, 0, -7.29234010343642752063e-49, 0, 6.69151056110833202403e-50, 0, -5.90216050130832565996e-51, 0, 5.01628120202640271364e-52, 0, -4.11712813083097550366e-53, 0, 3.26979981058805103677e-54, 0, -2.51744398078964159887e-55, 0, 1.88209459326237557329e-56, 0, -1.36847863485756345982e-57, 0, 9.69100202123250256337e-59, 0, -6.69276012514332290443e-60, 0, 4.51312163186703299911e-61, 0, -2.97491774368096158551e-62, 0, 1.9189130779832848159e-63, 0, -1.21239155092506058164e-64, 0, 7.50989789360946195734e-66, 0, -4.5645602801701598802e-67, 0, 2.72448318878435363778e-68, 0, -1.59813819818218758618e-69, 0, 9.21922360744089582282e-71, 0, -5.23372219047796008758e-72, 0, 2.92572097762425213621e-73, 0, -1.61144370441637500992e-74, 0, 8.74977875703391412358e-76, 0, -4.68603066254881889847e-77, 0, 2.4765859566577557157e-78, 0, -1.29224419105060422109e-79, 0, 6.65994633834694465384e-81},
            {-7.33069992496758580537e-39, 0, 1.83831910347809002411e-37, 0, -8.38949089759723210872e-37, 0, 1.66606496988628935164e-36, 0, -1.92169451193518807117e-36, 0, 1.49060068661944036432e-36, 0, -8.49540520723292355254e-37, 0, 3.77412131797944752191e-37, 0, -1.36309110287770776671e-37, 0, 4.12975992221100310982e-38, 0, -1.07526054640893570307e-38, 0, 2.45247918046542509775e-39, 0, -4.9765142623019623301e-40, 0, 9.09934566224027958733e-41, 0, -1.5152525364281468758e-41, 0, 2.31878982974082812205e-42, 0, -3.28611653837629403041e-43, 0, 4.34144881322627993232e-44, 0, -5.3780656220908861387e-45, 0, 6.27850212481501429311e-46, 0, -6.93846904768207518711e-47, 0, 7.28733917183342938412e-48, 0, -7.29971355146821359497e-49, 0, 6.99597767460668889064e-50, 0, -6.4332952683623610328e-51, 0, 5.69086704618162168321e-52, 0, -4.85396501572185787389e-53, 0, 4.0004628622968066274e-54, 0, -3.19198660456037468653e-55, 0, 2.47013021441310767859e-56, 0, -1.85692449745080906277e-57, 0, 1.35811211339011613274e-58, 0, -9.67709502422138701045e-60, 0, 6.72633092555309063771e-61, 0, -4.56615281588240615451e-62, 0, 3.03067970456005144837e-63, 0, -1.9687571595405938262e-64, 0, 1.25291521986406594839e-65, 0, -7.81836715329449022959e-67, 0, 4.78781777766148293474e-68, 0, -2.87955740056689411382e-69, 0, 1.70215392388140301036e-70, 0, -9.89591556743557670756e-72, 0, 5.66211319633247582276e-73, 0, -3.19030007406194364956e-74, 0, 1.77118878377976704504e-75, 0, -9.69425554658734425306e-77, 0, 5.23363463034854342346e-78, 0, -2.78832063063901861254e-79, 0, 1.46666967896053037978e-80, 0},
            {0, 8.00042163022379604303e-39, 0, -7.30226480448501827645e-38, 0, 2.17522989298500060417e-37, 0, -3.34530959524500824768e-37, 0, 3.24357015947170292042e-37, 0, -2.21833598254631466072e-37, 0, 1.14975649435544097621e-37, 0, -4.74577173148911794988e-38, 0, 1.61755586895111823934e-38, 0, -4.67956717489382075806e-39, 0, 1.17405918213770350424e-39, 0, -2.59895328979019309309e-40, 0, 5.14808241045509048219e-41, 0, -9.23219630512313860499e-42, 0, 1.51371676506291971217e-42, 0, -2.28820493968175212949e-43, 0, 3.2120003308685726772e-44, 0, -4.2129914447713904955e-45, 0, 5.19160475504529711858e-46, 0, -6.03928640513913701006e-47, 0, 6.66009237657890789941e-48, 0, -6.98908744289509812284e-49, 0, 7.00274361046220793212e-50, 0, -6.71949602498196316772e-51, 0, 6.19170737616472378493e-52, 0, -5.49239755163885271997e-53, 0, 4.70073730917854937359e-54, 0, -3.88965485662095948262e-55, 0, 3.11752411006683319203e-56, 0, -2.42441786417658823476e-57, 0, 1.83226924388705222938e-58, 0, -1.34768054495926472873e-59, 0, 9.66015611648582166054e-61, 0, -6.75649304477764160193e-62, 0, 4.61636415346429500115e-63, 0, -3.08451315131118181668e-64, 0, 2.01750855036138278924e-65, 0, -1.29297948086398242675e-66, 0, 8.12632514487031194437e-68, 0, -5.01276916926538627164e-69, 0, 3.0372088873899309034e-70, 0, -1.80882789385427852778e-71, 0, 1.05959274999065190687e-72, 0, -6.10908524820372188214e-74, 0, 3.46872078061318014139e-75, 0, -1.94072620710210856904e-76, 0, 1.07051617438947479116e-77, 0, -5.82473168489388801072e-79, 0, 3.1276659981701832567e-80, 0, -1.65814972651708931753e-81},
            {1.7037934953254380462e-40, 0, -4.66533584730987278773e-39, 0, 2.31621701567847286555e-38, 0, -4.98698930402265118404e-38, 0, 6.21684280565409726413e-38, 0, -5.19665744059460749225e-38, 0, 3.1831221464099708508e-38, 0, -1.51601041422569045621e-38, 0, 5.85615134036932621834e-39, 0, -1.89349153280425895488e-39, 0, 5.25065356456028511619e-40, 0, -1.27300582435093717245e-40, 0, 2.74087720927007132154e-41, 0, -5.30851287544580469787e-42, 0, 9.34860261386080970388e-43, 0, -1.51063900184545302623e-43, 0, 2.25732245474930246481e-44, 0, -3.14023899355645310081e-45, 0, 4.09079226531809985918e-46, 0, -5.01596287537944990558e-47, 0, 5.81524732510547236032e-48, 0, -6.40019211205856670694e-49, 0, 6.71096262669294926828e-50, 0, -6.72571778056065017065e-51, 0, 6.46116130827559602372e-52, 0, -5.96535400747442059307e-53, 0, 5.30573961100801082074e-54, 0, -4.55593832743103124585e-55, 0, 3.78432787805335029144e-56, 0, -3.04623614971076873571e-57, 0, 2.38025347145697618316e-58, 0, -1.80813806448701351104e-59, 0, 1.33721605501354660949e-60, 0, -9.64051461296513491535e-62, 0, 6.78349065884058904336e-63, 0, -4.66389812601033324689e-64, 0, 3.1364785704229275029e-65, 0, -2.06517555971330526495e-66, 0, 1.33256683625604837532e-67, 0, -8.4335199819955619033e-69, 0, 5.23918533074763080836e-70, 0, -3.19727078645168306439e-71, 0, 1.91805909836270784994e-72, 0, -1.13187773904218958205e-73, 0, 6.57451059066220347169e-75, 0, -3.76105551061547521759e-76, 0, 2.12021675649915423916e-77, 0, -1.1784295121752912318e-78, 0, 6.4609470758497026349e-80, 0, -3.49593234007352997779e-81, 0},
            {0, -1.94561477217004455212e-40, 0, 1.93189351795720008307e-39, 0, -6.23926789589346776353e-39, 0, 1.03705984690591862081e-38, 0, -1.08359760296338310619e-38, 0, 7.96486641781376912091e-39, 0, -4.42562046388866158024e-39, 0, 1.95378252349500147125e-39, 0, -7.10689368568058152542e-40, 0, 2.18971355398698669442e-40, 0, -5.83978714453801702002e-41, 0, 1.37165461049540392666e-41, 0, -2.87799588899501922839e-42, 0, 5.45819034598084541717e-43, 0, -9.44987130701902736019e-44, 0, 1.50621693520095426223e-44, 0, -2.22630963252138955417e-45, 0, 3.07081655408971826164e-46, 0, -3.97449409735035382935e-47, 0, 4.85033938385017215501e-48, 0, -5.60513719130594972471e-49, 0, 6.15717422892680527365e-50, 0, -6.45119868747654200042e-51, 0, 6.46689437066093373093e-52, 0, -6.21942409829853078692e-53, 0, 5.75298474237070915967e-54, 0, -5.12997847161488788907e-55, 0, 4.41896671474552704839e-56, 0, -3.68413475781346742394e-57, 0, 2.97795687200917162224e-58, 0, -2.33758399286386751162e-59, 0, 1.78453677616714649572e-60, 0, -1.32674695339032158418e-61, 0, 9.61847211430990354151e-63, 0, -6.80755316529458579515e-64, 0, 4.70889240563939071421e-65, 0, -3.18663735434022879835e-66, 0, 2.11176962693283265157e-67, 0, -1.37166301038135447815e-68, 0, 8.7397235331016379057e-70, 0, -5.46685075908819278179e-71, 0, 3.35958177477194791107e-72, 0, -2.02974703691594067908e-73, 0, 1.20639644201325969649e-74, 0, -7.05823638416302580763e-76, 0, 4.06735459410041833636e-77, 0, -2.30980549458315734786e-78, 0, 1.2933359896288313349e-79, 0, -7.14386173841112647636e-81, 0, 3.89441767834465658656e-82},
            {-3.97402166230477185113e-42, 0, 1.18379858121632685941e-40, 0, -6.37201827665715856701e-40, 0, 1.48277493004420704933e-39, 0, -1.9919751680007723484e-39, 0, 1.7895529653641149344e-39, 0, -1.17514347636873396854e-39, 0, 5.9860570932612811034e-40, 0, -2.4677554244746189467e-40, 0, 8.49795217547290155451e-41, 0, -2.50489593263588134305e-41, 0, 6.44385825526351461717e-42, 0, -1.46961492204000981875e-42, 0, 3.01013390995369177049e-43, 0, -5.59754079122148344059e-44, 0, 9.53723744501710613703e-45, 0, -1.50062742889952385268e-45, 0, 2.195307153562011353e-46, 0, -3.00370277314648017061e-47, 0, 3.86375971343298820178e-48, 0, -4.69400425212345066307e-49, 0, 5.40783302489571322758e-50, 0, -5.92961241061673647698e-51, 0, 6.20821859583449638169e-52, 0, -6.2247172251906997493e-53, 0, 5.99289644652063660548e-54, 0, -5.55347456671841480417e-55, 0, 4.96428601145880485436e-56, 0, -4.28927348824580717953e-57, 0, 3.58875483469360597199e-58, 0, -2.9125301834491081166e-59, 0, 2.29635711111891532045e-60, 0, -1.761468295565022699e-61, 0, 1.31629814126045318253e-62, 0, -9.59430471636411410789e-64, 0, 6.82889588017831640597e-65, 0, -4.75147969770560072742e-66, 0, 3.23505134338646704071e-67, 0, -2.15730488781680261755e-68, 0, 1.41025666542644301866e-69, 0, -9.04473010695101852579e-71, 0, 5.69556331518784701179e-72, 0, -3.52398634494342041304e-73, 0, 2.14379214546696701811e-74, 0, -1.28309726949550835107e-75, 0, 7.56008717745984140136e-77, 0, -4.38764754375285719186e-78, 0, 2.50962217562020037751e-79, 0, -1.41539660655498744144e-80, 0, 7.87500970531651408482e-82, 0},
            {0, 4.73906294767973987836e-42, 0, -5.1017793391536073494e-41, 0, 1.78078361696485650533e-40, 0, -3.18976415790973349908e-40, 0, 3.58203003688078561216e-40, 0, -2.82264854617980217934e-40, 0, 1.67746534557893743339e-40, 0, -7.90326900648734172473e-41, 0, 3.06176218086891306008e-41, 0, -1.00277696649639040694e-41, 0, 2.83761405195019148583e-42, 0, -7.05991482156475305087e-43, 0, 1.56654844823570396879e-43, 0, -3.13718380945909937928e-44, 0, 5.72701758340487991071e-45, 0, -9.6118619628858390564e-46, 0, 1.49402847950747994857e-46, 0, -2.1644328806496695347e-47, 0, 2.93885644869780393453e-48, 0, -3.75827137833413533481e-49, 0, 4.54629099887066087515e-50, 0, -5.22232204137650483839e-51, 0, 5.71622741626264495275e-52, 0, -5.98061066734008407285e-53, 0, 5.99779260374818614519e-54, 0, -5.7803321879078925331e-55, 0, 5.36580914473856112935e-56, 0, -4.80791113224938517182e-57, 0, 4.16635671576765856716e-58, 0, -3.49789164188740925768e-59, 0, 2.84980919263858853902e-60, 0, -2.25652147667153234643e-61, 0, 1.73893308367496143477e-62, 0, -1.30589147528289330913e-63, 0, 9.5682650608707619577e-65, 0, -6.84772074081101281305e-66, 0, 4.79178765160103328824e-67, 0, -3.28178243555137783813e-68, 0, 2.20179778401138285021e-69, 0, -1.44833913477320231295e-70, 0, 9.34835514723234039762e-72, 0, -5.92513390350780981213e-73, 0, 3.69033500857753227708e-74, 0, -2.26009617077803595172e-75, 0, 1.36192746946886848775e-76, 0, -8.07986729053834976344e-78, 0, 4.72194433860565479527e-79, 0, -2.71978171455664253454e-80, 0, 1.54476293320792077759e-81, 0, -8.65587594339305693933e-83},
            {9.29957407315490556978e-44, 0, -3.00340227972151139094e-42, 0, 1.74723667284620928702e-41, 0, -4.3815441729529306306e-41, 0, 6.3261911954330986086e-41, 0, -6.09284419308827001035e-41, 0, 4.27924833055851386068e-41, 0, -2.3263154453946257039e-41, 0, 1.02138848262895451376e-41, 0, -3.73876812469219343247e-42, 0, 1.16934644997947451339e-42, 0, -3.18638227817875432045e-43, 0, 7.68518665735726044345e-44, 0, -1.6621656761262889176e-44, 0, 3.25909556355458236677e-45, 0, -5.84709028354515327214e-46, 0, 9.67483120560181285376e-47, 0, -1.48656104440224555955e-47, 0, 2.13378509815185921463e-48, 0, -2.87622809566387908277e-49, 0, 3.65773019924837315308e-50, 0, -4.40659041952884042486e-51, 0, 5.04768904497290076283e-52, 0, -5.51586933604756576578e-53, 0, 5.76710827283479437037e-54, 0, -5.78486934033168208768e-55, 0, 5.58060998177283633939e-56, 0, -5.1890720618861103699e-57, 0, 4.66017136575267932354e-58, 0, -4.04975680673777759426e-59, 0, 3.4112708153640875369e-60, 0, -2.78965567170931196674e-61, 0, 2.21802689244255285047e-62, 0, -1.71692952990490289858e-63, 0, 1.29554609340675544561e-64, 0, -9.54058423464642679997e-66, 0, 6.86421700484449431008e-67, 0, -4.82993882783267931437e-68, 0, 3.32689225606115540553e-69, 0, -2.24526671206991724339e-70, 0, 1.48590417371628644468e-71, 0, -9.65043394802096182117e-73, 0, 6.15538610143426694569e-74, 0, -3.85848443598291067111e-75, 0, 2.37856249573644614226e-76, 0, -1.44283344473899102919e-77, 0, 8.61736309831879701648e-79, 0, -5.07023671277239091015e-80, 0, 2.94038470410455877994e-81, 0, -1.68157715540799183084e-82, 0},
            {0, -1.15602653785507230896e-43, 0, 1.34504257079481771529e-42, 0, -5.05944346008904442628e-42, 0, 9.73994719900643106531e-42, 0, -1.17258510885849724727e-41, 0, 9.88264142755400182165e-42, 0, -6.26788387928967076448e-42, 0, 3.14510566726500710653e-42, 0, -1.29516571262922021548e-42, 0, 4.50088067539269435343e-43, 0, -1.34910223249681598021e-43, 0, 3.54968621456803274822e-44, 0, -8.31710070393758152729e-45, 0, 1.75622206217205419613e-45, 0, -3.37586722031097528542e-46, 0, 5.95823567077062587824e-47, 0, -9.72715792827733509532e-48, 0, 1.47835073215351453512e-48, 0, -2.10344530165909345751e-49, 0, 2.8157621156478042386e-50, 0, -3.56185535042670799624e-51, 0, 4.27434498751667521199e-52, 0, -4.88310545749720350435e-53, 0, 5.32750228373568929006e-54, 0, -5.56657238409275068814e-55, 0, 5.58482176289115546116e-56, 0, -5.39271866356013130518e-57, 0, 5.02243374361873665964e-58, 0, -4.52044552238880985804e-59, 0, 3.93905233774117277845e-60, 0, -3.32863820148862054295e-61, 0, 2.73193953846509151092e-62, 0, -2.18082445194713326665e-63, 0, 1.69545428374891618316e-64, 0, -1.285278706327839384e-65, 0, 9.51147352520338985155e-67, 0, -6.87856193820397423865e-68, 0, 4.86605071112944843465e-69, 0, -3.37044187947703048838e-70, 0, 2.28773170896696177143e-71, 0, -1.52294772719334574853e-72, 0, 9.95082039945071682842e-74, 0, -6.38615574951737592585e-75, 0, 4.02829753994912086281e-76, 0, -2.499096419378101443e-77, 0, 1.52576104367214323024e-78, 0, -9.17234520793616680123e-80, 0, 5.43249943822487539117e-81, 0, -3.17151797084118610208e-82, 0, 1.82597216710873008766e-83},
            {-2.18276615717007117161e-45, 0, 7.61897752519940318028e-44, 0, -4.77652614242248202916e-43, 0, 1.28734233131384927661e-42, 0, -1.99262828956345937445e-42, 0, 2.0526038113873961663e-42, 0, -1.53852196891787125519e-42, 0, 8.90770668288564104246e-43, 0, -4.15732204053823772869e-43, 0, 1.61469502806390051604e-43, 0, -5.34938140118563199123e-44, 0, 1.5415485521508232269e-44, 0, -3.92600977310052868027e-45, 0, 8.95328894440655080381e-46, 0, -1.84851407706207361308e-46, 0, 3.48753663808360527078e-47, 0, -6.06093064812051816397e-48, 0, 9.76978334248146860534e-49, 0, -1.46950935380976609014e-49, 0, 2.07348059932234821927e-50, 0, -2.7573985501487804822e-51, 0, 3.47038322152769999057e-52, 0, -4.14904385277540167036e-53, 0, 4.72781974635077146874e-54, 0, -5.15019115274812227792e-55, 0, 5.37797651241370525889e-56, 0, -5.3966349443615547847e-57, 0, 5.21574455582773669084e-58, 0, -4.86514180405244459667e-59, 0, 4.38816723754172769945e-60, 0, -3.83385634536016861374e-61, 0, 3.24975814379507617638e-62, 0, -2.67653836150374380584e-63, 0, 2.14486663928149018959e-64, 0, -1.67450254114171667022e-65, 0, 1.27510385820809423863e-66, 0, -9.48112604118456289394e-68, 0, 6.89092148634889211879e-69, 0, -4.90023576086638710076e-70, 0, 3.41249159783452394953e-71, 0, -2.3292141710015876154e-72, 0, 1.55946771401704044413e-73, 0, -1.02493857708303564242e-74, 0, 6.61729051224757544784e-76, 0, -4.19964351085034621577e-77, 0, 2.62160539530013862218e-78, 0, -1.61065582518443364745e-79, 0, 9.74457052462995077428e-81, 0, -5.80869159220150424797e-82, 0, 3.41325516204638434688e-83, 0},
            {0, 2.82381684500397460528e-45, 0, -3.54064175592156010553e-44, 0, 1.43138063411819604881e-43, 0, -2.95410627543673697471e-43, 0, 3.80377629382979009838e-43, 0, -3.42132857423694446958e-43, 0, 2.31102040514026071801e-43, 0, -1.23266052111063831955e-43, 0, 5.38608061808727654653e-44, 0, -1.98263786197789157717e-44, 0, 6.28477486646104854043e-45, 0, -1.7461134375468085599e-45, 0, 4.31385740048679266002e-46, 0, -9.59159052573467567066e-47, 0, 1.93887526382969663655e-47, 0, -3.59417425846587370842e-48, 0, 6.1556467073956665828e-49, 0, -9.80357988485676118877e-50, 0, 1.4601363381241990607e-50, 0, -2.04394577843196315464e-51, 0, 2.70107449339883223042e-52, 0, -3.38306652610917366968e-53, 0, 4.03021837118992337091e-54, 0, -4.58114905335357450176e-55, 0, 4.98309012513857305457e-56, 0, -5.20039367365749824708e-57, 0, 5.21939192964300084237e-58, 0, -5.04886044560407537165e-59, 0, 4.7165126182528919399e-60, 0, -4.2628192930927748922e-61, 0, 3.73381302815056654391e-62, 0, -3.17441193084639824804e-63, 0, 2.62333688958274569342e-64, 0, -2.11010739799816324457e-65, 0, 1.65406829159161875011e-66, 0, -1.2650341599007095106e-67, 0, 9.44971820610501919227e-69, 0, -6.9014509247446878468e-70, 0, 4.93260149141535734524e-71, 0, -3.45310072903731870256e-72, 0, 2.36973660318813208749e-73, 0, -1.59546382698380233568e-74, 0, 1.05460175366519052067e-75, 0, -6.84864941769441075187e-77, 0, 4.37239780964393749224e-78, 0, -2.745999232027726736e-79, 0, 1.69746329908064387264e-80, 0, -1.03337842031892495153e-81, 0, 6.19875780128283926492e-83, 0, -3.665657355761480443e-84},
            {5.13767215735224490179e-47, 0, -1.93256052715395127054e-45, 0, 1.30213197847679559697e-44, 0, -3.76230516211282539232e-44, 0, 6.22855552156764820692e-44, 0, -6.84726810342569075111e-44, 0, 5.4660927372252797306e-44, 0, -3.3640667860499226376e-44, 0, 1.66591037985314011783e-44, 0, -6.85372791910147155719e-45, 0, 2.40125832161955156497e-45, 0, -7.30684935792835657478e-46, 0, 1.96216559658260447811e-46, 0, -4.7117718957281526711e-47, 0, 1.02300494041688171592e-47, 0, -2.02717240858216731398e-48, 0, 3.69587683038378633779e-49, 0, -6.24284568139463566266e-50, 0, 9.82935445947489798951e-51, 0, -1.45032001663669622765e-51, 0, 2.01488508368767336865e-52, 0, -2.64672522696276996664e-53, 0, 3.29967339689741030704e-54, 0, -3.91743810559682347893e-55, 0, 4.44247185684523729865e-56, 0, -4.82543267427653307697e-57, 0, 5.03298507501289366943e-58, 0, -5.05226264266984631193e-59, 0, 4.89131598348463658727e-60, 0, -4.5759239446743870642e-61, 0, 4.14392861008354656188e-62, 0, -3.63859480752676780318e-63, 0, 3.10239638896072688137e-64, 0, -2.5722266057807798581e-65, 0, 2.07650217468678283791e-66, 0, -1.63414453135421841767e-67, 0, 1.25508049758982431455e-68, 0, -9.41741113383287930578e-70, 0, 6.91029548561491099781e-71, 0, -4.96325057617021616749e-72, 0, 3.49232746035879034726e-73, 0, -2.40932239640882819021e-74, 0, 1.63093734815472523244e-75, 0, -1.08406182494367728141e-76, 0, 7.08010238313637587187e-78, 0, -4.54644212472515134121e-79, 0, 2.87219025875437787345e-80, 0, -1.7861291429366863212e-81, 0, 1.09397214835308329076e-82, 0, -6.60262945549220837206e-84, 0},
            {0, -6.90648661426038465755e-47, 0, 9.30698620093875995233e-46, 0, -4.03366050518918901711e-45, 0, 8.90371809450865890528e-45, 0, -1.22352094115793694383e-44, 0, 1.17206666880074224243e-44, 0, -8.41563166100857839815e-45, 0, 4.76283669353724270204e-45, 0, -2.20441541257649669968e-45, 0, 8.58149497654810500803e-46, 0, -2.87241316539743712004e-46, 0, 8.414745248502397372e-47, 0, -2.18902982809982401549e-47, 0, 5.11834830487978506339e-48, 0, -1.08669086230038208839e-48, 0, 2.11330189131756463759e-49, 0, -3.79276199616893069824e-50, 0, 6.32297655287858934998e-51, 0, -9.84785196481707315073e-52, 0, 1.44013878626149493536e-52, 0, -1.98633374733073379563e-53, 0, 2.59428512686541031288e-54, 0, -3.21998648705651832414e-55, 0, 3.81030724563724056804e-56, 0, -4.31122152510086613439e-57, 0, 4.67652284422900451415e-58, 0, -4.87499026924283416063e-59, 0, 4.89449422648885012631e-60, 0, -4.74242929938638555387e-61, 0, 4.44280845135662886751e-62, 0, -4.03106182380320929462e-63, 0, 3.54789970407464542638e-64, 0, -3.03352260525803472544e-65, 0, 2.52310530647451845802e-66, 0, -2.04400794207723876155e-67, 0, 1.61472344719158683744e-68, 0, -1.24525221945093628247e-69, 0, 9.38435189404494086122e-71, 0, -6.91759095898967750439e-72, 0, 4.99228096997357944377e-73, 0, -3.53022872248337074004e-74, 0, 2.44799562978389557306e-75, 0, -1.66589097855217463972e-76, 0, 1.11331044621117801234e-77, 0, -7.31152973274512642592e-79, 0, 4.72166429801726836895e-80, 0, -3.00009345970846922697e-81, 0, 1.87659939678501617128e-82, 0, -1.15621094103648483188e-83, 0, 7.0202258869740677309e-85},
            {-1.21242398244069448534e-48, 0, 4.90148489579219959872e-47, 0, -3.54051705784631010906e-46, 0, 1.09412460597096999714e-45, 0, -1.93308637725266526549e-45, 0, 2.26330115354626088193e-45, 0, -1.92055794646214579118e-45, 0, 1.25416389422297299991e-45, 0, -6.57869427201512494701e-46, 0, 2.8622917413941014823e-46, 0, -1.05892096630325581604e-46, 0, 3.397552313501908406e-47, 0, -9.60702745874530915888e-48, 0, 2.42600082663894514603e-48, 0, -5.53224438989285426818e-49, 0, 1.15006021420918251124e-49, 0, -2.19718625984958743898e-50, 0, 3.88496365004452511786e-51, 0, -6.39647312573698293677e-52, 0, 9.85975896299405936934e-53, 0, -1.42966215795340589177e-53, 0, 1.95831930579683637411e-54, 0, -2.54368838475938124665e-55, 0, 3.14380209107122795457e-56, 0, -3.70846139964789237391e-57, 0, 4.18688064047587363399e-58, 0, -4.53572762354631090557e-59, 0, 4.72571856350647598403e-60, 0, -4.74540260929195695547e-61, 0, 4.60157966247094099632e-62, 0, -4.31664802197860907537e-63, 0, 3.92382136550951381325e-64, 0, -3.46144899157970106602e-65, 0, 2.96761476799134584781e-66, 0, -2.47587670476064281336e-67, 0, 2.01258320565321293594e-68, 0, -1.59579657464433464663e-69, 0, 1.23555730266422418862e-70, 0, -9.35067467559983993697e-72, 0, 6.92346426682229324742e-73, 0, -5.0197860455124042874e-74, 0, 3.56686009004249110457e-75, 0, -2.48578089589603488561e-76, 0, 1.70032868148616278248e-77, 0, -1.14234057015679342027e-78, 0, 7.54282171244388702451e-80, 0, -4.8979582251290619856e-81, 0, 3.12962658021827148313e-82, 0, -1.96882063689974470432e-83, 0, 1.22006684380514832289e-84, 0},
            {0, 1.69119030908084368721e-48, 0, -2.44321395032977816243e-47, 0, 1.13253818172539872585e-46, 0, -2.66794003640198353832e-46, 0, 3.90460550097266556508e-46, 0, -3.97597347270008390183e-46, 0, 3.02912465977582461843e-46, 0, -1.81591076757802480378e-46, 0, 8.88835147297320859819e-47, 0, -3.6536619297388366534e-47, 0, 1.2895068405361359386e-47, 0, -3.97772807613909894956e-48, 0, 1.08817591558078592809e-48, 0, -2.67235534088044655327e-49, 0, 5.95218815465406202852e-50, 0, -1.21297449696296836825e-50, 0, 2.27877105138810220291e-51, 0, -3.97262798244924000795e-52, 0, 6.46375239523157766162e-53, 0, -9.86570738539275252193e-54, 0, 1.4189517003866907626e-54, 0, -1.93086273274107995357e-55, 0, 2.49486957711524203901e-56, 0, -3.0709292946236784307e-57, 0, 3.61156471711750600995e-58, 0, -4.06897599158331280996e-59, 0, 4.40247025982836957592e-60, 0, -4.58454150389222960104e-61, 0, 4.60436512231505173542e-62, 0, -4.46820103969940769908e-63, 0, 4.19696873659522452059e-64, 0, -3.82184198586039633439e-65, 0, 3.37898509599983144051e-66, 0, -2.90450911248554828831e-67, 0, 2.43045005767443087603e-68, 0, -1.98218799707637693395e-69, 0, 1.57735493421237821659e-70, 0, -1.22600250286617756074e-71, 0, 9.31650185541522874637e-73, 0, -6.92803400954496475501e-74, 0, 5.04585473996931096331e-75, 0, -3.60227570506967767321e-76, 0, 2.5227031466843734745e-77, 0, -1.73425553871261373974e-78, 0, 1.17114634942001030374e-79, 0, -7.77387800622784535487e-81, 0, 5.07522373390117996569e-82, 0, -3.26071020735938348125e-83, 0, 2.06274012999260246115e-84, 0, -1.28551139226972321115e-85},
            {2.86810052417219104848e-50, 0, -1.2430386764835713458e-48, 0, 9.60339393860718217827e-48, 0, -3.16720366894504478526e-47, 0, 5.95966102780038428354e-47, 0, -7.41716688766857757125e-47, 0, 6.67824559494436187805e-47, 0, -4.61942212804936134294e-47, 0, 2.56254811472268528591e-47, 0, -1.17729106624918069943e-47, 0, 4.59245418647079992167e-48, 0, -1.5515465653712157891e-48, 0, 4.61361133798871226823e-49, 0, -1.22365744556104657966e-49, 0, 2.92736271231816734853e-50, 0, -6.37698288169420212314e-51, 0, 1.27531221998737649601e-51, 0, -2.35802187262337930296e-52, 0, 4.05591012870379112919e-53, 0, -6.52521348121590824696e-54, 0, 9.86627819742558664753e-55, 0, -1.40806188756030801293e-55, 0, 1.90397941411426366135e-56, 0, -2.44776411027606649184e-57, 0, 3.00118915966314388312e-58, 0, -3.51930730500100564089e-59, 0, 3.9570741458223415428e-60, 0, -4.2762243852094188384e-61, 0, 4.45088628490455001091e-62, 0, -4.47081402276355939949e-63, 0, 4.3417764298461708637e-64, 0, -4.08333643752452871517e-65, 0, 3.72478766430390775752e-66, 0, -3.30026971085346217789e-67, 0, 2.84405296222604455142e-68, 0, -2.38673981636272520877e-69, 0, 1.95278385715064601434e-70, 0, -1.55938914838241882726e-71, 0, 1.21659348790305297021e-72, 0, -9.28194498003948201972e-74, 0, 6.93141098490521137591e-75, 0, -5.07057170883199658446e-76, 0, 3.63652822022045649978e-77, 0, -2.55878755799527746512e-78, 0, 1.76767761862751262805e-79, 0, -1.19972304435294057845e-80, 0, 8.00460725750379085816e-82, 0, -5.25336644519011783091e-83, 0, 3.39326782787671972118e-84, 0, -2.15830596912653528608e-85, 0},
            {0, -4.14580451738443806682e-50, 0, 6.40588176797991801603e-49, 0, -3.16899406106994305818e-48, 0, 7.95070662838264946815e-48, 0, -1.23689329104704939713e-47, 0, 1.33640414958185647531e-47, 0, -1.07847447082215163066e-47, 0, 6.83732453447771314273e-48, 0, -3.53386973532116987788e-48, 0, 1.53168342002135215025e-48, 0, -5.69222001653996069601e-49, 0, 1.84648774861278026337e-49, 0, -5.30551306243822909325e-50, 0, 1.36687484475681527975e-50, 0, -3.19029386676052508704e-51, 0, 6.80551009422319622519e-52, 0, -1.3369677434942054499e-52, 0, 2.43492173922183503629e-53, 0, -4.13497134677390228651e-54, 0, 6.58123701128445010972e-55, 0, -9.86200496714087975137e-56, 0, 1.39704085897134778543e-56, 0, -1.87767998736270335185e-57, 0, 2.40230856420746847852e-58, 0, -2.93441394848868474862e-59, 0, 3.43140290542197395515e-60, 0, -3.85077752721232572616e-61, 0, 4.15650884265817785077e-62, 0, -4.32422995644344269787e-63, 0, 4.34423079752839029325e-64, 0, -4.22183286841852064446e-65, 0, 3.97535280396030403968e-66, 0, -3.63234885643396883005e-67, 0, 3.2250821041410092539e-68, 0, -2.78610385573150229289e-69, 0, 2.34466529824079826708e-70, 0, -1.92433381058158298469e-71, 0, 1.54188954204558776666e-72, 0, -1.20733495755064149957e-73, 0, 9.24710566669095469031e-75, 0, -6.93369867929033337354e-76, 0, 5.09401748428846309015e-77, 0, -3.66966875897909492878e-78, 0, 2.59405941094235318396e-79, 0, -1.80060185571342975454e-80, 0, 1.2280669359449004177e-81, 0, -8.23492659836755044947e-83, 0, 5.43229761930292269666e-84, 0, -3.52722586588174873491e-85, 0, 2.25546719263426837787e-86},
            {-6.80011675896846047045e-52, 0, 3.15215614608087819269e-50, 0, -2.59895631033620261742e-49, 0, 9.12875009273021535435e-49, 0, -1.8259222995227082407e-48, 0, 2.41122673243309260172e-48, 0, -2.29964485303793950769e-48, 0, 1.68222856233732690773e-48, 0, -9.85387405693710572838e-49, 0, 4.77342563921361796413e-49, 0, -1.96068814129041839174e-49, 0, 6.96597346387544221831e-50, 0, -2.17557944058429295787e-50, 0, 6.053409645997924421e-51, 0, -1.51752633356022789816e-51, 0, 3.46042886146942180942e-52, 0, -7.23673081497683649754e-53, 0, 1.39785009632746133849e-53, 0, -2.50946866862713588739e-54, 0, 4.20997665566036447696e-55, 0, -6.63218486035171246265e-56, 0, 9.85337729946986683001e-57, 0, -1.38593110056842510935e-57, 0, 1.85197106371379472647e-58, 0, -2.35844095367871327527e-59, 0, 2.87044638889864415056e-60, 0, -3.34758680605117436008e-61, 0, 3.7497209351481648189e-62, 0, -4.04288311947418644798e-63, 0, 4.20409432018876479991e-64, 0, -4.22414114226675384328e-65, 0, 4.10793701448057661837e-66, 0, -3.87265186989952937047e-67, 0, 3.54424003790236664863e-68, 0, -3.15321759505971008544e-69, 0, 2.73052875082170601907e-70, 0, -2.30415038008401680507e-71, 0, 1.89680233439178374794e-72, 0, -1.52484622850846466047e-73, 0, 1.19823075068658078819e-74, 0, -9.21207643011236199984e-76, 0, 6.93499373202748665635e-77, 0, -5.11626863608348390837e-78, 0, 3.70174689040980962828e-79, 0, -2.62854398838428509821e-80, 0, 1.83303594047543911444e-81, 0, -1.25617524381877888212e-82, 0, 8.46476118918170021075e-84, 0, -5.61193399109671340547e-85, 0, 3.66251370263738495476e-86, 0},
            {0, 1.01736256566631518388e-51, 0, -1.67763317386781332976e-50, 0, 8.83894850248481169231e-50, 0, -2.35727534964836407794e-49, 0, 3.89113308673065208213e-49, 0, -4.45328050905759714188e-49, 0, 3.80059045565099782857e-49, 0, -2.54428070888111512987e-49, 0, 1.38656649520014617053e-49, 0, -6.32814691104314930667e-50, 0, 2.47310486468805382459e-50, 0, -8.42605370638996002729e-51, 0, 2.53986976152188045812e-51, 0, -6.85697084053140013241e-52, 0, 1.67528698848916452678e-52, 0, -3.73706310868645101672e-53, 0, 7.66968544916178522761e-54, 0, -1.45788179796433608696e-54, 0, 2.58167351529648805757e-55, 0, -4.28109287281962391769e-56, 0, 6.67840016964068751812e-57, 0, -9.8408441109144259087e-58, 0, 1.3747700541748433869e-58, 0, -1.82685584983366996561e-59, 0, 2.31610092225948800508e-60, 0, -2.80913898116251985984e-61, 0, 3.26761395777197219933e-62, 0, -3.65356844871000553077e-63, 0, 3.93494330815551583653e-64, 0, -4.09004142346463467365e-65, 0, 4.11011052612844993933e-66, 0, -3.99969124340946102178e-67, 0, 3.77489692925791749402e-68, 0, -3.46019750907610514138e-69, 0, 3.08448618148377902154e-70, 0, -2.67720329876428619255e-71, 0, 2.26512321096415657095e-72, 0, -1.8701553215251963402e-73, 0, 1.50824918300707708736e-74, 0, -1.18928394124201922114e-75, 0, 9.17694144116441488229e-77, 0, -6.93538637335761152023e-78, 0, 5.13739793309255590211e-79, 0, -3.73281061630868846751e-80, 0, 2.66226648497623299955e-81, 0, -1.86498821912989076362e-82, 0, 1.28404604917375314837e-83, 0, -8.69404377033395600593e-85, 0, 5.79219759639319768772e-86, 0, -3.79906368055996256108e-87},
            {1.61568850080203743342e-53, 0, -7.99282198615300408136e-52, 0, 7.0186322637558699401e-51, 0, -2.62053663357425719731e-50, 0, 5.56160927867752013789e-50, 0, -7.77955252863033107264e-50, 0, 7.84650590997618916451e-50, 0, -6.06091459851290233293e-50, 0, 3.74344540456187004033e-50, 0, -1.90946646035062240862e-50, 0, 8.24790608049140901543e-51, 0, -3.07775424828690650587e-51, 0, 1.00840116044029577615e-51, 0, -2.94020727127294155268e-52, 0, 7.71558915292909277447e-53, 0, -1.83981436856950790321e-53, 0, 4.0195124049654233032e-54, 0, -8.10349257577512630302e-55, 0, 1.51699770596571301333e-55, 0, -2.6515580344461707564e-56, 0, 4.34848699570354192394e-57, 0, -6.72020758188982056163e-58, 0, 9.82481672937452113074e-59, 0, -1.36359066250392271511e-59, 0, 1.80233468284434543018e-60, 0, -2.27522988177148765287e-61, 0, 2.75035334662876553458e-62, 0, -3.19125727717754069158e-63, 0, 3.56201066880676049342e-64, 0, -3.83231852639181189452e-65, 0, 3.98166957218693587873e-66, 0, -4.00174026556284701615e-67, 0, 3.89673018056081134757e-68, 0, -3.6817777798929663825e-69, 0, 3.37997742940256317985e-70, 0, -3.0187113015267386833e-71, 0, 2.62601118156346635249e-72, 0, -2.22751594392729584578e-73, 0, 1.84436004090055994238e-74, 0, -1.49208830537997186095e-75, 0, 1.18049692411700029557e-76, 0, -9.14177722266861395571e-78, 0, 6.93496083693590409941e-79, 0, -5.15747450419289590004e-80, 0, 3.76290636887778014639e-81, 0, -2.69525192938802348574e-82, 0, 1.89646760234012824117e-83, 0, -1.31167822252220801421e-84, 0, 8.92271422764054582324e-86, 0, -5.97301559202793294055e-87, 0},
            {0, -2.4989964522463486706e-53, 0, 4.38882215996644968959e-52, 0, -2.45797232628056878556e-51, 0, 6.95546172817238250495e-51, 0, -1.21615833574121800887e-50, 0, 1.47194999204516104426e-50, 0, -1.32648304612614884805e-50, 0, 9.36325798461132754503e-51, 0, -5.3730396179593196312e-51, 0, 2.57874979191542812889e-51, 0, -1.05850307397658868912e-51, 0, 3.78338102874870276312e-52, 0, -1.1950519876786794698e-52, 0, 3.37724547537640686208e-53, 0, -8.62840981785699736245e-54, 0, 2.01075360010180977153e-54, 0, -4.30711689759561303749e-55, 0, 8.53734689114202757877e-56, 0, -1.57514390433353170988e-56, 0, 2.71915315860370363482e-57, 0, -4.41232487882889955486e-58, 0, 6.75791364114793364129e-59, 0, -9.80567181125649634835e-60, 0, 1.35242185630801503248e-60, 0, -1.77840549071468637879e-61, 0, 2.23577110758209327327e-62, 0, -2.69395961711116462351e-63, 0, 3.11830611403232035255e-64, 0, -3.4747622569319306855e-65, 0, 3.73466773768402422372e-66, 0, -3.87860979585322095412e-67, 0, 3.8986640416926033135e-68, 0, -3.79871762004837573659e-69, 0, 3.59300826490336989144e-70, 0, -3.30335405452429716957e-71, 0, 2.95572871453396609799e-72, 0, -2.57684350634964100075e-73, 0, 2.19126448531808461641e-74, 0, -1.81938509494719149497e-75, 0, 1.4763534733373899478e-76, 0, -1.17187149211677567482e-77, 0, 9.1066532876091326288e-79, 0, -6.93379574782062282542e-80, 0, 5.17656399728496603761e-81, 0, -3.79207901727793875041e-82, 0, 2.72752511741026880541e-83, 0, -1.92748348232667887349e-84, 0, 1.33907135604888389923e-85, 0, -9.15071917250135433622e-87, 0, 6.1543200715552177688e-88},
            {-3.84645918575676563055e-55, 0, 2.02658454717065497932e-53, 0, -1.89165739396291970029e-52, 0, 7.49410017850223030836e-52, 0, -1.68472150405709854043e-51, 0, 2.49219046272196578922e-51, 0, -2.65424217021874901774e-51, 0, 2.16179116527822858183e-51, 0, -1.40593244452615193813e-51, 0, 7.54150973297056422495e-52, 0, -3.42142407750008465169e-52, 0, 1.33937875765225840965e-52, 0, -4.59856464715220575199e-53, 0, 1.40353058716941583879e-53, 0, -3.85144988502707722576e-54, 0, 9.59436061231839967943e-55, 0, -2.18774191623904154285e-55, 0, 4.59924411644014953738e-56, 0, -8.97051651145214788117e-57, 0, 1.63227664354854359608e-57, 0, -2.78449747042978172966e-58, 0, 4.47277016364577041386e-59, 0, -6.79180731515601478674e-60, 0, 9.7837540735317682003e-61, 0, -1.34128898962993181431e-61, 0, 1.75506418834727091004e-62, 0, -2.19766979827827571018e-63, 0, 2.63983586373106484872e-64, 0, -3.0485648661105539059e-65, 0, 3.39155973484725239749e-66, 0, -3.64167692232106171353e-67, 0, 3.78052270709585775854e-68, 0, -3.80054480505080400774e-69, 0, 3.70534378064108948881e-70, 0, -3.50832407522349598384e-71, 0, 3.23011815267973591853e-72, 0, -2.89538548861604683875e-73, 0, 2.52959825144944833063e-74, 0, -2.15630826067815288293e-75, 0, 1.79520037546749484755e-76, 0, -1.46103458757416188029e-77, 0, 1.16340890485280693901e-78, 0, -9.07163272442140167635e-80, 0, 6.9319644869847741456e-81, 0, -5.19472873554957650849e-82, 0, 3.82037188162515765337e-83, 0, -2.75911055478797322151e-84, 0, 1.95804565771457770739e-85, 0, -1.36622570040616661181e-86, 0, 9.37801153760795088579e-88, 0},
            {0, 6.14402964394088496529e-55, 0, -1.14699375566781511678e-53, 0, 6.815995964589248648e-53, 0, -2.04303913738267546881e-52, 0, 3.77780737119700970848e-52, 0, -4.82814573873746323191e-52, 0, 4.58775643750743472356e-52, 0, -3.40991077963432373054e-52, 0, 2.05773469859504667518e-52, 0, -1.03727875483911148489e-52, 0, 4.46667822631233564785e-53, 0, -1.67298527275126888365e-53, 0, 5.53163874140931149148e-54, 0, -1.63471053888742550161e-54, 0, 4.36310708815785433183e-55, 0, -1.06121809369804253944e-55, 0, 2.3704126626242375181e-56, 0, -4.89529119328312174486e-57, 0, 9.40233980775397080766e-58, 0, -1.68836133934641616071e-58, 0, 2.84763585511962528681e-59, 0, -4.52998342382140911615e-60, 0, 6.82216060631063127773e-61, 0, -9.75937884245659342501e-62, 0, 1.33021422857477389404e-62, 0, -1.7323050182324094917e-63, 0, 2.16087310673881474324e-64, 0, -2.58786756358265303579e-65, 0, 2.98185172583352181403e-66, 0, -3.31215951423790594281e-67, 0, 3.55305655540958646617e-68, 0, -3.68709570639257105229e-69, 0, 3.70707201934474671339e-70, 0, -3.61632285738989091618e-71, 0, 3.42748078234440261878e-72, 0, -3.16007557992609589677e-73, 0, 2.83753908336563583729e-74, 0, -2.48417975927007351718e-75, 0, 2.12258999618008369334e-76, 0, -1.77177701851344257871e-77, 0, 1.44612160981004220731e-78, 0, -1.15510995045104601569e-79, 0, 9.03677273373248308627e-81, 0, -6.92953553342900597682e-82, 0, 5.21202787022088905602e-83, 0, -3.84782675317912310276e-84, 0, 2.79003240873042672391e-85, 0, -1.98816426551643648734e-86, 0, 1.39314210575006173373e-87, 0, -9.60455018874562843258e-89},
            {9.17434290724204542329e-57, 0, -5.13811682403229396204e-55, 0, 5.088865765417312339e-54, 0, -2.13548434721899562577e-53, 0, 5.07696284726475965347e-53, 0, -7.93039322697601426779e-53, 0, 8.90564484927913799279e-53, 0, -7.63758296795923188515e-53, 0, 5.22348038874127232931e-53, 0, -2.94286777956616697296e-53, 0, 1.4006371089748636217e-53, 0, -5.74568245257109992168e-54, 0, 2.06497826319578370157e-54, 0, -6.59062031741491457887e-55, 0, 1.88936356713441927401e-55, 0, -4.9123353387017987233e-56, 0, 1.16804497266868536525e-56, 0, -2.55839879105973104765e-57, 0, 5.1946863824740264055e-58, 0, -9.83222191737030587708e-59, 0, 1.74337163437866652174e-59, 0, -2.90861831601926675829e-60, 0, 4.58412149338067305314e-61, 0, -6.84922922382360923176e-62, 0, 9.73283442355388862743e-63, 0, -1.31921689850006568984e-63, 0, 1.7101208432969171882e-64, 0, -2.12533014837217885066e-65, 0, 2.53794710239495680189e-66, 0, -2.91799754489647188718e-67, 0, 3.23633612942963690334e-68, 0, -3.46853935456568109399e-69, 0, 3.59804048936401886888e-70, 0, -3.61795920257423023334e-71, 0, 3.53139083321185735881e-72, 0, -3.35025207410264374938e-73, 0, 3.09304599630217951676e-74, 0, -2.78205651773458459503e-75, 0, 2.44049827162606002931e-76, 0, -2.09005551459934153969e-77, 0, 1.74908735883359403626e-78, 0, -1.43160459469928282216e-79, 0, 1.14697500081989208403e-80, 0, -9.00212512057677654273e-82, 0, 6.92657278499491002603e-83, 0, -5.22851752931986727492e-84, 0, 3.87448391963514914737e-85, 0, -2.82031446714661918001e-86, 0, 2.01784971968594914465e-87, 0, -1.41982196681592615788e-88, 0},
            {0, -1.51187451563532584742e-56, 0, 2.99476509690786057719e-55, 0, -1.88507840927105015713e-54, 0, 5.97552061074640134884e-54, 0, -1.1667464782771035484e-53, 0, 1.57227458472121803825e-53, 0, -1.5731341291