---
layout: post
title: At WIRED's Helm
tags: story
icon_alt: Purple background with a white greater than symbol and underscore in the middle, written in a pixelated typeface
doi: 10.5281/zenodo.8325972
---
WIRED (officially the Faculty of Information Technology Society), is Monash University's official IT club. I have lead
this club for two years, and now that I have resigned I thought I would write about my experiences and lessons learned
at WIRED's helm.

## Joining WIRED

Excited to jump into uni life, I was looking online for IT groups I can join at Monash, hoping to make some connections
and meet like-minded people, and saw that they were recruiting for some positions in their committee. I applied on a
whim, thinking they would never accept a first-year into any important role. On March 2020, To my surprise, they accepted me to become
the new club Secretary.

## My Stumble into Leadership

The club was facing a few huge hurdles. The previous committee had not filled out required financial audit documentation
(meaning the club could have been shut down), the club's membership had shrunk because O-week was cancelled when the
virus spread to Australia, and to top it all off, both the President and Vice President were looking for the exit door.

Perhaps with a little too much self-confidence, I put my hand up to become President, got elected, and previous President
and VP both left.

## Putting out the Fire

I had a few ideas in mind about how to revitalise the club. But first I had to put out the fire that the previous committee
left us by not completing the financial audit. I had a lot of meetings and a lot of reparations to pay on the club's
behalf, all while figuring out the legal and financial landscape of this space myself, but eventually I was able to get a
special dispensation, and I could get to what I really wanted to work on.

## Growing the Club

I wanted to grow the club's leadership, since I knew I couldn't make the changes I wanted to make by myself. I designed
WIRED's four subcommittees (Industry, Publications, Education, and Events) wrote their drafts, and began the recruitment
application reviews, interviews, and official acceptances of the applicants. After this, WIRED really got into the swing
of things. We had a podcast (WIRED_in), industry panels, games nights, outdoor cinema, bar/restaurant outings, a social
media team, a brand-new website, and so much more.

Off the back of this success, I looked back to WIRED's mission statement to support IT/CS students at Monash, and realised
that Monash is a global university, and a significant number of the IT students were in its Malaysian campus in Sunway
City (near Kuala Lumpur). I explored the IT landscape at the Malaysia campus, sent out some feelers, and found that there
was no IT club on the campus, and that students there were definitely wanting one, so decided to make it. Cognisant of the
cultural difference I knew that we would need to run this differently to the subcommittees, so I worked with the Monash
Malaysian school of IT to create it in a way consistent with Malaysian cultural expectations, and to find local students
to lead it with a lot of autonomy. Once the legal process was over, recruitment started, and WIRED Malaysia was born.

## Founding ACSA

Many of WIRED's events could be accessed online (such as industry panels), and I thought about how we could very easily
share some of these events with a wider audience.

Some student clubs have interconnecting associations, such as VITA for Victorian Italian-Australian tertiary clubs. But
no organisation like that existed for IT clubs, so I decided to make one. After getting advice from club leaders that
are part of VITA, I decided to go for a less controlling framework, so that each club can choose which events to share,
and whether they would like to leave.

After meeting with every IT club I could find in every Australian university, I founded the Australian Computing
Students' Association (ACSA), and managed to get nearly all the clubs I met with to agree to join. The negotiations over
the constitution were tedious, since it was a room full of lions and not a single sheep, but before long, ACSA was off
and away.

## Resigning

After two years in the club (a pretty long term in this context), I felt that I had accomplished what I wanted to be
accomplished, I was seeing that there was some leadership potential in some members of the committee, and I had begun
a university entrepreneurship program called [Fastrack](https://www.fastrackatmonash.com) which took up a lot of my time.
The writing was on the role, it felt right, so I decided to leave the club I became so fond of. In the ensuing general
meeting's election, as a parting gift from the club, they kindly voted to make me an honorary life member.

## Final Thoughts

There are things I could have done better, for instance I think we should have held more events, even though we were in
lockdown, but overall, I am very happy with what I was able to do in WIRED.

WIRED has shaped by university experience, taught me about myself, and given me many untold opportunities. My number one
take-away from my time at WIRED is this: **Apply anyway**.
