%
% Calculates diffusion field around oblate spheroid precipitate
% From Mou and Howe, Met Mat Trans A 28A 1997 p.39-50
%
% Set up for case of Mg17Al12 ppts in AZ80 at 180C
%
% (c) Joseph Robson, University of Manchester, 2023
% Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
% Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
% Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation 
% and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES, 
% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
% IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
% OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
% Note: This code is provided without support.
%
%
% Aspect ratio
A = 5;
b = 1e-7; % minor axis length of particle
%
%
c = (sqrt(A^2-1)) * b; 
% Concentrations
c0 = 0.02;
cs = 0.08;
%
%
xstore = [];
zstore = [];
cstore = [];
%
ep = 1-(1/sqrt((A^2)-1)); % epsilon coordinate on surface of sphere
q0p = -i * atan(1/ep);
epmax = ep .* 10; % calculate to multiple distance of surface
step = (epmax-ep)/100;
for ec = ep:step:epmax
    for theta = 0:((2*pi)/100):2*pi
        q0 = -i * atan(1/ec);
        conc = ((c0 - cs) * (q0/q0p)) + cs;
        n = cos(theta);
        x = c .* sqrt((ec^2 + 1)*(1-n^2));
        %disp(['ec2 + 1 ' num2str(ec^2 + 1) ' 1-n^2 ' num2str(1-n^2) ' x ' num2str(x)])
        z = c .* ec .* n;
        xstore = [xstore x];
        zstore = [zstore z];
        cstore = [cstore conc];
    end
end
xv = linspace(min(xstore),max(xstore));                         % ?x? Vector For Interpolation
zv = linspace(min(zstore),max(zstore));                         % ?y? Vector For Interpolation
[X,Z] = ndgrid(xv,zv);                                % Create Interpolation Grids
C = griddata(xstore, zstore, cstore, X, Z);        % Interpolated Grid Of ?tally? Values
