# Contributing

When contributing to Flux Cloud, it is important to properly communicate the gist of the contribution.
If it is a simple code or editorial fix, simply explaining this within the GitHub Pull Request (PR) will suffice. But if this is a larger
fix or Enhancement, it should be first discussed with the project leader or developers.
You can also join us on the Flux Framework Slack using the [Contact](https://flux-framework.org/) link here to get an invitiation.

## Pull Request Process

1. All pull requests should go to the main branch.
2. Follow the existing code style precedent.
3. Test your PR locally, and provide the steps necessary to test for the reviewers.
4. The project's default copyright and header have been included in any new source files.
5. All (major) changes must be documented in the CHANGELOG.md in the root of the repository, and documentation updated here.
6. If necessary, update the README.md.
7. The pull request will be reviewed by others, and the final merge must be done by a project owner.

If you have any questions, please don't hesitate to [open an issue](https://github.com/flux-framework/flux-cloud/issues).
