/**
 * Copyright (c) 2018-2022 mol* contributors, licensed under MIT, See LICENSE file for more info.
 *
 * @author Michal Malý <michal.maly@ibt.cas.cz>
 * @author Jiří Černý <jiri.cerny@ibt.cas.cz>
 */

import { Color, ColorMap } from '../../mol-util/color';

export const DefaultNtCClassColors = {
    A: 0xFFC1C1,
    B: 0xC8CFFF,
    BII: 0x0059DA,
    miB: 0x3BE8FB,
    Z: 0x01F60E,
    IC: 0xFA5CFB,
    OPN: 0xE90000,
    SYN: 0xFFFF01,
    N: 0xF2F2F2,
};
export const ErrorColor = Color(0xFFA10A);

export const NtCColors = ColorMap({
    NANT_Upr: DefaultNtCClassColors.N,
    NANT_Lwr: DefaultNtCClassColors.N,
    AA00_Upr: DefaultNtCClassColors.A,
    AA00_Lwr: DefaultNtCClassColors.A,
    AA02_Upr: DefaultNtCClassColors.A,
    AA02_Lwr: DefaultNtCClassColors.A,
    AA03_Upr: DefaultNtCClassColors.A,
    AA03_Lwr: DefaultNtCClassColors.A,
    AA04_Upr: DefaultNtCClassColors.A,
    AA04_Lwr: DefaultNtCClassColors.A,
    AA08_Upr: DefaultNtCClassColors.A,
    AA08_Lwr: DefaultNtCClassColors.A,
    AA09_Upr: DefaultNtCClassColors.A,
    AA09_Lwr: DefaultNtCClassColors.A,
    AA01_Upr: DefaultNtCClassColors.A,
    AA01_Lwr: DefaultNtCClassColors.A,
    AA05_Upr: DefaultNtCClassColors.A,
    AA05_Lwr: DefaultNtCClassColors.A,
    AA06_Upr: DefaultNtCClassColors.A,
    AA06_Lwr: DefaultNtCClassColors.A,
    AA10_Upr: DefaultNtCClassColors.A,
    AA10_Lwr: DefaultNtCClassColors.A,
    AA11_Upr: DefaultNtCClassColors.A,
    AA11_Lwr: DefaultNtCClassColors.A,
    AA07_Upr: DefaultNtCClassColors.A,
    AA07_Lwr: DefaultNtCClassColors.A,
    AA12_Upr: DefaultNtCClassColors.A,
    AA12_Lwr: DefaultNtCClassColors.A,
    AA13_Upr: DefaultNtCClassColors.A,
    AA13_Lwr: DefaultNtCClassColors.A,
    AB01_Upr: DefaultNtCClassColors.A,
    AB01_Lwr: DefaultNtCClassColors.B,
    AB02_Upr: DefaultNtCClassColors.A,
    AB02_Lwr: DefaultNtCClassColors.B,
    AB03_Upr: DefaultNtCClassColors.A,
    AB03_Lwr: DefaultNtCClassColors.B,
    AB04_Upr: DefaultNtCClassColors.A,
    AB04_Lwr: DefaultNtCClassColors.B,
    AB05_Upr: DefaultNtCClassColors.A,
    AB05_Lwr: DefaultNtCClassColors.B,
    BA01_Upr: DefaultNtCClassColors.B,
    BA01_Lwr: DefaultNtCClassColors.A,
    BA05_Upr: DefaultNtCClassColors.B,
    BA05_Lwr: DefaultNtCClassColors.A,
    BA09_Upr: DefaultNtCClassColors.B,
    BA09_Lwr: DefaultNtCClassColors.A,
    BA08_Upr: DefaultNtCClassColors.BII,
    BA08_Lwr: DefaultNtCClassColors.A,
    BA10_Upr: DefaultNtCClassColors.B,
    BA10_Lwr: DefaultNtCClassColors.A,
    BA13_Upr: DefaultNtCClassColors.BII,
    BA13_Lwr: DefaultNtCClassColors.A,
    BA16_Upr: DefaultNtCClassColors.BII,
    BA16_Lwr: DefaultNtCClassColors.A,
    BA17_Upr: DefaultNtCClassColors.BII,
    BA17_Lwr: DefaultNtCClassColors.A,
    BB00_Upr: DefaultNtCClassColors.B,
    BB00_Lwr: DefaultNtCClassColors.B,
    BB01_Upr: DefaultNtCClassColors.B,
    BB01_Lwr: DefaultNtCClassColors.B,
    BB17_Upr: DefaultNtCClassColors.B,
    BB17_Lwr: DefaultNtCClassColors.B,
    BB02_Upr: DefaultNtCClassColors.B,
    BB02_Lwr: DefaultNtCClassColors.B,
    BB03_Upr: DefaultNtCClassColors.B,
    BB03_Lwr: DefaultNtCClassColors.B,
    BB11_Upr: DefaultNtCClassColors.B,
    BB11_Lwr: DefaultNtCClassColors.B,
    BB16_Upr: DefaultNtCClassColors.B,
    BB16_Lwr: DefaultNtCClassColors.B,
    BB04_Upr: DefaultNtCClassColors.B,
    BB04_Lwr: DefaultNtCClassColors.BII,
    BB05_Upr: DefaultNtCClassColors.B,
    BB05_Lwr: DefaultNtCClassColors.BII,
    BB07_Upr: DefaultNtCClassColors.BII,
    BB07_Lwr: DefaultNtCClassColors.BII,
    BB08_Upr: DefaultNtCClassColors.BII,
    BB08_Lwr: DefaultNtCClassColors.BII,
    BB10_Upr: DefaultNtCClassColors.miB,
    BB10_Lwr: DefaultNtCClassColors.miB,
    BB12_Upr: DefaultNtCClassColors.miB,
    BB12_Lwr: DefaultNtCClassColors.miB,
    BB13_Upr: DefaultNtCClassColors.miB,
    BB13_Lwr: DefaultNtCClassColors.miB,
    BB14_Upr: DefaultNtCClassColors.miB,
    BB14_Lwr: DefaultNtCClassColors.miB,
    BB15_Upr: DefaultNtCClassColors.miB,
    BB15_Lwr: DefaultNtCClassColors.miB,
    BB20_Upr: DefaultNtCClassColors.miB,
    BB20_Lwr: DefaultNtCClassColors.miB,
    IC01_Upr: DefaultNtCClassColors.IC,
    IC01_Lwr: DefaultNtCClassColors.IC,
    IC02_Upr: DefaultNtCClassColors.IC,
    IC02_Lwr: DefaultNtCClassColors.IC,
    IC03_Upr: DefaultNtCClassColors.IC,
    IC03_Lwr: DefaultNtCClassColors.IC,
    IC04_Upr: DefaultNtCClassColors.IC,
    IC04_Lwr: DefaultNtCClassColors.IC,
    IC05_Upr: DefaultNtCClassColors.IC,
    IC05_Lwr: DefaultNtCClassColors.IC,
    IC06_Upr: DefaultNtCClassColors.IC,
    IC06_Lwr: DefaultNtCClassColors.IC,
    IC07_Upr: DefaultNtCClassColors.IC,
    IC07_Lwr: DefaultNtCClassColors.IC,
    OP01_Upr: DefaultNtCClassColors.OPN,
    OP01_Lwr: DefaultNtCClassColors.OPN,
    OP02_Upr: DefaultNtCClassColors.OPN,
    OP02_Lwr: DefaultNtCClassColors.OPN,
    OP03_Upr: DefaultNtCClassColors.OPN,
    OP03_Lwr: DefaultNtCClassColors.OPN,
    OP04_Upr: DefaultNtCClassColors.OPN,
    OP04_Lwr: DefaultNtCClassColors.OPN,
    OP05_Upr: DefaultNtCClassColors.OPN,
    OP05_Lwr: DefaultNtCClassColors.OPN,
    OP06_Upr: DefaultNtCClassColors.OPN,
    OP06_Lwr: DefaultNtCClassColors.OPN,
    OP07_Upr: DefaultNtCClassColors.OPN,
    OP07_Lwr: DefaultNtCClassColors.OPN,
    OP08_Upr: DefaultNtCClassColors.OPN,
    OP08_Lwr: DefaultNtCClassColors.OPN,
    OP09_Upr: DefaultNtCClassColors.OPN,
    OP09_Lwr: DefaultNtCClassColors.OPN,
    OP10_Upr: DefaultNtCClassColors.OPN,
    OP10_Lwr: DefaultNtCClassColors.OPN,
    OP11_Upr: DefaultNtCClassColors.OPN,
    OP11_Lwr: DefaultNtCClassColors.OPN,
    OP12_Upr: DefaultNtCClassColors.OPN,
    OP12_Lwr: DefaultNtCClassColors.OPN,
    OP13_Upr: DefaultNtCClassColors.OPN,
    OP13_Lwr: DefaultNtCClassColors.OPN,
    OP14_Upr: DefaultNtCClassColors.OPN,
    OP14_Lwr: DefaultNtCClassColors.OPN,
    OP15_Upr: DefaultNtCClassColors.OPN,
    OP15_Lwr: DefaultNtCClassColors.OPN,
    OP16_Upr: DefaultNtCClassColors.OPN,
    OP16_Lwr: DefaultNtCClassColors.OPN,
    OP17_Upr: DefaultNtCClassColors.OPN,
    OP17_Lwr: DefaultNtCClassColors.OPN,
    OP18_Upr: DefaultNtCClassColors.OPN,
    OP18_Lwr: DefaultNtCClassColors.OPN,
    OP19_Upr: DefaultNtCClassColors.OPN,
    OP19_Lwr: DefaultNtCClassColors.OPN,
    OP20_Upr: DefaultNtCClassColors.OPN,
    OP20_Lwr: DefaultNtCClassColors.OPN,
    OP21_Upr: DefaultNtCClassColors.OPN,
    OP21_Lwr: DefaultNtCClassColors.OPN,
    OP22_Upr: DefaultNtCClassColors.OPN,
    OP22_Lwr: DefaultNtCClassColors.OPN,
    OP23_Upr: DefaultNtCClassColors.OPN,
    OP23_Lwr: DefaultNtCClassColors.OPN,
    OP24_Upr: DefaultNtCClassColors.OPN,
    OP24_Lwr: DefaultNtCClassColors.OPN,
    OP25_Upr: DefaultNtCClassColors.OPN,
    OP25_Lwr: DefaultNtCClassColors.OPN,
    OP26_Upr: DefaultNtCClassColors.OPN,
    OP26_Lwr: DefaultNtCClassColors.OPN,
    OP27_Upr: DefaultNtCClassColors.OPN,
    OP27_Lwr: DefaultNtCClassColors.OPN,
    OP28_Upr: DefaultNtCClassColors.OPN,
    OP28_Lwr: DefaultNtCClassColors.OPN,
    OP29_Upr: DefaultNtCClassColors.OPN,
    OP29_Lwr: DefaultNtCClassColors.OPN,
    OP30_Upr: DefaultNtCClassColors.OPN,
    OP30_Lwr: DefaultNtCClassColors.OPN,
    OP31_Upr: DefaultNtCClassColors.OPN,
    OP31_Lwr: DefaultNtCClassColors.OPN,
    OPS1_Upr: DefaultNtCClassColors.OPN,
    OPS1_Lwr: DefaultNtCClassColors.OPN,
    OP1S_Upr: DefaultNtCClassColors.OPN,
    OP1S_Lwr: DefaultNtCClassColors.SYN,
    AAS1_Upr: DefaultNtCClassColors.SYN,
    AAS1_Lwr: DefaultNtCClassColors.A,
    AB1S_Upr: DefaultNtCClassColors.A,
    AB1S_Lwr: DefaultNtCClassColors.SYN,
    AB2S_Upr: DefaultNtCClassColors.A,
    AB2S_Lwr: DefaultNtCClassColors.SYN,
    BB1S_Upr: DefaultNtCClassColors.B,
    BB1S_Lwr: DefaultNtCClassColors.SYN,
    BB2S_Upr: DefaultNtCClassColors.B,
    BB2S_Lwr: DefaultNtCClassColors.SYN,
    BBS1_Upr: DefaultNtCClassColors.SYN,
    BBS1_Lwr: DefaultNtCClassColors.B,
    ZZ01_Upr: DefaultNtCClassColors.Z,
    ZZ01_Lwr: DefaultNtCClassColors.Z,
    ZZ02_Upr: DefaultNtCClassColors.Z,
    ZZ02_Lwr: DefaultNtCClassColors.Z,
    ZZ1S_Upr: DefaultNtCClassColors.Z,
    ZZ1S_Lwr: DefaultNtCClassColors.SYN,
    ZZ2S_Upr: DefaultNtCClassColors.Z,
    ZZ2S_Lwr: DefaultNtCClassColors.SYN,
    ZZS1_Upr: DefaultNtCClassColors.SYN,
    ZZS1_Lwr: DefaultNtCClassColors.Z,
    ZZS2_Upr: DefaultNtCClassColors.SYN,
    ZZS2_Lwr: DefaultNtCClassColors.Z,
});

