Data Format
===========

This document describes the CIF categories and fields generated by the server.

Query info
----------

The reponse always contains a data block called ``SERVER`` with this format:

```
data_SERVER
#
_density_server_result.server_version     0.9.0 
_density_server_result.datetime_utc       '2017-03-09 20:35:45' 
_density_server_result.guid               f69581b4-6b48-4fa4-861f-c879b4323688 
_density_server_result.is_empty           no 
_density_server_result.has_error          no 
_density_server_result.error              . 
_density_server_result.query_source_id    xray/1cbs 
_density_server_result.query_type         box 
_density_server_result.query_box_type     cartesian 
_density_server_result.query_box_a[0]     14.555 
_density_server_result.query_box_a[1]     16.075001 
_density_server_result.query_box_a[2]     9.848 
_density_server_result.query_box_b[0]     29.302999 
_density_server_result.query_box_b[1]     35.737 
_density_server_result.query_box_b[2]     32.037001 
```

Query data
----------

If the query completed successfully with a non-empty result the response will contain one or more data blocks that correpond to the
"channels" present in the data (e.g. for x-ray data there will be ``2Fo-Fc`` and ``Fo-Fc``) channels.

The format is this:

```
data_2FO-FC
#
_volume_data_3d_info.name                         2Fo-Fc 
```
### Axis order

Axis order determines the order of axes of ``origin``, ``dimensions`` and ``sample_count`` fields. It also specifies
the order of values in ``_volume_data_3d.values``. ``0`` = X axis, ``1`` = Y axis, ``2`` = Z axis.

```
_volume_data_3d_info.axis_order[0]                0 
_volume_data_3d_info.axis_order[1]                1 
_volume_data_3d_info.axis_order[2]                2  
```

### Origin and dimensions

Specifies the fractional coordinates of the bounding box of the data present in the data block.

```
_volume_data_3d_info.origin[0]                    -0.5 
_volume_data_3d_info.origin[1]                    -0.5 
_volume_data_3d_info.origin[2]                    -0.5 
_volume_data_3d_info.dimensions[0]                1 
_volume_data_3d_info.dimensions[1]                1 
_volume_data_3d_info.dimensions[2]                1 
```

### Sample rate

Determines how many values of the original input data were collapsed in to 1 value.

```
_volume_data_3d_info.sample_rate                  8 
```

### Sample count

Determines how many values in ``_volume_data_3d.values`` are present along each axis (in ``axis_order``).

```
_volume_data_3d_info.sample_count[0]              96 
_volume_data_3d_info.sample_count[1]              96 
_volume_data_3d_info.sample_count[2]              96 
```

### Spacegroup information

```
_volume_data_3d_info.spacegroup_number            1 
_volume_data_3d_info.spacegroup_cell_size[0]      798.72 
_volume_data_3d_info.spacegroup_cell_size[1]      798.72 
_volume_data_3d_info.spacegroup_cell_size[2]      798.72 
_volume_data_3d_info.spacegroup_cell_angles[0]    90 
_volume_data_3d_info.spacegroup_cell_angles[1]    90 
_volume_data_3d_info.spacegroup_cell_angles[2]    90 
```

### Values info

Contains mean, standard deviation, min, and max values for the _entire_ (i.e. not just the slice present in response)
original and the downsampled data. Both types of values are present 
so that relative iso-levels can be estimated when sampling changes between queries.

```
_volume_data_3d_info.mean_source                  0.026747 
_volume_data_3d_info.mean_sampled                 0.026748 
_volume_data_3d_info.sigma_source                 1.129252 
_volume_data_3d_info.sigma_sampled                0.344922 
_volume_data_3d_info.min_source                   -19.308199 
_volume_data_3d_info.min_sampled                  -2.692016 
_volume_data_3d_info.max_source                   26.264214 
_volume_data_3d_info.max_sampled                  3.533172 
```

### Values

The values are stored in the ``_volume_data_3d.values`` loop containg ``sample_count[0] * sample_count[1] * sample_count[2]`` values. ``axis_order[0]`` is the axis that changes the fastest, ``axis_order[2]`` is the axis that changes the slowest, same as in the [CCP4 format](http://www.ccp4.ac.uk/html/maplib.html#description)).

```
loop_
_volume_data_3d.values
-0.075391 
-0.078252 
-0.078161 
...
```