rm( list = ls() )

library( "data.table" )
library( "dplyr" )
library( "tidyr" )
library( "ggplot2" )
library("extrafont")
library("scales")

font_import() #import fonts for plot labels
loadfonts(device = "all") #load the fonts
a=pdfFonts() #list available fonts

# Results file
df <- fread( "2010_results.csv" )
#df <- fread( "2015_results.csv" )

# Select the variables of interest, drop duplicated rows, include informative scenario labels
df <- df %>%
  select( scenario, country, starts_with( "gini" ) ) %>% 
  unique %>% 
  mutate( scenario_lab =
            case_when( scenario == 1 ~ "5% rate",
                       scenario == 2 ~ "Standard VAT",
                       scenario == 3 ~ "GHG-based",
                       scenario == 4 ~ "Unit tax",
                       scenario == 5 ~ "Social cost"),     ### SCENARIO 5? ###
          scenario_lab = paste0( "(", scenario, ") ", scenario_lab ) ) %>% 
  relocate( scenario, scenario_lab )

# Separate scenario 5
df_sc5 <- df %>% filter( scenario  %in% c(1,2,5) )
df <- df %>% filter( scenario != 5 )

# Reshape to long to plot the net effect of recycling without DR
df <- df %>%
  pivot_longer( cols = starts_with( "gini" ) ) %>%
  mutate( 
    recycle = 
      case_when( 
        name %in% c( "gini_diff", "gini_diff_dr" ) ~ "Tax only",
        name %in% c( "gini_diff_ult", "gini_diff_ult_dr" ) ~ "Tax + Uniform lump transfer",
        name %in% c( "gini_diff_vat", "gini_diff_vat_dr" ) ~ "Tax + VAT reform",
        #name %in% c( "gini_diff_tlq", "gini_diff_tlq_dr" ) ~ "Tax + Transfer to bottom quintile"
      ),
    dr = grepl( pattern = "_dr", x = name )
  )

# Factor order
lvls <- c( "Tax only", "Tax + Uniform lump transfer", "Tax + VAT reform")#, "Tax + Transfer to bottom quintile" )
df <- df %>% mutate( recycle = factor( recycle, lvls ) )



# Plot (/wo demand response)
df1 <- df %>% filter( dr == FALSE & recycle == "Tax only" ) 
df2 <- df %>% filter( dr == FALSE & recycle != "Tax only" ) %>% mutate( recycle = droplevels( recycle ) )

ggplot() + 
  geom_bar( data = df1,
            aes( x = country, y = value,
                 fill = recycle), #fill="#56B4E9" ,
            # Specify fill inside aes to get this in the legend
            position = "dodge", stat = "identity" ) +
  geom_point( data = df2,
              aes( x = country, y = value, shape = recycle ),
              # fill = "white",
              # color = "black",
              size = 3.5,
              stroke = 1 ) +   # Thin/thick marker border 
  facet_wrap( vars( scenario_lab ), nrow = 2 ) +
  # facet_wrap( vars( scenario_lab ), nrow = 4 ) +
  ylab( "Change in Gini coefficient" ) +
  scale_fill_manual( values = "grey75" ) +
  scale_shape_manual( values = c( 16, 0 ) ) +
  #scale_y_continuous(labels = scales::number_format(accuracy = 0.001))+#labels=label_comma())+
  scale_y_continuous(breaks=c(-0.002,-0.001,0,0.001))+#labels=label_comma())+
  # Point shapes:https://ggplot2.tidyverse.org/articles/ggplot2-specs.html
  guides(fill = guide_legend( order = 1 ), 
         shape = guide_legend( order = 2 ) ) +  # Move Tax only bar to the left-hand side of the legend 
  theme_bw() +
  theme(
    panel.grid.minor.y = element_blank(),
    axis.text.x = element_text( angle = 90, vjust = 0.5, hjust = 1 ),
    axis.title.x = element_blank(),
    text = element_text( size = 20, family="serif"), # family sets font for plot
    strip.text = element_text( face = "bold" ),
    #    strip.background = element_rect(fill = "white", color = "white" ),
    legend.position = "bottom",
    legend.title = element_blank() )

ggsave("Meat_tax_main_chart_2010_noDR_230720.png", width = 1220, height = 783, units="px",dpi=96)
ggsave("Meat_tax_main_chart_2010_noDR_230713.pdf")
dev.off()
###################################################################################################
# Plot (/w demand response)
df1_DR <- df %>% filter( dr == TRUE & recycle == "Tax only" ) 
df2_DR <- df %>% filter( dr == TRUE & recycle != "Tax only" ) %>% mutate( recycle = droplevels( recycle ) )

ggplot() + 
  geom_bar( data = df1_DR,
            aes( x = country, y = value,
                 fill = recycle), #fill="#56B4E9" ,
            # Specify fill inside aes to get this in the legend
            position = "dodge", stat = "identity" ) +
  geom_point( data = df2_DR,
              aes( x = country, y = value, shape = recycle ),
              # fill = "white",
              # color = "black",
              size = 3.5,
              stroke = 1 ) +   # Thin/thick marker border 
  facet_wrap( vars( scenario_lab ), nrow = 2 ) +
  # facet_wrap( vars( scenario_lab ), nrow = 4 ) +
  ylab( "Change in Gini coefficient" ) +
  scale_fill_manual( values = "grey75" ) +
  scale_shape_manual( values = c( 16, 0 ) ) +
  #scale_y_continuous(labels = scales::number_format(accuracy = 0.001))+#labels=label_comma())+
  scale_y_continuous(breaks=c(-0.002,-0.001,0,0.001),label=comma)+
  # Point shapes:https://ggplot2.tidyverse.org/articles/ggplot2-specs.html
  guides(fill = guide_legend( order = 1 ), 
         shape = guide_legend( order = 2 ) ) +  # Move Tax only bar to the left-hand side of the legend 
  theme_bw() +
  theme(
    panel.grid.minor.y = element_blank(),
    axis.text.x = element_text( angle = 90, vjust = 0.5, hjust = 1 ),
    axis.title.x = element_blank(),
    text = element_text( size = 20, family="serif"), # family sets font for plot
    strip.text = element_text( face = "bold" ),
    #    strip.background = element_rect(fill = "white", color = "white" ),
    legend.position = "bottom",
    legend.title = element_blank() )

ggsave("Meat_tax_main_chart_2010_DR_230720.png", width = 1220, height = 783, units="px",dpi=96)
ggsave("Meat_tax_main_chart_2010_DR.pdf")
dev.off()
###################################################################################################
# Plot (/wo demand response) + scenario w. social cost
# Reshape to long to plot the net effect of recycling without DR
df_sc5 <- df_sc5 %>%
  pivot_longer( cols = starts_with( "gini" ) ) %>%
  mutate( 
    recycle = 
      case_when( 
        name %in% c( "gini_diff", "gini_diff_dr" ) ~ "Tax only",
        name %in% c( "gini_diff_ult", "gini_diff_ult_dr" ) ~ "Tax + Uniform lump transfer",
        name %in% c( "gini_diff_vat", "gini_diff_vat_dr" ) ~ "Tax + VAT reform",
        #name %in% c( "gini_diff_tlq", "gini_diff_tlq_dr" ) ~ "Tax + Transfer to bottom quintile"
      ),
    dr = grepl( pattern = "_dr", x = name )
  )

# Factor order
lvls <- c( "Tax only", "Tax + Uniform lump transfer", "Tax + VAT reform")#, "Tax + Transfer to bottom quintile" )
df_sc5 <- df_sc5 %>% mutate( recycle = factor( recycle, lvls ) )

# Plot (/wo demand response)
df5_1 <- df_sc5 %>% filter( dr == FALSE & recycle == "Tax only" ) 
df5_2 <- df_sc5 %>% filter( dr == FALSE & recycle != "Tax only" ) %>% mutate( recycle = droplevels( recycle ) )

ggplot() + 
  geom_bar( data = df5_1,
            aes( x = country, y = value,
                 fill = recycle), #fill="#56B4E9" ,
            # Specify fill inside aes to get this in the legend
            position = "dodge", stat = "identity" ) +
  geom_point( data = df5_2,
              aes( x = country, y = value, shape = recycle ),
              # fill = "white",
              # color = "black",
              size = 3.5,
              stroke = 1 ) +   # Thin/thick marker border 
  facet_wrap( vars( scenario_lab ), nrow = 2 ) +
  # facet_wrap( vars( scenario_lab ), nrow = 4 ) +
  ylab( "Change in Gini coefficient" ) +
  scale_fill_manual( values = "grey75" ) +
  scale_shape_manual( values = c( 16, 0 ) ) +
  #scale_y_continuous(labels = scales::number_format(accuracy = 0.001))+#labels=label_comma())+
  scale_y_continuous(breaks=c(-0.005,0,0.01))+#labels=label_comma())+
  # Point shapes:https://ggplot2.tidyverse.org/articles/ggplot2-specs.html
  guides(fill = guide_legend( order = 1 ), 
         shape = guide_legend( order = 2 ) ) +  # Move Tax only bar to the left-hand side of the legend 
  theme_bw() +
  theme(
    panel.grid.minor.y = element_blank(),
    axis.text.x = element_text( angle = 90, vjust = 0.5, hjust = 1 ),
    axis.title.x = element_blank(),
    text = element_text( size = 20,family="serif"), 
    strip.text = element_text( face = "bold" ),
    #    strip.background = element_rect(fill = "white", color = "white" ),
    legend.position = "bottom",
    legend.title = element_blank() )

ggsave("Meat_tax_main_chart_2010_noDR_sc5_230713.png", width = 1220, height = 783, units="px",dpi=96)
ggsave("Meat_tax_main_chart_2010_noDR.pdf")
dev.off()

