rm( list = ls() )

library( "dplyr" )

### Input data ###

# Country-level test results from stata -- Gini coefficient
dt_gini <- readRDS( "output_data/digini_by_country_high_dr.rds" )

# Country-level test results from stata -- Gini coefficient
dt_brdn <- read.csv( "output_data/burden_by_country_high_dr.csv", stringsAsFactors = FALSE )


# Population from the results file
pop <- read.csv( paste0( "input_data/results_high_dr/results_2010_sc1_230717_highelast.csv" ) )
names( pop ) <- tolower( names( pop ) )
pop <- pop %>% select( country, pop ) %>% unique %>% mutate( year = 2010 )

# Merge into results files
pop <- pop %>% rename( country1 = country )
dt_gini <- dt_gini %>% filter( var == "Diff" )   # Will drop all missing data as well
dt_gini <- left_join( x = dt_gini, y = pop, by = c( "year", "country1" ) )
dt_brdn <- left_join( x = dt_brdn, y = pop, by = c( "year", "country1" ) )



### EU weighted averages ###

# Gini
dt_gini <- dt_gini %>% 
  group_by( year, scenario, scenario1, recycle, recycle1, rscheme, rscheme1, dr ) %>% 
  mutate( wpop = sum( pop ),
          wpop = pop / wpop ) %>%
  summarize( est = sum( wpop * est ),
             stderr = sqrt( sum( ( wpop ^ 2 ) * ( stderr ^ 2 ) ) ) ) %>% 
  ungroup %>% 
  mutate( tstat = est / stderr,
          ci95lo = est + qnorm( .025 ) * stderr,
          ci95up = est + qnorm( .975 ) * stderr ) %>% 
  rename( se = stderr ) %>%
  arrange( year, scenario, recycle, rscheme, dr )
write.csv( dt_gini, "output_data/digini_EU_high_dr.csv", row.names = F )


# Burden by quintile (reverse sign)
dt_brdn <- dt_brdn %>% 
  filter( ! is.na( base_mean ) ) %>%
  group_by( year, scenario, scenario1, recycle, recycle1, rscheme, rscheme1, dr, quintile ) %>% 
  mutate( wpop = sum( pop ),
          wpop = pop / wpop ) %>%
  summarize( base_mean = sum( wpop * base_mean ),
             base_se = sqrt( sum( ( wpop ^ 2 ) * ( base_se ^2 ) ) ),
             value_mean = sum( wpop * value_mean ),
             value_se = sqrt( sum( ( wpop ^ 2 ) * ( value_se ^2 ) ) ),
             diff_mean = sum( wpop * diff_mean ),
             diff_se = sqrt( sum( ( wpop ^ 2 ) * ( diff_se ^2 ) ) )
  ) %>% 
  ungroup %>% 
  mutate( diff_tstat = diff_mean / diff_se,
          diff_lo95 = diff_mean + qnorm( .025 ) * diff_se,
          diff_hi95 = diff_mean + qnorm( .975 ) * diff_se ) %>%
  arrange( year, scenario, recycle, rscheme, dr, quintile )
write.csv( dt_brdn, "output_data/burden_EU_high_dr.csv", row.names = F )


