rm( list = ls() )

### Extract digini test output ###

library( "dplyr" )

# Working folder
setwd( "//main.oecd.org/Homedir1/Cai_M/Projects_R/meat" ) 

# Scenario and country labels
dt0 <- read.csv( "output_data/burden_by_country.csv" )
dt0 <- as_tibble( dt0 )
dt0 <- dt0 %>%
  select( starts_with( "country" ), starts_with( "scenario" ),  starts_with( "recycle" ), 
          starts_with( "rscheme" ), "dr" ) %>%
  unique

# Read stata log line by line
lns <- readLines( "intm_data/test_log.txt" )

# Identify where each set of results begin
index <- grep( pattern = "**********", x = lns, fixed = TRUE )
index <- index[ - 1 ]
year <- as.numeric( lns[ index + 1 ] )
country <- as.numeric( lns[ index + 2 ] )
scenario <- as.numeric( lns[ index + 3 ] )
recycle <- as.numeric( lns[ index + 4 ] )

# Recover the results
dt <- lns[ rep( index, each = 3 ) + c( 16, 17, 19 ) ]
dt[ dt == "type mismatch" ] <- NA       # 0 observations
dt[ dt == "no variables defined" ] <- NA
dt[ dt == "last estimates not found" ] <- NA
dt[ dt == "------------------------------------------------------------------------------" ] <- NA
dt[ grep( "value", dt ) ] <- NA
dt <- strsplit( x = dt, split = " " )
dt <- lapply( dt, function( x ) x[ x != "" ] )
index <- which( sapply( dt, length ) == 1 )
for ( i in index ){ dt[[ i ]] <- rep( dt[[ i ]], 7 ) }
dt <- do.call( "rbind", dt )
colnames( dt ) <- c( "var", "est", "stderr", "tstat", "pval", "ci95lo", "ci95up" )
dt <- as_tibble( dt )

# string to numeric 
dt[ dt == "." ] <- as.character( NA )
dt <- dt %>% mutate( across( est:ci95up, ~ as.numeric( .x ) ) )

# Clean up and save
dt <- dt %>%
  mutate( 
    year = rep( year, each = 3 ), 
    country = rep( country, each = 3 ), 
    scenario = rep( scenario, each = 3 ), 
    recycle = rep( recycle, each = 3 ), 
    var = case_when(
      var == "GINI_Dis1|" ~ "Base",
      var == "GINI_Dis2|" ~ "Value",
      var == "diff.|" ~ "Diff" )
  )

# Country labels
dt <- left_join( dt, dt0, by = c( "country", "scenario", "recycle" ) ) %>%
  relocate( year,
            starts_with( "country" ),
            starts_with( "scenario" ),
            starts_with( "recycle" ),
            starts_with( "rscheme"),
            dr )
# Save
saveRDS( dt, "output_data/digini_by_country.rds" )
data.table::fwrite( dt, "output_data/digini_by_country.csv", na = "" )




