cap log close
clear all

* Stack all results into a single file and compute the quintiles

* Working folder (set to 03-Code-ConfInt and copy the results_sc*.csv files there)
cd "\.."

* Process the two sets of results

foreach t of numlist 2010 2015 {
	
	* No missing households in the first scenario
	import delimited "input_data\results_`t'_sc1.csv", clear stringcols( 2 )
	g exp_eq = eur_he00_bt / hb062 
	egen quintile = xtile( exp_eq ), n( 5 ) by( country ) weights( ha10 )
	keep country ha04 quintile
	tostring ha04, replace
	sort country ha04
	save "intm_data\temp.dta", replace
		
	* Merge into each scenario 
	foreach s of numlist 1/5 {
		import delimited "input_data\results_`t'_sc`s'.csv", clear stringcols( 2 5 ) //avoid type mismatch//
		keep country ha04 ha10 ha09 hb05 hb061 hb062 eur*
		sort country ha04
		merge country ha04 using "intm_data\temp.dta"
		
		* Fix any NAs generated in R
		ds, has( type string )
		foreach var of varlist `r(varlist)' {
			replace `var' = "" if `var' == "NA"
		}
		destring eur*, replace float

		g year = `t'
		g scenario = `s'
		save "intm_data\temp`s'.dta", replace
	}
	
	* Stack scenarios
	use "intm_data\temp1.dta", clear
	foreach s of numlist 2/5 {
		append using "intm_data\temp`s'.dta"
	}
	order year scenario country ha04 ha10 ha09 hb05 hb061 hb062 quintile
	save "intm_data\temp`t'.dta", replace

}

* Stack 2010 and 2015
use "intm_data\temp2010.dta", clear
append using "intm_data\temp2015.dta"
compress
sort year scenario country ha04
save "intm_data\full_hh_results.dta", replace

* Clean up
local datafiles: dir "intm_data" files "temp*.dta"
cd "intm_data"
foreach datafile of local datafiles {
	rm `datafile'
}



