#####################################  
# Setting parameters

  ###################################
  # Policy parameters
    
        tr       <- 5         # excess tax on meat in % used for scenario 1 
        tax_co2  <- 0.05      # GHG tax on meat in EUR per kg CO2e i.e. 0.05 equals 50 EUR/tCO2e
    
  ###################################
  # model calibration
    
    # elasticities # predicted elasticities from Gallet (2010) Table 4
        eta_meat     <- -0.850     # demand elasticity of meat (aggregate category) used for demand response in scenarios 1, and 2. 
        elast_beef   <- -0.985     # elasticities of individual meat types used in scenarios 3 and 4. 
        elast_pork   <- -0.913
        elast_shpg   <- -1.062     # actually lamb
        elast_pltr   <- -0.778
        elasticities <- c(elast_beef,elast_pork,elast_shpg,elast_pltr,eta_meat,eta_meat,eta_meat)
        
        # values for sensitivity analysis from upper limit of prediction interval
        
        #elast_beef   <- -1.336      # elasticities of individual meat types used in scenarios 3, 3a, 4 and 4a. 
        #elast_pork   <- -1.124
        #elast_shpg   <- -1.585
        #elast_pltr   <- -1.452
        #eta_meat     <- mean(c(elast_beef,elast_pork,elast_shpg,elast_pltr)) # demand elasticity of meat (aggregate category) used for demand response in scenarios 1, 1a, 2 and 2a. 
        #elasticities <- c(elast_beef,elast_pork,elast_shpg,elast_pltr,eta_meat,eta_meat,eta_meat)
        
        eta_FnG=-0.64 #elasticity fruits and vegetables Andreyeva 2010
        #c("EUR_HE0112",    "EUR_HE01121",    "EUR_HE01122",    "EUR_HE01123",    "EUR_HE01124",    "EUR_HE01125",    "EUR_HE01126",    "EUR_HE01127")
        
  
    # GHG intensities
        # apart from beef, poultry, sheep and goat and pork, we do not have GHG intensities for the categories, dried, salted and smoked, other preserved and processed, other meat
        # for each country, I therefore estimate the GHG intensity of these categories as a weighted average of the GHG intensities of the other meat types consumed in this country.
        # in the following I use the GHG intensities from Weiss and Leip 2012 # we use their scenario 2, the intermediate scenario in terms of GHG emissions from land use.

        co2_int_beef = 22.5 # kgs CO2e per kg
        co2_int_shpg = 20
        co2_int_pork = 7.5
        co2_int_pltr = 5
        
        # calculating the multipliers for "dried smoked or salted", "other preserved" and "other fresh"
        # strategy: calculate the share of meat consumption in quantity across the EU. Then take the average multiplier with each meat type weighted by its share.
        
        q_beef <- mean(HBS_all_q$EUR_HE01121) 
        q_pork <- mean(HBS_all_q$EUR_HE01122)
        q_shpg <- mean(HBS_all_q$EUR_HE01123)
        q_pltr <- mean(HBS_all_q$EUR_HE01124)
        
        q_total<- q_beef+q_pork+q_shpg+q_pltr
        
        co2_avg<- q_beef/q_total*co2_int_beef + q_pork/q_total*co2_int_pork + q_shpg/q_total*co2_int_shpg + q_pltr/q_total*co2_int_pltr
        
        co2_intensities =c(co2_int_beef,co2_int_pork,co2_int_shpg,co2_int_pltr,co2_avg,co2_avg,co2_avg)
        
    # Social cost per kg for different sorts of meat
        social_cost_beef = 7.5 # 2017 EUR per kg meat; for beef this is an average of 9.2 EUR/kg for meat herds and 5.8 EUR/kg for dairy herds
        social_cost_shpg = 3.7 # lamb/mutton 
        social_cost_pork = 1.9
        social_cost_pltr = 1.5
        
        social_cost_avg <- q_beef/q_total*social_cost_beef + q_pork/q_total*social_cost_pork + q_shpg/q_total*social_cost_shpg + q_pltr/q_total*social_cost_pltr
        
        social_cost =c(social_cost_beef,social_cost_pork,social_cost_shpg,social_cost_pltr,social_cost_avg,social_cost_avg,social_cost_avg)
        
        tax_social_cost=1 #factor 1 since social costs above are not per-kg intensities but per-kg tax rates already
        
    # variable names
        column_names_net=c("EUR_HE0112_net","EUR_HE01121_net","EUR_HE01122_net","EUR_HE01123_net","EUR_HE01124_net","EUR_HE01125_net","EUR_HE01126_net","EUR_HE01127_net")
        column_names_abs=c("EUR_HE0112",    "EUR_HE01121",    "EUR_HE01122",    "EUR_HE01123",    "EUR_HE01124",    "EUR_HE01125",    "EUR_HE01126",    "EUR_HE01127")
        meat_quantities_names=c("HQ01121","HQ01122","HQ01123","HQ01124","HQ01125","HQ01126","HQ01127")
        column_names_net_q=c("EUR_HE01121_net","EUR_HE01122_net","EUR_HE01123_net","EUR_HE01124_net","EUR_HE01125_net","EUR_HE01126_net","EUR_HE01127_net") #without the aggregate category for scenarios that rely on quantity data
        column_names_abs_q=c("EUR_HE01121",    "EUR_HE01122",    "EUR_HE01123",    "EUR_HE01124",    "EUR_HE01125",    "EUR_HE01126",    "EUR_HE01127")
        
        #variables to include in results dataframe
        relevant_vars_sc = c("COUNTRY","HA04","HA09","HA10","HB05","HB061","HB062","EUR_HE00","exp_mns_tax","exp_mns_tax_DR","exp_mns_tax_TLQ","exp_mns_tax_TLQ_DR","exp_mns_tax_ULT","exp_mns_tax_ULT_DR","exp_mns_tax_VAT","exp_mns_tax_VAT_DR","Gini_diff","Gini_diff_DR","Gini_diff_TLQ","Gini_diff_TLQ_DR","Gini_diff_ULT","Gini_diff_ULT_DR","Gini_diff_VAT","Gini_diff_VAT_DR","pop","qn")
        
#####################################  
# Scenario 1: a 5% excess tax on meat

  HBS_all_VAT_5perc = HBS_all
  for(j in 1:length(column_names_abs)){
    eval(parse(text=paste0("HBS_all_VAT_5perc$",column_names_net[j],"_AT   =HBS_all_VAT_5perc$",column_names_net[j],"*(1+(HBS_all_VAT_5perc$VAT_meat_2010+tr)/100)")))
    eval(parse(text=paste0("HBS_all_VAT_5perc$",column_names_net[j],"_AT_DR=HBS_all_VAT_5perc$",column_names_abs[j],"*(1+(tr/100)/(1+HBS_all_VAT_5perc$VAT_meat_2010/100)*eta_meat)*(1+(tr/100)/(1+HBS_all_VAT_5perc$VAT_meat_2010/100))"  )))
  }
  
  names_countries = unique(HBS_all_VAT_5perc$COUNTRY)
  
  HBS_all_VAT_5perc$exp_mns_tax    <- HBS_all_VAT_5perc$EUR_HE00 - (HBS_all_VAT_5perc$EUR_HE0112_net_AT    - HBS_all_VAT_5perc$EUR_HE0112)
  
  HBS_all_VAT_5perc$exp_mns_tax_DR <- HBS_all_VAT_5perc$EUR_HE00 - (tr/100*HBS_all_VAT_5perc$EUR_HE0112_net_AT_DR/(1+HBS_all_VAT_5perc$VAT_meat_2010/100+tr/100)) 
    

  #####################################  
  # Scenario 1a: 5% tax + uniform lump-sum transfers and VAT cuts

  # Create new columns in data frame
  HBS_all_VAT_5perc<-create_new_empty_cols(HBS_all_VAT_5perc)
  
  HBS_all_VAT_5perc<-distr_analysis(HBS_all_VAT_5perc)
  
  HBS_all_VAT_5perc<-tax_burden(HBS_all_VAT_5perc)

  results_sc1      <- HBS_all_VAT_5perc[,which(names(HBS_all_VAT_5perc) %in% relevant_vars_sc)]
  
  # check results
  results_sc1<-check_and_prepare_for_STATA(results_sc1) 
  
  write.csv(results_sc1,"05-outputData/results_2010_sc1.csv",row.names = FALSE) 
  
#####################################    
# Scenario 2: changing from reduced VAT to standard VAT (in countries which have a reduced VAT rate for meat)
  
  HBS_all_VAT_stdrate = HBS_all
  
  for(j in 1:length(column_names_abs)){
    eval(parse(text=paste0("HBS_all_VAT_stdrate$",column_names_net[j],"_AT   =HBS_all_VAT_stdrate$",column_names_net[j],"*(1+(HBS_all_VAT_stdrate$VAT_std_2010)/100)")))
    eval(parse(text=paste0("HBS_all_VAT_stdrate$",column_names_net[j],"_AT_DR=HBS_all_VAT_stdrate$",column_names_abs[j],"*(1+((HBS_all_VAT_stdrate$VAT_std_2010-HBS_all_VAT_stdrate$VAT_meat_2010)/100)/(1+HBS_all_VAT_stdrate$VAT_meat_2010/100)*eta_meat)*(1+((HBS_all_VAT_stdrate$VAT_std_2010-HBS_all_VAT_stdrate$VAT_meat_2010)/100)/(1+HBS_all_VAT_stdrate$VAT_meat_2010/100))"))) # demand response added 2.12.2021 DK
  }
  
  names_countries = unique(HBS_all_VAT_stdrate$COUNTRY)
  
  HBS_all_VAT_stdrate$exp_mns_tax    <- HBS_all_VAT_stdrate$EUR_HE00 - (HBS_all_VAT_stdrate$EUR_HE0112_net_AT    - HBS_all_VAT_stdrate$EUR_HE0112)
  
  HBS_all_VAT_stdrate$exp_mns_tax_DR <- HBS_all_VAT_stdrate$EUR_HE00 - ((HBS_all_VAT_stdrate$VAT_std_2010-HBS_all_VAT_stdrate$VAT_meat_2010)/100*HBS_all_VAT_stdrate$EUR_HE0112_net_AT_DR/(1+HBS_all_VAT_stdrate$VAT_meat_2010/100+(HBS_all_VAT_stdrate$VAT_std_2010-HBS_all_VAT_stdrate$VAT_meat_2010)/100)) 

  #####################################  
  # Scenario 2a: changing from reduced VAT to standard VAT (in countries which have a reduced VAT rate for meat) + uniform lump-sum transfers
 
  HBS_all_VAT_stdrate<-create_new_empty_cols(HBS_all_VAT_stdrate)

  HBS_all_VAT_stdrate<-distr_analysis(HBS_all_VAT_stdrate)
  
  HBS_all_VAT_stdrate<-tax_burden(HBS_all_VAT_stdrate)
  
  results_sc2      <- HBS_all_VAT_stdrate[,which(names(HBS_all_VAT_stdrate) %in% relevant_vars_sc)]
  
  # check results
  results_sc2<-check_and_prepare_for_STATA(results_sc2) 
  
  write.csv(results_sc2,"05-outputData/results_2010_sc2.csv",row.names = FALSE) 
  
#####################################  
# Scenario 3: GHG-equivalent tax on meat

  HBS_all_co2tax_50 = HBS_all_q # only countries with data on quantities used for this scenario
  
  # step 1: create empty columns for after tax spending
      for(j in 1:length(column_names_abs_q)){# without DR: first, 
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_AT=NA")))#
      }
      for(j in 1:length(column_names_abs_q)){# DR:first, create empty columns for co2 tax values in relative terms
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel=NA")))#DK 17.2.2022
      }
  #step 2: calculate co2 tax values in relative terms, check for NAs
      for(j in 1:length(column_names_net_q)){# DR:second
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel=(HBS_all_co2tax_50$",meat_quantities_names[j],"*tax_co2*",co2_intensities[j],"/HBS_all_co2tax_50$",column_names_net_q[j],") "))) #get absolute meat tax level
      }
      for(j in 1:length(column_names_net_q)){
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel[which(is.na(HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel))]<-0")))
      }
  #step 3: use the relative co2 tax values to determine the total after tax spending 
      for(j in 1:length(column_names_net_q)){# DR
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_AT_DR=HBS_all_co2tax_50$",column_names_abs_q[j],"*(1+(HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_co2tax_50$VAT_meat_2010/100)*elasticities[j])*(1+(HBS_all_co2tax_50$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_co2tax_50$VAT_meat_2010/100))"  )))# demand response added 17.2.2022 DK: this is similar to the X% tax in scenario 1, but using the relative carbon tax instead of the fixed increase
      }
      for(j in 1:length(column_names_net_q)){# without DR
        eval(parse(text=paste0("HBS_all_co2tax_50$",column_names_net_q[j],"_AT=HBS_all_co2tax_50$",column_names_net_q[j],"*(1+(HBS_all_co2tax_50$VAT_meat_2010)/100)+(HBS_all_co2tax_50$",meat_quantities_names[j],"*tax_co2*",co2_intensities[j],") "))) 
      }
  #filter out inf values for _tax_rel variables
  HBS_all_co2tax_50 <- HBS_all_co2tax_50[-which(is.infinite(HBS_all_co2tax_50$EUR_HE01127_net_tax_rel) | is.infinite(HBS_all_co2tax_50$EUR_HE01126_net_tax_rel) | is.infinite(HBS_all_co2tax_50$EUR_HE01125_net_tax_rel)
      | is.infinite(HBS_all_co2tax_50$EUR_HE01124_net_tax_rel) | is.infinite(HBS_all_co2tax_50$EUR_HE01123_net_tax_rel) | is.infinite(HBS_all_co2tax_50$EUR_HE01122_net_tax_rel)
      | is.infinite(HBS_all_co2tax_50$EUR_HE01121_net_tax_rel)),]

  HBS_all_co2tax_50$exp_mns_tax    <- HBS_all_co2tax_50$EUR_HE00 - ( ( HBS_all_co2tax_50$EUR_HE01121_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01122_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01123_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01124_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01125_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01126_net_AT
                                                              +HBS_all_co2tax_50$EUR_HE01127_net_AT) - HBS_all_co2tax_50$EUR_HE0112)
  
  HBS_all_co2tax_50$exp_mns_tax_DR <- HBS_all_co2tax_50$EUR_HE00 - (HBS_all_co2tax_50$EUR_HE01121_net_tax_rel*HBS_all_co2tax_50$EUR_HE01121_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01121_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01122_net_tax_rel*HBS_all_co2tax_50$EUR_HE01122_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01122_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01123_net_tax_rel*HBS_all_co2tax_50$EUR_HE01123_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01123_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01124_net_tax_rel*HBS_all_co2tax_50$EUR_HE01124_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01124_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01125_net_tax_rel*HBS_all_co2tax_50$EUR_HE01125_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01125_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01126_net_tax_rel*HBS_all_co2tax_50$EUR_HE01126_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01126_net_tax_rel)
                                                                    +HBS_all_co2tax_50$EUR_HE01127_net_tax_rel*HBS_all_co2tax_50$EUR_HE01127_net_AT_DR/(1+HBS_all_co2tax_50$VAT_meat_2010/100+HBS_all_co2tax_50$EUR_HE01127_net_tax_rel)) 
  
  HBS_all_co2tax_50<-create_new_empty_cols(HBS_all_co2tax_50)
  
  # Sum up after tax expenditure for aggregate category HE0112 (as EUR_HE0112_net_AT is still NA)
  HBS_all_co2tax_50$EUR_HE0112_net_AT =
    HBS_all_co2tax_50$EUR_HE01121_net_AT +
    HBS_all_co2tax_50$EUR_HE01122_net_AT +
    HBS_all_co2tax_50$EUR_HE01123_net_AT +
    HBS_all_co2tax_50$EUR_HE01124_net_AT +
    HBS_all_co2tax_50$EUR_HE01125_net_AT +
    HBS_all_co2tax_50$EUR_HE01126_net_AT +
    HBS_all_co2tax_50$EUR_HE01127_net_AT
  
  HBS_all_co2tax_50$EUR_HE0112_net_AT_DR =
    HBS_all_co2tax_50$EUR_HE01121_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01122_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01123_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01124_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01125_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01126_net_AT_DR +
    HBS_all_co2tax_50$EUR_HE01127_net_AT_DR
  
  HBS_all_co2tax_50<-distr_analysis(HBS_all_co2tax_50)
  
  HBS_all_co2tax_50<-tax_burden(HBS_all_co2tax_50)
  
  results_sc3 <- HBS_all_co2tax_50[,which(names(HBS_all_co2tax_50) %in% relevant_vars_sc)]
  
  # check results
  results_sc3<-check_and_prepare_for_STATA(results_sc3) 

  write.csv(results_sc3,"05-outputData/results_2010_sc3.csv",row.names = FALSE) 
  
#####################################################################################
  
#Scenario 4 (formerly: 5): Unit tax on meat
  
  # Note that this scenario is not as "cleanly" programmed as the others and some variables are only defined here in this section DK 27.6.2023
  
  HBS_all_unit_tax = HBS_all_q
  
  ### setting the level of the unit tax equivalent in terms of total revenue the 5% VAT increase DK 15.7.22 
  countries_quantity = as.character(unique(HBS_all_q$COUNTRY))
  total_revenue      = sum(unique(HBS_all_VAT_5perc$total_tax_rev[which(HBS_all_VAT_5perc$COUNTRY %in% countries_quantity)]))
  unit_tax           = 0.3506
  hlpr=total_revenue/sum(HBS_all_unit_tax$HQ0112*HBS_all_unit_tax$HA10) #EUR per kg of meat
  
  # Set to unit tax rates equivalent to other scenarios (for equivalent total revenue): 0.3506 EUR/kg for 5%, ...

  for(j in 1:length(column_names_abs_q)){# without DR: first, create empty columns for after tax spending
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_AT=NA")))
  }
  for(j in 1:length(column_names_abs_q)){# DR:first, create empty columns for unit tax values in relative terms
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel=NA")))
  }
  for(j in 1:length(column_names_net_q)){# DR:second, calculate unit tax values in relative terms
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel=(HBS_all_unit_tax$",meat_quantities_names[j],"*unit_tax/HBS_all_unit_tax$",column_names_net_q[j],") "))) #get absolute meat tax level
  }
  # check for NaNs and set to 0:
  for(j in 1:length(column_names_net_q)){
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel[which(is.na(HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel))]<-0")))
  }
  for(j in 1:length(column_names_net_q)){# DR:third, use the relative net tax values to determine the total after tax spending including the demand response
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_AT_DR=HBS_all_q$",column_names_abs_q[j],"*(1+(HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_unit_tax$VAT_meat_2010/100)*eta_meat)*(1+(HBS_all_unit_tax$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_unit_tax$VAT_meat_2010/100))"  )))# demand response added 17.2.2022 DK: this is similar to the X% tax in scenario 1, but using the relative carbon tax instead of the fixed increase
  }
  for(j in 1:length(column_names_net_q)){# without DR: second step
    eval(parse(text=paste0("HBS_all_unit_tax$",column_names_net_q[j],"_AT=HBS_all_unit_tax$",column_names_net_q[j],"*(1+(HBS_all_unit_tax$VAT_meat_2010)/100)+(HBS_all_unit_tax$",meat_quantities_names[j],"*unit_tax)"))) 
  }
  
  HBS_all_unit_tax$exp_mns_tax    <- HBS_all_unit_tax$EUR_HE00 - ( ( HBS_all_unit_tax$EUR_HE01121_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01122_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01123_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01124_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01125_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01126_net_AT
                                                                     +HBS_all_unit_tax$EUR_HE01127_net_AT) - HBS_all_unit_tax$EUR_HE0112)
  
  HBS_all_unit_tax$exp_mns_tax_DR <- HBS_all_unit_tax$EUR_HE00 - (HBS_all_unit_tax$EUR_HE01121_net_tax_rel*HBS_all_unit_tax$EUR_HE01121_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01121_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01122_net_tax_rel*HBS_all_unit_tax$EUR_HE01122_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01122_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01123_net_tax_rel*HBS_all_unit_tax$EUR_HE01123_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01123_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01124_net_tax_rel*HBS_all_unit_tax$EUR_HE01124_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01124_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01125_net_tax_rel*HBS_all_unit_tax$EUR_HE01125_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01125_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01126_net_tax_rel*HBS_all_unit_tax$EUR_HE01126_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01126_net_tax_rel)
                                                                  +HBS_all_unit_tax$EUR_HE01127_net_tax_rel*HBS_all_unit_tax$EUR_HE01127_net_AT_DR/(1+HBS_all_unit_tax$VAT_meat_2010/100+HBS_all_unit_tax$EUR_HE01127_net_tax_rel)) 
  
  HBS_all_unit_tax<-create_new_empty_cols(HBS_all_unit_tax)
  
  # Sum up after tax expenditure for aggregate category HE0112 (as EUR_HE0112_net_AT is still NA)
  HBS_all_unit_tax$EUR_HE0112_net_AT =
    HBS_all_unit_tax$EUR_HE01121_net_AT +
    HBS_all_unit_tax$EUR_HE01122_net_AT +
    HBS_all_unit_tax$EUR_HE01123_net_AT +
    HBS_all_unit_tax$EUR_HE01124_net_AT +
    HBS_all_unit_tax$EUR_HE01125_net_AT +
    HBS_all_unit_tax$EUR_HE01126_net_AT +
    HBS_all_unit_tax$EUR_HE01127_net_AT
  
  HBS_all_unit_tax$EUR_HE0112_net_AT_DR =
    HBS_all_unit_tax$EUR_HE01121_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01122_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01123_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01124_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01125_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01126_net_AT_DR +
    HBS_all_unit_tax$EUR_HE01127_net_AT_DR
  
  HBS_all_unit_tax<-distr_analysis(HBS_all_unit_tax)
  
  HBS_all_unit_tax<-tax_burden(HBS_all_unit_tax)
  
  results_sc4 <- HBS_all_unit_tax[,which(names(HBS_all_unit_tax) %in% relevant_vars_sc)]
  
  # check results
  results_sc4<-check_and_prepare_for_STATA(results_sc4) 
  
  write.csv(results_sc4,"05-outputData/results_2010_sc4.csv",row.names = FALSE) 
  
#####################################################################################
  
#Scenario 5 (formerly: 4): Social-cost-equivalent tax on meat (from Funke et al., 2022) 
  
  HBS_all_social_cost = HBS_all_q

  for(j in 1:length(column_names_abs_q)){# without DR: first, create empty columns for after tax spending
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_AT=NA")))#
  }
  for(j in 1:length(column_names_abs_q)){# DR:first, create empty columns for social cost tax values in relative terms
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_tax_rel=NA")))#DK 17.2.2022
  }
  for(j in 1:length(column_names_net_q)){# DR:second, calculate social cost tax values in relative terms
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_tax_rel=(HBS_all_social_cost$",meat_quantities_names[j],"*tax_social_cost*",social_cost[j],"/HBS_all_social_cost$",column_names_net_q[j],") "))) #get absolute meat tax level
  }
  # check for NaNs and remove:
  for(j in 1:length(column_names_net_q)){
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_tax_rel[which(is.na(HBS_all_social_cost$",column_names_net_q[j],"_tax_rel))]<-0")))
  }
  for(j in 1:length(column_names_net_q)){# DR:third, use the relative social cost tax values to determine the total after tax spending including the demand response
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_AT_DR=HBS_all_social_cost$",column_names_abs_q[j],"*(1+(HBS_all_social_cost$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_social_cost$VAT_meat_2010/100)*eta_meat)*(1+(HBS_all_social_cost$",column_names_net_q[j],"_tax_rel)/(1+HBS_all_social_cost$VAT_meat_2010/100))"  )))# demand response added 17.2.2022 DK: this is similar to the X% tax in scenario 1, but using the relative carbon tax instead of the fixed increase
  }
  for(j in 1:length(column_names_net_q)){# without DR: second step
    eval(parse(text=paste0("HBS_all_social_cost$",column_names_net_q[j],"_AT=HBS_all_social_cost$",column_names_net_q[j],"*(1+(HBS_all_social_cost$VAT_meat_2010)/100)+(HBS_all_social_cost$",meat_quantities_names[j],"*tax_social_cost*",social_cost[j],") "))) 
  }
  
  HBS_all_social_cost$exp_mns_tax    <- HBS_all_social_cost$EUR_HE00 - ( ( HBS_all_social_cost$EUR_HE01121_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01122_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01123_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01124_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01125_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01126_net_AT
                                                                       +HBS_all_social_cost$EUR_HE01127_net_AT) - HBS_all_social_cost$EUR_HE0112)
  
  HBS_all_social_cost$exp_mns_tax_DR <- HBS_all_social_cost$EUR_HE00 - (HBS_all_social_cost$EUR_HE01121_net_tax_rel*HBS_all_social_cost$EUR_HE01121_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01121_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01122_net_tax_rel*HBS_all_social_cost$EUR_HE01122_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01122_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01123_net_tax_rel*HBS_all_social_cost$EUR_HE01123_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01123_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01124_net_tax_rel*HBS_all_social_cost$EUR_HE01124_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01124_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01125_net_tax_rel*HBS_all_social_cost$EUR_HE01125_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01125_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01126_net_tax_rel*HBS_all_social_cost$EUR_HE01126_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01126_net_tax_rel)
                                                                        +HBS_all_social_cost$EUR_HE01127_net_tax_rel*HBS_all_social_cost$EUR_HE01127_net_AT_DR/(1+HBS_all_social_cost$VAT_meat_2010/100+HBS_all_social_cost$EUR_HE01127_net_tax_rel))  
  HBS_all_social_cost<-create_new_empty_cols(HBS_all_social_cost)
  
  # Sum up after tax expenditure for aggregate category HE0112 (as EUR_HE0112_net_AT is still NA)
  HBS_all_social_cost$EUR_HE0112_net_AT =
    HBS_all_social_cost$EUR_HE01121_net_AT +
    HBS_all_social_cost$EUR_HE01122_net_AT +
    HBS_all_social_cost$EUR_HE01123_net_AT +
    HBS_all_social_cost$EUR_HE01124_net_AT +
    HBS_all_social_cost$EUR_HE01125_net_AT +
    HBS_all_social_cost$EUR_HE01126_net_AT +
    HBS_all_social_cost$EUR_HE01127_net_AT
  
  HBS_all_social_cost$EUR_HE0112_net_AT_DR =
    HBS_all_social_cost$EUR_HE01121_net_AT_DR +
    HBS_all_social_cost$EUR_HE01122_net_AT_DR +
    HBS_all_social_cost$EUR_HE01123_net_AT_DR +
    HBS_all_social_cost$EUR_HE01124_net_AT_DR +
    HBS_all_social_cost$EUR_HE01125_net_AT_DR +
    HBS_all_social_cost$EUR_HE01126_net_AT_DR +
    HBS_all_social_cost$EUR_HE01127_net_AT_DR
  
  HBS_all_social_cost<-distr_analysis(HBS_all_social_cost)
  
  HBS_all_social_cost<-tax_burden(HBS_all_social_cost)
  
  results_sc5 <- HBS_all_social_cost[,which(names(HBS_all_social_cost) %in% relevant_vars_sc)]
  
  # check results
  results_sc5<-check_and_prepare_for_STATA(results_sc5) 
  
  write.csv(results_sc5,"05-outputData/results_2010_sc5.csv",row.names = FALSE)
  
  # get total revenue from different scenarios:
    sum(unique(HBS_all_VAT_5perc$total_tax_rev),na.rm=T)*1e-9
    sum(unique(HBS_all_VAT_stdrate$total_tax_rev),na.rm=T)*1e-9
    sum(unique(HBS_all_co2tax_50$total_tax_rev),na.rm=T)*1e-9
    sum(unique(HBS_all_unit_tax$total_tax_rev),na.rm=T)*1e-9

