
# This file loads the Household Budget Survey data and assembles it into one data frame. Alternatively, just load HBS_all.csv
# David Klenert 29.8.2019

load_HBS_data <- function(HBS_data_path, countrycodes){ 
  
  for(i in 1: length(countrycodes)){
    print(countrycodes[i])
    eval(parse(text=paste0("HBS_",countrycodes[i],"<- readWorkbook(\"",HBS_data_path,countrycodes[i],"_HBS_hh.xlsx\")")))
    eval(parse(text=paste0("HBS_",countrycodes[i],"<-cbind(rep(\"",countrycodes[i],"\",times=length(HBS_",countrycodes[i],"[,1])),HBS_",countrycodes[i],")")))
    eval(parse(text=paste0("names(HBS_",countrycodes[i],")[1] <- \"COUNTRY\"")))
  }
  
  
  # fix some mislabeling: Only in 2010 wave. not necessary for 2015 (which anyway does not contain MT or PT)
  for(i in 1: length(countrycodes)){
    if(countrycodes[i] == "MT"){names(HBS_MT)[which(names(HBS_MT)=="new_HA04")]<-"HA04"}
    if(countrycodes[i] == "PT"){names(HBS_PT)[which(names(HBS_PT)=="EUR_HJ9")]<-"EUR_HJ90"}
  }

    
  # merge all countries into one dataframe
    for(i in 1:length(countrycodes)){
      if(i==1){all_cc<-paste0("HBS_",countrycodes[i])}else{all_cc<-cbind(all_cc,paste0("HBS_",countrycodes[i]))}
    }
    eval(parse(text=paste0("HBS_all<-rbind(",paste(all_cc,collapse=","),")")))
    eval(parse(text=paste0("rm(",paste(all_cc,collapse=","),")")))
  
  #write.csv(HBS_all,"inputData/HBS/HBS_2010_all.csv",row.names = FALSE)
  return(HBS_all)
}
