#############################################################################################

do_country_lvl_plots_OECD <- function(HBS_agg_country_lvl_OECD,country_plot_directory){
  # do country level plots
    cntr <- unique(HBS_agg_country_lvl_OECD$COUNTRY) 
    
    # calculate relative expenditure
    HBS_agg_country_lvl_OECD$share_meat   <- HBS_agg_country_lvl_OECD$EUR_HE0112 /HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of meat per quintile 
    HBS_agg_country_lvl_OECD$share_bovine <- HBS_agg_country_lvl_OECD$EUR_HE01121/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of bovine meat per quintile 
    HBS_agg_country_lvl_OECD$share_swine  <- HBS_agg_country_lvl_OECD$EUR_HE01122/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of swine per quintile 
    HBS_agg_country_lvl_OECD$share_sh_gt  <- HBS_agg_country_lvl_OECD$EUR_HE01123/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of sheep&goat per quintile 
    HBS_agg_country_lvl_OECD$share_poultry<- HBS_agg_country_lvl_OECD$EUR_HE01124/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of poultry per quintile
    HBS_agg_country_lvl_OECD$share_dried  <- HBS_agg_country_lvl_OECD$EUR_HE01125/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of dried/salted/smoked meat per quintile
    HBS_agg_country_lvl_OECD$share_presv  <- HBS_agg_country_lvl_OECD$EUR_HE01126/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of otherwise preserved meat per quintile
    HBS_agg_country_lvl_OECD$share_other  <- HBS_agg_country_lvl_OECD$EUR_HE01127/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of other meat per quintile
    #HBS_agg_country_lvl_OECD$share_fish   <- HBS_agg_country_lvl_OECD$EUR_HE0113/HBS_agg_country_lvl_OECD$EUR_HE00 # expenditure share of fish per quintile
    
    # absolute expenditure
    HBS_agg_country_lvl_OECD$abs_meat   <- HBS_agg_country_lvl_OECD$EUR_HE0112 
    HBS_agg_country_lvl_OECD$abs_bovine <- HBS_agg_country_lvl_OECD$EUR_HE01121
    HBS_agg_country_lvl_OECD$abs_swine  <- HBS_agg_country_lvl_OECD$EUR_HE01122 
    HBS_agg_country_lvl_OECD$abs_sh_gt  <- HBS_agg_country_lvl_OECD$EUR_HE01123
    HBS_agg_country_lvl_OECD$abs_poultry<- HBS_agg_country_lvl_OECD$EUR_HE01124
    HBS_agg_country_lvl_OECD$abs_dried  <- HBS_agg_country_lvl_OECD$EUR_HE01125
    HBS_agg_country_lvl_OECD$abs_presv  <- HBS_agg_country_lvl_OECD$EUR_HE01126
    HBS_agg_country_lvl_OECD$abs_other  <- HBS_agg_country_lvl_OECD$EUR_HE01127
    #HBS_agg_country_lvl_OECD$abs_fish   <- HBS_agg_country_lvl_OECD$EUR_HE0113
    
    
    for(k in c(1:length(cntr))){# do all plots
      data_plot <- HBS_agg_country_lvl_OECD[which(HBS_agg_country_lvl_OECD$COUNTRY==cntr[k]),]
      # convert wide to long format (for plotting)
      
      data_long     <- gather(data_plot,meat_type,shares, share_bovine:share_other, factor_key=TRUE)
      data_long_abs <- gather(data_plot,meat_type,abs_cons, abs_bovine:abs_other, factor_key=TRUE)
      
      # plot relative expenditure   
      data_long$qn <- as.numeric(as.character(data_long$qn))
      labels <- c("bovine (mainly beef)", "pork", "sheep & goat", "poultry", "dried, smoked or salted", "other preserved", "other fresh")
      labels_old <-c("share_bovine","share_swine", "share_sh_gt", "share_poultry", "share_dried", "share_presv", "share_other")
      newcol<-rep(NA,times=5)
      data_long <- cbind(data_long,newcol); rm(newcol)
      names(data_long)[dim(data_long)[2]]<-"labels"
      for(i in c(1:length(labels))){
        data_long$labels[which(data_long$meat_type==labels_old[i])] <- labels[i]
      }
      
      ggplot(data_long, aes(x = qn, y = shares, fill=labels)) +
        geom_area(size=0.2, alpha=0.8, color='yellow')+
        scale_fill_viridis(discrete = TRUE)+
        #+ geom_area() +
        labs(x = "expenditure quintiles", y = "meat expenditure share") +
        #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
        theme_bw(base_size=14)+
        theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+#legend.position=c(.073,.078),
        ggtitle(paste("Expenditure shares of different meat types in",cntr[k]))
      ggsave(paste0(country_plot_directory,"Engels meat curve_",cntr[k],".pdf"), width = 9, height = 6.6)
      ggsave(paste0(country_plot_directory,"Engels meat curve_",cntr[k],".png"), width = 9, height = 6.6)
      
      # plot absolute expenditure   
      data_long_abs$qn <- as.numeric(as.character(data_long_abs$qn))
      labels <- c("bovine (mainly beef)", "pork", "sheep & goat", "poultry", "dried, smoked or salted", "other preserved", "other fresh")
      labels_old <-c("abs_bovine","abs_swine", "abs_sh_gt", "abs_poultry", "abs_dried", "abs_presv", "abs_other")
      newcol<-rep(NA,times=5)
      data_long_abs <- cbind(data_long_abs,newcol); rm(newcol)
      names(data_long_abs)[dim(data_long_abs)[2]]<-"labels"
      for(i in c(1:length(labels))){
        data_long_abs$labels[which(data_long_abs$meat_type==labels_old[i])] <- labels[i]
      }
      
      ggplot(data_long_abs, aes(x = qn, y = abs_cons, fill=labels)) +
        geom_area(size=0.2, alpha=0.8, color='yellow')+
        scale_fill_viridis(discrete = TRUE)+
        #+ geom_area() +
        labs(x = "expenditure quintiles", y = "meat expenditure (in 2010 EUR)") +
        #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
        theme_bw(base_size=14)+#legend.position=c(.3,.84),
        theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+
        #guides(fill=guide_legend(ncol=2))+
        ggtitle(paste("Absolute expenditure on different meat types in",cntr[k]))
      ggsave(paste0(country_plot_directory,"Absolute meat expenditure_",cntr[k],".pdf"), width = 9, height = 6.6)
      ggsave(paste0(country_plot_directory,"Absolute meat expenditure_",cntr[k],".png"), width = 9, height = 6.6) 
      rm(data_plot)
    }
    print(paste("Plots can be found in",country_plot_directory))
}    
