do_EU_agg_plots <- function(HBS_agg_red,country_plot_directory){
  
    # this file plots weighted EU averages of absolute and relative meat expenditures
  
    # calculate relative expenditure
    HBS_agg_red$share_meat   <- HBS_agg_red$EUR_HE0112 /HBS_agg_red$EUR_HE00 # expenditure share of meat per quintile 
    HBS_agg_red$share_bovine <- HBS_agg_red$EUR_HE01121/HBS_agg_red$EUR_HE00 # expenditure share of bovine meat per quintile 
    HBS_agg_red$share_swine  <- HBS_agg_red$EUR_HE01122/HBS_agg_red$EUR_HE00 # expenditure share of swine per quintile 
    HBS_agg_red$share_sh_gt  <- HBS_agg_red$EUR_HE01123/HBS_agg_red$EUR_HE00 # expenditure share of sheep&goat per quintile 
    HBS_agg_red$share_poultry<- HBS_agg_red$EUR_HE01124/HBS_agg_red$EUR_HE00 # expenditure share of poultry per quintile
    HBS_agg_red$share_dried  <- HBS_agg_red$EUR_HE01125/HBS_agg_red$EUR_HE00 # expenditure share of dried/salted/smoked meat per quintile
    HBS_agg_red$share_presv  <- HBS_agg_red$EUR_HE01126/HBS_agg_red$EUR_HE00 # expenditure share of otherwise preserved meat per quintile
    HBS_agg_red$share_other  <- HBS_agg_red$EUR_HE01127/HBS_agg_red$EUR_HE00 # expenditure share of other meat per quintile
    #HBS_agg_red$share_fish   <- HBS_agg_red$EUR_HE0113 /HBS_agg_red$EUR_HE00 # expenditure share of fish per quintile
    
    # fruits and veggies 14.10.2022 DK
    HBS_agg_red$fruits_rel  = HBS_agg_red$EUR_HE0116 /HBS_agg_red$EUR_HE00
    HBS_agg_red$vegetables_rel = HBS_agg_red$EUR_HE0117 /HBS_agg_red$EUR_HE00

    # absolute expenditure
    HBS_agg_red$abs_meat   <- HBS_agg_red$EUR_HE0112 
    HBS_agg_red$abs_bovine <- HBS_agg_red$EUR_HE01121
    HBS_agg_red$abs_swine  <- HBS_agg_red$EUR_HE01122 
    HBS_agg_red$abs_sh_gt  <- HBS_agg_red$EUR_HE01123
    HBS_agg_red$abs_poultry<- HBS_agg_red$EUR_HE01124
    HBS_agg_red$abs_dried  <- HBS_agg_red$EUR_HE01125
    HBS_agg_red$abs_presv  <- HBS_agg_red$EUR_HE01126
    HBS_agg_red$abs_other  <- HBS_agg_red$EUR_HE01127
    #HBS_agg_red$abs_fish   <- HBS_agg_red$EUR_HE0113
    
    # fruits and veggies 14.10.2022 DK
    HBS_agg_red$fruits_abs   <- HBS_agg_red$EUR_HE0116
    HBS_agg_red$vegetables_abs   <- HBS_agg_red$EUR_HE0117 
    
    # convert wide to long format (for plotting)
    
    data_long_FnV     <- gather(HBS_agg_red,plant_type,shares, fruits_rel:vegetables_rel, factor_key=TRUE)
    data_long_abs_FnV <- gather(HBS_agg_red,plant_type,abs_cons, fruits_abs:vegetables_abs, factor_key=TRUE)
    
    data_long     <- gather(HBS_agg_red,meat_type,shares, share_bovine:share_other, factor_key=TRUE)
    data_long_abs <- gather(HBS_agg_red,meat_type,abs_cons, abs_bovine:abs_other, factor_key=TRUE)
    
    # plot relative expenditure   
    data_long$qn <- as.numeric(as.character(data_long$qn)); data_long_FnV$qn <- as.numeric(as.character(data_long_FnV$qn))
    labels <- c("bovine (mainly beef)", "pork", "sheep & goat", "poultry", "dried, smoked or salted", "other preserved", "other fresh")
    labels_old <-c("share_bovine","share_swine", "share_sh_gt", "share_poultry", "share_dried", "share_presv", "share_other")
    newcol<-rep(NA,times=5)
    data_long <- cbind(data_long,newcol); rm(newcol)
    names(data_long)[dim(data_long)[2]]<-"labels"
    for(i in c(1:length(labels))){
      data_long$labels[which(data_long$meat_type==labels_old[i])] <- labels[i]
    }
    
    ggplot(data_long, aes(x = qn, y = shares, fill=labels)) +
      geom_area(size=0.2, alpha=0.8, color='yellow')+
      scale_fill_viridis(discrete = TRUE)+
      #+ geom_area() +
      labs(x = "expenditure quintiles", y = "meat expenditure share") +
      #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
      theme_bw(base_size=14)+#legend.position=c(.79,.82),
      theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+
      ggtitle("Expenditure shares of different meat types")
    ggsave(paste0(country_plot_directory,"Engels meat curve for Europe_v4_EU_weighted.pdf"), width = 9, height = 6.6)
    ggsave(paste0(country_plot_directory,"Engels meat curve for Europe_v4_EU_weighted.png"), width = 9, height = 6.6)
    
    #FnV:
    ggplot(data_long_FnV, aes(x = qn, y = shares, fill=plant_type)) +
      geom_area(size=0.2, alpha=0.8, color='yellow')+
      scale_fill_viridis(discrete = TRUE)+
      #+ geom_area() +
      labs(x = "expenditure quintiles", y = "fruit and vegetables expenditure share") +
      #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
      theme_bw(base_size=14)+#legend.position=c(.79,.82),
      theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+
      ggtitle("Expenditure shares of fruit and vegetables")
    ggsave(paste0(country_plot_directory,"Engels fruit curve for Europe_v4_EU_weighted.pdf"), width = 9, height = 6.6)
    ggsave(paste0(country_plot_directory,"Engels fruit curve for Europe_v4_EU_weighted.png"), width = 9, height = 6.6)
    
    # plot absolute expenditure   
    data_long_abs$qn <- as.numeric(as.character(data_long_abs$qn))
    data_long_abs_FnV$qn <- as.numeric(as.character(data_long_abs_FnV$qn))
    labels <- c("bovine (mainly beef)", "pork", "sheep & goat", "poultry", "dried, smoked or salted", "other preserved", "other fresh")
    labels_old <-c("abs_bovine","abs_swine", "abs_sh_gt", "abs_poultry", "abs_dried", "abs_presv", "abs_other")
    newcol<-rep(NA,times=5)
    data_long_abs <- cbind(data_long_abs,newcol); rm(newcol)
    names(data_long_abs)[dim(data_long_abs)[2]]<-"labels"
    for(i in c(1:length(labels))){
      data_long_abs$labels[which(data_long_abs$meat_type==labels_old[i])] <- labels[i]
    }
    
    ggplot(data_long_abs, aes(x = qn, y = abs_cons, fill=labels)) +
      geom_area(size=0.2, alpha=0.8, color='yellow')+
      scale_fill_viridis(discrete = TRUE)+
      #+ geom_area() +
      labs(x = "expenditure quintiles", y = "meat expenditure (in 2015 EUR)") +
      #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
      theme_bw(base_size=14)+#legend.position=c(.35,.87),
      theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+
      #guides(fill=guide_legend(ncol=2))+
      ggtitle("Absolute expenditure on different meat types")
    ggsave(paste0(country_plot_directory,"Absolute meat expenditure for Europe_v4_EU_weighted.pdf"), width = 9, height = 6.6)
    ggsave(paste0(country_plot_directory,"Absolute meat expenditure for Europe_v4_EU_weighted.png"), width = 9, height = 6.6) 
    
    ggplot(data_long_abs_FnV, aes(x = qn, y = abs_cons, fill=plant_type)) +
      geom_area(size=0.2, alpha=0.8, color='yellow')+
      scale_fill_viridis(discrete = TRUE)+
      #+ geom_area() +
      labs(x = "expenditure quintiles", y = "expenditure (in 2015 EUR)") +
      #scale_color_hue(labels = c("1", "2","3","4","5","6","7"))
      theme_bw(base_size=14)+#legend.position=c(.35,.87),
      theme(legend.title = element_blank(),axis.text=element_text(size=14),axis.title=element_text(size=16),legend.text=element_text(size=14))+
      #guides(fill=guide_legend(ncol=2))+
      ggtitle("Absolute expenditure on fruits and vegetables")
    ggsave(paste0(country_plot_directory,"Absolute fruit expenditure for Europe_v4_EU_weighted.pdf"), width = 9, height = 6.6)
    ggsave(paste0(country_plot_directory,"Absolute fruit expenditure for Europe_v4_EU_weighted.png"), width = 9, height = 6.6) 
}