import numpy as np

def cceua(x, f, objective_function, lower_bound, upper_bound, number_call, ID):

    bound = upper_bound - lower_bound

    q = x.shape[0] # number of points to define the simplex
    n = x.shape[1] # number of parameters to be optimized

    alpha = 1.0 # reflection parameter
    beta = 0.5 # contraction parameter

    # assign the best and worst points
    x_best = x[0, :]
    f_best = f[0, :]

    x_worst = x[-1, :]
    f_worst = f[-1, :]

    # compute the centroid of the simpex without including the worst point
    x_center = np.mean(x[:-1, :], axis = 0)

    # attempt a reflection step
    x_new = x_center + alpha * (x_center - x_worst)

    # check if it is outside the bounds
    flag_bound = 0

    # check lower bound
    x_1 = x_new - lower_bound
    flag_lower = (x_1 < 0).sum()

    # check upper bound
    x_2 = upper_bound - x_new
    flag_upper= (x_2 < 0).sum()

    flag_bound += flag_lower + flag_upper

    if flag_bound >= 1:

        x_new = lower_bound + np.random.rand(1, n) * bound

    f_new, ID = objective_function(x_new.flatten(), ID)
    number_call += 1

    # if the reflection failed; now attempt a contraction point
    if f_new > f_worst:
        x_new = x_worst + beta * (x_center - x_worst)

        # check if it is outside the bounds
        flag_bound = 0

        # check lower bound
        x_1 = x_new - lower_bound
        flag_lower = (x_1 < 0).sum()

        # check upper bound
        x_2 = upper_bound - x_new
        flag_upper= (x_2 < 0).sum()

        flag_bound += flag_lower + flag_upper

        if flag_bound >= 1:
            print("Contraction failed when ID = ", ID)
            x_new = lower_bound + np.random.rand(1, n) * bound

        f_new, ID = objective_function(x_new.flatten(), ID)
        number_call += 1

        # if both reflection and contraction failed, attemp a random point
        if f_new > f_worst:
            x_new = lower_bound + np.random.rand(1, n) * bound
            f_new, ID = objective_function(x_new.flatten(), ID)
            number_call += 1

    return  x_new, f_new, number_call, ID
