#include <iostream>
#include "simplePointCalculator.h"

int main(){  
  bool assert = true;
  typedef unsigned int LabelType;
  typedef typename std::vector<LabelType>::const_iterator IteratorType;
  std::vector<LabelType> n;
  simplePointCalculator<IteratorType,LabelType> spc;
  //spc.generateInitializerList();
  //Test scenario 1
  // 1 1 2
  // 1 X 2
  // 2 3 3
  // Should be SP wrt 1 and 3
  n.push_back(1);
  n.push_back(1);
  n.push_back(2);
  n.push_back(1);
  n.push_back(0);
  n.push_back(2);
  n.push_back(2);
  n.push_back(3);
  n.push_back(3);
  assert &= (spc.isSimpleLabel(n.begin(), n.end(), 1) == true &&
	     spc.isSimpleLabel(n.begin(), n.end(), 2) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(), 3) == true);

  n.clear();

  // Test scenario 2
  //  4 2 3
  //  4   2
  //  4 3 5
  //  Should be SP wrt 4
  n.push_back(4);
  n.push_back(2);
  n.push_back(3);
  n.push_back(4);
  n.push_back(0);
  n.push_back(2);
  n.push_back(4);
  n.push_back(3);
  n.push_back(3);
  assert &= (spc.isSimpleLabel(n.begin(), n.end(),4) == true &&
	     spc.isSimpleLabel(n.begin(), n.end(),2) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),1) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),5) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),3) == false);

  n.clear();
  //Test scenario 3
  // 3 3 3
  // 1   3
  // 2 3 3
  // Should be SP wrt 1 and 3
  n.push_back(3);
  n.push_back(3);
  n.push_back(3);
  n.push_back(1);
  n.push_back(0);
  n.push_back(3);
  n.push_back(2);
  n.push_back(3);
  n.push_back(3);
  assert &= (spc.isSimpleLabel(n.begin(), n.end(),1) == true &&
	     spc.isSimpleLabel(n.begin(), n.end(),2) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),4) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),3) == true);
  n.clear();

  //Test scenario 3
  // 1 1 1
  // 1   1
  // 2 1 1
  // Should be SP wrt 1 only
  n.push_back(1);
  n.push_back(1);
  n.push_back(1);
  n.push_back(1);
  n.push_back(0);
  n.push_back(1);
  n.push_back(2);
  n.push_back(1);
  n.push_back(1);
  assert &= (spc.isSimpleLabel(n.begin(), n.end(),1) == true &&
	     spc.isSimpleLabel(n.begin(), n.end(),2) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),4) == false &&
	     spc.isSimpleLabel(n.begin(), n.end(),3) == false);
  n.clear();
  if(assert){
    std::cout << "simplePointCalculatorTest : success" << std::endl;
  }
  else{
    std::cout << "simplePointCalculatorTest : failed" << std::endl;
  }

}
