#ifndef otbUnsupervisedSegmentationCriteriaFilter_txx
#define otbUnsupervisedSegmentationCriteriaFilter_txx

#include "otbUnsupervisedSegmentationCriteriaFilter.h"

namespace otb{

  template <class TInputImage, class TInputLabel>
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TInputLabel>
  ::UnsupervisedSegmentationCriteriaFilter():
    m_NumberOfSegments(0),
    m_SpatialLL(0.0),
    m_SpectralLL(0.0),
    m_PerimeterCompacity(0.0),
    m_SizeVariance(0.0)
  {
  }

  template <class TInputImage, class TInputLabel>
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TInputLabel>
  ::~UnsupervisedSegmentationCriteriaFilter()
  {
  }
  
  
  template <class TInputImage, class TInputLabel>
  void
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TInputLabel>
  ::Reset()
  {    
    m_nbComps = this->GetInput()->GetNumberOfComponentsPerPixel();
    // std::cout << m_nbComps << "\n";
    m_totalVariance = std::vector<float>(m_nbComps,0.0);
    m_totalMean = std::vector<float>(m_nbComps, 0.0);
    m_totalCount = 0.0;
    m_explainedVarianceTemp = std::vector<float>(m_nbComps, 0.0);
    m_AvSize = 0.0;
    m_VarianceCompacity = 0.0;
    // //Calculate log likelihoods and invert matrices
    // LabeledMatrixContainerIteratorType varit;
    // m_SpatialLL = 0.0;
    // m_SpectralLL = 0.0;

    // Matrix totalVariance(m_nbComps, m_nbComps);
    // totalVariance.Fill(0.0);
    // SampleType totalMean(m_nbComps);
    // totalMean.Fill(0.0);
    // unsigned int totalCount = 0;
    
    // Matrix explainedVarianceTemp(m_nbComps, m_nbComps);
    // explainedVarianceTemp.Fill(0.0);
    
    // for(varit = m_Variances.begin() ; varit != m_Variances.end();++varit)
    //   {
    // 	const Matrix var = varit->second;
    // 	const unsigned int c = m_Count.find(varit->first)->second;
    // 	const unsigned int bc = m_BorderCount.find(varit->first)->second;
    // 	const SampleType m = m_Means.find(varit->first)->second;

    // 	//PerimeterCompacity
    // 	m_PerimeterCompacity += (double)4*3.1415*c/bc/bc;
    // 	const double avSize = (double) nbPixels/m_NumberOfSegments;
    // 	//Size Variance
    // 	m_SizeVariance += (c-avSize)*(c-avSize);

	
    // 	if(totalCount>0){
    // 	  //Update total variance
    // 	  for(unsigned int i = 0 ; i < m_nbComps; ++i)
    // 	    {
    // 	      for(unsigned int j = 0 ; j < m_nbComps; ++j)
    // 		{
    // 		  totalVariance[i][j] = ((totalCount-1)*totalVariance[i][j] + (c-1)*var[i][j] + (totalMean[i]-m[i])*(totalMean[j]-m[j])*totalCount*c/(totalCount+c))/(totalCount+c-1);
    // 		}
    // 	    }
    // 	  //Update explained variance
    // 	  for(unsigned int i = 0 ; i < m_nbComps; ++i)
    // 	    {
    // 	      for(unsigned int j = 0 ; j < m_nbComps; ++j)
    // 		{
    // 		  explainedVarianceTemp[i][j] = ((totalCount-1)*explainedVarianceTemp[i][j] + (totalMean[i]-m[i])*(totalMean[j]-m[j])*totalCount*c/(totalCount+c))/(totalCount+c-1);
    // 		}
    // 	    }
    // 	  //Update total mean
    // 	  for(unsigned int i = 0 ; i < m_nbComps+2 ; ++i)
    // 	    {
    // 	      totalMean[i] = (totalCount*totalMean[i] + c*m[i])/(totalCount+c);
    // 	    }
    // 	  //Update total count
    // 	  totalCount += c;
    // 	}
    // 	else{
    // 	  totalVariance=var;
    // 	  totalMean=m;
    // 	  totalCount=c;
    // 	}

    // 	// for(unsigned int comp = 0; comp < m_nbComps; comp++)
    // 	//   {
    // 	//     m_SpectralLL += var[comp][comp]*c;
    // 	//   }
    // 	// m_SpatialLL += var[m_nbComps][m_nbComps]*c;
    // 	// m_SpatialLL += var[m_nbComps+1][m_nbComps+1]*c;
    // 	// m_SpatialLL+=2*vcl_sqrt(var[m_nbComps][m_nbComps]*var[m_nbComps+1][m_nbComps+1])/(var[m_nbComps][m_nbComps]+var[m_nbComps+1][m_nbComps+1]);
    // 	if(c > 1)
    // 	  {
    // 	    const double sx = var[m_nbComps][m_nbComps];
    // 	    const double sy = var[m_nbComps+1][m_nbComps+1];
    // 	    const double sxy = var[m_nbComps][m_nbComps+1];	
    // 	    //const double d = vcl_sqrt((sx-sy)*(sx-sy)+sxy*sxy);
    // 	    // m_SpatialLL += c*(sx+sy-d)/(sx+sy+d);
    // 	    m_SpatialLL += c*2*(sx*sy-sxy*sxy)/(sx*sx+sy*sy-sxy*sxy);
    // 	  }
    // 	else
    // 	  {
    // 	    m_SpatialLL += 1;
    // 	  }
	

    // 	Matrix varInv(m_nbComps,m_nbComps);

    // 	//discard variances of x and y
    // 	for(unsigned int i = 0 ; i < m_nbComps ; ++i)
    // 	  for(unsigned int j  = 0 ; j < m_nbComps ; ++j)
    // 	    varInv[i][j] = var[i][j];
    // 	varInv = varInv.GetInverse();
    // 	LabelMatrixPairType newInv(varit->first,varInv);
    // 	m_InvVariances.insert(newInv);	 
    //   }

    // double avEV=0.0;
    // double avTV=0.0;
    
    // for(unsigned int comp = 0; comp < m_nbComps; comp++)
    //   {
    //     avEV += explainedVarianceTemp[comp][comp]/m_nbComps;
    // 	avTV += totalVariance[comp][comp]/m_nbComps;
    //   }
    // m_SpectralLL = avEV/avTV;
  }
  
  template <class TInputImage, class TInputLabel>
  void
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TInputLabel>
  ::BeforeThreadedGenerateData()
  {

  }
  
  template <class TInputImage, class TInputLabel>
  void
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TInputLabel>
  ::ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId)
  {
    LabeledIntContainerType count;
    {
      std::stringstream name;
      name << m_Prefix << "count_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> count;
    }
    LabeledIntContainerType perimeter;
    {
      std::stringstream name;
      name << m_Prefix << "perimeter_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> perimeter;
    }
    LabeledSampleContainerType means;
    {
      std::stringstream name;
      name << m_Prefix << "means_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> means;
    }

    LabeledMatrixContainerType covars;
    {
      std::stringstream name;
      name << m_Prefix << "covars_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> covars;
    }

    LabeledMatrixContainerIteratorType varit;
    
    for(varit = covars.begin() ; varit != covars.end();++varit)
      {
	//test if segment has already been counted by another tile
	if(m_usedLabels.find(varit->first) == m_usedLabels.end()){
	  m_usedLabels.insert(varit->first);
	  const Matrix var = varit->second;
	  const unsigned int c = count[varit->first];
	  const unsigned int bc = perimeter[varit->first];
	  const SampleType m = means[varit->first];

	  //PerimeterCompacity
	  m_PerimeterCompacity += (double)4*3.1415*c/bc/bc;
	  // //Size Variance
          if (m_AvSize > 0){
	    double newAvSize = m_AvSize;
	    newAvSize += (c-m_AvSize)/m_usedLabels.size();
	    m_SizeVariance += (c-newAvSize)*(c-m_AvSize);
	    m_AvSize = newAvSize;
	  }
	  else{
	    m_AvSize = c;
	  }

	  if(c > 1){
	    const double sx = var[m_nbComps][m_nbComps];
	    const double sy = var[m_nbComps+1][m_nbComps+1];
	    const double sxy = var[m_nbComps][m_nbComps+1];
	    m_VarianceCompacity += c*2*(sx*sy-sxy*sxy)/(sx*sx+sy*sy-sxy*sxy);
	  }
	  
	  if(m_totalCount>0){
	    //Update total variance
	    for(unsigned int i = 0 ; i < m_nbComps; ++i)
	      {
		m_totalVariance[i] = ((m_totalCount-1)*m_totalVariance[i] + (c-1)*var[i][i] + (m_totalMean[i]-m[i])*(m_totalMean[i]-m[i])*m_totalCount*c/(m_totalCount+c))/(m_totalCount+c-1);
		  
	      }
	    //Update explained variance
	    for(unsigned int i = 0 ; i < m_nbComps; ++i)
	      {
		m_explainedVarianceTemp[i] = ((m_totalCount-1)*m_explainedVarianceTemp[i] + (m_totalMean[i]-m[i])*(m_totalMean[i]-m[i])*m_totalCount*c/(m_totalCount+c))/(m_totalCount+c-1);
		  
	      }
	    //Update total mean
	    for(unsigned int i = 0 ; i < m_nbComps ; ++i)
	      {
		m_totalMean[i] = (m_totalCount*m_totalMean[i] + c*m[i])/(m_totalCount+c);
	      }
	    //Update total count
	    m_totalCount += c;
	  }
	  else{
	    for (unsigned i = 0; i < m_nbComps; i++) {
	      m_totalVariance[i]=var[i][i];
	    }
	    m_totalMean=SampleType(m.begin(), m.begin()+m_nbComps);
	    m_totalCount=c;
	  }
	}
      }
      
  }

  template <class TInputImage, class TOutputLabelImage>
  void
  UnsupervisedSegmentationCriteriaFilter<TInputImage, TOutputLabelImage>
  ::Synthetize()
  {
    m_ExplainedVariance = 0.0;
    for (unsigned int i = 0 ; i < m_nbComps ; ++i) {
      m_ExplainedVariance += m_explainedVarianceTemp[i]/m_totalVariance[i];
    }   
    m_ExplainedVariance /= m_nbComps;
    m_NumberOfSegments = m_usedLabels.size();

    const unsigned long nbPixels = m_ImageSeg->GetLargestPossibleRegion().GetNumberOfPixels();
    // for(unsigned int threadId = 0 ; threadId < this->GetNumberOfThreads() ; ++threadId)
    //   {
    // 	m_OutlierCount += m_TempOutlier[threadId];
    //   }
    // m_OutlierCount /= nbPixels;
    m_VarianceCompacity /= nbPixels;
    m_PerimeterCompacity /= m_NumberOfSegments;
    m_SizeVariance /= (m_NumberOfSegments-1);//s^2
    m_SizeVariance = vcl_sqrt(m_SizeVariance);//s
    m_SizeVariance /= m_AvSize;// s/mu (coeff de variation, RSD)
  }
}
#endif
