#ifndef otbUnsupervisedSegmentationCriteriaFilter_h
#define otbUnsupervisedSegmentationCriteriaFilter_h

#include "otbVectorImage.h"
#include "otbImage.h"
#include "itkMacro.h"
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionConstIteratorWithIndex.h"
#include "itkImageRegionIterator.h"
#include "otbPersistentImageFilter.h"
#include "itkVariableSizeMatrix.h"
#include "itkProgressReporter.h"

#include <fstream>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/serialization/unordered_map.hpp>
#include <unordered_map>
#include <unordered_set>

namespace otb{
  template <class TInputImage, class TInputLabel>
  class ITK_EXPORT UnsupervisedSegmentationCriteriaFilter : public PersistentImageFilter<TInputImage,TInputImage>
  {
  public:
    typedef UnsupervisedSegmentationCriteriaFilter                                                    Self;
    typedef PersistentImageFilter<TInputImage, TInputImage>                 Superclass;
    typedef itk::SmartPointer<Self>                                              Pointer;
    typedef itk::SmartPointer<const Self>                                        ConstPointer;

    /** Method for creation through the object factory. */
    itkNewMacro(Self);

    /** Runtime information support. */
    itkTypeMacro(UnsupervisedSegmentationCriteriaFilter, PersistentImageFilter);

    /** ImageDimension constants */
    itkStaticConstMacro(ImageDimension, unsigned int, TInputImage::ImageDimension);
    
    typedef typename TInputLabel::PixelType LabelType;
    typedef TInputLabel LabelImageType;
    typedef itk::ImageRegionIterator<TInputLabel> LabelImageIteratorType;
    typedef typename TInputLabel::Pointer LabelImagePointer;
    
    typedef TInputImage InputImageType;
    typedef typename std::vector<float> SampleType;
    typedef itk::ImageRegionIterator<TInputImage> InputImageIteratorType;
    typedef typename TInputImage::Pointer InputImagePointer;
    
    typedef typename TInputImage::RegionType RegionType;

    typedef std::unordered_map<LabelType,SampleType> LabeledSampleContainerType;
    typedef typename LabeledSampleContainerType::iterator LabeledSampleContainerIteratorType;
    typedef std::pair<LabelType,SampleType> LabelSamplePairType;
    
    typedef std::vector<std::vector<float> > Matrix;
    typedef std::unordered_map<LabelType,Matrix> LabeledMatrixContainerType;
    typedef typename LabeledMatrixContainerType::iterator LabeledMatrixContainerIteratorType;
    typedef std::pair<LabelType,Matrix> LabelMatrixPairType;
    
    typedef std::unordered_map<LabelType, unsigned int> LabeledIntContainerType;
    typedef typename LabeledIntContainerType::iterator LabeledIntContainerIteratorType;
    typedef std::pair<LabelType,unsigned int> LabelIntPairType;
    
    itkSetMacro(ImageSeg,LabelImagePointer);

    itkSetMacro(Prefix,std::string);

    itkGetConstReferenceMacro(ExplainedVariance, double);
    
    itkGetConstReferenceMacro(SpectralLL, double);

    itkGetConstReferenceMacro(NumberOfSegments, unsigned int);

    itkGetConstReferenceMacro(PerimeterCompacity, double);

    itkGetConstReferenceMacro(SizeVariance,double);

    itkGetConstReferenceMacro(VarianceCompacity,double);

    virtual void Reset() ITK_OVERRIDE;
    
    virtual void Synthetize() ITK_OVERRIDE;
    
  protected:
    UnsupervisedSegmentationCriteriaFilter();

    ~UnsupervisedSegmentationCriteriaFilter() ITK_OVERRIDE;
    
    virtual void BeforeThreadedGenerateData() ITK_OVERRIDE;
    
    virtual void ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId) ITK_OVERRIDE;
  
  private:
    UnsupervisedSegmentationCriteriaFilter(const Self&);//purposely not implemented
    void operator =(const Self&); //purposely not implemented
    //Inputs
    LabelImagePointer m_ImageSeg;        
    
    unsigned int m_nbComps;

    std::string m_Prefix;

    //Temporary Variables

    std::unordered_set<LabelType> m_usedLabels;

    SampleType m_totalVariance;

    SampleType m_totalMean;

    unsigned int m_totalCount;

    SampleType m_explainedVarianceTemp;

    //Outputs
    unsigned int m_NumberOfSegments;
    
    double m_OutlierCount;
    
    double m_SpatialLL;
    
    double m_SpectralLL;  

    double m_PerimeterCompacity;

    double m_SizeVariance;

    double m_ExplainedVariance;

    double m_AvSize;

    double m_VarianceCompacity;
   
  };
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbUnsupervisedSegmentationCriteriaFilter.txx"
#endif

#endif
