#include "otbVectorImage.h"
#include "otbImage.h"
#include "otbImageFileReader.h"
#include "otbImageFileWriter.h"
#include "otbSegmentCharacteristicsFilter.h"
#include "otbUnsupervisedSegmentationCriteriaFilter.h"
#include "otbPersistentFilterStreamingDecorator.h"
#include "otbSegmentCharacteristicsArchiveWriter.h"

typedef unsigned int                                                         LabelType;
typedef otb::Image<LabelType>                                                LabelImageType;
typedef otb::ImageFileReader<LabelImageType>                                 LabelReaderType;

typedef unsigned short                                                       ComponentType;
typedef otb::VectorImage<ComponentType>                                      VectorImageType;
typedef otb::ImageFileReader<VectorImageType>                                VectorReaderType;

typedef otb::ImageFileWriter<LabelImageType>                                 LabelWriterType;

typedef otb::SegmentCharacteristicsArchiveWriter<VectorImageType,LabelImageType> CharFilter;
typedef otb::UnsupervisedSegmentationCriteriaFilter<VectorImageType,LabelImageType>      CritFilter;

typedef otb::PersistentFilterStreamingDecorator<CritFilter> StreamingCritFilterType;


int main(int argc, char* argv[])
{  
  if(argc!=5)
    {
      std::cerr<<"Usage: "<<argv[0]<<" image image_seg tempFiles nbX"<<std::endl;
      return EXIT_FAILURE;
    }
  //Read the input image
  VectorReaderType::Pointer vreader = VectorReaderType::New();
  vreader->SetFileName(argv[1]);
  vreader->UpdateOutputInformation();
  // Read the input segmentation
  LabelReaderType::Pointer lreader = LabelReaderType::New();
  lreader->SetFileName(argv[2]);
  const std::string prefix(argv[3]);
  const unsigned nbX(atoi(argv[4]));
  
  CharFilter::Pointer charFilter = CharFilter::New();
  charFilter->SetInput(vreader->GetOutput());
  charFilter->SetImageSeg(lreader->GetOutput());
  charFilter->SetPrefix(prefix);
  charFilter->SetNbDivisions(nbX*nbX);
  charFilter->SetCovarianceMatrixFlag(true);
  charFilter->Run();

  StreamingCritFilterType::Pointer streamingCritFilter = StreamingCritFilterType::New();
  CritFilter::Pointer critfilter = CritFilter::New();
  
  critfilter->SetInput(vreader->GetOutput());
  critfilter->SetImageSeg(lreader->GetOutput());
  critfilter->SetPrefix(prefix);
  critfilter->SetNumberOfThreads(1);
  streamingCritFilter->SetFilter(critfilter);
  streamingCritFilter->GetStreamer()->SetStreamingManager(charFilter->GetStreamingManager());
  streamingCritFilter->Update();

  std::cout <<
    critfilter->GetNumberOfSegments() << " " <<
    critfilter->GetVarianceCompacity() << " " <<
    critfilter->GetExplainedVariance() << " " << 
    critfilter->GetPerimeterCompacity() << " " <<
    critfilter->GetSizeVariance() << " " <<
    std::endl;

}
