#ifndef otbSegmentCharacteristicsFilter_txx
#define otbSegmentCharacteristicsFilter_txx

#include "otbSegmentCharacteristicsFilter.h"
namespace otb{

  template <class TInputImage, class TInputLabel>
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::SegmentCharacteristicsFilter()
  {
    this->SetNumberOfRequiredInputs(2);
    m_PerimeterFlag=false;
    m_CovarianceMatrixFlag=false;
    m_NLabels=1000;
  }

  template <class TInputImage, class TInputLabel>
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::~SegmentCharacteristicsFilter()
  {
  }
  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::SetImageSeg(LabelImagePointer im){
    this->SetNthInput(1,im);
  }
  template <class TInputImage, class TInputLabel>
  TInputLabel *
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::GetImageSeg() {
    return static_cast<TInputLabel *>(this->itk::ProcessObject::GetInput(1));
  }
  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::FuseCovarianceContainers(LabeledIntContainerType const & count1, LabeledIntContainerType const& count2,
			     LabeledSampleContainerType const& means1, LabeledSampleContainerType const& means2,
			     LabeledMatrixContainerType & vars1, LabeledMatrixContainerType const& vars2) const
  {
    typename LabeledMatrixContainerType::const_iterator v2 = vars2.begin();
    for(;v2 != vars2.end();++v2)
      {
	const LabelType currentLabel = v2->first;
	LabeledMatrixContainerIteratorType v1 = vars1.find(currentLabel);
	if(v1 == vars1.end())
	  {
	    //new label
	    vars1.insert(*v2);
	  }
	else
	  {
	    const unsigned int c1 = count1.find(currentLabel)->second;
	    const unsigned int c2 = count2.find(currentLabel)->second;
	    const SampleType m1 = means1.find(currentLabel)->second;
	    const SampleType m2 = means2.find(currentLabel)->second;
	    
	    //Fuse old and new label contents
	    //Fusion of covariance matrices : Sx_ij = Sa_ij + Sb_ij + (mua_i - mub_i)(mua_j -mub_j)*na*nb/(na+nb)
	    //where Sx = sigma_x^2/(n-1)
	    for(unsigned int i = 0 ; i < m_nbComps; ++i)
	      {
		for(unsigned int j = 0 ; j < m_nbComps; ++j)
		  {
		    v1->second[i][j] = ((c1-1)*v1->second[i][j] + (c2-1)*v2->second[i][j] + (m1[i]-m2[i])*(m1[j]-m2[j])*c1*c2/(c1+c2))/(c1+c2-1);
		  }
	      }
	    for(unsigned int i = m_nbComps ; i < m_nbComps+2; ++i)
	      {
		for(unsigned int j = m_nbComps  ; j < m_nbComps +2; ++j)
		  {
		    v1->second[i][j] = ((c1-1)*v1->second[i][j] + (c2-1)*v2->second[i][j] + (m1[i]-m2[i])*(m1[j]-m2[j])*c1*c2/(c1+c2))/(c1+c2-1);
		  }
	      }
	  }
      }
  }
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::FuseVarianceContainers(LabeledIntContainerType const & count1, LabeledIntContainerType const& count2,
			   LabeledSampleContainerType const& means1, LabeledSampleContainerType const& means2,
			   LabeledSampleContainerType & vars1, LabeledSampleContainerType const& vars2) const
  {
    typename LabeledSampleContainerType::const_iterator v2 = vars2.begin();
    for(;v2 != vars2.end();++v2)
      {
	const LabelType currentLabel = v2->first;
	LabeledSampleContainerIteratorType v1 = vars1.find(currentLabel);
	if(v1 == vars1.end())
	  {
	    //new label
	    vars1.insert(*v2);
	  }
	else
	  {
	    const unsigned int c1 = count1.find(currentLabel)->second;
	    const unsigned int c2 = count2.find(currentLabel)->second;
	    const SampleType m1 = means1.find(currentLabel)->second;
	    const SampleType m2 = means2.find(currentLabel)->second;
	    
	    //Fuse old and new label contents
	    //Fusion of covariance matrices : Sx_ij = Sa_ij + Sb_ij + (mua_i - mub_i)(mua_j -mub_j)*na*nb/(na+nb)
	    //where Sx = sigma_x^2/(n-1)
	    for(unsigned int i = 0 ; i < m_nbComps; ++i)
	      {
		v1->second[i] = ((c1-1)*v1->second[i] + (c2-1)*v2->second[i] + (m1[i]-m2[i])*(m1[i]-m2[i])*c1*c2/(c1+c2))/(c1+c2-1);
	      }
	  }
      }
  }
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::FuseMeansContainers(LabeledIntContainerType const & count1, LabeledIntContainerType const& count2,
			LabeledSampleContainerType & means1, LabeledSampleContainerType const& means2) const
  {
    typename LabeledSampleContainerType::const_iterator m2 = means2.begin();
    for(;m2 != means2.end();++m2)
      {
	const LabelType currentLabel = m2->first;
	LabeledSampleContainerIteratorType m1 = means1.find(currentLabel);
	if(m1 == means1.end())
	  {
	    //new label
	    means1.insert(*m2);
	  }
	else
	  {
	    //cast to double here
	    const double c1 = count1.find(currentLabel)->second;
	    const double c2 = count2.find(currentLabel)->second;
	    //Fuse old and new label contents
	    for(unsigned int i = 0 ; i < m_nbComps+2 ; ++i)
	      {
		m1->second[i] = (c1*m1->second[i] + c2*m2->second[i])/(c1+c2);
	      }
	  }
      }
  }
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::FuseCountContainers(LabeledIntContainerType & count1, LabeledIntContainerType const& count2) const
  {
    typename LabeledIntContainerType::const_iterator c2 = count2.begin();
    for(;c2 != count2.end();++c2)
      {
	const LabelType currentLabel = c2->first;
	LabeledIntContainerIteratorType c1 = count1.find(currentLabel);
	if(c1 == count1.end())
	  {
	    //new label
	    count1.insert(*c2);
	  }
	else
	  {
	    //Fuse old and new label contents
	    c1->second+=c2->second;
	  }
      }
  }
  
  template <class TInputImage, class TInputLabel>
  unsigned int
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::perimeterCount(NeighborhoodType const& n) const
  { 
    typename NeighborhoodType::ConstIterator ni = n.Begin()+1;
    const LabelType l = n.GetCenterValue();
    unsigned int c = 0;
    for(;ni < n.End(); ni += 2)
      {
	if(*ni != l)
	  {
	    c++;
	  }
      }       
    return c;
  }

  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::Reset()
  {
    // std::cout << "Reset" << std::endl;
    // const unsigned int numberOfThreads = this->GetNumberOfThreads();
    // m_TemporaryCount.resize(numberOfThreads);
    // if(m_PerimeterFlag){
    //   m_TemporaryBorderCount.resize(numberOfThreads);
    // }
    // m_TemporaryMeans.resize(numberOfThreads);
    // if(m_CovarianceMatrixFlag){
    //   m_TemporaryCovariances.resize(numberOfThreads);
    // }
    // else{
    //   m_TemporaryVariances.resize(numberOfThreads);
    // }
    // //resize containers to avoid rehashing
    // for (unsigned i = 0; i < numberOfThreads; i++) {
    //   m_TemporaryCount[i].reserve(m_NLabels/numberOfThreads);
    //   if(m_PerimeterFlag){
    // 	m_TemporaryBorderCount[i].reserve(m_NLabels/numberOfThreads);
    //   }
    //   m_TemporaryMeans.reserve(numberOfThreads/numberOfThreads);
    //   if(m_CovarianceMatrixFlag){
    // 	m_TemporaryCovariances[i].reserve(m_NLabels/numberOfThreads);
    //   }
    //   else{
    // 	m_TemporaryVariances[i].reserve(m_NLabels/numberOfThreads);
    //   }
    // }
    m_nbComps = this->GetInput()->GetNumberOfComponentsPerPixel();
  }
  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::BeforeThreadedGenerateData()
  {
    // unsigned int numberOfThreads = this->GetNumberOfThreads();
    // m_TemporaryCount.resize(numberOfThreads);
    //std::cout << "Reset" << std::endl;
  }
  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::GenerateInputRequestedRegion(){
    Superclass::GenerateInputRequestedRegion();
    if(m_PerimeterFlag){
      RegionType req = this->GetInput()->GetRequestedRegion();
      req.PadByRadius(1);
      req.Crop(this->GetInput()->GetLargestPossibleRegion());
      //Request enlarged region for neighborhood calculations
      GetImageSeg()->SetRequestedRegion(req);
    }
  }
  
  template <class TInputImage, class TInputLabel>
  void
  SegmentCharacteristicsFilter<TInputImage, TInputLabel>
  ::ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId)
  {
    // std::cout<< "Start thread " << threadId << " " <<outputRegionForThread<< std::endl;
    
    itk::ImageRegionConstIteratorWithIndex<InputImageType> vit(this->GetInput(),outputRegionForThread);

    const typename NeighborhoodLabelIteratorType::RadiusType radius = {{1,1}};
    NeighborhoodLabelIteratorType lit(radius,GetImageSeg(),outputRegionForThread);
    //const unsigned int nbPixels = outputRegionForThread.GetNumberOfPixels();
    LabeledIntContainerType count;
    LabeledIntContainerType borderCount;
    LabeledSampleContainerType means;
    LabeledSampleContainerType vars;
    LabeledMatrixContainerType covars;
    for(vit.GoToBegin(),lit.GoToBegin();!vit.IsAtEnd() && !lit.IsAtEnd();++vit,++lit)
      {	  
	const LabelType label = lit.GetCenterPixel();	
	LabeledIntContainerIteratorType search = count.find(label);
	if(search == count.end())	  
	  {
	    // Label is not in list	    
	    // Create new element in count
	    count.insert(LabelIntPairType(label,1));
	    // Create new element in BorderCount
	    if(m_PerimeterFlag){
	      borderCount.insert(LabelIntPairType(label,perimeterCount(lit.GetNeighborhood())));
	    }
	    // Create new element in means	    
	    SampleType s(m_nbComps+2);
	    for(unsigned int i = 0 ; i < m_nbComps ; ++i)
	      {
		s[i] = vit.Get()[i];
	      }
	    s[m_nbComps]=vit.GetIndex()[0];
	    s[m_nbComps+1]=vit.GetIndex()[1];
	    means.insert(LabelSamplePairType(label,s));

	    if(m_CovarianceMatrixFlag){
	      // Create new element in covariances
	      Matrix m(m_nbComps+2,std::vector<float>(m_nbComps+2,0.0));
	      covars.insert(LabelMatrixPairType(label,m));
	    }
	    else{
	      SampleType s(m_nbComps+2,0.0);
	      vars.insert(LabelSamplePairType(label,s));
	    }	    
	  }
	else
	  {
	    //Element is already in list
	    //Update with running formulas
	    //Update count
	    search->second++;
	    //Update borderCount
	    if(m_PerimeterFlag){
	      borderCount.find(label)->second+=perimeterCount(lit.GetNeighborhood());
	    }
	    //Update Means
	    LabeledSampleContainerIteratorType searchM = means.find(label);	    
	    SampleType oldMeans = searchM->second;
	    SampleType newMeans = oldMeans;
	    //Cast to int to double
	    const double N = search->second;
	    for(unsigned int i = 0 ; i < m_nbComps ; ++i)
	      {
		newMeans[i] += (vit.Get()[i]-oldMeans[i])/N;
	      }
	    newMeans[m_nbComps] += (vit.GetIndex()[0]-oldMeans[m_nbComps])/N;
	    newMeans[m_nbComps+1] += (vit.GetIndex()[1]-oldMeans[m_nbComps+1])/N;

	    searchM->second = newMeans;
	    if(m_CovarianceMatrixFlag){
	      //Update coVars
	      LabeledMatrixContainerIteratorType searchVar = covars.find(label);
	      Matrix oldCovar = searchVar->second;
	      Matrix newCovar = oldCovar;
	      for(unsigned int i = 0 ; i < m_nbComps ; ++i)
		{
		  for(unsigned int j = 0 ; j < m_nbComps ; ++j)
		    {
		      //Update running covar matrix
		      newCovar[i][j] += (vit.Get()[i]-newMeans[i])*(vit.Get()[j]-oldMeans[j]);
		    }	      
		}
	      //xvariance
	      newCovar[m_nbComps][m_nbComps] += (vit.GetIndex()[0]-newMeans[m_nbComps])*(vit.GetIndex()[0]-oldMeans[m_nbComps]);
	      //yvariance
	      newCovar[m_nbComps+1][m_nbComps+1] += (vit.GetIndex()[1]-newMeans[m_nbComps+1])*(vit.GetIndex()[1]-oldMeans[m_nbComps+1]);
	      //xy covariance
	      newCovar[m_nbComps][m_nbComps+1] += (vit.GetIndex()[0]-newMeans[m_nbComps])*(vit.GetIndex()[1]-oldMeans[m_nbComps+1]);
	      //symmetric
	      newCovar[m_nbComps+1][m_nbComps]+=(vit.GetIndex()[1]-newMeans[m_nbComps+1])*(vit.GetIndex()[0]-oldMeans[m_nbComps]);
	      searchVar->second = newCovar;
	    }
	    else{
	      LabeledSampleContainerIteratorType searchVar = vars.find(label);
	      SampleType oldVar = searchVar->second;
	      SampleType newVar = oldVar;
	      for(unsigned int i = 0 ; i < m_nbComps ; ++i)
		{
		  //Update running covar matrix
		  newVar[i] += (vit.Get()[i]-newMeans[i])*(vit.Get()[i]-oldMeans[i]);  
		}
	      //xvariance
	      newVar[m_nbComps] += (vit.GetIndex()[0]-newMeans[m_nbComps])*(vit.GetIndex()[0]-oldMeans[m_nbComps]);
	      //yvariance
	      newVar[m_nbComps+1] += (vit.GetIndex()[1]-newMeans[m_nbComps+1])*(vit.GetIndex()[1]-oldMeans[m_nbComps+1]);
	      searchVar->second = newVar;
	    }
	  }	
	
      }

    if(m_CovarianceMatrixFlag){
      for(LabeledMatrixContainerIteratorType v = covars.begin(); v!= covars.end() ; ++v)
	{
	  const unsigned int c = count.find(v->first)->second;
	  if(c>1){
	    for(auto r = v->second.begin() ; r != v->second.end() ; ++r){
	      for(auto l = r->begin() ; l != r->end() ; ++l){
		(*l)/=(c-1);
	      }
	    }
	  }
	}
    }
    else{
      for(LabeledSampleContainerIteratorType v = vars.begin(); v!= vars.end() ; ++v)
	{
	  const unsigned int c = count.find(v->first)->second;
	  if(c>1){
	    for(auto it = v->second.begin() ; it != v->second.end() ; ++it)
	      (*it)/=(c-1);
	  }
	}
    }
    //Archive count, borderCount, means, vars and/or covars
    {
      std::stringstream name;
      name << m_Prefix << "count_" << outputRegionForThread.GetIndex()[0] << "_" <<outputRegionForThread.GetIndex()[1];
      std::ofstream ofs(name.str());
      boost::archive::binary_oarchive oa(ofs);
      oa << count;
      ofs.close();
    }
    {
      std::stringstream name;
      name << m_Prefix << "means_" << outputRegionForThread.GetIndex()[0] << "_" <<outputRegionForThread.GetIndex()[1];
      std::ofstream ofs(name.str());
      boost::archive::binary_oarchive oa(ofs);
      oa << means;
      ofs.close();
    }
    if(m_CovarianceMatrixFlag){
      std::stringstream name;
      name << m_Prefix << "covars_" << outputRegionForThread.GetIndex()[0] << "_" <<outputRegionForThread.GetIndex()[1];
      std::ofstream ofs(name.str());
      boost::archive::binary_oarchive oa(ofs);
      oa << covars;
      ofs.close();
    }
    else{
      std::stringstream name;
      name << m_Prefix << "vars_" << outputRegionForThread.GetIndex()[0] << "_" <<outputRegionForThread.GetIndex()[1];
      std::ofstream ofs(name.str());
      boost::archive::binary_oarchive oa(ofs);
      oa << vars;
      ofs.close();
    }
    if(m_PerimeterFlag){
      std::stringstream name;
      name << m_Prefix << "perimeter_" << outputRegionForThread.GetIndex()[0] << "_" <<outputRegionForThread.GetIndex()[1];
      std::ofstream ofs(name.str());
      boost::archive::binary_oarchive oa(ofs);
      oa << borderCount;
      ofs.close();
    }
    // if(m_CovarianceMatrixFlag){
    //   FuseCovarianceContainers(m_TemporaryCount[threadId],count, m_TemporaryMeans[threadId],means, m_TemporaryCovariances[threadId],covars);
    // }
    // else{
    //   FuseVarianceContainers(m_TemporaryCount[threadId],count, m_TemporaryMeans[threadId],means, m_TemporaryVariances[threadId],vars);
    // }
    // FuseMeansContainers(m_TemporaryCount[threadId],count, m_TemporaryMeans[threadId],means);
    // FuseCountContainers(m_TemporaryCount[threadId],count);
    // if(m_PerimeterFlag){
    //   FuseCountContainers(m_TemporaryBorderCount[threadId],borderCount);
    // }
  }

  template <class TInputImage, class TOutputLabelImage>
  void
  SegmentCharacteristicsFilter<TInputImage, TOutputLabelImage>
  ::Synthetize()
  {
  
    // std::cout << "Enter Sythetize" << std::endl;
    // if(this->GetNumberOfThreads() == 1){
    //   if(m_CovarianceMatrixFlag){
    // 	m_Covariances=m_TemporaryCovariances[0];
    //   }
    //   else{
    // 	m_Variances=m_TemporaryVariances[0];
    //   }
    //   m_Means=m_TemporaryMeans[0];
    //   m_Count=m_TemporaryCount[0];
    //   if(m_PerimeterFlag){
    // 	m_BorderCount=m_TemporaryBorderCount[0];
    //   }
    // }
    // for(unsigned int threadId = 0 ; threadId < this->GetNumberOfThreads(); ++threadId)
    //   {
    // 	if(m_CovarianceMatrixFlag){
    // 	  FuseCovarianceContainers(m_Count,m_TemporaryCount[threadId], m_Means,m_TemporaryMeans[threadId], m_Covariances, m_TemporaryCovariances[threadId]);
    // 	}
    // 	else{
    // 	  FuseVarianceContainers(m_Count,m_TemporaryCount[threadId], m_Means,m_TemporaryMeans[threadId], m_Variances, m_TemporaryVariances[threadId]);
    // 	}
    // 	FuseMeansContainers(m_Count,m_TemporaryCount[threadId], m_Means,m_TemporaryMeans[threadId]);
    // 	FuseCountContainers(m_Count,m_TemporaryCount[threadId]);
    // 	if(m_PerimeterFlag){
    // 	  FuseCountContainers(m_BorderCount,m_TemporaryBorderCount[threadId]);
    // 	}
    //   }
    
  }
}
#endif
