#ifndef otbSegmentCharacteristicsFilter_h
#define otbSegmentCharacteristicsFilter_h

#include "otbVectorImage.h"
#include "otbImage.h"
#include "itkImageRegionConstIterator.h"
#include "itkConstNeighborhoodIterator.h"
#include "itkConstantBoundaryCondition.h"
#include "itkImageRegionConstIteratorWithIndex.h"
#include "itkImageRegionIterator.h"
#include "otbPersistentImageFilter.h"
#include "itkVariableSizeMatrix.h"
#include "itkProgressReporter.h"
#include <fstream>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/serialization/unordered_map.hpp>
#include <boost/serialization/vector.hpp>
#include <unordered_map>
namespace otb{
  template <class TInputImage, class TInputLabel>
  class ITK_EXPORT SegmentCharacteristicsFilter : public PersistentImageFilter<TInputImage,TInputImage>
  {
  public:
    typedef SegmentCharacteristicsFilter                                                    Self;
    typedef PersistentImageFilter<TInputImage, TInputImage>                 Superclass;
    typedef itk::SmartPointer<Self>                                              Pointer;
    typedef itk::SmartPointer<const Self>                                        ConstPointer;

    /** Method for creation through the object factory. */
    itkNewMacro(Self);

    /** Runtime information support. */
    itkTypeMacro(SegmentCharacteristicsFilter, PersistentImageFilter);

    /** ImageDimension constants */
    itkStaticConstMacro(ImageDimension, unsigned int, TInputImage::ImageDimension);
    
    typedef typename TInputLabel::PixelType LabelType;
    typedef TInputLabel LabelImageType;
    typedef itk::ImageRegionIterator<TInputLabel> LabelImageIteratorType;
    typedef typename TInputLabel::Pointer LabelImagePointer;
 
    typedef TInputImage InputImageType;
    typedef typename std::vector<float> SampleType;
    typedef itk::ImageRegionIterator<TInputImage> InputImageIteratorType;
    typedef typename TInputImage::Pointer InputImagePointer;
    
    typedef typename TInputImage::RegionType RegionType;
 
    typedef std::unordered_map<LabelType,SampleType> LabeledSampleContainerType;
    typedef typename LabeledSampleContainerType::iterator LabeledSampleContainerIteratorType;
    typedef std::pair<LabelType,SampleType> LabelSamplePairType;
    
    typedef std::vector<std::vector<float> > Matrix;
    typedef std::unordered_map<LabelType,Matrix> LabeledMatrixContainerType;
    typedef typename LabeledMatrixContainerType::iterator LabeledMatrixContainerIteratorType;
    typedef std::pair<LabelType,Matrix> LabelMatrixPairType;
    
    typedef std::unordered_map<LabelType, unsigned int> LabeledIntContainerType;
    typedef typename LabeledIntContainerType::iterator LabeledIntContainerIteratorType;
    typedef std::pair<LabelType,unsigned int> LabelIntPairType;
    
    typedef itk::ConstantBoundaryCondition<TInputLabel>                    BoundaryConditionType;
    typedef itk::ConstNeighborhoodIterator<TInputLabel,BoundaryConditionType>   NeighborhoodLabelIteratorType;
    typedef typename NeighborhoodLabelIteratorType::NeighborhoodType NeighborhoodType;

    // itkGetConstReferenceMacro(Means,LabeledSampleContainerType);

    // itkGetConstReferenceMacro(Variances,LabeledSampleContainerType);
	
    // itkGetConstReferenceMacro(Covariances,LabeledMatrixContainerType);

    // itkGetConstReferenceMacro(Count,LabeledIntContainerType);

    // itkGetConstReferenceMacro(BorderCount, LabeledIntContainerType);

    itkSetMacro(PerimeterFlag,bool);
    
    itkSetMacro(CovarianceMatrixFlag,bool);

    // itkSetMacro(NLabels,unsigned);

    itkSetMacro(Prefix,std::string);

    virtual void Reset() ITK_OVERRIDE;
    
    virtual void Synthetize() ITK_OVERRIDE;

    void SetImageSeg(LabelImagePointer im);

    TInputLabel* GetImageSeg();
    
  protected:
    SegmentCharacteristicsFilter();

    ~SegmentCharacteristicsFilter() ITK_OVERRIDE;
    
    virtual void BeforeThreadedGenerateData() ITK_OVERRIDE;
    
    virtual void ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId) ITK_OVERRIDE;

    virtual void GenerateInputRequestedRegion() ITK_OVERRIDE;
  
  private:
    SegmentCharacteristicsFilter(const Self&);//purposely not implemented
    void operator =(const Self&); //purposely not implemented

    void FuseVarianceContainers(LabeledIntContainerType const& count1, LabeledIntContainerType const& count2,
				LabeledSampleContainerType const& means1, LabeledSampleContainerType const& means2,
				LabeledSampleContainerType & vars1, LabeledSampleContainerType const& vars2) const;
    
    void FuseCovarianceContainers(LabeledIntContainerType const& count1, LabeledIntContainerType const& count2,
				LabeledSampleContainerType const& means1, LabeledSampleContainerType const& means2,
				LabeledMatrixContainerType & covars1, LabeledMatrixContainerType const& covars2) const;
    
    void FuseMeansContainers(LabeledIntContainerType const& count1, LabeledIntContainerType const& count2,
			     LabeledSampleContainerType & means1, LabeledSampleContainerType const& means2) const;
    
    void FuseCountContainers(LabeledIntContainerType & count1, LabeledIntContainerType const& count2) const ;
    
    unsigned int perimeterCount(NeighborhoodType const& n) const;
    
    unsigned int m_nbComps;
    
    // std::vector<LabeledMatrixContainerType> m_TemporaryCovariances;
    LabeledMatrixContainerType m_Covariances;

    // std::vector<LabeledSampleContainerType> m_TemporaryVariances;
    LabeledSampleContainerType m_Variances;
   
    // std::vector<LabeledSampleContainerType> m_TemporaryMeans;
    LabeledSampleContainerType m_Means;

    // std::vector<LabeledIntContainerType> m_TemporaryCount;
    LabeledIntContainerType m_Count;
    
    // std::vector<LabeledIntContainerType> m_TemporaryBorderCount;
    LabeledIntContainerType m_BorderCount;

    bool m_PerimeterFlag;

    bool m_CovarianceMatrixFlag;

    unsigned m_NLabels;

    std::string m_Prefix;
    
  };
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbSegmentCharacteristicsFilter.txx"
#endif

#endif
