#ifndef otbSegmentCharacteristicsArchiveWriter_h
#define otbSegmentCharacteristicsArchiveWriter_h

#include "otbVectorImage.h"
#include "otbImage.h"

#include "otbMultiChannelExtractROI.h"
#include "itkExtractImageFilter.h"

#include "itkImageRegionConstIterator.h"
#include "itkConstNeighborhoodIterator.h"
#include "itkImageRegionConstIteratorWithIndex.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageRegionIterator.h"
#include "itkConstantBoundaryCondition.h"

#include "itkImageToImageFilter.h"
#include "itkConstantPadImageFilter.h"
#include "itkImageRegionSplitterBase.h"

#include "itkVariableSizeMatrix.h"
#include "itkProgressReporter.h"
#include "itkNeighborhoodIterator.h"

#include <unordered_map>

#include "otbSegmentCharacteristicsFilter.h"
#include "otbPersistentFilterStreamingDecorator.h"

namespace otb{

  template <class TInputImage, class TInputLabel>
  class ITK_EXPORT SegmentCharacteristicsArchiveWriter : public itk::ProcessObject
  {
  public:
    typedef SegmentCharacteristicsArchiveWriter                                  Self;
    typedef itk::ProcessObject                                                   Superclass;
    typedef itk::SmartPointer<Self>                                              Pointer;
    typedef itk::SmartPointer<const Self>                                        ConstPointer;

    /** Method for creation through the object factory. */
    itkNewMacro(Self);

    /** Runtime information support. */
    itkTypeMacro(SegmentCharacteristicsArchiveWriter, ImageToImageFilter);

    /** ImageDimension constants */
    itkStaticConstMacro(ImageDimension, unsigned int, TInputImage::ImageDimension);
   
    typedef typename TInputLabel::PixelType LabelType;
    typedef TInputLabel LabelImageType;
    typedef itk::ImageRegionIterator<TInputLabel> LabelImageIteratorType;
    typedef typename TInputLabel::Pointer LabelImagePointer;

    
    typedef TInputImage InputImageType;
    typedef typename std::vector<float> SampleType;
    typedef itk::ImageRegionIterator<TInputImage> InputImageIteratorType;
    typedef typename TInputImage::Pointer InputImagePointer;
    
    typedef typename TInputImage::RegionType RegionType;

    typedef otb::SegmentCharacteristicsFilter<TInputImage,TInputLabel> CharFilter;
    typedef otb::PersistentFilterStreamingDecorator<CharFilter> StreamingCharFilterType;
    typedef typename otb::StreamingManager<TInputImage>::Pointer StreamingManagerPointerType;

    typedef std::unordered_map<LabelType, unsigned int> LabeledIntContainerType;
    typedef typename LabeledIntContainerType::iterator LabeledIntContainerIteratorType;
    typedef std::pair<LabelType,unsigned int> LabelIntPairType;
    typedef std::unordered_map<LabelType,SampleType> LabeledSampleContainerType;
    typedef typename LabeledSampleContainerType::iterator LabeledSampleContainerIteratorType;
    typedef std::pair<LabelType,SampleType> LabelSamplePairType;
    typedef std::vector<std::vector<float> > Matrix;
    typedef std::unordered_map<LabelType,Matrix> LabeledMatrixContainerType;
    typedef typename LabeledMatrixContainerType::iterator LabeledMatrixContainerIteratorType;
    typedef std::pair<LabelType,Matrix> LabelMatrixPairType;

    itkSetMacro(Prefix,std::string);
    
    itkSetMacro(NbDivisions,unsigned int);
    
    itkGetMacro(StreamingManager,StreamingManagerPointerType);

    itkSetMacro(CovarianceMatrixFlag, bool);

    itkSetMacro(PerimeterFlag,bool);

    void SetInput(InputImagePointer im);

    void SetImageSeg(LabelImagePointer im);

    TInputImage* GetInput();

    TInputLabel* GetImageSeg();
	
    virtual void Run();

  protected:
    SegmentCharacteristicsArchiveWriter();

    ~SegmentCharacteristicsArchiveWriter() ITK_OVERRIDE;

    template <class T> static T readArchive(std::string name);

    template <class T> static void writeArchive(T const& object, std::string name);

    static bool areNeighboringRegions(RegionType const r1, RegionType const r2);

    void fixArchives(std::vector<RegionType> const& regions, unsigned nbComps, std::string prefix) const ;
    
  private:
    SegmentCharacteristicsArchiveWriter(const Self&);//purposely not implemented
    void operator =(const Self&); //purposely not implemented
    std::string m_Prefix;
    unsigned int m_NbDivisions;
    StreamingManagerPointerType m_StreamingManager;
    bool m_CovarianceMatrixFlag;
    bool m_PerimeterFlag;
  };
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbSegmentCharacteristicsArchiveWriter.txx"
#endif

#endif
