#ifndef MultiScaleFeatureExtractorFilter_txx
#define MultiScaleFeatureExtractorFilter_txx

#include "otbMultiScaleFeatureExtractorFilter.h"
namespace otb{

  template <class TInputImage, class TOutputImage>
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::MultiScaleFeatureExtractorFilter()
  {
  }

  template <class TInputImage, class TOutputImage>
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::~MultiScaleFeatureExtractorFilter()
  {
  }
  template <class TInputImage, class TOutputImage>
  TOutputImage *
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::GetOutput()
  {
    return static_cast<TOutputImage *>(this->itk::ProcessObject::GetOutput(0));
  }
  template <class TInputImage, class TOutputImage>
  const TOutputImage *
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::GetOutput() const
  {
    return static_cast<TOutputImage *>(this->itk::ProcessObject::GetOutput(0));
  }
  template <class TInputImage, class TOutputImage>
  void
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::BeforeThreadedGenerateData()
  {
    // std::cout << "before" << std::endl;
    // this->GetOutput()->SetRegions(this->GetInput()->GetLargestPossibleRegion());
    this->GetOutput()->SetVectorLength(m_NbComps);
    this->GetOutput()->Allocate();
  }

  
  template <class TInputImage, class TOutputImage>
  void
  MultiScaleFeatureExtractorFilter<TInputImage, TOutputImage>
  ::ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId)
  {
    // std::cout<< "Start thread " << threadId << " "  << outputRegionForThread <<std::endl;
    itk::ImageRegionConstIterator<TInputImage> lit(this->GetInput(),outputRegionForThread);
    itk::ImageRegionIterator<TOutputImage> it(this->GetOutput(),outputRegionForThread);
    // LabeledIntContainerType count;
    // std::stringstream name;
    // name << m_Prefix << "count_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
    // std::ifstream ifs(name.str());
    // boost::archive::binary_iarchive ia(ifs);
    // ia >> count;
    // std::cout << count.size() << std::endl;
    // std::cout << outputRegionForThread << std::endl;
    if(m_Feature == "mean"){
      LabeledSampleContainerType means;	  
      std::stringstream name;
      name << m_Prefix << "means_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> means;
      for (it.GoToBegin(), lit.GoToBegin(); !it.IsAtEnd() && !lit.IsAtEnd(); ++it, ++lit){
	//Get Mean vector
	typename VectorImage<float>::PixelType s(m_NbComps);
	const SampleType m = means.find(lit.Get())->second;
	for (unsigned int i = 0; i < m_NbComps; i++) {
	  s[i] = m[i];
	}
	it.Set(s);
      }
    }
    else if(m_Feature == "variance"){
      LabeledSampleContainerType vars;
      std::stringstream name;
      name << m_Prefix << "vars_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> vars;
      for (it.GoToBegin(), lit.GoToBegin(); !it.IsAtEnd() && !lit.IsAtEnd(); ++it, ++lit){
	typename VectorImage<float>::PixelType s(m_NbComps);
	const SampleType v = vars.find(lit.Get())->second;
	for (unsigned int i = 0; i < m_NbComps; i++) {
	  s[i] = vcl_sqrt(v[i]);
	}
	it.Set(s);
      }
    }
    else if (m_Feature == "perimeter"){
      LabeledIntContainerType peri;
      std::stringstream name;
      name << m_Prefix << "perimeter_fixed_" << outputRegionForThread.GetIndex()[0] << "_" << outputRegionForThread.GetIndex()[1];
      std::ifstream ifs(name.str());
      boost::archive::binary_iarchive ia(ifs);
      ia >> peri;
      for (it.GoToBegin(), lit.GoToBegin(); !it.IsAtEnd() && !lit.IsAtEnd(); ++it, ++lit){
	typename VectorImage<float>::PixelType s(1);
	s[0] = peri.find(lit.Get())->second;
	it.Set(s);
      }
    }
  }
}
#endif
