#ifndef MultiScaleFeatureExtractorFilter_h
#define MultiScaleFeatureExtractorFilter_h

#include "otbVectorImage.h"
#include "otbImage.h"

#include "otbMultiChannelExtractROI.h"
#include "itkExtractImageFilter.h"

#include "itkImageRegionConstIterator.h"
#include "itkConstNeighborhoodIterator.h"
#include "itkImageRegionConstIteratorWithIndex.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkImageRegionIterator.h"
#include "itkConstantBoundaryCondition.h"

#include "itkImageToImageFilter.h"
#include "itkConstantPadImageFilter.h"
#include "itkImageRegionSplitterBase.h"

#include "itkVariableSizeMatrix.h"
#include "itkProgressReporter.h"
#include "itkNeighborhoodIterator.h"

#include <fstream>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/serialization/unordered_map.hpp>
#include <unordered_map>

namespace otb{

  template <class TInputImage, class TOutputImage>
  class ITK_EXPORT MultiScaleFeatureExtractorFilter : public itk::ImageToImageFilter<TInputImage, TOutputImage>
  {
  public:
    typedef MultiScaleFeatureExtractorFilter                                     Self;
    typedef itk::ImageToImageFilter<TInputImage, TOutputImage>                   Superclass;
    typedef itk::SmartPointer<Self>                                              Pointer;
    typedef itk::SmartPointer<const Self>                                        ConstPointer;

    /** Method for creation through the object factory. */
    itkNewMacro(Self);

    /** Runtime information support. */
    itkTypeMacro(otbMultiScaleFeatureExtractorFilter, ImageToImageFilter);

    /** ImageDimension constants */
    itkStaticConstMacro(ImageDimension, unsigned int, TInputImage::ImageDimension);
   
    typedef TInputImage InputImageType;
    typedef typename std::vector<float> SampleType;
    typedef itk::ImageRegionIterator<TInputImage> InputImageIteratorType;
    typedef typename TInputImage::Pointer InputImagePointer;   
    typedef typename TInputImage::RegionType RegionType;
    typedef typename TInputImage::PixelType LabelType;
    
    typedef itk::ConstantBoundaryCondition<TInputImage>  BoundaryConditionType;
    typedef itk::ConstNeighborhoodIterator<TInputImage,BoundaryConditionType> NeighborhoodLabelIteratorType;
    typedef typename NeighborhoodLabelIteratorType::NeighborhoodType NeighborhoodType;
    
    typedef itk::VariableSizeMatrix<float> Matrix;
    typedef std::unordered_map<LabelType,Matrix> LabeledMatrixContainerType;

    typedef std::unordered_map<LabelType,SampleType> LabeledSampleContainerType;
    typedef std::unordered_map<LabelType,unsigned int> LabeledIntContainerType;
    //Returns the const image of region labels
    const TOutputImage * GetOutput() const;
    //Returns the image of region labels
    TOutputImage * GetOutput();
    
    itkSetMacro(NbComps,unsigned int);

    // itkSetMacro(Variances,LabeledSampleContainerType);

    // itkSetMacro(Means,LabeledSampleContainerType);

    itkSetMacro(Prefix,std::string);

    itkSetMacro(Feature,std::string);

  protected:
    MultiScaleFeatureExtractorFilter();

    ~MultiScaleFeatureExtractorFilter() ITK_OVERRIDE;
        
    virtual void BeforeThreadedGenerateData() ITK_OVERRIDE;
    
    virtual void ThreadedGenerateData(const RegionType& outputRegionForThread, itk::ThreadIdType threadId) ITK_OVERRIDE;

  private:
    MultiScaleFeatureExtractorFilter(const Self&);//purposely not implemented
    void operator =(const Self&); //purposely not implemented
    unsigned int m_NbComps;
    // LabeledSampleContainerType m_Variances;
    // LabeledSampleContainerType m_Means;
    std::string m_Prefix;
    std::string m_Feature;
  };
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbMultiScaleFeatureExtractorFilter.txx"
#endif

#endif
