#include "otbVectorImage.h"
#include "otbImage.h"
#include "otbImageFileReader.h"
#include "otbImageFileWriter.h"
#include "otbMultiScaleFeatureExtractorFilter.h"
#include "otbSegmentCharacteristicsArchiveWriter.h"


typedef unsigned int                                                         LabelType;
typedef otb::Image<LabelType>                                                LabelImageType;
typedef otb::ImageFileReader<LabelImageType>                                 LabelReaderType;
typedef typename LabelImageType::RegionType                                  RegionType;

typedef unsigned short                                                       ComponentType;
typedef otb::VectorImage<ComponentType>                                      VectorImageType;
typedef otb::ImageFileReader<VectorImageType>                                VectorReaderType;

typedef otb::ImageFileWriter<VectorImageType>                                VectorWriterType;

typedef typename std::vector<float>                                         SampleType;

typedef otb::SegmentCharacteristicsArchiveWriter<VectorImageType,LabelImageType> CharFilter;

typedef std::unordered_map<LabelType, unsigned int> LabeledIntContainerType;
typedef typename LabeledIntContainerType::iterator LabeledIntContainerIteratorType;
typedef std::pair<LabelType,unsigned int> LabelIntPairType;
typedef std::unordered_map<LabelType,SampleType> LabeledSampleContainerType;
typedef typename LabeledSampleContainerType::iterator LabeledSampleContainerIteratorType;
typedef std::pair<LabelType,SampleType> LabelSamplePairType;
typedef itk::VariableSizeMatrix<double> Matrix;
typedef std::unordered_map<LabelType,Matrix> LabeledMatrixContainerType;
typedef typename LabeledMatrixContainerType::iterator LabeledMatrixContainerIteratorType;
typedef std::pair<LabelType,Matrix> LabelMatrixPairType;

typedef otb::MultiScaleFeatureExtractorFilter<LabelImageType, VectorImageType> ExtractorFilterType;


int main(int argc, char* argv[])
{
  
  if(argc!=7)
    {
      std::cerr<<"Usage: "<<argv[0]<<" image image_seg output_raster tempFiles nbX feature"<<std::endl;
      return EXIT_FAILURE;
    }
  //Read the input image
  VectorReaderType::Pointer vreader = VectorReaderType::New();
  vreader->SetFileName(argv[1]);
  vreader->UpdateOutputInformation();
  const unsigned int nbComps = vreader->GetOutput()->GetNumberOfComponentsPerPixel();
  // Read the input segmentation
  LabelReaderType::Pointer lreader = LabelReaderType::New();
  lreader->SetFileName(argv[2]);
  // lreader->Update();
  const std::string prefix(argv[4]);
  const unsigned nbX = atoi(argv[5]);
  const std::string feature(argv[6]);
  CharFilter::Pointer charFilter = CharFilter::New();
  std::cout << "Extracting "+ feature + " from " + std::string(argv[2]) << "\n";
  charFilter->SetInput(vreader->GetOutput());
  charFilter->SetImageSeg(lreader->GetOutput());
  charFilter->SetPrefix(prefix);
  charFilter->SetNumberOfThreads(1);
  charFilter->SetNbDivisions(nbX*nbX);
  charFilter->SetCovarianceMatrixFlag(false);
  charFilter->Run();
  ExtractorFilterType::Pointer extractFilter = ExtractorFilterType::New();
  extractFilter->SetInput(lreader->GetOutput());
  extractFilter->SetNbComps(nbComps);
  extractFilter->SetFeature(feature);
  extractFilter->SetPrefix(prefix);
  extractFilter->SetNumberOfThreads(1);
  VectorWriterType::Pointer vwriter = VectorWriterType::New();
  vwriter->SetStreamingManager(charFilter->GetStreamingManager());
  vwriter->SetInput(extractFilter->GetOutput());
  vwriter->SetFileName(argv[3]);
  vwriter->Update();
}

