clear;close all;clc;

addpath('/Users/xudo627/donghui/mylib/m/');
addpath('/Users/xudo627/donghui/CODE/Setup-E3SM-Mac/matlab-scripts-for-mosart/');

files = dir('original_scheme/*.nc');
xv = ncread('inputdata_run/domain_lnd_Pantanal_all_template.nc','xv');
yv = ncread('inputdata_run/domain_lnd_Pantanal_all_template.nc','yv');
ncell = size(xv,2);

[lon_gsim,lat_gsim,S,yr_gsim,mo_gsim,da,mu_gsim,sd,cv] = get_GSIM_discharge('BR_0002835',1);

fh2osfc = NaN(ncell,length(files));
for i = 1 : length(files)
    filename = fullfile(files(i).folder,files(i).name);
    disp(filename);
    tmp = ncread(filename,'FH2OSFC');
    fh2osfc(:,i) = tmp(1:ncell);
end

cmap = getPyPlot_cMap('Blues');
figure; set(gcf,'Position',[10 10 1200 500]);
subplot_tight(1,2,1,[0.12 0.06]); 
a = nanmean(fh2osfc,1);
a = reshape(a(:),[12,length(files)/12]);
a = nanmean(a,2);
plot(1:12,a,'k-','LineWidth',2); grid on;
set(gca,'FontSize',13);
ylabel('Wetland inundation [-]','FontSize',14,'FontWeight','bold');
xlim([1 12]);
xticklabels({'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'});
title('(a)','FontSize',15,'FontWeight','bold');

subplot_tight(1,2,2,[0.12 0.06]);
patch(xv,yv,nanmean(fh2osfc,2),'LineStyle','none'); axis equal; hold on;
set(gca,'FontSize',13);
plot(S.X,S.Y,'g-','LineWidth',2);
cb = colorbar('west'); colormap(cmap);
pos = get(gca,'Position');
cb.Position = [pos(1) + pos(3) + 0.01 pos(2) 0.02 pos(4)];
title('(b)','FontSize',15,'FontWeight','bold');
