function [xtrain, nr] = get_parameters(ex,numc,ntot)

rng(1);

nr = [];
if strcmp(ex,'all')
    micro_sigma_default = ones(numc,1).*0.1;
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= 0.001 + (1-0.001)*rand(ntot,1); % micro_sigma
    xtrain(:,4)= 0.01 + (1-0.01)*rand(ntot,1); % fc   
    xtrain(:,5)= 2.6 + (20.2-2.6)*rand(ntot,1); % rwid [2.6 - 20.2]
    xtrain(:,6)= 0.12 + (0.63-0.12)*rand(ntot,1); % rdep  

elseif strcmp(ex,'geo')
    micro_sigma_default = [];
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= ones(ntot,1).*0.5;
    xtrain(:,3)= ones(ntot,1).*0.1;
    xtrain(:,4)= ones(ntot,1).*0.4;  
    xtrain(:,5)= 2.6 + (20.2-2.6)*rand(ntot,1);   % rwid [2.6 - 20.2]
    xtrain(:,6)= 0.12 + (0.63-0.12)*rand(ntot,1); % rdep  
    
elseif strcmp(ex,'sub')
    micro_sigma_default = [];
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,2)= ones(ntot,1).*0.5;
    xtrain(:,3)= ones(ntot,1).*0.1;
    xtrain(:,4)= ones(ntot,1).*0.4;  
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26; 
    
elseif strcmp(ex,'sur')
    micro_sigma_default = ones(numc,1).*0.1;
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= 0.001 + (1-0.001)*rand(ntot,1); % micro_sigma
    xtrain(:,4)= 0.01 + (1-0.01)*rand(ntot,1); % fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26;      
    
elseif strcmp(ex,'sur2')
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= ones(ntot,1).*0.1;
    xtrain(:,4)= 10.^(-3 + (-0.155+3)*rand(1,ntot)); %fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26;   
    
elseif strcmp(ex,'sur22') || strcmp(ex,'sur222')
    micro_sigma_default = ones(numc,1).*0.1;
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= 0.001 + (1-0.001)*rand(ntot,1); % micro_sigma
    xtrain(:,4)= 0.01 + (1-0.01)*rand(ntot,1); % fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26;   
    
    swf_sim = NaN(ntot*numc,12);
    qru_sim = NaN(ntot*numc,12);
    for i = 1 : 12
        swf_sim(:,i) = nanmean(fdfall(:,i:12:end) + fh2osfcall(:,i:12:end),2);
        qru_sim(:,i) = nanmean(qrunoffall(:,i:12:end),2);
    end
    glad = load('/Users/xudo627/DATA/GLAD/GLAD_Pantanal_half.mat');

    swf_glad = NaN(length(xc),12);
    for i = 1 : length(xc)
        [row,col] = find(glad.lon == xc(i) & glad.lat == yc(i));
        swf_glad(i,:) = glad.swf(row,col,:)./100;
    end
    
    swf_cal = NaN(numc,12);
    qrunoff_cal = NaN(numc,12);
    qover_cal   = NaN(numc,1);
    fc_cal      = NaN(numc,1);
    sigma_cal   = NaN(numc,1);
    for i = 1 : numc
        disp(['Calibrating ' num2str(i)]);
        y1 = swf_sim(i:numc:end,:);
        y2 = swf_glad(i,:);
        y3 = qru_sim(i:numc:end,:);
        NSE = NaN(ntot,1);
        for j = 1 : ntot
            [~,~,NSE(j)] = estimate_evaluation_metric(y2',y1(j,:)');
        end
        ii = find(NSE == max(NSE));
        swf_cal(i,:) = y1(ii(1),:);
        qrunoff_cal(i,:) = y3(ii(1),:);
        qover_cal(i) = xtrain(ii(1),2);
        fc_cal(i)    = xtrain(ii(1),3);
        sigma_cal(i) = xtrain(ii(1),4);
    end
    
    figure(102);
    subplot(1,3,1);
    patch(xv,yv,qover_cal,'LineStyle','none'); colorbar;
    subplot(1,3,2);
    patch(xv,yv,fc_cal,'LineStyle','none'); colorbar;
    subplot(1,3,3);
    patch(xv,yv,sigma_cal,'LineStyle','none'); colorbar;
    
    figure(101);
    subplot(1,2,1);
    patch(xv,yv,nanmean(swf_glad,2),'LineStyle','none'); colorbar;
    title('GLAD','FontSize',16,'FontWeight','bold');
    subplot(1,2,2);
    patch(xv,yv,nanmean(swf_cal,2),'LineStyle','none'); colorbar;
    title('Calibration','FontSize',16,'FontWeight','bold');
    
    figure;
    plot(nanmean(swf_glad,1),'k-','LineWidth',2); hold on;
    plot(nanmean(swf_cal,1),'g-','LineWidth',2); 
    R2 = NaN(12,1);
    for i = 1 : 12
        [~,~,R2(i)] = LSE(swf_glad(:,i),swf_cal(:,i));
    end
elseif strcmp(ex,'run')
    xtrain = NaN(ntot,6);
    xtrain(:,1)= 0.1 + (5-0.1)*rand(ntot,1); % fdrain
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1); % fover
    xtrain(:,3)=ones(ntot,1).*0.1;
    xtrain(:,4)= 0 + (1-0)*rand(ntot,1); % fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26; 
    
elseif strcmp(ex,'run4')
    
    xtrain = NaN(ntot,6);
    xtrain(:,1)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= 10.^(-3 + (0+3)*rand(1,ntot)); % micro_sigma
    xtrain(:,4)= 10.^(-3 + (-0.155+3)*rand(1,ntot)); %fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26;  
    
elseif strcmp(ex,'run5')
    xtrain = NaN(ntot,6);
    xtrain(:,1)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,2)= 0.1 + (5-0.1)*rand(ntot,1);
    xtrain(:,3)= ones(ntot,1).*0.1; % micro_sigma
    xtrain(:,4)= 10.^(-3 + (-0.155+3)*rand(1,ntot)); %fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26;  
elseif strcmp(ex,'hydraulic')
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= ones(ntot,1).*0.5;
    xtrain(:,3)= ones(ntot,1).*0.1;
    xtrain(:,4)= ones(ntot,1).*0.4;  
    xtrain(:,5)= 2.6 + (20.2-2.6)*rand(ntot,1);   % rwid [2.6 - 20.2]
    xtrain(:,6)= 0.12 + (0.63-0.12)*rand(ntot,1); % rdep  

    nr = 0.01 + (0.2-0.01)*rand(ntot,1);

elseif strcmp(ex,'hydraulic2')
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= ones(ntot,1).*0.5;
    xtrain(:,3)= ones(ntot,1).*0.1;
    xtrain(:,4)= ones(ntot,1).*0.4;  
    xtrain(:,5)= 2.6 + (20.2-2.6)*rand(ntot,1);   % rwid [2.6 - 20.2]
    xtrain(:,6)= 0.12 + (0.63-0.12)*rand(ntot,1); % rdep  

    nr_uq = ones(numc*ntot,1).*0.05;
    nr = 0.01 + (0.2-0.01)*rand(ntot,1);
    for i = 1 : ntot
        nr_uq((i-1)*numc+1:i*numc) = nr(i);
    end

elseif strcmp(ex,'sur3')
    xtrain = NaN(ntot,6);
    xtrain(:,1)= ones(ntot,1).*2.5;
    xtrain(:,2)= ones(ntot,1).*0.5;
    xtrain(:,3)=ones(ntot,1).*0.1;
    xtrain(:,4)= 0 + (0.5-0)*rand(ntot,1); % fc   
    xtrain(:,5)= ones(ntot,1).*7.2;  
    xtrain(:,6)= ones(ntot,1).*0.26; 
elseif strcmp(ex,'man') || strcmp(ex,'man2')
    xtrain =  NaN(ntot,6);
elseif strcmp(ex,'default')
    xtrain =  NaN(ntot,6);
end


end