function [muyr,qyr,z,zmu,trend,trendmu,slope,slopemu] = convert_mon_to_annual(mu_gsim,q,ntot,yr,yr1,yr2)
    mu   = mu_gsim(yr >= yr1 & yr <= yr2);
    muyr = nanmean(reshape(mu,[12,yr2-yr1+1]),1);

    qyr = NaN(ntot,yr2-yr1+1);
    yrs = 1979;
    yre = 2010;
    for i = 1 : ntot
        tmp = q(i,(yr1-yrs)*12+1:(yr2-yrs+1)*12);
        qyr(i,:) = nanmean(reshape(tmp',[12,yr2-yr1+1]),1);
        [~,~,NSEyr(i)] = estimate_evaluation_metric(muyr,qyr(i,:));
        [z(i), trend(i), h, p] = mk_test(qyr(i,:)');
        [slope(i), intercept] = sens_slope(qyr(i,:)');
    end
    [zmu, trendmu, h, p] = mk_test(muyr(:)');
    [slopemu, intercept] = sens_slope(muyr(:));
end

