clear;close all;clc;

addpath('/Users/xudo627/developments/getPanoply_cMap/');

S = shaperead('river_geometry.shp');

X = []; Y = []; 
W05 = []; D05 = [];
W50 = []; D50 = [];
W95 = []; D95 = [];
for i = 1 : length(S)
    disp(i);
    X = [X; S(i).X'];
    Y = [Y; S(i).Y'];
    W05 = [W05; ones(length(S(i).X),1).*S(i).a_WIDTH5];
    W50 = [W50; ones(length(S(i).X),1).*S(i).a_WIDTH];
    W95 = [W95; ones(length(S(i).X),1).*S(i).a_WIDTH95];
    
    D05 = [D05; ones(length(S(i).X),1).*S(i).a_DEPTH5];
    D50 = [D50; ones(length(S(i).X),1).*S(i).a_DEPTH];
    D95 = [D95; ones(length(S(i).X),1).*S(i).a_DEPTH95];
end

sz = 1.5; w = 0.06; d = 0.06;
figure; set(gcf,'Position',[10 10 1200 600]);
subplot_tight(2,3,1,[w,d]);
scatter(X,Y,sz,W05,'filled'); colorbar;
title('5% Width [m]','FontSize',15,'FontWeight','bold');
subplot_tight(2,3,2,[w,d]);
scatter(X,Y,sz,W50,'filled'); colorbar;
title('50% Width [m]','FontSize',15,'FontWeight','bold');
subplot_tight(2,3,3,[w,d]);
scatter(X,Y,sz,W95,'filled'); colorbar;
title('95% Width [m]','FontSize',15,'FontWeight','bold');

subplot_tight(2,3,4,[w,d]);
scatter(X,Y,sz,D05,'filled'); colorbar;
title('5% Depth [m]','FontSize',15,'FontWeight','bold');
subplot_tight(2,3,5,[w,d]);
scatter(X,Y,sz,D50,'filled'); colorbar;
title('50% Depth [m]','FontSize',15,'FontWeight','bold');
subplot_tight(2,3,6,[w,d]);
scatter(X,Y,sz,D95,'filled'); colorbar;
title('95% Depth [m]','FontSize',15,'FontWeight','bold');

cmap = getPanoply_cMap('EO_aura_omi_formal');

colormap(cmap);