clear;close all; clc;

xv=ncread('inputdata_run/domain_lnd_Pantanal_default.nc','xv');
yv=ncread('inputdata_run/domain_lnd_Pantanal_default.nc','yv');
xc=ncread('inputdata_run/domain_lnd_Pantanal_default.nc','xc');
yc=ncread('inputdata_run/domain_lnd_Pantanal_default.nc','yc');

data = load('/Users/xudo627/DATA/GIEMS/wetland_global_extent_1993_2007_Papa_etal_2010_Prigent_etal_2012.dat');
lat = data(:,2);
lon = data(:,3);
lon(lon > 180) = lon(lon > 180) - 360;

giems = data(:,4:end); clear data;
giems(giems == -99) = NaN;
giems(giems < 0) = NaN;
giems = giems./773;

giems_pantanal = NaN(length(xc),size(giems,2));

for i = 1 : size(giems,2)
    disp([num2str(i) '/' num2str(size(giems,2))]);
    giems_pantanal(:,i) = griddata(lon,lat,giems(:,i),xc,yc);
end

figure;
giems_pantanal(isnan(giems_pantanal)) = 0;
a = nanmean(giems_pantanal,1);
a = reshape(a',[12 15]);
plot(a,'-');

figure;
plot(nanmean(a,2),'-');
figure;
plot(nanmean(a,2).*100,'k-','LineWidth',2);
figure;
plot(nanmean(a,1).*100,'k-','LineWidth',2);
grid on;
ylabel('GIEMS inundation [%]','FontWeight','bold','FontSize',15);
figure;
patch(xv,yv,nanmean(giems_pantanal,2)); colorbar;