#!/bin/sh

RES=ELMMOS_USRDAT
COMPSET=IELM
MACH=compy
COMPILER=intel
PROJECT=esmd

SRC_DIR=/qfs/people/xudo627/E3SMv2-sensitivity
CASE_DIR=${SRC_DIR}/cime/scripts

cd ${SRC_DIR}
GIT_HASH=`git log -n 1 --format=%h`

cd ${SRC_DIR}/cime/scripts
CASE_NAME=Pantanal_half_calibration_CLMCRUNCEPv7_${GIT_HASH}.`date "+%Y-%m-%d-%H%M%S"`

./create_newcase \
-case ${CASE_NAME} \
-res ${RES} \
-mach ${MACH} \
-compiler ${COMPILER} \
-compset ${COMPSET} --project ${PROJECT}


cd ${CASE_DIR}/${CASE_NAME}

./xmlchange -file env_run.xml -id DOUT_S             -val FALSE
./xmlchange -file env_run.xml -id INFO_DBUG          -val 2

./xmlchange DATM_MODE=CLMCRUNCEPv7 #CLMGSWP3v1 #CLMNLDAS2
./xmlchange LND_DOMAIN_FILE=domain_lnd_Pantanal_calibration_uq.nc
./xmlchange ATM_DOMAIN_FILE=domain_lnd_Pantanal_calibration_uq.nc
./xmlchange LND_DOMAIN_PATH=/compyfs/xudo627/Pantanal/code/inputdata_run
./xmlchange ATM_DOMAIN_PATH=/compyfs/xudo627/Pantanal/code/inputdata_run
./xmlchange CIME_OUTPUT_ROOT=/compyfs/xudo627/Pantanal/outputs

./xmlchange -file env_run.xml -id DATM_CLMNCEP_YR_END -val 2010
./xmlchange -file env_run.xml -id DATM_CLMNCEP_YR_START -val 1970
./xmlchange -file env_run.xml -id DATM_CLMNCEP_YR_ALIGN -val 1

./xmlchange PIO_BUFFER_SIZE_LIMIT=67108864
./xmlchange STOP_N=41,STOP_OPTION=nyears
#./xmlchange REST_N=10,REST_OPTION=nyears
./xmlchange NTASKS=40
./xmlchange JOB_WALLCLOCK_TIME=30:00:00

cat >> user_nl_elm << EOF
fsurdat = '/compyfs/xudo627/Pantanal/code/inputdata_run/surfdata_Pantanal_calibration_uq.nc'
use_modified_infil = .true.
hist_empty_htapes = .true.
hist_fincl1 = 'QOVER', 'QDRAI', 'QRUNOFF', 'FH2OSFC', 'EFLX_LH_TOT', 'RAIN', 'ZWT', 'TSA','FSNO','FSAT','GPP','NPP','TWS','SOILWATER_10CM'
EOF

cat >> user_nl_mosart << EOF
frivinp_rtm = '/compyfs/xudo627/Pantanal/code/inputdata_run/MOSART_Pantanal_calibration_uq.nc'
rtmhist_fincl1='RIVER_DISCHARGE_OVER_LAND_LIQ','RIVER_DISCHARGE_TO_OCEAN_LIQ','FLOODED_FRACTION','FLOODPLAIN_FRACTION'
inundflag = .true.
routingmethod = 2
opt_elevprof = 1
EOF

./case.setup

./case.build

./case.submit
