clear;close all;clc;

cases = {'Pantanal_default_DW_a26c8e3','Pantanal_default_KW_a26c8e3'};
xc = ncread('./inputdata_run/domain_lnd_Pantanal_default.nc','xc');
numc = length(xc);

data = struct([]);
for i = 1 : length(cases)
    files = dir(['/compyfs/xudo627/Pantanal/outputs/' cases{i} '/run/*.mosart.h0.*.nc']);
    data(1).(cases{i}).q = NaN(numc,length(files));
    data(1).(cases{i}).f = NaN(numc,length(files));
    for j = 1 : length(files)
        filename = fullfile(files(j).folder,files(j).name);
        disp(filename);
        data(1).(cases{i}).q(:,j) = ncread(filename,'RIVER_DISCHARGE_OVER_LAND_LIQ');
        data(1).(cases{i}).f(:,j) = ncread(filename,'FLOODED_FRACTION');
    end
end

save('Pantanal_default.mat','data','-v7.3');