!**************************************************
! Description: reading parameters for different PFTs
! Original   : G. Mo   April,2011
! Fortran    : Wang Jun, 11/2016
!***************************************************

subroutine readparam(lc,param)
use shr_kind_mod, only: r8 => shr_kind_r8
implicit none
integer,intent(in)    :: lc
real(r8),intent(out)  :: param(0:49)
integer               :: sec_per_day = 86400  

param(4)   = lc
select case (lc)
    case (1)       ! conifer evergreen
       param(2)   = 0.62     !clumping index
       param(6)   = 100      !light_compensate_point
       param(7)   = 1000     !light_saturation_point
       param(8)   = 4.5      ! LAI_max_overstory
       param(9)   = 2.4      ! LAI_max_understory
       param(10)  = 0.01     ! LAI_min_overstory
       param(11)  = 0.01     ! LAI_min_understory
       param(12)  = 0.87     ! albedo_new_snow
       param(13)  = 0.94     ! albedo_new_snow_vis
       param(14)  = 0.8      ! albedo_new_snow_nir
       param(15)  = 100.0    ! density_new_snow
       param(16)  = 1.33     ! z0 roughness length
       param(17)  = 2700     ! specific heat overstory
       param(18)  = 35       ! mass overstory (kg/m^2)
       param(19)  = 2700     ! specific heat understory
       param(20)  = 10       ! mass understory
       param(21)  = 0.6      ! root_depth(m)
       param(22)  = 0.035    ! albedo_canopy_vis
       param(23)  = 0.23     ! albedo_C_nir_observed
       param(24)  = 0.10     ! albedo_saturated_soil
       param(25)  = 0.35     ! albedo_dry_soil
       param(26)  = 0.5      ! drainage_class
       param(27)  = 0.95     ! decay_rate_of_root_distribution
       param(28)  = 150.     ! minimum_stomatal_resistant (s/m)
       param(29)  = 20       ! canopy_height
       param(30)  = 3        ! height of understory
       param(31)  = 2       ! height to measure the wind speed
       param(32)  = 0.05     ! the depth litter
       !the following paramters were added by MEM for the B-B calculations
       param(33)  = 8        ! k Ball
       param(34)  = 0.0175   ! intercept for H2O ball bery
       param(35)  = 0.0175/1.6 ! intercept for CO2 ball bery
       param(36)  = 62.5     ! maximum capacity of rubisco at 25C-Vcmax
       param(37)  = 2.39*param(36)-14.2   !Jmax at 25 C 
       param(38)  = 28.0     ! mb / coefficient reflecting the sensistivity of stomata to VPD/moderatly N-stres    sed plants
       param(39)  = 0.0015/sec_per_day     ! leaf resp co. kg C/kg/s
       param(40)  = 0.0020/sec_per_day     ! stem resp co.
       param(41)  = 0.0020/sec_per_day     ! root resp co.
       param(44)  = 0.003/sec_per_day      ! fine root resp co.
       param(45)  = 2.3                    ! Q10
       param(46)  = 3.10+1.35              ! leaf Nitrogen content mean value + 1 SD g/m2
       param(47)  = 20.72/62.5             ! slope of Vcmax-N curve

    case (2)  ! conifer decidous
       param(2)   = 0.68
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 2.4
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 1.33
       param(17)  = 2700
       param(18)  = 35
       param(19)  = 2700
       param(20)  = 10
       param(21)  = 0.6
       param(22)  = 0.035
       param(23)  = 0.23
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.95
       param(28)  = 150
       param(29)  = 20
       param(30)  = 3
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 39.1
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.0015/sec_per_day
       param(40)  = 0.0020/sec_per_day
       param(41)  = 0.0020/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3    !Q10
       param(46)  = 1.81+0.64
       param(47)  = 22.05/39.1

    case (6)  ! broadleaf decidous
       param(2)   = 0.7
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 2.4
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 1.53
       param(17)  = 2700
       param(18)  = 40
       param(19)  = 2700
       param(20)  = 10
       param(21)  = 0.8
       param(22)  = 0.04
       param(23)  = 0.25
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.97
       param(28)  = 200
       param(29)  = 23
       param(30)  = 3
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 57.7
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.015/sec_per_day
       param(40)  = 0.0035/sec_per_day
       param(41)  = 0.0025/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = 1.74+0.71
       param(47)  = 33.79/57.7

    case (9)  ! broadleaf evergreen forest
       param(2)   = 0.63
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 2.4
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 1.53
       param(17)  = 2700
       param(18)  = 40
       param(19)  = 2700
       param(20)  = 10
       param(21)  = 0.8
       param(22)  = 0.04
       param(23)  = 0.25
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.97
       param(28)  = 200
       param(29)  = 23
       param(30)  = 3
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 29
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.015/sec_per_day
       param(40)  = 0.0035/sec_per_day
       param(41)  = 0.0025/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = 2.17+0.8
       param(47)  = 14.02/29.0

    case (10)   !!mix forest
       param(2)   = 0.66
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 2.4
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.
       param(16)  = 1.43
       param(17)  = 2700
       param(18)  = 37.5
       param(19)  = 2700
       param(20)  = 10
       param(21)  = 0.7
       param(22)  = 0.0375
       param(23)  = 0.24
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.96
       param(28)  = 175
       param(29)  = 21.5
       param(30)  = 3
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 55.*1.2
       param(37)  = (2.39*param(36)-14.2)*1.2
       param(38)  = 28.0
       param(39)  = 0.00275/sec_per_day
       param(40)  = 0.0012/sec_per_day
       param(41)  = 0.0012/sec_per_day
       param(44)  = 0.00275/sec_per_day
       param(45)  = 2.3
       param(46)  = 3.5
       param(47)  = 0.47

    case (13)   !shrub
       param(2)   = 0.7
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 3.3
       param(9)   = 0.01
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 0.3
       param(17)  = 2700
       param(18)  = 25
       param(19)  = 2700
       param(20)  = 0
       param(21)  = 0.5
       param(22)  = 0.045
       param(23)  = 0.28
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.95
       param(28)  = 100
       param(29)  = 4
       param(30)  = 0
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 61.7*0.5+54*0.5
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.002/sec_per_day
       param(41)  = 0.0015/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = (2.03+1.05+1.69+0.62)*0.5
       param(47)  = (32.09/61.7+33.14/54.0)*0.5 

   case (14)   ! grass
       param(2)   = 0.7
       param(6)   = 100 
       param(7)   = 1000
       param(8)   = 3. 
       param(9)   = 0.01 
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8 
       param(15)  = 100.
       param(16)  = 0.04
       param(17)  = 2700
       param(18)  = 2.5
       param(19)  = 2700
       param(20)  = 0.1
       param(21)  = 0.3 
       param(22)  = 0.055
       param(23)  = 0.3
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5 
       param(27)  = 0.96
       param(28)  = 200 
       param(29)  = 4
       param(30)  = 0.1 
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 4
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 40.*1.2
       param(37)  = (2.39*param(36)-14.2)*1.2
       param(38)  = 28.0
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.00/sec_per_day
       param(41)  = 0.00/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3 
       param(46)  = (2.03+1.05+1.69+0.62)*0.5
       param(47)  = (32.09/61.7+33.14/54.)*0.5

   case (15)   !!crop
       param(2)   = 0.8
       param(6)   = 100 
       param(7)   = 1000
       param(8)   = 4.5 
       param(9)   = 0.01 
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8 
       param(15)  = 100.
       param(16)  = 0.04
       param(17)  = 2700
       param(18)  = 2.5
       param(19)  = 2700
       param(20)  = 0.1
       param(21)  = 0.3 
       param(22)  = 0.055
       param(23)  = 0.3
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5 
       param(27)  = 0.95
       param(28)  = 200
       param(29)  = 4
       param(30)  = 0.1
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 4
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 65.*1.3
       param(37)  = (2.39*param(36)-14.2)*1.3
       param(38)  = 28.0
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.00/sec_per_day
       param(41)  = 0.00/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3 
       param(46)  = 2.375 
       param(47)  = 0.31


    case (40)    !C4 grass
       param(2)   = 0.73
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 0.01
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 0.04
       param(17)  = 2700
       param(18)  = 2.5
       param(19)  = 2700
       param(20)  = 0.1
       param(21)  = 0.3
       param(22)  = 0.055
       param(23)  = 0.3
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.95
       param(28)  = 200
       param(29)  = 4
       param(30)  = 0.1
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 4
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 30
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.002/sec_per_day
       param(41)  = 0.0015/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = 2.375
       param(47)  = 0.31

    case (41)    !C4 crop
       param(2)   = 0.73
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 0.01
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 0.04
       param(17)  = 2700
       param(18)  = 2.5
       param(19)  = 2700
       param(20)  = 0.1
       param(21)  = 0.3
       param(22)  = 0.055
       param(23)  = 0.3
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.95
       param(28)  = 200
       param(29)  = 4
       param(30)  = 0.1
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 4
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = 30
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.0
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.002/sec_per_day
       param(41)  = 0.0015/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = 2.375
       param(47)  = 0.31


   case default
       param(2)   = 0.8
       param(6)   = 100
       param(7)   = 1000
       param(8)   = 4.5
       param(9)   = 0.01
       param(10)  = 0.01
       param(11)  = 0.01
       param(12)  = 0.87
       param(13)  = 0.94
       param(14)  = 0.8
       param(15)  = 100.0
       param(16)  = 0.04
       param(17)  = 2700
       param(18)  = 2.5
       param(19)  = 2700
       param(20)  = 0.1
       param(21)  = 0.3
       param(22)  = 0.055
       param(23)  = 0.3
       param(24)  = 0.10
       param(25)  = 0.35
       param(26)  = 0.5
       param(27)  = 0.95
       param(28)  = 200
       param(29)  = 4
       param(30)  = 0.1
       param(31)  = 2
       param(32)  = 0.05
       param(33)  = 8
       param(34)  = 0.0175
       param(35)  = 0.0175/1.6
       param(36)  = (78.2+100.7)*0.5
       param(37)  = 2.39*param(36)-14.2
       param(38)  = 28.
       param(39)  = 0.001/sec_per_day
       param(40)  = 0.002/sec_per_day
       param(41)  = 0.0015/sec_per_day
       param(44)  = 0.003/sec_per_day
       param(45)  = 2.3
       param(46)  = (1.75+0.76+1.62+0.61)*0.5
       param(47)  = (45.29/78.2+62.75/100.7)*0.5

end select

return
end subroutine
