# https://github.com/RayleighLord/RayleighLordAnimations

from matplotlib import pyplot as plt
from matplotlib.ticker import MultipleLocator


def figure_features(tex=True, font="serif", dpi=180):
	"""Customize figure settings.

	Args:
		tex (bool, optional): use LaTeX. Defaults to True.
		font (str, optional): font type. Defaults to "serif".
		dpi (int, optional): dots per inch. Defaults to 180.
	"""
	plt.rcParams.update(
		{
			"font.size": 16,
			"font.family": font,
			"text.usetex": tex,
			"figure.subplot.top": 0.9,
			"figure.subplot.right": 0.9,
			"figure.subplot.left": 0.15,
			"figure.subplot.bottom": 0.12,
			"figure.subplot.hspace": 0.4,
			"savefig.dpi": dpi,
			"savefig.format": "png",
			"axes.titlesize": 16,
			"axes.labelsize": 18,
			"axes.axisbelow": True,
			"xtick.direction": "in",
			"ytick.direction": "in",
			"xtick.major.size": 5,
			"xtick.minor.size": 2.25,
			"xtick.major.pad": 7.5,
			"xtick.minor.pad": 7.5,
			"ytick.major.pad": 7.5,
			"ytick.minor.pad": 7.5,
			"ytick.major.size": 5,
			"ytick.minor.size": 2.25,
			"xtick.labelsize": 16,
			"ytick.labelsize": 16,
			# "legend.fontsize": 16,
			"legend.framealpha": 1,
			"figure.titlesize": 16,
			"lines.linewidth": 2,
		}
	)


def add_grid(ax, lines=True, locations=None):
	"""Add a grid to the current plot.

	Args:
		ax (Axis): axis object in which to draw the grid.
		lines (bool, optional): add lines to the grid. Defaults to True.
		locations (tuple, optional):
			(xminor, xmajor, yminor, ymajor). Defaults to None.
	"""

	if lines:
		ax.grid(lines, alpha=0.5, which="minor", ls=":")
		ax.grid(lines, alpha=0.7, which="major")

	if locations is not None:

		assert (
			len(locations) == 4
		), "Invalid entry for the locations of the markers"

		xmin, xmaj, ymin, ymaj = locations

		ax.xaxis.set_minor_locator(MultipleLocator(xmin))
		ax.xaxis.set_major_locator(MultipleLocator(xmaj))
		ax.yaxis.set_minor_locator(MultipleLocator(ymin))
		ax.yaxis.set_major_locator(MultipleLocator(ymaj))