% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{trim_fao_data}
\alias{trim_fao_data}
\title{Trim countries in FAO live animals data}
\usage{
trim_fao_data(
  .df,
  yes_const = MWTools::amw_analysis_constants$yes_const,
  country_incl_col = MWTools::conc_cols$country_incl_col,
  country_name = MWTools::mw_constants$country_name
)
}
\arguments{
\item{.df}{The data frame containing live animals data, with added country
codes. Usually produced by calling the
\code{tidy_fao_live_animals}, and
\code{add_concordance_codes} functions in sequence on the raw FAO data.}

\item{yes_const}{See \code{MWTools::amw_analysis_constants}.}

\item{country_incl_col}{See \code{MWTools::conc_cols}.}

\item{country_name}{See \code{ MWTools::mw_constants}.}
}
\description{
This function filters out countries which have more than one instance
and aggregate regions from FAO live animals data. Data is usually downloaded
through the \code{FAOSTAT} package, using the \code{MWTools::down_fao_live_animals}
function, and after applying the \code{MWTools::add_concordance_codes} function.
}
\examples{
live_animals_data <- read.csv(file = MWTools::amw_test_data_path()) \%>\%
  tidy_fao_live_animals() \%>\%
  add_concordance_codes() \%>\%
  trim_fao_data()

}
