% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{tidy_fao_live_animals}
\alias{tidy_fao_live_animals}
\title{Tidy live animals data from the FAO}
\usage{
tidy_fao_live_animals(
  .df,
  country_name = MWTools::mw_constants$country_name,
  species = MWTools::mw_constants$species,
  year = MWTools::mw_cols$year,
  unit = MWTools::mw_cols$unit,
  value = MWTools::mw_constants$value,
  value_count = MWTools::mw_constants$value_count,
  area_fao_col = MWTools::fao_cols$area_fao_col,
  item_fao_col = MWTools::fao_cols$item_fao_col,
  year_fao_col = MWTools::fao_cols$year_fao_col,
  unit_fao_col = MWTools::fao_cols$unit_fao_col,
  value_fao_col = MWTools::fao_cols$value_fao_col,
  col_1960 = MWTools::hmw_analysis_constants$col_1960,
  col_2020 = MWTools::hmw_analysis_constants$col_2020
)
}
\arguments{
\item{.df}{A data frame containing the raw FAO live animals data,
corresponding to the "QCL" FAO bulk download query.}

\item{country_name, species, year, unit, value, value_count}{See \code{MWTools::mw_constants}.}

\item{area_fao_col, item_fao_col, year_fao_col, unit_fao_col, value_fao_col}{See \code{MWTools::fao_cols}.}

\item{col_1960, col_2020}{See \code{MWTools::hmw_analysis_constants}.}
}
\description{
Create a tidy data frame using data supplied by the function
\code{MWTools::down_fao_live_animals}.
}
\examples{
live_animals_data <- read.csv(file = MWTools::amw_test_data_path()) \%>\%
  tidy_fao_live_animals()

}
