% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{split_labor_by_sector}
\alias{split_labor_by_sector}
\title{Title}
\usage{
split_labor_by_sector(
  .df,
  hmw_analysis_data_path = MWTools::hmw_analysis_data_path(),
  hmw_labor_map_sheet = MWTools::hmw_analysis_constants$hmw_labor_map_sheet,
  unit = MWTools::mw_cols$unit,
  hmw_region_code_col = MWTools::conc_cols$hmw_region_code_col,
  sex_ilo_col = MWTools::ilo_cols$sex_ilo_col,
  sector_col = MWTools::mw_constants$sector_col,
  year = MWTools::mw_cols$year,
  labor_type_col = MWTools::hmw_analysis_constants$labor_type_col,
  labor_split_col = MWTools::hmw_analysis_constants$labor_split_col,
  employed_persons_ilo_col = MWTools::ilo_cols$employed_persons_ilo_col,
  total_wk_hrs_ilo_col = MWTools::hmw_analysis_constants$total_wk_hrs_ilo_col,
  agriculture = MWTools::mw_sectors$agriculture_broad.sector,
  industry = MWTools::mw_sectors$industry_broad.sector,
  services = MWTools::mw_sectors$services_broad.sector
)
}
\arguments{
\item{.df}{A data frame containing the number of hours worked by broad sector.
Usually produced by calling the
\code{add_hmw_region_codes},
\code{fill_ilo_data},
\code{calc_total_hours_worked}, and
\code{get_broad.sector_data} functions in sequence on the raw FAO data.}

\item{hmw_analysis_data_path}{See \code{MWTools::hmw_analysis_data_path()}.}

\item{hmw_labor_map_sheet, labor_type_col, labor_split_col, total_wk_hrs_ilo_col}{See \code{MWTools::hmw_analysis_constants}.}

\item{unit, year}{See \code{MWTools::mw_cols}.}

\item{hmw_region_code_col}{See \code{MWTools::conc_cols}.}

\item{sex_ilo_col, employed_persons_ilo_col}{See \code{MWTools::ilo_cols}.}

\item{sector_col}{See \code{MWTools::mw_constants}.}

\item{agriculture, industry, services}{See \code{MWTools::mw_sectors}.}
}
\description{
Title
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
working_hours_labor_type_data <- hmw_data |>
  add_hmw_region_codes() |>
  fill_ilo_data() |>
  calc_total_hours_worked() |>
  get_broad.sector_data() |>
  split_labor_by_sector()
}
