% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_useful_products}
\alias{specify_useful_products}
\title{Specify useful energy products}
\usage{
specify_useful_products(
  .df,
  product = MWTools::mw_cols$product,
  stage = MWTools::mw_constants$stage_col,
  species = MWTools::mw_constants$species,
  useful = MWTools::all_stages$useful,
  notation = RCLabels::from_notation
)
}
\arguments{
\item{.df}{A data frame, usually the output of \code{MWTools::specify_primary_production()}.}

\item{product, stage, species}{See \code{MWTools::mw_constants}.}

\item{useful}{See \code{MWTools::all_stages}.}

\item{notation}{See \code{RCLabels::from_notation}.}
}
\value{
A data frame with
}
\description{
Final-to-useful machines make useful energy products.
This function specifies those products
to include a \verb{[from X]} suffix.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products()
}
