% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_product}
\alias{specify_product}
\title{Add a product column to a muscle work data frame}
\usage{
specify_product(
  .df,
  product = MWTools::mw_cols$product,
  primary = MWTools::all_stages$primary,
  final = MWTools::all_stages$final,
  useful = MWTools::all_stages$useful,
  species = MWTools::mw_constants$species,
  human = MWTools::mw_species$human,
  stage = MWTools::mw_constants$stage_col,
  sector = MWTools::mw_constants$sector_col,
  biomass = MWTools::mw_products$biomass,
  food = MWTools::mw_products$food,
  feed = MWTools::mw_products$feed,
  hu_mech = MWTools::mw_products$hu_mech,
  an_mech = MWTools::mw_products$an_mech,
  an_p = MWTools::mw_products$an_p,
  transport = MWTools::mw_sectors$transport_sector
)
}
\arguments{
\item{.df}{A data frame, likely produced by \code{specify_energy_type_method()}.}

\item{product}{The name of the column to be added. See \code{MWTools::mw_constants}.}

\item{primary, final, useful}{See \code{MWTools::all_stages}.}

\item{species}{See \code{MWTools::mw_constants}.}

\item{human}{See \code{MWTools::mw_species}.}

\item{stage, sector}{See \code{MWTools::mw_constants}.}

\item{biomass, food, feed, hu_mech, an_mech, an_p}{See \code{MWTools::mw_products}.}

\item{transport}{See \code{MWTools::sectors}.}
}
\value{
A data frame with additional rows needed for converting to PSUT matrices.
}
\description{
A \code{product} column is needed before converting a muscle work data frame
to PSUT matrices. This function adds and populates the \code{product} column.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu() \%>\%
  specify_product()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product()
}
