% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_primary_production}
\alias{specify_primary_production}
\title{Add primary production to a data frame of PFU muscle work data}
\usage{
specify_primary_production(
  .df,
  product = MWTools::mw_cols$product,
  primary = MWTools::all_stages$primary,
  stage = MWTools::mw_constants$stage_col,
  notation = RCLabels::from_notation,
  resources = MWTools::mw_sectors$resources_sector
)
}
\arguments{
\item{.df}{A muscle work data frame with products already specified,
usually by \code{specify_product()}.}

\item{product}{See \code{MWTools::mw_constants}.}

\item{primary}{See \code{MWTools::all_stages}.}

\item{stage}{See \code{MWTools::mw_constants}.}

\item{notation}{The notation to be used for primary energy product specification.
Default is \code{RCLabels::from_notation}.}

\item{resources}{See \code{MWTools::mw_sectors}.}
}
\value{
A data frame with primary production specified.
}
\description{
Adds rows for biomass from resources.
}
\details{
If no primary rows are found
(probably because \code{.df} has no rows),
\code{.df} is returned unmodified.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  MWTools::specify_primary_production()
}
