% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_last_stages}
\alias{specify_last_stages}
\title{Create energy conversion chains for final and useful last stages}
\usage{
specify_last_stages(
  .df,
  stage = MWTools::mw_constants$stage_col,
  last_stage = MWTools::mw_cols$last_stage,
  final = MWTools::last_stages$final,
  useful = MWTools::last_stages$useful
)
}
\arguments{
\item{.df}{A data frame, probably the output of \code{specify_fu_machines()}.}

\item{stage}{See \code{MWTools::mw_constants}.}

\item{last_stage}{See \code{MWTools::mw_cols}.}

\item{final, useful}{See \code{MWTools::last_stages}.}
}
\value{
A data frame containing a new column \code{last_stage} and
rows for both final and useful being the last stage.
}
\description{
We have two ways to describe the energy conversion chain:
with last stage of "Final" and last stage of "Useful".
This function takes \code{.df} (assumed to be \code{last_stage = "Useful"})
and converts to \code{last_stage = "Final"}
by adding a last_stage column with appropriate values.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products() \%>\%
  specify_fu_machines() \%>\%
  specify_last_stages()
}
