% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_fu_machines}
\alias{specify_fu_machines}
\title{Specify final-to-useful industries}
\usage{
specify_fu_machines(
  .df,
  product = MWTools::mw_cols$product,
  stage = MWTools::mw_constants$stage_col,
  species = MWTools::mw_constants$species,
  final = MWTools::all_stages$final,
  useful = MWTools::all_stages$useful,
  product_notation = RCLabels::from_notation,
  machine_notation = RCLabels::arrow_notation
)
}
\arguments{
\item{.df}{A data frame, likely the output of \code{specify_useful_products()}.}

\item{product, stage, species}{See \code{MWTools::mw_constants}.}

\item{final, useful}{See \code{MWTools::all_stages}.}

\item{product_notation}{The notation for products. Default is \code{RCLabels::from_notation}.}

\item{machine_notation}{The notation for machines. Default is \code{RCLabels::arrow_notation}.}
}
\value{
A data frame in which final-to-useful machines are specified.
}
\description{
Final-to-useful industries should be named as "Industry -> Product".
This function renames final-to-useful industries (in this case, species) to the desired form.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products() \%>\%
  specify_fu_machines()
}
