% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_energy_type_method}
\alias{specify_energy_type_method}
\title{Add energy type and method columns to tidy muscle work data frames}
\usage{
specify_energy_type_method(
  .hmw_df,
  .amw_df,
  e_dot = MWTools::mw_cols$e_dot,
  energy_type = MWTools::mw_cols$energy_type,
  method = MWTools::mw_cols$method,
  e_type = MWTools::energy_types$e,
  pcm = MWTools::methods$pcm
)
}
\arguments{
\item{.hmw_df}{A data frame produced by \code{calc_hmw_pfu()}.}

\item{.amw_df}{A data frame produced by \code{calc_amw_pfu()}.}

\item{e_dot, energy_type, method, e_type}{See \code{MWTools::mw_cols}.}

\item{pcm}{See \code{MWTools::methods}.}
}
\value{
A data frame in which \code{energy_type} and \code{method} columns are included.
}
\description{
To specify muscle work data in preparation for
conversion to PSUT matrices,
the first step is specifying that these data are energy (not exergy) data
and indicating the method for estimating
the primary energy ("Biomass [from Resources]")
associated with
the initial stage of final energy ("Biomass").
We assume the Physical Content Method (PCM) in which
the primary energy ("Biomass [from Resources]")
is equal in magnitude to
the final energy ("Biomass").
}
\details{
\code{.hmw_df} and \code{.amw_df} bound by rows.
The resulting data frame is modified,
replacing any \code{NA} values with \code{0} in the \code{e_dot} column.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df)
}
